diff --git a/common/lualib.c b/common/lualib.c
index 312fb2d594..bb110ac716 100644
--- common/lualib.c
+++ common/lualib.c
@@ -20,6 +20,8 @@
 #include "common/lualib.h"
 #include "luaa.h"
 
+lua_CFunction lualib_dofunction_on_error;
+
 void luaA_checkfunction(lua_State *L, int idx)
 {
     if(!lua_isfunction(L, idx))
diff --git a/common/lualib.h b/common/lualib.h
index 8a3ef089d7..a91261843c 100644
--- common/lualib.h
+++ common/lualib.h
@@ -28,7 +28,7 @@
 #include "common/util.h"
 
 /** Lua function to call on dofunction() error */
-lua_CFunction lualib_dofunction_on_error;
+extern lua_CFunction lualib_dofunction_on_error;
 
 void luaA_checkfunction(lua_State *, int);
 void luaA_checktable(lua_State *, int);
diff --git a/luaa.c b/luaa.c
index 419a8c2eb2..aeaba9cd1f 100644
--- luaa.c
+++ luaa.c
@@ -91,6 +91,8 @@ extern const struct luaL_Reg awesome_mouse_meta[];
 extern const struct luaL_Reg awesome_root_methods[];
 extern const struct luaL_Reg awesome_root_meta[];
 
+signal_array_t global_signals;
+
 /** A call into the Lua code aborted with an error.
  *
  * This signal is used in the example configuration, @{05-awesomerc.md},
diff --git a/luaa.h b/luaa.h
index e159258348..d26c437691 100644
--- luaa.h
+++ luaa.h
@@ -317,7 +317,7 @@ const char *luaA_find_config(xdgHandle *, const char *, luaA_config_callback *);
 bool luaA_parserc(xdgHandle *, const char *);
 
 /** Global signals */
-signal_array_t global_signals;
+extern signal_array_t global_signals;
 
 int luaA_class_index_miss_property(lua_State *, lua_object_t *);
 int luaA_class_newindex_miss_property(lua_State *, lua_object_t *);
diff --git a/objects/button.c b/objects/button.c
index 892347a928..5ffdcd4432 100644
--- objects/button.c
+++ objects/button.c
@@ -35,6 +35,8 @@
 
 #include "button.h"
 
+lua_class_t button_class;
+
 /** Button object.
  *
  * @tfield int button The mouse button number, or 0 for any button.
diff --git a/objects/button.h b/objects/button.h
index fb8bb8da28..8f0b894305 100644
--- objects/button.h
+++ objects/button.h
@@ -39,7 +39,7 @@ typedef struct button_t
     xcb_button_t button;
 } button_t;
 
-lua_class_t button_class;
+extern lua_class_t button_class;
 LUA_OBJECT_FUNCS(button_class, button_t, button)
 ARRAY_FUNCS(button_t *, button, DO_NOTHING)
 
diff --git a/objects/client.c b/objects/client.c
index 7b2d3a2022..b617a9e7a9 100644
--- objects/client.c
+++ objects/client.c
@@ -108,6 +108,8 @@
 #include <xcb/shape.h>
 #include <cairo-xcb.h>
 
+lua_class_t client_class;
+
 /** Client class.
  *
  * This table allow to add more dynamic properties to the clients. For example,
diff --git a/objects/client.h b/objects/client.h
index 74a23131c5..387e7c2aea 100644
--- objects/client.h
+++ objects/client.h
@@ -200,7 +200,7 @@ struct client_t
 ARRAY_FUNCS(client_t *, client, DO_NOTHING)
 
 /** Client class */
-lua_class_t client_class;
+extern lua_class_t client_class;
 
 LUA_OBJECT_FUNCS(client_class, client_t, client)
 
diff --git a/objects/drawin.c b/objects/drawin.c
index 3fd1cc4350..3bbd93179c 100644
--- objects/drawin.c
+++ objects/drawin.c
@@ -46,6 +46,8 @@
 #include <cairo-xcb.h>
 #include <xcb/shape.h>
 
+lua_class_t drawin_class;
+
 /** Drawin object.
  *
  * @field border_width Border width.
diff --git a/objects/drawin.h b/objects/drawin.h
index 31f315aac5..2f8887d944 100644
--- objects/drawin.h
+++ objects/drawin.h
@@ -52,7 +52,7 @@ void luaA_drawin_systray_kickout(lua_State *);
 
 void drawin_class_setup(lua_State *);
 
-lua_class_t drawin_class;
+extern lua_class_t drawin_class;
 
 #endif
 // vim: filetype=c:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:textwidth=80
diff --git a/objects/key.c b/objects/key.c
index c42f7446d8..365ba998cc 100644
--- objects/key.c
+++ objects/key.c
@@ -43,6 +43,8 @@
 #include <xkbcommon/xkbcommon.h>
 #include <glib.h>
 
+lua_class_t key_class;
+
 /** Key object.
  *
  * @tfield string key The key to trigger an event.
diff --git a/objects/key.h b/objects/key.h
index 8aa07ffe3d..45f23cac79 100644
--- objects/key.h
+++ objects/key.h
@@ -36,7 +36,7 @@ typedef struct keyb_t
     xcb_keycode_t keycode;
 } keyb_t;
 
-lua_class_t key_class;
+extern lua_class_t key_class;
 LUA_OBJECT_FUNCS(key_class, keyb_t, key)
 DO_ARRAY(keyb_t *, key, DO_NOTHING)
 
diff --git a/objects/tag.c b/objects/tag.c
index a0050cc2a9..1b1a135762 100644
--- objects/tag.c
+++ objects/tag.c
@@ -203,6 +203,8 @@
 #include "ewmh.h"
 #include "luaa.h"
 
+lua_class_t tag_class;
+
 /**
  * @signal request::select
  */
diff --git a/objects/tag.h b/objects/tag.h
index d6bb40e0d8..f830b1e2c5 100644
--- objects/tag.h
+++ objects/tag.h
@@ -46,7 +46,7 @@ struct tag
     client_array_t clients;
 };
 
-lua_class_t tag_class;
+extern lua_class_t tag_class;
 LUA_OBJECT_FUNCS(tag_class, tag_t, tag)
 
 void tag_class_setup(lua_State *);
diff --git a/objects/window.c b/objects/window.c
index 440970f3d0..371d06bcd3 100644
--- objects/window.c
+++ objects/window.c
@@ -59,6 +59,7 @@
 #include "property.h"
 #include "xwindow.h"
 
+lua_class_t window_class;
 LUA_CLASS_FUNCS(window, window_class)
 
 static xcb_window_t
diff --git a/objects/window.h b/objects/window.h
index 5386fafead..fbc5296cf5 100644
--- objects/window.h
+++ objects/window.h
@@ -80,7 +80,7 @@ typedef struct
     WINDOW_OBJECT_HEADER
 } window_t;
 
-lua_class_t window_class;
+extern lua_class_t window_class;
 
 void window_class_setup(lua_State *);
 
