#
# Copyright 2017 Shivansh Rai
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $FreeBSD: stable/10/bin/echo/tests/echo_test.sh 321830 2017-07-31 23:03:10Z asomers $
#

atf_test_case n_output
n_output_head()
{
	atf_set "descr" "Verify that echo(1) does not print the trailing " \
			"newline character with option '-n'"
}

n_output_body()
{
	atf_check -s ignore -o inline:"Hello world" \
		/bin/echo -n "Hello world"
}

atf_test_case append_c_output
append_c_output_head()
{
	atf_set "descr" "Verify that echo(1) does not print the trailing newline " \
			"character when '\c' is appended to the end of the string"
}

append_c_output_body()
{
	atf_check -s ignore -o inline:"Hello world" \
		/bin/echo "Hello world\c"
}

atf_init_test_cases()
{
	atf_add_test_case n_output
	atf_add_test_case append_c_output
}
