/*-
 * Copyright (C) 1996
 *	David L. Nugent.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY DAVID L. NUGENT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL DAVID L. NUGENT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
  "$FreeBSD: stable/3/usr.sbin/pw/grupd.c 62224 2000-06-28 22:48:15Z ache $";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>

#include "pwupd.h"

static char * grpath = _PATH_PWD;

int
setgrdir(const char * dir)
{
	if (dir == NULL)
		return -1;
	else {
		char * d = malloc(strlen(dir)+1);
		if (d == NULL)
			return -1;
		grpath = strcpy(d, dir);
	}
	return 0;
}

char *
getgrpath(const char * file)
{
	static char pathbuf[MAXPATHLEN];

	snprintf(pathbuf, sizeof pathbuf, "%s/%s", grpath, file);
	return pathbuf;
}

int
grdb(char *arg,...)
{
	/*
	 * This is a stub for now, but maybe eventually be functional
	 * if ever an indexed version of /etc/groups is implemented.
	 */
	arg=arg;
	return 0;
}

int
fmtgrentry(char **buf, int * buflen, struct group * grp, int type)
{
	int             i, l;

	/*
	 * Since a group line is of arbitrary length,
	 * we need to calculate up-front just how long
	 * it will need to be...
	 */
	/*  groupname              :   password                 :  gid  : */
	l = strlen(grp->gr_name) + 1 + strlen(grp->gr_passwd) + 1 + 5 + 1;
	/* group members + comma separator */
	for (i = 0; grp->gr_mem[i] != NULL; i++) {
		l += strlen(grp->gr_mem[i]) + 1;
	}
	l += 2; /* For newline & NUL */
	if (extendline(buf, buflen, l) == -1)
		l = -1;
	else{
		/*
		 * Now we can safely format
		 */
		if (type == PWF_STANDARD)
			l = sprintf(*buf, "%s:*:%ld:", grp->gr_name, (long) grp->gr_gid);
		else
			l = sprintf(*buf, "%s:%s:%ld:", grp->gr_name, grp->gr_passwd, (long) grp->gr_gid);

		/*
		 * List members
		 */
		for (i = 0; grp->gr_mem[i] != NULL; i++) {
			l += sprintf(*buf + l, "%s%s", i ? "," : "", grp->gr_mem[i]);
		}

		(*buf)[l++] = '\n';
		(*buf)[l] = '\0';
	}
	return l;
}


int
fmtgrent(char **buf, int * buflen, struct group * grp)
{
	return fmtgrentry(buf, buflen, grp, PWF_STANDARD);
}


static int
gr_update(struct group * grp, char const * group, int mode)
{
	int             l;
	char            pfx[64];
	int		grbuflen = 0;
	char	       *grbuf = NULL;

	ENDGRENT();
	l = snprintf(pfx, sizeof pfx, "%s:", group);

	/*
	 * Update the group file
	 */
	if (grp != NULL && fmtgrentry(&grbuf, &grbuflen, grp, PWF_PASSWD) == -1)
		l = -1;
	else {
		l = fileupdate(getgrpath(_GROUP), 0644, grbuf, pfx, l, mode);
		if (l == 0)
			l = grdb(NULL);
	}
	if (grbuf != NULL)
		free(grbuf);
	return l;
}


int
addgrent(struct group * grp)
{
	return gr_update(grp, grp->gr_name, UPD_CREATE);
}

int
chggrent(char const * login, struct group * grp)
{
	return gr_update(grp, login, UPD_REPLACE);
}

int
delgrent(struct group * grp)
{
	return gr_update(NULL, grp->gr_name, UPD_DELETE);
}
