/*
 * Copyright (c) 2004-05 Applied Micro Circuits Corporation.
 * Copyright (c) 2004-05 Vinod Kashyap
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$FreeBSD: stable/5/sys/dev/twa/tw_cl_fwimg.c 153208 2005-12-07 18:20:38Z vkashyap $
 */

/*
 * AMCC'S 3ware driver for 9000 series storage controllers.
 *
 * Author: Vinod Kashyap
 */


#include "tw_osl_share.h"
#include "tw_cl_share.h"

#ifdef TW_OSL_FLASH_FIRMWARE

TW_INT8  tw_cli_fw_img[] = {
2,0,136,1,16,146,14,0,170,164,84,35,6,0,0,0,3,0,2,0,
8,0,4,0,30,0,24,0,175,236,221,186,48,57,47,50,56,47,48,53,
49,54,58,48,50,58,51,52,70,69,57,88,32,51,46,48,50,46,48,48,
46,48,48,52,13,9,9,9,9,9,9,9,9,9,9,13,10,65,77,67,
67,32,51,119,97,114,101,32,70,105,114,109,119,97,114,101,32,73,109,97,
103,101,32,40,67,41,32,50,48,48,51,45,50,48,48,52,32,65,77,67,
67,13,10,66,117,105,108,116,32,98,121,32,70,108,97,115,104,73,109,97,
103,101,67,111,109,112,111,115,101,114,32,49,46,48,53,32,111,110,32,87,
101,100,32,83,101,112,32,50,56,32,49,54,58,48,55,58,50,56,32,50,
48,48,53,10,13,10,66,117,105,108,100,32,68,101,116,97,105,108,115,58,
13,10,68,97,116,101,32,32,32,32,61,32,48,57,47,50,56,47,48,53,
13,10,84,105,109,101,32,32,32,32,61,32,49,54,58,48,50,58,51,52,
13,10,86,101,114,115,105,111,110,32,61,32,70,69,57,88,32,51,46,48,
50,46,48,48,46,48,48,52,13,10,83,82,76,32,32,32,32,32,61,32,
50,52,45,51,48,13,10,66,117,105,108,100,32,32,32,61,32,52,13,10,
66,114,97,110,99,104,32,32,61,32,56,13,10,10,67,111,109,112,111,110,
101,110,116,32,86,101,114,115,105,111,110,115,58,13,10,70,69,57,88,32,
51,46,48,50,46,48,48,46,48,48,52,13,10,66,69,57,88,32,51,46,
48,49,46,48,48,46,48,50,52,13,10,66,66,85,58,32,49,46,48,49,
46,48,48,46,48,49,48,13,10,26,0,0,128,255,33,148,166,2,8,124,
16,0,1,144,20,0,65,144,24,0,161,145,28,0,193,145,32,0,225,145,
36,0,1,146,40,0,33,146,44,0,65,146,48,0,97,146,52,0,129,146,
56,0,161,146,60,0,193,146,64,0,225,146,68,0,1,147,72,0,33,147,
76,0,65,147,80,0,97,147,84,0,129,147,88,0,161,147,92,0,193,147,
96,0,225,147,130,17,66,76,5,0,0,72,166,2,136,125,1,0,96,61,
100,128,107,57,16,96,107,125,1,0,64,61,204,129,74,57,20,90,74,125,
0,0,42,144,2,0,32,60,220,238,33,56,20,90,33,124,2,0,160,61,
232,238,173,57,20,90,173,125,2,0,64,60,232,110,66,56,20,90,66,124,
0,64,173,57,0,64,173,57,1,0,64,61,128,129,74,57,20,90,74,125,
4,0,202,133,4,0,234,133,4,0,10,134,4,0,42,134,4,0,74,134,
4,0,106,134,4,0,138,134,4,0,170,134,4,0,202,134,4,0,234,134,
0,0,64,57,56,0,33,84,248,255,65,149,1,0,96,60,172,129,99,56,
20,90,99,124,225,0,0,72,5,0,0,72,166,2,136,125,1,0,96,61,
4,129,107,57,16,96,107,125,1,0,64,61,204,129,74,57,20,90,74,125,
0,0,42,128,16,0,1,128,166,3,8,124,20,0,65,128,24,0,161,129,
28,0,193,129,32,0,225,129,36,0,1,130,40,0,33,130,44,0,65,130,
48,0,97,130,52,0,129,130,56,0,161,130,60,0,193,130,64,0,225,130,
68,0,1,131,72,0,33,131,76,0,65,131,80,0,97,131,84,0,129,131,
88,0,161,131,92,0,193,131,96,0,225,131,128,0,33,56,32,0,128,78,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,180,206,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,108,97,115,104,32,
85,112,100,97,116,101,114,0,166,2,8,124,200,255,33,148,28,0,33,147,
32,0,65,147,36,0,97,147,40,0,129,147,44,0,161,147,48,0,193,147,
52,0,225,147,60,0,1,144,5,0,0,72,166,2,232,127,120,27,107,124,
120,35,140,124,120,43,172,124,120,51,204,124,0,0,0,61,244,62,8,57,
20,250,8,125,0,0,128,63,104,57,156,59,20,250,156,127,0,0,160,63,
228,57,189,59,20,250,189,127,0,0,32,61,172,76,41,57,20,250,41,125,
0,0,192,59,120,227,135,127,120,67,10,125,0,0,139,129,1,0,12,44,
64,0,130,64,4,0,139,57,0,0,44,131,8,0,139,57,0,0,76,131,
12,0,139,57,0,0,204,128,16,0,139,57,0,0,108,131,20,0,139,57,
0,0,108,128,24,0,139,57,0,0,140,128,28,0,139,57,0,0,172,128,
40,0,0,72,0,0,43,131,4,0,139,57,0,0,76,131,8,0,139,57,
0,0,204,128,0,0,96,56,0,0,96,59,0,0,160,56,0,0,128,56,
64,40,4,124,140,0,130,65,80,32,219,124,0,0,128,57,8,0,129,145,
8,0,129,57,4,0,108,57,0,0,128,57,0,0,139,145,8,0,129,57,
8,0,108,57,0,0,128,57,0,0,139,145,8,0,129,57,12,0,108,57,
0,0,128,57,0,0,139,145,64,32,9,124,12,0,128,65,64,72,5,124,
8,0,129,65,208,0,198,127,64,32,7,124,12,0,128,65,64,56,5,124,
12,0,129,65,20,50,156,127,20,50,189,127,64,80,4,124,24,0,129,65,
64,40,10,124,16,0,128,64,64,24,27,124,8,0,130,65,80,64,6,125,
88,0,0,72,0,0,128,57,8,0,129,145,8,0,129,57,4,0,108,57,
255,255,128,61,248,125,140,57,20,250,140,125,80,96,153,125,0,0,139,145,
8,0,129,57,8,0,108,57,254,255,130,61,204,95,140,57,80,96,154,125,
0,0,139,145,8,0,129,57,12,0,108,57,254,255,141,61,24,145,140,57,
80,96,134,125,0,0,139,145,0,0,128,61,172,76,140,57,20,250,140,125,
20,242,76,127,0,0,128,61,220,76,140,57,20,250,140,125,20,242,108,127,
68,0,0,72,120,211,75,127,4,0,90,59,8,0,129,57,12,0,140,57,
0,0,107,129,0,0,140,129,20,98,75,125,0,0,122,129,4,0,90,59,
0,0,154,129,4,0,90,59,120,83,67,125,120,91,100,125,120,99,133,125,
166,3,137,127,33,4,128,78,64,216,26,124,188,255,130,64,0,0,128,61,
220,76,140,57,20,250,140,125,20,242,76,127,0,0,128,61,220,76,140,57,
20,250,140,125,20,242,108,127,0,0,128,61,220,76,140,57,20,250,140,125,
20,242,140,127,108,0,0,72,0,216,26,124,20,0,128,64,8,0,129,57,
12,0,140,57,0,0,140,129,16,0,0,72,8,0,129,57,4,0,140,57,
0,0,140,129,0,0,122,129,20,98,75,125,4,0,90,59,120,211,75,127,
4,0,90,59,8,0,129,57,4,0,140,57,0,0,107,129,0,0,140,129,
20,98,107,125,0,0,154,129,4,0,90,59,120,83,67,125,120,91,100,125,
120,99,133,125,166,3,169,127,33,4,128,78,64,224,26,124,148,255,130,64,
0,0,160,63,144,56,189,59,20,250,189,127,0,0,128,61,220,76,140,57,
20,250,140,125,20,242,76,127,0,0,128,61,220,76,140,57,20,250,140,125,
20,242,108,127,0,0,128,61,220,76,140,57,20,250,140,125,20,242,140,127,
108,0,0,72,0,216,26,124,20,0,128,64,8,0,129,57,12,0,140,57,
0,0,140,129,16,0,0,72,8,0,129,57,4,0,140,57,0,0,140,129,
0,0,122,129,20,98,75,125,4,0,90,59,120,211,75,127,4,0,90,59,
8,0,129,57,4,0,140,57,0,0,107,129,0,0,140,129,20,98,107,125,
0,0,154,129,4,0,90,59,120,83,67,125,120,91,100,125,120,99,133,125,
166,3,169,127,33,4,128,78,64,224,26,124,148,255,130,64,0,0,128,61,
152,68,140,57,20,250,140,125,20,242,172,124,0,0,128,61,72,69,140,57,
20,250,140,125,20,242,204,124,0,0,128,61,72,69,140,57,20,250,140,125,
20,242,236,124,64,40,6,124,192,0,130,65,8,0,129,57,12,0,140,57,
254,255,109,61,24,145,107,57,0,0,140,129,80,88,140,125,80,48,204,124,
160,0,0,72,120,59,236,124,1,0,231,56,0,0,140,137,116,7,140,125,
183,6,139,85,112,38,107,125,120,91,106,125,58,16,74,85,8,0,97,57,
20,82,107,125,0,0,75,129,120,43,171,124,4,0,165,56,0,0,107,129,
20,82,107,125,0,0,11,129,49,6,138,85,0,0,10,44,12,0,130,65,
0,0,8,44,76,0,130,65,191,7,138,85,120,83,73,125,58,16,41,85,
8,0,65,57,20,74,74,125,0,0,74,129,0,0,10,44,44,0,130,65,
57,7,137,85,0,0,9,44,8,0,130,65,58,16,8,85,20,82,8,125,
57,7,140,85,0,0,12,44,8,0,130,65,112,22,8,125,0,0,11,145,
64,48,5,124,96,255,130,64,49,0,0,72,28,0,33,131,32,0,65,131,
36,0,97,131,40,0,129,131,44,0,161,131,48,0,193,131,52,0,225,131,
60,0,1,128,166,3,8,124,56,0,33,56,32,0,128,78,166,2,8,124,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,28,0,225,147,
36,0,1,144,137,31,0,72,166,2,8,124,5,0,0,72,166,2,104,124,
166,3,8,124,120,27,108,124,112,22,140,125,58,16,158,85,134,42,146,124,
120,35,131,124,120,27,108,124,79,2,159,85,120,251,229,127,134,43,178,124,
0,0,96,56,227,255,128,60,0,160,132,96,134,3,114,124,134,3,147,124,
16,0,96,56,0,2,128,60,0,0,132,96,134,3,114,124,134,3,147,124,
25,6,0,72,120,27,108,124,0,0,12,44,204,3,130,64,0,0,160,59,
120,235,172,127,58,16,140,85,20,98,158,125,0,0,108,129,32,16,128,61,
64,48,140,57,64,96,11,124,40,0,130,64,120,235,172,127,58,16,140,85,
4,0,140,57,20,98,158,125,0,0,108,129,34,17,128,61,68,51,140,57,
64,96,11,124,72,0,130,65,120,235,172,127,58,16,140,85,20,98,158,125,
0,0,108,129,32,16,128,61,64,48,140,57,64,96,11,124,132,0,130,64,
120,235,172,127,58,16,140,85,4,0,140,57,20,98,158,125,0,0,108,129,
161,144,128,61,192,176,140,57,64,96,11,124,96,0,130,64,120,235,172,127,
58,16,140,85,20,98,254,127,120,235,172,127,58,16,140,85,4,0,140,57,
20,98,158,125,0,0,108,129,161,144,128,61,192,176,140,57,64,96,11,124,
28,0,130,64,237,8,0,72,120,27,107,124,12,0,159,129,64,88,12,124,
28,0,130,64,44,0,0,72,120,251,227,127,49,3,0,72,120,27,108,124,
0,0,12,44,24,0,130,65,1,0,189,59,1,0,128,61,0,240,140,57,
0,96,29,124,12,255,128,65,0,240,29,40,12,0,130,64,195,1,128,57,
192,2,0,72,0,0,127,129,32,16,128,61,64,48,140,57,64,96,11,124,
120,0,130,64,4,0,127,129,161,144,128,61,192,176,140,57,64,96,11,124,
100,0,130,64,165,8,0,72,10,0,159,161,20,98,159,124,12,0,191,128,
221,10,0,72,120,27,108,124,0,0,12,44,120,2,130,64,10,0,159,161,
20,98,127,125,12,0,159,129,20,98,235,127,0,0,127,129,32,16,128,61,
64,48,140,57,64,96,11,124,24,0,130,64,4,0,127,129,34,17,128,61,
68,51,140,57,64,96,11,124,12,0,130,65,195,1,128,57,56,2,0,72,
69,8,0,72,120,27,107,124,60,137,141,129,64,88,12,124,36,0,130,64,
1,8,0,72,120,27,107,124,60,137,141,129,20,90,204,127,9,8,0,72,
120,27,108,124,20,98,222,127,8,0,0,72,60,137,205,131,120,251,253,127,
36,0,0,72,120,235,163,127,49,2,0,72,120,27,108,124,0,0,12,44,
228,1,130,64,120,235,163,127,213,2,0,72,120,27,125,124,0,0,29,44,
220,255,130,64,173,7,0,72,120,27,107,124,60,137,141,129,20,90,172,127,
0,0,125,129,32,16,128,61,64,48,140,57,64,96,11,124,24,0,130,64,
4,0,125,129,34,17,128,61,68,51,140,57,64,96,11,124,8,0,130,65,
120,243,221,127,0,0,125,129,32,16,128,61,64,48,140,57,64,96,11,124,
84,0,130,64,4,0,125,129,34,17,128,61,68,51,140,57,64,96,11,124,
64,0,130,64,36,0,0,72,20,0,157,129,0,0,12,44,20,0,130,65,
120,235,163,127,77,2,0,72,120,27,125,124,8,0,0,72,0,0,160,59,
120,235,163,127,97,2,0,72,120,27,108,124,0,0,12,44,208,255,130,64,
60,0,0,72,109,7,0,72,120,27,108,124,0,0,12,44,40,0,130,64,
69,7,0,72,120,27,125,124,120,235,163,127,81,1,0,72,120,27,108,124,
0,0,12,44,16,0,130,65,0,0,160,59,8,0,0,72,0,0,160,59,
0,0,128,59,164,0,0,72,20,0,159,129,0,0,12,44,96,0,130,64,
1,0,128,59,0,0,29,44,84,0,130,65,80,232,158,125,20,0,159,145,
20,0,127,129,12,0,159,129,64,96,11,124,16,0,128,64,0,0,128,57,
20,0,159,145,20,0,0,72,120,251,227,127,117,2,0,72,120,27,108,124,
16,0,159,145,120,251,227,127,193,0,0,72,120,27,107,124,20,0,159,129,
20,0,139,145,16,0,159,129,16,0,139,145,120,243,195,127,120,251,228,127,
12,0,191,128,209,8,0,72,120,27,108,124,0,0,12,44,108,0,130,64,
12,0,159,129,126,248,140,85,60,8,140,85,20,98,222,127,120,251,227,127,
77,1,0,72,120,27,127,124,0,0,28,44,92,255,130,65,37,6,0,72,
120,27,107,124,60,137,141,129,20,90,236,127,4,0,127,129,34,17,128,61,
68,51,140,57,64,96,11,124,32,0,130,64,255,255,128,57,8,0,129,145,
120,251,227,127,8,0,129,56,4,0,160,56,101,8,0,72,120,27,108,124,
0,0,128,57,120,99,131,125,16,0,129,131,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,166,3,8,124,32,0,33,56,32,0,128,78,
120,27,107,124,12,0,139,129,20,98,139,125,10,0,107,161,80,96,139,125,
120,99,131,125,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
120,27,106,124,120,83,67,125,209,255,255,75,120,27,105,124,0,0,106,129,
32,16,128,61,64,48,140,57,64,96,11,124,32,0,130,65,0,0,106,129,
96,80,128,61,128,112,140,57,64,96,11,124,12,0,130,65,200,1,128,57,
92,0,0,72,0,0,105,129,32,16,128,61,64,48,140,57,64,96,11,124,
32,0,130,65,0,0,105,129,96,80,128,61,128,112,140,57,64,96,11,124,
12,0,130,65,200,1,128,57,44,0,0,72,120,83,67,125,120,75,36,125,
10,0,170,160,205,38,0,72,120,27,108,124,0,0,12,44,12,0,130,65,
200,1,128,57,8,0,0,72,0,0,128,57,120,99,131,125,12,0,1,128,
166,3,8,124,8,0,33,56,32,0,128,78,120,27,107,124,20,0,139,129,
0,0,12,44,16,0,130,65,20,0,139,129,20,98,139,125,8,0,0,72,
0,0,128,57,120,99,131,125,32,0,128,78,120,27,106,124,0,0,10,44,
148,0,130,65,0,0,106,129,32,16,128,61,64,48,140,57,64,96,11,124,
32,0,130,64,4,0,106,129,34,17,128,61,68,51,140,57,64,96,11,124,
12,0,130,64,1,0,128,57,104,0,0,72,0,0,106,129,96,80,128,61,
128,112,140,57,64,96,11,124,32,0,130,64,4,0,106,129,102,85,128,61,
136,119,140,57,64,96,11,124,12,0,130,64,1,0,128,57,56,0,0,72,
0,0,106,129,32,16,128,61,64,48,140,57,64,96,11,124,32,0,130,64,
4,0,106,129,137,136,128,61,136,136,140,57,64,96,11,124,12,0,130,64,
1,0,128,57,8,0,0,72,0,0,128,57,120,99,131,125,32,0,128,78,
120,27,108,124,0,0,224,56,0,0,0,57,24,0,172,56,10,0,108,161,
60,8,107,85,12,0,140,129,80,96,139,125,190,240,140,85,58,16,140,85,
20,98,197,124,120,43,172,124,4,0,165,56,0,0,140,129,120,99,139,125,
0,0,128,57,120,91,105,125,120,99,138,125,20,72,103,125,20,81,136,125,
120,91,103,125,120,99,136,125,0,48,5,124,208,255,128,65,120,59,235,124,
120,67,12,125,20,98,107,125,120,91,108,125,120,99,131,125,32,0,128,78,
240,255,33,148,166,2,8,124,12,0,225,147,20,0,1,144,0,0,96,56,
201,6,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,229,26,0,72,0,0,31,44,228,1,130,65,0,0,96,56,
245,18,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,169,26,0,72,0,0,31,44,168,1,130,65,0,0,96,56,
65,19,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,109,26,0,72,0,0,31,44,108,1,130,65,0,0,96,56,
145,19,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,49,26,0,72,0,0,31,44,48,1,130,65,0,0,96,56,
225,19,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,245,25,0,72,0,0,31,44,244,0,130,65,0,0,96,56,
53,20,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,185,25,0,72,0,0,31,44,184,0,130,65,0,0,96,56,
133,20,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,125,25,0,72,0,0,31,44,56,0,130,65,0,0,96,56,
217,20,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,65,25,0,72,0,0,31,44,56,0,130,65,0,0,96,56,
41,21,0,72,52,137,109,144,52,137,141,129,12,0,140,129,20,0,12,128,
52,137,109,128,166,3,9,124,33,4,128,78,121,27,127,124,12,0,130,65,
52,137,109,128,5,25,0,72,0,0,31,44,8,0,130,64,29,0,0,72,
120,251,227,127,12,0,225,131,20,0,1,128,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,166,2,8,124,8,0,193,147,12,0,225,147,
20,0,1,144,52,137,109,129,12,0,139,129,76,0,236,128,52,137,109,128,
166,3,233,124,33,4,128,78,0,0,3,44,164,0,130,65,52,137,45,129,
12,0,73,129,28,0,10,128,52,137,109,128,166,3,9,124,33,4,128,78,
52,137,141,129,12,0,236,128,44,0,7,129,120,27,127,124,52,137,109,128,
166,3,9,125,33,4,128,78,52,137,45,129,12,0,73,129,28,0,10,128,
20,26,223,127,52,137,109,128,166,3,9,124,33,4,128,78,52,137,141,129,
12,0,236,128,44,0,7,128,120,27,127,124,52,137,109,128,166,3,9,124,
33,4,128,78,52,137,45,129,12,0,73,129,52,0,10,128,20,26,255,127,
52,137,109,128,166,3,9,124,33,4,128,78,20,26,63,125,120,243,195,127,
8,0,137,56,109,2,0,72,56,137,109,144,112,0,0,72,52,137,141,129,
12,0,140,129,28,0,12,128,52,137,109,128,166,3,9,124,33,4,128,78,
52,137,13,129,12,0,72,129,28,0,10,128,120,27,126,124,52,137,109,128,
166,3,9,124,33,4,128,78,52,137,141,129,12,0,236,128,36,0,7,129,
120,27,127,124,52,137,109,128,166,3,9,125,33,4,128,78,20,26,63,125,
252,255,137,56,120,243,195,127,34,17,160,60,68,51,165,56,69,1,0,72,
56,137,109,144,8,0,193,131,12,0,225,131,20,0,1,128,16,0,33,56,
166,3,8,124,32,0,128,78,52,137,141,129,12,0,140,129,44,0,12,128,
52,137,109,128,166,3,9,124,32,4,128,78,52,137,141,129,12,0,140,129,
52,0,12,128,52,137,109,128,166,3,9,124,32,4,128,78,52,137,141,129,
12,0,140,129,60,0,12,128,52,137,109,128,166,3,9,124,32,4,128,78,
52,137,141,129,12,0,140,129,68,0,12,128,52,137,109,128,166,3,9,124,
32,4,128,78,166,2,8,124,4,0,1,144,248,255,33,148,52,137,141,129,
12,0,140,129,76,0,12,128,52,137,109,128,166,3,9,124,33,4,128,78,
12,0,1,128,62,6,99,84,166,3,8,124,8,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,12,0,225,147,20,0,1,144,120,27,127,124,
0,0,31,128,32,16,96,61,64,48,107,57,64,88,0,124,24,0,130,65,
0,0,159,129,96,80,0,60,128,112,0,96,64,0,12,124,36,0,130,64,
120,251,227,127,201,1,0,72,10,0,191,160,120,27,100,124,120,251,227,127,
205,32,0,72,121,27,96,124,28,0,130,65,12,0,225,131,20,0,1,128,
202,1,96,56,16,0,33,56,166,3,8,124,32,0,128,78,12,0,225,131,
52,7,3,124,20,0,1,128,16,0,33,56,166,3,8,124,32,0,128,78,
232,255,33,148,8,0,129,147,12,0,161,147,16,0,193,147,120,35,158,124,
120,27,125,124,0,240,29,124,166,2,8,124,20,0,225,147,120,43,191,124,
28,0,1,144,104,0,128,64,0,0,29,128,32,16,32,61,64,48,41,57,
64,72,0,124,72,0,130,64,120,235,188,127,120,227,131,127,41,255,255,75,
0,0,3,44,52,0,130,64,4,0,124,129,64,88,31,124,40,0,130,64,
120,227,131,127,8,0,129,131,12,0,161,131,16,0,193,131,20,0,225,131,
28,0,1,128,24,0,33,56,166,3,8,124,32,0,128,78,4,0,189,59,
0,240,29,124,160,255,128,65,8,0,129,131,12,0,161,131,16,0,193,131,
20,0,225,131,28,0,1,128,0,0,96,56,24,0,33,56,166,3,8,124,
32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,20,0,225,147,
120,35,159,124,120,27,126,124,0,248,30,124,166,2,8,124,28,0,1,144,
88,0,128,64,0,0,158,129,32,16,0,60,64,48,0,96,64,0,12,124,
56,0,130,64,120,243,221,127,120,235,163,127,121,254,255,75,0,0,3,44,
36,0,130,64,120,235,163,127,12,0,161,131,16,0,193,131,20,0,225,131,
28,0,1,128,24,0,33,56,166,3,8,124,32,0,128,78,4,0,222,59,
0,248,30,124,176,255,128,65,12,0,161,131,16,0,193,131,20,0,225,131,
28,0,1,128,0,0,96,56,24,0,33,56,166,3,8,124,32,0,128,78,
52,137,77,129,12,0,74,129,12,0,74,129,120,27,107,124,52,137,109,128,
120,43,166,124,120,35,133,124,166,3,73,125,120,91,100,125,32,4,128,78,
12,0,3,128,10,0,99,161,20,2,131,125,80,96,107,124,32,0,128,78,
230,66,109,124,230,66,140,124,230,66,173,124,0,40,3,124,240,255,130,64,
32,0,128,78,230,66,141,124,230,66,108,124,230,66,173,124,0,40,4,124,
240,255,130,64,32,0,128,78,166,2,8,125,120,27,103,124,201,255,255,75,
20,56,228,124,148,1,195,124,189,255,255,75,16,56,132,124,17,49,99,124,
244,255,128,64,166,3,8,125,32,0,128,78,16,0,131,129,1,0,32,61,
0,144,41,57,0,26,9,56,0,0,12,176,20,0,131,129,0,85,0,56,
0,0,12,176,16,0,99,129,0,0,43,177,32,0,128,78,240,255,33,148,
166,2,8,124,12,0,225,147,121,27,108,124,20,0,1,144,240,255,224,63,
20,0,130,64,36,0,96,56,145,18,0,72,121,27,108,124,92,0,130,65,
1,0,96,57,0,0,13,60,120,137,0,48,12,0,12,144,8,0,108,153,
0,0,13,60,160,138,0,48,12,0,12,144,16,0,0,60,4,0,12,144,
0,0,236,147,60,137,237,147,170,10,127,57,16,0,108,145,84,5,31,56,
20,0,12,144,24,0,236,147,2,0,127,57,28,0,108,145,0,1,0,60,
34,218,0,96,32,0,12,144,12,0,225,131,20,0,1,128,120,99,131,125,
16,0,33,56,166,3,8,124,32,0,128,78,0,0,99,128,32,0,128,78,
4,0,99,128,32,0,128,78,120,27,107,124,4,0,11,128,16,0,128,61,
64,96,0,124,36,0,130,65,4,0,139,129,32,0,0,60,64,0,12,124,
20,0,130,64,0,0,109,61,156,138,107,129,42,80,108,85,16,0,0,72,
0,0,141,61,16,138,140,129,42,80,140,85,120,99,131,125,32,0,128,78,
4,0,131,129,16,0,0,60,64,0,12,124,32,0,130,64,0,0,141,61,
200,137,140,57,68,0,108,129,64,0,12,128,20,2,11,124,42,80,11,84,
28,0,0,72,0,0,109,61,20,138,107,57,132,0,139,129,128,0,11,128,
20,2,12,124,42,80,11,84,120,91,99,125,32,0,128,78,240,255,33,148,
166,2,8,124,12,0,225,147,20,0,1,144,120,27,127,124,4,0,31,128,
16,0,224,60,64,56,0,124,72,0,130,64,12,0,31,129,36,0,104,129,
120,251,227,127,166,3,105,125,33,4,128,78,0,0,205,60,16,138,198,128,
0,0,95,129,12,0,225,131,42,80,199,84,80,24,7,125,60,0,0,85,
20,2,106,124,20,0,1,128,16,0,33,56,166,3,8,124,32,0,128,78,
12,0,127,129,36,0,139,129,120,251,227,127,166,3,137,125,33,4,128,78,
0,0,77,61,156,138,74,129,0,0,159,129,12,0,225,131,20,0,1,128,
42,80,69,85,80,24,197,124,60,0,201,84,166,3,8,124,20,74,108,124,
16,0,33,56,32,0,128,78,232,255,33,148,166,2,8,124,12,0,161,147,
16,0,193,147,20,0,225,147,28,0,1,144,12,0,99,129,36,0,11,128,
120,27,127,124,166,3,9,124,33,4,128,78,12,0,95,129,44,0,10,128,
120,27,125,124,120,251,227,127,166,3,9,124,33,4,128,78,12,0,159,129,
52,0,204,128,120,27,126,124,166,3,201,124,120,251,227,127,33,4,128,78,
0,0,159,129,20,26,30,124,80,232,0,125,12,0,161,131,16,0,193,131,
20,0,225,131,28,0,1,128,60,0,9,85,20,74,108,124,24,0,33,56,
166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
166,0,0,125,94,4,7,85,36,1,224,124,69,253,255,75,24,0,195,128,
0,0,102,161,28,0,35,129,0,0,9,160,16,0,227,128,0,128,12,113,
30,128,107,85,120,3,107,125,0,0,0,60,0,240,0,96,0,0,7,176,
166,0,192,124,94,4,198,84,120,99,198,124,36,1,192,124,32,0,227,128,
64,56,11,124,192,1,0,57,8,0,130,64,0,0,0,57,12,0,1,128,
8,0,33,56,166,3,8,124,120,67,3,125,32,0,128,78,200,255,33,148,
166,2,8,124,8,0,129,146,12,0,161,146,16,0,193,146,20,0,225,146,
24,0,1,147,28,0,33,147,32,0,65,147,36,0,97,147,40,0,129,147,
44,0,161,147,48,0,193,147,52,0,225,147,60,0,1,144,120,27,124,124,
0,0,156,129,120,35,157,124,0,96,29,124,120,51,223,124,120,43,190,124,
36,0,128,65,4,0,156,129,0,0,220,128,255,255,12,56,20,2,166,124,
255,255,31,56,20,2,29,125,64,40,8,124,72,0,129,64,8,0,129,130,
12,0,161,130,16,0,193,130,20,0,225,130,24,0,1,131,28,0,33,131,
32,0,65,131,36,0,97,131,40,0,129,131,44,0,161,131,48,0,193,131,
52,0,225,131,60,0,1,128,193,1,96,56,56,0,33,56,166,3,8,124,
32,0,128,78,1,0,96,60,157,16,0,72,121,27,119,124,120,187,248,126,
72,0,130,64,8,0,129,130,12,0,161,130,16,0,193,130,20,0,225,130,
24,0,1,131,28,0,33,131,32,0,65,131,36,0,97,131,40,0,129,131,
44,0,161,131,48,0,193,131,52,0,225,131,60,0,1,128,21,1,96,56,
56,0,33,56,166,3,8,124,32,0,128,78,0,0,60,131,4,0,220,128,
16,0,0,60,64,0,6,124,0,0,0,57,24,0,130,64,0,0,205,62,
200,137,214,58,19,0,0,57,0,0,224,56,44,0,0,72,4,0,28,128,
32,0,32,61,64,72,0,124,16,0,130,64,0,0,205,62,20,138,214,58,
35,0,0,57,0,0,224,56,0,64,7,124,44,0,128,64,58,16,234,84,
46,176,170,126,42,80,181,86,20,170,25,124,0,0,29,124,20,0,128,65,
1,0,231,56,0,64,7,124,120,3,25,124,220,255,128,65,0,0,31,44,
120,59,250,124,8,1,130,65,58,16,75,87,46,176,171,126,120,227,131,127,
42,80,181,86,120,203,36,127,120,187,229,126,120,171,166,126,213,5,0,72,
80,232,121,125,120,235,172,127,32,0,0,72,0,0,30,136,1,0,140,57,
174,89,24,124,1,0,222,59,255,255,255,59,1,0,189,59,1,0,107,57,
20,170,121,127,0,216,12,124,12,0,128,64,0,0,31,44,212,255,130,64,
120,227,131,127,120,203,36,127,41,6,0,72,121,27,116,124,60,0,130,64,
120,227,131,127,120,203,36,127,120,187,229,126,120,171,166,126,189,3,0,72,
121,27,116,124,32,0,130,64,120,227,131,127,120,203,36,127,120,187,229,126,
120,171,166,126,149,5,0,72,121,27,116,124,80,0,130,65,120,187,227,126,
25,15,0,72,120,163,131,126,8,0,129,130,12,0,161,130,16,0,193,130,
20,0,225,130,24,0,1,131,28,0,33,131,32,0,65,131,36,0,97,131,
40,0,129,131,44,0,161,131,48,0,193,131,52,0,225,131,60,0,1,128,
56,0,33,56,166,3,8,124,32,0,128,78,0,0,31,44,1,0,90,59,
120,219,121,127,0,255,130,64,120,187,227,126,189,14,0,72,8,0,129,130,
12,0,161,130,16,0,193,130,20,0,225,130,24,0,1,131,28,0,33,131,
32,0,65,131,36,0,97,131,40,0,129,131,44,0,161,131,48,0,193,131,
52,0,225,131,60,0,1,128,0,0,96,56,56,0,33,56,166,3,8,124,
32,0,128,78,200,255,33,148,166,2,8,124,8,0,129,146,12,0,161,146,
16,0,193,146,20,0,225,146,24,0,1,147,28,0,33,147,32,0,65,147,
36,0,97,147,40,0,129,147,44,0,161,147,48,0,193,147,52,0,225,147,
60,0,1,144,120,27,124,124,0,0,156,129,120,35,157,124,0,96,29,124,
120,51,223,124,120,43,190,124,36,0,128,65,4,0,156,129,0,0,220,128,
255,255,12,56,20,2,166,124,255,255,31,56,20,2,29,125,64,40,8,124,
72,0,129,64,8,0,129,130,12,0,161,130,16,0,193,130,20,0,225,130,
24,0,1,131,28,0,33,131,32,0,65,131,36,0,97,131,40,0,129,131,
44,0,161,131,48,0,193,131,52,0,225,131,60,0,1,128,193,1,96,56,
56,0,33,56,166,3,8,124,32,0,128,78,1,0,96,60,177,13,0,72,
121,27,119,124,120,187,248,126,72,0,130,64,8,0,129,130,12,0,161,130,
16,0,193,130,20,0,225,130,24,0,1,131,28,0,33,131,32,0,65,131,
36,0,97,131,40,0,129,131,44,0,161,131,48,0,193,131,52,0,225,131,
60,0,1,128,21,1,96,56,56,0,33,56,166,3,8,124,32,0,128,78,
0,0,60,131,4,0,220,128,16,0,0,60,64,0,6,124,0,0,0,57,
24,0,130,64,0,0,205,62,200,137,214,58,19,0,0,57,0,0,224,56,
44,0,0,72,4,0,28,128,32,0,32,61,64,72,0,124,16,0,130,64,
0,0,205,62,20,138,214,58,35,0,0,57,0,0,224,56,0,64,7,124,
44,0,128,64,58,16,234,84,46,176,170,126,42,80,181,86,20,170,25,124,
0,0,29,124,20,0,128,65,1,0,231,56,0,64,7,124,120,3,25,124,
220,255,128,65,0,0,31,44,120,59,250,124,8,1,130,65,58,16,75,87,
46,176,171,126,120,227,131,127,42,80,181,86,120,203,36,127,120,187,229,126,
120,171,166,126,233,2,0,72,80,232,121,125,120,235,172,127,32,0,0,72,
0,0,30,136,1,0,140,57,174,89,24,124,1,0,222,59,255,255,255,59,
1,0,189,59,1,0,107,57,20,170,121,127,0,216,12,124,12,0,128,64,
0,0,31,44,212,255,130,64,120,227,131,127,120,203,36,127,241,3,0,72,
121,27,116,124,60,0,130,64,120,227,131,127,120,203,36,127,120,187,229,126,
120,171,166,126,185,1,0,72,121,27,116,124,32,0,130,64,120,227,131,127,
120,203,36,127,120,187,229,126,120,171,166,126,169,2,0,72,121,27,116,124,
80,0,130,65,120,187,227,126,45,12,0,72,120,163,131,126,8,0,129,130,
12,0,161,130,16,0,193,130,20,0,225,130,24,0,1,131,28,0,33,131,
32,0,65,131,36,0,97,131,40,0,129,131,44,0,161,131,48,0,193,131,
52,0,225,131,60,0,1,128,56,0,33,56,166,3,8,124,32,0,128,78,
0,0,31,44,1,0,90,59,120,219,121,127,0,255,130,64,120,187,227,126,
209,11,0,72,8,0,129,130,12,0,161,130,16,0,193,130,20,0,225,130,
24,0,1,131,28,0,33,131,32,0,65,131,36,0,97,131,40,0,129,131,
44,0,161,131,48,0,193,131,52,0,225,131,60,0,1,128,0,0,96,56,
56,0,33,56,166,3,8,124,32,0,128,78,120,27,103,124,120,35,136,124,
120,43,169,124,120,51,202,124,60,137,141,129,16,0,140,60,240,255,132,56,
0,0,160,56,172,0,0,72,0,0,104,161,0,0,137,161,64,96,11,124,
16,0,130,64,2,0,8,57,2,0,41,57,140,0,0,72,16,0,135,129,
1,0,96,61,0,170,107,57,0,0,108,177,20,0,103,129,0,85,128,57,
0,0,139,177,16,0,135,129,1,0,96,61,0,160,107,57,0,0,108,177,
120,67,11,125,2,0,8,57,120,75,44,125,2,0,41,57,0,0,140,161,
0,0,139,177,0,0,196,160,0,0,100,161,165,4,204,84,0,0,12,44,
36,0,130,65,0,0,196,160,0,0,100,161,99,4,195,84,99,4,108,85,
64,96,3,124,12,0,130,65,205,1,128,57,44,0,0,72,99,4,198,84,
99,4,108,85,64,96,6,124,192,255,130,64,1,0,165,56,112,14,76,125,
148,1,140,125,64,96,5,124,76,255,128,65,0,0,128,57,120,99,131,125,
32,0,128,78,240,255,33,148,12,0,225,147,60,137,141,129,120,51,202,124,
32,0,236,63,120,27,103,124,0,0,96,56,240,255,255,59,112,14,76,125,
1,0,192,60,0,160,198,56,148,1,140,125,64,96,3,124,120,43,169,124,
120,35,136,124,128,0,128,64,0,0,104,161,0,0,137,161,64,96,11,124,
20,0,130,64,2,0,8,57,2,0,41,57,1,0,99,56,80,0,0,72,
16,0,103,129,0,10,134,57,0,0,139,177,20,0,103,129,0,85,128,57,
0,0,139,177,16,0,135,129,0,0,204,176,0,0,137,161,0,0,136,177,
2,0,41,57,2,0,8,57,0,0,127,161,0,0,159,161,99,4,107,85,
99,4,140,85,64,96,11,124,236,255,130,64,1,0,99,56,112,14,76,125,
148,1,140,125,64,96,3,124,136,255,128,65,12,0,225,131,16,0,33,56,
0,0,96,56,32,0,128,78,0,0,224,56,120,51,192,124,254,255,36,57,
254,255,101,57,112,14,12,124,148,1,76,125,64,80,7,124,32,0,128,76,
2,0,9,165,2,0,11,181,1,0,231,56,112,14,12,124,148,1,76,125,
64,80,7,124,232,255,128,65,32,0,128,78,0,0,64,57,120,51,192,124,
112,14,9,124,148,1,9,125,0,64,10,124,120,43,172,124,120,35,139,124,
56,0,128,64,0,0,204,160,0,0,235,160,64,56,6,124,2,0,140,57,
2,0,107,57,12,0,130,65,194,1,96,56,32,0,128,78,1,0,74,57,
112,14,9,124,148,1,9,125,0,64,10,124,208,255,128,65,0,0,96,56,
32,0,128,78,120,27,105,124,120,35,138,124,60,137,141,129,16,0,12,61,
240,255,8,57,16,0,105,129,1,0,128,61,0,170,140,57,0,0,139,177,
20,0,105,129,0,85,128,57,0,0,139,177,16,0,105,129,1,0,128,61,
0,128,140,57,0,0,139,177,16,0,105,129,1,0,128,61,0,170,140,57,
0,0,139,177,20,0,105,129,0,85,128,57,0,0,139,177,0,48,128,57,
0,0,138,177,0,0,40,161,0,0,72,161,165,4,44,85,0,0,12,44,
36,0,130,65,0,0,40,161,0,0,72,161,99,4,43,85,99,4,76,85,
64,96,11,124,12,0,130,65,206,1,128,57,24,0,0,72,99,4,43,85,
99,4,76,85,64,96,11,124,192,255,130,64,0,0,128,57,120,99,131,125,
32,0,128,78,60,137,77,129,16,0,227,128,1,0,192,60,0,128,198,56,
0,42,102,57,0,0,103,177,20,0,227,128,0,85,128,57,0,0,135,177,
16,0,227,128,0,0,199,176,16,0,227,128,0,0,103,177,20,0,227,128,
0,48,0,56,32,0,106,61,0,0,135,177,240,255,107,57,0,0,4,176,
0,0,235,160,33,4,224,84,0,0,11,160,36,0,130,65,0,0,235,160,
0,0,11,160,99,4,234,84,99,4,12,84,64,96,10,124,12,0,130,65,
206,1,96,56,32,0,128,78,99,4,231,84,99,4,0,84,64,0,7,124,
196,255,130,64,0,0,96,56,32,0,128,78,240,255,33,148,166,2,8,124,
8,0,193,147,12,0,225,147,121,27,127,124,20,0,1,144,240,255,192,63,
20,0,130,64,36,0,96,56,37,6,0,72,121,27,127,124,64,0,130,65,
120,251,227,127,101,243,255,75,16,0,0,60,4,0,31,144,0,0,223,147,
170,10,30,56,16,0,31,144,84,5,30,56,20,0,31,144,24,0,223,147,
2,0,94,57,28,0,95,145,1,32,128,61,0,218,140,57,32,0,159,145,
8,0,193,131,120,251,227,127,12,0,225,131,20,0,1,128,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,8,0,193,147,
12,0,225,147,121,27,127,124,20,0,1,144,240,255,192,63,20,0,130,64,
36,0,96,56,157,5,0,72,121,27,127,124,68,0,130,65,120,251,227,127,
221,242,255,75,16,0,0,60,4,0,31,144,0,0,223,147,60,137,205,147,
170,10,30,56,16,0,31,144,84,5,30,56,20,0,31,144,24,0,223,147,
2,0,94,57,28,0,95,145,1,32,128,61,34,218,140,57,32,0,159,145,
8,0,193,131,120,251,227,127,12,0,225,131,20,0,1,128,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,8,0,193,147,
12,0,225,147,121,27,127,124,20,0,1,144,240,255,192,63,20,0,130,64,
36,0,96,56,17,5,0,72,121,27,127,124,68,0,130,65,120,251,227,127,
81,242,255,75,16,0,0,60,4,0,31,144,0,0,223,147,60,137,205,147,
170,10,30,56,16,0,31,144,84,5,30,56,20,0,31,144,24,0,223,147,
2,0,94,57,28,0,95,145,1,194,128,61,34,218,140,57,32,0,159,145,
8,0,193,131,120,251,227,127,12,0,225,131,20,0,1,128,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,8,0,193,147,
12,0,225,147,121,27,127,124,20,0,1,144,240,255,192,63,20,0,130,64,
36,0,96,56,133,4,0,72,121,27,127,124,72,0,130,65,120,251,227,127,
197,241,255,75,16,0,0,60,4,0,31,144,0,0,223,147,60,137,205,147,
170,10,30,56,16,0,31,144,2,0,30,56,84,5,126,57,20,0,127,145,
0,2,158,57,24,0,159,145,28,0,31,144,0,28,128,61,91,34,140,57,
32,0,159,145,8,0,193,131,120,251,227,127,12,0,225,131,20,0,1,128,
16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,
8,0,193,147,12,0,225,147,121,27,127,124,20,0,1,144,224,255,192,63,
20,0,130,64,36,0,96,56,245,3,0,72,121,27,127,124,68,0,130,65,
120,251,227,127,53,241,255,75,32,0,0,60,4,0,31,144,0,0,223,147,
60,137,205,147,170,10,30,56,16,0,31,144,84,5,30,56,20,0,31,144,
24,0,223,147,2,0,94,57,28,0,95,145,1,1,128,61,34,196,140,57,
32,0,159,145,8,0,193,131,120,251,227,127,12,0,225,131,20,0,1,128,
16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,
8,0,193,147,12,0,225,147,121,27,127,124,20,0,1,144,224,255,192,63,
20,0,130,64,36,0,96,56,105,3,0,72,121,27,127,124,72,0,130,65,
120,251,227,127,169,240,255,75,32,0,0,60,4,0,31,144,0,0,223,147,
60,137,205,147,170,10,30,56,16,0,31,144,2,2,30,56,84,5,126,57,
20,0,127,145,0,2,158,57,24,0,159,145,28,0,31,144,1,28,128,61,
34,196,140,57,32,0,159,145,8,0,193,131,120,251,227,127,12,0,225,131,
20,0,1,128,16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
166,2,8,124,8,0,193,147,12,0,225,147,121,27,127,124,20,0,1,144,
224,255,192,63,20,0,130,64,36,0,96,56,217,2,0,72,121,27,127,124,
68,0,130,65,120,251,227,127,25,240,255,75,32,0,0,60,4,0,31,144,
0,0,223,147,60,137,205,147,170,10,30,56,16,0,31,144,84,5,30,56,
20,0,31,144,24,0,223,147,2,0,94,57,28,0,95,145,1,32,128,61,
34,196,140,57,32,0,159,145,8,0,193,131,120,251,227,127,12,0,225,131,
20,0,1,128,16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
166,2,8,124,8,0,193,147,12,0,225,147,121,27,127,124,20,0,1,144,
224,255,192,63,20,0,130,64,36,0,96,56,77,2,0,72,121,27,127,124,
84,0,130,65,120,251,227,127,141,239,255,75,84,85,126,57,225,255,128,61,
170,170,140,57,0,0,13,60,240,138,0,48,12,0,31,144,32,0,0,60,
4,0,31,144,0,0,223,147,60,137,205,147,16,0,159,145,20,0,127,145,
24,0,223,147,2,0,158,57,28,0,159,145,0,191,0,60,35,74,0,96,
32,0,31,144,8,0,193,131,120,251,227,127,12,0,225,131,20,0,1,128,
16,0,33,56,166,3,8,124,32,0,128,78,8,0,3,136,116,7,0,124,
52,0,0,124,62,222,3,84,32,0,128,78,166,2,8,124,120,11,43,124,
232,255,33,148,37,33,0,72,166,3,104,124,33,0,128,78,24,0,97,57,
108,33,0,72,166,2,8,124,120,11,43,124,224,255,33,148,253,32,0,72,
120,27,127,124,0,0,173,63,92,128,125,129,0,0,192,59,120,91,124,125,
120,0,0,72,0,0,31,44,28,0,130,65,4,0,156,129,0,0,12,44,
92,0,130,65,0,0,140,129,64,96,31,124,80,0,130,64,0,0,30,44,
0,0,156,129,16,0,130,64,120,99,139,125,92,128,125,145,8,0,0,72,
0,0,158,145,8,0,124,128,0,0,3,44,12,0,156,129,120,91,123,125,
8,0,130,65,2,0,128,56,166,3,137,125,33,4,128,78,92,128,125,129,
64,88,27,124,140,255,130,64,8,0,0,72,120,227,158,127,0,0,156,131,
0,0,28,44,136,255,130,64,32,0,97,57,184,32,0,72,166,2,8,124,
120,11,43,124,240,255,33,148,97,32,0,72,120,27,127,124,44,0,0,72,
120,99,139,125,0,0,140,129,0,0,159,145,4,0,107,128,0,0,3,44,
8,0,139,129,8,0,130,65,2,0,128,56,166,3,137,125,33,4,128,78,
0,0,159,129,0,0,12,44,208,255,130,64,16,0,97,57,116,32,0,72,
0,0,141,61,92,128,140,129,0,0,12,44,12,0,130,65,0,0,96,56,
236,254,255,75,0,0,109,60,88,128,99,56,140,255,255,75,166,2,8,124,
120,11,43,124,240,255,33,148,229,31,0,72,0,0,141,61,68,139,108,133,
0,0,11,44,0,0,192,59,76,0,130,64,1,0,96,57,0,0,108,145,
0,0,127,60,204,255,99,56,165,19,0,72,28,0,0,72,120,243,203,127,
58,16,107,85,46,96,139,125,1,0,222,59,166,3,137,125,33,4,128,78,
0,0,141,61,244,131,140,57,58,16,203,87,46,96,107,125,0,0,11,44,
212,255,130,64,16,0,97,57,216,31,0,72,6,0,96,56,76,1,0,72,
166,2,8,124,120,11,43,124,232,255,33,148,101,31,0,72,121,27,126,124,
72,0,130,64,1,0,192,59,64,0,0,72,0,0,141,61,72,139,140,129,
0,0,191,63,0,0,12,44,156,1,189,59,8,0,130,65,120,99,157,125,
166,3,169,127,33,4,128,78,0,0,159,61,156,1,140,57,64,96,29,124,
12,0,130,64,0,0,96,56,20,0,0,72,120,243,195,127,85,18,0,72,
0,0,3,44,184,255,130,65,24,0,97,57,88,31,0,72,166,2,8,124,
120,11,43,124,240,255,33,148,249,30,0,72,255,255,67,57,8,0,10,40,
0,0,128,57,172,0,129,65,0,0,127,61,44,0,107,57,58,16,74,85,
46,88,74,125,20,90,74,125,166,3,73,125,32,4,128,78,36,0,0,0,
48,0,0,0,60,0,0,0,72,0,0,0,84,0,0,0,96,0,0,0,
108,0,0,0,120,0,0,0,132,0,0,0,254,255,130,61,150,92,140,57,
96,0,0,72,254,255,130,61,226,92,140,57,84,0,0,72,254,255,130,61,
26,93,140,57,72,0,0,72,254,255,130,61,198,93,140,57,60,0,0,72,
254,255,130,61,78,93,140,57,48,0,0,72,254,255,130,61,110,93,140,57,
36,0,0,72,254,255,130,61,146,93,140,57,24,0,0,72,254,255,130,61,
170,93,140,57,12,0,0,72,254,255,130,61,170,92,140,57,120,99,131,125,
16,0,97,57,140,30,0,72,166,2,8,124,120,11,43,124,240,255,33,148,
33,30,0,72,120,27,127,124,1,0,96,56,21,255,255,75,120,27,126,124,
120,251,227,127,9,255,255,75,120,27,102,124,0,0,109,60,212,130,99,56,
120,243,197,127,254,255,130,60,10,94,132,56,41,0,0,72,81,18,0,72,
16,0,97,57,56,30,0,72,0,0,3,44,32,0,130,77,104,14,0,72,
92,254,255,75,240,255,255,75,32,0,128,78,166,2,8,124,4,0,1,144,
136,255,33,148,24,0,97,144,28,0,129,144,36,0,193,144,40,0,225,144,
44,0,1,145,48,0,33,145,52,0,65,145,128,0,129,57,12,0,129,145,
24,0,129,57,16,0,129,145,2,0,128,57,8,0,129,153,0,0,128,57,
9,0,129,153,32,0,161,144,8,0,161,56,21,0,0,72,124,0,1,128,
120,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,120,11,43,124,
224,253,33,148,73,29,0,72,120,35,157,124,120,43,190,124,120,27,124,124,
81,11,0,72,12,0,156,129,254,47,155,85,67,0,140,85,16,0,130,64,
9,0,96,56,109,23,0,72,148,0,0,72,12,0,156,129,194,0,140,85,
12,0,156,145,4,0,156,129,0,0,12,44,36,0,130,64,8,0,129,57,
4,0,156,145,0,0,156,145,0,2,128,57,8,0,156,145,12,0,156,129,
136,1,140,85,12,0,156,145,120,227,131,127,0,0,159,60,216,9,132,56,
120,235,165,127,120,243,198,127,241,2,0,72,4,0,124,129,8,0,129,57,
64,96,11,124,120,27,126,124,28,0,130,64,120,227,131,127,45,11,0,72,
0,0,128,57,4,0,156,145,0,0,156,145,8,0,156,145,0,0,27,44,
20,0,130,64,12,0,156,129,9,1,140,85,8,0,130,65,255,255,192,59,
120,227,131,127,97,10,0,72,120,243,195,127,32,2,97,57,204,28,0,72,
32,0,0,72,10,0,96,57,150,91,131,125,10,0,140,29,80,24,140,125,
48,0,140,57,255,255,132,157,150,91,99,124,0,0,3,44,224,255,130,64,
0,0,5,44,24,0,130,65,12,0,0,72,48,0,128,57,255,255,132,157,
0,32,5,124,244,255,128,65,120,35,131,124,32,0,128,78,166,2,8,124,
120,11,43,124,208,255,33,148,9,28,0,72,120,27,121,124,120,35,154,124,
121,211,94,127,8,0,121,131,12,0,153,131,16,0,130,64,254,255,194,63,
18,94,222,59,120,243,218,127,120,211,67,127,53,8,0,72,21,0,153,137,
0,0,12,44,4,0,121,129,16,0,130,65,64,24,11,124,8,0,128,64,
120,91,99,125,0,0,249,131,0,24,31,124,20,26,186,127,8,0,128,64,
120,27,127,124,16,0,153,137,0,0,12,44,80,248,227,126,76,0,130,65,
0,0,154,137,45,0,12,44,20,0,130,65,43,0,12,44,12,0,130,65,
32,0,12,44,8,0,130,64,1,0,90,59,0,0,154,137,48,0,12,44,
24,0,130,64,1,0,154,137,32,0,140,97,120,0,12,44,8,0,130,64,
2,0,90,59,48,0,0,59,32,0,0,72,32,0,0,59,24,0,0,72,
0,0,126,136,1,0,222,59,120,219,100,127,166,3,137,127,33,4,128,78,
0,208,30,124,232,255,128,65,17,0,153,137,0,0,12,44,60,0,130,64,
24,0,0,72,120,195,3,127,120,219,100,127,166,3,137,127,33,4,128,78,
255,255,247,58,0,0,23,44,232,255,129,65,24,0,0,72,0,0,122,136,
1,0,90,59,120,219,100,127,166,3,137,127,33,4,128,78,0,232,26,124,
232,255,128,65,24,0,0,72,120,219,100,127,32,0,96,56,166,3,137,127,
33,4,128,78,255,255,247,58,0,0,23,44,232,255,129,65,120,251,227,127,
48,0,97,57,16,27,0,72,166,2,8,124,120,11,43,124,136,255,33,148,
197,26,0,72,120,27,127,124,4,0,95,129,120,35,131,124,0,0,10,44,
120,43,190,124,107,0,97,57,8,0,128,64,1,0,64,57,0,0,128,57,
0,0,139,153,120,91,100,125,80,88,170,124,21,254,255,75,0,0,30,44,
120,27,100,124,8,0,130,65,255,255,196,159,120,251,227,127,73,254,255,75,
120,0,97,57,200,26,0,72,27,0,131,137,181,6,138,85,32,0,0,72,
63,7,139,84,254,255,130,61,26,94,140,57,174,88,140,125,62,225,132,84,
120,99,76,125,255,255,133,157,0,0,4,44,224,255,130,64,120,43,163,124,
32,0,128,78,4,0,131,129,0,0,12,44,8,0,128,64,1,0,128,57,
0,0,4,44,80,48,204,124,12,0,128,64,48,0,128,57,255,255,133,157,
0,48,5,124,244,255,129,65,0,0,4,44,20,0,129,64,27,0,131,137,
255,255,133,153,48,0,128,57,254,255,133,157,120,43,164,124,188,253,255,75,
166,2,8,124,120,11,43,124,80,255,33,148,193,25,0,72,120,27,120,124,
120,35,153,124,121,43,186,124,120,51,219,124,0,0,192,59,12,0,130,64,
254,255,66,63,18,94,90,59,16,0,1,147,20,0,33,147,212,5,0,72,
37,0,3,44,1,0,90,59,12,0,130,65,120,195,4,127,160,5,0,72,
0,0,224,58,255,255,128,57,8,0,129,145,12,0,129,145,24,0,97,57,
16,0,0,72,0,0,128,57,0,0,139,153,1,0,107,57,35,0,129,57,
0,96,11,124,236,255,129,64,0,0,122,136,45,0,3,44,16,0,130,64,
1,0,128,57,25,0,129,153,80,0,0,72,120,27,108,124,43,0,12,44,
12,0,130,64,26,0,129,153,60,0,0,72,48,0,3,44,16,0,130,64,
1,0,128,57,24,0,129,153,40,0,0,72,120,27,108,124,32,0,12,44,
12,0,130,64,27,0,129,153,20,0,0,72,35,0,3,44,20,0,130,64,
1,0,128,57,28,0,129,153,1,0,90,59,152,255,255,75,208,255,131,57,
10,0,12,40,56,0,128,64,0,0,128,57,255,255,90,59,20,0,0,72,
10,0,108,29,0,0,154,137,20,98,139,125,208,255,140,57,8,0,129,145,
1,0,122,141,208,255,107,57,10,0,11,40,224,255,128,65,60,0,0,72,
42,0,3,44,52,0,130,64,120,219,99,127,1,0,128,56,161,20,0,72,
0,0,131,129,0,0,12,44,8,0,129,145,20,0,128,64,208,0,140,125,
8,0,129,145,1,0,128,57,25,0,129,153,1,0,90,59,0,0,154,137,
46,0,12,44,140,0,130,64,1,0,122,140,208,255,131,57,10,0,12,40,
1,0,224,58,56,0,128,64,0,0,128,57,255,255,90,59,20,0,0,72,
10,0,108,29,0,0,154,137,20,98,139,125,208,255,140,57,12,0,129,145,
1,0,122,141,208,255,107,57,10,0,11,40,224,255,128,65,68,0,0,72,
42,0,3,44,44,0,130,64,120,219,99,127,1,0,128,56,21,20,0,72,
0,0,131,129,0,0,12,44,12,0,129,145,28,0,128,64,255,255,128,57,
12,0,129,145,16,0,0,72,0,0,128,57,12,0,129,145,8,0,0,72,
1,0,90,59,0,0,122,136,32,0,3,44,244,255,130,65,108,0,3,44,
20,0,130,64,1,0,154,141,108,0,12,44,108,0,130,64,20,0,0,72,
76,0,3,44,12,0,130,65,106,0,3,44,20,0,130,64,1,0,90,59,
1,0,128,57,31,0,129,153,72,0,0,72,104,0,3,44,44,0,130,64,
1,0,154,141,104,0,12,44,20,0,130,64,1,0,90,59,1,0,128,57,
34,0,129,153,36,0,0,72,1,0,128,57,33,0,129,153,24,0,0,72,
122,0,3,44,12,0,130,65,116,0,3,44,8,0,130,64,1,0,90,59,
0,0,122,137,65,0,11,40,35,0,97,153,1,0,90,59,100,2,130,65,
69,0,11,40,48,3,128,65,71,0,11,40,84,2,129,64,80,0,11,40,
28,1,130,65,88,0,11,40,48,1,130,65,97,0,11,40,60,2,130,65,
99,0,11,40,248,2,130,65,100,0,11,40,80,0,130,65,101,0,11,40,
248,2,128,65,103,0,11,40,28,2,129,64,105,0,11,40,56,0,130,65,
110,0,11,40,56,2,130,65,111,0,11,40,240,0,130,65,112,0,11,40,
204,0,130,65,115,0,11,40,148,2,130,65,117,0,11,40,216,0,130,65,
120,0,11,40,208,0,130,65,180,2,0,72,0,0,23,44,12,0,130,65,
0,0,128,57,24,0,129,153,31,0,129,137,0,0,12,44,120,219,99,127,
52,0,130,65,2,0,128,56,161,18,0,72,255,255,159,61,176,83,140,53,
0,0,163,128,4,0,195,128,16,0,130,65,8,0,97,56,105,80,255,75,
172,2,0,72,120,43,189,124,16,0,0,72,1,0,128,56,113,18,0,72,
0,0,163,131,33,0,129,137,0,0,12,44,12,0,130,65,52,7,189,127,
20,0,0,72,34,0,129,137,0,0,12,44,8,0,130,65,116,7,189,127,
26,0,161,136,0,0,5,44,120,235,164,127,8,0,130,64,27,0,161,136,
0,0,4,44,12,0,128,64,45,0,160,56,208,0,132,124,8,0,97,56,
184,0,0,72,8,255,139,57,35,0,129,153,120,219,99,127,1,0,128,56,
9,18,0,72,0,0,131,131,164,0,0,72,0,0,23,44,12,0,130,65,
0,0,128,57,24,0,129,153,31,0,129,137,0,0,12,44,120,219,99,127,
52,0,130,65,2,0,128,56,217,17,0,72,255,255,159,61,176,83,140,53,
0,0,163,128,4,0,195,128,16,0,130,65,8,0,97,56,161,79,255,75,
228,1,0,72,120,43,189,124,16,0,0,72,1,0,128,56,169,17,0,72,
0,0,131,131,33,0,129,137,0,0,12,44,12,0,130,65,62,4,156,87,
20,0,0,72,34,0,129,137,0,0,12,44,8,0,130,65,62,6,189,87,
35,0,129,137,117,0,12,44,24,0,130,64,120,227,132,127,8,0,97,56,
0,0,160,56,161,250,255,75,140,1,0,72,121,227,132,127,28,0,225,138,
139,0,161,56,116,7,247,126,0,0,128,57,139,0,129,153,8,0,130,64,
120,35,151,124,35,0,129,137,111,0,12,44,40,0,130,64,208,0,247,126,
20,0,0,72,127,7,140,84,48,0,140,57,255,255,133,157,254,232,132,84,
0,0,4,44,236,255,130,64,20,0,0,72,139,0,161,56,8,0,97,56,
165,250,255,75,120,27,101,124,120,187,228,126,139,0,193,56,8,0,97,56,
201,250,255,75,24,1,0,72,0,0,237,62,76,139,247,58,120,187,228,126,
8,0,97,56,181,248,255,75,20,26,222,127,41,0,128,57,15,0,151,153,
0,0,128,57,16,0,151,153,240,0,0,72,34,0,129,137,0,0,12,44,
1,0,128,56,120,219,99,127,20,0,130,65,169,16,0,72,0,0,131,129,
0,0,204,155,204,0,0,72,33,0,129,137,0,0,12,44,20,0,130,65,
141,16,0,72,0,0,131,129,0,0,204,179,176,0,0,72,31,0,129,137,
0,0,12,44,28,0,130,65,113,16,0,72,0,0,67,129,112,254,204,127,
0,0,202,147,4,0,138,145,140,0,0,72,89,16,0,72,0,0,131,129,
0,0,204,147,124,0,0,72,1,0,128,56,29,0,129,152,0,0,128,57,
24,0,129,153,120,219,99,127,53,16,0,72,0,0,131,128,8,0,97,56,
80,0,0,72,120,219,99,127,1,0,128,56,29,16,0,72,0,0,99,137,
36,0,97,153,0,0,128,57,37,0,129,153,0,0,11,44,1,0,128,57,
29,0,129,153,28,0,130,64,120,195,4,127,0,0,96,56,166,3,41,127,
33,4,128,78,1,0,222,59,20,0,0,72,8,0,97,56,36,0,129,56,
181,247,255,75,20,26,222,127,0,0,122,136,0,0,3,44,40,250,130,64,
120,243,195,127,176,0,97,57,4,20,0,72,255,255,99,57,1,0,139,141,
0,0,12,44,248,255,130,64,80,88,99,124,32,0,128,78,0,0,128,57,
0,0,5,44,255,255,35,57,255,255,68,57,28,0,130,65,166,3,169,124,
1,0,138,141,1,0,105,141,81,88,140,125,8,0,130,64,240,255,0,66,
120,99,131,125,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
8,0,132,129,255,255,140,53,8,0,132,145,12,0,128,64,45,0,0,72,
24,0,0,72,0,0,132,129,1,0,108,57,0,0,100,145,0,0,108,152,
62,6,99,84,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
166,2,8,124,120,11,43,124,232,255,33,148,33,19,0,72,120,35,157,124,
0,0,109,61,180,130,107,57,0,88,29,124,120,27,127,124,184,0,128,65,
0,0,141,61,144,139,140,161,54,32,140,85,20,98,139,125,0,96,29,124,
160,0,128,64,12,0,157,129,67,0,140,85,148,0,130,65,12,0,157,129,
62,55,140,85,9,0,140,113,9,0,12,44,4,0,221,131,8,0,130,64,
0,0,221,147,12,0,157,129,0,0,30,44,136,1,140,85,194,0,140,85,
12,0,157,145,80,0,130,64,12,0,157,129,190,4,158,85,33,4,140,85,
8,0,225,155,20,0,130,65,120,243,195,127,0,0,128,56,2,0,160,56,
45,13,0,72,120,243,195,127,8,0,129,56,1,0,160,56,57,13,0,72,
1,0,3,44,64,0,128,64,12,0,157,129,0,8,140,101,12,0,157,145,
20,0,0,72,120,235,163,127,209,0,0,72,0,0,3,44,12,0,130,65,
255,255,96,56,28,0,0,72,255,1,128,57,8,0,157,145,0,0,254,155,
1,0,222,59,0,0,221,147,62,6,227,87,24,0,97,57,132,18,0,72,
166,2,8,124,4,0,1,144,248,255,33,148,157,10,0,72,0,0,3,44,
20,0,130,65,0,0,99,128,0,0,3,44,8,0,130,65,5,9,0,72,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,101,10,0,72,0,0,3,44,20,0,130,65,
0,0,99,128,0,0,3,44,8,0,130,65,209,8,0,72,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,45,10,0,72,0,0,3,44,8,0,130,65,157,8,0,72,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,
120,11,43,124,224,255,33,148,117,17,0,72,0,0,224,59,120,27,124,124,
133,255,255,75,0,0,28,44,232,0,130,65,4,0,156,129,0,0,12,44,
220,0,130,65,12,0,124,129,67,0,107,85,20,0,130,64,9,0,96,56,
145,11,0,72,255,255,224,59,192,0,0,72,12,0,124,129,133,0,107,85,
180,0,130,64,0,0,124,129,0,96,11,124,128,0,129,64,12,0,156,129,
33,4,140,85,24,0,130,65,12,0,156,129,0,0,128,56,190,4,131,85,
2,0,160,56,173,11,0,72,12,0,156,129,4,0,124,131,190,4,154,85,
0,0,156,129,0,0,192,59,80,96,187,127,120,211,67,127,20,242,155,124,
80,232,190,124,161,11,0,72,0,0,3,44,12,0,128,64,120,27,126,124,
16,0,0,72,20,26,222,127,0,232,30,124,216,255,128,65,0,0,30,44,
20,0,128,64,12,0,156,129,255,255,224,59,0,8,140,101,12,0,156,145,
12,0,156,129,160,4,140,85,12,0,156,145,4,0,156,129,0,0,12,44,
0,0,156,145,0,2,96,57,8,0,130,64,120,99,139,125,8,0,124,145,
120,227,131,127,89,254,255,75,120,251,227,127,32,0,97,57,192,16,0,72,
0,0,77,61,188,129,74,57,28,0,138,129,0,96,3,124,32,0,128,77,
32,0,138,129,0,96,3,124,32,0,128,76,127,7,108,84,32,0,130,76,
8,0,138,129,0,96,3,124,252,255,195,128,32,0,128,64,120,99,139,125,
4,0,139,129,0,96,3,124,44,0,128,64,0,88,12,124,236,255,128,65,
32,0,0,72,120,99,139,125,120,91,108,125,0,0,108,129,0,88,12,124,
12,0,128,64,0,24,11,124,236,255,129,64,0,24,12,124,8,0,138,145,
252,255,236,128,16,0,129,65,20,58,76,125,0,80,3,124,32,0,128,77,
20,58,76,125,64,24,10,124,0,0,0,57,120,67,9,125,20,0,130,64,
120,99,131,125,4,0,131,129,20,58,198,124,1,0,0,57,20,50,67,125,
64,88,10,124,40,0,130,64,0,0,75,129,0,0,108,144,252,255,107,129,
4,0,131,145,20,90,198,124,120,83,75,125,0,0,99,145,4,0,107,144,
1,0,32,57,252,255,195,144,0,0,8,44,32,0,130,76,0,0,9,44,
32,0,130,76,0,0,108,144,4,0,131,145,0,0,99,145,4,0,107,144,
32,0,128,78,166,2,8,124,120,11,43,124,240,255,33,148,101,15,0,72,
120,27,127,124,101,6,0,72,0,0,31,44,12,0,130,65,120,251,227,127,
213,254,255,75,77,6,0,72,16,0,97,57,152,15,0,72,166,2,8,124,
120,11,43,124,232,255,33,148,37,15,0,72,0,0,237,63,188,129,255,59,
36,0,159,129,0,0,12,44,120,35,156,124,120,27,126,124,12,0,130,64,
0,8,128,57,36,0,159,145,120,243,221,127,20,98,126,125,7,0,107,57,
255,255,140,57,121,96,126,125,60,0,128,65,64,232,30,124,52,0,128,65,
120,243,195,127,141,7,0,72,255,255,3,44,44,0,130,64,0,0,28,44,
28,0,130,65,8,0,157,57,57,0,158,85,120,243,195,127,109,7,0,72,
255,255,3,44,12,0,130,64,0,0,224,59,132,0,0,72,127,7,106,84,
8,0,130,65,8,0,74,33,32,0,127,129,64,24,11,124,20,0,130,64,
20,242,131,125,32,0,159,145,20,82,227,127,72,0,0,72,28,0,159,129,
0,0,12,44,12,0,130,65,0,96,3,124,8,0,128,64,28,0,127,144,
0,0,11,44,16,0,130,65,20,242,131,125,0,96,11,124,12,0,128,64,
20,242,131,125,32,0,159,145,20,82,131,125,8,0,236,59,8,0,138,57,
80,240,204,127,7,0,158,57,57,0,158,85,252,255,223,147,120,251,227,127,
189,253,255,75,120,251,227,127,24,0,97,57,116,14,0,72,166,2,8,124,
120,11,43,124,224,255,33,148,9,14,0,72,11,0,131,57,57,0,158,85,
64,24,30,124,12,0,128,64,0,0,96,56,52,1,0,72,16,0,30,40,
8,0,128,64,16,0,192,59,0,0,173,63,188,129,189,59,8,0,253,131,
121,251,251,127,44,0,130,64,121,251,236,127,32,0,130,64,20,0,253,59,
0,0,157,145,8,0,253,147,0,0,255,147,4,0,255,147,0,0,128,57,
16,0,157,145,120,251,251,127,120,219,105,127,0,0,123,131,252,255,123,129,
64,240,11,124,120,0,128,65,80,88,158,125,16,0,12,40,0,0,27,129,
8,0,61,145,20,0,128,64,0,0,9,145,4,0,40,145,120,219,99,127,
180,0,0,72,20,90,91,125,32,0,125,129,64,88,10,124,20,0,130,64,
120,219,106,127,20,242,123,127,1,0,96,57,12,0,0,72,20,98,91,125,
0,0,96,57,120,83,67,125,0,0,11,44,252,255,202,147,252,255,155,145,
120,0,130,65,0,0,105,147,4,0,59,145,0,0,27,145,4,0,104,147,
100,0,0,72,64,248,27,124,116,255,130,64,120,243,220,127,120,227,131,127,
0,0,128,56,221,253,255,75,0,0,3,44,60,0,130,64,0,0,123,129,
120,91,106,125,0,0,106,129,0,88,10,124,16,0,128,64,20,0,157,57,
64,96,11,124,232,255,130,64,252,255,138,129,1,0,128,56,80,224,108,124,
165,253,255,75,0,0,3,44,12,0,130,65,8,0,253,147,28,255,255,75,
32,0,97,57,16,13,0,72,166,2,8,124,120,11,43,124,240,255,33,148,
185,12,0,72,120,27,127,124,185,3,0,72,120,251,227,127,133,254,255,75,
120,27,127,124,165,3,0,72,120,251,227,127,16,0,97,57,236,12,0,72,
166,2,8,124,120,11,43,124,240,255,33,148,133,12,0,72,137,3,0,72,
35,0,224,59,58,16,235,87,0,0,141,61,20,90,108,125,228,129,139,133,
0,0,12,44,20,0,130,65,0,0,64,57,0,0,75,145,166,3,137,125,
33,4,128,78,255,255,255,55,212,255,128,64,0,0,237,63,248,131,159,133,
0,0,12,44,20,0,130,65,166,3,137,125,33,4,128,78,0,0,128,57,
0,0,159,145,45,3,0,72,16,0,97,57,120,12,0,72,166,2,8,124,
120,11,43,124,240,255,33,148,13,12,0,72,120,27,126,124,17,3,0,72,
0,0,109,60,116,130,131,133,0,0,12,44,20,0,130,64,0,0,159,61,
124,255,140,57,0,0,131,145,161,5,0,72,0,0,64,57,58,16,75,85,
0,0,141,61,20,90,140,125,228,129,108,133,0,0,11,44,20,0,130,64,
0,0,204,147,201,2,0,72,0,0,96,56,24,0,0,72,1,0,74,57,
36,0,10,44,208,255,128,65,177,2,0,72,255,255,96,56,16,0,97,57,
244,11,0,72,6,0,96,56,176,2,0,72,120,27,104,124,20,42,228,124,
238,15,160,56,0,0,192,56,188,0,0,72,126,248,198,84,239,5,204,84,
16,0,130,64,0,0,132,137,1,0,132,56,0,255,134,97,255,7,204,84,
0,0,132,137,1,0,132,56,20,0,130,65,0,0,131,153,1,0,99,56,
1,0,133,57,128,0,0,72,0,0,68,137,1,0,132,56,46,37,75,85,
120,91,140,125,63,7,75,85,3,0,75,57,0,96,5,124,20,98,99,125,
80,88,37,125,8,0,129,65,0,240,41,57,0,0,128,57,24,0,0,72,
0,0,96,57,0,0,99,153,1,0,99,56,1,0,41,57,1,0,140,57,
0,64,9,124,36,0,128,64,0,80,12,124,224,255,128,65,32,0,0,72,
0,0,105,137,1,0,41,57,0,0,99,153,1,0,99,56,1,0,140,57,
0,80,12,124,232,255,128,65,20,82,133,125,63,5,133,85,64,56,4,124,
68,255,130,64,32,0,128,78,32,0,5,40,120,27,105,124,88,0,128,65,
46,68,132,80,15,0,108,112,30,128,132,80,32,0,130,65,16,0,140,33,
255,255,41,57,16,40,172,124,166,3,137,125,1,0,137,156,252,255,0,66,
1,0,41,57,62,225,172,84,252,255,41,57,62,7,165,84,166,3,137,125,
4,0,137,144,8,0,137,144,12,0,137,144,16,0,137,148,240,255,0,66,
4,0,41,57,0,0,5,40,32,0,130,77,255,255,41,57,166,3,169,124,
1,0,137,156,252,255,0,66,32,0,128,78,7,0,133,42,252,255,67,57,
252,255,132,56,3,0,75,113,104,0,148,65,140,0,130,64,3,0,128,112,
192,0,130,64,63,225,166,84,52,0,130,65,166,3,201,124,15,0,165,112,
4,0,196,128,8,0,228,128,12,0,4,129,16,0,36,133,4,0,202,144,
8,0,234,144,12,0,10,145,16,0,42,149,224,255,0,66,32,0,162,77,
191,240,166,84,28,0,130,65,166,3,201,124,3,0,165,112,4,0,196,132,
4,0,202,148,248,255,0,66,32,0,162,77,0,0,5,40,4,0,74,57,
4,0,132,56,32,0,130,77,166,3,169,124,255,255,165,56,174,32,197,124,
174,81,197,124,244,255,0,66,32,0,128,78,2,0,139,40,4,0,139,33,
16,0,166,65,20,0,133,65,6,0,36,137,6,0,42,153,5,0,36,137,
5,0,42,153,4,0,36,137,4,0,42,153,20,98,132,124,80,40,172,124,
20,98,74,125,3,0,128,112,72,255,162,65,190,240,166,84,56,24,11,84,
255,255,128,57,166,3,201,124,48,88,140,125,80,32,128,124,32,0,107,33,
62,88,140,93,4,0,196,132,3,0,165,112,62,88,198,92,56,96,199,124,
4,0,4,133,62,88,6,93,120,96,200,124,120,67,231,124,4,0,234,148,
232,255,0,66,32,0,130,77,4,0,74,57,20,2,132,124,88,255,255,75,
32,0,128,78,32,0,128,78,32,0,128,78,32,0,128,78,32,0,128,78,
32,0,128,78,0,0,109,60,16,132,99,56,32,0,128,78,166,2,8,124,
120,11,43,124,240,255,33,148,221,8,0,72,120,27,127,124,255,255,159,57,
32,0,12,40,12,0,128,65,255,255,96,56,76,0,0,72,205,255,255,75,
9,0,31,44,58,16,236,87,46,96,67,125,12,0,130,65,0,0,10,44,
16,0,130,64,120,251,227,127,81,2,0,72,32,0,0,72,1,0,10,44,
24,0,130,65,0,0,96,57,46,97,99,125,120,251,227,127,166,3,73,125,
33,4,128,78,0,0,96,56,16,0,97,57,204,8,0,72,166,2,8,124,
0,0,3,44,4,0,1,144,248,255,33,148,8,0,130,64,105,255,255,75,
1,0,64,57,58,16,75,85,1,0,74,57,32,0,10,44,0,0,128,57,
46,25,139,125,236,255,129,64,18,0,64,57,58,16,75,85,1,0,74,57,
24,0,10,44,1,0,128,57,46,25,139,125,236,255,129,64,29,0,64,57,
58,16,75,85,1,0,74,57,32,0,10,44,1,0,128,57,46,25,139,125,
236,255,129,64,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
166,2,8,124,120,11,43,124,240,255,33,148,233,7,0,72,0,0,237,63,
180,130,255,59,28,0,95,129,44,0,127,129,12,0,159,129,0,64,74,101,
0,32,140,101,12,0,159,145,1,0,128,57,190,4,138,81,28,0,95,145,
0,64,107,101,2,0,128,57,190,4,139,81,44,0,127,145,120,251,227,127,
229,245,255,75,16,0,127,56,221,245,255,75,32,0,127,56,213,245,255,75,
16,0,97,57,228,7,0,72,0,0,141,61,180,130,140,57,80,24,140,125,
0,0,96,56,112,38,140,125,20,0,12,40,32,0,128,76,58,16,139,85,
0,0,141,61,240,132,140,57,20,90,108,124,32,0,128,78,166,2,8,124,
120,11,43,124,232,255,33,148,69,7,0,72,120,27,126,124,0,0,237,63,
254,255,173,63,252,95,189,59,65,254,255,75,124,130,159,133,0,0,12,44,
12,0,130,64,120,235,172,127,0,0,159,145,20,242,108,125,0,88,29,124,
32,0,129,65,255,255,141,61,252,111,140,57,0,96,11,124,16,0,129,65,
0,0,127,145,80,88,254,127,16,0,0,72,255,255,224,59,12,0,96,56,
45,1,0,72,241,253,255,75,120,251,227,127,24,0,97,57,48,7,0,72,
166,2,8,124,120,11,43,124,232,255,33,148,201,6,0,72,120,27,126,124,
0,0,160,59,205,253,255,75,0,0,237,63,128,130,255,131,20,0,0,72,
0,0,159,129,166,3,137,125,33,4,128,78,4,0,255,131,0,0,31,44,
236,255,130,64,0,0,141,61,148,139,140,129,0,0,12,44,16,0,130,65,
153,253,255,75,220,0,99,56,89,64,255,75,120,243,196,127,2,0,96,56,
225,0,0,72,62,6,171,87,2,0,128,57,214,91,140,125,255,7,140,85,
2,0,12,40,236,255,128,65,97,253,255,75,24,0,97,57,164,6,0,72,
1,0,96,56,112,255,255,75,166,2,8,124,120,11,43,124,240,255,33,148,
57,6,0,72,120,27,126,124,0,0,237,63,57,253,255,75,128,130,159,129,
128,130,223,147,4,0,158,145,37,253,255,75,16,0,97,57,108,6,0,72,
16,0,96,56,255,255,128,56,116,0,0,72,166,2,8,124,120,11,43,124,
240,255,33,148,253,5,0,72,0,0,159,61,4,253,140,53,16,0,130,64,
0,0,141,61,64,133,140,57,20,0,0,72,237,252,255,75,121,27,108,124,
8,0,130,65,120,27,108,124,120,99,131,125,16,0,97,57,32,6,0,72,
166,2,8,124,120,11,43,124,240,255,33,148,185,5,0,72,120,27,127,124,
169,255,255,75,0,0,3,44,8,0,130,65,0,0,227,147,16,0,97,57,
244,5,0,72,166,2,8,124,4,0,1,144,248,255,33,148,66,18,66,76,
245,5,0,72,12,0,162,65,189,255,255,75,255,255,96,56,12,0,1,128,
166,3,8,124,8,0,33,56,32,0,128,78,120,43,166,124,120,35,140,124,
120,99,133,125,120,27,100,124,4,0,96,60,7,0,99,56,184,255,255,75,
120,43,166,124,120,35,140,124,120,99,133,125,120,27,100,124,4,0,96,60,
1,0,99,56,156,255,255,75,166,2,8,124,120,11,43,124,216,255,33,148,
29,5,0,72,120,27,127,124,120,35,157,124,120,43,190,124,1,255,255,75,
0,0,141,61,152,139,140,129,0,0,12,44,8,0,130,65,1,252,255,75,
0,0,141,61,156,139,140,129,0,0,12,44,8,0,130,65,249,252,255,75,
0,0,141,61,160,139,140,129,0,0,12,44,8,0,130,65,173,62,255,75,
0,0,141,61,164,139,140,129,0,0,12,44,12,0,130,65,0,0,96,56,
81,252,255,75,0,0,141,61,168,139,140,129,0,0,12,44,16,0,130,65,
185,251,255,75,220,0,99,56,121,62,255,75,0,0,141,61,172,139,140,129,
0,0,12,44,8,0,130,65,101,62,255,75,0,0,31,44,52,0,130,64,
0,0,96,57,9,0,97,153,16,0,97,145,8,0,129,57,12,0,129,145,
1,0,140,57,20,0,129,145,24,0,97,145,20,0,193,59,12,0,161,59,
8,0,225,155,1,0,224,59,0,0,141,61,68,133,204,147,0,0,141,61,
176,139,140,129,0,0,12,44,20,0,130,65,120,251,227,127,120,235,164,127,
120,243,197,127,5,62,255,75,120,251,227,127,120,235,164,127,120,243,197,127,
137,196,255,75,65,253,255,75,40,0,97,57,100,4,0,72,1,0,4,44,
208,0,130,64,0,0,131,137,8,0,12,40,84,0,128,64,0,0,99,137,
8,0,3,57,120,91,108,125,1,0,107,57,191,7,9,85,0,0,99,153,
58,16,140,85,12,0,130,64,8,0,67,129,36,0,0,72,80,64,9,125,
0,0,104,129,56,24,41,85,48,76,107,125,4,0,72,129,32,0,41,33,
48,72,74,125,120,91,74,125,20,98,138,125,188,2,0,72,4,0,35,57,
191,7,42,85,12,0,130,64,4,0,99,129,36,0,0,72,80,72,42,125,
0,0,137,129,56,24,74,85,48,84,140,125,4,0,105,129,32,0,74,33,
48,80,107,125,120,99,107,125,120,91,108,125,4,0,43,57,4,0,67,57,
191,7,75,85,12,0,130,64,4,0,35,145,32,0,0,72,0,0,42,153,
62,194,43,85,1,0,106,153,62,194,107,85,2,0,106,153,62,194,107,85,
3,0,106,153,76,2,0,72,2,0,4,44,12,0,130,65,3,0,4,44,
20,1,130,64,0,0,227,136,255,7,236,84,16,0,130,65,1,0,231,56,
62,6,231,84,0,0,227,152,8,0,7,40,76,0,128,64,8,0,35,57,
191,7,42,85,58,16,232,84,12,0,130,64,8,0,99,129,36,0,0,72,
80,72,42,125,0,0,137,129,56,24,74,85,48,84,140,125,4,0,105,129,
32,0,74,33,48,80,107,125,120,99,107,125,20,66,139,125,2,0,103,57,
0,0,99,153,212,1,0,72,4,0,35,57,191,7,42,85,12,0,130,64,
4,0,131,129,36,0,0,72,80,72,42,125,0,0,105,129,56,24,74,85,
48,84,107,125,4,0,137,129,32,0,74,33,48,80,140,125,120,91,140,125,
7,0,140,57,57,0,139,85,4,0,67,57,191,7,76,85,12,0,130,64,
4,0,99,145,32,0,0,72,0,0,106,153,62,194,108,85,1,0,138,153,
62,194,140,85,2,0,138,153,62,194,140,85,3,0,138,153,120,91,108,125,
8,0,43,57,4,0,67,57,191,7,75,85,12,0,130,64,4,0,35,145,
32,0,0,72,0,0,42,153,62,194,43,85,1,0,106,153,62,194,107,85,
2,0,106,153,62,194,107,85,3,0,106,153,44,1,0,72,0,0,131,137,
8,0,12,40,132,0,128,64,0,0,99,137,8,0,3,57,120,91,108,125,
1,0,107,57,191,7,9,85,0,0,99,153,58,16,140,85,12,0,130,64,
8,0,99,129,36,0,0,72,80,64,9,125,0,0,72,129,56,24,41,85,
48,76,74,125,4,0,104,129,32,0,41,33,48,72,107,125,120,83,107,125,
20,90,44,125,191,7,42,85,12,0,130,64,0,0,137,129,36,0,0,72,
80,72,42,125,0,0,105,129,56,24,74,85,48,84,107,125,4,0,137,129,
32,0,74,33,48,80,140,125,120,91,140,125,160,0,0,72,4,0,35,57,
191,7,42,85,12,0,130,64,4,0,99,129,36,0,0,72,80,72,42,125,
0,0,137,129,56,24,74,85,48,84,140,125,4,0,105,129,32,0,74,33,
48,80,107,125,120,99,107,125,120,91,104,125,191,7,9,85,12,0,130,64,
0,0,136,129,36,0,0,72,80,64,9,125,0,0,72,129,56,24,41,85,
48,76,74,125,4,0,136,129,32,0,41,33,48,72,140,125,120,83,140,125,
4,0,43,57,4,0,67,57,191,7,75,85,12,0,130,64,4,0,35,145,
32,0,0,72,0,0,42,153,62,194,43,85,1,0,106,153,62,194,107,85,
2,0,106,153,62,194,107,85,3,0,106,153,120,99,131,125,32,0,128,78,
0,0,64,0,184,255,203,145,188,255,235,145,192,255,11,146,196,255,43,146,
200,255,75,146,204,255,107,146,208,255,139,146,212,255,171,146,216,255,203,146,
220,255,235,146,224,255,11,147,228,255,43,147,232,255,75,147,236,255,107,147,
240,255,139,147,244,255,171,147,248,255,203,147,252,255,235,147,166,2,232,127,
32,0,128,78,0,0,96,0,184,255,203,129,188,255,235,129,192,255,11,130,
196,255,43,130,200,255,75,130,204,255,107,130,208,255,139,130,212,255,171,130,
216,255,203,130,220,255,235,130,224,255,11,131,228,255,43,131,232,255,75,131,
236,255,107,131,240,255,139,131,244,255,171,131,248,255,203,131,252,255,235,131,
32,0,128,78,0,0,64,0,184,255,203,145,188,255,235,145,192,255,11,146,
196,255,43,146,200,255,75,146,204,255,107,146,208,255,139,146,212,255,171,146,
216,255,203,146,220,255,235,146,224,255,11,147,228,255,43,147,232,255,75,147,
236,255,107,147,240,255,139,147,244,255,171,147,248,255,203,147,252,255,235,147,
4,0,11,144,166,2,232,127,32,0,128,78,0,0,96,0,184,255,203,129,
188,255,235,129,192,255,11,130,196,255,43,130,200,255,75,130,204,255,107,130,
208,255,139,130,212,255,171,130,216,255,203,130,220,255,235,130,224,255,11,131,
228,255,43,131,232,255,75,131,236,255,107,131,240,255,139,131,244,255,171,131,
248,255,203,131,4,0,11,128,252,255,235,131,166,3,8,124,120,91,97,125,
32,0,128,78,0,0,0,96,32,0,128,78,60,248,1,0,64,248,1,0,
68,248,1,0,72,248,1,0,76,248,1,0,80,248,1,0,84,248,1,0,
88,248,1,0,92,248,1,0,108,248,1,0,116,248,1,0,124,248,1,0,
132,248,1,0,140,248,1,0,148,248,1,0,156,248,1,0,164,248,1,0,
172,248,1,0,148,249,1,0,156,249,1,0,164,249,1,0,172,249,1,0,
180,249,1,0,188,249,1,0,196,249,1,0,204,249,1,0,212,249,1,0,
228,249,1,0,236,249,1,0,244,249,1,0,252,249,1,0,4,250,1,0,
12,250,1,0,20,250,1,0,28,250,1,0,36,250,1,0,124,250,1,0,
128,250,1,0,132,250,1,0,136,250,1,0,140,250,1,0,144,250,1,0,
148,250,1,0,152,250,1,0,50,50,50,50,50,50,50,50,50,49,49,49,
49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,49,177,177,177,177,177,177,177,177,67,104,101,99,107,105,110,103,
32,102,108,97,115,104,32,109,101,109,111,114,121,32,102,105,108,101,115,10,
0,0,0,0,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,
45,45,45,45,45,32,58,32,32,45,45,45,45,45,45,45,45,45,45,32,
32,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,10,0,
32,110,111,110,101,32,102,111,117,110,100,10,109,97,114,107,105,110,103,32,
108,97,115,116,32,118,97,108,105,100,32,102,105,108,101,46,46,46,46,0,
32,102,111,117,110,100,46,10,76,105,110,107,105,110,103,32,118,97,108,105,
100,32,102,105,108,101,115,46,46,46,46,32,10,0,0,0,32,68,111,110,
101,10,82,101,112,97,105,114,32,99,111,109,112,108,101,116,101,100,32,115,
117,99,99,101,115,115,102,117,108,108,121,32,10,0,0,0,10,10,82,101,
112,97,105,114,105,110,103,32,116,104,101,32,102,108,97,115,104,32,102,105,
108,101,32,115,121,115,116,101,109,10,0,0,66,97,100,32,100,105,114,101,
99,116,111,114,121,44,32,114,101,112,97,105,114,32,97,98,111,114,116,101,
100,10,0,0,48,120,37,48,56,88,46,48,120,37,48,56,88,32,58,32,
32,48,120,37,48,56,120,32,32,37,54,100,32,40,61,37,35,120,41,10,
0,0,0,0,118,97,108,105,100,97,116,105,111,110,32,102,97,105,108,101,
100,44,32,115,101,97,114,99,104,105,110,103,32,102,111,114,32,118,97,108,
105,100,32,102,105,108,101,115,46,46,46,46,0,0,0,0,32,82,101,112,
97,105,114,32,102,97,105,108,101,100,32,10,0,0,0,0,86,97,108,105,
100,97,116,105,110,103,32,102,108,97,115,104,32,102,105,108,101,32,115,121,
115,116,101,109,46,46,46,46,46,10,115,105,103,110,97,116,117,114,101,49,
46,115,105,103,110,97,116,117,114,101,50,32,58,32,32,97,100,100,114,101,
115,115,32,32,32,32,32,116,111,116,97,108,32,115,105,122,101,10,0,0,
85,110,115,117,112,112,111,114,116,101,100,32,70,108,97,115,104,70,105,108,
101,32,118,101,114,115,105,111,110,32,40,97,100,100,114,61,48,120,37,88,
41,10,0,0,102,108,97,115,104,70,105,108,101,46,99,112,112,0,0,0,
85,110,115,117,112,112,111,114,116,101,100,32,70,108,97,115,104,70,105,108,
101,32,118,101,114,115,105,111,110,32,40,97,100,100,114,61,48,120,37,88,
41,10,0,0,66,73,79,83,32,105,109,97,103,101,32,110,111,116,32,102,
111,117,110,100,32,105,110,32,102,108,97,115,104,33,10,0,70,105,114,109,
119,97,114,101,32,105,109,97,103,101,32,110,111,116,32,102,111,117,110,100,
32,105,110,32,102,108,97,115,104,33,10,0,85,110,101,120,112,101,99,116,
101,100,32,108,111,99,97,116,105,111,110,32,111,102,32,70,105,114,109,119,
97,114,101,32,105,110,32,102,108,97,115,104,33,10,0,0,32,32,32,69,
120,112,101,99,116,101,100,32,97,100,100,114,58,32,37,120,32,32,32,32,
65,99,116,117,97,108,32,97,100,100,114,58,32,37,120,10,0,0,0,0,
85,110,101,120,112,101,99,116,101,100,32,115,105,122,101,32,111,102,32,70,
105,114,109,119,97,114,101,32,104,101,97,100,101,114,33,10,0,0,0,0,
32,32,32,69,120,112,101,99,116,101,100,32,115,105,122,101,58,32,37,120,
32,32,32,32,65,99,116,117,97,108,32,115,105,122,101,58,32,37,120,10,
0,0,0,0,85,110,101,120,112,101,99,116,101,100,32,108,111,99,97,116,
105,111,110,32,111,102,32,66,73,79,83,32,105,110,32,102,108,97,115,104,
33,10,0,0,85,110,101,120,112,101,99,116,101,100,32,115,105,122,101,32,
111,102,32,66,73,79,83,32,104,101,97,100,101,114,33,10,0,69,114,114,
111,114,58,32,100,101,116,101,99,116,101,100,32,109,105,115,109,97,116,99,
104,32,105,110,32,116,104,101,32,115,116,97,116,105,99,32,100,101,115,116,
114,117,99,116,111,114,32,111,114,100,101,114,105,110,103,32,115,116,114,97,
116,101,103,121,10,0,0,0,0,69,114,114,111,114,58,32,100,101,116,101,
99,116,101,100,32,109,105,115,109,97,116,99,104,32,105,110,32,116,104,101,
32,115,116,97,116,105,99,32,100,101,115,116,114,117,99,116,111,114,32,111,
114,100,101,114,105,110,103,32,115,116,114,97,116,101,103,121,10,0,67,43,
43,32,114,117,110,116,105,109,101,32,97,98,111,114,116,0,0,0,102,114,
101,101,105,110,103,32,97,114,114,97,121,32,110,111,116,32,97,108,108,111,
99,97,116,101,100,32,98,121,32,97,110,32,97,114,114,97,121,32,110,101,
119,32,111,112,101,114,97,116,105,111,110,0,0,0,116,101,114,109,105,110,
97,116,101,40,41,32,99,97,108,108,101,100,32,98,121,32,116,104,101,32,
101,120,99,101,112,116,105,111,110,32,104,97,110,100,108,105,110,103,32,109,
101,99,104,97,110,105,115,109,0,0,114,101,116,117,114,110,101,100,32,102,
114,111,109,32,97,32,117,115,101,114,45,100,101,102,105,110,101,100,32,116,
101,114,109,105,110,97,116,101,40,41,32,114,111,117,116,105,110,101,0,0,
0,0,109,97,105,110,40,41,32,99,97,108,108,101,100,32,109,111,114,101,
32,116,104,97,110,32,111,110,99,101,0,0,0,0,97,32,112,117,114,101,
32,118,105,114,116,117,97,108,32,102,117,110,99,116,105,111,110,32,119,97,
115,32,99,97,108,108,101,100,0,0,105,110,118,97,108,105,100,32,100,121,
110,97,109,105,99,32,99,97,115,116,0,0,0,0,105,110,118,97,108,105,
100,32,116,121,112,101,105,100,32,111,112,101,114,97,116,105,111,110,0,0,
0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,115,116,
97,116,105,99,32,111,98,106,101,99,116,32,109,97,114,107,101,100,32,102,
111,114,32,100,101,115,116,114,117,99,116,105,111,110,32,109,111,114,101,32,
116,104,97,110,32,111,110,99,101,0,37,115,58,32,37,115,10,0,40,110,
117,108,108,41,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,
69,70,65,77,0,80,77,0,0,0,83,117,110,77,111,110,84,117,101,87,
101,100,84,104,117,70,114,105,83,97,116,0,0,0,74,97,110,70,101,98,
77,97,114,65,112,114,77,97,121,74,117,110,74,117,108,65,117,103,83,101,
112,79,99,116,78,111,118,68,101,99,0,0,0,0,83,117,110,100,97,121,
0,77,111,110,100,97,121,0,84,117,101,115,100,97,121,0,87,101,100,110,
101,115,100,97,121,0,84,104,117,114,115,100,97,121,0,70,114,105,100,97,
121,0,83,97,116,117,114,100,97,121,0,0,0,0,74,97,110,117,97,114,
121,0,70,101,98,114,117,97,114,121,0,77,97,114,99,104,0,65,112,114,
105,108,0,77,97,121,0,74,117,110,101,0,74,117,108,121,0,65,117,103,
117,115,116,0,83,101,112,116,101,109,98,101,114,0,79,99,116,111,98,101,
114,0,78,111,118,101,109,98,101,114,0,68,101,99,101,109,98,101,114,0,
0,0,87,69,84,0,32,32,32,0,32,32,32,0,32,32,32,0,65,83,
84,0,69,83,84,0,67,83,84,0,77,83,84,0,80,83,84,0,32,32,
32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,
32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,32,0,32,32,
32,0,32,32,32,0,32,32,32,0,32,32,32,0,77,69,84,0,69,69,
84,0,32,32,32,0,44,32,108,105,110,101,32,0,34,44,32,0,102,105,
108,101,32,0,0,0,65,115,115,101,114,116,105,111,110,32,102,97,105,108,
101,100,58,32,0,0,95,117,110,107,110,111,119,110,32,115,116,114,105,110,
103,95,0,0,0,0,95,78,97,109,101,108,101,115,115,95,0,31,28,31,
30,31,30,31,31,30,31,30,31,31,28,31,30,31,30,31,31,30,31,30,
152,198,0,0,0,0,0,0,0,0,0,0,64,239,1,0,0,0,0,0,
219,8,0,0,28,248,1,0,0,0,0,0,13,0,0,0,60,248,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
238,238,34,34,187,187,85,85,73,78,86,65,76,73,68,0,68,73,82,72,
69,65,68,0,68,73,82,84,65,73,76,0,67,79,77,80,95,48,51,0,
67,79,77,80,95,48,52,0,67,79,77,80,95,48,53,0,67,79,77,80,
95,48,54,0,67,79,77,80,95,48,55,0,67,79,77,80,95,48,56,0,
36,86,69,82,86,69,82,36,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,240,238,1,0,248,238,1,0,0,239,1,0,
8,239,1,0,16,239,1,0,24,239,1,0,32,239,1,0,40,239,1,0,
48,239,1,0,0,0,0,0,0,0,0,0,0,0,0,0,172,166,0,0,
0,0,0,0,172,166,0,0,0,0,0,0,172,166,0,0,0,0,0,0,
172,166,0,0,0,0,0,0,172,166,0,0,0,0,0,0,172,166,0,0,
0,0,0,0,172,166,0,0,0,0,0,0,172,166,0,0,0,0,0,0,
224,164,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,32,0,0,0,8,0,0,0,8,0,0,0,16,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,64,0,0,0,
64,0,0,0,32,0,0,0,8,0,0,0,8,0,0,0,16,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,252,150,0,0,0,0,0,0,
124,150,0,0,0,0,0,0,160,148,0,0,0,0,0,0,168,148,0,0,
0,0,0,0,176,148,0,0,0,0,0,0,248,148,0,0,0,0,0,0,
68,149,0,0,0,0,0,0,240,149,0,0,0,0,0,0,224,164,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,232,153,0,0,0,0,0,0,
124,150,0,0,0,0,0,0,160,148,0,0,0,0,0,0,168,148,0,0,
0,0,0,0,176,148,0,0,0,0,0,0,248,148,0,0,0,0,0,0,
68,149,0,0,0,0,0,0,240,149,0,0,0,0,0,0,224,164,0,0,
232,3,0,0,0,0,0,0,0,0,0,0,40,70,108,111,97,116,105,110,
103,32,112,111,105,110,116,32,111,117,116,112,117,116,32,117,110,115,117,112,
112,111,114,116,101,100,32,119,47,45,110,111,102,108,111,97,116,105,111,32,
111,114,32,45,102,110,111,110,101,41,0,71,77,84,0,32,32,32,0,0,
20,0,0,0,0,0,0,0,44,189,0,0,56,190,0,0,0,0,0,0,
188,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,48,32,16,
68,51,34,17,3,0,24,0,216,119,11,0,21,22,185,207,216,119,11,0,
0,128,0,0,120,43,166,124,120,35,133,124,120,27,100,124,20,0,96,56,
130,17,66,76,81,107,11,72,166,2,136,125,45,0,32,60,192,165,33,56,
0,0,160,61,104,0,173,57,3,0,4,40,24,0,130,65,2,0,4,40,
16,0,130,65,4,0,4,40,8,0,130,65,0,0,128,56,0,0,160,56,
0,0,192,56,12,0,64,60,112,109,66,56,1,0,96,61,24,128,107,57,
16,96,107,125,0,0,64,61,0,0,74,57,0,0,10,40,8,0,130,64,
20,90,66,124,0,64,173,57,0,64,173,57,1,0,75,61,224,128,74,57,
4,0,202,133,4,0,234,133,4,0,10,134,4,0,42,134,4,0,74,134,
4,0,106,134,4,0,138,134,4,0,170,134,4,0,202,134,4,0,234,134,
0,0,64,57,56,0,33,84,248,255,65,149,0,0,108,60,244,0,99,56,
76,2,0,72,72,0,128,186,56,96,0,1,60,96,128,0,124,123,235,166,
124,0,7,140,76,0,1,44,2,128,0,72,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
196,222,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,240,255,33,148,12,0,225,147,120,27,106,124,120,35,139,124,
120,43,172,124,120,91,100,125,120,83,69,125,20,98,196,124,120,43,167,124,
238,15,224,59,0,0,96,56,0,1,0,72,126,248,99,84,239,5,108,84,
0,0,12,44,20,0,130,64,120,35,140,124,1,0,132,56,0,0,108,137,
0,255,99,97,255,7,108,84,0,0,12,44,48,0,130,65,120,35,140,124,
1,0,132,56,0,0,108,137,120,43,172,124,1,0,165,56,116,7,107,125,
62,6,107,85,0,0,108,153,1,0,159,57,63,5,159,85,168,0,0,72,
120,35,140,124,1,0,132,56,0,0,140,137,120,35,139,124,1,0,132,56,
0,0,43,137,55,6,43,85,54,32,107,85,120,91,140,125,63,7,43,85,
3,0,43,57,80,248,108,125,80,40,11,125,0,96,31,124,8,0,129,65,
0,240,8,57,0,0,96,57,28,0,0,72,120,43,170,124,1,0,165,56,
0,0,128,57,0,0,138,153,1,0,8,57,1,0,107,57,0,56,8,124,
8,0,128,65,44,0,0,72,0,72,11,124,216,255,128,65,32,0,0,72,
120,43,170,124,1,0,165,56,120,67,12,125,1,0,8,57,0,0,140,137,
0,0,138,153,1,0,107,57,0,72,11,124,224,255,128,65,20,74,159,125,
63,5,159,85,64,48,4,124,0,255,130,64,12,0,225,131,16,0,33,56,
32,0,128,78,120,27,102,124,120,35,140,124,120,43,171,124,20,90,230,124,
62,6,140,85,120,99,136,125,255,255,38,57,32,0,11,40,108,0,129,64,
120,67,11,125,46,64,107,85,120,67,107,125,30,128,108,85,120,99,107,125,
12,0,0,72,255,255,231,56,0,0,7,153,63,7,236,84,0,0,12,44,
240,255,130,64,55,0,202,84,32,0,0,72,0,0,103,145,4,0,135,57,
0,0,108,145,8,0,135,57,0,0,108,145,12,0,135,57,0,0,108,145,
240,255,231,56,64,80,7,124,220,255,130,64,16,0,231,56,8,0,0,72,
0,0,7,153,255,255,231,56,64,72,7,124,244,255,130,64,120,51,204,124,
120,99,131,125,32,0,128,78,166,2,8,124,200,255,33,148,24,0,1,147,
28,0,33,147,32,0,65,147,36,0,97,147,40,0,129,147,44,0,161,147,
48,0,193,147,52,0,225,147,60,0,1,144,120,27,107,124,120,35,157,124,
120,43,190,124,120,51,223,124,1,0,128,63,244,134,156,59,1,0,128,60,
108,130,132,56,7,0,192,60,0,5,198,56,12,0,224,60,108,235,231,56,
0,0,96,59,120,35,136,124,120,227,137,127,16,0,139,57,0,0,44,131,
20,0,139,57,0,0,108,128,24,0,139,57,0,0,76,131,28,0,139,57,
0,0,172,128,80,208,89,125,0,0,128,57,8,0,129,145,8,0,129,57,
4,0,108,57,0,0,128,57,0,0,139,145,8,0,129,57,8,0,108,57,
0,0,128,57,0,0,139,145,8,0,129,57,12,0,108,57,0,0,128,57,
0,0,139,145,64,208,7,124,12,0,128,65,64,56,5,124,8,0,129,65,
208,0,106,127,64,208,8,124,12,0,128,65,64,64,5,124,12,0,129,65,
20,82,132,124,20,82,198,124,64,72,26,124,24,0,129,65,64,40,9,124,
16,0,128,64,64,24,25,124,8,0,130,65,80,224,138,127,64,40,26,124,
24,0,130,65,120,203,35,127,120,211,68,127,80,40,186,124,166,3,201,124,
33,4,128,78,12,0,128,61,108,235,140,57,20,218,44,127,12,0,128,61,
192,235,140,57,20,218,76,127,64,0,0,72,120,203,43,127,4,0,57,59,
8,0,129,57,12,0,140,57,0,0,107,129,0,0,140,129,20,98,75,125,
0,0,121,129,4,0,57,59,0,0,153,129,4,0,57,59,120,83,67,125,
120,91,100,125,120,99,133,125,225,253,255,75,64,208,25,124,192,255,130,64,
12,0,128,61,192,235,140,57,20,218,76,127,12,0,128,61,20,236,140,57,
20,218,44,127,12,0,128,61,20,236,140,57,20,218,12,127,104,0,0,72,
0,200,26,124,20,0,128,64,8,0,129,57,12,0,140,57,0,0,108,129,
16,0,0,72,8,0,129,57,4,0,140,57,0,0,108,129,0,0,154,129,
20,90,76,125,4,0,90,59,120,211,75,127,4,0,90,59,8,0,129,57,
4,0,140,57,0,0,107,129,0,0,140,129,20,98,107,125,0,0,154,129,
4,0,90,59,120,83,67,125,120,91,100,125,120,99,133,125,225,127,6,72,
64,192,26,124,152,255,130,64,12,0,128,61,20,236,140,57,20,218,76,127,
12,0,128,61,20,236,140,57,20,218,44,127,12,0,128,61,20,236,140,57,
20,218,12,127,104,0,0,72,0,200,26,124,20,0,128,64,8,0,129,57,
12,0,140,57,0,0,108,129,16,0,0,72,8,0,129,57,4,0,140,57,
0,0,108,129,0,0,154,129,20,90,76,125,4,0,90,59,120,211,75,127,
4,0,90,59,8,0,129,57,4,0,140,57,0,0,107,129,0,0,140,129,
20,98,107,125,0,0,154,129,4,0,90,59,120,83,67,125,120,91,100,125,
120,99,133,125,121,251,255,75,64,192,26,124,152,255,130,64,12,0,128,61,
20,236,140,57,20,218,204,124,12,0,128,61,72,236,140,57,20,218,236,124,
12,0,128,61,72,236,140,57,20,218,12,125,64,48,7,124,192,0,130,65,
8,0,129,57,12,0,140,57,0,0,96,61,0,0,107,57,0,0,140,129,
80,88,140,125,80,56,236,124,160,0,0,72,120,67,12,125,1,0,8,57,
0,0,140,137,116,7,140,125,183,6,139,85,112,38,107,125,120,91,106,125,
58,16,74,85,8,0,97,57,20,82,107,125,0,0,75,129,120,51,203,124,
4,0,198,56,0,0,107,129,20,82,107,125,0,0,43,129,49,6,138,85,
0,0,10,44,12,0,130,65,0,0,9,44,76,0,130,65,191,7,138,85,
120,83,69,125,58,16,165,84,8,0,65,57,20,42,74,125,0,0,74,129,
0,0,10,44,44,0,130,65,57,7,133,85,0,0,5,44,8,0,130,65,
58,16,41,85,20,82,41,125,57,7,140,85,0,0,12,44,8,0,130,65,
112,22,41,125,0,0,43,145,64,56,6,124,96,255,130,64,120,235,163,127,
120,243,196,127,120,251,229,127,166,3,137,127,33,4,128,78,24,0,1,131,
28,0,33,131,32,0,65,131,36,0,97,131,40,0,129,131,44,0,161,131,
48,0,193,131,52,0,225,131,60,0,1,128,166,3,8,124,56,0,33,56,
32,0,128,78,166,2,8,124,240,255,33,148,8,0,193,147,12,0,225,147,
20,0,1,144,120,27,127,124,120,35,158,124,120,43,172,124,24,128,130,129,
0,0,12,44,8,0,130,65,1,52,6,72,28,128,130,129,0,0,12,44,
8,0,130,65,1,130,6,72,32,128,130,129,0,0,12,44,8,0,130,65,
193,120,255,75,36,128,130,129,0,0,12,44,12,0,130,65,0,0,96,56,
97,129,6,72,120,251,227,127,120,243,196,127,245,5,0,72,8,0,193,131,
12,0,225,131,20,0,1,128,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,124,196,141,129,
120,35,135,124,120,43,164,124,40,0,172,128,120,27,102,124,11,0,96,60,
196,222,99,56,177,94,6,72,196,136,13,160,49,6,0,84,88,0,130,64,
196,136,13,160,128,0,0,96,0,0,96,56,196,136,13,176,45,190,5,72,
1,0,96,57,8,0,97,145,255,255,96,56,161,89,7,72,43,0,224,63,
36,212,127,56,255,255,128,56,229,229,9,72,0,0,3,44,240,255,130,64,
8,0,129,129,0,0,12,44,16,0,130,65,0,0,0,56,8,0,1,144,
109,89,7,72,0,0,0,72,216,255,33,148,12,0,33,147,16,0,65,147,
20,0,97,147,24,0,129,147,28,0,161,147,166,2,8,124,44,0,1,144,
36,0,225,147,120,35,159,124,32,0,193,147,120,27,126,124,50,0,96,56,
65,74,6,72,120,27,125,124,11,0,128,60,232,222,132,56,41,242,5,72,
120,251,228,127,120,235,165,127,11,0,96,60,244,222,99,56,241,93,6,72,
120,235,163,127,25,74,6,72,166,0,32,127,94,4,40,87,36,1,0,125,
232,129,13,128,40,0,0,44,120,0,128,64,224,129,77,129,1,0,74,57,
40,0,10,44,224,129,77,145,12,0,128,65,0,0,0,56,224,129,13,144,
232,129,141,129,1,0,140,57,232,129,141,145,224,129,13,128,12,0,128,63,
0,0,128,56,124,0,160,56,52,88,156,59,48,56,27,84,20,218,188,127,
4,0,93,59,120,211,67,127,149,249,255,75,120,211,67,127,120,251,228,127,
120,243,197,127,124,0,192,56,77,11,4,72,4,0,253,136,113,0,7,44,
104,0,130,65,76,0,0,72,224,129,13,128,12,0,128,63,48,56,27,84,
0,0,128,56,124,0,160,56,52,88,156,59,20,218,188,127,4,0,93,59,
120,211,67,127,73,249,255,75,120,211,67,127,255,0,128,56,120,243,197,127,
124,0,192,56,1,11,4,72,4,0,253,136,113,0,7,44,28,0,130,65,
29,0,61,137,113,0,0,57,4,0,64,57,4,0,29,153,126,7,73,81,
29,0,61,153,248,191,109,129,46,217,124,125,0,128,44,115,166,0,0,124,
94,4,0,84,120,99,0,124,36,1,0,124,32,0,193,131,24,0,129,131,
20,0,97,131,28,0,161,131,36,0,225,131,44,0,1,128,16,0,65,131,
12,0,33,131,166,3,8,124,40,0,33,56,32,0,128,78,232,255,33,148,
8,0,129,147,12,0,161,147,16,0,193,147,166,2,8,124,28,0,1,144,
20,0,225,147,120,27,127,124,166,0,128,127,94,4,136,87,36,1,0,125,
232,129,13,128,0,0,0,44,4,0,127,56,124,0,160,56,104,0,129,64,
228,129,77,129,12,0,192,63,48,56,93,85,52,88,222,59,20,234,158,125,
4,0,140,56,1,123,6,72,228,129,141,129,1,0,140,57,40,0,12,44,
46,232,30,124,0,0,31,144,228,129,141,145,12,0,128,65,0,0,0,56,
228,129,13,144,232,129,45,129,255,255,41,57,232,129,45,145,0,128,137,115,
166,0,64,125,94,4,74,85,120,75,74,125,36,1,64,125,60,0,0,72,
0,0,128,56,29,248,255,75,0,0,0,56,26,0,31,176,112,0,96,57,
4,0,127,153,10,0,128,57,11,0,159,153,0,0,31,144,0,128,137,115,
166,0,64,125,94,4,74,85,120,75,74,125,36,1,64,125,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,0,0,0,56,0,0,4,152,1,0,4,152,
2,0,96,56,32,0,128,78,120,255,33,148,124,0,161,147,28,0,129,144,
32,0,161,144,36,0,193,144,44,0,1,145,48,0,33,145,52,0,65,145,
132,0,225,147,120,35,159,124,40,0,225,144,24,0,225,56,16,0,225,144,
166,2,8,124,140,0,1,144,144,0,1,56,12,0,1,144,2,0,0,56,
8,0,1,152,0,0,128,57,9,0,129,153,24,0,97,144,128,0,193,147,
120,27,126,124,255,0,96,56,105,71,6,72,120,27,125,124,120,251,228,127,
8,0,161,56,233,80,6,72,166,0,224,127,94,4,224,87,36,1,0,124,
120,235,163,127,120,243,196,127,205,252,255,75,196,136,109,161,247,6,107,85,
20,0,130,65,16,0,96,61,0,32,32,61,24,0,105,149,4,0,105,145,
0,128,234,115,166,0,128,125,94,4,140,85,120,83,140,125,36,1,128,125,
120,235,163,127,13,71,6,72,132,0,225,131,140,0,1,128,128,0,193,131,
124,0,161,131,166,3,8,124,136,0,33,56,32,0,128,78,232,255,33,148,
166,2,8,124,28,0,1,144,16,0,193,147,40,0,192,59,12,0,161,147,
0,0,160,59,20,0,225,147,12,0,224,63,180,87,255,59,128,0,191,151,
4,0,127,56,0,0,128,56,124,0,160,56,153,246,255,75,255,255,222,55,
26,0,191,179,228,255,130,64,40,0,96,57,224,129,109,145,0,0,0,56,
228,129,13,144,232,129,13,144,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,16,0,3,40,
32,0,128,76,10,0,32,57,224,255,128,57,236,129,237,56,50,48,107,84,
20,90,71,125,20,90,231,124,0,0,160,56,36,0,0,57,20,0,10,181,
2,0,170,152,231,255,192,56,3,0,202,152,12,0,7,181,2,0,135,153,
64,0,0,56,3,0,7,152,236,129,205,56,20,90,166,124,16,0,5,181,
20,90,6,125,120,67,10,125,2,0,133,153,3,0,5,152,0,0,40,177,
2,0,136,153,200,255,160,56,3,0,168,152,120,67,7,125,4,0,39,181,
2,0,135,153,3,0,167,152,8,0,42,181,18,0,32,57,2,0,138,153,
3,0,170,152,24,0,40,181,2,0,136,153,202,255,0,56,3,0,8,152,
18,1,0,57,20,90,198,124,28,0,38,181,2,0,134,153,3,0,6,152,
236,129,237,56,20,90,71,125,32,0,42,181,20,90,39,125,2,0,138,153,
3,0,10,152,36,0,9,181,2,0,137,153,3,0,9,152,20,90,231,124,
40,0,7,181,2,0,135,153,3,0,7,152,236,129,77,57,20,90,170,124,
44,0,5,181,2,0,133,153,3,0,5,152,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,0,0,128,56,120,35,131,124,233,254,255,75,
1,0,132,56,16,0,4,44,240,255,128,65,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,128,0,96,56,32,0,128,78,232,255,33,148,
12,0,161,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
20,0,225,147,120,35,159,124,45,64,6,72,120,243,195,127,120,251,228,127,
149,233,0,72,120,243,195,127,177,92,7,72,197,73,4,72,120,27,125,124,
53,187,5,72,0,0,29,44,12,0,130,65,120,235,163,127,9,210,0,72,
11,0,96,60,72,225,99,56,169,88,6,72,11,0,96,60,168,225,99,56,
157,88,6,72,11,0,96,60,196,225,99,56,145,88,6,72,40,128,98,56,
137,88,6,72,11,0,160,63,56,225,125,56,125,88,6,72,40,128,98,56,
117,88,6,72,11,0,96,60,220,225,99,56,105,88,6,72,11,0,96,60,
104,225,99,56,24,0,128,56,30,0,160,56,85,88,6,72,11,0,96,60,
136,225,99,56,8,0,128,56,4,0,160,56,65,88,6,72,11,0,96,60,
0,226,99,56,11,0,128,60,28,226,132,56,11,0,160,60,40,226,165,56,
37,88,6,72,11,0,96,60,52,226,99,56,25,88,6,72,120,251,228,127,
120,243,197,127,11,0,96,60,76,226,99,56,5,88,6,72,40,128,98,56,
253,87,6,72,56,225,125,56,245,87,6,72,40,128,98,56,237,87,6,72,
121,33,6,72,20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,
0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,
8,0,193,147,12,0,225,147,8,0,69,129,18,0,228,163,52,3,131,129,
16,32,96,61,190,244,140,85,72,2,139,145,254,239,231,87,0,32,0,61,
76,2,72,145,0,0,128,57,76,2,136,149,57,7,236,87,60,8,204,84,
120,99,233,124,32,0,130,65,10,0,196,163,92,3,131,137,88,3,99,128,
255,223,107,84,12,0,164,128,4,1,130,65,28,0,0,72,10,0,196,163,
93,3,131,137,88,3,99,128,255,223,107,84,12,0,164,128,232,0,130,65,
255,215,107,84,144,0,130,65,30,64,203,87,0,17,107,101,120,91,41,125,
0,0,40,145,63,6,203,87,0,17,107,97,0,18,106,101,24,152,203,84,
120,91,73,125,0,0,40,145,62,70,171,84,0,19,107,97,0,19,106,101,
30,130,171,84,120,91,73,125,0,20,64,61,0,20,74,57,30,66,171,84,
120,83,102,125,30,2,170,84,239,5,235,87,0,21,96,61,0,21,107,57,
120,91,68,125,192,0,64,57,12,0,130,65,255,207,107,84,8,0,130,64,
64,0,64,57,0,22,75,97,0,151,107,101,30,128,140,85,120,99,108,125,
0,0,40,145,236,0,0,72,0,17,42,101,30,128,203,87,120,91,73,125,
56,24,203,84,0,18,107,97,0,19,106,101,30,130,171,84,120,91,70,125,
62,198,171,84,0,20,107,97,0,21,106,101,30,2,171,84,120,91,68,125,
62,70,171,84,64,22,107,97,0,151,107,101,30,128,140,85,120,99,108,125,
0,0,40,145,156,0,0,72,63,6,171,84,255,215,106,84,0,19,107,97,
0,20,106,101,80,0,130,65,30,64,203,87,0,18,107,101,120,91,41,125,
0,0,40,145,63,6,203,87,0,18,107,97,0,19,105,101,30,194,171,84,
120,91,41,125,0,0,40,145,120,83,73,125,62,198,171,84,0,20,107,97,
0,21,102,101,62,134,171,84,0,21,107,97,64,22,100,101,0,151,140,97,
56,0,0,72,0,18,41,101,30,128,203,87,120,91,41,125,30,66,171,84,
120,91,70,125,62,70,171,84,64,0,107,97,30,128,106,85,62,134,171,84,
0,21,107,97,0,22,107,101,120,83,100,125,0,151,140,97,0,0,40,145,
0,0,200,144,0,0,136,144,0,0,136,145,12,0,225,131,8,0,193,131,
62,6,227,84,16,0,33,56,32,0,128,78,192,255,33,148,8,0,65,146,
12,0,97,146,16,0,129,146,20,0,161,146,24,0,193,146,28,0,225,146,
32,0,1,147,36,0,33,147,40,0,65,147,44,0,97,147,48,0,129,147,
52,0,161,147,56,0,193,147,60,0,225,147,0,0,133,131,28,0,252,131,
132,0,233,119,0,6,96,63,0,0,64,57,20,0,130,65,204,136,141,137,
0,0,12,44,8,0,130,65,1,0,64,57,16,32,128,61,0,0,140,57,
148,0,140,144,255,255,106,49,16,81,43,127,8,1,234,119,255,255,105,49,
16,73,107,124,255,255,106,49,16,81,43,125,12,0,92,129,0,0,103,129,
254,63,255,87,8,217,123,80,0,0,192,58,120,227,151,127,132,232,59,81,
120,179,221,126,120,179,195,126,255,255,74,57,66,240,251,83,254,47,122,87,
254,31,120,87,254,23,115,87,128,0,61,33,5,0,9,44,120,227,159,127,
132,0,128,64,255,5,201,86,120,187,255,126,72,0,130,65,120,187,252,126,
0,0,133,147,1,0,117,56,0,0,102,144,24,0,124,128,126,186,222,86,
80,24,41,125,0,0,39,145,254,1,59,81,44,72,195,87,126,186,105,84,
64,240,9,124,148,0,140,146,0,0,38,129,0,128,123,103,92,0,129,64,
100,0,0,72,126,186,222,86,44,72,195,87,126,186,105,84,64,240,9,124,
0,0,166,146,148,0,140,146,0,0,38,129,4,0,151,131,0,128,123,103,
0,0,133,147,44,0,129,64,52,0,0,72,24,0,63,129,80,72,43,125,
126,186,222,86,254,1,59,81,20,74,99,124,126,186,105,84,64,240,9,124,
0,0,38,129,16,0,129,65,0,0,25,44,52,0,130,65,28,0,0,72,
0,0,25,44,120,27,118,124,20,234,132,126,120,251,247,127,120,75,53,125,
24,0,130,65,12,0,223,131,64,240,10,124,4,1,123,87,8,0,130,65,
198,224,59,83,255,255,41,53,0,0,38,145,24,0,130,64,0,0,40,137,
0,0,9,44,0,128,123,103,8,0,130,65,74,209,59,81,255,55,105,87,
148,0,108,147,1,0,189,59,20,0,130,64,0,0,26,44,254,15,114,87,
72,0,130,65,52,0,0,72,255,15,114,87,28,0,63,129,20,0,130,65,
0,0,200,139,0,0,30,44,8,0,130,65,0,16,41,101,0,0,26,44,
148,0,44,145,136,1,123,87,1,0,189,59,20,0,130,65,8,0,63,129,
1,0,189,59,20,90,105,125,148,0,108,145,255,39,107,87,16,0,130,65,
12,0,95,129,1,0,189,59,148,0,76,145,0,0,24,44,16,0,130,65,
16,0,127,129,1,0,189,59,148,0,108,145,0,0,19,44,16,0,130,65,
20,0,127,129,1,0,189,59,148,0,108,145,0,0,18,44,24,0,130,64,
4,0,156,131,0,0,96,57,0,0,133,147,0,0,103,145,64,254,255,75,
48,0,129,131,20,0,161,130,24,0,193,130,52,0,161,131,44,0,97,131,
16,0,129,130,28,0,225,130,56,0,193,131,40,0,65,131,12,0,97,130,
32,0,1,131,60,0,225,131,36,0,33,131,8,0,65,130,64,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
166,0,224,127,94,4,235,87,36,1,96,125,80,3,99,128,0,3,128,56,
61,165,6,72,62,7,96,84,1,0,0,40,16,0,130,65,3,0,0,40,
52,0,130,65,92,0,0,72,0,128,236,115,166,0,0,124,94,4,0,84,
120,99,0,124,36,1,0,124,20,0,1,128,12,0,225,131,1,0,96,56,
16,0,33,56,166,3,8,124,32,0,128,78,0,128,236,115,166,0,0,124,
94,4,0,84,120,99,0,124,36,1,0,124,20,0,1,128,12,0,225,131,
2,0,96,56,16,0,33,56,166,3,8,124,32,0,128,78,0,128,235,115,
166,0,128,125,94,4,140,85,120,91,140,125,36,1,128,125,20,0,1,128,
12,0,225,131,0,0,96,56,16,0,33,56,166,3,8,124,32,0,128,78,
0,0,36,129,0,0,9,44,12,0,130,64,0,0,96,56,32,0,128,78,
4,0,100,128,4,0,68,129,8,0,106,129,4,0,139,129,255,255,41,53,
0,0,0,56,0,0,36,145,8,0,130,65,120,99,128,125,4,0,4,144,
32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,
12,0,225,147,120,35,159,124,0,0,95,129,0,0,10,44,1,0,10,56,
0,0,31,144,120,27,107,124,120,43,164,124,40,0,130,64,8,0,4,128,
8,0,31,144,4,0,159,144,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,0,0,6,44,44,0,130,65,
0,0,192,59,112,3,107,56,141,164,6,72,0,0,3,44,16,0,130,65,
112,3,107,56,77,161,6,72,120,27,126,124,121,243,196,127,20,0,130,65,
8,0,159,129,4,0,140,144,8,0,36,129,8,0,63,145,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,27,125,124,16,0,193,147,120,35,158,124,166,0,224,127,94,4,236,87,
36,1,128,125,112,3,125,56,229,160,6,72,0,0,3,44,44,0,130,65,
8,0,93,129,0,0,192,56,8,0,157,56,255,255,74,57,120,27,101,124,
120,235,163,127,8,0,93,145,249,254,255,75,0,0,30,44,204,255,130,65,
0,128,235,115,166,0,0,124,94,4,0,84,120,91,0,124,36,1,0,124,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,120,35,133,124,236,3,131,56,0,0,192,56,
176,254,255,75,240,255,33,148,8,0,193,147,12,0,225,147,166,2,8,124,
20,0,1,144,166,0,224,127,94,4,224,87,36,1,0,124,120,27,126,124,
0,0,128,56,53,255,255,75,120,243,195,127,8,0,158,56,57,254,255,75,
121,27,100,124,16,0,130,65,120,243,195,127,173,255,255,75,228,255,255,75,
0,128,235,115,166,0,0,124,94,4,0,84,120,91,0,124,36,1,0,124,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,16,0,193,147,
20,0,225,147,166,2,8,124,28,0,1,144,166,0,192,127,94,4,192,87,
36,1,0,124,2,0,128,59,176,255,163,59,0,0,224,59,84,0,125,132,
0,0,3,44,60,0,130,65,255,255,67,57,43,0,125,57,40,0,160,56,
166,3,169,124,1,0,202,140,1,0,11,140,81,48,128,125,8,0,130,64,
240,255,0,66,0,0,12,44,16,0,130,64,4,0,157,56,40,0,160,56,
73,110,6,72,255,255,156,55,0,0,253,147,180,255,130,64,0,128,200,115,
166,0,0,124,94,4,0,84,120,67,0,124,36,1,0,124,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,
16,0,193,147,166,2,8,124,28,0,1,144,20,0,225,147,120,27,127,124,
88,3,159,137,63,7,140,85,120,35,156,124,120,43,189,124,172,0,130,64,
0,0,29,44,164,0,130,65,120,251,227,127,0,0,128,56,233,253,255,75,
120,251,227,127,8,0,159,56,237,252,255,75,121,27,126,124,28,0,130,65,
64,224,30,124,20,0,130,65,120,251,227,127,120,243,196,127,85,254,255,75,
0,0,192,59,120,251,227,127,89,254,255,75,0,0,30,44,24,0,130,65,
120,251,227,127,8,0,159,56,120,243,197,127,0,0,192,56,233,252,255,75,
88,3,31,136,62,7,160,83,88,3,31,152,88,3,63,129,0,0,64,57,
0,2,41,97,88,3,63,145,96,3,95,145,12,128,45,129,72,3,159,129,
1,0,0,56,48,96,11,124,120,88,41,125,12,128,45,145,16,128,77,129,
120,88,74,125,16,128,77,145,0,4,127,128,105,254,255,75,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,224,255,33,148,12,0,97,147,16,0,129,147,
166,2,8,124,36,0,1,144,24,0,193,147,120,35,158,124,28,0,225,147,
120,43,191,124,20,0,161,147,120,27,125,124,73,251,255,75,120,27,124,124,
1,0,28,44,0,0,128,56,8,0,130,64,127,0,128,56,120,243,195,127,
12,0,160,56,33,234,255,75,2,0,28,44,8,1,130,64,80,3,125,128,
32,1,128,56,0,0,160,56,45,163,6,72,80,3,125,128,4,1,128,56,
101,160,6,72,63,6,108,84,80,3,125,128,0,0,158,177,8,1,128,56,
81,160,6,72,63,6,96,84,80,3,125,128,12,1,128,56,2,0,30,176,
61,160,6,72,63,6,123,84,80,3,125,128,16,1,128,56,45,160,6,72,
63,6,124,84,80,3,125,128,20,1,128,56,29,160,6,72,30,130,101,84,
46,64,128,87,120,3,167,124,120,219,232,124,4,0,30,145,80,3,125,128,
0,0,32,57,24,1,128,56,10,0,62,177,245,159,6,72,8,0,126,152,
80,3,125,128,28,1,128,56,229,159,6,72,0,0,31,44,9,0,126,152,
96,0,130,65,80,3,125,128,32,1,128,56,128,0,160,56,133,162,6,72,
80,3,125,128,8,1,128,56,189,159,6,72,2,0,158,161,63,6,106,84,
80,3,125,128,46,64,64,85,12,1,128,56,20,2,140,125,2,0,158,177,
157,159,6,72,4,0,94,129,14,192,96,84,20,2,74,125,4,0,94,145,
80,3,125,128,0,0,160,56,32,1,128,56,57,162,6,72,20,0,161,131,
24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,32,0,4,40,
166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,96,0,128,65,
88,3,63,129,176,6,41,85,88,3,63,145,88,3,95,129,242,6,74,85,
88,3,95,145,88,3,127,129,1,0,5,40,30,45,0,56,31,0,128,56,
100,3,191,152,104,3,159,144,108,3,159,144,110,6,107,85,88,3,127,145,
220,1,128,65,140,0,130,65,3,0,5,40,232,0,128,65,56,1,130,65,
4,0,5,40,124,1,130,65,192,1,0,72,0,0,4,44,8,0,130,64,
1,0,128,56,88,3,63,129,176,6,41,85,88,3,63,145,88,3,95,129,
242,6,74,85,88,3,95,145,88,3,127,129,1,0,5,40,0,0,0,56,
255,255,196,56,104,3,159,144,108,3,159,144,254,6,192,80,100,3,191,152,
0,45,0,96,110,6,107,85,88,3,127,145,108,1,128,65,28,0,130,65,
3,0,5,40,120,0,128,65,200,0,130,65,4,0,5,40,12,1,130,65,
80,1,0,72,80,3,127,128,88,3,31,129,64,0,8,97,88,3,31,145,
88,3,63,129,32,0,41,97,88,3,63,145,88,3,159,129,96,0,160,56,
32,0,0,96,0,0,128,56,92,3,191,152,97,0,64,57,120,3,5,124,
93,3,95,153,128,0,140,97,88,3,159,145,229,160,6,72,0,0,128,57,
4,0,159,145,168,3,31,57,164,3,31,145,200,3,159,145,204,3,159,145,
36,1,0,72,80,3,127,128,88,3,255,128,64,0,231,96,88,3,255,144,
88,3,63,129,0,0,128,56,0,2,5,96,38,0,128,57,54,0,64,57,
93,3,95,153,92,3,159,153,32,0,44,97,88,3,159,145,145,160,6,72,
0,0,128,57,4,0,159,145,168,3,31,57,164,3,31,145,200,3,159,145,
204,3,159,145,208,0,0,72,80,3,127,128,88,3,191,128,0,2,0,96,
0,0,128,56,32,0,172,96,199,0,192,56,204,0,64,57,88,3,159,145,
92,3,223,152,93,3,95,153,120,3,5,124,69,160,6,72,0,0,128,57,
4,0,159,145,168,3,31,57,164,3,31,145,200,3,159,145,204,3,159,145,
132,0,0,72,80,3,127,128,88,3,255,128,120,3,5,124,0,0,128,56,
64,0,236,96,37,0,0,57,53,0,64,57,88,3,159,145,92,3,31,153,
93,3,95,153,253,159,6,72,0,0,128,57,4,0,159,145,168,3,31,57,
164,3,31,145,200,3,159,145,204,3,159,145,60,0,0,72,80,3,127,128,
200,0,32,57,92,3,63,153,202,0,64,57,120,3,5,124,0,0,128,56,
93,3,95,153,193,159,6,72,0,0,128,57,4,0,159,145,168,3,31,57,
164,3,31,145,200,3,159,145,204,3,159,145,120,99,138,125,252,255,191,56,
255,255,0,56,255,255,200,56,32,0,96,57,166,3,105,125,1,0,70,157,
24,0,133,149,8,0,133,145,12,0,133,145,20,0,5,176,4,0,133,177,
1,0,74,57,228,255,0,66,0,0,192,56,28,3,223,144,255,255,0,57,
20,3,31,145,42,3,223,152,249,155,6,72,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,88,3,255,128,41,5,231,84,
8,1,130,65,248,3,223,128,0,0,38,161,123,7,40,85,36,0,130,65,
88,3,95,129,102,5,74,85,88,3,95,145,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,120,0,6,160,122,0,134,161,
166,0,70,161,107,5,73,85,30,128,139,85,120,91,11,124,20,0,130,65,
202,0,102,161,200,0,6,160,30,128,106,85,120,83,11,124,84,3,31,136,
0,0,0,44,0,0,128,57,40,0,130,65,152,0,38,161,0,0,9,44,
28,0,130,65,255,255,9,40,20,0,130,65,255,199,44,85,2,0,128,56,
32,0,130,65,16,0,0,72,0,0,12,44,2,0,128,56,16,0,130,65,
150,0,6,161,255,6,7,85,1,0,135,56,0,0,12,44,0,16,64,61,
255,255,74,57,16,80,107,125,16,89,139,125,208,0,204,124,32,0,130,65,
1,0,160,56,120,251,227,127,69,252,255,75,88,3,31,128,44,6,0,84,
88,3,31,144,40,0,0,72,0,0,6,44,5,0,160,56,8,0,130,65,
4,0,160,56,120,251,227,127,29,252,255,75,88,3,31,128,44,6,0,84,
88,3,31,144,20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,80,3,99,128,
28,1,128,56,57,155,6,72,12,0,1,128,63,6,99,84,166,3,8,124,
8,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,193,255,255,75,72,3,31,128,112,254,11,124,
191,7,108,85,20,2,140,125,59,0,136,85,80,0,8,124,1,0,0,40,
0,0,0,57,24,0,128,65,60,0,130,65,3,0,0,40,92,0,128,65,
128,0,130,65,128,0,0,72,68,3,95,129,58,16,73,85,18,0,105,61,
32,113,107,128,17,1,0,97,20,0,128,56,248,0,5,124,113,157,6,72,
13,154,6,72,124,0,0,72,68,3,95,129,58,16,73,85,18,0,105,61,
32,113,107,128,18,2,0,97,20,0,128,56,248,0,5,124,73,157,6,72,
229,153,6,72,84,0,0,72,68,3,95,129,58,16,73,85,18,0,105,61,
32,113,107,128,20,4,0,97,20,0,128,56,248,0,5,124,33,157,6,72,
189,153,6,72,44,0,0,72,8,8,8,97,68,3,95,129,58,16,73,85,
18,0,105,61,32,113,107,128,16,0,0,97,20,0,128,56,248,0,5,124,
245,156,6,72,145,153,6,72,20,0,1,128,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,88,3,95,129,247,6,74,85,160,0,130,65,
221,254,255,75,80,3,127,128,12,0,128,56,241,153,6,72,103,14,101,96,
80,3,127,128,8,0,32,61,12,0,128,56,244,224,41,57,36,104,37,81,
145,156,6,72,80,3,127,128,44,3,191,128,20,0,128,56,129,156,6,72,
44,3,191,128,80,3,127,128,24,0,128,56,113,156,6,72,56,3,191,128,
80,3,127,128,44,3,127,129,52,3,127,145,32,0,128,56,89,156,6,72,
56,3,191,128,80,3,127,128,36,0,128,56,73,156,6,72,80,3,127,128,
40,0,128,56,1,0,160,56,0,0,128,57,60,3,159,145,49,156,6,72,
88,3,31,128,52,7,0,84,88,3,31,144,193,152,6,72,20,0,1,128,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
80,3,126,128,40,0,128,56,2,0,160,56,229,155,6,72,8,0,225,59,
80,3,126,128,40,0,128,56,25,153,6,72,255,7,96,84,28,0,130,65,
120,251,227,127,61,7,9,72,0,0,3,44,224,255,130,65,232,3,96,56,
137,219,5,72,88,3,30,128,16,0,0,96,88,3,30,144,28,0,1,128,
20,0,225,131,16,0,193,131,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,54,0,4,40,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,12,0,225,147,5,0,224,59,32,0,128,64,37,0,4,40,
68,0,130,65,38,0,4,40,180,0,130,65,53,0,4,40,236,0,130,64,
48,0,0,72,54,0,4,40,160,0,130,65,96,0,4,40,216,0,128,65,
97,0,4,40,204,0,129,64,199,0,4,40,76,0,130,65,204,0,4,40,
68,0,130,65,188,0,0,72,120,243,195,127,21,255,255,75,120,243,195,127,
4,0,160,56,1,0,128,56,253,248,255,75,88,3,30,128,0,1,0,96,
88,3,30,144,96,3,30,128,120,243,195,127,2,0,0,96,96,3,30,144,
21,254,255,75,184,0,0,72,120,243,195,127,217,254,255,75,120,243,195,127,
3,0,160,56,1,0,128,56,193,248,255,75,88,3,30,128,0,1,0,96,
88,3,30,144,96,3,30,128,120,243,195,127,2,0,0,96,96,3,30,144,
217,253,255,75,124,0,0,72,120,243,195,127,157,254,255,75,120,243,195,127,
2,0,160,56,1,0,128,56,133,248,255,75,88,3,30,128,0,1,0,96,
88,3,30,144,96,3,30,128,120,243,195,127,2,0,0,96,96,3,30,144,
157,253,255,75,64,0,0,72,1,0,224,59,120,243,195,127,93,254,255,75,
120,243,195,127,120,251,229,127,1,0,128,56,69,248,255,75,88,3,30,128,
0,1,0,96,88,3,30,144,96,3,30,128,120,243,195,127,2,0,0,96,
96,3,30,144,93,253,255,75,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,12,0,97,147,
16,0,129,147,166,2,8,124,36,0,1,144,20,0,161,147,120,27,125,124,
24,0,193,147,121,35,158,124,28,0,225,147,120,43,191,124,32,0,130,64,
28,0,225,131,24,0,193,131,20,0,161,131,166,3,8,124,0,0,96,56,
32,0,33,56,32,0,128,78,4,0,62,129,18,0,137,161,172,0,29,168,
2,2,0,40,0,0,96,59,120,219,124,127,24,0,130,65,4,2,0,40,
112,0,130,65,10,2,0,40,28,0,130,65,244,0,0,72,189,7,135,85,
228,0,130,65,57,7,136,85,220,0,130,65,224,0,0,72,189,7,138,85,
216,0,130,65,10,0,137,161,1,0,12,40,204,0,129,64,8,0,125,56,
120,75,59,125,120,219,100,127,40,0,160,56,213,98,6,72,0,0,31,44,
255,15,0,60,255,255,0,96,8,0,130,65,255,255,0,56,0,0,27,44,
12,0,27,144,192,0,130,65,156,0,0,72,189,7,128,85,140,0,130,65,
57,7,128,85,48,0,130,65,8,0,125,56,120,75,59,125,120,219,100,127,
40,0,160,56,141,98,6,72,0,0,27,44,10,0,91,161,128,0,74,57,
10,0,91,177,132,0,130,65,96,0,0,72,247,6,139,85,80,0,130,65,
4,0,233,128,24,0,231,131,0,2,31,40,56,0,129,64,62,191,236,87,
1,0,12,44,44,0,130,65,92,0,125,56,120,59,252,124,120,227,132,127,
40,0,160,56,61,98,6,72,0,0,27,44,0,254,63,57,24,0,60,145,
56,0,130,65,20,0,0,72,0,0,96,57,172,0,125,177,0,0,27,44,
36,0,130,65,48,0,125,56,120,219,100,127,40,0,160,56,9,98,6,72,
4,0,125,147,0,0,221,147,0,0,0,56,172,0,29,176,0,0,28,44,
12,0,130,64,172,0,125,168,36,0,0,72,132,0,125,56,120,227,132,127,
40,0,160,56,217,97,6,72,88,0,157,147,0,0,221,147,0,0,96,56,
172,0,125,176,20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,
16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,
4,0,4,128,0,32,128,61,0,0,140,57,164,0,12,144,168,0,12,128,
52,0,0,124,62,222,3,84,32,0,128,78,224,255,33,148,12,0,97,147,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,120,27,127,124,166,0,96,127,94,4,105,87,36,1,32,125,
1,2,4,44,44,0,130,64,76,3,127,128,104,29,128,56,1,0,160,56,
205,151,6,72,0,128,104,115,166,0,0,124,94,4,0,84,120,67,0,124,
36,1,0,124,32,1,0,72,24,2,4,44,192,0,130,64,0,0,128,59,
1,0,96,56,65,152,6,72,32,0,224,56,252,255,31,57,0,32,32,61,
0,0,41,57,24,0,168,135,0,0,29,44,84,0,130,65,8,0,104,129,
0,0,11,44,72,0,130,65,120,251,227,127,120,91,100,125,61,255,255,75,
0,0,3,44,52,0,130,64,4,0,75,129,1,0,202,59,164,0,201,147,
172,0,233,131,1,0,235,87,152,0,201,147,0,128,108,109,127,0,224,87,
120,3,159,125,160,0,233,147,125,152,6,72,24,0,0,72,255,255,231,52,
160,255,130,64,109,152,6,72,0,0,28,44,120,0,130,65,120,235,164,127,
120,243,197,127,120,251,230,127,11,0,96,60,164,226,99,56,137,158,5,72,
0,128,104,115,166,0,0,124,94,4,0,84,120,67,0,124,36,1,0,124,
92,0,0,72,88,3,31,128,0,0,4,44,44,0,130,65,0,4,255,128,
0,128,104,115,0,4,12,96,172,0,135,176,88,3,159,145,166,0,0,124,
94,4,0,84,120,67,0,124,36,1,0,124,40,0,0,72,0,4,127,128,
168,5,0,84,88,3,31,144,97,241,255,75,0,128,104,115,166,0,0,124,
94,4,0,84,120,67,0,124,36,1,0,124,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,
32,0,33,56,32,0,128,78,58,16,137,84,80,72,4,125,56,24,8,85,
20,66,227,124,0,0,64,57,20,0,71,149,8,0,135,129,0,0,12,44,
4,0,71,177,56,0,130,65,0,0,0,57,8,0,7,145,255,255,192,56,
248,133,45,129,248,133,141,145,240,133,77,129,12,0,12,129,2,0,204,176,
12,0,44,145,121,67,12,125,255,255,74,57,240,133,77,145,220,255,130,64,
12,0,103,129,0,0,11,44,36,0,130,65,4,134,13,128,4,134,109,145,
252,133,205,128,0,0,128,57,255,255,198,56,12,0,135,145,4,0,11,144,
252,133,205,144,4,0,195,128,0,0,6,44,32,0,129,76,164,3,227,128,
255,255,231,56,164,3,227,144,0,0,135,152,204,3,131,129,200,3,99,129,
1,0,64,57,255,255,198,52,4,0,195,144,48,32,73,125,120,72,107,125,
200,3,99,145,120,72,140,125,204,3,131,145,32,0,130,76,108,3,3,128,
104,3,3,144,32,0,128,78,232,255,33,148,8,0,129,147,16,0,193,147,
20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,120,27,125,124,
4,0,125,129,0,0,11,44,120,35,158,124,188,0,129,65,88,3,29,136,
63,7,0,84,176,0,130,64,0,0,96,56,201,150,6,72,0,4,125,128,
88,3,93,129,254,215,69,85,120,243,196,127,41,251,255,75,88,3,29,128,
121,27,124,124,168,5,0,84,88,3,29,144,128,0,130,65,4,0,157,129,
104,3,29,128,64,0,12,124,255,255,224,59,56,0,128,64,4,0,125,129,
1,0,107,57,4,0,125,145,164,3,125,129,1,0,11,56,164,3,29,144,
0,0,235,139,200,3,157,129,1,0,64,57,116,7,255,127,48,248,64,125,
120,3,140,125,200,3,157,145,0,0,31,44,48,0,128,65,120,235,163,127,
120,251,228,127,97,254,255,75,120,243,196,127,1,0,160,56,49,240,255,75,
58,16,224,87,80,0,95,125,56,24,74,85,20,82,157,125,24,0,140,179,
16,0,193,131,20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,
166,3,8,124,24,0,33,56,32,0,128,78,240,133,109,129,244,133,13,129,
0,64,11,124,0,0,128,57,1,0,107,57,40,0,128,64,240,133,109,145,
248,133,141,129,248,133,45,129,12,0,73,129,0,0,0,56,0,0,108,176,
2,0,140,176,248,133,77,145,12,0,12,144,0,0,5,44,8,0,130,65,
12,0,133,145,120,99,131,125,32,0,128,78,12,128,13,128,72,3,99,129,
0,0,5,44,1,0,128,57,48,88,139,125,120,91,0,124,12,128,13,144,
48,0,130,65,255,255,64,57,248,133,13,129,12,0,37,129,2,0,69,177,
248,133,173,144,12,0,5,145,121,75,37,125,240,133,45,129,255,255,41,57,
240,133,45,145,220,255,130,64,0,0,6,44,28,0,130,65,4,134,13,128,
4,134,205,144,252,133,237,128,4,0,6,144,255,255,231,56,252,133,237,144,
32,0,4,40,0,0,0,57,96,3,3,145,32,0,128,76,80,253,255,75,
252,133,141,129,0,134,13,128,0,0,12,124,0,0,96,56,1,0,140,57,
32,0,128,76,252,133,141,145,4,134,109,128,4,134,141,129,4,0,12,128,
4,134,13,144,32,0,128,78,240,255,33,148,8,0,193,147,12,0,225,147,
166,2,8,124,20,0,1,144,166,0,192,127,94,4,203,87,36,1,96,125,
120,27,127,124,77,235,255,75,2,0,3,44,108,0,130,64,120,251,227,127,
81,247,255,75,80,3,127,128,24,1,128,56,4,0,160,56,73,147,6,72,
80,3,127,128,32,1,128,56,6,0,160,56,57,147,6,72,80,3,127,128,
32,1,128,56,113,144,6,72,10,0,96,56,249,210,5,72,80,3,127,128,
24,1,128,56,0,0,160,56,21,147,6,72,80,3,127,128,32,1,128,56,
0,0,160,56,5,147,6,72,80,3,127,128,32,1,128,56,61,144,6,72,
0,128,204,115,166,0,0,124,94,4,0,84,120,99,0,124,36,1,0,124,
136,19,96,56,177,210,5,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,0,0,5,44,0,0,96,56,
32,0,129,76,166,3,169,124,24,0,4,128,4,0,132,128,20,2,99,124,
244,255,0,66,32,0,128,78,232,255,33,148,20,0,225,147,120,35,159,124,
12,0,161,147,16,0,193,147,166,2,8,124,28,0,1,144,0,0,96,57,
42,3,99,153,17,0,159,137,24,3,131,145,120,27,126,124,101,244,255,75,
51,6,96,84,64,0,0,44,20,0,130,64,120,243,195,127,61,234,255,75,
2,0,3,44,52,0,130,65,120,243,195,127,212,3,158,56,0,0,160,56,
177,238,255,75,20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,
0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,18,0,191,163,
33,4,165,87,0,0,0,56,41,3,30,152,200,0,130,65,1,0,0,56,
41,3,30,152,9,0,191,136,80,3,126,128,4,1,128,56,245,145,6,72,
11,0,191,136,80,3,126,128,8,1,128,56,229,145,6,72,15,0,191,136,
80,3,126,128,12,1,128,56,213,145,6,72,80,3,126,128,16,1,128,56,
0,0,160,56,197,145,6,72,80,3,126,128,20,1,128,56,0,0,160,56,
181,145,6,72,16,0,191,136,80,3,126,128,24,1,128,56,165,145,6,72,
80,3,126,128,8,0,191,136,4,1,128,56,149,145,6,72,80,3,126,128,
10,0,191,136,8,1,128,56,133,145,6,72,80,3,126,128,12,0,191,136,
12,1,128,56,117,145,6,72,80,3,126,128,13,0,191,136,16,1,128,56,
101,145,6,72,14,0,191,136,80,3,126,128,20,1,128,56,85,145,6,72,
96,0,29,44,144,0,130,65,124,0,0,72,16,0,31,137,80,3,126,128,
15,0,95,137,24,1,128,56,55,6,0,85,63,7,73,85,120,75,5,124,
41,145,6,72,8,0,191,136,80,3,126,128,4,1,128,56,25,145,6,72,
10,0,191,136,80,3,126,128,8,1,128,56,9,145,6,72,80,3,126,128,
12,0,191,136,12,1,128,56,249,144,6,72,80,3,126,128,13,0,191,136,
16,1,128,56,233,144,6,72,14,0,191,136,80,3,126,128,20,1,128,56,
217,144,6,72,96,0,29,44,20,0,130,65,17,0,191,136,80,3,126,128,
28,1,128,56,193,144,6,72,93,141,6,72,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,1,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,221,3,35,137,115,6,42,85,9,2,0,56,232,3,131,152,
12,0,130,64,8,2,96,56,32,0,128,78,255,7,43,85,88,0,130,65,
212,3,131,161,16,0,12,40,24,0,128,64,1,0,12,40,64,0,130,65,
4,0,12,40,48,0,130,65,56,0,0,72,16,0,12,40,28,0,130,65,
64,0,12,40,36,0,130,65,132,0,12,40,32,0,130,64,0,2,0,56,
24,0,0,72,0,0,4,44,12,0,130,64,10,2,0,56,8,0,0,72,
2,2,0,56,120,3,3,124,32,0,128,78,0,0,128,57,0,2,224,56,
166,3,233,124,255,255,68,57,1,0,42,141,20,74,140,125,62,6,140,85,
244,255,0,66,0,0,12,44,80,0,130,64,3,0,68,137,212,3,67,177,
12,0,4,160,214,3,3,176,4,0,36,137,5,0,228,136,8,0,4,137,
6,0,100,137,46,64,236,84,14,192,0,85,20,98,9,125,30,128,106,85,
20,82,136,125,20,2,44,125,216,3,35,145,7,0,100,137,220,3,99,153,
2,0,4,136,221,3,3,152,232,3,131,136,8,255,255,75,200,255,33,148,
166,2,8,124,60,0,1,144,52,0,225,147,120,35,159,124,48,0,193,147,
120,27,126,124,121,243,255,75,120,243,195,127,157,241,255,75,20,3,254,147,
0,0,224,59,28,3,254,147,8,0,97,56,120,251,228,127,40,0,160,56,
57,214,255,75,231,0,128,57,25,0,129,153,41,0,0,56,26,0,1,176,
120,243,195,127,8,0,129,56,165,252,255,75,0,0,3,44,8,0,130,64,
25,16,224,59,60,0,1,128,120,251,227,127,52,0,225,131,48,0,193,131,
166,3,8,124,56,0,33,56,32,0,128,78,224,255,33,148,12,0,97,147,
16,0,129,147,20,0,161,147,24,0,193,147,120,27,126,124,166,2,8,124,
36,0,1,144,28,0,225,147,120,35,159,124,58,16,224,87,80,0,127,125,
56,24,107,85,20,90,190,127,20,0,125,135,0,0,27,44,32,1,130,65,
96,3,30,129,255,7,8,85,176,0,130,65,120,243,195,127,120,251,228,127,
33,255,255,75,96,3,30,128,121,27,124,124,60,0,0,84,96,3,30,144,
96,0,130,65,120,243,195,127,120,251,228,127,45,248,255,75,120,219,100,127,
1,0,160,56,253,233,255,75,72,3,126,128,0,0,94,129,120,219,100,127,
120,227,133,127,212,3,222,56,255,255,74,57,0,0,94,145,153,107,4,72,
20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,
12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,1,0,0,56,
22,0,29,152,20,0,29,176,20,0,161,131,24,0,193,131,28,0,225,131,
36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,
32,0,128,78,96,3,30,128,189,7,0,84,92,0,130,65,96,3,62,129,
250,7,41,85,120,243,195,127,120,251,228,127,96,3,62,145,137,247,255,75,
4,0,30,128,0,0,0,44,24,0,130,64,225,241,255,75,120,243,195,127,
212,3,158,56,0,0,160,56,73,234,255,75,72,3,126,128,0,0,158,129,
120,219,100,127,212,3,222,56,0,0,160,56,255,255,140,57,0,0,158,145,
225,106,4,72,20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,
16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,
216,255,33,148,32,0,193,147,120,35,158,124,32,0,30,40,16,0,65,147,
166,2,8,124,44,0,1,144,28,0,161,147,120,27,125,124,36,0,225,147,
120,43,191,124,20,0,97,147,120,51,219,124,12,0,33,147,120,59,249,124,
24,0,129,147,11,0,128,63,20,0,128,65,212,226,124,56,120,243,197,127,
4,13,128,56,41,217,255,75,0,0,27,44,58,16,197,87,80,40,30,124,
56,24,0,84,36,0,130,64,20,2,125,127,40,0,155,169,255,255,140,57,
53,7,140,125,40,0,155,177,20,0,123,59,72,1,130,64,36,0,0,72,
20,2,29,125,40,0,136,169,24,0,104,179,255,255,140,57,53,7,140,125,
40,0,136,177,20,0,104,59,36,1,130,64,0,0,91,131,0,0,26,44,
232,0,130,65,22,0,27,136,116,7,0,124,3,0,0,44,4,0,187,168,
36,0,130,64,4,128,45,129,255,255,41,53,4,128,45,145,20,0,130,64,
1,0,0,61,181,177,8,57,0,32,64,61,200,0,10,145,96,3,29,128,
0,0,0,44,12,0,130,65,0,0,5,44,84,0,130,65,0,0,25,44,
0,0,224,59,12,0,130,64,0,0,5,44,8,0,130,65,212,3,253,59,
120,235,163,127,120,243,196,127,1,246,255,75,72,3,125,128,0,0,125,129,
120,211,68,127,120,251,230,127,255,255,107,57,0,0,125,145,125,105,4,72,
8,0,253,128,0,0,7,40,84,0,129,64,56,0,0,72,4,0,29,128,
1,0,0,44,20,0,130,65,212,226,124,56,54,13,128,56,0,0,160,56,
21,216,255,75,120,235,163,127,120,243,196,127,9,253,255,75,8,0,253,128,
0,0,7,40,28,0,129,64,72,3,29,128,16,128,141,129,1,0,96,57,
48,0,96,125,120,3,140,125,16,128,141,145,32,0,193,131,20,0,97,131,
24,0,129,131,36,0,225,131,28,0,161,131,16,0,65,131,44,0,1,128,
12,0,33,131,1,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,
0,0,12,44,20,0,129,65,212,226,124,56,74,13,128,56,0,0,160,56,
157,215,255,75,22,0,251,155,32,0,193,131,20,0,97,131,24,0,129,131,
36,0,225,131,28,0,161,131,16,0,65,131,44,0,1,128,12,0,33,131,
0,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,41,3,190,136,120,35,159,124,212,3,158,56,193,231,255,75,
20,3,190,131,32,0,29,40,0,0,128,56,24,0,128,64,58,16,171,87,
80,88,93,125,56,24,74,85,20,82,158,125,20,0,140,128,0,0,4,44,
255,255,0,56,20,3,30,144,192,0,130,65,0,0,31,44,76,0,130,64,
24,3,62,129,47,0,9,44,76,0,130,64,100,3,94,137,116,7,74,125,
1,0,10,44,60,0,130,64,88,3,30,136,63,7,0,84,48,0,130,65,
252,3,158,128,120,243,195,127,201,250,255,75,88,3,158,129,239,5,140,85,
120,27,127,124,92,0,130,65,28,0,0,72,120,243,195,127,1,0,160,56,
45,230,255,75,88,3,158,129,239,5,140,85,64,0,130,65,4,0,30,128,
1,0,0,44,52,0,130,64,24,3,30,128,236,0,0,44,40,0,130,64,
0,0,31,44,32,0,130,64,248,3,126,128,32,3,158,128,0,2,160,56,
245,83,6,72,88,3,30,128,0,8,0,96,88,3,30,144,120,243,195,127,
120,235,164,127,120,251,230,127,1,0,160,56,120,43,167,124,209,252,255,75,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
28,3,30,128,0,2,0,40,0,0,224,56,0,2,224,59,42,3,254,152,
8,0,128,64,120,3,31,124,24,3,30,129,50,0,8,44,180,0,130,64,
0,1,224,59,36,3,94,129,0,0,170,160,80,3,126,128,0,1,128,56,
2,0,10,56,36,3,30,144,221,137,6,72,255,255,255,55,224,255,130,64,
0,2,160,59,0,0,224,59,120,243,195,127,189,235,255,75,57,7,103,84,
40,0,130,65,36,3,126,129,0,0,171,160,80,3,126,128,0,1,128,56,
2,0,11,56,36,3,30,144,161,137,6,72,0,0,224,59,1,0,189,59,
10,0,96,56,101,201,5,72,1,0,255,59,232,3,31,44,188,255,128,65,
120,235,164,127,11,0,96,60,224,226,99,56,245,144,5,72,0,0,96,56,
28,3,126,144,16,0,193,131,20,0,225,131,28,0,1,128,12,0,161,131,
8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,0,0,128,59,
112,14,233,127,148,1,169,127,0,232,28,124,44,0,128,64,36,3,158,129,
0,0,172,160,80,3,126,128,0,1,128,56,2,0,108,57,36,3,126,145,
29,137,6,72,1,0,156,59,0,232,28,124,220,255,128,65,28,3,158,129,
80,96,159,125,28,3,158,145,12,0,161,131,16,0,193,131,20,0,225,131,
255,255,12,48,16,97,96,124,28,0,1,128,8,0,129,131,62,6,99,84,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,
20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,120,27,125,124,
42,3,61,137,0,0,9,44,120,35,158,124,244,0,130,65,20,3,29,128,
32,0,0,40,0,0,64,57,42,3,93,153,224,0,128,64,40,3,157,137,
0,0,12,44,212,0,130,64,28,3,29,128,0,0,0,44,200,0,130,65,
232,3,224,59,120,235,163,127,109,234,255,75,49,6,96,84,32,0,130,65,
0,0,30,44,152,0,130,65,50,0,96,56,49,200,5,72,255,255,255,55,
220,255,130,64,132,0,0,72,255,7,96,84,72,0,130,65,120,235,163,127,
212,3,157,56,0,0,160,56,169,228,255,75,120,235,163,127,0,0,128,56,
149,247,255,75,120,27,100,124,120,235,163,127,169,252,255,75,20,0,225,131,
28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,
32,0,128,78,57,7,102,84,40,0,130,65,120,235,163,127,181,253,255,75,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,255,255,255,55,88,255,130,64,88,3,253,128,
1,0,0,57,0,2,231,96,88,3,253,144,42,3,29,153,20,0,225,131,
28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,
32,0,128,78,224,255,33,148,8,0,65,147,28,0,225,147,166,2,8,124,
36,0,1,144,16,0,129,147,120,35,156,124,20,0,161,147,120,43,189,124,
24,0,193,147,120,51,222,124,12,0,97,147,120,27,123,124,97,235,255,75,
120,219,99,127,133,233,255,75,4,0,220,128,18,0,134,161,160,0,12,44,
25,16,224,59,12,0,130,65,32,0,12,44,96,0,130,64,32,0,12,44,
20,3,219,147,58,16,198,87,0,0,224,59,41,3,251,155,80,48,30,124,
56,24,0,84,20,2,123,125,20,0,139,151,8,0,235,147,12,0,235,147,
28,3,251,147,24,3,251,147,1,0,0,56,22,0,11,152,20,0,11,176,
248,0,130,64,120,219,99,127,109,243,255,75,120,219,99,127,0,0,128,56,
117,251,255,75,236,0,0,72,4,0,70,131,20,3,219,147,120,219,99,127,
120,211,68,127,120,235,165,127,17,244,255,75,28,3,123,144,254,239,139,85,
40,3,123,153,16,0,186,128,120,51,196,124,120,219,99,127,0,0,64,57,
32,3,187,144,36,3,187,144,58,16,192,87,80,0,158,125,56,24,140,85,
20,98,123,125,20,0,139,151,8,0,75,145,12,0,75,145,1,0,0,56,
22,0,11,152,20,0,11,176,229,243,255,75,0,0,3,44,112,0,130,65,
120,219,99,127,120,211,68,127,120,235,165,127,169,243,255,75,0,0,3,44,
28,3,123,144,96,0,130,65,40,3,251,136,0,0,7,44,84,0,130,64,
20,0,186,128,1,0,128,56,32,3,187,144,36,3,187,144,120,219,99,127,
42,3,155,152,97,253,255,75,24,0,193,131,16,0,129,131,20,0,161,131,
28,0,225,131,36,0,1,128,12,0,97,131,8,0,65,131,166,3,8,124,
32,0,33,56,32,0,128,78,120,219,99,127,120,251,228,127,137,250,255,75,
24,0,193,131,16,0,129,131,20,0,161,131,28,0,225,131,36,0,1,128,
12,0,97,131,8,0,65,131,166,3,8,124,32,0,33,56,32,0,128,78,
176,255,33,148,28,0,97,146,32,0,129,146,36,0,161,146,40,0,193,146,
44,0,225,146,48,0,1,147,52,0,33,147,64,0,129,147,68,0,161,147,
72,0,193,147,76,0,225,147,166,2,8,124,84,0,1,144,60,0,97,147,
56,0,65,147,120,35,154,124,120,27,123,124,88,3,155,128,4,0,58,131,
18,0,185,163,181,6,166,87,254,199,191,87,254,231,136,84,254,183,128,84,
120,67,199,124,120,3,224,124,255,255,160,48,16,1,69,125,121,251,73,125,
28,0,130,64,4,0,123,129,104,3,27,128,64,0,11,124,255,255,192,59,
120,1,128,65,168,1,0,72,4,0,123,129,0,0,11,44,56,0,129,64,
0,0,31,44,0,0,128,57,16,0,130,65,255,207,128,84,8,0,130,64,
1,0,128,57,121,99,71,125,24,0,130,65,189,7,169,87,1,0,96,56,
8,0,130,65,2,0,96,56,44,4,0,72,0,0,8,44,136,0,130,65,
120,219,99,127,217,220,255,75,2,0,3,44,92,0,130,65,189,7,171,87,
84,0,130,65,120,219,99,127,120,211,68,127,1,0,160,56,65,224,255,75,
120,219,99,127,212,3,155,56,0,0,160,56,53,225,255,75,0,0,26,44,
16,0,130,65,0,0,155,129,255,255,140,57,0,0,155,145,72,3,123,128,
120,211,68,127,212,3,219,56,25,16,160,56,197,97,4,72,0,0,96,56,
188,3,0,72,88,3,187,128,239,5,165,84,12,0,130,65,120,219,99,127,
65,229,255,75,120,219,99,127,161,231,255,75,173,5,167,87,28,0,130,65,
17,0,153,136,120,219,99,127,217,232,255,75,0,0,31,44,44,0,130,65,
64,0,0,72,88,3,27,129,107,5,8,85,20,0,130,65,120,219,99,127,
120,211,68,127,173,238,255,75,18,0,185,163,0,0,31,44,28,0,130,64,
4,0,123,129,104,3,27,128,64,0,11,124,255,255,192,59,80,0,128,65,
128,0,0,72,88,3,27,128,49,6,0,84,28,0,130,65,4,0,123,129,
104,3,27,128,64,0,11,124,255,255,192,59,44,0,128,65,92,0,0,72,
96,3,91,129,1,0,74,97,96,3,91,145,4,0,123,129,1,0,11,40,
255,255,192,59,1,0,0,56,104,3,27,144,56,0,128,64,4,0,155,129,
1,0,140,57,4,0,155,145,164,3,219,128,1,0,6,56,164,3,27,144,
0,0,198,139,200,3,59,129,1,0,0,57,116,7,222,127,48,240,0,125,
120,3,41,125,200,3,59,145,0,0,30,44,2,0,96,56,188,2,128,65,
20,0,122,169,254,255,171,52,0,0,224,59,12,0,161,144,48,0,129,64,
72,3,123,128,120,243,196,127,0,0,160,56,229,238,255,75,121,27,127,124,
24,0,130,64,120,219,99,127,0,0,192,56,33,239,255,75,2,0,96,56,
124,2,0,72,189,7,160,87,40,2,130,65,16,32,128,63,0,0,156,59,
0,32,160,63,0,0,189,59,0,0,0,59,20,0,1,147,120,219,99,127,
120,203,36,127,120,251,229,127,120,243,198,127,37,214,255,75,4,0,25,128,
4,0,159,128,8,0,97,152,16,0,161,56,12,0,193,56,120,219,99,127,
16,0,1,144,8,0,1,57,20,0,225,56,21,216,255,75,12,0,1,129,
0,0,8,44,120,27,107,124,16,1,129,64,41,239,255,75,121,27,120,124,
32,0,130,64,120,219,99,127,120,243,196,127,120,251,229,127,0,0,192,56,
141,238,255,75,2,0,96,56,232,1,0,72,0,0,56,131,52,3,27,128,
190,244,5,84,120,251,247,127,72,2,188,144,76,2,61,147,4,0,23,128,
16,0,193,58,12,0,161,58,8,0,97,58,190,244,40,87,20,0,129,58,
72,2,28,145,72,3,123,128,120,243,196,127,120,187,229,126,62,4,107,85,
32,120,0,84,0,128,10,100,76,2,93,145,76,2,125,145,221,237,255,75,
121,27,119,124,120,219,99,127,24,0,130,64,120,251,229,127,120,195,6,127,
21,238,255,75,2,0,96,56,112,1,0,72,4,0,151,128,120,179,197,126,
120,171,166,126,120,163,135,126,120,155,104,126,77,215,255,75,0,0,213,128,
0,0,6,44,4,0,23,128,16,0,57,59,120,27,107,124,190,244,38,87,
12,0,130,65,72,2,220,144,132,255,255,75,8,0,129,137,0,0,12,44,
32,120,7,84,1,0,0,56,62,4,107,85,0,128,106,101,72,2,220,144,
0,128,232,100,76,2,29,145,76,2,93,145,60,0,130,65,52,0,0,72,
8,0,95,161,4,0,138,57,112,22,134,125,8,0,129,137,0,0,12,44,
62,4,107,85,1,0,0,56,0,128,106,101,148,1,166,124,72,2,188,144,
76,2,93,145,8,0,130,65,4,0,0,56,116,7,0,124,4,0,0,44,
1,0,224,56,58,16,197,87,80,40,158,125,56,24,140,85,20,98,155,125,
20,0,76,151,8,0,236,147,12,0,12,147,22,0,12,152,8,0,130,64,
2,0,224,56,20,0,236,176,52,3,187,128,48,3,219,128,64,48,5,124,
32,0,130,64,80,3,123,128,44,3,187,128,20,0,128,56,52,3,187,144,
77,129,6,72,0,0,96,56,108,0,0,72,80,3,123,128,32,0,165,56,
20,0,128,56,52,3,187,144,49,129,6,72,0,0,96,56,80,0,0,72,
0,0,31,44,48,0,130,65,255,255,64,57,248,133,13,129,248,133,237,147,
240,133,45,129,12,0,31,128,2,0,95,177,12,0,31,145,121,3,31,124,
255,255,41,57,240,133,45,145,220,255,130,64,12,0,161,128,120,211,68,127,
120,243,198,127,120,219,99,127,69,249,255,75,0,0,96,56,44,0,225,130,
64,0,129,131,68,0,161,131,48,0,1,131,40,0,193,130,60,0,97,131,
72,0,193,131,52,0,33,131,36,0,161,130,56,0,65,131,76,0,225,131,
84,0,1,128,32,0,129,130,28,0,97,130,166,3,8,124,80,0,33,56,
32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,16,0,193,147,
166,2,8,124,28,0,1,144,20,0,225,147,120,27,127,124,12,0,159,128,
12,0,255,128,8,0,135,131,4,0,188,131,8,0,223,131,0,0,30,44,
204,0,130,65,133,250,255,75,0,0,3,44,192,0,130,64,8,0,223,131,
255,255,222,55,8,0,223,147,176,0,129,64,16,0,255,128,64,56,28,124,
68,0,130,64,112,3,127,56,217,122,6,72,72,3,255,128,12,0,127,144,
8,0,3,129,16,0,31,145,12,128,13,128,1,0,64,57,48,56,73,125,
120,72,0,124,12,128,13,144,104,3,31,128,4,0,159,129,64,0,12,124,
156,0,128,64,48,0,0,72,72,3,255,128,12,0,191,147,12,128,13,128,
1,0,64,57,48,56,73,125,120,72,0,124,12,128,13,144,104,3,31,128,
4,0,159,129,64,0,12,124,108,0,128,64,16,128,13,128,1,0,128,57,
48,56,139,125,120,91,0,124,16,128,13,144,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,16,128,77,129,72,3,255,128,0,0,30,44,1,0,32,57,
48,56,40,125,120,64,74,125,16,128,77,145,24,0,130,64,12,128,13,128,
1,0,128,57,48,56,139,125,120,88,0,124,12,128,13,144,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
28,3,30,128,0,2,0,40,0,2,224,59,8,0,128,64,120,3,31,124,
24,3,30,129,34,0,8,44,212,0,130,64,0,1,224,59,80,3,126,128,
0,1,128,56,53,124,6,72,32,3,254,128,0,0,7,44,62,4,99,84,
20,0,130,65,36,3,94,129,2,0,10,56,0,0,106,176,36,3,30,144,
255,255,255,55,208,255,130,64,0,2,160,59,0,0,224,59,120,243,195,127,
177,224,255,75,57,7,105,84,56,0,130,65,80,3,126,128,0,1,128,56,
233,123,6,72,32,3,94,129,0,0,10,44,62,4,99,84,20,0,130,65,
36,3,126,129,2,0,11,56,0,0,107,176,36,3,30,144,0,0,224,59,
1,0,189,59,10,0,96,56,73,190,5,72,1,0,255,59,232,3,31,44,
172,255,128,65,120,235,164,127,11,0,96,60,12,228,99,56,217,133,5,72,
0,0,96,56,28,3,126,144,16,0,193,131,20,0,225,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
0,0,128,59,112,14,236,127,148,1,172,127,0,232,28,124,60,0,128,64,
80,3,126,128,0,1,128,56,85,123,6,72,32,3,190,128,0,0,5,44,
62,4,99,84,20,0,130,65,36,3,158,129,2,0,204,56,0,0,108,176,
36,3,222,144,1,0,156,59,0,232,28,124,204,255,128,65,28,3,254,128,
80,56,255,124,28,3,254,144,12,0,161,131,16,0,193,131,20,0,225,131,
255,255,7,48,16,57,96,124,28,0,1,128,8,0,129,131,62,6,99,84,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,20,3,190,128,32,0,5,40,0,0,224,59,120,251,253,127,
24,0,128,64,58,16,171,84,80,88,69,125,56,24,74,85,20,82,158,125,
20,0,236,131,120,243,195,127,129,223,255,75,0,0,31,44,0,1,130,65,
32,78,128,59,120,243,195,127,65,223,255,75,28,3,30,128,0,0,0,44,
120,27,127,124,28,0,130,65,57,7,224,87,20,0,130,64,10,0,96,56,
253,188,5,72,255,255,156,55,212,255,130,64,255,7,224,87,92,0,130,64,
28,3,222,128,0,0,6,44,20,0,130,64,51,6,224,87,64,0,0,44,
120,0,130,64,148,0,0,72,104,0,224,115,72,0,0,44,52,0,130,64,
40,3,30,136,0,0,0,44,120,243,195,127,20,0,130,65,161,253,255,75,
0,0,3,44,108,0,130,65,72,0,0,72,141,242,255,75,0,0,3,44,
92,0,130,65,56,0,0,72,120,243,195,127,212,3,158,56,0,0,160,56,
33,217,255,75,120,243,195,127,0,0,128,56,13,236,255,75,120,27,100,124,
120,243,195,127,33,241,255,75,120,243,195,127,181,222,255,75,56,0,0,72,
16,0,193,131,20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,
166,3,8,124,24,0,33,56,32,0,128,78,120,243,195,127,120,235,164,127,
233,240,255,75,120,243,195,127,125,222,255,75,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,208,255,33,148,16,0,1,147,24,0,65,147,28,0,97,147,
32,0,129,147,36,0,161,147,40,0,193,147,44,0,225,147,166,2,8,124,
52,0,1,144,20,0,33,147,120,27,121,124,20,3,249,128,32,0,7,40,
16,0,128,65,4,0,25,129,0,0,8,44,60,0,130,64,120,203,35,127,
65,254,255,75,28,0,97,131,40,0,193,131,36,0,161,131,24,0,65,131,
32,0,129,131,44,0,225,131,52,0,1,128,20,0,33,131,16,0,1,131,
166,3,8,124,48,0,33,56,32,0,128,78,80,3,121,128,32,0,128,56,
241,120,6,72,60,3,89,131,120,27,120,124,64,192,26,124,3,0,224,59,
8,0,97,59,1,0,160,63,177,177,189,59,12,0,193,59,0,32,128,63,
0,0,156,59,172,0,130,65,56,3,25,129,20,210,8,124,190,244,0,84,
80,2,28,144,84,2,28,128,0,0,27,144,254,255,190,160,255,199,166,84,
84,2,28,128,0,0,30,144,112,0,130,64,0,0,155,160,0,0,192,56,
2,0,160,56,120,203,35,127,120,51,199,124,173,237,255,75,0,0,3,44,
80,0,130,64,0,0,96,56,149,133,6,72,0,0,59,161,58,16,32,85,
80,0,41,125,56,24,41,85,20,74,153,125,20,0,108,133,0,0,11,44,
40,0,130,65,22,0,12,136,116,7,0,124,2,0,0,44,24,0,130,64,
4,128,173,128,22,0,236,155,1,0,165,56,4,128,173,144,200,0,188,147,
8,0,90,59,63,6,90,87,64,192,26,124,92,255,130,64,56,3,217,128,
80,3,121,128,60,3,89,147,36,0,128,56,20,210,166,124,193,122,6,72,
28,0,97,131,40,0,193,131,36,0,161,131,24,0,65,131,32,0,129,131,
44,0,225,131,52,0,1,128,20,0,33,131,16,0,1,131,166,3,8,124,
48,0,33,56,32,0,128,78,224,255,33,148,8,0,65,147,12,0,97,147,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,120,27,127,124,88,3,159,129,0,1,140,97,88,3,159,145,
0,0,31,128,0,0,0,44,84,0,130,64,69,222,255,75,120,251,227,127,
0,0,128,56,1,0,160,56,169,213,255,75,72,3,127,128,212,3,223,56,
0,0,128,56,25,16,160,56,81,87,4,72,24,0,193,131,16,0,129,131,
20,0,161,131,28,0,225,131,36,0,1,128,12,0,97,131,8,0,65,131,
166,3,8,124,32,0,33,56,32,0,128,78,20,3,95,131,32,0,26,40,
84,0,128,65,80,3,127,128,48,0,128,56,45,119,6,72,254,6,122,84,
80,3,127,128,40,0,128,56,4,0,160,56,213,121,6,72,80,3,127,128,
12,0,128,56,0,0,160,56,197,121,6,72,97,118,6,72,25,0,96,56,
141,185,5,72,80,3,127,128,0,0,160,56,40,0,128,56,169,121,6,72,
69,118,6,72,16,39,96,56,113,185,5,72,120,251,227,127,97,253,255,75,
0,0,96,56,245,131,6,72,0,0,160,59,32,0,96,59,20,0,223,59,
252,255,159,59,24,0,188,132,0,0,5,44,56,0,130,65,64,208,29,124,
48,0,130,65,22,0,28,136,116,7,0,124,1,0,0,44,12,0,130,65,
4,0,0,44,24,0,130,64,120,251,227,127,120,235,164,127,213,226,255,75,
120,43,164,124,105,211,255,75,255,255,123,55,1,0,189,59,184,255,130,64,
58,16,64,87,80,0,58,125,56,24,41,85,110,72,190,127,120,251,227,127,
120,235,164,127,1,0,160,56,125,212,255,75,0,0,29,44,108,0,130,65,
22,0,30,136,116,7,0,124,4,0,0,44,28,0,130,64,120,251,227,127,
120,211,68,127,1,0,160,56,25,16,192,56,0,0,224,56,81,235,255,75,
120,251,227,127,120,211,68,127,2,0,160,56,25,16,192,56,0,0,224,56,
57,235,255,75,24,0,193,131,16,0,129,131,20,0,161,131,28,0,225,131,
36,0,1,128,12,0,97,131,8,0,65,131,166,3,8,124,32,0,33,56,
32,0,128,78,72,3,127,128,212,3,223,56,0,0,128,56,25,16,160,56,
181,85,4,72,24,0,193,131,16,0,129,131,20,0,161,131,28,0,225,131,
36,0,1,128,12,0,97,131,8,0,65,131,166,3,8,124,32,0,33,56,
32,0,128,78,232,255,33,148,166,2,8,124,28,0,1,144,20,0,225,147,
120,27,127,124,16,0,193,147,0,32,192,63,0,0,222,59,12,0,161,147,
20,2,254,147,12,2,254,147,24,2,254,147,0,0,160,59,1,0,0,56,
48,232,7,124,57,56,233,127,32,0,130,65,120,235,163,127,13,230,8,72,
52,40,170,87,20,82,126,125,28,3,11,128,165,4,0,84,232,255,130,64,
1,0,189,59,32,0,29,44,204,255,128,65,16,2,254,147,20,0,225,131,
28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,120,35,139,124,
12,0,225,147,255,255,224,59,0,0,224,56,32,0,192,56,120,27,106,124,
20,0,42,57,252,255,10,57,24,0,8,132,0,0,0,44,64,0,130,65,
22,0,168,136,116,7,165,124,1,0,5,44,12,0,130,65,4,0,5,44,
40,0,130,64,8,0,136,128,120,83,67,125,77,223,255,75,0,0,3,44,
20,0,130,65,0,0,11,44,120,59,255,124,140,0,130,65,24,0,0,72,
255,255,198,52,1,0,231,56,176,255,130,64,0,0,11,44,116,0,130,65,
0,0,31,44,108,0,128,64,0,0,192,56,32,0,96,57,232,255,169,56,
24,0,37,133,0,0,9,44,72,0,130,65,22,0,5,136,116,7,0,124,
3,0,0,44,56,0,130,64,8,0,133,128,120,83,67,125,229,222,255,75,
0,0,3,44,36,0,130,65,80,3,106,128,48,0,128,56,120,51,223,124,
65,116,6,72,0,0,31,44,254,6,96,84,48,0,128,64,40,0,0,72,
255,255,107,53,1,0,198,56,168,255,130,64,80,3,106,128,48,0,128,56,
25,116,6,72,0,0,31,44,254,6,96,84,8,0,128,64,120,3,31,124,
20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,80,3,126,128,6,0,160,56,120,35,159,124,
40,0,128,56,129,118,6,72,88,3,158,129,16,0,140,97,88,3,158,145,
17,115,6,72,25,0,96,56,61,182,5,72,80,3,126,128,40,0,128,56,
0,0,160,56,89,118,6,72,0,0,31,44,48,0,130,65,80,3,126,128,
8,3,128,56,1,3,160,56,65,118,6,72,221,114,6,72,208,7,96,56,
9,182,5,72,80,3,126,128,0,3,160,56,8,3,128,56,37,118,6,72,
193,114,6,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,12,0,161,147,120,27,125,124,20,3,29,128,
32,0,0,40,120,43,191,124,120,35,158,124,100,0,128,64,205,217,255,75,
20,3,93,129,58,16,64,85,80,0,74,125,56,24,74,85,20,82,157,125,
20,0,140,128,0,0,4,44,40,0,130,64,255,255,0,57,20,3,29,145,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,120,235,163,127,120,251,229,127,241,208,255,75,
120,235,163,127,120,243,196,127,1,234,255,75,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
216,255,33,148,8,0,1,147,12,0,33,147,16,0,65,147,20,0,97,147,
36,0,225,147,166,2,8,124,44,0,1,144,24,0,129,147,120,27,124,124,
32,0,193,147,121,43,190,124,28,0,161,147,120,35,157,124,12,0,130,65,
1,0,96,56,185,117,6,72,0,32,96,63,0,0,123,59,0,64,0,56,
60,0,27,144,0,16,0,56,28,2,27,144,172,4,0,124,252,1,59,131,
0,0,224,59,120,251,228,127,1,0,64,59,0,3,27,59,32,0,128,57,
18,0,96,63,180,74,123,59,48,32,67,127,57,24,32,127,88,0,130,65,
24,0,24,128,28,0,184,128,63,4,11,84,165,4,165,84,8,0,130,65,
1,0,107,57,72,3,28,128,255,255,203,56,246,232,201,84,174,74,251,124,
64,0,7,124,20,74,27,125,2,0,72,169,32,0,130,64,64,80,29,124,
24,0,130,64,45,252,255,75,0,0,30,44,1,0,224,59,36,0,130,65,
28,0,0,72,255,255,140,53,32,0,24,59,1,0,132,56,148,255,130,64,
0,0,30,44,8,0,130,65,165,117,6,72,16,0,65,131,24,0,129,131,
28,0,161,131,120,251,227,127,36,0,225,131,20,0,97,131,32,0,193,131,
44,0,1,128,12,0,33,131,8,0,1,131,166,3,8,124,40,0,33,56,
32,0,128,78,168,255,33,148,52,0,225,146,56,0,1,147,60,0,33,147,
68,0,97,147,80,0,193,147,84,0,225,147,64,0,65,147,72,0,129,147,
120,27,124,124,20,0,252,56,166,2,8,124,92,0,1,144,76,0,161,147,
120,35,157,124,58,16,160,87,80,0,29,124,56,24,0,84,20,2,71,127,
0,0,26,128,0,0,0,44,1,0,96,63,41,128,123,59,120,43,190,124,
120,51,223,124,32,2,130,65,0,0,32,59,32,0,224,58,232,255,7,59,
24,0,184,132,0,0,5,44,56,0,130,65,64,232,25,124,48,0,130,65,
22,0,120,137,116,7,107,125,1,0,11,44,12,0,130,65,4,0,11,44,
24,0,130,64,120,227,131,127,120,203,36,127,17,221,255,75,120,43,164,124,
165,205,255,75,255,255,247,54,1,0,57,59,184,255,130,64,0,0,154,128,
120,227,131,127,120,251,229,127,201,206,255,75,8,0,154,128,0,0,4,44,
136,0,130,65,120,227,131,127,25,219,255,75,0,0,3,44,28,0,130,65,
120,227,131,127,120,235,164,127,1,0,160,56,217,253,255,75,0,0,3,44,
80,0,130,65,22,0,26,136,116,7,0,124,4,0,0,44,80,0,130,64,
120,227,131,127,120,235,164,127,120,243,198,127,1,0,160,56,0,0,224,56,
113,229,255,75,120,227,131,127,241,214,255,75,120,227,131,127,21,213,255,75,
100,3,92,137,116,7,74,125,1,0,10,44,36,1,130,64,52,0,0,72,
0,0,0,60,177,177,0,96,0,32,0,61,200,0,8,144,120,227,131,127,
189,214,255,75,120,227,131,127,225,212,255,75,100,3,92,137,116,7,74,125,
1,0,10,44,240,0,130,64,1,0,31,44,232,0,130,64,8,0,97,56,
0,0,128,56,40,0,160,56,113,185,255,75,1,0,128,57,18,0,129,177,
16,0,0,56,20,0,1,152,47,0,96,57,25,0,97,153,26,0,97,179,
120,227,131,127,8,0,129,56,209,223,255,75,0,0,3,44,92,0,130,65,
252,3,28,128,1,0,128,57,0,2,64,57,20,3,188,147,32,3,28,144,
36,3,28,144,28,3,92,145,40,3,156,153,4,0,218,179,64,0,65,131,
76,0,161,131,80,0,193,131,68,0,97,131,60,0,33,131,72,0,129,131,
84,0,225,131,92,0,1,128,56,0,1,131,52,0,225,130,166,3,8,124,
88,0,33,56,32,0,128,78,120,227,131,127,120,235,164,127,1,0,160,56,
25,16,192,56,0,0,224,56,101,228,255,75,64,0,65,131,76,0,161,131,
80,0,193,131,68,0,97,131,60,0,33,131,72,0,129,131,84,0,225,131,
92,0,1,128,56,0,1,131,52,0,225,130,166,3,8,124,88,0,33,56,
32,0,128,78,120,227,131,127,120,235,164,127,120,243,198,127,2,0,160,56,
0,0,224,56,25,228,255,75,64,0,65,131,76,0,161,131,80,0,193,131,
68,0,97,131,60,0,33,131,72,0,129,131,84,0,225,131,92,0,1,128,
56,0,1,131,52,0,225,130,166,3,8,124,88,0,33,56,32,0,128,78,
224,255,33,148,12,0,97,147,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,120,27,127,124,80,3,127,128,
8,0,128,56,137,110,6,72,120,27,125,124,120,235,164,127,11,0,96,60,
28,228,99,56,177,120,5,72,120,251,227,127,245,244,255,75,20,3,159,129,
254,239,188,87,224,255,12,48,255,247,170,87,0,0,192,59,16,1,32,125,
208,0,105,127,16,0,130,65,255,15,168,87,96,0,130,65,76,0,0,72,
185,7,171,87,111,6,108,85,53,7,128,85,16,0,130,64,255,15,168,87,
68,0,130,65,48,0,0,72,120,251,227,127,1,0,132,107,62,6,132,84,
41,250,255,75,80,3,127,128,8,0,128,56,247,255,160,56,193,112,6,72,
93,109,6,72,255,15,168,87,20,0,130,65,255,199,160,87,11,2,192,59,
52,0,130,65,96,0,0,72,63,159,169,87,28,0,130,64,255,94,170,87,
20,0,130,64,63,127,171,87,12,0,130,64,255,54,172,87,8,0,130,65,
0,2,192,59,255,199,160,87,52,0,130,64,255,223,160,87,44,0,130,64,
255,183,170,87,36,0,130,64,255,191,171,87,28,0,130,64,255,7,172,87,
20,0,130,64,255,175,160,87,12,0,130,64,255,255,160,87,8,0,130,65,
12,2,192,59,255,167,170,87,16,0,130,65,0,0,27,44,8,0,130,65,
4,2,192,59,0,0,28,44,24,0,130,64,255,231,160,87,104,0,130,65,
4,0,159,129,0,0,12,44,60,0,129,64,88,3,31,128,102,5,0,84,
88,3,31,144,88,3,31,129,80,3,127,128,248,232,165,127,8,0,128,56,
25,16,192,59,0,1,8,97,88,3,31,145,233,111,6,72,120,251,227,127,
217,211,255,75,68,0,0,72,80,3,127,128,24,16,192,59,248,232,165,127,
8,0,128,56,201,111,6,72,120,251,227,127,185,211,255,75,36,0,0,72,
0,0,30,44,28,0,130,65,80,3,127,128,248,232,165,127,8,0,128,56,
165,111,6,72,120,251,227,127,149,211,255,75,0,0,96,56,253,121,6,72,
0,0,30,44,76,0,130,64,4,0,31,128,0,0,0,44,64,0,130,64,
80,3,127,128,248,232,165,127,8,0,128,56,113,111,6,72,13,108,6,72,
72,3,63,129,12,128,109,129,1,0,64,57,48,72,73,125,120,72,107,125,
12,128,109,145,16,128,13,129,120,72,8,125,16,128,13,145,28,2,0,72,
25,16,30,44,156,0,130,64,4,0,95,129,0,0,10,44,144,0,130,64,
88,3,127,137,63,7,107,85,80,0,130,64,120,251,227,127,0,0,128,56,
1,0,160,56,129,202,255,75,72,3,127,128,212,3,223,56,0,0,128,56,
25,16,160,56,41,76,4,72,72,3,63,129,12,128,109,129,1,0,64,57,
48,72,73,125,120,72,107,125,12,128,109,145,16,128,13,129,120,72,8,125,
16,128,13,145,176,1,0,72,72,3,63,129,88,3,159,129,0,16,140,97,
88,3,159,145,12,128,109,129,1,0,64,57,48,72,73,125,120,72,107,125,
12,128,109,145,16,128,13,129,120,72,8,125,16,128,13,145,124,1,0,72,
24,16,30,44,92,0,130,64,4,0,31,128,0,0,0,44,80,0,130,64,
120,251,227,127,0,0,128,56,1,0,160,56,237,201,255,75,72,3,127,128,
0,0,128,56,24,16,160,56,120,35,134,124,149,75,4,72,72,3,63,129,
12,128,109,129,1,0,64,57,48,72,73,125,120,72,107,125,12,128,109,145,
16,128,13,129,120,72,8,125,16,128,13,145,28,1,0,72,0,0,27,44,
116,0,130,65,120,251,227,127,212,3,159,56,0,0,160,56,157,202,255,75,
0,0,30,44,20,0,130,64,120,251,227,127,0,0,128,56,129,221,255,75,
120,27,126,124,80,3,127,128,248,232,165,127,8,0,128,56,5,110,6,72,
120,251,227,127,120,243,196,127,1,0,160,56,241,247,255,75,72,3,63,129,
12,128,109,129,1,0,64,57,48,72,73,125,120,72,107,125,12,128,109,145,
16,128,13,129,120,72,8,125,16,128,13,145,164,0,0,72,80,3,127,128,
132,0,160,99,8,0,128,56,248,0,5,124,185,109,6,72,80,3,127,128,
48,0,128,56,241,106,6,72,120,27,124,124,120,251,227,127,0,0,128,56,
201,245,255,75,120,27,125,124,120,251,227,127,137,209,255,75,88,3,31,129,
212,3,159,56,120,251,227,127,254,215,5,85,237,201,255,75,0,0,30,44,
20,0,130,64,120,251,227,127,254,223,132,87,209,220,255,75,120,27,126,124,
120,251,227,127,120,235,164,127,120,243,197,127,1,0,192,56,41,249,255,75,
72,3,63,129,12,128,109,129,1,0,64,57,48,72,73,125,120,72,107,125,
12,128,109,145,16,128,13,129,120,72,8,125,16,128,13,145,20,0,161,131,
24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,
166,2,8,124,20,0,1,144,166,0,224,127,94,4,235,87,36,1,96,125,
80,3,99,128,0,3,128,56,37,106,6,72,190,231,99,84,0,128,236,115,
166,0,0,124,94,4,0,84,120,99,0,124,36,1,0,124,20,0,1,128,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,46,64,108,84,
20,26,12,124,58,16,0,84,18,0,128,61,48,113,140,57,20,2,108,124,
148,255,255,75,46,64,108,84,20,26,12,124,58,16,0,84,18,0,128,61,
20,2,140,125,132,116,108,136,32,0,128,78,0,0,4,44,0,0,224,56,
18,0,128,61,48,113,140,57,32,0,130,77,255,7,137,84,64,0,130,65,
166,0,0,125,94,4,10,85,36,1,64,125,10,128,109,169,0,88,7,124,
20,0,128,64,88,3,12,128,0,1,0,96,84,3,108,152,88,3,12,144,
0,128,5,113,166,0,192,124,94,4,198,84,120,43,198,124,36,1,192,124,
127,248,132,84,4,4,140,57,1,0,231,56,176,255,130,64,32,0,128,78,
88,3,131,129,181,6,140,85,52,128,226,56,8,0,130,65,44,128,226,56,
88,3,3,128,49,6,0,84,8,0,130,65,48,128,226,56,72,3,131,128,
84,3,163,136,108,3,195,128,11,0,96,60,80,228,99,56,156,22,6,72,
10,128,13,168,64,0,3,124,32,0,128,76,46,64,108,84,20,26,12,124,
58,16,0,84,18,0,128,61,48,113,140,57,20,2,108,124,160,255,255,75,
10,128,13,168,64,0,3,124,12,0,128,65,0,0,96,56,32,0,128,78,
46,64,108,84,20,26,12,124,58,16,0,84,18,0,128,61,48,113,140,57,
46,0,108,124,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
0,0,3,44,20,0,130,64,176,0,96,56,165,0,6,72,0,0,3,44,
24,0,130,65,0,0,0,56,0,0,3,144,4,0,3,144,88,0,3,144,
172,0,3,176,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,126,56,0,0,128,56,12,0,160,56,233,177,255,75,
236,3,126,56,0,0,128,56,12,0,160,56,217,177,255,75,0,0,96,56,
0,0,126,144,88,3,126,144,96,3,126,144,72,3,94,129,248,191,13,128,
12,128,109,129,1,0,128,57,48,80,137,125,120,72,107,125,12,128,109,145,
16,128,205,128,208,3,30,144,84,3,158,153,120,72,198,124,16,128,205,144,
65,255,255,75,68,3,30,128,58,16,7,84,0,4,126,144,18,0,7,61,
32,113,104,128,20,0,128,56,0,0,160,56,153,106,6,72,120,243,195,127,
185,205,255,75,80,3,126,128,0,0,128,56,120,35,133,124,129,106,6,72,
80,3,126,128,0,0,160,56,4,0,128,56,113,106,6,72,80,3,126,128,
8,0,128,56,0,0,160,56,97,106,6,72,80,3,126,128,0,0,160,56,
12,0,128,56,81,106,6,72,80,3,126,128,0,0,160,56,16,0,128,56,
65,106,6,72,80,3,126,128,0,0,160,56,28,0,128,56,49,106,6,72,
80,3,126,128,44,0,128,56,0,0,160,56,33,106,6,72,80,3,126,128,
0,0,160,56,52,0,128,56,17,106,6,72,80,3,126,128,56,0,128,56,
73,103,6,72,177,6,101,84,80,3,126,128,56,0,128,56,245,105,6,72,
120,243,195,127,229,205,255,75,88,3,94,129,5,0,160,56,0,1,74,97,
0,0,128,56,120,243,195,127,88,3,94,145,193,199,255,75,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,8,0,193,147,11,0,192,63,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,76,3,223,144,64,3,159,144,72,3,191,144,
112,22,160,124,148,1,96,125,68,3,127,145,112,254,160,124,191,7,12,84,
20,42,12,125,59,0,0,85,80,40,0,124,36,104,11,84,20,90,135,125,
0,32,12,56,80,3,31,144,42,80,167,84,0,64,231,60,44,3,255,144,
224,3,7,57,48,3,31,145,46,64,169,84,1,64,73,61,0,128,74,57,
56,3,95,145,52,3,255,144,0,0,128,57,60,3,159,145,153,120,6,72,
112,3,127,56,20,0,128,56,245,120,6,72,120,251,227,127,233,253,255,75,
0,2,96,56,5,0,6,72,0,0,3,44,248,3,127,144,20,0,130,64,
152,228,126,56,28,7,128,56,0,0,160,56,225,180,255,75,0,2,96,56,
225,255,5,72,0,0,3,44,252,3,127,144,20,0,130,64,152,228,126,56,
32,7,128,56,0,0,160,56,189,180,255,75,248,3,127,128,255,0,128,56,
0,2,160,56,157,175,255,75,252,3,127,128,255,0,128,56,0,2,160,56,
141,175,255,75,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,0,0,4,44,0,0,128,57,32,0,129,76,
0,32,96,61,0,0,107,57,0,0,0,56,166,3,137,124,152,0,139,145,
160,0,11,144,1,0,140,57,244,255,0,66,32,0,128,78,240,255,33,148,
1,0,128,61,0,160,140,57,18,0,96,61,180,74,107,57,120,91,101,125,
0,32,192,60,0,0,198,56,16,32,0,61,0,0,8,57,12,0,225,147,
0,0,224,59,120,251,231,127,120,59,233,124,166,2,8,124,20,0,1,144,
255,255,0,56,240,255,75,57,0,2,128,56,166,3,137,124,16,0,10,180,
2,0,234,176,16,0,165,56,12,0,170,144,0,0,96,56,0,64,140,60,
8,0,138,144,8,0,140,56,190,244,132,84,72,2,136,144,76,2,102,144,
12,0,140,56,190,244,132,84,72,2,136,144,76,2,102,144,190,244,132,85,
72,2,136,144,0,128,36,101,76,2,134,144,76,2,102,144,64,0,41,61,
4,0,234,147,128,0,255,59,16,0,140,57,160,255,0,66,240,133,109,144,
0,2,0,56,244,133,13,144,248,133,109,145,1,0,128,60,9,255,255,75,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
1,0,128,60,0,192,132,56,204,0,160,56,18,0,96,60,180,106,99,56,
120,27,106,124,16,32,96,61,0,0,107,57,0,32,128,61,0,0,140,57,
248,255,3,57,120,35,134,124,0,0,224,56,0,64,36,61,8,0,40,149,
8,0,42,57,4,0,40,145,5,0,32,57,166,3,41,125,8,0,38,57,
190,244,41,85,72,2,43,145,76,2,236,144,12,0,38,57,190,244,41,85,
72,2,43,145,76,2,236,144,16,0,198,56,220,255,0,66,255,255,165,52,
80,0,132,56,8,0,74,57,172,255,130,64,0,0,128,57,252,133,141,145,
204,0,128,57,0,134,141,145,4,134,109,144,32,0,128,78,184,255,33,148,
12,0,33,146,16,0,65,146,20,0,97,146,24,0,129,146,28,0,161,146,
32,0,193,146,36,0,225,146,40,0,1,147,44,0,33,147,48,0,65,147,
52,0,97,147,56,0,129,147,60,0,161,147,64,0,193,147,166,2,8,124,
76,0,1,144,68,0,225,147,0,32,224,63,0,0,255,59,109,107,6,72,
20,128,45,129,2,0,96,59,0,0,224,58,128,2,63,145,132,2,255,146,
44,2,255,146,10,128,237,178,120,187,249,126,120,187,250,126,120,211,84,127,
20,128,173,58,120,187,246,126,24,134,13,59,2,0,192,63,120,203,35,127,
77,109,6,72,121,27,127,124,36,0,130,65,10,128,173,168,1,0,247,58,
112,22,167,124,148,1,7,124,0,0,24,144,4,0,24,59,20,250,5,124,
10,128,13,176,0,0,31,44,0,0,96,58,108,0,129,64,18,0,20,61,
48,113,136,59,120,171,189,126,3,0,32,62,18,0,64,62,32,113,82,58,
4,0,19,44,120,139,41,126,8,0,128,64,120,243,201,127,0,0,221,128,
120,211,69,127,20,50,233,124,120,227,131,127,120,203,36,127,112,22,64,127,
148,1,0,124,58,16,12,84,46,145,236,124,33,252,255,75,4,4,156,59,
4,4,148,58,255,255,255,55,1,0,90,59,1,0,115,58,180,255,130,64,
4,0,181,58,255,255,123,55,4,0,214,58,1,0,57,59,76,255,130,64,
120,187,227,126,33,106,6,72,9,128,141,136,10,128,173,168,116,7,132,124,
64,40,4,124,32,0,129,64,0,0,4,44,20,0,129,64,11,0,96,60,
164,228,99,56,65,16,6,72,10,128,173,168,9,128,173,152,9,253,255,75,
229,253,255,75,8,0,128,56,0,0,132,60,134,51,128,124,166,0,192,127,
94,4,192,87,36,1,0,124,134,50,130,124,120,35,131,124,8,0,127,96,
120,251,229,127,134,51,162,124,0,128,192,115,166,0,32,125,94,4,41,85,
120,3,41,125,36,1,32,125,9,128,13,136,116,7,0,124,8,0,0,44,
68,0,129,64,4,0,128,56,0,0,132,60,134,51,128,124,166,0,192,127,
94,4,192,87,36,1,0,124,134,50,130,124,120,35,131,124,4,0,127,96,
120,251,229,127,134,51,162,124,0,128,192,115,166,0,0,125,94,4,8,85,
120,3,8,125,36,1,0,125,56,0,129,131,32,0,193,130,28,0,161,130,
52,0,97,131,60,0,161,131,36,0,225,130,24,0,129,130,48,0,65,131,
64,0,193,131,40,0,1,131,20,0,97,130,44,0,33,131,68,0,225,131,
76,0,1,128,16,0,65,130,12,0,33,130,166,3,8,124,72,0,33,56,
32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,20,0,225,147,
166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,4,0,126,129,
0,0,11,44,100,0,130,65,20,3,158,131,224,255,156,49,0,0,0,56,
149,1,224,127,20,0,130,65,120,243,195,127,1,0,128,56,109,236,255,75,
120,27,124,124,32,0,28,40,56,0,128,64,58,16,128,87,80,0,92,125,
56,24,74,85,20,242,170,124,20,0,101,128,0,0,3,44,20,0,190,59,
24,0,130,65,208,3,190,128,1,0,128,56,169,63,4,72,0,0,3,44,
40,0,130,64,20,0,225,131,16,0,193,131,12,0,161,131,28,0,1,128,
8,0,129,131,0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
72,3,158,128,11,0,96,60,232,228,99,56,77,107,5,72,0,0,31,44,
1,0,224,59,152,0,130,65,1,0,96,56,89,100,6,72,32,0,32,57,
0,0,224,56,120,59,235,124,64,224,7,124,76,0,130,65,20,90,221,124,
0,0,6,128,0,0,0,44,60,0,130,65,22,0,6,136,116,7,0,124,
1,0,0,44,12,0,130,65,4,0,0,44,36,0,130,64,8,0,134,128,
120,243,195,127,65,203,255,75,0,0,3,44,16,0,130,65,0,0,224,59,
165,100,6,72,44,0,0,72,255,255,41,53,24,0,107,57,1,0,231,56,
164,255,130,64,80,3,126,128,40,0,128,56,6,0,160,56,61,99,6,72,
217,95,6,72,121,100,6,72,0,0,31,44,116,0,130,65,20,3,94,129,
32,0,10,40,120,243,195,127,72,0,128,65,1,0,128,56,109,236,255,75,
80,3,126,128,8,0,128,56,247,255,160,56,5,99,6,72,161,95,6,72,
120,243,195,127,120,227,132,127,4,2,160,56,2,0,192,56,197,238,255,75,
120,243,195,127,221,198,255,75,120,243,195,127,1,197,255,75,32,0,0,72,
4,2,128,56,2,0,160,56,201,236,255,75,120,243,195,127,189,198,255,75,
120,243,195,127,225,196,255,75,120,251,227,127,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,166,0,224,127,94,4,224,87,36,1,0,124,
120,243,195,127,236,3,158,56,17,187,255,75,121,27,101,124,24,0,130,65,
120,243,195,127,8,0,158,56,0,0,192,56,57,187,255,75,220,255,255,75,
0,128,235,115,166,0,128,125,94,4,140,85,120,91,140,125,36,1,128,125,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,8,0,193,147,12,0,225,147,166,2,8,124,
20,0,1,144,166,0,192,127,94,4,204,87,36,1,128,125,120,27,127,124,
241,197,255,75,56,3,191,128,80,3,127,128,32,0,128,56,233,97,6,72,
56,3,191,128,80,3,127,128,36,0,128,56,217,97,6,72,0,0,160,56,
60,3,191,144,88,3,31,128,80,3,127,128,12,0,128,56,36,5,0,84,
88,3,31,144,185,97,6,72,80,3,127,128,4,0,160,56,40,0,128,56,
169,97,6,72,80,3,127,128,80,0,128,56,225,94,6,72,128,16,101,96,
80,3,127,128,80,0,128,56,141,97,6,72,80,3,127,128,80,0,128,56,
197,94,6,72,120,251,227,127,1,0,128,56,205,234,255,75,0,128,192,115,
166,0,32,125,94,4,41,85,120,3,41,125,36,1,32,125,3,0,96,60,
64,13,99,56,41,161,5,72,166,0,192,127,94,4,202,87,36,1,64,125,
80,3,127,128,8,0,128,56,247,255,160,56,57,97,6,72,80,3,127,128,
12,0,128,56,113,94,6,72,24,0,101,96,80,3,127,128,12,0,128,56,
29,97,6,72,185,93,6,72,0,128,203,115,166,0,0,124,94,4,0,84,
120,91,0,124,36,1,0,124,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,0,0,30,128,0,0,0,44,120,35,159,124,44,0,130,64,
0,0,32,57,204,3,62,145,16,0,193,131,20,0,225,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
166,0,128,127,94,4,138,87,36,1,64,125,88,3,126,129,208,3,222,128,
80,248,166,127,173,5,107,85,112,254,167,127,120,58,189,127,80,232,167,127,
68,0,130,64,204,3,158,129,0,0,12,44,152,0,130,65,150,0,29,44,
156,0,129,64,88,3,94,129,0,128,137,115,0,2,74,97,1,0,0,56,
104,3,30,144,88,3,94,145,166,0,64,125,94,4,74,85,120,75,74,125,
36,1,64,125,132,0,0,72,88,3,158,137,88,3,254,128,0,0,128,56,
120,243,195,127,62,7,140,85,255,255,12,48,16,97,0,124,172,77,7,80,
88,3,254,144,45,215,255,75,204,3,126,129,0,0,11,44,48,0,130,65,
88,3,30,128,60,0,29,44,1,0,128,57,104,3,158,145,0,2,0,96,
88,3,30,144,32,0,129,64,120,243,195,127,73,251,255,75,0,0,3,44,
16,0,130,65,200,3,30,129,208,3,254,147,204,3,30,145,0,128,137,115,
166,0,64,125,94,4,74,85,120,75,74,125,36,1,64,125,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,240,255,33,148,8,0,193,147,12,0,225,147,
166,2,8,124,20,0,1,144,166,0,192,127,94,4,204,87,36,1,128,125,
120,27,127,124,89,195,255,75,88,3,31,128,80,3,127,128,12,0,128,56,
0,0,160,56,36,5,0,84,88,3,31,144,69,95,6,72,80,3,127,128,
4,0,160,56,8,3,128,56,53,95,6,72,209,91,6,72,0,128,204,115,
166,0,0,124,94,4,0,84,120,99,0,124,36,1,0,124,120,251,227,127,
249,182,255,75,0,0,3,44,244,255,130,64,166,0,192,127,94,4,200,87,
36,1,0,125,80,3,127,128,103,255,160,56,8,0,128,56,241,94,6,72,
141,91,6,72,0,128,202,115,166,0,96,125,94,4,107,85,120,83,107,125,
36,1,96,125,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,8,0,193,147,12,0,225,147,
166,2,8,124,20,0,1,144,166,0,192,127,94,4,192,87,36,1,0,124,
120,27,127,124,236,3,159,56,61,183,255,75,0,0,3,44,36,0,130,64,
120,251,227,127,0,0,128,56,25,184,255,75,120,251,227,127,8,0,159,56,
29,183,255,75,0,0,3,44,16,0,130,65,0,0,159,129,255,255,140,57,
0,0,159,145,0,128,192,115,166,0,64,125,94,4,74,85,120,3,74,125,
36,1,64,125,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,12,0,161,147,120,27,125,124,166,0,224,127,
94,4,224,87,36,1,0,124,88,3,125,137,63,7,107,85,28,0,130,64,
0,128,236,115,166,0,0,124,94,4,0,84,120,99,0,124,36,1,0,124,
248,0,0,72,4,128,13,128,0,0,0,44,20,0,130,64,0,0,0,60,
181,177,0,96,0,32,96,61,200,0,11,144,120,235,163,127,49,251,255,75,
88,3,29,136,54,0,0,84,88,3,29,152,88,3,125,129,231,4,107,85,
120,235,163,127,52,0,130,65,88,3,29,128,36,5,0,84,0,0,128,56,
1,0,160,56,88,3,29,144,253,184,255,75,72,3,125,128,212,3,221,56,
0,0,128,56,25,16,160,56,165,58,4,72,116,0,0,72,89,181,255,75,
2,0,3,44,120,235,163,127,20,0,130,64,209,220,255,75,1,0,128,57,
104,3,157,145,84,0,0,72,8,0,157,56,249,181,255,75,121,27,126,124,
68,0,130,65,120,235,163,127,120,243,196,127,1,0,160,56,165,184,255,75,
120,235,163,127,212,3,157,56,0,0,160,56,153,185,255,75,0,0,125,129,
72,3,125,128,120,243,196,127,212,3,221,56,255,255,107,57,25,16,160,56,
0,0,125,145,49,58,4,72,0,128,236,115,166,0,0,124,94,4,0,84,
120,99,0,124,36,1,0,124,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,
166,0,192,127,94,4,204,87,36,1,128,125,0,0,99,129,1,0,107,57,
120,27,125,124,120,35,159,124,0,0,99,145,201,214,255,75,0,0,3,44,
24,0,130,65,120,235,163,127,8,0,157,56,120,251,229,127,0,0,192,56,
105,181,255,75,0,128,192,115,166,0,64,125,94,4,74,85,120,3,74,125,
36,1,64,125,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,8,0,193,147,
12,0,225,147,166,2,8,124,20,0,1,144,120,35,135,124,0,0,7,128,
32,0,0,40,120,27,105,124,24,0,128,65,20,0,1,128,16,0,33,56,
166,3,8,124,0,0,96,56,32,0,128,78,166,0,96,125,94,4,102,85,
36,1,192,124,120,3,6,124,120,51,222,124,32,0,30,44,0,0,0,57,
20,0,137,57,58,16,192,87,80,0,30,124,56,24,0,84,20,2,236,127,
232,255,255,59,204,0,128,64,24,0,95,133,0,0,10,44,172,0,130,65,
8,0,159,128,0,0,4,44,160,0,130,65,120,75,35,125,141,195,255,75,
0,0,3,44,24,0,130,64,0,0,199,128,1,0,198,56,1,0,222,59,
0,0,199,144,136,0,0,72,4,0,202,128,4,0,38,129,1,0,30,56,
0,0,7,144,0,0,5,145,28,0,137,129,132,0,135,117,254,47,137,85,
255,255,7,48,16,57,0,124,120,67,7,125,8,3,136,117,254,7,7,80,
255,255,8,48,16,65,192,124,188,15,199,80,122,23,39,81,0,0,229,144,
0,128,104,113,166,0,0,124,94,4,0,84,120,67,0,124,36,1,0,124,
12,0,225,131,20,0,1,128,8,0,193,131,120,83,67,125,166,3,8,124,
16,0,33,56,32,0,128,78,1,0,222,59,1,0,198,56,0,0,199,144,
32,0,30,44,60,255,128,65,0,128,106,113,166,0,96,125,94,4,107,85,
120,83,107,125,36,1,96,125,12,0,225,131,20,0,1,128,8,0,193,131,
0,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,
20,0,225,147,166,2,8,124,28,0,1,144,8,0,129,147,120,27,124,124,
12,0,161,147,120,35,157,124,16,0,193,147,120,43,190,124,166,0,224,127,
94,4,230,87,36,1,192,124,0,0,252,128,1,0,7,57,0,0,28,145,
88,3,60,137,63,7,41,85,188,0,130,64,0,0,30,44,96,0,130,64,
0,0,7,44,88,0,129,64,4,0,93,129,18,0,10,160,189,7,11,84,
16,0,130,64,120,227,131,127,0,0,128,56,5,180,255,75,120,227,131,127,
8,0,156,56,120,235,165,127,0,0,192,56,65,179,255,75,120,227,131,127,
1,0,128,56,229,179,255,75,0,128,236,115,166,0,0,124,94,4,0,84,
120,99,0,124,36,1,0,124,112,0,0,72,8,0,28,128,0,0,0,44,
2,0,96,56,24,0,130,64,120,227,131,127,120,235,164,127,69,212,255,75,
0,0,3,44,56,0,130,65,0,0,30,44,0,0,192,56,16,0,130,65,
1,0,3,44,8,0,130,65,1,0,192,56,120,227,131,127,8,0,156,56,
120,235,165,127,62,6,198,84,205,178,255,75,8,0,0,72,9,180,255,75,
0,128,236,115,166,0,0,124,94,4,0,84,120,99,0,124,36,1,0,124,
16,0,193,131,20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,45,0,67,137,
43,0,131,137,44,0,99,137,46,0,3,136,11,0,129,153,8,0,1,152,
9,0,65,153,10,0,97,153,8,0,97,128,24,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,8,0,193,147,120,27,126,124,166,2,8,124,
20,0,1,144,112,0,126,128,36,0,99,129,92,0,139,129,120,35,128,124,
0,0,158,136,120,43,166,124,120,3,5,124,166,3,137,125,33,4,128,78,
121,27,127,124,2,0,254,179,32,0,130,65,241,179,3,72,120,251,228,127,
120,27,101,124,11,0,96,60,252,228,99,56,225,3,6,72,2,0,254,171,
20,0,1,128,120,251,227,127,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,224,255,33,148,12,0,97,147,24,0,193,147,
28,0,225,147,166,2,8,124,36,0,1,144,16,0,129,147,20,0,161,147,
120,27,125,124,41,0,157,59,120,227,131,127,0,0,128,56,35,0,160,56,
157,159,255,75,112,0,125,128,36,0,67,129,108,0,138,129,0,0,157,136,
35,0,192,56,120,227,133,127,166,3,137,125,33,4,128,78,121,27,127,124,
41,0,221,139,2,0,253,179,92,0,130,64,3,0,30,44,0,0,0,57,
12,0,128,65,35,0,30,40,16,0,129,64,138,3,224,59,2,0,253,179,
52,0,0,72,121,243,192,127,28,0,129,64,255,255,124,57,166,3,9,124,
1,0,11,140,20,2,8,125,116,7,8,125,244,255,0,66,0,0,8,44,
12,0,130,65,21,3,224,59,2,0,253,179,0,0,31,44,100,0,130,65,
120,251,227,127,245,178,3,72,120,251,228,127,120,27,101,124,11,0,96,60,
44,229,99,56,229,2,6,72,0,0,30,44,0,0,96,59,48,0,129,64,
255,255,252,59,19,0,27,44,12,0,130,64,60,128,98,56,197,2,6,72,
1,0,159,140,64,128,98,56,185,2,6,72,255,255,222,55,1,0,123,59,
220,255,130,64,60,128,98,56,165,2,6,72,2,0,253,171,120,251,227,127,
28,0,225,131,20,0,161,131,24,0,193,131,36,0,1,128,16,0,129,131,
12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,8,0,193,147,120,27,126,124,166,2,8,124,20,0,1,144,
112,0,126,128,36,0,99,129,100,0,139,129,120,35,128,124,0,0,158,136,
120,43,166,124,120,3,5,124,166,3,137,125,33,4,128,78,121,27,127,124,
2,0,254,179,32,0,130,65,41,178,3,72,120,251,228,127,120,27,101,124,
11,0,96,60,92,229,99,56,25,2,6,72,2,0,254,171,20,0,1,128,
120,251,227,127,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,200,255,33,148,52,0,225,147,32,0,65,147,120,27,122,124,
4,0,250,59,16,0,193,146,20,0,225,146,24,0,1,147,28,0,33,147,
36,0,97,147,44,0,161,147,48,0,193,147,40,0,129,147,166,2,8,124,
60,0,1,144,3,0,69,57,4,0,90,153,120,35,156,124,255,255,10,52,
5,0,154,155,0,0,128,57,28,0,129,64,3,0,26,57,166,3,9,124,
1,0,8,140,80,96,128,125,116,7,140,125,244,255,0,66,8,0,193,56,
212,192,109,56,32,0,128,60,20,82,191,124,255,255,133,153,1,0,160,56,
0,0,224,56,189,133,9,72,0,0,192,59,76,0,218,155,12,0,33,59,
77,0,26,59,32,0,224,62,15,0,192,62,64,66,214,58,28,0,0,72,
11,0,96,60,212,234,99,56,61,1,6,72,94,1,96,56,89,196,5,72,
4,0,250,59,0,0,191,136,120,211,67,127,120,251,228,127,173,254,255,75,
121,27,127,124,188,1,130,64,9,0,28,44,200,0,160,59,12,0,130,65,
7,0,28,44,8,0,130,64,220,5,160,59,166,0,96,124,254,143,107,84,
1,0,108,105,63,6,140,85,128,0,130,65,11,0,96,60,0,235,99,56,
61,93,5,72,166,3,201,126,134,50,128,124,120,35,131,124,255,151,96,84,
44,0,130,64,240,255,0,66,120,203,38,127,212,192,109,56,120,187,228,126,
1,0,160,56,0,0,224,56,5,133,9,72,138,3,31,44,196,0,130,64,
160,0,0,72,2,0,128,56,0,0,132,60,134,51,128,124,233,71,0,72,
120,203,38,127,212,192,109,56,120,187,228,126,1,0,160,56,0,0,224,56,
209,132,9,72,138,3,31,44,144,0,130,64,108,0,0,72,120,203,38,127,
120,235,167,127,212,192,109,56,120,187,228,126,1,0,160,56,173,132,9,72,
0,0,3,44,16,0,130,64,0,0,249,128,149,2,230,84,56,0,130,64,
10,0,28,44,16,0,130,64,0,0,224,59,0,0,216,155,76,0,0,72,
22,3,224,59,120,251,227,127,33,176,3,72,120,27,101,124,11,0,96,60,
20,235,99,56,120,251,228,127,17,0,6,72,138,3,31,44,36,0,130,64,
120,251,227,127,253,175,3,72,120,251,228,127,120,27,101,124,11,0,96,60,
44,235,99,56,237,255,5,72,68,0,0,72,0,0,31,44,32,0,130,64,
0,0,24,136,0,0,0,44,112,0,130,65,116,7,0,124,0,3,224,35,
53,7,255,127,96,0,130,65,120,251,227,127,185,175,3,72,120,251,228,127,
120,27,101,124,11,0,96,60,44,235,99,56,169,255,5,72,0,0,160,59,
255,255,120,59,20,0,0,72,19,0,29,44,12,0,130,64,72,128,98,56,
141,255,5,72,0,0,155,136,76,128,98,56,129,255,5,72,1,0,189,59,
35,0,29,44,1,0,123,59,216,255,128,65,72,128,98,56,105,255,5,72,
2,3,31,44,28,254,130,65,40,0,129,131,28,0,33,131,24,0,1,131,
36,0,97,131,44,0,161,131,120,251,227,127,52,0,225,131,32,0,65,131,
48,0,193,131,60,0,1,128,20,0,225,130,16,0,193,130,166,3,8,124,
56,0,33,56,32,0,128,78,224,255,33,148,8,0,65,147,12,0,97,147,
16,0,129,147,24,0,193,147,28,0,225,147,166,2,8,124,36,0,1,144,
20,0,161,147,120,27,125,124,124,0,29,128,52,0,9,124,120,35,154,124,
127,217,59,85,120,43,188,124,0,0,192,59,24,0,130,64,116,0,125,56,
255,255,128,56,73,134,9,72,0,0,3,44,240,255,130,64,120,235,163,127,
9,251,255,75,0,0,3,44,36,0,130,65,0,0,27,44,80,1,130,65,
212,192,109,56,32,0,128,60,0,0,160,56,221,126,9,72,120,243,195,127,
96,1,0,72,42,0,157,137,128,255,76,57,62,6,74,85,19,0,10,40,
41,0,253,59,0,0,154,153,136,0,128,65,0,0,27,44,44,0,130,65,
76,0,125,56,120,251,228,127,35,0,160,56,17,29,6,72,212,192,109,56,
32,0,128,60,0,0,160,56,145,126,9,72,120,243,195,127,20,1,0,72,
11,0,96,60,124,235,99,56,69,254,5,72,0,0,128,59,20,0,0,72,
19,0,28,44,12,0,130,64,84,128,98,56,45,254,5,72,0,0,159,136,
88,128,98,56,33,254,5,72,1,0,156,59,35,0,28,40,1,0,255,59,
216,255,128,65,84,128,98,56,9,254,5,72,0,0,27,44,156,0,130,65,
188,0,0,72,112,255,12,56,3,0,0,40,32,0,128,64,120,235,163,127,
125,249,255,75,0,0,27,44,1,0,192,59,0,0,124,144,116,0,130,65,
148,0,0,72,16,0,10,40,60,0,128,64,120,235,163,127,89,249,255,75,
120,27,101,124,12,0,224,63,164,247,127,56,96,128,130,56,177,243,5,72,
164,247,159,56,11,0,96,60,156,235,99,56,161,253,5,72,0,0,27,44,
52,0,130,65,84,0,0,72,11,0,96,60,100,235,99,56,137,253,5,72,
0,0,154,136,11,0,96,60,180,235,99,56,121,253,5,72,84,128,98,56,
113,253,5,72,0,0,27,44,40,0,130,64,116,0,125,56,129,131,9,72,
0,0,3,44,24,0,130,65,11,0,96,60,192,235,99,56,185,1,128,56,
0,0,160,56,105,158,255,75,120,243,195,127,24,0,193,131,16,0,129,131,
20,0,161,131,28,0,225,131,36,0,1,128,12,0,97,131,8,0,65,131,
166,3,8,124,32,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,2,0,128,56,0,0,132,60,134,51,128,124,96,239,96,60,
28,7,99,56,0,0,99,128,255,191,96,84,36,0,130,65,212,192,109,56,
16,0,128,60,0,0,160,56,21,125,9,72,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,0,0,96,56,53,74,0,72,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,216,255,33,148,32,0,193,147,
120,43,190,124,32,0,30,40,20,0,97,147,24,0,129,147,166,2,8,124,
44,0,1,144,28,0,161,147,120,27,125,124,36,0,225,147,120,35,159,124,
16,0,65,147,120,51,218,124,36,0,129,64,28,0,161,131,36,0,225,131,
32,0,193,131,16,0,65,131,166,3,8,124,33,3,96,56,40,0,33,56,
32,0,128,78,0,0,30,44,48,0,130,64,24,0,129,131,32,0,193,131,
36,0,225,131,28,0,161,131,20,0,97,131,44,0,1,128,16,0,65,131,
0,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,116,0,157,59,
8,0,129,147,1,0,128,57,12,0,129,153,120,227,155,127,120,219,99,127,
255,255,128,56,121,131,9,72,0,0,3,44,240,255,130,64,4,0,64,57,
4,0,62,57,0,72,10,124,2,0,190,56,112,70,232,127,6,0,29,153,
7,0,253,155,255,255,90,59,7,0,253,56,24,0,128,64,1,0,74,57,
0,72,10,124,1,0,26,140,1,0,7,156,240,255,128,65,120,235,163,127,
116,7,165,124,7,0,128,56,189,249,255,75,0,0,0,56,12,0,1,152,
120,27,127,124,120,227,131,127,189,129,9,72,0,0,3,44,24,0,130,65,
11,0,96,60,204,235,99,56,185,1,128,56,0,0,160,56,165,156,255,75,
28,0,161,131,120,251,227,127,36,0,225,131,24,0,129,131,32,0,193,131,
44,0,1,128,20,0,97,131,16,0,65,131,166,3,8,124,40,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,11,0,96,60,
216,235,99,56,61,251,5,72,77,250,6,72,124,196,13,128,0,0,0,44,
28,0,130,65,10,0,96,56,73,190,5,72,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,2,0,96,60,160,134,99,56,21,144,5,72,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,29,247,255,75,121,27,127,124,164,3,130,64,42,0,94,137,
128,255,106,57,62,6,107,85,16,0,11,40,0,0,128,57,16,0,128,64,
4,0,11,40,8,0,128,65,1,0,128,57,63,6,140,85,88,0,130,64,
112,255,106,57,3,0,11,40,56,0,128,64,120,243,195,127,37,246,255,75,
12,0,160,63,120,27,126,124,164,247,125,56,120,243,197,127,108,128,130,56,
121,240,5,72,164,247,157,56,11,0,96,60,116,236,99,56,105,250,5,72,
72,0,0,72,11,0,96,60,100,237,99,56,89,250,5,72,129,3,224,59,
36,3,0,72,120,243,195,127,221,245,255,75,12,0,160,63,120,27,126,124,
164,247,125,56,120,243,197,127,108,128,130,56,49,240,5,72,164,247,157,56,
11,0,96,60,116,236,99,56,33,250,5,72,1,0,204,87,255,255,12,48,
16,97,64,125,63,6,74,85,24,2,130,65,67,0,200,87,255,255,40,49,
16,65,105,125,63,6,107,85,16,0,130,64,11,0,96,60,248,235,99,56,
237,249,5,72,75,1,202,87,255,255,106,49,16,81,11,124,63,6,0,84,
16,0,130,65,11,0,96,60,232,235,99,56,205,249,5,72,91,3,204,87,
255,255,12,48,16,97,0,125,63,6,8,85,11,0,96,60,24,236,99,56,
12,0,130,65,11,0,96,60,136,236,99,56,165,249,5,72,190,103,196,87,
116,7,132,124,11,0,96,60,156,236,99,56,145,249,5,72,99,4,200,87,
255,255,40,49,16,65,105,125,63,6,107,85,104,128,98,56,12,0,130,65,
11,0,96,60,172,236,99,56,109,249,5,72,165,4,202,87,255,255,106,49,
16,81,139,125,63,6,140,85,11,0,96,60,44,236,99,56,12,0,130,65,
11,0,96,60,184,236,99,56,69,249,5,72,231,4,204,87,255,255,12,48,
16,97,0,125,63,6,8,85,16,0,130,65,11,0,96,60,196,236,99,56,
37,249,5,72,41,5,200,87,255,255,40,49,16,65,41,125,63,6,41,85,
16,0,130,65,11,0,96,60,220,236,99,56,5,249,5,72,33,4,200,87,
255,255,8,48,16,65,64,125,63,6,74,85,16,0,130,65,11,0,96,60,
56,236,99,56,229,248,5,72,223,3,200,87,255,255,40,49,16,65,9,124,
63,6,0,84,16,0,130,65,11,0,96,60,244,236,99,56,197,248,5,72,
157,3,202,87,255,255,10,48,16,81,0,124,63,6,0,84,16,0,130,65,
11,0,96,60,72,236,99,56,165,248,5,72,107,5,192,87,255,255,0,49,
16,1,40,125,63,6,41,85,16,0,130,65,11,0,96,60,8,237,99,56,
133,248,5,72,115,6,201,87,255,255,73,49,16,73,74,125,63,6,74,85,
16,0,130,65,11,0,96,60,28,237,99,56,101,248,5,72,57,7,203,87,
255,255,139,49,16,89,108,125,63,6,107,85,16,0,130,65,11,0,96,60,
44,237,99,56,69,248,5,72,83,2,192,87,255,255,0,49,16,1,8,124,
63,6,0,84,11,0,96,60,56,237,99,56,60,0,130,65,11,0,96,60,
92,236,99,56,29,248,5,72,127,7,201,87,80,0,130,65,4,0,9,40,
200,0,128,65,96,0,130,65,6,0,9,40,116,0,128,65,140,0,130,65,
180,0,0,72,11,0,96,60,80,237,99,56,237,247,5,72,127,7,201,87,
32,0,130,65,4,0,9,40,152,0,128,65,48,0,130,65,6,0,9,40,
68,0,128,65,92,0,130,65,132,0,0,72,11,0,128,60,140,229,132,56,
127,7,197,87,11,0,96,60,4,236,99,56,177,247,5,72,128,0,0,72,
11,0,128,60,196,229,132,56,127,7,197,87,11,0,96,60,4,236,99,56,
149,247,5,72,100,0,0,72,11,0,128,60,244,229,132,56,127,7,197,87,
11,0,96,60,4,236,99,56,121,247,5,72,72,0,0,72,9,1,202,87,
11,0,128,60,156,229,132,56,40,0,130,64,11,0,128,60,20,230,132,56,
127,7,197,87,11,0,96,60,4,236,99,56,77,247,5,72,28,0,0,72,
11,0,128,60,44,230,132,56,127,7,197,87,11,0,96,60,4,236,99,56,
49,247,5,72,120,251,227,127,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,224,255,33,148,
24,0,193,147,20,0,161,147,120,27,125,124,116,0,221,59,8,0,193,147,
166,2,8,124,36,0,1,144,1,0,0,56,12,0,1,152,28,0,225,147,
120,243,223,127,120,251,227,127,255,255,128,56,73,126,9,72,0,0,3,44,
240,255,130,64,120,235,163,127,10,0,128,56,0,0,160,56,201,244,255,75,
0,0,128,57,12,0,129,153,120,27,127,124,120,243,195,127,201,124,9,72,
0,0,3,44,24,0,130,65,11,0,96,60,128,237,99,56,185,1,128,56,
0,0,160,56,177,151,255,75,120,251,227,127,28,0,225,131,36,0,1,128,
24,0,193,131,20,0,161,131,166,3,8,124,32,0,33,56,32,0,128,78,
208,255,33,148,16,0,1,147,20,0,33,147,24,0,65,147,28,0,97,147,
32,0,129,147,44,0,225,147,166,2,8,124,52,0,1,144,36,0,161,147,
120,35,157,124,40,0,193,147,120,27,126,124,41,255,255,75,121,27,127,124,
52,0,130,65,28,0,97,131,40,0,193,131,36,0,161,131,24,0,65,131,
32,0,129,131,44,0,225,131,52,0,1,128,20,0,33,131,16,0,1,131,
166,3,8,124,48,0,33,56,32,0,128,78,116,0,30,59,8,0,1,147,
1,0,0,56,12,0,1,152,120,195,31,127,120,251,227,127,255,255,128,56,
81,125,9,72,0,0,3,44,240,255,130,64,11,0,128,63,120,243,195,127,
13,242,255,75,120,243,195,127,5,242,255,75,120,243,195,127,253,241,255,75,
121,27,127,124,96,0,130,65,0,0,96,57,12,0,97,153,120,195,3,127,
193,123,9,72,0,0,3,44,20,0,130,65,192,237,124,56,185,1,128,56,
0,0,160,56,173,150,255,75,24,0,65,131,32,0,129,131,36,0,161,131,
120,251,227,127,44,0,225,131,28,0,97,131,40,0,193,131,52,0,1,128,
20,0,33,131,16,0,1,131,166,3,8,124,48,0,33,56,32,0,128,78,
42,0,222,139,11,0,64,63,11,0,96,63,204,237,123,56,0,238,154,56,
61,245,5,72,11,0,32,63,12,238,121,56,120,243,196,127,45,245,5,72,
116,128,98,56,37,245,5,72,128,255,30,56,4,0,0,40,88,0,128,64,
0,0,29,44,116,0,130,64,129,0,30,44,20,0,130,64,11,0,96,60,
24,238,99,56,253,244,5,72,92,0,0,72,11,0,96,60,68,238,99,56,
237,244,5,72,204,237,123,56,0,238,154,56,225,244,5,72,12,238,121,56,
63,6,196,87,213,244,5,72,116,128,98,56,205,244,5,72,133,3,224,59,
40,0,0,72,11,0,96,60,140,237,99,56,185,244,5,72,12,238,121,56,
120,243,196,127,173,244,5,72,116,128,98,56,165,244,5,72,135,3,224,59,
0,0,128,57,12,0,129,153,120,195,3,127,177,122,9,72,0,0,3,44,
20,0,130,65,192,237,124,56,185,1,128,56,0,0,160,56,157,149,255,75,
24,0,65,131,32,0,129,131,36,0,161,131,120,251,227,127,44,0,225,131,
28,0,97,131,40,0,193,131,52,0,1,128,20,0,33,131,16,0,1,131,
166,3,8,124,48,0,33,56,32,0,128,78,224,255,33,148,166,2,8,124,
36,0,1,144,28,0,225,147,20,0,161,147,120,27,125,124,116,0,253,59,
8,0,225,147,1,0,128,57,12,0,129,153,24,0,193,147,120,251,254,127,
120,243,195,127,255,255,128,56,125,123,9,72,0,0,3,44,240,255,130,64,
120,235,163,127,61,240,255,75,120,235,163,127,53,240,255,75,120,235,163,127,
45,240,255,75,166,0,192,127,94,4,192,87,36,1,0,124,120,235,163,127,
25,240,255,75,120,235,163,127,17,240,255,75,120,235,163,127,9,240,255,75,
0,128,202,115,166,0,0,124,94,4,0,84,120,83,0,124,36,1,0,124,
0,0,0,56,12,0,1,152,120,251,227,127,193,121,9,72,0,0,3,44,
28,0,130,65,11,0,96,60,116,238,99,56,185,1,128,56,0,0,160,56,
169,148,255,75,0,0,3,44,28,0,225,131,36,0,1,128,24,0,193,131,
20,0,161,131,166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,120,35,156,124,24,0,193,147,28,0,225,147,120,27,127,124,
116,0,223,59,8,0,193,147,166,2,8,124,36,0,1,144,1,0,0,56,
12,0,1,152,20,0,161,147,120,243,221,127,120,235,163,127,255,255,128,56,
149,122,9,72,0,0,3,44,240,255,130,64,6,0,159,155,120,251,227,127,
8,0,128,56,1,0,160,56,17,241,255,75,0,0,128,57,12,0,129,153,
120,27,127,124,120,243,195,127,17,121,9,72,0,0,3,44,24,0,130,65,
11,0,96,60,128,238,99,56,185,1,128,56,0,0,160,56,249,147,255,75,
120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,
16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,
20,0,161,147,120,35,157,124,24,0,193,147,16,0,129,147,120,27,124,124,
116,0,220,59,8,0,193,147,166,2,8,124,36,0,1,144,1,0,0,56,
12,0,1,152,28,0,225,147,120,243,223,127,120,251,227,127,255,255,128,56,
225,121,9,72,0,0,3,44,240,255,130,64,6,0,188,155,120,227,131,127,
9,0,128,56,1,0,160,56,93,240,255,75,0,0,0,56,12,0,1,152,
120,27,127,124,120,243,195,127,93,120,9,72,0,0,3,44,24,0,130,65,
11,0,96,60,140,238,99,56,185,1,128,56,0,0,160,56,69,147,255,75,
120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,
16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,
166,2,8,124,36,0,1,144,24,0,193,147,28,0,225,147,120,27,127,124,
116,0,223,59,8,0,193,147,1,0,128,57,12,0,129,153,20,0,161,147,
120,243,221,127,120,235,163,127,255,255,128,56,53,121,9,72,0,0,3,44,
240,255,130,64,4,0,191,56,3,0,0,56,4,0,31,152,5,0,31,152,
0,0,224,56,3,0,159,57,2,0,64,57,166,3,73,125,1,0,12,140,
80,56,224,124,116,7,231,124,244,255,0,66,2,0,229,152,0,0,159,136,
112,0,127,128,36,0,35,129,100,0,73,129,0,0,197,136,166,3,73,125,
33,4,128,78,0,0,0,56,12,0,1,152,120,243,195,127,121,119,9,72,
0,0,3,44,24,0,130,65,11,0,96,60,152,238,99,56,185,1,128,56,
0,0,160,56,97,146,255,75,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,0,0,96,56,166,3,8,124,32,0,33,56,32,0,128,78,
200,255,33,148,32,0,65,147,40,0,129,147,48,0,193,147,52,0,225,147,
166,2,8,124,60,0,1,144,36,0,97,147,120,43,187,124,44,0,161,147,
4,0,59,129,8,129,66,57,0,0,160,59,255,255,169,56,120,35,154,124,
120,27,124,124,120,235,191,127,120,235,190,127,255,255,202,56,1,0,229,140,
1,0,6,141,64,64,7,124,12,0,130,64,0,0,7,40,236,255,130,64,
81,56,8,124,52,0,130,65,4,0,27,129,188,128,34,57,255,255,136,57,
255,255,169,56,1,0,204,140,1,0,229,140,64,56,6,124,12,0,130,64,
0,0,6,40,236,255,130,64,81,48,7,124,96,0,130,64,8,0,123,128,
0,0,128,56,16,0,160,56,253,7,6,72,120,27,127,124,149,220,5,72,
121,27,126,124,64,0,130,64,8,0,155,128,120,251,229,127,11,0,96,60,
0,240,99,56,77,240,5,72,48,0,193,131,40,0,129,131,44,0,161,131,
52,0,225,131,60,0,1,128,36,0,97,131,32,0,65,131,166,3,8,124,
56,0,33,56,32,0,128,78,4,0,251,128,8,129,2,57,255,255,103,57,
255,255,136,57,1,0,171,140,1,0,204,140,64,48,5,124,12,0,130,64,
0,0,5,40,236,255,130,64,81,40,38,125,80,0,130,64,120,227,131,127,
120,243,196,127,62,6,229,87,169,235,255,75,120,27,125,124,11,0,96,60,
164,238,99,56,213,239,5,72,0,0,31,44,16,16,129,64,255,255,158,59,
1,0,156,140,120,128,98,56,189,239,5,72,255,255,255,55,240,255,130,64,
0,0,29,44,12,16,130,64,244,15,0,72,4,0,187,128,188,128,194,56,
255,255,69,57,255,255,102,57,1,0,138,141,1,0,11,140,64,0,12,124,
12,0,130,64,0,0,12,40,236,255,130,64,81,96,0,124,76,0,130,64,
121,251,250,127,40,0,129,64,8,0,123,59,255,255,190,59,4,0,123,132,
0,0,128,56,16,0,160,56,229,6,6,72,255,255,90,55,1,0,125,156,
232,255,130,64,120,227,131,127,120,243,196,127,62,6,229,87,201,236,255,75,
121,27,125,124,148,15,130,64,124,15,0,72,4,0,123,129,11,0,128,61,
255,255,235,56,180,238,140,57,255,255,12,57,1,0,39,141,1,0,72,141,
64,80,9,124,12,0,130,64,0,0,9,40,236,255,130,64,81,72,10,124,
36,0,130,64,169,169,4,72,120,27,125,124,11,0,96,60,44,240,99,56,
233,238,5,72,0,0,29,44,64,15,130,64,40,15,0,72,4,0,59,129,
16,129,66,57,255,255,169,56,255,255,202,56,1,0,229,140,1,0,6,141,
64,64,7,124,12,0,130,64,0,0,7,40,236,255,130,64,81,56,8,124,
52,0,130,65,4,0,27,129,24,129,34,57,255,255,136,57,255,255,169,56,
1,0,204,140,1,0,229,140,64,56,6,124,12,0,130,64,0,0,6,40,
236,255,130,64,81,48,7,124,0,1,130,64,4,0,251,128,24,129,2,57,
255,255,103,57,255,255,136,57,1,0,171,140,1,0,204,140,64,48,5,124,
12,0,130,64,0,0,5,40,236,255,130,64,81,40,38,125,24,0,130,64,
41,0,252,59,11,0,96,60,192,238,99,56,61,238,5,72,20,0,0,72,
76,0,252,59,11,0,96,60,192,238,99,56,41,238,5,72,0,0,64,59,
35,0,96,59,255,255,159,59,1,0,156,140,196,128,98,56,17,238,5,72,
17,0,26,44,20,0,130,64,11,0,96,60,104,239,99,56,34,0,128,56,
249,237,5,72,255,255,123,55,1,0,90,59,212,255,130,64,11,0,96,60,
80,240,99,56,225,237,5,72,0,0,96,59,35,0,128,59,255,255,255,59,
1,0,159,141,224,255,12,56,94,0,0,40,126,0,128,56,8,0,129,65,
120,99,132,125,28,129,98,56,181,237,5,72,17,0,27,44,16,0,130,64,
11,0,96,60,128,239,99,56,161,237,5,72,255,255,156,55,1,0,123,59,
196,255,130,64,204,128,98,56,141,237,5,72,0,0,29,44,228,13,130,64,
204,13,0,72,4,0,251,128,36,129,2,57,255,255,103,57,255,255,136,57,
1,0,171,140,1,0,204,140,64,48,5,124,12,0,130,64,0,0,5,40,
236,255,130,64,81,40,38,125,92,0,130,64,11,0,96,60,104,240,99,56,
69,237,5,72,0,0,64,59,37,0,96,59,3,0,252,59,1,0,159,140,
196,128,98,56,45,237,5,72,20,0,26,44,16,0,130,64,11,0,96,60,
212,238,99,56,25,237,5,72,255,255,123,55,1,0,90,59,216,255,130,64,
204,128,98,56,5,237,5,72,0,0,29,44,92,13,130,64,68,13,0,72,
4,0,187,128,208,128,194,56,255,255,69,57,255,255,102,57,1,0,138,141,
1,0,11,140,64,0,12,124,12,0,130,64,0,0,12,40,236,255,130,64,
81,96,224,124,124,0,130,64,3,0,26,44,32,0,130,65,48,134,141,128,
11,0,96,60,124,240,99,56,177,236,5,72,0,0,29,44,8,13,130,64,
240,12,0,72,8,0,123,128,0,0,128,56,10,0,160,56,33,4,6,72,
120,27,127,124,120,251,228,127,11,0,96,60,232,238,99,56,129,236,5,72,
2,0,31,40,20,0,128,64,0,0,29,44,48,134,237,147,204,12,130,64,
180,12,0,72,11,0,96,60,4,239,99,56,93,236,5,72,0,0,29,44,
180,12,130,64,156,12,0,72,4,0,155,129,44,129,162,56,255,255,12,57,
255,255,37,57,1,0,72,141,1,0,9,140,64,0,10,124,12,0,130,64,
0,0,10,40,236,255,130,64,81,80,192,124,116,0,130,64,35,0,96,56,
69,216,5,72,120,27,126,124,8,0,123,128,0,0,128,56,10,0,160,56,
145,3,6,72,63,6,127,84,60,0,129,64,17,0,0,56,255,255,62,57,
32,0,0,57,166,3,9,125,1,0,9,156,252,255,0,66,120,227,131,127,
120,243,198,127,16,64,128,56,32,0,160,56,33,239,255,75,255,255,255,55,
120,27,125,124,204,255,130,64,120,243,195,127,237,215,5,72,0,0,29,44,
20,12,130,64,252,11,0,72,4,0,123,129,216,128,130,57,255,255,235,56,
255,255,12,57,1,0,39,141,1,0,8,140,64,0,9,124,12,0,130,64,
0,0,9,40,236,255,130,64,81,72,160,124,196,0,130,64,120,227,131,127,
189,231,255,75,0,0,3,44,228,0,130,64,42,0,124,137,128,255,107,57,
62,6,107,85,16,0,11,40,0,0,0,56,16,0,128,64,4,0,11,40,
8,0,128,65,1,0,0,56,63,6,0,84,184,0,130,65,36,0,224,63,
60,183,255,59,44,0,223,128,12,0,230,128,2,0,160,56,8,0,129,56,
120,251,227,127,166,3,233,124,0,0,192,56,120,51,199,124,33,4,128,78,
120,227,131,127,193,239,255,75,5,0,96,60,224,147,99,56,17,128,5,72,
120,251,227,127,8,0,129,56,2,0,160,56,0,0,192,56,217,167,4,72,
228,168,109,128,33,48,0,72,36,0,97,131,44,0,161,131,40,0,129,131,
60,0,1,128,32,0,65,131,52,0,225,131,48,0,193,131,166,3,8,124,
56,0,33,56,32,0,128,78,4,0,155,129,52,129,162,56,255,255,12,57,
255,255,37,57,1,0,72,141,1,0,9,140,64,0,10,124,12,0,130,64,
0,0,10,40,236,255,130,64,81,80,192,124,52,0,130,64,120,227,131,127,
57,239,255,75,48,0,193,131,40,0,129,131,44,0,161,131,52,0,225,131,
60,0,1,128,36,0,97,131,32,0,65,131,166,3,8,124,56,0,33,56,
32,0,128,78,4,0,123,129,11,0,128,61,255,255,235,56,152,239,140,57,
255,255,12,57,1,0,39,141,1,0,72,141,64,80,9,124,12,0,130,64,
0,0,9,40,236,255,130,64,81,72,10,124,144,0,130,64,11,0,96,60,
164,239,99,56,33,234,5,72,166,0,128,127,94,4,133,87,36,1,160,124,
0,0,224,59,52,0,96,56,133,212,5,72,121,27,125,124,12,0,130,65,
245,81,1,72,120,235,191,127,48,0,223,128,20,0,230,128,120,251,227,127,
166,3,233,124,33,4,128,78,0,0,31,44,120,27,125,124,28,0,130,65,
48,0,31,129,12,0,40,129,120,251,227,127,3,0,128,56,166,3,41,125,
33,4,128,78,0,128,138,115,166,0,0,124,94,4,0,84,120,83,0,124,
36,1,0,124,0,0,29,44,4,10,130,64,236,9,0,72,4,0,27,129,
128,128,34,57,255,255,136,57,255,255,169,56,1,0,204,140,1,0,229,140,
64,56,6,124,12,0,130,64,0,0,6,40,236,255,130,64,81,48,71,125,
144,0,130,64,11,0,96,60,152,240,99,56,101,233,5,72,166,0,128,127,
94,4,128,87,36,1,0,124,0,0,224,59,52,0,96,56,201,211,5,72,
121,27,125,124,12,0,130,65,53,77,1,72,120,235,191,127,48,0,159,129,
20,0,172,128,120,251,227,127,166,3,169,124,33,4,128,78,0,0,31,44,
120,27,125,124,28,0,130,65,48,0,223,128,12,0,230,128,120,251,227,127,
3,0,128,56,166,3,233,124,33,4,128,78,0,128,136,115,166,0,32,125,
94,4,41,85,120,67,41,125,36,1,32,125,0,0,29,44,72,9,130,64,
48,9,0,72,4,0,187,128,136,128,194,56,255,255,69,57,255,255,102,57,
1,0,138,141,1,0,11,140,64,0,12,124,12,0,130,64,0,0,12,40,
236,255,130,64,81,96,224,124,24,0,130,64,120,227,131,127,185,237,255,75,
121,27,125,124,4,9,130,64,236,8,0,72,4,0,155,129,168,128,162,56,
255,255,12,57,255,255,37,57,1,0,72,141,1,0,9,140,64,0,10,124,
12,0,130,64,0,0,10,40,236,255,130,64,81,80,192,124,28,0,130,64,
120,227,131,127,0,0,128,56,253,241,255,75,121,27,125,124,188,8,130,64,
164,8,0,72,4,0,123,129,60,129,130,57,255,255,235,56,255,255,12,57,
1,0,39,141,1,0,72,141,64,80,9,124,12,0,130,64,0,0,9,40,
236,255,130,64,81,72,10,124,20,0,130,64,61,47,0,72,121,27,125,124,
124,8,130,64,100,8,0,72,4,0,59,129,144,128,66,57,255,255,169,56,
255,255,202,56,1,0,229,140,1,0,6,141,64,64,7,124,12,0,130,64,
0,0,7,40,236,255,130,64,81,56,8,124,24,0,130,64,120,227,131,127,
161,243,255,75,0,0,29,44,56,8,130,64,32,8,0,72,4,0,27,129,
63,129,34,57,255,255,136,57,255,255,169,56,1,0,204,140,1,0,229,140,
64,56,6,124,12,0,130,64,0,0,6,40,236,255,130,64,81,48,7,124,
20,0,130,64,125,46,0,72,121,27,125,124,248,7,130,64,224,7,0,72,
4,0,251,128,66,129,2,57,255,255,103,57,255,255,136,57,1,0,171,140,
1,0,204,140,64,48,5,124,12,0,130,64,0,0,5,40,236,255,130,64,
81,40,38,125,44,0,130,64,8,0,123,128,0,0,128,56,16,0,160,56,
225,254,5,72,62,6,100,84,120,227,131,127,233,243,255,75,121,27,125,124,
160,7,130,64,136,7,0,72,4,0,187,128,69,129,194,56,255,255,69,57,
255,255,102,57,1,0,138,141,1,0,11,140,64,0,12,124,12,0,130,64,
0,0,12,40,236,255,130,64,81,96,224,124,44,0,130,64,8,0,123,128,
0,0,128,56,16,0,160,56,137,254,5,72,62,6,100,84,120,227,131,127,
69,244,255,75,121,27,125,124,72,7,130,64,48,7,0,72,4,0,155,129,
72,129,162,56,255,255,12,57,255,255,37,57,1,0,72,141,1,0,9,140,
64,0,10,124,12,0,130,64,0,0,10,40,236,255,130,64,81,80,192,124,
24,0,130,64,120,227,131,127,161,239,255,75,121,27,125,124,4,7,130,64,
236,6,0,72,4,0,123,129,224,128,130,57,255,255,235,56,255,255,12,57,
1,0,39,141,1,0,8,140,64,0,9,124,12,0,130,64,0,0,9,40,
236,255,130,64,81,72,160,124,52,0,130,64,8,0,123,128,0,0,128,56,
10,0,160,56,237,253,5,72,0,0,29,44,184,136,237,136,255,255,195,48,
16,25,6,125,122,23,7,81,184,136,237,152,164,6,130,64,140,6,0,72,
4,0,155,129,76,129,162,56,19,0,224,63,255,255,12,57,112,177,255,59,
255,255,37,57,1,0,72,141,1,0,9,140,64,0,10,124,12,0,130,64,
0,0,10,40,236,255,130,64,81,80,192,124,28,0,130,64,120,251,227,127,
0,0,128,56,5,53,0,72,121,27,125,124,84,6,130,64,60,6,0,72,
4,0,123,129,232,128,130,57,255,255,235,56,255,255,12,57,1,0,39,141,
1,0,72,141,64,80,9,124,12,0,130,64,0,0,9,40,236,255,130,64,
81,72,10,124,28,0,130,64,120,251,227,127,5,0,128,56,189,52,0,72,
121,27,125,124,12,6,130,64,244,5,0,72,4,0,59,129,84,129,66,57,
255,255,169,56,255,255,202,56,1,0,229,140,1,0,6,141,64,64,7,124,
12,0,130,64,0,0,7,40,236,255,130,64,81,56,8,124,28,0,130,64,
120,251,227,127,6,0,128,56,117,52,0,72,121,27,125,124,196,5,130,64,
172,5,0,72,4,0,27,129,92,129,34,57,255,255,136,57,255,255,169,56,
1,0,204,140,1,0,229,140,64,56,6,124,12,0,130,64,0,0,6,40,
236,255,130,64,81,48,7,124,32,0,130,64,113,10,9,72,120,27,100,124,
120,251,227,127,245,52,0,72,121,27,125,124,120,5,130,64,96,5,0,72,
4,0,251,128,11,0,0,61,255,255,103,57,196,240,8,57,255,255,136,57,
1,0,171,140,1,0,204,140,64,48,5,124,12,0,130,64,0,0,5,40,
236,255,130,64,81,40,6,124,44,0,130,64,8,0,123,128,0,0,128,56,
10,0,160,56,93,252,5,72,62,6,100,84,120,251,227,127,181,53,0,72,
121,27,125,124,28,5,130,64,4,5,0,72,4,0,187,128,11,0,192,60,
255,255,69,57,212,239,198,56,255,255,102,57,1,0,138,141,1,0,11,140,
64,0,12,124,12,0,130,64,0,0,12,40,236,255,130,64,81,96,224,124,
24,0,130,64,120,251,227,127,133,54,0,72,121,27,125,124,212,4,130,64,
188,4,0,72,4,0,155,129,11,0,160,60,255,255,12,57,208,240,165,56,
255,255,37,57,1,0,72,141,1,0,9,140,64,0,10,124,12,0,130,64,
0,0,10,40,236,255,130,64,81,80,192,124,24,0,130,64,120,251,227,127,
249,54,0,72,0,0,29,44,140,4,130,64,116,4,0,72,4,0,123,129,
152,128,130,57,255,255,235,56,255,255,12,57,1,0,39,141,1,0,72,141,
64,80,9,124,12,0,130,64,0,0,9,40,236,255,130,64,81,72,10,124,
32,0,130,64,184,136,141,136,11,0,96,60,64,239,99,56,233,227,5,72,
0,0,29,44,64,4,130,64,40,4,0,72,4,0,59,129,240,128,66,57,
255,255,169,56,255,255,202,56,1,0,5,140,1,0,6,141,64,64,0,124,
12,0,130,64,0,0,0,40,236,255,130,64,81,0,104,125,68,0,130,64,
166,0,128,127,94,4,128,87,36,1,0,124,134,50,130,124,120,35,131,124,
2,0,127,96,120,251,229,127,134,51,162,124,0,128,128,115,166,0,160,124,
94,4,165,84,120,3,165,124,36,1,160,124,0,0,29,44,208,3,130,64,
184,3,0,72,4,0,91,129,248,128,98,57,255,255,202,56,255,255,235,56,
1,0,6,140,1,0,39,141,64,72,0,124,12,0,130,64,0,0,0,40,
236,255,130,64,81,0,9,124,68,0,130,64,166,0,224,127,94,4,224,87,
36,1,0,124,134,50,130,124,120,35,131,124,251,7,124,84,120,227,133,127,
134,51,162,124,0,128,233,115,166,0,0,124,94,4,0,84,120,75,0,124,
36,1,0,124,0,0,29,44,96,3,130,64,72,3,0,72,4,0,251,128,
0,129,2,57,255,255,103,57,255,255,136,57,1,0,171,140,1,0,12,140,
64,0,5,124,12,0,130,64,0,0,5,40,236,255,130,64,81,40,32,125,
28,0,130,64,2,0,128,56,0,0,132,60,134,51,128,124,0,0,29,44,
24,3,130,64,0,3,0,72,4,0,187,128,172,128,194,56,255,255,69,57,
255,255,102,57,1,0,138,141,1,0,11,140,64,0,12,124,12,0,130,64,
0,0,12,40,236,255,130,64,81,96,224,124,24,0,130,64,120,227,131,127,
133,240,255,75,121,27,125,124,212,2,130,64,188,2,0,72,4,0,155,129,
100,129,162,56,255,255,12,57,255,255,37,57,1,0,72,141,1,0,9,140,
64,0,10,124,12,0,130,64,0,0,10,40,236,255,130,64,81,80,0,124,
20,0,130,64,137,40,0,72,121,27,125,124,148,2,130,64,124,2,0,72,
4,0,123,129,103,129,130,57,255,255,235,56,255,255,12,57,1,0,39,141,
1,0,8,140,64,0,9,124,12,0,130,64,0,0,9,40,236,255,130,64,
81,72,0,124,72,0,130,64,8,0,123,128,0,0,128,56,16,0,160,56,
125,249,5,72,62,4,127,84,12,0,123,128,0,0,128,56,16,0,160,56,
105,249,5,72,16,0,219,128,120,27,101,124,120,251,228,127,120,227,131,127,
25,229,255,75,121,27,125,124,32,2,130,64,8,2,0,72,4,0,59,129,
106,129,66,57,255,255,169,56,255,255,202,56,1,0,5,140,1,0,6,141,
64,64,0,124,12,0,130,64,0,0,0,40,236,255,130,64,81,0,8,124,
28,0,130,64,1,0,96,56,106,129,130,56,173,18,0,72,121,27,125,124,
216,1,130,64,192,1,0,72,4,0,27,129,112,129,34,57,255,255,136,57,
255,255,169,56,1,0,204,140,1,0,229,140,64,56,6,124,12,0,130,64,
0,0,6,40,236,255,130,64,81,48,7,124,28,0,130,64,1,0,96,56,
112,129,130,56,101,18,0,72,121,27,125,124,144,1,130,64,120,1,0,72,
4,0,27,129,120,129,34,57,255,255,136,57,255,255,169,56,1,0,204,140,
1,0,229,140,64,56,6,124,12,0,130,64,0,0,6,40,236,255,130,64,
81,48,7,124,32,0,130,64,28,128,141,128,11,0,96,60,224,239,99,56,
237,224,5,72,0,0,29,44,68,1,130,64,44,1,0,72,4,0,251,128,
176,128,2,57,255,255,103,57,255,255,136,57,1,0,171,140,1,0,204,140,
64,48,5,124,12,0,130,64,0,0,5,40,236,255,130,64,81,40,38,125,
84,0,130,64,11,0,64,61,80,239,74,57,4,0,138,129,8,0,129,145,
8,0,10,128,12,0,1,144,12,0,170,128,16,0,161,144,16,0,202,128,
20,0,193,144,20,0,234,128,3,0,128,56,6,0,96,56,8,0,161,56,
20,0,192,56,24,0,225,144,173,91,4,72,121,27,125,124,196,0,130,64,
172,0,0,72,4,0,155,129,180,128,162,56,255,255,12,57,255,255,37,57,
1,0,72,141,1,0,9,140,64,0,10,124,12,0,130,64,0,0,10,40,
236,255,130,64,81,80,0,124,92,0,130,64,8,0,97,56,0,0,128,56,
20,0,160,56,53,124,255,75,6,0,96,56,3,0,128,56,8,0,161,56,
20,0,192,56,149,90,4,72,120,27,125,124,128,129,98,56,1,224,5,72,
20,0,128,59,7,0,225,59,1,0,159,140,184,128,98,56,237,223,5,72,
255,255,156,55,240,255,130,64,0,0,29,44,60,0,130,64,36,0,0,72,
11,0,96,60,220,240,99,56,205,223,5,72,0,0,30,44,80,0,130,65,
68,0,0,72,0,0,29,44,24,0,130,64,160,128,98,56,177,223,5,72,
0,0,30,44,52,0,130,65,40,0,0,72,120,235,163,127,153,143,3,72,
120,235,164,127,120,27,101,124,11,0,96,60,0,241,99,56,137,223,5,72,
0,0,30,44,12,0,130,65,120,243,195,127,169,203,5,72,48,0,193,131,
40,0,129,131,44,0,161,131,52,0,225,131,60,0,1,128,36,0,97,131,
32,0,65,131,166,3,8,124,56,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,117,219,255,75,121,27,127,124,112,1,130,64,42,0,94,137,
128,255,138,57,62,6,140,85,16,0,12,40,0,0,0,56,16,0,128,64,
4,0,12,40,8,0,128,65,1,0,0,56,63,6,0,84,88,0,130,64,
112,255,10,56,3,0,0,40,56,0,128,64,120,243,195,127,125,218,255,75,
12,0,160,63,120,27,126,124,164,247,125,56,120,243,197,127,136,129,130,56,
209,212,5,72,164,247,157,56,11,0,96,60,32,241,99,56,193,222,5,72,
72,0,0,72,11,0,96,60,76,241,99,56,177,222,5,72,129,3,224,59,
240,0,0,72,120,243,195,127,53,218,255,75,12,0,160,63,120,27,126,124,
164,247,125,56,120,243,197,127,136,129,130,56,137,212,5,72,164,247,157,56,
11,0,96,60,32,241,99,56,121,222,5,72,127,7,203,87,32,0,130,65,
4,0,11,40,152,0,128,65,48,0,130,65,6,0,11,40,68,0,128,65,
92,0,130,65,132,0,0,72,11,0,128,60,140,229,132,56,127,7,197,87,
11,0,96,60,52,241,99,56,61,222,5,72,128,0,0,72,11,0,128,60,
196,229,132,56,127,7,197,87,11,0,96,60,52,241,99,56,33,222,5,72,
100,0,0,72,11,0,128,60,244,229,132,56,127,7,197,87,11,0,96,60,
52,241,99,56,5,222,5,72,72,0,0,72,9,1,204,87,11,0,128,60,
156,229,132,56,40,0,130,64,11,0,128,60,20,230,132,56,127,7,197,87,
11,0,96,60,52,241,99,56,217,221,5,72,28,0,0,72,11,0,128,60,
44,230,132,56,127,7,197,87,11,0,96,60,52,241,99,56,189,221,5,72,
120,251,227,127,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,216,255,33,148,28,0,161,147,
20,0,97,147,120,35,155,124,24,0,129,147,32,0,193,147,120,27,126,124,
116,0,158,59,8,0,129,147,166,2,8,124,44,0,1,144,1,0,0,56,
12,0,1,152,36,0,225,147,120,227,159,127,120,251,227,127,255,255,128,56,
201,100,9,72,0,0,3,44,240,255,130,64,11,0,160,63,120,243,195,127,
133,217,255,75,121,27,127,124,84,0,130,65,0,0,96,57,12,0,97,153,
120,227,131,127,73,99,9,72,0,0,3,44,20,0,130,65,104,241,125,56,
185,1,128,56,0,0,160,56,53,126,255,75,120,251,227,127,36,0,225,131,
28,0,161,131,32,0,193,131,44,0,1,128,24,0,129,131,20,0,97,131,
166,3,8,124,40,0,33,56,32,0,128,78,42,0,254,136,128,255,7,56,
62,6,0,84,16,0,0,40,0,0,64,57,16,0,128,64,4,0,0,40,
8,0,128,65,1,0,64,57,63,6,74,85,40,0,130,64,112,255,7,57,
3,0,8,40,20,0,128,64,120,243,195,127,61,216,255,75,0,0,123,144,
24,0,0,72,139,3,224,59,16,0,0,72,120,243,195,127,37,216,255,75,
0,0,123,144,0,0,128,57,12,0,129,153,120,227,131,127,157,98,9,72,
0,0,3,44,20,0,130,65,104,241,125,56,185,1,128,56,0,0,160,56,
137,125,255,75,120,251,227,127,36,0,225,131,28,0,161,131,32,0,193,131,
44,0,1,128,24,0,129,131,20,0,97,131,166,3,8,124,40,0,33,56,
32,0,128,78,224,255,33,148,166,2,8,124,36,0,1,144,16,0,129,147,
120,35,156,124,20,0,161,147,28,0,225,147,120,27,127,124,116,0,191,59,
8,0,161,147,1,0,96,57,12,0,97,153,24,0,193,147,120,235,190,127,
120,243,195,127,255,255,128,56,109,99,9,72,0,0,3,44,240,255,130,64,
11,0,192,63,120,251,227,127,41,216,255,75,0,0,3,44,84,0,130,65,
0,0,128,57,12,0,129,153,120,27,127,124,120,235,163,127,233,97,9,72,
0,0,3,44,20,0,130,65,116,241,126,56,185,1,128,56,0,0,160,56,
213,124,255,75,120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
42,0,31,136,120,235,163,127,0,0,28,152,0,0,0,56,12,0,1,152,
149,97,9,72,0,0,3,44,20,0,130,65,116,241,126,56,185,1,128,56,
0,0,160,56,129,124,255,75,28,0,225,131,24,0,193,131,20,0,161,131,
36,0,1,128,16,0,129,131,0,0,96,56,166,3,8,124,32,0,33,56,
32,0,128,78,224,255,33,148,24,0,193,147,20,0,161,147,120,27,125,124,
116,0,221,59,8,0,193,147,166,2,8,124,36,0,1,144,1,0,0,56,
12,0,1,152,28,0,225,147,120,243,223,127,120,251,227,127,255,255,128,56,
113,98,9,72,0,0,3,44,240,255,130,64,120,235,163,127,6,0,128,56,
0,0,160,56,241,216,255,75,0,0,128,57,12,0,129,153,120,27,127,124,
120,243,195,127,241,96,9,72,0,0,3,44,24,0,130,65,11,0,96,60,
140,241,99,56,185,1,128,56,0,0,160,56,217,123,255,75,120,251,227,127,
28,0,225,131,36,0,1,128,24,0,193,131,20,0,161,131,166,3,8,124,
32,0,33,56,32,0,128,78,208,255,33,148,40,0,193,147,120,35,158,124,
44,0,225,147,120,43,191,124,24,0,65,147,120,51,218,124,28,0,97,147,
120,59,251,124,32,0,129,147,36,0,161,147,120,27,125,124,116,0,157,59,
8,0,129,147,166,2,8,124,52,0,1,144,1,0,0,56,12,0,1,152,
20,0,33,147,120,227,153,127,120,203,35,127,255,255,128,56,173,97,9,72,
0,0,3,44,240,255,130,64,120,235,163,127,255,6,200,87,96,0,136,56,
116,7,132,124,0,0,160,56,37,216,255,75,121,27,126,124,80,0,130,64,
121,251,230,127,0,0,224,56,68,0,129,64,76,0,93,57,166,3,201,124,
0,0,27,44,24,0,130,64,20,58,106,125,2,0,11,136,0,0,26,152,
1,0,90,59,20,0,0,72,20,250,170,124,1,0,5,136,0,0,26,152,
1,0,90,59,255,255,255,59,1,0,231,56,204,255,0,66,0,0,128,57,
12,0,129,153,120,227,131,127,213,95,9,72,0,0,3,44,24,0,130,65,
11,0,96,60,152,241,99,56,185,1,128,56,0,0,160,56,189,122,255,75,
36,0,161,131,120,243,195,127,40,0,193,131,28,0,97,131,32,0,129,131,
44,0,225,131,52,0,1,128,24,0,65,131,20,0,33,131,166,3,8,124,
48,0,33,56,32,0,128,78,208,255,33,148,40,0,193,147,120,43,190,124,
32,0,30,44,20,0,33,147,36,0,161,147,166,2,8,124,52,0,1,144,
24,0,65,147,120,27,122,124,28,0,97,147,120,35,155,124,44,0,225,147,
120,51,223,124,32,0,129,147,120,59,252,124,40,0,129,64,28,0,97,131,
40,0,193,131,44,0,225,131,32,0,129,131,24,0,65,131,166,3,8,124,
15,1,96,56,48,0,33,56,32,0,128,78,116,0,186,59,8,0,161,147,
1,0,0,56,12,0,1,152,120,235,185,127,120,203,35,127,255,255,128,56,
85,96,9,72,0,0,3,44,240,255,130,64,121,243,198,127,60,0,129,64,
255,255,126,57,20,90,255,124,5,0,58,57,166,3,201,124,0,0,28,44,
16,0,130,64,0,0,95,137,1,0,73,157,12,0,0,72,0,0,71,137,
1,0,73,157,255,255,231,56,1,0,255,59,220,255,0,66,120,211,67,127,
255,6,108,87,64,0,140,56,116,7,132,124,116,7,197,127,141,214,255,75,
0,0,128,57,12,0,129,153,120,27,127,124,120,235,163,127,141,94,9,72,
0,0,3,44,24,0,130,65,11,0,96,60,164,241,99,56,185,1,128,56,
0,0,160,56,117,121,255,75,28,0,97,131,36,0,161,131,120,251,227,127,
44,0,225,131,32,0,129,131,40,0,193,131,52,0,1,128,24,0,65,131,
20,0,33,131,166,3,8,124,48,0,33,56,32,0,128,78,224,255,33,148,
24,0,193,147,20,0,161,147,120,27,125,124,116,0,221,59,8,0,193,147,
166,2,8,124,36,0,1,144,1,0,0,56,12,0,1,152,28,0,225,147,
120,243,223,127,120,251,227,127,255,255,128,56,89,95,9,72,0,0,3,44,
240,255,130,64,120,235,163,127,2,0,128,56,0,0,160,56,217,213,255,75,
0,0,128,57,12,0,129,153,120,27,127,124,120,243,195,127,217,93,9,72,
0,0,3,44,24,0,130,65,11,0,96,60,176,241,99,56,185,1,128,56,
0,0,160,56,193,120,255,75,120,251,227,127,28,0,225,131,36,0,1,128,
24,0,193,131,20,0,161,131,166,3,8,124,32,0,33,56,32,0,128,78,
224,255,33,148,24,0,193,147,20,0,161,147,120,27,125,124,116,0,221,59,
8,0,193,147,166,2,8,124,36,0,1,144,1,0,0,56,12,0,1,152,
28,0,225,147,120,243,223,127,120,251,227,127,255,255,128,56,181,94,9,72,
0,0,3,44,240,255,130,64,120,235,163,127,1,0,128,56,0,0,160,56,
53,213,255,75,0,0,128,57,12,0,129,153,120,27,127,124,120,243,195,127,
53,93,9,72,0,0,3,44,24,0,130,65,11,0,96,60,188,241,99,56,
185,1,128,56,0,0,160,56,29,120,255,75,120,251,227,127,28,0,225,131,
36,0,1,128,24,0,193,131,20,0,161,131,166,3,8,124,32,0,33,56,
32,0,128,78,224,255,33,148,24,0,193,147,20,0,161,147,120,27,125,124,
116,0,221,59,8,0,193,147,166,2,8,124,36,0,1,144,1,0,0,56,
12,0,1,152,28,0,225,147,120,243,223,127,120,251,227,127,255,255,128,56,
17,94,9,72,0,0,3,44,240,255,130,64,120,235,163,127,0,0,128,56,
120,35,133,124,145,212,255,75,0,0,128,57,12,0,129,153,120,27,127,124,
120,243,195,127,145,92,9,72,0,0,3,44,24,0,130,65,11,0,96,60,
200,241,99,56,185,1,128,56,0,0,160,56,121,119,255,75,120,251,227,127,
28,0,225,131,36,0,1,128,24,0,193,131,20,0,161,131,166,3,8,124,
32,0,33,56,32,0,128,78,116,0,99,56,144,129,130,56,1,0,160,56,
8,3,4,72,240,255,33,148,0,0,3,44,166,2,8,124,20,0,1,144,
8,0,193,147,120,35,158,124,12,0,225,147,120,43,191,124,20,0,130,64,
152,0,96,56,117,192,5,72,0,0,3,44,24,0,130,65,0,0,195,155,
0,0,0,56,2,0,3,176,112,0,227,147,148,0,3,152,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,19,0,96,60,112,177,99,56,
81,41,0,72,239,0,0,56,32,134,13,152,0,0,128,57,36,134,141,145,
40,134,13,152,44,134,141,145,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,239,0,32,57,8,0,33,153,11,0,96,60,
76,242,99,56,89,213,5,72,28,0,96,60,240,85,99,56,29,255,255,75,
184,136,173,136,192,136,13,128,72,0,165,112,0,0,0,44,0,0,128,57,
48,134,141,145,184,136,173,152,16,0,130,64,188,136,13,144,191,0,166,112,
184,136,205,152,19,0,96,60,112,177,99,56,53,40,0,72,0,64,64,61,
36,134,77,145,31,0,224,63,128,132,255,59,96,239,96,60,28,7,99,56,
0,0,99,128,255,191,103,84,12,0,130,64,255,255,255,55,232,255,130,64,
2,0,128,56,0,0,132,60,134,51,128,124,31,0,224,63,128,132,255,59,
96,239,96,60,28,7,99,56,0,0,99,128,255,191,105,84,12,0,130,64,
255,255,255,55,232,255,130,64,0,0,31,44,52,0,130,64,11,0,96,60,
24,242,99,56,165,212,5,72,0,0,64,57,184,136,77,153,20,0,225,131,
28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,
32,0,128,78,0,0,160,59,28,0,192,63,240,85,222,59,120,243,195,127,
8,0,129,56,49,248,255,75,121,27,127,124,60,0,130,65,65,2,31,44,
96,0,130,64,33,128,109,137,0,0,11,44,84,0,130,65,11,0,96,60,
212,241,99,56,65,212,5,72,120,243,195,127,233,216,255,75,1,0,189,59,
3,0,29,44,188,255,128,65,60,0,0,72,8,0,225,136,128,255,135,57,
19,0,12,40,120,251,224,127,20,0,128,64,0,0,31,44,0,0,64,57,
76,0,130,64,36,0,0,72,63,6,0,84,16,0,130,64,1,0,189,59,
3,0,29,44,128,255,128,65,0,0,31,44,0,0,64,57,40,0,130,64,
8,0,129,137,128,255,12,56,19,0,0,40,12,0,128,64,1,0,64,57,
16,0,0,72,63,6,255,87,8,0,130,65,1,0,64,57,184,136,173,136,
62,6,74,85,188,15,69,81,189,7,166,84,184,136,173,152,44,0,130,65,
11,0,96,60,12,242,99,56,157,211,5,72,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
11,0,96,60,252,241,99,56,117,211,5,72,0,0,0,57,184,136,13,153,
9,0,1,153,36,0,96,60,116,188,99,56,9,0,129,56,1,0,160,56,
221,79,4,72,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,200,255,33,148,28,0,33,147,
32,0,65,147,36,0,97,147,40,0,129,147,44,0,161,147,48,0,193,147,
52,0,225,147,166,2,8,124,60,0,1,144,5,0,3,136,6,0,67,137,
7,0,227,139,0,0,195,139,4,0,131,137,1,0,35,137,16,0,129,56,
8,0,99,59,36,0,128,63,15,0,225,155,1,0,160,56,13,0,1,152,
16,0,161,152,46,64,95,81,12,0,129,153,221,0,0,56,11,0,1,152,
116,188,124,56,14,0,65,153,170,0,64,57,10,0,65,153,8,0,33,153,
62,4,255,87,9,0,193,155,46,64,62,81,62,4,222,87,45,79,4,72,
152,129,226,136,19,0,225,152,153,129,2,136,19,0,193,56,28,0,32,63,
2,64,128,56,2,0,160,56,20,0,1,152,240,85,121,56,205,213,255,75,
121,27,125,124,32,0,130,65,0,0,0,56,17,0,1,152,17,0,129,56,
116,188,124,56,1,0,160,56,229,78,4,72,144,0,0,72,0,0,31,44,
88,0,130,65,32,0,31,44,120,251,250,127,8,0,129,64,32,0,64,59,
255,6,198,87,12,0,130,65,255,6,192,87,32,0,64,35,240,85,121,56,
120,243,196,127,120,211,69,127,120,219,102,127,109,213,255,75,121,27,125,124,
52,0,130,64,20,210,222,127,80,248,250,127,63,4,255,87,62,4,222,87,
20,210,123,127,176,255,130,64,240,85,121,56,0,64,128,56,8,0,160,56,
8,0,193,56,57,213,255,75,120,27,125,124,0,0,32,57,18,0,33,153,
18,0,129,56,116,188,124,56,1,0,160,56,85,78,4,72,48,0,193,131,
36,0,97,131,40,0,129,131,120,235,163,127,44,0,161,131,52,0,225,131,
60,0,1,128,32,0,65,131,28,0,33,131,166,3,8,124,56,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,239,0,64,57,
8,0,65,153,12,0,225,147,28,0,224,63,240,85,127,56,41,214,255,75,
5,0,96,60,224,147,99,56,121,102,5,72,240,85,127,56,8,0,129,56,
41,245,255,75,240,85,127,56,8,0,129,56,29,245,255,75,240,85,127,56,
8,0,129,56,17,245,255,75,0,0,3,44,220,0,130,64,8,0,1,137,
128,255,40,57,62,6,41,85,16,0,9,40,120,27,107,124,0,0,128,57,
20,0,128,64,4,0,9,40,0,0,0,56,28,0,128,65,44,0,0,72,
63,6,140,85,48,0,130,65,4,0,9,40,0,0,0,56,24,0,128,64,
63,6,107,85,11,0,224,63,248,242,255,59,104,0,130,65,32,0,0,72,
63,6,0,84,8,0,130,64,1,0,96,57,63,6,107,85,11,0,224,63,
248,242,255,59,72,0,130,65,137,0,8,44,100,0,130,65,11,0,96,60,
136,242,99,56,189,208,5,72,11,0,96,60,184,242,99,56,11,0,128,60,
236,242,132,56,169,208,5,72,8,0,129,136,120,251,227,127,157,208,5,72,
154,129,98,56,149,208,5,72,132,3,96,56,40,0,0,72,11,0,96,60,
96,242,99,56,129,208,5,72,8,0,129,136,120,251,227,127,117,208,5,72,
154,129,98,56,109,208,5,72,136,3,96,56,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,17,253,255,75,0,0,3,44,8,0,130,64,161,254,255,75,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,40,128,109,129,
36,128,141,128,120,27,126,124,16,0,0,57,255,255,235,56,0,0,224,59,
166,3,9,125,255,255,196,56,1,0,38,141,1,0,71,141,81,72,10,124,
16,0,130,64,0,0,9,44,8,0,130,65,232,255,0,66,0,0,0,44,
52,0,129,64,11,0,96,60,4,243,99,56,197,207,5,72,28,0,96,60,
240,85,99,56,0,0,128,56,77,217,255,75,121,27,127,124,68,0,130,64,
120,243,195,127,85,255,255,75,60,0,0,72,36,0,96,60,4,183,99,56,
8,0,129,56,1,0,160,56,0,0,192,56,120,51,199,124,85,142,4,72,
0,0,3,44,16,0,130,65,8,0,1,136,129,0,0,44,8,0,130,65,
133,3,224,59,120,251,227,127,28,0,1,128,20,0,225,131,16,0,193,131,
166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,0,0,96,56,255,255,4,57,
156,129,130,57,255,255,44,57,1,0,72,141,1,0,9,140,64,0,10,124,
12,0,130,64,0,0,10,40,236,255,130,64,81,80,0,124,28,0,130,64,
28,0,96,60,240,85,99,56,1,0,128,56,149,216,255,75,0,0,3,44,
12,0,130,64,120,251,227,127,185,251,255,75,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,192,255,33,148,48,0,129,147,
60,0,225,147,166,2,8,124,68,0,1,144,52,0,161,147,120,27,125,124,
8,0,97,56,56,0,193,147,120,35,158,124,137,136,128,60,136,136,132,56,
253,155,3,72,8,0,97,56,113,185,3,72,0,0,3,44,52,0,130,64,
11,0,96,60,40,243,99,56,137,206,5,72,60,0,225,131,56,0,193,131,
52,0,161,131,68,0,1,128,48,0,129,131,0,0,96,56,166,3,8,124,
64,0,33,56,32,0,128,78,8,0,97,56,49,145,3,72,120,27,127,124,
129,186,5,72,121,27,124,124,112,0,130,65,120,227,132,127,120,251,229,127,
8,0,97,56,0,0,192,56,120,51,199,124,129,152,3,72,121,27,127,124,
228,1,130,64,36,128,109,128,0,0,3,44,24,0,130,64,17,0,96,56,
69,186,5,72,0,0,3,44,36,128,109,144,48,0,130,65,0,0,128,56,
17,0,160,56,21,106,255,75,40,128,109,128,0,0,3,44,60,0,130,64,
17,0,96,56,25,186,5,72,0,0,3,44,40,128,109,144,40,0,130,64,
60,0,225,131,56,0,193,131,52,0,161,131,68,0,1,128,48,0,129,131,
16,1,96,56,166,3,8,124,64,0,33,56,32,0,128,78,0,0,128,56,
17,0,160,56,197,105,255,75,8,0,97,56,125,144,3,72,36,128,205,128,
120,27,101,124,120,227,132,127,8,0,97,56,149,183,3,72,0,0,3,44,
60,0,130,64,11,0,96,60,120,243,99,56,129,205,5,72,36,128,109,128,
169,185,5,72,60,0,225,131,56,0,193,131,52,0,161,131,68,0,1,128,
48,0,129,131,128,3,96,56,166,3,8,124,64,0,33,56,32,0,128,78,
0,0,29,44,72,0,130,64,40,128,141,128,0,0,192,56,36,0,96,60,
16,0,160,56,4,181,99,56,120,51,199,124,1,140,4,72,0,0,3,44,
20,0,130,64,11,0,96,60,168,243,99,56,29,205,5,72,20,0,0,72,
40,128,141,128,11,0,96,60,96,243,99,56,9,205,5,72,255,255,126,57,
168,129,130,57,255,255,140,57,1,0,11,140,1,0,76,141,64,80,0,124,
12,0,130,64,0,0,0,40,236,255,130,64,81,0,10,124,36,0,130,64,
120,227,131,127,120,235,164,127,8,0,161,56,169,252,255,75,120,27,127,124,
120,227,131,127,241,184,5,72,124,0,0,72,255,255,190,56,160,129,34,57,
255,255,201,56,1,0,229,140,1,0,6,141,64,64,7,124,12,0,130,64,
0,0,7,40,236,255,130,64,81,56,8,124,36,128,141,128,40,0,130,64,
11,0,96,60,200,243,99,56,129,204,5,72,120,227,131,127,41,252,255,75,
120,27,127,124,120,227,131,127,157,184,5,72,40,0,0,72,11,0,96,60,
244,243,99,56,93,204,5,72,120,227,131,127,120,243,196,127,5,253,255,75,
120,27,127,124,120,227,131,127,117,184,5,72,120,251,227,127,60,0,225,131,
56,0,193,131,68,0,1,128,52,0,161,131,48,0,129,131,166,3,8,124,
64,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,
24,0,193,147,28,0,225,147,166,2,8,124,36,0,1,144,184,136,141,137,
239,0,0,56,184,7,140,85,134,3,224,59,8,0,1,152,189,7,128,85,
0,0,160,59,184,136,141,153,192,2,130,65,28,0,128,63,240,85,124,56,
8,0,129,56,153,239,255,75,240,85,124,56,8,0,129,56,141,239,255,75,
240,85,124,56,8,0,129,56,129,239,255,75,121,27,127,124,116,2,130,64,
8,0,1,137,128,255,200,56,62,6,198,84,4,0,6,40,11,0,192,63,
72,0,128,64,240,85,124,56,65,208,255,75,5,0,96,60,224,147,99,56,
145,96,5,72,240,85,124,56,8,0,129,56,65,239,255,75,240,85,124,56,
8,0,129,56,53,239,255,75,240,85,124,56,8,0,129,56,41,239,255,75,
121,27,127,124,28,2,130,64,76,0,0,72,63,6,255,87,232,0,130,65,
240,85,124,56,245,207,255,75,5,0,96,60,224,147,99,56,69,96,5,72,
240,85,124,56,8,0,129,56,245,238,255,75,240,85,124,56,8,0,129,56,
233,238,255,75,240,85,124,56,8,0,129,56,221,238,255,75,121,27,127,124,
208,1,130,64,8,0,1,137,128,255,200,56,62,6,198,84,4,0,6,40,
120,251,234,127,16,0,128,64,129,0,8,44,48,0,130,64,20,0,0,72,
63,6,74,85,116,0,130,65,129,0,8,44,28,0,130,64,1,0,96,56,
176,129,130,56,249,251,255,75,121,27,127,124,136,1,130,64,104,1,0,72,
11,0,96,60,68,244,99,56,181,202,5,72,11,0,96,60,40,244,99,56,
169,202,5,72,8,0,129,136,116,244,126,56,157,202,5,72,184,129,98,56,
149,202,5,72,184,136,13,136,11,0,96,60,20,245,99,56,184,7,0,84,
133,3,224,59,120,251,228,127,184,136,13,152,117,202,5,72,80,1,0,72,
0,0,29,44,16,1,130,64,16,0,6,40,0,0,32,57,20,0,128,64,
4,0,6,40,0,0,96,57,28,0,128,65,36,0,0,72,63,6,41,85,
40,0,130,65,4,0,6,40,0,0,96,57,16,0,128,64,63,6,172,87,
28,0,130,65,56,0,0,72,63,6,107,85,8,0,130,64,1,0,160,59,
63,6,172,87,36,0,130,64,112,255,8,56,3,0,0,40,16,0,128,64,
137,0,8,44,48,0,130,64,20,0,0,72,63,6,140,85,112,0,130,65,
137,0,8,44,28,0,130,64,0,0,96,56,188,129,130,56,17,251,255,75,
121,27,127,124,160,0,130,64,128,0,0,72,11,0,96,60,68,245,99,56,
205,201,5,72,11,0,96,60,128,244,99,56,11,0,128,60,180,244,132,56,
185,201,5,72,8,0,129,136,116,244,126,56,173,201,5,72,184,129,98,56,
165,201,5,72,1,0,96,56,188,129,130,56,197,250,255,75,121,27,127,124,
84,0,130,64,52,0,0,72,11,0,96,60,192,244,99,56,129,201,5,72,
184,136,13,136,11,0,96,60,20,245,99,56,184,7,0,84,142,3,224,59,
120,251,228,127,184,136,13,152,97,201,5,72,60,0,0,72,184,136,237,136,
4,0,231,96,11,0,96,60,244,244,99,56,184,136,237,152,69,201,5,72,
32,0,0,72,184,136,13,136,11,0,96,60,184,7,0,84,120,251,228,127,
20,245,99,56,184,136,13,152,37,201,5,72,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,184,136,141,137,189,7,140,85,130,3,224,59,96,0,130,65,
19,0,128,61,128,177,140,137,116,7,140,125,6,0,12,44,72,0,130,65,
28,0,96,60,240,85,99,56,73,241,255,75,121,27,127,124,24,0,130,65,
120,251,228,127,11,0,96,60,168,245,99,56,169,200,5,72,36,0,0,72,
11,0,96,60,148,245,99,56,153,200,5,72,184,136,13,136,118,7,0,84,
184,136,13,152,8,0,0,72,140,3,224,59,20,0,1,128,120,251,227,127,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,216,255,33,148,
12,0,33,147,16,0,65,147,20,0,97,147,24,0,129,147,28,0,161,147,
32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,34,128,45,137,
0,0,9,44,0,0,0,57,8,0,1,145,16,0,130,64,184,136,109,137,
250,7,107,85,184,136,109,153,184,136,13,136,189,7,0,84,19,0,224,63,
112,177,255,59,32,0,130,64,16,0,159,137,116,7,140,125,5,0,12,44,
0,0,64,57,1,0,0,56,96,4,130,64,104,4,0,72,2,0,128,56,
0,0,132,60,134,51,128,124,166,0,160,127,94,4,160,87,36,1,0,124,
134,50,130,124,120,35,131,124,2,0,126,96,120,243,197,127,134,51,162,124,
0,128,172,115,166,0,0,124,94,4,0,84,120,99,0,124,36,1,0,124,
11,0,96,60,192,246,99,56,169,199,5,72,28,0,128,63,240,85,156,59,
120,227,131,127,77,232,255,75,120,251,227,127,85,26,0,72,16,0,159,137,
116,7,140,125,5,0,12,44,1,0,32,57,16,0,130,65,6,0,12,44,
8,0,130,65,0,0,32,57,63,6,41,85,11,0,160,63,252,245,189,59,
40,0,130,64,9,0,12,44,32,0,130,65,11,0,96,60,140,246,99,56,
77,199,5,72,45,251,255,75,121,27,121,124,68,2,130,64,56,2,0,72,
11,0,96,60,168,246,99,56,49,199,5,72,120,227,131,127,8,0,129,56,
141,233,255,75,124,134,109,139,121,27,121,124,116,7,123,127,0,0,64,59,
84,0,130,65,139,3,25,44,56,0,130,65,11,0,96,60,212,245,99,56,
253,198,5,72,120,235,163,127,120,203,36,127,241,198,5,72,184,136,173,136,
184,7,165,84,62,6,160,84,255,247,9,84,184,136,173,152,192,2,130,65,
228,1,0,72,11,0,96,60,216,246,99,56,139,3,128,56,197,198,5,72,
96,1,0,72,8,0,1,128,9,1,6,84,1,0,192,59,0,0,96,57,
20,0,130,64,127,7,7,84,6,0,7,44,8,0,130,64,1,0,96,57,
63,6,107,85,28,0,130,64,127,7,6,84,4,0,6,44,16,0,130,65,
0,0,6,44,8,0,130,65,0,0,192,59,3,0,27,44,62,6,222,87,
56,0,130,64,0,0,30,44,208,0,130,64,11,0,96,60,4,247,99,56,
93,198,5,72,11,0,96,60,56,247,99,56,216,0,128,56,0,0,160,56,
109,103,255,75,0,0,26,44,68,1,130,65,220,0,0,72,0,0,30,44,
1,0,192,59,20,0,130,64,127,7,8,84,5,0,8,44,8,0,130,65,
0,0,192,59,62,6,222,87,120,219,100,127,11,0,96,60,44,246,99,56,
13,198,5,72,1,0,27,44,36,0,130,64,8,0,65,129,127,7,73,85,
5,0,9,44,20,0,130,65,11,0,96,60,68,247,99,56,233,197,5,72,
132,0,0,72,0,0,30,44,20,0,130,64,11,0,96,60,60,246,99,56,
209,197,5,72,108,0,0,72,8,0,129,129,127,7,139,85,5,0,11,44,
28,0,130,64,120,227,131,127,153,237,255,75,184,136,13,136,8,0,0,96,
120,27,121,124,184,136,13,152,0,0,25,44,28,0,130,64,0,0,26,44,
184,136,13,136,4,0,0,96,184,136,13,152,140,0,130,65,36,0,0,72,
120,235,163,127,120,203,36,127,121,197,5,72,0,0,26,44,184,136,13,136,
184,7,0,84,184,136,13,152,104,0,130,65,251,0,96,56,220,129,130,56,
185,105,255,75,166,0,192,127,94,4,199,87,36,1,224,124,120,251,227,127,
8,0,128,56,73,20,0,72,184,136,13,137,118,7,8,85,0,128,201,115,
184,136,13,153,166,0,64,125,94,4,74,85,120,75,74,125,36,1,64,125,
11,0,96,60,124,247,99,56,21,197,5,72,245,248,255,75,121,27,121,124,
12,0,130,64,9,252,255,75,120,27,121,124,184,136,13,136,255,247,9,84,
220,0,130,65,0,0,25,44,204,0,130,64,120,227,131,127,8,0,129,56,
73,231,255,75,121,27,121,124,44,0,130,65,120,235,163,127,120,203,36,127,
205,196,5,72,184,136,77,137,184,7,74,85,184,136,77,153,62,6,74,85,
255,247,73,85,156,0,130,65,0,1,0,72,8,0,225,128,57,7,229,84,
255,255,5,48,16,41,0,125,63,6,8,85,1,0,128,57,20,0,130,64,
32,128,109,137,0,0,11,44,8,0,130,64,120,91,108,125,184,136,77,137,
8,0,97,129,62,6,140,85,196,129,98,56,254,7,138,81,36,134,109,145,
184,136,77,153,101,196,5,72,8,0,161,128,57,7,160,84,255,255,192,48,
16,1,198,124,63,6,198,84,28,0,130,64,32,128,237,136,0,0,7,44,
224,129,98,56,8,0,130,65,204,129,98,56,53,196,5,72,212,129,98,56,
45,196,5,72,184,136,13,136,254,247,9,84,0,0,9,44,108,0,130,64,
0,0,64,57,184,136,77,153,2,0,128,56,0,0,132,60,134,51,128,124,
166,0,160,127,94,4,172,87,36,1,128,125,134,50,130,124,120,35,131,124,
251,7,126,84,120,243,197,127,134,51,162,124,0,128,165,115,166,0,192,124,
94,4,198,84,120,43,198,124,36,1,192,124,184,136,13,136,57,7,0,84,
11,0,96,60,180,247,99,56,12,0,130,65,11,0,96,60,112,246,99,56,
181,195,5,72,16,0,159,137,116,7,140,125,5,0,12,44,0,0,64,57,
1,0,0,56,16,0,130,65,6,0,12,44,8,0,130,65,0,0,0,56,
63,6,0,84,12,0,130,64,9,0,12,44,36,0,130,64,184,136,13,137,
189,7,8,85,20,0,130,64,124,134,13,136,116,7,0,124,3,0,0,44,
8,0,130,64,1,0,64,57,32,0,193,131,20,0,97,131,24,0,129,131,
36,0,225,131,28,0,161,131,16,0,65,131,44,0,1,128,12,0,33,131,
62,6,67,85,166,3,8,124,40,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,
124,196,141,129,0,0,12,44,16,1,130,65,34,128,45,137,0,0,9,44,
32,0,130,65,125,237,255,75,145,250,255,75,212,192,109,56,2,0,128,60,
0,0,160,56,33,67,9,72,232,0,0,72,184,136,13,136,189,7,0,84,
204,0,130,65,19,0,192,63,112,177,222,59,16,0,126,137,116,7,107,125,
5,0,11,44,1,0,0,56,16,0,130,65,6,0,11,44,8,0,130,65,
0,0,0,56,63,6,0,84,76,0,130,65,0,0,224,59,120,243,195,127,
62,6,253,87,120,235,164,127,9,21,0,72,0,0,3,44,36,0,130,65,
120,243,195,127,120,235,164,127,113,19,0,72,120,251,229,127,95,0,96,56,
11,0,128,60,212,247,132,56,205,102,255,75,1,0,255,59,16,0,31,44,
192,255,128,65,97,249,255,75,166,0,224,127,94,4,224,87,36,1,0,124,
134,50,130,124,120,35,131,124,251,7,126,84,120,243,197,127,134,51,162,124,
0,128,234,115,166,0,96,125,94,4,107,85,120,83,107,125,36,1,96,125,
2,0,128,56,0,0,132,60,134,51,128,124,184,136,13,136,250,7,0,84,
184,136,13,152,212,192,109,56,2,0,128,60,0,0,160,56,57,66,9,72,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
28,0,96,60,240,85,99,56,125,198,255,75,5,0,96,60,224,147,99,56,
205,86,5,72,12,0,1,128,8,0,33,56,166,3,8,124,0,0,96,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,184,136,13,136,
189,7,0,84,120,27,100,124,130,3,96,56,16,0,130,65,28,0,96,60,
240,85,99,56,33,206,255,75,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,120,35,133,124,120,27,100,124,28,0,96,60,240,85,99,56,
68,208,255,75,232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,
184,136,205,136,189,7,198,84,0,0,224,59,244,0,130,65,12,0,129,56,
36,0,96,60,228,183,99,56,4,0,160,56,0,0,192,56,197,121,4,72,
16,0,129,56,36,0,96,60,36,182,99,56,4,0,160,56,0,0,192,56,
173,121,4,72,36,0,96,61,92,182,107,57,44,0,43,129,12,0,73,129,
120,27,127,124,0,0,192,56,120,91,99,125,166,3,73,125,120,51,199,124,
1,0,160,56,8,0,129,56,33,4,128,78,12,0,1,129,16,0,129,129,
37,0,32,61,80,64,108,125,0,234,41,57,64,72,11,124,16,0,129,65,
8,0,1,136,0,0,0,44,100,0,130,64,184,136,141,137,115,6,140,85,
24,0,130,64,188,136,13,145,83,0,96,56,232,129,130,56,249,100,255,75,
76,0,0,72,188,136,77,129,0,0,10,44,12,0,130,64,188,136,13,145,
56,0,0,72,80,64,10,124,9,0,160,60,128,58,165,56,64,40,0,124,
36,0,128,65,83,0,96,56,232,129,130,56,193,100,255,75,12,0,225,128,
188,136,237,144,12,0,0,72,0,0,0,57,188,136,13,145,28,0,1,128,
120,251,227,127,20,0,225,131,24,0,33,56,166,3,8,124,32,0,128,78,
57,40,96,124,90,0,96,56,8,0,130,65,91,0,96,56,233,129,130,56,
124,100,255,75,166,2,8,124,4,0,1,144,240,255,33,148,57,40,96,124,
52,0,130,64,8,0,129,56,36,0,96,60,188,186,99,56,1,0,160,56,
0,0,192,56,120,51,199,124,189,126,4,72,8,0,161,136,89,0,96,56,
11,0,128,60,236,247,132,56,57,100,255,75,20,0,1,128,16,0,33,56,
166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,240,255,33,148,
57,40,96,124,52,0,130,64,8,0,129,56,36,0,96,60,132,186,99,56,
1,0,160,56,0,0,192,56,120,51,199,124,105,126,4,72,8,0,161,136,
88,0,96,56,11,0,128,60,248,247,132,56,229,99,255,75,20,0,1,128,
16,0,33,56,166,3,8,124,32,0,128,78,57,40,96,124,32,0,130,76,
87,0,96,56,234,129,130,56,192,99,255,75,57,40,96,124,85,0,96,56,
8,0,130,65,86,0,96,56,235,129,130,56,168,99,255,75,166,2,8,124,
4,0,1,144,240,255,33,148,57,40,96,124,60,0,130,64,36,0,96,60,
148,182,99,56,44,0,131,129,12,0,12,128,1,0,160,56,8,0,129,56,
0,0,192,56,120,51,199,124,166,3,9,124,33,4,128,78,8,0,161,136,
84,0,96,56,236,129,130,56,93,99,255,75,20,0,1,128,16,0,33,56,
166,3,8,124,32,0,128,78,57,40,96,124,32,0,130,76,93,0,96,56,
244,129,130,56,56,99,255,75,57,40,96,124,32,0,130,76,92,0,96,56,
245,129,130,56,36,99,255,75,57,40,96,124,81,0,96,56,8,0,130,65,
82,0,96,56,246,129,130,56,12,99,255,75,166,2,8,124,4,0,1,144,
248,255,33,148,184,136,141,137,255,7,140,85,0,0,96,56,56,0,130,65,
32,128,13,136,0,0,0,44,44,0,130,64,19,0,128,61,128,177,140,137,
116,7,140,125,6,0,12,44,24,0,130,65,184,136,13,136,60,0,0,84,
184,136,13,152,129,27,9,72,97,245,255,75,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,240,255,33,148,
57,40,96,124,48,0,130,64,78,0,96,56,247,129,130,56,141,98,255,75,
184,136,13,136,16,0,0,96,184,136,13,152,117,255,255,75,20,0,1,128,
16,0,33,56,166,3,8,124,32,0,128,78,36,0,96,60,92,182,99,56,
44,0,131,129,12,0,140,129,1,0,160,56,8,0,129,56,0,0,192,56,
120,51,199,124,166,3,137,125,33,4,128,78,8,0,161,136,80,0,96,56,
11,0,128,60,4,248,132,56,49,98,255,75,184,136,13,136,52,7,0,84,
184,136,13,152,20,0,1,128,16,0,33,56,166,3,8,124,32,0,128,78,
116,7,165,124,2,0,5,40,16,0,128,64,1,0,5,40,44,0,128,64,
28,0,0,72,3,0,5,40,44,0,128,65,52,0,130,65,4,0,5,40,
56,0,130,65,32,0,128,78,73,0,96,56,248,129,130,56,216,97,255,75,
74,0,96,56,248,129,130,56,204,97,255,75,75,0,96,56,248,129,130,56,
192,97,255,75,76,0,96,56,248,129,130,56,180,97,255,75,77,0,96,56,
248,129,130,56,168,97,255,75,116,7,165,124,2,0,5,40,16,0,128,64,
1,0,5,40,56,0,128,64,28,0,0,72,3,0,5,40,68,0,128,65,
76,0,130,65,4,0,5,40,92,0,130,65,32,0,128,78,184,136,13,136,
247,6,0,84,32,0,130,76,68,0,96,56,249,129,130,56,96,97,255,75,
184,136,13,136,247,6,0,84,32,0,130,76,69,0,96,56,249,129,130,56,
72,97,255,75,70,0,96,56,249,129,130,56,60,97,255,75,184,136,13,136,
247,6,0,84,32,0,130,76,71,0,96,56,249,129,130,56,36,97,255,75,
72,0,96,56,249,129,130,56,24,97,255,75,184,136,13,136,255,7,0,84,
32,0,130,76,19,0,128,61,128,177,140,137,116,7,140,125,6,0,12,44,
32,0,130,77,184,136,13,136,0,0,160,56,1,0,0,96,212,192,109,56,
2,0,128,60,184,136,13,152,180,60,9,72,57,40,96,124,8,0,130,64,
188,255,255,75,196,253,255,75,166,2,8,124,4,0,1,144,248,255,33,148,
184,136,13,136,189,7,0,84,48,0,130,65,0,0,67,129,40,134,77,145,
4,0,3,128,44,134,141,56,44,134,13,144,36,134,109,56,45,16,0,72,
40,134,109,129,32,134,109,145,44,134,141,129,36,134,141,145,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,224,255,33,148,28,0,225,147,
166,2,8,124,36,0,1,144,184,136,141,137,0,0,96,56,189,7,140,85,
239,0,0,56,8,0,1,152,12,0,97,144,92,0,130,65,28,0,224,63,
240,85,127,56,12,0,129,56,69,222,255,75,0,0,3,44,68,0,130,64,
12,0,1,128,8,0,129,129,16,0,129,145,16,0,97,56,20,0,1,144,
85,255,255,75,19,0,128,61,128,177,140,137,116,7,140,125,6,0,12,44,
16,0,130,64,184,136,45,137,60,0,41,85,184,136,45,153,240,85,127,56,
73,220,255,75,184,136,77,137,32,0,74,97,184,136,77,153,36,0,1,128,
28,0,225,131,32,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,184,136,13,136,255,255,12,84,
116,0,130,65,255,7,0,84,100,0,130,65,19,0,128,61,128,177,140,137,
116,7,140,125,6,0,12,44,72,0,130,65,28,0,96,60,240,85,99,56,
93,228,255,75,121,27,127,124,24,0,130,65,120,251,228,127,11,0,96,60,
16,248,99,56,25,187,5,72,52,0,0,72,11,0,96,60,56,248,99,56,
9,187,5,72,184,136,141,137,8,0,140,97,184,136,141,153,24,0,0,72,
140,3,224,59,16,0,0,72,131,3,224,59,8,0,0,72,130,3,224,59,
20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
184,136,141,137,189,7,140,85,0,0,224,59,52,0,130,65,8,0,129,56,
8,0,97,144,36,0,96,60,228,183,99,56,4,0,160,56,0,0,192,56,
9,115,4,72,120,27,127,124,49,249,255,75,184,136,13,136,64,0,0,96,
184,136,13,152,20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,6,0,5,168,1,0,0,40,120,0,130,64,19,0,128,61,
128,177,140,137,116,7,140,125,6,0,12,44,12,0,130,64,140,3,224,59,
96,0,0,72,36,0,96,60,92,182,99,56,0,0,128,56,105,120,4,72,
121,27,127,124,72,0,130,64,105,251,255,75,121,27,127,124,60,0,130,64,
28,0,96,60,240,85,99,56,201,222,255,75,121,27,127,124,184,136,13,136,
16,0,130,64,16,0,12,96,184,136,141,153,24,0,0,72,52,7,0,84,
184,136,13,152,37,253,255,75,8,0,0,72,13,1,224,59,20,0,1,128,
120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
232,255,33,148,16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,
184,136,13,136,0,0,128,57,189,7,0,84,130,3,224,59,8,0,129,145,
76,0,130,65,28,0,192,63,240,85,126,56,8,0,129,56,229,219,255,75,
121,27,127,124,52,0,130,64,8,0,97,129,127,7,106,85,36,0,130,64,
109,108,8,72,240,85,126,56,65,225,255,75,120,27,127,124,0,0,96,56,
1,147,4,72,120,251,227,127,12,0,0,72,141,3,224,59,120,251,227,127,
28,0,1,128,20,0,225,131,16,0,193,131,166,3,8,124,24,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,28,0,96,60,
240,85,99,56,153,225,255,75,0,0,3,44,16,0,130,64,184,136,13,136,
118,7,0,84,184,136,13,152,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,28,0,96,60,
240,85,99,56,1,226,255,75,0,0,3,44,16,0,130,64,184,136,13,136,
8,0,0,96,184,136,13,152,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,232,255,33,148,239,0,0,56,
8,0,1,152,0,0,0,56,12,0,1,144,8,0,129,56,12,0,161,56,
28,0,96,60,240,85,99,56,97,185,255,75,0,0,3,44,200,0,130,65,
184,136,109,137,181,6,107,85,128,0,130,65,166,0,96,124,254,143,96,84,
1,0,12,104,63,6,140,85,56,0,130,65,11,0,96,60,188,248,99,56,
169,20,5,72,12,0,97,129,8,0,1,128,16,0,1,144,16,0,97,56,
20,0,97,145,205,251,255,75,28,0,1,128,24,0,33,56,166,3,8,124,
32,0,128,78,8,0,129,56,36,0,96,60,236,157,99,56,255,255,160,56,
25,107,5,72,212,192,109,56,64,0,128,60,0,0,160,56,57,56,9,72,
28,0,1,128,24,0,33,56,166,3,8,124,32,0,128,78,11,0,96,60,
172,248,99,56,229,183,5,72,8,0,129,136,11,0,96,60,228,248,99,56,
213,183,5,72,11,0,96,60,212,248,99,56,201,183,5,72,12,0,129,128,
252,129,98,56,189,183,5,72,250,129,98,56,181,183,5,72,28,0,1,128,
24,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,19,0,224,63,112,177,255,59,16,0,159,137,
116,7,140,125,5,0,12,44,1,0,0,56,16,0,130,65,6,0,12,44,
8,0,130,65,0,0,0,56,63,6,0,84,48,0,130,64,141,41,0,72,
0,0,3,44,20,0,130,65,120,27,100,124,11,0,96,60,240,248,99,56,
1,20,5,72,120,251,227,127,5,0,128,56,69,6,0,72,65,106,8,72,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,166,0,224,127,
94,4,235,87,36,1,96,125,19,0,96,60,112,177,99,56,8,0,128,56,
1,6,0,72,0,0,3,44,16,0,130,64,184,136,13,136,118,7,0,84,
184,136,13,152,0,128,224,115,166,0,128,125,94,4,140,85,120,3,140,125,
36,1,128,125,0,0,3,44,8,0,130,64,201,237,255,75,20,0,1,128,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
19,0,128,61,112,177,140,57,12,0,225,147,166,2,8,124,20,0,1,144,
16,0,76,137,116,7,74,125,5,0,10,44,124,134,237,139,0,0,96,56,
1,0,0,56,116,7,255,127,16,0,130,65,6,0,10,44,8,0,130,65,
0,0,0,56,63,6,0,84,88,0,130,65,120,99,131,125,1,0,128,56,
157,5,0,72,5,0,3,40,64,0,129,65,184,136,13,136,189,7,0,84,
12,0,130,64,3,0,31,44,32,0,130,64,11,0,96,60,16,249,99,56,
49,182,5,72,129,38,0,72,0,0,3,44,24,0,130,65,16,0,0,72,
250,0,96,56,4,130,130,56,117,90,255,75,241,254,255,75,20,0,1,128,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,224,255,33,148,
12,0,97,147,16,0,129,147,20,0,161,147,28,0,225,147,166,2,8,124,
36,0,1,144,24,0,193,147,0,0,192,59,145,41,6,72,120,27,127,124,
225,41,6,72,120,251,228,127,120,27,101,124,11,0,96,60,88,249,99,56,
185,181,5,72,19,0,128,63,112,177,156,59,16,0,60,137,116,7,41,125,
5,0,9,44,108,192,237,147,1,0,128,57,16,0,130,65,6,0,9,44,
8,0,130,65,0,0,128,57,63,6,140,85,16,0,130,64,13,137,4,72,
16,0,60,137,116,7,41,125,20,0,124,131,4,0,9,44,24,0,130,64,
120,227,131,127,8,0,128,56,105,4,0,72,16,0,60,137,116,7,41,125,
8,0,9,44,52,0,130,64,0,0,27,44,0,0,224,59,40,0,130,65,
255,7,102,87,20,0,130,65,120,251,229,127,95,0,96,56,8,130,130,56,
141,89,255,75,127,248,123,87,1,0,255,59,224,255,130,64,184,136,13,136,
189,7,0,84,104,1,130,65,16,0,60,137,116,7,41,125,5,0,9,44,
1,0,0,56,16,0,130,65,6,0,9,44,8,0,130,65,0,0,0,56,
63,6,0,84,240,0,130,65,166,0,224,127,94,4,232,87,36,1,0,125,
120,227,131,127,120,219,100,127,149,4,0,72,0,0,160,59,1,0,96,57,
48,232,96,125,57,0,96,127,20,0,130,64,120,227,131,127,62,6,164,87,
255,255,160,56,81,4,0,72,1,0,189,59,16,0,29,44,216,255,128,65,
0,0,27,44,120,227,131,127,36,0,130,65,6,0,128,56,153,3,0,72,
0,128,230,115,166,0,224,124,94,4,231,84,120,51,231,124,36,1,224,124,
40,0,0,72,17,5,0,72,184,136,13,136,0,128,230,115,118,7,0,84,
184,136,13,152,166,0,224,124,94,4,231,84,120,51,231,124,36,1,224,124,
0,0,27,44,12,0,130,64,77,235,255,75,120,27,126,124,0,0,224,59,
1,0,32,57,48,248,40,125,57,64,106,127,20,0,130,65,120,251,229,127,
79,0,96,56,8,130,130,56,129,88,255,75,1,0,255,59,16,0,31,44,
216,255,128,65,124,134,13,136,116,7,0,124,3,0,0,44,112,0,130,65,
40,0,0,72,9,0,9,44,16,0,130,65,120,227,131,127,225,3,0,72,
120,27,126,124,124,134,13,136,116,7,0,124,3,0,0,44,72,0,130,65,
11,0,96,60,48,249,99,56,209,179,5,72,25,250,255,75,120,27,126,124,
120,227,131,127,237,2,0,72,69,6,9,72,165,247,255,75,120,243,195,127,
48,0,0,72,120,227,131,127,1,0,128,56,173,2,0,72,120,227,131,127,
141,3,0,72,120,27,126,124,120,227,131,127,189,2,0,72,21,6,9,72,
117,247,255,75,120,243,195,127,20,0,161,131,24,0,193,131,28,0,225,131,
36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,
32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,166,2,8,124,
28,0,1,144,20,0,225,147,19,0,224,63,112,177,255,59,16,0,127,137,
116,7,107,125,5,0,11,44,1,0,0,56,16,0,130,65,6,0,11,44,
8,0,130,65,0,0,0,56,63,6,0,84,108,0,130,65,0,0,160,59,
120,235,163,127,157,216,8,72,252,13,160,87,20,2,63,125,24,0,9,168,
254,255,0,44,62,6,163,87,16,0,130,64,241,13,9,72,1,0,189,59,
48,0,0,72,255,255,0,44,62,6,190,87,120,243,195,127,24,0,129,64,
17,14,9,72,120,243,195,127,229,13,9,72,1,0,189,59,12,0,0,72,
217,13,9,72,1,0,189,59,16,0,29,44,164,255,128,65,173,134,4,72,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,19,0,192,63,112,177,222,59,16,0,158,137,
116,7,140,125,5,0,12,44,1,0,0,56,120,27,127,124,16,0,130,65,
6,0,12,44,8,0,130,65,0,0,0,56,63,6,0,84,224,0,130,64,
9,0,12,44,216,0,130,65,96,239,96,60,28,7,99,56,0,0,99,128,
255,191,96,84,8,0,130,64,193,100,8,72,184,136,77,137,57,7,74,85,
12,0,130,64,0,0,31,44,8,1,130,65,19,0,192,63,112,177,222,59,
16,0,30,136,116,7,0,124,3,0,0,44,12,0,130,64,0,0,31,44,
80,0,130,65,120,243,195,127,4,0,128,56,245,0,0,72,45,215,8,72,
120,27,100,124,120,243,195,127,177,1,0,72,117,185,6,72,109,185,6,72,
81,133,8,72,48,134,13,128,0,0,0,44,24,0,130,64,97,185,6,72,
48,134,77,129,0,0,10,44,8,0,130,64,221,134,8,72,217,35,0,72,
120,243,195,127,5,0,128,56,169,0,0,72,165,100,8,72,11,0,96,60,
172,249,99,56,237,13,5,72,197,18,5,72,184,136,141,137,118,7,140,85,
28,0,96,60,240,85,99,56,184,136,141,153,125,191,255,75,60,0,0,72,
184,136,109,137,57,7,107,85,84,0,130,65,105,100,8,72,11,0,96,60,
172,249,99,56,177,13,5,72,137,18,5,72,184,136,141,137,118,7,140,85,
28,0,96,60,240,85,99,56,184,136,141,153,65,191,255,75,96,239,96,60,
28,7,99,56,0,0,99,128,255,191,108,84,240,255,130,65,11,0,96,60,
120,249,99,56,117,13,5,72,53,136,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,16,0,163,56,
16,0,131,152,0,0,128,56,1,0,192,56,184,48,5,72,24,0,163,56,
5,0,128,56,32,0,192,56,168,48,5,72,0,0,0,56,56,0,3,152,
56,0,163,56,37,0,128,56,1,0,192,56,144,48,5,72,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,56,0,131,137,120,27,127,124,
20,34,140,125,1,0,192,56,37,0,128,56,56,0,131,153,56,0,191,56,
97,48,5,72,0,0,3,44,255,255,0,56,12,0,130,64,56,0,31,136,
116,7,0,124,62,6,3,84,20,0,1,128,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,16,0,4,40,12,0,128,65,10,1,96,56,
32,0,128,78,60,8,132,84,20,34,131,125,24,0,172,176,96,255,255,75,
20,0,163,56,20,0,131,144,1,0,128,56,4,0,192,56,0,48,5,72,
20,0,131,129,120,35,140,125,20,0,163,56,4,0,192,56,1,0,128,56,
20,0,131,145,228,47,5,72,240,255,33,148,0,0,96,57,12,0,225,147,
120,27,127,124,166,2,8,124,20,0,1,144,16,0,127,153,20,0,127,145,
56,0,127,153,22,0,159,57,255,255,0,56,16,0,64,57,166,3,73,125,
2,0,12,180,252,255,0,66,120,251,227,127,16,0,191,56,0,0,128,56,
1,0,192,56,149,47,5,72,0,0,3,44,40,0,130,64,120,251,227,127,
20,0,191,56,1,0,128,56,4,0,192,56,121,47,5,72,0,0,3,44,
12,0,130,64,120,251,227,127,181,254,255,75,0,0,3,44,24,0,130,64,
120,251,227,127,56,0,191,56,37,0,128,56,1,0,192,56,77,47,5,72,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
20,0,31,128,0,0,0,44,24,0,130,65,11,0,96,60,184,249,99,56,
210,0,128,56,0,0,160,56,89,80,255,75,120,251,227,127,7,0,128,56,
49,254,255,75,20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,232,255,33,148,20,0,225,147,12,0,161,147,16,0,193,147,
166,2,8,124,28,0,1,144,8,0,129,147,120,27,124,124,20,0,28,128,
120,35,159,124,1,0,32,57,48,248,62,125,57,240,11,124,188,0,130,65,
11,0,96,60,204,249,99,56,209,174,5,72,166,0,160,127,94,4,170,87,
36,1,64,125,20,0,28,128,4,0,192,56,1,0,128,56,120,240,0,124,
120,227,131,127,20,0,188,56,20,0,28,144,117,46,5,72,121,27,126,124,
60,8,255,87,20,250,92,125,254,255,128,57,24,0,138,177,16,0,130,64,
120,227,131,127,161,253,255,75,120,27,126,124,20,0,220,128,0,0,6,44,
60,0,130,64,120,227,131,127,93,254,255,75,120,227,131,127,1,255,255,75,
184,136,237,136,118,7,231,84,0,128,168,115,184,136,237,152,166,0,32,125,
94,4,41,85,120,67,41,125,36,1,32,125,69,229,255,75,137,241,255,75,
0,128,171,115,166,0,128,125,94,4,140,85,120,91,140,125,36,1,128,125,
8,0,0,72,10,1,192,59,120,243,195,127,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,166,2,8,124,
28,0,1,144,20,0,225,147,120,27,127,124,20,0,223,131,0,0,30,44,
0,0,96,56,120,27,125,124,36,0,130,65,255,7,192,87,16,0,130,65,
120,251,227,127,62,6,164,87,169,254,255,75,127,248,222,87,1,0,189,59,
228,255,130,64,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,
166,2,8,124,20,0,1,144,20,0,131,129,1,0,0,56,11,0,96,60,
228,249,99,56,48,32,0,124,56,96,12,124,255,255,12,48,16,97,224,127,
120,251,229,127,89,173,5,72,20,0,1,128,120,251,227,127,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,16,0,159,136,11,0,96,60,
116,7,132,124,64,250,99,56,25,173,5,72,20,0,159,128,11,0,96,60,
0,250,99,56,9,173,5,72,56,0,159,136,11,0,96,60,32,250,99,56,
249,172,5,72,20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,209,48,5,72,120,251,227,127,16,0,191,56,0,0,128,56,
1,0,192,56,121,37,5,72,120,251,227,127,20,0,191,56,1,0,128,56,
4,0,192,56,101,37,5,72,120,251,227,127,24,0,191,56,5,0,128,56,
32,0,192,56,81,37,5,72,120,251,227,127,56,0,191,56,37,0,128,56,
1,0,192,56,61,37,5,72,120,251,227,127,57,255,255,75,12,0,225,131,
20,0,1,128,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,121,27,127,124,166,2,8,124,20,0,1,144,20,0,130,64,
60,0,96,56,189,150,5,72,121,27,127,124,20,0,130,65,120,251,227,127,
3,0,128,56,38,0,160,56,217,47,5,72,20,0,1,128,120,251,227,127,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,216,255,33,148,
12,0,33,147,16,0,65,147,20,0,97,147,24,0,129,147,28,0,161,147,
32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,0,0,99,131,
0,0,164,131,121,234,96,127,11,0,32,63,168,250,57,59,176,0,130,65,
13,0,64,59,126,231,188,87,126,199,190,87,4,0,185,136,116,7,165,124,
4,0,5,44,0,0,128,57,36,0,130,64,112,0,160,56,118,6,96,87,
118,6,169,87,121,74,0,124,120,227,159,127,1,0,128,57,104,0,130,65,
68,0,0,72,8,0,5,44,36,0,130,64,0,7,160,56,110,5,96,87,
110,5,169,87,121,74,0,124,120,243,223,127,1,0,128,57,64,0,130,65,
28,0,0,72,1,0,0,56,48,40,5,124,56,40,96,127,56,40,169,127,
121,74,0,124,36,0,130,65,0,0,12,44,8,0,130,65,120,251,229,127,
0,0,121,129,120,235,164,127,166,3,105,125,120,219,99,127,33,4,128,78,
255,255,90,55,8,0,57,59,100,255,130,64,32,0,193,131,24,0,129,131,
20,0,97,131,28,0,161,131,36,0,225,131,44,0,1,128,16,0,65,131,
12,0,33,131,166,3,8,124,40,0,33,56,32,0,128,78,0,0,4,44,
12,0,130,64,9,0,96,56,32,0,128,78,0,0,131,129,1,0,128,85,
255,255,96,49,16,1,11,124,63,6,0,84,12,0,130,64,1,0,96,56,
32,0,128,78,67,0,128,85,255,255,96,49,16,1,107,125,63,6,107,85,
12,0,130,64,2,0,96,56,32,0,128,78,25,3,128,85,255,255,96,49,
16,1,11,124,63,6,0,84,24,0,130,64,141,1,128,85,255,255,96,49,
16,1,11,124,63,6,0,84,12,0,130,65,7,0,96,56,32,0,128,78,
57,7,128,85,255,255,96,49,16,1,11,124,63,6,0,84,12,0,130,65,
0,0,96,56,32,0,128,78,41,5,128,85,255,255,96,49,16,1,107,125,
63,6,107,85,12,0,130,65,3,0,96,56,32,0,128,78,99,4,128,85,
255,255,96,49,16,1,11,124,63,6,0,84,12,0,130,65,4,0,96,56,
32,0,128,78,75,1,128,85,255,255,96,49,16,1,107,125,63,6,107,85,
24,0,130,64,207,1,128,85,255,255,96,49,16,1,107,125,63,6,107,85,
12,0,130,65,8,0,96,56,32,0,128,78,33,4,128,85,255,255,96,49,
16,1,107,125,63,6,107,85,44,0,130,64,107,5,139,85,255,255,11,48,
16,89,0,124,63,6,0,84,24,0,130,64,115,6,128,85,255,255,96,49,
16,1,107,125,63,6,107,85,12,0,130,65,5,0,96,56,32,0,128,78,
6,0,96,56,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
169,254,255,75,12,0,128,61,168,247,140,57,10,0,0,56,166,3,9,124,
8,0,12,140,116,7,0,124,64,24,0,124,24,0,130,64,12,0,1,128,
4,0,108,128,8,0,33,56,166,3,8,124,32,0,128,78,220,255,0,66,
12,0,1,128,8,0,33,56,166,3,8,124,44,130,98,56,32,0,128,78,
240,255,33,148,120,27,100,124,244,1,67,57,0,80,4,124,0,0,224,56,
12,0,225,147,12,0,32,61,16,248,41,57,239,255,233,59,8,0,193,147,
60,130,130,57,255,255,108,56,56,130,130,57,255,255,204,59,248,0,128,64,
255,255,196,56,120,243,200,127,4,0,128,57,166,3,137,125,1,0,102,141,
1,0,136,141,81,88,140,125,16,0,130,64,0,0,11,44,8,0,130,65,
232,255,0,66,0,0,12,44,184,0,130,64,4,0,132,56,255,255,100,57,
120,91,108,125,1,0,12,141,117,7,8,125,248,255,130,64,81,96,132,125,
152,0,130,65,120,27,102,124,20,98,164,124,4,0,128,57,166,3,137,125,
1,0,5,141,1,0,134,141,81,64,140,125,16,0,130,64,0,0,8,44,
8,0,130,65,232,255,0,66,0,0,12,44,100,0,130,64,120,251,232,127,
16,0,128,57,166,3,137,125,1,0,171,140,116,7,165,124,121,43,166,124,
1,0,168,156,20,0,130,64,0,0,12,44,255,255,8,57,24,0,130,64,
48,0,0,72,255,255,140,57,216,255,0,66,0,0,12,44,32,0,130,65,
1,0,12,40,0,0,96,57,8,0,128,64,1,0,128,57,166,3,137,125,
1,0,104,157,252,255,0,66,0,0,233,152,1,0,132,56,0,80,4,124,
16,255,128,65,12,0,225,131,8,0,193,131,16,0,33,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,196,136,13,160,57,7,0,84,
44,0,130,64,0,1,96,56,93,28,6,72,0,0,3,44,28,0,130,65,
11,0,96,60,16,251,99,56,83,0,128,56,0,0,160,56,249,72,255,75,
0,0,3,44,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
192,255,33,148,48,0,129,147,52,0,161,147,56,0,193,147,60,0,225,147,
166,2,8,124,68,0,1,144,196,136,13,160,0,32,160,63,57,7,0,84,
2,0,192,63,0,0,189,59,28,0,130,65,11,0,96,60,60,251,99,56,
129,167,5,72,0,2,128,57,24,0,157,145,108,1,0,72,0,2,0,56,
28,0,29,144,12,0,97,56,102,85,128,60,136,119,132,56,181,116,3,72,
12,0,97,56,41,146,3,72,0,0,3,44,28,0,130,64,11,0,96,60,
108,251,99,56,65,167,5,72,0,2,128,57,24,0,157,145,44,1,0,72,
12,0,97,56,1,106,3,72,120,27,127,124,64,240,31,124,8,0,129,64,
120,243,223,127,120,251,227,127,65,147,5,72,121,27,124,124,28,0,130,64,
11,0,96,60,132,251,99,56,1,167,5,72,0,2,128,57,24,0,157,145,
236,0,0,72,12,0,97,56,0,0,128,56,8,0,161,56,193,144,3,72,
8,0,161,128,64,248,5,124,12,0,129,64,120,251,229,127,8,0,161,144,
120,227,132,127,12,0,97,56,0,0,192,56,120,51,199,124,9,113,3,72,
0,0,3,44,16,0,130,65,11,0,96,60,180,251,99,56,169,166,5,72,
12,0,224,63,120,227,131,127,81,253,255,75,196,136,13,160,255,7,0,84,
32,0,130,65,0,248,159,56,11,0,96,60,208,251,99,56,129,166,5,72,
120,227,131,127,169,146,5,72,100,0,0,72,120,227,132,127,0,0,96,56,
120,243,197,127,17,100,8,72,121,27,126,124,44,0,130,64,0,248,159,56,
11,0,96,60,236,251,99,56,77,166,5,72,196,136,13,160,120,227,131,127,
1,0,0,96,196,136,13,176,105,146,5,72,36,0,0,72,45,86,3,72,
120,243,196,127,120,27,101,124,11,0,96,60,28,251,99,56,29,166,5,72,
120,227,131,127,69,146,5,72,0,2,128,57,24,0,157,145,56,0,193,131,
60,0,225,131,68,0,1,128,52,0,161,131,48,0,129,131,166,3,8,124,
64,0,33,56,32,0,128,78,224,255,33,148,28,0,225,147,16,0,129,147,
20,0,161,147,166,2,8,124,36,0,1,144,24,0,193,147,12,0,97,147,
120,43,187,124,120,27,126,124,0,0,190,128,120,35,159,124,0,0,255,128,
64,56,5,124,11,0,128,63,112,253,156,59,20,0,130,65,120,227,131,127,
204,6,128,56,0,0,160,56,189,70,255,75,4,0,222,136,4,0,31,136,
64,0,6,124,20,0,130,65,120,227,131,127,205,6,128,56,0,0,160,56,
157,70,255,75,120,243,195,127,120,251,228,127,12,0,160,56,17,196,5,72,
8,0,59,129,0,0,9,44,64,0,130,64,120,227,131,127,210,6,128,56,
0,0,160,56,113,70,255,75,8,0,59,129,0,0,3,44,36,0,130,65,
16,0,251,131,0,0,160,59,252,255,254,56,121,75,40,125,120,67,0,125,
120,235,190,127,36,0,129,65,108,0,0,72,16,0,251,131,0,0,160,59,
252,255,254,56,121,75,40,125,120,67,0,125,120,235,190,127,80,0,129,64,
166,3,9,124,64,248,7,124,68,0,130,65,120,251,234,127,191,7,75,85,
120,251,253,127,12,0,130,64,0,0,234,131,36,0,0,72,80,80,75,125,
0,0,10,128,4,0,234,131,56,24,107,85,48,92,0,124,32,0,107,33,
48,88,255,127,120,3,255,127,1,0,222,59,188,255,0,66,0,64,30,124,
28,0,128,65,120,227,131,127,120,243,197,127,234,6,128,56,197,69,255,75,
8,0,59,129,0,0,3,44,120,251,230,127,191,7,204,84,255,255,9,56,
8,0,27,144,12,0,130,64,0,0,6,128,36,0,0,72,80,48,204,124,
4,0,6,128,0,0,198,128,56,24,140,85,48,100,198,124,32,0,140,33,
48,96,0,124,120,51,0,124,0,0,30,44,12,0,130,64,16,0,27,144,
48,0,0,72,191,7,171,87,12,0,130,64,0,0,29,144,32,0,0,72,
0,0,29,152,62,194,12,84,1,0,157,153,62,194,140,85,2,0,157,153,
62,194,140,85,3,0,157,153,191,7,224,87,12,0,130,64,0,0,127,147,
32,0,0,72,0,0,127,155,62,194,101,87,1,0,191,152,62,194,165,84,
2,0,191,152,62,194,165,84,3,0,191,152,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,
32,0,33,56,32,0,128,78,0,0,0,56,23,0,128,61,200,20,12,152,
12,0,96,60,20,248,99,56,116,137,5,72,208,255,33,148,32,0,129,147,
166,2,8,124,52,0,1,144,44,0,225,147,120,27,127,124,0,0,96,56,
40,0,193,147,41,0,192,63,36,0,161,147,8,0,161,59,6,0,31,136,
189,7,0,84,44,0,130,65,5,0,159,139,120,251,227,127,120,235,165,127,
120,227,134,127,0,0,128,56,109,21,6,72,228,2,126,56,120,235,164,127,
120,227,133,127,81,121,8,72,8,0,255,131,0,0,31,44,12,0,130,65,
0,0,3,44,188,255,130,65,40,0,193,131,44,0,225,131,52,0,1,128,
36,0,161,131,32,0,129,131,166,3,8,124,48,0,33,56,32,0,128,78,
208,255,33,148,166,2,8,124,52,0,1,144,36,0,161,147,40,0,193,147,
120,27,126,124,0,0,96,56,120,27,125,124,44,0,225,147,8,0,225,59,
28,0,97,147,41,0,96,63,32,0,129,147,1,0,128,63,36,0,0,72,
8,0,191,147,12,0,191,147,16,0,159,147,228,2,123,56,120,251,228,127,
128,0,160,56,197,120,8,72,1,0,189,63,64,240,29,124,12,0,128,64,
0,0,3,44,212,255,130,65,36,0,161,131,40,0,193,131,44,0,225,131,
52,0,1,128,32,0,129,131,28,0,97,131,166,3,8,124,48,0,33,56,
32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,166,0,160,127,94,4,160,87,36,1,0,124,
11,0,96,60,72,254,99,56,101,162,5,72,0,0,96,56,25,68,1,72,
120,27,126,124,3,0,128,56,125,65,1,72,0,0,30,44,120,27,127,124,
28,0,130,65,48,0,158,129,12,0,76,129,120,243,195,127,3,0,128,56,
166,3,73,125,33,4,128,78,0,128,172,115,166,0,0,124,94,4,0,84,
120,99,0,124,36,1,0,124,120,251,227,127,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
23,0,96,60,168,20,99,56,11,0,128,60,100,254,132,56,1,0,160,56,
196,206,3,72,0,0,3,44,32,0,130,77,255,7,128,84,32,0,130,77,
236,141,5,72,120,0,99,56,100,125,8,72,240,255,33,148,12,0,225,147,
0,0,32,57,23,0,96,61,204,20,107,57,120,91,108,125,236,255,76,57,
166,2,8,124,20,0,1,144,47,0,0,56,166,3,9,124,20,0,140,57,
20,0,138,149,19,0,42,153,244,255,0,66,0,0,128,56,172,3,139,144,
191,3,139,152,60,134,109,145,23,0,224,63,140,24,255,59,120,251,227,127,
64,0,160,56,121,61,255,75,52,0,31,128,1,0,0,96,52,0,31,144,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
16,0,4,40,0,0,128,57,20,0,128,64,168,4,4,28,43,0,128,61,
104,212,140,57,20,2,140,125,0,0,12,44,32,0,130,77,163,0,12,136,
0,0,0,44,32,0,130,77,184,136,13,136,254,255,0,84,162,0,12,152,
32,0,128,78,16,0,4,40,0,0,128,57,20,0,128,64,168,4,4,28,
43,0,128,61,104,212,140,57,20,2,140,125,0,0,12,44,32,0,130,77,
161,0,12,136,0,0,0,44,32,0,130,77,184,136,13,136,254,255,0,84,
160,0,12,152,32,0,128,78,104,192,13,136,100,0,128,57,80,99,0,16,
100,192,13,144,32,0,128,78,200,255,33,148,52,0,225,147,120,35,159,124,
16,0,31,40,20,0,225,146,24,0,1,147,28,0,33,147,36,0,97,147,
40,0,129,147,44,0,161,147,48,0,193,147,166,2,8,124,60,0,1,144,
32,0,65,147,0,0,64,59,16,0,128,64,168,4,255,28,43,0,7,61,
104,212,72,59,0,0,26,44,160,7,130,65,120,251,227,127,197,163,8,72,
121,27,123,124,144,7,130,65,8,0,155,131,0,0,28,44,132,7,130,65,
1,0,26,136,25,0,250,155,0,0,26,152,104,0,252,128,100,0,39,129,
120,227,131,127,166,3,41,125,33,4,128,78,255,255,67,49,17,25,170,127,
16,0,130,64,0,0,122,137,184,7,107,85,0,0,122,153,20,0,154,129,
123,7,140,85,0,0,192,59,20,0,130,65,20,0,26,128,184,7,0,84,
1,0,192,59,20,0,26,144,104,0,188,128,156,1,197,128,120,227,131,127,
16,0,129,56,166,3,201,124,33,4,128,78,26,0,250,136,0,0,7,44,
28,0,130,65,16,0,1,129,0,0,8,44,16,0,130,65,0,0,3,44,
8,0,130,64,1,0,192,59,184,136,109,137,255,255,105,85,68,0,130,65,
255,7,106,85,1,0,160,56,28,0,130,65,36,134,141,129,57,7,139,85,
255,255,11,48,16,89,128,125,63,6,140,85,20,0,130,64,32,128,13,137,
0,0,8,44,8,0,130,64,0,0,160,56,63,6,165,84,8,0,130,64,
1,0,192,59,104,0,188,128,116,0,197,128,19,0,32,63,166,3,201,124,
112,177,57,59,120,227,131,127,33,4,128,78,20,0,26,129,8,0,161,56,
12,0,129,56,255,255,227,48,16,25,199,124,120,227,131,127,188,15,200,80,
20,0,26,145,145,193,6,72,8,0,1,129,144,0,90,161,64,64,10,124,
12,0,161,128,16,0,130,65,0,0,5,44,44,0,129,64,56,0,0,72,
146,0,58,161,64,40,9,124,20,0,130,64,0,0,26,136,255,247,9,84,
0,2,130,65,0,1,0,72,0,0,5,44,20,0,129,65,0,0,26,136,
255,247,9,84,232,1,130,65,232,0,0,72,0,0,8,44,20,0,129,65,
0,0,26,136,255,247,9,84,208,1,130,65,208,0,0,72,16,0,217,136,
116,7,198,124,5,0,6,44,1,0,0,56,16,0,130,65,6,0,6,44,
8,0,130,65,0,0,0,56,63,6,0,84,0,0,26,136,116,7,0,124,
36,0,130,65,62,6,0,84,254,247,9,84,62,4,10,85,144,0,90,177,
146,0,186,176,0,0,128,57,148,0,154,177,60,0,0,72,62,6,0,84,
255,247,9,84,28,0,130,65,120,219,99,127,41,162,8,72,0,0,26,136,
8,0,1,129,12,0,161,128,254,247,9,84,62,4,10,85,144,0,90,177,
146,0,186,176,0,0,128,57,148,0,154,177,120,43,167,124,1,0,0,56,
16,0,96,57,166,3,105,125,48,96,11,124,64,88,7,124,20,0,130,64,
148,0,154,177,255,255,133,57,150,0,154,177,20,0,0,72,1,0,140,57,
224,255,0,66,255,255,133,57,150,0,154,177,0,0,9,44,0,1,130,65,
19,0,0,63,216,179,216,132,212,135,237,168,214,43,8,124,58,16,0,84,
214,59,134,124,214,67,164,124,0,40,0,124,120,43,172,124,8,0,128,64,
120,3,12,124,62,6,140,85,64,40,12,124,24,0,154,153,4,0,0,56,
8,0,130,64,3,0,0,56,148,0,58,161,60,8,231,84,0,54,192,56,
214,99,166,124,48,72,168,124,215,59,232,126,62,6,0,84,22,0,26,152,
68,0,130,64,11,0,96,60,40,0,99,56,9,2,128,56,0,0,160,56,
145,62,255,75,0,0,216,128,0,0,3,44,144,0,90,161,212,135,237,168,
24,0,154,137,22,0,26,136,214,59,134,124,16,0,130,65,0,48,23,44,
20,0,129,64,12,0,0,72,0,48,23,44,8,0,129,64,0,48,224,58,
16,3,108,17,214,91,4,125,60,8,12,85,85,85,96,61,86,85,107,57,
150,96,11,125,156,0,250,178,60,8,74,85,112,254,128,125,80,64,0,125,
0,64,10,124,8,0,129,64,120,83,72,125,0,184,8,124,120,187,229,126,
8,0,128,64,120,67,5,125,158,0,186,176,0,0,29,44,11,0,0,63,
44,2,130,65,20,0,218,128,57,7,198,84,0,0,26,136,116,7,0,124,
20,0,130,65,62,6,0,84,255,247,9,84,40,0,130,65,64,0,0,72,
62,6,0,84,255,247,9,84,252,1,130,65,2,0,250,136,123,7,231,84,
240,1,130,64,0,0,9,44,32,0,130,64,11,0,96,60,56,0,99,56,
145,156,5,72,152,0,26,129,0,0,8,44,208,0,130,64,44,0,0,72,
0,0,30,44,11,0,96,60,76,0,99,56,12,0,130,65,11,0,96,60,
208,255,99,56,101,156,5,72,152,0,26,129,0,0,8,44,164,0,130,64,
20,0,26,128,57,7,0,84,16,0,130,65,116,0,90,169,0,0,10,44,
140,0,130,64,100,0,120,56,57,156,5,72,16,0,217,136,116,7,198,124,
5,0,6,44,1,0,0,56,16,0,130,65,6,0,6,44,8,0,130,65,
0,0,0,56,63,6,0,84,28,1,130,65,104,0,220,128,36,1,230,128,
120,227,131,127,166,3,233,124,33,4,128,78,20,0,154,129,118,7,140,85,
120,203,35,127,62,6,228,87,20,0,154,145,213,236,255,75,255,255,32,57,
4,0,58,145,8,0,58,145,0,0,0,56,12,0,26,144,16,0,26,152,
17,0,26,152,18,0,26,152,19,0,26,152,28,0,26,144,4,1,0,72,
11,0,96,60,244,255,99,56,173,155,5,72,120,211,67,127,113,40,6,72,
0,0,3,44,120,0,130,65,104,0,28,129,36,1,40,129,120,227,131,127,
166,3,41,125,33,4,128,78,120,251,227,127,255,255,128,56,205,157,0,72,
120,251,229,127,94,0,96,56,104,130,130,56,205,63,255,75,20,0,154,129,
118,7,140,85,120,203,35,127,62,6,228,87,20,0,154,145,69,236,255,75,
255,255,32,57,4,0,58,145,8,0,58,145,0,0,0,56,12,0,26,144,
16,0,26,152,17,0,26,152,18,0,26,152,19,0,26,152,28,0,26,144,
116,0,0,72,0,0,122,137,104,130,130,56,184,7,107,85,120,251,229,127,
79,0,96,56,0,0,122,153,109,63,255,75,0,0,218,136,2,0,154,137,
64,96,6,124,64,2,130,65,12,2,0,72,20,0,154,129,118,7,140,85,
120,203,35,127,62,6,228,87,20,0,154,145,209,235,255,75,255,255,32,57,
4,0,58,145,8,0,58,145,0,0,0,56,12,0,26,144,16,0,26,152,
17,0,26,152,18,0,26,152,19,0,26,152,28,0,26,144,0,0,30,44,
16,0,130,65,0,0,122,137,184,7,107,85,0,0,122,153,0,0,154,137,
123,7,140,85,156,1,130,64,2,0,26,136,123,7,0,84,28,1,130,65,
11,0,96,60,4,0,99,56,129,154,5,72,152,0,186,128,0,0,5,44,
44,0,130,64,100,0,120,56,109,154,5,72,20,0,218,128,118,7,198,84,
20,0,218,144,0,0,218,136,2,0,154,137,64,96,6,124,148,1,130,65,
96,1,0,72,0,0,29,44,96,0,130,65,16,0,217,136,116,7,198,124,
5,0,6,44,1,0,0,56,16,0,130,65,6,0,6,44,8,0,130,65,
0,0,0,56,63,6,0,84,24,0,130,64,11,0,96,60,232,255,99,56,
17,154,5,72,120,219,99,127,225,157,8,72,2,0,154,137,0,0,218,136,
64,96,6,124,20,0,250,128,118,7,231,84,20,0,250,144,48,1,130,65,
252,0,0,72,11,0,96,60,112,0,99,56,221,153,5,72,132,0,122,128,
0,0,3,44,28,0,130,65,49,28,6,72,132,0,122,128,25,0,154,136,
101,21,6,72,0,0,0,56,132,0,26,144,116,0,218,168,20,0,26,128,
120,203,35,127,1,0,160,56,62,6,255,87,48,248,164,124,208,0,70,125,
120,48,76,125,254,15,138,85,56,31,64,81,20,0,26,144,93,233,255,75,
0,0,218,136,2,0,154,137,64,96,6,124,188,0,130,65,136,0,0,72,
0,0,29,44,112,0,130,64,11,0,96,60,128,0,99,56,97,153,5,72,
116,0,250,168,20,0,186,128,208,0,103,125,120,56,96,125,255,15,10,84,
56,31,69,81,20,0,186,144,56,0,130,65,11,0,96,60,144,0,99,56,
53,153,5,72,120,203,35,127,62,6,255,87,1,0,0,57,48,248,4,125,
245,232,255,75,0,0,218,136,2,0,154,137,64,96,6,124,84,0,130,65,
32,0,0,72,11,0,96,60,168,0,99,56,1,153,5,72,0,0,218,136,
2,0,154,137,64,96,6,124,52,0,130,65,255,7,192,84,32,0,130,64,
11,0,96,60,28,0,99,56,221,152,5,72,2,0,186,136,0,0,218,136,
1,0,165,96,2,0,186,152,2,0,218,152,120,211,67,127,149,41,6,72,
32,0,65,131,44,0,161,131,48,0,193,131,36,0,97,131,28,0,33,131,
40,0,129,131,52,0,225,131,60,0,1,128,24,0,1,131,20,0,225,130,
166,3,8,124,56,0,33,56,32,0,128,78,216,255,33,148,8,0,1,147,
12,0,33,147,20,0,97,147,24,0,129,147,36,0,225,147,166,2,8,124,
44,0,1,144,16,0,65,147,120,27,122,124,28,0,161,147,120,35,157,124,
32,0,193,147,0,0,192,63,68,71,126,56,255,255,128,56,57,19,9,72,
0,0,3,44,240,255,130,64,25,0,26,136,16,0,0,40,0,0,224,59,
28,0,128,64,58,16,12,84,20,2,44,125,56,24,41,85,0,0,73,61,
96,66,42,57,8,0,233,131,0,0,31,44,24,0,130,64,11,0,96,60,
12,1,99,56,103,11,128,56,0,0,160,56,33,57,255,75,104,0,127,129,
132,0,139,129,120,251,227,127,1,0,128,56,166,3,137,125,33,4,128,78,
0,0,29,44,32,1,130,64,16,0,0,72,120,211,67,127,120,251,228,127,
197,29,6,72,116,0,26,169,0,0,8,44,32,0,130,65,108,0,250,131,
108,0,122,56,120,251,228,127,185,114,8,72,0,0,31,44,212,255,130,64,
36,0,0,72,0,0,224,59,28,0,0,72,52,0,31,128,64,0,0,100,
120,211,67,127,120,251,228,127,52,0,31,144,221,19,6,72,128,0,90,169,
0,0,10,44,32,0,130,65,120,0,250,131,120,0,122,56,120,251,228,127,
113,114,8,72,0,0,31,44,200,255,130,64,8,0,0,72,0,0,224,59,
48,0,96,59,23,0,128,63,204,20,156,59,5,0,0,59,0,0,160,59,
120,227,153,127,19,0,57,137,116,7,41,125,5,0,9,44,104,0,130,65,
0,0,121,129,64,208,11,124,92,0,130,64,28,0,0,72,52,0,159,129,
64,0,140,101,120,211,67,127,120,251,228,127,52,0,159,145,97,19,6,72,
12,0,25,168,0,0,0,44,32,0,130,65,4,0,249,131,4,0,121,56,
120,251,228,127,245,113,8,72,0,0,31,44,200,255,130,64,8,0,0,72,
0,0,224,59,16,0,185,179,19,0,25,155,120,203,35,127,157,20,6,72,
255,255,123,55,20,0,156,59,128,255,130,64,68,71,126,56,45,14,9,72,
0,0,3,44,28,0,130,65,11,0,96,60,116,254,99,56,6,1,128,56,
0,0,160,56,193,55,255,75,0,0,3,44,20,0,97,131,32,0,193,131,
28,0,161,131,16,0,65,131,24,0,129,131,36,0,225,131,44,0,1,128,
12,0,33,131,8,0,1,131,166,3,8,124,40,0,33,56,32,0,128,78,
232,255,33,148,16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,
12,0,161,147,120,27,125,124,0,0,128,56,189,253,255,75,20,0,29,128,
254,255,30,84,0,0,30,44,24,0,130,65,44,0,125,56,201,170,7,72,
121,27,127,124,80,0,130,65,48,0,0,72,104,0,29,168,0,0,0,44,
24,0,130,65,96,0,253,131,96,0,125,56,120,251,228,127,13,113,8,72,
8,0,0,72,0,0,224,59,0,0,31,44,32,0,130,65,52,0,127,129,
64,0,107,101,120,235,163,127,120,251,228,127,52,0,127,145,53,18,6,72,
160,255,255,75,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,19,0,128,61,216,179,140,129,5,0,0,56,104,192,13,152,
244,1,0,56,100,192,13,144,0,0,0,56,108,192,13,144,112,22,140,125,
148,1,12,124,58,16,12,84,80,96,128,125,112,192,141,145,85,111,6,72,
25,105,6,72,117,1,0,72,173,243,255,75,65,174,7,72,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,20,0,225,147,
166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,20,0,30,129,
120,35,159,124,255,255,32,57,4,0,62,145,8,0,62,145,0,0,192,56,
12,0,222,144,16,0,222,152,17,0,222,152,255,7,7,85,18,0,222,152,
19,0,222,152,36,0,130,65,152,0,126,129,0,0,11,44,24,0,130,65,
120,243,195,127,0,0,128,56,109,252,255,75,20,0,222,128,254,7,199,84,
0,0,64,57,21,0,94,153,23,0,94,153,20,0,126,129,0,0,7,44,
1,0,0,56,0,0,30,152,1,0,30,152,144,0,94,177,146,0,94,177,
148,0,94,177,150,0,94,177,132,0,94,145,156,0,94,177,152,0,94,145,
26,0,30,152,163,0,94,153,162,0,30,152,118,7,107,85,161,0,30,152,
160,0,94,153,20,0,126,145,68,0,130,64,1,0,128,57,2,0,158,153,
1,0,96,97,20,0,30,144,32,0,126,56,65,104,6,72,44,0,126,56,
0,0,128,56,49,172,7,72,96,0,126,56,145,112,8,72,108,0,126,56,
137,112,8,72,120,0,126,56,129,112,8,72,60,0,0,72,120,251,228,127,
8,0,97,56,153,243,255,75,32,0,126,56,5,104,6,72,44,0,126,56,
0,0,128,56,245,171,7,72,96,0,126,56,85,112,8,72,108,0,126,56,
77,112,8,72,120,0,126,56,69,112,8,72,28,0,1,128,20,0,225,131,
16,0,193,131,166,3,8,124,24,0,33,56,32,0,128,78,24,0,96,61,
204,136,107,57,88,134,109,145,12,0,75,57,0,0,0,56,84,134,13,144,
255,53,32,57,166,3,41,125,248,255,74,145,244,255,10,144,252,255,10,144,
12,0,74,57,240,255,0,66,58,16,42,85,80,80,9,124,58,16,0,84,
20,2,75,125,0,0,0,56,4,0,10,144,0,0,10,144,8,0,10,144,
32,0,128,78,232,255,33,148,12,0,161,147,20,0,225,147,166,2,8,124,
28,0,1,144,16,0,193,147,120,27,126,124,8,0,30,169,1,0,8,44,
11,0,160,63,120,35,159,124,20,0,128,64,220,1,125,56,77,5,128,56,
0,0,160,56,141,52,255,75,166,0,0,125,94,4,7,85,36,1,224,124,
0,0,30,128,64,0,31,124,4,0,254,128,184,0,130,64,64,56,0,124,
108,0,130,64,8,0,126,169,0,128,0,113,0,0,128,57,255,255,107,57,
0,0,158,145,4,0,158,145,8,0,126,177,166,0,192,124,94,4,198,84,
120,3,198,124,36,1,192,124,53,7,107,125,20,1,128,64,220,1,125,56,
98,5,128,56,0,0,160,56,37,52,255,75,0,0,3,44,252,0,130,64,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,16,0,127,129,0,0,126,145,20,0,95,129,
16,0,106,145,16,0,63,129,8,0,158,169,255,255,140,57,0,128,0,113,
8,0,158,177,20,0,73,145,166,0,192,124,94,4,198,84,120,3,198,124,
36,1,192,124,53,7,140,125,140,0,128,65,156,0,0,72,20,0,95,129,
64,56,31,124,64,0,130,65,16,0,127,129,16,0,106,145,16,0,63,129,
8,0,158,169,255,255,140,57,0,128,0,113,8,0,158,177,20,0,73,145,
166,0,192,124,94,4,198,84,120,3,198,124,36,1,192,124,53,7,140,125,
68,0,128,65,84,0,0,72,4,0,94,145,16,0,127,129,16,0,106,145,
16,0,63,129,8,0,158,169,255,255,140,57,0,128,0,113,8,0,158,177,
20,0,73,145,166,0,192,124,94,4,198,84,120,3,198,124,36,1,192,124,
53,7,140,125,24,0,128,64,220,1,125,56,125,5,128,56,0,0,160,56,
41,51,255,75,0,0,3,44,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,166,2,8,124,28,0,1,144,20,0,225,147,120,27,127,124,
16,0,193,147,11,0,192,63,166,0,160,127,94,4,172,87,36,1,128,125,
8,0,31,169,0,0,8,44,56,0,130,64,44,2,126,56,16,5,128,56,
0,0,160,56,193,50,255,75,0,128,160,115,166,0,64,125,94,4,74,85,
120,3,74,125,36,1,64,125,8,0,127,169,0,0,11,44,116,0,128,65,
132,0,0,72,0,0,191,128,4,0,31,128,64,0,5,124,0,0,164,144,
28,0,130,64,0,0,0,56,4,0,31,144,0,0,31,144,255,255,8,56,
8,0,31,176,36,0,0,72,4,0,223,128,0,0,255,128,16,0,167,128,
255,255,8,56,8,0,31,176,0,0,191,144,20,0,197,144,16,0,166,144,
0,128,160,115,166,0,64,125,94,4,74,85,120,3,74,125,36,1,64,125,
8,0,127,169,0,0,11,44,24,0,128,64,44,2,126,56,54,5,128,56,
0,0,160,56,33,50,255,75,0,0,3,44,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
23,0,96,61,204,24,107,57,68,134,109,145,12,0,75,57,0,0,0,56,
64,134,13,144,255,7,32,57,166,3,41,125,248,255,74,145,244,255,10,144,
252,255,10,144,12,0,74,57,240,255,0,66,58,16,42,85,80,80,9,124,
58,16,0,84,20,2,75,125,0,0,0,56,4,0,10,144,0,0,10,144,
8,0,10,144,32,0,128,78,166,0,192,124,94,4,201,84,36,1,32,125,
8,0,131,169,0,0,12,44,52,0,130,64,0,0,131,144,4,0,131,144,
20,0,132,144,16,0,132,144,1,0,12,56,8,0,3,176,0,128,199,112,
166,0,0,125,94,4,8,85,120,59,8,125,36,1,0,125,32,0,128,78,
4,0,99,129,20,0,100,145,16,0,139,144,0,0,67,129,0,128,199,112,
1,0,12,56,8,0,3,176,16,0,68,145,20,0,138,144,4,0,131,144,
166,0,0,125,94,4,8,85,120,59,8,125,36,1,0,125,32,0,128,78,
0,0,4,44,120,27,108,124,0,0,96,56,32,0,130,77,252,255,108,57,
166,3,137,124,4,0,11,132,20,2,99,124,248,255,0,66,32,0,128,78,
0,0,4,44,0,0,128,57,24,0,130,65,252,255,99,57,166,3,137,124,
4,0,11,132,20,2,140,125,248,255,0,66,208,0,108,124,32,0,128,78,
232,255,33,148,12,0,161,147,16,0,193,147,20,0,225,147,166,2,8,124,
28,0,1,144,96,134,109,128,189,123,5,72,121,27,125,124,120,235,190,127,
24,0,130,64,11,0,96,60,52,3,99,56,69,1,128,56,0,0,160,56,
149,48,255,75,92,134,109,128,96,134,173,128,120,235,164,127,105,76,8,72,
121,27,127,124,64,0,130,65,120,251,229,127,249,0,96,56,11,0,128,60,
76,3,132,56,165,51,255,75,120,243,195,127,109,123,5,72,120,251,227,127,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,44,128,13,129,14,0,224,56,255,255,61,57,
255,255,72,57,166,3,233,124,1,0,105,141,1,0,138,141,81,88,12,124,
8,0,130,64,240,255,0,66,0,0,0,44,56,0,130,65,248,0,96,56,
112,130,130,56,65,51,255,75,120,243,195,127,9,123,5,72,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,248,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,96,134,13,128,120,235,163,127,190,240,4,84,
173,254,255,75,0,0,3,44,56,0,130,65,247,0,96,56,112,130,130,56,
245,50,255,75,120,243,195,127,189,122,5,72,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,247,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,14,0,189,59,120,235,163,127,229,180,8,72,20,26,189,127,
120,235,163,127,1,104,8,72,20,26,189,127,120,235,163,127,37,99,6,72,
20,26,189,127,120,235,163,127,109,8,6,72,20,26,189,127,120,235,163,127,
185,70,6,72,20,26,189,127,120,235,163,127,97,166,7,72,20,26,189,127,
120,235,163,127,249,253,5,72,20,26,189,127,120,235,163,127,29,41,8,72,
20,26,125,124,141,93,4,72,217,92,4,72,120,243,195,127,41,122,5,72,
20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,0,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,12,0,161,147,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,96,134,109,128,
229,121,5,72,121,27,125,124,120,235,191,127,24,0,130,64,11,0,96,60,
88,3,99,56,186,0,128,56,0,0,160,56,189,46,255,75,96,134,173,128,
120,251,227,127,0,0,128,56,157,41,255,75,44,128,141,128,120,251,227,127,
14,0,160,56,33,172,5,72,14,0,255,59,166,0,192,127,94,4,204,87,
36,1,128,125,120,251,227,127,109,180,8,72,20,26,255,127,120,251,227,127,
97,103,8,72,20,26,255,127,120,251,227,127,137,98,6,72,20,26,255,127,
120,251,227,127,189,7,6,72,20,26,255,127,120,251,227,127,65,70,6,72,
20,26,255,127,120,251,227,127,177,165,7,72,20,26,255,127,120,251,227,127,
57,254,5,72,20,26,255,127,120,251,227,127,153,40,8,72,20,26,127,124,
65,93,4,72,96,134,77,129,252,255,42,57,120,235,163,127,190,240,36,85,
29,253,255,75,8,0,97,144,20,74,125,124,8,0,129,56,4,0,160,56,
133,171,5,72,96,134,173,128,92,134,109,128,120,235,164,127,29,89,8,72,
120,27,127,124,9,178,8,72,120,27,100,124,19,0,96,60,112,177,99,56,
137,220,255,75,0,128,203,115,166,0,0,124,94,4,0,84,120,91,0,124,
36,1,0,124,120,235,163,127,201,120,5,72,120,251,227,127,20,0,225,131,
28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,141,98,4,72,
11,0,99,61,78,108,107,57,255,5,108,85,120,99,128,125,96,134,109,145,
20,0,130,65,80,88,128,125,0,2,108,57,96,134,109,145,255,5,108,85,
0,0,12,44,52,0,130,65,11,0,96,60,112,3,99,56,154,0,128,56,
0,0,160,56,73,45,255,75,96,134,109,129,0,0,3,44,20,0,130,65,
126,186,99,85,125,0,6,72,92,134,109,144,16,0,0,72,126,186,99,85,
109,0,6,72,92,134,109,144,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,0,0,0,56,28,0,128,61,72,85,12,152,12,0,96,60,
32,248,99,56,144,113,5,72,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,224,119,5,72,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,28,0,96,60,116,85,99,56,0,2,128,56,120,35,133,124,
5,0,192,56,0,1,224,56,120,59,232,124,3,0,32,57,217,137,3,72,
12,0,96,60,64,249,99,56,61,113,5,72,28,0,224,63,180,85,127,56,
0,0,128,56,217,170,3,72,12,0,96,60,76,249,99,56,33,113,5,72,
28,0,96,60,76,85,99,56,0,0,128,56,49,155,3,72,12,0,96,60,
88,249,99,56,5,113,5,72,180,85,191,56,28,0,96,60,240,85,99,56,
22,0,128,56,21,181,255,75,12,0,96,60,100,249,99,56,229,112,5,72,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,8,0,193,147,12,0,225,147,166,2,8,124,20,0,1,144,
109,110,3,72,120,27,126,124,217,117,3,72,120,27,127,124,20,242,3,125,
136,130,130,57,255,255,44,57,132,130,194,56,255,255,6,56,16,1,0,72,
255,255,159,57,120,3,6,124,4,0,96,57,166,3,105,125,1,0,76,141,
1,0,166,140,81,80,229,124,16,0,130,64,0,0,10,44,8,0,130,65,
232,255,0,66,0,0,7,44,216,0,130,64,4,0,255,59,255,255,159,57,
120,99,134,125,1,0,230,140,117,7,231,124,248,255,130,64,81,48,127,125,
184,0,130,65,20,90,159,124,120,75,37,125,4,0,64,57,166,3,73,125,
1,0,228,140,1,0,101,141,81,56,203,124,16,0,130,64,0,0,7,44,
8,0,130,65,232,255,0,66,0,0,6,44,132,0,130,64,56,128,77,57,
255,255,170,56,16,0,96,57,166,3,105,125,1,0,12,140,116,7,0,124,
121,3,7,124,1,0,5,156,20,0,130,64,0,0,11,44,255,255,165,56,
24,0,130,64,52,0,0,72,255,255,107,57,216,255,0,66,0,0,11,44,
36,0,130,65,1,0,11,40,120,91,96,125,0,0,32,57,8,0,128,64,
1,0,0,56,166,3,9,124,1,0,37,157,252,255,0,66,0,0,0,56,
72,128,13,152,11,0,96,60,128,4,99,56,56,128,141,56,213,137,5,72,
32,0,0,72,1,0,255,59,0,64,31,124,240,254,128,65,11,0,96,60,
128,4,99,56,56,128,141,56,181,137,5,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,1,0,3,40,0,0,4,168,20,0,128,65,
52,0,130,65,2,0,3,40,136,0,130,65,144,0,0,72,11,0,96,60,
152,4,99,56,105,137,5,72,157,183,4,72,244,1,96,56,129,76,5,72,
140,130,98,56,85,137,5,72,124,0,0,72,62,4,0,84,255,231,12,84,
52,0,130,65,11,0,96,60,192,4,99,56,57,137,5,72,255,255,96,56,
81,132,6,72,41,225,8,72,69,132,6,72,244,1,96,56,69,76,5,72,
140,130,98,56,25,137,5,72,64,0,0,72,11,0,96,60,168,4,99,56,
9,137,5,72,244,1,96,56,37,76,5,72,140,130,98,56,249,136,5,72,
32,0,0,72,11,0,96,60,208,4,99,56,233,136,5,72,244,1,96,56,
5,76,5,72,140,130,98,56,217,136,5,72,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,216,255,33,148,20,0,97,147,24,0,129,147,
28,0,161,147,32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,
0,0,228,171,120,27,126,124,85,73,1,72,0,0,3,44,20,0,130,64,
11,0,96,60,36,5,99,56,137,136,5,72,180,1,0,72,1,0,128,59,
120,243,195,127,0,0,96,59,120,219,100,127,120,219,101,127,8,0,193,56,
29,30,8,72,120,27,125,124,120,243,195,127,120,235,164,127,117,208,5,72,
0,0,253,168,0,0,7,44,248,255,130,64,12,0,29,169,0,0,8,44,
20,0,130,64,10,0,1,160,0,0,0,44,8,0,130,64,0,0,128,59,
0,0,32,57,0,0,61,177,120,235,163,127,5,24,9,72,255,7,234,87,
112,0,130,65,120,243,195,127,109,192,7,72,121,27,123,124,48,0,130,64,
120,243,195,127,153,77,1,72,120,243,198,127,120,27,101,124,34,0,96,56,
11,0,128,60,56,5,132,56,73,44,255,75,0,0,28,44,252,0,130,65,
72,0,0,72,1,16,27,44,28,0,130,65,11,0,96,60,244,4,99,56,
201,135,5,72,0,0,28,44,220,0,130,65,40,0,0,72,0,0,28,44,
0,0,96,59,204,0,130,65,24,0,0,72,11,0,96,60,220,4,99,56,
161,135,5,72,0,0,28,44,180,0,130,65,128,134,141,137,117,7,140,125,
168,0,130,64,62,4,255,87,255,255,224,87,128,0,130,65,0,0,27,44,
120,0,130,64,120,243,195,127,109,192,7,72,120,27,123,124,96,2,27,44,
36,0,130,64,120,243,197,127,15,0,96,56,144,130,130,56,181,43,255,75,
244,1,96,56,113,74,5,72,152,130,98,56,112,0,0,72,0,0,27,44,
32,0,130,64,11,0,96,60,76,5,99,56,49,135,5,72,244,1,96,56,
77,74,5,72,152,130,98,56,76,0,0,72,11,0,96,60,12,5,99,56,
21,135,5,72,244,1,96,56,49,74,5,72,152,130,98,56,48,0,0,72,
11,0,96,60,100,5,99,56,249,134,5,72,244,1,96,56,21,74,5,72,
152,130,98,56,20,0,0,72,11,0,96,60,124,5,99,56,221,134,5,72,
152,130,98,56,213,134,5,72,28,0,161,131,32,0,193,131,36,0,225,131,
44,0,1,128,24,0,129,131,20,0,97,131,166,3,8,124,40,0,33,56,
32,0,128,78,56,255,33,148,160,0,193,146,164,0,225,146,168,0,1,147,
172,0,33,147,180,0,97,147,188,0,161,147,196,0,225,147,176,0,65,147,
0,32,64,63,255,255,90,59,184,0,129,147,0,0,128,59,192,0,193,147,
12,0,192,63,184,248,222,59,248,255,190,56,166,2,8,124,204,0,1,144,
17,0,0,56,166,3,9,124,8,0,197,172,64,48,3,124,12,0,130,65,
1,0,156,59,240,255,0,66,17,0,28,44,8,0,130,64,16,0,128,59,
16,0,96,56,177,112,5,72,0,0,3,44,20,0,130,65,0,0,0,57,
4,0,3,145,8,0,3,145,12,0,3,145,120,27,125,124,4,0,221,128,
0,0,6,44,2,0,128,57,232,3,160,56,44,1,0,56,88,2,224,56,
0,0,0,57,100,0,129,153,96,0,161,144,88,0,1,144,84,0,1,153,
80,0,225,144,76,0,1,153,92,0,1,153,100,0,160,56,112,0,161,144,
104,0,161,144,3,0,128,57,108,0,129,153,16,0,130,65,8,0,29,129,
80,64,230,124,112,30,232,124,0,0,6,44,0,0,32,57,16,0,130,65,
12,0,93,129,80,80,38,125,112,30,41,125,8,0,157,128,64,72,8,124,
120,35,159,124,76,0,128,64,121,251,234,127,20,0,130,65,0,0,0,56,
0,0,10,152,232,3,160,56,4,0,170,144,8,0,223,56,56,24,128,87,
20,2,254,127,4,0,95,129,102,102,128,61,103,102,140,57,150,80,236,126,
8,0,221,144,112,254,64,125,112,22,247,126,80,184,224,126,112,12,0,72,
0,0,6,44,36,0,130,64,0,0,6,44,92,0,1,129,68,0,1,145,
96,0,33,129,0,0,96,59,72,0,33,145,96,0,130,65,80,0,0,72,
8,0,29,129,80,64,230,124,113,30,224,124,36,0,130,64,0,0,6,44,
92,0,1,129,68,0,1,145,96,0,33,129,0,0,96,59,72,0,33,145,
48,0,130,65,32,0,0,72,0,0,6,44,92,0,1,129,68,0,1,145,
96,0,33,129,0,0,96,59,72,0,33,145,16,0,130,65,12,0,189,128,
80,40,6,124,112,30,27,124,0,0,6,44,20,0,130,64,0,0,6,44,
0,0,64,57,176,8,130,65,160,8,0,72,8,0,29,129,80,64,230,124,
112,30,224,124,80,208,32,125,1,0,9,40,124,8,128,64,0,0,192,56,
24,0,193,152,44,0,225,59,60,0,193,144,44,0,193,152,11,0,0,63,
88,4,24,59,15,0,64,57,64,0,65,145,255,255,88,57,1,0,10,141,
117,7,8,125,248,255,130,64,64,0,161,128,16,0,5,40,80,80,88,127,
120,251,224,127,8,0,128,65,0,0,31,128,0,0,24,124,12,0,32,63,
168,2,128,65,16,0,5,40,120,251,234,127,8,0,128,65,0,0,95,129,
60,0,33,129,20,74,10,124,0,192,0,124,136,2,129,64,16,0,5,40,
120,251,230,127,8,0,128,65,0,0,223,128,80,192,102,127,64,216,9,124,
16,0,128,64,40,0,97,56,93,101,5,72,60,0,33,129,80,72,91,125,
64,80,26,124,8,0,128,64,120,211,74,127,212,87,25,131,20,82,251,126,
64,184,9,124,120,195,26,127,16,0,128,64,40,0,97,56,45,101,5,72,
60,0,33,129,80,72,23,124,64,208,0,124,8,0,128,64,120,3,26,124,
0,0,26,44,228,0,130,65,64,0,161,128,16,0,5,40,120,251,231,127,
8,0,128,65,0,0,255,128,16,0,5,40,20,186,231,124,120,251,232,127,
8,0,128,65,0,0,31,129,81,0,26,124,120,3,6,124,20,186,72,125,
20,210,10,125,128,0,130,65,80,56,168,124,64,48,5,124,68,0,129,65,
1,0,0,40,20,50,8,125,20,50,231,124,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,200,140,255,255,199,156,248,255,0,66,64,0,161,128,
16,0,5,40,60,0,33,129,80,72,26,124,120,251,234,127,76,0,128,65,
68,0,0,72,1,0,0,40,255,255,8,57,120,3,10,124,255,255,231,56,
8,0,128,64,1,0,64,57,166,3,73,125,1,0,40,141,1,0,39,157,
248,255,0,66,64,0,161,128,60,0,33,129,16,0,5,40,80,72,26,124,
120,251,234,127,8,0,128,65,0,0,95,129,0,0,96,57,25,0,97,153,
60,0,1,144,174,1,106,125,60,0,33,129,64,216,9,124,8,0,128,64,
120,75,59,125,0,0,27,44,236,2,130,65,64,0,161,128,16,0,5,40,
120,251,230,127,8,0,128,65,0,0,223,128,16,0,5,40,120,251,232,127,
8,0,128,65,0,0,31,129,80,72,27,124,121,3,10,124,120,83,71,125,
20,218,40,125,136,0,130,65,80,48,9,124,64,56,0,124,72,0,129,65,
1,0,10,40,20,58,198,124,120,83,72,125,20,58,41,125,8,0,128,64,
1,0,0,57,166,3,9,125,255,255,169,140,255,255,166,156,248,255,0,66,
64,0,161,128,16,0,5,40,60,0,33,129,80,72,27,124,120,251,233,127,
76,0,128,65,68,0,0,72,1,0,10,40,255,255,41,57,120,83,64,125,
255,255,198,56,8,0,128,64,1,0,0,56,166,3,9,124,1,0,9,141,
1,0,6,157,248,255,0,66,60,0,33,129,64,0,161,128,80,72,27,124,
16,0,5,40,120,251,233,127,8,0,128,65,0,0,63,129,0,0,96,57,
26,0,97,153,60,0,1,144,174,1,105,125,60,0,33,131,12,0,0,61,
76,248,8,57,124,0,1,145,120,195,8,127,64,200,8,124,30,0,97,153,
132,0,65,59,116,130,226,56,120,0,225,144,132,0,97,153,15,0,64,57,
148,0,97,145,128,0,97,59,152,0,65,145,24,2,128,64,16,2,0,72,
254,255,64,57,64,80,26,124,16,0,129,64,40,0,97,56,205,100,5,72,
64,0,161,128,64,208,5,124,232,0,128,64,60,0,225,130,254,255,0,56,
15,0,86,99,64,0,22,124,32,0,129,64,120,211,86,127,1,0,118,56,
221,107,5,72,0,0,23,44,120,27,123,124,104,0,130,65,68,0,0,72,
171,170,128,61,171,170,140,57,22,176,12,124,126,248,166,84,126,248,0,84,
64,48,0,124,20,0,128,64,254,255,70,33,64,80,5,124,8,0,129,65,
20,50,197,126,1,0,118,56,153,107,5,72,0,0,23,44,120,27,123,124,
36,0,130,65,64,0,1,128,16,0,0,40,120,219,99,127,120,251,228,127,
8,0,128,65,0,0,159,128,120,187,229,126,153,159,5,72,64,0,161,128,
16,0,5,40,12,0,128,65,0,0,127,128,253,108,5,72,16,0,22,40,
64,0,193,146,120,251,231,127,0,0,127,147,0,0,128,57,60,0,129,145,
37,0,129,153,8,0,128,65,120,219,103,127,0,0,26,44,0,0,96,57,
28,0,97,153,60,0,225,146,174,185,103,125,132,0,130,64,52,0,0,72,
0,0,26,44,36,0,130,64,16,0,5,40,120,251,234,127,8,0,128,65,
0,0,95,129,0,0,0,56,27,0,1,152,60,0,1,144,0,0,10,152,
0,0,26,44,80,0,130,64,212,87,25,131,60,0,33,131,12,0,0,61,
76,248,8,57,124,0,1,145,120,195,8,127,64,200,8,124,0,0,0,56,
30,0,1,152,132,0,65,59,116,130,226,56,120,0,225,144,132,0,1,152,
15,0,64,57,148,0,1,144,128,0,97,59,152,0,65,145,152,0,128,64,
144,0,0,72,64,0,161,128,16,0,5,40,120,251,227,127,8,0,128,65,
0,0,127,128,120,195,4,127,120,211,69,127,169,158,5,72,64,0,193,128,
16,0,6,40,120,251,233,127,8,0,128,65,0,0,63,129,0,0,96,57,
29,0,97,153,60,0,65,147,174,209,105,125,212,87,25,131,60,0,33,131,
12,0,0,61,76,248,8,57,124,0,1,145,120,195,8,127,64,200,8,124,
0,0,0,56,30,0,1,152,132,0,65,59,116,130,226,56,120,0,225,144,
132,0,1,152,15,0,64,57,148,0,1,144,128,0,97,59,152,0,65,145,
8,0,128,64,120,67,25,125,40,0,193,56,64,48,27,124,56,1,130,64,
20,0,27,128,64,200,0,124,16,0,128,64,120,219,99,127,205,96,5,72,
20,0,27,128,80,0,25,125,64,192,8,124,8,0,128,64,120,67,24,125,
0,0,24,44,144,2,130,65,24,0,219,128,16,0,6,40,120,211,74,127,
8,0,128,65,0,0,90,129,16,0,6,40,20,202,74,125,120,211,69,127,
8,0,128,65,0,0,186,128,81,64,24,125,120,67,12,125,20,202,229,124,
20,194,167,124,132,0,130,65,80,80,37,125,64,96,9,124,72,0,129,65,
1,0,8,40,20,98,74,125,120,67,0,125,20,98,165,124,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,5,140,255,255,10,156,248,255,0,66,
24,0,219,128,16,0,6,40,20,0,27,128,80,0,24,124,120,211,73,127,
76,0,128,65,68,0,0,72,1,0,8,40,255,255,165,56,120,67,6,125,
255,255,74,57,8,0,128,64,1,0,192,56,166,3,201,124,1,0,5,140,
1,0,10,156,248,255,0,66,24,0,219,128,20,0,27,128,16,0,6,40,
80,0,24,124,120,211,73,127,8,0,128,65,0,0,58,129,0,0,96,57,
31,0,97,153,20,0,27,144,174,1,105,125,12,0,128,61,216,87,140,129,
0,0,12,44,12,0,0,60,120,0,33,59,108,248,0,48,124,0,1,144,
176,1,130,64,184,1,0,72,254,255,192,56,64,48,25,124,12,0,129,64,
120,219,99,127,125,97,5,72,24,0,219,128,64,200,6,124,232,0,128,64,
20,0,251,130,254,255,0,56,15,0,54,99,64,0,22,124,32,0,129,64,
120,203,54,127,1,0,118,56,141,104,5,72,0,0,23,44,120,27,120,124,
72,0,130,64,100,0,0,72,171,170,128,61,171,170,140,57,22,176,12,124,
126,248,197,84,126,248,0,84,64,40,0,124,20,0,128,64,254,255,37,33,
64,72,6,124,8,0,129,65,20,42,198,126,1,0,118,56,73,104,5,72,
0,0,23,44,120,27,120,124,36,0,130,65,24,0,91,129,16,0,10,40,
120,195,3,127,120,211,68,127,8,0,128,65,0,0,154,128,120,187,229,126,
73,156,5,72,24,0,187,128,16,0,5,40,12,0,128,65,0,0,122,128,
173,105,5,72,16,0,22,40,120,211,74,127,0,0,128,57,38,0,129,153,
20,0,155,145,0,0,26,147,24,0,219,146,8,0,128,65,120,195,10,127,
0,0,25,44,0,0,96,57,33,0,97,153,20,0,251,146,174,185,106,125,
140,0,130,65,52,0,0,72,0,0,25,44,36,0,130,64,16,0,6,40,
120,211,71,127,8,0,128,65,0,0,250,128,0,0,64,57,32,0,65,153,
20,0,91,145,0,0,71,153,0,0,25,44,88,0,130,65,24,0,187,128,
16,0,5,40,120,211,67,127,8,0,128,65,0,0,122,128,64,0,193,128,
16,0,6,40,120,251,228,127,8,0,128,65,0,0,159,128,120,203,37,127,
149,155,5,72,24,0,251,128,16,0,7,40,120,211,71,127,8,0,128,65,
0,0,250,128,0,0,96,57,34,0,97,153,20,0,59,147,174,201,103,125,
12,0,128,61,216,87,140,129,0,0,12,44,12,0,0,60,120,0,33,59,
108,248,0,48,124,0,1,144,16,0,130,65,120,203,35,127,166,3,137,125,
33,4,128,78,4,0,89,129,28,0,170,128,120,203,35,127,166,3,169,124,
33,4,128,78,120,203,35,127,141,89,5,72,24,0,219,128,16,0,6,40,
12,0,128,65,0,0,122,128,141,104,5,72,0,0,0,57,35,0,1,153,
20,0,27,145,15,0,224,56,24,0,251,144,0,0,26,153,64,0,65,129,
16,0,10,40,12,0,128,65,0,0,127,128,97,104,5,72,0,0,160,56,
36,0,161,152,60,0,161,144,15,0,0,56,64,0,1,144,0,0,191,152,
36,3,0,72,0,0,6,44,0,0,64,57,16,0,130,65,8,0,189,128,
80,40,6,124,112,30,10,124,1,0,42,57,64,72,27,124,176,1,128,64,
126,248,104,87,80,208,72,125,64,216,10,124,0,0,0,56,8,0,128,65,
20,66,27,124,0,0,6,44,120,3,27,124,0,0,160,56,16,0,130,65,
8,0,189,128,80,40,6,124,112,30,5,124,1,0,229,56,64,56,27,124,
32,0,128,64,0,0,6,44,0,0,224,56,16,0,130,65,8,0,93,129,
80,80,38,125,112,30,39,125,1,0,103,59,64,208,27,124,68,0,129,64,
228,135,13,128,0,0,0,44,48,0,130,64,1,0,160,56,228,135,173,144,
11,0,192,60,72,4,198,56,220,135,205,144,12,0,224,60,140,248,231,56,
224,135,237,144,12,0,96,60,172,248,99,56,33,97,5,72,220,135,109,56,
105,88,5,72,56,24,122,87,120,211,67,127,205,101,5,72,4,0,125,129,
120,251,231,127,120,91,106,125,64,56,10,124,120,27,123,124,120,219,102,127,
44,0,130,65,121,51,197,124,20,0,130,65,0,0,10,137,0,0,5,153,
4,0,10,128,4,0,5,144,8,0,74,57,64,56,10,124,8,0,198,56,
220,255,130,64,121,51,199,124,20,0,130,65,68,0,129,137,0,0,135,153,
72,0,161,128,4,0,167,144,8,0,157,128,120,35,136,124,64,64,31,124,
8,0,198,56,44,0,130,65,121,51,199,124,20,0,130,65,0,0,31,136,
0,0,7,152,4,0,63,129,4,0,39,145,8,0,255,59,64,64,31,124,
8,0,198,56,220,255,130,64,4,0,221,128,0,0,6,44,0,0,160,56,
16,0,130,65,8,0,29,128,80,0,6,124,112,30,5,124,0,0,11,44,
1,0,229,59,36,0,130,65,120,91,106,125,64,32,10,124,16,0,130,65,
8,0,74,57,64,32,10,124,248,255,130,64,120,91,99,125,145,102,5,72,
20,210,219,124,12,0,221,144,56,24,231,87,20,58,27,125,8,0,29,145,
4,0,125,147,84,1,0,72,80,32,63,125,112,30,42,125,1,0,10,40,
176,0,128,64,120,35,135,124,120,251,232,127,64,56,8,124,8,0,63,57,
44,0,130,65,121,75,37,125,20,0,130,65,0,0,8,136,0,0,5,152,
4,0,200,128,4,0,197,144,8,0,8,57,64,56,8,124,8,0,41,57,
220,255,130,64,1,0,202,32,0,0,6,44,68,0,65,57,120,35,133,124,
40,0,130,65,121,43,167,124,20,0,130,65,0,0,10,137,0,0,7,153,
4,0,10,128,4,0,7,144,255,255,198,52,8,0,165,56,224,255,130,64,
8,0,132,56,248,255,36,57,64,72,31,124,68,0,1,57,8,0,157,144,
184,0,130,65,0,0,200,128,0,0,223,144,4,0,232,128,4,0,255,144,
8,0,255,59,64,72,31,124,232,255,130,64,152,0,0,72,120,35,137,124,
248,255,201,56,120,51,197,124,64,72,5,124,44,0,130,65,121,35,135,124,
20,0,130,65,0,0,5,137,0,0,7,153,4,0,5,128,4,0,7,144,
8,0,165,56,64,72,5,124,8,0,132,56,220,255,130,64,120,251,232,127,
64,48,8,124,8,0,157,144,28,0,130,65,248,255,6,132,248,255,9,148,
4,0,6,128,64,48,8,124,4,0,9,144,236,255,130,64,120,251,234,127,
8,0,31,56,64,0,10,124,68,0,193,56,32,0,130,65,0,0,166,128,
0,0,170,144,4,0,230,128,4,0,234,144,8,0,74,57,64,0,10,124,
232,255,130,64,56,24,128,87,20,2,254,127,4,0,95,129,102,102,128,61,
103,102,140,57,150,80,236,126,112,254,64,125,112,22,247,126,80,184,224,126,
121,187,251,126,236,1,129,64,84,0,129,59,108,0,193,59,4,0,221,128,
0,0,6,44,0,0,160,56,16,0,130,65,8,0,253,128,80,56,166,124,
112,30,165,124,0,0,6,44,0,0,0,56,16,0,130,65,12,0,61,129,
80,72,6,125,112,30,0,125,8,0,157,128,64,0,5,124,48,0,128,64,
120,235,163,127,120,243,198,127,1,0,160,56,97,11,0,72,4,0,221,128,
0,0,6,44,0,0,0,57,120,27,100,124,8,0,157,144,176,0,130,65,
160,0,0,72,0,0,6,44,40,0,130,64,0,0,64,59,120,235,163,127,
120,243,198,127,8,0,129,144,8,0,129,56,1,0,160,56,93,11,0,72,
8,0,157,128,100,0,0,72,80,32,70,125,113,30,64,125,40,0,130,64,
0,0,64,59,120,235,163,127,120,243,198,127,8,0,129,144,8,0,129,56,
1,0,160,56,45,11,0,72,8,0,157,128,52,0,0,72,4,0,93,129,
1,0,160,56,8,0,129,144,120,243,198,127,120,235,163,127,80,32,10,124,
112,30,26,124,8,0,129,56,1,11,0,72,8,0,157,128,56,24,69,87,
20,42,24,127,4,0,221,128,0,0,6,44,0,0,0,57,16,0,130,65,
8,0,29,129,80,64,230,124,112,30,232,124,0,0,6,44,0,0,32,57,
16,0,130,65,12,0,93,129,80,80,38,125,112,30,41,125,64,72,8,124,
36,0,128,64,120,235,163,127,120,227,134,127,1,0,160,56,109,10,0,72,
255,255,123,55,8,0,125,144,180,254,130,64,144,0,0,72,0,0,6,44,
36,0,130,64,0,0,64,59,120,235,163,127,120,227,134,127,12,0,129,144,
12,0,129,56,1,0,160,56,117,10,0,72,96,0,0,72,8,0,189,128,
80,40,6,124,113,30,0,124,36,0,130,64,0,0,64,59,120,235,163,127,
120,227,134,127,12,0,129,144,12,0,129,56,1,0,160,56,69,10,0,72,
48,0,0,72,4,0,29,128,1,0,160,56,12,0,129,144,120,227,134,127,
120,235,163,127,80,32,0,124,112,30,26,124,12,0,129,56,29,10,0,72,
56,24,71,87,20,58,57,127,255,255,123,55,36,254,130,64,0,0,23,44,
236,0,130,65,4,0,221,128,0,0,6,44,0,0,0,56,16,0,130,65,
8,0,29,128,80,0,6,125,112,30,0,125,0,0,6,44,0,0,160,56,
16,0,130,65,12,0,189,128,80,40,70,125,112,30,69,125,8,0,157,128,
64,40,0,124,72,0,128,64,120,235,163,127,1,0,160,56,76,0,193,56,
121,9,0,72,4,0,31,128,102,102,128,61,103,102,140,57,150,0,12,125,
8,0,125,144,112,254,9,124,112,22,8,125,80,64,9,125,58,16,10,85,
20,66,10,125,60,8,8,85,80,0,40,125,148,0,0,72,0,0,6,44,
32,0,130,64,120,235,163,127,116,0,129,144,116,0,129,56,1,0,160,56,
76,0,193,56,97,9,0,72,68,0,0,72,80,32,198,124,113,30,199,124,
32,0,130,64,120,235,163,127,116,0,129,144,116,0,129,56,1,0,160,56,
76,0,193,56,57,9,0,72,28,0,0,72,120,235,163,127,116,0,129,144,
116,0,129,56,1,0,160,56,76,0,193,56,29,9,0,72,4,0,31,128,
102,102,128,61,103,102,140,57,150,0,12,125,112,254,9,124,112,22,8,125,
80,64,9,125,58,16,10,85,20,66,10,125,60,8,8,85,80,0,40,125,
0,0,0,59,0,72,24,124,100,0,193,59,84,0,129,59,44,2,128,64,
4,0,221,128,0,0,6,44,0,0,0,56,16,0,130,65,8,0,29,128,
80,0,166,124,112,30,160,124,0,0,6,44,0,0,160,56,16,0,130,65,
12,0,189,128,80,40,38,125,112,30,37,125,8,0,157,128,64,40,0,124,
48,0,128,64,120,235,163,127,120,243,198,127,1,0,160,56,81,8,0,72,
4,0,221,128,0,0,6,44,0,0,0,57,120,27,100,124,8,0,157,144,
168,0,130,65,152,0,0,72,0,0,6,44,36,0,130,64,120,235,163,127,
120,243,198,127,16,0,129,144,16,0,129,56,1,0,160,56,81,8,0,72,
8,0,157,128,96,0,0,72,80,32,198,124,113,30,192,124,36,0,130,64,
120,235,163,127,120,243,198,127,16,0,129,144,16,0,129,56,1,0,160,56,
37,8,0,72,8,0,157,128,52,0,0,72,4,0,61,129,1,0,160,56,
16,0,129,144,120,243,198,127,120,235,163,127,80,32,41,125,112,30,59,125,
16,0,129,56,249,7,0,72,8,0,157,128,56,24,106,87,20,82,57,127,
4,0,221,128,0,0,6,44,0,0,0,57,16,0,130,65,8,0,189,128,
80,40,6,124,112,30,8,124,0,0,6,44,0,0,32,57,16,0,130,65,
12,0,61,129,80,72,230,124,112,30,233,124,64,72,8,124,76,0,128,64,
120,235,163,127,120,227,134,127,1,0,160,56,101,7,0,72,4,0,31,128,
102,102,128,61,103,102,140,57,150,0,76,125,1,0,24,59,8,0,125,144,
112,254,7,124,112,22,74,125,80,80,71,125,58,16,72,85,20,82,72,125,
60,8,74,85,80,0,42,125,176,0,0,72,0,0,6,44,32,0,130,64,
120,235,163,127,120,227,134,127,20,0,129,144,20,0,129,56,1,0,160,56,
73,7,0,72,92,0,0,72,8,0,29,128,80,0,70,125,113,30,64,125,
32,0,130,64,120,235,163,127,120,227,134,127,20,0,129,144,20,0,129,56,
1,0,160,56,29,7,0,72,48,0,0,72,4,0,93,129,1,0,160,56,
20,0,129,144,120,227,134,127,120,235,163,127,80,32,234,124,112,30,251,124,
20,0,129,56,245,6,0,72,56,24,96,87,20,2,90,127,4,0,31,128,
102,102,128,61,103,102,140,57,150,0,76,125,1,0,24,59,112,254,7,124,
112,22,74,125,80,80,71,125,58,16,72,85,20,82,72,125,60,8,74,85,
80,0,42,125,0,72,24,124,220,253,128,65,120,235,163,127,45,163,3,72,
188,0,161,131,172,0,33,131,176,0,65,131,192,0,193,131,184,0,129,131,
168,0,1,131,180,0,97,131,196,0,225,131,204,0,1,128,164,0,225,130,
160,0,193,130,166,3,8,124,200,0,33,56,32,0,128,78,166,2,8,124,
4,0,1,144,232,255,33,148,220,168,13,128,8,0,1,144,8,0,97,56,
245,148,5,72,120,27,102,124,12,0,97,56,9,0,128,56,154,130,162,56,
129,126,5,72,11,0,96,60,180,5,99,56,12,0,129,56,25,115,5,72,
192,136,141,128,11,0,96,60,200,5,99,56,9,115,5,72,200,192,141,128,
11,0,96,60,220,5,99,56,249,114,5,72,173,12,8,72,120,27,100,124,
11,0,96,60,240,5,99,56,229,114,5,72,4,192,141,128,11,0,96,60,
4,6,99,56,213,114,5,72,181,167,3,72,120,27,100,124,11,0,96,60,
24,6,99,56,193,114,5,72,160,192,141,128,11,0,96,60,44,6,99,56,
177,114,5,72,105,230,5,72,120,27,100,124,11,0,96,60,64,6,99,56,
157,114,5,72,173,230,5,72,120,27,100,124,11,0,96,60,84,6,99,56,
137,114,5,72,28,0,1,128,24,0,33,56,166,3,8,124,32,0,128,78,
224,255,33,148,24,0,193,147,28,0,225,147,121,27,104,124,166,2,8,124,
36,0,1,144,60,0,130,65,120,134,109,161,16,0,128,56,120,67,107,125,
0,0,160,56,212,192,109,56,120,134,109,177,52,128,173,144,117,242,8,72,
36,0,1,128,28,0,225,131,24,0,193,131,166,3,8,124,32,0,33,56,
32,0,128,78,8,0,97,56,16,0,129,56,105,5,5,72,52,128,205,131,
120,134,237,163,137,136,192,60,137,136,198,56,22,24,198,124,19,0,30,44,
126,217,198,84,64,0,130,64,5,0,70,57,13,208,0,60,209,0,0,96,
150,80,224,124,20,58,234,124,112,254,73,125,112,110,231,124,80,56,233,124,
96,39,231,28,11,0,96,60,120,6,99,56,80,80,135,125,48,128,141,145,
193,113,5,72,156,0,0,72,19,0,30,44,136,0,129,64,48,128,13,128,
80,0,70,125,10,0,10,44,0,0,224,59,12,0,129,64,0,0,0,56,
48,128,13,144,138,134,109,161,7,0,32,57,28,0,160,60,0,0,64,57,
224,85,165,56,166,3,41,125,60,8,76,85,174,42,140,125,0,96,0,124,
20,0,129,65,0,96,6,124,12,0,128,65,120,91,255,127,62,4,255,87,
1,0,74,57,220,255,0,66,0,0,31,44,28,0,130,65,0,0,192,59,
52,128,205,147,11,0,96,60,120,6,99,56,61,113,5,72,24,0,0,72,
19,0,30,44,16,0,129,65,11,0,96,60,120,6,99,56,37,113,5,72,
16,0,30,44,64,0,128,64,120,243,196,127,11,0,96,60,156,6,99,56,
13,113,5,72,10,0,225,179,120,243,195,127,10,0,129,56,57,232,255,75,
166,0,0,125,94,4,9,85,36,1,32,125,52,128,109,129,64,88,30,124,
200,0,130,64,176,0,0,72,19,0,30,44,64,0,128,64,240,255,158,56,
11,0,96,60,104,6,99,56,201,112,5,72,12,0,225,179,240,255,126,56,
12,0,129,56,33,231,255,75,166,0,0,125,94,4,9,85,36,1,32,125,
52,128,109,129,64,88,30,124,132,0,130,64,108,0,0,72,19,0,30,44,
16,0,130,64,11,0,96,60,132,6,99,56,137,112,5,72,166,0,64,125,
94,4,64,85,36,1,0,124,52,128,13,128,64,0,30,124,20,0,130,64,
1,0,190,56,52,128,173,144,0,0,192,56,120,134,205,176,0,128,71,113,
166,0,0,125,94,4,8,85,120,59,8,125,36,1,0,125,36,0,1,128,
28,0,225,131,24,0,193,131,166,3,8,124,32,0,33,56,32,0,128,78,
1,0,158,57,52,128,141,145,120,134,173,160,120,251,165,124,120,134,173,176,
0,128,7,113,166,0,0,125,94,4,8,85,120,59,8,125,36,1,0,125,
212,192,109,56,16,0,128,56,0,0,160,56,53,240,8,72,36,0,1,128,
28,0,225,131,24,0,193,131,166,3,8,124,32,0,33,56,32,0,128,78,
196,136,109,161,0,0,3,44,62,4,96,84,246,38,11,80,0,32,128,61,
0,0,140,57,196,136,109,177,16,0,130,65,32,0,0,56,24,0,12,144,
32,0,128,78,32,0,96,57,28,0,108,145,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,120,27,106,124,124,134,77,153,52,0,76,125,
126,217,131,85,173,255,255,75,2,0,10,40,40,0,130,65,3,0,10,40,
40,0,130,64,192,136,141,129,1,0,140,57,192,136,141,145,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,0,0,0,56,192,136,13,144,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,120,27,106,124,124,134,77,153,125,134,141,152,
0,0,96,56,73,255,255,75,196,136,13,160,3,0,10,44,110,6,0,84,
196,136,13,176,16,0,130,65,0,0,0,56,192,136,13,144,196,136,13,176,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
12,0,225,147,0,0,224,59,166,2,8,124,20,0,1,144,128,134,237,155,
255,0,96,57,136,134,109,153,29,217,255,75,21,9,8,72,233,188,5,72,
137,21,255,75,101,73,8,72,225,221,4,72,125,79,8,72,57,64,4,72,
161,65,4,72,141,241,7,72,97,153,7,72,177,104,6,72,241,106,6,72,
69,170,6,72,169,204,255,75,221,19,255,75,121,194,4,72,153,104,1,72,
101,61,1,72,141,131,0,72,185,131,0,72,33,206,8,72,193,3,5,72,
145,161,4,72,113,23,3,72,253,225,255,75,113,221,4,72,229,228,5,72,
28,0,128,61,222,85,140,57,7,0,0,56,166,3,9,124,2,0,236,183,
160,5,255,59,248,255,0,66,3,0,0,56,138,134,13,176,18,17,96,60,
255,255,99,56,121,232,3,72,86,85,96,60,187,187,99,56,109,232,3,72,
154,153,96,60,187,187,99,56,97,232,3,72,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,0,0,96,56,109,109,6,72,116,7,101,124,126,134,173,152,
80,128,109,56,160,130,130,56,229,99,5,72,11,0,96,60,168,6,99,56,
76,128,141,56,213,109,5,72,126,134,109,136,116,7,99,124,109,117,6,72,
121,94,3,72,177,226,255,75,69,68,96,60,204,204,99,56,245,231,3,72,
35,34,96,60,238,238,99,56,233,231,3,72,120,119,96,60,153,153,99,56,
221,231,3,72,0,0,96,56,73,155,3,72,0,0,96,56,65,73,4,72,
1,0,96,56,213,91,255,75,0,0,96,56,157,253,255,75,0,32,128,61,
108,0,140,129,62,70,128,85,28,0,96,60,76,85,99,56,132,134,13,144,
49,125,3,72,28,0,96,60,180,85,99,56,25,139,3,72,29,248,4,72,
245,246,4,72,185,246,4,72,197,151,255,75,0,0,96,56,117,230,5,72,
45,197,255,75,181,128,1,72,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,121,43,170,124,120,35,136,124,40,0,130,65,121,67,12,125,
20,0,130,65,0,0,230,136,0,0,236,152,4,0,38,129,4,0,44,145,
255,255,74,53,8,0,8,57,224,255,130,64,56,24,160,84,20,2,100,124,
32,0,128,78,128,255,33,148,100,0,33,147,104,0,65,147,108,0,97,147,
116,0,161,147,120,0,193,147,124,0,225,147,166,2,8,124,132,0,1,144,
112,0,129,147,120,43,188,124,252,255,166,56,0,0,198,128,0,0,196,131,
52,0,193,144,8,0,229,128,120,27,125,124,56,0,225,144,4,0,29,129,
0,0,8,44,0,0,224,59,0,32,32,61,255,255,41,57,16,0,130,65,
12,0,93,129,80,80,8,124,112,30,31,124,0,0,28,44,56,12,130,65,
0,0,8,44,0,0,64,57,16,0,130,65,8,0,189,128,80,40,8,124,
112,30,10,124,80,72,202,124,64,224,6,124,168,8,128,64,15,0,224,56,
48,0,225,144,0,0,64,57,8,0,65,153,44,0,65,145,28,0,193,59,
28,0,65,153,11,0,160,63,88,4,189,59,255,255,61,57,1,0,169,140,
117,7,165,124,248,255,130,64,48,0,225,128,16,0,7,40,80,72,125,127,
120,243,202,127,8,0,128,65,0,0,94,129,0,80,29,124,12,0,128,63,
172,2,128,65,16,0,7,40,120,243,201,127,8,0,128,65,0,0,62,129,
44,0,129,129,20,98,9,124,0,232,0,124,140,2,129,64,16,0,7,40,
120,243,199,127,8,0,128,65,0,0,254,128,80,232,167,127,64,232,12,124,
16,0,128,64,24,0,97,56,17,77,5,72,44,0,129,129,80,96,29,125,
64,64,27,124,8,0,128,64,120,219,104,127,212,87,252,131,20,66,125,127,
64,216,12,124,120,251,252,127,16,0,128,64,24,0,97,56,225,76,5,72,
44,0,129,129,80,96,27,124,64,224,0,124,8,0,128,64,120,3,28,124,
0,0,28,44,232,0,130,65,48,0,225,128,16,0,7,40,120,243,202,127,
8,0,128,65,0,0,94,129,16,0,7,40,20,218,74,125,120,243,200,127,
8,0,128,65,0,0,30,129,81,0,28,124,120,3,9,124,20,218,200,124,
20,226,166,124,132,0,130,65,80,80,229,124,64,72,7,124,72,0,129,65,
1,0,0,40,20,74,74,125,120,3,6,124,20,74,165,124,8,0,128,64,
1,0,192,56,166,3,201,124,255,255,5,141,255,255,10,157,248,255,0,66,
48,0,225,128,16,0,7,40,44,0,129,129,80,96,28,124,120,243,199,127,
76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,120,3,7,124,
255,255,74,57,8,0,128,64,1,0,224,56,166,3,233,124,1,0,37,141,
1,0,42,157,248,255,0,66,48,0,225,128,44,0,129,129,16,0,7,40,
80,96,28,124,120,243,199,127,8,0,128,65,0,0,254,128,0,0,96,57,
9,0,97,153,44,0,1,144,174,1,103,125,44,0,129,129,64,232,12,124,
8,0,128,64,120,99,157,125,0,0,29,44,236,2,130,65,48,0,225,128,
16,0,7,40,120,243,198,127,8,0,128,65,0,0,222,128,16,0,7,40,
120,243,201,127,8,0,128,65,0,0,62,129,80,96,29,124,121,3,10,124,
120,83,69,125,20,234,41,125,136,0,130,65,80,48,9,124,64,40,0,124,
72,0,129,65,1,0,10,40,20,42,198,124,120,83,64,125,20,42,41,125,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,169,140,255,255,166,156,
248,255,0,66,48,0,225,128,16,0,7,40,44,0,129,129,120,243,197,127,
80,96,29,124,76,0,128,65,68,0,0,72,1,0,10,40,255,255,41,57,
120,83,69,125,255,255,198,56,8,0,128,64,1,0,160,56,166,3,169,124,
1,0,233,140,1,0,230,156,248,255,0,66,44,0,129,129,48,0,225,128,
80,96,29,124,16,0,7,40,120,243,197,127,8,0,128,65,0,0,190,128,
0,0,96,57,10,0,97,153,44,0,1,144,174,1,101,125,44,0,97,131,
12,0,0,60,76,248,0,48,64,0,1,144,120,251,224,127,64,216,0,124,
14,0,97,153,72,0,129,59,116,130,226,56,60,0,225,144,72,0,97,153,
15,0,64,57,88,0,97,145,68,0,161,59,92,0,65,145,20,2,128,65,
20,2,0,72,254,255,64,57,64,80,27,124,16,0,129,64,24,0,97,56,
125,76,5,72,48,0,225,128,64,216,7,124,232,0,128,64,44,0,33,131,
254,255,0,56,15,0,122,99,64,0,26,124,32,0,129,64,120,219,122,127,
1,0,122,56,141,83,5,72,0,0,25,44,120,27,127,124,72,0,130,64,
100,0,0,72,171,170,128,61,171,170,140,57,22,208,172,124,126,248,224,84,
126,248,165,84,64,0,5,124,20,0,128,64,254,255,192,32,64,48,7,124,
8,0,129,65,20,2,71,127,1,0,122,56,73,83,5,72,0,0,25,44,
120,27,127,124,36,0,130,65,48,0,1,128,16,0,0,40,120,251,227,127,
120,243,196,127,8,0,128,65,0,0,158,128,120,203,37,127,73,135,5,72,
48,0,33,129,16,0,9,40,12,0,128,65,0,0,126,128,173,84,5,72,
16,0,26,40,48,0,65,147,120,243,202,127,0,0,254,147,0,0,128,57,
44,0,129,145,21,0,129,153,8,0,128,65,120,251,234,127,0,0,27,44,
0,0,96,57,12,0,97,153,44,0,33,147,174,201,106,125,56,0,130,65,
128,0,0,72,0,0,27,44,36,0,130,64,16,0,7,40,120,243,200,127,
8,0,128,65,0,0,30,129,0,0,0,56,11,0,1,152,44,0,1,144,
0,0,8,152,0,0,27,44,80,0,130,64,44,0,97,131,212,87,252,131,
12,0,0,60,76,248,0,48,64,0,1,144,120,251,224,127,64,216,0,124,
15,0,64,57,68,0,161,59,92,0,65,145,0,0,160,56,72,0,129,59,
116,130,226,56,14,0,161,152,60,0,225,144,72,0,161,152,88,0,161,144,
148,0,128,65,148,0,0,72,48,0,161,128,16,0,5,40,120,243,195,127,
8,0,128,65,0,0,126,128,120,235,164,127,120,219,101,127,89,134,5,72,
48,0,1,128,16,0,0,40,120,243,198,127,8,0,128,65,0,0,222,128,
0,0,96,57,13,0,97,153,44,0,97,147,174,217,102,125,212,87,252,131,
44,0,97,131,12,0,0,60,76,248,0,48,64,0,1,144,120,251,224,127,
64,216,0,124,0,0,160,56,14,0,161,152,72,0,129,59,116,130,226,56,
60,0,225,144,72,0,161,152,15,0,64,57,88,0,161,144,68,0,161,59,
92,0,65,145,8,0,128,64,120,3,27,124,24,0,1,56,64,0,29,124,
56,1,130,64,20,0,221,128,64,216,6,124,16,0,128,64,120,235,163,127,
125,72,5,72,20,0,221,128,80,48,91,125,64,248,10,124,8,0,128,64,
120,83,95,125,0,0,31,44,144,2,130,65,24,0,189,128,16,0,5,40,
120,227,136,127,8,0,128,65,0,0,28,129,16,0,5,40,20,218,232,124,
120,227,137,127,8,0,128,65,0,0,60,129,81,80,31,124,20,218,9,125,
120,3,9,124,20,250,8,125,132,0,130,65,80,56,200,124,64,72,6,124,
72,0,129,65,1,0,0,40,20,74,231,124,120,3,10,124,20,74,8,125,
8,0,128,64,1,0,64,57,166,3,73,125,255,255,8,140,255,255,7,156,
248,255,0,66,24,0,189,128,16,0,5,40,20,0,221,128,80,48,63,125,
120,227,138,127,76,0,128,65,68,0,0,72,1,0,0,40,255,255,8,57,
120,3,9,124,255,255,231,56,8,0,128,64,1,0,32,57,166,3,41,125,
1,0,168,140,1,0,167,156,248,255,0,66,24,0,189,128,20,0,221,128,
16,0,5,40,80,48,63,125,120,227,138,127,8,0,128,65,0,0,92,129,
0,0,96,57,15,0,97,153,20,0,61,145,174,73,106,125,12,0,128,61,
216,87,140,129,0,0,12,44,12,0,160,60,60,0,225,59,108,248,165,56,
64,0,161,144,192,1,130,65,172,1,0,72,254,255,192,56,64,48,27,124,
12,0,129,64,120,235,163,127,45,73,5,72,24,0,189,128,64,216,5,124,
232,0,128,64,20,0,61,131,254,255,224,56,15,0,122,99,64,56,26,124,
32,0,129,64,120,219,122,127,1,0,122,56,61,80,5,72,0,0,25,44,
120,27,127,124,104,0,130,65,68,0,0,72,171,170,128,61,171,170,140,57,
22,208,12,124,126,248,168,84,126,248,0,84,64,64,0,124,20,0,128,64,
254,255,232,32,64,56,5,124,8,0,129,65,20,66,69,127,1,0,122,56,
249,79,5,72,0,0,25,44,120,27,127,124,36,0,130,65,24,0,61,129,
16,0,9,40,120,251,227,127,120,227,132,127,8,0,128,65,0,0,156,128,
120,203,37,127,249,131,5,72,24,0,93,129,16,0,10,40,12,0,128,65,
0,0,124,128,93,81,5,72,16,0,26,40,120,227,136,127,0,0,128,57,
22,0,129,153,20,0,157,145,0,0,252,147,24,0,93,147,8,0,128,65,
120,251,232,127,0,0,27,44,0,0,96,57,17,0,97,153,20,0,61,147,
174,201,104,125,56,0,130,64,136,0,0,72,0,0,27,44,36,0,130,64,
16,0,5,40,120,227,135,127,8,0,128,65,0,0,252,128,0,0,160,56,
16,0,161,152,20,0,189,144,0,0,167,152,0,0,27,44,88,0,130,65,
24,0,29,129,16,0,8,40,120,227,131,127,8,0,128,65,0,0,124,128,
48,0,65,129,16,0,10,40,120,243,196,127,8,0,128,65,0,0,158,128,
120,219,101,127,69,131,5,72,24,0,29,128,16,0,0,40,120,227,137,127,
8,0,128,65,0,0,60,129,0,0,96,57,18,0,97,153,20,0,125,147,
174,217,105,125,12,0,128,61,216,87,140,129,0,0,12,44,12,0,160,60,
60,0,225,59,108,248,165,56,64,0,161,144,20,0,130,65,120,251,227,127,
166,3,137,125,33,4,128,78,64,0,161,128,28,0,165,128,120,251,227,127,
166,3,169,124,33,4,128,78,120,251,227,127,61,65,5,72,24,0,221,128,
16,0,6,40,12,0,128,65,0,0,124,128,61,80,5,72,0,0,0,56,
19,0,1,152,20,0,29,144,15,0,224,56,24,0,253,144,0,0,28,152,
48,0,193,128,16,0,6,40,12,0,128,65,0,0,126,128,17,80,5,72,
0,0,0,56,20,0,1,152,44,0,1,144,15,0,224,56,48,0,225,144,
0,0,30,152,120,0,193,131,112,0,129,131,108,0,97,131,116,0,161,131,
124,0,225,131,132,0,1,128,104,0,65,131,100,0,33,131,166,3,8,124,
128,0,33,56,32,0,128,78,0,0,8,44,0,0,160,56,16,0,130,65,
8,0,29,128,80,0,168,124,112,30,165,124,20,226,5,124,64,0,31,124,
248,1,128,64,126,248,231,87,80,72,199,124,64,248,6,124,0,0,0,56,
8,0,128,65,20,58,31,124,0,0,8,44,120,3,31,124,0,0,64,57,
16,0,130,65,8,0,29,128,80,0,8,124,112,30,10,124,20,226,170,124,
64,40,31,124,32,0,128,64,0,0,8,44,0,0,160,56,16,0,130,65,
8,0,253,128,80,56,200,124,112,30,197,124,20,226,229,127,64,72,31,124,
68,0,129,64,228,135,13,128,0,0,0,44,48,0,130,64,1,0,32,57,
228,135,45,145,11,0,64,61,72,4,74,57,220,135,77,145,12,0,0,60,
140,248,0,48,224,135,13,144,12,0,96,60,172,248,99,56,169,72,5,72,
220,135,109,56,241,63,5,72,56,24,251,87,120,219,99,127,85,77,5,72,
4,0,253,128,120,243,201,127,120,59,230,124,64,72,6,124,120,27,127,124,
120,251,234,127,44,0,130,65,121,83,76,125,20,0,130,65,0,0,166,136,
0,0,172,152,4,0,6,129,4,0,12,145,8,0,198,56,64,72,6,124,
8,0,74,57,220,255,130,64,52,0,33,137,56,0,1,129,121,227,133,127,
120,83,76,125,116,7,41,125,32,0,130,65,121,99,134,125,12,0,130,65,
0,0,38,153,4,0,6,145,255,255,165,52,8,0,140,57,232,255,130,64,
8,0,61,129,120,75,40,125,64,64,30,124,56,24,128,87,20,2,74,125,
44,0,130,65,121,83,76,125,20,0,130,65,0,0,190,136,0,0,172,152,
4,0,222,128,4,0,204,144,8,0,222,59,64,64,30,124,8,0,74,57,
220,255,130,64,4,0,29,129,0,0,8,44,0,0,0,56,16,0,130,65,
8,0,29,128,80,0,72,125,112,30,64,125,0,0,7,44,20,2,156,127,
36,0,130,65,120,59,232,124,64,72,8,124,16,0,130,65,8,0,8,57,
64,72,8,124,248,255,130,64,120,59,227,124,249,77,5,72,20,218,191,124,
12,0,189,144,56,24,134,87,20,50,255,124,8,0,253,144,4,0,253,147,
120,0,193,131,112,0,129,131,108,0,97,131,116,0,161,131,124,0,225,131,
132,0,1,128,104,0,65,131,100,0,33,131,166,3,8,124,128,0,33,56,
32,0,128,78,8,0,61,129,80,72,30,125,112,30,5,125,64,224,5,124,
56,24,134,87,172,0,128,64,120,75,43,125,120,243,204,127,64,88,12,124,
20,50,254,124,44,0,130,65,121,59,232,124,20,0,130,65,0,0,76,137,
0,0,72,153,4,0,12,128,4,0,8,144,8,0,140,57,64,88,12,124,
8,0,231,56,220,255,130,64,56,0,65,129,52,0,1,136,81,224,229,124,
116,7,0,124,120,75,44,125,32,0,130,65,121,99,136,125,12,0,130,65,
0,0,8,152,4,0,72,145,255,255,231,52,8,0,140,57,232,255,130,64,
20,50,41,125,80,72,198,124,64,48,30,124,52,0,161,56,8,0,61,145,
184,0,130,65,0,0,69,129,0,0,94,145,4,0,5,128,4,0,30,144,
8,0,222,59,64,48,30,124,232,255,130,64,152,0,0,72,120,75,40,125,
80,64,230,124,120,59,236,124,64,64,12,124,44,0,130,65,121,75,42,125,
20,0,130,65,0,0,172,136,0,0,170,152,4,0,12,128,4,0,10,144,
8,0,140,57,64,64,12,124,8,0,41,57,220,255,130,64,120,243,204,127,
64,56,12,124,8,0,61,145,28,0,130,65,248,255,7,132,248,255,8,148,
4,0,167,128,64,56,12,124,4,0,168,144,236,255,130,64,120,243,199,127,
20,50,30,125,64,64,7,124,52,0,193,56,32,0,130,65,0,0,6,128,
0,0,7,144,4,0,166,128,4,0,167,144,8,0,231,56,64,64,7,124,
232,255,130,64,120,0,193,131,112,0,129,131,108,0,97,131,116,0,161,131,
124,0,225,131,132,0,1,128,104,0,65,131,100,0,33,131,166,3,8,124,
128,0,33,56,32,0,128,78,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,32,76,5,72,8,61,5,72,4,61,5,72,232,255,33,148,
12,0,161,147,166,2,8,124,28,0,1,144,16,0,193,147,121,27,126,124,
20,0,225,147,120,35,159,124,104,0,130,65,32,0,30,129,16,0,8,40,
12,0,190,59,40,0,128,64,15,0,32,57,32,0,62,145,0,0,64,57,
28,0,94,145,255,7,231,87,8,0,65,153,12,0,94,153,56,0,130,65,
44,0,0,72,12,0,126,128,185,75,5,72,15,0,32,57,32,0,62,145,
0,0,64,57,28,0,94,145,255,7,231,87,8,0,65,153,12,0,94,153,
12,0,130,65,120,243,195,127,145,75,5,72,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
92,60,5,72,32,0,3,128,16,0,0,40,12,0,128,65,12,0,99,128,
32,0,128,78,12,0,99,56,32,0,128,78,232,255,33,148,12,0,161,147,
166,2,8,124,28,0,1,144,16,0,193,147,121,27,126,124,20,0,225,147,
120,35,159,124,104,0,130,65,32,0,30,129,16,0,8,40,12,0,190,59,
40,0,128,64,15,0,32,57,32,0,62,145,0,0,64,57,28,0,94,145,
255,7,231,87,8,0,65,153,12,0,94,153,56,0,130,65,44,0,0,72,
12,0,126,128,245,74,5,72,15,0,32,57,32,0,62,145,0,0,64,57,
28,0,94,145,255,7,231,87,8,0,65,153,12,0,94,153,12,0,130,65,
120,243,195,127,205,74,5,72,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,32,0,128,78,
0,0,99,128,32,0,128,78,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,144,74,5,72,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,124,74,5,72,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,104,74,5,72,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,84,74,5,72,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,64,74,5,72,240,255,33,148,8,0,193,147,12,0,225,147,
166,2,8,124,20,0,1,144,255,255,128,56,255,255,132,60,134,51,128,124,
0,0,128,56,0,0,132,60,134,51,130,124,64,0,128,56,0,0,132,60,
134,51,131,124,128,255,128,56,255,255,132,60,134,51,132,124,0,0,128,56,
0,0,132,60,134,51,133,124,1,0,128,56,0,0,132,60,134,51,136,124,
255,255,128,56,255,255,132,60,134,51,128,124,0,0,64,57,58,16,76,85,
1,0,74,57,10,0,10,44,0,0,96,57,28,0,0,60,136,86,0,48,
46,1,108,125,228,255,128,65,233,253,4,72,166,0,224,127,94,4,235,87,
36,1,96,125,134,50,130,124,120,35,131,124,251,7,126,84,120,243,197,127,
134,51,162,124,0,128,236,115,166,0,0,124,94,4,0,84,120,99,0,124,
36,1,0,124,2,0,128,56,0,0,132,60,134,51,128,124,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,0,0,96,56,227,255,128,60,
0,160,132,96,134,3,114,124,134,3,147,124,16,0,96,56,0,2,128,60,
0,0,132,96,134,3,114,124,134,3,147,124,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,1,0,96,56,1,32,128,60,0,192,132,96,134,3,114,124,
134,3,147,124,2,0,96,56,17,32,128,60,0,192,132,96,134,3,114,124,
134,3,147,124,0,3,224,59,2,0,0,56,80,184,31,80,17,0,96,56,
120,251,228,127,134,3,114,124,134,3,147,124,2,0,0,56,0,2,224,59,
18,0,96,56,120,251,228,127,134,3,114,124,134,3,147,124,64,192,224,63,
35,0,96,56,120,251,228,127,134,3,114,124,134,3,147,124,134,66,152,124,
120,35,131,124,0,2,127,96,120,251,229,127,134,67,184,124,134,66,144,124,
120,35,131,124,0,2,127,96,120,251,229,127,134,67,176,124,16,39,96,56,
81,241,4,72,134,74,134,124,120,35,131,124,16,0,127,100,120,251,229,127,
134,75,166,124,172,4,0,124,20,0,1,128,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,8,0,193,147,12,0,225,147,
166,2,8,124,20,0,1,144,134,66,128,124,120,35,131,124,0,8,127,100,
120,251,229,127,134,67,160,124,0,48,96,60,0,49,128,60,0,0,160,56,
41,89,6,72,0,0,128,56,0,4,132,60,134,51,128,124,166,0,224,127,
94,4,224,87,36,1,0,124,134,50,130,124,120,35,131,124,0,4,126,100,
120,243,197,127,134,51,162,124,0,128,235,115,166,0,0,124,94,4,0,84,
120,91,0,124,36,1,0,124,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,140,134,141,129,255,255,140,53,
140,134,141,145,32,0,130,76,212,139,3,72,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,0,0,224,59,0,0,128,61,112,71,236,155,
12,0,96,60,112,249,99,56,9,65,5,72,0,0,128,61,148,71,236,155,
12,0,96,60,124,249,99,56,245,64,5,72,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,108,0,160,56,177,121,5,72,
20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,120,0,160,56,125,121,5,72,20,0,1,128,120,251,227,127,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,128,0,160,56,
73,121,5,72,20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,124,0,160,56,21,121,5,72,20,0,1,128,
120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
124,0,160,56,225,120,5,72,20,0,1,128,120,251,227,127,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,0,0,3,44,32,0,130,77,
255,7,128,84,32,0,130,77,44,70,5,72,0,0,3,44,32,0,130,77,
255,7,128,84,32,0,130,77,24,70,5,72,2,0,131,137,1,0,0,56,
254,255,139,85,1,0,99,105,0,0,4,144,32,0,128,78,120,27,108,124,
2,0,12,136,1,0,96,56,250,7,0,84,2,0,12,152,124,0,108,144,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,124,0,126,129,1,0,11,44,120,35,159,124,
40,0,130,64,2,0,30,136,0,0,159,128,2,0,0,96,2,0,30,152,
29,100,6,72,0,0,3,44,24,0,130,64,0,0,0,56,124,0,30,144,
120,243,195,127,120,251,228,127,81,152,6,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,7,0,127,137,
116,7,107,125,251,255,11,44,16,0,130,64,11,0,96,60,184,8,99,56,
37,89,5,72,1,0,159,136,108,0,191,168,11,0,96,60,196,8,99,56,
116,7,132,124,13,89,5,72,116,0,159,128,112,0,191,128,11,0,96,60,
212,8,99,56,249,88,5,72,120,251,227,127,213,121,6,72,100,0,67,29,
11,0,96,60,168,8,99,56,112,86,76,125,148,1,140,124,217,88,5,72,
2,0,31,136,254,255,4,84,11,0,96,60,236,8,99,56,197,88,5,72,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
7,0,159,137,116,7,140,125,251,255,12,44,16,0,130,64,11,0,96,60,
252,8,99,56,129,88,5,72,1,0,159,136,108,0,191,168,11,0,96,60,
8,9,99,56,116,7,132,124,105,88,5,72,116,0,159,128,112,0,191,128,
11,0,96,60,24,9,99,56,85,88,5,72,120,251,227,127,49,121,6,72,
100,0,3,28,11,0,96,60,48,9,99,56,112,86,0,124,148,1,128,124,
53,88,5,72,20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,240,255,33,148,173,151,6,72,
12,0,97,144,12,0,1,160,8,0,1,176,14,0,65,161,10,0,65,177,
8,0,97,129,255,7,107,85,16,0,130,65,8,0,1,128,128,0,0,96,
8,0,1,144,20,0,1,128,8,0,97,128,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,7,0,31,136,116,7,0,124,251,255,0,44,16,0,130,64,
11,0,96,60,88,9,99,56,161,87,5,72,1,0,159,136,108,0,191,168,
11,0,96,60,100,9,99,56,116,7,132,124,137,87,5,72,116,0,159,128,
112,0,191,128,11,0,96,60,64,9,99,56,117,87,5,72,20,0,1,128,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
7,0,223,139,116,7,222,127,31,0,30,44,64,0,130,64,0,0,127,137,
117,7,107,125,32,0,130,64,104,0,159,129,100,0,12,128,120,251,227,127,
166,3,9,124,33,4,128,78,0,0,3,44,24,0,130,65,116,0,159,129,
40,0,140,85,120,0,159,145,0,248,236,56,116,0,255,144,120,251,227,127,
229,150,6,72,31,0,30,44,16,0,130,64,2,0,31,137,1,0,8,97,
2,0,31,153,2,0,63,137,255,7,41,85,16,0,130,65,116,0,127,129,
0,8,11,56,120,0,31,144,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,120,35,159,124,
28,0,130,65,0,0,128,56,45,147,6,72,255,7,224,87,12,0,130,65,
120,243,195,127,153,66,5,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,2,0,3,136,250,7,0,84,
2,0,3,152,32,0,128,78,1,0,96,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,
120,35,159,124,28,0,130,65,0,0,128,56,197,146,6,72,255,7,224,87,
12,0,130,65,120,243,195,127,49,66,5,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,
120,35,159,124,28,0,130,65,0,0,128,56,117,146,6,72,255,7,224,87,
12,0,130,65,120,243,195,127,225,65,5,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,0,0,96,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,8,0,193,147,
121,27,126,124,12,0,225,147,120,35,159,124,28,0,130,65,0,0,128,56,
1,203,6,72,255,7,224,87,12,0,130,65,120,243,195,127,137,65,5,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,136,255,33,148,96,0,65,147,48,0,193,145,52,0,225,145,
56,0,1,146,60,0,33,146,64,0,65,146,68,0,97,146,72,0,129,146,
76,0,161,146,80,0,193,146,84,0,225,146,88,0,1,147,100,0,97,147,
104,0,129,147,108,0,161,147,112,0,193,147,116,0,225,147,166,2,8,124,
124,0,1,144,92,0,33,147,120,27,121,124,14,0,121,171,120,35,154,124,
12,0,26,131,0,0,128,57,121,195,128,125,8,0,250,130,120,43,178,124,
96,0,130,65,120,187,227,126,120,195,4,127,120,219,101,127,112,254,118,127,
120,179,198,126,41,112,5,72,120,35,159,124,120,27,126,124,214,177,126,125,
214,217,31,125,214,217,158,127,22,216,222,124,20,0,218,170,20,66,70,125,
20,90,170,127,16,184,60,125,20,178,105,125,64,216,11,124,0,0,250,130,
120,187,248,126,8,0,33,145,84,0,129,64,52,0,0,72,150,219,215,127,
214,217,158,127,16,184,60,125,0,0,250,130,20,0,218,170,20,178,105,125,
64,216,11,124,0,0,224,59,120,251,253,127,8,0,33,145,120,187,248,126,
32,0,129,64,77,229,7,72,14,0,121,171,10,0,128,61,120,27,120,124,
36,119,140,57,4,0,131,145,8,0,227,146,16,0,186,128,4,0,250,130,
28,0,26,128,8,0,1,129,16,0,225,146,40,0,1,144,28,0,161,144,
20,64,28,125,20,0,1,145,148,1,61,125,24,0,33,145,24,0,26,160,
36,0,1,176,8,0,1,128,80,216,64,125,0,80,22,124,36,0,97,129,
12,0,161,58,1,0,128,58,16,0,25,58,9,0,96,62,0,0,32,58,
176,108,115,58,120,83,70,125,8,0,128,64,120,179,198,126,184,7,107,85,
36,0,97,145,32,0,193,176,80,0,121,128,120,251,230,127,120,243,197,127,
0,0,224,56,121,50,8,72,120,27,110,124,166,0,32,125,94,4,44,85,
36,1,128,125,92,0,25,129,88,0,249,128,0,128,37,113,166,0,0,124,
94,4,0,84,120,43,0,124,36,1,0,124,12,0,117,131,8,0,85,131,
64,64,31,124,52,0,129,65,12,0,128,65,64,56,30,124,40,0,128,64,
0,0,21,147,120,115,195,125,85,49,8,72,4,0,112,128,104,0,35,129,
0,0,18,44,120,171,164,126,236,0,130,64,196,0,0,72,64,64,31,124,
144,0,130,64,64,56,30,124,136,0,130,64,2,0,217,136,115,6,198,84,
124,0,130,65,33,228,7,72,8,0,3,147,40,0,195,145,104,0,249,128,
4,0,99,146,52,1,7,128,166,3,9,124,0,0,117,144,0,0,131,178,
120,203,35,127,33,4,128,78,14,0,25,168,112,254,8,124,22,0,67,125,
214,1,196,124,214,1,131,127,214,65,3,124,4,0,112,128,8,0,97,129,
20,50,42,125,20,2,169,127,104,0,35,129,0,0,18,44,120,171,164,126,
20,88,188,124,8,0,181,144,148,1,221,124,12,0,213,144,88,0,130,64,
48,0,0,72,169,227,7,72,8,0,3,147,40,0,195,145,4,0,99,146,
0,0,117,144,0,0,131,178,0,0,112,128,104,0,35,129,0,0,18,44,
120,171,164,126,40,0,130,64,12,0,9,128,166,3,9,124,33,4,128,78,
20,0,21,168,80,176,192,126,53,7,214,126,1,0,49,58,40,0,130,64,
160,0,0,72,20,0,9,128,166,3,9,124,33,4,128,78,20,0,21,168,
80,176,192,126,53,7,214,126,1,0,49,58,128,0,130,65,16,0,213,128,
16,0,183,128,112,254,10,124,20,0,122,125,44,72,0,84,80,40,6,125,
8,0,117,145,81,0,8,124,20,81,155,125,12,0,149,145,24,0,128,65,
36,0,23,129,81,0,8,124,0,0,192,56,20,0,247,58,240,255,128,64,
14,0,57,169,0,72,22,124,20,66,198,124,20,2,230,124,120,75,40,125,
8,0,128,64,120,179,200,126,4,0,245,146,16,0,245,144,20,0,21,177,
1,0,222,51,148,1,255,127,0,0,0,56,8,0,1,144,4,254,255,75,
1,0,17,44,68,0,129,64,166,0,64,125,94,4,76,85,36,1,128,125,
0,0,120,169,0,128,69,113,21,138,107,125,0,0,120,177,166,0,0,124,
94,4,0,84,120,43,0,124,36,1,0,124,20,0,130,64,4,0,248,128,
120,195,3,127,166,3,233,124,33,4,128,78,100,0,97,131,68,0,97,130,
72,0,129,130,104,0,129,131,96,0,65,131,64,0,65,130,76,0,161,130,
108,0,161,131,92,0,33,131,60,0,33,130,80,0,193,130,112,0,193,131,
88,0,1,131,56,0,1,130,84,0,225,130,116,0,225,131,124,0,1,128,
52,0,225,129,48,0,193,129,166,3,8,124,120,0,33,56,32,0,128,78,
232,255,33,148,239,255,4,44,166,2,8,124,28,0,1,144,16,0,193,147,
120,43,190,124,20,0,225,147,120,51,223,124,12,0,161,147,120,27,125,124,
0,0,96,56,72,0,130,64,16,0,125,128,104,0,67,129,204,0,10,128,
239,255,128,56,166,3,9,124,33,4,128,78,0,0,3,44,136,0,130,64,
20,0,125,128,104,0,131,129,204,0,140,129,120,243,197,127,120,251,230,127,
239,255,128,56,166,3,137,125,33,4,128,78,100,0,0,72,255,255,4,44,
92,0,130,64,7,0,29,136,116,7,0,124,175,255,0,44,76,0,130,64,
100,0,157,129,88,0,61,129,92,0,93,129,64,96,10,124,96,0,125,129,
52,0,128,65,12,0,129,65,64,88,9,124,40,0,128,65,84,0,125,129,
0,0,11,44,255,255,0,56,7,0,29,152,20,0,130,65,1,0,0,57,
5,1,11,153,0,0,0,56,84,0,29,144,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
200,255,33,148,16,0,193,146,20,0,225,146,24,0,1,147,28,0,33,147,
32,0,65,147,36,0,97,147,40,0,129,147,48,0,193,147,52,0,225,147,
166,2,8,124,60,0,1,144,44,0,161,147,120,35,157,124,0,0,157,136,
116,7,132,124,2,0,4,44,120,59,254,124,120,27,120,124,76,0,130,65,
11,0,96,60,232,16,99,56,209,79,5,72,28,0,33,131,44,0,161,131,
48,0,193,131,32,0,65,131,24,0,1,131,40,0,129,131,52,0,225,131,
36,0,97,131,20,0,225,130,60,0,1,128,16,0,193,130,0,0,96,56,
166,3,8,124,56,0,33,56,32,0,128,78,2,0,0,56,4,0,24,176,
1,0,125,137,6,0,120,153,0,0,184,152,5,0,157,137,7,0,152,153,
2,0,189,136,1,0,216,152,116,7,165,124,10,0,184,176,19,0,253,136,
2,0,248,152,12,0,125,129,8,0,93,129,0,0,96,59,120,219,119,127,
2,0,23,44,120,51,223,124,8,0,129,59,1,0,32,59,120,219,122,127,
0,0,138,48,88,0,152,144,148,1,171,124,92,0,184,144,128,0,128,64,
58,16,38,87,20,202,6,124,58,16,0,84,20,2,221,126,1,0,118,136,
197,97,6,72,121,27,102,124,20,210,56,125,16,0,201,144,64,0,130,65,
0,0,152,137,0,0,30,128,104,0,102,129,140,0,171,128,120,227,135,127,
116,7,140,125,120,179,196,126,120,251,230,127,166,3,169,124,0,0,28,144,
1,0,172,56,33,4,128,78,121,27,123,124,20,218,57,127,36,0,130,65,
4,0,24,168,1,0,247,58,0,0,23,124,1,0,255,59,4,0,90,59,
136,255,128,65,0,0,27,44,64,0,130,64,28,0,33,131,44,0,161,131,
48,0,193,131,32,0,65,131,24,0,1,131,40,0,129,131,52,0,225,131,
36,0,97,131,20,0,225,130,60,0,1,128,16,0,193,130,0,0,96,56,
166,3,8,124,56,0,33,56,32,0,128,78,20,0,24,129,14,0,232,168,
16,0,120,128,14,0,3,168,120,59,247,124,0,0,23,124,8,0,40,169,
120,75,42,125,20,0,128,64,20,58,247,126,0,0,23,124,20,74,74,125,
244,255,128,65,7,0,24,136,116,7,0,124,31,0,0,44,128,0,130,65,
10,0,152,169,214,97,39,125,104,0,99,129,28,0,11,128,166,3,9,124,
20,74,247,126,0,0,64,57,12,0,88,177,14,0,248,178,8,0,248,178,
33,4,128,78,14,0,56,171,112,254,58,127,120,203,37,127,120,35,157,124,
120,27,124,124,120,211,70,127,69,105,5,72,22,200,227,124,214,209,3,124,
214,201,4,125,214,201,195,127,20,66,39,125,20,2,233,127,64,232,31,124,
116,0,248,146,200,0,129,65,180,0,128,65,64,224,30,124,188,0,128,64,
168,0,0,72,0,0,128,57,120,187,235,126,20,0,0,72,20,58,107,125,
20,74,74,125,1,0,140,57,52,7,140,125,0,1,10,44,10,0,152,177,
12,0,128,64,0,4,11,44,224,255,128,65,214,97,39,125,104,0,99,129,
28,0,11,128,0,0,64,57,20,74,247,126,12,0,88,177,8,0,248,178,
14,0,248,178,166,3,9,124,33,4,128,78,14,0,56,171,112,254,58,127,
120,203,37,127,120,35,157,124,120,27,124,124,120,211,70,127,157,104,5,72,
22,200,227,124,214,209,3,124,214,201,4,125,214,201,195,127,20,66,39,125,
20,2,233,127,64,232,31,124,116,0,248,146,32,0,129,65,12,0,128,65,
64,224,30,124,20,0,128,64,1,0,99,48,148,1,132,124,16,224,222,124,
116,0,216,144,255,255,3,49,20,0,120,128,104,0,67,129,28,0,10,128,
212,1,36,125,108,0,24,145,112,0,56,145,166,3,9,124,33,4,128,78,
14,0,216,170,112,254,215,126,120,179,197,126,120,35,154,124,120,27,121,124,
120,187,230,126,29,104,5,72,22,176,131,125,214,185,227,124,214,177,164,124,
214,177,195,127,20,42,204,124,20,58,230,127,64,208,31,124,100,0,152,144,
96,0,120,144,32,0,129,65,12,0,128,65,64,200,30,124,20,0,128,64,
1,0,99,48,96,0,120,144,148,1,132,124,100,0,152,144,121,27,136,124,
20,0,130,64,1,0,224,56,96,0,248,144,0,0,0,57,100,0,24,145,
20,0,120,128,104,0,35,129,28,0,9,128,166,3,9,124,33,4,128,78,
64,232,4,124,20,0,129,65,12,0,128,65,64,224,3,124,8,0,128,64,
0,0,96,59,28,0,33,131,44,0,161,131,48,0,193,131,32,0,65,131,
24,0,1,131,40,0,129,131,120,219,99,127,36,0,97,131,52,0,225,131,
60,0,1,128,20,0,225,130,16,0,193,130,166,3,8,124,56,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,7,0,94,137,116,7,74,125,31,0,10,44,
20,0,130,64,0,0,160,56,2,0,190,152,88,0,190,144,92,0,190,144,
16,0,126,128,104,0,131,129,188,1,12,128,166,3,9,124,33,4,128,78,
121,27,127,124,24,0,130,64,7,0,126,137,116,7,107,125,255,255,11,44,
108,0,130,65,96,0,0,72,20,0,126,128,104,0,227,128,188,1,7,129,
166,3,9,125,33,4,128,78,7,0,126,137,121,27,127,124,116,7,107,125,
16,0,130,64,255,255,11,44,60,0,130,65,48,0,0,72,31,0,11,44,
32,0,130,64,20,0,126,128,104,0,35,129,236,1,73,129,166,3,73,125,
33,4,128,78,7,0,126,137,116,7,107,125,255,255,11,44,12,0,130,65,
175,255,128,57,7,0,158,153,16,0,126,129,7,0,11,136,117,7,0,124,
20,0,130,65,20,0,158,129,7,0,12,136,117,7,0,124,16,0,130,64,
0,0,224,59,7,0,254,155,92,0,0,72,0,0,31,44,84,0,130,65,
80,0,30,129,0,0,8,44,48,0,130,64,120,243,195,127,5,43,8,72,
0,0,3,44,80,0,126,144,28,0,130,64,11,0,96,60,40,17,99,56,
197,74,5,72,0,0,224,59,7,0,254,155,28,0,0,72,2,0,62,137,
189,7,41,85,16,0,130,65,191,255,192,56,7,0,222,152,0,0,224,59,
20,0,1,128,120,251,227,127,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
8,0,193,147,121,27,126,124,12,0,225,147,120,35,159,124,132,0,130,65,
80,0,158,128,0,0,4,44,12,0,128,61,24,12,140,57,104,0,158,145,
12,0,130,65,120,243,195,127,253,41,8,72,84,0,30,128,0,0,0,44,
24,0,130,65,11,0,96,60,72,17,99,56,58,6,128,56,0,0,160,56,
73,235,254,75,104,0,94,129,196,1,106,129,120,243,195,127,166,3,105,125,
33,4,128,78,0,0,158,136,1,0,190,136,11,0,96,60,116,7,165,124,
88,17,99,56,116,7,132,124,245,73,5,72,255,7,224,87,12,0,130,65,
120,243,195,127,5,54,5,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,216,255,33,148,24,0,129,147,
32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,28,0,161,147,
120,27,125,124,2,0,29,136,189,7,0,84,120,35,159,124,52,0,130,65,
7,0,29,136,116,7,0,124,191,255,0,44,36,0,130,64,16,0,221,128,
7,0,230,136,117,7,231,124,20,0,130,65,20,0,253,128,7,0,71,137,
117,7,74,125,40,0,130,64,36,0,225,131,32,0,193,131,28,0,161,131,
44,0,1,128,24,0,129,131,44,1,96,56,166,3,8,124,40,0,33,56,
32,0,128,78,0,0,192,59,124,1,96,56,185,51,5,72,121,27,124,124,
12,0,130,65,41,210,4,72,120,227,158,127,0,0,30,44,40,0,130,64,
36,0,225,131,32,0,193,131,28,0,161,131,44,0,1,128,24,0,129,131,
145,3,96,56,166,3,8,124,40,0,33,56,32,0,128,78,11,0,96,60,
128,17,99,56,245,72,5,72,120,243,195,127,120,251,228,127,16,0,161,56,
8,0,193,56,9,0,225,56,109,196,4,72,121,27,127,124,184,0,130,64,
9,0,1,136,0,0,0,44,172,0,130,65,11,0,96,60,176,17,99,56,
189,72,5,72,8,0,1,136,116,7,0,124,2,0,0,40,2,0,29,137,
176,6,8,85,2,0,29,153,32,0,128,65,16,0,130,65,3,0,0,40,
20,0,130,65,96,0,0,72,2,0,61,137,64,0,41,97,2,0,61,153,
2,0,29,137,20,0,129,129,16,0,97,129,20,0,125,128,255,255,160,56,
251,255,128,56,250,7,8,85,2,0,29,153,92,0,157,145,88,0,125,145,
213,121,6,72,104,0,61,129,188,1,9,128,120,235,163,127,166,3,9,124,
33,4,128,78,120,243,195,127,3,0,128,56,193,203,4,72,40,0,0,72,
145,3,224,59,120,243,195,127,3,0,128,56,173,203,4,72,20,0,0,72,
44,1,224,59,120,243,195,127,3,0,128,56,153,203,4,72,120,251,227,127,
36,0,225,131,32,0,193,131,44,0,1,128,28,0,161,131,24,0,129,131,
166,3,8,124,40,0,33,56,32,0,128,78,232,255,33,148,12,0,161,147,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,8,0,129,147,
120,27,124,124,20,0,124,128,104,0,131,129,28,0,12,128,255,255,224,59,
166,3,9,124,33,4,128,78,120,27,125,124,16,0,124,128,104,0,67,129,
28,0,106,129,120,35,158,124,166,3,105,125,33,4,128,78,64,32,30,124,
20,0,128,65,12,0,129,65,64,24,29,124,8,0,129,64,17,0,224,59,
120,251,227,127,20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,
8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,27,125,124,16,0,125,128,104,0,131,129,156,1,44,129,120,35,158,124,
8,0,129,56,166,3,41,125,33,4,128,78,8,0,1,128,1,0,0,44,
120,27,127,124,56,0,130,64,20,0,125,128,104,0,3,129,156,1,72,129,
8,0,129,56,166,3,73,125,33,4,128,78,8,0,1,128,1,0,31,44,
16,0,130,65,0,0,30,144,120,251,227,127,16,0,0,72,120,27,127,124,
0,0,30,144,120,251,227,127,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,27,125,124,84,0,125,128,121,35,158,124,120,43,191,124,120,27,106,124,
56,0,130,64,7,0,221,136,116,7,198,124,64,48,31,124,40,0,130,64,
0,0,3,44,32,0,130,65,0,0,0,57,84,0,29,145,1,0,32,57,
5,1,42,153,11,0,96,60,248,17,99,56,89,70,5,72,1,0,30,44,
212,0,130,64,7,0,93,137,116,7,74,125,64,80,31,124,196,0,130,64,
200,129,109,137,0,0,11,44,0,0,0,56,20,0,130,65,204,129,141,129,
0,0,12,44,8,0,130,64,1,0,0,56,63,6,0,84,156,0,130,65,
84,0,125,128,0,0,3,44,52,0,130,64,3,0,29,136,0,0,0,44,
32,0,130,64,0,0,96,56,9,76,4,72,84,0,125,144,11,0,96,60,
28,18,99,56,233,69,5,72,84,0,125,128,0,0,3,44,96,0,130,65,
120,235,164,127,141,121,4,72,0,0,3,44,60,0,130,65,84,0,125,128,
0,0,3,44,24,0,130,65,240,13,99,129,12,0,139,129,3,0,128,56,
166,3,137,125,33,4,128,78,0,0,0,56,84,0,29,144,11,0,96,60,
56,18,99,56,153,69,5,72,24,0,0,72,1,0,224,56,3,0,253,152,
11,0,96,60,208,17,99,56,129,69,5,72,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
2,0,31,136,14,0,127,169,11,0,96,60,254,215,5,84,96,18,99,56,
112,14,108,125,148,1,140,124,49,69,5,72,120,251,227,127,241,108,6,72,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
200,255,33,148,16,0,193,146,20,0,225,146,24,0,1,147,28,0,33,147,
32,0,65,147,36,0,97,147,40,0,129,147,48,0,193,147,52,0,225,147,
166,2,8,124,60,0,1,144,44,0,161,147,120,27,123,124,96,0,123,129,
100,0,155,129,120,35,157,124,12,0,253,131,64,96,31,124,20,0,29,169,
8,0,221,131,120,43,184,124,120,67,28,125,16,0,128,65,80,0,129,65,
64,88,30,124,72,0,128,64,8,0,27,168,0,0,8,124,60,0,128,64,
16,0,123,128,104,0,131,129,188,0,236,128,120,195,4,127,166,3,233,124,
33,4,128,78,12,0,97,144,12,0,97,161,8,0,97,177,14,0,1,160,
10,0,1,176,8,0,97,129,255,7,102,85,64,0,130,64,28,0,33,131,
44,0,161,131,48,0,193,131,32,0,65,131,24,0,1,131,40,0,129,131,
52,0,225,131,36,0,97,131,20,0,225,130,60,0,1,128,16,0,193,130,
34,1,96,56,166,3,8,124,56,0,33,56,32,0,128,78,14,0,187,168,
112,254,166,124,214,41,254,124,214,49,30,124,214,41,159,125,22,40,94,125,
16,0,251,130,14,0,215,170,11,0,32,57,28,0,61,145,20,98,202,124,
120,179,197,126,112,254,138,127,20,2,6,125,20,224,39,127,120,203,35,127,
20,81,72,127,120,211,68,127,112,254,198,126,65,95,5,72,8,0,125,144,
120,203,35,127,12,0,157,144,120,211,68,127,120,179,197,126,112,254,198,126,
81,94,5,72,104,0,151,129,132,1,12,128,20,0,125,176,120,235,164,127,
120,195,5,127,120,187,227,126,166,3,9,124,33,4,128,78,0,0,3,44,
88,0,130,65,14,0,91,169,112,254,71,125,22,80,158,125,214,81,126,124,
214,57,30,125,214,81,191,124,112,254,139,127,20,42,236,124,20,66,135,124,
20,224,163,124,16,0,123,128,20,89,196,124,104,0,99,129,84,0,11,128,
1,0,32,57,20,0,61,177,8,0,189,144,12,0,221,144,120,235,164,127,
166,3,9,124,33,4,128,78,8,0,221,147,12,0,253,147,20,0,157,179,
28,0,33,131,44,0,161,131,48,0,193,131,32,0,65,131,24,0,1,131,
40,0,129,131,52,0,225,131,36,0,97,131,20,0,225,130,60,0,1,128,
16,0,193,130,0,0,96,56,166,3,8,124,56,0,33,56,32,0,128,78,
184,255,33,148,24,0,129,146,16,0,65,146,20,0,97,146,28,0,161,146,
32,0,193,146,36,0,225,146,40,0,1,147,44,0,33,147,48,0,65,147,
52,0,97,147,56,0,129,147,60,0,161,147,68,0,225,147,166,2,8,124,
76,0,1,144,64,0,193,147,120,27,123,124,100,0,155,129,120,35,158,124,
12,0,190,131,64,96,29,124,96,0,123,129,8,0,158,131,20,0,254,168,
120,43,180,124,120,51,213,124,120,59,246,124,16,0,128,65,80,0,129,65,
64,88,28,124,72,0,128,64,8,0,219,168,0,48,7,124,60,0,128,64,
16,0,123,128,104,0,3,129,188,0,8,128,120,163,132,126,166,3,9,124,
33,4,128,78,12,0,97,144,12,0,1,160,8,0,1,176,14,0,193,160,
10,0,193,176,8,0,161,128,255,7,167,84,80,0,130,64,32,0,193,130,
56,0,129,131,60,0,161,131,36,0,225,130,28,0,161,130,52,0,97,131,
64,0,193,131,40,0,1,131,24,0,129,130,48,0,65,131,68,0,225,131,
44,0,33,131,20,0,97,130,76,0,1,128,16,0,65,130,0,0,96,56,
166,3,8,124,72,0,33,56,32,0,128,78,80,0,123,128,120,227,133,127,
120,235,166,127,120,171,167,126,165,32,8,72,14,0,59,169,112,254,42,125,
214,73,221,124,22,72,252,124,214,81,28,125,214,73,252,126,16,0,123,130,
14,0,83,170,120,27,127,124,12,0,0,56,28,0,30,144,120,147,69,126,
112,254,204,126,20,50,231,124,20,66,7,127,20,176,55,127,120,203,35,127,
20,97,88,127,120,211,68,127,112,254,70,126,233,92,5,72,8,0,126,144,
120,203,35,127,12,0,158,144,120,211,68,127,120,147,69,126,112,254,70,126,
249,91,5,72,104,0,211,128,124,1,6,128,20,0,126,176,120,163,133,126,
120,243,196,127,166,3,9,124,120,155,99,126,120,171,166,126,33,4,128,78,
0,0,3,44,24,0,130,65,53,31,8,72,8,0,158,147,12,0,190,147,
20,0,222,178,100,0,0,72,14,0,123,169,112,254,108,125,214,97,188,124,
214,89,61,125,22,88,28,125,214,89,220,124,16,0,123,128,112,254,204,126,
20,74,72,125,20,42,234,124,20,176,38,125,20,97,71,125,104,0,131,129,
76,0,12,128,120,243,196,127,12,0,94,145,8,0,62,145,1,0,192,56,
20,0,222,176,166,3,9,124,33,4,128,78,8,0,158,147,12,0,190,147,
20,0,222,178,52,0,97,131,32,0,193,130,28,0,161,130,48,0,65,131,
56,0,129,131,36,0,225,130,24,0,129,130,44,0,33,131,60,0,161,131,
120,251,227,127,68,0,225,131,40,0,1,131,64,0,193,131,76,0,1,128,
20,0,97,130,16,0,65,130,166,3,8,124,72,0,33,56,32,0,128,78,
232,255,33,148,16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,
12,0,161,147,120,35,157,124,8,0,221,131,14,0,3,169,12,0,253,131,
112,254,10,125,22,64,190,124,214,65,223,124,214,65,126,125,214,81,30,125,
24,0,61,161,72,0,42,97,8,0,125,145,20,50,229,124,24,0,93,177,
20,66,135,125,12,0,157,145,112,0,131,129,64,96,31,124,108,0,99,129,
64,0,128,65,12,0,129,65,64,88,30,124,52,0,129,64,100,0,131,129,
96,0,99,129,246,255,139,48,212,1,172,124,64,40,31,124,28,0,129,65,
12,0,128,65,64,32,30,124,16,0,128,64,24,0,221,160,118,7,198,84,
24,0,221,176,20,0,99,128,104,0,227,128,20,0,7,128,120,235,164,127,
166,3,9,124,33,4,128,78,24,0,93,161,118,7,74,85,12,0,253,147,
8,0,221,147,24,0,93,177,28,0,1,128,20,0,225,131,12,0,161,131,
16,0,193,131,0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
216,255,33,148,20,0,97,147,8,0,1,147,12,0,33,147,16,0,65,147,
28,0,161,147,32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,
24,0,129,147,120,35,156,124,8,0,188,131,120,27,123,124,14,0,219,168,
12,0,220,131,112,254,201,124,22,48,157,125,214,73,157,124,214,49,93,125,
214,49,30,124,24,0,60,161,80,0,123,128,120,43,167,124,120,235,165,127,
120,243,198,127,8,0,92,145,64,0,41,97,24,0,60,177,20,2,44,125,
20,34,105,125,12,0,124,145,213,29,8,72,112,0,187,128,64,40,30,124,
108,0,155,128,120,27,127,124,60,0,128,65,12,0,129,65,64,32,29,124,
48,0,129,64,28,0,124,131,12,0,128,56,33,0,96,56,17,0,192,56,
120,227,133,127,28,0,220,144,49,139,5,72,28,0,124,147,8,0,188,147,
12,0,220,147,156,0,0,72,20,0,92,171,64,40,30,124,20,0,130,64,
64,32,29,124,12,0,130,64,116,0,27,128,20,0,28,176,2,0,187,136,
115,6,165,84,0,0,0,57,68,0,130,65,104,0,27,129,52,1,40,129,
120,219,99,127,166,3,41,125,33,4,128,78,14,0,27,168,112,254,12,124,
22,0,163,124,214,1,196,124,214,1,3,127,214,97,3,124,1,0,0,57,
8,0,28,147,20,50,229,124,20,2,39,127,12,0,60,147,58,16,10,85,
20,82,123,125,16,0,107,128,104,0,131,129,12,0,12,128,120,227,132,127,
166,3,9,124,33,4,128,78,20,0,92,179,8,0,188,147,12,0,220,147,
16,0,65,131,24,0,129,131,28,0,161,131,120,251,227,127,36,0,225,131,
20,0,97,131,32,0,193,131,44,0,1,128,12,0,33,131,8,0,1,131,
166,3,8,124,40,0,33,56,32,0,128,78,208,255,33,148,24,0,65,147,
28,0,97,147,32,0,129,147,36,0,161,147,44,0,225,147,166,2,8,124,
52,0,1,144,40,0,193,147,120,35,158,124,12,0,158,129,8,0,126,129,
120,27,125,124,12,0,129,145,8,0,97,145,20,0,125,128,104,0,67,129,
76,1,10,128,0,0,96,59,16,0,193,56,120,43,191,124,16,0,157,59,
120,251,228,127,8,0,161,56,166,3,9,124,33,4,128,78,0,0,3,44,
96,0,130,65,92,0,253,128,88,0,221,128,14,0,29,168,112,254,10,124,
214,1,134,124,214,81,102,125,214,1,7,125,22,0,230,124,12,0,97,131,
8,0,65,131,20,66,39,125,20,90,169,124,16,216,5,124,16,1,32,125,
208,0,137,125,120,42,104,127,52,0,9,125,126,217,42,85,16,208,100,125,
16,89,203,124,208,0,6,124,56,0,71,125,120,59,155,125,58,16,105,87,
46,224,105,124,104,0,67,129,92,1,10,128,120,243,196,127,120,251,229,127,
166,3,9,124,33,4,128,78,40,0,193,131,32,0,129,131,36,0,161,131,
44,0,225,131,52,0,1,128,28,0,97,131,24,0,65,131,166,3,8,124,
48,0,33,56,32,0,128,78,208,255,33,148,40,0,193,147,24,0,65,147,
28,0,97,147,32,0,129,147,166,2,8,124,52,0,1,144,36,0,161,147,
120,35,157,124,44,0,225,147,120,51,223,124,12,0,221,128,120,43,190,124,
8,0,189,128,120,27,124,124,12,0,193,144,8,0,161,144,20,0,124,128,
104,0,99,129,76,1,43,129,0,0,64,59,8,0,225,56,120,243,196,127,
16,0,124,59,120,59,229,124,166,3,41,125,16,0,193,56,33,4,128,78,
0,0,3,44,96,0,130,65,92,0,28,129,88,0,252,128,14,0,28,168,
112,254,11,124,214,89,135,125,214,1,167,124,214,1,40,125,22,0,7,125,
12,0,129,128,8,0,97,128,20,74,72,125,20,98,202,124,16,32,134,125,
16,97,12,124,208,0,0,124,120,50,139,124,52,0,108,125,126,217,137,85,
16,24,5,125,16,65,72,125,208,0,234,124,56,56,43,125,120,91,26,124,
58,16,76,87,46,216,108,124,104,0,163,128,84,1,5,128,120,235,164,127,
120,251,230,127,166,3,9,124,120,243,197,127,33,4,128,78,40,0,193,131,
32,0,129,131,36,0,161,131,44,0,225,131,52,0,1,128,28,0,97,131,
24,0,65,131,166,3,8,124,48,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
7,0,30,136,116,7,0,124,255,255,0,44,120,35,159,124,48,0,130,64,
20,0,126,128,104,0,131,129,236,0,140,129,166,3,137,125,33,4,128,78,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,177,104,6,72,3,0,126,137,19,0,31,136,116,7,107,125,
188,15,96,81,19,0,31,152,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,7,0,131,137,116,7,140,125,
255,255,12,44,24,0,130,64,20,0,99,128,104,0,131,129,228,0,12,128,
166,3,9,124,32,4,128,78,152,105,6,72,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,16,0,127,128,104,0,67,129,
116,0,10,128,166,3,9,124,33,4,128,78,0,0,3,44,24,0,130,64,
20,0,127,128,104,0,131,129,116,0,12,128,166,3,9,124,33,4,128,78,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
16,0,127,128,104,0,67,129,108,0,10,128,166,3,9,124,33,4,128,78,
0,0,3,44,24,0,130,64,20,0,127,128,104,0,131,129,108,0,12,128,
166,3,9,124,33,4,128,78,20,0,1,128,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,1,0,160,56,4,229,255,75,0,0,160,56,
252,228,255,75,0,0,96,56,32,0,128,78,20,0,99,128,104,0,131,129,
212,1,12,128,166,3,9,124,32,4,128,78,20,0,99,128,104,0,131,129,
204,1,12,128,166,3,9,124,32,4,128,78,255,255,96,56,32,0,128,78,
20,0,99,128,104,0,131,129,196,0,12,128,166,3,9,124,32,4,128,78,
20,0,99,128,104,0,131,129,148,0,12,128,166,3,9,124,32,4,128,78,
0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,20,0,99,128,
104,0,131,129,28,0,12,128,166,3,9,124,32,4,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,16,0,99,128,0,0,3,44,1,0,96,57,
0,0,128,57,28,0,130,65,104,0,131,129,28,0,12,128,166,3,9,124,
33,4,128,78,120,27,107,124,120,35,140,124,12,0,1,128,8,0,33,56,
166,3,8,124,120,99,132,125,120,91,99,125,32,0,128,78,0,0,100,128,
40,1,0,56,255,255,128,56,12,0,3,176,88,208,7,72,240,255,33,148,
166,2,8,124,20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,
120,35,159,124,64,0,130,65,12,0,128,61,16,14,140,57,196,1,108,129,
104,0,158,145,166,3,105,125,33,4,128,78,0,0,158,136,11,0,96,60,
116,7,132,124,128,18,99,56,21,57,5,72,255,7,224,87,12,0,130,65,
120,243,195,127,37,37,5,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,16,0,131,129,0,0,12,44,
44,1,96,56,32,0,130,77,104,0,76,129,44,1,10,128,120,99,131,125,
166,3,9,124,32,4,128,78,16,0,131,129,0,0,12,44,24,0,130,65,
104,0,108,129,244,0,11,128,120,99,131,125,166,3,9,124,32,4,128,78,
108,96,6,72,16,0,131,129,0,0,12,44,24,0,130,65,104,0,108,129,
236,0,11,128,120,99,131,125,166,3,9,124,32,4,128,78,212,101,6,72,
16,0,131,129,0,0,12,44,1,0,96,56,32,0,130,77,104,0,108,129,
228,0,11,128,120,99,131,125,166,3,9,124,32,4,128,78,166,2,8,124,
4,0,1,144,240,255,33,148,16,0,99,128,0,0,3,44,8,0,97,129,
30,0,96,85,8,0,1,144,72,0,130,65,104,0,131,129,188,0,12,128,
166,3,9,124,33,4,128,78,12,0,97,144,12,0,97,161,8,0,97,177,
14,0,129,161,10,0,129,177,8,0,65,129,255,7,74,85,24,0,130,65,
0,0,0,56,8,0,1,176,8,0,129,129,1,0,140,97,8,0,129,145,
20,0,1,128,8,0,97,128,16,0,33,56,166,3,8,124,32,0,128,78,
16,0,131,129,0,0,12,44,1,0,96,56,0,0,128,56,32,0,130,77,
104,0,76,129,28,0,10,128,120,99,131,125,166,3,9,124,32,4,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,20,0,130,64,108,0,96,56,13,34,5,72,
121,27,127,124,52,0,130,65,120,251,227,127,165,73,6,72,0,0,30,44,
12,0,128,61,16,14,140,57,104,0,159,145,16,0,130,65,16,0,223,147,
1,0,0,56,4,0,31,176,64,0,96,57,6,0,127,153,20,0,1,128,
120,251,227,127,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,35,1,96,56,32,0,128,78,0,0,96,56,32,0,128,78,
0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,
32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,
0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,32,0,128,78,
34,1,96,56,32,0,128,78,0,0,96,56,32,0,128,78,34,1,96,56,
32,0,128,78,34,1,96,56,32,0,128,78,32,0,128,78,35,1,96,56,
32,0,128,78,35,1,96,56,32,0,128,78,0,0,96,56,32,0,128,78,
32,0,128,78,0,0,96,56,32,0,128,78,0,0,128,57,0,0,132,145,
1,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,
32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,
0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,244,252,255,75,
240,252,255,75,2,0,192,60,64,252,198,56,96,2,160,56,16,0,128,56,
28,0,96,60,172,126,99,56,0,0,224,56,120,59,232,124,224,30,5,72,
240,255,33,148,12,0,225,147,1,0,224,63,238,238,255,59,166,2,8,124,
20,0,1,144,8,0,193,147,12,0,192,63,32,16,222,59,6,0,126,52,
15,0,224,56,0,0,254,176,20,0,130,64,2,0,96,56,125,32,5,72,
0,0,3,44,12,0,130,65,1,0,64,57,0,0,67,177,12,0,126,52,
20,0,130,64,2,0,96,56,93,32,5,72,0,0,3,44,12,0,130,65,
2,0,96,57,0,0,99,177,18,0,126,52,20,0,130,64,2,0,96,56,
61,32,5,72,0,0,3,44,12,0,130,65,4,0,128,57,0,0,131,177,
24,0,126,52,20,0,130,64,2,0,96,56,29,32,5,72,0,0,3,44,
12,0,130,65,8,0,0,56,0,0,3,176,30,0,126,52,20,0,130,64,
2,0,96,56,253,31,5,72,0,0,3,44,8,0,130,65,0,0,227,179,
36,0,126,52,20,0,130,64,2,0,96,56,225,31,5,72,0,0,3,44,
8,0,130,65,0,0,227,179,42,0,126,52,20,0,130,64,2,0,96,56,
197,31,5,72,0,0,3,44,12,0,130,65,17,17,31,56,0,0,3,176,
12,0,192,63,80,16,222,59,6,0,126,52,15,0,0,56,0,0,30,176,
20,0,130,64,2,0,96,56,149,31,5,72,0,0,3,44,12,0,130,65,
1,0,0,56,0,0,3,176,12,0,126,52,20,0,130,64,2,0,96,56,
117,31,5,72,0,0,3,44,12,0,130,65,2,0,0,57,0,0,3,177,
18,0,126,52,20,0,130,64,2,0,96,56,85,31,5,72,0,0,3,44,
12,0,130,65,4,0,0,56,0,0,3,176,24,0,126,52,20,0,130,64,
2,0,96,56,53,31,5,72,0,0,3,44,12,0,130,65,8,0,64,57,
0,0,67,177,30,0,126,52,20,0,130,64,2,0,96,56,21,31,5,72,
0,0,3,44,8,0,130,65,0,0,227,179,36,0,126,52,20,0,130,64,
2,0,96,56,249,30,5,72,0,0,3,44,8,0,130,65,0,0,227,179,
42,0,126,52,20,0,130,64,2,0,96,56,221,30,5,72,0,0,3,44,
12,0,130,65,17,17,127,57,0,0,99,177,2,0,192,60,144,252,198,56,
15,0,0,56,124,128,13,176,16,0,128,56,132,128,141,176,96,2,160,56,
28,0,96,60,172,126,99,56,77,30,5,72,12,0,96,60,8,16,99,56,
217,25,5,72,0,0,128,57,29,0,32,61,248,4,137,153,12,0,96,60,
20,16,99,56,193,25,5,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,120,35,159,124,
52,0,130,65,0,0,222,168,0,0,6,44,24,0,130,65,4,0,158,128,
8,0,190,128,11,0,96,60,104,19,99,56,173,51,5,72,255,7,224,87,
12,0,130,65,120,243,195,127,189,31,5,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
166,2,8,124,36,0,1,144,24,0,193,147,121,27,126,124,28,0,225,147,
120,35,159,124,52,0,130,65,8,0,97,56,20,132,130,56,125,199,4,72,
4,0,158,128,11,0,96,60,8,0,161,56,144,19,99,56,69,51,5,72,
255,7,224,87,12,0,130,65,120,243,195,127,85,31,5,72,36,0,1,128,
28,0,225,131,24,0,193,131,166,3,8,124,32,0,33,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,129,170,8,72,0,0,3,44,
28,0,130,65,11,0,96,60,180,19,99,56,6,1,128,56,0,0,160,56,
21,212,254,75,0,0,3,44,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,232,255,33,148,12,0,161,147,166,2,8,124,28,0,1,144,
16,0,193,147,121,27,126,124,20,0,225,147,120,35,159,124,72,0,130,65,
0,0,160,59,0,0,94,129,1,0,0,56,48,232,7,124,57,56,73,125,
20,0,130,65,96,2,125,29,28,0,139,61,172,126,108,56,121,255,255,75,
1,0,189,59,16,0,29,44,212,255,128,65,255,7,224,87,12,0,130,65,
120,243,195,127,149,30,5,72,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,120,251,227,127,
255,255,128,56,41,173,8,72,0,0,3,44,240,255,130,64,20,0,1,128,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,
12,0,161,147,166,2,8,124,28,0,1,144,20,0,225,147,121,27,127,124,
16,0,193,147,120,35,158,124,20,0,130,64,4,0,96,56,109,28,5,72,
121,27,127,124,68,0,130,65,0,0,223,147,0,0,160,59,1,0,96,57,
48,232,106,125,57,80,204,127,24,0,130,65,96,2,29,28,28,0,32,61,
172,126,41,57,20,2,105,124,105,255,255,75,1,0,189,59,16,0,29,44,
12,0,128,64,0,0,223,131,204,255,255,75,120,251,227,127,20,0,225,131,
28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,0,0,131,137,
0,0,12,44,56,0,130,65,0,0,0,56,0,0,3,152,29,0,96,60,
204,4,99,56,209,168,8,72,0,0,3,44,28,0,130,65,11,0,96,60,
192,19,99,56,6,1,128,56,0,0,160,56,101,210,254,75,0,0,3,44,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,0,0,127,137,
0,0,11,44,32,0,130,64,29,0,96,60,204,4,99,56,0,0,128,56,
237,171,8,72,52,0,96,124,126,217,12,84,0,0,159,153,20,0,1,128,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,24,0,130,65,53,255,255,75,255,7,192,87,12,0,130,65,
120,251,227,127,201,28,5,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,
121,27,127,124,166,2,8,124,20,0,1,144,20,0,130,64,1,0,96,56,
237,26,5,72,121,27,127,124,32,0,130,65,29,0,96,60,204,4,99,56,
0,0,128,56,73,171,8,72,52,0,96,124,126,217,12,84,0,0,159,153,
20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,12,0,225,147,121,27,127,124,166,2,8,124,
20,0,1,144,20,0,130,64,1,0,96,56,145,26,5,72,121,27,127,124,
36,0,130,65,1,0,0,56,0,0,31,152,29,0,96,60,204,4,99,56,
255,255,128,56,229,170,8,72,0,0,3,44,236,255,130,64,20,0,1,128,
120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,12,0,225,147,8,0,193,147,0,0,192,59,120,243,223,127,
4,0,99,57,0,0,11,129,4,0,107,57,0,32,11,124,20,64,222,127,
148,1,255,127,236,255,128,65,20,248,126,124,12,0,225,131,8,0,193,131,
16,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
120,27,108,124,0,2,140,56,169,255,255,75,0,0,108,144,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,120,27,108,124,0,18,140,56,125,255,255,75,0,0,108,144,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,120,27,108,124,0,2,140,56,81,255,255,75,
0,0,140,129,120,98,108,124,255,255,12,48,16,97,0,124,62,6,3,84,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,121,0,35,137,
0,0,0,56,116,7,41,125,120,3,10,124,0,72,10,124,60,0,128,64,
58,16,70,85,80,48,138,125,60,8,140,85,20,98,99,125,122,0,235,164,
64,32,7,124,20,0,130,64,2,0,11,169,4,0,11,160,0,0,5,145,
16,0,0,72,1,0,74,57,0,72,10,124,204,255,128,65,120,3,3,124,
32,0,128,78,232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,
16,0,193,147,120,27,126,124,84,0,30,160,0,0,0,44,120,35,159,124,
24,0,130,64,11,0,96,60,204,19,99,56,215,5,128,56,0,0,160,56,
141,207,254,75,120,243,195,127,4,0,128,56,8,0,161,56,97,255,255,75,
0,0,3,44,32,0,130,64,20,0,225,131,28,0,1,128,16,0,193,131,
128,1,96,56,166,3,8,124,24,0,33,56,32,0,128,78,56,0,158,129,
8,0,65,129,120,251,228,127,44,72,101,84,44,72,74,85,20,82,108,124,
33,235,7,72,0,0,3,44,28,0,130,65,28,0,1,128,20,0,225,131,
16,0,193,131,166,3,8,124,24,0,33,56,32,0,128,78,120,251,227,127,
0,2,159,56,29,254,255,75,0,0,31,129,64,64,3,124,48,0,130,65,
48,0,158,128,11,0,96,60,216,19,99,56,209,45,5,72,20,0,225,131,
28,0,1,128,16,0,193,131,131,1,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,4,0,31,128,80,0,30,144,28,0,1,128,16,0,193,131,
20,0,225,131,0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,84,0,30,160,0,0,0,44,120,35,159,124,24,0,130,64,
11,0,96,60,52,20,99,56,98,5,128,56,0,0,160,56,121,206,254,75,
69,0,94,137,0,0,10,44,8,0,128,56,8,0,130,65,16,0,128,56,
120,243,195,127,8,0,161,56,61,254,255,75,56,0,158,129,8,0,97,129,
120,251,228,127,44,72,101,84,44,72,107,85,20,90,108,124,33,234,7,72,
0,0,3,44,28,0,130,65,28,0,1,128,20,0,225,131,16,0,193,131,
166,3,8,124,24,0,33,56,32,0,128,78,4,0,255,128,50,1,191,168,
1,48,5,44,3,0,0,56,76,0,254,144,76,0,130,65,1,64,5,44,
32,0,130,64,0,18,159,56,120,251,227,127,253,252,255,75,0,0,95,129,
64,80,3,124,104,0,130,65,64,0,0,72,9,0,192,56,92,2,222,152,
20,0,225,131,28,0,1,128,16,0,193,131,129,1,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,0,6,159,56,120,251,227,127,189,252,255,75,
0,0,95,129,64,80,3,124,40,0,130,65,8,0,96,57,92,2,126,153,
20,0,225,131,28,0,1,128,16,0,193,131,130,1,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,52,1,159,169,0,0,12,44,12,0,130,65,
0,0,7,44,48,0,130,64,48,0,158,128,11,0,96,60,8,20,99,56,
57,44,5,72,20,0,225,131,28,0,1,128,16,0,193,131,132,1,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,20,0,225,131,28,0,1,128,
16,0,193,131,0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
232,255,33,148,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
20,0,225,147,120,35,159,124,2,0,128,56,8,0,161,56,225,252,255,75,
0,0,3,44,32,0,130,64,20,0,225,131,28,0,1,128,16,0,193,131,
128,1,96,56,166,3,8,124,24,0,33,56,32,0,128,78,56,0,126,129,
8,0,65,129,120,251,228,127,44,72,101,84,44,72,74,85,20,82,107,124,
161,232,7,72,0,0,3,44,28,0,130,65,28,0,1,128,20,0,225,131,
16,0,193,131,166,3,8,124,24,0,33,56,32,0,128,78,4,0,63,129,
72,0,62,145,120,251,227,127,0,6,159,56,149,251,255,75,0,0,31,128,
64,0,3,124,40,0,130,65,6,0,224,56,92,2,254,152,20,0,225,131,
28,0,1,128,16,0,193,131,130,1,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,0,0,9,44,44,0,130,65,48,0,31,128,0,0,0,44,
32,0,129,64,80,1,0,40,24,0,129,65,24,3,159,129,0,0,12,44,
12,0,129,64,80,1,12,40,48,0,129,64,48,0,158,128,11,0,96,60,
64,20,99,56,245,42,5,72,20,0,225,131,28,0,1,128,16,0,193,131,
133,1,96,56,166,3,8,124,24,0,33,56,32,0,128,78,20,0,225,131,
28,0,1,128,16,0,193,131,0,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,11,0,32,61,
108,20,41,57,12,0,225,147,120,27,127,124,92,0,255,56,100,0,31,57,
0,0,64,57,0,0,104,137,0,0,9,136,116,7,0,124,116,7,107,125,
64,0,11,124,1,0,41,57,1,0,8,57,28,0,130,65,20,0,1,128,
12,0,225,131,0,0,96,56,16,0,33,56,166,3,8,124,32,0,128,78,
1,0,74,57,8,0,10,44,192,255,128,65,120,59,227,124,21,251,255,75,
0,0,3,44,28,0,130,65,20,0,1,128,12,0,225,131,4,0,96,56,
16,0,33,56,166,3,8,124,32,0,128,78,24,0,7,160,2,144,0,40,
36,0,130,65,3,144,0,40,28,0,130,65,20,0,1,128,12,0,225,131,
5,0,96,56,16,0,33,56,166,3,8,124,32,0,128,78,120,251,227,127,
16,0,128,56,8,0,161,56,245,250,255,75,255,255,3,48,16,25,128,125,
69,0,159,153,20,0,1,128,12,0,225,131,1,0,96,56,16,0,33,56,
166,3,8,124,32,0,128,78,232,255,33,148,166,2,8,124,28,0,1,144,
12,0,161,147,120,27,125,124,16,0,193,147,120,35,158,124,11,0,128,60,
120,20,132,56,20,0,225,147,120,43,191,124,1,0,160,56,221,86,3,72,
48,0,221,147,56,0,253,147,255,255,128,57,60,0,157,145,64,0,157,145,
0,0,128,56,68,0,157,152,69,0,157,152,72,0,157,144,76,0,157,144,
80,0,157,144,52,0,157,145,84,0,157,176,93,2,157,152,94,2,157,152,
95,2,157,152,88,0,157,144,2,0,0,56,92,2,29,152,92,0,125,56,
0,2,160,56,81,197,254,75,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,176,255,33,148,
64,0,129,147,68,0,161,147,76,0,225,147,166,2,8,124,84,0,1,144,
72,0,193,147,120,27,126,124,48,0,30,128,56,0,94,129,1,0,224,59,
52,0,65,145,48,0,252,127,48,0,65,145,0,32,0,56,56,0,1,144,
225,185,7,72,120,251,228,127,232,3,224,56,29,0,192,60,172,4,198,56,
9,0,160,60,248,112,165,56,0,0,160,59,8,0,163,147,4,0,163,144,
36,0,195,144,40,0,131,147,20,0,227,144,88,0,126,144,157,191,7,72,
88,0,30,128,8,0,161,56,12,0,128,56,33,0,96,56,24,0,161,147,
32,0,161,179,20,0,161,147,16,0,161,147,40,0,33,57,12,0,33,145,
8,0,1,144,16,0,0,56,28,0,1,176,17,0,128,57,36,0,129,145,
205,116,5,72,88,0,126,128,84,0,190,179,81,187,7,72,120,27,127,124,
88,0,126,128,0,0,163,179,45,184,8,72,120,251,227,127,76,0,225,131,
72,0,193,131,84,0,1,128,68,0,161,131,64,0,129,131,166,3,8,124,
80,0,33,56,32,0,128,78,118,0,131,152,116,7,132,124,52,0,131,144,
92,0,99,56,132,248,255,75,166,2,8,124,4,0,1,144,248,255,33,148,
48,0,99,128,117,238,0,72,12,0,1,128,8,0,33,56,166,3,8,124,
4,216,99,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,92,0,126,56,12,0,225,147,120,35,159,124,
0,0,128,56,0,2,160,56,209,195,254,75,120,243,195,127,169,255,255,75,
0,0,31,44,64,0,126,144,216,0,130,65,99,0,94,57,11,0,32,61,
139,20,41,57,9,0,96,57,166,3,105,125,1,0,137,141,1,0,138,157,
248,255,0,66,52,0,30,128,76,0,31,44,118,0,30,152,8,0,224,56,
1,0,0,57,1,0,32,61,121,0,254,152,112,0,30,145,2,144,41,57,
116,0,62,177,40,0,0,56,120,0,30,152,40,0,130,64,4,0,0,57,
64,0,30,145,76,0,32,57,119,0,62,153,12,0,192,60,80,16,198,56,
8,0,0,56,7,0,224,56,28,0,0,72,78,0,96,57,119,0,126,153,
12,0,192,60,32,16,198,56,8,0,0,56,7,0,224,56,58,16,224,84,
80,0,39,125,60,8,41,85,20,74,70,125,0,0,106,161,20,74,30,125,
122,0,104,181,2,0,138,161,2,0,136,177,4,0,10,160,4,0,8,176,
121,59,224,124,255,255,231,56,204,255,130,64,69,0,30,152,92,0,126,56,
73,247,255,75,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,168,255,33,148,64,0,65,147,76,0,161,147,
84,0,225,147,166,2,8,124,92,0,1,144,68,0,97,147,120,27,123,124,
72,0,129,147,120,35,156,124,80,0,193,147,120,43,190,124,120,243,196,127,
8,0,161,56,137,247,255,75,121,27,127,124,44,0,130,64,80,0,193,131,
72,0,129,131,76,0,161,131,84,0,225,131,92,0,1,128,68,0,97,131,
64,0,65,131,166,3,8,124,88,0,33,56,32,0,128,78,2,0,220,160,
64,0,198,96,2,0,220,176,2,0,252,160,0,0,96,57,84,0,219,179,
0,8,231,96,2,0,252,176,44,0,97,145,48,0,97,145,8,0,97,129,
60,0,219,128,56,0,91,129,0,0,160,59,44,0,1,56,16,0,1,144,
24,0,161,147,44,72,96,85,20,2,10,124,56,0,1,144,52,0,1,144,
20,90,6,124,20,0,1,144,48,0,123,128,9,0,128,56,12,0,161,56,
2,0,64,57,11,0,192,59,44,72,236,87,28,0,161,147,32,0,225,179,
12,0,129,147,60,0,129,145,40,0,193,147,36,0,65,177,41,114,5,72,
8,0,129,129,64,0,123,129,24,0,161,147,20,98,75,125,20,0,65,145,
48,0,123,128,2,0,0,56,40,0,193,147,32,0,225,179,44,0,1,57,
12,0,161,56,9,0,128,56,28,0,161,147,12,0,129,147,36,0,1,176,
16,0,1,145,229,113,5,72,72,0,129,131,80,0,193,131,84,0,225,131,
76,0,161,131,68,0,97,131,92,0,1,128,64,0,65,131,2,0,96,56,
166,3,8,124,88,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,
20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,120,27,125,124,
221,242,255,75,0,0,0,57,92,2,29,153,120,235,163,127,5,252,255,75,
121,27,127,124,144,0,130,64,48,0,29,128,1,0,32,57,48,0,63,125,
13,182,7,72,15,0,160,56,120,27,100,124,29,0,128,61,172,4,140,57,
9,0,96,61,248,112,107,57,0,0,192,59,8,0,195,147,4,0,99,145,
36,0,131,145,40,0,227,147,88,0,157,144,244,1,0,56,20,0,3,144,
120,235,163,127,17,254,255,75,120,27,100,124,88,0,125,128,181,187,7,72,
88,0,125,128,173,183,7,72,120,27,127,124,88,0,125,128,0,0,195,179,
137,180,8,72,119,0,189,136,48,0,157,128,11,0,96,60,152,20,99,56,
116,7,165,124,141,36,5,72,120,235,163,127,109,241,255,75,120,251,227,127,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,168,255,33,148,80,0,193,147,120,51,222,124,
16,0,30,40,64,0,65,147,84,0,225,147,166,2,8,124,92,0,1,144,
68,0,97,147,120,27,123,124,72,0,129,147,120,35,156,124,76,0,161,147,
120,43,189,124,24,0,129,64,11,0,96,60,204,20,99,56,210,10,128,56,
0,0,160,56,57,197,254,75,120,219,99,127,241,250,255,75,121,27,127,124,
20,1,130,64,48,0,27,128,1,0,160,56,48,0,191,124,249,180,7,72,
244,1,0,56,29,0,0,61,172,4,8,57,9,0,224,60,248,112,231,56,
0,0,64,59,8,0,67,147,4,0,227,144,36,0,3,145,40,0,227,147,
20,0,3,144,2,0,3,160,64,0,0,96,2,0,3,176,2,0,3,160,
0,8,0,96,88,0,123,144,2,0,3,176,40,0,65,147,44,0,65,147,
56,0,27,128,44,72,203,87,2,0,128,56,52,0,1,144,48,0,1,144,
56,0,97,145,129,186,7,72,88,0,27,128,20,0,65,147,16,0,129,147,
48,0,123,128,11,0,128,59,2,0,0,57,8,0,1,144,24,0,65,147,
9,0,128,56,8,0,161,56,28,0,193,179,40,0,1,56,12,0,1,144,
32,0,1,177,36,0,129,147,177,111,5,72,88,0,59,129,20,0,65,147,
16,0,161,147,48,0,123,128,40,0,161,56,2,0,224,59,24,0,65,147,
8,0,33,145,9,0,128,56,36,0,129,147,28,0,193,179,32,0,225,179,
12,0,161,144,8,0,161,56,117,111,5,72,88,0,123,128,253,181,7,72,
120,27,127,124,88,0,123,128,0,0,67,179,217,178,8,72,76,0,161,131,
120,251,227,127,84,0,225,131,72,0,129,131,80,0,193,131,92,0,1,128,
68,0,97,131,64,0,65,131,166,3,8,124,88,0,33,56,32,0,128,78,
232,255,33,148,12,0,161,147,16,0,193,147,20,0,225,147,166,2,8,124,
28,0,1,144,8,0,129,147,120,27,124,124,81,240,255,75,92,2,92,137,
116,7,74,125,1,0,10,40,108,0,130,65,3,0,10,40,184,0,128,65,
24,0,130,65,5,0,10,40,104,0,129,64,9,0,10,40,80,0,129,64,
160,0,0,72,48,0,156,128,60,0,124,129,4,0,160,56,11,0,96,60,
216,20,99,56,252,255,203,59,89,34,5,72,120,227,131,127,0,0,128,56,
120,243,197,127,4,0,192,56,229,253,255,75,0,0,0,56,92,2,28,152,
120,27,127,124,120,227,131,127,25,239,255,75,100,0,0,72,119,0,28,136,
116,7,0,124,76,0,0,44,72,0,130,64,48,0,156,128,60,0,220,131,
16,0,160,56,11,0,96,60,216,20,99,56,5,34,5,72,120,227,131,127,
4,0,128,56,120,243,197,127,16,0,192,56,145,253,255,75,0,0,0,56,
92,2,28,152,120,27,127,124,120,227,131,127,197,238,255,75,16,0,0,72,
120,227,131,127,185,238,255,75,0,0,224,59,120,251,227,127,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,166,2,8,124,28,0,1,144,
16,0,193,147,120,27,126,124,20,0,225,147,120,43,191,124,8,0,161,56,
141,242,255,75,45,72,101,84,32,0,130,64,20,0,225,131,28,0,1,128,
16,0,193,131,128,1,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
8,0,1,128,56,0,158,129,120,251,228,127,44,72,0,84,20,2,108,124,
0,0,0,56,84,0,30,176,237,222,7,72,28,0,1,128,20,0,225,131,
16,0,193,131,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,20,0,225,147,
120,35,159,124,12,0,161,147,0,0,160,63,124,0,0,72,120,243,195,127,
117,239,255,75,0,0,159,137,0,0,12,44,48,0,130,65,0,0,0,56,
0,0,31,152,68,71,125,56,81,152,8,72,0,0,3,44,24,0,130,65,
11,0,96,60,92,19,99,56,6,1,128,56,0,0,160,56,229,193,254,75,
1,0,96,56,221,227,4,72,120,243,195,127,0,0,128,56,133,239,255,75,
0,0,255,136,0,0,7,44,28,0,130,64,68,71,125,56,0,0,128,56,
133,155,8,72,52,0,96,124,126,217,8,84,0,0,31,153,0,0,30,136,
0,0,0,44,128,255,130,65,0,0,31,136,0,0,0,44,116,255,130,65,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,216,255,33,148,12,0,33,147,166,2,8,124,
44,0,1,144,32,0,193,147,28,0,161,147,121,27,125,124,120,35,158,124,
20,0,97,147,1,0,96,63,2,144,123,59,24,0,129,147,28,0,128,63,
172,126,156,59,16,0,65,147,36,0,225,147,0,0,224,59,120,251,250,127,
36,1,130,65,255,7,169,87,16,1,130,65,96,2,154,29,20,98,60,127,
69,0,249,139,1,64,30,44,20,0,130,64,1,0,255,107,0,0,31,44,
232,0,130,65,12,0,0,72,0,0,31,44,220,0,130,65,119,0,153,137,
116,7,140,125,76,0,12,44,12,0,160,60,32,16,165,56,12,0,130,64,
12,0,160,60,80,16,165,56,7,0,224,56,58,16,224,84,80,0,7,124,
60,8,0,84,20,2,5,125,0,0,40,161,20,2,217,124,122,0,38,181,
2,0,72,161,2,0,70,177,4,0,8,160,0,0,7,44,255,255,231,56,
4,0,6,176,204,255,130,64,1,64,30,44,88,0,130,64,1,0,128,57,
69,0,153,153,1,0,27,56,116,0,25,176,124,128,237,160,122,0,249,176,
126,128,13,161,124,0,25,177,128,128,77,161,9,0,0,56,121,0,25,152,
126,0,89,177,132,128,205,160,170,0,217,176,134,128,237,160,172,0,249,176,
136,128,13,161,92,0,121,56,174,0,25,177,149,239,255,75,44,0,0,72,
0,0,128,56,69,0,153,152,116,0,121,179,8,0,96,57,121,0,121,153,
170,0,121,56,6,0,160,56,17,187,254,75,92,0,121,56,105,239,255,75,
127,248,189,87,1,0,90,59,228,254,130,64,20,0,97,131,28,0,161,131,
120,251,227,127,36,0,225,131,24,0,129,131,32,0,193,131,44,0,1,128,
16,0,65,131,12,0,33,131,166,3,8,124,40,0,33,56,32,0,128,78,
128,255,33,148,92,0,225,146,96,0,1,147,100,0,33,147,112,0,129,147,
120,0,193,147,166,2,8,124,132,0,1,144,116,0,161,147,120,35,157,124,
108,0,97,147,0,0,96,59,104,0,65,147,124,0,225,147,120,27,127,124,
120,251,250,127,121,175,7,72,0,0,31,44,120,27,124,124,244,1,160,56,
29,0,0,60,172,4,0,48,9,0,128,61,248,112,140,57,8,0,99,147,
4,0,131,145,36,0,3,144,40,0,227,147,20,0,163,144,120,219,126,127,
56,0,130,65,255,7,230,87,36,0,130,65,96,2,30,28,28,0,0,61,
120,227,132,127,120,235,165,127,172,126,8,57,20,2,104,124,97,247,255,75,
20,26,123,127,127,248,255,87,1,0,222,59,208,255,130,64,120,227,131,127,
120,219,100,127,245,180,7,72,120,227,131,127,237,176,7,72,121,27,127,124,
148,0,130,65,124,196,45,129,8,193,13,56,64,0,9,124,132,0,130,64,
8,0,97,56,0,0,128,56,80,0,160,56,225,185,254,75,24,0,252,130,
255,255,247,56,57,56,232,126,32,132,194,59,8,0,130,65,24,132,194,59,
0,0,23,44,61,0,160,56,8,0,33,59,0,0,0,59,48,0,130,65,
255,7,224,86,28,0,130,65,120,203,35,127,120,195,6,127,40,132,130,56,
137,19,5,72,20,26,57,127,44,0,160,56,127,248,247,86,1,0,24,59,
216,255,130,64,184,192,109,160,120,243,197,127,48,132,130,56,8,0,193,56,
32,0,224,56,225,200,2,72,0,0,0,56,0,0,28,176,120,227,131,127,
49,173,8,72,120,211,68,127,120,235,165,127,120,219,102,127,120,251,231,127,
11,0,96,60,8,21,99,56,49,29,5,72,112,0,129,131,100,0,33,131,
104,0,65,131,116,0,161,131,120,251,227,127,124,0,225,131,108,0,97,131,
120,0,193,131,132,0,1,128,96,0,1,131,92,0,225,130,166,3,8,124,
128,0,33,56,32,0,128,78,92,2,3,136,116,7,0,124,12,0,0,40,
196,0,129,65,58,16,11,84,2,0,139,61,136,201,12,128,166,3,9,124,
32,4,128,78,32,202,1,0,32,202,1,0,52,202,1,0,12,202,1,0,
228,201,1,0,248,201,1,0,228,201,1,0,248,201,1,0,228,201,1,0,
248,201,1,0,228,201,1,0,188,201,1,0,208,201,1,0,48,0,99,128,
236,0,128,56,0,0,160,56,120,43,166,124,148,233,0,72,48,0,99,128,
238,0,128,56,0,0,160,56,120,43,166,124,128,233,0,72,48,0,99,128,
221,0,128,56,0,0,160,56,120,43,166,124,108,233,0,72,48,0,99,128,
219,0,128,56,0,0,160,56,120,43,166,124,88,233,0,72,48,0,99,128,
217,0,128,56,0,0,160,56,120,43,166,124,68,233,0,72,48,0,99,128,
255,0,128,56,0,0,160,56,120,43,166,124,48,233,0,72,48,0,99,128,
0,0,128,56,120,35,133,124,120,43,166,124,28,233,0,72,216,255,33,148,
8,0,1,147,166,2,8,124,44,0,1,144,24,0,129,147,120,35,156,124,
28,0,161,147,120,43,189,124,32,0,193,147,120,51,222,124,12,0,33,147,
16,0,65,147,121,27,122,124,120,211,89,127,20,0,97,147,36,0,225,147,
0,0,224,59,120,251,251,127,192,0,130,65,255,7,42,87,172,0,130,65,
96,2,155,29,28,0,108,61,1,0,128,56,172,126,11,59,120,195,3,127,
92,0,184,56,1,250,255,75,0,0,3,44,120,27,127,124,144,0,130,64,
120,195,3,127,120,227,133,127,2,0,128,56,229,249,255,75,121,27,127,124,
120,0,130,64,4,0,28,128,4,0,128,56,72,0,24,144,120,195,3,127,
120,235,165,127,197,249,255,75,121,27,127,124,88,0,130,64,4,0,221,128,
69,0,24,136,0,0,0,44,8,0,128,56,80,0,216,144,8,0,130,65,
16,0,128,56,120,195,3,127,120,243,197,127,149,249,255,75,121,27,127,124,
40,0,130,64,4,0,30,129,1,0,0,56,76,0,24,145,120,195,3,127,
92,2,24,152,37,254,255,75,127,248,57,87,1,0,123,59,72,255,130,64,
0,0,31,44,20,0,130,64,120,211,67,127,15,0,128,56,69,252,255,75,
120,27,127,124,16,0,65,131,24,0,129,131,28,0,161,131,120,251,227,127,
36,0,225,131,20,0,97,131,32,0,193,131,44,0,1,128,12,0,33,131,
8,0,1,131,166,3,8,124,40,0,33,56,32,0,128,78,0,0,128,57,
120,99,133,125,52,0,96,124,126,217,11,84,1,0,224,56,48,40,230,124,
57,48,104,125,32,0,130,64,96,2,37,29,28,0,105,61,172,126,75,57,
72,0,10,128,64,96,0,124,8,0,129,64,120,3,12,124,1,0,165,56,
16,0,5,44,196,255,128,65,1,0,108,56,32,0,128,78,0,0,128,57,
120,99,133,125,52,0,96,124,126,217,11,84,1,0,224,56,48,40,230,124,
57,48,104,125,32,0,130,64,96,2,37,29,28,0,105,61,172,126,75,57,
80,0,10,128,64,96,0,124,8,0,129,64,120,3,12,124,1,0,165,56,
16,0,5,44,196,255,128,65,1,0,108,56,32,0,128,78,0,0,128,57,
120,99,133,125,52,0,96,124,126,217,11,84,1,0,224,56,48,40,230,124,
57,48,104,125,32,0,130,64,96,2,37,29,28,0,105,61,172,126,75,57,
76,0,10,128,64,96,0,124,8,0,129,64,120,3,12,124,1,0,165,56,
16,0,5,44,196,255,128,65,1,0,108,56,32,0,128,78,224,255,33,148,
12,0,97,147,16,0,129,147,166,2,8,124,36,0,1,144,20,0,161,147,
120,27,125,124,24,0,193,147,120,35,158,124,0,0,128,56,28,0,225,147,
120,43,191,124,0,18,160,56,173,181,254,75,104,0,158,129,236,0,12,128,
120,243,195,127,56,1,157,56,166,3,9,124,33,4,128,78,120,27,123,124,
120,243,195,127,13,79,8,72,120,27,124,124,73,123,8,72,48,1,125,176,
120,227,131,127,209,28,8,72,56,1,157,57,58,16,103,87,20,218,7,124,
58,16,0,84,20,2,140,124,20,0,99,56,25,80,3,72,120,27,126,124,
20,242,123,127,163,0,27,44,24,0,129,64,120,219,101,127,11,0,96,60,
76,21,99,56,2,13,128,56,69,186,254,75,52,1,125,179,120,227,131,127,
249,67,8,72,0,0,30,44,20,0,0,56,1,48,96,57,255,255,3,49,
16,25,40,125,54,1,29,176,20,0,130,64,0,0,9,44,12,0,130,64,
51,0,27,44,8,0,129,64,1,64,96,57,50,1,125,177,4,0,253,147,
120,235,163,127,117,233,255,75,20,0,161,131,24,0,193,131,28,0,225,131,
36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,
32,0,128,78,216,255,33,148,28,0,161,147,32,0,193,147,20,0,97,147,
24,0,129,147,36,0,225,147,166,2,8,124,44,0,1,144,9,128,141,137,
116,7,140,125,0,0,128,59,120,227,155,127,0,96,27,124,120,27,125,124,
120,35,158,124,120,227,159,127,0,0,158,147,164,0,128,64,104,0,29,129,
188,0,8,128,120,235,163,127,120,219,100,127,166,3,9,124,33,4,128,78,
12,0,97,144,14,0,1,161,10,0,1,177,8,0,97,176,8,0,1,128,
255,7,0,84,92,0,130,65,120,219,99,127,229,216,0,72,0,0,3,44,
76,0,130,65,10,0,129,168,96,2,123,29,28,0,139,61,1,0,156,59,
172,126,108,56,237,239,255,75,8,0,1,128,189,7,0,84,16,0,130,64,
1,0,32,57,48,216,39,125,120,59,255,127,8,0,65,129,49,6,74,85,
16,0,130,65,0,0,126,129,1,0,107,57,0,0,126,145,9,128,141,137,
116,7,140,125,1,0,123,59,0,96,27,124,100,255,128,65,0,0,62,129,
0,0,9,44,32,0,130,65,64,224,9,124,24,0,130,65,11,0,96,60,
88,21,99,56,244,6,128,56,0,0,160,56,197,184,254,75,120,251,227,127,
36,0,225,131,28,0,161,131,32,0,193,131,44,0,1,128,24,0,129,131,
20,0,97,131,166,3,8,124,40,0,33,56,32,0,128,78,232,255,33,148,
166,2,8,124,28,0,1,144,20,0,225,147,120,27,127,124,12,0,161,147,
120,35,157,124,120,235,163,127,0,0,128,56,16,0,193,147,120,43,190,124,
0,2,160,56,89,179,254,75,16,0,31,40,20,0,128,64,120,251,227,127,
12,0,157,56,244,1,160,56,217,144,3,72,3,64,0,56,8,0,29,176,
4,0,221,147,120,235,163,127,0,2,157,56,69,231,255,75,0,0,125,144,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,176,255,33,148,56,0,65,147,60,0,97,147,
68,0,161,147,72,0,193,147,76,0,225,147,0,0,224,59,12,0,225,179,
166,2,8,124,84,0,1,144,11,0,0,60,100,21,0,48,16,0,1,144,
64,0,129,147,120,27,124,124,20,0,129,147,24,0,129,147,28,0,1,144,
40,0,97,56,56,132,130,56,197,170,4,72,28,0,129,128,24,0,161,128,
11,0,96,60,40,0,193,56,116,21,99,56,137,22,5,72,9,0,97,56,
120,251,228,127,241,229,255,75,0,0,192,63,68,71,126,56,120,251,228,127,
93,145,8,72,16,0,28,40,52,0,102,124,126,217,199,84,8,0,225,152,
28,0,128,64,58,16,137,87,20,226,9,124,56,24,0,84,248,193,141,57,
20,2,108,125,8,0,235,131,0,0,31,44,11,0,160,63,140,0,130,64,
0,0,7,44,10,1,0,56,12,0,1,176,44,0,130,65,0,0,128,57,
8,0,129,153,68,71,126,56,137,141,8,72,0,0,3,44,20,0,130,65,
92,19,125,56,6,1,128,56,0,0,160,56,33,183,254,75,9,0,97,56,
2,0,128,56,25,229,255,75,24,0,97,56,2,0,128,56,101,226,255,75,
12,0,97,56,2,0,128,56,241,225,255,75,64,0,129,131,72,0,193,131,
76,0,225,131,68,0,161,131,60,0,97,131,84,0,1,128,56,0,65,131,
10,1,96,56,166,3,8,124,80,0,33,56,32,0,128,78,9,0,97,56,
8,0,129,56,125,244,255,75,120,251,227,127,32,0,129,56,233,252,255,75,
32,0,1,128,0,0,0,44,120,27,122,124,140,0,130,64,8,0,33,137,
0,0,9,44,12,0,225,171,44,0,130,65,0,0,0,57,8,0,1,153,
68,71,126,56,217,140,8,72,0,0,3,44,20,0,130,65,92,19,125,56,
6,1,128,56,0,0,160,56,113,182,254,75,9,0,97,56,2,0,128,56,
105,228,255,75,24,0,97,56,2,0,128,56,181,225,255,75,12,0,97,56,
2,0,128,56,65,225,255,75,68,0,161,131,120,251,227,127,76,0,225,131,
64,0,129,131,72,0,193,131,84,0,1,128,60,0,97,131,56,0,65,131,
166,3,8,124,80,0,33,56,32,0,128,78,120,211,68,127,36,0,97,56,
217,226,255,75,0,2,96,56,101,255,4,72,121,27,123,124,24,0,130,64,
11,0,96,60,152,21,99,56,19,10,128,56,0,0,160,56,241,181,254,75,
120,211,67,127,89,250,255,75,120,27,101,124,120,227,131,127,120,219,100,127,
65,253,255,75,121,211,95,127,0,0,128,59,60,0,130,65,255,7,234,87,
40,0,130,65,96,2,124,29,28,0,139,61,120,219,101,127,4,0,128,56,
172,126,108,56,229,242,255,75,0,0,3,44,12,0,97,176,44,0,130,64,
113,14,255,127,1,0,156,59,204,255,130,64,12,0,97,168,0,0,3,44,
20,0,130,64,120,211,67,127,4,0,128,56,165,245,255,75,12,0,97,176,
120,27,127,124,120,219,99,127,105,0,5,72,36,0,97,56,2,0,128,56,
101,225,255,75,8,0,97,137,0,0,11,44,44,0,130,65,0,0,64,57,
8,0,65,153,68,71,126,56,149,139,8,72,0,0,3,44,20,0,130,65,
92,19,125,56,6,1,128,56,0,0,160,56,45,181,254,75,9,0,97,56,
2,0,128,56,37,227,255,75,24,0,97,56,2,0,128,56,113,224,255,75,
12,0,97,56,2,0,128,56,253,223,255,75,68,0,161,131,120,251,227,127,
76,0,225,131,64,0,129,131,72,0,193,131,84,0,1,128,60,0,97,131,
56,0,65,131,166,3,8,124,80,0,33,56,32,0,128,78,0,0,3,44,
0,0,0,56,120,3,10,124,64,0,130,65,255,7,108,84,44,0,130,65,
96,2,10,28,28,0,96,61,20,2,139,125,35,127,12,136,116,7,0,124,
76,0,0,40,48,0,130,65,78,0,0,40,40,0,130,65,32,0,0,72,
127,248,99,84,1,0,74,57,200,255,130,64,76,0,0,40,16,0,130,65,
78,0,0,40,8,0,130,65,78,0,0,56,120,3,3,124,32,0,128,78,
224,255,33,148,20,0,161,147,24,0,193,147,28,0,225,147,121,27,127,124,
166,2,8,124,36,0,1,144,20,0,130,64,28,0,225,131,32,0,33,56,
166,3,8,124,32,0,128,78,9,128,13,136,116,7,0,124,0,0,192,59,
120,243,221,127,0,0,29,124,88,0,128,64,104,0,63,129,188,0,73,129,
120,251,227,127,120,235,164,127,166,3,73,125,33,4,128,78,12,0,97,144,
14,0,33,161,10,0,33,177,8,0,97,176,8,0,65,129,255,7,74,85,
16,0,130,65,1,0,128,57,48,232,139,125,120,91,222,127,9,128,13,136,
116,7,0,124,1,0,189,59,0,0,29,124,176,255,128,65,120,243,195,127,
24,0,193,131,36,0,1,128,28,0,225,131,20,0,161,131,166,3,8,124,
32,0,33,56,32,0,128,78,16,0,3,40,0,0,0,56,28,0,128,64,
58,16,108,84,20,26,140,125,56,24,140,85,0,0,108,61,96,66,139,57,
8,0,12,128,120,3,3,124,28,255,255,75,168,255,33,148,64,0,65,147,
68,0,97,147,76,0,161,147,80,0,193,147,84,0,225,147,166,2,8,124,
92,0,1,144,72,0,129,147,120,27,124,124,56,0,28,128,48,0,156,129,
120,43,191,124,52,0,1,144,48,0,1,144,120,35,157,124,1,0,192,59,
48,96,218,127,44,72,224,87,56,0,1,144,25,163,7,72,244,1,64,57,
120,243,196,127,29,0,32,61,60,48,41,57,9,0,0,61,248,112,8,57,
0,0,96,59,8,0,99,147,4,0,3,145,36,0,35,145,40,0,67,147,
20,0,67,145,88,0,124,144,213,168,7,72,88,0,124,129,2,0,139,161,
0,1,140,97,2,0,139,177,2,0,171,160,0,8,165,96,2,0,171,176,
16,0,161,147,20,0,97,147,48,0,124,128,120,219,100,127,40,0,225,56,
12,0,32,57,24,0,97,147,32,0,129,176,8,0,161,56,28,0,225,179,
8,0,97,145,12,0,225,144,36,0,33,145,241,93,5,72,95,2,220,155,
80,0,193,131,72,0,129,131,76,0,161,131,84,0,225,131,92,0,1,128,
68,0,97,131,64,0,65,131,166,3,8,124,88,0,33,56,32,0,128,78,
240,255,33,148,8,0,193,147,120,27,126,124,12,0,225,147,166,2,8,124,
20,0,1,144,48,0,30,128,0,0,160,56,29,0,96,60,1,0,224,59,
60,48,99,56,48,0,228,127,97,145,8,72,94,2,254,155,95,2,254,155,
93,2,254,155,20,0,1,128,120,251,227,127,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,88,0,127,128,0,0,3,44,
8,0,130,65,169,168,7,72,12,0,128,57,92,2,159,153,120,251,227,127,
217,243,255,75,120,251,227,127,173,221,255,75,0,0,0,56,94,2,31,152,
95,2,31,152,93,2,31,152,20,0,1,128,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,92,2,159,137,116,7,140,125,
12,0,12,44,12,0,130,65,11,0,0,56,92,2,31,152,0,0,192,59,
94,2,223,155,120,251,227,127,109,243,255,75,120,251,227,127,65,221,255,75,
12,0,225,131,20,0,1,128,120,243,195,127,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
0,0,0,56,12,0,225,147,94,2,3,152,120,27,127,124,41,243,255,75,
120,251,227,127,253,220,255,75,20,0,1,128,12,0,225,131,11,0,96,56,
16,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,12,0,161,147,
16,0,193,147,166,2,8,124,28,0,1,144,20,0,225,147,120,27,127,124,
88,0,127,128,0,0,160,59,95,2,191,155,12,0,195,171,0,0,163,179,
173,159,8,72,0,0,30,44,88,0,191,147,36,0,130,65,48,0,191,128,
120,243,198,127,67,0,96,56,11,0,128,60,1,0,0,56,68,0,31,152,
164,21,132,56,253,179,254,75,20,0,225,131,16,0,193,131,28,0,1,128,
12,0,161,131,11,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
232,255,33,148,12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,
16,0,193,147,120,27,126,124,88,0,126,128,0,0,224,59,95,2,254,155,
12,0,163,171,0,0,227,179,45,159,8,72,0,0,29,44,88,0,254,147,
28,0,130,64,56,0,126,128,92,0,158,56,0,2,160,56,53,204,7,72,
121,27,125,124,144,0,130,65,48,0,158,128,120,235,165,127,11,0,96,60,
184,21,99,56,17,15,5,72,4,2,29,44,11,0,32,57,8,0,130,64,
12,0,32,57,92,2,62,153,120,243,195,127,233,230,255,75,64,0,62,129,
64,24,9,124,44,0,130,64,4,0,0,56,64,0,30,144,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,6,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,0,0,0,56,92,2,30,152,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,12,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,19,2,254,56,60,132,130,57,255,255,12,57,
4,0,32,57,166,3,41,125,1,0,71,141,1,0,104,141,81,80,139,125,
16,0,130,64,0,0,10,44,8,0,130,65,232,255,0,66,0,0,12,44,
36,0,130,64,3,0,0,57,92,2,30,153,4,0,64,57,64,0,94,145,
76,0,0,56,119,0,30,152,11,0,96,56,16,0,0,72,0,0,128,57,
92,2,158,153,11,0,96,56,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,88,0,126,128,0,0,224,59,95,2,254,155,12,0,163,171,
0,0,227,179,201,157,8,72,0,0,29,44,88,0,254,147,28,0,130,64,
56,0,126,128,92,0,158,56,0,2,160,56,209,202,7,72,121,27,125,124,
104,0,130,65,48,0,158,128,120,235,165,127,11,0,96,60,232,21,99,56,
173,13,5,72,4,2,29,44,11,0,0,56,8,0,130,64,12,0,0,56,
92,2,30,152,120,243,195,127,133,229,255,75,64,0,30,128,64,24,0,124,
12,0,130,64,2,2,29,44,76,0,130,65,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,12,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,120,243,195,127,157,226,255,75,0,0,3,44,92,2,126,152,
92,0,130,64,120,243,195,127,53,229,255,75,64,0,30,128,64,24,0,124,
40,0,130,64,4,0,96,56,64,0,126,144,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,5,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,1,0,3,44,48,0,130,64,
118,0,158,137,116,7,140,125,255,255,12,44,15,0,0,56,84,0,30,176,
52,0,158,145,12,0,130,65,16,0,12,44,12,0,129,64,10,0,0,57,
92,2,30,153,20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,
11,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,88,0,126,128,0,0,224,59,95,2,254,155,12,0,163,171,
0,0,227,179,77,156,8,72,0,0,29,44,88,0,254,147,28,0,130,64,
56,0,126,128,92,0,158,56,0,2,160,56,85,201,7,72,121,27,125,124,
108,0,130,65,48,0,158,128,120,235,165,127,11,0,96,60,44,22,99,56,
49,12,5,72,48,0,190,128,120,235,166,127,66,0,96,56,11,0,128,60,
1,0,0,56,68,0,30,152,24,22,132,56,113,176,254,75,4,2,29,44,
11,0,0,56,8,0,130,64,12,0,0,56,92,2,30,152,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,4,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,120,243,195,127,29,225,255,75,0,0,3,44,
92,2,126,152,36,0,130,64,20,0,225,131,16,0,193,131,28,0,1,128,
12,0,161,131,5,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
1,0,3,44,104,0,130,64,119,0,30,136,116,7,0,124,76,0,0,44,
15,0,128,57,84,0,158,177,12,0,130,64,4,0,0,56,64,0,30,144,
118,0,126,137,116,7,107,125,255,255,11,44,52,0,126,145,12,0,130,65,
16,0,11,44,92,0,129,64,10,0,32,57,92,2,62,153,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,4,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,4,0,3,44,12,0,130,65,5,0,3,44,
36,0,130,64,20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,
4,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,3,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,48,0,159,128,11,0,96,60,0,0,160,56,
92,22,99,56,197,10,5,72,120,251,227,127,0,0,128,56,4,0,160,56,
81,248,255,75,20,0,1,128,12,0,225,131,10,0,96,56,16,0,33,56,
166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
60,0,131,129,252,255,140,56,4,0,160,56,29,248,255,75,12,0,1,128,
8,0,33,56,166,3,8,124,10,0,96,56,32,0,128,78,200,255,33,148,
40,0,129,147,48,0,193,147,52,0,225,147,166,2,8,124,60,0,1,144,
44,0,161,147,120,27,125,124,48,0,93,129,1,0,192,59,48,80,220,127,
65,155,7,72,120,243,196,127,244,1,0,57,29,0,224,60,60,48,231,56,
9,0,192,60,248,112,198,56,0,0,224,59,8,0,227,147,4,0,195,144,
36,0,227,144,40,0,131,147,20,0,3,145,88,0,125,144,253,160,7,72,
88,0,157,129,2,0,44,161,0,1,41,97,2,0,44,177,2,0,76,161,
64,0,125,129,0,8,74,97,2,0,76,177,16,0,97,145,20,0,225,147,
48,0,125,128,16,0,0,56,32,0,225,179,8,0,129,145,12,0,225,147,
8,0,161,56,3,0,128,56,36,0,225,147,24,0,225,147,28,0,1,176,
25,86,5,72,95,2,221,155,52,0,225,131,48,0,193,131,44,0,161,131,
60,0,1,128,40,0,129,131,8,0,96,56,166,3,8,124,56,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,48,0,159,128,64,0,191,128,11,0,96,60,140,22,99,56,
97,9,5,72,64,0,159,128,120,251,227,127,16,0,160,56,237,246,255,75,
20,0,1,128,12,0,225,131,9,0,96,56,16,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,60,0,131,128,
16,0,160,56,189,246,255,75,12,0,1,128,8,0,33,56,166,3,8,124,
7,0,96,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,48,0,126,128,101,207,0,72,
4,252,3,56,60,0,30,144,120,243,195,127,209,224,255,75,0,0,224,59,
84,0,254,179,64,0,126,144,92,0,126,56,120,251,228,127,0,2,160,56,
213,164,254,75,1,0,0,56,94,2,30,152,95,2,254,155,12,0,225,131,
20,0,1,128,8,0,193,131,2,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,120,27,108,124,0,0,96,56,94,2,108,152,95,2,108,152,
32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,93,2,127,136,11,0,192,63,116,7,99,124,
152,24,222,59,13,0,3,44,72,0,128,65,11,0,96,60,184,22,99,56,
254,2,128,56,0,0,160,56,101,169,254,75,0,0,3,44,93,2,127,136,
116,7,99,124,36,0,130,65,54,32,99,84,20,26,126,125,10,0,139,169,
0,0,12,44,8,0,43,169,20,74,127,124,72,0,128,64,32,0,0,72,
54,32,99,84,20,26,126,125,10,0,139,169,0,0,12,44,8,0,43,169,
20,74,127,124,40,0,128,64,12,0,43,129,166,3,41,125,33,4,128,78,
95,2,31,136,0,0,0,44,94,2,31,136,93,2,127,152,104,0,130,65,
108,0,0,72,12,0,11,168,20,2,195,124,191,7,192,84,56,24,140,85,
12,0,130,64,0,0,6,129,36,0,0,72,80,48,192,124,0,0,70,129,
4,0,6,129,56,24,0,84,48,4,74,125,32,0,0,32,48,0,8,125,
120,83,8,125,20,98,136,125,4,0,44,129,166,3,41,125,33,4,128,78,
95,2,31,136,0,0,0,44,94,2,31,136,93,2,127,152,12,0,130,64,
0,0,0,44,16,255,130,64,12,0,225,131,120,3,3,124,20,0,1,128,
8,0,193,131,16,0,33,56,166,3,8,124,32,0,128,78,216,255,33,148,
28,0,161,147,120,27,125,124,16,0,29,40,12,0,33,147,16,0,65,147,
20,0,97,147,24,0,129,147,32,0,193,147,36,0,225,147,166,2,8,124,
0,0,96,56,44,0,1,144,28,0,128,64,58,16,167,87,20,234,7,124,
56,24,0,84,248,193,45,57,20,2,9,125,8,0,104,128,0,0,3,44,
52,0,130,64,32,0,193,131,20,0,97,131,24,0,129,131,36,0,225,131,
28,0,161,131,16,0,65,131,44,0,1,128,12,0,33,131,10,1,96,56,
166,3,8,124,40,0,33,56,32,0,128,78,8,0,129,56,17,238,255,75,
120,27,127,124,120,235,163,127,153,46,8,72,0,0,3,44,72,0,130,65,
8,0,65,129,0,0,10,44,60,0,130,64,120,235,163,127,97,100,8,72,
32,0,193,131,20,0,97,131,24,0,129,131,36,0,225,131,28,0,161,131,
16,0,65,131,44,0,1,128,12,0,33,131,0,0,96,56,166,3,8,124,
40,0,33,56,32,0,128,78,0,2,96,56,217,240,4,72,121,27,121,124,
24,0,130,64,11,0,96,60,0,23,99,56,4,14,128,56,0,0,160,56,
101,167,254,75,0,0,31,44,255,255,96,59,28,0,128,63,172,126,156,59,
0,0,64,59,120,211,94,127,68,0,130,65,255,7,224,87,48,0,130,65,
96,2,30,28,20,2,124,124,120,203,36,127,109,215,255,75,0,0,3,44,
24,0,130,64,4,0,25,128,0,208,0,124,12,0,129,64,120,3,26,124,
120,243,219,127,113,14,255,127,1,0,222,59,196,255,130,64,255,255,27,44,
76,0,130,64,120,235,164,127,11,0,96,60,196,22,99,56,205,5,5,72,
120,203,35,127,229,241,4,72,32,0,193,131,20,0,97,131,24,0,129,131,
36,0,225,131,28,0,161,131,16,0,65,131,44,0,1,128,12,0,33,131,
0,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,96,2,187,28,
20,42,124,124,120,203,36,127,229,214,255,75,121,27,127,124,60,0,130,65,
120,203,35,127,149,241,4,72,20,0,97,131,28,0,161,131,120,251,227,127,
36,0,225,131,24,0,129,131,32,0,193,131,44,0,1,128,16,0,65,131,
12,0,33,131,166,3,8,124,40,0,33,56,32,0,128,78,120,235,163,127,
12,0,153,56,57,127,3,72,120,203,35,127,81,241,4,72,32,0,193,131,
20,0,97,131,24,0,129,131,36,0,225,131,28,0,161,131,16,0,65,131,
44,0,1,128,12,0,33,131,0,0,96,56,166,3,8,124,40,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,240,255,33,148,120,27,96,124,
16,0,0,40,0,0,96,56,28,0,128,64,58,16,12,84,20,2,12,124,
56,24,0,84,248,193,141,57,20,2,140,125,8,0,108,128,0,0,3,44,
24,0,130,64,20,0,1,128,16,0,33,56,166,3,8,124,62,6,99,84,
32,0,128,78,8,0,129,56,253,235,255,75,241,240,255,75,78,0,96,104,
52,0,12,124,20,0,1,128,62,222,131,85,166,3,8,124,16,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,240,255,33,148,16,0,3,40,
0,0,0,56,28,0,128,64,58,16,108,84,20,26,12,124,56,24,0,84,
248,193,141,57,20,2,140,125,8,0,12,128,0,0,0,44,24,0,130,64,
62,6,3,84,20,0,1,128,16,0,33,56,166,3,8,124,32,0,128,78,
120,3,3,124,8,0,129,56,133,235,255,75,8,0,129,129,255,255,12,48,
16,97,0,124,62,6,3,84,20,0,1,128,16,0,33,56,166,3,8,124,
32,0,128,78,224,255,33,148,16,0,4,40,20,0,161,147,24,0,193,147,
28,0,225,147,166,2,8,124,36,0,1,144,16,0,129,147,120,27,124,124,
0,0,96,56,28,0,128,64,58,16,138,84,20,34,10,124,56,24,0,84,
248,193,141,57,20,2,108,125,8,0,107,128,0,0,3,44,28,0,130,65,
8,0,129,56,17,235,255,75,8,0,129,129,0,0,12,44,120,27,126,124,
40,0,130,64,28,0,225,131,24,0,193,131,20,0,161,131,36,0,1,128,
16,0,129,131,0,0,96,56,166,3,8,124,32,0,33,56,32,0,128,78,
120,243,196,127,12,0,97,56,101,209,255,75,0,0,30,44,0,0,224,59,
120,251,253,127,108,0,130,65,255,7,192,87,84,0,130,65,96,2,125,29,
28,0,235,60,172,126,103,56,68,0,3,137,0,0,8,44,60,0,130,65,
84,0,163,160,15,0,5,44,32,0,130,65,120,235,164,127,11,0,96,60,
12,23,99,56,49,3,5,72,1,0,189,59,112,14,222,127,28,0,0,72,
120,227,132,127,15,0,160,56,97,220,255,75,20,26,255,127,1,0,189,59,
112,14,222,127,0,0,30,44,156,255,130,64,12,0,97,56,2,0,128,56,
33,208,255,75,120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
216,255,33,148,16,0,65,147,20,0,97,147,24,0,129,147,28,0,161,147,
166,2,8,124,44,0,1,144,36,0,225,147,120,27,127,124,32,0,193,147,
120,35,158,124,120,243,195,127,0,0,128,56,88,1,160,56,173,158,254,75,
0,0,31,44,48,0,130,64,28,0,161,131,120,251,227,127,36,0,225,131,
24,0,129,131,32,0,193,131,44,0,1,128,20,0,97,131,16,0,65,131,
166,3,8,124,40,0,33,56,32,0,128,78,0,0,64,63,68,71,122,56,
255,255,128,56,69,125,8,72,0,0,3,44,240,255,130,64,9,128,141,137,
116,7,140,125,0,0,160,59,0,96,29,124,8,0,158,59,120,227,155,127,
92,0,128,64,104,0,191,128,188,0,5,128,120,251,227,127,120,235,164,127,
166,3,9,124,33,4,128,78,12,0,97,144,14,0,1,160,10,0,1,176,
8,0,97,176,8,0,97,129,255,7,107,85,20,0,130,65,120,235,163,127,
120,219,100,127,53,198,0,72,120,27,123,124,9,128,141,137,116,7,140,125,
1,0,189,59,0,96,29,124,172,255,128,65,248,191,13,128,80,216,252,127,
80,1,31,44,0,0,254,147,4,0,30,144,36,0,129,64,11,0,96,60,
68,23,99,56,242,11,128,56,0,0,160,56,209,162,254,75,0,0,254,131,
0,0,3,44,4,0,130,65,68,71,122,56,13,121,8,72,0,0,3,44,
24,0,130,65,11,0,96,60,92,19,99,56,6,1,128,56,0,0,160,56,
161,162,254,75,28,0,161,131,120,251,227,127,36,0,225,131,24,0,129,131,
32,0,193,131,44,0,1,128,20,0,97,131,16,0,65,131,166,3,8,124,
40,0,33,56,32,0,128,78,176,255,33,148,44,0,225,146,48,0,1,147,
52,0,33,147,56,0,65,147,60,0,97,147,166,2,8,124,84,0,1,144,
72,0,193,147,11,0,192,63,76,0,225,147,255,255,224,59,20,0,225,147,
64,0,129,147,11,0,128,63,80,23,156,59,24,0,129,147,68,0,161,147,
120,27,125,124,28,0,97,56,68,132,130,56,29,149,4,72,20,0,161,128,
24,0,129,128,11,0,96,60,28,0,193,56,92,23,99,56,225,0,5,72,
0,0,0,56,8,0,1,176,12,0,129,147,16,0,225,147,0,6,96,56,
69,235,4,72,120,27,122,124,0,2,96,56,57,235,4,72,120,27,123,124,
0,18,96,56,45,235,4,72,0,0,26,44,120,27,124,124,20,0,130,64,
128,23,126,56,121,11,128,56,0,0,160,56,185,161,254,75,0,0,27,44,
20,0,130,64,128,23,126,56,122,11,128,56,0,0,160,56,161,161,254,75,
0,0,28,44,24,0,130,64,128,23,126,56,123,11,128,56,0,0,160,56,
137,161,254,75,0,0,3,44,121,235,190,127,0,0,32,59,216,1,130,65,
255,7,192,87,196,1,130,65,96,2,25,29,28,0,104,61,172,126,11,59,
120,195,3,127,117,221,255,75,0,0,3,44,8,0,97,176,204,1,130,64,
120,195,3,127,0,0,128,56,1,216,255,75,120,195,3,127,78,0,128,56,
49,216,255,75,120,195,3,127,92,0,184,56,1,0,128,56,97,222,255,75,
0,0,3,44,8,0,97,176,152,1,130,64,120,211,67,127,0,0,128,56,
0,6,160,56,253,155,254,75,48,0,250,59,120,203,35,127,56,0,250,58,
120,187,228,126,25,196,0,72,248,191,13,128,20,2,153,125,120,251,228,127,
88,1,160,56,52,0,154,145,80,24,23,124,48,0,26,144,24,3,122,56,
89,30,5,72,1,32,192,56,8,0,218,176,1,0,224,56,4,0,250,144,
21,0,0,57,10,0,26,177,88,1,0,56,12,0,26,176,144,1,0,56,
14,0,26,176,120,211,67,127,0,6,154,56,173,207,255,75,0,0,122,144,
120,195,3,127,120,211,69,127,2,0,128,56,197,221,255,75,0,0,3,44,
8,0,97,176,252,0,130,64,4,0,26,128,1,0,160,56,72,0,24,144,
120,219,100,127,255,255,96,56,209,231,255,75,120,195,3,127,120,219,101,127,
4,0,128,56,145,221,255,75,0,0,3,44,8,0,97,176,200,0,130,64,
4,0,155,129,0,18,160,56,80,0,152,145,120,227,131,127,0,0,128,56,
37,155,254,75,1,0,0,56,52,1,28,176,253,15,160,56,48,1,188,176,
20,0,192,56,54,1,220,176,1,48,224,56,50,1,252,176,4,0,28,144,
12,0,32,57,57,1,60,153,31,0,64,57,61,1,92,153,59,1,60,155,
120,203,35,127,73,197,0,72,0,184,3,56,68,1,28,144,120,227,131,127,
97,207,255,75,120,195,3,127,120,227,133,127,8,0,128,56,13,221,255,75,
0,0,3,44,8,0,97,176,68,0,130,64,4,0,220,128,1,0,224,56,
76,0,216,144,120,195,3,127,92,2,248,152,153,225,255,75,113,14,222,127,
1,0,57,59,48,254,130,64,8,0,129,169,0,0,12,44,20,0,130,64,
120,235,163,127,15,0,128,56,181,223,255,75,8,0,97,176,120,211,67,127,
125,234,4,72,120,219,99,127,117,234,4,72,120,227,131,127,109,234,4,72,
8,0,225,171,8,0,97,56,2,0,128,56,85,202,255,75,20,0,97,56,
2,0,128,56,177,202,255,75,64,0,129,131,52,0,33,131,56,0,65,131,
68,0,161,131,120,251,227,127,76,0,225,131,60,0,97,131,72,0,193,131,
84,0,1,128,48,0,1,131,44,0,225,130,166,3,8,124,80,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,0,0,3,44,
24,0,130,64,12,0,1,128,8,0,33,56,166,3,8,124,10,1,96,56,
32,0,128,78,129,234,255,75,125,252,255,75,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,196,230,255,75,168,255,33,148,52,0,225,146,
56,0,1,147,60,0,33,147,64,0,65,147,68,0,97,147,80,0,193,147,
84,0,225,147,0,0,224,59,12,0,225,179,166,2,8,124,92,0,1,144,
11,0,0,60,176,23,0,48,16,0,1,144,76,0,161,147,120,27,125,124,
20,0,161,147,24,0,161,147,28,0,1,144,40,0,97,56,72,0,129,147,
120,35,156,124,71,132,130,56,117,145,4,72,28,0,129,128,24,0,161,128,
11,0,96,60,40,0,193,56,140,23,99,56,57,253,4,72,9,0,97,56,
120,251,228,127,161,204,255,75,0,0,192,63,68,71,126,56,120,251,228,127,
13,120,8,72,16,0,29,40,52,0,106,124,126,217,75,85,8,0,97,153,
28,0,128,64,58,16,166,87,20,234,134,125,56,24,140,85,0,0,12,61,
96,66,232,56,8,0,231,131,0,0,31,44,11,0,160,63,152,0,130,64,
0,0,11,44,10,1,0,56,12,0,1,176,44,0,130,65,0,0,32,57,
8,0,33,153,68,71,126,56,57,116,8,72,0,0,3,44,20,0,130,65,
92,19,125,56,6,1,128,56,0,0,160,56,209,157,254,75,9,0,97,56,
2,0,128,56,201,203,255,75,24,0,97,56,2,0,128,56,21,201,255,75,
12,0,97,56,2,0,128,56,161,200,255,75,64,0,65,131,80,0,193,131,
76,0,161,131,60,0,33,131,68,0,97,131,84,0,225,131,72,0,129,131,
56,0,1,131,92,0,1,128,52,0,225,130,10,1,96,56,166,3,8,124,
88,0,33,56,32,0,128,78,9,0,97,56,8,0,129,56,33,219,255,75,
120,251,227,127,32,0,129,56,141,227,255,75,32,0,65,129,0,0,10,44,
56,224,122,124,152,0,130,64,8,0,97,137,0,0,11,44,12,0,225,171,
44,0,130,65,0,0,128,57,8,0,129,153,68,71,126,56,125,115,8,72,
0,0,3,44,20,0,130,65,92,19,125,56,6,1,128,56,0,0,160,56,
21,157,254,75,9,0,97,56,2,0,128,56,13,203,255,75,24,0,97,56,
2,0,128,56,89,200,255,75,12,0,97,56,2,0,128,56,229,199,255,75,
72,0,129,131,60,0,33,131,64,0,65,131,76,0,161,131,120,251,227,127,
84,0,225,131,68,0,97,131,80,0,193,131,92,0,1,128,56,0,1,131,
52,0,225,130,166,3,8,124,88,0,33,56,32,0,128,78,120,211,68,127,
36,0,97,56,113,201,255,75,0,18,96,56,253,229,4,72,121,27,123,124,
24,0,130,64,11,0,96,60,192,23,99,56,180,9,128,56,0,0,160,56,
137,156,254,75,120,211,67,127,65,225,255,75,120,27,101,124,120,219,99,127,
120,251,228,127,129,225,255,75,50,1,155,168,120,211,67,127,241,218,255,75,
8,0,1,137,0,0,8,44,120,27,124,124,44,0,130,65,0,0,192,56,
8,0,193,152,68,71,126,56,149,114,8,72,0,0,3,44,20,0,130,65,
92,19,125,56,6,1,128,56,0,0,160,56,45,156,254,75,121,211,88,127,
0,0,224,59,120,251,247,127,124,0,130,65,255,7,11,87,104,0,130,65,
4,0,27,128,96,2,55,29,28,0,137,61,172,126,44,59,69,0,249,139,
0,0,31,44,8,0,128,56,76,0,25,144,8,0,130,65,16,0,128,56,
120,203,35,127,120,219,101,127,25,217,255,75,0,0,3,44,12,0,97,176,
124,0,130,64,0,0,28,44,32,0,130,65,120,203,35,127,92,0,185,56,
1,0,128,56,245,216,255,75,0,0,3,44,12,0,97,176,88,0,130,64,
127,248,24,87,1,0,247,58,140,255,130,64,12,0,97,168,0,0,3,44,
64,0,130,64,0,0,31,44,8,0,128,56,8,0,130,65,16,0,128,56,
120,211,67,127,169,219,255,75,0,0,3,44,12,0,97,176,28,0,130,64,
0,0,28,44,20,0,130,65,120,211,67,127,1,0,128,56,137,219,255,75,
12,0,97,176,120,27,127,124,120,219,99,127,77,230,4,72,36,0,97,56,
2,0,128,56,73,199,255,75,8,0,1,136,0,0,0,44,44,0,130,65,
0,0,0,56,8,0,1,152,68,71,126,56,121,113,8,72,0,0,3,44,
20,0,130,65,92,19,125,56,6,1,128,56,0,0,160,56,17,155,254,75,
9,0,97,56,2,0,128,56,9,201,255,75,24,0,97,56,2,0,128,56,
85,198,255,75,12,0,97,56,2,0,128,56,225,197,255,75,72,0,129,131,
60,0,33,131,64,0,65,131,76,0,161,131,120,251,227,127,84,0,225,131,
68,0,97,131,80,0,193,131,92,0,1,128,56,0,1,131,52,0,225,130,
166,3,8,124,88,0,33,56,32,0,128,78,144,255,33,148,56,0,65,146,
60,0,97,146,64,0,129,146,68,0,161,146,76,0,225,146,80,0,1,147,
84,0,33,147,88,0,65,147,92,0,97,147,96,0,129,147,100,0,161,147,
104,0,193,147,0,0,192,59,12,0,193,179,166,2,8,124,116,0,1,144,
11,0,0,60,204,23,0,48,16,0,1,144,108,0,225,147,120,27,127,124,
20,0,225,147,28,0,225,147,32,0,1,144,40,0,97,56,72,0,193,146,
120,35,150,124,74,132,130,56,61,141,4,72,28,0,161,128,32,0,129,128,
11,0,96,60,40,0,193,56,216,23,99,56,1,249,4,72,9,0,97,56,
120,243,196,127,105,200,255,75,0,0,160,63,68,71,125,56,120,243,196,127,
213,115,8,72,16,0,31,40,52,0,106,124,126,217,75,85,8,0,97,153,
28,0,128,64,58,16,236,87,20,250,12,124,56,24,0,84,248,193,13,57,
20,2,168,124,8,0,197,131,0,0,30,44,11,0,128,63,172,0,130,64,
0,0,11,44,10,1,0,57,12,0,1,177,44,0,130,65,0,0,32,57,
8,0,33,153,68,71,125,56,1,112,8,72,0,0,3,44,20,0,130,65,
92,19,124,56,6,1,128,56,0,0,160,56,153,153,254,75,9,0,97,56,
2,0,128,56,145,199,255,75,28,0,97,56,2,0,128,56,221,196,255,75,
12,0,97,56,2,0,128,56,105,196,255,75,72,0,193,130,96,0,129,131,
100,0,161,131,76,0,225,130,68,0,161,130,92,0,97,131,104,0,193,131,
80,0,1,131,64,0,129,130,88,0,65,131,108,0,225,131,84,0,33,131,
60,0,97,130,116,0,1,128,56,0,65,130,10,1,96,56,166,3,8,124,
112,0,33,56,32,0,128,78,11,0,224,62,9,0,97,56,8,0,129,56,
209,214,255,75,120,243,195,127,36,0,129,56,61,223,255,75,120,27,117,124,
120,171,164,126,24,0,97,56,193,197,255,75,0,6,96,56,77,226,4,72,
121,27,122,124,20,0,130,64,252,23,119,56,236,8,128,56,0,0,160,56,
221,152,254,75,120,211,67,127,0,0,128,56,0,6,160,56,189,147,254,75,
120,251,227,127,48,0,154,56,209,35,8,72,0,0,3,44,12,0,97,176,
192,0,130,65,120,27,127,124,120,211,67,127,165,227,4,72,24,0,97,56,
2,0,128,56,161,196,255,75,8,0,97,137,0,0,11,44,44,0,130,65,
0,0,64,57,8,0,65,153,68,71,125,56,209,110,8,72,0,0,3,44,
20,0,130,65,92,19,124,56,6,1,128,56,0,0,160,56,105,152,254,75,
9,0,97,56,2,0,128,56,97,198,255,75,28,0,97,56,2,0,128,56,
173,195,255,75,12,0,97,56,2,0,128,56,57,195,255,75,92,0,97,131,
72,0,193,130,68,0,161,130,88,0,65,131,96,0,129,131,76,0,225,130,
64,0,129,130,84,0,33,131,100,0,161,131,120,251,227,127,108,0,225,131,
80,0,1,131,104,0,193,131,116,0,1,128,60,0,97,130,56,0,65,130,
166,3,8,124,112,0,33,56,32,0,128,78,120,243,195,127,24,3,154,56,
249,243,255,75,120,171,163,126,5,220,255,75,21,0,96,57,10,0,122,177,
88,1,0,56,12,0,26,176,144,1,0,56,14,0,26,176,4,0,122,144,
120,211,67,127,0,6,154,56,201,198,255,75,0,0,122,144,0,6,96,56,
9,225,4,72,121,27,123,124,20,0,130,64,252,23,119,56,254,8,128,56,
0,0,160,56,153,151,254,75,120,219,99,127,0,0,128,56,0,6,160,56,
121,146,254,75,48,0,123,56,24,3,154,56,88,1,160,56,253,20,5,72,
24,3,123,56,24,3,154,56,88,1,160,56,237,20,5,72,4,0,218,128,
144,1,0,56,88,1,0,57,21,0,224,56,1,0,166,56,0,6,155,56,
120,219,99,127,4,0,187,144,10,0,251,176,12,0,27,177,14,0,27,176,
69,198,255,75,0,0,123,144,0,18,96,56,133,224,4,72,121,27,120,124,
20,0,130,64,252,23,119,56,10,9,128,56,0,0,160,56,21,151,254,75,
120,171,163,126,205,219,255,75,120,27,101,124,120,195,3,127,120,243,196,127,
13,220,255,75,0,2,96,56,77,224,4,72,121,27,121,124,20,0,130,64,
252,23,119,56,15,9,128,56,0,0,160,56,221,150,254,75,120,171,163,126,
69,219,255,75,255,255,163,56,120,251,227,127,120,203,36,127,45,222,255,75,
8,0,1,136,0,0,0,44,44,0,130,65,0,0,128,57,8,0,129,153,
68,71,125,56,249,108,8,72,0,0,3,44,20,0,130,65,92,19,124,56,
6,1,128,56,0,0,160,56,145,150,254,75,36,0,129,129,0,0,12,44,
0,0,224,59,16,0,130,65,120,176,163,126,161,225,255,75,116,7,127,124,
28,0,224,62,121,179,212,126,172,126,247,58,0,0,64,58,60,0,130,65,
255,7,133,86,40,0,130,65,96,2,114,30,20,154,119,124,101,210,255,75,
0,0,3,44,12,0,97,176,28,0,130,64,20,154,119,124,120,251,228,127,
45,205,255,75,113,14,148,126,1,0,82,58,204,255,130,64,50,1,152,168,
120,179,163,126,169,212,255,75,36,0,1,128,0,0,0,44,12,0,97,168,
68,0,130,64,120,27,127,124,120,203,35,127,253,224,4,72,120,195,3,127,
245,224,4,72,120,219,99,127,237,224,4,72,120,211,67,127,229,224,4,72,
24,0,97,56,2,0,128,56,225,193,255,75,8,0,225,136,0,0,7,44,
76,0,130,64,112,0,0,72,0,0,3,44,216,0,130,65,120,27,127,124,
120,203,35,127,181,224,4,72,120,195,3,127,173,224,4,72,120,219,99,127,
165,224,4,72,120,211,67,127,157,224,4,72,24,0,97,56,2,0,128,56,
153,193,255,75,8,0,225,136,0,0,7,44,44,0,130,65,0,0,0,57,
8,0,1,153,68,71,125,56,201,107,8,72,0,0,3,44,20,0,130,65,
92,19,124,56,6,1,128,56,0,0,160,56,97,149,254,75,9,0,97,56,
2,0,128,56,89,195,255,75,28,0,97,56,2,0,128,56,165,192,255,75,
12,0,97,56,2,0,128,56,49,192,255,75,92,0,97,131,72,0,193,130,
68,0,161,130,88,0,65,131,96,0,129,131,76,0,225,130,64,0,129,130,
84,0,33,131,100,0,161,131,120,251,227,127,108,0,225,131,80,0,1,131,
104,0,193,131,116,0,1,128,60,0,97,130,56,0,65,130,166,3,8,124,
112,0,33,56,32,0,128,78,120,179,195,126,120,219,100,127,120,203,37,127,
120,195,6,127,169,215,255,75,0,0,3,44,12,0,97,176,216,0,130,65,
120,27,127,124,120,203,35,127,193,223,4,72,120,195,3,127,185,223,4,72,
120,219,99,127,177,223,4,72,120,211,67,127,169,223,4,72,24,0,97,56,
2,0,128,56,165,192,255,75,8,0,33,137,0,0,9,44,44,0,130,65,
0,0,64,57,8,0,65,153,68,71,125,56,213,106,8,72,0,0,3,44,
20,0,130,65,92,19,124,56,6,1,128,56,0,0,160,56,109,148,254,75,
9,0,97,56,2,0,128,56,101,194,255,75,28,0,97,56,2,0,128,56,
177,191,255,75,12,0,97,56,2,0,128,56,61,191,255,75,92,0,97,131,
72,0,193,130,68,0,161,130,88,0,65,131,96,0,129,131,76,0,225,130,
64,0,129,130,84,0,33,131,100,0,161,131,120,251,227,127,108,0,225,131,
80,0,1,131,104,0,193,131,116,0,1,128,60,0,97,130,56,0,65,130,
166,3,8,124,112,0,33,56,32,0,128,78,121,176,182,126,120,179,213,126,
0,0,128,58,68,0,130,65,255,7,160,86,48,0,130,65,96,2,244,31,
20,250,119,124,120,211,69,127,2,0,128,56,9,209,255,75,0,0,3,44,
12,0,97,176,60,0,130,64,4,0,58,129,20,250,247,124,72,0,39,145,
127,248,181,86,1,0,148,58,196,255,130,64,0,0,3,44,28,0,130,64,
120,179,195,126,2,0,128,56,193,211,255,75,0,0,3,44,12,0,97,176,
216,0,130,65,120,27,127,124,120,203,35,127,125,222,4,72,120,195,3,127,
117,222,4,72,120,219,99,127,109,222,4,72,120,211,67,127,101,222,4,72,
24,0,97,56,2,0,128,56,97,191,255,75,8,0,97,137,0,0,11,44,
44,0,130,65,0,0,128,57,8,0,129,153,68,71,125,56,145,105,8,72,
0,0,3,44,20,0,130,65,92,19,124,56,6,1,128,56,0,0,160,56,
41,147,254,75,9,0,97,56,2,0,128,56,33,193,255,75,28,0,97,56,
2,0,128,56,109,190,255,75,12,0,97,56,2,0,128,56,249,189,255,75,
92,0,97,131,72,0,193,130,68,0,161,130,88,0,65,131,96,0,129,131,
76,0,225,130,64,0,129,130,84,0,33,131,100,0,161,131,120,251,227,127,
108,0,225,131,80,0,1,131,104,0,193,131,116,0,1,128,60,0,97,130,
56,0,65,130,166,3,8,124,112,0,33,56,32,0,128,78,120,179,195,126,
120,219,100,127,120,203,37,127,120,195,6,127,113,213,255,75,0,0,3,44,
12,0,97,176,216,0,130,65,120,27,127,124,120,203,35,127,137,221,4,72,
120,195,3,127,129,221,4,72,120,219,99,127,121,221,4,72,120,211,67,127,
113,221,4,72,24,0,97,56,2,0,128,56,109,190,255,75,8,0,1,136,
0,0,0,44,44,0,130,65,0,0,160,56,8,0,161,152,68,71,125,56,
157,104,8,72,0,0,3,44,20,0,130,65,92,19,124,56,6,1,128,56,
0,0,160,56,53,146,254,75,9,0,97,56,2,0,128,56,45,192,255,75,
28,0,97,56,2,0,128,56,121,189,255,75,12,0,97,56,2,0,128,56,
5,189,255,75,92,0,97,131,72,0,193,130,68,0,161,130,88,0,65,131,
96,0,129,131,76,0,225,130,64,0,129,130,84,0,33,131,100,0,161,131,
120,251,227,127,108,0,225,131,80,0,1,131,104,0,193,131,116,0,1,128,
60,0,97,130,56,0,65,130,166,3,8,124,112,0,33,56,32,0,128,78,
120,243,195,127,48,0,155,56,65,84,8,72,12,0,225,171,120,203,35,127,
169,220,4,72,120,195,3,127,161,220,4,72,120,219,99,127,153,220,4,72,
120,211,67,127,145,220,4,72,24,0,97,56,2,0,128,56,141,189,255,75,
8,0,193,136,0,0,6,44,44,0,130,65,0,0,0,56,8,0,1,152,
68,71,125,56,189,103,8,72,0,0,3,44,20,0,130,65,92,19,124,56,
6,1,128,56,0,0,160,56,85,145,254,75,9,0,97,56,2,0,128,56,
77,191,255,75,28,0,97,56,2,0,128,56,153,188,255,75,12,0,97,56,
2,0,128,56,37,188,255,75,92,0,97,131,72,0,193,130,68,0,161,130,
88,0,65,131,96,0,129,131,76,0,225,130,64,0,129,130,84,0,33,131,
100,0,161,131,120,251,227,127,108,0,225,131,80,0,1,131,104,0,193,131,
116,0,1,128,60,0,97,130,56,0,65,130,166,3,8,124,112,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,0,0,158,137,117,7,140,125,120,35,159,124,
24,0,130,65,11,0,96,60,8,24,99,56,104,10,128,56,0,0,160,56,
169,144,254,75,120,251,227,127,237,220,255,75,197,219,255,75,120,27,127,124,
3,0,126,136,116,7,99,124,225,181,0,72,76,0,31,40,24,0,130,64,
0,248,99,57,12,0,126,145,0,4,0,56,8,0,30,144,20,0,0,72,
0,184,99,57,12,0,126,145,0,0,0,56,8,0,30,144,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
168,255,33,148,56,0,1,147,60,0,33,147,68,0,97,147,72,0,129,147,
76,0,161,147,84,0,225,147,166,2,8,124,92,0,1,144,64,0,65,147,
120,27,122,124,24,0,65,147,80,0,193,147,11,0,192,63,56,24,222,59,
28,0,193,147,40,0,97,56,77,132,130,56,253,130,4,72,28,0,129,128,
24,0,161,128,11,0,96,60,40,0,193,56,20,24,99,56,193,238,4,72,
0,0,224,59,12,0,225,179,16,0,193,147,20,0,65,147,8,0,97,56,
121,190,255,75,16,0,26,40,28,0,128,64,58,16,74,87,20,210,10,124,
56,24,0,84,248,193,141,57,20,2,108,125,8,0,235,131,0,0,31,44,
92,0,130,64,8,0,97,56,2,0,128,56,157,189,255,75,12,0,97,56,
2,0,128,56,129,186,255,75,24,0,97,56,2,0,128,56,221,186,255,75,
80,0,193,131,68,0,97,131,64,0,65,131,76,0,161,131,84,0,225,131,
72,0,129,131,60,0,33,131,92,0,1,128,56,0,1,131,10,1,96,56,
166,3,8,124,88,0,33,56,32,0,128,78,120,251,227,127,32,0,129,56,
113,213,255,75,120,27,121,124,120,203,36,127,36,0,97,56,245,187,255,75,
121,203,61,127,0,0,128,59,108,0,130,65,255,7,160,87,88,0,130,65,
96,2,28,31,28,0,96,63,172,126,123,59,20,194,123,124,33,203,255,75,
121,27,126,124,12,0,193,179,72,0,130,64,20,194,123,124,78,0,128,56,
233,197,255,75,32,0,1,128,0,0,0,44,24,0,130,64,20,194,123,124,
109,200,255,75,121,27,126,124,12,0,193,179,28,0,130,64,20,194,123,124,
177,208,255,75,127,248,189,87,1,0,156,59,156,255,130,64,12,0,193,171,
32,0,1,128,0,0,0,44,12,0,130,65,0,0,30,44,104,0,130,65,
36,0,97,56,2,0,128,56,157,186,255,75,8,0,97,56,2,0,128,56,
145,188,255,75,12,0,97,56,2,0,128,56,117,185,255,75,24,0,97,56,
2,0,128,56,209,185,255,75,120,243,195,127,80,0,193,131,76,0,161,131,
72,0,129,131,64,0,65,131,68,0,97,131,84,0,225,131,92,0,1,128,
60,0,33,131,56,0,1,131,166,3,8,124,88,0,33,56,32,0,128,78,
11,0,192,63,0,6,96,56,141,215,4,72,121,27,123,124,20,0,130,64,
68,24,126,56,71,8,128,56,0,0,160,56,29,142,254,75,120,219,99,127,
0,0,128,56,0,6,160,56,253,136,254,75,16,0,26,40,48,0,155,56,
120,0,128,64,120,211,67,127,9,25,8,72,24,3,123,56,48,0,155,56,
88,1,160,56,109,11,5,72,1,32,0,57,8,0,27,177,1,0,32,57,
4,0,59,145,21,0,96,57,10,0,123,177,88,1,128,57,12,0,155,177,
144,1,0,56,14,0,27,176,120,219,99,127,0,6,155,56,193,188,255,75,
0,0,123,144,0,18,96,56,1,215,4,72,120,27,124,124,0,2,96,56,
245,214,4,72,0,0,28,44,120,27,125,124,120,0,130,65,132,0,0,72,
120,251,227,127,145,233,255,75,24,3,123,56,48,0,155,56,88,1,160,56,
249,10,5,72,1,32,0,57,8,0,27,177,1,0,32,57,4,0,59,145,
21,0,96,57,10,0,123,177,88,1,128,57,12,0,155,177,144,1,0,56,
14,0,27,176,120,219,99,127,0,6,155,56,77,188,255,75,0,0,123,144,
0,18,96,56,141,214,4,72,120,27,124,124,0,2,96,56,129,214,4,72,
0,0,28,44,120,27,125,124,20,0,130,64,68,24,126,56,98,8,128,56,
0,0,160,56,13,141,254,75,0,0,29,44,20,0,130,64,68,24,126,56,
99,8,128,56,0,0,160,56,245,140,254,75,120,227,131,127,120,251,228,127,
1,0,160,56,245,209,255,75,50,1,156,168,120,203,35,127,101,203,255,75,
120,211,67,127,0,0,128,56,169,101,3,72,120,211,67,127,120,235,164,127,
1,0,160,56,37,212,255,75,120,203,35,127,120,219,100,127,120,235,165,127,
120,227,134,127,117,207,255,75,12,0,97,176,120,27,126,124,120,235,163,127,
149,215,4,72,120,227,131,127,141,215,4,72,120,219,99,127,133,215,4,72,
36,0,97,56,2,0,128,56,129,184,255,75,8,0,97,56,2,0,128,56,
117,186,255,75,12,0,97,56,2,0,128,56,89,183,255,75,24,0,97,56,
2,0,128,56,181,183,255,75,76,0,161,131,120,243,195,127,80,0,193,131,
56,0,1,131,68,0,97,131,64,0,65,131,84,0,225,131,92,0,1,128,
72,0,129,131,60,0,33,131,166,3,8,124,88,0,33,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,9,128,13,136,116,7,0,124,
54,32,3,84,81,95,5,72,156,134,109,144,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,29,0,96,60,172,4,99,56,11,0,128,60,104,24,132,56,
189,150,4,72,0,0,3,44,24,0,130,65,11,0,96,60,124,24,99,56,
158,2,128,56,0,0,160,56,181,139,254,75,29,0,96,60,204,4,99,56,
11,0,128,60,80,24,132,56,1,0,160,56,193,23,3,72,9,128,13,136,
116,7,0,124,0,0,224,59,0,0,31,124,56,0,128,64,96,2,63,29,
156,134,141,129,36,104,235,87,120,251,228,127,28,0,73,61,20,90,172,124,
172,126,106,56,129,192,255,75,9,128,13,136,116,7,0,124,1,0,255,59,
0,0,31,124,208,255,128,65,20,0,1,128,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,40,214,4,72,166,2,8,124,4,0,1,144,248,255,33,148,
0,0,3,44,20,0,130,64,6,0,96,56,105,212,4,72,0,0,3,44,
12,0,130,65,0,0,0,56,0,0,3,176,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,121,27,127,124,
166,2,8,124,20,0,1,144,20,0,130,64,96,2,96,56,41,212,4,72,
121,27,127,124,36,0,130,65,2,0,192,60,84,252,198,56,0,0,0,56,
44,0,31,152,122,0,127,56,6,0,160,56,40,0,128,56,169,211,4,72,
20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,0,0,3,44,32,0,130,77,255,7,128,84,32,0,130,77,
120,213,4,72,240,255,33,148,8,0,193,147,12,0,225,147,166,2,8,124,
20,0,1,144,2,0,3,160,20,2,227,127,11,0,96,60,120,25,99,56,
49,233,4,72,101,74,4,72,205,234,5,72,166,0,192,127,94,4,192,87,
36,1,0,124,166,3,233,127,33,4,128,78,120,27,127,124,0,128,203,115,
166,0,0,124,94,4,0,84,120,91,0,124,36,1,0,124,157,234,5,72,
0,0,31,44,44,0,130,65,120,251,228,127,11,0,96,60,104,25,99,56,
225,232,4,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,11,0,96,60,156,25,99,56,189,232,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,144,128,141,137,0,0,12,44,248,255,130,65,143,128,109,136,
0,0,0,56,144,128,13,152,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,217,255,255,75,0,0,3,44,248,255,128,64,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,0,0,4,44,120,27,108,124,
0,0,96,56,32,0,129,76,11,0,32,61,112,32,41,57,166,3,137,124,
255,255,140,57,1,0,12,141,112,70,106,124,120,66,64,125,252,13,11,84,
46,74,11,124,46,64,104,84,120,2,3,125,62,4,99,84,224,255,0,66,
32,0,128,78,184,251,33,148,16,4,65,146,28,4,161,146,32,4,193,146,
36,4,225,146,40,4,1,147,52,4,97,147,56,4,129,147,166,2,8,124,
76,4,1,144,20,4,97,146,120,27,115,124,24,4,129,146,120,35,148,124,
44,4,33,147,1,0,32,59,68,4,225,147,0,0,224,59,48,4,65,147,
25,0,64,59,60,4,161,147,16,0,160,59,64,4,193,147,49,1,192,63,
0,45,222,59,120,243,195,127,185,124,4,72,67,0,96,56,217,232,5,72,
1,255,255,75,63,6,99,84,192,0,130,65,1,0,3,44,52,0,130,64,
0,0,128,59,128,0,192,58,214,179,180,127,0,232,28,124,132,0,224,58,
8,0,97,59,9,0,193,59,140,0,65,58,139,0,1,59,11,0,161,58,
216,2,128,64,192,0,0,72,2,0,3,44,52,0,130,64,0,0,128,59,
0,4,192,58,214,179,180,127,0,232,28,124,4,4,224,58,8,0,97,59,
9,0,193,59,12,4,65,58,11,4,1,59,11,0,161,58,160,2,128,64,
136,0,0,72,32,4,193,130,56,4,129,131,60,4,161,131,36,4,225,130,
28,4,161,130,52,4,97,131,64,4,193,131,40,4,1,131,24,4,129,130,
48,4,65,131,68,4,225,131,44,4,33,131,20,4,97,130,76,4,1,128,
16,4,65,130,254,255,96,56,166,3,8,124,72,4,33,56,32,0,128,78,
255,255,189,55,36,255,130,64,0,0,128,59,214,179,180,127,0,232,28,124,
9,0,193,59,20,178,30,125,3,0,72,58,2,0,190,58,4,0,246,58,
8,0,97,59,20,218,55,125,255,255,9,59,24,2,128,64,121,187,231,126,
120,243,197,127,0,0,123,152,24,0,129,64,255,255,165,56,237,253,255,75,
255,255,231,52,1,0,101,156,244,255,130,64,0,0,254,136,255,255,21,136,
248,0,0,124,62,6,0,84,64,0,7,124,248,0,130,64,64,200,7,124,
16,0,130,65,255,255,25,56,64,0,7,124,228,0,130,64,120,171,163,126,
120,179,196,126,237,253,255,75,0,0,152,137,0,0,18,136,46,64,134,85,
20,2,6,124,62,4,0,84,64,0,3,124,188,0,130,64,64,200,7,124,
60,0,130,64,80,160,95,127,0,176,26,124,8,0,129,64,120,179,218,126,
0,0,26,44,24,0,129,64,20,250,115,124,120,171,164,126,120,211,69,127,
165,4,5,72,20,210,255,127,1,0,57,59,62,6,57,87,26,0,64,59,
255,255,90,55,108,0,129,65,93,253,255,75,24,0,96,56,13,231,5,72,
24,0,96,56,5,231,5,72,24,0,96,56,253,230,5,72,32,4,193,130,
56,4,129,131,60,4,161,131,36,4,225,130,28,4,161,130,52,4,97,131,
64,4,193,131,40,4,1,131,24,4,129,130,48,4,65,131,68,4,225,131,
44,4,33,131,20,4,97,130,76,4,1,128,16,4,65,130,253,255,96,56,
166,3,8,124,72,4,33,56,32,0,128,78,6,0,96,56,169,230,5,72,
209,252,255,75,63,6,99,84,208,0,130,65,4,0,3,44,88,0,130,64,
6,0,96,56,141,230,5,72,52,4,97,131,32,4,193,130,28,4,161,130,
48,4,65,131,56,4,129,131,36,4,225,130,24,4,129,130,44,4,33,131,
60,4,161,131,120,251,227,127,68,4,225,131,40,4,1,131,64,4,193,131,
76,4,1,128,20,4,97,130,16,4,65,130,166,3,8,124,72,4,33,56,
32,0,128,78,24,0,3,44,108,0,130,64,97,252,255,75,62,6,99,84,
24,0,3,44,92,0,130,64,109,252,255,75,6,0,96,56,29,230,5,72,
32,4,193,130,56,4,129,131,60,4,161,131,36,4,225,130,28,4,161,130,
52,4,97,131,64,4,193,131,40,4,1,131,24,4,129,130,48,4,65,131,
68,4,225,131,44,4,33,131,20,4,97,130,76,4,1,128,16,4,65,130,
255,255,96,56,166,3,8,124,72,4,33,56,32,0,128,78,1,0,156,59,
0,232,28,124,240,253,128,65,32,4,193,130,56,4,129,131,60,4,161,131,
36,4,225,130,28,4,161,130,52,4,97,131,64,4,193,131,40,4,1,131,
24,4,129,130,48,4,65,131,68,4,225,131,44,4,33,131,20,4,97,130,
76,4,1,128,16,4,65,130,0,0,96,56,166,3,8,124,72,4,33,56,
32,0,128,78,176,251,33,148,44,4,225,146,48,4,1,147,52,4,33,147,
56,4,65,147,60,4,97,147,76,4,225,147,12,0,97,144,64,4,129,147,
1,0,128,59,72,4,193,147,68,4,161,147,0,0,160,59,120,235,190,127,
166,2,8,124,84,4,1,144,8,0,4,56,8,0,1,144,89,251,255,75,
0,0,3,44,248,255,128,65,67,0,3,44,52,0,130,64,8,0,1,128,
80,0,93,127,0,4,26,44,2,0,128,57,17,0,129,155,1,0,96,59,
120,219,126,127,248,224,128,127,16,0,129,153,18,0,1,152,4,1,129,64,
224,0,0,72,21,0,3,44,48,0,130,64,8,0,1,128,80,0,93,127,
0,4,26,44,2,0,128,57,17,0,129,155,0,0,96,59,248,224,128,127,
16,0,129,153,18,0,1,152,208,0,129,64,172,0,0,72,24,0,3,44,
132,255,130,64,217,250,255,75,24,0,3,44,72,0,130,64,6,0,96,56,
157,228,5,72,225,250,255,75,56,4,65,131,72,4,193,131,68,4,161,131,
52,4,33,131,60,4,97,131,76,4,225,131,64,4,129,131,48,4,1,131,
84,4,1,128,44,4,225,130,255,255,96,56,166,3,8,124,80,4,33,56,
32,0,128,78,24,0,96,56,89,228,5,72,24,0,96,56,81,228,5,72,
24,0,96,56,73,228,5,72,56,4,65,131,72,4,193,131,68,4,161,131,
52,4,33,131,60,4,97,131,76,4,225,131,64,4,129,131,48,4,1,131,
84,4,1,128,44,4,225,130,254,255,96,56,166,3,8,124,80,4,33,56,
32,0,128,78,16,0,33,59,19,0,225,59,120,251,227,127,0,0,128,56,
0,4,64,59,120,211,69,127,213,126,254,75,64,0,0,72,0,0,26,44,
248,1,128,65,16,0,33,59,19,0,225,59,120,251,227,127,0,0,128,56,
0,4,160,56,177,126,254,75,0,0,26,44,24,0,130,64,0,0,27,44,
26,0,0,56,3,0,25,152,180,0,130,65,128,0,0,72,0,0,30,44,
72,0,130,65,120,251,227,127,12,0,129,56,4,0,160,56,17,1,5,72,
23,0,97,56,8,0,129,56,4,0,160,56,1,1,5,72,12,0,65,129,
27,0,97,56,20,234,138,124,248,255,186,56,0,0,192,59,233,0,5,72,
0,4,26,44,48,0,128,64,36,0,0,72,12,0,129,129,120,211,69,127,
248,255,29,56,120,251,227,127,20,2,140,124,197,0,5,72,0,4,26,44,
12,0,128,64,26,0,160,56,174,209,191,124,0,0,27,44,52,0,130,65,
120,251,227,127,0,4,128,56,157,249,255,75,62,198,107,84,19,4,97,153,
20,4,97,152,16,0,225,58,255,255,27,48,16,217,32,125,4,4,9,59,
25,0,64,59,60,0,0,72,0,0,192,56,255,255,159,57,0,4,0,56,
166,3,9,124,1,0,236,140,20,58,198,124,62,6,198,84,244,255,0,66,
19,4,193,152,16,0,225,58,255,255,27,48,16,217,32,125,4,4,9,59,
25,0,64,59,121,195,25,127,28,0,129,64,255,255,247,59,1,0,127,140,
116,7,99,124,185,226,5,72,255,255,57,55,240,255,130,64,217,248,255,75,
0,0,3,44,88,0,128,65,6,0,3,40,16,0,130,65,24,0,3,40,
60,0,130,65,68,0,0,72,8,0,1,128,0,4,189,59,80,0,93,127,
0,4,26,44,2,0,128,57,1,0,156,59,16,0,129,153,62,6,156,87,
17,0,129,155,248,224,128,127,18,0,1,152,116,254,129,64,80,254,255,75,
133,248,255,75,24,0,3,44,176,253,130,65,255,255,90,55,124,255,130,64,
24,0,96,56,65,226,5,72,24,0,96,56,57,226,5,72,24,0,96,56,
49,226,5,72,117,248,255,75,56,4,65,131,72,4,193,131,68,4,161,131,
52,4,33,131,60,4,97,131,76,4,225,131,64,4,129,131,48,4,1,131,
84,4,1,128,44,4,225,130,252,255,96,56,166,3,8,124,80,4,33,56,
32,0,128,78,10,0,224,59,4,0,96,56,233,225,5,72,17,248,255,75,
6,0,3,44,12,0,130,65,255,255,255,55,232,255,130,64,68,4,161,131,
52,4,33,131,56,4,65,131,72,4,193,131,64,4,129,131,48,4,1,131,
60,4,97,131,76,4,225,131,84,4,1,128,44,4,225,130,8,0,97,128,
166,3,8,124,80,4,33,56,32,0,128,78,224,255,33,148,3,0,3,44,
12,0,97,147,16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,120,35,159,124,52,0,130,65,11,0,96,60,
176,35,99,56,49,224,4,72,20,0,161,131,24,0,193,131,28,0,225,131,
36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,
32,0,128,78,4,0,127,128,0,0,128,56,16,0,160,56,36,0,192,63,
224,156,222,59,129,247,4,72,120,27,125,124,8,0,127,128,0,0,128,56,
16,0,160,56,109,247,4,72,1,0,0,56,142,128,13,152,120,27,124,124,
11,0,96,60,240,35,99,56,201,223,4,72,120,243,195,127,37,156,4,72,
166,0,224,127,94,4,224,87,36,1,0,124,134,50,130,124,120,35,131,124,
119,7,123,84,120,219,101,127,134,51,162,124,0,128,234,115,166,0,96,125,
94,4,107,85,120,83,107,125,36,1,96,125,166,0,224,127,94,4,224,87,
36,1,0,124,134,50,130,124,120,35,131,124,185,7,123,84,120,219,101,127,
134,51,162,124,0,128,224,115,166,0,32,125,94,4,41,85,120,3,41,125,
36,1,32,125,166,0,224,127,94,4,224,87,36,1,0,124,134,50,130,124,
120,35,131,124,243,6,123,84,120,219,101,127,134,51,162,124,0,128,235,115,
166,0,128,125,94,4,140,85,120,91,140,125,36,1,128,125,166,0,224,127,
94,4,224,87,36,1,0,124,134,50,130,124,120,35,131,124,53,7,123,84,
120,219,101,127,134,51,162,124,0,128,233,115,166,0,64,125,94,4,74,85,
120,75,74,125,36,1,64,125,166,0,224,127,94,4,224,87,36,1,0,124,
134,50,130,124,120,35,131,124,251,7,123,84,120,219,101,127,134,51,162,124,
0,128,236,115,166,0,0,124,94,4,0,84,120,99,0,124,36,1,0,124,
166,0,224,127,94,4,224,87,36,1,0,124,134,50,130,124,120,35,131,124,
137,1,123,84,120,219,101,127,134,51,162,124,0,128,234,115,166,0,96,125,
94,4,107,85,120,83,107,125,36,1,96,125,166,0,224,127,94,4,224,87,
36,1,0,124,134,50,130,124,120,35,131,124,79,2,123,84,120,219,101,127,
134,51,162,124,0,128,224,115,166,0,128,125,94,4,140,85,120,3,140,125,
36,1,128,125,166,0,224,127,94,4,224,87,36,1,0,124,134,50,130,124,
120,35,131,124,195,0,123,84,120,219,101,127,134,51,162,124,0,128,233,115,
166,0,64,125,94,4,74,85,120,75,74,125,36,1,64,125,166,0,224,127,
94,4,224,87,36,1,0,124,134,50,130,124,120,35,131,124,177,6,123,84,
120,219,101,127,134,51,162,124,0,128,236,115,166,0,0,124,94,4,0,84,
120,99,0,124,36,1,0,124,120,235,163,127,120,227,132,127,205,245,255,75,
120,27,127,124,120,243,195,127,65,155,4,72,0,0,32,57,142,128,45,153,
166,0,192,127,94,4,192,87,36,1,0,124,134,50,130,124,120,35,131,124,
128,0,124,100,120,227,133,127,134,51,162,124,0,128,203,115,166,0,128,125,
94,4,140,85,120,91,140,125,36,1,128,125,0,0,31,44,120,251,228,127,
20,0,128,64,11,0,96,60,208,35,99,56,129,221,4,72,44,0,0,72,
11,0,96,60,136,35,99,56,113,221,4,72,120,235,163,127,21,244,255,75,
2,0,96,56,185,109,255,75,0,0,0,56,125,134,13,152,29,223,5,72,
166,0,224,127,94,4,224,87,36,1,0,124,134,50,130,124,120,35,131,124,
8,0,126,96,120,243,197,127,134,51,162,124,0,128,234,115,166,0,96,125,
94,4,107,85,120,83,107,125,36,1,96,125,166,0,224,127,94,4,224,87,
36,1,0,124,134,50,130,124,120,35,131,124,4,0,126,96,120,243,197,127,
134,51,162,124,0,128,224,115,166,0,32,125,94,4,41,85,120,3,41,125,
36,1,32,125,166,0,224,127,94,4,224,87,36,1,0,124,134,50,130,124,
120,35,131,124,32,0,126,96,120,243,197,127,134,51,162,124,0,128,235,115,
166,0,128,125,94,4,140,85,120,91,140,125,36,1,128,125,166,0,224,127,
94,4,224,87,36,1,0,124,134,50,130,124,120,35,131,124,16,0,126,96,
120,243,197,127,134,51,162,124,0,128,224,115,166,0,64,125,94,4,74,85,
120,3,74,125,36,1,64,125,166,0,224,127,94,4,224,87,36,1,0,124,
134,50,130,124,120,35,131,124,2,0,126,96,120,243,197,127,134,51,162,124,
0,128,236,115,166,0,0,124,94,4,0,84,120,99,0,124,36,1,0,124,
166,0,224,127,94,4,224,87,36,1,0,124,134,50,130,124,120,35,131,124,
0,4,126,100,120,243,197,127,134,51,162,124,0,128,234,115,166,0,96,125,
94,4,107,85,120,83,107,125,36,1,96,125,166,0,224,127,94,4,224,87,
36,1,0,124,134,50,130,124,120,35,131,124,0,32,126,100,120,243,197,127,
134,51,162,124,0,128,224,115,166,0,32,125,94,4,41,85,120,3,41,125,
36,1,32,125,166,0,224,127,94,4,224,87,36,1,0,124,134,50,130,124,
120,35,131,124,64,0,126,96,120,243,197,127,134,51,162,124,0,128,235,115,
166,0,0,124,94,4,0,84,120,91,0,124,36,1,0,124,16,0,129,131,
24,0,193,131,28,0,225,131,12,0,97,131,36,0,1,128,20,0,161,131,
32,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,3,0,3,44,
8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,120,35,159,124,
40,0,130,65,11,0,96,60,92,36,99,56,101,219,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
4,0,127,128,0,0,128,56,16,0,160,56,201,242,4,72,120,27,126,124,
8,0,127,128,0,0,128,56,16,0,160,56,181,242,4,72,1,0,0,56,
142,128,13,152,120,27,127,124,11,0,96,60,152,36,99,56,17,219,4,72,
120,243,195,127,120,251,228,127,197,246,255,75,121,27,100,124,11,0,96,60,
52,36,99,56,12,0,128,64,11,0,96,60,120,36,99,56,233,218,4,72,
0,0,0,56,142,128,13,152,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,200,255,33,148,48,0,193,147,
52,0,225,147,166,2,8,124,60,0,1,144,0,0,100,129,11,0,128,61,
255,255,43,57,0,37,140,57,255,255,76,57,1,0,137,141,1,0,10,140,
64,0,12,124,12,0,130,64,0,0,12,40,236,255,130,64,81,96,128,125,
0,1,130,64,8,0,97,56,103,102,128,60,170,170,132,56,201,167,2,72,
8,0,97,56,61,197,2,72,0,0,3,44,128,0,130,65,0,32,224,59,
8,0,97,56,41,157,2,72,0,32,3,40,16,0,128,64,8,0,97,56,
25,157,2,72,120,27,127,124,120,251,227,127,101,198,4,72,120,27,126,124,
120,243,196,127,120,251,229,127,8,0,97,56,0,0,192,56,120,51,199,124,
105,164,2,72,0,0,32,57,20,250,126,125,255,255,43,153,11,0,224,63,
12,37,255,59,120,251,227,127,93,54,4,72,120,243,195,127,85,54,4,72,
120,251,227,127,77,54,4,72,120,243,195,127,25,198,4,72,168,0,0,72,
80,0,96,56,9,198,4,72,120,27,126,124,255,255,158,57,11,0,0,61,
219,36,8,57,17,0,32,57,166,3,41,125,1,0,72,137,1,0,76,153,
2,0,104,141,2,0,108,157,240,255,0,66,11,0,224,63,12,37,255,59,
120,251,227,127,253,53,4,72,120,243,195,127,245,53,4,72,120,251,227,127,
237,53,4,72,120,243,195,127,185,197,4,72,72,0,0,72,0,32,96,56,
169,197,4,72,120,27,126,124,0,32,128,56,209,54,4,72,0,0,0,56,
255,31,30,152,11,0,224,63,12,37,255,59,120,251,227,127,181,53,4,72,
120,243,195,127,173,53,4,72,120,251,227,127,165,53,4,72,120,243,195,127,
113,197,4,72,60,0,1,128,52,0,225,131,48,0,193,131,166,3,8,124,
56,0,33,56,32,0,128,78,216,255,33,148,1,0,3,40,16,0,65,147,
20,0,97,147,24,0,129,147,28,0,161,147,166,2,8,124,44,0,1,144,
32,0,193,147,120,35,158,124,36,0,225,147,11,0,224,63,92,46,255,59,
20,0,129,65,11,0,96,60,92,37,99,56,229,216,4,72,116,1,0,72,
11,0,160,63,212,37,189,59,10,0,128,57,8,0,97,59,0,0,64,57,
244,255,95,59,12,0,154,135,4,0,62,129,255,255,105,57,255,255,220,56,
1,0,235,140,1,0,6,140,64,0,7,124,12,0,130,64,0,0,7,40,
236,255,130,64,81,56,0,124,8,1,130,64,2,0,3,44,104,0,130,64,
8,0,122,128,120,219,100,127,4,0,160,56,0,0,91,145,169,84,3,72,
121,27,100,124,12,0,130,65,120,235,163,127,109,216,4,72,0,0,187,128,
120,227,132,127,120,43,166,124,11,0,96,60,76,37,99,56,85,216,4,72,
32,0,193,131,24,0,129,131,28,0,161,131,36,0,225,131,44,0,1,128,
20,0,97,131,16,0,65,131,166,3,8,124,40,0,33,56,32,0,128,78,
8,0,126,128,120,219,101,127,32,133,130,56,249,204,4,72,1,0,3,44,
60,0,130,65,4,0,158,128,11,0,96,60,132,37,99,56,5,216,4,72,
32,0,193,131,24,0,129,131,28,0,161,131,36,0,225,131,44,0,1,128,
20,0,97,131,16,0,65,131,166,3,8,124,40,0,33,56,32,0,128,78,
8,0,122,128,120,219,100,127,4,0,160,56,85,84,3,72,121,27,100,124,
160,0,130,65,120,235,163,127,189,215,4,72,32,0,193,131,24,0,129,131,
28,0,161,131,36,0,225,131,44,0,1,128,20,0,97,131,16,0,65,131,
166,3,8,124,40,0,33,56,32,0,128,78,255,255,140,53,200,254,130,64,
4,0,158,128,11,0,96,60,244,37,99,56,125,215,4,72,11,0,96,60,
92,37,99,56,113,215,4,72,10,0,192,59,8,0,97,59,244,255,255,59,
11,0,160,63,184,37,189,59,20,0,159,131,120,227,131,127,120,219,100,127,
4,0,160,56,117,83,3,72,12,0,159,132,4,0,255,128,0,0,187,128,
4,0,220,160,120,235,163,127,49,215,4,72,255,255,222,55,208,255,130,64,
32,0,193,131,24,0,129,131,28,0,161,131,36,0,225,131,44,0,1,128,
20,0,97,131,16,0,65,131,166,3,8,124,40,0,33,56,32,0,128,78,
144,255,33,148,9,0,3,44,64,0,129,146,68,0,161,146,72,0,193,146,
76,0,225,146,80,0,1,147,84,0,33,147,88,0,65,147,96,0,129,147,
100,0,161,147,104,0,193,147,108,0,225,147,166,2,8,124,116,0,1,144,
92,0,97,147,120,35,155,124,80,0,130,65,11,0,96,60,144,38,99,56,
173,214,4,72,80,0,1,131,100,0,161,131,96,0,129,131,76,0,225,130,
84,0,33,131,104,0,193,131,92,0,97,131,72,0,193,130,88,0,65,131,
108,0,225,131,116,0,1,128,68,0,161,130,64,0,129,130,166,3,8,124,
112,0,33,56,32,0,128,78,4,0,123,128,0,0,128,56,16,0,160,56,
233,237,4,72,120,27,119,124,8,0,123,128,0,0,128,56,16,0,160,56,
213,237,4,72,120,27,120,124,12,0,123,128,16,0,160,56,0,0,128,56,
193,237,4,72,120,27,124,124,16,0,123,128,16,0,160,56,0,0,128,56,
173,237,4,72,120,27,126,124,20,0,123,128,0,0,128,56,16,0,160,56,
153,237,4,72,120,27,125,124,24,0,123,128,0,0,128,56,16,0,160,56,
133,237,4,72,120,27,127,124,28,0,123,128,16,0,160,56,0,0,128,56,
113,237,4,72,120,27,122,124,32,0,123,128,0,0,128,56,16,0,160,56,
93,237,4,72,2,0,26,44,8,0,193,179,62,4,172,87,2,0,64,107,
52,0,0,124,126,217,26,84,255,255,3,48,16,25,96,127,10,0,129,177,
104,0,130,64,12,0,225,147,64,0,224,98,16,0,1,152,17,0,129,155,
0,0,128,56,36,0,129,144,56,0,129,176,48,0,129,144,52,0,129,177,
44,72,140,85,16,0,128,145,120,187,227,126,120,35,133,124,8,0,193,56,
33,107,7,72,32,0,97,144,2,0,3,160,32,0,0,96,2,0,3,176,
44,72,163,87,129,193,4,72,255,0,23,44,120,27,121,124,4,1,130,64,
104,0,0,72,63,1,255,87,12,0,225,147,64,0,224,98,16,0,1,152,
17,0,129,155,0,0,128,56,36,0,129,144,56,0,129,176,48,0,129,144,
52,0,129,177,44,72,140,85,16,0,128,145,120,187,227,126,120,35,133,124,
8,0,193,56,185,106,7,72,32,0,97,144,2,0,3,160,32,0,0,96,
2,0,3,176,44,72,163,87,25,193,4,72,255,0,23,44,120,27,121,124,
156,0,130,64,16,0,24,44,148,0,130,64,11,0,96,60,104,38,99,56,
205,212,4,72,49,56,167,87,200,2,129,64,166,3,233,124,120,203,44,127,
191,7,133,85,12,0,130,64,0,0,140,147,32,0,0,72,0,0,140,155,
62,194,128,87,1,0,12,152,62,194,0,84,2,0,12,152,62,194,0,84,
3,0,12,152,1,0,57,59,204,255,0,66,80,0,1,131,100,0,161,131,
96,0,129,131,76,0,225,130,84,0,33,131,104,0,193,131,92,0,97,131,
72,0,193,130,88,0,65,131,108,0,225,131,116,0,1,128,68,0,161,130,
64,0,129,130,166,3,8,124,112,0,33,56,32,0,128,78,120,187,227,126,
120,211,68,127,116,7,5,127,120,203,40,127,8,0,193,56,32,0,225,56,
21,23,5,72,32,0,225,128,6,0,24,44,76,0,130,64,12,0,39,169,
0,0,0,56,120,59,227,124,0,0,7,176,241,99,8,72,13,0,225,139,
14,0,193,139,10,0,1,163,0,0,26,44,8,0,65,163,12,0,129,139,
24,0,129,179,20,0,65,179,28,0,193,179,22,0,1,179,26,0,225,179,
188,0,130,65,88,0,0,72,120,59,229,124,0,0,5,168,0,0,0,44,
248,255,130,64,12,0,39,169,0,0,0,56,120,59,227,124,0,0,7,176,
153,99,8,72,13,0,225,139,14,0,193,139,10,0,1,163,0,0,26,44,
8,0,65,163,12,0,129,139,24,0,129,179,20,0,65,179,28,0,193,179,
22,0,1,179,26,0,225,179,100,0,130,65,12,0,1,128,17,0,193,138,
30,0,225,138,11,0,96,60,31,0,193,154,120,38,99,56,46,132,6,84,
120,51,156,127,62,4,156,87,24,0,129,179,89,211,4,72,120,211,68,127,
120,195,5,127,120,227,134,127,120,251,231,127,120,243,200,127,120,187,233,126,
120,179,202,126,11,0,96,60,68,38,99,56,49,211,4,72,0,0,27,44,
36,1,130,65,84,0,0,72,17,0,193,138,16,0,1,136,11,0,96,60,
31,0,193,154,120,38,99,56,255,6,23,84,30,0,225,154,5,211,4,72,
120,211,68,127,120,195,5,127,120,227,134,127,120,251,231,127,120,243,200,127,
120,187,233,126,120,179,202,126,11,0,96,60,68,38,99,56,221,210,4,72,
0,0,27,44,208,0,130,65,0,0,29,44,200,0,129,64,7,0,160,62,
88,230,181,58,0,0,128,58,11,0,224,62,12,38,247,58,120,203,54,127,
120,187,227,126,173,210,4,72,32,0,96,59,120,179,222,126,120,163,159,126,
120,243,216,127,120,251,228,127,36,133,98,56,145,210,4,72,16,0,64,59,
255,255,152,59,1,0,156,140,44,133,98,56,125,210,4,72,255,255,90,55,
240,255,130,64,16,0,64,59,255,255,152,59,1,0,156,140,224,255,4,56,
91,0,0,40,24,0,128,64,56,133,98,56,85,210,4,72,255,255,90,55,
228,255,130,64,20,0,0,72,52,133,98,56,65,210,4,72,255,255,90,55,
208,255,130,64,54,133,98,56,49,210,4,72,255,255,123,55,16,0,222,59,
16,0,255,59,132,255,130,64,54,133,98,56,25,210,4,72,255,255,189,55,
0,2,148,58,0,2,214,58,88,255,130,64,120,203,35,127,49,190,4,72,
80,0,1,131,100,0,161,131,96,0,129,131,76,0,225,130,84,0,33,131,
104,0,193,131,92,0,97,131,72,0,193,130,88,0,65,131,108,0,225,131,
116,0,1,128,68,0,161,130,64,0,129,130,166,3,8,124,112,0,33,56,
32,0,128,78,232,255,33,148,4,0,3,44,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,12,0,161,147,120,35,157,124,44,0,130,65,
11,0,96,60,220,38,99,56,145,209,4,72,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
4,0,125,128,0,0,128,56,16,0,160,56,241,232,4,72,120,27,126,124,
8,0,125,128,0,0,128,56,16,0,160,56,221,232,4,72,120,27,127,124,
12,0,125,128,0,0,128,56,16,0,160,56,201,232,4,72,120,27,101,124,
120,243,195,127,120,251,228,127,101,38,5,72,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,3,0,3,44,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,35,158,124,40,0,130,65,11,0,96,60,12,39,99,56,
229,208,4,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,4,0,126,128,0,0,128,56,16,0,160,56,
73,232,4,72,120,27,127,124,8,0,126,128,0,0,128,56,16,0,160,56,
53,232,4,72,120,27,100,124,120,251,227,127,25,35,5,72,120,27,100,124,
11,0,96,60,48,39,99,56,141,208,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
4,0,3,44,8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,
120,35,159,124,40,0,130,65,11,0,96,60,76,39,99,56,73,208,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,8,0,127,128,0,0,128,56,16,0,160,56,173,231,4,72,
120,27,126,124,12,0,127,128,0,0,128,56,16,0,160,56,153,231,4,72,
4,0,159,129,0,0,12,136,116,7,0,124,49,0,0,40,24,0,130,65,
50,0,0,40,44,0,130,65,52,0,0,40,64,0,130,65,88,0,0,72,
0,0,126,152,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,0,0,126,176,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,0,0,126,144,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,11,0,96,60,60,39,99,56,133,207,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
232,255,33,148,3,0,3,44,8,0,129,147,12,0,161,147,16,0,193,147,
166,2,8,124,28,0,1,144,20,0,225,147,120,35,159,124,48,0,130,65,
11,0,96,60,208,39,99,56,57,207,4,72,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,8,0,127,128,0,0,128,56,16,0,160,56,149,230,4,72,
4,0,159,129,0,0,12,136,116,7,0,124,49,0,0,40,32,0,130,65,
50,0,0,40,72,0,130,65,52,0,0,40,112,0,130,65,56,0,0,40,
152,0,130,65,236,0,0,72,0,0,131,136,11,0,96,60,116,39,99,56,
201,206,4,72,16,0,193,131,20,0,225,131,28,0,1,128,12,0,161,131,
8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,0,0,131,160,
11,0,96,60,132,39,99,56,153,206,4,72,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,0,0,131,128,11,0,96,60,148,39,99,56,105,206,4,72,
16,0,193,131,20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,
166,3,8,124,24,0,33,56,32,0,128,78,120,27,127,124,11,0,96,60,
164,39,99,56,57,206,4,72,32,0,160,59,120,251,228,127,60,133,98,56,
41,206,4,72,4,0,128,59,252,255,223,59,4,0,158,132,68,133,98,56,
21,206,4,72,255,255,156,55,240,255,130,64,76,133,98,56,5,206,4,72,
255,255,189,55,16,0,255,59,200,255,130,64,76,133,98,56,241,205,4,72,
11,0,96,60,240,39,99,56,229,205,4,72,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,224,255,33,148,12,0,97,147,16,0,129,147,20,0,161,147,
24,0,193,147,28,0,225,147,166,2,8,124,36,0,1,144,1,0,96,56,
33,177,2,72,208,134,237,131,121,184,2,72,64,24,31,124,16,0,130,64,
249,176,2,72,208,134,141,129,20,26,236,127,12,0,63,129,24,0,191,131,
208,255,9,56,190,240,10,84,254,255,138,59,1,0,124,55,28,0,223,59,
0,0,224,59,96,0,129,64,0,0,189,128,0,0,30,128,64,0,5,124,
44,0,130,65,120,235,164,127,11,0,96,60,24,40,99,56,61,205,4,72,
0,0,190,128,120,243,196,127,11,0,96,60,0,40,99,56,41,205,4,72,
1,0,255,59,10,0,31,44,4,0,222,59,4,0,189,59,12,0,128,65,
109,69,5,72,20,0,0,72,255,255,123,55,255,255,156,59,168,255,130,64,
89,69,5,72,20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,
16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,
192,255,33,148,4,0,3,44,48,0,129,147,52,0,161,147,56,0,193,147,
166,2,8,124,68,0,1,144,60,0,225,147,120,35,159,124,48,0,130,65,
11,0,96,60,56,40,99,56,165,204,4,72,56,0,193,131,60,0,225,131,
68,0,1,128,52,0,161,131,48,0,129,131,166,3,8,124,64,0,33,56,
32,0,128,78,4,0,127,128,0,0,128,56,16,0,160,56,1,228,4,72,
120,27,125,124,8,0,127,128,0,0,128,56,16,0,160,56,237,227,4,72,
42,80,126,84,12,0,127,128,16,0,160,56,0,0,128,56,217,227,4,72,
0,0,224,59,120,235,164,127,8,0,97,56,149,153,2,72,8,0,97,56,
9,183,2,72,0,0,3,44,44,0,130,65,8,0,97,56,249,142,2,72,
120,235,164,127,120,27,101,124,11,0,96,60,136,40,99,56,17,204,4,72,
1,0,96,56,141,175,2,72,136,0,0,72,120,243,196,127,8,0,97,56,
0,0,160,56,233,165,2,72,120,243,195,127,25,184,4,72,120,27,124,124,
0,0,128,56,120,243,197,127,241,103,254,75,120,227,132,127,120,243,197,127,
8,0,97,56,0,0,192,56,120,51,199,124,253,171,2,72,120,27,127,124,
120,227,131,127,233,183,4,72,0,0,31,44,32,0,130,64,120,235,164,127,
11,0,96,60,184,40,99,56,161,203,4,72,1,0,96,56,29,175,2,72,
24,0,0,72,11,0,96,60,108,40,99,56,137,203,4,72,1,0,96,56,
5,175,2,72,56,0,193,131,60,0,225,131,68,0,1,128,52,0,161,131,
48,0,129,131,166,3,8,124,64,0,33,56,32,0,128,78,200,255,33,148,
2,0,3,40,48,0,193,147,166,2,8,124,60,0,1,144,52,0,225,147,
120,35,159,124,40,0,128,64,11,0,96,60,4,41,99,56,53,203,4,72,
60,0,1,128,52,0,225,131,48,0,193,131,166,3,8,124,56,0,33,56,
32,0,128,78,4,0,127,129,11,0,128,61,255,255,235,56,20,41,140,57,
255,255,12,57,1,0,39,141,1,0,8,140,64,0,9,124,12,0,130,64,
0,0,9,40,236,255,130,64,81,72,0,124,40,0,130,64,35,34,96,60,
238,238,131,56,8,0,97,56,49,152,2,72,8,0,97,56,165,141,2,72,
121,27,126,124,244,1,130,65,200,1,0,72,4,0,127,129,11,0,128,61,
255,255,235,56,32,41,140,57,255,255,12,57,1,0,39,141,1,0,8,140,
64,0,9,124,12,0,130,64,0,0,9,40,236,255,130,64,81,72,224,124,
40,0,130,64,52,51,96,60,221,221,131,56,8,0,97,56,217,151,2,72,
8,0,97,56,77,141,2,72,121,27,126,124,156,1,130,65,112,1,0,72,
4,0,159,129,11,0,96,61,255,255,12,57,212,40,107,57,255,255,43,57,
1,0,72,141,1,0,9,140,64,0,10,124,12,0,130,64,0,0,10,40,
236,255,130,64,81,80,0,124,40,0,130,64,86,85,96,60,187,187,131,56,
8,0,97,56,129,151,2,72,8,0,97,56,245,140,2,72,121,27,126,124,
68,1,130,65,24,1,0,72,4,0,127,129,11,0,128,61,255,255,235,56,
48,41,140,57,255,255,12,57,1,0,39,141,1,0,72,141,64,80,9,124,
12,0,130,64,0,0,9,40,236,255,130,64,81,72,10,124,40,0,130,64,
103,102,96,60,170,170,131,56,8,0,97,56,41,151,2,72,8,0,97,56,
157,140,2,72,121,27,126,124,236,0,130,65,192,0,0,72,4,0,127,129,
11,0,128,61,255,255,235,56,60,41,140,57,255,255,12,57,1,0,39,141,
1,0,72,141,64,80,9,124,12,0,130,64,0,0,9,40,236,255,130,64,
81,72,10,124,40,0,130,64,34,17,96,60,68,51,131,56,8,0,97,56,
209,150,2,72,8,0,97,56,69,140,2,72,121,27,126,124,148,0,130,65,
104,0,0,72,4,0,127,129,80,133,130,57,120,119,96,60,255,255,235,56,
153,153,99,56,255,255,12,57,1,0,39,141,1,0,72,141,64,80,9,124,
12,0,130,64,0,0,9,40,236,255,130,64,81,72,10,124,20,0,130,65,
4,0,127,128,0,0,128,56,16,0,160,56,169,224,4,72,120,27,100,124,
8,0,97,56,105,150,2,72,8,0,97,56,221,139,2,72,121,27,126,124,
44,0,130,65,8,0,97,56,237,156,2,72,4,0,159,128,120,243,197,127,
11,0,96,60,224,40,99,56,229,200,4,72,1,0,96,56,97,172,2,72,
28,0,0,72,4,0,159,128,11,0,96,60,72,41,99,56,201,200,4,72,
1,0,96,56,69,172,2,72,60,0,1,128,52,0,225,131,48,0,193,131,
166,3,8,124,56,0,33,56,32,0,128,78,166,0,0,124,94,4,0,84,
36,1,0,124,3,0,0,56,172,129,13,152,32,0,128,78,172,42,8,72,
232,255,33,148,166,2,8,124,28,0,1,144,12,0,161,147,34,0,160,59,
16,0,193,147,11,0,192,63,184,44,222,59,20,0,225,147,11,0,224,63,
12,0,158,132,4,0,190,128,100,41,127,56,85,200,4,72,255,255,189,55,
236,255,130,64,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,11,0,96,60,132,41,99,56,11,0,128,60,148,41,132,56,
17,200,4,72,11,0,96,60,168,41,99,56,24,0,128,56,30,0,160,56,
4,0,192,56,8,0,224,56,245,199,4,72,11,0,96,60,212,41,99,56,
11,0,128,60,248,41,132,56,11,0,160,60,4,42,165,56,88,133,194,56,
213,199,4,72,11,0,96,60,16,42,99,56,12,0,128,60,0,248,132,56,
193,199,4,72,184,136,13,136,189,7,0,84,20,0,130,65,40,128,141,128,
11,0,96,60,116,41,99,56,165,199,4,72,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
8,0,193,147,121,27,126,124,12,0,225,147,120,35,159,124,172,0,130,65,
0,0,95,129,255,255,106,57,1,0,139,141,117,7,140,125,248,255,130,64,
81,88,10,124,144,0,130,65,34,0,192,56,11,0,0,61,184,44,8,57,
12,0,104,133,255,255,171,56,255,255,234,56,1,0,37,141,1,0,71,141,
64,80,9,124,12,0,130,64,0,0,9,40,236,255,130,64,81,72,138,125,
48,0,130,64,8,0,8,128,120,243,195,127,120,251,228,127,166,3,9,124,
33,4,128,78,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,255,255,198,52,12,0,130,65,0,0,95,129,
156,255,255,75,11,0,96,60,32,42,99,56,217,198,4,72,120,243,195,127,
120,251,228,127,69,254,255,75,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,216,255,33,148,3,0,3,40,
12,0,33,147,16,0,65,147,20,0,97,147,36,0,225,147,166,2,8,124,
44,0,1,144,28,0,161,147,120,35,157,124,24,0,129,147,32,0,193,147,
28,0,128,63,180,85,156,59,0,0,192,59,60,0,128,64,11,0,96,60,
84,42,99,56,105,198,4,72,32,0,193,131,24,0,129,131,20,0,97,131,
28,0,161,131,36,0,225,131,44,0,1,128,16,0,65,131,12,0,33,131,
166,3,8,124,40,0,33,56,32,0,128,78,12,0,125,128,16,0,160,56,
0,0,128,56,185,221,4,72,120,27,127,124,81,178,4,72,121,27,123,124,
8,0,157,128,64,0,130,64,120,251,229,127,11,0,96,60,108,42,99,56,
9,198,4,72,32,0,193,131,24,0,129,131,20,0,97,131,28,0,161,131,
36,0,225,131,44,0,1,128,16,0,65,131,12,0,33,131,166,3,8,124,
40,0,33,56,32,0,128,78,120,35,131,124,0,0,128,56,16,0,160,56,
89,221,4,72,4,0,61,129,124,133,66,57,255,255,169,56,62,6,122,84,
255,255,202,56,1,0,229,140,1,0,6,141,64,64,7,124,12,0,130,64,
0,0,7,40,236,255,130,64,81,56,8,124,104,0,130,64,36,0,156,129,
92,0,12,128,120,211,68,127,120,227,131,127,120,219,101,127,120,251,230,127,
166,3,9,124,33,4,128,78,120,27,126,124,11,0,96,60,152,42,99,56,
105,197,4,72,0,0,31,44,28,0,129,64,255,255,187,59,1,0,157,140,
96,133,98,56,81,197,4,72,255,255,255,55,240,255,130,64,112,133,98,56,
65,197,4,72,0,0,30,44,52,1,130,65,20,1,0,72,4,0,93,129,
116,133,98,57,255,255,202,56,255,255,235,56,1,0,6,141,1,0,39,141,
64,72,8,124,12,0,130,64,0,0,8,40,236,255,130,64,81,64,9,124,
92,0,130,64,121,251,254,127,40,0,129,64,12,0,61,59,255,255,187,59,
4,0,121,132,0,0,128,56,16,0,160,56,113,220,4,72,255,255,222,55,
1,0,125,156,232,255,130,64,36,0,156,129,100,0,12,128,120,211,68,127,
120,227,131,127,120,219,101,127,120,251,230,127,166,3,9,124,33,4,128,78,
121,27,126,124,172,0,130,65,140,0,0,72,4,0,125,129,104,133,130,57,
255,255,203,56,255,255,236,56,1,0,6,141,1,0,39,141,64,72,8,124,
12,0,130,64,0,0,8,40,236,255,130,64,81,64,9,124,36,0,130,64,
8,0,125,128,0,0,128,56,10,0,160,56,249,219,4,72,101,191,0,72,
0,0,30,44,92,0,130,65,60,0,0,72,11,0,96,60,168,42,99,56,
81,196,4,72,32,0,193,131,24,0,129,131,20,0,97,131,28,0,161,131,
36,0,225,131,44,0,1,128,16,0,65,131,12,0,33,131,166,3,8,124,
40,0,33,56,32,0,128,78,120,243,195,127,25,116,2,72,120,243,196,127,
120,27,101,124,11,0,96,60,188,42,99,56,9,196,4,72,32,0,193,131,
24,0,129,131,20,0,97,131,28,0,161,131,36,0,225,131,44,0,1,128,
16,0,65,131,12,0,33,131,166,3,8,124,40,0,33,56,32,0,128,78,
232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,27,125,124,16,0,193,147,120,35,158,124,4,0,126,128,0,0,128,56,
120,35,133,124,57,219,4,72,120,27,127,124,21,199,7,72,0,0,3,44,
12,0,130,65,2,0,29,44,48,0,130,65,4,0,158,128,11,0,96,60,
220,42,99,56,133,195,4,72,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,201,58,8,72,
0,0,3,44,24,0,130,65,120,251,229,127,120,27,100,124,11,0,96,60,
248,42,99,56,73,195,4,72,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,1,0,0,56,
188,129,13,144,32,0,128,78,1,0,96,60,255,255,99,56,108,18,4,72,
224,255,33,148,24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,
120,27,127,124,20,0,161,147,120,35,157,124,4,0,125,128,132,133,130,56,
12,0,161,56,193,183,4,72,120,27,126,124,8,0,125,128,132,133,130,56,
16,0,161,56,173,183,4,72,20,26,222,127,2,0,30,44,44,0,130,65,
11,0,96,60,108,43,99,56,185,194,4,72,28,0,225,131,36,0,1,128,
24,0,193,131,20,0,161,131,166,3,8,124,32,0,33,56,32,0,128,78,
8,0,97,56,0,0,128,56,4,0,160,56,161,94,254,75,3,0,31,44,
88,0,130,64,12,0,97,128,16,0,129,128,8,0,161,56,4,0,192,56,
249,60,3,72,121,27,127,124,20,0,130,65,120,251,228,127,11,0,96,60,
196,43,99,56,89,194,4,72,16,0,161,128,8,0,193,128,12,0,129,128,
11,0,96,60,120,51,199,124,80,43,99,56,61,194,4,72,0,0,31,44,
116,0,130,65,96,0,0,72,12,0,125,128,8,0,161,56,132,133,130,56,
253,182,4,72,1,0,3,44,44,0,130,65,11,0,96,60,32,43,99,56,
13,194,4,72,28,0,225,131,36,0,1,128,24,0,193,131,20,0,161,131,
166,3,8,124,32,0,33,56,32,0,128,78,12,0,97,128,16,0,129,128,
8,0,161,56,4,0,192,56,29,61,3,72,121,27,127,124,20,0,130,65,
120,251,228,127,11,0,96,60,160,43,99,56,197,193,4,72,28,0,225,131,
36,0,1,128,24,0,193,131,20,0,161,131,166,3,8,124,32,0,33,56,
32,0,128,78,168,255,33,148,2,0,3,44,48,0,193,146,52,0,225,146,
60,0,33,147,64,0,65,147,68,0,97,147,72,0,129,147,76,0,161,147,
80,0,193,147,166,2,8,124,92,0,1,144,84,0,225,147,120,35,159,124,
56,0,1,147,0,0,0,59,24,0,130,64,4,0,127,128,0,0,128,56,
16,0,160,56,225,216,4,72,120,27,120,124,8,0,127,128,0,0,128,56,
16,0,160,56,205,216,4,72,132,196,13,128,12,0,1,144,11,0,96,60,
108,44,99,56,45,193,4,72,12,0,97,128,12,0,129,59,20,0,65,59,
16,0,97,59,24,0,33,59,28,0,225,58,32,0,193,58,36,0,225,59,
40,0,193,59,12,0,160,63,128,16,189,59,0,0,3,44,208,0,130,65,
120,219,100,127,120,211,69,127,120,203,38,127,120,187,231,126,120,179,200,126,
120,251,233,127,120,227,138,127,8,0,193,147,165,101,4,72,121,27,100,124,
72,0,130,65,11,0,96,60,228,43,99,56,193,192,4,72,76,0,161,131,
60,0,33,131,64,0,65,131,80,0,193,131,72,0,129,131,56,0,1,131,
68,0,97,131,84,0,225,131,92,0,1,128,52,0,225,130,48,0,193,130,
166,3,8,124,88,0,33,56,32,0,128,78,0,0,155,128,0,0,90,129,
58,16,74,85,46,232,170,124,11,0,96,60,16,44,99,56,109,192,4,72,
1,0,24,44,44,0,130,64,0,0,124,129,8,0,139,128,11,0,96,60,
28,44,99,56,81,192,4,72,0,0,156,129,16,0,140,128,11,0,96,60,
68,44,99,56,61,192,4,72,0,0,124,128,132,196,13,128,64,0,3,124,
48,255,130,64,76,0,161,131,60,0,33,131,64,0,65,131,80,0,193,131,
72,0,129,131,56,0,1,131,68,0,97,131,84,0,225,131,92,0,1,128,
52,0,225,130,48,0,193,130,166,3,8,124,88,0,33,56,32,0,128,78,
32,0,128,78,0,0,128,57,174,97,131,124,1,0,140,57,0,2,12,44,
244,255,128,65,32,0,128,78,224,255,33,148,12,0,97,147,20,0,161,147,
28,0,225,147,166,2,8,124,36,0,1,144,24,0,193,147,120,27,126,124,
16,0,129,147,16,0,126,128,28,0,128,63,0,0,128,56,180,85,156,59,
181,255,255,75,40,0,126,128,16,0,190,128,0,2,192,56,89,139,7,72,
0,0,3,44,52,1,130,64,16,0,126,131,0,0,155,128,11,0,96,60,
28,47,99,56,117,191,4,72,4,0,155,128,11,0,96,60,0,47,99,56,
101,191,4,72,52,0,222,128,37,0,6,44,120,0,130,64,11,0,96,60,
56,47,99,56,77,191,4,72,11,0,96,60,236,46,99,56,65,191,4,72,
4,0,27,128,0,0,224,59,64,0,31,124,8,0,187,59,32,0,128,64,
174,248,157,124,156,133,98,56,33,191,4,72,4,0,27,128,1,0,255,59,
64,0,31,124,232,255,128,65,152,133,98,56,9,191,4,72,0,0,155,136,
36,0,28,129,100,0,8,128,4,0,219,128,120,227,131,127,120,235,165,127,
166,3,9,124,33,4,128,78,144,0,0,72,11,0,96,60,212,46,99,56,
217,190,4,72,4,0,219,128,36,0,124,129,92,0,139,129,0,0,155,136,
8,0,187,59,120,227,131,127,120,235,165,127,166,3,137,125,33,4,128,78,
0,0,3,44,88,0,130,64,11,0,96,60,84,47,99,56,161,190,4,72,
4,0,27,128,0,0,224,59,64,0,31,124,32,0,128,64,174,248,157,124,
144,133,98,56,133,190,4,72,4,0,27,128,1,0,255,59,64,0,31,124,
232,255,128,65,152,133,98,56,109,190,4,72,40,0,126,128,16,0,190,128,
0,0,128,56,0,2,192,56,185,136,7,72,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,
32,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,
166,2,8,124,28,0,1,144,16,0,193,147,121,27,126,124,20,0,225,147,
120,35,159,124,212,1,130,65,28,0,158,128,11,0,160,63,12,0,128,61,
184,16,140,57,48,0,158,145,16,48,125,56,241,189,4,72,28,0,158,128,
11,0,96,60,44,48,99,56,225,189,4,72,32,0,158,128,11,0,96,60,
68,48,99,56,209,189,4,72,28,0,158,128,16,48,125,56,197,189,4,72,
8,0,30,168,0,0,0,44,124,0,130,65,24,0,126,128,120,27,101,124,
11,0,128,60,100,47,132,56,41,105,2,72,24,0,126,128,8,0,190,168,
11,0,128,60,92,48,132,56,21,105,2,72,8,0,158,168,11,0,96,60,
176,47,99,56,129,189,4,72,32,0,94,129,0,0,62,129,52,0,9,128,
4,0,158,129,12,0,126,128,0,2,0,96,52,0,9,144,4,0,76,145,
141,169,4,72,16,0,126,128,133,169,4,72,20,0,126,128,125,169,4,72,
255,7,224,87,12,1,130,65,0,1,0,72,32,0,94,129,0,0,10,44,
64,0,130,64,0,0,62,129,52,0,9,128,4,0,158,129,12,0,126,128,
0,2,0,96,52,0,9,144,4,0,76,145,69,169,4,72,16,0,126,128,
61,169,4,72,20,0,126,128,53,169,4,72,255,7,224,87,196,0,130,65,
184,0,0,72,11,0,96,60,156,47,99,56,237,188,4,72,24,0,126,128,
164,133,130,56,101,104,2,72,36,0,30,128,0,0,160,59,0,0,29,124,
12,0,126,128,84,0,128,64,60,8,188,87,174,226,195,124,0,0,6,44,
52,0,130,65,24,0,126,128,1,0,189,56,11,0,128,60,216,47,132,56,
45,104,2,72,12,0,254,128,174,226,167,124,1,0,157,56,11,0,96,60,
236,47,99,56,145,188,4,72,12,0,126,128,36,0,30,128,1,0,189,59,
0,0,29,124,180,255,128,65,0,0,62,129,52,0,9,128,4,0,158,129,
32,0,94,129,0,2,0,96,52,0,9,144,4,0,76,145,141,168,4,72,
16,0,126,128,133,168,4,72,20,0,126,128,125,168,4,72,255,7,224,87,
12,0,130,65,120,243,195,127,93,168,4,72,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
197,253,255,75,255,7,192,87,12,0,130,65,120,251,227,127,5,168,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,12,0,97,147,16,0,129,147,20,0,161,147,
24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,0,0,133,131,
121,27,127,124,120,51,221,124,120,35,155,124,20,0,130,64,52,0,96,56,
13,166,4,72,121,27,127,124,204,0,130,65,0,0,192,59,28,0,223,147,
32,0,223,147,4,0,189,128,36,0,191,144,0,0,221,128,8,0,29,160,
44,0,31,176,10,0,29,161,62,4,137,87,0,0,127,147,4,0,191,147,
40,0,223,144,24,0,63,145,60,8,163,84,12,0,0,60,184,16,0,48,
48,0,31,144,46,0,31,177,101,167,4,72,36,0,191,128,0,40,30,124,
12,0,127,144,28,0,128,64,60,8,202,87,1,0,222,59,0,40,30,124,
0,0,0,56,46,27,10,124,236,255,128,65,0,0,128,57,8,0,159,177,
0,2,96,56,45,167,4,72,16,0,127,144,0,2,96,56,33,167,4,72,
20,0,127,144,29,0,96,60,252,4,99,56,11,0,128,60,112,48,132,56,
237,102,4,72,0,0,3,44,24,0,130,65,11,0,96,60,124,48,99,56,
238,0,128,56,0,0,160,56,229,91,254,75,120,251,227,127,28,0,225,131,
20,0,161,131,24,0,193,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,
20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,
12,0,97,147,0,0,197,131,120,35,157,124,121,27,127,124,120,59,252,124,
120,51,219,124,20,0,130,64,56,0,96,56,213,164,4,72,121,27,127,124,
56,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,120,219,102,127,
8,0,161,56,113,254,255,75,12,0,0,60,120,20,0,48,48,0,31,144,
11,0,96,60,140,48,99,56,33,186,4,72,52,0,159,147,120,251,227,127,
28,0,225,131,20,0,161,131,24,0,193,131,36,0,1,128,16,0,129,131,
12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,8,0,193,147,121,27,126,124,166,2,8,124,20,0,1,144,
20,0,130,64,52,0,96,56,77,164,4,72,121,27,126,124,136,0,130,65,
12,0,32,61,184,16,41,57,48,0,62,145,0,0,224,59,0,0,254,147,
28,0,254,147,32,0,254,147,1,0,128,57,36,0,158,145,24,0,254,147,
2,0,96,56,197,165,4,72,36,0,94,129,0,80,31,124,12,0,126,144,
28,0,128,64,60,8,232,87,1,0,255,59,0,80,31,124,0,0,32,57,
46,27,40,125,236,255,128,65,19,0,128,61,172,179,140,129,0,0,0,56,
148,128,141,145,0,2,96,56,8,0,30,176,129,165,4,72,16,0,126,144,
0,2,96,56,117,165,4,72,20,0,126,144,12,0,225,131,20,0,1,128,
120,243,195,127,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
144,255,33,148,96,0,129,147,100,0,161,147,104,0,193,147,108,0,225,147,
166,2,8,124,116,0,1,144,11,0,160,60,184,48,165,56,8,0,225,56,
20,0,32,57,166,3,41,125,4,0,69,133,4,0,71,149,248,255,0,66,
0,0,224,59,120,251,227,127,1,0,128,56,69,216,2,72,120,27,125,124,
120,251,254,127,36,0,157,129,12,0,12,128,60,8,220,87,12,0,97,57,
174,224,171,124,120,235,163,127,210,0,128,56,8,0,193,56,166,3,9,124,
33,4,128,78,0,0,3,44,32,0,130,64,8,0,1,136,20,226,193,124,
13,0,6,137,64,64,0,124,28,0,130,65,115,48,224,59,32,0,0,72,
11,0,96,60,168,48,99,56,125,184,4,72,115,48,224,59,1,0,222,59,
40,0,30,40,156,255,128,65,120,251,227,127,108,0,225,131,104,0,193,131,
116,0,1,128,100,0,161,131,96,0,129,131,166,3,8,124,112,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,8,0,193,147,
120,43,190,124,12,0,225,147,0,0,224,59,5,255,255,75,0,0,3,44,
24,0,130,65,0,0,158,129,1,0,140,57,115,48,224,59,0,0,158,145,
28,0,0,72,11,0,96,60,12,49,99,56,1,184,4,72,0,0,158,129,
1,0,140,57,0,0,158,145,20,0,1,128,120,251,227,127,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,84,0,130,64,36,0,30,128,0,0,31,124,
84,0,128,64,24,0,158,128,120,243,195,127,28,0,190,56,85,255,255,75,
12,0,254,128,0,0,3,44,60,8,236,87,46,59,108,124,16,0,130,65,
32,0,62,129,1,0,41,57,32,0,62,145,36,0,30,128,1,0,255,59,
0,0,31,124,196,255,128,65,16,0,0,72,32,0,126,129,1,0,107,57,
32,0,126,145,152,128,141,129,1,0,140,56,11,0,96,60,32,49,99,56,
152,128,141,144,65,183,4,72,12,0,225,131,20,0,1,128,8,0,193,131,
0,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,205,248,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,13,163,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,
20,0,130,64,52,0,96,56,25,161,4,72,121,27,127,124,52,0,130,65,
8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,
181,250,255,75,12,0,0,60,48,20,0,48,48,0,31,144,11,0,96,60,
52,49,99,56,101,182,4,72,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,8,0,193,147,
120,43,190,124,12,0,225,147,0,0,224,59,134,42,148,124,120,35,131,124,
128,170,0,60,0,128,0,96,64,0,3,124,8,0,130,65,114,48,224,59,
0,0,158,129,1,0,140,57,0,0,158,145,20,0,1,128,120,251,227,127,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,88,0,130,64,36,0,30,128,
0,0,31,124,88,0,128,64,24,0,158,128,4,0,222,128,120,243,195,127,
28,0,190,56,97,255,255,75,12,0,30,129,0,0,3,44,60,8,230,87,
46,67,102,124,16,0,130,65,32,0,62,129,1,0,41,57,32,0,62,145,
36,0,30,128,1,0,255,59,0,0,31,124,192,255,128,65,16,0,0,72,
32,0,126,129,1,0,107,57,32,0,126,145,152,128,141,129,1,0,140,56,
11,0,96,60,92,49,99,56,152,128,141,144,69,181,4,72,12,0,225,131,
20,0,1,128,8,0,193,131,0,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
209,246,255,75,255,7,192,87,12,0,130,65,120,251,227,127,17,161,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,29,159,4,72,
121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,185,248,255,75,12,0,0,60,72,20,0,48,
48,0,31,144,11,0,96,60,112,49,99,56,105,180,4,72,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,43,191,124,8,0,193,147,120,51,222,124,
0,0,96,56,149,179,5,72,0,0,159,129,1,0,140,57,62,231,96,84,
10,0,30,176,0,0,159,145,12,0,225,131,20,0,1,128,8,0,193,131,
0,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,88,0,130,64,36,0,30,128,0,0,31,124,
88,0,128,64,24,0,158,128,4,0,222,128,120,243,195,127,28,0,190,56,
109,255,255,75,12,0,30,129,0,0,3,44,60,8,230,87,46,67,102,124,
16,0,130,65,32,0,62,129,1,0,41,57,32,0,62,145,36,0,30,128,
1,0,255,59,0,0,31,124,192,255,128,65,16,0,0,72,32,0,126,129,
1,0,107,57,32,0,126,145,152,128,141,129,1,0,140,56,11,0,96,60,
136,49,99,56,152,128,141,144,85,179,4,72,12,0,225,131,20,0,1,128,
8,0,193,131,0,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,225,244,255,75,
255,7,192,87,12,0,130,65,120,251,227,127,33,159,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,
120,35,157,124,20,0,130,64,52,0,96,56,45,157,4,72,121,27,127,124,
52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,
8,0,161,56,201,246,255,75,12,0,0,60,24,20,0,48,48,0,31,144,
11,0,96,60,156,49,99,56,121,178,4,72,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,43,191,124,8,0,193,147,120,51,222,124,0,0,96,56,
165,177,5,72,0,0,159,129,1,0,140,57,63,7,96,84,10,0,30,176,
0,0,159,145,12,0,225,131,20,0,1,128,8,0,193,131,0,0,96,56,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,
166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,
0,0,31,44,88,0,130,64,36,0,30,128,0,0,31,124,88,0,128,64,
24,0,158,128,4,0,222,128,120,243,195,127,28,0,190,56,109,255,255,75,
12,0,30,129,0,0,3,44,60,8,230,87,46,67,102,124,16,0,130,65,
32,0,62,129,1,0,41,57,32,0,62,145,36,0,30,128,1,0,255,59,
0,0,31,124,192,255,128,65,16,0,0,72,32,0,126,129,1,0,107,57,
32,0,126,145,152,128,141,129,1,0,140,56,11,0,96,60,176,49,99,56,
152,128,141,144,101,177,4,72,12,0,225,131,20,0,1,128,8,0,193,131,
0,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,241,242,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,49,157,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,
20,0,130,64,52,0,96,56,61,155,4,72,121,27,127,124,52,0,130,65,
8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,
217,244,255,75,12,0,0,60,0,20,0,48,48,0,31,144,11,0,96,60,
196,49,99,56,137,176,4,72,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,176,255,33,148,166,2,8,124,84,0,1,144,8,0,97,56,
76,0,225,147,120,43,191,124,0,2,128,56,120,35,133,124,5,0,192,56,
0,1,224,56,120,59,232,124,3,0,32,57,125,174,2,72,8,0,97,56,
45,175,2,72,8,0,161,56,0,0,96,56,80,0,128,56,153,64,4,72,
245,63,4,72,0,0,3,44,8,0,130,65,113,48,96,56,0,0,159,129,
1,0,140,57,0,0,159,145,84,0,1,128,76,0,225,131,80,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,
84,0,130,64,36,0,62,129,0,72,31,124,84,0,128,64,24,0,158,128,
120,243,195,127,28,0,190,56,73,255,255,75,12,0,254,128,0,0,3,44,
60,8,230,87,46,59,102,124,16,0,130,65,32,0,30,129,1,0,8,57,
32,0,30,145,36,0,62,129,1,0,255,59,0,72,31,124,196,255,128,65,
16,0,0,72,32,0,94,129,1,0,74,57,32,0,94,145,152,128,141,129,
1,0,140,56,11,0,96,60,216,49,99,56,152,128,141,144,81,175,4,72,
32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,113,48,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
205,240,255,75,255,7,192,87,12,0,130,65,120,251,227,127,13,155,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,25,153,4,72,
121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,181,242,255,75,12,0,0,60,232,19,0,48,
48,0,31,144,11,0,96,60,236,49,99,56,101,174,4,72,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,104,255,33,148,140,0,161,147,
166,2,8,124,156,0,1,144,136,0,129,147,120,43,188,124,144,0,193,147,
148,0,225,147,0,0,224,59,120,251,254,127,8,0,97,56,170,0,128,56,
64,0,160,56,29,74,254,75,72,0,97,56,0,0,128,56,64,0,160,56,
13,74,254,75,62,4,221,87,120,235,163,127,8,0,129,56,64,0,160,56,
97,44,4,72,0,0,3,44,28,0,130,64,120,235,163,127,72,0,129,56,
64,0,160,56,129,37,4,72,0,0,3,44,24,0,130,65,0,0,124,129,
1,0,107,57,112,48,224,59,0,0,124,145,76,0,0,72,8,0,129,57,
174,24,44,125,72,0,1,57,174,24,8,124,64,0,9,124,16,0,130,65,
112,48,224,59,0,1,222,59,20,0,0,72,1,0,99,56,64,0,3,44,
212,255,128,65,0,1,222,59,0,32,30,44,96,255,128,65,0,0,124,129,
1,0,107,57,0,0,124,145,120,251,227,127,148,0,225,131,144,0,193,131,
156,0,1,128,140,0,161,131,136,0,129,131,166,3,8,124,152,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,84,0,130,64,
36,0,62,129,0,72,31,124,84,0,128,64,24,0,158,128,120,243,195,127,
28,0,190,56,201,254,255,75,12,0,254,128,0,0,3,44,60,8,230,87,
46,59,102,124,16,0,130,65,32,0,30,129,1,0,8,57,32,0,30,145,
36,0,62,129,1,0,255,59,0,72,31,124,196,255,128,65,16,0,0,72,
32,0,94,129,1,0,74,57,32,0,94,145,152,128,141,129,1,0,140,56,
11,0,96,60,16,50,99,56,152,128,141,144,173,172,4,72,32,0,30,128,
0,0,0,44,0,0,96,56,8,0,130,65,112,48,96,56,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,41,238,255,75,
255,7,192,87,12,0,130,65,120,251,227,127,105,152,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,
120,35,157,124,20,0,130,64,52,0,96,56,117,150,4,72,121,27,127,124,
52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,
8,0,161,56,17,240,255,75,12,0,0,60,208,19,0,48,48,0,31,144,
11,0,96,60,36,50,99,56,193,171,4,72,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,
20,0,225,147,166,2,8,124,28,0,1,144,9,128,13,136,116,7,0,124,
0,0,224,59,0,0,31,124,120,43,190,124,144,0,128,64,113,77,4,72,
120,27,125,124,120,251,227,127,93,225,2,72,97,77,4,72,64,232,3,124,
52,0,129,64,80,24,29,124,58,16,9,84,20,2,137,125,28,67,64,61,
131,222,74,57,22,96,10,124,190,116,4,84,11,0,96,60,64,50,99,56,
41,171,4,72,1,0,255,59,52,0,0,72,80,232,3,125,248,64,0,125,
58,16,9,84,20,2,137,125,28,67,64,61,131,222,74,57,22,96,10,124,
190,116,4,84,11,0,96,60,64,50,99,56,245,170,4,72,1,0,255,59,
9,128,13,136,116,7,0,124,0,0,31,124,120,255,128,65,0,0,158,129,
1,0,140,57,0,0,158,145,28,0,1,128,20,0,225,131,12,0,161,131,
16,0,193,131,0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,84,0,130,64,36,0,62,129,
0,72,31,124,84,0,128,64,24,0,158,128,120,243,195,127,28,0,190,56,
221,254,255,75,12,0,254,128,0,0,3,44,60,8,230,87,46,59,102,124,
16,0,130,65,32,0,30,129,1,0,8,57,32,0,30,145,36,0,62,129,
1,0,255,59,0,72,31,124,196,255,128,65,16,0,0,72,32,0,94,129,
1,0,74,57,32,0,94,145,152,128,141,129,1,0,140,56,11,0,96,60,
76,50,99,56,152,128,141,144,29,170,4,72,32,0,30,128,0,0,0,44,
0,0,96,56,8,0,130,65,26,48,96,56,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,153,235,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,217,149,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,
20,0,130,64,52,0,96,56,229,147,4,72,121,27,127,124,52,0,130,65,
8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,
129,237,255,75,12,0,0,60,184,19,0,48,48,0,31,144,11,0,96,60,
96,50,99,56,49,169,4,72,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,0,0,128,57,252,255,132,56,1,0,140,57,128,0,12,44,
4,0,164,148,244,255,128,65,32,0,128,78,0,32,128,61,0,7,140,57,
0,0,96,56,8,0,108,144,12,0,108,144,16,0,204,144,0,2,64,57,
24,0,76,145,28,0,108,129,255,159,105,85,248,255,130,64,8,0,44,145,
0,0,0,56,12,0,12,144,40,224,96,61,16,0,108,145,0,2,0,57,
24,0,12,145,28,0,12,128,255,159,11,84,248,255,130,64,0,0,68,129,
0,0,5,128,64,0,10,124,4,0,165,56,4,0,132,56,12,0,130,65,
26,48,96,56,32,0,128,78,1,0,107,57,128,0,11,44,216,255,128,65,
32,0,128,78,232,255,33,148,166,2,8,124,28,0,1,144,20,0,225,147,
1,129,224,63,16,0,193,147,0,32,192,63,0,0,222,59,0,14,158,56,
12,0,161,147,120,43,189,124,52,18,160,60,120,86,165,56,45,255,255,75,
0,8,158,56,205,204,160,60,204,204,165,56,29,255,255,75,0,10,158,56,
222,221,160,60,221,221,165,56,13,255,255,75,0,12,158,56,239,238,160,60,
238,238,165,56,253,254,255,75,0,14,158,56,0,8,190,56,120,27,103,124,
1,129,192,60,5,255,255,75,0,0,3,44,48,0,130,64,0,8,190,56,
0,14,158,56,120,59,227,124,237,254,255,75,0,0,3,44,24,0,130,64,
0,8,190,56,0,14,158,56,120,251,230,127,120,59,227,124,209,254,255,75,
0,0,157,129,1,0,140,57,0,0,157,145,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,84,0,130,64,36,0,30,129,
0,64,31,124,84,0,128,64,24,0,158,128,120,243,195,127,28,0,190,56,
237,254,255,75,12,0,30,128,0,0,3,44,60,8,236,87,46,3,108,124,
16,0,130,65,32,0,254,128,1,0,231,56,32,0,254,144,36,0,30,129,
1,0,255,59,0,64,31,124,196,255,128,65,16,0,0,72,32,0,62,129,
1,0,41,57,32,0,62,145,152,128,109,129,1,0,139,56,11,0,96,60,
120,50,99,56,152,128,141,144,253,166,4,72,32,0,30,128,0,0,0,44,
0,0,96,56,8,0,130,65,26,48,96,56,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,121,232,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,185,146,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,
20,0,130,64,52,0,96,56,197,144,4,72,121,27,127,124,52,0,130,65,
8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,
97,234,255,75,12,0,0,60,160,19,0,48,48,0,31,144,11,0,96,60,
140,50,99,56,17,166,4,72,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,208,255,33,148,40,0,193,147,44,0,225,147,0,0,128,56,
120,35,131,124,0,32,32,61,0,0,41,57,120,35,136,124,11,0,64,61,
184,50,74,57,4,0,97,57,8,0,128,57,166,3,137,125,4,0,138,133,
4,0,139,149,248,255,0,66,16,0,225,131,20,0,193,128,12,0,193,131,
28,0,65,129,32,0,97,129,8,0,4,40,8,0,129,129,24,0,225,128,
72,2,9,145,76,2,137,145,36,0,1,145,76,2,201,147,76,2,233,147,
76,2,201,144,76,2,233,144,76,2,73,145,76,2,105,145,76,2,9,145,
80,2,9,145,52,0,128,64,8,0,129,57,58,16,139,84,46,96,139,125,
84,2,105,129,64,96,11,124,16,0,130,65,28,48,96,56,16,0,8,57,
20,0,0,72,1,0,132,56,8,0,4,40,212,255,128,65,16,0,8,57,
0,32,8,44,88,255,128,65,0,0,133,129,1,0,140,57,0,0,133,145,
44,0,225,131,40,0,193,131,48,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,84,0,130,64,36,0,30,129,0,64,31,124,
84,0,128,64,24,0,158,128,120,243,195,127,28,0,190,56,221,254,255,75,
12,0,30,128,0,0,3,44,60,8,236,87,46,3,108,124,16,0,130,65,
32,0,254,128,1,0,231,56,32,0,254,144,36,0,30,129,1,0,255,59,
0,64,31,124,196,255,128,65,16,0,0,72,32,0,62,129,1,0,41,57,
32,0,62,145,152,128,109,129,1,0,139,56,11,0,96,60,220,50,99,56,
152,128,141,144,109,164,4,72,32,0,30,128,0,0,0,44,0,0,96,56,
8,0,130,65,28,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,
28,0,130,65,0,0,128,56,233,229,255,75,255,7,192,87,12,0,130,65,
120,251,227,127,41,144,4,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,
20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,
0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,20,0,130,64,
52,0,96,56,53,142,4,72,121,27,127,124,52,0,130,65,8,0,193,147,
120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,209,231,255,75,
12,0,0,60,136,19,0,48,48,0,31,144,11,0,96,60,240,50,99,56,
129,163,4,72,120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
216,255,33,148,32,0,193,147,36,0,225,147,1,0,224,60,0,0,128,56,
120,35,131,124,0,32,32,61,0,0,41,57,120,35,136,124,11,0,64,61,
4,51,74,57,4,0,97,57,6,0,128,57,166,3,137,125,4,0,138,133,
4,0,139,149,248,255,0,66,28,0,97,129,20,0,193,128,16,0,225,131,
6,0,4,40,12,0,193,131,24,0,65,129,148,0,9,145,0,254,236,100,
148,0,137,145,8,0,129,145,148,0,201,147,148,0,233,147,148,0,201,144,
148,0,73,145,148,0,105,145,164,0,9,145,76,0,128,64,172,0,73,129,
0,0,4,44,16,0,130,64,13,0,75,85,250,18,76,85,120,99,106,125,
58,16,139,84,8,0,129,57,46,96,139,125,64,96,10,124,20,0,130,65,
27,48,96,56,16,0,8,57,0,1,231,56,24,0,0,72,1,0,132,56,
6,0,4,40,188,255,128,65,16,0,8,57,0,1,231,56,1,0,128,61,
0,96,8,124,68,255,128,65,0,0,133,129,1,0,140,57,0,0,133,145,
36,0,225,131,32,0,193,131,40,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,84,0,130,64,36,0,30,129,0,64,31,124,
84,0,128,64,24,0,158,128,120,243,195,127,28,0,190,56,197,254,255,75,
12,0,30,128,0,0,3,44,60,8,236,87,46,3,108,124,16,0,130,65,
32,0,254,128,1,0,231,56,32,0,254,144,36,0,30,129,1,0,255,59,
0,64,31,124,196,255,128,65,16,0,0,72,32,0,62,129,1,0,41,57,
32,0,62,145,152,128,109,129,1,0,139,56,11,0,96,60,32,51,99,56,
152,128,141,144,197,161,4,72,32,0,30,128,0,0,0,44,0,0,96,56,
8,0,130,65,27,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,
28,0,130,65,0,0,128,56,65,227,255,75,255,7,192,87,12,0,130,65,
120,251,227,127,129,141,4,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,
20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,
0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,20,0,130,64,
52,0,96,56,141,139,4,72,121,27,127,124,52,0,130,65,8,0,193,147,
120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,41,229,255,75,
12,0,0,60,112,19,0,48,48,0,31,144,11,0,96,60,52,51,99,56,
217,160,4,72,120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
0,0,96,57,0,40,11,124,44,0,128,64,174,88,131,125,174,88,4,124,
64,0,12,124,16,0,130,65,19,48,96,56,0,0,102,145,32,0,128,78,
1,0,107,57,0,40,11,124,220,255,128,65,0,0,96,56,255,255,96,57,
0,0,102,145,32,0,128,78,216,255,33,148,16,0,65,147,24,0,129,147,
120,35,156,124,20,42,92,127,166,2,8,124,44,0,1,144,0,0,0,56,
8,0,1,144,0,254,26,56,64,0,28,124,36,0,225,147,20,0,97,147,
120,27,123,124,28,0,161,147,120,51,221,124,32,0,193,147,120,59,254,124,
164,0,129,65,120,227,131,127,120,243,196,127,0,2,160,56,29,93,7,72,
121,27,127,124,32,0,130,65,120,219,99,127,11,0,192,63,204,51,158,56,
129,75,2,72,204,51,126,56,245,159,4,72,112,0,0,72,120,235,163,127,
120,243,196,127,0,2,160,56,8,0,193,56,45,255,255,75,121,27,127,124,
68,0,130,65,8,0,1,128,174,0,254,124,174,0,221,124,120,219,99,127,
20,2,188,124,11,0,128,60,76,51,132,56,57,75,2,72,8,0,1,128,
174,0,189,124,174,0,222,124,20,2,156,124,11,0,96,60,140,51,99,56,
153,159,4,72,20,0,0,72,0,2,156,59,0,254,26,56,64,0,28,124,
100,255,129,64,28,0,161,131,120,251,227,127,36,0,225,131,24,0,129,131,
32,0,193,131,44,0,1,128,20,0,97,131,16,0,65,131,166,3,8,124,
40,0,33,56,32,0,128,78,224,255,33,148,8,0,65,147,166,2,8,124,
36,0,1,144,16,0,129,147,120,35,156,124,20,0,161,147,120,43,189,124,
24,0,193,147,120,51,222,124,28,0,225,147,130,3,224,59,12,0,97,147,
120,27,123,124,11,0,96,60,116,52,99,56,21,159,4,72,184,136,13,136,
189,7,0,84,12,1,130,65,19,0,224,63,176,179,255,131,160,0,95,63,
120,251,228,127,11,0,96,60,12,52,99,56,237,158,4,72,120,211,68,127,
11,0,96,60,40,52,99,56,221,158,4,72,11,0,96,60,152,52,99,56,
160,0,128,60,205,158,4,72,120,235,163,127,170,0,128,56,213,222,255,75,
120,219,99,127,120,251,228,127,120,235,166,127,120,243,199,127,160,0,160,60,
61,254,255,75,121,27,127,124,10,0,128,56,48,0,130,65,19,0,96,60,
112,177,99,56,153,237,254,75,145,213,254,75,11,0,96,60,228,51,99,56,
129,158,4,72,0,0,156,129,1,0,140,57,0,0,156,145,140,0,0,72,
19,0,96,60,112,177,99,56,109,237,254,75,121,27,127,124,60,0,130,65,
120,219,99,127,11,0,192,63,68,52,158,56,209,73,2,72,68,52,126,56,
69,158,4,72,69,213,254,75,11,0,96,60,228,51,99,56,53,158,4,72,
0,0,156,129,1,0,140,57,0,0,156,145,64,0,0,72,37,213,254,75,
121,27,127,124,28,0,130,65,120,219,99,127,11,0,192,63,180,52,158,56,
141,73,2,72,180,52,126,56,1,158,4,72,11,0,96,60,228,51,99,56,
245,157,4,72,0,0,156,129,1,0,140,57,0,0,156,145,20,0,161,131,
120,251,227,127,28,0,225,131,16,0,129,131,24,0,193,131,36,0,1,128,
12,0,97,131,8,0,65,131,166,3,8,124,32,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,88,0,130,64,36,0,62,129,
0,72,31,124,88,0,128,64,20,0,222,128,24,0,126,128,16,0,190,128,
28,0,158,56,37,254,255,75,12,0,254,128,0,0,3,44,60,8,230,87,
46,59,102,124,16,0,130,65,32,0,30,129,1,0,8,57,32,0,30,145,
36,0,62,129,1,0,255,59,0,72,31,124,192,255,128,65,16,0,0,72,
32,0,94,129,1,0,74,57,32,0,94,145,152,128,141,129,1,0,140,56,
11,0,96,60,204,52,99,56,152,128,141,144,33,157,4,72,32,0,30,128,
0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,157,222,255,75,
255,7,192,87,12,0,130,65,120,251,227,127,221,136,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,
120,35,157,124,20,0,130,64,52,0,96,56,233,134,4,72,121,27,127,124,
52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,
8,0,161,56,133,224,255,75,12,0,0,60,200,18,0,48,48,0,31,144,
11,0,96,60,224,52,99,56,53,156,4,72,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,121,27,127,124,
166,2,8,124,20,0,1,144,20,0,130,64,52,0,96,56,109,134,4,72,
121,27,127,124,24,0,130,65,120,251,227,127,241,225,255,75,12,0,0,60,
200,18,0,48,48,0,31,144,20,0,1,128,120,251,227,127,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,216,255,33,148,20,0,97,147,
28,0,161,147,36,0,225,147,166,2,8,124,44,0,1,144,12,0,33,147,
120,35,153,124,16,0,65,147,120,43,186,124,24,0,129,147,120,51,220,124,
32,0,193,147,130,3,192,59,8,0,1,147,120,27,120,124,11,0,96,60,
76,53,99,56,113,155,4,72,184,136,13,136,189,7,0,84,100,1,130,65,
19,0,224,63,176,179,255,131,160,0,127,63,120,251,228,127,11,0,96,60,
48,53,99,56,73,155,4,72,120,219,100,127,11,0,96,60,116,53,99,56,
57,155,4,72,11,0,96,60,20,54,99,56,160,0,128,60,41,155,4,72,
11,0,96,60,144,53,99,56,29,155,4,72,120,211,67,127,170,0,128,56,
37,219,255,75,120,251,253,127,0,254,27,56,64,0,29,124,72,0,129,65,
120,235,163,127,120,211,68,127,0,2,160,56,157,88,7,72,121,27,126,124,
32,0,130,65,120,195,3,127,11,0,224,63,184,53,159,56,93,70,2,72,
184,53,127,56,209,154,4,72,204,0,0,72,0,2,189,59,0,254,27,56,
64,0,29,124,192,255,129,64,11,0,96,60,48,54,99,56,177,154,4,72,
11,0,96,60,96,54,99,56,165,154,4,72,120,195,3,127,120,251,228,127,
120,211,70,127,120,227,135,127,160,0,160,60,33,250,255,75,120,27,126,124,
11,0,96,60,208,53,99,56,125,154,4,72,0,0,30,44,116,0,130,64,
19,0,224,63,112,177,127,56,9,0,128,56,109,233,254,75,121,27,126,124,
32,0,130,65,120,195,3,127,11,0,224,63,0,53,159,56,209,69,2,72,
0,53,127,56,69,154,4,72,64,0,0,72,184,136,13,136,1,0,0,96,
184,136,13,152,193,222,254,75,121,27,126,124,40,0,130,65,112,177,127,56,
0,0,128,56,37,233,254,75,120,195,3,127,11,0,224,63,252,53,159,56,
145,69,2,72,252,53,127,56,5,154,4,72,11,0,96,60,132,54,99,56,
249,153,4,72,0,0,121,129,1,0,107,57,0,0,121,145,20,0,97,131,
120,243,195,127,32,0,193,131,28,0,161,131,16,0,65,131,24,0,129,131,
36,0,225,131,44,0,1,128,12,0,33,131,8,0,1,131,166,3,8,124,
40,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,
88,0,130,64,36,0,62,129,0,72,31,124,88,0,128,64,20,0,222,128,
24,0,126,128,16,0,190,128,28,0,158,56,189,253,255,75,12,0,254,128,
0,0,3,44,60,8,230,87,46,59,102,124,16,0,130,65,32,0,30,129,
1,0,8,57,32,0,30,145,36,0,62,129,1,0,255,59,0,72,31,124,
192,255,128,65,16,0,0,72,32,0,94,129,1,0,74,57,32,0,94,145,
152,128,141,129,1,0,140,56,11,0,96,60,180,54,99,56,152,128,141,144,
29,153,4,72,32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,
19,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,
0,0,128,56,153,218,255,75,255,7,192,87,12,0,130,65,120,251,227,127,
217,132,4,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,
24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,
121,27,127,124,120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,
229,130,4,72,121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,
120,235,164,127,120,227,134,127,8,0,161,56,129,220,255,75,12,0,0,60,
176,18,0,48,48,0,31,144,11,0,96,60,200,54,99,56,49,152,4,72,
120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,
16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,121,27,127,124,166,2,8,124,20,0,1,144,20,0,130,64,
52,0,96,56,105,130,4,72,121,27,127,124,24,0,130,65,120,251,227,127,
237,221,255,75,12,0,0,60,176,18,0,48,48,0,31,144,20,0,1,128,
120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
232,255,33,148,12,0,161,147,16,0,193,147,20,0,225,147,166,2,8,124,
28,0,1,144,184,136,13,136,120,35,157,124,189,7,0,84,120,27,126,124,
130,3,224,59,68,0,130,65,1,0,96,56,172,133,130,56,169,200,254,75,
121,27,127,124,48,0,130,65,120,243,195,127,11,0,192,63,236,54,158,56,
233,66,2,72,236,54,126,56,93,151,4,72,0,0,157,129,1,0,140,57,
120,251,227,127,0,0,157,145,20,0,0,72,0,0,157,129,1,0,140,57,
120,251,227,127,0,0,157,145,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,80,0,130,64,36,0,30,129,0,64,31,124,
80,0,128,64,24,0,126,128,28,0,158,56,45,255,255,75,12,0,30,128,
0,0,3,44,60,8,236,87,46,3,108,124,16,0,130,65,32,0,254,128,
1,0,231,56,32,0,254,144,36,0,30,129,1,0,255,59,0,64,31,124,
200,255,128,65,16,0,0,72,32,0,62,129,1,0,41,57,32,0,62,145,
152,128,109,129,1,0,139,56,11,0,96,60,12,55,99,56,152,128,141,144,
137,150,4,72,32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,
19,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,
0,0,128,56,5,216,255,75,255,7,192,87,12,0,130,65,120,251,227,127,
69,130,4,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,
24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,
121,27,127,124,120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,
81,128,4,72,121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,
120,235,164,127,120,227,134,127,8,0,161,56,237,217,255,75,12,0,0,60,
152,18,0,48,48,0,31,144,11,0,96,60,32,55,99,56,157,149,4,72,
120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,
16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,120,35,159,124,129,211,254,75,
0,0,159,129,1,0,140,57,0,0,159,145,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,
166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,
0,0,31,44,80,0,130,64,36,0,30,129,0,64,31,124,80,0,128,64,
24,0,126,128,28,0,158,56,145,255,255,75,12,0,30,128,0,0,3,44,
60,8,236,87,46,3,108,124,16,0,130,65,32,0,254,128,1,0,231,56,
32,0,254,144,36,0,30,129,1,0,255,59,0,64,31,124,200,255,128,65,
16,0,0,72,32,0,62,129,1,0,41,57,32,0,62,145,152,128,109,129,
1,0,139,56,11,0,96,60,64,55,99,56,152,128,141,144,173,148,4,72,
32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
41,214,255,75,255,7,192,87,12,0,130,65,120,251,227,127,105,128,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,117,126,4,72,
121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,17,216,255,75,12,0,0,60,128,18,0,48,
48,0,31,144,11,0,96,60,84,55,99,56,193,147,4,72,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,35,159,124,62,6,163,84,217,209,254,75,
0,0,159,129,1,0,140,57,0,0,159,145,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,
166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,
0,0,31,44,84,0,130,64,36,0,62,129,0,72,31,124,84,0,128,64,
24,0,126,128,44,0,190,160,28,0,158,56,137,255,255,75,12,0,254,128,
0,0,3,44,60,8,230,87,46,59,102,124,16,0,130,65,32,0,30,129,
1,0,8,57,32,0,30,145,36,0,62,129,1,0,255,59,0,72,31,124,
196,255,128,65,16,0,0,72,32,0,94,129,1,0,74,57,32,0,94,145,
152,128,141,129,1,0,140,56,11,0,96,60,104,55,99,56,152,128,141,144,
201,146,4,72,32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,
19,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,
0,0,128,56,69,212,255,75,255,7,192,87,12,0,130,65,120,251,227,127,
133,126,4,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,
24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,0,0,133,131,
121,27,127,124,120,51,221,124,120,35,158,124,20,0,130,64,52,0,96,56,
145,124,4,72,121,27,127,124,68,0,130,65,8,0,129,147,120,251,227,127,
120,243,196,127,120,235,166,127,8,0,161,56,45,214,255,75,12,0,0,60,
104,18,0,48,48,0,31,144,11,0,96,60,148,55,99,56,221,145,4,72,
44,0,159,160,11,0,96,60,124,55,99,56,205,145,4,72,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,35,159,124,221,215,254,75,0,0,159,129,
1,0,140,57,0,0,159,145,20,0,1,128,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,
80,0,130,64,36,0,30,129,0,64,31,124,80,0,128,64,24,0,126,128,
28,0,158,56,145,255,255,75,12,0,30,128,0,0,3,44,60,8,236,87,
46,3,108,124,16,0,130,65,32,0,254,128,1,0,231,56,32,0,254,144,
36,0,30,129,1,0,255,59,0,64,31,124,200,255,128,65,16,0,0,72,
32,0,62,129,1,0,41,57,32,0,62,145,152,128,109,129,1,0,139,56,
11,0,96,60,184,55,99,56,152,128,141,144,221,144,4,72,32,0,30,128,
0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,89,210,255,75,
255,7,192,87,12,0,130,65,120,251,227,127,153,124,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,
120,35,157,124,20,0,130,64,52,0,96,56,165,122,4,72,121,27,127,124,
52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,
8,0,161,56,65,212,255,75,12,0,0,60,80,18,0,48,48,0,31,144,
11,0,96,60,204,55,99,56,241,143,4,72,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,11,0,96,60,0,56,99,56,173,143,4,72,
89,74,3,72,28,0,159,129,1,0,140,57,28,0,159,145,12,0,225,131,
20,0,1,128,0,0,96,56,16,0,33,56,166,3,8,124,32,0,128,78,
208,255,33,148,166,2,8,124,52,0,1,144,44,0,225,147,120,27,127,124,
8,0,97,56,35,34,128,60,238,238,132,56,185,92,2,72,8,0,97,56,
45,122,2,72,0,0,3,44,36,0,130,65,8,0,97,56,61,99,2,72,
11,0,96,60,44,56,99,56,61,143,4,72,1,0,0,56,28,0,31,144,
16,0,0,72,11,0,96,60,80,56,99,56,37,143,4,72,52,0,1,128,
44,0,225,131,0,0,96,56,48,0,33,56,166,3,8,124,32,0,128,78,
224,255,33,148,24,0,193,147,166,2,8,124,36,0,1,144,8,0,65,147,
120,27,122,124,20,0,161,147,120,51,221,124,16,0,129,147,12,0,97,147,
120,35,155,124,28,0,225,147,1,0,224,59,48,216,252,127,213,31,7,72,
120,251,228,127,120,27,126,124,232,3,96,57,29,0,64,61,252,4,74,57,
9,0,32,61,248,112,41,57,0,0,0,57,8,0,3,145,4,0,35,145,
36,0,67,145,40,0,131,147,20,0,99,145,145,37,7,72,2,0,158,161,
0,1,140,97,2,0,158,177,2,0,30,160,232,0,29,44,0,8,0,96,
2,0,30,176,60,0,130,64,120,219,99,127,120,243,196,127,120,211,69,127,
253,206,4,72,120,243,195,127,89,33,7,72,0,0,0,56,0,0,30,176,
120,27,127,124,120,243,195,127,49,30,8,72,0,0,31,44,136,0,130,65,
128,0,0,72,228,0,29,44,60,0,130,64,120,219,99,127,120,243,196,127,
120,211,69,127,161,205,4,72,120,243,195,127,25,33,7,72,0,0,0,56,
0,0,30,176,120,27,127,124,120,243,195,127,241,29,8,72,0,0,31,44,
72,0,130,65,64,0,0,72,236,0,29,44,20,0,130,64,120,219,99,127,
120,243,196,127,120,211,69,127,53,217,4,72,120,243,195,127,217,32,7,72,
0,0,0,56,0,0,30,176,120,27,127,124,120,243,195,127,177,29,8,72,
0,0,31,44,8,0,130,65,19,48,224,59,20,0,161,131,120,251,227,127,
28,0,225,131,16,0,129,131,24,0,193,131,36,0,1,128,12,0,97,131,
8,0,65,131,166,3,8,124,32,0,33,56,32,0,128,78,11,0,96,60,
160,56,99,56,136,141,4,72,224,255,33,148,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,12,0,97,147,120,51,219,124,120,219,127,127,
120,219,99,127,16,0,129,147,120,35,156,124,120,59,228,124,20,0,161,147,
120,43,189,124,0,2,160,56,236,0,192,56,61,254,255,75,121,27,126,124,
208,0,130,64,120,219,99,127,165,255,255,75,11,0,96,60,4,57,99,56,
41,141,4,72,176,0,31,160,112,70,10,124,127,6,95,85,16,0,31,40,
24,0,128,64,4,0,31,40,44,0,130,65,8,0,31,40,132,0,130,64,
32,0,0,72,16,0,31,40,48,0,130,65,32,0,31,40,64,0,130,65,
64,0,31,40,80,0,130,65,100,0,0,72,2,0,224,59,11,0,96,60,
24,57,99,56,213,140,4,72,10,0,253,179,96,0,0,72,4,0,224,59,
11,0,96,60,36,57,99,56,189,140,4,72,10,0,253,179,72,0,0,72,
5,0,224,59,11,0,96,60,236,56,99,56,165,140,4,72,10,0,253,179,
48,0,0,72,6,0,224,59,11,0,96,60,248,56,99,56,141,140,4,72,
10,0,253,179,24,0,0,72,0,0,224,59,11,0,96,60,224,56,99,56,
117,140,4,72,10,0,253,179,0,0,156,129,1,0,140,57,0,0,156,145,
20,0,161,131,120,243,195,127,24,0,193,131,28,0,225,131,36,0,1,128,
16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,92,0,130,64,36,0,94,129,
0,80,31,124,92,0,128,64,16,0,222,128,44,0,254,160,24,0,126,128,
4,0,190,128,28,0,158,56,113,254,255,75,12,0,30,129,0,0,3,44,
60,8,231,87,46,67,103,124,16,0,130,65,32,0,62,129,1,0,41,57,
32,0,62,145,36,0,94,129,1,0,255,59,0,80,31,124,188,255,128,65,
16,0,0,72,32,0,126,129,1,0,107,57,32,0,126,145,152,128,141,129,
1,0,140,56,11,0,96,60,48,57,99,56,152,128,141,144,157,139,4,72,
32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
25,205,255,75,255,7,192,87,12,0,130,65,120,251,227,127,89,119,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,133,131,121,27,127,124,
120,51,221,124,120,35,158,124,20,0,130,64,52,0,96,56,101,117,4,72,
121,27,127,124,68,0,130,65,8,0,129,147,120,251,227,127,120,243,196,127,
120,235,166,127,8,0,161,56,1,207,255,75,12,0,0,60,96,20,0,48,
48,0,31,144,11,0,96,60,68,57,99,56,177,138,4,72,44,0,159,160,
11,0,96,60,96,57,99,56,161,138,4,72,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,224,255,33,148,12,0,97,147,16,0,129,147,
28,0,225,147,166,2,8,124,36,0,1,144,20,0,161,147,120,35,157,124,
0,0,128,56,24,0,193,147,120,43,190,124,120,51,195,124,0,2,192,56,
13,86,7,72,121,27,127,124,172,0,130,64,0,0,30,136,2,0,30,137,
3,0,254,136,1,0,94,137,46,64,74,85,14,192,231,84,11,0,96,60,
148,57,99,56,30,128,8,85,20,66,39,125,20,82,137,125,20,2,108,127,
120,219,100,127,5,138,4,72,5,0,222,136,4,0,30,137,46,64,198,84,
20,66,230,124,63,252,252,84,92,0,130,65,128,0,28,40,8,0,129,64,
128,0,128,59,120,227,132,127,11,0,96,60,112,57,99,56,209,137,4,72,
0,0,192,56,60,8,128,87,0,0,6,124,254,255,123,59,44,0,128,64,
20,242,102,125,7,0,43,137,6,0,75,137,2,0,198,56,46,64,41,85,
20,82,9,124,2,0,27,180,60,8,128,87,0,0,6,124,220,255,128,65,
0,0,157,129,1,0,140,57,0,0,157,145,24,0,193,131,20,0,161,131,
120,251,227,127,28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,
166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,
0,0,31,44,88,0,130,64,36,0,62,129,0,72,31,124,88,0,128,64,
40,0,222,128,24,0,126,128,16,0,190,128,28,0,158,56,165,254,255,75,
12,0,254,128,0,0,3,44,60,8,230,87,46,59,102,124,16,0,130,65,
32,0,30,129,1,0,8,57,32,0,30,145,36,0,62,129,1,0,255,59,
0,72,31,124,192,255,128,65,16,0,0,72,32,0,94,129,1,0,74,57,
32,0,94,145,152,128,141,129,1,0,140,56,11,0,96,60,176,57,99,56,
152,128,141,144,197,136,4,72,32,0,30,128,0,0,0,44,0,0,96,56,
8,0,130,65,19,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,
28,0,130,65,0,0,128,56,65,202,255,75,255,7,192,87,12,0,130,65,
120,251,227,127,129,116,4,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,
20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,
0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,20,0,130,64,
52,0,96,56,141,114,4,72,121,27,127,124,52,0,130,65,8,0,193,147,
120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,41,204,255,75,
12,0,0,60,88,19,0,48,48,0,31,144,11,0,96,60,196,57,99,56,
217,135,4,72,120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
224,255,33,148,8,0,65,147,12,0,97,147,28,0,225,147,166,2,8,124,
36,0,1,144,24,0,193,147,120,51,222,124,120,243,195,127,16,0,129,147,
120,35,156,124,0,0,128,56,20,0,161,147,120,43,189,124,0,2,192,56,
61,83,7,72,121,27,127,124,200,0,130,64,0,0,29,136,2,0,253,136,
3,0,221,136,1,0,61,137,46,64,41,85,14,192,198,84,11,0,96,60,
220,57,99,56,30,128,231,84,20,58,6,125,20,74,72,125,20,2,74,127,
120,211,68,127,53,135,4,72,5,0,157,137,4,0,221,136,46,64,140,85,
20,50,172,124,63,252,187,84,120,0,130,65,128,0,27,40,8,0,129,64,
128,0,96,59,120,219,100,127,11,0,96,60,244,57,99,56,1,135,4,72,
6,0,160,56,60,8,106,87,6,0,10,56,0,0,5,124,254,255,90,59,
44,0,128,64,2,0,26,164,60,8,106,87,112,70,9,124,174,41,29,124,
20,234,5,125,2,0,165,56,6,0,10,56,0,0,5,124,1,0,40,153,
220,255,128,65,120,243,195,127,0,0,128,56,120,235,165,127,0,2,192,56,
13,81,7,72,120,27,127,124,0,0,156,129,1,0,140,57,0,0,156,145,
24,0,193,131,20,0,161,131,16,0,129,131,120,251,227,127,28,0,225,131,
36,0,1,128,12,0,97,131,8,0,65,131,166,3,8,124,32,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,88,0,130,64,
36,0,62,129,0,72,31,124,88,0,128,64,40,0,222,128,24,0,126,128,
16,0,190,128,28,0,158,56,125,254,255,75,12,0,254,128,0,0,3,44,
60,8,230,87,46,59,102,124,16,0,130,65,32,0,30,129,1,0,8,57,
32,0,30,145,36,0,62,129,1,0,255,59,0,72,31,124,192,255,128,65,
16,0,0,72,32,0,94,129,1,0,74,57,32,0,94,145,152,128,141,129,
1,0,140,56,11,0,96,60,24,58,99,56,152,128,141,144,213,133,4,72,
32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
81,199,255,75,255,7,192,87,12,0,130,65,120,251,227,127,145,113,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,157,111,4,72,
121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,57,201,255,75,12,0,0,60,64,19,0,48,
48,0,31,144,11,0,96,60,44,58,99,56,233,132,4,72,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,
24,0,193,147,28,0,225,147,166,2,8,124,36,0,1,144,12,0,97,147,
120,35,155,124,0,0,128,56,20,0,161,147,120,43,189,124,120,51,195,124,
0,2,192,56,85,80,7,72,121,27,127,124,152,0,130,64,0,0,125,137,
2,0,29,136,3,0,93,137,1,0,61,137,46,64,41,85,14,192,74,85,
11,0,96,60,104,58,99,56,30,128,0,84,20,2,138,125,20,74,76,125,
20,90,138,127,120,227,132,127,77,132,4,72,5,0,157,137,4,0,189,136,
46,64,140,85,20,42,204,127,63,4,222,87,72,0,130,65,0,1,30,40,
8,0,129,64,0,1,192,59,120,243,196,127,11,0,96,60,68,58,99,56,
25,132,4,72,0,0,224,56,0,240,7,124,255,255,156,59,28,0,128,64,
20,234,199,124,1,0,231,56,0,240,7,124,6,0,6,137,1,0,28,157,
236,255,128,65,0,0,59,129,1,0,41,57,0,0,59,145,24,0,193,131,
20,0,161,131,120,251,227,127,28,0,225,131,36,0,1,128,16,0,129,131,
12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,88,0,130,64,36,0,62,129,0,72,31,124,
88,0,128,64,40,0,222,128,24,0,126,128,16,0,190,128,28,0,158,56,
185,254,255,75,12,0,254,128,0,0,3,44,60,8,230,87,46,59,102,124,
16,0,130,65,32,0,30,129,1,0,8,57,32,0,30,145,36,0,62,129,
1,0,255,59,0,72,31,124,192,255,128,65,16,0,0,72,32,0,94,129,
1,0,74,57,32,0,94,145,152,128,141,129,1,0,140,56,11,0,96,60,
132,58,99,56,152,128,141,144,33,131,4,72,32,0,30,128,0,0,0,44,
0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,157,196,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,221,110,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,
20,0,130,64,52,0,96,56,233,108,4,72,121,27,127,124,52,0,130,65,
8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,
133,198,255,75,12,0,0,60,40,19,0,48,48,0,31,144,11,0,96,60,
152,58,99,56,53,130,4,72,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,224,255,33,148,12,0,97,147,24,0,193,147,28,0,225,147,
166,2,8,124,36,0,1,144,20,0,161,147,120,51,221,124,120,235,163,127,
16,0,129,147,120,35,156,124,0,0,128,56,8,0,65,147,120,43,186,124,
0,2,192,56,153,77,7,72,121,27,127,124,180,0,130,64,0,0,122,137,
2,0,26,136,3,0,90,137,1,0,58,137,46,64,41,85,14,192,74,85,
11,0,96,60,176,58,99,56,30,128,0,84,20,2,138,125,20,74,76,125,
20,90,106,127,120,219,100,127,145,129,4,72,5,0,154,137,4,0,186,136,
46,64,140,85,20,42,204,127,63,4,222,87,100,0,130,65,0,1,30,40,
8,0,129,64,0,1,192,59,120,243,196,127,11,0,96,60,200,58,99,56,
93,129,4,72,6,0,224,56,6,0,30,57,0,64,7,124,255,255,123,59,
28,0,128,64,1,0,219,140,6,0,30,57,174,57,218,124,1,0,231,56,
0,64,7,124,236,255,128,65,120,235,163,127,0,0,128,56,120,211,69,127,
0,2,192,56,125,75,7,72,120,27,127,124,0,0,60,129,1,0,41,57,
0,0,60,145,24,0,193,131,20,0,161,131,16,0,129,131,120,251,227,127,
28,0,225,131,36,0,1,128,12,0,97,131,8,0,65,131,166,3,8,124,
32,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,
88,0,130,64,36,0,62,129,0,72,31,124,88,0,128,64,40,0,222,128,
24,0,126,128,16,0,190,128,28,0,158,56,145,254,255,75,12,0,254,128,
0,0,3,44,60,8,230,87,46,59,102,124,16,0,130,65,32,0,30,129,
1,0,8,57,32,0,30,145,36,0,62,129,1,0,255,59,0,72,31,124,
192,255,128,65,16,0,0,72,32,0,94,129,1,0,74,57,32,0,94,145,
152,128,141,129,1,0,140,56,11,0,96,60,236,58,99,56,152,128,141,144,
69,128,4,72,32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,
19,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,
0,0,128,56,193,193,255,75,255,7,192,87,12,0,130,65,120,251,227,127,
1,108,4,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,
24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,
121,27,127,124,120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,
13,106,4,72,121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,
120,235,164,127,120,227,134,127,8,0,161,56,169,195,255,75,12,0,0,60,
16,19,0,48,48,0,31,144,11,0,96,60,0,59,99,56,89,127,4,72,
120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,
16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,232,253,33,148,
16,2,193,147,20,2,225,147,166,2,8,124,28,2,1,144,12,2,161,147,
0,0,160,59,166,0,224,127,94,4,230,87,36,1,192,124,13,16,7,72,
232,3,64,57,1,0,128,56,29,0,0,60,252,4,0,48,9,0,128,61,
248,112,140,57,8,0,163,147,4,0,131,145,36,0,3,144,40,0,131,144,
20,0,67,145,120,27,126,124,205,21,7,72,2,0,126,161,0,1,107,97,
2,0,126,177,2,0,158,161,120,243,196,127,8,0,161,56,120,235,163,127,
0,8,140,97,2,0,158,177,249,201,4,72,2,0,96,60,160,134,99,56,
173,19,4,72,134,50,134,124,120,35,131,124,57,7,96,84,76,0,130,65,
0,128,231,115,166,0,0,125,94,4,8,85,120,59,8,125,36,1,0,125,
120,243,195,127,109,17,7,72,0,0,32,57,0,0,62,177,120,243,195,127,
73,14,8,72,2,0,96,60,160,134,99,56,101,19,4,72,134,50,134,124,
120,35,131,124,57,7,106,84,8,0,130,65,106,48,160,59,20,2,225,131,
16,2,193,131,28,2,1,128,120,235,163,127,12,2,161,131,166,3,8,124,
24,2,33,56,32,0,128,78,208,255,33,148,12,0,225,146,24,0,65,147,
28,0,97,147,36,0,161,147,44,0,225,147,166,2,8,124,52,0,1,144,
16,0,1,147,120,27,120,124,32,0,129,147,120,35,156,124,20,0,33,147,
0,32,32,63,0,0,57,59,40,0,193,147,0,0,192,59,134,50,134,124,
120,35,131,124,185,6,105,84,255,255,9,48,17,73,128,125,40,0,130,65,
120,195,3,127,11,0,128,60,176,60,132,56,61,41,2,72,11,0,96,60,
248,60,99,56,173,125,4,72,106,48,192,59,120,2,0,72,113,254,255,75,
120,27,126,124,106,48,30,44,64,0,130,64,32,0,128,56,0,0,132,60,
134,51,128,124,16,0,128,56,0,0,132,60,134,51,128,124,120,195,3,127,
11,0,224,63,140,59,255,59,120,251,228,127,237,40,2,72,120,251,227,127,
97,125,4,72,106,48,192,59,44,2,0,72,166,0,224,126,94,4,235,86,
36,1,96,125,1,0,96,56,33,67,7,72,232,3,96,56,73,18,4,72,
134,50,134,124,120,35,131,124,181,6,96,84,64,0,130,64,32,0,128,56,
0,0,132,60,134,51,128,124,16,0,128,56,0,0,132,60,134,51,128,124,
120,195,3,127,11,0,224,63,196,59,255,59,120,251,228,127,133,40,2,72,
120,251,227,127,249,124,4,72,106,48,192,59,196,1,0,72,247,6,127,84,
0,0,96,56,193,66,7,72,0,0,31,44,64,0,130,65,32,0,128,56,
0,0,132,60,134,51,128,124,16,0,128,56,0,0,132,60,134,51,128,124,
120,195,3,127,11,0,224,63,80,59,255,59,120,251,228,127,53,40,2,72,
120,251,227,127,169,124,4,72,106,48,192,59,116,1,0,72,11,0,224,63,
24,59,255,59,232,3,96,56,157,17,4,72,32,0,128,56,0,0,132,60,
134,51,128,124,232,3,96,56,137,17,4,72,134,50,134,124,120,35,131,124,
181,6,96,84,48,0,130,65,32,0,128,56,0,0,132,60,134,51,128,124,
120,195,3,127,11,0,128,60,0,60,132,56,213,39,2,72,120,251,227,127,
73,124,4,72,106,48,192,59,20,1,0,72,16,0,89,131,20,0,121,131,
1,0,96,56,20,0,89,147,16,0,121,147,5,66,7,72,232,3,96,56,
45,17,4,72,134,50,134,124,120,35,131,124,247,6,96,84,64,0,130,64,
32,0,128,56,0,0,132,60,134,51,128,124,16,0,128,56,0,0,132,60,
134,51,128,124,120,195,3,127,11,0,224,63,60,60,255,59,120,251,228,127,
105,39,2,72,120,251,227,127,221,123,4,72,106,48,192,59,168,0,0,72,
181,6,125,84,0,0,96,56,165,65,7,72,0,0,29,44,64,0,130,65,
32,0,128,56,0,0,132,60,134,51,128,124,16,0,128,56,0,0,132,60,
134,51,128,124,120,195,3,127,11,0,224,63,116,60,255,59,120,251,228,127,
25,39,2,72,120,251,227,127,141,123,4,72,106,48,192,59,88,0,0,72,
232,3,96,56,137,16,4,72,16,0,128,56,0,0,132,60,134,51,128,124,
2,0,96,60,160,134,99,56,113,16,4,72,134,50,134,124,120,35,131,124,
247,6,96,84,40,0,130,65,32,0,128,56,0,0,132,60,134,51,128,124,
120,195,3,127,120,251,228,127,193,38,2,72,120,251,227,127,53,123,4,72,
106,48,192,59,16,0,89,147,20,0,121,147,0,128,232,114,166,0,64,125,
94,4,74,85,120,67,74,125,36,1,64,125,0,0,156,129,1,0,140,57,
0,0,156,145,36,0,161,131,24,0,65,131,120,243,195,127,40,0,193,131,
28,0,97,131,20,0,33,131,32,0,129,131,44,0,225,131,52,0,1,128,
16,0,1,131,12,0,225,130,166,3,8,124,48,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,84,0,130,64,36,0,62,129,
0,72,31,124,84,0,128,64,24,0,126,128,52,0,190,128,28,0,158,56,
113,252,255,75,12,0,254,128,0,0,3,44,60,8,230,87,46,59,102,124,
16,0,130,65,32,0,30,129,1,0,8,57,32,0,30,145,36,0,62,129,
1,0,255,59,0,72,31,124,196,255,128,65,16,0,0,72,32,0,94,129,
1,0,74,57,32,0,94,145,152,128,141,129,1,0,140,56,11,0,96,60,
64,61,99,56,152,128,141,144,57,122,4,72,32,0,30,128,0,0,0,44,
0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,181,187,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,245,101,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,165,131,121,27,127,124,120,51,222,124,120,35,156,124,
20,0,130,64,56,0,96,56,1,100,4,72,121,27,127,124,92,0,130,65,
8,0,161,147,120,251,227,127,120,227,132,127,120,243,198,127,8,0,161,56,
157,189,255,75,44,0,159,161,255,232,139,85,12,0,64,61,248,18,74,57,
48,0,95,145,52,0,127,145,12,0,130,64,1,0,0,56,52,0,31,144,
11,0,96,60,84,61,99,56,53,121,4,72,52,0,159,128,11,0,96,60,
128,61,99,56,37,121,4,72,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,160,255,33,148,64,0,1,147,166,2,8,124,100,0,1,144,
72,0,65,147,120,43,186,124,80,0,129,147,120,59,252,124,84,0,161,147,
120,67,29,125,40,0,97,144,88,0,193,147,0,0,192,59,44,0,193,147,
48,0,97,144,52,0,97,144,76,0,97,147,120,51,219,124,56,0,97,147,
60,0,225,146,68,0,33,147,120,35,153,124,92,0,225,147,1,0,224,59,
48,200,247,127,157,9,7,72,120,251,228,127,120,27,120,124,232,3,0,56,
29,0,128,61,252,4,140,57,9,0,96,61,248,112,107,57,8,0,195,147,
4,0,99,145,36,0,131,145,40,0,227,146,20,0,3,144,93,15,7,72,
2,0,24,160,0,1,0,96,2,0,24,176,2,0,216,160,24,0,193,147,
120,203,35,127,36,0,129,147,40,0,1,57,8,0,161,56,120,235,164,127,
126,186,96,87,12,0,1,145,0,8,198,96,2,0,216,176,8,0,1,147,
16,0,65,147,20,0,193,147,28,0,1,176,32,0,193,179,125,196,4,72,
120,195,3,127,5,11,7,72,0,0,216,179,120,27,127,124,120,195,3,127,
225,7,8,72,0,0,31,44,8,0,130,65,19,48,224,59,80,0,129,131,
68,0,33,131,72,0,65,131,84,0,161,131,120,251,227,127,92,0,225,131,
76,0,97,131,88,0,193,131,100,0,1,128,64,0,1,131,60,0,225,130,
166,3,8,124,96,0,33,56,32,0,128,78,224,255,33,148,166,2,8,124,
36,0,1,144,24,0,193,147,120,43,190,124,0,80,160,56,28,0,225,147,
120,51,223,124,0,2,192,56,20,0,161,147,120,35,157,124,120,59,228,124,
13,0,224,56,16,0,129,147,120,27,124,124,0,0,96,56,120,27,104,124,
117,254,255,75,0,0,3,44,132,0,130,64,120,243,196,127,0,0,96,56,
0,2,160,56,97,52,7,72,0,0,3,44,108,0,130,64,174,24,31,124,
255,0,0,104,174,25,31,124,1,0,99,56,0,2,3,44,236,255,128,65,
120,243,195,127,120,251,228,127,0,2,160,56,8,0,193,56,117,214,255,75,
0,0,3,44,56,0,130,65,8,0,161,128,174,40,223,124,174,40,254,124,
120,227,131,127,11,0,128,63,180,61,156,56,133,34,2,72,8,0,129,128,
174,32,222,124,174,32,191,124,180,61,124,56,237,118,4,72,104,48,96,56,
0,0,157,129,1,0,140,57,0,0,157,145,24,0,193,131,28,0,225,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,92,0,130,64,
36,0,94,129,0,80,31,124,92,0,128,64,20,0,222,128,44,0,254,160,
24,0,126,128,16,0,190,128,28,0,158,56,193,254,255,75,12,0,30,129,
0,0,3,44,60,8,231,87,46,67,103,124,16,0,130,65,32,0,62,129,
1,0,41,57,32,0,62,145,36,0,94,129,1,0,255,59,0,80,31,124,
188,255,128,65,16,0,0,72,32,0,126,129,1,0,107,57,32,0,126,145,
152,128,141,129,1,0,140,56,11,0,96,60,244,61,99,56,152,128,141,144,
29,118,4,72,32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,
19,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,
0,0,128,56,153,183,255,75,255,7,192,87,12,0,130,65,120,251,227,127,
217,97,4,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,0,0,96,57,1,0,11,56,174,89,3,124,
120,3,11,124,0,2,11,44,240,255,128,65,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,
20,0,130,64,52,0,96,56,201,95,4,72,121,27,127,124,176,0,130,65,
8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,
101,185,255,75,12,0,0,60,224,18,0,48,48,0,31,144,11,0,96,60,
8,62,99,56,21,117,4,72,44,0,159,160,11,0,96,60,28,62,99,56,
5,117,4,72,20,0,127,128,97,255,255,75,20,0,159,128,0,2,160,56,
0,0,96,56,153,50,7,72,0,0,3,44,8,0,127,176,76,0,130,64,
16,0,127,128,255,0,128,56,233,180,255,75,16,0,159,128,0,2,96,56,
120,27,101,124,113,50,7,72,0,0,3,44,8,0,127,176,36,0,130,64,
44,0,159,160,0,2,96,56,0,80,160,56,11,0,224,56,6,0,0,57,
120,27,102,124,161,251,255,75,8,0,127,176,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,166,2,8,124,
28,0,1,144,20,0,225,147,120,35,159,124,12,0,161,147,120,43,189,124,
0,0,128,57,8,0,129,177,8,0,97,56,81,95,2,72,8,0,129,160,
120,27,126,124,11,0,96,60,44,62,99,56,49,116,4,72,0,0,127,129,
8,0,1,160,10,0,29,176,1,0,107,57,0,0,127,145,28,0,1,128,
20,0,225,131,120,243,195,127,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,
84,0,130,64,36,0,62,129,0,72,31,124,84,0,128,64,24,0,126,128,
4,0,190,128,28,0,158,56,77,255,255,75,12,0,254,128,0,0,3,44,
60,8,230,87,46,59,102,124,16,0,130,65,32,0,30,129,1,0,8,57,
32,0,30,145,36,0,62,129,1,0,255,59,0,72,31,124,196,255,128,65,
16,0,0,72,32,0,94,129,1,0,74,57,32,0,94,145,152,128,141,129,
1,0,140,56,11,0,96,60,68,62,99,56,152,128,141,144,101,115,4,72,
32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
225,180,255,75,255,7,192,87,12,0,130,65,120,251,227,127,33,95,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,45,93,4,72,
121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,201,182,255,75,12,0,0,60,56,18,0,48,
48,0,31,144,11,0,96,60,88,62,99,56,121,114,4,72,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
240,255,33,148,0,0,0,56,8,0,1,144,8,0,193,56,137,209,255,75,
20,0,1,128,16,0,33,56,166,3,8,124,32,0,128,78,224,255,33,148,
166,2,8,124,36,0,1,144,28,0,225,147,120,51,223,124,12,0,97,147,
120,59,251,124,16,0,129,147,120,27,124,124,20,0,161,147,120,35,157,124,
24,0,193,147,120,43,190,124,0,2,160,56,153,47,7,72,0,0,3,44,
136,0,130,64,120,227,131,127,120,251,228,127,120,219,101,127,0,2,192,56,
11,0,224,56,6,0,0,57,205,248,255,75,0,0,3,44,100,0,130,64,
120,243,195,127,238,0,128,56,201,177,255,75,120,227,131,127,120,243,196,127,
0,2,160,56,81,47,7,72,0,0,3,44,64,0,130,64,120,227,131,127,
120,251,228,127,120,219,101,127,0,2,192,56,12,0,224,56,0,0,0,57,
133,248,255,75,0,0,3,44,28,0,130,64,120,227,131,127,120,243,196,127,
0,2,160,56,113,46,7,72,0,0,3,44,40,0,130,65,20,0,161,131,
24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,120,235,163,127,120,243,196,127,
0,2,160,56,221,254,255,75,20,0,161,131,24,0,193,131,28,0,225,131,
36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,
32,0,128,78,0,0,128,57,165,0,0,56,174,97,3,124,1,0,140,57,
0,2,12,44,240,255,128,65,32,0,128,78,224,255,33,148,166,2,8,124,
36,0,1,144,28,0,225,147,120,35,159,124,12,0,97,147,120,43,187,124,
16,0,129,147,120,51,220,124,24,0,193,147,120,27,126,124,20,0,161,147,
120,59,253,124,120,235,163,127,105,49,0,72,0,0,3,44,56,0,130,64,
120,243,195,127,11,0,192,63,120,62,158,56,120,235,165,127,25,28,2,72,
120,62,126,56,120,235,164,127,137,112,4,72,0,0,159,129,1,0,140,57,
105,48,96,56,0,0,159,145,132,0,0,72,120,219,99,127,18,0,128,56,
125,176,255,75,120,219,100,127,120,227,133,127,120,235,166,127,0,0,96,56,
0,80,224,56,45,254,255,75,0,0,3,44,76,0,130,64,120,219,99,127,
165,250,255,75,120,219,100,127,120,227,133,127,120,235,166,127,0,0,96,56,
0,80,224,56,5,254,255,75,0,0,3,44,36,0,130,64,120,219,99,127,
21,255,255,75,120,219,100,127,120,227,133,127,120,235,166,127,0,0,96,56,
0,80,224,56,221,253,255,75,0,0,159,129,1,0,140,57,0,0,159,145,
20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,
12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,92,0,130,64,36,0,94,129,0,80,31,124,
92,0,128,64,20,0,222,128,44,0,254,160,24,0,126,128,16,0,190,128,
28,0,158,56,161,254,255,75,12,0,30,129,0,0,3,44,60,8,231,87,
46,67,103,124,16,0,130,65,32,0,62,129,1,0,41,57,32,0,62,145,
36,0,94,129,1,0,255,59,0,80,31,124,188,255,128,65,16,0,0,72,
32,0,126,129,1,0,107,57,32,0,126,145,152,128,141,129,1,0,140,56,
11,0,96,60,144,62,99,56,152,128,141,144,49,111,4,72,32,0,30,128,
0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,173,176,255,75,
255,7,192,87,12,0,130,65,120,251,227,127,237,90,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,0,0,133,131,121,27,127,124,120,51,221,124,
120,35,158,124,20,0,130,64,52,0,96,56,249,88,4,72,121,27,127,124,
68,0,130,65,8,0,129,147,120,251,227,127,120,243,196,127,120,235,166,127,
8,0,161,56,149,178,255,75,12,0,0,60,32,18,0,48,48,0,31,144,
11,0,96,60,164,62,99,56,69,110,4,72,44,0,159,160,11,0,96,60,
196,62,99,56,53,110,4,72,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,224,255,33,148,20,0,161,147,166,2,8,124,36,0,1,144,
12,0,97,147,120,51,219,124,16,0,129,147,120,59,252,124,24,0,193,147,
120,27,126,124,28,0,225,147,120,35,159,124,8,0,65,147,120,43,186,124,
0,2,160,56,125,43,7,72,0,0,3,44,44,0,130,65,24,0,193,131,
16,0,129,131,20,0,161,131,28,0,225,131,36,0,1,128,12,0,97,131,
8,0,65,131,166,3,8,124,32,0,33,56,32,0,128,78,120,27,125,124,
0,216,29,124,68,0,128,64,120,235,163,127,69,46,0,72,0,0,3,44,
40,0,130,65,120,243,195,127,62,4,164,87,120,227,133,127,0,2,192,56,
11,0,224,56,6,0,0,57,109,244,255,75,0,0,3,44,156,255,130,64,
1,0,189,59,0,216,29,124,196,255,128,65,0,0,160,59,0,216,29,124,
128,0,128,64,120,211,67,127,238,0,128,56,81,173,255,75,120,243,195,127,
120,211,68,127,0,2,160,56,217,42,7,72,0,0,3,44,96,255,130,64,
120,243,195,127,62,4,164,87,120,227,133,127,0,2,192,56,12,0,224,56,
0,0,0,57,13,244,255,75,120,243,195,127,120,211,68,127,0,2,160,56,
1,42,7,72,0,0,3,44,44,255,130,64,120,251,227,127,120,211,68,127,
0,2,160,56,145,250,255,75,0,0,3,44,20,255,130,64,1,0,189,59,
0,216,29,124,136,255,128,65,16,0,129,131,24,0,193,131,28,0,225,131,
20,0,161,131,12,0,97,131,36,0,1,128,8,0,65,131,0,0,96,56,
166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,24,0,193,147,
120,59,254,124,20,0,161,147,0,0,160,59,0,240,29,124,166,2,8,124,
36,0,1,144,28,0,225,147,120,27,127,124,8,0,65,147,120,35,154,124,
12,0,97,147,120,43,187,124,16,0,129,147,120,51,220,124,84,0,128,64,
120,235,163,127,13,45,0,72,0,0,3,44,56,0,130,64,120,251,227,127,
11,0,224,63,212,62,159,56,120,243,197,127,189,23,2,72,212,62,127,56,
120,243,196,127,45,108,4,72,0,0,154,129,1,0,140,57,105,48,96,56,
0,0,154,145,128,0,0,72,1,0,189,59,0,240,29,124,180,255,128,65,
120,219,99,127,17,0,128,56,21,172,255,75,120,219,100,127,120,227,133,127,
120,243,198,127,0,0,96,56,0,80,224,56,221,253,255,75,120,219,99,127,
69,246,255,75,120,219,100,127,120,227,133,127,120,243,198,127,0,0,96,56,
0,80,224,56,189,253,255,75,120,219,99,127,189,250,255,75,120,219,100,127,
120,227,133,127,120,243,198,127,0,0,96,56,0,80,224,56,157,253,255,75,
0,0,154,129,1,0,140,57,0,0,154,145,24,0,193,131,16,0,129,131,
20,0,161,131,28,0,225,131,36,0,1,128,12,0,97,131,8,0,65,131,
166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,
166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,
0,0,31,44,92,0,130,64,36,0,94,129,0,80,31,124,92,0,128,64,
20,0,222,128,44,0,254,160,24,0,126,128,16,0,190,128,28,0,158,56,
145,254,255,75,12,0,30,129,0,0,3,44,60,8,231,87,46,67,103,124,
16,0,130,65,32,0,62,129,1,0,41,57,32,0,62,145,36,0,94,129,
1,0,255,59,0,80,31,124,188,255,128,65,16,0,0,72,32,0,126,129,
1,0,107,57,32,0,126,145,152,128,141,129,1,0,140,56,11,0,96,60,
12,63,99,56,152,128,141,144,213,106,4,72,32,0,30,128,0,0,0,44,
0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,81,172,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,145,86,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,133,131,121,27,127,124,120,51,221,124,120,35,158,124,
20,0,130,64,52,0,96,56,157,84,4,72,121,27,127,124,68,0,130,65,
8,0,129,147,120,251,227,127,120,243,196,127,120,235,166,127,8,0,161,56,
57,174,255,75,12,0,0,60,8,18,0,48,48,0,31,144,11,0,96,60,
64,63,99,56,233,105,4,72,44,0,159,160,11,0,96,60,32,63,99,56,
217,105,4,72,120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
0,0,132,129,0,0,96,56,1,0,140,57,0,0,132,145,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
8,0,127,169,0,0,11,44,80,0,130,64,36,0,255,128,0,56,11,124,
80,0,128,64,24,0,127,128,28,0,159,56,185,255,255,75,12,0,31,128,
0,0,3,44,60,8,108,85,46,3,108,124,16,0,130,65,32,0,223,128,
1,0,198,56,32,0,223,144,36,0,255,128,1,0,107,57,0,56,11,124,
200,255,128,65,16,0,0,72,32,0,63,129,1,0,41,57,32,0,63,145,
152,128,77,129,1,0,138,56,11,0,96,60,96,63,99,56,152,128,141,144,
17,105,4,72,32,0,31,128,0,0,0,44,0,0,96,56,8,0,130,65,
19,48,96,56,20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
145,170,255,75,255,7,192,87,12,0,130,65,120,251,227,127,209,84,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,221,82,4,72,
121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,121,172,255,75,12,0,0,60,240,17,0,48,
48,0,31,144,11,0,96,60,116,63,99,56,41,104,4,72,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,20,0,161,147,
120,51,221,124,24,0,193,147,120,59,254,124,16,0,129,147,120,43,188,124,
166,2,8,124,36,0,1,144,120,27,96,124,120,227,131,127,28,0,225,147,
120,35,159,124,120,3,4,124,221,167,255,75,120,235,163,127,213,167,255,75,
120,227,132,127,0,0,96,56,0,2,160,56,93,37,7,72,0,0,3,44,
40,0,130,64,120,227,131,127,120,251,228,127,177,167,255,75,120,227,132,127,
0,2,96,56,120,27,101,124,57,37,7,72,0,0,3,44,36,0,130,65,
120,243,195,127,11,0,224,63,156,63,159,56,249,18,2,72,156,63,127,56,
109,103,4,72,39,48,96,56,140,0,0,72,120,227,132,127,0,0,96,56,
8,0,160,56,93,36,7,72,0,0,3,44,36,0,130,65,120,243,195,127,
11,0,224,63,180,63,159,56,193,18,2,72,180,63,127,56,53,103,4,72,
39,48,96,56,84,0,0,72,120,227,131,127,120,235,164,127,8,0,160,56,
8,0,193,56,105,198,255,75,0,0,3,44,56,0,130,65,8,0,161,128,
174,40,253,124,174,40,220,124,11,0,224,63,120,243,195,127,204,63,159,56,
121,18,2,72,8,0,129,128,174,32,221,124,174,32,188,124,204,63,127,56,
225,102,4,72,37,48,96,56,24,0,193,131,28,0,225,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
1,0,224,56,0,0,0,57,120,67,10,125,56,24,75,85,20,26,43,125,
4,0,9,145,60,8,8,85,254,15,235,84,120,91,8,125,0,0,233,144,
60,8,231,84,121,59,0,125,12,0,130,64,1,0,224,56,0,0,0,57,
1,0,74,57,64,0,10,40,200,255,128,65,32,0,128,78,232,255,33,148,
8,0,129,147,12,0,161,147,16,0,193,147,20,0,225,147,0,0,131,160,
0,0,192,59,3,0,132,57,1,0,224,63,22,96,126,125,214,97,159,125,
1,0,64,57,20,98,11,125,2,0,132,57,22,96,126,125,214,97,138,125,
20,98,139,125,0,0,94,49,20,97,104,125,30,128,140,84,1,0,140,61,
112,254,134,125,20,96,234,124,4,0,68,57,0,0,67,177,12,0,161,131,
16,0,193,131,8,0,129,131,20,0,225,131,20,49,11,125,20,32,103,125,
120,91,99,125,148,1,136,125,120,99,132,125,24,0,33,56,32,0,128,78,
56,0,139,84,20,26,139,125,0,0,172,144,4,0,204,144,32,0,128,78,
56,0,140,84,110,24,108,124,4,0,140,128,32,0,128,78,208,255,33,148,
40,0,193,147,120,35,158,124,12,0,225,146,0,2,224,58,64,240,23,124,
16,0,1,147,20,0,33,147,24,0,65,147,28,0,97,147,32,0,129,147,
36,0,161,147,120,27,125,124,44,0,225,147,120,43,191,124,166,2,8,124,
52,0,1,144,0,0,0,56,17,0,96,57,8,0,97,177,112,0,128,64,
120,235,163,127,0,0,128,56,113,165,255,75,8,0,97,56,233,254,255,75,
120,27,101,124,120,235,163,127,120,35,134,124,0,0,128,56,101,255,255,75,
120,187,227,126,120,235,164,127,0,2,160,56,221,34,7,72,121,27,96,124,
36,0,130,65,120,251,227,127,11,0,224,63,92,64,159,56,157,16,2,72,
92,64,127,56,17,101,4,72,39,48,0,56,60,1,0,72,60,8,247,86,
64,240,23,124,152,255,128,65,0,2,224,58,120,187,252,126,64,240,28,124,
17,0,128,57,8,0,129,177,24,1,128,64,120,227,131,127,120,235,164,127,
32,0,160,56,221,33,7,72,121,27,96,124,36,0,130,65,120,251,227,127,
11,0,224,63,116,64,159,56,65,16,2,72,116,64,127,56,181,100,4,72,
39,48,0,56,224,0,0,72,120,235,163,127,0,0,128,56,217,254,255,75,
64,184,28,124,120,35,155,124,120,27,122,124,120,0,130,64,8,0,97,56,
29,254,255,75,120,35,153,124,64,200,27,124,120,27,120,124,12,0,130,64,
64,192,26,124,76,0,130,65,120,251,227,127,11,0,224,63,28,64,159,56,
120,187,229,126,120,195,7,127,120,203,40,127,120,211,73,127,120,219,106,127,
209,15,2,72,28,64,127,56,120,187,228,126,120,195,5,127,120,203,38,127,
120,211,71,127,120,219,104,127,49,100,4,72,38,48,0,56,92,0,0,72,
60,8,247,86,0,2,156,59,72,0,0,72,121,211,106,127,60,0,130,65,
120,251,227,127,11,0,224,63,140,64,159,56,120,187,229,126,120,211,71,127,
120,219,104,127,125,15,2,72,140,64,127,56,120,187,228,126,120,211,69,127,
120,219,102,127,229,99,4,72,38,48,0,56,16,0,0,72,0,2,156,59,
64,240,28,124,240,254,128,65,32,0,129,131,20,0,33,131,24,0,65,131,
36,0,161,131,28,0,97,131,120,3,3,124,52,0,1,128,16,0,1,131,
44,0,225,131,40,0,193,131,12,0,225,130,166,3,8,124,48,0,33,56,
32,0,128,78,208,255,33,148,20,0,33,147,24,0,65,147,32,0,129,147,
16,0,1,147,28,0,97,147,36,0,161,147,40,0,193,147,44,0,225,147,
166,2,8,124,52,0,1,144,56,134,13,128,0,0,0,44,120,27,121,124,
120,35,154,124,120,51,220,124,120,43,187,124,0,0,27,144,120,59,253,124,
120,67,30,125,11,0,0,63,25,27,7,72,56,134,109,128,25,192,254,75,
121,27,127,124,48,0,130,65,165,33,7,72,120,203,35,127,220,64,152,56,
165,14,2,72,220,64,120,56,25,99,4,72,0,0,154,129,1,0,140,57,
39,48,224,59,0,0,154,145,252,1,0,72,255,7,192,87,68,0,130,65,
120,227,133,127,120,235,166,127,120,203,39,127,85,0,96,56,170,0,128,56,
229,250,255,75,121,27,127,124,84,1,130,64,120,227,133,127,120,235,166,127,
120,203,39,127,170,0,96,56,85,0,128,56,197,250,255,75,121,27,127,124,
52,1,130,64,189,7,192,87,12,1,130,65,120,227,131,127,245,251,255,75,
120,235,163,127,238,0,128,56,181,162,255,75,120,227,132,127,0,0,96,56,
0,2,160,56,61,32,7,72,0,0,3,44,52,0,130,65,253,32,7,72,
120,203,35,127,11,0,224,63,244,64,159,56,249,13,2,72,244,64,127,56,
109,98,4,72,0,0,154,129,1,0,140,57,39,48,224,59,0,0,154,145,
80,1,0,72,120,235,164,127,0,0,96,56,0,2,160,56,81,31,7,72,
0,0,3,44,52,0,130,65,181,32,7,72,120,203,35,127,11,0,224,63,
12,65,159,56,177,13,2,72,12,65,127,56,37,98,4,72,0,0,154,129,
1,0,140,57,39,48,224,59,0,0,154,145,8,1,0,72,120,227,131,127,
120,235,164,127,0,2,160,56,8,0,193,56,77,193,255,75,121,27,127,124,
76,0,130,65,105,32,7,72,8,0,161,128,174,40,253,124,174,40,220,124,
11,0,224,63,120,203,35,127,36,65,159,56,89,13,2,72,8,0,129,128,
174,32,221,124,174,32,188,124,36,65,127,56,193,97,4,72,0,0,154,129,
1,0,140,57,36,48,224,59,0,0,154,145,164,0,0,72,123,7,202,87,
48,0,130,65,0,0,155,128,120,227,131,127,120,203,37,127,221,251,255,75,
121,27,127,124,24,0,130,65,1,32,7,72,0,0,154,129,1,0,140,57,
0,0,154,145,112,0,0,72,57,7,192,87,92,0,130,65,56,134,109,128,
73,190,254,75,0,0,3,44,28,0,130,64,213,31,7,72,19,0,96,60,
172,179,99,128,49,190,254,75,121,27,127,124,44,0,130,65,120,203,35,127,
220,64,152,56,193,12,2,72,220,64,120,56,53,97,4,72,0,0,154,129,
1,0,140,57,39,48,224,59,0,0,154,145,24,0,0,72,21,218,4,72,
0,0,123,144,0,0,154,129,1,0,140,57,0,0,154,145,24,0,65,131,
32,0,129,131,36,0,161,131,120,251,227,127,44,0,225,131,28,0,97,131,
40,0,193,131,52,0,1,128,20,0,33,131,16,0,1,131,166,3,8,124,
48,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,12,0,161,147,120,27,125,124,8,0,253,171,
0,0,31,44,120,35,158,124,96,0,130,64,36,0,29,128,0,0,31,124,
96,0,128,64,16,0,221,128,24,0,125,128,20,0,253,128,28,0,157,56,
120,243,200,127,148,128,173,56,241,252,255,75,12,0,93,129,0,0,3,44,
60,8,233,87,46,83,105,124,16,0,130,65,32,0,125,129,1,0,107,57,
32,0,125,145,36,0,29,128,1,0,255,59,0,0,31,124,184,255,128,65,
16,0,0,72,32,0,253,128,1,0,231,56,32,0,253,144,152,128,141,129,
1,0,140,56,11,0,96,60,116,65,99,56,152,128,141,144,45,96,4,72,
32,0,29,128,0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,
96,0,130,64,36,0,30,128,0,0,31,124,96,0,128,64,16,0,222,128,
24,0,126,128,20,0,254,128,28,0,158,56,148,128,173,56,255,255,0,57,
29,252,255,75,12,0,30,129,0,0,3,44,60,8,231,87,46,67,103,124,
16,0,130,65,32,0,62,129,1,0,41,57,32,0,62,145,36,0,30,128,
1,0,255,59,0,0,31,124,184,255,128,65,16,0,0,72,32,0,158,129,
1,0,140,57,32,0,158,145,152,128,109,129,1,0,139,56,11,0,96,60,
136,65,99,56,152,128,141,144,89,95,4,72,32,0,30,128,0,0,0,44,
0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,213,160,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,21,75,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,120,35,157,124,
20,0,130,64,52,0,96,56,33,73,4,72,121,27,127,124,52,0,130,65,
8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,8,0,161,56,
189,162,255,75,12,0,0,60,216,17,0,48,48,0,31,144,11,0,96,60,
156,65,99,56,109,94,4,72,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,121,27,127,124,166,2,8,124,
20,0,1,144,20,0,130,64,52,0,96,56,165,72,4,72,121,27,127,124,
24,0,130,65,120,251,227,127,41,164,255,75,12,0,0,60,216,17,0,48,
48,0,31,144,20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,232,255,33,148,166,2,8,124,28,0,1,144,
20,0,225,147,120,51,223,124,8,0,129,147,120,27,124,124,12,0,161,147,
120,35,157,124,16,0,193,147,120,43,190,124,0,2,160,56,109,27,7,72,
0,0,3,44,84,0,130,64,120,235,163,127,120,251,228,127,0,2,160,56,
232,0,192,56,157,206,255,75,0,0,3,44,56,0,130,64,120,235,163,127,
120,251,228,127,0,2,160,56,228,0,192,56,129,206,255,75,0,0,3,44,
28,0,130,64,120,227,131,127,120,243,196,127,0,2,160,56,121,26,7,72,
0,0,3,44,36,0,130,65,16,0,193,131,20,0,225,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
120,235,163,127,120,243,196,127,0,2,160,56,233,234,255,75,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,166,2,8,124,28,0,1,144,
20,0,225,147,120,51,223,124,8,0,129,147,120,59,252,124,16,0,193,147,
120,43,190,124,120,243,195,127,12,0,161,147,120,35,157,124,0,0,128,56,
245,156,255,75,120,243,196,127,120,251,229,127,120,227,134,127,0,0,96,56,
221,254,255,75,0,0,3,44,68,0,130,64,120,243,195,127,33,231,255,75,
120,243,196,127,120,251,229,127,120,227,134,127,0,0,96,56,185,254,255,75,
0,0,3,44,32,0,130,64,120,243,195,127,149,235,255,75,120,243,196,127,
120,251,229,127,120,227,134,127,0,0,96,56,149,254,255,75,0,0,157,129,
1,0,140,57,0,0,157,145,16,0,193,131,20,0,225,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,92,0,130,64,36,0,94,129,
0,80,31,124,92,0,128,64,20,0,222,128,44,0,254,160,24,0,126,128,
16,0,190,128,28,0,158,56,253,254,255,75,12,0,30,129,0,0,3,44,
60,8,231,87,46,67,103,124,16,0,130,65,32,0,62,129,1,0,41,57,
32,0,62,145,36,0,94,129,1,0,255,59,0,80,31,124,188,255,128,65,
16,0,0,72,32,0,126,129,1,0,107,57,32,0,126,145,152,128,141,129,
1,0,140,56,11,0,96,60,180,65,99,56,152,128,141,144,185,91,4,72,
32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
53,157,255,75,255,7,192,87,12,0,130,65,120,251,227,127,117,71,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,133,131,121,27,127,124,
120,51,221,124,120,35,158,124,20,0,130,64,52,0,96,56,129,69,4,72,
121,27,127,124,68,0,130,65,8,0,129,147,120,251,227,127,120,243,196,127,
120,235,166,127,8,0,161,56,29,159,255,75,12,0,0,60,192,17,0,48,
48,0,31,144,11,0,96,60,200,65,99,56,205,90,4,72,44,0,159,160,
11,0,96,60,244,65,99,56,189,90,4,72,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,0,0,131,144,32,0,128,78,0,0,99,128,
32,0,128,78,224,255,33,148,20,0,161,147,120,35,157,124,16,0,129,147,
166,2,8,124,36,0,1,144,0,0,0,56,120,3,28,124,0,232,28,124,
8,0,65,147,12,0,97,147,120,27,123,124,24,0,193,147,120,51,222,124,
28,0,225,147,120,59,255,124,220,0,128,64,120,251,227,127,120,219,100,127,
165,255,255,75,169,255,255,75,120,27,122,124,64,216,26,124,60,0,130,65,
120,67,3,125,11,0,192,63,68,66,158,56,120,251,229,127,120,219,102,127,
120,211,71,127,145,5,2,72,68,66,126,56,120,251,228,127,120,219,101,127,
120,211,70,127,249,89,4,72,100,48,96,56,140,0,0,72,0,0,224,56,
0,232,7,124,58,16,140,87,46,72,204,124,0,0,223,144,92,0,128,64,
0,0,126,129,58,16,234,84,46,72,138,125,64,96,11,124,56,0,130,65,
120,67,3,125,120,251,229,127,120,243,198,127,11,0,128,60,128,66,132,56,
49,5,2,72,120,251,228,127,120,243,197,127,11,0,96,60,4,66,99,56,
153,89,4,72,101,48,96,56,44,0,0,72,1,0,231,56,0,232,7,124,
1,0,222,63,172,255,128,65,1,0,156,59,0,232,28,124,1,0,255,63,
120,43,190,124,44,255,128,65,120,3,3,124,24,0,193,131,16,0,129,131,
20,0,161,131,28,0,225,131,36,0,1,128,12,0,97,131,8,0,65,131,
166,3,8,124,32,0,33,56,32,0,128,78,208,255,33,148,32,0,129,147,
44,0,225,147,166,2,8,124,52,0,1,144,24,0,65,147,120,35,154,124,
12,0,225,146,1,0,224,62,170,170,247,58,20,0,33,147,40,0,193,147,
120,75,62,125,120,243,217,127,28,0,97,147,120,243,219,127,16,0,1,147,
120,27,120,124,36,0,161,147,120,67,29,125,58,16,163,87,21,69,4,72,
0,0,64,57,0,232,10,124,120,27,124,124,32,0,128,64,58,16,76,85,
1,0,74,57,0,232,10,124,0,0,25,128,1,0,57,63,46,225,12,124,
232,255,128,65,120,235,164,127,120,243,197,127,120,243,217,127,120,203,38,127,
120,219,103,127,120,195,8,127,120,227,137,127,0,0,96,56,21,254,255,75,
121,27,127,124,120,0,130,64,120,235,164,127,120,243,197,127,120,203,38,127,
120,219,103,127,120,195,8,127,120,227,137,127,85,85,119,56,237,253,255,75,
121,27,127,124,80,0,130,64,120,235,164,127,120,243,197,127,120,203,38,127,
120,219,103,127,120,195,8,127,120,227,137,127,85,85,96,56,197,253,255,75,
121,27,127,124,40,0,130,64,120,235,164,127,120,243,197,127,120,203,38,127,
120,219,103,127,120,195,8,127,120,227,137,127,120,187,227,126,157,253,255,75,
120,27,127,124,120,227,131,127,69,68,4,72,0,0,122,129,1,0,107,57,
0,0,122,145,36,0,161,131,24,0,65,131,28,0,97,131,40,0,193,131,
32,0,129,131,20,0,33,131,120,251,227,127,44,0,225,131,52,0,1,128,
16,0,1,131,12,0,225,130,166,3,8,124,48,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,100,0,130,64,36,0,30,128,
0,0,31,124,100,0,128,64,68,0,62,129,52,0,190,128,56,0,222,128,
60,0,254,128,24,0,126,128,64,0,30,129,28,0,158,56,69,254,255,75,
12,0,94,129,0,0,3,44,60,8,233,87,46,83,105,124,16,0,130,65,
32,0,126,129,1,0,107,57,32,0,126,145,36,0,30,128,1,0,255,59,
0,0,31,124,180,255,128,65,16,0,0,72,32,0,254,128,1,0,231,56,
32,0,254,144,152,128,141,129,1,0,140,56,11,0,96,60,196,66,99,56,
152,128,141,144,41,87,4,72,32,0,30,129,0,0,8,44,0,0,96,56,
8,0,130,65,19,48,96,56,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,
28,0,130,65,0,0,128,56,165,152,255,75,255,7,192,87,12,0,130,65,
120,251,227,127,229,66,4,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,
20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,
0,0,165,131,121,27,127,124,120,51,222,124,120,35,156,124,20,0,130,64,
72,0,96,56,241,64,4,72,121,27,127,124,108,0,130,65,8,0,161,147,
120,251,227,127,120,227,132,127,120,243,198,127,8,0,161,56,141,154,255,75,
12,0,0,60,168,17,0,48,48,0,31,144,11,0,96,60,216,66,99,56,
61,86,4,72,0,0,128,60,8,0,132,56,52,0,159,144,127,0,160,60,
0,0,165,56,56,0,191,144,80,40,196,124,60,0,223,144,68,0,159,144,
62,132,199,84,64,0,255,144,11,0,96,60,232,66,99,56,5,86,4,72,
120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,
16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,
28,0,225,147,166,2,8,124,36,0,1,144,16,0,129,147,120,35,156,124,
24,0,193,147,120,51,222,124,12,0,97,147,120,27,123,124,20,0,161,147,
120,43,189,124,120,235,163,127,13,224,255,75,0,0,128,57,238,0,0,56,
174,97,29,124,1,0,140,57,0,2,12,44,240,255,128,65,173,13,7,72,
120,27,127,124,120,235,164,127,0,2,160,56,129,15,7,72,120,243,195,127,
238,0,128,56,133,149,255,75,120,251,227,127,120,243,196,127,0,2,160,56,
141,15,7,72,120,251,227,127,33,18,7,72,120,235,163,127,120,243,196,127,
0,2,160,56,8,0,193,56,149,180,255,75,0,0,3,44,56,0,130,65,
8,0,161,128,174,40,254,124,174,40,221,124,11,0,224,63,120,219,99,127,
56,67,159,56,165,0,2,72,8,0,129,128,174,32,222,124,174,32,189,124,
56,67,127,56,13,85,4,72,103,48,96,56,0,0,92,129,1,0,74,57,
0,0,92,145,20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,
16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,88,0,130,64,36,0,62,129,
0,72,31,124,88,0,128,64,20,0,222,128,24,0,126,128,16,0,190,128,
28,0,158,56,185,254,255,75,12,0,254,128,0,0,3,44,60,8,230,87,
46,59,102,124,16,0,130,65,32,0,30,129,1,0,8,57,32,0,30,145,
36,0,62,129,1,0,255,59,0,72,31,124,192,255,128,65,16,0,0,72,
32,0,94,129,1,0,74,57,32,0,94,145,152,128,141,129,1,0,140,56,
11,0,96,60,124,67,99,56,152,128,141,144,61,84,4,72,32,0,30,128,
0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,185,149,255,75,
255,7,192,87,12,0,130,65,120,251,227,127,249,63,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,
120,35,157,124,20,0,130,64,52,0,96,56,5,62,4,72,121,27,127,124,
52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,
8,0,161,56,161,151,255,75,12,0,0,60,144,17,0,48,48,0,31,144,
11,0,96,60,144,67,99,56,81,83,4,72,120,251,227,127,28,0,225,131,
24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,
32,0,33,56,32,0,128,78,224,255,33,148,166,2,8,124,36,0,1,144,
12,0,97,147,120,59,251,124,16,0,129,147,120,27,124,124,24,0,193,147,
120,43,190,124,20,0,161,147,120,35,157,124,120,235,165,127,0,0,128,56,
28,0,225,147,120,51,223,124,0,2,192,56,73,29,7,72,0,0,3,44,
144,0,130,64,120,227,131,127,120,251,228,127,120,219,101,127,0,2,192,56,
8,0,224,56,6,0,0,57,201,217,255,75,0,0,3,44,108,0,130,64,
120,243,195,127,238,0,128,56,197,146,255,75,120,227,131,127,0,0,128,56,
120,243,197,127,0,2,192,56,253,28,7,72,0,0,3,44,68,0,130,64,
120,227,131,127,120,251,228,127,120,219,101,127,0,2,192,56,9,0,224,56,
0,0,0,57,125,217,255,75,0,0,3,44,32,0,130,64,120,227,131,127,
0,0,128,56,120,243,197,127,0,2,192,56,37,30,7,72,0,0,3,44,
40,0,130,65,20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,
16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,
120,235,163,127,120,243,196,127,0,2,160,56,209,223,255,75,20,0,161,131,
24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,166,2,8,124,
36,0,1,144,28,0,225,147,120,51,223,124,12,0,97,147,120,59,251,124,
16,0,129,147,120,67,28,125,24,0,193,147,120,43,190,124,120,243,195,127,
20,0,161,147,120,35,157,124,0,0,128,56,209,145,255,75,120,219,99,127,
120,243,196,127,120,251,229,127,120,227,134,127,0,80,224,56,125,254,255,75,
0,0,3,44,76,0,130,64,120,243,195,127,249,219,255,75,120,219,99,127,
120,243,196,127,120,251,229,127,120,227,134,127,0,80,224,56,85,254,255,75,
0,0,3,44,36,0,130,64,120,243,195,127,105,224,255,75,120,219,99,127,
120,243,196,127,120,251,229,127,120,227,134,127,0,80,224,56,45,254,255,75,
0,0,157,129,1,0,140,57,0,0,157,145,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,
32,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,8,0,254,171,0,0,31,44,
96,0,130,64,36,0,30,128,0,0,31,124,96,0,128,64,44,0,30,161,
16,0,190,128,20,0,222,128,24,0,126,128,40,0,254,128,28,0,158,56,
225,254,255,75,12,0,30,129,0,0,3,44,60,8,231,87,46,67,103,124,
16,0,130,65,32,0,62,129,1,0,41,57,32,0,62,145,36,0,30,128,
1,0,255,59,0,0,31,124,184,255,128,65,16,0,0,72,32,0,158,129,
1,0,140,57,32,0,158,145,152,128,109,129,1,0,139,56,11,0,96,60,
188,67,99,56,152,128,141,144,129,80,4,72,32,0,30,128,0,0,0,44,
0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,253,145,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,61,60,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,0,0,133,131,121,27,127,124,120,51,221,124,120,35,158,124,
20,0,130,64,52,0,96,56,73,58,4,72,121,27,127,124,68,0,130,65,
8,0,129,147,120,251,227,127,120,243,196,127,120,235,166,127,8,0,161,56,
229,147,255,75,12,0,0,60,120,17,0,48,48,0,31,144,11,0,96,60,
208,67,99,56,149,79,4,72,44,0,159,160,11,0,96,60,0,68,99,56,
133,79,4,72,120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
0,0,132,129,0,0,96,56,1,0,140,57,0,0,132,145,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
8,0,127,169,0,0,11,44,80,0,130,64,36,0,255,128,0,56,11,124,
80,0,128,64,24,0,127,128,28,0,159,56,185,255,255,75,12,0,31,128,
0,0,3,44,60,8,108,85,46,3,108,124,16,0,130,65,32,0,223,128,
1,0,198,56,32,0,223,144,36,0,255,128,1,0,107,57,0,56,11,124,
200,255,128,65,16,0,0,72,32,0,63,129,1,0,41,57,32,0,63,145,
152,128,77,129,1,0,138,56,11,0,96,60,16,68,99,56,152,128,141,144,
189,78,4,72,32,0,31,128,0,0,0,44,0,0,96,56,8,0,130,65,
19,48,96,56,20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
61,144,255,75,255,7,192,87,12,0,130,65,120,251,227,127,125,58,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,137,56,4,72,
121,27,127,124,52,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,37,146,255,75,12,0,0,60,96,17,0,48,
48,0,31,144,11,0,96,60,36,68,99,56,213,77,4,72,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,232,255,33,148,166,2,8,124,
28,0,1,144,16,0,193,147,120,43,190,124,8,0,129,147,120,59,252,124,
20,0,225,147,120,51,223,124,120,251,227,127,12,0,161,147,120,35,157,124,
0,0,128,56,141,141,255,75,120,251,228,127,0,0,96,56,0,2,160,56,
21,11,7,72,0,0,3,44,68,0,130,64,120,227,131,127,0,0,128,56,
0,2,160,56,57,19,7,72,0,0,3,44,44,0,130,64,120,251,228,127,
0,0,96,56,0,2,160,56,65,10,7,72,0,0,3,44,20,0,130,64,
120,243,195,127,120,251,228,127,0,2,160,56,209,218,255,75,0,0,157,129,
1,0,140,57,0,0,157,145,16,0,193,131,20,0,225,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,92,0,130,64,36,0,94,129,
0,80,31,124,92,0,128,64,20,0,222,128,40,0,254,128,24,0,126,128,
16,0,190,128,28,0,158,56,1,255,255,75,12,0,30,129,0,0,3,44,
60,8,231,87,46,67,103,124,16,0,130,65,32,0,62,129,1,0,41,57,
32,0,62,145,36,0,94,129,1,0,255,59,0,80,31,124,188,255,128,65,
16,0,0,72,32,0,126,129,1,0,107,57,32,0,126,145,152,128,141,129,
1,0,140,56,11,0,96,60,48,68,99,56,152,128,141,144,85,76,4,72,
32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
209,141,255,75,255,7,192,87,12,0,130,65,120,251,227,127,17,56,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,29,54,4,72,
121,27,127,124,84,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,185,143,255,75,12,0,128,61,72,17,140,57,
48,0,159,145,11,0,96,60,68,68,99,56,105,75,4,72,16,0,127,128,
197,213,255,75,40,0,127,128,16,0,191,128,0,0,128,56,0,2,192,56,
173,21,7,72,8,0,127,176,120,251,227,127,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,
32,0,128,78,232,255,33,148,166,2,8,124,28,0,1,144,16,0,193,147,
120,43,190,124,8,0,129,147,120,59,252,124,20,0,225,147,120,51,223,124,
120,251,227,127,12,0,161,147,120,35,157,124,0,0,128,56,1,139,255,75,
120,227,131,127,120,251,229,127,0,2,192,56,61,21,7,72,0,0,3,44,
72,0,130,64,120,227,131,127,0,0,128,56,0,2,160,56,45,17,7,72,
0,0,3,44,48,0,130,64,120,227,131,127,0,0,128,56,120,251,229,127,
0,2,192,56,113,22,7,72,0,0,3,44,20,0,130,64,120,243,195,127,
120,251,228,127,0,2,160,56,65,216,255,75,0,0,157,129,1,0,140,57,
0,0,157,145,16,0,193,131,20,0,225,131,28,0,1,128,12,0,161,131,
8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,92,0,130,64,36,0,94,129,0,80,31,124,
92,0,128,64,20,0,222,128,40,0,254,128,24,0,126,128,16,0,190,128,
28,0,158,56,253,254,255,75,12,0,30,129,0,0,3,44,60,8,231,87,
46,67,103,124,16,0,130,65,32,0,62,129,1,0,41,57,32,0,62,145,
36,0,94,129,1,0,255,59,0,80,31,124,188,255,128,65,16,0,0,72,
32,0,126,129,1,0,107,57,32,0,126,145,152,128,141,129,1,0,140,56,
11,0,96,60,108,68,99,56,152,128,141,144,197,73,4,72,32,0,30,128,
0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,65,139,255,75,
255,7,192,87,12,0,130,65,120,251,227,127,129,53,4,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,166,2,8,124,
36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,120,51,220,124,
120,35,157,124,20,0,130,64,52,0,96,56,141,51,4,72,121,27,127,124,
80,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,120,227,134,127,
8,0,161,56,41,141,255,75,12,0,0,60,48,17,0,48,48,0,31,144,
11,0,96,60,128,68,99,56,217,72,4,72,16,0,127,128,53,211,255,75,
16,0,159,128,0,0,96,56,0,2,160,56,109,6,7,72,8,0,127,176,
120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,
16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,
20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,16,0,129,147,
120,43,188,124,8,0,65,147,120,59,250,124,28,0,225,147,120,51,223,124,
120,251,227,127,12,0,97,147,120,35,155,124,238,0,128,56,109,136,255,75,
120,211,93,127,120,235,163,127,0,0,192,59,120,243,196,127,120,251,229,127,
0,2,192,56,157,18,7,72,0,0,3,44,76,0,130,64,120,235,163,127,
120,243,196,127,120,227,133,127,0,2,192,56,129,18,7,72,0,0,3,44,
48,0,130,64,120,211,67,127,0,0,128,56,120,251,229,127,0,2,192,56,
205,19,7,72,0,0,3,44,20,0,130,64,120,227,131,127,120,251,228,127,
0,2,160,56,157,213,255,75,0,0,155,129,1,0,140,57,0,0,155,145,
24,0,193,131,16,0,129,131,20,0,161,131,28,0,225,131,36,0,1,128,
12,0,97,131,8,0,65,131,166,3,8,124,32,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,8,0,254,171,0,0,31,44,92,0,130,64,36,0,94,129,
0,80,31,124,92,0,128,64,20,0,222,128,40,0,254,128,24,0,126,128,
16,0,190,128,28,0,158,56,221,254,255,75,12,0,30,129,0,0,3,44,
60,8,231,87,46,67,103,124,16,0,130,65,32,0,62,129,1,0,41,57,
32,0,62,145,36,0,94,129,1,0,255,59,0,80,31,124,188,255,128,65,
16,0,0,72,32,0,126,129,1,0,107,57,32,0,126,145,152,128,141,129,
1,0,140,56,11,0,96,60,168,68,99,56,152,128,141,144,25,71,4,72,
32,0,30,128,0,0,0,44,0,0,96,56,8,0,130,65,19,48,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
121,27,127,124,8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,
149,136,255,75,255,7,192,87,12,0,130,65,120,251,227,127,213,50,4,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,
166,2,8,124,36,0,1,144,28,0,225,147,0,0,197,131,121,27,127,124,
120,51,220,124,120,35,157,124,20,0,130,64,52,0,96,56,225,48,4,72,
121,27,127,124,60,0,130,65,8,0,193,147,120,251,227,127,120,235,164,127,
120,227,134,127,8,0,161,56,125,138,255,75,12,0,0,60,24,17,0,48,
48,0,31,144,11,0,96,60,188,68,99,56,45,70,4,72,16,0,127,128,
137,208,255,75,120,251,227,127,28,0,225,131,24,0,193,131,36,0,1,128,
20,0,161,131,16,0,129,131,166,3,8,124,32,0,33,56,32,0,128,78,
224,255,33,148,12,0,97,147,16,0,129,147,24,0,193,147,28,0,225,147,
166,2,8,124,36,0,1,144,20,0,161,147,120,59,253,124,0,0,61,129,
64,64,9,124,120,51,220,124,120,43,187,124,120,27,126,124,120,35,159,124,
76,0,128,65,0,0,0,56,0,0,29,144,19,0,96,60,172,179,99,128,
141,162,254,75,0,0,3,44,48,0,130,65,120,243,195,127,11,0,192,63,
228,68,158,56,25,241,1,72,228,68,126,56,141,69,4,72,0,0,159,129,
1,0,140,57,39,48,96,56,0,0,159,145,128,0,0,72,120,227,131,127,
238,0,128,56,129,133,255,75,0,0,125,128,120,227,132,127,0,2,160,56,
9,3,7,72,0,0,3,44,80,0,130,64,0,0,125,128,120,219,100,127,
0,2,160,56,241,2,7,72,0,0,3,44,56,0,130,64,0,0,125,128,
120,227,132,127,0,2,160,56,53,2,7,72,0,0,3,44,32,0,130,64,
120,219,99,127,120,227,132,127,0,2,160,56,197,210,255,75,0,0,125,129,
0,2,107,57,0,0,125,145,0,0,159,129,1,0,140,57,0,0,159,145,
20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,
12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,232,255,33,148,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
8,0,254,171,0,0,31,44,0,0,32,57,8,0,33,145,96,0,130,64,
36,0,30,128,0,0,31,124,96,0,128,64,148,128,13,129,24,0,126,128,
20,0,222,128,16,0,190,128,28,0,158,56,8,0,225,56,137,254,255,75,
12,0,30,128,0,0,3,44,60,8,234,87,46,3,106,124,16,0,130,65,
32,0,158,129,1,0,140,57,32,0,158,145,36,0,30,128,1,0,255,59,
0,0,31,124,184,255,128,65,16,0,0,72,32,0,254,128,1,0,231,56,
32,0,254,144,152,128,141,129,1,0,140,56,11,0,96,60,252,68,99,56,
152,128,141,144,45,68,4,72,32,0,30,128,0,0,0,44,0,0,96,56,
8,0,130,65,19,48,96,56,28,0,1,128,20,0,225,131,16,0,193,131,
166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,
28,0,130,65,0,0,128,56,169,133,255,75,255,7,192,87,12,0,130,65,
120,251,227,127,233,47,4,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,
20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,
0,0,165,131,121,27,127,124,120,51,222,124,120,35,156,124,20,0,130,64,
52,0,96,56,245,45,4,72,121,27,127,124,84,0,130,65,8,0,161,147,
120,251,227,127,120,227,132,127,120,243,198,127,8,0,161,56,145,135,255,75,
12,0,0,60,0,17,0,48,48,0,31,144,11,0,96,60,16,69,99,56,
65,67,4,72,19,0,96,60,172,179,99,128,21,160,254,75,0,0,3,44,
8,0,127,176,12,0,130,64,16,0,127,128,133,205,255,75,120,251,227,127,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,16,0,129,131,
166,3,8,124,32,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,11,0,96,60,56,69,99,56,229,66,4,72,12,0,1,128,
8,0,33,56,166,3,8,124,33,48,96,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,
120,35,159,124,28,0,130,65,0,0,128,56,121,132,255,75,255,7,224,87,
12,0,130,65,120,243,195,127,185,46,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,
120,35,159,124,28,0,130,65,0,0,128,56,41,132,255,75,255,7,224,87,
12,0,130,65,120,243,195,127,105,46,4,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,120,27,101,124,
11,0,128,60,184,71,132,56,0,0,64,57,11,0,32,61,56,71,41,57,
56,24,64,85,174,0,105,125,64,40,11,124,24,0,130,64,20,2,137,125,
4,0,140,128,11,0,96,60,200,71,99,56,244,65,4,72,1,0,74,57,
16,0,10,44,212,255,128,65,11,0,96,60,200,71,99,56,220,65,4,72,
1,0,128,61,255,255,140,57,56,24,96,84,80,0,3,124,54,32,0,84,
29,0,96,61,60,5,107,57,20,2,107,125,20,0,139,177,22,0,139,177,
24,0,139,177,26,0,139,177,0,0,0,56,28,0,11,144,32,0,128,78,
0,0,0,60,255,255,0,96,2,0,99,57,30,0,64,57,166,3,73,125,
0,0,11,137,64,32,8,124,28,0,130,64,5,0,139,137,6,0,107,137,
46,64,105,85,20,74,12,124,62,4,3,84,32,0,128,78,12,0,107,57,
216,255,0,66,62,4,3,84,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,120,27,103,124,0,0,128,57,0,2,0,56,166,3,9,124,
120,35,134,124,255,255,6,57,1,0,40,141,20,74,140,125,62,6,140,85,
244,255,0,66,0,0,12,44,24,0,130,65,12,0,1,128,8,0,33,56,
166,3,8,124,107,48,96,56,32,0,128,78,120,51,195,124,5,0,128,56,
97,255,255,75,56,24,235,84,80,88,71,125,54,32,74,85,29,0,138,61,
60,5,236,56,20,0,103,176,120,51,195,124,9,0,128,56,61,255,255,75,
22,0,103,176,120,51,195,124,12,0,128,56,45,255,255,75,24,0,103,176,
120,51,195,124,194,0,128,56,29,255,255,75,248,191,13,128,28,0,7,144,
26,0,103,176,12,0,1,128,8,0,33,56,166,3,8,124,0,0,96,56,
32,0,128,78,232,253,33,148,20,2,225,147,16,2,193,147,8,2,129,147,
12,2,161,147,166,2,8,124,28,2,1,144,248,191,141,129,29,0,32,61,
60,5,41,57,120,35,159,124,56,24,231,87,80,56,191,124,54,32,165,84,
20,42,201,127,28,0,30,128,80,96,96,125,184,11,11,40,216,0,129,64,
120,251,227,127,109,254,255,75,1,0,160,59,48,248,188,127,61,209,6,72,
208,7,0,56,29,0,64,61,60,48,74,57,9,0,32,61,248,112,41,57,
0,0,0,57,8,0,3,145,4,0,35,145,36,0,67,145,40,0,131,147,
20,0,3,144,2,0,131,161,32,0,140,97,2,0,131,177,2,0,3,160,
120,235,164,127,120,27,124,124,64,0,0,96,2,0,3,176,225,214,6,72,
120,251,227,127,120,227,132,127,8,0,161,56,9,138,4,72,0,0,220,168,
0,0,6,44,248,255,130,64,12,0,188,171,0,0,0,57,120,227,131,127,
0,0,28,177,157,207,7,72,0,0,29,44,32,0,130,65,11,0,96,60,
212,71,99,56,165,63,4,72,56,24,234,87,80,80,127,124,54,32,99,84,
44,0,0,72,120,251,227,127,8,0,129,56,53,254,255,75,28,0,158,128,
11,0,96,60,232,71,99,56,121,63,4,72,56,24,234,87,80,80,127,124,
54,32,99,84,16,2,193,131,20,2,225,131,28,2,1,128,12,2,161,131,
8,2,129,131,166,3,8,124,24,2,33,56,32,0,128,78,29,0,131,61,
28,5,12,136,129,0,12,112,129,0,140,105,52,0,128,125,62,222,3,84,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,0,0,96,57,
120,91,105,125,16,0,0,57,1,0,64,57,120,75,35,125,197,255,255,75,
0,0,3,44,12,0,130,65,48,72,64,125,120,3,107,125,255,255,8,53,
1,0,41,57,224,255,130,64,12,0,1,128,8,0,33,56,166,3,8,124,
120,91,99,125,32,0,128,78,56,24,96,84,80,0,3,124,54,32,0,84,
29,0,128,61,20,2,108,125,171,5,139,152,32,0,128,78,29,0,131,61,
28,5,12,136,249,0,0,104,52,0,12,124,62,222,131,85,32,0,128,78,
29,0,131,61,28,5,12,136,245,0,0,104,52,0,12,124,62,222,131,85,
32,0,128,78,29,0,131,61,28,5,12,136,217,0,0,44,60,0,130,65,
219,0,0,44,52,0,130,65,221,0,0,44,44,0,130,65,223,0,0,44,
36,0,130,65,236,0,0,44,28,0,130,65,238,0,0,44,20,0,130,65,
254,0,0,44,12,0,130,65,241,0,0,44,12,0,130,64,1,0,96,56,
32,0,128,78,0,0,96,56,32,0,128,78,232,255,33,148,12,0,161,147,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,35,158,124,
0,0,30,161,123,7,0,85,120,27,125,124,20,0,130,64,0,2,96,56,
49,42,4,72,0,0,3,44,36,0,130,64,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,0,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,1,0,224,59,54,0,94,57,254,255,131,57,20,0,192,56,
166,3,201,124,0,0,170,136,3,0,172,152,1,0,202,140,2,0,204,156,
1,0,74,57,236,255,0,66,56,24,168,87,80,64,253,124,54,32,231,84,
29,0,39,61,60,5,137,56,39,0,36,57,255,255,131,57,120,99,133,125,
40,0,0,56,166,3,9,124,1,0,73,141,1,0,101,141,81,80,11,124,
8,0,130,64,240,255,0,66,0,0,0,44,8,0,130,65,0,0,224,59,
20,0,94,57,254,255,99,57,10,0,0,57,166,3,9,125,0,0,10,136,
3,0,11,152,1,0,170,140,2,0,171,156,1,0,74,57,236,255,0,66,
80,0,164,56,120,99,137,125,20,0,224,56,166,3,233,124,1,0,197,140,
1,0,233,140,81,48,71,125,8,0,130,64,240,255,0,66,0,0,10,44,
8,0,130,65,0,0,224,59,46,0,94,57,254,255,227,56,4,0,0,56,
166,3,9,124,0,0,10,137,3,0,7,153,1,0,42,141,2,0,39,157,
1,0,74,57,236,255,0,66,101,0,100,57,8,0,0,57,166,3,9,125,
1,0,75,141,1,0,12,140,81,80,0,124,8,0,130,64,240,255,0,66,
0,0,0,44,8,0,130,65,0,0,224,59,233,40,4,72,120,251,227,127,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,29,0,131,61,28,5,12,136,2,0,0,104,
52,0,12,124,62,222,131,85,32,0,128,78,29,0,131,61,28,5,12,136,
241,0,0,44,0,0,96,56,28,0,130,65,245,0,0,44,20,0,130,65,
249,0,0,44,12,0,130,65,2,0,0,44,32,0,130,76,1,0,96,56,
32,0,128,78,56,24,96,84,80,0,131,125,54,32,140,85,29,0,108,61,
60,5,139,57,111,0,108,136,32,0,128,78,56,24,96,84,80,0,131,125,
54,32,140,85,29,0,108,61,60,5,139,57,81,0,108,56,32,0,128,78,
56,24,96,84,80,0,3,124,54,32,0,84,29,0,128,61,20,2,108,125,
99,5,139,152,32,0,128,78,56,24,96,84,80,0,131,125,54,32,140,85,
29,0,108,61,60,5,139,57,38,0,108,136,32,0,128,78,56,24,96,84,
80,0,131,125,54,32,140,85,29,0,108,61,60,5,139,57,39,0,108,136,
32,0,128,78,0,0,224,56,56,24,106,84,80,80,35,125,54,32,41,85,
29,0,105,61,60,5,107,57,39,0,75,57,40,0,0,56,166,3,9,124,
1,0,138,141,120,98,231,124,116,7,231,124,244,255,0,66,80,0,11,57,
0,0,228,152,20,0,224,56,166,3,233,124,1,0,8,140,1,0,4,156,
248,255,0,66,1,0,100,56,32,0,128,78,216,255,33,148,16,0,65,147,
20,0,97,147,24,0,129,147,28,0,161,147,166,2,8,124,44,0,1,144,
32,0,193,147,120,27,126,124,36,0,225,147,255,255,224,59,166,0,96,127,
94,4,106,87,36,1,64,125,0,0,160,59,16,0,64,59,248,193,141,59,
16,0,29,40,0,0,96,56,8,0,128,64,8,0,124,128,0,0,3,44,
84,0,130,65,104,0,131,129,188,0,12,128,120,243,196,127,166,3,9,124,
33,4,128,78,12,0,97,144,12,0,1,160,8,0,1,176,14,0,225,160,
10,0,225,176,8,0,1,129,255,7,8,85,32,0,130,65,120,235,191,127,
0,128,105,115,166,0,0,124,94,4,0,84,120,75,0,124,36,1,0,124,
40,0,0,72,255,255,90,55,40,0,156,59,1,0,189,59,140,255,130,64,
0,128,105,115,166,0,0,124,94,4,0,84,120,75,0,124,36,1,0,124,
28,0,161,131,120,251,227,127,36,0,225,131,24,0,129,131,32,0,193,131,
44,0,1,128,20,0,97,131,16,0,65,131,166,3,8,124,40,0,33,56,
32,0,128,78,56,24,96,84,80,0,131,125,54,32,140,85,29,0,108,61,
37,0,139,57,60,5,108,136,116,7,99,124,32,0,128,78,56,24,96,84,
80,0,131,125,54,32,140,85,29,0,108,61,36,0,139,57,60,5,108,136,
116,7,99,124,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
120,27,105,124,177,255,255,75,120,27,106,124,120,75,35,125,197,255,255,75,
12,0,224,60,172,20,231,56,60,8,64,85,174,0,7,125,0,0,4,153,
20,2,103,125,1,0,11,137,116,7,8,125,0,24,8,124,0,0,5,153,
12,0,129,64,0,0,0,56,0,0,5,152,120,75,35,125,137,250,255,75,
0,0,3,44,16,0,130,64,0,0,64,57,0,0,68,153,0,0,69,153,
12,0,1,128,8,0,33,56,166,3,8,124,120,83,67,125,32,0,128,78,
56,24,96,84,80,0,3,124,54,32,0,84,29,0,128,61,20,2,108,125,
97,5,139,152,32,0,128,78,56,24,96,84,80,0,131,125,54,32,140,85,
29,0,0,60,60,5,0,48,46,0,108,124,32,0,128,78,56,24,96,84,
80,0,131,125,54,32,140,85,29,0,108,61,60,5,139,57,16,0,12,160,
123,7,3,84,32,0,128,78,56,24,96,84,80,0,131,125,54,32,140,85,
29,0,108,61,60,5,139,57,16,0,12,160,189,7,3,84,32,0,128,78,
56,24,96,84,80,0,131,125,54,32,140,85,29,0,108,61,60,5,139,57,
32,0,12,160,123,7,3,84,32,0,128,78,56,24,96,84,80,0,131,125,
54,32,140,85,29,0,108,61,60,5,139,57,32,0,12,160,255,7,3,84,
32,0,128,78,56,24,96,84,80,0,3,124,54,32,0,84,29,0,128,61,
60,5,140,57,20,2,108,125,8,0,139,161,255,255,12,40,0,0,96,56,
32,0,130,77,10,0,11,160,255,255,0,40,32,0,130,77,1,0,96,56,
32,0,128,78,56,24,96,84,80,0,131,125,54,32,140,85,29,0,108,61,
60,5,139,57,8,0,12,160,57,7,3,84,32,0,128,78,232,255,33,148,
8,0,129,147,166,2,8,124,28,0,1,144,12,0,161,147,29,0,160,63,
60,5,189,59,16,0,193,147,20,0,225,147,120,27,127,124,29,0,223,63,
120,251,228,127,11,0,96,60,184,72,99,56,89,56,4,72,56,24,230,87,
20,250,6,124,50,48,0,84,29,0,224,60,60,12,231,56,20,2,135,127,
60,2,28,137,116,7,8,125,46,0,8,44,76,0,130,64,28,5,158,56,
80,48,31,124,54,32,0,84,20,2,189,124,11,0,96,60,200,72,99,56,
21,56,4,72,28,5,222,139,11,0,96,60,220,72,99,56,5,56,4,72,
120,243,195,127,209,245,255,75,60,2,28,136,116,7,0,124,46,0,0,44,
4,2,130,64,68,0,0,72,54,32,10,85,11,0,138,61,100,79,108,57,
4,0,139,128,204,133,98,56,209,55,4,72,28,5,222,139,11,0,96,60,
220,72,99,56,193,55,4,72,120,243,195,127,141,245,255,75,60,2,28,136,
116,7,0,124,46,0,0,44,192,1,130,64,56,24,231,87,80,56,223,124,
54,32,198,84,20,50,253,127,40,0,159,56,11,0,96,60,252,71,99,56,
137,55,4,72,81,0,159,56,11,0,96,60,12,72,99,56,121,55,4,72,
102,0,159,56,11,0,96,60,28,72,99,56,105,55,4,72,0,0,159,128,
11,0,96,60,120,35,133,124,236,72,99,56,85,55,4,72,8,0,31,161,
10,0,31,160,11,0,96,60,172,73,99,56,254,183,6,84,254,191,7,84,
255,7,4,85,254,255,5,85,49,55,4,72,12,0,95,161,11,0,96,60,
254,231,70,85,254,215,69,85,254,175,68,85,8,73,99,56,21,55,4,72,
10,0,63,161,173,5,40,85,24,0,130,65,39,0,159,136,38,0,191,136,
11,0,96,60,92,72,99,56,245,54,4,72,8,0,159,161,189,7,128,85,
144,0,130,65,32,0,223,163,120,243,196,127,11,0,96,60,68,73,99,56,
213,54,4,72,0,0,30,44,104,0,130,65,189,7,198,87,11,0,128,60,
108,73,132,56,8,0,130,65,196,133,130,56,123,7,199,87,11,0,160,60,
120,73,165,56,8,0,130,65,216,133,162,56,249,6,192,87,212,133,194,56,
12,0,130,65,11,0,192,60,132,73,198,56,11,0,96,60,96,73,99,56,
133,54,4,72,18,0,31,160,14,0,127,161,0,0,11,44,0,0,160,56,
254,255,4,84,64,0,130,65,40,0,0,72,11,0,96,60,144,72,99,56,
93,54,4,72,18,0,31,160,14,0,127,161,0,0,11,44,0,0,160,56,
254,255,4,84,24,0,130,65,255,255,11,40,16,0,130,65,239,5,96,85,
8,0,130,65,1,0,160,56,62,6,165,84,11,0,96,60,44,72,99,56,
33,54,4,72,36,0,159,136,116,7,132,124,12,0,0,60,144,20,0,48,
58,16,140,84,46,0,172,124,11,0,96,60,148,73,99,56,253,53,4,72,
24,0,159,160,11,0,96,60,76,72,99,56,237,53,4,72,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,54,0,132,57,56,24,103,84,80,56,227,124,
54,32,231,84,29,0,192,60,60,5,198,56,20,58,6,125,38,0,104,57,
20,0,0,56,166,3,9,124,0,0,44,137,3,0,43,153,1,0,76,141,
2,0,75,157,1,0,140,57,236,255,0,66,0,0,96,57,20,58,70,125,
80,0,106,153,20,0,132,57,79,0,10,57,10,0,0,56,166,3,9,124,
0,0,108,137,3,0,104,153,1,0,12,140,2,0,8,156,1,0,140,57,
236,255,0,66,0,0,0,56,101,0,10,152,46,0,132,57,20,58,6,125,
100,0,200,56,4,0,32,57,166,3,41,125,0,0,44,137,3,0,38,153,
1,0,12,140,2,0,6,156,1,0,140,57,236,255,0,66,0,0,192,56,
110,0,202,152,122,0,4,161,166,0,196,160,120,0,36,161,30,128,7,85,
107,5,203,84,120,59,41,125,4,0,42,145,20,0,130,65,202,0,4,161,
200,0,36,161,30,128,7,85,120,59,41,125,164,0,100,161,8,0,106,177,
166,0,4,160,10,0,10,176,168,0,196,160,12,0,202,176,166,0,4,161,
173,5,7,85,0,0,42,145,0,0,0,56,8,0,130,65,188,0,4,160,
39,0,10,152,62,194,11,84,38,0,106,153,0,1,228,160,32,0,234,176,
152,0,4,160,14,0,10,176,156,0,36,161,16,0,42,177,166,0,100,161,
239,5,8,84,0,0,224,56,18,0,106,177,34,0,234,152,12,0,130,65,
1,0,32,57,34,0,42,153,190,255,11,84,35,0,106,153,176,0,4,160,
127,6,0,84,31,0,0,40,255,0,96,56,24,0,128,64,7,0,0,40,
44,0,130,65,15,0,0,40,80,0,130,64,32,0,0,72,31,0,0,40,
40,0,130,65,63,0,0,40,48,0,130,65,127,0,0,40,40,0,130,65,
48,0,0,72,2,0,192,56,36,0,202,152,254,0,96,56,32,0,128,78,
4,0,224,56,36,0,234,152,254,0,96,56,32,0,128,78,5,0,32,57,
36,0,42,153,32,0,128,78,0,0,0,56,36,0,10,152,254,0,96,56,
32,0,128,78,29,0,131,61,44,5,108,137,2,0,11,44,32,0,130,76,
2,0,0,56,29,0,131,61,28,5,12,152,32,0,128,78,29,0,99,61,
28,5,11,136,29,0,131,61,44,5,12,152,32,0,128,78,120,27,96,124,
64,0,4,124,0,0,96,56,32,0,130,77,241,0,4,40,24,0,128,64,
0,0,4,40,156,0,130,65,2,0,4,40,88,0,130,65,128,0,0,72,
241,0,4,40,24,0,130,65,245,0,4,40,24,0,130,65,249,0,4,40,
44,0,130,65,100,0,0,72,245,0,0,44,108,0,130,65,249,0,0,44,
100,0,130,65,255,0,0,44,92,0,130,65,0,0,0,44,32,0,130,76,
80,0,0,72,255,0,0,44,20,0,130,64,1,0,96,56,32,0,128,78,
255,0,0,44,56,0,130,65,0,0,0,44,48,0,130,65,245,0,0,44,
40,0,130,65,249,0,0,44,32,0,130,65,241,0,0,44,32,0,130,76,
20,0,0,72,0,0,0,44,12,0,130,65,255,0,0,44,32,0,130,76,
1,0,96,56,32,0,128,78,216,255,33,148,12,0,33,147,16,0,65,147,
20,0,97,147,166,2,8,124,44,0,1,144,24,0,129,147,120,27,124,124,
28,0,161,147,120,35,157,124,32,0,193,147,120,43,190,124,36,0,225,147,
120,51,223,124,166,0,32,127,94,4,41,87,36,1,32,125,29,0,156,61,
28,5,76,139,28,5,108,59,120,234,76,127,49,6,128,85,108,0,130,65,
49,6,160,87,160,134,237,168,52,0,130,65,0,0,30,44,1,0,7,56,
160,134,13,176,16,0,130,65,11,0,96,60,4,74,99,56,121,50,4,72,
2,0,128,56,120,227,131,127,1,0,160,56,253,49,0,72,48,0,0,72,
0,0,30,44,255,255,231,56,160,134,237,176,16,0,130,65,11,0,96,60,
244,73,99,56,73,50,4,72,120,227,131,127,1,0,128,56,120,35,133,124,
205,49,0,72,0,0,31,44,24,0,130,64,120,211,67,127,120,235,164,127,
109,254,255,75,0,0,3,44,180,0,130,65,196,136,13,161,247,6,8,85,
124,0,130,65,64,232,26,124,116,0,130,65,2,0,29,40,24,0,130,65,
245,0,29,40,64,0,130,65,255,0,29,40,28,0,130,65,72,0,0,72,
25,0,96,56,120,227,133,127,224,133,130,56,61,214,253,75,68,0,0,72,
2,0,26,44,60,0,130,64,26,0,96,56,120,227,133,127,224,133,130,56,
33,214,253,75,40,0,0,72,15,0,96,56,120,227,133,127,224,133,130,56,
13,214,253,75,20,0,0,72,0,0,30,44,0,0,187,155,44,0,130,65,
16,0,0,72,0,0,30,44,0,0,187,155,28,0,130,65,120,227,132,127,
11,0,96,60,20,74,99,56,125,49,4,72,120,235,163,127,73,239,255,75,
120,227,131,127,241,53,0,72,0,128,43,115,166,0,0,124,94,4,0,84,
120,91,0,124,36,1,0,124,32,0,193,131,24,0,129,131,20,0,97,131,
28,0,161,131,36,0,225,131,44,0,1,128,16,0,65,131,12,0,33,131,
166,3,8,124,40,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,29,0,96,60,60,5,99,56,0,0,128,56,0,7,160,56,
33,205,253,75,29,0,96,60,28,5,99,56,0,0,128,56,16,0,160,56,
13,205,253,75,0,0,0,56,160,134,13,176,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,52,2,67,137,0,0,10,44,32,0,130,77,
0,0,99,129,176,134,13,128,1,0,32,57,48,88,44,125,57,96,12,124,
32,0,130,77,161,128,109,137,116,7,107,125,2,0,11,44,8,0,128,64,
2,0,96,57,232,3,235,28,56,2,99,129,102,102,32,61,103,102,41,57,
150,56,9,124,248,191,77,129,80,80,75,125,112,254,232,124,112,22,0,124,
80,0,8,124,0,0,10,124,32,0,129,76,0,0,128,57,176,134,141,145,
180,134,141,153,32,0,128,78,12,0,99,129,248,191,13,128,156,128,77,129,
208,7,138,57,80,0,11,124,16,96,96,125,16,89,139,125,208,0,108,124,
32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,16,0,127,128,0,0,192,59,8,0,223,155,
12,0,67,169,20,0,95,177,0,0,195,179,245,191,7,72,20,0,31,168,
0,0,0,44,16,0,223,147,36,0,96,56,8,0,130,65,40,0,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,166,2,8,124,
28,0,1,144,12,0,161,147,120,27,125,124,93,255,255,75,0,0,3,44,
36,0,130,65,20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,
39,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,0,0,125,128,
101,246,255,75,0,0,3,44,36,0,130,64,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,22,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,0,0,253,128,1,0,224,59,48,56,254,127,93,192,6,72,
232,3,96,57,29,0,64,61,60,48,74,57,9,0,32,61,248,112,41,57,
0,0,0,57,8,0,3,145,4,0,35,145,36,0,67,145,40,0,195,147,
20,0,99,145,2,0,131,161,32,0,140,97,2,0,131,177,2,0,3,160,
64,0,0,96,120,251,228,127,16,0,125,144,2,0,3,176,1,198,6,72,
16,0,157,128,184,134,173,128,0,0,125,128,242,0,192,56,165,112,4,72,
8,0,253,155,20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,
21,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,
8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
16,0,127,128,0,0,192,59,8,0,223,155,12,0,67,169,20,0,95,177,
0,0,195,179,129,190,7,72,20,0,31,168,0,0,0,44,16,0,223,147,
22,0,96,56,8,0,130,65,18,0,96,56,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,27,125,124,233,253,255,75,0,0,3,44,36,0,130,65,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,39,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,0,0,253,128,1,0,192,59,48,56,223,127,
25,191,6,72,232,3,96,57,29,0,64,61,60,48,74,57,9,0,32,61,
248,112,41,57,0,0,0,57,8,0,3,145,4,0,35,145,36,0,67,145,
40,0,227,147,20,0,99,145,2,0,131,161,32,0,140,97,2,0,131,177,
2,0,3,160,64,0,0,96,120,243,196,127,16,0,125,144,2,0,3,176,
189,196,6,72,16,0,157,128,184,134,173,128,0,0,125,128,246,0,192,56,
97,111,4,72,8,0,221,155,20,0,225,131,16,0,193,131,28,0,1,128,
12,0,161,131,37,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,16,0,127,128,0,0,192,59,8,0,223,155,12,0,67,169,
20,0,95,177,0,0,195,179,61,189,7,72,20,0,31,168,0,0,0,44,
16,0,223,147,20,0,130,65,11,0,96,60,216,76,99,56,61,45,4,72,
36,0,0,72,29,0,95,137,244,0,10,44,24,0,130,64,30,0,127,137,
44,0,11,44,12,0,130,64,245,0,0,56,6,0,31,152,12,0,225,131,
20,0,1,128,8,0,193,131,46,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,125,252,255,75,0,0,3,44,32,0,130,65,
12,0,225,131,20,0,1,128,8,0,193,131,39,0,96,56,166,3,8,124,
16,0,33,56,32,0,128,78,0,0,126,128,29,0,128,60,60,48,132,56,
1,0,224,59,24,0,222,56,48,24,229,127,85,194,6,72,120,27,100,124,
2,0,100,161,32,0,107,97,2,0,100,177,2,0,132,161,0,0,126,128,
16,0,158,144,64,0,140,97,2,0,132,177,65,117,4,72,8,0,254,155,
12,0,225,131,20,0,1,128,8,0,193,131,44,0,96,56,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,16,0,127,128,0,0,192,59,
8,0,223,155,12,0,99,169,20,0,127,177,0,0,195,179,9,188,7,72,
20,0,31,168,0,0,0,44,16,0,223,147,44,0,130,65,11,0,96,60,
248,76,99,56,9,44,4,72,12,0,225,131,20,0,1,128,8,0,193,131,
46,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,0,2,96,56,
17,24,4,72,120,27,126,124,52,0,159,56,0,2,160,56,125,74,4,72,
0,0,127,128,120,243,196,127,117,234,255,75,120,243,195,127,241,23,4,72,
12,0,225,131,20,0,1,128,8,0,193,131,43,0,96,56,166,3,8,124,
16,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,12,0,161,147,120,27,125,124,33,251,255,75,
0,0,3,44,36,0,130,65,20,0,225,131,16,0,193,131,28,0,1,128,
12,0,161,131,39,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
0,0,253,128,1,0,192,59,48,56,223,127,81,188,6,72,208,7,96,57,
29,0,64,61,60,48,74,57,9,0,32,61,248,112,41,57,0,0,0,57,
8,0,3,145,4,0,35,145,36,0,67,145,40,0,227,147,20,0,99,145,
2,0,131,161,32,0,140,97,2,0,131,177,2,0,3,160,64,0,0,96,
120,243,196,127,16,0,125,144,2,0,3,176,245,193,6,72,0,0,125,128,
16,0,157,128,52,0,189,56,29,117,4,72,8,0,221,155,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,35,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,16,0,127,128,0,0,192,59,
8,0,223,155,12,0,67,169,20,0,95,177,0,0,195,179,121,186,7,72,
20,0,31,168,0,0,0,44,16,0,223,147,44,0,130,65,11,0,96,60,
20,77,99,56,121,42,4,72,12,0,225,131,20,0,1,128,8,0,193,131,
46,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,12,0,225,131,
20,0,1,128,8,0,193,131,34,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,232,255,33,148,20,0,225,147,12,0,161,147,16,0,193,147,
166,2,8,124,28,0,1,144,0,0,3,129,120,27,127,124,56,24,9,85,
29,0,128,61,0,0,0,56,80,72,232,124,54,32,231,84,20,58,76,125,
84,5,10,176,157,249,255,75,0,0,3,44,36,0,130,65,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,39,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,0,0,31,128,1,0,192,59,48,0,221,127,
205,186,6,72,232,3,160,56,29,0,0,60,60,48,0,48,9,0,128,61,
248,112,140,57,0,0,96,57,8,0,99,145,4,0,131,145,36,0,3,144,
40,0,163,147,20,0,163,144,2,0,195,160,32,0,198,96,2,0,195,176,
2,0,3,161,64,0,8,97,120,243,196,127,16,0,127,144,2,0,3,177,
113,192,6,72,16,0,159,128,0,0,127,128,213,113,4,72,8,0,223,155,
20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,33,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,8,0,193,147,
166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,16,0,127,128,
0,0,192,59,8,0,223,155,12,0,67,169,20,0,95,177,0,0,195,179,
249,184,7,72,20,0,31,168,0,0,0,44,16,0,223,147,32,0,96,56,
8,0,130,65,40,0,96,56,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,216,255,33,148,24,0,129,147,
28,0,161,147,36,0,225,147,166,2,8,124,44,0,1,144,32,0,193,147,
120,27,126,124,93,248,255,75,0,0,3,44,40,0,130,65,36,0,225,131,
32,0,193,131,28,0,161,131,44,0,1,128,24,0,129,131,39,0,96,56,
166,3,8,124,40,0,33,56,32,0,128,78,0,0,126,128,153,236,255,75,
120,27,124,124,0,0,126,128,169,236,255,75,0,0,254,128,1,0,32,57,
120,27,125,124,48,56,63,125,113,185,6,72,120,27,100,124,232,3,128,57,
29,0,96,61,60,48,107,57,9,0,32,61,248,112,41,57,0,0,0,56,
8,0,3,144,4,0,35,145,36,0,99,145,40,0,227,147,20,0,131,145,
2,0,4,160,32,0,0,96,2,0,4,176,2,0,164,160,163,128,13,136,
116,7,0,124,1,0,0,40,16,0,158,144,64,0,165,96,2,0,164,176,
20,0,128,65,36,0,130,65,3,0,0,40,48,0,130,65,64,0,0,72,
128,0,28,44,0,0,0,56,254,0,224,59,148,0,128,65,60,0,0,72,
128,0,28,44,0,0,0,56,128,0,224,59,128,0,128,65,40,0,0,72,
128,0,28,44,0,0,0,56,120,227,159,127,108,0,128,65,20,0,0,72,
128,0,28,44,0,0,0,56,120,235,191,127,88,0,128,65,64,232,31,124,
80,0,130,65,0,0,126,128,36,0,0,56,239,0,128,57,0,0,192,56,
62,6,255,87,66,0,96,57,8,0,161,56,8,0,97,177,10,0,225,179,
12,0,193,144,16,0,193,152,17,0,129,153,18,0,1,176,249,91,4,72,
0,0,126,128,120,251,228,127,89,235,255,75,16,0,158,128,1,0,0,56,
120,35,131,124,120,3,4,124,77,190,6,72,1,0,64,57,8,0,94,153,
36,0,225,131,32,0,193,131,28,0,161,131,44,0,1,128,24,0,129,131,
31,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,240,255,33,148,
8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,
16,0,127,128,0,0,192,59,8,0,223,155,12,0,67,169,20,0,95,177,
0,0,195,179,217,182,7,72,20,0,31,168,0,0,0,44,16,0,223,147,
44,0,130,65,11,0,96,60,40,77,99,56,217,38,4,72,12,0,225,131,
20,0,1,128,8,0,193,131,46,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,12,0,225,131,20,0,1,128,8,0,193,131,30,0,96,56,
166,3,8,124,16,0,33,56,32,0,128,78,216,255,33,148,24,0,129,147,
32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,28,0,161,147,
120,27,125,124,25,246,255,75,0,0,3,44,40,0,130,65,36,0,225,131,
32,0,193,131,28,0,161,131,44,0,1,128,24,0,129,131,39,0,96,56,
166,3,8,124,40,0,33,56,32,0,128,78,0,0,125,128,221,236,255,75,
0,0,3,44,40,0,130,64,36,0,225,131,32,0,193,131,28,0,161,131,
44,0,1,128,24,0,129,131,30,0,96,56,166,3,8,124,40,0,33,56,
32,0,128,78,0,0,29,128,1,0,192,59,48,0,220,127,17,183,6,72,
232,3,224,56,29,0,32,61,60,48,41,57,9,0,0,61,248,112,8,57,
0,0,224,59,8,0,227,147,4,0,3,145,36,0,35,145,40,0,131,147,
20,0,227,144,2,0,3,160,32,0,0,96,2,0,3,176,2,0,3,160,
64,0,0,96,120,243,196,127,16,0,125,144,2,0,3,176,181,188,6,72,
0,0,125,128,16,0,157,128,2,0,96,57,16,0,64,57,120,251,230,127,
239,0,128,57,12,0,225,147,10,0,97,177,8,0,65,177,16,0,193,152,
17,0,129,153,8,0,161,56,36,0,0,56,18,0,1,176,5,90,4,72,
8,0,221,155,36,0,225,131,44,0,1,128,24,0,129,131,28,0,161,131,
32,0,193,131,29,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,
240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,16,0,127,128,0,0,192,59,8,0,223,155,12,0,67,169,
20,0,95,177,0,0,195,179,9,181,7,72,20,0,31,168,0,0,0,44,
16,0,223,147,44,0,130,65,11,0,96,60,92,77,99,56,9,37,4,72,
12,0,225,131,20,0,1,128,8,0,193,131,46,0,96,56,166,3,8,124,
16,0,33,56,32,0,128,78,12,0,225,131,20,0,1,128,8,0,193,131,
28,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,216,255,33,148,
24,0,129,147,32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,
28,0,161,147,120,27,125,124,73,244,255,75,0,0,3,44,40,0,130,65,
36,0,225,131,32,0,193,131,28,0,161,131,44,0,1,128,24,0,129,131,
39,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,0,0,125,128,
45,235,255,75,0,0,3,44,40,0,130,64,36,0,225,131,32,0,193,131,
28,0,161,131,44,0,1,128,24,0,129,131,28,0,96,56,166,3,8,124,
40,0,33,56,32,0,128,78,0,0,253,128,1,0,192,59,48,56,220,127,
65,181,6,72,232,3,0,56,29,0,64,61,60,48,74,57,9,0,32,61,
248,112,41,57,0,0,224,59,8,0,227,147,4,0,35,145,36,0,67,145,
40,0,131,147,20,0,3,144,2,0,3,160,32,0,0,96,2,0,3,176,
2,0,3,160,64,0,0,96,120,243,196,127,16,0,125,144,2,0,3,176,
229,186,6,72,0,0,125,128,16,0,157,128,120,251,230,127,144,0,0,56,
239,0,96,57,16,0,193,152,12,0,225,147,8,0,1,176,17,0,97,153,
10,0,193,179,8,0,161,56,36,0,128,57,18,0,129,177,57,88,4,72,
8,0,221,155,44,0,1,128,32,0,193,131,28,0,161,131,24,0,129,131,
36,0,225,131,27,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,
240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,16,0,127,128,0,0,192,59,8,0,223,155,12,0,67,169,
20,0,95,177,0,0,195,179,61,179,7,72,20,0,31,168,0,0,0,44,
16,0,223,147,26,0,96,56,8,0,130,65,40,0,96,56,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
216,255,33,148,24,0,129,147,32,0,193,147,36,0,225,147,166,2,8,124,
44,0,1,144,28,0,161,147,120,27,125,124,161,242,255,75,0,0,3,44,
40,0,130,65,36,0,225,131,32,0,193,131,28,0,161,131,44,0,1,128,
24,0,129,131,39,0,96,56,166,3,8,124,40,0,33,56,32,0,128,78,
0,0,253,128,1,0,192,59,48,56,220,127,205,179,6,72,232,3,0,56,
29,0,32,61,60,48,41,57,9,0,0,61,248,112,8,57,0,0,224,59,
8,0,227,147,4,0,3,145,36,0,35,145,40,0,131,147,20,0,3,144,
2,0,99,161,32,0,107,97,2,0,99,177,2,0,3,160,64,0,0,96,
120,243,196,127,16,0,125,144,2,0,3,176,113,185,6,72,0,0,125,128,
16,0,157,128,170,0,96,57,239,0,128,57,16,0,225,155,12,0,225,147,
8,0,97,177,17,0,129,153,10,0,225,179,8,0,161,56,120,251,230,127,
36,0,0,56,18,0,1,176,197,86,4,72,8,0,221,155,44,0,1,128,
32,0,193,131,28,0,161,131,24,0,129,131,36,0,225,131,25,0,96,56,
166,3,8,124,40,0,33,56,32,0,128,78,240,255,33,148,8,0,193,147,
166,2,8,124,20,0,1,144,12,0,225,147,120,27,127,124,16,0,127,128,
0,0,192,59,8,0,223,155,12,0,67,169,20,0,95,177,0,0,195,179,
201,177,7,72,20,0,31,168,0,0,0,44,16,0,223,147,24,0,96,56,
8,0,130,65,40,0,96,56,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,216,255,33,148,24,0,129,147,
32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,28,0,161,147,
120,27,125,124,45,241,255,75,0,0,3,44,40,0,130,65,36,0,225,131,
32,0,193,131,28,0,161,131,44,0,1,128,24,0,129,131,39,0,96,56,
166,3,8,124,40,0,33,56,32,0,128,78,0,0,253,128,1,0,192,59,
48,56,220,127,89,178,6,72,232,3,0,56,29,0,32,61,60,48,41,57,
9,0,0,61,248,112,8,57,0,0,224,59,8,0,227,147,4,0,3,145,
36,0,35,145,40,0,131,147,20,0,3,144,2,0,99,161,32,0,107,97,
2,0,99,177,2,0,3,160,64,0,0,96,120,243,196,127,16,0,125,144,
2,0,3,176,253,183,6,72,0,0,125,128,16,0,157,128,2,0,96,57,
239,0,128,57,16,0,225,155,12,0,225,147,8,0,97,177,17,0,129,153,
10,0,225,179,8,0,161,56,120,251,230,127,36,0,0,56,18,0,1,176,
81,85,4,72,8,0,221,155,44,0,1,128,32,0,193,131,28,0,161,131,
24,0,129,131,36,0,225,131,23,0,96,56,166,3,8,124,40,0,33,56,
32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,16,0,127,128,0,0,192,59,8,0,223,155,
12,0,67,169,20,0,95,177,0,0,195,179,85,176,7,72,20,0,31,168,
0,0,0,44,16,0,223,147,20,0,96,56,8,0,130,65,40,0,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,216,255,33,148,20,0,97,147,24,0,129,147,28,0,161,147,
36,0,225,147,166,2,8,124,44,0,1,144,32,0,193,147,120,27,126,124,
181,239,255,75,0,0,3,44,40,0,130,64,0,0,126,128,176,134,237,128,
1,0,160,56,48,24,172,124,120,96,231,124,176,134,237,144,173,229,255,75,
121,27,127,124,44,0,130,64,28,0,161,131,36,0,225,131,32,0,193,131,
24,0,129,131,44,0,1,128,20,0,97,131,39,0,96,56,166,3,8,124,
40,0,33,56,32,0,128,78,0,0,30,128,1,0,128,59,48,0,155,127,
185,176,6,72,232,3,64,57,29,0,0,60,60,48,0,48,9,0,0,61,
248,112,8,57,0,0,160,59,8,0,163,147,4,0,3,145,36,0,3,144,
40,0,99,147,20,0,67,145,2,0,3,160,32,0,0,96,2,0,3,176,
2,0,3,160,64,0,0,96,120,227,132,127,16,0,126,144,2,0,3,176,
93,182,6,72,16,0,126,128,0,0,158,128,120,251,229,127,157,180,6,72,
120,27,100,124,0,0,126,128,36,0,96,57,239,0,0,56,8,0,161,56,
12,0,161,147,3,0,64,57,8,0,65,177,64,0,159,57,10,0,129,177,
120,235,166,127,16,0,193,152,17,0,1,152,18,0,97,177,157,83,4,72,
5,0,254,155,8,0,158,155,28,0,161,131,36,0,225,131,32,0,193,131,
24,0,129,131,44,0,1,128,20,0,97,131,19,0,96,56,166,3,8,124,
40,0,33,56,32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,16,0,127,128,0,0,192,59,
8,0,223,155,12,0,67,169,20,0,95,177,0,0,195,179,153,174,7,72,
20,0,31,168,10,2,0,44,16,0,223,147,84,0,130,65,0,0,0,44,
32,0,130,65,12,0,225,131,20,0,1,128,8,0,193,131,40,0,96,56,
166,3,8,124,16,0,33,56,32,0,128,78,26,0,159,161,255,0,12,44,
48,0,31,152,32,0,130,65,12,0,225,131,20,0,1,128,8,0,193,131,
13,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,12,0,225,131,
20,0,1,128,8,0,193,131,18,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,185,237,255,75,0,0,3,44,32,0,130,65,
12,0,225,131,20,0,1,128,8,0,193,131,39,0,96,56,166,3,8,124,
16,0,33,56,32,0,128,78,0,0,126,128,29,0,128,60,60,48,132,56,
1,0,224,59,24,0,222,56,48,24,229,127,145,179,6,72,120,27,100,124,
2,0,100,161,32,0,107,97,2,0,100,177,2,0,132,161,0,0,126,128,
16,0,158,144,64,0,140,97,2,0,132,177,209,101,4,72,8,0,254,155,
12,0,225,131,20,0,1,128,8,0,193,131,17,0,96,56,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,161,128,141,137,232,3,0,56,116,7,140,125,80,3,44,17,
102,102,64,61,103,102,74,57,150,72,234,127,112,254,41,125,112,22,255,127,
80,248,233,127,120,251,227,127,121,224,3,72,0,0,3,44,24,0,130,65,
11,0,96,60,140,77,99,56,185,9,128,56,0,0,160,56,93,190,253,75,
156,128,141,129,160,128,13,136,1,0,96,57,117,7,0,124,20,250,140,125,
156,128,141,145,8,0,130,65,120,3,11,124,164,134,109,145,20,0,1,128,
12,0,225,131,13,0,96,56,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,16,0,127,128,0,0,192,59,8,0,223,155,12,0,67,169,
20,0,95,177,0,0,195,179,173,172,7,72,20,0,31,168,0,0,0,44,
16,0,223,147,4,0,96,56,8,0,130,65,40,0,96,56,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
224,255,33,148,20,0,161,147,24,0,193,147,166,2,8,124,36,0,1,144,
28,0,225,147,120,27,127,124,21,236,255,75,0,0,3,44,36,0,130,65,
28,0,225,131,24,0,193,131,36,0,1,128,20,0,161,131,39,0,96,56,
166,3,8,124,32,0,33,56,32,0,128,78,164,134,173,128,0,0,5,44,
255,255,5,56,164,134,13,144,36,0,130,64,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,15,0,96,56,166,3,8,124,32,0,33,56,
32,0,128,78,0,0,31,129,1,0,192,59,48,64,221,127,17,173,6,72,
208,7,0,56,29,0,128,61,60,48,140,57,9,0,96,61,248,112,107,57,
0,0,64,57,8,0,67,145,4,0,99,145,36,0,131,145,40,0,163,147,
20,0,3,144,2,0,3,160,32,0,0,96,2,0,3,176,2,0,195,160,
16,0,127,144,120,243,196,127,64,0,198,96,2,0,195,176,181,178,6,72,
0,0,191,128,248,191,141,128,11,0,96,60,172,77,99,56,169,27,4,72,
48,0,255,136,0,0,7,44,88,0,130,65,11,0,96,60,204,77,99,56,
145,27,4,72,0,0,127,128,16,0,159,128,7,0,128,57,0,0,192,56,
239,0,0,56,8,0,129,177,10,0,193,176,12,0,193,144,16,0,193,152,
17,0,1,152,8,0,161,56,36,0,96,57,18,0,97,177,221,79,4,72,
52,2,63,137,0,0,9,44,76,0,130,65,44,0,0,72,11,0,96,60,
160,77,99,56,61,27,4,72,0,0,127,128,16,0,159,128,0,0,160,56,
253,98,4,72,52,2,63,137,0,0,9,44,32,0,130,65,176,134,13,128,
0,0,159,129,1,0,96,57,180,134,109,153,48,96,106,125,120,80,0,124,
176,134,13,144,1,0,32,57,8,0,63,153,28,0,225,131,24,0,193,131,
36,0,1,128,20,0,161,131,14,0,96,56,166,3,8,124,32,0,33,56,
32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,20,0,225,147,
166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,16,0,126,128,
0,0,224,59,8,0,254,155,12,0,35,169,20,0,62,177,0,0,227,179,
133,170,7,72,20,0,30,168,0,0,0,44,16,0,254,147,40,0,130,65,
20,0,225,131,16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,
40,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,0,2,96,56,
145,6,4,72,120,27,124,124,52,0,158,56,0,2,160,56,253,56,4,72,
0,0,124,161,123,7,127,85,80,0,130,65,4,0,92,161,200,55,10,44,
1,0,0,56,16,0,130,65,140,115,10,44,8,0,130,65,0,0,0,56,
48,0,30,152,120,227,131,127,81,6,4,72,20,0,225,131,16,0,193,131,
12,0,161,131,28,0,1,128,8,0,129,131,13,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,11,0,160,63,120,251,227,127,169,218,255,75,
0,0,3,44,200,0,130,64,120,251,227,127,120,227,132,127,169,219,255,75,
0,0,30,128,64,0,31,124,80,0,130,64,0,0,3,44,32,0,130,65,
11,0,96,60,220,77,99,56,189,25,4,72,1,0,255,59,16,0,31,44,
188,255,128,65,152,0,0,72,120,251,227,127,17,221,255,75,0,0,3,44,
124,0,130,65,252,77,125,56,149,25,4,72,1,0,255,59,16,0,31,44,
148,255,128,65,112,0,0,72,0,0,3,44,92,0,130,65,120,251,227,127,
249,220,255,75,0,0,3,44,76,0,130,65,252,77,125,56,101,25,4,72,
120,251,227,127,201,220,255,75,0,0,3,44,120,251,227,127,1,0,192,56,
32,0,130,65,2,0,128,56,0,0,160,56,73,230,255,75,1,0,255,59,
16,0,31,44,64,255,128,65,28,0,0,72,0,0,128,56,120,35,133,124,
45,230,255,75,1,0,255,59,16,0,31,44,36,255,128,65,0,0,126,128,
120,227,132,127,69,227,255,75,6,0,126,152,120,227,131,127,49,5,4,72,
6,0,126,137,254,0,11,44,40,0,130,64,20,0,225,131,16,0,193,131,
12,0,161,131,28,0,1,128,8,0,129,131,42,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,0,0,126,128,221,223,255,75,0,0,3,44,
56,0,130,65,0,0,126,128,9,224,255,75,0,0,3,44,40,0,130,65,
20,0,225,131,16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,
16,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,20,0,225,131,
16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,18,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,
20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,120,27,125,124,
229,231,255,75,0,0,3,44,36,0,130,65,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,39,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,0,0,253,128,1,0,192,59,48,56,223,127,21,169,6,72,
208,7,96,57,29,0,64,61,60,48,74,57,9,0,32,61,248,112,41,57,
0,0,0,57,8,0,3,145,4,0,35,145,36,0,67,145,40,0,227,147,
20,0,99,145,2,0,131,161,32,0,140,97,2,0,131,177,2,0,3,160,
64,0,0,96,120,243,196,127,16,0,125,144,2,0,3,176,185,174,6,72,
0,0,125,128,16,0,157,128,52,0,189,56,253,98,4,72,8,0,221,155,
20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,12,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,12,0,161,147,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
16,0,126,128,0,0,224,59,8,0,254,155,12,0,131,169,20,0,158,177,
0,0,227,179,57,167,7,72,20,0,158,169,0,0,12,44,16,0,254,147,
36,0,130,65,20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,
41,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,0,2,96,56,
73,3,4,72,121,27,125,124,24,0,130,64,11,0,96,60,20,78,99,56,
89,5,128,56,0,0,160,56,37,184,253,75,0,0,30,128,96,2,0,28,
28,0,224,60,20,2,199,124,228,126,102,128,120,235,164,127,0,2,160,56,
233,211,6,72,20,0,126,176,0,0,224,59,120,251,231,127,60,8,232,84,
46,64,233,84,120,59,32,125,1,0,231,56,0,1,7,44,46,234,104,125,
120,2,106,125,120,83,255,127,62,4,255,87,220,255,128,65,120,235,163,127,
197,2,4,72,0,0,31,44,60,0,130,65,248,191,141,128,0,0,190,128,
120,251,230,127,11,0,96,60,40,78,99,56,133,22,4,72,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,41,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,20,0,225,131,16,0,193,131,28,0,1,128,
12,0,161,131,11,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
232,255,33,148,12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,
16,0,193,147,120,27,126,124,16,0,126,128,0,0,224,59,8,0,254,155,
12,0,99,169,20,0,126,177,0,0,227,179,241,165,7,72,20,0,30,168,
0,0,0,44,16,0,254,147,36,0,130,65,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,11,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,0,0,62,129,1,0,224,59,48,72,253,127,209,166,6,72,
208,7,0,56,29,0,128,61,60,48,140,57,9,0,96,61,248,112,107,57,
0,0,64,57,8,0,67,145,4,0,99,145,36,0,131,145,40,0,163,147,
20,0,3,144,2,0,227,160,32,0,231,96,2,0,227,176,2,0,3,161,
64,0,8,97,120,251,228,127,16,0,126,144,2,0,3,177,117,172,6,72,
0,0,126,128,96,2,3,28,28,0,64,61,20,2,138,125,228,126,172,128,
16,0,158,128,217,84,4,72,8,0,254,155,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,10,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,16,0,193,147,
166,2,8,124,28,0,1,144,20,0,225,147,120,27,127,124,0,2,96,56,
65,1,4,72,120,27,125,124,0,0,224,56,60,8,232,84,46,64,233,84,
120,59,42,125,1,0,231,56,0,1,7,44,46,235,72,125,232,255,128,65,
0,0,31,128,96,2,96,29,28,0,192,63,172,126,222,59,20,90,222,124,
56,0,102,128,120,235,164,127,0,2,160,56,121,210,6,72,120,235,163,127,
229,0,4,72,0,0,31,128,1,0,160,59,48,0,188,127,185,165,6,72,
208,7,0,57,29,0,224,60,60,48,231,56,9,0,192,60,248,112,198,56,
0,0,0,56,8,0,3,144,4,0,195,144,36,0,227,144,40,0,131,147,
20,0,3,145,2,0,35,161,32,0,41,97,2,0,35,177,2,0,99,161,
16,0,127,144,120,235,164,127,64,0,107,97,2,0,99,177,93,171,6,72,
0,0,127,128,96,2,131,29,20,98,222,124,56,0,166,128,16,0,159,128,
225,84,4,72,8,0,191,155,20,0,225,131,12,0,161,131,8,0,129,131,
28,0,1,128,16,0,193,131,9,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,16,0,127,128,0,0,192,59,8,0,223,155,
12,0,67,169,20,0,95,177,0,0,195,179,213,163,7,72,20,0,31,168,
0,0,0,44,16,0,223,147,6,0,96,56,8,0,130,65,41,0,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,11,0,32,57,
73,227,255,75,0,0,3,44,8,0,130,65,40,0,32,57,12,0,1,128,
8,0,33,56,166,3,8,124,120,75,35,125,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
16,0,126,128,0,0,224,59,8,0,254,155,12,0,67,169,20,0,94,177,
0,0,227,179,61,163,7,72,20,0,30,168,0,0,0,44,16,0,254,147,
32,0,130,65,12,0,225,131,20,0,1,128,8,0,193,131,40,0,96,56,
166,3,8,124,16,0,33,56,32,0,128,78,33,0,158,137,40,0,254,128,
251,7,159,85,0,0,7,44,40,0,130,65,36,0,222,136,64,48,31,124,
28,0,130,64,191,6,128,85,63,0,0,44,1,0,231,56,40,0,254,144,
116,0,130,64,32,1,0,72,153,129,109,137,255,7,96,85,72,0,130,65,
248,191,141,128,0,0,190,128,120,99,134,125,11,0,96,60,116,78,99,56,
209,18,4,72,40,0,254,128,0,0,7,44,24,0,130,65,36,0,158,136,
120,59,229,124,11,0,96,60,156,78,99,56,177,18,4,72,0,134,98,56,
169,18,4,72,33,0,158,137,191,6,128,85,63,0,0,44,120,251,230,127,
36,0,222,152,1,0,224,56,40,0,254,144,180,0,130,65,0,0,12,44,
28,0,130,64,5,0,7,44,28,0,128,65,153,129,45,137,255,7,32,85,
152,0,130,65,128,0,0,72,49,6,235,87,32,0,130,65,12,0,225,131,
20,0,1,128,8,0,193,131,4,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,36,0,236,115,44,0,130,64,88,0,224,115,8,0,0,40,
32,0,130,65,64,0,0,40,112,0,130,65,80,0,0,40,104,0,130,65,
88,0,0,40,96,0,130,65,32,0,0,72,12,0,225,131,20,0,1,128,
8,0,193,131,1,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,
153,129,45,137,255,7,32,85,24,0,130,65,248,191,141,128,0,0,190,128,
11,0,96,60,188,78,99,56,217,17,4,72,12,0,225,131,20,0,1,128,
8,0,193,131,39,0,96,56,166,3,8,124,16,0,33,56,32,0,128,78,
12,0,225,131,20,0,1,128,8,0,193,131,6,0,96,56,166,3,8,124,
16,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,33,225,255,75,0,0,3,44,
32,0,130,65,12,0,225,131,20,0,1,128,8,0,193,131,39,0,96,56,
166,3,8,124,16,0,33,56,32,0,128,78,0,0,126,128,29,0,128,60,
60,48,132,56,1,0,224,59,24,0,222,56,48,24,229,127,249,166,6,72,
120,27,100,124,2,0,100,161,32,0,107,97,2,0,100,177,2,0,132,161,
0,0,126,128,16,0,158,144,64,0,140,97,2,0,132,177,73,90,4,72,
8,0,254,155,12,0,225,131,20,0,1,128,8,0,193,131,5,0,96,56,
166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,27,125,124,16,0,125,128,0,0,224,59,8,0,253,155,12,0,99,169,
20,0,125,177,0,0,227,179,165,160,7,72,16,0,253,147,120,235,163,127,
81,224,255,75,0,0,3,44,40,0,130,65,20,0,225,131,16,0,193,131,
12,0,161,131,28,0,1,128,8,0,129,131,39,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,20,0,253,168,0,0,7,44,40,0,130,65,
20,0,225,131,16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,
40,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,33,0,61,137,
127,0,9,44,56,2,253,128,248,191,205,128,80,48,135,127,100,0,130,64,
0,0,125,128,40,0,28,40,44,0,129,64,172,134,13,128,168,134,109,129,
4,0,224,59,1,0,107,57,1,0,32,57,48,24,40,125,120,64,0,124,
172,134,13,144,168,134,109,145,20,1,0,72,9,70,2,72,0,0,157,129,
0,0,160,56,29,0,96,60,60,48,99,56,1,0,192,59,2,0,224,59,
48,96,196,127,33,144,7,72,8,0,221,155,232,0,0,72,238,0,32,113,
150,0,28,40,64,0,8,104,52,0,0,125,126,217,0,84,12,0,129,65,
0,0,0,44,196,0,130,65,0,0,29,128,128,0,9,44,4,0,224,59,
32,0,130,64,172,134,45,129,1,0,96,57,48,0,103,125,121,56,41,125,
172,134,45,145,160,0,130,64,48,0,0,72,176,134,205,128,248,191,13,129,
172,134,45,129,1,0,128,57,48,0,135,125,56,2,29,145,121,56,41,125,
120,59,198,124,172,134,45,145,176,134,205,144,112,0,130,64,176,134,45,129,
0,0,9,44,100,0,130,64,161,128,109,137,232,3,128,57,116,7,107,125,
80,99,75,17,102,102,0,60,103,102,0,96,150,80,192,127,112,254,64,125,
112,22,222,127,80,240,192,127,81,240,220,127,20,0,129,65,156,128,13,129,
20,226,200,124,156,128,205,144,36,0,0,72,120,243,195,127,57,210,3,72,
156,128,13,129,20,242,8,125,20,226,200,124,156,128,205,144,8,0,0,72,
2,0,224,59,120,251,227,127,20,0,225,131,16,0,193,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,89,222,255,75,0,0,3,44,32,0,130,65,12,0,225,131,
20,0,1,128,8,0,193,131,39,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,0,0,126,128,29,0,128,60,60,48,132,56,1,0,224,59,
24,0,222,56,48,24,229,127,49,164,6,72,120,27,100,124,2,0,100,161,
32,0,107,97,2,0,100,177,2,0,132,161,0,0,126,128,16,0,158,144,
64,0,140,97,2,0,132,177,129,87,4,72,8,0,254,155,12,0,225,131,
20,0,1,128,8,0,193,131,3,0,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,224,255,33,148,12,0,97,147,16,0,129,147,24,0,193,147,
28,0,225,147,166,2,8,124,36,0,1,144,20,0,161,147,120,27,125,124,
52,2,29,136,0,0,0,44,84,1,130,65,172,134,237,128,0,0,7,44,
20,0,130,65,168,134,237,128,0,0,7,44,188,0,129,64,128,0,0,72,
176,134,13,128,0,0,0,44,20,0,130,65,168,134,237,128,0,0,7,44,
160,0,129,64,100,0,0,72,180,134,77,137,0,0,10,44,64,0,130,65,
161,128,13,136,232,3,192,56,116,7,0,124,80,51,128,17,102,102,0,60,
103,102,0,96,150,96,224,127,112,254,136,125,112,22,255,127,80,248,232,127,
120,251,227,127,181,208,3,72,156,128,141,129,20,250,140,125,156,128,141,145,
160,128,237,136,0,0,192,56,117,7,231,124,168,134,237,144,180,134,205,152,
60,0,129,64,255,255,39,57,168,134,45,145,196,136,45,161,0,0,157,129,
172,134,205,128,248,191,13,129,1,0,96,57,12,0,29,145,48,96,106,125,
247,6,41,85,120,83,198,124,172,134,205,144,148,0,130,65,152,0,0,72,
0,0,125,129,1,0,192,59,48,88,219,127,41,158,6,72,120,27,124,124,
2,0,64,57,29,0,32,61,60,48,41,57,9,0,224,60,248,112,231,56,
0,0,224,59,8,0,227,147,4,0,227,144,36,0,35,145,40,0,99,147,
20,0,67,145,120,251,228,127,229,163,6,72,0,0,252,179,120,227,131,127,
197,156,7,72,8,0,221,155,120,243,195,127,24,0,193,131,28,0,225,131,
36,0,1,128,12,0,97,131,16,0,129,131,20,0,161,131,166,3,8,124,
32,0,33,56,32,0,128,78,196,136,45,161,247,6,41,85,12,0,130,64,
0,0,125,128,161,66,2,72,248,191,77,129,0,0,192,59,56,2,93,145,
8,0,221,155,24,0,193,131,20,0,161,131,36,0,1,128,28,0,225,131,
12,0,97,131,16,0,129,131,2,0,96,56,166,3,8,124,32,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,0,0,95,129,9,128,13,136,116,7,0,124,0,0,10,124,
28,0,128,65,20,0,1,128,12,0,225,131,38,0,96,56,16,0,33,56,
166,3,8,124,32,0,128,78,96,2,10,28,248,191,109,129,0,0,32,57,
28,0,128,61,12,0,127,145,44,0,63,145,172,126,140,57,20,2,108,124,
177,217,254,75,4,0,31,136,0,0,0,44,1,0,96,56,8,0,130,65,
43,0,96,56,20,0,1,128,12,0,225,131,116,7,99,124,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,12,0,225,147,20,0,190,168,61,2,30,136,
116,7,0,124,11,0,0,61,100,79,8,57,54,32,0,84,20,2,136,125,
4,0,204,128,120,35,159,124,0,0,158,128,11,0,96,60,240,78,99,56,
141,11,4,72,4,0,30,136,0,0,0,44,172,134,13,128,0,0,126,128,
176,134,141,129,1,0,64,57,48,24,73,125,120,72,140,125,176,134,141,145,
120,72,0,124,172,134,13,144,8,0,130,65,241,0,224,59,120,251,228,127,
0,0,160,56,120,43,166,124,81,216,255,75,0,0,62,129,96,2,9,29,
0,0,0,56,7,0,30,152,28,0,72,61,172,126,106,56,21,216,254,75,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,8,0,193,147,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,166,0,192,127,94,4,192,87,36,1,0,124,
0,0,127,128,85,206,255,75,0,0,3,44,76,0,130,64,0,0,127,128,
237,214,255,75,0,0,127,128,6,0,159,136,0,0,160,56,1,0,192,56,
205,215,255,75,0,128,202,115,166,0,0,124,94,4,0,84,120,83,0,124,
36,1,0,124,4,0,127,137,0,0,11,44,0,0,0,56,7,0,31,152,
76,0,130,65,44,0,0,72,1,0,0,56,4,0,31,152,120,3,11,124,
0,128,202,115,166,0,0,124,94,4,0,84,120,83,0,124,36,1,0,124,
0,0,0,56,7,0,31,152,0,0,95,129,96,2,10,28,28,0,96,61,
172,126,107,57,20,2,107,124,65,215,254,75,4,0,127,137,0,0,11,44,
46,0,96,56,8,0,130,65,45,0,96,56,12,0,225,131,20,0,1,128,
8,0,193,131,116,7,99,124,166,3,8,124,16,0,33,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,254,0,128,56,65,254,255,75,
12,0,1,128,8,0,33,56,166,3,8,124,42,0,96,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,0,0,128,56,25,254,255,75,
12,0,1,128,8,0,33,56,166,3,8,124,41,0,96,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,0,0,128,56,241,253,255,75,
12,0,1,128,8,0,33,56,166,3,8,124,40,0,96,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,172,134,13,128,
176,134,77,129,120,27,127,124,0,0,127,128,0,0,128,56,120,35,134,124,
120,35,133,124,1,0,128,57,48,24,139,125,120,88,0,124,172,134,13,144,
120,88,74,125,176,134,77,145,113,214,255,75,0,0,95,129,96,2,10,28,
28,0,128,61,0,0,96,57,172,126,140,57,7,0,127,153,20,2,108,124,
49,214,254,75,20,0,1,128,12,0,225,131,39,0,96,56,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,0,0,127,128,0,0,128,56,120,35,133,124,
120,35,134,124,17,214,255,75,0,0,0,56,7,0,31,152,20,0,1,128,
12,0,225,131,38,0,96,56,16,0,33,56,166,3,8,124,32,0,128,78,
232,255,33,148,12,0,161,147,16,0,193,147,166,2,8,124,28,0,1,144,
20,0,225,147,120,27,127,124,60,2,127,137,11,0,192,63,116,7,107,125,
100,79,222,59,47,0,11,44,76,0,128,65,11,0,96,60,44,79,99,56,
147,1,128,56,0,0,160,56,197,169,253,75,60,2,127,137,0,0,3,44,
116,7,107,125,40,0,130,65,54,32,102,85,20,50,62,125,8,0,9,168,
10,0,137,169,0,0,12,44,120,91,125,125,20,2,127,124,80,0,128,64,
36,0,0,72,54,32,102,85,20,50,62,125,8,0,9,168,10,0,137,169,
0,0,12,44,120,91,125,125,20,2,127,124,44,0,128,64,12,0,9,129,
166,3,9,125,33,4,128,78,7,0,31,136,8,0,95,137,0,0,10,44,
120,27,107,124,60,2,127,153,116,0,130,65,104,0,0,72,12,0,9,168,
20,2,99,125,191,7,102,85,56,24,140,85,12,0,130,64,0,0,235,128,
36,0,0,72,80,88,102,125,0,0,11,128,4,0,235,128,56,24,198,84,
48,52,0,124,32,0,198,32,48,48,231,124,120,3,231,124,20,98,71,125,
4,0,10,129,166,3,9,125,33,4,128,78,7,0,31,136,8,0,95,137,
0,0,10,44,120,27,107,124,60,2,127,153,12,0,130,65,61,2,191,155,
16,0,0,72,0,0,0,44,248,254,130,64,61,2,191,155,120,3,3,124,
28,0,1,128,20,0,225,131,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,240,255,33,148,0,0,4,44,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,8,0,193,147,0,0,192,59,
24,0,130,65,0,0,127,128,253,203,255,75,255,255,3,44,8,0,130,65,
1,0,192,59,162,128,237,136,161,128,13,136,255,0,96,57,52,2,255,152,
36,0,127,153,117,7,0,124,4,0,223,155,0,0,192,56,1,0,0,57,
60,2,223,152,7,0,31,153,8,0,223,152,12,0,223,144,20,0,223,176,
40,0,223,144,8,0,130,64,52,2,31,152,0,0,127,128,61,211,255,75,
4,0,63,137,0,0,127,128,0,0,128,56,1,0,38,105,120,35,133,124,
62,6,198,84,245,211,255,75,160,128,205,136,116,7,198,124,1,0,6,44,
52,2,31,136,38,0,96,125,254,15,106,85,57,80,12,124,12,0,130,65,
1,0,192,56,160,128,205,152,0,0,0,44,0,0,0,56,16,0,128,57,
156,128,13,144,8,0,130,64,120,51,204,124,248,191,13,128,56,2,31,144,
0,0,32,57,164,134,141,145,180,134,45,153,176,134,45,145,172,134,45,145,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
120,27,127,124,16,0,127,128,0,0,3,44,8,0,130,65,33,158,6,72,
0,0,127,128,0,0,128,56,120,35,133,124,120,35,134,124,73,211,255,75,
0,0,31,128,96,2,128,29,0,0,64,57,7,0,95,153,8,0,95,153,
28,0,108,61,172,126,107,56,9,211,254,75,39,0,0,56,60,2,31,152,
4,2,0,56,20,0,31,176,20,0,1,128,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
29,0,96,60,60,48,99,56,11,0,128,60,64,79,132,56,237,177,3,72,
0,0,3,44,24,0,130,65,11,0,96,60,80,79,99,56,13,1,128,56,
0,0,160,56,229,166,253,75,1,0,96,56,37,122,4,72,184,134,109,144,
0,0,96,57,29,0,128,61,252,9,140,57,64,2,108,149,1,0,107,57,
16,0,11,44,244,255,128,65,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,29,0,96,61,136,48,107,57,0,0,128,57,4,0,139,145,
8,0,139,145,12,0,139,145,12,0,96,60,72,21,99,56,32,235,3,72,
166,2,8,124,4,0,1,144,248,255,33,148,0,0,3,136,190,215,8,84,
188,134,45,57,58,16,10,85,46,72,138,125,0,0,12,44,120,35,134,124,
12,4,96,56,190,6,4,84,28,0,130,65,36,0,108,129,124,0,43,129,
120,99,131,125,13,0,160,56,166,3,41,125,33,4,128,78,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,2,0,3,44,
8,0,193,147,12,0,225,147,166,2,8,124,120,27,100,124,20,0,1,144,
44,0,128,65,11,0,96,60,140,82,99,56,221,4,4,72,12,0,225,131,
20,0,1,128,8,0,193,131,12,4,96,56,166,3,8,124,16,0,33,56,
32,0,128,78,188,134,237,59,58,16,126,84,46,240,31,124,0,0,0,44,
44,0,130,65,11,0,96,60,168,82,99,56,161,4,4,72,46,240,127,124,
36,0,131,129,132,0,12,128,166,3,9,124,33,4,128,78,0,0,96,56,
20,0,0,72,11,0,96,60,212,82,99,56,121,4,4,72,0,0,96,56,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,232,255,33,148,166,2,8,124,28,0,1,144,16,0,193,147,
11,0,192,63,20,0,225,147,120,27,127,124,12,0,161,147,29,0,160,63,
92,48,125,56,8,0,161,56,0,0,128,56,120,35,134,124,120,35,135,124,
120,59,232,124,213,167,3,72,0,0,3,44,20,0,130,65,244,82,126,56,
209,5,128,56,0,0,160,56,41,165,253,75,8,0,33,129,1,0,9,44,
112,0,130,65,100,0,0,56,80,3,127,17,102,102,0,60,103,102,0,96,
150,88,128,124,92,48,125,56,166,128,237,155,0,0,160,56,112,254,96,125,
112,22,132,124,80,32,128,124,241,191,3,72,0,0,3,44,20,0,130,65,
244,82,126,56,214,5,128,56,0,0,160,56,213,164,253,75,92,48,125,56,
21,193,3,72,0,0,3,44,24,0,130,65,244,82,126,56,215,5,128,56,
0,0,160,56,181,164,253,75,0,0,3,44,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
224,255,33,148,8,0,65,147,12,0,97,147,16,0,129,147,24,0,193,147,
28,0,225,147,166,2,8,124,36,0,1,144,20,0,161,147,29,0,160,63,
136,48,189,59,4,0,29,128,0,0,0,44,255,0,192,59,0,0,224,59,
16,0,130,65,8,0,61,129,80,72,0,125,112,22,31,125,63,6,255,87,
0,0,96,59,100,0,130,65,4,0,157,129,58,16,106,87,46,80,108,124,
25,154,0,72,63,6,124,84,0,0,64,59,60,0,129,64,4,0,253,128,
58,16,96,87,46,0,103,124,166,128,173,136,120,211,68,127,117,152,0,72,
0,0,3,44,16,0,130,65,64,240,3,124,8,0,128,64,120,27,126,124,
255,255,156,55,1,0,90,59,204,255,130,64,255,255,255,55,1,0,123,59,
164,255,130,64,93,146,0,72,63,6,127,84,0,0,160,59,48,0,130,65,
166,128,141,136,120,235,163,127,201,144,0,72,0,0,3,44,16,0,130,65,
64,240,3,124,8,0,128,64,120,27,126,124,255,255,255,55,1,0,189,59,
216,255,130,64,255,0,30,44,52,0,130,65,62,6,195,87,21,254,255,75,
24,0,193,131,16,0,129,131,20,0,161,131,28,0,225,131,36,0,1,128,
12,0,97,131,8,0,65,131,166,3,8,124,32,0,33,56,32,0,128,78,
29,0,96,60,92,48,99,56,157,190,3,72,24,0,193,131,16,0,129,131,
20,0,161,131,28,0,225,131,36,0,1,128,12,0,97,131,8,0,65,131,
166,3,8,124,32,0,33,56,32,0,128,78,212,192,109,56,0,1,128,60,
0,0,160,56,56,130,7,72,240,255,33,148,2,0,5,40,166,2,8,124,
20,0,1,144,120,27,96,124,12,0,225,147,12,4,224,59,56,0,128,64,
58,16,165,84,188,134,77,57,46,80,101,124,0,0,3,44,48,0,130,65,
36,0,131,129,140,0,108,129,120,35,133,124,166,3,105,125,120,3,4,124,
33,4,128,78,120,27,127,124,16,0,0,72,11,0,96,60,0,83,99,56,
161,1,4,72,20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,
166,3,8,124,32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,196,134,77,137,
255,7,74,85,120,43,190,124,24,0,130,64,16,0,193,131,24,0,33,56,
166,3,8,124,17,4,96,56,32,0,128,78,9,128,13,136,116,7,0,124,
64,0,3,124,44,0,128,64,29,0,192,60,152,48,198,56,56,24,96,84,
20,2,134,125,4,0,172,131,46,0,134,127,255,255,28,44,12,0,130,65,
255,255,29,44,40,0,130,64,20,0,225,131,16,0,193,131,12,0,161,131,
28,0,1,128,8,0,129,131,14,1,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,13,0,4,40,0,0,224,59,68,0,130,64,120,27,100,124,
11,0,96,60,40,83,99,56,209,0,4,72,58,16,133,87,188,134,13,56,
46,0,101,124,36,0,3,129,124,0,8,128,120,235,164,127,120,243,198,127,
13,0,160,56,166,3,9,124,33,4,128,78,120,27,127,124,16,0,0,72,
11,0,96,60,72,83,99,56,149,0,4,72,120,251,227,127,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,196,134,13,136,
255,7,0,84,120,43,190,124,28,0,130,64,28,0,1,128,16,0,193,131,
17,4,96,56,24,0,33,56,166,3,8,124,32,0,128,78,9,128,237,136,
116,7,231,124,64,56,3,124,44,0,128,64,29,0,128,61,152,48,140,57,
56,24,107,84,20,90,12,125,4,0,168,131,46,88,140,127,255,255,28,44,
12,0,130,65,255,255,29,44,40,0,130,64,20,0,225,131,16,0,193,131,
12,0,161,131,28,0,1,128,8,0,129,131,14,1,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,14,0,4,40,0,0,224,59,24,4,129,65,
3,0,128,61,176,230,140,57,58,16,128,84,46,0,76,125,166,3,73,125,
32,4,128,78,172,232,2,0,236,232,2,0,44,233,2,0,172,231,2,0,
236,231,2,0,44,232,2,0,108,233,2,0,108,232,2,0,236,230,2,0,
44,231,2,0,172,233,2,0,236,233,2,0,44,234,2,0,108,234,2,0,
44,231,2,0,120,27,100,124,11,0,96,60,32,84,99,56,97,255,3,72,
58,16,135,87,188,134,13,57,46,64,103,124,36,0,35,129,116,0,73,129,
120,235,164,127,120,243,198,127,8,0,160,56,166,3,73,125,33,4,128,78,
120,27,127,124,144,3,0,72,14,0,4,44,120,27,100,124,58,16,159,87,
60,0,130,64,11,0,96,60,64,84,99,56,21,255,3,72,188,134,109,57,
46,88,127,124,36,0,131,129,116,0,12,128,120,235,164,127,120,243,198,127,
14,0,160,56,166,3,9,124,33,4,128,78,120,27,127,124,72,3,0,72,
11,0,96,60,104,84,99,56,221,254,3,72,188,134,237,56,46,56,127,124,
36,0,3,129,116,0,40,129,120,235,164,127,120,243,198,127,9,0,160,56,
166,3,41,125,33,4,128,78,120,27,127,124,16,3,0,72,120,27,100,124,
11,0,96,60,144,84,99,56,161,254,3,72,58,16,138,87,188,134,13,56,
46,0,106,124,36,0,131,129,116,0,236,128,120,235,164,127,120,243,198,127,
3,0,160,56,166,3,233,124,33,4,128,78,120,27,127,124,208,2,0,72,
120,27,100,124,11,0,96,60,176,84,99,56,97,254,3,72,58,16,136,87,
188,134,45,57,46,72,104,124,36,0,67,129,116,0,10,128,120,235,164,127,
120,243,198,127,4,0,160,56,166,3,9,124,33,4,128,78,120,27,127,124,
144,2,0,72,120,27,100,124,11,0,96,60,132,83,99,56,33,254,3,72,
58,16,140,87,188,134,237,56,46,56,108,124,36,0,3,129,116,0,40,129,
120,235,164,127,120,243,198,127,5,0,160,56,166,3,41,125,33,4,128,78,
120,27,127,124,80,2,0,72,120,27,100,124,11,0,96,60,160,83,99,56,
225,253,3,72,58,16,138,87,188,134,13,56,46,0,106,124,36,0,131,129,
116,0,236,128,120,235,164,127,120,243,198,127,7,0,160,56,166,3,233,124,
33,4,128,78,120,27,127,124,16,2,0,72,120,27,100,124,11,0,96,60,
192,83,99,56,161,253,3,72,58,16,136,87,188,134,45,57,46,72,104,124,
36,0,67,129,116,0,10,128,120,235,164,127,120,243,198,127,0,0,160,56,
166,3,9,124,33,4,128,78,120,27,127,124,208,1,0,72,120,27,100,124,
11,0,96,60,224,83,99,56,97,253,3,72,58,16,140,87,188,134,237,56,
46,56,108,124,36,0,3,129,116,0,40,129,120,235,164,127,120,243,198,127,
1,0,160,56,166,3,41,125,33,4,128,78,120,27,127,124,144,1,0,72,
120,27,100,124,11,0,96,60,208,84,99,56,33,253,3,72,58,16,138,87,
188,134,13,56,46,0,106,124,36,0,131,129,116,0,236,128,120,235,164,127,
120,243,198,127,2,0,160,56,166,3,233,124,33,4,128,78,120,27,127,124,
80,1,0,72,120,27,100,124,11,0,96,60,236,84,99,56,225,252,3,72,
58,16,136,87,188,134,45,57,46,72,104,124,36,0,67,129,116,0,106,129,
120,235,164,127,120,243,198,127,6,0,160,56,166,3,105,125,33,4,128,78,
120,27,127,124,16,1,0,72,120,27,100,124,11,0,96,60,16,85,99,56,
161,252,3,72,58,16,140,87,188,134,13,56,46,0,108,124,36,0,67,129,
116,0,10,128,120,235,164,127,120,243,198,127,10,0,160,56,166,3,9,124,
33,4,128,78,120,27,127,124,208,0,0,72,120,27,100,124,11,0,96,60,
60,85,99,56,97,252,3,72,58,16,140,87,188,134,237,56,46,56,108,124,
36,0,3,129,116,0,40,129,120,235,164,127,120,243,198,127,11,0,160,56,
166,3,41,125,33,4,128,78,120,27,127,124,144,0,0,72,120,27,100,124,
11,0,96,60,0,84,99,56,33,252,3,72,58,16,138,87,188,134,109,57,
46,88,106,124,36,0,131,129,116,0,12,128,120,235,164,127,120,243,198,127,
12,0,160,56,166,3,9,124,33,4,128,78,120,27,127,124,80,0,0,72,
120,27,100,124,11,0,96,60,100,83,99,56,225,251,3,72,58,16,135,87,
188,134,13,57,46,64,103,124,36,0,35,129,116,0,73,129,120,235,164,127,
120,243,198,127,13,0,160,56,166,3,73,125,33,4,128,78,120,27,127,124,
16,0,0,72,11,0,96,60,100,85,99,56,165,251,3,72,120,251,227,127,
20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,8,0,129,131,
166,3,8,124,24,0,33,56,32,0,128,78,224,255,33,148,12,0,97,147,
16,0,129,147,20,0,161,147,24,0,193,147,28,0,225,147,166,2,8,124,
36,0,1,144,196,134,13,136,255,7,0,84,120,27,124,124,0,0,192,59,
32,0,130,64,24,0,193,131,36,0,1,128,16,0,129,131,17,4,96,56,
166,3,8,124,32,0,33,56,32,0,128,78,9,128,13,136,116,7,0,124,
64,0,28,124,44,0,128,65,20,0,161,131,28,0,225,131,24,0,193,131,
16,0,129,131,36,0,1,128,12,0,97,131,14,1,96,56,166,3,8,124,
32,0,33,56,32,0,128,78,120,227,131,127,141,191,255,75,120,27,123,124,
16,0,27,40,0,0,224,59,28,0,128,64,58,16,106,87,20,218,10,124,
56,24,0,84,248,193,141,57,20,2,108,125,8,0,235,131,0,0,160,59,
120,227,131,127,13,0,128,56,8,0,161,56,49,249,255,75,0,0,3,44,
8,0,130,64,8,0,161,139,8,0,161,155,120,227,131,127,85,187,255,75,
8,0,1,136,0,0,0,44,120,27,125,124,48,0,130,65,120,227,131,127,
13,0,128,56,1,0,160,56,17,250,255,75,120,27,126,124,120,219,99,127,
120,227,132,127,65,51,7,72,0,0,3,44,88,0,130,65,52,0,0,72,
0,0,29,44,24,0,130,64,120,227,131,127,1,0,128,56,120,35,133,124,
221,249,255,75,120,27,126,124,120,219,99,127,120,227,132,127,13,51,7,72,
0,0,3,44,36,0,130,65,0,0,29,44,28,0,130,65,120,227,131,127,
4,0,128,56,1,0,160,56,173,249,255,75,120,27,126,124,228,0,0,72,
120,219,99,127,120,227,132,127,93,88,7,72,0,0,3,44,120,227,131,127,
24,0,130,65,3,0,128,56,1,0,160,56,129,249,255,75,120,27,126,124,
184,0,0,72,85,187,255,75,0,0,3,44,120,227,131,127,24,0,130,65,
8,0,128,56,1,0,160,56,93,249,255,75,120,27,126,124,148,0,0,72,
25,187,255,75,0,0,3,44,120,227,131,127,24,0,130,65,9,0,128,56,
1,0,160,56,57,249,255,75,120,27,126,124,112,0,0,72,221,186,255,75,
0,0,3,44,28,0,130,65,120,227,131,127,14,0,128,56,1,0,160,56,
21,249,255,75,120,27,126,124,76,0,0,72,0,0,31,44,40,0,130,65,
6,0,31,137,13,0,8,44,28,0,130,64,120,227,131,127,6,0,128,56,
1,0,160,56,233,248,255,75,120,27,126,124,32,0,0,72,0,0,29,44,
24,0,130,65,120,227,131,127,5,0,128,56,1,0,160,56,201,248,255,75,
120,27,126,124,20,0,161,131,120,243,195,127,24,0,193,131,28,0,225,131,
36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,32,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,
0,0,224,59,8,0,193,147,16,0,192,59,120,251,227,127,105,253,255,75,
255,255,222,55,1,0,255,59,240,255,130,64,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,216,255,33,148,
8,0,1,147,12,0,33,147,16,0,65,147,20,0,97,147,24,0,129,147,
28,0,161,147,32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,
196,134,45,137,0,0,224,59,120,43,186,124,255,7,41,85,120,35,153,124,
120,27,126,124,36,0,130,64,16,0,65,131,36,0,225,131,32,0,193,131,
12,0,33,131,166,3,8,124,17,4,96,56,40,0,33,56,32,0,128,78,
16,0,30,40,36,0,128,64,58,16,204,87,20,242,12,124,56,24,0,84,
248,193,237,56,20,2,199,124,8,0,6,129,0,0,8,44,56,0,130,64,
32,0,193,131,20,0,97,131,16,0,65,131,28,0,161,131,36,0,225,131,
24,0,129,131,12,0,33,131,44,0,1,128,8,0,1,131,10,1,96,56,
166,3,8,124,40,0,33,56,32,0,128,78,9,0,25,40,76,2,129,65,
3,0,128,61,128,238,140,57,58,16,32,87,46,0,12,124,166,3,9,124,
32,4,128,78,220,238,2,0,16,239,2,0,168,238,2,0,80,240,2,0,
128,240,2,0,68,239,2,0,132,239,2,0,28,240,2,0,232,239,2,0,
184,239,2,0,120,243,196,127,11,0,96,60,216,85,99,56,165,247,3,72,
120,243,195,127,120,211,69,127,1,0,128,56,129,134,0,72,3,0,25,44,
12,0,0,59,120,27,127,124,240,1,130,64,172,2,0,72,120,243,196,127,
11,0,96,60,116,86,99,56,113,247,3,72,120,243,195,127,120,211,69,127,
2,0,128,56,77,134,0,72,3,0,25,44,10,0,0,59,120,27,127,124,
188,1,130,64,120,2,0,72,120,243,196,127,11,0,96,60,148,86,99,56,
61,247,3,72,120,243,195,127,120,211,69,127,4,0,128,56,25,134,0,72,
3,0,25,44,10,0,0,59,120,27,127,124,136,1,130,64,68,2,0,72,
120,243,196,127,11,0,96,60,248,85,99,56,9,247,3,72,120,243,195,127,
120,211,69,127,0,0,128,56,229,133,0,72,196,134,237,136,189,7,231,84,
120,27,127,124,20,2,130,65,3,0,25,44,5,0,0,59,72,1,130,64,
4,2,0,72,120,243,196,127,11,0,96,60,20,86,99,56,201,246,3,72,
120,243,195,127,120,211,69,127,0,0,128,56,165,133,0,72,3,0,25,44,
7,0,0,59,120,27,127,124,20,1,130,64,208,1,0,72,120,243,196,127,
11,0,96,60,52,86,99,56,149,246,3,72,120,243,195,127,120,211,69,127,
5,0,128,56,113,133,0,72,3,0,25,44,120,27,127,124,228,0,130,64,
160,1,0,72,120,243,196,127,11,0,96,60,84,86,99,56,101,246,3,72,
120,243,195,127,120,211,69,127,5,0,128,56,65,133,0,72,3,0,25,44,
0,0,0,59,120,27,127,124,176,0,130,64,108,1,0,72,120,243,196,127,
11,0,96,60,160,85,99,56,49,246,3,72,120,243,195,127,120,211,69,127,
3,0,128,56,13,133,0,72,3,0,25,44,11,0,0,59,120,27,127,124,
124,0,130,64,56,1,0,72,120,243,196,127,11,0,96,60,180,86,99,56,
253,245,3,72,120,243,195,127,120,211,69,127,6,0,128,56,217,132,0,72,
3,0,25,44,120,27,127,124,76,0,130,64,8,1,0,72,120,243,196,127,
11,0,96,60,188,85,99,56,205,245,3,72,120,243,195,127,120,211,69,127,
7,0,128,56,169,132,0,72,3,0,25,44,120,27,127,124,28,0,130,64,
216,0,0,72,11,0,96,60,128,85,99,56,161,245,3,72,3,0,25,44,
196,0,130,65,9,0,25,44,188,0,130,65,4,0,25,44,180,0,130,65,
0,0,31,44,172,0,130,64,120,243,195,127,249,6,7,72,120,27,123,124,
0,0,128,59,16,0,160,59,1,0,192,59,48,224,200,127,57,64,96,127,
124,0,130,65,120,227,131,127,13,182,255,75,0,0,3,44,108,0,130,65,
2,0,25,44,52,0,130,65,7,0,25,44,44,0,130,65,8,0,25,44,
36,0,130,65,6,0,25,44,28,0,130,65,5,0,25,44,20,0,130,65,
120,227,131,127,161,249,255,75,121,27,127,124,64,0,130,64,120,227,131,127,
120,195,4,127,120,211,69,127,153,244,255,75,121,27,127,124,40,0,130,64,
5,0,25,44,20,0,130,64,120,227,131,127,113,249,255,75,121,27,127,124,
16,0,130,64,255,255,189,55,1,0,156,59,116,255,130,64,16,0,65,131,
24,0,129,131,28,0,161,131,120,251,227,127,36,0,225,131,20,0,97,131,
32,0,193,131,44,0,1,128,12,0,33,131,8,0,1,131,166,3,8,124,
40,0,33,56,32,0,128,78,224,255,33,148,20,0,161,147,24,0,193,147,
28,0,225,147,166,2,8,124,36,0,1,144,196,134,141,137,255,7,140,85,
120,27,125,124,10,1,192,59,28,0,130,64,24,0,193,131,20,0,161,131,
166,3,8,124,17,4,96,56,32,0,33,56,32,0,128,78,16,0,29,40,
0,0,224,59,28,0,128,64,58,16,167,87,20,234,7,124,56,24,0,84,
248,193,109,57,20,2,43,125,8,0,233,131,120,235,163,127,12,0,129,56,
8,0,161,56,209,28,7,72,0,0,31,44,228,0,130,65,120,235,163,127,
6,0,128,56,1,0,160,56,255,255,192,56,85,251,255,75,6,0,31,136,
64,0,0,44,120,235,163,127,255,255,192,56,24,0,130,64,7,0,128,56,
1,0,160,56,53,251,255,75,120,27,126,124,168,0,0,72,8,0,1,168,
62,4,10,84,255,223,73,85,24,0,130,65,3,0,128,56,1,0,160,56,
17,251,255,75,120,27,126,124,132,0,0,72,255,255,75,85,24,0,130,65,
0,0,128,56,1,0,160,56,245,250,255,75,120,27,126,124,104,0,0,72,
62,4,8,84,255,247,5,85,24,0,130,65,1,0,128,56,120,35,133,124,
213,250,255,75,120,27,126,124,72,0,0,72,255,231,10,85,1,0,160,56,
20,0,130,65,2,0,128,56,185,250,255,75,120,27,126,124,44,0,0,72,
62,4,0,84,255,239,12,84,20,0,130,65,4,0,128,56,157,250,255,75,
120,27,126,124,16,0,0,72,5,0,128,56,141,250,255,75,120,27,126,124,
120,243,195,127,24,0,193,131,36,0,1,128,28,0,225,131,20,0,161,131,
166,3,8,124,32,0,33,56,32,0,128,78,232,255,33,148,166,2,8,124,
28,0,1,144,20,0,225,147,0,0,96,56,120,27,127,124,12,0,161,147,
16,0,160,59,16,0,193,147,0,0,192,63,56,66,222,59,48,0,30,128,
0,0,0,44,40,0,222,59,20,0,130,65,120,251,227,127,65,254,255,75,
0,0,3,44,16,0,130,64,255,255,189,55,1,0,255,59,216,255,130,64,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
58,16,172,84,188,134,109,57,46,88,140,125,0,0,12,44,120,27,96,124,
12,4,96,56,32,0,130,65,36,0,76,129,108,0,106,129,120,99,131,125,
120,35,133,124,166,3,105,125,120,3,4,124,33,4,128,78,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,58,16,172,84,188,134,109,57,46,88,140,125,0,0,12,44,
120,27,96,124,12,4,96,56,32,0,130,65,36,0,76,129,100,0,106,129,
120,99,131,125,120,35,133,124,166,3,105,125,120,3,4,124,33,4,128,78,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,58,16,172,84,188,134,109,57,46,88,140,125,
0,0,12,44,120,27,96,124,12,4,96,56,32,0,130,65,36,0,76,129,
92,0,106,129,120,99,131,125,120,35,133,124,166,3,105,125,120,3,4,124,
33,4,128,78,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,58,16,172,84,188,134,109,57,
46,88,140,125,0,0,12,44,120,27,96,124,12,4,96,56,32,0,130,65,
36,0,76,129,84,0,106,129,120,99,131,125,120,35,133,124,166,3,105,125,
120,3,4,124,33,4,128,78,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,58,16,172,84,
188,134,109,57,46,88,140,125,0,0,12,44,120,27,96,124,12,4,96,56,
32,0,130,65,36,0,76,129,76,0,106,129,120,99,131,125,120,35,133,124,
166,3,105,125,120,3,4,124,33,4,128,78,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
58,16,172,84,188,134,109,57,46,88,140,125,0,0,12,44,120,27,96,124,
12,4,96,56,32,0,130,65,36,0,76,129,68,0,106,129,120,99,131,125,
120,35,133,124,166,3,105,125,120,3,4,124,33,4,128,78,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,58,16,172,84,188,134,109,57,46,88,140,125,0,0,12,44,
120,27,96,124,12,4,96,56,32,0,130,65,36,0,76,129,60,0,106,129,
120,99,131,125,120,35,133,124,166,3,105,125,120,3,4,124,33,4,128,78,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,58,16,172,84,188,134,109,57,46,88,140,125,
0,0,12,44,120,27,96,124,12,4,96,56,32,0,130,65,36,0,76,129,
52,0,106,129,120,99,131,125,120,35,133,124,166,3,105,125,120,3,4,124,
33,4,128,78,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,58,16,172,84,188,134,109,57,
46,88,140,125,0,0,12,44,120,27,96,124,12,4,96,56,32,0,130,65,
36,0,76,129,44,0,106,129,120,99,131,125,120,35,133,124,166,3,105,125,
120,3,4,124,33,4,128,78,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,58,16,172,84,
188,134,109,57,46,88,140,125,0,0,12,44,120,27,96,124,12,4,96,56,
32,0,130,65,36,0,76,129,36,0,106,129,120,99,131,125,120,35,133,124,
166,3,105,125,120,3,4,124,33,4,128,78,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
58,16,172,84,188,134,109,57,46,88,140,125,0,0,12,44,120,27,96,124,
12,4,96,56,32,0,130,65,36,0,76,129,28,0,106,129,120,99,131,125,
120,35,133,124,166,3,105,125,120,3,4,124,33,4,128,78,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,58,16,172,84,188,134,109,57,46,88,140,125,0,0,12,44,
120,27,96,124,12,4,96,56,32,0,130,65,36,0,76,129,20,0,106,129,
120,99,131,125,120,35,133,124,166,3,105,125,120,3,4,124,33,4,128,78,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,216,255,33,148,
12,0,33,147,16,0,65,147,20,0,97,147,24,0,129,147,28,0,161,147,
166,2,8,124,44,0,1,144,32,0,193,147,120,27,126,124,36,0,225,147,
29,0,224,63,152,48,127,56,255,0,128,56,128,0,160,56,149,138,253,75,
0,0,30,44,116,0,129,64,0,0,30,44,0,0,32,59,104,0,129,64,
29,0,160,63,136,48,189,59,4,0,61,129,58,16,40,87,46,64,105,124,
101,133,0,72,121,27,124,124,0,0,96,59,56,0,129,64,152,48,95,59,
4,0,253,128,58,16,42,87,46,80,103,124,120,219,100,127,9,131,0,72,
56,24,96,84,46,1,58,127,20,2,154,125,255,255,156,55,4,0,108,147,
1,0,123,59,212,255,130,64,255,255,222,55,1,0,57,59,168,255,130,64,
32,0,193,131,24,0,129,131,20,0,97,131,28,0,161,131,36,0,225,131,
44,0,1,128,16,0,65,131,12,0,33,131,166,3,8,124,40,0,33,56,
32,0,128,78,216,255,33,148,28,0,161,147,12,0,33,147,16,0,65,147,
20,0,97,147,24,0,129,147,36,0,225,147,166,2,8,124,44,0,1,144,
32,0,193,147,164,128,141,137,29,0,160,63,136,48,189,59,4,0,29,128,
0,0,0,44,0,0,192,59,196,134,205,155,120,243,223,127,165,128,141,153,
16,0,130,65,8,0,29,129,80,64,224,124,112,22,255,124,121,251,249,127,
0,0,128,59,136,0,129,64,188,134,77,59,252,255,90,59,1,0,128,105,
0,0,0,44,120,227,132,127,58,16,155,87,48,0,130,65,11,0,96,60,
252,86,99,56,77,237,3,72,4,0,189,128,46,216,133,124,0,0,96,56,
141,52,0,72,4,0,122,148,20,134,98,56,49,237,3,72,44,0,0,72,
11,0,96,60,212,86,99,56,33,237,3,72,4,0,61,129,46,216,137,124,
0,0,96,56,89,95,0,72,4,0,122,148,20,134,98,56,5,237,3,72,
255,255,57,55,1,0,156,59,12,0,130,65,165,128,141,137,136,255,255,75,
120,251,227,127,117,11,7,72,0,0,31,44,48,0,129,64,196,134,13,136,
1,0,0,96,120,251,227,127,196,134,13,152,17,254,255,75,197,243,255,75,
165,249,255,75,196,134,141,137,2,0,140,97,120,27,126,124,196,134,141,153,
28,0,161,131,120,243,195,127,32,0,193,131,20,0,97,131,24,0,129,131,
36,0,225,131,44,0,1,128,16,0,65,131,12,0,33,131,166,3,8,124,
40,0,33,56,32,0,128,78,176,255,33,148,52,0,33,147,56,0,65,147,
60,0,97,147,64,0,129,147,68,0,161,147,72,0,193,147,76,0,225,147,
166,2,8,124,84,0,1,144,167,128,109,137,0,0,11,44,0,0,192,59,
168,0,130,65,11,0,96,60,72,87,99,56,65,236,3,72,12,0,160,63,
84,21,29,140,238,0,0,44,64,0,130,64,11,0,96,60,208,87,99,56,
37,236,3,72,72,0,193,131,60,0,97,131,64,0,129,131,76,0,225,131,
68,0,161,131,56,0,65,131,84,0,1,128,52,0,33,131,0,0,96,56,
166,3,8,124,80,0,33,56,32,0,128,78,11,0,96,60,128,87,99,56,
233,235,3,72,12,0,224,63,100,22,255,59,120,251,227,127,120,235,164,127,
16,1,160,56,121,10,4,72,120,251,250,127,0,0,186,136,238,0,5,44,
0,0,64,57,12,0,161,59,12,0,65,145,29,0,128,63,136,48,156,59,
244,2,130,65,164,0,0,72,16,0,97,56,154,153,128,60,170,170,132,56,
241,184,1,72,16,0,97,56,101,214,1,72,0,0,3,44,64,0,130,64,
11,0,96,60,148,87,99,56,125,235,3,72,72,0,193,131,60,0,97,131,
64,0,129,131,76,0,225,131,68,0,161,131,56,0,65,131,84,0,1,128,
52,0,33,131,198,1,96,56,166,3,8,124,80,0,33,56,32,0,128,78,
11,0,96,60,180,87,99,56,65,235,3,72,154,153,96,60,170,170,99,56,
117,101,2,72,12,0,224,63,100,22,255,59,120,251,250,127,0,0,186,136,
238,0,5,44,0,0,64,57,12,0,161,59,12,0,65,145,29,0,128,63,
136,48,156,59,80,2,130,65,1,0,5,44,216,1,130,64,120,211,68,127,
0,0,96,56,29,141,0,72,0,0,3,44,0,0,125,144,52,0,130,64,
72,0,193,131,60,0,97,131,64,0,129,131,76,0,225,131,68,0,161,131,
56,0,65,131,84,0,1,128,52,0,33,131,16,1,96,56,166,3,8,124,
80,0,33,56,32,0,128,78,112,0,195,171,0,0,30,44,44,0,130,65,
3,0,128,56,117,131,0,72,120,243,195,127,153,154,1,72,120,243,196,127,
120,27,101,124,11,0,96,60,40,87,99,56,137,234,3,72,236,1,0,72,
8,0,124,129,4,0,188,128,0,0,5,44,0,0,0,57,20,0,130,64,
0,0,5,44,0,0,0,56,40,0,130,65,24,0,0,72,0,0,5,44,
80,88,5,124,112,22,8,124,0,0,0,56,16,0,130,65,12,0,28,128,
80,0,197,124,112,22,192,124,64,0,8,124,120,91,108,125,52,0,128,64,
0,0,108,144,4,0,76,57,8,0,92,145,3,0,218,136,4,0,186,136,
2,0,26,136,46,68,198,84,120,3,192,124,62,4,0,84,20,2,5,124,
20,2,255,127,60,1,0,72,0,0,5,44,64,0,130,64,8,0,129,145,
120,227,131,127,120,235,166,127,8,0,129,56,1,0,160,56,157,3,0,72,
3,0,218,136,4,0,186,136,2,0,26,136,46,68,198,84,120,3,192,124,
62,4,0,84,20,2,5,124,20,2,255,127,248,0,0,72,80,88,37,125,
113,22,39,125,64,0,130,64,8,0,129,145,120,227,131,127,120,235,166,127,
8,0,129,56,1,0,160,56,85,3,0,72,3,0,218,136,4,0,186,136,
2,0,26,136,46,68,198,84,120,3,192,124,62,4,0,84,20,2,5,124,
20,2,255,127,176,0,0,72,80,96,69,125,112,22,89,125,8,0,129,145,
120,227,131,127,120,235,166,127,8,0,129,56,1,0,160,56,17,3,0,72,
3,0,218,136,4,0,186,136,58,16,32,87,20,2,123,127,2,0,26,136,
46,68,198,84,120,3,192,124,62,4,0,84,20,2,5,124,20,2,255,127,
100,0,0,72,2,0,5,44,24,0,130,64,120,251,227,127,13,119,0,72,
121,27,126,124,44,0,130,65,96,0,0,72,12,4,192,59,120,243,195,127,
1,153,1,72,120,243,196,127,120,27,101,124,11,0,96,60,40,87,99,56,
241,232,3,72,84,0,0,72,3,0,218,136,4,0,186,136,2,0,26,136,
46,68,198,84,120,3,192,124,62,4,0,84,20,2,5,124,20,2,255,127,
120,251,250,127,0,0,186,136,238,0,5,44,184,253,130,64,120,243,195,127,
32,0,0,72,173,152,1,72,120,243,196,127,120,27,101,124,11,0,96,60,
40,87,99,56,157,232,3,72,120,243,195,127,72,0,193,131,64,0,129,131,
60,0,97,131,68,0,161,131,76,0,225,131,84,0,1,128,56,0,65,131,
52,0,33,131,166,3,8,124,80,0,33,56,32,0,128,78,232,255,33,148,
8,0,129,147,20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,
121,27,125,124,16,0,193,147,120,35,158,124,68,1,130,65,2,0,128,59,
188,134,237,59,252,255,255,59,4,0,127,132,0,0,3,44,24,0,130,65,
36,0,99,129,148,0,11,128,3,0,128,56,166,3,9,124,33,4,128,78,
255,255,156,55,220,255,130,64,29,0,224,63,136,48,255,59,4,0,31,129,
0,0,128,59,40,0,0,72,58,16,134,87,46,48,232,124,0,0,7,44,
20,0,130,65,120,59,227,124,3,0,128,56,177,128,0,72,4,0,31,129,
1,0,156,59,0,0,8,44,0,0,192,56,16,0,130,65,8,0,159,129,
80,96,40,125,112,22,38,125,64,48,28,124,192,255,128,65,4,0,127,129,
8,0,31,128,120,3,12,124,64,96,11,124,148,0,130,65,80,0,236,124,
112,22,230,124,59,16,201,84,120,0,130,65,120,91,103,125,80,56,12,124,
64,72,0,124,120,75,42,125,60,0,129,65,1,0,10,40,20,74,231,124,
120,83,72,125,20,74,140,125,8,0,128,64,1,0,0,57,166,3,9,125,
255,255,12,140,255,255,7,156,248,255,0,66,58,16,202,84,20,82,203,124,
8,0,223,144,56,0,0,72,1,0,10,40,255,255,140,57,120,83,64,125,
255,255,231,56,8,0,128,64,1,0,0,56,166,3,9,124,1,0,12,140,
1,0,7,156,248,255,0,66,58,16,202,84,20,82,203,124,8,0,223,144,
255,7,204,87,12,0,130,65,120,235,163,127,37,211,3,72,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
0,0,3,44,20,0,130,64,1,0,96,56,69,209,3,72,0,0,3,44,
104,0,130,65,0,0,64,57,188,134,141,57,252,255,140,57,2,0,0,56,
166,3,9,124,4,0,76,149,252,255,0,66,29,0,128,61,136,48,140,57,
4,0,204,128,8,0,12,129,0,0,96,57,80,64,230,124,120,91,106,125,
112,22,229,124,16,0,0,72,58,16,105,85,46,73,70,125,1,0,107,57,
0,0,6,44,0,0,0,56,8,0,130,65,120,43,160,124,64,0,11,124,
224,255,128,65,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
136,255,33,148,92,0,33,147,96,0,65,147,100,0,97,147,104,0,129,147,
108,0,161,147,112,0,193,147,116,0,225,147,166,2,8,124,124,0,1,144,
0,0,166,131,120,27,124,124,4,0,156,129,0,0,12,44,0,0,196,131,
0,0,224,59,120,43,187,124,0,64,32,61,255,255,41,57,16,0,130,65,
12,0,188,128,80,40,12,124,112,22,31,124,0,0,27,44,136,13,130,65,
0,0,12,44,0,0,224,56,16,0,130,65,8,0,252,128,80,56,204,124,
112,22,199,124,80,72,7,125,64,216,8,124,160,8,128,64,15,0,0,56,
48,0,1,144,0,0,160,56,8,0,161,152,44,0,161,144,28,0,193,59,
28,0,161,152,11,0,96,63,120,82,123,59,255,255,59,57,1,0,233,140,
117,7,231,124,248,255,130,64,48,0,97,129,16,0,11,40,80,72,155,127,
120,243,202,127,8,0,128,65,0,0,94,129,0,80,27,124,12,0,160,63,
168,2,128,65,16,0,11,40,120,243,199,127,8,0,128,65,0,0,254,128,
44,0,129,129,20,98,7,124,0,216,0,124,136,2,129,64,16,0,11,40,
120,243,197,127,8,0,128,65,0,0,190,128,80,216,229,127,64,248,12,124,
16,0,128,64,24,0,97,56,133,198,3,72,44,0,129,129,80,96,255,124,
64,56,28,124,8,0,128,64,120,227,135,127,212,87,189,131,20,58,127,127,
64,216,12,124,120,235,188,127,16,0,128,64,24,0,97,56,85,198,3,72,
44,0,129,129,80,96,27,124,64,224,0,124,8,0,128,64,120,3,28,124,
0,0,28,44,232,0,130,65,48,0,97,129,16,0,11,40,120,243,199,127,
8,0,128,65,0,0,254,128,16,0,11,40,20,218,71,125,120,243,201,127,
8,0,128,65,0,0,62,129,81,0,28,124,20,218,201,124,120,3,9,124,
20,226,166,124,132,0,130,65,80,80,229,124,64,72,7,124,72,0,129,65,
1,0,0,40,20,74,74,125,120,3,6,124,20,74,165,124,8,0,128,64,
1,0,192,56,166,3,201,124,255,255,37,141,255,255,42,157,248,255,0,66,
48,0,97,129,16,0,11,40,44,0,129,129,80,96,92,125,120,243,200,127,
76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,120,3,8,124,
255,255,74,57,8,0,128,64,1,0,0,57,166,3,9,125,1,0,5,140,
1,0,10,156,248,255,0,66,48,0,97,129,44,0,129,129,16,0,11,40,
80,96,92,125,120,243,200,127,8,0,128,65,0,0,30,129,0,0,96,57,
9,0,97,153,44,0,65,145,174,81,104,125,44,0,129,129,64,248,12,124,
8,0,128,64,120,99,159,125,0,0,31,44,232,2,130,65,48,0,97,129,
16,0,11,40,120,243,202,127,8,0,128,65,0,0,94,129,16,0,11,40,
120,243,201,127,8,0,128,65,0,0,62,129,80,96,31,124,121,3,8,124,
120,67,5,125,20,250,233,124,132,0,130,65,80,80,199,124,64,40,6,124,
68,0,129,65,1,0,8,40,20,42,231,124,20,42,74,125,8,0,128,64,
1,0,0,57,166,3,9,125,255,255,39,141,255,255,42,157,248,255,0,66,
48,0,97,129,16,0,11,40,44,0,129,129,120,243,197,127,80,96,31,124,
76,0,128,65,68,0,0,72,1,0,8,40,255,255,231,56,120,67,0,125,
255,255,74,57,8,0,128,64,1,0,0,56,166,3,9,124,1,0,7,140,
1,0,10,156,248,255,0,66,44,0,129,129,48,0,97,129,80,96,31,124,
16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,0,0,96,57,
10,0,97,153,44,0,1,144,174,1,101,125,44,0,97,131,12,134,2,57,
52,0,1,145,120,235,168,127,64,216,8,124,14,0,97,153,64,0,129,59,
12,0,32,61,220,20,41,57,56,0,33,145,64,0,97,153,15,0,0,56,
80,0,97,145,60,0,225,59,84,0,1,144,20,2,128,65,20,2,0,72,
254,255,224,56,64,56,28,124,16,0,129,64,24,0,97,56,245,197,3,72,
48,0,97,129,64,224,11,124,232,0,128,64,44,0,65,131,254,255,32,57,
15,0,153,99,64,72,25,124,32,0,129,64,120,227,153,127,1,0,121,56,
5,205,3,72,0,0,26,44,120,27,127,124,72,0,130,64,100,0,0,72,
171,170,128,61,171,170,140,57,22,200,76,125,126,248,105,85,126,248,74,85,
64,72,10,124,20,0,128,64,254,255,9,32,64,0,11,124,8,0,129,65,
20,74,43,127,1,0,121,56,193,204,3,72,0,0,26,44,120,27,127,124,
36,0,130,65,48,0,161,128,16,0,5,40,120,251,227,127,120,243,196,127,
8,0,128,65,0,0,158,128,120,211,69,127,193,0,4,72,48,0,1,128,
16,0,0,40,12,0,128,65,0,0,126,128,37,206,3,72,16,0,25,40,
48,0,33,147,120,243,202,127,0,0,254,147,0,0,128,57,44,0,129,145,
21,0,129,153,8,0,128,65,120,251,234,127,0,0,28,44,0,0,96,57,
12,0,97,153,44,0,65,147,174,209,106,125,56,0,130,65,128,0,0,72,
0,0,28,44,36,0,130,64,16,0,11,40,120,243,197,127,8,0,128,65,
0,0,190,128,0,0,192,56,11,0,193,152,44,0,193,144,0,0,197,152,
0,0,28,44,80,0,130,64,44,0,97,131,212,87,189,131,12,134,2,57,
52,0,1,145,120,235,168,127,64,216,8,124,0,0,160,56,14,0,161,152,
64,0,129,59,12,0,32,61,220,20,41,57,56,0,33,145,64,0,161,152,
15,0,0,56,80,0,161,144,60,0,225,59,84,0,1,144,148,0,128,65,
148,0,0,72,48,0,1,129,16,0,8,40,120,243,195,127,8,0,128,65,
0,0,126,128,120,219,100,127,120,227,133,127,209,255,3,72,48,0,1,128,
16,0,0,40,120,243,199,127,8,0,128,65,0,0,254,128,0,0,96,57,
13,0,97,153,44,0,129,147,174,225,103,125,212,87,189,131,44,0,97,131,
12,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,0,0,160,56,
14,0,161,152,64,0,129,59,12,0,32,61,220,20,41,57,56,0,33,145,
64,0,161,152,15,0,0,56,80,0,161,144,60,0,225,59,84,0,1,144,
8,0,128,64,120,67,27,125,24,0,1,56,64,0,31,124,52,1,130,64,
20,0,255,128,64,216,7,124,16,0,128,64,120,251,227,127,245,193,3,72,
20,0,255,128,80,56,27,124,64,232,0,124,8,0,128,64,120,3,29,124,
0,0,29,44,140,2,130,65,24,0,223,128,16,0,6,40,120,227,138,127,
8,0,128,65,0,0,92,129,16,0,6,40,20,218,42,125,120,227,136,127,
8,0,128,65,0,0,28,129,81,0,29,124,20,218,168,124,120,3,8,124,
20,234,165,124,128,0,130,65,80,72,197,124,64,64,6,124,68,0,129,65,
1,0,0,40,20,66,165,124,20,66,41,125,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,229,140,255,255,233,156,248,255,0,66,24,0,223,128,
16,0,6,40,20,0,255,128,80,56,61,125,120,227,134,127,76,0,128,65,
68,0,0,72,1,0,0,40,255,255,165,56,120,3,6,124,255,255,41,57,
8,0,128,64,1,0,192,56,166,3,201,124,1,0,5,140,1,0,9,156,
248,255,0,66,24,0,223,128,20,0,255,128,16,0,6,40,80,56,61,125,
120,227,134,127,8,0,128,65,0,0,220,128,0,0,96,57,15,0,97,153,
20,0,63,145,174,73,102,125,12,0,128,61,216,87,140,129,0,0,12,44,
12,0,0,61,52,0,161,59,252,20,8,57,56,0,1,145,192,1,130,65,
172,1,0,72,254,255,192,56,64,48,27,124,12,0,129,64,120,251,227,127,
169,194,3,72,24,0,223,128,64,216,6,124,232,0,128,64,20,0,63,131,
254,255,0,57,15,0,122,99,64,64,26,124,32,0,129,64,120,219,122,127,
1,0,122,56,185,201,3,72,0,0,25,44,120,27,125,124,104,0,130,65,
68,0,0,72,171,170,128,61,171,170,140,57,22,208,76,125,126,248,200,84,
126,248,74,85,64,64,10,124,20,0,128,64,254,255,8,32,64,0,6,124,
8,0,129,65,20,66,70,127,1,0,122,56,117,201,3,72,0,0,25,44,
120,27,125,124,36,0,130,65,24,0,63,129,16,0,9,40,120,235,163,127,
120,227,132,127,8,0,128,65,0,0,156,128,120,203,37,127,117,253,3,72,
24,0,223,128,16,0,6,40,12,0,128,65,0,0,124,128,217,202,3,72,
16,0,26,40,120,227,135,127,0,0,128,57,22,0,129,153,20,0,159,145,
0,0,188,147,24,0,95,147,8,0,128,65,120,235,167,127,0,0,27,44,
0,0,96,57,17,0,97,153,20,0,63,147,174,201,103,125,56,0,130,64,
136,0,0,72,0,0,27,44,36,0,130,64,16,0,6,40,120,227,135,127,
8,0,128,65,0,0,252,128,0,0,160,56,16,0,161,152,20,0,191,144,
0,0,167,152,0,0,27,44,88,0,130,65,24,0,255,128,16,0,7,40,
120,227,131,127,8,0,128,65,0,0,124,128,48,0,33,129,16,0,9,40,
120,243,196,127,8,0,128,65,0,0,158,128,120,219,101,127,193,252,3,72,
24,0,95,129,16,0,10,40,120,227,133,127,8,0,128,65,0,0,188,128,
0,0,96,57,18,0,97,153,20,0,127,147,174,217,101,125,12,0,128,61,
216,87,140,129,0,0,12,44,12,0,0,61,52,0,161,59,252,20,8,57,
56,0,1,145,20,0,130,65,120,235,163,127,166,3,137,125,33,4,128,78,
56,0,1,129,28,0,8,128,120,235,163,127,166,3,9,124,33,4,128,78,
120,235,163,127,185,186,3,72,24,0,63,129,16,0,9,40,12,0,128,65,
0,0,124,128,185,201,3,72,0,0,0,56,19,0,1,152,20,0,31,144,
15,0,64,57,24,0,95,145,0,0,28,152,48,0,1,128,16,0,0,40,
12,0,128,65,0,0,126,128,141,201,3,72,0,0,224,56,20,0,225,152,
44,0,225,144,15,0,192,56,48,0,193,144,0,0,254,152,112,0,193,131,
104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,
96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,
0,0,12,44,0,0,192,56,16,0,130,65,8,0,28,128,80,0,76,125,
112,22,70,125,20,218,166,124,64,40,31,124,88,2,128,64,126,248,232,87,
80,72,200,124,64,248,6,124,0,0,0,56,8,0,128,65,20,66,31,124,
0,0,12,44,120,3,31,124,0,0,64,57,16,0,130,65,8,0,28,128,
80,0,236,124,112,22,234,124,20,218,170,124,64,40,31,124,32,0,128,64,
0,0,12,44,0,0,160,56,16,0,130,65,8,0,252,128,80,56,204,124,
112,22,197,124,20,218,229,127,64,72,31,124,68,0,129,64,240,135,13,129,
0,0,8,44,48,0,130,64,1,0,32,57,240,135,45,145,11,0,64,61,
84,82,74,57,232,135,77,145,12,0,0,61,28,21,8,57,236,135,13,145,
12,0,96,60,60,21,99,56,37,194,3,72,232,135,109,56,109,185,3,72,
58,16,255,87,120,251,227,127,209,198,3,72,4,0,60,129,120,27,122,124,
80,240,9,124,59,0,0,84,120,3,8,124,120,211,69,127,120,0,130,65,
120,43,166,124,80,48,73,125,64,64,10,124,120,67,10,125,64,0,129,65,
1,0,10,40,20,66,198,124,20,66,41,125,120,83,72,125,8,0,128,64,
1,0,0,57,166,3,9,125,255,255,233,140,255,255,230,156,248,255,0,66,
20,2,5,125,121,219,101,127,252,255,72,57,60,0,130,64,68,0,0,72,
1,0,10,40,255,255,198,56,255,255,41,57,8,0,128,64,1,0,64,57,
166,3,73,125,1,0,9,141,1,0,6,157,248,255,0,66,20,2,5,125,
121,219,101,127,252,255,72,57,16,0,130,65,255,255,165,52,4,0,170,151,
248,255,130,64,8,0,28,128,80,0,190,124,59,0,167,84,58,16,96,87,
20,2,72,125,112,0,130,65,80,80,222,124,64,56,6,124,120,59,224,124,
60,0,129,65,1,0,0,40,20,58,222,127,20,58,74,125,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,30,141,255,255,10,157,248,255,0,66,
4,0,156,129,0,0,12,44,0,0,160,56,72,0,130,65,56,0,0,72,
1,0,0,40,255,255,74,57,255,255,222,59,8,0,128,64,1,0,0,56,
166,3,9,124,1,0,62,141,1,0,42,157,248,255,0,66,4,0,156,129,
0,0,12,44,0,0,160,56,16,0,130,65,8,0,188,128,80,40,12,124,
112,22,5,124,4,0,124,128,0,0,3,44,20,42,123,127,8,0,130,65,
21,199,3,72,20,250,218,124,12,0,220,144,58,16,103,87,20,58,26,125,
8,0,28,145,4,0,92,147,112,0,193,131,104,0,129,131,100,0,97,131,
108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,
166,3,8,124,120,0,33,56,32,0,128,78,8,0,188,128,80,40,30,124,
112,22,6,124,64,216,6,124,58,16,108,87,220,0,128,64,59,0,0,84,
20,98,30,125,120,243,202,127,140,0,130,65,80,64,42,125,64,0,9,124,
120,3,5,124,72,0,129,65,1,0,5,40,20,2,8,125,20,2,74,125,
120,43,160,124,8,0,128,64,1,0,0,56,166,3,9,124,255,255,10,140,
255,255,8,156,248,255,0,66,8,0,188,128,80,40,30,124,112,22,6,124,
81,216,70,125,252,255,37,57,84,0,130,65,68,0,0,72,1,0,5,40,
255,255,74,57,120,43,169,124,255,255,8,57,8,0,128,64,1,0,32,57,
166,3,41,125,1,0,170,140,1,0,168,156,248,255,0,66,8,0,188,128,
80,40,30,124,112,22,6,124,81,216,70,125,252,255,37,57,16,0,130,65,
255,255,74,53,4,0,169,151,248,255,130,64,20,98,165,124,80,40,236,124,
64,56,30,124,8,0,188,144,116,1,130,65,0,0,190,147,4,0,222,59,
64,56,30,124,244,255,130,64,96,1,0,72,120,43,164,124,80,32,44,125,
80,32,9,125,59,0,0,85,120,3,8,124,120,75,38,125,144,0,130,65,
120,43,171,124,80,88,70,125,64,64,10,124,120,67,7,125,84,0,129,65,
1,0,7,40,20,66,107,125,120,59,234,124,20,66,198,124,8,0,128,64,
1,0,64,57,166,3,73,125,255,255,230,140,255,255,235,156,248,255,0,66,
20,2,229,124,8,0,252,144,80,72,62,125,112,22,32,125,58,16,10,84,
59,16,0,84,80,32,234,124,120,243,200,127,196,0,130,65,80,0,0,72,
1,0,7,40,255,255,198,56,120,59,232,124,255,255,107,57,8,0,128,64,
1,0,0,57,166,3,9,125,1,0,70,141,1,0,75,157,248,255,0,66,
20,2,229,124,8,0,252,144,80,72,62,125,112,22,32,125,58,16,10,84,
59,16,0,84,80,32,234,124,120,243,200,127,116,0,130,65,80,56,168,124,
64,0,5,124,120,3,6,124,64,0,129,65,1,0,6,40,20,2,231,124,
20,2,8,125,120,51,192,124,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,200,140,255,255,199,156,248,255,0,66,120,243,198,127,20,98,254,124,
64,56,6,124,76,0,130,65,56,0,0,72,1,0,6,40,255,255,231,56,
255,255,8,57,8,0,128,64,1,0,192,56,166,3,201,124,1,0,200,140,
1,0,199,156,248,255,0,66,120,243,198,127,20,98,254,124,64,56,6,124,
20,0,130,65,0,0,166,147,4,0,198,56,64,56,6,124,244,255,130,64,
112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,
124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,8,0,193,147,
121,27,126,124,12,0,225,147,120,35,159,124,52,0,130,65,4,0,126,128,
0,0,3,44,8,0,130,65,41,196,3,72,0,0,128,57,4,0,158,145,
255,7,235,87,8,0,158,145,12,0,158,145,12,0,130,65,120,243,195,127,
9,196,3,72,20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,220,195,3,72,196,180,3,72,192,180,3,72,232,255,33,148,
12,0,161,147,166,2,8,124,28,0,1,144,16,0,193,147,121,27,126,124,
20,0,225,147,120,35,159,124,104,0,130,65,32,0,30,129,16,0,8,40,
12,0,190,59,40,0,128,64,15,0,32,57,32,0,62,145,0,0,64,57,
28,0,94,145,255,7,231,87,8,0,65,153,12,0,94,153,56,0,130,65,
44,0,0,72,12,0,126,128,117,195,3,72,15,0,32,57,32,0,62,145,
0,0,64,57,28,0,94,145,255,7,231,87,8,0,65,153,12,0,94,153,
12,0,130,65,120,243,195,127,77,195,3,72,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
24,180,3,72,32,0,3,128,16,0,0,40,12,0,128,65,12,0,99,128,
32,0,128,78,12,0,99,56,32,0,128,78,232,255,33,148,12,0,161,147,
166,2,8,124,28,0,1,144,16,0,193,147,121,27,126,124,20,0,225,147,
120,35,159,124,104,0,130,65,32,0,30,129,16,0,8,40,12,0,190,59,
40,0,128,64,15,0,32,57,32,0,62,145,0,0,64,57,28,0,94,145,
255,7,231,87,8,0,65,153,12,0,94,153,56,0,130,65,44,0,0,72,
12,0,126,128,177,194,3,72,15,0,32,57,32,0,62,145,0,0,64,57,
28,0,94,145,255,7,231,87,8,0,65,153,12,0,94,153,12,0,130,65,
120,243,195,127,137,194,3,72,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,32,0,128,78,
0,0,99,128,32,0,128,78,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,76,194,3,72,0,0,3,44,32,0,130,77,255,7,128,84,
32,0,130,77,56,194,3,72,166,2,8,124,4,0,1,144,248,255,33,148,
0,0,3,44,20,0,130,64,40,0,96,56,121,192,3,72,0,0,3,44,
60,0,130,65,28,134,130,137,26,0,131,153,28,134,2,136,12,0,96,61,
100,26,107,57,36,0,99,145,0,0,128,57,0,0,131,145,4,0,131,145,
20,0,131,145,16,0,131,145,24,0,3,152,8,0,131,145,12,0,131,145,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,0,0,96,56,
32,0,128,78,0,0,96,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,120,35,159,124,
76,0,130,65,40,0,126,128,0,0,3,44,12,0,0,60,252,26,0,48,
36,0,30,144,24,0,130,65,0,0,99,129,20,0,11,128,3,0,128,56,
166,3,9,124,33,4,128,78,120,243,195,127,0,0,128,56,29,255,255,75,
255,7,224,87,12,0,130,65,120,243,195,127,85,193,3,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,121,27,127,124,166,2,8,124,20,0,1,144,
20,0,130,64,44,0,96,56,121,191,3,72,121,27,127,124,32,0,130,65,
120,251,227,127,217,254,255,75,12,0,128,61,252,26,140,57,36,0,159,145,
0,0,0,56,40,0,31,144,20,0,1,128,120,251,227,127,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,0,0,96,56,32,0,128,78,
0,0,96,56,32,0,128,78,5,4,96,56,32,0,128,78,5,4,96,56,
32,0,128,78,5,4,96,56,32,0,128,78,5,4,96,56,32,0,128,78,
0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,
32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,
0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,8,0,193,147,
121,27,126,124,12,0,225,147,120,35,159,124,76,0,130,65,40,0,126,128,
0,0,3,44,12,0,0,60,148,27,0,48,36,0,30,144,24,0,130,65,
0,0,99,129,20,0,11,128,3,0,128,56,166,3,9,124,33,4,128,78,
120,243,195,127,0,0,128,56,209,253,255,75,255,7,224,87,12,0,130,65,
120,243,195,127,9,192,3,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,
121,27,127,124,166,2,8,124,20,0,1,144,20,0,130,64,44,0,96,56,
45,190,3,72,121,27,127,124,32,0,130,65,120,251,227,127,141,253,255,75,
12,0,128,61,148,27,140,57,36,0,159,145,0,0,0,56,40,0,31,144,
20,0,1,128,120,251,227,127,12,0,225,131,16,0,33,56,166,3,8,124,
32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,
0,0,96,56,32,0,128,78,0,0,96,56,32,0,128,78,0,0,96,56,
32,0,128,78,0,0,96,56,32,0,128,78,6,4,96,56,32,0,128,78,
6,4,96,56,32,0,128,78,6,4,96,56,32,0,128,78,6,4,96,56,
32,0,128,78,6,4,96,56,32,0,128,78,6,4,96,56,32,0,128,78,
6,4,96,56,32,0,128,78,6,4,96,56,32,0,128,78,71,0,131,137,
255,255,12,48,16,97,64,125,156,0,131,137,157,0,3,136,70,0,35,137,
52,0,43,125,126,217,104,85,122,23,0,81,254,7,76,81,156,0,131,153,
157,0,3,152,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,8,0,193,147,120,27,126,124,16,0,94,129,120,35,159,124,
0,80,31,124,28,0,128,65,12,0,225,131,8,0,193,131,166,3,8,124,
10,4,96,56,16,0,33,56,32,0,128,78,44,0,126,128,161,101,0,72,
128,255,3,44,32,0,130,64,12,0,225,131,20,0,1,128,8,0,193,131,
16,4,96,56,166,3,8,124,16,0,33,56,32,0,128,78,246,255,3,44,
32,0,128,64,72,0,158,57,0,0,32,57,174,249,44,125,74,0,62,153,
75,0,62,153,120,75,35,125,44,0,0,72,235,0,3,44,8,0,129,64,
235,0,96,56,72,0,158,57,10,0,35,57,174,249,44,125,0,0,0,56,
74,0,30,152,75,0,30,152,120,3,3,124,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
20,0,30,128,120,35,159,124,0,0,31,124,32,0,128,65,20,0,225,131,
28,0,1,128,16,0,193,131,10,4,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,44,0,126,128,2,0,160,56,8,0,193,56,61,98,0,72,
0,0,3,44,16,0,130,64,8,0,1,136,71,0,126,57,174,249,11,124,
28,0,1,128,20,0,225,131,16,0,193,131,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,16,0,193,147,166,2,8,124,28,0,1,144,
20,0,225,147,120,27,127,124,4,0,159,129,120,35,158,124,0,96,30,124,
28,0,128,65,20,0,225,131,16,0,193,131,166,3,8,124,10,4,96,56,
24,0,33,56,32,0,128,78,44,0,127,128,3,0,160,56,8,0,193,56,
37,101,0,72,0,0,3,44,28,0,130,64,8,0,1,136,0,0,0,44,
8,0,130,65,16,0,0,56,52,0,127,57,174,241,11,124,20,0,225,131,
28,0,1,128,16,0,193,131,0,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,
16,0,193,147,120,27,126,124,0,0,126,129,120,35,159,124,0,88,31,124,
28,0,128,65,20,0,225,131,16,0,193,131,166,3,8,124,10,4,96,56,
24,0,33,56,32,0,128,78,44,0,126,128,8,0,161,56,221,103,0,72,
0,0,3,44,32,0,130,64,8,0,1,136,0,0,0,44,128,0,0,56,
8,0,130,65,0,0,0,56,20,250,94,125,48,0,10,152,28,0,1,128,
20,0,225,131,16,0,193,131,166,3,8,124,24,0,33,56,32,0,128,78,
232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,
120,27,126,124,12,0,30,128,120,35,159,124,0,0,31,124,32,0,128,65,
20,0,225,131,28,0,1,128,16,0,193,131,10,4,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,44,0,126,128,2,0,160,56,8,0,193,56,
77,98,0,72,0,0,3,44,16,0,130,64,8,0,1,136,70,0,126,57,
174,249,11,124,28,0,1,128,20,0,225,131,16,0,193,131,166,3,8,124,
24,0,33,56,32,0,128,78,0,0,96,56,32,0,128,78,240,255,33,148,
12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,
225,255,255,75,0,0,3,44,28,0,130,65,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,0,0,94,129,
0,0,224,59,0,80,31,124,40,0,128,64,120,243,195,127,120,251,228,127,
157,254,255,75,0,0,3,44,200,255,130,64,0,0,94,129,1,0,255,59,
0,80,31,124,224,255,128,65,4,0,126,129,0,0,224,59,0,88,31,124,
40,0,128,64,120,243,195,127,120,251,228,127,221,253,255,75,0,0,3,44,
148,255,130,64,4,0,126,129,1,0,255,59,0,88,31,124,224,255,128,65,
12,0,158,129,0,0,224,59,0,96,31,124,40,0,128,64,120,243,195,127,
120,251,228,127,189,254,255,75,0,0,3,44,96,255,130,64,12,0,158,129,
1,0,255,59,0,96,31,124,224,255,128,65,20,0,30,128,0,0,224,59,
0,0,31,124,40,0,128,64,120,243,195,127,120,251,228,127,245,252,255,75,
0,0,3,44,44,255,130,64,20,0,30,128,1,0,255,59,0,0,31,124,
224,255,128,65,16,0,30,128,0,0,224,59,0,0,31,124,120,243,195,127,
40,0,128,64,120,251,228,127,241,251,255,75,0,0,3,44,248,254,130,64,
16,0,30,128,1,0,255,59,0,0,31,124,120,243,195,127,224,255,128,65,
157,251,255,75,12,0,225,131,20,0,1,128,8,0,193,131,0,0,96,56,
166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,12,0,225,147,
166,2,8,124,20,0,1,144,8,0,193,147,120,27,126,124,16,0,30,128,
0,0,224,59,0,0,31,124,32,0,128,64,120,243,195,127,120,251,228,127,
129,251,255,75,16,0,30,128,1,0,255,59,0,0,31,124,232,255,128,65,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,20,0,225,147,
166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,20,0,30,128,
0,0,160,59,0,0,29,124,71,0,158,59,120,235,191,127,76,0,128,64,
44,0,126,128,120,235,164,127,2,0,160,56,0,0,192,56,169,93,0,72,
0,0,3,44,24,0,130,65,120,243,195,127,120,235,164,127,201,251,255,75,
0,0,3,44,8,0,130,65,0,0,252,155,20,0,30,128,1,0,189,59,
0,0,29,124,1,0,156,59,188,255,128,65,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,166,2,8,124,
28,0,1,144,20,0,225,147,120,27,127,124,12,0,159,129,0,0,192,59,
0,96,30,124,70,0,191,59,92,0,128,64,44,0,127,128,120,243,196,127,
1,0,160,56,0,0,192,56,181,94,0,72,0,0,3,44,36,0,130,65,
120,251,227,127,120,243,196,127,197,252,255,75,0,0,3,44,24,0,130,65,
128,0,0,56,0,0,29,152,12,0,0,72,0,0,0,56,0,0,29,152,
12,0,159,129,1,0,222,59,0,96,30,124,1,0,189,59,172,255,128,65,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,
20,0,225,147,166,2,8,124,28,0,1,144,8,0,129,147,120,27,124,124,
4,0,28,128,0,0,160,59,0,0,29,124,52,0,252,59,128,0,192,59,
48,0,128,64,120,227,131,127,120,235,164,127,33,251,255,75,0,0,3,44,
8,0,130,65,0,0,223,155,4,0,28,128,1,0,189,59,0,0,29,124,
1,0,255,59,216,255,128,65,16,0,193,131,20,0,225,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
232,255,33,148,12,0,161,147,16,0,193,147,166,2,8,124,28,0,1,144,
20,0,225,147,120,27,127,124,0,0,31,128,0,0,192,59,0,0,30,124,
48,0,191,59,88,0,128,64,44,0,127,128,120,243,196,127,1,0,160,56,
13,100,0,72,0,0,3,44,36,0,130,65,120,251,227,127,120,243,196,127,
25,251,255,75,0,0,3,44,24,0,130,65,128,0,0,56,0,0,29,152,
12,0,0,72,0,0,0,56,0,0,29,152,0,0,31,128,1,0,222,59,
0,0,30,124,1,0,189,59,176,255,128,65,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
224,255,33,148,12,0,97,147,16,0,129,147,20,0,161,147,28,0,225,147,
166,2,8,124,36,0,1,144,24,0,193,147,120,27,126,124,8,0,190,128,
76,0,254,59,58,16,165,84,0,0,128,56,120,251,227,127,149,103,253,75,
8,0,30,128,0,0,128,59,0,0,28,124,5,0,160,59,53,0,126,59,
92,0,128,64,44,0,126,128,120,227,132,127,53,96,0,72,1,0,123,156,
13,140,255,75,0,0,3,44,32,0,130,65,0,0,31,136,1,0,156,59,
129,0,11,96,3,0,191,155,0,0,127,153,4,0,255,59,24,0,0,72,
3,0,159,137,1,0,156,59,2,0,140,97,3,0,159,153,4,0,255,59,
8,0,30,128,0,0,28,124,172,255,128,65,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,
32,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,48,0,127,56,0,0,128,56,111,0,160,56,
221,102,253,75,120,251,227,127,9,255,255,75,120,251,227,127,153,252,255,75,
120,251,227,127,89,254,255,75,120,251,227,127,205,253,255,75,120,251,227,127,
33,253,255,75,120,251,227,127,29,252,255,75,120,251,227,127,145,247,255,75,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,
8,0,193,147,120,35,158,124,28,0,130,65,0,0,128,56,189,244,255,75,
255,7,192,87,12,0,130,65,120,251,227,127,101,182,3,72,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,120,35,131,124,32,0,128,56,
41,102,253,75,12,0,1,128,8,0,33,56,166,3,8,124,0,0,96,56,
32,0,128,78,224,255,33,148,8,0,65,147,12,0,97,147,16,0,129,147,
20,0,161,147,28,0,225,147,166,2,8,124,36,0,1,144,24,0,193,147,
120,27,126,124,52,134,98,56,209,201,3,72,24,0,158,56,11,0,96,60,
88,89,99,56,193,201,3,72,26,0,158,56,11,0,96,60,116,89,99,56,
177,201,3,72,4,0,222,128,8,0,158,128,0,0,190,128,11,0,96,60,
108,88,99,56,153,201,3,72,20,0,190,128,16,0,222,128,12,0,158,128,
11,0,96,60,140,89,99,56,129,201,3,72,120,243,195,127,153,249,255,75,
8,0,30,128,0,0,96,59,0,0,27,124,120,27,127,124,53,0,190,59,
72,0,94,59,48,0,158,59,104,0,128,64,1,0,189,140,120,219,100,127,
11,0,96,60,152,88,99,56,69,201,3,72,4,0,154,140,11,0,96,60,
12,88,99,56,53,201,3,72,1,0,154,136,11,0,96,60,36,88,99,56,
37,201,3,72,2,0,154,136,11,0,96,60,60,88,99,56,21,201,3,72,
3,0,154,136,11,0,96,60,84,88,99,56,5,201,3,72,8,0,30,128,
1,0,123,59,0,0,27,124,160,255,128,65,0,0,30,128,0,0,64,59,
0,0,26,124,255,255,124,59,11,0,160,63,48,0,128,64,120,211,68,127,
11,0,96,60,196,89,99,56,205,200,3,72,1,0,155,140,220,89,125,56,
193,200,3,72,0,0,30,128,1,0,90,59,0,0,26,124,216,255,128,65,
4,0,254,128,0,0,64,59,0,56,26,124,3,0,124,59,48,0,128,64,
120,211,68,127,11,0,96,60,224,88,99,56,141,200,3,72,1,0,155,140,
220,89,125,56,129,200,3,72,4,0,254,128,1,0,90,59,0,56,26,124,
216,255,128,65,12,0,30,128,0,0,64,59,0,0,26,124,21,0,124,59,
48,0,128,64,120,211,68,127,11,0,96,60,240,89,99,56,77,200,3,72,
1,0,155,140,220,89,125,56,65,200,3,72,12,0,30,128,1,0,90,59,
0,0,26,124,216,255,128,65,20,0,62,129,0,0,64,59,0,72,26,124,
22,0,124,59,48,0,128,64,120,211,68,127,11,0,96,60,12,90,99,56,
13,200,3,72,1,0,155,140,220,89,125,56,1,200,3,72,20,0,62,129,
1,0,90,59,0,72,26,124,216,255,128,65,16,0,30,128,0,0,96,59,
0,0,27,124,23,0,188,59,56,0,128,64,120,219,100,127,11,0,96,60,
188,88,99,56,205,199,3,72,1,0,93,141,246,255,138,56,11,0,96,60,
40,90,99,56,185,199,3,72,16,0,30,128,1,0,123,59,0,0,27,124,
208,255,128,65,0,0,0,44,36,0,129,64,26,0,156,136,11,0,96,60,
0,89,99,56,145,199,3,72,27,0,156,136,11,0,96,60,44,89,99,56,
129,199,3,72,108,0,156,137,254,7,132,85,11,0,96,60,72,90,99,56,
109,199,3,72,109,0,28,136,254,247,4,84,11,0,96,60,108,90,99,56,
89,199,3,72,20,0,161,131,120,251,227,127,28,0,225,131,16,0,129,131,
24,0,193,131,36,0,1,128,12,0,97,131,8,0,65,131,166,3,8,124,
32,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
8,0,67,129,0,80,4,124,24,0,128,65,12,0,1,128,8,0,33,56,
166,3,8,124,14,1,96,56,32,0,128,78,13,0,5,40,32,0,130,64,
140,0,131,57,174,32,12,124,0,0,96,56,255,255,32,49,16,1,9,124,
0,0,6,152,20,0,0,72,11,0,96,60,148,90,99,56,209,198,3,72,
0,0,96,56,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
224,255,33,148,16,0,129,147,20,0,161,147,24,0,193,147,28,0,225,147,
166,2,8,124,36,0,1,144,12,0,97,147,120,27,123,124,8,0,155,129,
120,35,156,124,0,96,28,124,0,0,192,59,32,0,128,65,24,0,193,131,
16,0,129,131,12,0,97,131,166,3,8,124,14,1,96,56,32,0,33,56,
32,0,128,78,14,0,5,40,108,3,129,65,58,16,170,84,3,0,138,61,
16,32,12,129,166,3,9,125,32,4,128,78,160,33,3,0,92,33,3,0,
84,34,3,0,160,32,3,0,208,32,3,0,4,33,3,0,116,34,3,0,
68,33,3,0,76,32,3,0,164,34,3,0,244,34,3,0,12,35,3,0,
36,35,3,0,60,35,3,0,76,32,3,0,44,0,123,128,14,0,5,44,
120,227,132,127,24,0,130,64,7,0,160,56,73,92,0,72,121,27,126,124,
8,3,130,64,20,0,0,72,5,0,160,56,53,92,0,72,121,27,126,124,
244,2,130,64,58,16,157,87,20,234,155,125,76,0,12,141,2,0,64,57,
190,7,72,81,191,0,7,113,0,0,236,152,212,2,0,72,44,0,123,128,
120,227,132,127,3,0,160,56,253,91,0,72,121,27,126,124,188,2,130,64,
58,16,137,87,20,74,123,125,76,0,11,140,4,0,0,96,0,0,11,152,
164,2,0,72,44,0,123,128,120,227,132,127,5,0,160,56,205,91,0,72,
121,27,126,124,140,2,130,64,58,16,138,87,20,82,155,125,76,0,236,140,
2,0,0,57,190,7,7,81,0,0,236,152,112,2,0,72,44,0,123,128,
120,227,132,127,0,0,160,56,153,91,0,72,121,27,126,124,88,2,130,64,
76,0,251,59,58,16,157,87,174,232,95,125,49,6,74,85,20,234,127,125,
174,233,95,125,0,0,139,137,1,0,140,97,0,0,139,153,48,2,0,72,
58,16,128,87,20,2,251,124,76,0,7,140,110,6,0,84,0,0,7,152,
24,2,0,72,44,0,123,128,120,227,132,127,6,0,160,56,65,91,0,72,
121,27,126,124,0,2,130,64,76,0,251,59,58,16,157,87,20,234,127,124,
0,0,128,56,4,0,160,56,229,96,253,75,20,234,63,125,3,0,9,136,
2,0,0,96,3,0,9,152,212,1,0,72,76,0,251,59,58,16,157,87,
20,234,191,127,120,235,163,127,0,0,128,56,3,0,160,56,181,96,253,75,
0,0,29,136,44,0,123,128,1,0,224,59,120,227,132,127,128,0,0,96,
0,0,29,152,93,89,0,72,245,133,255,75,0,0,3,44,32,0,130,64,
44,0,123,128,120,227,132,127,69,89,0,72,173,133,255,75,0,0,3,44,
8,0,130,64,0,0,224,59,44,0,123,128,62,6,255,87,120,227,132,127,
37,89,0,72,165,133,255,75,0,0,29,136,0,0,31,44,1,0,32,57,
188,15,224,83,114,54,96,80,0,0,29,152,16,0,130,64,0,0,3,44,
8,0,130,64,0,0,32,57,0,0,29,136,52,0,43,125,126,217,105,85,
254,7,32,81,0,0,29,152,32,1,0,72,58,16,157,87,20,234,187,127,
5,0,224,56,79,0,253,152,76,0,29,141,128,0,8,97,0,0,29,153,
0,1,0,72,44,0,123,128,120,227,132,127,2,0,160,56,41,90,0,72,
121,27,126,124,232,0,130,64,58,16,137,87,20,74,91,125,77,0,106,137,
1,0,107,97,77,0,106,153,208,0,0,72,44,0,123,128,120,227,132,127,
7,0,160,56,249,89,0,72,121,27,126,124,184,0,130,64,58,16,157,87,
20,234,187,127,76,0,157,141,60,0,140,85,64,0,128,97,62,6,8,84,
62,255,7,85,9,0,233,112,1,0,9,44,0,0,29,152,140,0,130,64,
250,7,10,85,0,0,93,153,128,0,0,72,58,16,139,87,20,90,155,125,
76,0,12,140,16,0,0,96,0,0,12,152,104,0,0,72,58,16,137,87,
20,74,123,125,76,0,11,140,8,0,0,96,0,0,11,152,80,0,0,72,
58,16,136,87,20,66,91,125,76,0,138,141,32,0,140,97,0,0,138,153,
56,0,0,72,44,0,123,128,120,227,132,127,1,0,160,56,97,89,0,72,
121,27,126,124,32,0,130,64,140,0,59,57,1,0,0,56,174,225,9,124,
16,0,0,72,11,0,96,60,176,90,99,56,237,194,3,72,20,0,161,131,
120,243,195,127,24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,
12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,
0,0,5,128,16,0,0,40,0,0,224,59,120,27,125,124,32,0,128,64,
20,0,225,131,28,0,1,128,12,0,161,131,208,1,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,0,0,253,128,1,0,196,139,0,56,30,124,
2,0,164,136,36,0,128,65,20,0,225,131,16,0,193,131,28,0,1,128,
12,0,161,131,10,4,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
0,0,5,44,120,243,196,127,60,0,130,64,11,0,96,60,44,91,99,56,
0,0,160,56,45,194,3,72,44,0,125,128,120,243,196,127,0,0,160,56,
13,90,0,72,121,27,127,124,96,0,130,64,20,242,157,125,128,0,0,56,
48,0,12,152,80,0,0,72,4,0,5,44,60,0,130,64,11,0,96,60,
204,90,99,56,4,0,160,56,237,193,3,72,44,0,125,128,120,243,196,127,
1,0,160,56,205,89,0,72,121,27,127,124,32,0,130,64,20,242,61,125,
0,0,0,56,48,0,9,152,16,0,0,72,11,0,96,60,0,91,99,56,
185,193,3,72,120,251,227,127,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
12,0,161,147,16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,
0,0,197,128,16,0,6,40,120,27,127,124,0,0,96,56,120,35,158,124,
28,0,128,64,20,0,225,131,16,0,193,131,166,3,8,124,208,1,96,56,
24,0,33,56,32,0,128,78,156,0,31,137,1,0,94,137,254,7,69,85,
254,7,6,85,64,40,6,124,1,0,190,59,76,0,130,65,11,0,96,60,
84,91,99,56,1,0,128,56,37,193,3,72,1,0,30,136,44,0,127,128,
0,0,128,56,2,0,160,56,254,7,6,84,221,80,0,72,0,0,3,44,
28,0,130,64,0,0,93,137,156,0,31,136,254,7,69,85,71,0,191,152,
254,7,160,80,156,0,31,152,157,0,159,137,1,0,29,136,254,247,5,84,
254,247,134,85,64,40,6,124,88,0,130,65,11,0,96,60,172,91,99,56,
1,0,128,56,197,192,3,72,1,0,61,137,44,0,127,128,0,0,128,56,
1,0,160,56,254,247,39,85,1,0,230,104,62,6,198,84,25,82,0,72,
0,0,3,44,32,0,130,64,157,0,31,136,1,0,125,137,254,247,101,85,
1,0,172,104,70,0,159,153,122,23,160,80,157,0,31,152,20,0,225,131,
28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,
32,0,128,78,224,255,33,148,8,0,65,147,12,0,97,147,16,0,129,147,
20,0,161,147,24,0,193,147,28,0,225,147,166,2,8,124,36,0,1,144,
0,0,5,128,64,0,0,40,0,0,192,59,120,27,124,124,32,0,128,64,
24,0,193,131,36,0,1,128,16,0,129,131,208,1,96,56,166,3,8,124,
32,0,33,56,32,0,128,78,120,35,140,124,1,0,172,139,8,0,28,128,
0,0,29,124,48,0,128,65,16,0,129,131,24,0,193,131,28,0,225,131,
20,0,161,131,12,0,97,131,36,0,1,128,8,0,65,131,10,4,96,56,
166,3,8,124,32,0,33,56,32,0,128,78,44,0,124,128,2,0,76,59,
120,235,164,127,153,84,0,72,117,128,255,75,58,16,170,87,20,82,252,127,
79,0,127,137,0,0,26,136,116,7,0,124,254,7,5,84,254,247,102,85,
64,40,6,124,76,0,255,59,36,0,130,65,120,235,164,127,11,0,96,60,
0,92,99,56,133,191,3,72,56,134,98,56,125,191,3,72,0,0,26,136,
116,7,0,124,3,0,127,137,254,255,5,84,254,255,102,85,64,40,6,124,
36,0,130,65,120,235,164,127,11,0,96,60,88,92,99,56,81,191,3,72,
56,134,98,56,73,191,3,72,0,0,26,136,116,7,0,124,140,0,124,59,
174,232,219,124,254,247,5,84,64,40,6,124,112,0,130,65,120,235,164,127,
11,0,96,60,184,92,99,56,29,191,3,72,0,0,26,136,123,7,0,84,
120,235,164,127,44,0,130,65,44,0,124,128,1,0,160,56,120,43,166,124,
77,85,0,72,121,27,126,124,56,0,130,64,0,0,26,137,254,247,31,85,
174,233,251,127,40,0,0,72,174,232,251,127,0,0,0,56,174,233,27,124,
44,0,124,128,169,83,0,72,81,195,255,75,121,27,126,124,8,0,130,65,
174,233,251,127,16,0,129,131,20,0,161,131,120,243,195,127,24,0,193,131,
28,0,225,131,36,0,1,128,12,0,97,131,8,0,65,131,166,3,8,124,
32,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,12,0,161,147,
16,0,193,147,166,2,8,124,28,0,1,144,20,0,225,147,120,27,127,124,
8,0,31,128,0,0,5,129,58,16,7,84,80,56,128,125,1,0,236,56,
64,56,8,124,28,0,128,64,28,0,1,128,20,0,225,131,208,1,96,56,
24,0,33,56,166,3,8,124,32,0,128,78,0,0,192,59,0,0,30,124,
72,0,191,59,1,0,132,59,56,1,128,64,4,0,93,141,0,0,156,137,
64,96,10,124,220,0,130,65,116,7,64,125,254,255,6,84,116,7,140,125,
254,255,133,85,64,40,6,124,44,0,130,65,120,243,196,127,11,0,96,60,
12,93,99,56,245,189,3,72,64,134,98,56,237,189,3,72,0,0,29,136,
0,0,156,137,116,7,140,125,116,7,0,124,254,247,6,84,254,247,133,85,
64,40,6,124,44,0,130,65,120,243,196,127,11,0,96,60,96,93,99,56,
189,189,3,72,64,134,98,56,181,189,3,72,0,0,29,136,0,0,156,137,
116,7,140,125,116,7,0,124,254,215,6,84,254,215,133,85,64,40,6,124,
44,0,130,65,120,243,196,127,11,0,96,60,184,93,99,56,133,189,3,72,
64,134,98,56,125,189,3,72,0,0,29,136,0,0,156,137,116,7,140,125,
116,7,0,124,254,207,6,84,254,207,133,85,64,40,6,124,28,0,130,65,
120,243,196,127,11,0,96,60,24,94,99,56,77,189,3,72,64,134,98,56,
69,189,3,72,1,0,61,137,1,0,28,136,64,0,9,124,44,0,130,65,
254,7,38,85,254,7,5,84,64,40,6,124,28,0,130,65,120,243,196,127,
11,0,96,60,120,94,99,56,21,189,3,72,64,134,98,56,13,189,3,72,
8,0,31,128,1,0,222,59,0,0,30,124,3,0,156,59,208,254,128,65,
20,0,225,131,16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,
0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,
166,2,8,124,28,0,1,144,16,0,193,147,120,35,158,124,20,0,225,147,
120,43,191,124,12,0,161,147,120,27,125,124,205,236,255,75,0,0,3,44,
32,0,130,65,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,0,0,191,128,120,243,195,127,
0,0,128,56,141,88,253,75,120,243,195,127,156,0,157,56,3,0,160,56,
17,219,3,72,16,0,0,56,0,0,31,144,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,0,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,12,0,161,147,166,2,8,124,28,0,1,144,
20,0,225,147,120,35,159,124,8,0,129,147,120,43,188,124,16,0,193,147,
120,27,126,124,45,236,255,75,0,0,3,44,36,0,130,65,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,0,0,188,128,0,0,128,56,120,251,227,127,
241,87,253,75,8,0,190,128,120,251,227,127,76,0,158,56,58,16,165,84,
113,218,3,72,8,0,30,128,58,16,10,84,20,82,191,127,0,0,29,152,
8,0,190,128,140,0,158,56,1,0,189,59,120,235,163,127,77,218,3,72,
8,0,126,129,20,90,189,127,80,232,159,125,0,0,156,145,16,0,193,131,
28,0,1,128,20,0,225,131,8,0,129,131,12,0,161,131,0,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,166,2,8,124,
28,0,1,144,8,0,129,147,120,27,124,124,20,0,225,147,12,0,161,147,
120,35,157,124,120,235,191,127,120,251,227,127,0,0,128,56,16,0,193,147,
120,43,190,124,4,0,160,56,73,87,253,75,120,227,131,127,77,235,255,75,
0,0,3,44,36,0,130,65,16,0,193,131,20,0,225,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
0,0,60,129,0,0,224,56,0,72,7,124,255,255,255,59,47,0,92,57,
28,0,128,64,1,0,10,141,1,0,31,157,0,0,60,129,1,0,231,56,
0,72,7,124,236,255,128,65,4,0,28,128,0,0,0,57,0,0,8,124,
51,0,156,57,28,0,128,64,1,0,108,141,1,0,127,157,4,0,28,128,
1,0,8,57,0,0,8,124,236,255,128,65,8,0,28,128,0,0,64,57,
0,0,10,124,53,0,220,56,28,0,128,64,1,0,134,141,1,0,159,157,
8,0,28,128,1,0,74,57,0,0,10,124,236,255,128,65,12,0,92,129,
0,0,10,44,1,0,255,59,32,0,130,64,1,0,192,56,0,0,223,152,
20,0,28,129,0,0,8,44,1,0,255,59,92,0,130,64,60,0,0,72,
0,0,96,57,0,80,11,124,69,0,156,57,32,0,128,64,1,0,12,140,
0,0,31,152,12,0,92,129,1,0,107,57,0,80,11,124,1,0,255,59,
232,255,128,65,20,0,28,129,0,0,8,44,32,0,130,64,0,0,0,57,
0,0,31,153,16,0,28,128,0,0,8,124,71,0,252,56,104,0,128,64,
76,0,0,72,12,0,124,129,0,0,224,56,0,88,7,124,70,0,92,57,
32,0,128,64,1,0,42,141,0,0,63,153,12,0,124,129,1,0,231,56,
0,88,7,124,1,0,255,59,232,255,128,65,16,0,28,128,0,0,0,57,
0,0,8,124,255,255,255,59,71,0,252,56,28,0,128,64,1,0,7,140,
1,0,31,156,16,0,28,128,1,0,8,57,0,0,8,124,236,255,128,65,
74,0,28,136,1,0,31,156,75,0,252,136,0,0,32,57,1,0,255,152,
2,0,63,157,1,0,255,59,80,248,29,124,0,0,30,144,16,0,193,131,
28,0,1,128,20,0,225,131,8,0,129,131,12,0,161,131,120,75,35,125,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,12,0,161,147,
16,0,193,147,166,2,8,124,28,0,1,144,20,0,225,147,120,43,191,124,
0,0,191,128,120,27,125,124,120,35,158,124,0,0,128,56,120,243,195,127,
53,85,253,75,0,0,125,129,0,0,126,153,4,0,157,129,1,0,158,153,
8,0,29,128,2,0,30,152,6,0,30,136,12,0,253,128,3,0,254,152,
16,0,29,129,4,0,30,153,20,0,61,129,0,0,96,56,118,6,0,84,
64,0,128,57,128,0,0,96,5,0,62,153,6,0,30,152,63,0,126,152,
0,0,159,145,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,
20,0,130,64,160,0,96,56,9,163,3,72,121,27,127,124,68,1,130,65,
120,251,227,127,101,227,255,75,12,0,0,60,44,28,0,48,36,0,31,144,
76,134,34,137,26,0,63,153,77,134,66,137,27,0,95,153,78,134,98,137,
28,0,127,153,79,134,130,137,29,0,159,153,80,134,2,136,30,0,31,152,
81,134,2,136,31,0,31,152,82,134,2,136,32,0,31,152,72,134,34,137,
24,0,63,153,73,134,66,137,120,243,195,127,44,0,223,147,25,0,95,153,
201,80,0,72,4,0,3,44,0,0,127,144,12,0,129,64,4,0,128,57,
0,0,159,145,120,243,195,127,17,79,0,72,16,0,3,44,8,0,127,144,
12,0,129,64,16,0,0,56,8,0,31,144,120,243,195,127,153,76,0,72,
2,0,3,44,4,0,127,144,12,0,129,64,2,0,32,57,4,0,63,145,
120,243,195,127,189,74,0,72,1,0,3,44,12,0,127,144,12,0,129,64,
1,0,64,57,12,0,95,145,120,243,195,127,125,75,0,72,2,0,3,44,
16,0,127,144,12,0,129,64,2,0,96,57,16,0,127,145,120,243,195,127,
225,72,0,72,1,0,3,44,20,0,127,144,12,0,129,64,1,0,128,57,
20,0,159,145,4,0,223,128,8,0,159,128,0,0,191,128,11,0,96,60,
4,95,99,56,101,183,3,72,16,0,223,128,12,0,159,128,20,0,191,128,
11,0,96,60,208,94,99,56,77,183,3,72,120,251,227,127,93,236,255,75,
20,0,1,128,120,251,227,127,12,0,225,131,8,0,193,131,166,3,8,124,
16,0,33,56,32,0,128,78,5,4,96,56,32,0,128,78,5,4,96,56,
32,0,128,78,5,4,96,56,32,0,128,78,5,4,96,56,32,0,128,78,
0,0,128,57,0,0,133,145,16,0,3,128,0,0,0,44,16,0,129,64,
4,0,128,57,0,0,133,145,16,0,3,128,0,0,32,57,0,0,9,124,
28,0,128,64,4,0,140,57,0,0,133,145,16,0,3,128,1,0,41,57,
0,0,9,124,236,255,128,65,0,0,96,56,32,0,128,78,224,255,33,148,
16,0,129,147,120,27,124,124,12,0,97,147,24,0,193,147,28,0,225,147,
166,2,8,124,36,0,1,144,20,0,161,147,120,43,189,124,0,0,64,57,
0,0,93,145,20,0,28,128,0,0,0,44,120,35,159,124,20,0,129,64,
4,0,64,57,0,0,93,145,20,0,28,128,4,0,255,59,0,0,96,59,
0,0,27,124,236,0,220,59,176,0,128,64,0,0,31,129,49,6,6,85,
132,0,130,65,0,0,30,128,254,47,6,84,254,47,5,85,64,40,6,124,
112,0,130,65,120,219,100,127,11,0,96,60,48,95,99,56,45,182,3,72,
0,0,127,129,44,0,124,128,120,219,100,127,2,0,160,56,254,47,102,85,
229,69,0,72,0,0,3,44,40,0,130,65,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,
32,0,33,56,32,0,128,78,0,0,31,128,0,0,190,128,254,47,0,84,
8,217,5,80,0,0,190,144,0,0,93,129,4,0,74,57,0,0,93,145,
20,0,28,128,1,0,123,59,0,0,27,124,4,0,222,59,4,0,255,59,
88,255,128,65,20,0,161,131,28,0,225,131,24,0,193,131,16,0,129,131,
36,0,1,128,12,0,97,131,0,0,96,56,166,3,8,124,32,0,33,56,
32,0,128,78,0,0,128,57,0,0,133,145,4,0,3,128,0,0,0,44,
16,0,129,64,4,0,128,57,0,0,133,145,4,0,3,128,0,0,32,57,
0,0,9,124,28,0,128,64,4,0,140,57,0,0,133,145,4,0,3,128,
1,0,41,57,0,0,9,124,236,255,128,65,0,0,96,56,32,0,128,78,
224,255,33,148,16,0,129,147,120,27,124,124,12,0,97,147,24,0,193,147,
28,0,225,147,166,2,8,124,36,0,1,144,20,0,161,147,120,43,189,124,
0,0,32,57,0,0,61,145,0,0,28,128,0,0,0,44,120,35,159,124,
20,0,129,64,4,0,32,57,0,0,61,145,0,0,28,128,4,0,255,59,
0,0,96,59,0,0,27,124,196,0,220,59,172,0,128,64,0,0,31,128,
49,6,5,84,128,0,130,65,0,0,222,128,254,31,198,84,254,31,5,84,
64,40,6,124,108,0,130,65,120,219,100,127,11,0,96,60,116,95,99,56,
173,180,3,72,44,0,124,128,0,0,31,128,254,31,5,84,120,219,100,127,
137,76,0,72,0,0,3,44,40,0,130,65,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,
32,0,33,56,32,0,128,78,0,0,159,129,0,0,30,128,254,31,139,85,
132,232,96,81,0,0,30,144,0,0,61,129,4,0,41,57,0,0,61,145,
0,0,28,128,1,0,123,59,0,0,27,124,4,0,222,59,4,0,255,59,
92,255,128,65,20,0,161,131,28,0,225,131,24,0,193,131,16,0,129,131,
36,0,1,128,12,0,97,131,0,0,96,56,166,3,8,124,32,0,33,56,
32,0,128,78,224,255,33,148,16,0,129,147,120,27,124,124,12,0,97,147,
24,0,193,147,28,0,225,147,166,2,8,124,36,0,1,144,20,0,161,147,
120,43,189,124,0,0,64,57,0,0,93,145,12,0,28,128,0,0,0,44,
120,35,159,124,20,0,129,64,4,0,64,57,0,0,93,145,12,0,28,128,
4,0,255,59,0,0,96,59,0,0,27,124,228,0,220,59,176,0,128,64,
0,0,31,129,49,6,6,85,132,0,130,65,0,0,30,128,254,71,6,84,
254,71,5,85,64,40,6,124,112,0,130,65,120,219,100,127,11,0,96,60,
172,95,99,56,125,179,3,72,0,0,127,129,44,0,124,128,120,219,100,127,
1,0,160,56,254,71,102,85,217,68,0,72,0,0,3,44,40,0,130,65,
20,0,161,131,24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,
12,0,97,131,166,3,8,124,32,0,33,56,32,0,128,78,0,0,31,128,
0,0,190,128,254,71,0,84,206,193,5,80,0,0,190,144,0,0,93,129,
4,0,74,57,0,0,93,145,12,0,28,128,1,0,123,59,0,0,27,124,
4,0,222,59,4,0,255,59,88,255,128,65,20,0,161,131,28,0,225,131,
24,0,193,131,16,0,129,131,36,0,1,128,12,0,97,131,0,0,96,56,
166,3,8,124,32,0,33,56,32,0,128,78,232,255,33,148,166,2,8,124,
28,0,1,144,12,0,161,147,120,27,125,124,16,0,193,147,121,43,190,124,
20,0,225,147,120,35,159,124,72,0,130,65,44,0,125,128,1,0,160,56,
120,43,166,124,241,72,0,72,0,0,3,44,132,0,130,64,58,16,235,87,
20,90,253,127,128,0,31,132,156,139,192,83,120,243,204,127,20,90,221,127,
0,0,31,144,60,0,30,132,156,139,128,81,0,0,30,144,88,0,0,72,
58,16,235,87,20,90,253,127,128,0,63,133,218,3,42,85,20,90,221,127,
0,0,95,145,60,0,30,132,218,3,0,84,0,0,30,144,44,0,125,128,
254,127,61,85,21,71,0,72,189,182,255,75,0,0,3,44,28,0,130,65,
0,0,31,128,156,139,160,83,0,0,31,144,0,0,30,128,156,139,160,83,
0,0,30,144,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,
120,27,124,124,12,0,97,147,24,0,193,147,28,0,225,147,166,2,8,124,
36,0,1,144,20,0,161,147,120,43,189,124,0,0,0,57,0,0,29,145,
8,0,28,128,0,0,0,44,120,35,159,124,20,0,129,64,4,0,0,57,
0,0,29,145,8,0,28,128,4,0,255,59,0,0,96,59,0,0,27,124,
128,0,220,59,188,1,128,64,0,0,63,129,49,6,44,85,144,1,130,65,
0,0,94,129,254,191,70,85,254,191,37,85,64,40,6,124,36,0,130,65,
120,219,100,127,11,0,96,60,248,95,99,56,109,177,3,72,84,134,98,56,
101,177,3,72,0,0,63,129,0,0,94,129,254,159,70,85,254,159,37,85,
64,40,6,124,36,0,130,65,120,219,100,127,11,0,96,60,88,96,99,56,
61,177,3,72,84,134,98,56,53,177,3,72,0,0,63,129,0,0,94,129,
254,143,70,85,254,143,37,85,64,40,6,124,36,0,130,65,120,219,100,127,
11,0,96,60,180,96,99,56,13,177,3,72,84,134,98,56,5,177,3,72,
0,0,63,129,0,0,94,129,254,127,70,85,254,127,37,85,64,40,6,124,
112,0,130,65,120,219,100,127,11,0,96,60,4,97,99,56,221,176,3,72,
0,0,127,129,120,227,131,127,120,219,100,127,254,127,101,85,245,253,255,75,
0,0,3,44,32,0,130,64,0,0,63,129,0,0,94,129,254,39,70,85,
254,39,37,85,64,40,6,124,92,0,130,65,56,0,0,72,20,0,161,131,
24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,254,39,70,85,254,39,37,85,
64,40,6,124,36,0,130,65,120,219,100,127,11,0,96,60,88,97,99,56,
97,176,3,72,84,134,98,56,89,176,3,72,0,0,63,129,0,0,94,129,
254,31,70,85,254,31,37,85,64,40,6,124,36,0,130,64,0,0,29,129,
4,0,8,57,0,0,29,145,8,0,28,128,4,0,222,59,1,0,123,59,
4,0,255,59,56,0,0,72,120,219,100,127,11,0,96,60,172,97,99,56,
17,176,3,72,84,134,98,56,9,176,3,72,0,0,29,129,4,0,8,57,
0,0,29,145,8,0,28,128,4,0,222,59,1,0,123,59,4,0,255,59,
0,0,27,124,76,254,128,65,20,0,161,131,28,0,225,131,24,0,193,131,
16,0,129,131,36,0,1,128,12,0,97,131,0,0,96,56,166,3,8,124,
32,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,120,27,124,124,
12,0,97,147,24,0,193,147,28,0,225,147,166,2,8,124,36,0,1,144,
20,0,161,147,120,43,189,124,0,0,128,57,0,0,157,145,8,0,28,128,
0,0,0,44,120,35,159,124,20,0,129,64,4,0,128,57,0,0,157,145,
8,0,28,128,4,0,255,59,0,0,96,59,0,0,27,124,60,0,220,59,
180,0,128,64,0,0,31,128,49,6,8,84,136,0,130,65,0,0,62,129,
254,127,38,85,254,127,5,84,64,40,6,124,116,0,130,65,120,219,100,127,
11,0,96,60,0,98,99,56,45,175,3,72,0,0,31,128,120,227,131,127,
120,219,100,127,254,127,5,84,69,252,255,75,0,0,3,44,36,0,130,64,
0,0,157,129,4,0,140,57,0,0,157,145,8,0,28,128,4,0,222,59,
1,0,123,59,4,0,255,59,64,0,0,72,20,0,161,131,24,0,193,131,
28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,166,3,8,124,
32,0,33,56,32,0,128,78,4,0,140,57,0,0,157,145,8,0,28,128,
4,0,222,59,1,0,123,59,4,0,255,59,0,0,27,124,84,255,128,65,
20,0,161,131,28,0,225,131,24,0,193,131,16,0,129,131,36,0,1,128,
12,0,97,131,0,0,96,56,166,3,8,124,32,0,33,56,32,0,128,78,
4,0,131,129,12,0,227,128,48,0,3,128,0,0,3,129,8,0,195,128,
16,0,99,129,20,0,35,129,20,66,70,125,20,98,74,125,20,58,202,124,
20,74,6,125,20,90,72,125,20,2,138,125,58,16,140,85,8,0,140,57,
64,96,5,124,0,0,96,56,32,0,128,76,208,1,96,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,16,0,30,129,120,35,159,124,0,64,31,124,28,0,128,65,
12,0,225,131,8,0,193,131,166,3,8,124,10,4,96,56,16,0,33,56,
32,0,128,78,44,0,126,128,5,65,0,72,128,255,3,44,60,0,130,64,
240,0,254,56,58,16,232,87,20,66,39,125,4,0,105,133,6,0,0,56,
62,6,11,80,0,0,105,145,20,0,1,128,8,0,193,131,12,0,225,131,
16,4,96,56,166,3,8,124,16,0,33,56,32,0,128,78,246,255,3,44,
44,0,128,64,58,16,236,87,20,98,30,125,244,0,40,133,1,0,0,56,
10,0,224,56,0,0,96,56,30,130,233,80,62,6,9,80,0,0,40,145,
52,0,0,72,235,0,3,44,8,0,129,64,235,0,96,56,58,16,236,87,
20,98,30,125,244,0,40,133,1,0,0,56,20,0,227,56,0,0,96,56,
30,130,233,80,62,6,9,80,0,0,40,145,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
20,0,254,128,120,35,159,124,0,56,31,124,28,0,128,65,20,0,225,131,
16,0,193,131,166,3,8,124,10,4,96,56,24,0,33,56,32,0,128,78,
44,0,126,128,2,0,160,56,8,0,193,56,117,61,0,72,0,0,3,44,
236,0,94,57,58,16,236,87,36,0,130,64,20,98,10,125,0,0,104,129,
8,0,1,136,1,0,32,57,8,217,11,80,62,6,43,81,0,0,104,145,
20,0,0,72,46,80,204,124,6,0,32,57,62,6,38,81,46,97,202,124,
28,0,1,128,20,0,225,131,16,0,193,131,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,
16,0,193,147,120,27,126,124,4,0,30,128,120,35,159,124,0,0,31,124,
32,0,128,65,20,0,225,131,28,0,1,128,16,0,193,131,10,4,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,44,0,126,128,3,0,160,56,
8,0,193,56,45,64,0,72,0,0,3,44,56,0,130,64,8,0,1,136,
0,0,0,44,2,0,64,57,44,0,130,64,212,0,30,57,58,16,224,87,
20,2,104,125,4,0,11,132,1,0,64,57,0,0,96,56,62,6,64,81,
0,0,11,144,36,0,0,72,6,0,64,57,212,0,30,57,58,16,224,87,
20,2,104,125,4,0,11,132,62,6,64,81,0,0,96,56,0,0,11,144,
28,0,1,128,20,0,225,131,16,0,193,131,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,20,0,225,147,166,2,8,124,28,0,1,144,
16,0,193,147,120,27,126,124,0,0,254,128,120,35,159,124,0,56,31,124,
28,0,128,65,20,0,225,131,16,0,193,131,166,3,8,124,10,4,96,56,
24,0,33,56,32,0,128,78,44,0,126,128,8,0,161,56,173,66,0,72,
0,0,3,44,196,0,126,57,58,16,236,87,36,0,130,64,20,98,11,125,
0,0,72,129,8,0,1,136,1,0,32,57,132,232,10,80,62,6,42,81,
0,0,72,145,20,0,0,72,46,88,12,124,6,0,32,57,62,6,32,81,
46,97,11,124,28,0,1,128,20,0,225,131,16,0,193,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,20,0,225,147,166,2,8,124,
28,0,1,144,16,0,193,147,120,27,126,124,12,0,254,128,120,35,159,124,
0,56,31,124,28,0,128,65,20,0,225,131,16,0,193,131,166,3,8,124,
10,4,96,56,24,0,33,56,32,0,128,78,44,0,126,128,2,0,160,56,
8,0,193,56,5,61,0,72,0,0,3,44,228,0,94,57,58,16,236,87,
36,0,130,64,20,98,10,125,0,0,104,129,8,0,1,136,1,0,32,57,
206,193,11,80,62,6,43,81,0,0,104,145,20,0,0,72,46,80,204,124,
6,0,32,57,62,6,38,81,46,97,202,124,28,0,1,128,20,0,225,131,
16,0,193,131,166,3,8,124,24,0,33,56,32,0,128,78,0,0,96,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,225,255,255,75,0,0,3,44,28,0,130,65,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,0,0,94,129,0,0,224,59,0,80,31,124,40,0,128,64,
120,243,195,127,120,251,228,127,89,254,255,75,0,0,3,44,200,255,130,64,
0,0,94,129,1,0,255,59,0,80,31,124,224,255,128,65,4,0,126,129,
0,0,224,59,0,88,31,124,40,0,128,64,120,243,195,127,120,251,228,127,
93,253,255,75,0,0,3,44,148,255,130,64,4,0,126,129,1,0,255,59,
0,88,31,124,224,255,128,65,20,0,158,129,0,0,224,59,0,96,31,124,
40,0,128,64,120,243,195,127,120,251,228,127,129,252,255,75,0,0,3,44,
96,255,130,64,20,0,158,129,1,0,255,59,0,96,31,124,224,255,128,65,
16,0,30,128,0,0,224,59,0,0,31,124,40,0,128,64,120,243,195,127,
120,251,228,127,77,251,255,75,0,0,3,44,44,255,130,64,16,0,30,128,
1,0,255,59,0,0,31,124,224,255,128,65,12,0,30,128,0,0,224,59,
0,0,31,124,40,0,128,64,120,243,195,127,120,251,228,127,45,254,255,75,
0,0,3,44,248,254,130,64,12,0,30,128,1,0,255,59,0,0,31,124,
224,255,128,65,12,0,225,131,20,0,1,128,8,0,193,131,0,0,96,56,
166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
120,27,124,124,16,0,193,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,51,221,124,20,0,225,147,0,0,224,59,0,0,253,147,16,0,156,129,
0,96,31,124,120,35,158,124,72,0,128,64,120,227,131,127,120,251,228,127,
157,250,255,75,0,0,3,44,36,0,130,65,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,16,0,156,129,1,0,255,59,0,96,31,124,192,255,128,65,
0,0,12,44,72,0,129,64,120,243,195,127,240,0,156,56,4,0,160,56,
37,199,3,72,0,0,93,129,4,0,74,57,0,0,93,145,16,0,188,128,
244,0,156,56,20,82,126,124,58,16,165,84,5,199,3,72,16,0,28,128,
0,0,125,129,58,16,0,84,20,2,107,125,0,0,125,145,20,0,225,131,
16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,0,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
120,27,124,124,16,0,193,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,51,221,124,20,0,225,147,0,0,224,59,0,0,253,147,20,0,156,129,
0,96,31,124,120,35,158,124,72,0,128,64,120,227,131,127,120,251,228,127,
173,250,255,75,0,0,3,44,36,0,130,65,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,20,0,156,129,1,0,255,59,0,96,31,124,192,255,128,65,
0,0,12,44,72,0,129,64,120,243,195,127,232,0,156,56,4,0,160,56,
53,198,3,72,0,0,93,129,4,0,74,57,0,0,93,145,20,0,188,128,
236,0,156,56,20,82,126,124,58,16,165,84,21,198,3,72,20,0,28,128,
0,0,125,129,58,16,0,84,20,2,107,125,0,0,125,145,20,0,225,131,
16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,0,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
120,27,124,124,16,0,193,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,51,221,124,20,0,225,147,0,0,224,59,0,0,253,147,4,0,156,129,
0,96,31,124,120,35,158,124,72,0,128,64,120,227,131,127,120,251,228,127,
101,250,255,75,0,0,3,44,36,0,130,65,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,4,0,156,129,1,0,255,59,0,96,31,124,192,255,128,65,
0,0,12,44,72,0,129,64,120,243,195,127,212,0,156,56,4,0,160,56,
69,197,3,72,0,0,93,129,4,0,74,57,0,0,93,145,4,0,188,128,
216,0,156,56,20,82,126,124,58,16,165,84,37,197,3,72,4,0,28,128,
0,0,125,129,58,16,0,84,20,2,107,125,0,0,125,145,20,0,225,131,
16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,0,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
120,27,124,124,16,0,193,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,51,221,124,20,0,225,147,0,0,224,59,0,0,253,147,0,0,156,129,
0,96,31,124,120,35,158,124,72,0,128,64,120,227,131,127,120,251,228,127,
61,250,255,75,0,0,3,44,36,0,130,65,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,0,0,156,129,1,0,255,59,0,96,31,124,192,255,128,65,
0,0,12,44,72,0,129,64,120,243,195,127,192,0,156,56,4,0,160,56,
85,196,3,72,0,0,93,129,4,0,74,57,0,0,93,145,0,0,188,128,
196,0,156,56,20,82,126,124,58,16,165,84,53,196,3,72,0,0,28,128,
0,0,125,129,58,16,0,84,20,2,107,125,0,0,125,145,20,0,225,131,
16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,0,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
120,27,124,124,16,0,193,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,51,221,124,20,0,225,147,0,0,224,59,0,0,253,147,12,0,156,129,
0,96,31,124,120,35,158,124,72,0,128,64,120,227,131,127,120,251,228,127,
241,249,255,75,0,0,3,44,36,0,130,65,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,12,0,156,129,1,0,255,59,0,96,31,124,192,255,128,65,
0,0,12,44,72,0,129,64,120,243,195,127,224,0,156,56,4,0,160,56,
101,195,3,72,0,0,93,129,4,0,74,57,0,0,93,145,12,0,188,128,
228,0,156,56,20,82,126,124,58,16,165,84,69,195,3,72,12,0,28,128,
0,0,125,129,58,16,0,84,20,2,107,125,0,0,125,145,20,0,225,131,
16,0,193,131,12,0,161,131,28,0,1,128,8,0,129,131,0,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,20,0,225,147,
120,35,159,124,166,2,8,124,28,0,1,144,12,0,161,147,120,51,221,124,
0,0,32,57,16,0,193,147,0,0,61,145,120,27,126,124,193,249,255,75,
0,0,3,44,32,0,130,65,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,8,0,30,128,
0,0,0,44,72,0,129,64,120,251,227,127,124,0,158,56,4,0,160,56,
157,194,3,72,0,0,93,129,4,0,74,57,0,0,93,145,8,0,190,128,
128,0,158,56,20,82,127,124,58,16,165,84,125,194,3,72,8,0,30,128,
0,0,157,129,58,16,0,84,20,2,140,125,0,0,157,145,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,0,0,96,56,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,20,0,225,147,120,35,159,124,
166,2,8,124,28,0,1,144,12,0,161,147,120,51,221,124,0,0,32,57,
16,0,193,147,0,0,61,145,120,27,126,124,253,248,255,75,0,0,3,44,
32,0,130,65,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,8,0,30,128,0,0,0,44,
72,0,129,64,120,251,227,127,56,0,158,56,4,0,160,56,217,193,3,72,
0,0,93,129,4,0,74,57,0,0,93,145,8,0,190,128,60,0,158,56,
20,82,127,124,58,16,165,84,185,193,3,72,8,0,30,128,0,0,157,129,
58,16,0,84,20,2,140,125,0,0,157,145,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,0,0,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,
8,0,193,147,120,27,126,124,16,0,30,128,0,0,224,59,0,0,31,124,
32,0,128,64,120,243,195,127,120,251,228,127,121,244,255,75,16,0,30,128,
1,0,255,59,0,0,31,124,232,255,128,65,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,
8,0,129,147,12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,
16,0,193,147,120,27,126,124,20,0,30,128,0,0,128,59,0,0,28,124,
1,0,160,59,236,0,254,59,92,0,128,64,44,0,126,128,120,227,132,127,
2,0,160,56,0,0,192,56,5,50,0,72,0,0,3,44,28,0,130,65,
120,243,195,127,120,227,132,127,241,244,255,75,4,0,255,59,1,0,156,59,
28,0,0,72,0,0,31,128,1,0,156,59,70,1,0,84,62,6,160,83,
0,0,31,144,4,0,255,59,20,0,30,128,0,0,28,124,172,255,128,65,
16,0,193,131,20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,
166,3,8,124,24,0,33,56,32,0,128,78,232,255,33,148,12,0,161,147,
20,0,225,147,166,2,8,124,28,0,1,144,16,0,193,147,120,27,126,124,
12,0,30,128,0,0,160,59,0,0,29,124,228,0,254,59,96,0,128,64,
44,0,126,128,120,235,164,127,1,0,160,56,0,0,192,56,1,51,0,72,
0,0,3,44,28,0,130,65,120,243,195,127,120,235,164,127,93,246,255,75,
4,0,255,59,1,0,189,59,32,0,0,72,0,0,159,129,1,0,189,59,
12,2,140,85,1,0,0,56,62,6,12,80,0,0,159,145,4,0,255,59,
12,0,30,128,0,0,29,124,168,255,128,65,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
240,255,33,148,12,0,225,147,166,2,8,124,20,0,1,144,8,0,193,147,
120,27,126,124,4,0,30,128,0,0,224,59,0,0,31,124,32,0,128,64,
120,243,195,127,120,251,228,127,109,244,255,75,4,0,30,128,1,0,255,59,
0,0,31,124,232,255,128,65,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,232,255,33,148,8,0,129,147,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,12,0,161,147,
120,27,125,124,0,0,29,128,0,0,128,59,0,0,28,124,1,0,224,59,
196,0,221,59,88,0,128,64,44,0,125,128,120,227,132,127,1,0,160,56,
117,56,0,72,0,0,3,44,28,0,130,65,120,235,163,127,120,227,132,127,
177,244,255,75,4,0,222,59,1,0,156,59,28,0,0,72,0,0,30,128,
1,0,156,59,0,32,0,100,62,6,224,83,0,0,30,144,4,0,222,59,
0,0,29,128,0,0,28,124,176,255,128,65,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,224,255,33,148,12,0,97,147,16,0,129,147,24,0,193,147,
28,0,225,147,166,2,8,124,36,0,1,144,20,0,161,147,120,27,125,124,
8,0,189,128,128,0,253,59,58,16,165,84,0,0,128,56,120,251,227,127,
249,59,253,75,8,0,189,128,60,0,125,56,58,16,165,84,0,0,128,56,
229,59,253,75,8,0,29,128,0,0,128,59,0,0,28,124,5,0,96,59,
1,0,192,59,132,0,128,64,44,0,125,128,120,227,132,127,133,52,0,72,
188,255,255,128,46,68,103,80,188,255,255,144,85,96,255,75,0,0,31,129,
0,0,3,44,188,255,31,128,40,0,130,64,62,6,104,83,12,0,10,101,
0,0,95,145,62,6,96,83,12,0,11,100,188,255,127,145,4,0,255,59,
1,0,156,59,40,0,0,72,62,6,200,83,0,128,12,97,64,0,138,101,
0,0,95,145,62,6,192,83,64,0,11,100,188,255,127,145,4,0,255,59,
1,0,156,59,8,0,29,128,0,0,28,124,132,255,128,65,20,0,161,131,
24,0,193,131,28,0,225,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,52,0,127,56,0,0,128,56,
200,0,160,56,5,59,253,75,0,0,0,56,52,0,31,152,252,0,31,152,
120,251,227,127,97,252,255,75,120,251,227,127,185,254,255,75,120,251,227,127,
5,254,255,75,120,251,227,127,161,253,255,75,120,251,227,127,241,252,255,75,
120,251,227,127,221,251,255,75,1,0,0,56,252,0,31,152,12,0,225,131,
20,0,1,128,166,3,8,124,16,0,33,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,
120,35,158,124,28,0,130,65,0,0,128,56,37,202,255,75,255,7,192,87,
12,0,130,65,120,251,227,127,129,138,3,72,20,0,1,128,12,0,225,131,
8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,120,35,131,124,32,0,128,56,69,58,253,75,
12,0,1,128,8,0,33,56,166,3,8,124,0,0,96,56,32,0,128,78,
224,255,33,148,12,0,97,147,16,0,129,147,20,0,161,147,28,0,225,147,
166,2,8,124,36,0,1,144,24,0,193,147,120,27,126,124,92,134,98,56,
241,157,3,72,24,0,158,56,11,0,96,60,20,99,99,56,225,157,3,72,
26,0,158,56,11,0,96,60,48,99,99,56,209,157,3,72,4,0,222,128,
8,0,158,128,0,0,190,128,11,0,96,60,84,98,99,56,185,157,3,72,
20,0,190,128,16,0,222,128,12,0,158,128,11,0,96,60,72,99,99,56,
161,157,3,72,120,243,195,127,45,243,255,75,52,0,158,136,120,27,127,124,
116,7,132,124,11,0,96,60,156,98,99,56,129,157,3,72,8,0,30,128,
0,0,128,59,0,0,28,124,56,0,126,59,11,0,160,63,48,0,128,64,
120,227,132,127,11,0,96,60,192,98,99,56,89,157,3,72,4,0,155,132,
128,99,125,56,77,157,3,72,8,0,30,128,1,0,156,59,0,0,28,124,
216,255,128,65,0,0,128,59,0,0,28,124,124,0,126,59,48,0,128,64,
120,227,132,127,11,0,96,60,156,99,99,56,29,157,3,72,4,0,155,132,
128,99,125,56,17,157,3,72,8,0,30,128,1,0,156,59,0,0,28,124,
216,255,128,65,0,0,30,128,0,0,128,59,0,0,28,124,192,0,126,59,
48,0,128,64,120,227,132,127,11,0,96,60,224,98,99,56,221,156,3,72,
4,0,155,132,128,99,125,56,209,156,3,72,0,0,30,128,1,0,156,59,
0,0,28,124,216,255,128,65,4,0,30,128,0,0,128,59,0,0,28,124,
212,0,126,59,48,0,128,64,120,227,132,127,11,0,96,60,188,99,99,56,
157,156,3,72,4,0,155,132,128,99,125,56,145,156,3,72,4,0,30,128,
1,0,156,59,0,0,28,124,216,255,128,65,12,0,30,128,0,0,128,59,
0,0,28,124,224,0,126,59,48,0,128,64,120,227,132,127,11,0,96,60,
128,98,99,56,93,156,3,72,4,0,155,132,128,99,125,56,81,156,3,72,
12,0,30,128,1,0,156,59,0,0,28,124,216,255,128,65,20,0,30,128,
0,0,96,59,0,0,27,124,232,0,158,59,48,0,128,64,120,219,100,127,
11,0,96,60,248,98,99,56,29,156,3,72,4,0,156,132,128,99,125,56,
17,156,3,72,20,0,30,128,1,0,123,59,0,0,27,124,216,255,128,65,
16,0,30,128,0,0,96,59,0,0,27,124,240,0,158,59,48,0,128,64,
120,219,100,127,11,0,96,60,220,99,99,56,221,155,3,72,4,0,156,132,
128,99,125,56,209,155,3,72,16,0,30,128,1,0,123,59,0,0,27,124,
216,255,128,65,92,134,98,56,185,155,3,72,120,251,227,127,28,0,225,131,
20,0,161,131,24,0,193,131,36,0,1,128,16,0,129,131,12,0,97,131,
166,3,8,124,32,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,8,0,131,129,0,96,4,124,24,0,128,65,12,0,1,128,
8,0,33,56,166,3,8,124,14,1,96,56,32,0,128,78,13,0,5,40,
32,0,130,64,58,16,137,84,20,74,67,125,128,0,10,128,0,0,96,56,
254,127,11,84,0,0,102,153,20,0,0,72,11,0,96,60,4,100,99,56,
53,155,3,72,0,0,96,56,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,216,255,33,148,12,0,33,147,16,0,65,147,24,0,129,147,
28,0,161,147,32,0,193,147,36,0,225,147,166,2,8,124,44,0,1,144,
20,0,97,147,120,27,123,124,8,0,123,129,120,35,153,124,0,88,25,124,
0,0,192,59,3,0,160,63,0,255,189,59,36,0,128,65,20,0,97,131,
32,0,193,131,28,0,161,131,12,0,33,131,166,3,8,124,14,1,96,56,
40,0,33,56,32,0,128,78,14,0,5,40,148,4,129,65,3,0,64,61,
196,75,74,57,58,16,160,84,46,0,10,125,166,3,9,125,32,4,128,78,
44,78,3,0,176,77,3,0,44,79,3,0,24,77,3,0,144,76,3,0,
76,77,3,0,116,79,3,0,72,80,3,0,144,76,3,0,0,76,3,0,
168,79,3,0,196,79,3,0,224,79,3,0,252,79,3,0,144,76,3,0,
44,0,123,128,120,203,36,127,7,0,160,56,157,48,0,72,121,27,126,124,
52,4,130,64,58,16,36,87,20,34,155,127,128,0,124,133,60,0,107,85,
20,34,91,127,64,0,96,97,94,4,6,84,0,0,220,144,60,0,26,133,
64,0,64,57,60,0,8,85,62,6,72,81,0,0,26,145,0,0,28,128,
4,0,192,60,4,0,0,61,126,171,12,84,1,0,198,56,56,96,197,124,
64,64,5,124,224,3,130,64,250,7,10,84,193,0,64,85,0,0,28,144,
0,0,154,129,64,0,0,56,62,6,12,80,193,0,133,85,0,0,186,144,
188,3,0,72,44,0,123,128,14,0,5,44,120,203,36,127,24,0,130,64,
7,0,160,56,5,48,0,72,121,27,126,124,156,3,130,64,20,0,0,72,
5,0,160,56,241,47,0,72,121,27,126,124,136,3,130,64,58,16,36,87,
20,34,155,127,128,0,28,132,58,0,0,84,20,34,91,127,2,0,7,96,
94,4,224,84,0,96,0,100,0,0,28,144,60,0,90,133,58,0,74,85,
2,0,75,97,0,96,108,101,0,0,154,145,0,0,28,128,176,6,0,84,
0,0,28,144,0,0,186,128,176,6,165,84,0,0,186,144,52,3,0,72,
44,0,123,128,120,203,36,127,3,0,160,56,133,47,0,72,121,27,126,124,
28,3,130,64,124,0,219,56,58,16,39,87,20,58,6,125,4,0,40,133,
0,2,41,97,0,0,40,145,0,3,0,72,44,0,123,128,120,203,36,127,
0,0,160,56,81,47,0,72,121,27,126,124,232,2,130,64,58,16,36,87,
20,34,155,127,128,0,92,133,1,0,128,57,157,3,74,85,60,0,123,56,
62,6,138,81,64,0,64,101,0,128,5,96,0,0,188,144,46,32,195,124,
56,232,198,124,20,34,227,124,46,33,195,124,0,0,7,129,62,6,136,81,
64,0,10,101,0,0,71,145,156,2,0,72,44,0,123,128,120,203,36,127,
6,0,160,56,237,46,0,72,121,27,126,124,132,2,130,64,128,0,123,57,
58,16,36,87,46,32,11,124,157,3,0,84,20,34,139,125,46,33,11,124,
0,0,172,128,5,0,192,56,62,6,197,80,0,0,172,144,46,32,235,124,
60,0,123,56,12,0,231,100,46,33,235,124,46,32,3,125,20,34,35,125,
56,232,8,125,46,33,3,125,0,0,73,129,62,6,202,80,0,0,73,145,
46,32,99,125,12,0,107,101,46,33,99,125,32,2,0,72,58,16,36,87,
20,34,155,127,128,0,156,133,1,0,224,59,157,3,140,85,20,34,91,127,
62,6,236,83,64,0,139,101,0,0,124,145,60,0,154,133,44,0,123,128,
56,232,140,125,120,203,36,127,62,6,236,83,64,0,134,101,0,0,218,144,
197,44,0,72,93,89,255,75,0,0,3,44,32,0,130,64,44,0,123,128,
120,203,36,127,173,44,0,72,21,89,255,75,0,0,3,44,8,0,130,64,
0,0,224,59,44,0,123,128,62,6,255,87,120,203,36,127,141,44,0,72,
13,89,255,75,0,0,31,44,40,0,130,65,0,0,252,128,2,0,0,57,
62,6,7,81,0,96,233,100,0,0,60,145,0,0,26,128,62,6,0,81,
62,6,0,81,0,0,26,144,0,0,3,44,32,0,130,65,0,0,28,128,
64,0,160,56,62,6,160,80,0,0,28,144,0,0,218,128,62,6,166,80,
0,0,218,144,0,0,31,44,1,0,160,56,16,0,130,64,0,0,3,44,
8,0,130,64,0,0,160,56,0,0,60,129,52,0,168,124,126,217,7,85,
32,124,233,80,0,0,60,145,32,1,0,72,128,0,123,57,58,16,36,87,
46,32,75,125,157,3,74,85,20,34,139,125,46,33,75,125,0,0,236,128,
60,0,123,56,64,0,231,100,0,0,236,144,46,32,3,124,56,232,0,124,
20,34,131,125,46,33,3,124,0,0,172,128,64,0,165,100,0,0,172,144,
216,0,0,72,44,0,123,128,120,203,36,127,2,0,160,56,41,45,0,72,
121,27,126,124,192,0,130,64,124,0,219,56,58,16,39,87,20,58,6,125,
4,0,40,133,0,32,41,97,0,0,40,145,164,0,0,72,124,0,91,57,
58,16,32,87,20,2,138,125,4,0,172,132,0,8,165,96,0,0,172,144,
136,0,0,72,124,0,219,56,58,16,39,87,20,58,6,125,4,0,40,133,
0,4,41,97,0,0,40,145,108,0,0,72,124,0,91,57,58,16,44,87,
20,98,170,124,4,0,229,132,0,16,231,96,0,0,229,144,80,0,0,72,
44,0,123,128,120,203,36,127,1,0,160,56,161,44,0,72,121,27,126,124,
56,0,130,64,58,16,36,87,20,34,59,125,128,0,105,133,2,0,107,101,
20,34,251,124,0,0,105,145,60,0,39,133,2,0,41,101,0,0,39,145,
16,0,0,72,11,0,96,60,32,100,99,56,21,150,3,72,28,0,161,131,
120,243,195,127,32,0,193,131,20,0,97,131,24,0,129,131,36,0,225,131,
44,0,1,128,16,0,65,131,12,0,33,131,166,3,8,124,40,0,33,56,
32,0,128,78,232,255,33,148,12,0,161,147,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,0,0,165,128,120,27,126,124,120,35,159,124,
61,231,255,75,208,1,3,44,36,0,130,64,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,208,1,96,56,166,3,8,124,24,0,33,56,
32,0,128,78,0,0,0,56,8,0,1,144,120,243,195,127,8,0,191,59,
120,235,164,127,8,0,161,56,193,229,255,75,8,0,129,128,120,27,127,124,
11,0,96,60,96,100,99,56,101,149,3,72,0,0,31,44,56,1,130,64,
8,0,1,128,20,2,189,127,120,243,195,127,8,0,161,56,120,235,164,127,
77,227,255,75,8,0,129,128,120,27,127,124,11,0,96,60,132,100,99,56,
49,149,3,72,0,0,31,44,4,1,130,64,8,0,1,129,20,66,189,127,
120,243,195,127,8,0,161,56,120,235,164,127,217,223,255,75,8,0,129,128,
120,27,127,124,11,0,96,60,168,100,99,56,253,148,3,72,0,0,31,44,
208,0,130,64,8,0,33,129,20,74,189,127,120,243,195,127,8,0,161,56,
120,235,164,127,89,223,255,75,8,0,129,128,120,27,127,124,11,0,96,60,
60,100,99,56,201,148,3,72,0,0,31,44,156,0,130,64,8,0,1,128,
20,2,189,127,120,243,195,127,8,0,161,56,120,235,164,127,161,224,255,75,
8,0,129,128,120,27,127,124,11,0,96,60,196,100,99,56,149,148,3,72,
0,0,31,44,104,0,130,64,8,0,97,129,20,90,189,127,120,243,195,127,
8,0,161,56,120,235,164,127,189,221,255,75,8,0,129,128,120,27,127,124,
11,0,96,60,232,100,99,56,97,148,3,72,0,0,31,44,52,0,130,64,
8,0,1,128,120,243,195,127,20,2,157,124,8,0,161,56,65,221,255,75,
8,0,129,128,120,27,127,124,11,0,96,60,8,101,99,56,49,148,3,72,
0,0,31,44,36,0,130,65,120,251,227,127,20,0,225,131,28,0,1,128,
16,0,193,131,12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,
20,0,225,131,16,0,193,131,28,0,1,128,12,0,161,131,0,0,96,56,
166,3,8,124,24,0,33,56,32,0,128,78,216,255,33,148,24,0,129,147,
36,0,225,147,16,0,65,147,20,0,97,147,32,0,193,147,166,2,8,124,
44,0,1,144,28,0,161,147,120,43,189,124,0,0,189,128,120,27,124,124,
120,35,159,124,0,0,128,56,120,251,227,127,189,47,253,75,2,0,0,56,
0,0,31,152,0,0,192,59,4,0,223,147,4,0,127,56,93,140,1,72,
52,0,220,155,0,0,189,128,8,0,127,59,8,0,193,147,120,227,131,127,
8,0,193,56,120,219,100,127,213,239,255,75,8,0,129,128,120,27,126,124,
11,0,96,60,76,101,99,56,93,147,3,72,0,0,30,44,100,1,130,64,
8,0,65,131,0,0,189,128,120,227,131,127,8,0,193,56,20,210,123,127,
120,219,100,127,217,238,255,75,8,0,129,128,120,27,126,124,11,0,96,60,
112,101,99,56,37,147,3,72,0,0,30,44,44,1,130,64,8,0,33,129,
0,0,189,128,120,227,131,127,8,0,193,56,20,74,123,127,20,74,90,127,
120,219,100,127,189,236,255,75,8,0,129,128,120,27,126,124,11,0,96,60,
148,101,99,56,233,146,3,72,0,0,30,44,240,0,130,64,8,0,33,129,
0,0,189,128,120,227,131,127,8,0,193,56,20,74,123,127,20,74,90,127,
120,219,100,127,145,235,255,75,8,0,129,128,120,27,126,124,11,0,96,60,
244,101,99,56,173,146,3,72,0,0,30,44,180,0,130,64,8,0,33,129,
0,0,189,128,120,227,131,127,8,0,193,56,20,74,123,127,20,74,90,127,
120,219,100,127,53,237,255,75,8,0,129,128,120,27,126,124,11,0,96,60,
44,101,99,56,113,146,3,72,0,0,30,44,120,0,130,64,8,0,33,129,
0,0,189,128,120,227,131,127,8,0,193,56,20,74,123,127,20,74,90,127,
120,219,100,127,41,234,255,75,8,0,129,128,120,27,126,124,11,0,96,60,
176,101,99,56,53,146,3,72,0,0,30,44,60,0,130,64,8,0,33,129,
0,0,189,128,120,227,131,127,8,0,193,56,20,74,155,124,20,74,90,127,
1,233,255,75,8,0,129,128,120,27,126,124,11,0,96,60,208,101,99,56,
253,145,3,72,0,0,30,44,48,0,130,65,24,0,129,131,28,0,161,131,
120,243,195,127,32,0,193,131,36,0,225,131,44,0,1,128,20,0,97,131,
16,0,65,131,166,3,8,124,40,0,33,56,32,0,128,78,8,0,33,129,
20,74,90,127,11,0,96,60,24,102,99,56,8,0,26,56,0,0,29,144,
4,0,154,56,62,4,132,84,2,0,159,176,161,145,3,72,2,0,127,56,
229,138,1,72,52,0,124,137,116,7,107,125,119,7,96,85,1,0,127,153,
52,0,28,152,32,0,193,131,28,0,161,131,24,0,129,131,44,0,1,128,
36,0,225,131,16,0,65,131,20,0,97,131,0,0,96,56,166,3,8,124,
40,0,33,56,32,0,128,78,224,255,33,148,16,0,129,147,28,0,225,147,
12,0,97,147,24,0,193,147,166,2,8,124,36,0,1,144,20,0,161,147,
120,43,189,124,0,0,189,128,120,27,124,124,120,35,159,124,0,0,128,56,
120,251,227,127,49,45,253,75,1,0,0,57,0,0,31,153,0,0,192,59,
1,0,223,155,4,0,223,147,4,0,127,56,205,137,1,72,8,0,159,137,
136,0,136,113,9,0,223,155,8,0,31,153,48,0,28,128,12,0,127,56,
36,0,224,56,11,0,128,60,8,0,160,56,11,0,255,152,48,0,223,59,
10,0,31,152,112,102,132,56,113,175,3,72,20,0,127,56,11,0,128,60,
124,102,132,56,8,0,160,56,93,175,3,72,28,0,127,56,11,0,128,60,
136,102,132,56,16,0,160,56,73,175,3,72,44,0,127,56,11,0,128,60,
161,102,132,56,4,0,160,56,53,175,3,72,8,0,28,128,0,0,0,44,
48,0,60,129,58,16,40,85,20,66,126,127,120,0,129,64,1,0,64,57,
48,0,95,153,49,0,31,152,0,0,96,57,50,0,127,153,11,0,160,56,
51,0,191,152,120,219,99,127,11,0,128,60,52,102,132,56,241,174,3,72,
8,0,28,128,0,0,0,44,11,0,123,59,4,0,222,59,56,0,129,64,
23,0,128,57,0,0,158,153,1,0,30,152,0,0,0,56,2,0,30,152,
12,0,160,56,3,0,190,152,120,219,99,127,11,0,128,60,176,102,132,56,
177,174,3,72,4,0,222,59,12,0,123,59,0,0,60,129,0,0,9,44,
48,0,129,64,3,0,160,56,0,0,190,152,1,0,62,153,0,0,224,56,
2,0,254,152,3,0,190,152,120,219,99,127,104,134,130,56,121,174,3,72,
4,0,222,59,3,0,123,59,4,0,252,128,0,0,7,44,56,0,129,64,
2,0,32,57,0,0,62,153,1,0,254,152,0,0,64,57,2,0,94,153,
12,0,160,56,3,0,190,152,120,219,99,127,11,0,128,60,192,102,132,56,
57,174,3,72,4,0,222,59,12,0,123,59,12,0,92,129,0,0,10,44,
56,0,129,64,5,0,96,57,0,0,126,153,1,0,94,153,0,0,0,56,
2,0,30,152,9,0,160,56,3,0,190,152,120,219,99,127,11,0,128,60,
64,102,132,56,249,173,3,72,4,0,222,59,9,0,123,59,20,0,124,129,
0,0,11,44,52,0,129,64,6,0,224,56,0,0,254,152,1,0,126,153,
0,0,0,56,2,0,30,152,7,0,160,56,3,0,190,152,120,219,99,127,
96,134,130,56,189,173,3,72,4,0,222,59,7,0,123,59,16,0,92,129,
0,0,10,44,52,0,129,64,1,0,94,153,4,0,0,56,0,0,30,152,
0,0,0,56,2,0,30,152,18,0,160,56,3,0,190,152,120,219,99,127,
11,0,128,60,208,102,132,56,125,173,3,72,18,0,123,59,80,216,159,125,
0,0,157,145,252,255,140,56,62,4,132,84,2,0,159,176,11,0,96,60,
76,102,99,56,177,142,3,72,2,0,127,56,245,135,1,72,20,0,161,131,
28,0,225,131,24,0,193,131,16,0,129,131,36,0,1,128,12,0,97,131,
0,0,96,56,166,3,8,124,32,0,33,56,32,0,128,78,224,255,33,148,
16,0,129,147,28,0,225,147,166,2,8,124,36,0,1,144,12,0,97,147,
24,0,193,147,20,0,161,147,120,43,189,124,0,0,221,128,3,0,6,40,
120,35,156,124,108,134,66,57,255,255,74,57,0,0,224,59,8,0,225,155,
1,0,128,57,9,0,129,153,2,0,0,56,120,51,222,124,10,0,1,152,
11,0,96,60,228,102,99,56,8,0,129,64,3,0,192,59,0,0,252,155,
4,0,124,59,62,4,222,87,2,0,220,179,120,243,196,127,5,142,3,72,
2,0,124,56,73,135,1,72,120,219,99,127,8,0,129,56,120,243,197,127,
149,172,3,72,4,0,30,56,0,0,29,144,16,0,129,131,24,0,193,131,
20,0,161,131,36,0,1,128,12,0,97,131,120,251,227,127,28,0,225,131,
32,0,33,56,166,3,8,124,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,121,27,127,124,8,0,193,147,120,35,158,124,
20,0,130,64,0,1,96,56,17,120,3,72,121,27,127,124,172,1,130,65,
120,251,227,127,185,185,255,75,12,0,0,60,196,28,0,48,36,0,31,144,
112,134,194,136,26,0,223,152,113,134,226,136,27,0,255,152,114,134,2,137,
28,0,31,153,115,134,2,136,29,0,31,152,116,134,130,137,24,0,159,153,
117,134,2,136,120,243,195,127,44,0,223,147,25,0,31,152,233,37,0,72,
4,0,3,44,0,0,127,144,12,0,129,64,4,0,128,57,0,0,159,145,
120,243,195,127,49,36,0,72,16,0,3,44,8,0,127,144,12,0,129,64,
16,0,0,56,8,0,31,144,120,243,195,127,185,33,0,72,2,0,3,44,
4,0,127,144,12,0,129,64,2,0,192,56,4,0,223,144,120,243,195,127,
221,31,0,72,1,0,3,44,12,0,127,144,12,0,129,64,1,0,224,56,
12,0,255,144,120,243,195,127,157,32,0,72,2,0,3,44,16,0,127,144,
12,0,129,64,2,0,0,57,16,0,31,145,120,243,195,127,1,30,0,72,
1,0,3,44,20,0,127,144,12,0,129,64,1,0,32,57,20,0,63,145,
4,0,223,128,8,0,159,128,0,0,191,128,11,0,96,60,60,103,99,56,
133,140,3,72,16,0,223,128,12,0,159,128,20,0,191,128,11,0,96,60,
8,103,99,56,109,140,3,72,0,0,95,129,0,0,10,44,0,0,0,57,
48,0,31,145,12,0,129,64,1,0,0,57,48,0,31,145,8,0,127,129,
0,0,11,44,12,0,129,64,2,0,8,57,48,0,31,145,4,0,159,129,
0,0,12,44,12,0,129,64,1,0,8,57,48,0,31,145,12,0,31,128,
0,0,0,44,12,0,129,64,1,0,8,57,48,0,31,145,16,0,223,128,
0,0,6,44,12,0,129,64,1,0,8,57,48,0,31,145,20,0,255,128,
0,0,7,44,12,0,129,64,1,0,40,57,48,0,63,145,120,251,227,127,
213,236,255,75,20,0,1,128,120,251,227,127,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,6,4,96,56,32,0,128,78,
6,4,96,56,32,0,128,78,6,4,96,56,32,0,128,78,6,4,96,56,
32,0,128,78,6,4,96,56,32,0,128,78,6,4,96,56,32,0,128,78,
6,4,96,56,32,0,128,78,6,4,96,56,32,0,128,78,166,2,8,124,
4,0,1,144,240,255,33,148,120,27,108,124,4,0,108,128,36,0,99,129,
92,0,11,128,0,0,140,136,8,0,161,56,1,0,192,56,166,3,9,124,
33,4,128,78,52,0,96,124,62,222,3,84,20,0,1,128,16,0,33,56,
166,3,8,124,32,0,128,78,240,255,33,148,12,0,225,147,166,2,8,124,
20,0,1,144,0,0,131,136,4,0,99,128,36,0,131,129,92,0,12,128,
8,0,161,56,2,0,192,56,128,255,224,59,166,3,9,124,33,4,128,78,
0,0,3,44,8,0,97,161,112,70,108,125,46,68,107,85,120,99,107,125,
62,4,107,85,8,0,97,177,48,0,130,64,62,220,107,85,107,5,108,85,
8,0,97,177,24,0,130,65,0,8,11,32,112,30,11,124,208,0,235,127,
116,7,227,127,16,0,0,72,112,30,127,125,116,7,255,127,120,251,227,127,
20,0,1,128,12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,
232,255,33,148,166,2,8,124,28,0,1,144,12,0,161,147,120,35,157,124,
20,0,225,147,121,27,127,124,16,0,193,147,120,43,190,124,20,0,130,64,
12,0,96,56,245,116,3,72,121,27,127,124,84,0,130,65,0,0,191,155,
12,0,0,60,108,29,0,48,8,0,31,144,36,0,158,129,28,0,12,128,
120,235,164,127,120,243,195,127,1,0,160,56,26,0,192,56,166,3,9,124,
4,0,223,147,33,4,128,78,0,0,159,136,4,0,127,128,36,0,35,129,
36,0,9,128,0,0,160,56,166,3,9,124,33,4,128,78,120,251,227,127,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
8,0,193,147,121,27,126,124,12,0,225,147,120,35,159,124,44,0,130,65,
12,0,0,60,124,29,0,48,0,0,30,144,11,0,96,60,104,103,99,56,
201,137,3,72,255,7,224,87,12,0,130,65,120,243,195,127,217,117,3,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,8,0,193,147,
121,27,126,124,12,0,225,147,120,35,159,124,56,0,130,65,12,0,128,61,
148,29,140,57,0,0,158,145,11,0,96,60,184,103,99,56,105,137,3,72,
120,243,195,127,0,0,128,56,97,255,255,75,255,7,224,87,12,0,130,65,
120,243,195,127,109,117,3,72,20,0,1,128,12,0,225,131,8,0,193,131,
166,3,8,124,16,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,11,0,96,60,240,103,99,56,29,137,3,72,12,0,1,128,
8,0,33,56,166,3,8,124,0,0,96,56,32,0,128,78,240,255,33,148,
166,2,8,124,20,0,1,144,8,0,193,147,121,27,126,124,12,0,225,147,
120,35,159,124,56,0,130,65,12,0,128,61,172,29,140,57,0,0,158,145,
11,0,96,60,148,104,99,56,209,136,3,72,120,243,195,127,0,0,128,56,
201,254,255,75,255,7,224,87,12,0,130,65,120,243,195,127,213,116,3,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,11,0,96,60,
204,104,99,56,133,136,3,72,12,0,1,128,8,0,33,56,166,3,8,124,
0,0,96,56,32,0,128,78,120,27,108,124,12,0,76,137,1,0,0,57,
48,32,7,125,116,7,231,124,57,80,233,124,0,0,96,56,12,0,130,65,
1,4,96,56,32,0,128,78,0,0,5,44,13,0,204,136,120,59,64,125,
12,0,12,152,16,0,130,65,120,59,203,124,13,0,108,153,32,0,128,78,
120,56,198,124,13,0,204,152,32,0,128,78,166,2,8,124,4,0,1,144,
240,255,33,148,120,27,108,124,4,0,108,128,36,0,99,129,92,0,11,128,
0,0,140,136,8,0,161,56,1,0,192,56,166,3,9,124,33,4,128,78,
52,0,96,124,62,222,3,84,20,0,1,128,16,0,33,56,166,3,8,124,
32,0,128,78,232,255,33,148,16,0,193,147,120,43,190,124,8,0,30,40,
166,2,8,124,28,0,1,144,120,27,107,124,20,0,225,147,120,51,223,124,
0,0,128,57,8,0,129,153,0,0,139,136,4,0,107,128,36,0,35,129,
20,0,9,129,8,0,161,56,166,3,9,125,33,4,128,78,8,0,1,136,
48,246,7,124,255,7,234,84,0,0,95,153,28,0,1,128,20,0,225,131,
16,0,193,131,166,3,8,124,24,0,33,56,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,8,0,5,40,120,27,108,124,1,0,0,56,
48,40,10,124,62,6,74,85,16,0,129,65,13,0,12,137,57,64,71,125,
12,0,130,65,0,4,96,56,100,0,0,72,14,0,12,136,0,0,6,44,
48,0,130,65,4,0,108,128,120,83,9,124,14,0,44,153,36,0,99,129,
100,0,107,129,0,0,140,136,14,0,172,56,1,0,192,56,166,3,105,125,
33,4,128,78,44,0,0,72,4,0,108,128,120,80,9,124,14,0,44,153,
36,0,99,129,100,0,107,129,0,0,140,136,14,0,172,56,1,0,192,56,
166,3,105,125,33,4,128,78,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,240,255,33,148,0,0,3,44,166,2,8,124,20,0,1,144,
8,0,193,147,120,35,158,124,12,0,225,147,120,43,191,124,20,0,130,64,
16,0,96,56,13,113,3,72,0,0,3,44,44,0,130,65,0,0,195,155,
4,0,227,147,12,0,0,60,212,29,0,48,8,0,3,144,255,0,96,57,
13,0,99,153,0,0,128,57,12,0,131,153,14,0,99,153,20,0,1,128,
12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,32,0,128,78,
29,0,96,61,24,49,107,57,0,0,128,57,4,0,139,145,8,0,139,145,
12,0,139,145,12,0,96,60,20,31,99,56,224,107,3,72,224,255,33,148,
24,0,193,147,166,2,8,124,36,0,1,144,28,0,225,147,120,27,127,124,
4,0,95,129,5,0,132,136,0,0,32,57,68,0,0,72,58,16,40,85,
46,64,10,125,0,0,8,136,64,32,0,124,44,0,130,64,11,0,96,60,
248,106,99,56,221,133,3,72,28,0,225,131,36,0,1,128,24,0,193,131,
8,4,96,56,166,3,8,124,32,0,33,56,32,0,128,78,1,0,41,57,
0,0,10,44,0,0,0,56,16,0,130,65,8,0,223,128,80,48,10,124,
112,22,0,124,64,0,9,124,164,255,128,65,28,0,160,60,180,85,165,56,
0,0,96,56,233,250,255,75,121,27,126,124,8,1,130,65,4,0,95,129,
0,0,10,44,8,0,63,129,120,243,203,127,0,0,0,56,8,0,97,145,
20,0,130,64,0,0,10,44,0,0,224,56,40,0,130,65,24,0,0,72,
0,0,10,44,80,72,10,124,0,0,224,56,112,22,0,124,16,0,130,65,
12,0,159,129,80,96,10,125,112,22,7,125,64,56,0,124,120,75,44,125,
36,0,128,64,0,0,108,145,4,0,44,57,8,0,63,145,8,0,96,56,
149,111,3,72,0,0,3,44,140,0,130,65,120,0,0,72,0,0,10,44,
32,0,130,64,16,0,129,145,120,251,227,127,16,0,129,56,1,0,160,56,
8,0,193,56,233,187,0,72,68,0,0,72,80,72,202,124,113,22,200,124,
32,0,130,64,16,0,129,145,120,251,227,127,16,0,129,56,1,0,160,56,
8,0,193,56,193,187,0,72,28,0,0,72,16,0,129,145,120,251,227,127,
16,0,129,56,1,0,160,56,8,0,193,56,165,187,0,72,8,0,96,56,
29,111,3,72,0,0,3,44,20,0,130,65,12,0,64,61,12,30,74,57,
0,0,67,145,4,0,195,147,0,0,3,44,32,0,130,64,28,0,225,131,
36,0,1,128,24,0,193,131,16,1,96,56,166,3,8,124,32,0,33,56,
32,0,128,78,68,0,223,128,0,0,6,44,72,0,255,128,12,0,97,144,
0,0,64,57,20,0,130,64,0,0,6,44,0,0,96,57,40,0,130,65,
24,0,0,72,0,0,6,44,80,56,102,125,112,22,106,125,0,0,96,57,
16,0,130,65,76,0,31,128,80,0,134,125,112,22,139,125,64,88,10,124,
120,59,235,124,24,0,128,64,4,0,139,57,72,0,159,145,0,0,107,144,
0,0,96,56,108,0,0,72,0,0,6,44,32,0,130,64,20,0,97,145,
64,0,127,56,20,0,129,56,1,0,160,56,12,0,193,56,153,102,0,72,
68,0,0,72,80,56,230,124,113,22,232,124,32,0,130,64,20,0,97,145,
64,0,127,56,20,0,129,56,1,0,160,56,12,0,193,56,113,102,0,72,
28,0,0,72,20,0,97,145,64,0,127,56,20,0,129,56,1,0,160,56,
12,0,193,56,85,102,0,72,0,0,96,56,36,0,1,128,28,0,225,131,
24,0,193,131,166,3,8,124,32,0,33,56,32,0,128,78,128,254,33,148,
56,1,193,145,60,1,225,145,64,1,1,146,68,1,33,146,72,1,65,146,
76,1,97,146,80,1,129,146,84,1,161,146,88,1,193,146,92,1,225,146,
96,1,1,147,100,1,33,147,104,1,65,147,108,1,97,147,112,1,129,147,
116,1,161,147,124,1,225,147,166,2,8,124,132,1,1,144,120,1,193,147,
120,35,158,124,2,0,30,136,3,0,254,136,46,68,231,84,120,3,224,124,
63,4,20,84,120,27,127,124,0,0,192,58,12,0,130,65,32,0,20,40,
8,0,129,64,7,4,192,58,4,0,191,128,5,0,158,136,0,0,0,57,
132,0,0,72,58,16,10,85,46,80,37,125,0,0,9,136,64,32,0,124,
108,0,130,64,11,0,96,60,36,107,99,56,201,130,3,72,76,1,97,130,
108,1,97,131,112,1,129,131,80,1,129,130,72,1,65,130,104,1,65,131,
116,1,161,131,84,1,161,130,68,1,33,130,100,1,33,131,120,1,193,131,
88,1,193,130,64,1,1,130,96,1,1,131,124,1,225,131,92,1,225,130,
60,1,225,129,132,1,1,128,56,1,193,129,8,4,96,56,166,3,8,124,
128,1,33,56,32,0,128,78,1,0,8,57,0,0,5,44,0,0,96,57,
16,0,130,65,8,0,223,128,80,48,133,125,112,22,139,125,64,88,8,124,
100,255,128,65,28,0,160,60,180,85,165,56,0,0,96,56,129,251,255,75,
121,27,113,124,96,0,130,64,76,1,97,130,108,1,97,131,112,1,129,131,
80,1,129,130,72,1,65,130,104,1,65,131,116,1,161,131,84,1,161,130,
68,1,33,130,100,1,33,131,120,1,193,131,88,1,193,130,64,1,1,130,
96,1,1,131,124,1,225,131,92,1,225,130,60,1,225,129,132,1,1,128,
56,1,193,129,16,1,96,56,166,3,8,124,128,1,33,56,32,0,128,78,
4,0,191,128,0,0,5,44,8,0,127,129,120,139,38,126,0,0,224,56,
24,1,193,144,20,0,130,64,0,0,5,44,0,0,0,56,40,0,130,65,
24,0,0,72,0,0,5,44,80,88,229,124,0,0,0,56,112,22,231,124,
16,0,130,65,12,0,63,129,80,72,5,125,112,22,0,125,64,0,7,124,
120,91,108,125,32,0,128,64,0,0,204,144,4,0,204,56,8,0,223,144,
4,0,222,136,0,0,6,44,120,0,130,65,120,0,0,72,0,0,5,44,
32,0,130,64,28,1,129,145,120,251,227,127,28,1,129,56,1,0,160,56,
24,1,193,56,61,184,0,72,68,0,0,72,80,88,5,124,113,22,11,124,
32,0,130,64,28,1,129,145,120,251,227,127,28,1,129,56,1,0,160,56,
24,1,193,56,21,184,0,72,28,0,0,72,28,1,129,145,120,251,227,127,
28,1,129,56,1,0,160,56,24,1,193,56,249,183,0,72,4,0,222,136,
0,0,6,44,8,0,130,64,7,4,192,58,0,0,20,44,29,0,160,62,
24,49,181,58,20,50,222,127,48,1,193,56,8,0,193,144,44,1,1,56,
12,0,1,144,36,1,1,56,16,0,1,144,32,1,1,58,40,1,225,57,
64,14,129,64,2,0,30,137,0,0,222,137,8,0,96,56,254,255,18,85,
254,7,19,85,254,247,22,85,25,107,3,72,0,0,3,44,32,0,130,65,
0,0,195,128,126,7,198,81,4,0,35,146,56,31,70,82,246,38,102,82,
180,46,198,82,0,0,195,144,121,27,118,124,68,254,130,65,1,0,62,137,
62,231,32,85,7,0,0,40,204,13,129,65,3,0,96,61,20,102,107,57,
58,16,0,84,46,0,75,125,166,3,73,125,32,4,128,78,196,115,3,0,
52,102,3,0,36,104,3,0,240,109,3,0,16,106,3,0,0,108,3,0,
220,111,3,0,208,113,3,0,20,0,95,129,0,0,10,44,0,0,0,56,
16,0,130,65,24,0,223,128,80,48,138,125,112,22,128,125,1,0,254,136,
120,3,19,124,62,7,236,84,0,96,19,124,28,1,128,64,0,96,19,124,
252,0,65,58,16,1,128,64,0,0,10,44,24,0,31,128,0,0,224,56,
0,0,242,144,120,59,232,124,20,0,130,64,0,0,10,44,0,0,192,56,
40,0,130,65,24,0,0,72,0,0,10,44,80,0,10,125,0,0,192,56,
112,22,8,125,16,0,130,65,28,0,127,129,80,88,42,125,112,22,38,125,
64,48,8,124,120,3,11,124,24,0,128,64,0,0,235,144,4,0,235,56,
24,0,255,144,1,0,115,58,160,0,0,72,0,0,10,44,44,0,130,64,
20,0,97,145,16,0,127,56,120,147,70,126,20,0,129,56,1,0,160,56,
77,168,0,72,20,0,95,129,1,0,30,136,62,7,12,84,108,0,0,72,
80,0,234,124,113,22,236,124,44,0,130,64,20,0,97,145,16,0,127,56,
120,147,70,126,20,0,129,56,1,0,160,56,25,168,0,72,20,0,95,129,
1,0,30,136,62,7,12,84,56,0,0,72,80,88,10,125,112,22,14,125,
20,0,97,145,16,0,127,56,120,147,70,126,20,0,129,56,1,0,160,56,
233,167,0,72,1,0,30,136,20,0,95,129,58,16,201,85,20,74,189,127,
62,7,12,84,1,0,115,58,0,96,19,124,248,254,128,65,255,255,44,57,
58,16,43,85,20,90,202,124,0,0,6,128,0,0,0,44,48,0,193,144,
52,0,65,145,92,0,130,64,60,0,65,145,24,0,96,56,0,0,96,58,
56,0,193,144,41,105,3,72,121,27,114,124,12,0,130,65,97,223,0,72,
120,147,83,126,56,0,1,129,0,0,104,146,1,0,62,137,20,0,95,129,
62,7,44,85,255,255,44,57,58,16,43,85,20,90,10,125,0,0,8,128,
0,0,0,44,68,0,65,145,64,0,1,145,60,252,130,65,58,16,38,85,
20,50,10,125,0,0,104,128,76,0,65,145,72,0,1,145,2,0,30,136,
254,238,5,84,120,179,196,126,169,221,0,72,121,27,118,124,184,11,130,65,
192,11,0,72,36,0,31,128,0,0,0,44,0,0,96,57,16,0,130,65,
40,0,127,129,80,88,64,125,112,22,75,125,1,0,158,137,120,91,115,125,
62,7,140,85,0,96,19,124,28,1,128,64,0,96,19,124,0,1,65,58,
16,1,128,64,0,0,0,44,40,0,31,129,0,0,32,57,0,0,50,145,
120,75,42,125,20,0,130,64,0,0,0,44,0,0,96,57,40,0,130,65,
24,0,0,72,0,0,0,44,80,64,192,124,0,0,96,57,112,22,202,124,
16,0,130,65,44,0,127,129,80,88,224,124,112,22,235,124,64,88,10,124,
120,67,10,125,24,0,128,64,0,0,42,145,4,0,10,57,40,0,31,145,
1,0,115,58,160,0,0,72,0,0,0,44,44,0,130,64,24,0,65,145,
32,0,127,56,120,147,70,126,24,0,129,56,1,0,160,56,249,142,0,72,
36,0,31,128,1,0,62,137,62,7,44,85,108,0,0,72,80,64,192,124,
113,22,198,124,44,0,130,64,24,0,65,145,32,0,127,56,120,147,70,126,
24,0,129,56,1,0,160,56,197,142,0,72,36,0,31,128,1,0,62,137,
62,7,44,85,56,0,0,72,80,80,0,124,112,22,14,124,24,0,65,145,
32,0,127,56,120,147,70,126,24,0,129,56,1,0,160,56,149,142,0,72,
1,0,62,137,36,0,31,128,58,16,200,85,20,66,156,127,62,7,44,85,
1,0,115,58,0,96,19,124,248,254,128,65,120,3,11,124,255,255,44,57,
58,16,42,85,20,82,107,125,0,0,139,129,0,0,12,44,80,0,97,145,
84,0,1,144,80,0,130,64,3,0,158,136,0,0,96,56,120,3,7,124,
92,0,1,144,20,82,103,126,88,0,97,146,145,214,0,72,0,0,115,144,
1,0,222,136,36,0,31,128,62,7,204,84,255,255,44,57,58,16,42,85,
20,2,74,125,96,0,65,145,0,0,74,129,0,0,10,44,100,0,1,144,
84,250,130,65,108,0,1,144,120,3,11,124,58,16,32,85,20,2,107,125,
0,0,107,128,104,0,97,145,2,0,158,137,254,238,133,85,120,179,196,126,
221,212,0,72,121,27,118,124,204,9,130,65,212,9,0,72,68,0,127,129,
0,0,11,44,0,0,64,57,16,0,130,65,72,0,63,129,80,72,203,124,
112,22,202,124,1,0,254,136,120,83,83,125,62,7,236,84,0,96,19,124,
28,1,128,64,0,96,19,124,4,1,65,58,16,1,128,64,0,0,11,44,
72,0,31,128,0,0,192,56,0,0,210,144,120,51,199,124,20,0,130,64,
0,0,11,44,0,0,64,57,40,0,130,65,24,0,0,72,0,0,11,44,
80,0,11,125,0,0,64,57,112,22,7,125,16,0,130,65,76,0,95,129,
80,80,43,125,112,22,42,125,64,80,7,124,120,3,9,124,24,0,128,64,
0,0,201,144,4,0,9,56,72,0,31,144,1,0,115,58,160,0,0,72,
0,0,11,44,44,0,130,64,28,0,33,145,64,0,127,56,120,147,70,126,
28,0,129,56,1,0,160,56,69,94,0,72,68,0,127,129,1,0,222,136,
62,7,204,84,108,0,0,72,80,0,235,124,113,22,236,124,44,0,130,64,
28,0,33,145,64,0,127,56,120,147,70,126,28,0,129,56,1,0,160,56,
17,94,0,72,68,0,127,129,1,0,222,136,62,7,204,84,56,0,0,72,
80,72,11,125,112,22,14,125,28,0,33,145,64,0,127,56,120,147,70,126,
28,0,129,56,1,0,160,56,225,93,0,72,1,0,222,136,68,0,127,129,
58,16,202,85,20,82,247,126,62,7,204,84,1,0,115,58,0,96,19,124,
248,254,128,65,255,255,44,57,58,16,39,85,20,58,203,124,0,0,6,128,
0,0,0,44,112,0,193,144,116,0,97,145,92,0,130,64,124,0,97,145,
24,0,96,56,0,0,96,58,120,0,193,144,77,101,3,72,121,27,114,124,
12,0,130,65,13,199,0,72,120,147,83,126,120,0,33,129,0,0,105,146,
1,0,94,137,68,0,127,129,62,7,76,85,255,255,44,57,58,16,39,85,
20,58,11,125,0,0,8,128,0,0,0,44,132,0,97,145,128,0,1,145,
96,248,130,65,58,16,41,85,20,74,235,124,0,0,103,128,140,0,97,145,
136,0,225,144,2,0,126,137,254,238,101,85,120,179,196,126,133,197,0,72,
121,27,118,124,220,7,130,65,228,7,0,72,84,0,255,128,0,0,7,44,
0,0,32,57,16,0,130,65,88,0,223,128,80,48,135,125,112,22,137,125,
1,0,222,136,120,75,50,125,62,7,204,84,0,96,18,124,28,1,128,64,
0,96,18,124,8,1,97,58,16,1,128,64,0,0,7,44,88,0,223,128,
0,0,96,57,0,0,115,145,120,91,105,125,20,0,130,64,0,0,7,44,
0,0,64,57,40,0,130,65,24,0,0,72,0,0,7,44,80,48,39,125,
0,0,64,57,112,22,41,125,16,0,130,65,92,0,95,129,80,80,7,124,
112,22,10,124,64,80,9,124,120,51,200,124,24,0,128,64,0,0,104,145,
4,0,72,57,88,0,95,145,1,0,82,58,160,0,0,72,0,0,7,44,
44,0,130,64,32,0,1,145,80,0,127,56,120,155,102,126,32,0,129,56,
1,0,160,56,241,68,0,72,84,0,255,128,1,0,94,137,62,7,76,85,
108,0,0,72,80,48,199,124,113,22,198,124,44,0,130,64,32,0,1,145,
80,0,127,56,120,155,102,126,32,0,129,56,1,0,160,56,189,68,0,72,
84,0,255,128,1,0,94,137,62,7,76,85,56,0,0,72,80,64,231,124,
112,22,238,124,32,0,1,145,80,0,127,56,120,155,102,126,32,0,129,56,
1,0,160,56,141,68,0,72,1,0,94,137,84,0,255,128,58,16,201,85,
20,74,24,127,62,7,76,85,1,0,82,58,0,96,18,124,248,254,128,65,
255,255,44,57,58,16,32,85,20,2,7,125,0,0,200,128,0,0,6,44,
144,0,1,145,148,0,225,144,92,0,130,64,156,0,225,144,16,0,96,56,
0,0,96,58,152,0,1,145,93,99,3,72,121,27,114,124,12,0,130,65,
101,194,0,72,120,147,83,126,152,0,225,128,0,0,103,146,1,0,30,136,
84,0,255,128,62,7,12,84,255,255,44,57,58,16,42,85,20,82,7,125,
0,0,136,129,0,0,12,44,164,0,225,144,160,0,1,145,112,246,130,65,
58,16,32,85,20,2,199,124,0,0,102,128,172,0,225,144,168,0,193,144,
2,0,94,137,254,238,69,85,120,179,196,126,173,192,0,72,121,27,118,124,
236,5,130,65,244,5,0,72,52,0,223,128,0,0,6,44,0,0,0,57,
16,0,130,65,56,0,159,129,80,96,102,125,112,22,104,125,1,0,30,136,
120,67,19,125,62,7,12,84,0,96,19,124,28,1,128,64,0,96,19,124,
12,1,65,58,16,1,128,64,0,0,6,44,56,0,127,129,0,0,64,57,
0,0,82,145,120,83,71,125,20,0,130,64,0,0,6,44,0,0,0,56,
40,0,130,65,24,0,0,72,0,0,6,44,80,88,230,124,0,0,0,56,
112,22,231,124,16,0,130,65,60,0,63,129,80,72,6,125,112,22,0,125,
64,0,7,124,120,91,103,125,24,0,128,64,0,0,71,145,4,0,71,57,
56,0,95,145,1,0,115,58,160,0,0,72,0,0,6,44,44,0,130,64,
36,0,225,144,48,0,127,56,120,147,70,126,36,0,129,56,1,0,160,56,
201,113,0,72,52,0,223,128,1,0,158,137,62,7,140,85,108,0,0,72,
80,88,6,125,113,22,0,125,44,0,130,64,36,0,225,144,48,0,127,56,
120,147,70,126,36,0,129,56,1,0,160,56,149,113,0,72,52,0,223,128,
1,0,158,137,62,7,140,85,56,0,0,72,80,56,6,124,112,22,14,124,
36,0,225,144,48,0,127,56,120,147,70,126,36,0,129,56,1,0,160,56,
101,113,0,72,1,0,158,137,52,0,223,128,58,16,202,85,20,82,57,127,
62,7,140,85,1,0,115,58,0,96,19,124,248,254,128,65,255,255,44,57,
58,16,42,85,20,82,102,125,0,0,11,129,0,0,8,44,176,0,97,145,
180,0,193,144,92,0,130,64,188,0,193,144,52,0,96,56,0,0,96,58,
184,0,97,145,109,97,3,72,121,27,114,124,12,0,130,65,197,197,0,72,
120,147,83,126,184,0,129,129,0,0,108,146,1,0,254,136,52,0,223,128,
62,7,236,84,255,255,44,57,58,16,32,85,20,2,102,125,192,0,97,145,
0,0,107,129,0,0,11,44,196,0,193,144,128,244,130,65,200,0,193,144,
58,16,44,85,110,96,102,124,0,0,208,144,2,0,254,136,120,179,196,126,
254,238,229,84,65,196,0,72,121,27,118,124,0,4,130,65,8,4,0,72,
100,0,127,129,0,0,11,44,0,0,224,56,16,0,130,65,104,0,63,129,
80,72,11,125,112,22,7,125,1,0,94,137,120,59,243,124,62,7,76,85,
0,96,19,124,28,1,128,64,0,96,19,124,16,1,65,58,16,1,128,64,
0,0,11,44,104,0,255,128,0,0,0,57,0,0,18,145,120,67,9,125,
20,0,130,64,0,0,11,44,0,0,0,56,40,0,130,65,24,0,0,72,
0,0,11,44,80,56,11,124,112,22,9,124,0,0,0,56,16,0,130,65,
108,0,95,129,80,80,203,124,112,22,192,124,64,0,9,124,120,59,230,124,
24,0,128,64,0,0,6,145,4,0,230,56,104,0,255,144,1,0,115,58,
160,0,0,72,0,0,11,44,44,0,130,64,96,0,127,56,40,0,193,144,
120,147,70,126,40,0,129,56,1,0,160,56,177,41,0,72,100,0,127,129,
1,0,222,136,62,7,204,84,108,0,0,72,80,56,11,124,113,22,0,124,
44,0,130,64,96,0,127,56,40,0,193,144,120,147,70,126,40,0,129,56,
1,0,160,56,125,41,0,72,100,0,127,129,1,0,222,136,62,7,204,84,
56,0,0,72,80,48,43,125,112,22,46,125,96,0,127,56,40,0,193,144,
120,147,70,126,40,0,129,56,1,0,160,56,77,41,0,72,1,0,222,136,
100,0,127,129,58,16,202,85,20,82,123,127,62,7,204,84,1,0,115,58,
0,96,19,124,248,254,128,65,255,255,44,57,58,16,39,85,20,58,11,125,
0,0,8,128,0,0,0,44,204,0,1,145,208,0,97,145,92,0,130,64,
216,0,97,145,28,0,96,56,0,0,96,58,212,0,1,145,129,95,3,72,
121,27,114,124,12,0,130,65,205,187,0,72,120,147,83,126,212,0,65,129,
0,0,106,146,1,0,158,137,100,0,127,129,62,7,140,85,255,255,44,57,
58,16,32,85,20,2,11,125,220,0,1,145,0,0,8,129,0,0,8,44,
224,0,97,145,148,242,130,65,16,0,65,129,0,0,111,145,58,16,41,85,
20,74,107,125,0,0,106,145,2,0,94,137,0,0,107,128,120,179,196,126,
254,238,69,85,17,186,0,72,121,27,118,124,12,2,130,65,20,2,0,72,
4,0,117,129,0,0,11,44,0,0,192,56,16,0,130,65,8,0,213,128,
80,48,11,124,112,22,6,124,1,0,30,136,120,51,211,124,62,7,12,84,
0,96,19,124,24,1,128,64,0,96,19,124,20,1,65,58,8,1,128,64,
4,0,21,128,0,0,0,44,8,0,117,129,0,0,224,56,0,0,242,144,
120,59,232,124,20,0,130,64,0,0,0,44,0,0,192,56,40,0,130,65,
24,0,0,72,0,0,0,44,80,88,0,125,0,0,192,56,112,22,8,125,
16,0,130,65,12,0,85,129,80,80,32,125,112,22,38,125,64,48,8,124,
120,91,106,125,24,0,128,64,0,0,234,144,4,0,202,56,8,0,213,144,
1,0,115,58,148,0,0,72,0,0,0,44,40,0,130,64,44,0,65,145,
120,171,163,126,120,147,70,126,44,0,129,56,1,0,160,56,153,23,0,72,
1,0,254,136,62,7,236,84,100,0,0,72,80,88,192,124,113,22,198,124,
40,0,130,64,44,0,65,145,120,171,163,126,120,147,70,126,44,0,129,56,
1,0,160,56,105,23,0,72,1,0,254,136,62,7,236,84,52,0,0,72,
80,80,224,124,112,22,238,124,44,0,65,145,120,171,163,126,120,147,70,126,
44,0,129,56,1,0,160,56,61,23,0,72,1,0,254,136,58,16,203,85,
62,7,236,84,20,90,90,127,1,0,115,58,0,96,19,124,0,255,128,65,
4,0,117,129,255,255,44,57,58,16,32,85,20,2,235,124,0,0,135,129,
0,0,12,44,228,0,225,144,232,0,97,145,92,0,130,64,240,0,97,145,
56,0,96,56,0,0,96,58,236,0,225,144,145,93,3,72,121,27,114,124,
12,0,130,65,13,198,0,72,120,147,83,126,236,0,193,128,0,0,102,146,
1,0,254,136,4,0,117,129,62,7,236,84,255,255,44,57,58,16,40,85,
20,66,75,125,0,0,10,128,0,0,0,44,248,0,97,145,244,0,65,145,
164,240,130,65,12,0,65,129,8,0,1,129,58,16,38,85,0,0,104,145,
20,50,107,125,0,0,106,145,2,0,30,136,0,0,107,128,120,179,196,126,
254,238,5,84,77,196,0,72,121,27,118,124,24,0,130,65,32,0,0,72,
0,0,20,44,9,4,192,58,32,0,130,65,24,0,0,72,252,255,148,54,
4,0,222,59,200,241,129,65,0,0,20,44,8,0,130,65,7,4,192,58,
76,1,97,130,108,1,97,131,112,1,129,131,80,1,129,130,72,1,65,130,
104,1,65,131,116,1,161,131,84,1,161,130,68,1,33,130,100,1,33,131,
120,1,193,131,92,1,225,130,120,179,195,126,88,1,193,130,64,1,1,130,
96,1,1,131,124,1,225,131,132,1,1,128,60,1,225,129,56,1,193,129,
166,3,8,124,128,1,33,56,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,41,206,0,72,0,0,3,44,
12,0,130,64,120,251,227,127,61,199,0,72,20,0,1,128,12,0,225,131,
16,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
232,255,33,148,29,0,128,61,24,49,140,57,4,0,236,128,0,0,7,44,
24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,0,0,96,56,
32,0,128,78,8,0,12,129,80,64,7,124,113,22,0,124,60,0,130,65,
0,0,7,44,0,0,96,57,8,0,130,65,120,3,11,124,255,255,43,57,
64,72,3,124,32,0,129,65,58,16,106,84,20,82,103,125,0,0,11,128,
0,0,0,44,8,0,97,145,12,0,225,144,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,0,0,96,56,32,0,128,78,120,3,3,124,
0,0,67,129,36,0,138,129,16,0,97,145,20,0,225,144,166,3,137,125,
33,4,128,78,28,0,1,128,24,0,33,56,166,3,8,124,62,6,99,84,
32,0,128,78,166,2,8,124,4,0,1,144,232,255,33,148,29,0,96,61,
24,49,107,57,4,0,235,128,0,0,7,44,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,10,4,96,56,32,0,128,78,8,0,11,129,
80,64,7,124,113,22,0,124,60,0,130,65,0,0,7,44,0,0,96,57,
8,0,130,65,120,3,11,124,255,255,43,57,64,72,3,124,32,0,129,65,
58,16,107,84,20,90,71,125,0,0,10,128,0,0,0,44,8,0,65,145,
12,0,225,144,24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,
10,4,96,56,32,0,128,78,120,3,3,124,0,0,131,129,28,0,140,129,
16,0,65,145,20,0,225,144,166,3,137,125,33,4,128,78,28,0,1,128,
24,0,33,56,166,3,8,124,32,0,128,78,29,0,96,61,24,49,107,57,
4,0,75,129,0,0,10,44,0,0,96,56,32,0,130,77,8,0,11,128,
80,0,138,125,112,22,131,125,32,0,128,78,166,2,8,124,4,0,1,144,
232,255,33,148,100,0,3,129,0,0,8,44,120,35,128,124,120,43,164,124,
120,51,197,124,24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,
10,4,96,56,32,0,128,78,104,0,227,128,80,56,136,125,113,22,137,125,
60,0,130,65,0,0,8,44,0,0,96,57,8,0,130,65,120,75,43,125,
255,255,43,57,64,72,0,124,32,0,129,65,58,16,0,84,20,2,72,125,
0,0,234,128,0,0,7,44,8,0,65,145,12,0,1,145,24,0,130,64,
28,0,1,128,24,0,33,56,166,3,8,124,10,4,96,56,32,0,128,78,
120,59,227,124,0,0,131,129,28,0,12,128,16,0,65,145,20,0,1,145,
166,3,9,124,33,4,128,78,28,0,1,128,24,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,232,255,33,148,100,0,3,129,
0,0,8,44,120,35,128,124,120,43,164,124,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,10,4,96,56,32,0,128,78,104,0,227,128,
80,56,136,125,113,22,137,125,60,0,130,65,0,0,8,44,0,0,96,57,
8,0,130,65,120,75,43,125,255,255,43,57,64,72,0,124,32,0,129,65,
58,16,0,84,20,2,72,125,0,0,234,128,0,0,7,44,8,0,65,145,
12,0,1,145,24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,
10,4,96,56,32,0,128,78,120,59,227,124,0,0,131,129,20,0,12,128,
120,51,197,124,16,0,65,145,166,3,9,124,20,0,1,145,33,4,128,78,
28,0,1,128,24,0,33,56,166,3,8,124,32,0,128,78,100,0,67,129,
0,0,10,44,0,0,0,56,16,0,130,65,104,0,131,129,80,96,106,125,
112,22,96,125,120,3,3,124,32,0,128,78,166,2,8,124,4,0,1,144,
232,255,33,148,84,0,3,129,0,0,8,44,120,35,128,124,120,43,164,124,
120,51,197,124,24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,
10,4,96,56,32,0,128,78,88,0,227,128,80,56,136,125,113,22,137,125,
60,0,130,65,0,0,8,44,0,0,96,57,8,0,130,65,120,75,43,125,
255,255,43,57,64,72,0,124,32,0,129,65,58,16,0,84,20,2,72,125,
0,0,234,128,0,0,7,44,8,0,65,145,12,0,1,145,24,0,130,64,
28,0,1,128,24,0,33,56,166,3,8,124,10,4,96,56,32,0,128,78,
120,59,227,124,0,0,131,129,28,0,12,128,16,0,65,145,20,0,1,145,
166,3,9,124,33,4,128,78,28,0,1,128,24,0,33,56,166,3,8,124,
32,0,128,78,166,2,8,124,4,0,1,144,232,255,33,148,84,0,3,129,
0,0,8,44,120,35,128,124,120,43,164,124,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,10,4,96,56,32,0,128,78,88,0,227,128,
80,56,136,125,113,22,137,125,60,0,130,65,0,0,8,44,0,0,96,57,
8,0,130,65,120,75,43,125,255,255,43,57,64,72,0,124,32,0,129,65,
58,16,0,84,20,2,72,125,0,0,234,128,0,0,7,44,8,0,65,145,
12,0,1,145,24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,
10,4,96,56,32,0,128,78,120,59,227,124,0,0,131,129,20,0,12,128,
120,51,197,124,16,0,65,145,166,3,9,124,20,0,1,145,33,4,128,78,
28,0,1,128,24,0,33,56,166,3,8,124,32,0,128,78,84,0,67,129,
0,0,10,44,0,0,0,56,16,0,130,65,88,0,131,129,80,96,106,125,
112,22,96,125,120,3,3,124,32,0,128,78,166,2,8,124,4,0,1,144,
232,255,33,148,68,0,35,129,0,0,9,44,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,128,255,96,56,32,0,128,78,72,0,3,128,
80,0,137,125,113,22,139,125,60,0,130,65,0,0,9,44,0,0,64,57,
8,0,130,65,120,91,106,125,255,255,10,57,64,64,4,124,32,0,129,65,
58,16,138,84,20,82,137,125,0,0,12,128,0,0,0,44,8,0,129,145,
12,0,33,145,24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,
128,255,96,56,32,0,128,78,120,3,3,124,0,0,67,129,20,0,10,128,
16,0,129,145,20,0,33,145,166,3,9,124,33,4,128,78,28,0,1,128,
24,0,33,56,166,3,8,124,116,7,99,124,32,0,128,78,68,0,67,129,
0,0,10,44,0,0,0,56,16,0,130,65,72,0,131,129,80,96,106,125,
112,22,96,125,120,3,3,124,32,0,128,78,166,2,8,124,4,0,1,144,
232,255,33,148,52,0,3,129,0,0,8,44,120,35,128,124,120,43,164,124,
24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,10,4,96,56,
32,0,128,78,56,0,227,128,80,56,136,125,113,22,137,125,60,0,130,65,
0,0,8,44,0,0,96,57,8,0,130,65,120,75,43,125,255,255,43,57,
64,72,0,124,32,0,129,65,58,16,0,84,20,2,72,125,0,0,234,128,
0,0,7,44,8,0,65,145,12,0,1,145,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,10,4,96,56,32,0,128,78,120,59,227,124,
0,0,131,129,20,0,12,128,120,51,197,124,16,0,65,145,166,3,9,124,
20,0,1,145,33,4,128,78,28,0,1,128,24,0,33,56,166,3,8,124,
32,0,128,78,52,0,67,129,0,0,10,44,0,0,0,56,16,0,130,65,
56,0,131,129,80,96,106,125,112,22,96,125,120,3,3,124,32,0,128,78,
166,2,8,124,4,0,1,144,232,255,33,148,36,0,35,129,0,0,9,44,
24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,255,0,96,56,
32,0,128,78,40,0,3,128,80,0,137,125,113,22,139,125,60,0,130,65,
0,0,9,44,0,0,64,57,8,0,130,65,120,91,106,125,255,255,10,57,
64,64,4,124,32,0,129,65,58,16,138,84,20,82,137,125,0,0,12,128,
0,0,0,44,8,0,129,145,12,0,33,145,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,255,0,96,56,32,0,128,78,120,3,3,124,
0,0,67,129,44,0,10,128,16,0,129,145,20,0,33,145,166,3,9,124,
33,4,128,78,28,0,1,128,24,0,33,56,166,3,8,124,62,6,99,84,
32,0,128,78,166,2,8,124,4,0,1,144,232,255,33,148,36,0,3,129,
0,0,8,44,120,35,128,124,120,43,164,124,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,0,0,96,56,32,0,128,78,40,0,227,128,
80,56,136,125,113,22,138,125,60,0,130,65,0,0,8,44,0,0,32,57,
8,0,130,65,120,83,73,125,255,255,41,57,64,72,0,124,32,0,129,65,
58,16,0,84,20,2,104,125,0,0,235,128,0,0,7,44,8,0,97,145,
12,0,1,145,24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,
0,0,96,56,32,0,128,78,16,0,97,145,120,59,227,124,0,0,99,129,
36,0,11,128,20,0,1,145,166,3,9,124,33,4,128,78,28,0,1,128,
24,0,33,56,166,3,8,124,62,6,99,84,32,0,128,78,166,2,8,124,
4,0,1,144,232,255,33,148,36,0,3,129,0,0,8,44,120,35,128,124,
120,43,164,124,120,51,197,124,24,0,130,64,28,0,1,128,24,0,33,56,
166,3,8,124,10,4,96,56,32,0,128,78,40,0,227,128,80,56,136,125,
113,22,137,125,60,0,130,65,0,0,8,44,0,0,96,57,8,0,130,65,
120,75,43,125,255,255,43,57,64,72,0,124,32,0,129,65,58,16,0,84,
20,2,72,125,0,0,234,128,0,0,7,44,8,0,65,145,12,0,1,145,
24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,10,4,96,56,
32,0,128,78,120,59,227,124,0,0,131,129,28,0,12,128,16,0,65,145,
20,0,1,145,166,3,9,124,33,4,128,78,28,0,1,128,24,0,33,56,
166,3,8,124,32,0,128,78,36,0,67,129,0,0,10,44,0,0,0,56,
16,0,130,65,40,0,131,129,80,96,106,125,112,22,96,125,120,3,3,124,
32,0,128,78,166,2,8,124,4,0,1,144,232,255,33,148,20,0,3,129,
0,0,8,44,120,35,128,124,120,43,164,124,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,10,4,96,56,32,0,128,78,24,0,227,128,
80,56,136,125,113,22,138,125,60,0,130,65,0,0,8,44,0,0,32,57,
8,0,130,65,120,83,73,125,255,255,41,57,64,72,0,124,32,0,129,65,
58,16,0,84,20,2,104,125,0,0,235,128,0,0,7,44,8,0,97,145,
12,0,1,145,24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,
10,4,96,56,32,0,128,78,16,0,97,145,120,59,227,124,0,0,99,129,
92,0,11,128,20,0,1,145,166,3,9,124,33,4,128,78,28,0,1,128,
24,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
232,255,33,148,20,0,3,129,0,0,8,44,120,35,128,124,120,43,164,124,
24,0,130,64,28,0,1,128,24,0,33,56,166,3,8,124,10,4,96,56,
32,0,128,78,24,0,227,128,80,56,136,125,113,22,138,125,60,0,130,65,
0,0,8,44,0,0,32,57,8,0,130,65,120,83,73,125,255,255,41,57,
64,72,0,124,32,0,129,65,58,16,0,84,20,2,104,125,0,0,235,128,
0,0,7,44,8,0,97,145,12,0,1,145,24,0,130,64,28,0,1,128,
24,0,33,56,166,3,8,124,10,4,96,56,32,0,128,78,16,0,97,145,
120,59,227,124,0,0,99,129,84,0,11,128,20,0,1,145,166,3,9,124,
33,4,128,78,28,0,1,128,24,0,33,56,166,3,8,124,32,0,128,78,
20,0,67,129,0,0,10,44,0,0,0,56,16,0,130,65,24,0,131,129,
80,96,106,125,112,22,96,125,120,3,3,124,32,0,128,78,232,255,33,148,
8,0,129,147,12,0,161,147,166,2,8,124,28,0,1,144,16,0,193,147,
121,27,126,124,20,0,225,147,120,35,159,124,20,9,130,65,4,0,126,128,
0,0,160,59,36,0,0,72,58,16,169,87,46,72,67,125,0,0,10,44,
16,0,130,65,120,83,67,125,9,83,3,72,4,0,126,128,1,0,189,59,
0,0,3,44,0,0,96,57,16,0,130,65,8,0,30,128,80,0,131,125,
112,22,139,125,64,88,29,124,196,255,128,65,20,0,30,129,0,0,160,59,
56,0,0,72,58,16,166,87,46,48,232,124,0,0,7,44,36,0,130,65,
121,59,227,124,28,0,130,65,0,0,35,129,12,0,9,128,3,0,128,56,
166,3,9,124,33,4,128,78,20,0,30,129,1,0,189,59,0,0,8,44,
0,0,0,56,16,0,130,65,24,0,254,128,80,56,168,124,112,22,160,124,
64,0,29,124,176,255,128,65,36,0,94,129,0,0,160,59,56,0,0,72,
58,16,169,87,46,72,10,124,0,0,0,44,36,0,130,65,121,3,3,124,
28,0,130,65,0,0,131,129,12,0,204,128,3,0,128,56,166,3,201,124,
33,4,128,78,36,0,94,129,1,0,189,59,0,0,10,44,0,0,160,56,
16,0,130,65,40,0,62,129,80,72,234,124,112,22,229,124,64,40,29,124,
176,255,128,65,52,0,158,129,0,0,160,59,56,0,0,72,58,16,170,87,
46,80,12,124,0,0,0,44,36,0,130,65,121,3,3,124,28,0,130,65,
0,0,131,129,12,0,172,128,3,0,128,56,166,3,169,124,33,4,128,78,
52,0,158,129,1,0,189,59,0,0,12,44,0,0,224,56,16,0,130,65,
56,0,30,129,80,64,204,124,112,22,199,124,64,56,29,124,176,255,128,65,
68,0,254,128,0,0,160,59,56,0,0,72,58,16,169,87,46,72,71,125,
0,0,10,44,36,0,130,65,121,83,67,125,28,0,130,65,0,0,99,129,
12,0,139,129,3,0,128,56,166,3,137,125,33,4,128,78,68,0,254,128,
1,0,189,59,0,0,7,44,0,0,0,57,16,0,130,65,72,0,190,128,
80,40,7,124,112,22,8,124,64,64,29,124,176,255,128,65,84,0,62,129,
0,0,160,59,56,0,0,72,58,16,166,87,46,48,9,124,0,0,0,44,
36,0,130,65,121,3,3,124,28,0,130,65,0,0,3,129,12,0,40,129,
3,0,128,56,166,3,41,125,33,4,128,78,84,0,62,129,1,0,189,59,
0,0,9,44,0,0,192,56,16,0,130,65,88,0,126,129,80,88,73,125,
112,22,70,125,64,48,29,124,176,255,128,65,100,0,126,129,0,0,160,59,
56,0,0,72,58,16,172,87,46,96,11,124,0,0,0,44,36,0,130,65,
121,3,3,124,28,0,130,65,0,0,163,128,12,0,197,128,3,0,128,56,
166,3,201,124,33,4,128,78,100,0,126,129,1,0,189,59,0,0,11,44,
0,0,192,56,16,0,130,65,104,0,30,128,80,0,235,124,112,22,230,124,
64,48,29,124,176,255,128,65,29,0,160,63,24,49,189,59,4,0,221,128,
0,0,128,59,56,0,0,72,58,16,133,87,46,40,230,124,0,0,7,44,
36,0,130,65,121,59,227,124,28,0,130,65,0,0,3,129,12,0,40,129,
3,0,128,56,166,3,41,125,33,4,128,78,4,0,221,128,1,0,156,59,
0,0,6,44,0,0,32,57,16,0,130,65,8,0,157,129,80,96,70,125,
112,22,73,125,64,72,28,124,176,255,128,65,4,0,158,129,8,0,30,128,
120,3,8,124,64,64,12,124,144,0,130,65,80,0,8,124,112,22,5,124,
59,16,170,84,116,0,130,65,120,99,135,125,80,56,200,124,64,80,6,124,
120,83,64,125,60,0,129,65,1,0,0,40,20,82,231,124,120,3,11,124,
20,82,8,125,8,0,128,64,1,0,96,57,166,3,105,125,255,255,8,140,
255,255,7,156,248,255,0,66,58,16,170,84,20,82,76,125,8,0,94,145,
52,0,0,72,1,0,0,40,255,255,231,56,255,255,8,57,8,0,128,64,
1,0,0,56,166,3,9,124,1,0,40,141,1,0,39,157,248,255,0,66,
58,16,170,84,20,82,76,125,8,0,94,145,20,0,190,128,24,0,30,129,
120,67,9,125,64,72,5,124,148,0,130,65,80,64,105,125,112,22,100,125,
59,16,139,84,120,0,130,65,120,43,166,124,80,48,137,125,64,88,12,124,
120,91,108,125,60,0,129,65,1,0,12,40,20,90,198,124,120,99,136,125,
20,90,41,125,8,0,128,64,1,0,0,57,166,3,9,125,255,255,9,140,
255,255,6,156,248,255,0,66,58,16,136,84,20,66,5,124,24,0,30,144,
56,0,0,72,1,0,12,40,255,255,41,57,120,99,138,125,255,255,198,56,
8,0,128,64,1,0,64,57,166,3,73,125,1,0,233,140,1,0,230,156,
248,255,0,66,58,16,136,84,20,66,5,124,24,0,30,144,36,0,254,128,
40,0,222,128,120,51,203,124,64,88,7,124,148,0,130,65,80,48,43,125,
112,22,38,125,59,16,192,84,120,0,130,65,120,59,233,124,80,72,75,125,
64,0,10,124,120,3,10,124,60,0,129,65,1,0,10,40,20,2,41,125,
20,2,107,125,120,83,64,125,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,139,141,255,255,137,157,248,255,0,66,58,16,197,84,20,42,7,124,
40,0,30,144,56,0,0,72,1,0,10,40,255,255,107,57,120,83,69,125,
255,255,41,57,8,0,128,64,1,0,160,56,166,3,169,124,1,0,11,140,
1,0,9,156,248,255,0,66,58,16,197,84,20,42,7,124,40,0,30,144,
52,0,30,129,56,0,30,128,120,3,11,124,64,88,8,124,144,0,130,65,
80,0,203,124,112,22,201,124,59,16,38,85,116,0,130,65,120,67,10,125,
80,80,235,124,64,48,7,124,120,51,199,124,56,0,129,65,1,0,7,40,
20,50,107,125,20,50,74,125,8,0,128,64,1,0,224,56,166,3,233,124,
255,255,139,141,255,255,138,157,248,255,0,66,58,16,39,85,20,58,168,124,
56,0,190,144,56,0,0,72,1,0,7,40,255,255,107,57,120,59,236,124,
255,255,74,57,8,0,128,64,1,0,128,57,166,3,137,125,1,0,171,140,
1,0,170,156,248,255,0,66,58,16,39,85,20,58,168,124,56,0,190,144,
68,0,94,129,72,0,30,128,120,3,12,124,64,96,10,124,144,0,130,65,
80,0,108,125,112,22,107,125,59,16,104,85,116,0,130,65,120,83,69,125,
80,40,12,124,64,64,0,124,120,67,6,125,60,0,129,65,1,0,6,40,
20,66,165,124,120,51,192,124,20,66,140,125,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,12,141,255,255,5,157,248,255,0,66,58,16,96,85,
20,2,202,124,72,0,222,144,52,0,0,72,1,0,6,40,255,255,165,56,
255,255,140,57,8,0,128,64,1,0,192,56,166,3,201,124,1,0,44,141,
1,0,37,157,248,255,0,66,58,16,96,85,20,2,202,124,72,0,222,144,
84,0,94,129,88,0,30,129,120,67,6,125,64,48,10,124,148,0,130,65,
80,64,102,125,112,22,105,125,59,16,37,85,120,0,130,65,120,83,75,125,
80,88,134,125,64,40,12,124,120,43,160,124,60,0,129,65,1,0,0,40,
20,42,107,125,120,3,8,124,20,42,198,124,8,0,128,64,1,0,0,57,
166,3,9,125,255,255,6,140,255,255,11,156,248,255,0,66,58,16,39,85,
20,58,202,124,88,0,222,144,56,0,0,72,1,0,0,40,255,255,198,56,
120,3,12,124,255,255,107,57,8,0,128,64,1,0,128,57,166,3,137,125,
1,0,166,140,1,0,171,156,248,255,0,66,58,16,39,85,20,58,202,124,
88,0,222,144,100,0,222,128,104,0,190,128,120,43,167,124,64,56,6,124,
148,0,130,65,80,40,7,125,112,22,8,125,59,16,5,85,120,0,130,65,
120,51,201,124,80,72,71,125,64,40,10,124,120,43,172,124,60,0,129,65,
1,0,12,40,20,42,41,125,120,99,128,125,20,42,231,124,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,103,141,255,255,105,157,248,255,0,66,
58,16,0,85,20,2,6,124,104,0,30,144,56,0,0,72,1,0,12,40,
255,255,231,56,120,99,133,125,255,255,41,57,8,0,128,64,1,0,160,56,
166,3,169,124,1,0,135,141,1,0,137,157,248,255,0,66,58,16,0,85,
20,2,6,124,104,0,30,144,4,0,189,128,8,0,93,129,120,83,73,125,
64,72,5,124,148,0,130,65,80,80,201,124,112,22,192,124,59,16,8,84,
120,0,130,65,120,43,172,124,80,96,233,124,64,64,7,124,120,67,7,125,
60,0,129,65,1,0,7,40,20,66,140,125,120,59,235,124,20,66,41,125,
8,0,128,64,1,0,96,57,166,3,105,125,255,255,105,141,255,255,108,157,
248,255,0,66,58,16,9,84,20,74,165,124,8,0,189,144,56,0,0,72,
1,0,7,40,255,255,41,57,120,59,234,124,255,255,140,57,8,0,128,64,
1,0,64,57,166,3,73,125,1,0,201,140,1,0,204,156,248,255,0,66,
58,16,9,84,20,74,165,124,8,0,189,144,100,0,126,129,0,0,11,44,
12,0,130,65,120,91,99,125,17,75,3,72,84,0,62,129,0,0,9,44,
0,0,0,56,108,0,30,144,104,0,30,144,100,0,30,144,12,0,130,65,
120,75,35,125,237,74,3,72,68,0,254,128,0,0,7,44,0,0,64,57,
92,0,94,145,88,0,94,145,84,0,94,145,12,0,130,65,120,59,227,124,
201,74,3,72,52,0,158,129,0,0,12,44,0,0,0,56,76,0,30,144,
72,0,30,144,68,0,30,144,12,0,130,65,120,99,131,125,165,74,3,72,
36,0,94,129,0,0,10,44,0,0,224,56,60,0,254,144,56,0,254,144,
52,0,254,144,12,0,130,65,120,83,67,125,129,74,3,72,20,0,30,129,
0,0,8,44,0,0,64,57,44,0,94,145,40,0,94,145,36,0,94,145,
12,0,130,65,120,67,3,125,93,74,3,72,4,0,126,128,0,0,3,44,
0,0,0,56,28,0,30,144,24,0,30,144,20,0,30,144,8,0,130,65,
61,74,3,72,0,0,192,56,4,0,222,144,255,7,224,87,8,0,222,144,
12,0,222,144,12,0,130,65,120,243,195,127,29,74,3,72,16,0,193,131,
20,0,225,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,20,0,225,147,166,2,8,124,
28,0,1,144,12,0,161,147,121,27,125,124,16,0,193,147,120,35,158,124,
20,0,130,64,116,0,96,56,45,72,3,72,121,27,125,124,92,1,130,65,
0,0,128,56,4,0,157,144,8,0,157,144,12,0,157,144,20,0,157,144,
24,0,157,144,28,0,157,144,32,0,125,56,29,125,0,72,48,0,125,56,
0,0,128,56,173,101,0,72,64,0,125,56,0,0,128,56,61,78,0,72,
80,0,125,56,0,0,128,56,205,54,0,72,96,0,125,56,0,0,128,56,
93,31,0,72,0,0,64,57,112,0,93,177,0,0,158,136,1,0,4,44,
224,0,130,64,4,0,62,137,0,0,9,44,3,0,30,136,2,0,126,137,
46,68,0,84,120,91,31,124,62,4,255,87,180,0,130,65,0,0,31,44,
20,74,222,127,160,0,129,64,0,0,158,136,3,0,4,40,16,0,130,65,
4,0,4,40,36,0,130,65,60,0,0,72,120,235,163,127,120,243,196,127,
121,217,255,75,0,0,3,44,112,0,125,176,60,0,130,65,148,0,0,72,
120,235,163,127,120,243,196,127,181,214,255,75,0,0,3,44,112,0,125,176,
32,0,130,65,120,0,0,72,11,0,96,60,80,107,99,56,185,92,3,72,
10,4,96,56,112,0,125,176,96,0,0,72,4,0,222,136,0,0,6,44,
52,0,130,65,3,0,30,136,2,0,254,136,46,68,0,84,120,59,12,124,
62,4,140,85,20,50,12,125,81,248,232,127,20,50,62,125,20,98,201,127,
104,255,129,65,0,0,31,44,36,0,130,65,7,4,0,56,112,0,29,176,
24,0,0,72,11,0,96,60,120,107,99,56,89,92,3,72,11,4,0,56,
112,0,29,176,20,0,225,131,16,0,193,131,28,0,1,128,120,235,163,127,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,136,255,33,148,
92,0,33,147,96,0,65,147,100,0,97,147,104,0,129,147,108,0,161,147,
112,0,193,147,116,0,225,147,166,2,8,124,124,0,1,144,0,0,166,131,
120,27,124,124,4,0,156,129,0,0,12,44,0,0,196,131,0,0,224,59,
120,43,187,124,0,64,32,61,255,255,41,57,16,0,130,65,12,0,188,128,
80,40,12,124,112,22,31,124,0,0,27,44,136,13,130,65,0,0,12,44,
0,0,224,56,16,0,130,65,8,0,252,128,80,56,204,124,112,22,199,124,
80,72,7,125,64,216,8,124,160,8,128,64,15,0,0,56,48,0,1,144,
0,0,160,56,8,0,161,152,44,0,161,144,28,0,193,59,28,0,161,152,
11,0,96,63,92,105,123,59,255,255,59,57,1,0,233,140,117,7,231,124,
248,255,130,64,48,0,97,129,16,0,11,40,80,72,155,127,120,243,202,127,
8,0,128,65,0,0,94,129,0,80,27,124,12,0,160,63,168,2,128,65,
16,0,11,40,120,243,199,127,8,0,128,65,0,0,254,128,44,0,129,129,
20,98,7,124,0,216,0,124,136,2,129,64,16,0,11,40,120,243,197,127,
8,0,128,65,0,0,190,128,80,216,229,127,64,248,12,124,16,0,128,64,
24,0,97,56,105,60,3,72,44,0,129,129,80,96,255,124,64,56,28,124,
8,0,128,64,120,227,135,127,212,87,189,131,20,58,127,127,64,216,12,124,
120,235,188,127,16,0,128,64,24,0,97,56,57,60,3,72,44,0,129,129,
80,96,27,124,64,224,0,124,8,0,128,64,120,3,28,124,0,0,28,44,
232,0,130,65,48,0,97,129,16,0,11,40,120,243,199,127,8,0,128,65,
0,0,254,128,16,0,11,40,20,218,71,125,120,243,201,127,8,0,128,65,
0,0,62,129,81,0,28,124,20,218,201,124,120,3,9,124,20,226,166,124,
132,0,130,65,80,80,229,124,64,72,7,124,72,0,129,65,1,0,0,40,
20,74,74,125,120,3,6,124,20,74,165,124,8,0,128,64,1,0,192,56,
166,3,201,124,255,255,37,141,255,255,42,157,248,255,0,66,48,0,97,129,
16,0,11,40,44,0,129,129,80,96,92,125,120,243,200,127,76,0,128,65,
68,0,0,72,1,0,0,40,255,255,165,56,120,3,8,124,255,255,74,57,
8,0,128,64,1,0,0,57,166,3,9,125,1,0,5,140,1,0,10,156,
248,255,0,66,48,0,97,129,44,0,129,129,16,0,11,40,80,96,92,125,
120,243,200,127,8,0,128,65,0,0,30,129,0,0,96,57,9,0,97,153,
44,0,65,145,174,81,104,125,44,0,129,129,64,248,12,124,8,0,128,64,
120,99,159,125,0,0,31,44,232,2,130,65,48,0,97,129,16,0,11,40,
120,243,202,127,8,0,128,65,0,0,94,129,16,0,11,40,120,243,201,127,
8,0,128,65,0,0,62,129,80,96,31,124,121,3,8,124,120,67,5,125,
20,250,233,124,132,0,130,65,80,80,199,124,64,40,6,124,68,0,129,65,
1,0,8,40,20,42,231,124,20,42,74,125,8,0,128,64,1,0,0,57,
166,3,9,125,255,255,39,141,255,255,42,157,248,255,0,66,48,0,97,129,
16,0,11,40,44,0,129,129,120,243,197,127,80,96,31,124,76,0,128,65,
68,0,0,72,1,0,8,40,255,255,231,56,120,67,0,125,255,255,74,57,
8,0,128,64,1,0,0,56,166,3,9,124,1,0,7,140,1,0,10,156,
248,255,0,66,44,0,129,129,48,0,97,129,80,96,31,124,16,0,11,40,
120,243,197,127,8,0,128,65,0,0,190,128,0,0,96,57,10,0,97,153,
44,0,1,144,174,1,101,125,44,0,97,131,128,134,2,57,52,0,1,145,
120,235,168,127,64,216,8,124,14,0,97,153,64,0,129,59,12,0,32,61,
84,30,41,57,56,0,33,145,64,0,97,153,15,0,0,56,80,0,97,145,
60,0,225,59,84,0,1,144,20,2,128,65,20,2,0,72,254,255,224,56,
64,56,28,124,16,0,129,64,24,0,97,56,217,59,3,72,48,0,97,129,
64,224,11,124,232,0,128,64,44,0,65,131,254,255,32,57,15,0,153,99,
64,72,25,124,32,0,129,64,120,227,153,127,1,0,121,56,233,66,3,72,
0,0,26,44,120,27,127,124,72,0,130,64,100,0,0,72,171,170,128,61,
171,170,140,57,22,200,76,125,126,248,105,85,126,248,74,85,64,72,10,124,
20,0,128,64,254,255,9,32,64,0,11,124,8,0,129,65,20,74,43,127,
1,0,121,56,165,66,3,72,0,0,26,44,120,27,127,124,36,0,130,65,
48,0,161,128,16,0,5,40,120,251,227,127,120,243,196,127,8,0,128,65,
0,0,158,128,120,211,69,127,165,118,3,72,48,0,1,128,16,0,0,40,
12,0,128,65,0,0,126,128,9,68,3,72,16,0,25,40,48,0,33,147,
120,243,202,127,0,0,254,147,0,0,128,57,44,0,129,145,21,0,129,153,
8,0,128,65,120,251,234,127,0,0,28,44,0,0,96,57,12,0,97,153,
44,0,65,147,174,209,106,125,56,0,130,65,128,0,0,72,0,0,28,44,
36,0,130,64,16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,
0,0,192,56,11,0,193,152,44,0,193,144,0,0,197,152,0,0,28,44,
80,0,130,64,44,0,97,131,212,87,189,131,128,134,2,57,52,0,1,145,
120,235,168,127,64,216,8,124,0,0,160,56,14,0,161,152,64,0,129,59,
12,0,32,61,84,30,41,57,56,0,33,145,64,0,161,152,15,0,0,56,
80,0,161,144,60,0,225,59,84,0,1,144,148,0,128,65,148,0,0,72,
48,0,1,129,16,0,8,40,120,243,195,127,8,0,128,65,0,0,126,128,
120,219,100,127,120,227,133,127,181,117,3,72,48,0,1,128,16,0,0,40,
120,243,199,127,8,0,128,65,0,0,254,128,0,0,96,57,13,0,97,153,
44,0,129,147,174,225,103,125,212,87,189,131,44,0,97,131,128,134,2,57,
52,0,1,145,120,235,168,127,64,216,8,124,0,0,160,56,14,0,161,152,
64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,64,0,161,152,
15,0,0,56,80,0,161,144,60,0,225,59,84,0,1,144,8,0,128,64,
120,67,27,125,24,0,1,56,64,0,31,124,52,1,130,64,20,0,255,128,
64,216,7,124,16,0,128,64,120,251,227,127,217,55,3,72,20,0,255,128,
80,56,27,124,64,232,0,124,8,0,128,64,120,3,29,124,0,0,29,44,
140,2,130,65,24,0,223,128,16,0,6,40,120,227,138,127,8,0,128,65,
0,0,92,129,16,0,6,40,20,218,42,125,120,227,136,127,8,0,128,65,
0,0,28,129,81,0,29,124,20,218,168,124,120,3,8,124,20,234,165,124,
128,0,130,65,80,72,197,124,64,64,6,124,68,0,129,65,1,0,0,40,
20,66,165,124,20,66,41,125,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,229,140,255,255,233,156,248,255,0,66,24,0,223,128,16,0,6,40,
20,0,255,128,80,56,61,125,120,227,134,127,76,0,128,65,68,0,0,72,
1,0,0,40,255,255,165,56,120,3,6,124,255,255,41,57,8,0,128,64,
1,0,192,56,166,3,201,124,1,0,5,140,1,0,9,156,248,255,0,66,
24,0,223,128,20,0,255,128,16,0,6,40,80,56,61,125,120,227,134,127,
8,0,128,65,0,0,220,128,0,0,96,57,15,0,97,153,20,0,63,145,
174,73,102,125,12,0,128,61,216,87,140,129,0,0,12,44,12,0,0,61,
52,0,161,59,116,30,8,57,56,0,1,145,192,1,130,65,172,1,0,72,
254,255,192,56,64,48,27,124,12,0,129,64,120,251,227,127,141,56,3,72,
24,0,223,128,64,216,6,124,232,0,128,64,20,0,63,131,254,255,0,57,
15,0,122,99,64,64,26,124,32,0,129,64,120,219,122,127,1,0,122,56,
157,63,3,72,0,0,25,44,120,27,125,124,104,0,130,65,68,0,0,72,
171,170,128,61,171,170,140,57,22,208,76,125,126,248,200,84,126,248,74,85,
64,64,10,124,20,0,128,64,254,255,8,32,64,0,6,124,8,0,129,65,
20,66,70,127,1,0,122,56,89,63,3,72,0,0,25,44,120,27,125,124,
36,0,130,65,24,0,63,129,16,0,9,40,120,235,163,127,120,227,132,127,
8,0,128,65,0,0,156,128,120,203,37,127,89,115,3,72,24,0,223,128,
16,0,6,40,12,0,128,65,0,0,124,128,189,64,3,72,16,0,26,40,
120,227,135,127,0,0,128,57,22,0,129,153,20,0,159,145,0,0,188,147,
24,0,95,147,8,0,128,65,120,235,167,127,0,0,27,44,0,0,96,57,
17,0,97,153,20,0,63,147,174,201,103,125,56,0,130,64,136,0,0,72,
0,0,27,44,36,0,130,64,16,0,6,40,120,227,135,127,8,0,128,65,
0,0,252,128,0,0,160,56,16,0,161,152,20,0,191,144,0,0,167,152,
0,0,27,44,88,0,130,65,24,0,255,128,16,0,7,40,120,227,131,127,
8,0,128,65,0,0,124,128,48,0,33,129,16,0,9,40,120,243,196,127,
8,0,128,65,0,0,158,128,120,219,101,127,165,114,3,72,24,0,95,129,
16,0,10,40,120,227,133,127,8,0,128,65,0,0,188,128,0,0,96,57,
18,0,97,153,20,0,127,147,174,217,101,125,12,0,128,61,216,87,140,129,
0,0,12,44,12,0,0,61,52,0,161,59,116,30,8,57,56,0,1,145,
20,0,130,65,120,235,163,127,166,3,137,125,33,4,128,78,56,0,1,129,
28,0,8,128,120,235,163,127,166,3,9,124,33,4,128,78,120,235,163,127,
157,48,3,72,24,0,63,129,16,0,9,40,12,0,128,65,0,0,124,128,
157,63,3,72,0,0,0,56,19,0,1,152,20,0,31,144,15,0,64,57,
24,0,95,145,0,0,28,152,48,0,1,128,16,0,0,40,12,0,128,65,
0,0,126,128,113,63,3,72,0,0,224,56,20,0,225,152,44,0,225,144,
15,0,192,56,48,0,193,144,0,0,254,152,112,0,193,131,104,0,129,131,
100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,
92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,0,0,12,44,
0,0,192,56,16,0,130,65,8,0,28,128,80,0,76,125,112,22,70,125,
20,218,166,124,64,40,31,124,88,2,128,64,126,248,232,87,80,72,200,124,
64,248,6,124,0,0,0,56,8,0,128,65,20,66,31,124,0,0,12,44,
120,3,31,124,0,0,64,57,16,0,130,65,8,0,28,128,80,0,236,124,
112,22,234,124,20,218,170,124,64,40,31,124,32,0,128,64,0,0,12,44,
0,0,160,56,16,0,130,65,8,0,252,128,80,56,204,124,112,22,197,124,
20,218,229,127,64,72,31,124,68,0,129,64,252,135,13,129,0,0,8,44,
48,0,130,64,1,0,32,57,252,135,45,145,11,0,64,61,56,105,74,57,
244,135,77,145,12,0,0,61,148,30,8,57,248,135,13,145,12,0,96,60,
180,30,99,56,9,56,3,72,244,135,109,56,81,47,3,72,58,16,255,87,
120,251,227,127,181,60,3,72,4,0,60,129,120,27,122,124,80,240,9,124,
59,0,0,84,120,3,8,124,120,211,69,127,120,0,130,65,120,43,166,124,
80,48,73,125,64,64,10,124,120,67,10,125,64,0,129,65,1,0,10,40,
20,66,198,124,20,66,41,125,120,83,72,125,8,0,128,64,1,0,0,57,
166,3,9,125,255,255,233,140,255,255,230,156,248,255,0,66,20,2,5,125,
121,219,101,127,252,255,72,57,60,0,130,64,68,0,0,72,1,0,10,40,
255,255,198,56,255,255,41,57,8,0,128,64,1,0,64,57,166,3,73,125,
1,0,9,141,1,0,6,157,248,255,0,66,20,2,5,125,121,219,101,127,
252,255,72,57,16,0,130,65,255,255,165,52,4,0,170,151,248,255,130,64,
8,0,28,128,80,0,190,124,59,0,167,84,58,16,96,87,20,2,72,125,
112,0,130,65,80,80,222,124,64,56,6,124,120,59,224,124,60,0,129,65,
1,0,0,40,20,58,222,127,20,58,74,125,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,30,141,255,255,10,157,248,255,0,66,4,0,156,129,
0,0,12,44,0,0,160,56,72,0,130,65,56,0,0,72,1,0,0,40,
255,255,74,57,255,255,222,59,8,0,128,64,1,0,0,56,166,3,9,124,
1,0,62,141,1,0,42,157,248,255,0,66,4,0,156,129,0,0,12,44,
0,0,160,56,16,0,130,65,8,0,188,128,80,40,12,124,112,22,5,124,
4,0,124,128,0,0,3,44,20,42,123,127,8,0,130,65,249,60,3,72,
20,250,218,124,12,0,220,144,58,16,103,87,20,58,26,125,8,0,28,145,
4,0,92,147,112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,
116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,
120,0,33,56,32,0,128,78,8,0,188,128,80,40,30,124,112,22,6,124,
64,216,6,124,58,16,108,87,220,0,128,64,59,0,0,84,20,98,30,125,
120,243,202,127,140,0,130,65,80,64,42,125,64,0,9,124,120,3,5,124,
72,0,129,65,1,0,5,40,20,2,8,125,20,2,74,125,120,43,160,124,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,10,140,255,255,8,156,
248,255,0,66,8,0,188,128,80,40,30,124,112,22,6,124,81,216,70,125,
252,255,37,57,84,0,130,65,68,0,0,72,1,0,5,40,255,255,74,57,
120,43,169,124,255,255,8,57,8,0,128,64,1,0,32,57,166,3,41,125,
1,0,170,140,1,0,168,156,248,255,0,66,8,0,188,128,80,40,30,124,
112,22,6,124,81,216,70,125,252,255,37,57,16,0,130,65,255,255,74,53,
4,0,169,151,248,255,130,64,20,98,165,124,80,40,236,124,64,56,30,124,
8,0,188,144,116,1,130,65,0,0,190,147,4,0,222,59,64,56,30,124,
244,255,130,64,96,1,0,72,120,43,164,124,80,32,44,125,80,32,9,125,
59,0,0,85,120,3,8,124,120,75,38,125,144,0,130,65,120,43,171,124,
80,88,70,125,64,64,10,124,120,67,7,125,84,0,129,65,1,0,7,40,
20,66,107,125,120,59,234,124,20,66,198,124,8,0,128,64,1,0,64,57,
166,3,73,125,255,255,230,140,255,255,235,156,248,255,0,66,20,2,229,124,
8,0,252,144,80,72,62,125,112,22,32,125,58,16,10,84,59,16,0,84,
80,32,234,124,120,243,200,127,196,0,130,65,80,0,0,72,1,0,7,40,
255,255,198,56,120,59,232,124,255,255,107,57,8,0,128,64,1,0,0,57,
166,3,9,125,1,0,70,141,1,0,75,157,248,255,0,66,20,2,229,124,
8,0,252,144,80,72,62,125,112,22,32,125,58,16,10,84,59,16,0,84,
80,32,234,124,120,243,200,127,116,0,130,65,80,56,168,124,64,0,5,124,
120,3,6,124,64,0,129,65,1,0,6,40,20,2,231,124,20,2,8,125,
120,51,192,124,8,0,128,64,1,0,0,56,166,3,9,124,255,255,200,140,
255,255,199,156,248,255,0,66,120,243,198,127,20,98,254,124,64,56,6,124,
76,0,130,65,56,0,0,72,1,0,6,40,255,255,231,56,255,255,8,57,
8,0,128,64,1,0,192,56,166,3,201,124,1,0,200,140,1,0,199,156,
248,255,0,66,120,243,198,127,20,98,254,124,64,56,6,124,20,0,130,65,
0,0,166,147,4,0,198,56,64,56,6,124,244,255,130,64,112,0,193,131,
104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,
96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,
240,255,33,148,166,2,8,124,20,0,1,144,8,0,193,147,121,27,126,124,
12,0,225,147,120,35,159,124,52,0,130,65,4,0,126,128,0,0,3,44,
8,0,130,65,13,58,3,72,0,0,128,57,4,0,158,145,255,7,235,87,
8,0,158,145,12,0,158,145,12,0,130,65,120,243,195,127,237,57,3,72,
20,0,1,128,12,0,225,131,8,0,193,131,166,3,8,124,16,0,33,56,
32,0,128,78,0,0,3,44,32,0,130,77,255,7,128,84,32,0,130,77,
192,57,3,72,168,42,3,72,164,42,3,72,232,255,33,148,12,0,161,147,
166,2,8,124,28,0,1,144,16,0,193,147,121,27,126,124,20,0,225,147,
120,35,159,124,104,0,130,65,32,0,30,129,16,0,8,40,12,0,190,59,
40,0,128,64,15,0,32,57,32,0,62,145,0,0,64,57,28,0,94,145,
255,7,231,87,8,0,65,153,12,0,94,153,56,0,130,65,44,0,0,72,
12,0,126,128,89,57,3,72,15,0,32,57,32,0,62,145,0,0,64,57,
28,0,94,145,255,7,231,87,8,0,65,153,12,0,94,153,12,0,130,65,
120,243,195,127,49,57,3,72,20,0,225,131,28,0,1,128,16,0,193,131,
12,0,161,131,166,3,8,124,24,0,33,56,32,0,128,78,252,41,3,72,
32,0,3,128,16,0,0,40,12,0,128,65,12,0,99,128,32,0,128,78,
12,0,99,56,32,0,128,78,232,255,33,148,12,0,161,147,166,2,8,124,
28,0,1,144,16,0,193,147,121,27,126,124,20,0,225,147,120,35,159,124,
104,0,130,65,32,0,30,129,16,0,8,40,12,0,190,59,40,0,128,64,
15,0,32,57,32,0,62,145,0,0,64,57,28,0,94,145,255,7,231,87,
8,0,65,153,12,0,94,153,56,0,130,65,44,0,0,72,12,0,126,128,
149,56,3,72,15,0,32,57,32,0,62,145,0,0,64,57,28,0,94,145,
255,7,231,87,8,0,65,153,12,0,94,153,12,0,130,65,120,243,195,127,
109,56,3,72,20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,
166,3,8,124,24,0,33,56,32,0,128,78,32,0,128,78,0,0,99,128,
32,0,128,78,0,0,3,44,32,0,130,77,255,7,128,84,32,0,130,77,
48,56,3,72,136,255,33,148,92,0,33,147,96,0,65,147,100,0,97,147,
104,0,129,147,108,0,161,147,112,0,193,147,116,0,225,147,166,2,8,124,
124,0,1,144,0,0,166,131,120,27,124,124,4,0,156,129,0,0,12,44,
0,0,196,131,0,0,224,59,120,43,187,124,0,64,32,61,255,255,41,57,
16,0,130,65,12,0,188,128,80,40,12,124,112,22,31,124,0,0,27,44,
136,13,130,65,0,0,12,44,0,0,224,56,16,0,130,65,8,0,252,128,
80,56,204,124,112,22,199,124,80,72,7,125,64,216,8,124,160,8,128,64,
15,0,0,56,48,0,1,144,0,0,160,56,8,0,161,152,44,0,161,144,
28,0,193,59,28,0,161,152,11,0,96,63,128,105,123,59,255,255,59,57,
1,0,233,140,117,7,231,124,248,255,130,64,48,0,97,129,16,0,11,40,
80,72,155,127,120,243,202,127,8,0,128,65,0,0,94,129,0,80,27,124,
12,0,160,63,168,2,128,65,16,0,11,40,120,243,199,127,8,0,128,65,
0,0,254,128,44,0,129,129,20,98,7,124,0,216,0,124,136,2,129,64,
16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,80,216,229,127,
64,248,12,124,16,0,128,64,24,0,97,56,73,44,3,72,44,0,129,129,
80,96,255,124,64,56,28,124,8,0,128,64,120,227,135,127,212,87,189,131,
20,58,127,127,64,216,12,124,120,235,188,127,16,0,128,64,24,0,97,56,
25,44,3,72,44,0,129,129,80,96,27,124,64,224,0,124,8,0,128,64,
120,3,28,124,0,0,28,44,232,0,130,65,48,0,97,129,16,0,11,40,
120,243,199,127,8,0,128,65,0,0,254,128,16,0,11,40,20,218,71,125,
120,243,201,127,8,0,128,65,0,0,62,129,81,0,28,124,20,218,201,124,
120,3,9,124,20,226,166,124,132,0,130,65,80,80,229,124,64,72,7,124,
72,0,129,65,1,0,0,40,20,74,74,125,120,3,6,124,20,74,165,124,
8,0,128,64,1,0,192,56,166,3,201,124,255,255,37,141,255,255,42,157,
248,255,0,66,48,0,97,129,16,0,11,40,44,0,129,129,80,96,92,125,
120,243,200,127,76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,
120,3,8,124,255,255,74,57,8,0,128,64,1,0,0,57,166,3,9,125,
1,0,5,140,1,0,10,156,248,255,0,66,48,0,97,129,44,0,129,129,
16,0,11,40,80,96,92,125,120,243,200,127,8,0,128,65,0,0,30,129,
0,0,96,57,9,0,97,153,44,0,65,145,174,81,104,125,44,0,129,129,
64,248,12,124,8,0,128,64,120,99,159,125,0,0,31,44,232,2,130,65,
48,0,97,129,16,0,11,40,120,243,202,127,8,0,128,65,0,0,94,129,
16,0,11,40,120,243,201,127,8,0,128,65,0,0,62,129,80,96,31,124,
121,3,8,124,120,67,5,125,20,250,233,124,132,0,130,65,80,80,199,124,
64,40,6,124,68,0,129,65,1,0,8,40,20,42,231,124,20,42,74,125,
8,0,128,64,1,0,0,57,166,3,9,125,255,255,39,141,255,255,42,157,
248,255,0,66,48,0,97,129,16,0,11,40,44,0,129,129,120,243,197,127,
80,96,31,124,76,0,128,65,68,0,0,72,1,0,8,40,255,255,231,56,
120,67,0,125,255,255,74,57,8,0,128,64,1,0,0,56,166,3,9,124,
1,0,7,140,1,0,10,156,248,255,0,66,44,0,129,129,48,0,97,129,
80,96,31,124,16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,
0,0,96,57,10,0,97,153,44,0,1,144,174,1,101,125,44,0,97,131,
136,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,14,0,97,153,
64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,64,0,97,153,
15,0,0,56,80,0,97,145,60,0,225,59,84,0,1,144,20,2,128,65,
20,2,0,72,254,255,224,56,64,56,28,124,16,0,129,64,24,0,97,56,
185,43,3,72,48,0,97,129,64,224,11,124,232,0,128,64,44,0,65,131,
254,255,32,57,15,0,153,99,64,72,25,124,32,0,129,64,120,227,153,127,
1,0,121,56,201,50,3,72,0,0,26,44,120,27,127,124,72,0,130,64,
100,0,0,72,171,170,128,61,171,170,140,57,22,200,76,125,126,248,105,85,
126,248,74,85,64,72,10,124,20,0,128,64,254,255,9,32,64,0,11,124,
8,0,129,65,20,74,43,127,1,0,121,56,133,50,3,72,0,0,26,44,
120,27,127,124,36,0,130,65,48,0,161,128,16,0,5,40,120,251,227,127,
120,243,196,127,8,0,128,65,0,0,158,128,120,211,69,127,133,102,3,72,
48,0,1,128,16,0,0,40,12,0,128,65,0,0,126,128,233,51,3,72,
16,0,25,40,48,0,33,147,120,243,202,127,0,0,254,147,0,0,128,57,
44,0,129,145,21,0,129,153,8,0,128,65,120,251,234,127,0,0,28,44,
0,0,96,57,12,0,97,153,44,0,65,147,174,209,106,125,56,0,130,65,
128,0,0,72,0,0,28,44,36,0,130,64,16,0,11,40,120,243,197,127,
8,0,128,65,0,0,190,128,0,0,192,56,11,0,193,152,44,0,193,144,
0,0,197,152,0,0,28,44,80,0,130,64,44,0,97,131,212,87,189,131,
136,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,0,0,160,56,
14,0,161,152,64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,
64,0,161,152,15,0,0,56,80,0,161,144,60,0,225,59,84,0,1,144,
148,0,128,65,148,0,0,72,48,0,1,129,16,0,8,40,120,243,195,127,
8,0,128,65,0,0,126,128,120,219,100,127,120,227,133,127,149,101,3,72,
48,0,1,128,16,0,0,40,120,243,199,127,8,0,128,65,0,0,254,128,
0,0,96,57,13,0,97,153,44,0,129,147,174,225,103,125,212,87,189,131,
44,0,97,131,136,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,
0,0,160,56,14,0,161,152,64,0,129,59,12,0,32,61,84,30,41,57,
56,0,33,145,64,0,161,152,15,0,0,56,80,0,161,144,60,0,225,59,
84,0,1,144,8,0,128,64,120,67,27,125,24,0,1,56,64,0,31,124,
52,1,130,64,20,0,255,128,64,216,7,124,16,0,128,64,120,251,227,127,
185,39,3,72,20,0,255,128,80,56,27,124,64,232,0,124,8,0,128,64,
120,3,29,124,0,0,29,44,140,2,130,65,24,0,223,128,16,0,6,40,
120,227,138,127,8,0,128,65,0,0,92,129,16,0,6,40,20,218,42,125,
120,227,136,127,8,0,128,65,0,0,28,129,81,0,29,124,20,218,168,124,
120,3,8,124,20,234,165,124,128,0,130,65,80,72,197,124,64,64,6,124,
68,0,129,65,1,0,0,40,20,66,165,124,20,66,41,125,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,229,140,255,255,233,156,248,255,0,66,
24,0,223,128,16,0,6,40,20,0,255,128,80,56,61,125,120,227,134,127,
76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,120,3,6,124,
255,255,41,57,8,0,128,64,1,0,192,56,166,3,201,124,1,0,5,140,
1,0,9,156,248,255,0,66,24,0,223,128,20,0,255,128,16,0,6,40,
80,56,61,125,120,227,134,127,8,0,128,65,0,0,220,128,0,0,96,57,
15,0,97,153,20,0,63,145,174,73,102,125,12,0,128,61,216,87,140,129,
0,0,12,44,12,0,0,61,52,0,161,59,116,30,8,57,56,0,1,145,
192,1,130,65,172,1,0,72,254,255,192,56,64,48,27,124,12,0,129,64,
120,251,227,127,109,40,3,72,24,0,223,128,64,216,6,124,232,0,128,64,
20,0,63,131,254,255,0,57,15,0,122,99,64,64,26,124,32,0,129,64,
120,219,122,127,1,0,122,56,125,47,3,72,0,0,25,44,120,27,125,124,
104,0,130,65,68,0,0,72,171,170,128,61,171,170,140,57,22,208,76,125,
126,248,200,84,126,248,74,85,64,64,10,124,20,0,128,64,254,255,8,32,
64,0,6,124,8,0,129,65,20,66,70,127,1,0,122,56,57,47,3,72,
0,0,25,44,120,27,125,124,36,0,130,65,24,0,63,129,16,0,9,40,
120,235,163,127,120,227,132,127,8,0,128,65,0,0,156,128,120,203,37,127,
57,99,3,72,24,0,223,128,16,0,6,40,12,0,128,65,0,0,124,128,
157,48,3,72,16,0,26,40,120,227,135,127,0,0,128,57,22,0,129,153,
20,0,159,145,0,0,188,147,24,0,95,147,8,0,128,65,120,235,167,127,
0,0,27,44,0,0,96,57,17,0,97,153,20,0,63,147,174,201,103,125,
56,0,130,64,136,0,0,72,0,0,27,44,36,0,130,64,16,0,6,40,
120,227,135,127,8,0,128,65,0,0,252,128,0,0,160,56,16,0,161,152,
20,0,191,144,0,0,167,152,0,0,27,44,88,0,130,65,24,0,255,128,
16,0,7,40,120,227,131,127,8,0,128,65,0,0,124,128,48,0,33,129,
16,0,9,40,120,243,196,127,8,0,128,65,0,0,158,128,120,219,101,127,
133,98,3,72,24,0,95,129,16,0,10,40,120,227,133,127,8,0,128,65,
0,0,188,128,0,0,96,57,18,0,97,153,20,0,127,147,174,217,101,125,
12,0,128,61,216,87,140,129,0,0,12,44,12,0,0,61,52,0,161,59,
116,30,8,57,56,0,1,145,20,0,130,65,120,235,163,127,166,3,137,125,
33,4,128,78,56,0,1,129,28,0,8,128,120,235,163,127,166,3,9,124,
33,4,128,78,120,235,163,127,125,32,3,72,24,0,63,129,16,0,9,40,
12,0,128,65,0,0,124,128,125,47,3,72,0,0,0,56,19,0,1,152,
20,0,31,144,15,0,64,57,24,0,95,145,0,0,28,152,48,0,1,128,
16,0,0,40,12,0,128,65,0,0,126,128,81,47,3,72,0,0,224,56,
20,0,225,152,44,0,225,144,15,0,192,56,48,0,193,144,0,0,254,152,
112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,
124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,
32,0,128,78,0,0,12,44,0,0,192,56,16,0,130,65,8,0,28,128,
80,0,76,125,112,22,70,125,20,218,166,124,64,40,31,124,88,2,128,64,
126,248,232,87,80,72,200,124,64,248,6,124,0,0,0,56,8,0,128,65,
20,66,31,124,0,0,12,44,120,3,31,124,0,0,64,57,16,0,130,65,
8,0,28,128,80,0,236,124,112,22,234,124,20,218,170,124,64,40,31,124,
32,0,128,64,0,0,12,44,0,0,160,56,16,0,130,65,8,0,252,128,
80,56,204,124,112,22,197,124,20,218,229,127,64,72,31,124,68,0,129,64,
80,136,13,129,0,0,8,44,48,0,130,64,1,0,32,57,80,136,45,145,
11,0,64,61,112,105,74,57,72,136,77,145,12,0,0,61,148,30,8,57,
76,136,13,145,12,0,96,60,192,30,99,56,233,39,3,72,72,136,109,56,
49,31,3,72,58,16,255,87,120,251,227,127,149,44,3,72,4,0,60,129,
120,27,122,124,80,240,9,124,59,0,0,84,120,3,8,124,120,211,69,127,
120,0,130,65,120,43,166,124,80,48,73,125,64,64,10,124,120,67,10,125,
64,0,129,65,1,0,10,40,20,66,198,124,20,66,41,125,120,83,72,125,
8,0,128,64,1,0,0,57,166,3,9,125,255,255,233,140,255,255,230,156,
248,255,0,66,20,2,5,125,121,219,101,127,252,255,72,57,60,0,130,64,
68,0,0,72,1,0,10,40,255,255,198,56,255,255,41,57,8,0,128,64,
1,0,64,57,166,3,73,125,1,0,9,141,1,0,6,157,248,255,0,66,
20,2,5,125,121,219,101,127,252,255,72,57,16,0,130,65,255,255,165,52,
4,0,170,151,248,255,130,64,8,0,28,128,80,0,190,124,59,0,167,84,
58,16,96,87,20,2,72,125,112,0,130,65,80,80,222,124,64,56,6,124,
120,59,224,124,60,0,129,65,1,0,0,40,20,58,222,127,20,58,74,125,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,30,141,255,255,10,157,
248,255,0,66,4,0,156,129,0,0,12,44,0,0,160,56,72,0,130,65,
56,0,0,72,1,0,0,40,255,255,74,57,255,255,222,59,8,0,128,64,
1,0,0,56,166,3,9,124,1,0,62,141,1,0,42,157,248,255,0,66,
4,0,156,129,0,0,12,44,0,0,160,56,16,0,130,65,8,0,188,128,
80,40,12,124,112,22,5,124,4,0,124,128,0,0,3,44,20,42,123,127,
8,0,130,65,217,44,3,72,20,250,218,124,12,0,220,144,58,16,103,87,
20,58,26,125,8,0,28,145,4,0,92,147,112,0,193,131,104,0,129,131,
100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,
92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,8,0,188,128,
80,40,30,124,112,22,6,124,64,216,6,124,58,16,108,87,220,0,128,64,
59,0,0,84,20,98,30,125,120,243,202,127,140,0,130,65,80,64,42,125,
64,0,9,124,120,3,5,124,72,0,129,65,1,0,5,40,20,2,8,125,
20,2,74,125,120,43,160,124,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,10,140,255,255,8,156,248,255,0,66,8,0,188,128,80,40,30,124,
112,22,6,124,81,216,70,125,252,255,37,57,84,0,130,65,68,0,0,72,
1,0,5,40,255,255,74,57,120,43,169,124,255,255,8,57,8,0,128,64,
1,0,32,57,166,3,41,125,1,0,170,140,1,0,168,156,248,255,0,66,
8,0,188,128,80,40,30,124,112,22,6,124,81,216,70,125,252,255,37,57,
16,0,130,65,255,255,74,53,4,0,169,151,248,255,130,64,20,98,165,124,
80,40,236,124,64,56,30,124,8,0,188,144,116,1,130,65,0,0,190,147,
4,0,222,59,64,56,30,124,244,255,130,64,96,1,0,72,120,43,164,124,
80,32,44,125,80,32,9,125,59,0,0,85,120,3,8,124,120,75,38,125,
144,0,130,65,120,43,171,124,80,88,70,125,64,64,10,124,120,67,7,125,
84,0,129,65,1,0,7,40,20,66,107,125,120,59,234,124,20,66,198,124,
8,0,128,64,1,0,64,57,166,3,73,125,255,255,230,140,255,255,235,156,
248,255,0,66,20,2,229,124,8,0,252,144,80,72,62,125,112,22,32,125,
58,16,10,84,59,16,0,84,80,32,234,124,120,243,200,127,196,0,130,65,
80,0,0,72,1,0,7,40,255,255,198,56,120,59,232,124,255,255,107,57,
8,0,128,64,1,0,0,57,166,3,9,125,1,0,70,141,1,0,75,157,
248,255,0,66,20,2,229,124,8,0,252,144,80,72,62,125,112,22,32,125,
58,16,10,84,59,16,0,84,80,32,234,124,120,243,200,127,116,0,130,65,
80,56,168,124,64,0,5,124,120,3,6,124,64,0,129,65,1,0,6,40,
20,2,231,124,20,2,8,125,120,51,192,124,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,200,140,255,255,199,156,248,255,0,66,120,243,198,127,
20,98,254,124,64,56,6,124,76,0,130,65,56,0,0,72,1,0,6,40,
255,255,231,56,255,255,8,57,8,0,128,64,1,0,192,56,166,3,201,124,
1,0,200,140,1,0,199,156,248,255,0,66,120,243,198,127,20,98,254,124,
64,56,6,124,20,0,130,65,0,0,166,147,4,0,198,56,64,56,6,124,
244,255,130,64,112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,
116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,
120,0,33,56,32,0,128,78,136,255,33,148,116,0,225,147,121,35,159,124,
92,0,33,147,96,0,65,147,100,0,97,147,104,0,129,147,108,0,161,147,
166,2,8,124,124,0,1,144,112,0,193,147,120,27,126,124,0,0,64,57,
4,0,94,145,12,0,94,145,8,0,94,145,52,0,130,64,112,0,193,131,
100,0,97,131,104,0,129,131,116,0,225,131,108,0,161,131,96,0,65,131,
124,0,1,128,92,0,33,131,0,0,96,56,166,3,8,124,120,0,33,56,
32,0,128,78,255,63,0,60,255,255,0,96,64,0,31,124,132,8,129,64,
15,0,224,56,48,0,225,144,0,0,0,56,8,0,1,152,44,0,1,144,
28,0,193,59,28,0,1,152,11,0,128,63,148,105,156,59,255,255,92,57,
1,0,234,140,117,7,231,124,248,255,130,64,48,0,1,129,16,0,8,40,
80,80,124,127,120,243,192,127,8,0,128,65,0,0,30,128,0,0,28,124,
12,0,160,63,172,2,128,65,16,0,8,40,120,243,197,127,8,0,128,65,
0,0,190,128,44,0,65,129,20,82,5,124,0,224,0,124,140,2,129,64,
16,0,8,40,120,243,198,127,8,0,128,65,0,0,222,128,80,224,230,127,
64,248,10,124,16,0,128,64,24,0,97,56,57,30,3,72,44,0,65,129,
80,80,223,124,64,48,27,124,8,0,128,64,120,219,102,127,212,87,125,131,
20,50,159,127,64,224,10,124,120,219,125,127,16,0,128,64,24,0,97,56,
9,30,3,72,44,0,65,129,80,80,28,124,64,232,0,124,8,0,128,64,
120,3,29,124,0,0,29,44,232,0,130,65,48,0,1,129,16,0,8,40,
120,243,199,127,8,0,128,65,0,0,254,128,16,0,8,40,20,226,199,124,
120,243,201,127,8,0,128,65,0,0,62,129,81,0,29,124,20,226,233,124,
120,3,9,124,20,234,231,124,132,0,130,65,80,48,7,125,64,72,8,124,
72,0,129,65,1,0,0,40,20,74,198,124,20,74,231,124,120,3,9,124,
8,0,128,64,1,0,32,57,166,3,41,125,255,255,167,140,255,255,166,156,
248,255,0,66,48,0,1,129,16,0,8,40,44,0,65,129,80,80,29,124,
120,243,201,127,76,0,128,65,68,0,0,72,1,0,0,40,255,255,231,56,
120,3,5,124,255,255,198,56,8,0,128,64,1,0,160,56,166,3,169,124,
1,0,7,140,1,0,6,156,248,255,0,66,48,0,1,129,44,0,65,129,
16,0,8,40,80,80,29,124,120,243,201,127,8,0,128,65,0,0,62,129,
0,0,96,57,9,0,97,153,44,0,1,144,174,1,105,125,44,0,65,129,
64,248,10,124,8,0,128,64,120,83,95,125,0,0,31,44,236,2,130,65,
48,0,1,129,16,0,8,40,120,243,201,127,8,0,128,65,0,0,62,129,
16,0,8,40,120,243,199,127,8,0,128,65,0,0,254,128,80,80,31,124,
121,3,10,124,120,83,76,125,20,250,167,124,136,0,130,65,80,72,197,124,
64,96,6,124,72,0,129,65,1,0,10,40,20,98,41,125,120,83,64,125,
20,98,165,124,8,0,128,64,1,0,0,56,166,3,9,124,255,255,5,140,
255,255,9,156,248,255,0,66,48,0,1,129,16,0,8,40,44,0,65,129,
80,80,31,124,120,243,202,127,76,0,128,65,68,0,0,72,1,0,10,40,
255,255,165,56,120,83,71,125,255,255,41,57,8,0,128,64,1,0,224,56,
166,3,233,124,1,0,5,141,1,0,9,157,248,255,0,66,44,0,65,129,
48,0,1,129,80,80,31,124,16,0,8,40,120,243,202,127,8,0,128,65,
0,0,94,129,0,0,32,57,10,0,33,153,44,0,1,144,174,1,42,125,
44,0,65,131,120,219,96,127,64,208,0,124,14,0,33,153,64,0,129,59,
144,134,162,56,52,0,161,144,12,0,192,60,84,30,198,56,56,0,193,144,
15,0,0,57,80,0,33,145,60,0,161,59,64,0,33,153,84,0,1,145,
20,2,128,65,20,2,0,72,254,255,0,56,64,0,27,124,16,0,129,64,
24,0,97,56,165,29,3,72,48,0,1,129,64,216,8,124,232,0,128,64,
44,0,65,131,254,255,0,56,15,0,121,99,64,0,25,124,32,0,129,64,
120,219,121,127,1,0,121,56,181,36,3,72,0,0,26,44,120,27,127,124,
72,0,130,64,100,0,0,72,171,170,128,61,171,170,140,57,22,200,204,124,
126,248,0,85,126,248,198,84,64,0,6,124,20,0,128,64,254,255,224,32,
64,56,8,124,8,0,129,65,20,2,40,127,1,0,121,56,113,36,3,72,
0,0,26,44,120,27,127,124,36,0,130,65,48,0,161,128,16,0,5,40,
120,251,227,127,120,243,196,127,8,0,128,65,0,0,158,128,120,211,69,127,
113,88,3,72,48,0,193,128,16,0,6,40,12,0,128,65,0,0,126,128,
213,37,3,72,16,0,25,40,48,0,33,147,120,243,202,127,0,0,254,147,
0,0,128,57,44,0,129,145,21,0,129,153,8,0,128,65,120,251,234,127,
0,0,27,44,0,0,96,57,12,0,97,153,44,0,65,147,174,209,106,125,
56,0,130,65,128,0,0,72,0,0,27,44,36,0,130,64,16,0,8,40,
120,243,199,127,8,0,128,65,0,0,254,128,0,0,0,56,11,0,1,152,
44,0,1,144,0,0,7,152,0,0,27,44,80,0,130,64,44,0,65,131,
212,87,125,131,120,219,96,127,64,208,0,124,0,0,32,57,14,0,33,153,
64,0,129,59,144,134,162,56,52,0,161,144,12,0,192,60,84,30,198,56,
15,0,0,57,80,0,33,145,60,0,161,59,64,0,33,153,84,0,1,145,
56,0,193,144,148,0,128,65,148,0,0,72,48,0,225,128,16,0,7,40,
120,243,195,127,8,0,128,65,0,0,126,128,120,227,132,127,120,219,101,127,
129,87,3,72,48,0,1,129,16,0,8,40,120,243,199,127,8,0,128,65,
0,0,254,128,0,0,96,57,13,0,97,153,44,0,97,147,174,217,103,125,
212,87,125,131,44,0,65,131,120,219,96,127,64,208,0,124,0,0,32,57,
14,0,33,153,64,0,129,59,144,134,162,56,52,0,161,144,12,0,192,60,
84,30,198,56,56,0,193,144,15,0,0,57,80,0,33,145,60,0,161,59,
64,0,33,153,84,0,1,145,8,0,128,64,120,3,26,124,24,0,1,56,
64,0,29,124,56,1,130,64,20,0,221,128,64,208,6,124,16,0,128,64,
120,235,163,127,165,25,3,72,20,0,221,128,80,48,90,125,64,216,10,124,
8,0,128,64,120,83,91,125,0,0,27,44,144,2,130,65,24,0,253,128,
16,0,7,40,120,227,137,127,8,0,128,65,0,0,60,129,16,0,7,40,
20,210,41,125,120,227,133,127,8,0,128,65,0,0,188,128,81,80,27,124,
120,3,12,124,20,210,165,124,20,218,69,125,132,0,130,65,80,72,10,125,
64,96,8,124,72,0,129,65,1,0,0,40,20,98,41,125,120,3,8,124,
20,98,74,125,8,0,128,64,1,0,0,57,166,3,9,125,255,255,10,140,
255,255,9,156,248,255,0,66,24,0,253,128,16,0,7,40,20,0,221,128,
80,48,219,124,120,227,136,127,76,0,128,65,68,0,0,72,1,0,0,40,
255,255,74,57,120,3,6,124,255,255,41,57,8,0,128,64,1,0,192,56,
166,3,201,124,1,0,234,140,1,0,233,156,248,255,0,66,24,0,253,128,
20,0,221,128,16,0,7,40,80,48,219,124,120,227,136,127,8,0,128,65,
0,0,28,129,0,0,96,57,15,0,97,153,20,0,221,144,174,49,104,125,
12,0,128,61,216,87,140,129,0,0,12,44,12,0,160,60,52,0,225,59,
116,30,165,56,56,0,161,144,192,1,130,65,172,1,0,72,254,255,0,57,
64,64,26,124,12,0,129,64,120,235,163,127,85,26,3,72,24,0,253,128,
64,208,7,124,232,0,128,64,20,0,125,131,254,255,0,56,15,0,89,99,
64,0,25,124,32,0,129,64,120,211,89,127,1,0,121,56,101,33,3,72,
0,0,27,44,120,27,127,124,104,0,130,65,68,0,0,72,171,170,128,61,
171,170,140,57,22,200,12,124,126,248,232,84,126,248,0,84,64,64,0,124,
20,0,128,64,254,255,8,32,64,0,7,124,8,0,129,65,20,66,39,127,
1,0,121,56,33,33,3,72,0,0,27,44,120,27,127,124,36,0,130,65,
24,0,221,128,16,0,6,40,120,251,227,127,120,227,132,127,8,0,128,65,
0,0,156,128,120,219,101,127,33,85,3,72,24,0,29,129,16,0,8,40,
12,0,128,65,0,0,124,128,133,34,3,72,16,0,25,40,120,227,138,127,
0,0,128,57,22,0,129,153,20,0,157,145,0,0,252,147,24,0,61,147,
8,0,128,65,120,251,234,127,0,0,26,44,0,0,96,57,17,0,97,153,
20,0,125,147,174,217,106,125,56,0,130,64,136,0,0,72,0,0,26,44,
36,0,130,64,16,0,7,40,120,227,138,127,8,0,128,65,0,0,92,129,
0,0,160,56,16,0,161,152,20,0,189,144,0,0,170,152,0,0,26,44,
88,0,130,65,24,0,29,129,16,0,8,40,120,227,131,127,8,0,128,65,
0,0,124,128,48,0,1,128,16,0,0,40,120,243,196,127,8,0,128,65,
0,0,158,128,120,211,69,127,109,84,3,72,24,0,221,128,16,0,6,40,
120,227,134,127,8,0,128,65,0,0,220,128,0,0,96,57,18,0,97,153,
20,0,93,147,174,209,102,125,12,0,128,61,216,87,140,129,0,0,12,44,
12,0,160,60,52,0,225,59,116,30,165,56,56,0,161,144,20,0,130,65,
120,251,227,127,166,3,137,125,33,4,128,78,56,0,161,128,28,0,5,128,
120,251,227,127,166,3,9,124,33,4,128,78,120,251,227,127,101,18,3,72,
24,0,29,128,16,0,0,40,12,0,128,65,0,0,124,128,101,33,3,72,
0,0,0,56,19,0,1,152,20,0,29,144,15,0,64,57,24,0,93,145,
0,0,28,152,48,0,1,129,16,0,8,40,12,0,128,65,0,0,126,128,
57,33,3,72,0,0,0,56,20,0,1,152,44,0,1,144,15,0,32,57,
48,0,33,145,0,0,30,152,1,0,96,56,36,0,0,72,58,16,227,87,
109,31,3,72,58,16,233,87,20,74,67,125,12,0,94,145,4,0,126,144,
8,0,126,144,1,0,96,56,112,0,193,131,104,0,129,131,100,0,97,131,
108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,
166,3,8,124,120,0,33,56,32,0,128,78,136,255,33,148,92,0,33,147,
96,0,65,147,100,0,97,147,104,0,129,147,108,0,161,147,112,0,193,147,
116,0,225,147,166,2,8,124,124,0,1,144,0,0,166,131,120,27,124,124,
4,0,156,129,0,0,12,44,0,0,196,131,0,0,224,59,120,43,187,124,
0,64,32,61,255,255,41,57,16,0,130,65,12,0,188,128,80,40,12,124,
112,22,31,124,0,0,27,44,136,13,130,65,0,0,12,44,0,0,224,56,
16,0,130,65,8,0,252,128,80,56,204,124,112,22,199,124,80,72,7,125,
64,216,8,124,160,8,128,64,15,0,0,56,48,0,1,144,0,0,160,56,
8,0,161,152,44,0,161,144,28,0,193,59,28,0,161,152,11,0,96,63,
184,105,123,59,255,255,59,57,1,0,233,140,117,7,231,124,248,255,130,64,
48,0,97,129,16,0,11,40,80,72,155,127,120,243,202,127,8,0,128,65,
0,0,94,129,0,80,27,124,12,0,160,63,168,2,128,65,16,0,11,40,
120,243,199,127,8,0,128,65,0,0,254,128,44,0,129,129,20,98,7,124,
0,216,0,124,136,2,129,64,16,0,11,40,120,243,197,127,8,0,128,65,
0,0,190,128,80,216,229,127,64,248,12,124,16,0,128,64,24,0,97,56,
229,20,3,72,44,0,129,129,80,96,255,124,64,56,28,124,8,0,128,64,
120,227,135,127,212,87,189,131,20,58,127,127,64,216,12,124,120,235,188,127,
16,0,128,64,24,0,97,56,181,20,3,72,44,0,129,129,80,96,27,124,
64,224,0,124,8,0,128,64,120,3,28,124,0,0,28,44,232,0,130,65,
48,0,97,129,16,0,11,40,120,243,199,127,8,0,128,65,0,0,254,128,
16,0,11,40,20,218,71,125,120,243,201,127,8,0,128,65,0,0,62,129,
81,0,28,124,20,218,201,124,120,3,9,124,20,226,166,124,132,0,130,65,
80,80,229,124,64,72,7,124,72,0,129,65,1,0,0,40,20,74,74,125,
120,3,6,124,20,74,165,124,8,0,128,64,1,0,192,56,166,3,201,124,
255,255,37,141,255,255,42,157,248,255,0,66,48,0,97,129,16,0,11,40,
44,0,129,129,80,96,92,125,120,243,200,127,76,0,128,65,68,0,0,72,
1,0,0,40,255,255,165,56,120,3,8,124,255,255,74,57,8,0,128,64,
1,0,0,57,166,3,9,125,1,0,5,140,1,0,10,156,248,255,0,66,
48,0,97,129,44,0,129,129,16,0,11,40,80,96,92,125,120,243,200,127,
8,0,128,65,0,0,30,129,0,0,96,57,9,0,97,153,44,0,65,145,
174,81,104,125,44,0,129,129,64,248,12,124,8,0,128,64,120,99,159,125,
0,0,31,44,232,2,130,65,48,0,97,129,16,0,11,40,120,243,202,127,
8,0,128,65,0,0,94,129,16,0,11,40,120,243,201,127,8,0,128,65,
0,0,62,129,80,96,31,124,121,3,8,124,120,67,5,125,20,250,233,124,
132,0,130,65,80,80,199,124,64,40,6,124,68,0,129,65,1,0,8,40,
20,42,231,124,20,42,74,125,8,0,128,64,1,0,0,57,166,3,9,125,
255,255,39,141,255,255,42,157,248,255,0,66,48,0,97,129,16,0,11,40,
44,0,129,129,120,243,197,127,80,96,31,124,76,0,128,65,68,0,0,72,
1,0,8,40,255,255,231,56,120,67,0,125,255,255,74,57,8,0,128,64,
1,0,0,56,166,3,9,124,1,0,7,140,1,0,10,156,248,255,0,66,
44,0,129,129,48,0,97,129,80,96,31,124,16,0,11,40,120,243,197,127,
8,0,128,65,0,0,190,128,0,0,96,57,10,0,97,153,44,0,1,144,
174,1,101,125,44,0,97,131,152,134,2,57,52,0,1,145,120,235,168,127,
64,216,8,124,14,0,97,153,64,0,129,59,12,0,32,61,84,30,41,57,
56,0,33,145,64,0,97,153,15,0,0,56,80,0,97,145,60,0,225,59,
84,0,1,144,20,2,128,65,20,2,0,72,254,255,224,56,64,56,28,124,
16,0,129,64,24,0,97,56,85,20,3,72,48,0,97,129,64,224,11,124,
232,0,128,64,44,0,65,131,254,255,32,57,15,0,153,99,64,72,25,124,
32,0,129,64,120,227,153,127,1,0,121,56,101,27,3,72,0,0,26,44,
120,27,127,124,72,0,130,64,100,0,0,72,171,170,128,61,171,170,140,57,
22,200,76,125,126,248,105,85,126,248,74,85,64,72,10,124,20,0,128,64,
254,255,9,32,64,0,11,124,8,0,129,65,20,74,43,127,1,0,121,56,
33,27,3,72,0,0,26,44,120,27,127,124,36,0,130,65,48,0,161,128,
16,0,5,40,120,251,227,127,120,243,196,127,8,0,128,65,0,0,158,128,
120,211,69,127,33,79,3,72,48,0,1,128,16,0,0,40,12,0,128,65,
0,0,126,128,133,28,3,72,16,0,25,40,48,0,33,147,120,243,202,127,
0,0,254,147,0,0,128,57,44,0,129,145,21,0,129,153,8,0,128,65,
120,251,234,127,0,0,28,44,0,0,96,57,12,0,97,153,44,0,65,147,
174,209,106,125,56,0,130,65,128,0,0,72,0,0,28,44,36,0,130,64,
16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,0,0,192,56,
11,0,193,152,44,0,193,144,0,0,197,152,0,0,28,44,80,0,130,64,
44,0,97,131,212,87,189,131,152,134,2,57,52,0,1,145,120,235,168,127,
64,216,8,124,0,0,160,56,14,0,161,152,64,0,129,59,12,0,32,61,
84,30,41,57,56,0,33,145,64,0,161,152,15,0,0,56,80,0,161,144,
60,0,225,59,84,0,1,144,148,0,128,65,148,0,0,72,48,0,1,129,
16,0,8,40,120,243,195,127,8,0,128,65,0,0,126,128,120,219,100,127,
120,227,133,127,49,78,3,72,48,0,1,128,16,0,0,40,120,243,199,127,
8,0,128,65,0,0,254,128,0,0,96,57,13,0,97,153,44,0,129,147,
174,225,103,125,212,87,189,131,44,0,97,131,152,134,2,57,52,0,1,145,
120,235,168,127,64,216,8,124,0,0,160,56,14,0,161,152,64,0,129,59,
12,0,32,61,84,30,41,57,56,0,33,145,64,0,161,152,15,0,0,56,
80,0,161,144,60,0,225,59,84,0,1,144,8,0,128,64,120,67,27,125,
24,0,1,56,64,0,31,124,52,1,130,64,20,0,255,128,64,216,7,124,
16,0,128,64,120,251,227,127,85,16,3,72,20,0,255,128,80,56,27,124,
64,232,0,124,8,0,128,64,120,3,29,124,0,0,29,44,140,2,130,65,
24,0,223,128,16,0,6,40,120,227,138,127,8,0,128,65,0,0,92,129,
16,0,6,40,20,218,42,125,120,227,136,127,8,0,128,65,0,0,28,129,
81,0,29,124,20,218,168,124,120,3,8,124,20,234,165,124,128,0,130,65,
80,72,197,124,64,64,6,124,68,0,129,65,1,0,0,40,20,66,165,124,
20,66,41,125,8,0,128,64,1,0,0,56,166,3,9,124,255,255,229,140,
255,255,233,156,248,255,0,66,24,0,223,128,16,0,6,40,20,0,255,128,
80,56,61,125,120,227,134,127,76,0,128,65,68,0,0,72,1,0,0,40,
255,255,165,56,120,3,6,124,255,255,41,57,8,0,128,64,1,0,192,56,
166,3,201,124,1,0,5,140,1,0,9,156,248,255,0,66,24,0,223,128,
20,0,255,128,16,0,6,40,80,56,61,125,120,227,134,127,8,0,128,65,
0,0,220,128,0,0,96,57,15,0,97,153,20,0,63,145,174,73,102,125,
12,0,128,61,216,87,140,129,0,0,12,44,12,0,0,61,52,0,161,59,
116,30,8,57,56,0,1,145,192,1,130,65,172,1,0,72,254,255,192,56,
64,48,27,124,12,0,129,64,120,251,227,127,9,17,3,72,24,0,223,128,
64,216,6,124,232,0,128,64,20,0,63,131,254,255,0,57,15,0,122,99,
64,64,26,124,32,0,129,64,120,219,122,127,1,0,122,56,25,24,3,72,
0,0,25,44,120,27,125,124,104,0,130,65,68,0,0,72,171,170,128,61,
171,170,140,57,22,208,76,125,126,248,200,84,126,248,74,85,64,64,10,124,
20,0,128,64,254,255,8,32,64,0,6,124,8,0,129,65,20,66,70,127,
1,0,122,56,213,23,3,72,0,0,25,44,120,27,125,124,36,0,130,65,
24,0,63,129,16,0,9,40,120,235,163,127,120,227,132,127,8,0,128,65,
0,0,156,128,120,203,37,127,213,75,3,72,24,0,223,128,16,0,6,40,
12,0,128,65,0,0,124,128,57,25,3,72,16,0,26,40,120,227,135,127,
0,0,128,57,22,0,129,153,20,0,159,145,0,0,188,147,24,0,95,147,
8,0,128,65,120,235,167,127,0,0,27,44,0,0,96,57,17,0,97,153,
20,0,63,147,174,201,103,125,56,0,130,64,136,0,0,72,0,0,27,44,
36,0,130,64,16,0,6,40,120,227,135,127,8,0,128,65,0,0,252,128,
0,0,160,56,16,0,161,152,20,0,191,144,0,0,167,152,0,0,27,44,
88,0,130,65,24,0,255,128,16,0,7,40,120,227,131,127,8,0,128,65,
0,0,124,128,48,0,33,129,16,0,9,40,120,243,196,127,8,0,128,65,
0,0,158,128,120,219,101,127,33,75,3,72,24,0,95,129,16,0,10,40,
120,227,133,127,8,0,128,65,0,0,188,128,0,0,96,57,18,0,97,153,
20,0,127,147,174,217,101,125,12,0,128,61,216,87,140,129,0,0,12,44,
12,0,0,61,52,0,161,59,116,30,8,57,56,0,1,145,20,0,130,65,
120,235,163,127,166,3,137,125,33,4,128,78,56,0,1,129,28,0,8,128,
120,235,163,127,166,3,9,124,33,4,128,78,120,235,163,127,25,9,3,72,
24,0,63,129,16,0,9,40,12,0,128,65,0,0,124,128,25,24,3,72,
0,0,0,56,19,0,1,152,20,0,31,144,15,0,64,57,24,0,95,145,
0,0,28,152,48,0,1,128,16,0,0,40,12,0,128,65,0,0,126,128,
237,23,3,72,0,0,224,56,20,0,225,152,44,0,225,144,15,0,192,56,
48,0,193,144,0,0,254,152,112,0,193,131,104,0,129,131,100,0,97,131,
108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,
166,3,8,124,120,0,33,56,32,0,128,78,0,0,12,44,0,0,192,56,
16,0,130,65,8,0,28,128,80,0,76,125,112,22,70,125,20,218,166,124,
64,40,31,124,88,2,128,64,126,248,232,87,80,72,200,124,64,248,6,124,
0,0,0,56,8,0,128,65,20,66,31,124,0,0,12,44,120,3,31,124,
0,0,64,57,16,0,130,65,8,0,28,128,80,0,236,124,112,22,234,124,
20,218,170,124,64,40,31,124,32,0,128,64,0,0,12,44,0,0,160,56,
16,0,130,65,8,0,252,128,80,56,204,124,112,22,197,124,20,218,229,127,
64,72,31,124,68,0,129,64,68,136,13,129,0,0,8,44,48,0,130,64,
1,0,32,57,68,136,45,145,11,0,64,61,168,105,74,57,60,136,77,145,
12,0,0,61,148,30,8,57,64,136,13,145,12,0,96,60,204,30,99,56,
133,16,3,72,60,136,109,56,205,7,3,72,58,16,255,87,120,251,227,127,
49,21,3,72,4,0,60,129,120,27,122,124,80,240,9,124,59,0,0,84,
120,3,8,124,120,211,69,127,120,0,130,65,120,43,166,124,80,48,73,125,
64,64,10,124,120,67,10,125,64,0,129,65,1,0,10,40,20,66,198,124,
20,66,41,125,120,83,72,125,8,0,128,64,1,0,0,57,166,3,9,125,
255,255,233,140,255,255,230,156,248,255,0,66,20,2,5,125,121,219,101,127,
252,255,72,57,60,0,130,64,68,0,0,72,1,0,10,40,255,255,198,56,
255,255,41,57,8,0,128,64,1,0,64,57,166,3,73,125,1,0,9,141,
1,0,6,157,248,255,0,66,20,2,5,125,121,219,101,127,252,255,72,57,
16,0,130,65,255,255,165,52,4,0,170,151,248,255,130,64,8,0,28,128,
80,0,190,124,59,0,167,84,58,16,96,87,20,2,72,125,112,0,130,65,
80,80,222,124,64,56,6,124,120,59,224,124,60,0,129,65,1,0,0,40,
20,58,222,127,20,58,74,125,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,30,141,255,255,10,157,248,255,0,66,4,0,156,129,0,0,12,44,
0,0,160,56,72,0,130,65,56,0,0,72,1,0,0,40,255,255,74,57,
255,255,222,59,8,0,128,64,1,0,0,56,166,3,9,124,1,0,62,141,
1,0,42,157,248,255,0,66,4,0,156,129,0,0,12,44,0,0,160,56,
16,0,130,65,8,0,188,128,80,40,12,124,112,22,5,124,4,0,124,128,
0,0,3,44,20,42,123,127,8,0,130,65,117,21,3,72,20,250,218,124,
12,0,220,144,58,16,103,87,20,58,26,125,8,0,28,145,4,0,92,147,
112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,
124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,
32,0,128,78,8,0,188,128,80,40,30,124,112,22,6,124,64,216,6,124,
58,16,108,87,220,0,128,64,59,0,0,84,20,98,30,125,120,243,202,127,
140,0,130,65,80,64,42,125,64,0,9,124,120,3,5,124,72,0,129,65,
1,0,5,40,20,2,8,125,20,2,74,125,120,43,160,124,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,10,140,255,255,8,156,248,255,0,66,
8,0,188,128,80,40,30,124,112,22,6,124,81,216,70,125,252,255,37,57,
84,0,130,65,68,0,0,72,1,0,5,40,255,255,74,57,120,43,169,124,
255,255,8,57,8,0,128,64,1,0,32,57,166,3,41,125,1,0,170,140,
1,0,168,156,248,255,0,66,8,0,188,128,80,40,30,124,112,22,6,124,
81,216,70,125,252,255,37,57,16,0,130,65,255,255,74,53,4,0,169,151,
248,255,130,64,20,98,165,124,80,40,236,124,64,56,30,124,8,0,188,144,
116,1,130,65,0,0,190,147,4,0,222,59,64,56,30,124,244,255,130,64,
96,1,0,72,120,43,164,124,80,32,44,125,80,32,9,125,59,0,0,85,
120,3,8,124,120,75,38,125,144,0,130,65,120,43,171,124,80,88,70,125,
64,64,10,124,120,67,7,125,84,0,129,65,1,0,7,40,20,66,107,125,
120,59,234,124,20,66,198,124,8,0,128,64,1,0,64,57,166,3,73,125,
255,255,230,140,255,255,235,156,248,255,0,66,20,2,229,124,8,0,252,144,
80,72,62,125,112,22,32,125,58,16,10,84,59,16,0,84,80,32,234,124,
120,243,200,127,196,0,130,65,80,0,0,72,1,0,7,40,255,255,198,56,
120,59,232,124,255,255,107,57,8,0,128,64,1,0,0,57,166,3,9,125,
1,0,70,141,1,0,75,157,248,255,0,66,20,2,229,124,8,0,252,144,
80,72,62,125,112,22,32,125,58,16,10,84,59,16,0,84,80,32,234,124,
120,243,200,127,116,0,130,65,80,56,168,124,64,0,5,124,120,3,6,124,
64,0,129,65,1,0,6,40,20,2,231,124,20,2,8,125,120,51,192,124,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,200,140,255,255,199,156,
248,255,0,66,120,243,198,127,20,98,254,124,64,56,6,124,76,0,130,65,
56,0,0,72,1,0,6,40,255,255,231,56,255,255,8,57,8,0,128,64,
1,0,192,56,166,3,201,124,1,0,200,140,1,0,199,156,248,255,0,66,
120,243,198,127,20,98,254,124,64,56,6,124,20,0,130,65,0,0,166,147,
4,0,198,56,64,56,6,124,244,255,130,64,112,0,193,131,104,0,129,131,
100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,
92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,136,255,33,148,
116,0,225,147,121,35,159,124,92,0,33,147,96,0,65,147,100,0,97,147,
104,0,129,147,108,0,161,147,166,2,8,124,124,0,1,144,112,0,193,147,
120,27,126,124,0,0,64,57,4,0,94,145,12,0,94,145,8,0,94,145,
52,0,130,64,112,0,193,131,100,0,97,131,104,0,129,131,116,0,225,131,
108,0,161,131,96,0,65,131,124,0,1,128,92,0,33,131,0,0,96,56,
166,3,8,124,120,0,33,56,32,0,128,78,255,63,0,60,255,255,0,96,
64,0,31,124,132,8,129,64,15,0,224,56,48,0,225,144,0,0,0,56,
8,0,1,152,44,0,1,144,28,0,193,59,28,0,1,152,11,0,128,63,
204,105,156,59,255,255,92,57,1,0,234,140,117,7,231,124,248,255,130,64,
48,0,1,129,16,0,8,40,80,80,124,127,120,243,192,127,8,0,128,65,
0,0,30,128,0,0,28,124,12,0,160,63,172,2,128,65,16,0,8,40,
120,243,197,127,8,0,128,65,0,0,190,128,44,0,65,129,20,82,5,124,
0,224,0,124,140,2,129,64,16,0,8,40,120,243,198,127,8,0,128,65,
0,0,222,128,80,224,230,127,64,248,10,124,16,0,128,64,24,0,97,56,
213,6,3,72,44,0,65,129,80,80,223,124,64,48,27,124,8,0,128,64,
120,219,102,127,212,87,125,131,20,50,159,127,64,224,10,124,120,219,125,127,
16,0,128,64,24,0,97,56,165,6,3,72,44,0,65,129,80,80,28,124,
64,232,0,124,8,0,128,64,120,3,29,124,0,0,29,44,232,0,130,65,
48,0,1,129,16,0,8,40,120,243,199,127,8,0,128,65,0,0,254,128,
16,0,8,40,20,226,199,124,120,243,201,127,8,0,128,65,0,0,62,129,
81,0,29,124,20,226,233,124,120,3,9,124,20,234,231,124,132,0,130,65,
80,48,7,125,64,72,8,124,72,0,129,65,1,0,0,40,20,74,198,124,
20,74,231,124,120,3,9,124,8,0,128,64,1,0,32,57,166,3,41,125,
255,255,167,140,255,255,166,156,248,255,0,66,48,0,1,129,16,0,8,40,
44,0,65,129,80,80,29,124,120,243,201,127,76,0,128,65,68,0,0,72,
1,0,0,40,255,255,231,56,120,3,5,124,255,255,198,56,8,0,128,64,
1,0,160,56,166,3,169,124,1,0,7,140,1,0,6,156,248,255,0,66,
48,0,1,129,44,0,65,129,16,0,8,40,80,80,29,124,120,243,201,127,
8,0,128,65,0,0,62,129,0,0,96,57,9,0,97,153,44,0,1,144,
174,1,105,125,44,0,65,129,64,248,10,124,8,0,128,64,120,83,95,125,
0,0,31,44,236,2,130,65,48,0,1,129,16,0,8,40,120,243,201,127,
8,0,128,65,0,0,62,129,16,0,8,40,120,243,199,127,8,0,128,65,
0,0,254,128,80,80,31,124,121,3,10,124,120,83,76,125,20,250,167,124,
136,0,130,65,80,72,197,124,64,96,6,124,72,0,129,65,1,0,10,40,
20,98,41,125,120,83,64,125,20,98,165,124,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,5,140,255,255,9,156,248,255,0,66,48,0,1,129,
16,0,8,40,44,0,65,129,80,80,31,124,120,243,202,127,76,0,128,65,
68,0,0,72,1,0,10,40,255,255,165,56,120,83,71,125,255,255,41,57,
8,0,128,64,1,0,224,56,166,3,233,124,1,0,5,141,1,0,9,157,
248,255,0,66,44,0,65,129,48,0,1,129,80,80,31,124,16,0,8,40,
120,243,202,127,8,0,128,65,0,0,94,129,0,0,32,57,10,0,33,153,
44,0,1,144,174,1,42,125,44,0,65,131,120,219,96,127,64,208,0,124,
14,0,33,153,64,0,129,59,160,134,162,56,52,0,161,144,12,0,192,60,
84,30,198,56,56,0,193,144,15,0,0,57,80,0,33,145,60,0,161,59,
64,0,33,153,84,0,1,145,20,2,128,65,20,2,0,72,254,255,0,56,
64,0,27,124,16,0,129,64,24,0,97,56,65,6,3,72,48,0,1,129,
64,216,8,124,232,0,128,64,44,0,65,131,254,255,0,56,15,0,121,99,
64,0,25,124,32,0,129,64,120,219,121,127,1,0,121,56,81,13,3,72,
0,0,26,44,120,27,127,124,72,0,130,64,100,0,0,72,171,170,128,61,
171,170,140,57,22,200,204,124,126,248,0,85,126,248,198,84,64,0,6,124,
20,0,128,64,254,255,224,32,64,56,8,124,8,0,129,65,20,2,40,127,
1,0,121,56,13,13,3,72,0,0,26,44,120,27,127,124,36,0,130,65,
48,0,161,128,16,0,5,40,120,251,227,127,120,243,196,127,8,0,128,65,
0,0,158,128,120,211,69,127,13,65,3,72,48,0,193,128,16,0,6,40,
12,0,128,65,0,0,126,128,113,14,3,72,16,0,25,40,48,0,33,147,
120,243,202,127,0,0,254,147,0,0,128,57,44,0,129,145,21,0,129,153,
8,0,128,65,120,251,234,127,0,0,27,44,0,0,96,57,12,0,97,153,
44,0,65,147,174,209,106,125,56,0,130,65,128,0,0,72,0,0,27,44,
36,0,130,64,16,0,8,40,120,243,199,127,8,0,128,65,0,0,254,128,
0,0,0,56,11,0,1,152,44,0,1,144,0,0,7,152,0,0,27,44,
80,0,130,64,44,0,65,131,212,87,125,131,120,219,96,127,64,208,0,124,
0,0,32,57,14,0,33,153,64,0,129,59,160,134,162,56,52,0,161,144,
12,0,192,60,84,30,198,56,15,0,0,57,80,0,33,145,60,0,161,59,
64,0,33,153,84,0,1,145,56,0,193,144,148,0,128,65,148,0,0,72,
48,0,225,128,16,0,7,40,120,243,195,127,8,0,128,65,0,0,126,128,
120,227,132,127,120,219,101,127,29,64,3,72,48,0,1,129,16,0,8,40,
120,243,199,127,8,0,128,65,0,0,254,128,0,0,96,57,13,0,97,153,
44,0,97,147,174,217,103,125,212,87,125,131,44,0,65,131,120,219,96,127,
64,208,0,124,0,0,32,57,14,0,33,153,64,0,129,59,160,134,162,56,
52,0,161,144,12,0,192,60,84,30,198,56,56,0,193,144,15,0,0,57,
80,0,33,145,60,0,161,59,64,0,33,153,84,0,1,145,8,0,128,64,
120,3,26,124,24,0,1,56,64,0,29,124,56,1,130,64,20,0,221,128,
64,208,6,124,16,0,128,64,120,235,163,127,65,2,3,72,20,0,221,128,
80,48,90,125,64,216,10,124,8,0,128,64,120,83,91,125,0,0,27,44,
144,2,130,65,24,0,253,128,16,0,7,40,120,227,137,127,8,0,128,65,
0,0,60,129,16,0,7,40,20,210,41,125,120,227,133,127,8,0,128,65,
0,0,188,128,81,80,27,124,120,3,12,124,20,210,165,124,20,218,69,125,
132,0,130,65,80,72,10,125,64,96,8,124,72,0,129,65,1,0,0,40,
20,98,41,125,120,3,8,124,20,98,74,125,8,0,128,64,1,0,0,57,
166,3,9,125,255,255,10,140,255,255,9,156,248,255,0,66,24,0,253,128,
16,0,7,40,20,0,221,128,80,48,219,124,120,227,136,127,76,0,128,65,
68,0,0,72,1,0,0,40,255,255,74,57,120,3,6,124,255,255,41,57,
8,0,128,64,1,0,192,56,166,3,201,124,1,0,234,140,1,0,233,156,
248,255,0,66,24,0,253,128,20,0,221,128,16,0,7,40,80,48,219,124,
120,227,136,127,8,0,128,65,0,0,28,129,0,0,96,57,15,0,97,153,
20,0,221,144,174,49,104,125,12,0,128,61,216,87,140,129,0,0,12,44,
12,0,160,60,52,0,225,59,116,30,165,56,56,0,161,144,192,1,130,65,
172,1,0,72,254,255,0,57,64,64,26,124,12,0,129,64,120,235,163,127,
241,2,3,72,24,0,253,128,64,208,7,124,232,0,128,64,20,0,125,131,
254,255,0,56,15,0,89,99,64,0,25,124,32,0,129,64,120,211,89,127,
1,0,121,56,1,10,3,72,0,0,27,44,120,27,127,124,104,0,130,65,
68,0,0,72,171,170,128,61,171,170,140,57,22,200,12,124,126,248,232,84,
126,248,0,84,64,64,0,124,20,0,128,64,254,255,8,32,64,0,7,124,
8,0,129,65,20,66,39,127,1,0,121,56,189,9,3,72,0,0,27,44,
120,27,127,124,36,0,130,65,24,0,221,128,16,0,6,40,120,251,227,127,
120,227,132,127,8,0,128,65,0,0,156,128,120,219,101,127,189,61,3,72,
24,0,29,129,16,0,8,40,12,0,128,65,0,0,124,128,33,11,3,72,
16,0,25,40,120,227,138,127,0,0,128,57,22,0,129,153,20,0,157,145,
0,0,252,147,24,0,61,147,8,0,128,65,120,251,234,127,0,0,26,44,
0,0,96,57,17,0,97,153,20,0,125,147,174,217,106,125,56,0,130,64,
136,0,0,72,0,0,26,44,36,0,130,64,16,0,7,40,120,227,138,127,
8,0,128,65,0,0,92,129,0,0,160,56,16,0,161,152,20,0,189,144,
0,0,170,152,0,0,26,44,88,0,130,65,24,0,29,129,16,0,8,40,
120,227,131,127,8,0,128,65,0,0,124,128,48,0,1,128,16,0,0,40,
120,243,196,127,8,0,128,65,0,0,158,128,120,211,69,127,9,61,3,72,
24,0,221,128,16,0,6,40,120,227,134,127,8,0,128,65,0,0,220,128,
0,0,96,57,18,0,97,153,20,0,93,147,174,209,102,125,12,0,128,61,
216,87,140,129,0,0,12,44,12,0,160,60,52,0,225,59,116,30,165,56,
56,0,161,144,20,0,130,65,120,251,227,127,166,3,137,125,33,4,128,78,
56,0,161,128,28,0,5,128,120,251,227,127,166,3,9,124,33,4,128,78,
120,251,227,127,1,251,2,72,24,0,29,128,16,0,0,40,12,0,128,65,
0,0,124,128,1,10,3,72,0,0,0,56,19,0,1,152,20,0,29,144,
15,0,64,57,24,0,93,145,0,0,28,152,48,0,1,129,16,0,8,40,
12,0,128,65,0,0,126,128,213,9,3,72,0,0,0,56,20,0,1,152,
44,0,1,144,15,0,32,57,48,0,33,145,0,0,30,152,1,0,96,56,
36,0,0,72,58,16,227,87,9,8,3,72,58,16,233,87,20,74,67,125,
12,0,94,145,4,0,126,144,8,0,126,144,1,0,96,56,112,0,193,131,
104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,
96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,
136,255,33,148,92,0,33,147,96,0,65,147,100,0,97,147,104,0,129,147,
108,0,161,147,112,0,193,147,116,0,225,147,166,2,8,124,124,0,1,144,
0,0,166,131,120,27,124,124,4,0,156,129,0,0,12,44,0,0,196,131,
0,0,224,59,120,43,187,124,0,64,32,61,255,255,41,57,16,0,130,65,
12,0,188,128,80,40,12,124,112,22,31,124,0,0,27,44,136,13,130,65,
0,0,12,44,0,0,224,56,16,0,130,65,8,0,252,128,80,56,204,124,
112,22,199,124,80,72,7,125,64,216,8,124,160,8,128,64,15,0,0,56,
48,0,1,144,0,0,160,56,8,0,161,152,44,0,161,144,28,0,193,59,
28,0,161,152,11,0,96,63,240,105,123,59,255,255,59,57,1,0,233,140,
117,7,231,124,248,255,130,64,48,0,97,129,16,0,11,40,80,72,155,127,
120,243,202,127,8,0,128,65,0,0,94,129,0,80,27,124,12,0,160,63,
168,2,128,65,16,0,11,40,120,243,199,127,8,0,128,65,0,0,254,128,
44,0,129,129,20,98,7,124,0,216,0,124,136,2,129,64,16,0,11,40,
120,243,197,127,8,0,128,65,0,0,190,128,80,216,229,127,64,248,12,124,
16,0,128,64,24,0,97,56,129,253,2,72,44,0,129,129,80,96,255,124,
64,56,28,124,8,0,128,64,120,227,135,127,212,87,189,131,20,58,127,127,
64,216,12,124,120,235,188,127,16,0,128,64,24,0,97,56,81,253,2,72,
44,0,129,129,80,96,27,124,64,224,0,124,8,0,128,64,120,3,28,124,
0,0,28,44,232,0,130,65,48,0,97,129,16,0,11,40,120,243,199,127,
8,0,128,65,0,0,254,128,16,0,11,40,20,218,71,125,120,243,201,127,
8,0,128,65,0,0,62,129,81,0,28,124,20,218,201,124,120,3,9,124,
20,226,166,124,132,0,130,65,80,80,229,124,64,72,7,124,72,0,129,65,
1,0,0,40,20,74,74,125,120,3,6,124,20,74,165,124,8,0,128,64,
1,0,192,56,166,3,201,124,255,255,37,141,255,255,42,157,248,255,0,66,
48,0,97,129,16,0,11,40,44,0,129,129,80,96,92,125,120,243,200,127,
76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,120,3,8,124,
255,255,74,57,8,0,128,64,1,0,0,57,166,3,9,125,1,0,5,140,
1,0,10,156,248,255,0,66,48,0,97,129,44,0,129,129,16,0,11,40,
80,96,92,125,120,243,200,127,8,0,128,65,0,0,30,129,0,0,96,57,
9,0,97,153,44,0,65,145,174,81,104,125,44,0,129,129,64,248,12,124,
8,0,128,64,120,99,159,125,0,0,31,44,232,2,130,65,48,0,97,129,
16,0,11,40,120,243,202,127,8,0,128,65,0,0,94,129,16,0,11,40,
120,243,201,127,8,0,128,65,0,0,62,129,80,96,31,124,121,3,8,124,
120,67,5,125,20,250,233,124,132,0,130,65,80,80,199,124,64,40,6,124,
68,0,129,65,1,0,8,40,20,42,231,124,20,42,74,125,8,0,128,64,
1,0,0,57,166,3,9,125,255,255,39,141,255,255,42,157,248,255,0,66,
48,0,97,129,16,0,11,40,44,0,129,129,120,243,197,127,80,96,31,124,
76,0,128,65,68,0,0,72,1,0,8,40,255,255,231,56,120,67,0,125,
255,255,74,57,8,0,128,64,1,0,0,56,166,3,9,124,1,0,7,140,
1,0,10,156,248,255,0,66,44,0,129,129,48,0,97,129,80,96,31,124,
16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,0,0,96,57,
10,0,97,153,44,0,1,144,174,1,101,125,44,0,97,131,168,134,2,57,
52,0,1,145,120,235,168,127,64,216,8,124,14,0,97,153,64,0,129,59,
12,0,32,61,84,30,41,57,56,0,33,145,64,0,97,153,15,0,0,56,
80,0,97,145,60,0,225,59,84,0,1,144,20,2,128,65,20,2,0,72,
254,255,224,56,64,56,28,124,16,0,129,64,24,0,97,56,241,252,2,72,
48,0,97,129,64,224,11,124,232,0,128,64,44,0,65,131,254,255,32,57,
15,0,153,99,64,72,25,124,32,0,129,64,120,227,153,127,1,0,121,56,
1,4,3,72,0,0,26,44,120,27,127,124,72,0,130,64,100,0,0,72,
171,170,128,61,171,170,140,57,22,200,76,125,126,248,105,85,126,248,74,85,
64,72,10,124,20,0,128,64,254,255,9,32,64,0,11,124,8,0,129,65,
20,74,43,127,1,0,121,56,189,3,3,72,0,0,26,44,120,27,127,124,
36,0,130,65,48,0,161,128,16,0,5,40,120,251,227,127,120,243,196,127,
8,0,128,65,0,0,158,128,120,211,69,127,189,55,3,72,48,0,1,128,
16,0,0,40,12,0,128,65,0,0,126,128,33,5,3,72,16,0,25,40,
48,0,33,147,120,243,202,127,0,0,254,147,0,0,128,57,44,0,129,145,
21,0,129,153,8,0,128,65,120,251,234,127,0,0,28,44,0,0,96,57,
12,0,97,153,44,0,65,147,174,209,106,125,56,0,130,65,128,0,0,72,
0,0,28,44,36,0,130,64,16,0,11,40,120,243,197,127,8,0,128,65,
0,0,190,128,0,0,192,56,11,0,193,152,44,0,193,144,0,0,197,152,
0,0,28,44,80,0,130,64,44,0,97,131,212,87,189,131,168,134,2,57,
52,0,1,145,120,235,168,127,64,216,8,124,0,0,160,56,14,0,161,152,
64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,64,0,161,152,
15,0,0,56,80,0,161,144,60,0,225,59,84,0,1,144,148,0,128,65,
148,0,0,72,48,0,1,129,16,0,8,40,120,243,195,127,8,0,128,65,
0,0,126,128,120,219,100,127,120,227,133,127,205,54,3,72,48,0,1,128,
16,0,0,40,120,243,199,127,8,0,128,65,0,0,254,128,0,0,96,57,
13,0,97,153,44,0,129,147,174,225,103,125,212,87,189,131,44,0,97,131,
168,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,0,0,160,56,
14,0,161,152,64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,
64,0,161,152,15,0,0,56,80,0,161,144,60,0,225,59,84,0,1,144,
8,0,128,64,120,67,27,125,24,0,1,56,64,0,31,124,52,1,130,64,
20,0,255,128,64,216,7,124,16,0,128,64,120,251,227,127,241,248,2,72,
20,0,255,128,80,56,27,124,64,232,0,124,8,0,128,64,120,3,29,124,
0,0,29,44,140,2,130,65,24,0,223,128,16,0,6,40,120,227,138,127,
8,0,128,65,0,0,92,129,16,0,6,40,20,218,42,125,120,227,136,127,
8,0,128,65,0,0,28,129,81,0,29,124,20,218,168,124,120,3,8,124,
20,234,165,124,128,0,130,65,80,72,197,124,64,64,6,124,68,0,129,65,
1,0,0,40,20,66,165,124,20,66,41,125,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,229,140,255,255,233,156,248,255,0,66,24,0,223,128,
16,0,6,40,20,0,255,128,80,56,61,125,120,227,134,127,76,0,128,65,
68,0,0,72,1,0,0,40,255,255,165,56,120,3,6,124,255,255,41,57,
8,0,128,64,1,0,192,56,166,3,201,124,1,0,5,140,1,0,9,156,
248,255,0,66,24,0,223,128,20,0,255,128,16,0,6,40,80,56,61,125,
120,227,134,127,8,0,128,65,0,0,220,128,0,0,96,57,15,0,97,153,
20,0,63,145,174,73,102,125,12,0,128,61,216,87,140,129,0,0,12,44,
12,0,0,61,52,0,161,59,116,30,8,57,56,0,1,145,192,1,130,65,
172,1,0,72,254,255,192,56,64,48,27,124,12,0,129,64,120,251,227,127,
165,249,2,72,24,0,223,128,64,216,6,124,232,0,128,64,20,0,63,131,
254,255,0,57,15,0,122,99,64,64,26,124,32,0,129,64,120,219,122,127,
1,0,122,56,181,0,3,72,0,0,25,44,120,27,125,124,104,0,130,65,
68,0,0,72,171,170,128,61,171,170,140,57,22,208,76,125,126,248,200,84,
126,248,74,85,64,64,10,124,20,0,128,64,254,255,8,32,64,0,6,124,
8,0,129,65,20,66,70,127,1,0,122,56,113,0,3,72,0,0,25,44,
120,27,125,124,36,0,130,65,24,0,63,129,16,0,9,40,120,235,163,127,
120,227,132,127,8,0,128,65,0,0,156,128,120,203,37,127,113,52,3,72,
24,0,223,128,16,0,6,40,12,0,128,65,0,0,124,128,213,1,3,72,
16,0,26,40,120,227,135,127,0,0,128,57,22,0,129,153,20,0,159,145,
0,0,188,147,24,0,95,147,8,0,128,65,120,235,167,127,0,0,27,44,
0,0,96,57,17,0,97,153,20,0,63,147,174,201,103,125,56,0,130,64,
136,0,0,72,0,0,27,44,36,0,130,64,16,0,6,40,120,227,135,127,
8,0,128,65,0,0,252,128,0,0,160,56,16,0,161,152,20,0,191,144,
0,0,167,152,0,0,27,44,88,0,130,65,24,0,255,128,16,0,7,40,
120,227,131,127,8,0,128,65,0,0,124,128,48,0,33,129,16,0,9,40,
120,243,196,127,8,0,128,65,0,0,158,128,120,219,101,127,189,51,3,72,
24,0,95,129,16,0,10,40,120,227,133,127,8,0,128,65,0,0,188,128,
0,0,96,57,18,0,97,153,20,0,127,147,174,217,101,125,12,0,128,61,
216,87,140,129,0,0,12,44,12,0,0,61,52,0,161,59,116,30,8,57,
56,0,1,145,20,0,130,65,120,235,163,127,166,3,137,125,33,4,128,78,
56,0,1,129,28,0,8,128,120,235,163,127,166,3,9,124,33,4,128,78,
120,235,163,127,181,241,2,72,24,0,63,129,16,0,9,40,12,0,128,65,
0,0,124,128,181,0,3,72,0,0,0,56,19,0,1,152,20,0,31,144,
15,0,64,57,24,0,95,145,0,0,28,152,48,0,1,128,16,0,0,40,
12,0,128,65,0,0,126,128,137,0,3,72,0,0,224,56,20,0,225,152,
44,0,225,144,15,0,192,56,48,0,193,144,0,0,254,152,112,0,193,131,
104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,
96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,
0,0,12,44,0,0,192,56,16,0,130,65,8,0,28,128,80,0,76,125,
112,22,70,125,20,218,166,124,64,40,31,124,88,2,128,64,126,248,232,87,
80,72,200,124,64,248,6,124,0,0,0,56,8,0,128,65,20,66,31,124,
0,0,12,44,120,3,31,124,0,0,64,57,16,0,130,65,8,0,28,128,
80,0,236,124,112,22,234,124,20,218,170,124,64,40,31,124,32,0,128,64,
0,0,12,44,0,0,160,56,16,0,130,65,8,0,252,128,80,56,204,124,
112,22,197,124,20,218,229,127,64,72,31,124,68,0,129,64,56,136,13,129,
0,0,8,44,48,0,130,64,1,0,32,57,56,136,45,145,11,0,64,61,
224,105,74,57,48,136,77,145,12,0,0,61,148,30,8,57,52,136,13,145,
12,0,96,60,216,30,99,56,33,249,2,72,48,136,109,56,105,240,2,72,
58,16,255,87,120,251,227,127,205,253,2,72,4,0,60,129,120,27,122,124,
80,240,9,124,59,0,0,84,120,3,8,124,120,211,69,127,120,0,130,65,
120,43,166,124,80,48,73,125,64,64,10,124,120,67,10,125,64,0,129,65,
1,0,10,40,20,66,198,124,20,66,41,125,120,83,72,125,8,0,128,64,
1,0,0,57,166,3,9,125,255,255,233,140,255,255,230,156,248,255,0,66,
20,2,5,125,121,219,101,127,252,255,72,57,60,0,130,64,68,0,0,72,
1,0,10,40,255,255,198,56,255,255,41,57,8,0,128,64,1,0,64,57,
166,3,73,125,1,0,9,141,1,0,6,157,248,255,0,66,20,2,5,125,
121,219,101,127,252,255,72,57,16,0,130,65,255,255,165,52,4,0,170,151,
248,255,130,64,8,0,28,128,80,0,190,124,59,0,167,84,58,16,96,87,
20,2,72,125,112,0,130,65,80,80,222,124,64,56,6,124,120,59,224,124,
60,0,129,65,1,0,0,40,20,58,222,127,20,58,74,125,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,30,141,255,255,10,157,248,255,0,66,
4,0,156,129,0,0,12,44,0,0,160,56,72,0,130,65,56,0,0,72,
1,0,0,40,255,255,74,57,255,255,222,59,8,0,128,64,1,0,0,56,
166,3,9,124,1,0,62,141,1,0,42,157,248,255,0,66,4,0,156,129,
0,0,12,44,0,0,160,56,16,0,130,65,8,0,188,128,80,40,12,124,
112,22,5,124,4,0,124,128,0,0,3,44,20,42,123,127,8,0,130,65,
17,254,2,72,20,250,218,124,12,0,220,144,58,16,103,87,20,58,26,125,
8,0,28,145,4,0,92,147,112,0,193,131,104,0,129,131,100,0,97,131,
108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,
166,3,8,124,120,0,33,56,32,0,128,78,8,0,188,128,80,40,30,124,
112,22,6,124,64,216,6,124,58,16,108,87,220,0,128,64,59,0,0,84,
20,98,30,125,120,243,202,127,140,0,130,65,80,64,42,125,64,0,9,124,
120,3,5,124,72,0,129,65,1,0,5,40,20,2,8,125,20,2,74,125,
120,43,160,124,8,0,128,64,1,0,0,56,166,3,9,124,255,255,10,140,
255,255,8,156,248,255,0,66,8,0,188,128,80,40,30,124,112,22,6,124,
81,216,70,125,252,255,37,57,84,0,130,65,68,0,0,72,1,0,5,40,
255,255,74,57,120,43,169,124,255,255,8,57,8,0,128,64,1,0,32,57,
166,3,41,125,1,0,170,140,1,0,168,156,248,255,0,66,8,0,188,128,
80,40,30,124,112,22,6,124,81,216,70,125,252,255,37,57,16,0,130,65,
255,255,74,53,4,0,169,151,248,255,130,64,20,98,165,124,80,40,236,124,
64,56,30,124,8,0,188,144,116,1,130,65,0,0,190,147,4,0,222,59,
64,56,30,124,244,255,130,64,96,1,0,72,120,43,164,124,80,32,44,125,
80,32,9,125,59,0,0,85,120,3,8,124,120,75,38,125,144,0,130,65,
120,43,171,124,80,88,70,125,64,64,10,124,120,67,7,125,84,0,129,65,
1,0,7,40,20,66,107,125,120,59,234,124,20,66,198,124,8,0,128,64,
1,0,64,57,166,3,73,125,255,255,230,140,255,255,235,156,248,255,0,66,
20,2,229,124,8,0,252,144,80,72,62,125,112,22,32,125,58,16,10,84,
59,16,0,84,80,32,234,124,120,243,200,127,196,0,130,65,80,0,0,72,
1,0,7,40,255,255,198,56,120,59,232,124,255,255,107,57,8,0,128,64,
1,0,0,57,166,3,9,125,1,0,70,141,1,0,75,157,248,255,0,66,
20,2,229,124,8,0,252,144,80,72,62,125,112,22,32,125,58,16,10,84,
59,16,0,84,80,32,234,124,120,243,200,127,116,0,130,65,80,56,168,124,
64,0,5,124,120,3,6,124,64,0,129,65,1,0,6,40,20,2,231,124,
20,2,8,125,120,51,192,124,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,200,140,255,255,199,156,248,255,0,66,120,243,198,127,20,98,254,124,
64,56,6,124,76,0,130,65,56,0,0,72,1,0,6,40,255,255,231,56,
255,255,8,57,8,0,128,64,1,0,192,56,166,3,201,124,1,0,200,140,
1,0,199,156,248,255,0,66,120,243,198,127,20,98,254,124,64,56,6,124,
20,0,130,65,0,0,166,147,4,0,198,56,64,56,6,124,244,255,130,64,
112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,
124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,
32,0,128,78,136,255,33,148,116,0,225,147,121,35,159,124,92,0,33,147,
96,0,65,147,100,0,97,147,104,0,129,147,108,0,161,147,166,2,8,124,
124,0,1,144,112,0,193,147,120,27,126,124,0,0,64,57,4,0,94,145,
12,0,94,145,8,0,94,145,52,0,130,64,112,0,193,131,100,0,97,131,
104,0,129,131,116,0,225,131,108,0,161,131,96,0,65,131,124,0,1,128,
92,0,33,131,0,0,96,56,166,3,8,124,120,0,33,56,32,0,128,78,
255,63,0,60,255,255,0,96,64,0,31,124,132,8,129,64,15,0,224,56,
48,0,225,144,0,0,0,56,8,0,1,152,44,0,1,144,28,0,193,59,
28,0,1,152,11,0,128,63,4,106,156,59,255,255,92,57,1,0,234,140,
117,7,231,124,248,255,130,64,48,0,1,129,16,0,8,40,80,80,124,127,
120,243,192,127,8,0,128,65,0,0,30,128,0,0,28,124,12,0,160,63,
172,2,128,65,16,0,8,40,120,243,197,127,8,0,128,65,0,0,190,128,
44,0,65,129,20,82,5,124,0,224,0,124,140,2,129,64,16,0,8,40,
120,243,198,127,8,0,128,65,0,0,222,128,80,224,230,127,64,248,10,124,
16,0,128,64,24,0,97,56,113,239,2,72,44,0,65,129,80,80,223,124,
64,48,27,124,8,0,128,64,120,219,102,127,212,87,125,131,20,50,159,127,
64,224,10,124,120,219,125,127,16,0,128,64,24,0,97,56,65,239,2,72,
44,0,65,129,80,80,28,124,64,232,0,124,8,0,128,64,120,3,29,124,
0,0,29,44,232,0,130,65,48,0,1,129,16,0,8,40,120,243,199,127,
8,0,128,65,0,0,254,128,16,0,8,40,20,226,199,124,120,243,201,127,
8,0,128,65,0,0,62,129,81,0,29,124,20,226,233,124,120,3,9,124,
20,234,231,124,132,0,130,65,80,48,7,125,64,72,8,124,72,0,129,65,
1,0,0,40,20,74,198,124,20,74,231,124,120,3,9,124,8,0,128,64,
1,0,32,57,166,3,41,125,255,255,167,140,255,255,166,156,248,255,0,66,
48,0,1,129,16,0,8,40,44,0,65,129,80,80,29,124,120,243,201,127,
76,0,128,65,68,0,0,72,1,0,0,40,255,255,231,56,120,3,5,124,
255,255,198,56,8,0,128,64,1,0,160,56,166,3,169,124,1,0,7,140,
1,0,6,156,248,255,0,66,48,0,1,129,44,0,65,129,16,0,8,40,
80,80,29,124,120,243,201,127,8,0,128,65,0,0,62,129,0,0,96,57,
9,0,97,153,44,0,1,144,174,1,105,125,44,0,65,129,64,248,10,124,
8,0,128,64,120,83,95,125,0,0,31,44,236,2,130,65,48,0,1,129,
16,0,8,40,120,243,201,127,8,0,128,65,0,0,62,129,16,0,8,40,
120,243,199,127,8,0,128,65,0,0,254,128,80,80,31,124,121,3,10,124,
120,83,76,125,20,250,167,124,136,0,130,65,80,72,197,124,64,96,6,124,
72,0,129,65,1,0,10,40,20,98,41,125,120,83,64,125,20,98,165,124,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,5,140,255,255,9,156,
248,255,0,66,48,0,1,129,16,0,8,40,44,0,65,129,80,80,31,124,
120,243,202,127,76,0,128,65,68,0,0,72,1,0,10,40,255,255,165,56,
120,83,71,125,255,255,41,57,8,0,128,64,1,0,224,56,166,3,233,124,
1,0,5,141,1,0,9,157,248,255,0,66,44,0,65,129,48,0,1,129,
80,80,31,124,16,0,8,40,120,243,202,127,8,0,128,65,0,0,94,129,
0,0,32,57,10,0,33,153,44,0,1,144,174,1,42,125,44,0,65,131,
120,219,96,127,64,208,0,124,14,0,33,153,64,0,129,59,176,134,162,56,
52,0,161,144,12,0,192,60,84,30,198,56,56,0,193,144,15,0,0,57,
80,0,33,145,60,0,161,59,64,0,33,153,84,0,1,145,20,2,128,65,
20,2,0,72,254,255,0,56,64,0,27,124,16,0,129,64,24,0,97,56,
221,238,2,72,48,0,1,129,64,216,8,124,232,0,128,64,44,0,65,131,
254,255,0,56,15,0,121,99,64,0,25,124,32,0,129,64,120,219,121,127,
1,0,121,56,237,245,2,72,0,0,26,44,120,27,127,124,72,0,130,64,
100,0,0,72,171,170,128,61,171,170,140,57,22,200,204,124,126,248,0,85,
126,248,198,84,64,0,6,124,20,0,128,64,254,255,224,32,64,56,8,124,
8,0,129,65,20,2,40,127,1,0,121,56,169,245,2,72,0,0,26,44,
120,27,127,124,36,0,130,65,48,0,161,128,16,0,5,40,120,251,227,127,
120,243,196,127,8,0,128,65,0,0,158,128,120,211,69,127,169,41,3,72,
48,0,193,128,16,0,6,40,12,0,128,65,0,0,126,128,13,247,2,72,
16,0,25,40,48,0,33,147,120,243,202,127,0,0,254,147,0,0,128,57,
44,0,129,145,21,0,129,153,8,0,128,65,120,251,234,127,0,0,27,44,
0,0,96,57,12,0,97,153,44,0,65,147,174,209,106,125,56,0,130,65,
128,0,0,72,0,0,27,44,36,0,130,64,16,0,8,40,120,243,199,127,
8,0,128,65,0,0,254,128,0,0,0,56,11,0,1,152,44,0,1,144,
0,0,7,152,0,0,27,44,80,0,130,64,44,0,65,131,212,87,125,131,
120,219,96,127,64,208,0,124,0,0,32,57,14,0,33,153,64,0,129,59,
176,134,162,56,52,0,161,144,12,0,192,60,84,30,198,56,15,0,0,57,
80,0,33,145,60,0,161,59,64,0,33,153,84,0,1,145,56,0,193,144,
148,0,128,65,148,0,0,72,48,0,225,128,16,0,7,40,120,243,195,127,
8,0,128,65,0,0,126,128,120,227,132,127,120,219,101,127,185,40,3,72,
48,0,1,129,16,0,8,40,120,243,199,127,8,0,128,65,0,0,254,128,
0,0,96,57,13,0,97,153,44,0,97,147,174,217,103,125,212,87,125,131,
44,0,65,131,120,219,96,127,64,208,0,124,0,0,32,57,14,0,33,153,
64,0,129,59,176,134,162,56,52,0,161,144,12,0,192,60,84,30,198,56,
56,0,193,144,15,0,0,57,80,0,33,145,60,0,161,59,64,0,33,153,
84,0,1,145,8,0,128,64,120,3,26,124,24,0,1,56,64,0,29,124,
56,1,130,64,20,0,221,128,64,208,6,124,16,0,128,64,120,235,163,127,
221,234,2,72,20,0,221,128,80,48,90,125,64,216,10,124,8,0,128,64,
120,83,91,125,0,0,27,44,144,2,130,65,24,0,253,128,16,0,7,40,
120,227,137,127,8,0,128,65,0,0,60,129,16,0,7,40,20,210,41,125,
120,227,133,127,8,0,128,65,0,0,188,128,81,80,27,124,120,3,12,124,
20,210,165,124,20,218,69,125,132,0,130,65,80,72,10,125,64,96,8,124,
72,0,129,65,1,0,0,40,20,98,41,125,120,3,8,124,20,98,74,125,
8,0,128,64,1,0,0,57,166,3,9,125,255,255,10,140,255,255,9,156,
248,255,0,66,24,0,253,128,16,0,7,40,20,0,221,128,80,48,219,124,
120,227,136,127,76,0,128,65,68,0,0,72,1,0,0,40,255,255,74,57,
120,3,6,124,255,255,41,57,8,0,128,64,1,0,192,56,166,3,201,124,
1,0,234,140,1,0,233,156,248,255,0,66,24,0,253,128,20,0,221,128,
16,0,7,40,80,48,219,124,120,227,136,127,8,0,128,65,0,0,28,129,
0,0,96,57,15,0,97,153,20,0,221,144,174,49,104,125,12,0,128,61,
216,87,140,129,0,0,12,44,12,0,160,60,52,0,225,59,116,30,165,56,
56,0,161,144,192,1,130,65,172,1,0,72,254,255,0,57,64,64,26,124,
12,0,129,64,120,235,163,127,141,235,2,72,24,0,253,128,64,208,7,124,
232,0,128,64,20,0,125,131,254,255,0,56,15,0,89,99,64,0,25,124,
32,0,129,64,120,211,89,127,1,0,121,56,157,242,2,72,0,0,27,44,
120,27,127,124,104,0,130,65,68,0,0,72,171,170,128,61,171,170,140,57,
22,200,12,124,126,248,232,84,126,248,0,84,64,64,0,124,20,0,128,64,
254,255,8,32,64,0,7,124,8,0,129,65,20,66,39,127,1,0,121,56,
89,242,2,72,0,0,27,44,120,27,127,124,36,0,130,65,24,0,221,128,
16,0,6,40,120,251,227,127,120,227,132,127,8,0,128,65,0,0,156,128,
120,219,101,127,89,38,3,72,24,0,29,129,16,0,8,40,12,0,128,65,
0,0,124,128,189,243,2,72,16,0,25,40,120,227,138,127,0,0,128,57,
22,0,129,153,20,0,157,145,0,0,252,147,24,0,61,147,8,0,128,65,
120,251,234,127,0,0,26,44,0,0,96,57,17,0,97,153,20,0,125,147,
174,217,106,125,56,0,130,64,136,0,0,72,0,0,26,44,36,0,130,64,
16,0,7,40,120,227,138,127,8,0,128,65,0,0,92,129,0,0,160,56,
16,0,161,152,20,0,189,144,0,0,170,152,0,0,26,44,88,0,130,65,
24,0,29,129,16,0,8,40,120,227,131,127,8,0,128,65,0,0,124,128,
48,0,1,128,16,0,0,40,120,243,196,127,8,0,128,65,0,0,158,128,
120,211,69,127,165,37,3,72,24,0,221,128,16,0,6,40,120,227,134,127,
8,0,128,65,0,0,220,128,0,0,96,57,18,0,97,153,20,0,93,147,
174,209,102,125,12,0,128,61,216,87,140,129,0,0,12,44,12,0,160,60,
52,0,225,59,116,30,165,56,56,0,161,144,20,0,130,65,120,251,227,127,
166,3,137,125,33,4,128,78,56,0,161,128,28,0,5,128,120,251,227,127,
166,3,9,124,33,4,128,78,120,251,227,127,157,227,2,72,24,0,29,128,
16,0,0,40,12,0,128,65,0,0,124,128,157,242,2,72,0,0,0,56,
19,0,1,152,20,0,29,144,15,0,64,57,24,0,93,145,0,0,28,152,
48,0,1,129,16,0,8,40,12,0,128,65,0,0,126,128,113,242,2,72,
0,0,0,56,20,0,1,152,44,0,1,144,15,0,32,57,48,0,33,145,
0,0,30,152,1,0,96,56,36,0,0,72,58,16,227,87,165,240,2,72,
58,16,233,87,20,74,67,125,12,0,94,145,4,0,126,144,8,0,126,144,
1,0,96,56,112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,
116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,
120,0,33,56,32,0,128,78,136,255,33,148,92,0,33,147,96,0,65,147,
100,0,97,147,104,0,129,147,108,0,161,147,112,0,193,147,116,0,225,147,
166,2,8,124,124,0,1,144,0,0,166,131,120,27,124,124,4,0,156,129,
0,0,12,44,0,0,196,131,0,0,224,59,120,43,187,124,0,64,32,61,
255,255,41,57,16,0,130,65,12,0,188,128,80,40,12,124,112,22,31,124,
0,0,27,44,136,13,130,65,0,0,12,44,0,0,224,56,16,0,130,65,
8,0,252,128,80,56,204,124,112,22,199,124,80,72,7,125,64,216,8,124,
160,8,128,64,15,0,0,56,48,0,1,144,0,0,160,56,8,0,161,152,
44,0,161,144,28,0,193,59,28,0,161,152,11,0,96,63,40,106,123,59,
255,255,59,57,1,0,233,140,117,7,231,124,248,255,130,64,48,0,97,129,
16,0,11,40,80,72,155,127,120,243,202,127,8,0,128,65,0,0,94,129,
0,80,27,124,12,0,160,63,168,2,128,65,16,0,11,40,120,243,199,127,
8,0,128,65,0,0,254,128,44,0,129,129,20,98,7,124,0,216,0,124,
136,2,129,64,16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,
80,216,229,127,64,248,12,124,16,0,128,64,24,0,97,56,29,230,2,72,
44,0,129,129,80,96,255,124,64,56,28,124,8,0,128,64,120,227,135,127,
212,87,189,131,20,58,127,127,64,216,12,124,120,235,188,127,16,0,128,64,
24,0,97,56,237,229,2,72,44,0,129,129,80,96,27,124,64,224,0,124,
8,0,128,64,120,3,28,124,0,0,28,44,232,0,130,65,48,0,97,129,
16,0,11,40,120,243,199,127,8,0,128,65,0,0,254,128,16,0,11,40,
20,218,71,125,120,243,201,127,8,0,128,65,0,0,62,129,81,0,28,124,
20,218,201,124,120,3,9,124,20,226,166,124,132,0,130,65,80,80,229,124,
64,72,7,124,72,0,129,65,1,0,0,40,20,74,74,125,120,3,6,124,
20,74,165,124,8,0,128,64,1,0,192,56,166,3,201,124,255,255,37,141,
255,255,42,157,248,255,0,66,48,0,97,129,16,0,11,40,44,0,129,129,
80,96,92,125,120,243,200,127,76,0,128,65,68,0,0,72,1,0,0,40,
255,255,165,56,120,3,8,124,255,255,74,57,8,0,128,64,1,0,0,57,
166,3,9,125,1,0,5,140,1,0,10,156,248,255,0,66,48,0,97,129,
44,0,129,129,16,0,11,40,80,96,92,125,120,243,200,127,8,0,128,65,
0,0,30,129,0,0,96,57,9,0,97,153,44,0,65,145,174,81,104,125,
44,0,129,129,64,248,12,124,8,0,128,64,120,99,159,125,0,0,31,44,
232,2,130,65,48,0,97,129,16,0,11,40,120,243,202,127,8,0,128,65,
0,0,94,129,16,0,11,40,120,243,201,127,8,0,128,65,0,0,62,129,
80,96,31,124,121,3,8,124,120,67,5,125,20,250,233,124,132,0,130,65,
80,80,199,124,64,40,6,124,68,0,129,65,1,0,8,40,20,42,231,124,
20,42,74,125,8,0,128,64,1,0,0,57,166,3,9,125,255,255,39,141,
255,255,42,157,248,255,0,66,48,0,97,129,16,0,11,40,44,0,129,129,
120,243,197,127,80,96,31,124,76,0,128,65,68,0,0,72,1,0,8,40,
255,255,231,56,120,67,0,125,255,255,74,57,8,0,128,64,1,0,0,56,
166,3,9,124,1,0,7,140,1,0,10,156,248,255,0,66,44,0,129,129,
48,0,97,129,80,96,31,124,16,0,11,40,120,243,197,127,8,0,128,65,
0,0,190,128,0,0,96,57,10,0,97,153,44,0,1,144,174,1,101,125,
44,0,97,131,184,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,
14,0,97,153,64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,
64,0,97,153,15,0,0,56,80,0,97,145,60,0,225,59,84,0,1,144,
20,2,128,65,20,2,0,72,254,255,224,56,64,56,28,124,16,0,129,64,
24,0,97,56,141,229,2,72,48,0,97,129,64,224,11,124,232,0,128,64,
44,0,65,131,254,255,32,57,15,0,153,99,64,72,25,124,32,0,129,64,
120,227,153,127,1,0,121,56,157,236,2,72,0,0,26,44,120,27,127,124,
72,0,130,64,100,0,0,72,171,170,128,61,171,170,140,57,22,200,76,125,
126,248,105,85,126,248,74,85,64,72,10,124,20,0,128,64,254,255,9,32,
64,0,11,124,8,0,129,65,20,74,43,127,1,0,121,56,89,236,2,72,
0,0,26,44,120,27,127,124,36,0,130,65,48,0,161,128,16,0,5,40,
120,251,227,127,120,243,196,127,8,0,128,65,0,0,158,128,120,211,69,127,
89,32,3,72,48,0,1,128,16,0,0,40,12,0,128,65,0,0,126,128,
189,237,2,72,16,0,25,40,48,0,33,147,120,243,202,127,0,0,254,147,
0,0,128,57,44,0,129,145,21,0,129,153,8,0,128,65,120,251,234,127,
0,0,28,44,0,0,96,57,12,0,97,153,44,0,65,147,174,209,106,125,
56,0,130,65,128,0,0,72,0,0,28,44,36,0,130,64,16,0,11,40,
120,243,197,127,8,0,128,65,0,0,190,128,0,0,192,56,11,0,193,152,
44,0,193,144,0,0,197,152,0,0,28,44,80,0,130,64,44,0,97,131,
212,87,189,131,184,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,
0,0,160,56,14,0,161,152,64,0,129,59,12,0,32,61,84,30,41,57,
56,0,33,145,64,0,161,152,15,0,0,56,80,0,161,144,60,0,225,59,
84,0,1,144,148,0,128,65,148,0,0,72,48,0,1,129,16,0,8,40,
120,243,195,127,8,0,128,65,0,0,126,128,120,219,100,127,120,227,133,127,
105,31,3,72,48,0,1,128,16,0,0,40,120,243,199,127,8,0,128,65,
0,0,254,128,0,0,96,57,13,0,97,153,44,0,129,147,174,225,103,125,
212,87,189,131,44,0,97,131,184,134,2,57,52,0,1,145,120,235,168,127,
64,216,8,124,0,0,160,56,14,0,161,152,64,0,129,59,12,0,32,61,
84,30,41,57,56,0,33,145,64,0,161,152,15,0,0,56,80,0,161,144,
60,0,225,59,84,0,1,144,8,0,128,64,120,67,27,125,24,0,1,56,
64,0,31,124,52,1,130,64,20,0,255,128,64,216,7,124,16,0,128,64,
120,251,227,127,141,225,2,72,20,0,255,128,80,56,27,124,64,232,0,124,
8,0,128,64,120,3,29,124,0,0,29,44,140,2,130,65,24,0,223,128,
16,0,6,40,120,227,138,127,8,0,128,65,0,0,92,129,16,0,6,40,
20,218,42,125,120,227,136,127,8,0,128,65,0,0,28,129,81,0,29,124,
20,218,168,124,120,3,8,124,20,234,165,124,128,0,130,65,80,72,197,124,
64,64,6,124,68,0,129,65,1,0,0,40,20,66,165,124,20,66,41,125,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,229,140,255,255,233,156,
248,255,0,66,24,0,223,128,16,0,6,40,20,0,255,128,80,56,61,125,
120,227,134,127,76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,
120,3,6,124,255,255,41,57,8,0,128,64,1,0,192,56,166,3,201,124,
1,0,5,140,1,0,9,156,248,255,0,66,24,0,223,128,20,0,255,128,
16,0,6,40,80,56,61,125,120,227,134,127,8,0,128,65,0,0,220,128,
0,0,96,57,15,0,97,153,20,0,63,145,174,73,102,125,12,0,128,61,
216,87,140,129,0,0,12,44,12,0,0,61,52,0,161,59,116,30,8,57,
56,0,1,145,192,1,130,65,172,1,0,72,254,255,192,56,64,48,27,124,
12,0,129,64,120,251,227,127,65,226,2,72,24,0,223,128,64,216,6,124,
232,0,128,64,20,0,63,131,254,255,0,57,15,0,122,99,64,64,26,124,
32,0,129,64,120,219,122,127,1,0,122,56,81,233,2,72,0,0,25,44,
120,27,125,124,104,0,130,65,68,0,0,72,171,170,128,61,171,170,140,57,
22,208,76,125,126,248,200,84,126,248,74,85,64,64,10,124,20,0,128,64,
254,255,8,32,64,0,6,124,8,0,129,65,20,66,70,127,1,0,122,56,
13,233,2,72,0,0,25,44,120,27,125,124,36,0,130,65,24,0,63,129,
16,0,9,40,120,235,163,127,120,227,132,127,8,0,128,65,0,0,156,128,
120,203,37,127,13,29,3,72,24,0,223,128,16,0,6,40,12,0,128,65,
0,0,124,128,113,234,2,72,16,0,26,40,120,227,135,127,0,0,128,57,
22,0,129,153,20,0,159,145,0,0,188,147,24,0,95,147,8,0,128,65,
120,235,167,127,0,0,27,44,0,0,96,57,17,0,97,153,20,0,63,147,
174,201,103,125,56,0,130,64,136,0,0,72,0,0,27,44,36,0,130,64,
16,0,6,40,120,227,135,127,8,0,128,65,0,0,252,128,0,0,160,56,
16,0,161,152,20,0,191,144,0,0,167,152,0,0,27,44,88,0,130,65,
24,0,255,128,16,0,7,40,120,227,131,127,8,0,128,65,0,0,124,128,
48,0,33,129,16,0,9,40,120,243,196,127,8,0,128,65,0,0,158,128,
120,219,101,127,89,28,3,72,24,0,95,129,16,0,10,40,120,227,133,127,
8,0,128,65,0,0,188,128,0,0,96,57,18,0,97,153,20,0,127,147,
174,217,101,125,12,0,128,61,216,87,140,129,0,0,12,44,12,0,0,61,
52,0,161,59,116,30,8,57,56,0,1,145,20,0,130,65,120,235,163,127,
166,3,137,125,33,4,128,78,56,0,1,129,28,0,8,128,120,235,163,127,
166,3,9,124,33,4,128,78,120,235,163,127,81,218,2,72,24,0,63,129,
16,0,9,40,12,0,128,65,0,0,124,128,81,233,2,72,0,0,0,56,
19,0,1,152,20,0,31,144,15,0,64,57,24,0,95,145,0,0,28,152,
48,0,1,128,16,0,0,40,12,0,128,65,0,0,126,128,37,233,2,72,
0,0,224,56,20,0,225,152,44,0,225,144,15,0,192,56,48,0,193,144,
0,0,254,152,112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,
116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,
120,0,33,56,32,0,128,78,0,0,12,44,0,0,192,56,16,0,130,65,
8,0,28,128,80,0,76,125,112,22,70,125,20,218,166,124,64,40,31,124,
88,2,128,64,126,248,232,87,80,72,200,124,64,248,6,124,0,0,0,56,
8,0,128,65,20,66,31,124,0,0,12,44,120,3,31,124,0,0,64,57,
16,0,130,65,8,0,28,128,80,0,236,124,112,22,234,124,20,218,170,124,
64,40,31,124,32,0,128,64,0,0,12,44,0,0,160,56,16,0,130,65,
8,0,252,128,80,56,204,124,112,22,197,124,20,218,229,127,64,72,31,124,
68,0,129,64,44,136,13,129,0,0,8,44,48,0,130,64,1,0,32,57,
44,136,45,145,11,0,64,61,24,106,74,57,36,136,77,145,12,0,0,61,
148,30,8,57,40,136,13,145,12,0,96,60,228,30,99,56,189,225,2,72,
36,136,109,56,5,217,2,72,58,16,255,87,120,251,227,127,105,230,2,72,
4,0,60,129,120,27,122,124,80,240,9,124,59,0,0,84,120,3,8,124,
120,211,69,127,120,0,130,65,120,43,166,124,80,48,73,125,64,64,10,124,
120,67,10,125,64,0,129,65,1,0,10,40,20,66,198,124,20,66,41,125,
120,83,72,125,8,0,128,64,1,0,0,57,166,3,9,125,255,255,233,140,
255,255,230,156,248,255,0,66,20,2,5,125,121,219,101,127,252,255,72,57,
60,0,130,64,68,0,0,72,1,0,10,40,255,255,198,56,255,255,41,57,
8,0,128,64,1,0,64,57,166,3,73,125,1,0,9,141,1,0,6,157,
248,255,0,66,20,2,5,125,121,219,101,127,252,255,72,57,16,0,130,65,
255,255,165,52,4,0,170,151,248,255,130,64,8,0,28,128,80,0,190,124,
59,0,167,84,58,16,96,87,20,2,72,125,112,0,130,65,80,80,222,124,
64,56,6,124,120,59,224,124,60,0,129,65,1,0,0,40,20,58,222,127,
20,58,74,125,8,0,128,64,1,0,0,56,166,3,9,124,255,255,30,141,
255,255,10,157,248,255,0,66,4,0,156,129,0,0,12,44,0,0,160,56,
72,0,130,65,56,0,0,72,1,0,0,40,255,255,74,57,255,255,222,59,
8,0,128,64,1,0,0,56,166,3,9,124,1,0,62,141,1,0,42,157,
248,255,0,66,4,0,156,129,0,0,12,44,0,0,160,56,16,0,130,65,
8,0,188,128,80,40,12,124,112,22,5,124,4,0,124,128,0,0,3,44,
20,42,123,127,8,0,130,65,173,230,2,72,20,250,218,124,12,0,220,144,
58,16,103,87,20,58,26,125,8,0,28,145,4,0,92,147,112,0,193,131,
104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,
96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,
8,0,188,128,80,40,30,124,112,22,6,124,64,216,6,124,58,16,108,87,
220,0,128,64,59,0,0,84,20,98,30,125,120,243,202,127,140,0,130,65,
80,64,42,125,64,0,9,124,120,3,5,124,72,0,129,65,1,0,5,40,
20,2,8,125,20,2,74,125,120,43,160,124,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,10,140,255,255,8,156,248,255,0,66,8,0,188,128,
80,40,30,124,112,22,6,124,81,216,70,125,252,255,37,57,84,0,130,65,
68,0,0,72,1,0,5,40,255,255,74,57,120,43,169,124,255,255,8,57,
8,0,128,64,1,0,32,57,166,3,41,125,1,0,170,140,1,0,168,156,
248,255,0,66,8,0,188,128,80,40,30,124,112,22,6,124,81,216,70,125,
252,255,37,57,16,0,130,65,255,255,74,53,4,0,169,151,248,255,130,64,
20,98,165,124,80,40,236,124,64,56,30,124,8,0,188,144,116,1,130,65,
0,0,190,147,4,0,222,59,64,56,30,124,244,255,130,64,96,1,0,72,
120,43,164,124,80,32,44,125,80,32,9,125,59,0,0,85,120,3,8,124,
120,75,38,125,144,0,130,65,120,43,171,124,80,88,70,125,64,64,10,124,
120,67,7,125,84,0,129,65,1,0,7,40,20,66,107,125,120,59,234,124,
20,66,198,124,8,0,128,64,1,0,64,57,166,3,73,125,255,255,230,140,
255,255,235,156,248,255,0,66,20,2,229,124,8,0,252,144,80,72,62,125,
112,22,32,125,58,16,10,84,59,16,0,84,80,32,234,124,120,243,200,127,
196,0,130,65,80,0,0,72,1,0,7,40,255,255,198,56,120,59,232,124,
255,255,107,57,8,0,128,64,1,0,0,57,166,3,9,125,1,0,70,141,
1,0,75,157,248,255,0,66,20,2,229,124,8,0,252,144,80,72,62,125,
112,22,32,125,58,16,10,84,59,16,0,84,80,32,234,124,120,243,200,127,
116,0,130,65,80,56,168,124,64,0,5,124,120,3,6,124,64,0,129,65,
1,0,6,40,20,2,231,124,20,2,8,125,120,51,192,124,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,200,140,255,255,199,156,248,255,0,66,
120,243,198,127,20,98,254,124,64,56,6,124,76,0,130,65,56,0,0,72,
1,0,6,40,255,255,231,56,255,255,8,57,8,0,128,64,1,0,192,56,
166,3,201,124,1,0,200,140,1,0,199,156,248,255,0,66,120,243,198,127,
20,98,254,124,64,56,6,124,20,0,130,65,0,0,166,147,4,0,198,56,
64,56,6,124,244,255,130,64,112,0,193,131,104,0,129,131,100,0,97,131,
108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,
166,3,8,124,120,0,33,56,32,0,128,78,136,255,33,148,116,0,225,147,
121,35,159,124,92,0,33,147,96,0,65,147,100,0,97,147,104,0,129,147,
108,0,161,147,166,2,8,124,124,0,1,144,112,0,193,147,120,27,126,124,
0,0,64,57,4,0,94,145,12,0,94,145,8,0,94,145,52,0,130,64,
112,0,193,131,100,0,97,131,104,0,129,131,116,0,225,131,108,0,161,131,
96,0,65,131,124,0,1,128,92,0,33,131,0,0,96,56,166,3,8,124,
120,0,33,56,32,0,128,78,255,63,0,60,255,255,0,96,64,0,31,124,
132,8,129,64,15,0,224,56,48,0,225,144,0,0,0,56,8,0,1,152,
44,0,1,144,28,0,193,59,28,0,1,152,11,0,128,63,60,106,156,59,
255,255,92,57,1,0,234,140,117,7,231,124,248,255,130,64,48,0,1,129,
16,0,8,40,80,80,124,127,120,243,192,127,8,0,128,65,0,0,30,128,
0,0,28,124,12,0,160,63,172,2,128,65,16,0,8,40,120,243,197,127,
8,0,128,65,0,0,190,128,44,0,65,129,20,82,5,124,0,224,0,124,
140,2,129,64,16,0,8,40,120,243,198,127,8,0,128,65,0,0,222,128,
80,224,230,127,64,248,10,124,16,0,128,64,24,0,97,56,13,216,2,72,
44,0,65,129,80,80,223,124,64,48,27,124,8,0,128,64,120,219,102,127,
212,87,125,131,20,50,159,127,64,224,10,124,120,219,125,127,16,0,128,64,
24,0,97,56,221,215,2,72,44,0,65,129,80,80,28,124,64,232,0,124,
8,0,128,64,120,3,29,124,0,0,29,44,232,0,130,65,48,0,1,129,
16,0,8,40,120,243,199,127,8,0,128,65,0,0,254,128,16,0,8,40,
20,226,199,124,120,243,201,127,8,0,128,65,0,0,62,129,81,0,29,124,
20,226,233,124,120,3,9,124,20,234,231,124,132,0,130,65,80,48,7,125,
64,72,8,124,72,0,129,65,1,0,0,40,20,74,198,124,20,74,231,124,
120,3,9,124,8,0,128,64,1,0,32,57,166,3,41,125,255,255,167,140,
255,255,166,156,248,255,0,66,48,0,1,129,16,0,8,40,44,0,65,129,
80,80,29,124,120,243,201,127,76,0,128,65,68,0,0,72,1,0,0,40,
255,255,231,56,120,3,5,124,255,255,198,56,8,0,128,64,1,0,160,56,
166,3,169,124,1,0,7,140,1,0,6,156,248,255,0,66,48,0,1,129,
44,0,65,129,16,0,8,40,80,80,29,124,120,243,201,127,8,0,128,65,
0,0,62,129,0,0,96,57,9,0,97,153,44,0,1,144,174,1,105,125,
44,0,65,129,64,248,10,124,8,0,128,64,120,83,95,125,0,0,31,44,
236,2,130,65,48,0,1,129,16,0,8,40,120,243,201,127,8,0,128,65,
0,0,62,129,16,0,8,40,120,243,199,127,8,0,128,65,0,0,254,128,
80,80,31,124,121,3,10,124,120,83,76,125,20,250,167,124,136,0,130,65,
80,72,197,124,64,96,6,124,72,0,129,65,1,0,10,40,20,98,41,125,
120,83,64,125,20,98,165,124,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,5,140,255,255,9,156,248,255,0,66,48,0,1,129,16,0,8,40,
44,0,65,129,80,80,31,124,120,243,202,127,76,0,128,65,68,0,0,72,
1,0,10,40,255,255,165,56,120,83,71,125,255,255,41,57,8,0,128,64,
1,0,224,56,166,3,233,124,1,0,5,141,1,0,9,157,248,255,0,66,
44,0,65,129,48,0,1,129,80,80,31,124,16,0,8,40,120,243,202,127,
8,0,128,65,0,0,94,129,0,0,32,57,10,0,33,153,44,0,1,144,
174,1,42,125,44,0,65,131,120,219,96,127,64,208,0,124,14,0,33,153,
64,0,129,59,192,134,162,56,52,0,161,144,12,0,192,60,84,30,198,56,
56,0,193,144,15,0,0,57,80,0,33,145,60,0,161,59,64,0,33,153,
84,0,1,145,20,2,128,65,20,2,0,72,254,255,0,56,64,0,27,124,
16,0,129,64,24,0,97,56,121,215,2,72,48,0,1,129,64,216,8,124,
232,0,128,64,44,0,65,131,254,255,0,56,15,0,121,99,64,0,25,124,
32,0,129,64,120,219,121,127,1,0,121,56,137,222,2,72,0,0,26,44,
120,27,127,124,72,0,130,64,100,0,0,72,171,170,128,61,171,170,140,57,
22,200,204,124,126,248,0,85,126,248,198,84,64,0,6,124,20,0,128,64,
254,255,224,32,64,56,8,124,8,0,129,65,20,2,40,127,1,0,121,56,
69,222,2,72,0,0,26,44,120,27,127,124,36,0,130,65,48,0,161,128,
16,0,5,40,120,251,227,127,120,243,196,127,8,0,128,65,0,0,158,128,
120,211,69,127,69,18,3,72,48,0,193,128,16,0,6,40,12,0,128,65,
0,0,126,128,169,223,2,72,16,0,25,40,48,0,33,147,120,243,202,127,
0,0,254,147,0,0,128,57,44,0,129,145,21,0,129,153,8,0,128,65,
120,251,234,127,0,0,27,44,0,0,96,57,12,0,97,153,44,0,65,147,
174,209,106,125,56,0,130,65,128,0,0,72,0,0,27,44,36,0,130,64,
16,0,8,40,120,243,199,127,8,0,128,65,0,0,254,128,0,0,0,56,
11,0,1,152,44,0,1,144,0,0,7,152,0,0,27,44,80,0,130,64,
44,0,65,131,212,87,125,131,120,219,96,127,64,208,0,124,0,0,32,57,
14,0,33,153,64,0,129,59,192,134,162,56,52,0,161,144,12,0,192,60,
84,30,198,56,15,0,0,57,80,0,33,145,60,0,161,59,64,0,33,153,
84,0,1,145,56,0,193,144,148,0,128,65,148,0,0,72,48,0,225,128,
16,0,7,40,120,243,195,127,8,0,128,65,0,0,126,128,120,227,132,127,
120,219,101,127,85,17,3,72,48,0,1,129,16,0,8,40,120,243,199,127,
8,0,128,65,0,0,254,128,0,0,96,57,13,0,97,153,44,0,97,147,
174,217,103,125,212,87,125,131,44,0,65,131,120,219,96,127,64,208,0,124,
0,0,32,57,14,0,33,153,64,0,129,59,192,134,162,56,52,0,161,144,
12,0,192,60,84,30,198,56,56,0,193,144,15,0,0,57,80,0,33,145,
60,0,161,59,64,0,33,153,84,0,1,145,8,0,128,64,120,3,26,124,
24,0,1,56,64,0,29,124,56,1,130,64,20,0,221,128,64,208,6,124,
16,0,128,64,120,235,163,127,121,211,2,72,20,0,221,128,80,48,90,125,
64,216,10,124,8,0,128,64,120,83,91,125,0,0,27,44,144,2,130,65,
24,0,253,128,16,0,7,40,120,227,137,127,8,0,128,65,0,0,60,129,
16,0,7,40,20,210,41,125,120,227,133,127,8,0,128,65,0,0,188,128,
81,80,27,124,120,3,12,124,20,210,165,124,20,218,69,125,132,0,130,65,
80,72,10,125,64,96,8,124,72,0,129,65,1,0,0,40,20,98,41,125,
120,3,8,124,20,98,74,125,8,0,128,64,1,0,0,57,166,3,9,125,
255,255,10,140,255,255,9,156,248,255,0,66,24,0,253,128,16,0,7,40,
20,0,221,128,80,48,219,124,120,227,136,127,76,0,128,65,68,0,0,72,
1,0,0,40,255,255,74,57,120,3,6,124,255,255,41,57,8,0,128,64,
1,0,192,56,166,3,201,124,1,0,234,140,1,0,233,156,248,255,0,66,
24,0,253,128,20,0,221,128,16,0,7,40,80,48,219,124,120,227,136,127,
8,0,128,65,0,0,28,129,0,0,96,57,15,0,97,153,20,0,221,144,
174,49,104,125,12,0,128,61,216,87,140,129,0,0,12,44,12,0,160,60,
52,0,225,59,116,30,165,56,56,0,161,144,192,1,130,65,172,1,0,72,
254,255,0,57,64,64,26,124,12,0,129,64,120,235,163,127,41,212,2,72,
24,0,253,128,64,208,7,124,232,0,128,64,20,0,125,131,254,255,0,56,
15,0,89,99,64,0,25,124,32,0,129,64,120,211,89,127,1,0,121,56,
57,219,2,72,0,0,27,44,120,27,127,124,104,0,130,65,68,0,0,72,
171,170,128,61,171,170,140,57,22,200,12,124,126,248,232,84,126,248,0,84,
64,64,0,124,20,0,128,64,254,255,8,32,64,0,7,124,8,0,129,65,
20,66,39,127,1,0,121,56,245,218,2,72,0,0,27,44,120,27,127,124,
36,0,130,65,24,0,221,128,16,0,6,40,120,251,227,127,120,227,132,127,
8,0,128,65,0,0,156,128,120,219,101,127,245,14,3,72,24,0,29,129,
16,0,8,40,12,0,128,65,0,0,124,128,89,220,2,72,16,0,25,40,
120,227,138,127,0,0,128,57,22,0,129,153,20,0,157,145,0,0,252,147,
24,0,61,147,8,0,128,65,120,251,234,127,0,0,26,44,0,0,96,57,
17,0,97,153,20,0,125,147,174,217,106,125,56,0,130,64,136,0,0,72,
0,0,26,44,36,0,130,64,16,0,7,40,120,227,138,127,8,0,128,65,
0,0,92,129,0,0,160,56,16,0,161,152,20,0,189,144,0,0,170,152,
0,0,26,44,88,0,130,65,24,0,29,129,16,0,8,40,120,227,131,127,
8,0,128,65,0,0,124,128,48,0,1,128,16,0,0,40,120,243,196,127,
8,0,128,65,0,0,158,128,120,211,69,127,65,14,3,72,24,0,221,128,
16,0,6,40,120,227,134,127,8,0,128,65,0,0,220,128,0,0,96,57,
18,0,97,153,20,0,93,147,174,209,102,125,12,0,128,61,216,87,140,129,
0,0,12,44,12,0,160,60,52,0,225,59,116,30,165,56,56,0,161,144,
20,0,130,65,120,251,227,127,166,3,137,125,33,4,128,78,56,0,161,128,
28,0,5,128,120,251,227,127,166,3,9,124,33,4,128,78,120,251,227,127,
57,204,2,72,24,0,29,128,16,0,0,40,12,0,128,65,0,0,124,128,
57,219,2,72,0,0,0,56,19,0,1,152,20,0,29,144,15,0,64,57,
24,0,93,145,0,0,28,152,48,0,1,129,16,0,8,40,12,0,128,65,
0,0,126,128,13,219,2,72,0,0,0,56,20,0,1,152,44,0,1,144,
15,0,32,57,48,0,33,145,0,0,30,152,1,0,96,56,36,0,0,72,
58,16,227,87,65,217,2,72,58,16,233,87,20,74,67,125,12,0,94,145,
4,0,126,144,8,0,126,144,1,0,96,56,112,0,193,131,104,0,129,131,
100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,
92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,136,255,33,148,
92,0,33,147,96,0,65,147,100,0,97,147,104,0,129,147,108,0,161,147,
112,0,193,147,116,0,225,147,166,2,8,124,124,0,1,144,0,0,166,131,
120,27,124,124,4,0,156,129,0,0,12,44,0,0,196,131,0,0,224,59,
120,43,187,124,0,64,32,61,255,255,41,57,16,0,130,65,12,0,188,128,
80,40,12,124,112,22,31,124,0,0,27,44,136,13,130,65,0,0,12,44,
0,0,224,56,16,0,130,65,8,0,252,128,80,56,204,124,112,22,199,124,
80,72,7,125,64,216,8,124,160,8,128,64,15,0,0,56,48,0,1,144,
0,0,160,56,8,0,161,152,44,0,161,144,28,0,193,59,28,0,161,152,
11,0,96,63,96,106,123,59,255,255,59,57,1,0,233,140,117,7,231,124,
248,255,130,64,48,0,97,129,16,0,11,40,80,72,155,127,120,243,202,127,
8,0,128,65,0,0,94,129,0,80,27,124,12,0,160,63,168,2,128,65,
16,0,11,40,120,243,199,127,8,0,128,65,0,0,254,128,44,0,129,129,
20,98,7,124,0,216,0,124,136,2,129,64,16,0,11,40,120,243,197,127,
8,0,128,65,0,0,190,128,80,216,229,127,64,248,12,124,16,0,128,64,
24,0,97,56,185,206,2,72,44,0,129,129,80,96,255,124,64,56,28,124,
8,0,128,64,120,227,135,127,212,87,189,131,20,58,127,127,64,216,12,124,
120,235,188,127,16,0,128,64,24,0,97,56,137,206,2,72,44,0,129,129,
80,96,27,124,64,224,0,124,8,0,128,64,120,3,28,124,0,0,28,44,
232,0,130,65,48,0,97,129,16,0,11,40,120,243,199,127,8,0,128,65,
0,0,254,128,16,0,11,40,20,218,71,125,120,243,201,127,8,0,128,65,
0,0,62,129,81,0,28,124,20,218,201,124,120,3,9,124,20,226,166,124,
132,0,130,65,80,80,229,124,64,72,7,124,72,0,129,65,1,0,0,40,
20,74,74,125,120,3,6,124,20,74,165,124,8,0,128,64,1,0,192,56,
166,3,201,124,255,255,37,141,255,255,42,157,248,255,0,66,48,0,97,129,
16,0,11,40,44,0,129,129,80,96,92,125,120,243,200,127,76,0,128,65,
68,0,0,72,1,0,0,40,255,255,165,56,120,3,8,124,255,255,74,57,
8,0,128,64,1,0,0,57,166,3,9,125,1,0,5,140,1,0,10,156,
248,255,0,66,48,0,97,129,44,0,129,129,16,0,11,40,80,96,92,125,
120,243,200,127,8,0,128,65,0,0,30,129,0,0,96,57,9,0,97,153,
44,0,65,145,174,81,104,125,44,0,129,129,64,248,12,124,8,0,128,64,
120,99,159,125,0,0,31,44,232,2,130,65,48,0,97,129,16,0,11,40,
120,243,202,127,8,0,128,65,0,0,94,129,16,0,11,40,120,243,201,127,
8,0,128,65,0,0,62,129,80,96,31,124,121,3,8,124,120,67,5,125,
20,250,233,124,132,0,130,65,80,80,199,124,64,40,6,124,68,0,129,65,
1,0,8,40,20,42,231,124,20,42,74,125,8,0,128,64,1,0,0,57,
166,3,9,125,255,255,39,141,255,255,42,157,248,255,0,66,48,0,97,129,
16,0,11,40,44,0,129,129,120,243,197,127,80,96,31,124,76,0,128,65,
68,0,0,72,1,0,8,40,255,255,231,56,120,67,0,125,255,255,74,57,
8,0,128,64,1,0,0,56,166,3,9,124,1,0,7,140,1,0,10,156,
248,255,0,66,44,0,129,129,48,0,97,129,80,96,31,124,16,0,11,40,
120,243,197,127,8,0,128,65,0,0,190,128,0,0,96,57,10,0,97,153,
44,0,1,144,174,1,101,125,44,0,97,131,200,134,2,57,52,0,1,145,
120,235,168,127,64,216,8,124,14,0,97,153,64,0,129,59,12,0,32,61,
84,30,41,57,56,0,33,145,64,0,97,153,15,0,0,56,80,0,97,145,
60,0,225,59,84,0,1,144,20,2,128,65,20,2,0,72,254,255,224,56,
64,56,28,124,16,0,129,64,24,0,97,56,41,206,2,72,48,0,97,129,
64,224,11,124,232,0,128,64,44,0,65,131,254,255,32,57,15,0,153,99,
64,72,25,124,32,0,129,64,120,227,153,127,1,0,121,56,57,213,2,72,
0,0,26,44,120,27,127,124,72,0,130,64,100,0,0,72,171,170,128,61,
171,170,140,57,22,200,76,125,126,248,105,85,126,248,74,85,64,72,10,124,
20,0,128,64,254,255,9,32,64,0,11,124,8,0,129,65,20,74,43,127,
1,0,121,56,245,212,2,72,0,0,26,44,120,27,127,124,36,0,130,65,
48,0,161,128,16,0,5,40,120,251,227,127,120,243,196,127,8,0,128,65,
0,0,158,128,120,211,69,127,245,8,3,72,48,0,1,128,16,0,0,40,
12,0,128,65,0,0,126,128,89,214,2,72,16,0,25,40,48,0,33,147,
120,243,202,127,0,0,254,147,0,0,128,57,44,0,129,145,21,0,129,153,
8,0,128,65,120,251,234,127,0,0,28,44,0,0,96,57,12,0,97,153,
44,0,65,147,174,209,106,125,56,0,130,65,128,0,0,72,0,0,28,44,
36,0,130,64,16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,
0,0,192,56,11,0,193,152,44,0,193,144,0,0,197,152,0,0,28,44,
80,0,130,64,44,0,97,131,212,87,189,131,200,134,2,57,52,0,1,145,
120,235,168,127,64,216,8,124,0,0,160,56,14,0,161,152,64,0,129,59,
12,0,32,61,84,30,41,57,56,0,33,145,64,0,161,152,15,0,0,56,
80,0,161,144,60,0,225,59,84,0,1,144,148,0,128,65,148,0,0,72,
48,0,1,129,16,0,8,40,120,243,195,127,8,0,128,65,0,0,126,128,
120,219,100,127,120,227,133,127,5,8,3,72,48,0,1,128,16,0,0,40,
120,243,199,127,8,0,128,65,0,0,254,128,0,0,96,57,13,0,97,153,
44,0,129,147,174,225,103,125,212,87,189,131,44,0,97,131,200,134,2,57,
52,0,1,145,120,235,168,127,64,216,8,124,0,0,160,56,14,0,161,152,
64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,64,0,161,152,
15,0,0,56,80,0,161,144,60,0,225,59,84,0,1,144,8,0,128,64,
120,67,27,125,24,0,1,56,64,0,31,124,52,1,130,64,20,0,255,128,
64,216,7,124,16,0,128,64,120,251,227,127,41,202,2,72,20,0,255,128,
80,56,27,124,64,232,0,124,8,0,128,64,120,3,29,124,0,0,29,44,
140,2,130,65,24,0,223,128,16,0,6,40,120,227,138,127,8,0,128,65,
0,0,92,129,16,0,6,40,20,218,42,125,120,227,136,127,8,0,128,65,
0,0,28,129,81,0,29,124,20,218,168,124,120,3,8,124,20,234,165,124,
128,0,130,65,80,72,197,124,64,64,6,124,68,0,129,65,1,0,0,40,
20,66,165,124,20,66,41,125,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,229,140,255,255,233,156,248,255,0,66,24,0,223,128,16,0,6,40,
20,0,255,128,80,56,61,125,120,227,134,127,76,0,128,65,68,0,0,72,
1,0,0,40,255,255,165,56,120,3,6,124,255,255,41,57,8,0,128,64,
1,0,192,56,166,3,201,124,1,0,5,140,1,0,9,156,248,255,0,66,
24,0,223,128,20,0,255,128,16,0,6,40,80,56,61,125,120,227,134,127,
8,0,128,65,0,0,220,128,0,0,96,57,15,0,97,153,20,0,63,145,
174,73,102,125,12,0,128,61,216,87,140,129,0,0,12,44,12,0,0,61,
52,0,161,59,116,30,8,57,56,0,1,145,192,1,130,65,172,1,0,72,
254,255,192,56,64,48,27,124,12,0,129,64,120,251,227,127,221,202,2,72,
24,0,223,128,64,216,6,124,232,0,128,64,20,0,63,131,254,255,0,57,
15,0,122,99,64,64,26,124,32,0,129,64,120,219,122,127,1,0,122,56,
237,209,2,72,0,0,25,44,120,27,125,124,104,0,130,65,68,0,0,72,
171,170,128,61,171,170,140,57,22,208,76,125,126,248,200,84,126,248,74,85,
64,64,10,124,20,0,128,64,254,255,8,32,64,0,6,124,8,0,129,65,
20,66,70,127,1,0,122,56,169,209,2,72,0,0,25,44,120,27,125,124,
36,0,130,65,24,0,63,129,16,0,9,40,120,235,163,127,120,227,132,127,
8,0,128,65,0,0,156,128,120,203,37,127,169,5,3,72,24,0,223,128,
16,0,6,40,12,0,128,65,0,0,124,128,13,211,2,72,16,0,26,40,
120,227,135,127,0,0,128,57,22,0,129,153,20,0,159,145,0,0,188,147,
24,0,95,147,8,0,128,65,120,235,167,127,0,0,27,44,0,0,96,57,
17,0,97,153,20,0,63,147,174,201,103,125,56,0,130,64,136,0,0,72,
0,0,27,44,36,0,130,64,16,0,6,40,120,227,135,127,8,0,128,65,
0,0,252,128,0,0,160,56,16,0,161,152,20,0,191,144,0,0,167,152,
0,0,27,44,88,0,130,65,24,0,255,128,16,0,7,40,120,227,131,127,
8,0,128,65,0,0,124,128,48,0,33,129,16,0,9,40,120,243,196,127,
8,0,128,65,0,0,158,128,120,219,101,127,245,4,3,72,24,0,95,129,
16,0,10,40,120,227,133,127,8,0,128,65,0,0,188,128,0,0,96,57,
18,0,97,153,20,0,127,147,174,217,101,125,12,0,128,61,216,87,140,129,
0,0,12,44,12,0,0,61,52,0,161,59,116,30,8,57,56,0,1,145,
20,0,130,65,120,235,163,127,166,3,137,125,33,4,128,78,56,0,1,129,
28,0,8,128,120,235,163,127,166,3,9,124,33,4,128,78,120,235,163,127,
237,194,2,72,24,0,63,129,16,0,9,40,12,0,128,65,0,0,124,128,
237,209,2,72,0,0,0,56,19,0,1,152,20,0,31,144,15,0,64,57,
24,0,95,145,0,0,28,152,48,0,1,128,16,0,0,40,12,0,128,65,
0,0,126,128,193,209,2,72,0,0,224,56,20,0,225,152,44,0,225,144,
15,0,192,56,48,0,193,144,0,0,254,152,112,0,193,131,104,0,129,131,
100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,
92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,0,0,12,44,
0,0,192,56,16,0,130,65,8,0,28,128,80,0,76,125,112,22,70,125,
20,218,166,124,64,40,31,124,88,2,128,64,126,248,232,87,80,72,200,124,
64,248,6,124,0,0,0,56,8,0,128,65,20,66,31,124,0,0,12,44,
120,3,31,124,0,0,64,57,16,0,130,65,8,0,28,128,80,0,236,124,
112,22,234,124,20,218,170,124,64,40,31,124,32,0,128,64,0,0,12,44,
0,0,160,56,16,0,130,65,8,0,252,128,80,56,204,124,112,22,197,124,
20,218,229,127,64,72,31,124,68,0,129,64,32,136,13,129,0,0,8,44,
48,0,130,64,1,0,32,57,32,136,45,145,11,0,64,61,80,106,74,57,
24,136,77,145,12,0,0,61,148,30,8,57,28,136,13,145,12,0,96,60,
240,30,99,56,89,202,2,72,24,136,109,56,161,193,2,72,58,16,255,87,
120,251,227,127,5,207,2,72,4,0,60,129,120,27,122,124,80,240,9,124,
59,0,0,84,120,3,8,124,120,211,69,127,120,0,130,65,120,43,166,124,
80,48,73,125,64,64,10,124,120,67,10,125,64,0,129,65,1,0,10,40,
20,66,198,124,20,66,41,125,120,83,72,125,8,0,128,64,1,0,0,57,
166,3,9,125,255,255,233,140,255,255,230,156,248,255,0,66,20,2,5,125,
121,219,101,127,252,255,72,57,60,0,130,64,68,0,0,72,1,0,10,40,
255,255,198,56,255,255,41,57,8,0,128,64,1,0,64,57,166,3,73,125,
1,0,9,141,1,0,6,157,248,255,0,66,20,2,5,125,121,219,101,127,
252,255,72,57,16,0,130,65,255,255,165,52,4,0,170,151,248,255,130,64,
8,0,28,128,80,0,190,124,59,0,167,84,58,16,96,87,20,2,72,125,
112,0,130,65,80,80,222,124,64,56,6,124,120,59,224,124,60,0,129,65,
1,0,0,40,20,58,222,127,20,58,74,125,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,30,141,255,255,10,157,248,255,0,66,4,0,156,129,
0,0,12,44,0,0,160,56,72,0,130,65,56,0,0,72,1,0,0,40,
255,255,74,57,255,255,222,59,8,0,128,64,1,0,0,56,166,3,9,124,
1,0,62,141,1,0,42,157,248,255,0,66,4,0,156,129,0,0,12,44,
0,0,160,56,16,0,130,65,8,0,188,128,80,40,12,124,112,22,5,124,
4,0,124,128,0,0,3,44,20,42,123,127,8,0,130,65,73,207,2,72,
20,250,218,124,12,0,220,144,58,16,103,87,20,58,26,125,8,0,28,145,
4,0,92,147,112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,
116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,
120,0,33,56,32,0,128,78,8,0,188,128,80,40,30,124,112,22,6,124,
64,216,6,124,58,16,108,87,220,0,128,64,59,0,0,84,20,98,30,125,
120,243,202,127,140,0,130,65,80,64,42,125,64,0,9,124,120,3,5,124,
72,0,129,65,1,0,5,40,20,2,8,125,20,2,74,125,120,43,160,124,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,10,140,255,255,8,156,
248,255,0,66,8,0,188,128,80,40,30,124,112,22,6,124,81,216,70,125,
252,255,37,57,84,0,130,65,68,0,0,72,1,0,5,40,255,255,74,57,
120,43,169,124,255,255,8,57,8,0,128,64,1,0,32,57,166,3,41,125,
1,0,170,140,1,0,168,156,248,255,0,66,8,0,188,128,80,40,30,124,
112,22,6,124,81,216,70,125,252,255,37,57,16,0,130,65,255,255,74,53,
4,0,169,151,248,255,130,64,20,98,165,124,80,40,236,124,64,56,30,124,
8,0,188,144,116,1,130,65,0,0,190,147,4,0,222,59,64,56,30,124,
244,255,130,64,96,1,0,72,120,43,164,124,80,32,44,125,80,32,9,125,
59,0,0,85,120,3,8,124,120,75,38,125,144,0,130,65,120,43,171,124,
80,88,70,125,64,64,10,124,120,67,7,125,84,0,129,65,1,0,7,40,
20,66,107,125,120,59,234,124,20,66,198,124,8,0,128,64,1,0,64,57,
166,3,73,125,255,255,230,140,255,255,235,156,248,255,0,66,20,2,229,124,
8,0,252,144,80,72,62,125,112,22,32,125,58,16,10,84,59,16,0,84,
80,32,234,124,120,243,200,127,196,0,130,65,80,0,0,72,1,0,7,40,
255,255,198,56,120,59,232,124,255,255,107,57,8,0,128,64,1,0,0,57,
166,3,9,125,1,0,70,141,1,0,75,157,248,255,0,66,20,2,229,124,
8,0,252,144,80,72,62,125,112,22,32,125,58,16,10,84,59,16,0,84,
80,32,234,124,120,243,200,127,116,0,130,65,80,56,168,124,64,0,5,124,
120,3,6,124,64,0,129,65,1,0,6,40,20,2,231,124,20,2,8,125,
120,51,192,124,8,0,128,64,1,0,0,56,166,3,9,124,255,255,200,140,
255,255,199,156,248,255,0,66,120,243,198,127,20,98,254,124,64,56,6,124,
76,0,130,65,56,0,0,72,1,0,6,40,255,255,231,56,255,255,8,57,
8,0,128,64,1,0,192,56,166,3,201,124,1,0,200,140,1,0,199,156,
248,255,0,66,120,243,198,127,20,98,254,124,64,56,6,124,20,0,130,65,
0,0,166,147,4,0,198,56,64,56,6,124,244,255,130,64,112,0,193,131,
104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,
96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,
136,255,33,148,116,0,225,147,121,35,159,124,92,0,33,147,96,0,65,147,
100,0,97,147,104,0,129,147,108,0,161,147,166,2,8,124,124,0,1,144,
112,0,193,147,120,27,126,124,0,0,64,57,4,0,94,145,12,0,94,145,
8,0,94,145,52,0,130,64,112,0,193,131,100,0,97,131,104,0,129,131,
116,0,225,131,108,0,161,131,96,0,65,131,124,0,1,128,92,0,33,131,
0,0,96,56,166,3,8,124,120,0,33,56,32,0,128,78,255,63,0,60,
255,255,0,96,64,0,31,124,132,8,129,64,15,0,224,56,48,0,225,144,
0,0,0,56,8,0,1,152,44,0,1,144,28,0,193,59,28,0,1,152,
11,0,128,63,116,106,156,59,255,255,92,57,1,0,234,140,117,7,231,124,
248,255,130,64,48,0,1,129,16,0,8,40,80,80,124,127,120,243,192,127,
8,0,128,65,0,0,30,128,0,0,28,124,12,0,160,63,172,2,128,65,
16,0,8,40,120,243,197,127,8,0,128,65,0,0,190,128,44,0,65,129,
20,82,5,124,0,224,0,124,140,2,129,64,16,0,8,40,120,243,198,127,
8,0,128,65,0,0,222,128,80,224,230,127,64,248,10,124,16,0,128,64,
24,0,97,56,169,192,2,72,44,0,65,129,80,80,223,124,64,48,27,124,
8,0,128,64,120,219,102,127,212,87,125,131,20,50,159,127,64,224,10,124,
120,219,125,127,16,0,128,64,24,0,97,56,121,192,2,72,44,0,65,129,
80,80,28,124,64,232,0,124,8,0,128,64,120,3,29,124,0,0,29,44,
232,0,130,65,48,0,1,129,16,0,8,40,120,243,199,127,8,0,128,65,
0,0,254,128,16,0,8,40,20,226,199,124,120,243,201,127,8,0,128,65,
0,0,62,129,81,0,29,124,20,226,233,124,120,3,9,124,20,234,231,124,
132,0,130,65,80,48,7,125,64,72,8,124,72,0,129,65,1,0,0,40,
20,74,198,124,20,74,231,124,120,3,9,124,8,0,128,64,1,0,32,57,
166,3,41,125,255,255,167,140,255,255,166,156,248,255,0,66,48,0,1,129,
16,0,8,40,44,0,65,129,80,80,29,124,120,243,201,127,76,0,128,65,
68,0,0,72,1,0,0,40,255,255,231,56,120,3,5,124,255,255,198,56,
8,0,128,64,1,0,160,56,166,3,169,124,1,0,7,140,1,0,6,156,
248,255,0,66,48,0,1,129,44,0,65,129,16,0,8,40,80,80,29,124,
120,243,201,127,8,0,128,65,0,0,62,129,0,0,96,57,9,0,97,153,
44,0,1,144,174,1,105,125,44,0,65,129,64,248,10,124,8,0,128,64,
120,83,95,125,0,0,31,44,236,2,130,65,48,0,1,129,16,0,8,40,
120,243,201,127,8,0,128,65,0,0,62,129,16,0,8,40,120,243,199,127,
8,0,128,65,0,0,254,128,80,80,31,124,121,3,10,124,120,83,76,125,
20,250,167,124,136,0,130,65,80,72,197,124,64,96,6,124,72,0,129,65,
1,0,10,40,20,98,41,125,120,83,64,125,20,98,165,124,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,5,140,255,255,9,156,248,255,0,66,
48,0,1,129,16,0,8,40,44,0,65,129,80,80,31,124,120,243,202,127,
76,0,128,65,68,0,0,72,1,0,10,40,255,255,165,56,120,83,71,125,
255,255,41,57,8,0,128,64,1,0,224,56,166,3,233,124,1,0,5,141,
1,0,9,157,248,255,0,66,44,0,65,129,48,0,1,129,80,80,31,124,
16,0,8,40,120,243,202,127,8,0,128,65,0,0,94,129,0,0,32,57,
10,0,33,153,44,0,1,144,174,1,42,125,44,0,65,131,120,219,96,127,
64,208,0,124,14,0,33,153,64,0,129,59,208,134,162,56,52,0,161,144,
12,0,192,60,84,30,198,56,56,0,193,144,15,0,0,57,80,0,33,145,
60,0,161,59,64,0,33,153,84,0,1,145,20,2,128,65,20,2,0,72,
254,255,0,56,64,0,27,124,16,0,129,64,24,0,97,56,21,192,2,72,
48,0,1,129,64,216,8,124,232,0,128,64,44,0,65,131,254,255,0,56,
15,0,121,99,64,0,25,124,32,0,129,64,120,219,121,127,1,0,121,56,
37,199,2,72,0,0,26,44,120,27,127,124,72,0,130,64,100,0,0,72,
171,170,128,61,171,170,140,57,22,200,204,124,126,248,0,85,126,248,198,84,
64,0,6,124,20,0,128,64,254,255,224,32,64,56,8,124,8,0,129,65,
20,2,40,127,1,0,121,56,225,198,2,72,0,0,26,44,120,27,127,124,
36,0,130,65,48,0,161,128,16,0,5,40,120,251,227,127,120,243,196,127,
8,0,128,65,0,0,158,128,120,211,69,127,225,250,2,72,48,0,193,128,
16,0,6,40,12,0,128,65,0,0,126,128,69,200,2,72,16,0,25,40,
48,0,33,147,120,243,202,127,0,0,254,147,0,0,128,57,44,0,129,145,
21,0,129,153,8,0,128,65,120,251,234,127,0,0,27,44,0,0,96,57,
12,0,97,153,44,0,65,147,174,209,106,125,56,0,130,65,128,0,0,72,
0,0,27,44,36,0,130,64,16,0,8,40,120,243,199,127,8,0,128,65,
0,0,254,128,0,0,0,56,11,0,1,152,44,0,1,144,0,0,7,152,
0,0,27,44,80,0,130,64,44,0,65,131,212,87,125,131,120,219,96,127,
64,208,0,124,0,0,32,57,14,0,33,153,64,0,129,59,208,134,162,56,
52,0,161,144,12,0,192,60,84,30,198,56,15,0,0,57,80,0,33,145,
60,0,161,59,64,0,33,153,84,0,1,145,56,0,193,144,148,0,128,65,
148,0,0,72,48,0,225,128,16,0,7,40,120,243,195,127,8,0,128,65,
0,0,126,128,120,227,132,127,120,219,101,127,241,249,2,72,48,0,1,129,
16,0,8,40,120,243,199,127,8,0,128,65,0,0,254,128,0,0,96,57,
13,0,97,153,44,0,97,147,174,217,103,125,212,87,125,131,44,0,65,131,
120,219,96,127,64,208,0,124,0,0,32,57,14,0,33,153,64,0,129,59,
208,134,162,56,52,0,161,144,12,0,192,60,84,30,198,56,56,0,193,144,
15,0,0,57,80,0,33,145,60,0,161,59,64,0,33,153,84,0,1,145,
8,0,128,64,120,3,26,124,24,0,1,56,64,0,29,124,56,1,130,64,
20,0,221,128,64,208,6,124,16,0,128,64,120,235,163,127,21,188,2,72,
20,0,221,128,80,48,90,125,64,216,10,124,8,0,128,64,120,83,91,125,
0,0,27,44,144,2,130,65,24,0,253,128,16,0,7,40,120,227,137,127,
8,0,128,65,0,0,60,129,16,0,7,40,20,210,41,125,120,227,133,127,
8,0,128,65,0,0,188,128,81,80,27,124,120,3,12,124,20,210,165,124,
20,218,69,125,132,0,130,65,80,72,10,125,64,96,8,124,72,0,129,65,
1,0,0,40,20,98,41,125,120,3,8,124,20,98,74,125,8,0,128,64,
1,0,0,57,166,3,9,125,255,255,10,140,255,255,9,156,248,255,0,66,
24,0,253,128,16,0,7,40,20,0,221,128,80,48,219,124,120,227,136,127,
76,0,128,65,68,0,0,72,1,0,0,40,255,255,74,57,120,3,6,124,
255,255,41,57,8,0,128,64,1,0,192,56,166,3,201,124,1,0,234,140,
1,0,233,156,248,255,0,66,24,0,253,128,20,0,221,128,16,0,7,40,
80,48,219,124,120,227,136,127,8,0,128,65,0,0,28,129,0,0,96,57,
15,0,97,153,20,0,221,144,174,49,104,125,12,0,128,61,216,87,140,129,
0,0,12,44,12,0,160,60,52,0,225,59,116,30,165,56,56,0,161,144,
192,1,130,65,172,1,0,72,254,255,0,57,64,64,26,124,12,0,129,64,
120,235,163,127,197,188,2,72,24,0,253,128,64,208,7,124,232,0,128,64,
20,0,125,131,254,255,0,56,15,0,89,99,64,0,25,124,32,0,129,64,
120,211,89,127,1,0,121,56,213,195,2,72,0,0,27,44,120,27,127,124,
104,0,130,65,68,0,0,72,171,170,128,61,171,170,140,57,22,200,12,124,
126,248,232,84,126,248,0,84,64,64,0,124,20,0,128,64,254,255,8,32,
64,0,7,124,8,0,129,65,20,66,39,127,1,0,121,56,145,195,2,72,
0,0,27,44,120,27,127,124,36,0,130,65,24,0,221,128,16,0,6,40,
120,251,227,127,120,227,132,127,8,0,128,65,0,0,156,128,120,219,101,127,
145,247,2,72,24,0,29,129,16,0,8,40,12,0,128,65,0,0,124,128,
245,196,2,72,16,0,25,40,120,227,138,127,0,0,128,57,22,0,129,153,
20,0,157,145,0,0,252,147,24,0,61,147,8,0,128,65,120,251,234,127,
0,0,26,44,0,0,96,57,17,0,97,153,20,0,125,147,174,217,106,125,
56,0,130,64,136,0,0,72,0,0,26,44,36,0,130,64,16,0,7,40,
120,227,138,127,8,0,128,65,0,0,92,129,0,0,160,56,16,0,161,152,
20,0,189,144,0,0,170,152,0,0,26,44,88,0,130,65,24,0,29,129,
16,0,8,40,120,227,131,127,8,0,128,65,0,0,124,128,48,0,1,128,
16,0,0,40,120,243,196,127,8,0,128,65,0,0,158,128,120,211,69,127,
221,246,2,72,24,0,221,128,16,0,6,40,120,227,134,127,8,0,128,65,
0,0,220,128,0,0,96,57,18,0,97,153,20,0,93,147,174,209,102,125,
12,0,128,61,216,87,140,129,0,0,12,44,12,0,160,60,52,0,225,59,
116,30,165,56,56,0,161,144,20,0,130,65,120,251,227,127,166,3,137,125,
33,4,128,78,56,0,161,128,28,0,5,128,120,251,227,127,166,3,9,124,
33,4,128,78,120,251,227,127,213,180,2,72,24,0,29,128,16,0,0,40,
12,0,128,65,0,0,124,128,213,195,2,72,0,0,0,56,19,0,1,152,
20,0,29,144,15,0,64,57,24,0,93,145,0,0,28,152,48,0,1,129,
16,0,8,40,12,0,128,65,0,0,126,128,169,195,2,72,0,0,0,56,
20,0,1,152,44,0,1,144,15,0,32,57,48,0,33,145,0,0,30,152,
1,0,96,56,36,0,0,72,58,16,227,87,221,193,2,72,58,16,233,87,
20,74,67,125,12,0,94,145,4,0,126,144,8,0,126,144,1,0,96,56,
112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,
124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,
32,0,128,78,136,255,33,148,92,0,33,147,96,0,65,147,100,0,97,147,
104,0,129,147,108,0,161,147,112,0,193,147,116,0,225,147,166,2,8,124,
124,0,1,144,0,0,166,131,120,27,124,124,4,0,156,129,0,0,12,44,
0,0,196,131,0,0,224,59,120,43,187,124,0,64,32,61,255,255,41,57,
16,0,130,65,12,0,188,128,80,40,12,124,112,22,31,124,0,0,27,44,
136,13,130,65,0,0,12,44,0,0,224,56,16,0,130,65,8,0,252,128,
80,56,204,124,112,22,199,124,80,72,7,125,64,216,8,124,160,8,128,64,
15,0,0,56,48,0,1,144,0,0,160,56,8,0,161,152,44,0,161,144,
28,0,193,59,28,0,161,152,11,0,96,63,152,106,123,59,255,255,59,57,
1,0,233,140,117,7,231,124,248,255,130,64,48,0,97,129,16,0,11,40,
80,72,155,127,120,243,202,127,8,0,128,65,0,0,94,129,0,80,27,124,
12,0,160,63,168,2,128,65,16,0,11,40,120,243,199,127,8,0,128,65,
0,0,254,128,44,0,129,129,20,98,7,124,0,216,0,124,136,2,129,64,
16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,80,216,229,127,
64,248,12,124,16,0,128,64,24,0,97,56,85,183,2,72,44,0,129,129,
80,96,255,124,64,56,28,124,8,0,128,64,120,227,135,127,212,87,189,131,
20,58,127,127,64,216,12,124,120,235,188,127,16,0,128,64,24,0,97,56,
37,183,2,72,44,0,129,129,80,96,27,124,64,224,0,124,8,0,128,64,
120,3,28,124,0,0,28,44,232,0,130,65,48,0,97,129,16,0,11,40,
120,243,199,127,8,0,128,65,0,0,254,128,16,0,11,40,20,218,71,125,
120,243,201,127,8,0,128,65,0,0,62,129,81,0,28,124,20,218,201,124,
120,3,9,124,20,226,166,124,132,0,130,65,80,80,229,124,64,72,7,124,
72,0,129,65,1,0,0,40,20,74,74,125,120,3,6,124,20,74,165,124,
8,0,128,64,1,0,192,56,166,3,201,124,255,255,37,141,255,255,42,157,
248,255,0,66,48,0,97,129,16,0,11,40,44,0,129,129,80,96,92,125,
120,243,200,127,76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,
120,3,8,124,255,255,74,57,8,0,128,64,1,0,0,57,166,3,9,125,
1,0,5,140,1,0,10,156,248,255,0,66,48,0,97,129,44,0,129,129,
16,0,11,40,80,96,92,125,120,243,200,127,8,0,128,65,0,0,30,129,
0,0,96,57,9,0,97,153,44,0,65,145,174,81,104,125,44,0,129,129,
64,248,12,124,8,0,128,64,120,99,159,125,0,0,31,44,232,2,130,65,
48,0,97,129,16,0,11,40,120,243,202,127,8,0,128,65,0,0,94,129,
16,0,11,40,120,243,201,127,8,0,128,65,0,0,62,129,80,96,31,124,
121,3,8,124,120,67,5,125,20,250,233,124,132,0,130,65,80,80,199,124,
64,40,6,124,68,0,129,65,1,0,8,40,20,42,231,124,20,42,74,125,
8,0,128,64,1,0,0,57,166,3,9,125,255,255,39,141,255,255,42,157,
248,255,0,66,48,0,97,129,16,0,11,40,44,0,129,129,120,243,197,127,
80,96,31,124,76,0,128,65,68,0,0,72,1,0,8,40,255,255,231,56,
120,67,0,125,255,255,74,57,8,0,128,64,1,0,0,56,166,3,9,124,
1,0,7,140,1,0,10,156,248,255,0,66,44,0,129,129,48,0,97,129,
80,96,31,124,16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,
0,0,96,57,10,0,97,153,44,0,1,144,174,1,101,125,44,0,97,131,
216,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,14,0,97,153,
64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,64,0,97,153,
15,0,0,56,80,0,97,145,60,0,225,59,84,0,1,144,20,2,128,65,
20,2,0,72,254,255,224,56,64,56,28,124,16,0,129,64,24,0,97,56,
197,182,2,72,48,0,97,129,64,224,11,124,232,0,128,64,44,0,65,131,
254,255,32,57,15,0,153,99,64,72,25,124,32,0,129,64,120,227,153,127,
1,0,121,56,213,189,2,72,0,0,26,44,120,27,127,124,72,0,130,64,
100,0,0,72,171,170,128,61,171,170,140,57,22,200,76,125,126,248,105,85,
126,248,74,85,64,72,10,124,20,0,128,64,254,255,9,32,64,0,11,124,
8,0,129,65,20,74,43,127,1,0,121,56,145,189,2,72,0,0,26,44,
120,27,127,124,36,0,130,65,48,0,161,128,16,0,5,40,120,251,227,127,
120,243,196,127,8,0,128,65,0,0,158,128,120,211,69,127,145,241,2,72,
48,0,1,128,16,0,0,40,12,0,128,65,0,0,126,128,245,190,2,72,
16,0,25,40,48,0,33,147,120,243,202,127,0,0,254,147,0,0,128,57,
44,0,129,145,21,0,129,153,8,0,128,65,120,251,234,127,0,0,28,44,
0,0,96,57,12,0,97,153,44,0,65,147,174,209,106,125,56,0,130,65,
128,0,0,72,0,0,28,44,36,0,130,64,16,0,11,40,120,243,197,127,
8,0,128,65,0,0,190,128,0,0,192,56,11,0,193,152,44,0,193,144,
0,0,197,152,0,0,28,44,80,0,130,64,44,0,97,131,212,87,189,131,
216,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,0,0,160,56,
14,0,161,152,64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,
64,0,161,152,15,0,0,56,80,0,161,144,60,0,225,59,84,0,1,144,
148,0,128,65,148,0,0,72,48,0,1,129,16,0,8,40,120,243,195,127,
8,0,128,65,0,0,126,128,120,219,100,127,120,227,133,127,161,240,2,72,
48,0,1,128,16,0,0,40,120,243,199,127,8,0,128,65,0,0,254,128,
0,0,96,57,13,0,97,153,44,0,129,147,174,225,103,125,212,87,189,131,
44,0,97,131,216,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,
0,0,160,56,14,0,161,152,64,0,129,59,12,0,32,61,84,30,41,57,
56,0,33,145,64,0,161,152,15,0,0,56,80,0,161,144,60,0,225,59,
84,0,1,144,8,0,128,64,120,67,27,125,24,0,1,56,64,0,31,124,
52,1,130,64,20,0,255,128,64,216,7,124,16,0,128,64,120,251,227,127,
197,178,2,72,20,0,255,128,80,56,27,124,64,232,0,124,8,0,128,64,
120,3,29,124,0,0,29,44,140,2,130,65,24,0,223,128,16,0,6,40,
120,227,138,127,8,0,128,65,0,0,92,129,16,0,6,40,20,218,42,125,
120,227,136,127,8,0,128,65,0,0,28,129,81,0,29,124,20,218,168,124,
120,3,8,124,20,234,165,124,128,0,130,65,80,72,197,124,64,64,6,124,
68,0,129,65,1,0,0,40,20,66,165,124,20,66,41,125,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,229,140,255,255,233,156,248,255,0,66,
24,0,223,128,16,0,6,40,20,0,255,128,80,56,61,125,120,227,134,127,
76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,120,3,6,124,
255,255,41,57,8,0,128,64,1,0,192,56,166,3,201,124,1,0,5,140,
1,0,9,156,248,255,0,66,24,0,223,128,20,0,255,128,16,0,6,40,
80,56,61,125,120,227,134,127,8,0,128,65,0,0,220,128,0,0,96,57,
15,0,97,153,20,0,63,145,174,73,102,125,12,0,128,61,216,87,140,129,
0,0,12,44,12,0,0,61,52,0,161,59,116,30,8,57,56,0,1,145,
192,1,130,65,172,1,0,72,254,255,192,56,64,48,27,124,12,0,129,64,
120,251,227,127,121,179,2,72,24,0,223,128,64,216,6,124,232,0,128,64,
20,0,63,131,254,255,0,57,15,0,122,99,64,64,26,124,32,0,129,64,
120,219,122,127,1,0,122,56,137,186,2,72,0,0,25,44,120,27,125,124,
104,0,130,65,68,0,0,72,171,170,128,61,171,170,140,57,22,208,76,125,
126,248,200,84,126,248,74,85,64,64,10,124,20,0,128,64,254,255,8,32,
64,0,6,124,8,0,129,65,20,66,70,127,1,0,122,56,69,186,2,72,
0,0,25,44,120,27,125,124,36,0,130,65,24,0,63,129,16,0,9,40,
120,235,163,127,120,227,132,127,8,0,128,65,0,0,156,128,120,203,37,127,
69,238,2,72,24,0,223,128,16,0,6,40,12,0,128,65,0,0,124,128,
169,187,2,72,16,0,26,40,120,227,135,127,0,0,128,57,22,0,129,153,
20,0,159,145,0,0,188,147,24,0,95,147,8,0,128,65,120,235,167,127,
0,0,27,44,0,0,96,57,17,0,97,153,20,0,63,147,174,201,103,125,
56,0,130,64,136,0,0,72,0,0,27,44,36,0,130,64,16,0,6,40,
120,227,135,127,8,0,128,65,0,0,252,128,0,0,160,56,16,0,161,152,
20,0,191,144,0,0,167,152,0,0,27,44,88,0,130,65,24,0,255,128,
16,0,7,40,120,227,131,127,8,0,128,65,0,0,124,128,48,0,33,129,
16,0,9,40,120,243,196,127,8,0,128,65,0,0,158,128,120,219,101,127,
145,237,2,72,24,0,95,129,16,0,10,40,120,227,133,127,8,0,128,65,
0,0,188,128,0,0,96,57,18,0,97,153,20,0,127,147,174,217,101,125,
12,0,128,61,216,87,140,129,0,0,12,44,12,0,0,61,52,0,161,59,
116,30,8,57,56,0,1,145,20,0,130,65,120,235,163,127,166,3,137,125,
33,4,128,78,56,0,1,129,28,0,8,128,120,235,163,127,166,3,9,124,
33,4,128,78,120,235,163,127,137,171,2,72,24,0,63,129,16,0,9,40,
12,0,128,65,0,0,124,128,137,186,2,72,0,0,0,56,19,0,1,152,
20,0,31,144,15,0,64,57,24,0,95,145,0,0,28,152,48,0,1,128,
16,0,0,40,12,0,128,65,0,0,126,128,93,186,2,72,0,0,224,56,
20,0,225,152,44,0,225,144,15,0,192,56,48,0,193,144,0,0,254,152,
112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,
124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,
32,0,128,78,0,0,12,44,0,0,192,56,16,0,130,65,8,0,28,128,
80,0,76,125,112,22,70,125,20,218,166,124,64,40,31,124,88,2,128,64,
126,248,232,87,80,72,200,124,64,248,6,124,0,0,0,56,8,0,128,65,
20,66,31,124,0,0,12,44,120,3,31,124,0,0,64,57,16,0,130,65,
8,0,28,128,80,0,236,124,112,22,234,124,20,218,170,124,64,40,31,124,
32,0,128,64,0,0,12,44,0,0,160,56,16,0,130,65,8,0,252,128,
80,56,204,124,112,22,197,124,20,218,229,127,64,72,31,124,68,0,129,64,
20,136,13,129,0,0,8,44,48,0,130,64,1,0,32,57,20,136,45,145,
11,0,64,61,136,106,74,57,12,136,77,145,12,0,0,61,148,30,8,57,
16,136,13,145,12,0,96,60,252,30,99,56,245,178,2,72,12,136,109,56,
61,170,2,72,58,16,255,87,120,251,227,127,161,183,2,72,4,0,60,129,
120,27,122,124,80,240,9,124,59,0,0,84,120,3,8,124,120,211,69,127,
120,0,130,65,120,43,166,124,80,48,73,125,64,64,10,124,120,67,10,125,
64,0,129,65,1,0,10,40,20,66,198,124,20,66,41,125,120,83,72,125,
8,0,128,64,1,0,0,57,166,3,9,125,255,255,233,140,255,255,230,156,
248,255,0,66,20,2,5,125,121,219,101,127,252,255,72,57,60,0,130,64,
68,0,0,72,1,0,10,40,255,255,198,56,255,255,41,57,8,0,128,64,
1,0,64,57,166,3,73,125,1,0,9,141,1,0,6,157,248,255,0,66,
20,2,5,125,121,219,101,127,252,255,72,57,16,0,130,65,255,255,165,52,
4,0,170,151,248,255,130,64,8,0,28,128,80,0,190,124,59,0,167,84,
58,16,96,87,20,2,72,125,112,0,130,65,80,80,222,124,64,56,6,124,
120,59,224,124,60,0,129,65,1,0,0,40,20,58,222,127,20,58,74,125,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,30,141,255,255,10,157,
248,255,0,66,4,0,156,129,0,0,12,44,0,0,160,56,72,0,130,65,
56,0,0,72,1,0,0,40,255,255,74,57,255,255,222,59,8,0,128,64,
1,0,0,56,166,3,9,124,1,0,62,141,1,0,42,157,248,255,0,66,
4,0,156,129,0,0,12,44,0,0,160,56,16,0,130,65,8,0,188,128,
80,40,12,124,112,22,5,124,4,0,124,128,0,0,3,44,20,42,123,127,
8,0,130,65,229,183,2,72,20,250,218,124,12,0,220,144,58,16,103,87,
20,58,26,125,8,0,28,145,4,0,92,147,112,0,193,131,104,0,129,131,
100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,
92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,8,0,188,128,
80,40,30,124,112,22,6,124,64,216,6,124,58,16,108,87,220,0,128,64,
59,0,0,84,20,98,30,125,120,243,202,127,140,0,130,65,80,64,42,125,
64,0,9,124,120,3,5,124,72,0,129,65,1,0,5,40,20,2,8,125,
20,2,74,125,120,43,160,124,8,0,128,64,1,0,0,56,166,3,9,124,
255,255,10,140,255,255,8,156,248,255,0,66,8,0,188,128,80,40,30,124,
112,22,6,124,81,216,70,125,252,255,37,57,84,0,130,65,68,0,0,72,
1,0,5,40,255,255,74,57,120,43,169,124,255,255,8,57,8,0,128,64,
1,0,32,57,166,3,41,125,1,0,170,140,1,0,168,156,248,255,0,66,
8,0,188,128,80,40,30,124,112,22,6,124,81,216,70,125,252,255,37,57,
16,0,130,65,255,255,74,53,4,0,169,151,248,255,130,64,20,98,165,124,
80,40,236,124,64,56,30,124,8,0,188,144,116,1,130,65,0,0,190,147,
4,0,222,59,64,56,30,124,244,255,130,64,96,1,0,72,120,43,164,124,
80,32,44,125,80,32,9,125,59,0,0,85,120,3,8,124,120,75,38,125,
144,0,130,65,120,43,171,124,80,88,70,125,64,64,10,124,120,67,7,125,
84,0,129,65,1,0,7,40,20,66,107,125,120,59,234,124,20,66,198,124,
8,0,128,64,1,0,64,57,166,3,73,125,255,255,230,140,255,255,235,156,
248,255,0,66,20,2,229,124,8,0,252,144,80,72,62,125,112,22,32,125,
58,16,10,84,59,16,0,84,80,32,234,124,120,243,200,127,196,0,130,65,
80,0,0,72,1,0,7,40,255,255,198,56,120,59,232,124,255,255,107,57,
8,0,128,64,1,0,0,57,166,3,9,125,1,0,70,141,1,0,75,157,
248,255,0,66,20,2,229,124,8,0,252,144,80,72,62,125,112,22,32,125,
58,16,10,84,59,16,0,84,80,32,234,124,120,243,200,127,116,0,130,65,
80,56,168,124,64,0,5,124,120,3,6,124,64,0,129,65,1,0,6,40,
20,2,231,124,20,2,8,125,120,51,192,124,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,200,140,255,255,199,156,248,255,0,66,120,243,198,127,
20,98,254,124,64,56,6,124,76,0,130,65,56,0,0,72,1,0,6,40,
255,255,231,56,255,255,8,57,8,0,128,64,1,0,192,56,166,3,201,124,
1,0,200,140,1,0,199,156,248,255,0,66,120,243,198,127,20,98,254,124,
64,56,6,124,20,0,130,65,0,0,166,147,4,0,198,56,64,56,6,124,
244,255,130,64,112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,
116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,
120,0,33,56,32,0,128,78,136,255,33,148,92,0,33,147,96,0,65,147,
100,0,97,147,104,0,129,147,108,0,161,147,112,0,193,147,116,0,225,147,
166,2,8,124,124,0,1,144,0,0,166,131,120,27,124,124,4,0,156,129,
0,0,12,44,0,0,196,131,0,0,224,59,120,43,187,124,0,64,32,61,
255,255,41,57,16,0,130,65,12,0,188,128,80,40,12,124,112,22,31,124,
0,0,27,44,136,13,130,65,0,0,12,44,0,0,224,56,16,0,130,65,
8,0,252,128,80,56,204,124,112,22,199,124,80,72,7,125,64,216,8,124,
160,8,128,64,15,0,0,56,48,0,1,144,0,0,160,56,8,0,161,152,
44,0,161,144,28,0,193,59,28,0,161,152,11,0,96,63,208,106,123,59,
255,255,59,57,1,0,233,140,117,7,231,124,248,255,130,64,48,0,97,129,
16,0,11,40,80,72,155,127,120,243,202,127,8,0,128,65,0,0,94,129,
0,80,27,124,12,0,160,63,168,2,128,65,16,0,11,40,120,243,199,127,
8,0,128,65,0,0,254,128,44,0,129,129,20,98,7,124,0,216,0,124,
136,2,129,64,16,0,11,40,120,243,197,127,8,0,128,65,0,0,190,128,
80,216,229,127,64,248,12,124,16,0,128,64,24,0,97,56,65,169,2,72,
44,0,129,129,80,96,255,124,64,56,28,124,8,0,128,64,120,227,135,127,
212,87,189,131,20,58,127,127,64,216,12,124,120,235,188,127,16,0,128,64,
24,0,97,56,17,169,2,72,44,0,129,129,80,96,27,124,64,224,0,124,
8,0,128,64,120,3,28,124,0,0,28,44,232,0,130,65,48,0,97,129,
16,0,11,40,120,243,199,127,8,0,128,65,0,0,254,128,16,0,11,40,
20,218,71,125,120,243,201,127,8,0,128,65,0,0,62,129,81,0,28,124,
20,218,201,124,120,3,9,124,20,226,166,124,132,0,130,65,80,80,229,124,
64,72,7,124,72,0,129,65,1,0,0,40,20,74,74,125,120,3,6,124,
20,74,165,124,8,0,128,64,1,0,192,56,166,3,201,124,255,255,37,141,
255,255,42,157,248,255,0,66,48,0,97,129,16,0,11,40,44,0,129,129,
80,96,92,125,120,243,200,127,76,0,128,65,68,0,0,72,1,0,0,40,
255,255,165,56,120,3,8,124,255,255,74,57,8,0,128,64,1,0,0,57,
166,3,9,125,1,0,5,140,1,0,10,156,248,255,0,66,48,0,97,129,
44,0,129,129,16,0,11,40,80,96,92,125,120,243,200,127,8,0,128,65,
0,0,30,129,0,0,96,57,9,0,97,153,44,0,65,145,174,81,104,125,
44,0,129,129,64,248,12,124,8,0,128,64,120,99,159,125,0,0,31,44,
232,2,130,65,48,0,97,129,16,0,11,40,120,243,202,127,8,0,128,65,
0,0,94,129,16,0,11,40,120,243,201,127,8,0,128,65,0,0,62,129,
80,96,31,124,121,3,8,124,120,67,5,125,20,250,233,124,132,0,130,65,
80,80,199,124,64,40,6,124,68,0,129,65,1,0,8,40,20,42,231,124,
20,42,74,125,8,0,128,64,1,0,0,57,166,3,9,125,255,255,39,141,
255,255,42,157,248,255,0,66,48,0,97,129,16,0,11,40,44,0,129,129,
120,243,197,127,80,96,31,124,76,0,128,65,68,0,0,72,1,0,8,40,
255,255,231,56,120,67,0,125,255,255,74,57,8,0,128,64,1,0,0,56,
166,3,9,124,1,0,7,140,1,0,10,156,248,255,0,66,44,0,129,129,
48,0,97,129,80,96,31,124,16,0,11,40,120,243,197,127,8,0,128,65,
0,0,190,128,0,0,96,57,10,0,97,153,44,0,1,144,174,1,101,125,
44,0,97,131,232,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,
14,0,97,153,64,0,129,59,12,0,32,61,84,30,41,57,56,0,33,145,
64,0,97,153,15,0,0,56,80,0,97,145,60,0,225,59,84,0,1,144,
20,2,128,65,20,2,0,72,254,255,224,56,64,56,28,124,16,0,129,64,
24,0,97,56,177,168,2,72,48,0,97,129,64,224,11,124,232,0,128,64,
44,0,65,131,254,255,32,57,15,0,153,99,64,72,25,124,32,0,129,64,
120,227,153,127,1,0,121,56,193,175,2,72,0,0,26,44,120,27,127,124,
72,0,130,64,100,0,0,72,171,170,128,61,171,170,140,57,22,200,76,125,
126,248,105,85,126,248,74,85,64,72,10,124,20,0,128,64,254,255,9,32,
64,0,11,124,8,0,129,65,20,74,43,127,1,0,121,56,125,175,2,72,
0,0,26,44,120,27,127,124,36,0,130,65,48,0,161,128,16,0,5,40,
120,251,227,127,120,243,196,127,8,0,128,65,0,0,158,128,120,211,69,127,
125,227,2,72,48,0,1,128,16,0,0,40,12,0,128,65,0,0,126,128,
225,176,2,72,16,0,25,40,48,0,33,147,120,243,202,127,0,0,254,147,
0,0,128,57,44,0,129,145,21,0,129,153,8,0,128,65,120,251,234,127,
0,0,28,44,0,0,96,57,12,0,97,153,44,0,65,147,174,209,106,125,
56,0,130,65,128,0,0,72,0,0,28,44,36,0,130,64,16,0,11,40,
120,243,197,127,8,0,128,65,0,0,190,128,0,0,192,56,11,0,193,152,
44,0,193,144,0,0,197,152,0,0,28,44,80,0,130,64,44,0,97,131,
212,87,189,131,232,134,2,57,52,0,1,145,120,235,168,127,64,216,8,124,
0,0,160,56,14,0,161,152,64,0,129,59,12,0,32,61,84,30,41,57,
56,0,33,145,64,0,161,152,15,0,0,56,80,0,161,144,60,0,225,59,
84,0,1,144,148,0,128,65,148,0,0,72,48,0,1,129,16,0,8,40,
120,243,195,127,8,0,128,65,0,0,126,128,120,219,100,127,120,227,133,127,
141,226,2,72,48,0,1,128,16,0,0,40,120,243,199,127,8,0,128,65,
0,0,254,128,0,0,96,57,13,0,97,153,44,0,129,147,174,225,103,125,
212,87,189,131,44,0,97,131,232,134,2,57,52,0,1,145,120,235,168,127,
64,216,8,124,0,0,160,56,14,0,161,152,64,0,129,59,12,0,32,61,
84,30,41,57,56,0,33,145,64,0,161,152,15,0,0,56,80,0,161,144,
60,0,225,59,84,0,1,144,8,0,128,64,120,67,27,125,24,0,1,56,
64,0,31,124,52,1,130,64,20,0,255,128,64,216,7,124,16,0,128,64,
120,251,227,127,177,164,2,72,20,0,255,128,80,56,27,124,64,232,0,124,
8,0,128,64,120,3,29,124,0,0,29,44,140,2,130,65,24,0,223,128,
16,0,6,40,120,227,138,127,8,0,128,65,0,0,92,129,16,0,6,40,
20,218,42,125,120,227,136,127,8,0,128,65,0,0,28,129,81,0,29,124,
20,218,168,124,120,3,8,124,20,234,165,124,128,0,130,65,80,72,197,124,
64,64,6,124,68,0,129,65,1,0,0,40,20,66,165,124,20,66,41,125,
8,0,128,64,1,0,0,56,166,3,9,124,255,255,229,140,255,255,233,156,
248,255,0,66,24,0,223,128,16,0,6,40,20,0,255,128,80,56,61,125,
120,227,134,127,76,0,128,65,68,0,0,72,1,0,0,40,255,255,165,56,
120,3,6,124,255,255,41,57,8,0,128,64,1,0,192,56,166,3,201,124,
1,0,5,140,1,0,9,156,248,255,0,66,24,0,223,128,20,0,255,128,
16,0,6,40,80,56,61,125,120,227,134,127,8,0,128,65,0,0,220,128,
0,0,96,57,15,0,97,153,20,0,63,145,174,73,102,125,12,0,128,61,
216,87,140,129,0,0,12,44,12,0,0,61,52,0,161,59,116,30,8,57,
56,0,1,145,192,1,130,65,172,1,0,72,254,255,192,56,64,48,27,124,
12,0,129,64,120,251,227,127,101,165,2,72,24,0,223,128,64,216,6,124,
232,0,128,64,20,0,63,131,254,255,0,57,15,0,122,99,64,64,26,124,
32,0,129,64,120,219,122,127,1,0,122,56,117,172,2,72,0,0,25,44,
120,27,125,124,104,0,130,65,68,0,0,72,171,170,128,61,171,170,140,57,
22,208,76,125,126,248,200,84,126,248,74,85,64,64,10,124,20,0,128,64,
254,255,8,32,64,0,6,124,8,0,129,65,20,66,70,127,1,0,122,56,
49,172,2,72,0,0,25,44,120,27,125,124,36,0,130,65,24,0,63,129,
16,0,9,40,120,235,163,127,120,227,132,127,8,0,128,65,0,0,156,128,
120,203,37,127,49,224,2,72,24,0,223,128,16,0,6,40,12,0,128,65,
0,0,124,128,149,173,2,72,16,0,26,40,120,227,135,127,0,0,128,57,
22,0,129,153,20,0,159,145,0,0,188,147,24,0,95,147,8,0,128,65,
120,235,167,127,0,0,27,44,0,0,96,57,17,0,97,153,20,0,63,147,
174,201,103,125,56,0,130,64,136,0,0,72,0,0,27,44,36,0,130,64,
16,0,6,40,120,227,135,127,8,0,128,65,0,0,252,128,0,0,160,56,
16,0,161,152,20,0,191,144,0,0,167,152,0,0,27,44,88,0,130,65,
24,0,255,128,16,0,7,40,120,227,131,127,8,0,128,65,0,0,124,128,
48,0,33,129,16,0,9,40,120,243,196,127,8,0,128,65,0,0,158,128,
120,219,101,127,125,223,2,72,24,0,95,129,16,0,10,40,120,227,133,127,
8,0,128,65,0,0,188,128,0,0,96,57,18,0,97,153,20,0,127,147,
174,217,101,125,12,0,128,61,216,87,140,129,0,0,12,44,12,0,0,61,
52,0,161,59,116,30,8,57,56,0,1,145,20,0,130,65,120,235,163,127,
166,3,137,125,33,4,128,78,56,0,1,129,28,0,8,128,120,235,163,127,
166,3,9,124,33,4,128,78,120,235,163,127,117,157,2,72,24,0,63,129,
16,0,9,40,12,0,128,65,0,0,124,128,117,172,2,72,0,0,0,56,
19,0,1,152,20,0,31,144,15,0,64,57,24,0,95,145,0,0,28,152,
48,0,1,128,16,0,0,40,12,0,128,65,0,0,126,128,73,172,2,72,
0,0,224,56,20,0,225,152,44,0,225,144,15,0,192,56,48,0,193,144,
0,0,254,152,112,0,193,131,104,0,129,131,100,0,97,131,108,0,161,131,
116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,166,3,8,124,
120,0,33,56,32,0,128,78,0,0,12,44,0,0,192,56,16,0,130,65,
8,0,28,128,80,0,76,125,112,22,70,125,20,218,166,124,64,40,31,124,
88,2,128,64,126,248,232,87,80,72,200,124,64,248,6,124,0,0,0,56,
8,0,128,65,20,66,31,124,0,0,12,44,120,3,31,124,0,0,64,57,
16,0,130,65,8,0,28,128,80,0,236,124,112,22,234,124,20,218,170,124,
64,40,31,124,32,0,128,64,0,0,12,44,0,0,160,56,16,0,130,65,
8,0,252,128,80,56,204,124,112,22,197,124,20,218,229,127,64,72,31,124,
68,0,129,64,8,136,13,129,0,0,8,44,48,0,130,64,1,0,32,57,
8,136,45,145,11,0,64,61,192,106,74,57,0,136,77,145,12,0,0,61,
148,30,8,57,4,136,13,145,12,0,96,60,8,31,99,56,225,164,2,72,
0,136,109,56,41,156,2,72,58,16,255,87,120,251,227,127,141,169,2,72,
4,0,60,129,120,27,122,124,80,240,9,124,59,0,0,84,120,3,8,124,
120,211,69,127,120,0,130,65,120,43,166,124,80,48,73,125,64,64,10,124,
120,67,10,125,64,0,129,65,1,0,10,40,20,66,198,124,20,66,41,125,
120,83,72,125,8,0,128,64,1,0,0,57,166,3,9,125,255,255,233,140,
255,255,230,156,248,255,0,66,20,2,5,125,121,219,101,127,252,255,72,57,
60,0,130,64,68,0,0,72,1,0,10,40,255,255,198,56,255,255,41,57,
8,0,128,64,1,0,64,57,166,3,73,125,1,0,9,141,1,0,6,157,
248,255,0,66,20,2,5,125,121,219,101,127,252,255,72,57,16,0,130,65,
255,255,165,52,4,0,170,151,248,255,130,64,8,0,28,128,80,0,190,124,
59,0,167,84,58,16,96,87,20,2,72,125,112,0,130,65,80,80,222,124,
64,56,6,124,120,59,224,124,60,0,129,65,1,0,0,40,20,58,222,127,
20,58,74,125,8,0,128,64,1,0,0,56,166,3,9,124,255,255,30,141,
255,255,10,157,248,255,0,66,4,0,156,129,0,0,12,44,0,0,160,56,
72,0,130,65,56,0,0,72,1,0,0,40,255,255,74,57,255,255,222,59,
8,0,128,64,1,0,0,56,166,3,9,124,1,0,62,141,1,0,42,157,
248,255,0,66,4,0,156,129,0,0,12,44,0,0,160,56,16,0,130,65,
8,0,188,128,80,40,12,124,112,22,5,124,4,0,124,128,0,0,3,44,
20,42,123,127,8,0,130,65,209,169,2,72,20,250,218,124,12,0,220,144,
58,16,103,87,20,58,26,125,8,0,28,145,4,0,92,147,112,0,193,131,
104,0,129,131,100,0,97,131,108,0,161,131,116,0,225,131,124,0,1,128,
96,0,65,131,92,0,33,131,166,3,8,124,120,0,33,56,32,0,128,78,
8,0,188,128,80,40,30,124,112,22,6,124,64,216,6,124,58,16,108,87,
220,0,128,64,59,0,0,84,20,98,30,125,120,243,202,127,140,0,130,65,
80,64,42,125,64,0,9,124,120,3,5,124,72,0,129,65,1,0,5,40,
20,2,8,125,20,2,74,125,120,43,160,124,8,0,128,64,1,0,0,56,
166,3,9,124,255,255,10,140,255,255,8,156,248,255,0,66,8,0,188,128,
80,40,30,124,112,22,6,124,81,216,70,125,252,255,37,57,84,0,130,65,
68,0,0,72,1,0,5,40,255,255,74,57,120,43,169,124,255,255,8,57,
8,0,128,64,1,0,32,57,166,3,41,125,1,0,170,140,1,0,168,156,
248,255,0,66,8,0,188,128,80,40,30,124,112,22,6,124,81,216,70,125,
252,255,37,57,16,0,130,65,255,255,74,53,4,0,169,151,248,255,130,64,
20,98,165,124,80,40,236,124,64,56,30,124,8,0,188,144,116,1,130,65,
0,0,190,147,4,0,222,59,64,56,30,124,244,255,130,64,96,1,0,72,
120,43,164,124,80,32,44,125,80,32,9,125,59,0,0,85,120,3,8,124,
120,75,38,125,144,0,130,65,120,43,171,124,80,88,70,125,64,64,10,124,
120,67,7,125,84,0,129,65,1,0,7,40,20,66,107,125,120,59,234,124,
20,66,198,124,8,0,128,64,1,0,64,57,166,3,73,125,255,255,230,140,
255,255,235,156,248,255,0,66,20,2,229,124,8,0,252,144,80,72,62,125,
112,22,32,125,58,16,10,84,59,16,0,84,80,32,234,124,120,243,200,127,
196,0,130,65,80,0,0,72,1,0,7,40,255,255,198,56,120,59,232,124,
255,255,107,57,8,0,128,64,1,0,0,57,166,3,9,125,1,0,70,141,
1,0,75,157,248,255,0,66,20,2,229,124,8,0,252,144,80,72,62,125,
112,22,32,125,58,16,10,84,59,16,0,84,80,32,234,124,120,243,200,127,
116,0,130,65,80,56,168,124,64,0,5,124,120,3,6,124,64,0,129,65,
1,0,6,40,20,2,231,124,20,2,8,125,120,51,192,124,8,0,128,64,
1,0,0,56,166,3,9,124,255,255,200,140,255,255,199,156,248,255,0,66,
120,243,198,127,20,98,254,124,64,56,6,124,76,0,130,65,56,0,0,72,
1,0,6,40,255,255,231,56,255,255,8,57,8,0,128,64,1,0,192,56,
166,3,201,124,1,0,200,140,1,0,199,156,248,255,0,66,120,243,198,127,
20,98,254,124,64,56,6,124,20,0,130,65,0,0,166,147,4,0,198,56,
64,56,6,124,244,255,130,64,112,0,193,131,104,0,129,131,100,0,97,131,
108,0,161,131,116,0,225,131,124,0,1,128,96,0,65,131,92,0,33,131,
166,3,8,124,120,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,4,0,99,128,165,47,255,75,12,0,1,128,8,0,33,56,
166,3,8,124,116,7,99,124,32,0,128,78,0,0,3,44,32,0,130,77,
255,7,128,84,32,0,130,77,216,166,2,72,2,4,96,56,32,0,128,78,
2,4,96,56,32,0,128,78,128,255,96,56,32,0,128,78,0,0,3,44,
32,0,130,77,255,7,128,84,32,0,130,77,172,166,2,72,232,255,33,148,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,8,0,129,147,
4,0,131,59,16,0,193,147,58,16,190,84,46,240,92,125,0,0,10,44,
120,35,157,124,124,0,130,64,0,0,29,128,4,0,125,128,126,7,4,84,
254,239,5,84,217,49,255,75,121,27,127,124,100,0,130,64,46,241,188,127,
0,0,29,128,57,7,0,84,84,0,130,64,167,128,45,137,0,0,9,44,
40,0,130,65,20,0,225,131,16,0,193,131,12,0,161,131,28,0,1,128,
8,0,129,131,0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
0,0,29,128,4,0,125,128,0,0,128,56,254,223,6,84,126,7,5,84,
133,50,255,75,8,0,0,72,3,4,224,59,120,251,227,127,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,8,0,129,147,121,27,124,124,12,0,161,147,
120,35,157,124,68,0,130,65,12,0,0,60,128,33,0,48,0,0,28,144,
6,0,192,59,120,227,159,127,4,0,31,132,0,0,0,44,12,0,130,65,
120,3,3,124,137,165,2,72,255,255,222,55,232,255,130,64,255,7,160,87,
12,0,130,65,120,227,131,127,113,165,2,72,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,0,0,3,44,
20,0,130,64,28,0,96,56,145,163,2,72,0,0,3,44,40,0,130,65,
120,27,108,124,0,0,64,57,12,0,0,60,128,33,0,48,0,0,3,144,
6,0,0,56,166,3,9,124,4,0,76,149,252,255,0,66,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,58,16,128,84,20,2,131,125,4,0,12,129,0,0,8,44,
120,43,166,124,12,0,130,64,2,4,96,56,104,0,0,72,0,0,40,129,
57,7,41,85,88,0,130,64,167,128,109,137,0,0,11,44,0,0,72,129,
180,46,202,80,0,0,72,145,24,0,130,65,12,0,1,128,8,0,33,56,
166,3,8,124,0,0,96,56,32,0,128,78,247,6,64,85,12,0,130,64,
1,0,204,104,62,6,134,85,4,0,104,128,0,0,8,129,0,0,128,56,
126,7,5,85,241,48,255,75,8,0,0,72,4,4,96,56,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,58,16,128,84,20,2,67,125,4,0,138,129,0,0,12,44,
0,0,96,56,120,43,166,124,12,0,130,64,2,4,96,56,44,0,0,72,
0,0,12,128,57,7,11,84,16,0,130,64,254,223,12,84,0,0,134,153,
20,0,0,72,4,0,108,128,0,0,128,56,126,7,5,84,17,48,255,75,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,8,0,129,147,
4,0,131,59,16,0,193,147,58,16,190,84,46,240,92,125,0,0,10,44,
120,35,157,124,124,0,130,64,0,0,29,128,4,0,125,128,126,7,4,84,
254,239,5,84,29,47,255,75,121,27,127,124,100,0,130,64,46,241,188,127,
0,0,29,128,57,7,0,84,84,0,130,64,167,128,45,137,0,0,9,44,
40,0,130,65,20,0,225,131,16,0,193,131,12,0,161,131,28,0,1,128,
8,0,129,131,0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
0,0,29,128,4,0,125,128,0,0,128,56,254,223,6,84,126,7,5,84,
201,47,255,75,8,0,0,72,3,4,224,59,120,251,227,127,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,8,0,129,147,121,27,124,124,12,0,161,147,
120,35,157,124,68,0,130,65,12,0,0,60,96,33,0,48,0,0,28,144,
3,0,192,59,120,227,159,127,4,0,31,132,0,0,0,44,12,0,130,65,
120,3,3,124,205,162,2,72,255,255,222,55,232,255,130,64,255,7,160,87,
12,0,130,65,120,227,131,127,181,162,2,72,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,0,0,3,44,
20,0,130,64,16,0,96,56,213,160,2,72,0,0,3,44,40,0,130,65,
120,27,108,124,0,0,64,57,12,0,0,60,96,33,0,48,0,0,3,144,
3,0,0,56,166,3,9,124,4,0,76,149,252,255,0,66,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,58,16,132,84,20,34,131,125,4,0,108,129,0,0,11,44,
12,0,130,64,2,4,96,56,132,0,0,72,0,0,11,128,57,7,0,84,
116,0,130,64,167,128,141,137,0,0,12,44,0,0,75,129,180,46,170,80,
0,0,75,145,48,0,130,65,12,0,131,129,0,0,12,44,16,0,130,65,
0,0,12,128,180,46,160,80,0,0,12,144,12,0,1,128,8,0,33,56,
166,3,8,124,0,0,96,56,32,0,128,78,247,6,74,85,12,0,130,64,
1,0,165,104,62,6,165,84,0,0,11,128,4,0,107,128,120,43,166,124,
0,0,128,56,126,7,5,84,29,46,255,75,8,0,0,72,4,4,96,56,
12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,
4,0,1,144,248,255,33,148,58,16,128,84,20,2,35,125,4,0,137,129,
0,0,12,44,0,0,96,56,120,43,166,124,12,0,130,64,2,4,96,56,
64,0,0,72,0,0,76,129,57,7,74,85,16,0,130,65,167,128,109,137,
0,0,11,44,20,0,130,65,0,0,76,129,254,223,76,85,0,0,134,153,
24,0,0,72,0,0,12,128,4,0,108,128,0,0,128,56,126,7,5,84,
41,45,255,75,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
232,255,33,148,12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,
8,0,129,147,4,0,131,59,16,0,193,147,58,16,190,84,46,240,28,124,
0,0,0,44,120,35,157,124,76,0,130,64,0,0,29,128,4,0,125,128,
126,7,4,84,254,239,5,84,53,44,255,75,121,27,127,124,52,0,130,64,
46,241,188,127,0,0,29,128,57,7,0,84,36,0,130,64,0,0,93,129,
4,0,125,128,0,0,128,56,254,223,70,85,126,7,69,85,17,45,255,75,
8,0,0,72,3,4,224,59,120,251,227,127,20,0,225,131,16,0,193,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,166,2,8,124,
28,0,1,144,8,0,129,147,121,27,124,124,12,0,161,147,120,35,157,124,
68,0,130,65,12,0,0,60,56,33,0,48,0,0,28,144,5,0,192,59,
120,227,159,127,4,0,31,132,0,0,0,44,12,0,130,65,120,3,3,124,
21,160,2,72,255,255,222,55,232,255,130,64,255,7,160,87,12,0,130,65,
120,227,131,127,253,159,2,72,16,0,193,131,20,0,225,131,28,0,1,128,
12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,0,0,3,44,20,0,130,64,
24,0,96,56,29,158,2,72,0,0,3,44,40,0,130,65,120,27,108,124,
0,0,64,57,12,0,0,60,56,33,0,48,0,0,3,144,5,0,0,56,
166,3,9,124,4,0,76,149,252,255,0,66,12,0,1,128,8,0,33,56,
166,3,8,124,32,0,128,78,167,128,13,136,0,0,0,44,128,255,96,56,
32,0,130,77,22,0,96,56,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,58,16,128,84,20,2,3,125,4,0,8,129,0,0,8,44,
120,43,166,124,12,0,130,64,2,4,96,56,72,0,0,72,0,0,40,129,
57,7,41,85,56,0,130,64,0,0,72,129,180,46,202,80,247,6,75,85,
0,0,72,145,12,0,130,64,1,0,204,104,62,6,134,85,0,0,8,128,
4,0,104,128,0,0,128,56,126,7,5,84,133,43,255,75,8,0,0,72,
4,4,96,56,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,58,16,128,84,20,2,35,125,
4,0,137,129,0,0,12,44,0,0,96,56,120,43,166,124,12,0,130,64,
2,4,96,56,64,0,0,72,0,0,76,129,57,7,74,85,16,0,130,65,
167,128,109,137,0,0,11,44,20,0,130,65,0,0,76,129,254,223,76,85,
0,0,134,153,24,0,0,72,0,0,12,128,4,0,108,128,0,0,128,56,
126,7,5,84,145,42,255,75,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,232,255,33,148,12,0,161,147,20,0,225,147,166,2,8,124,
28,0,1,144,8,0,129,147,4,0,131,59,16,0,193,147,58,16,190,84,
46,240,28,124,0,0,0,44,120,35,157,124,76,0,130,64,0,0,29,128,
4,0,125,128,126,7,4,84,254,239,5,84,157,41,255,75,121,27,127,124,
52,0,130,64,46,241,188,127,0,0,29,128,57,7,0,84,36,0,130,64,
0,0,93,129,4,0,125,128,0,0,128,56,254,223,70,85,126,7,69,85,
121,42,255,75,8,0,0,72,3,4,224,59,120,251,227,127,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,8,0,129,147,121,27,124,124,12,0,161,147,
120,35,157,124,68,0,130,65,12,0,0,60,24,33,0,48,0,0,28,144,
12,0,192,59,120,227,159,127,4,0,31,132,0,0,0,44,12,0,130,65,
120,3,3,124,125,157,2,72,255,255,222,55,232,255,130,64,255,7,160,87,
12,0,130,65,120,227,131,127,101,157,2,72,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,0,0,3,44,
20,0,130,64,52,0,96,56,133,155,2,72,0,0,3,44,40,0,130,65,
120,27,108,124,0,0,64,57,12,0,0,60,24,33,0,48,0,0,3,144,
12,0,0,56,166,3,9,124,4,0,76,149,252,255,0,66,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,166,2,8,124,4,0,1,144,
248,255,33,148,58,16,128,84,20,2,3,125,4,0,8,129,0,0,8,44,
120,43,166,124,12,0,130,64,2,4,96,56,72,0,0,72,0,0,40,129,
57,7,41,85,56,0,130,64,0,0,72,129,180,46,202,80,247,6,75,85,
0,0,72,145,12,0,130,64,1,0,204,104,62,6,134,85,0,0,8,128,
4,0,104,128,0,0,128,56,126,7,5,84,5,41,255,75,8,0,0,72,
4,4,96,56,12,0,1,128,8,0,33,56,166,3,8,124,32,0,128,78,
166,2,8,124,4,0,1,144,248,255,33,148,58,16,128,84,20,2,35,125,
4,0,137,129,0,0,12,44,0,0,96,56,120,43,166,124,12,0,130,64,
2,4,96,56,64,0,0,72,0,0,76,129,57,7,74,85,16,0,130,65,
167,128,109,137,0,0,11,44,20,0,130,65,0,0,76,129,254,223,76,85,
0,0,134,153,24,0,0,72,0,0,12,128,4,0,108,128,0,0,128,56,
126,7,5,84,17,40,255,75,12,0,1,128,8,0,33,56,166,3,8,124,
32,0,128,78,29,0,131,61,140,49,108,136,32,0,128,78,58,16,99,84,
29,0,131,61,100,49,44,129,174,32,9,124,100,49,76,57,254,7,12,84,
0,0,133,153,0,0,42,129,174,32,9,124,254,255,12,84,0,0,134,153,
32,0,128,78,58,16,99,84,29,0,0,60,100,49,0,48,46,0,131,125,
174,32,12,124,190,246,3,84,32,0,128,78,240,255,33,148,166,2,8,124,
20,0,1,144,12,0,225,147,120,27,127,124,44,0,95,137,116,7,74,125,
58,16,64,85,20,2,127,125,4,0,139,129,0,0,12,44,196,0,130,64,
52,0,127,136,0,0,3,44,208,0,130,65,64,32,3,124,20,0,129,64,
80,24,100,124,62,6,99,84,52,0,127,152,184,0,0,72,120,83,67,125,
81,255,255,75,1,0,3,44,144,0,130,65,48,0,159,128,1,0,132,56,
0,24,4,124,48,0,159,144,12,0,128,65,0,0,128,56,48,0,159,144,
0,0,128,57,8,0,129,153,9,0,129,153,120,83,67,125,116,7,132,124,
8,0,161,56,9,0,193,56,25,255,255,75,0,0,159,129,28,0,108,129,
8,0,161,136,8,0,128,56,120,251,227,127,166,3,105,125,33,4,128,78,
0,0,127,129,28,0,11,128,9,0,161,136,120,251,227,127,9,0,128,56,
166,3,9,124,33,4,128,78,44,0,127,136,48,0,159,136,116,7,99,124,
1,255,255,75,52,0,127,152,28,0,0,72,20,0,1,128,12,0,225,131,
0,0,96,56,16,0,33,56,166,3,8,124,32,0,128,78,20,0,1,128,
12,0,225,131,16,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,
12,0,161,147,20,0,225,147,166,2,8,124,28,0,1,144,8,0,129,147,
4,0,131,59,16,0,193,147,58,16,190,84,46,240,92,125,0,0,10,44,
120,35,157,124,124,0,130,64,0,0,29,128,4,0,125,128,126,7,4,84,
254,239,5,84,169,37,255,75,121,27,127,124,100,0,130,64,46,241,188,127,
0,0,29,128,57,7,0,84,84,0,130,64,167,128,45,137,0,0,9,44,
40,0,130,65,20,0,225,131,16,0,193,131,12,0,161,131,28,0,1,128,
8,0,129,131,0,0,96,56,166,3,8,124,24,0,33,56,32,0,128,78,
0,0,29,128,4,0,125,128,0,0,128,56,254,223,6,84,126,7,5,84,
85,38,255,75,8,0,0,72,3,4,224,59,120,251,227,127,20,0,225,131,
16,0,193,131,28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,
24,0,33,56,32,0,128,78,232,255,33,148,16,0,193,147,20,0,225,147,
166,2,8,124,28,0,1,144,8,0,129,147,121,27,124,124,12,0,161,147,
120,35,157,124,68,0,130,65,12,0,0,60,240,32,0,48,0,0,28,144,
10,0,192,59,120,227,159,127,4,0,31,132,0,0,0,44,12,0,130,65,
120,3,3,124,89,153,2,72,255,255,222,55,232,255,130,64,255,7,160,87,
12,0,130,65,120,227,131,127,65,153,2,72,16,0,193,131,20,0,225,131,
28,0,1,128,12,0,161,131,8,0,129,131,166,3,8,124,24,0,33,56,
32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,0,0,3,44,
20,0,130,64,56,0,96,56,97,151,2,72,0,0,3,44,60,0,130,65,
12,0,96,61,240,32,107,57,0,0,99,145,120,27,108,124,0,0,64,57,
10,0,0,56,166,3,9,124,4,0,76,149,252,255,0,66,5,0,128,57,
44,0,131,153,0,0,0,56,48,0,3,144,52,0,3,152,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,232,255,33,148,12,0,161,147,
16,0,193,147,20,0,225,147,166,2,8,124,28,0,1,144,167,128,13,136,
0,0,0,44,120,27,126,124,28,0,130,65,28,0,1,128,16,0,193,131,
0,0,96,56,24,0,33,56,166,3,8,124,32,0,128,78,58,16,134,84,
20,50,30,125,4,0,40,129,0,0,9,44,188,0,130,64,8,0,4,44,
172,0,130,65,9,0,4,44,164,0,130,65,0,0,64,57,48,0,94,145,
120,35,138,124,44,0,94,153,120,35,131,124,77,252,255,75,0,0,3,44,
132,0,130,65,120,83,67,125,0,0,128,56,117,252,255,75,8,0,129,152,
9,0,129,152,52,0,126,152,120,83,67,125,8,0,161,56,9,0,193,56,
41,252,255,75,0,0,126,129,28,0,139,129,8,0,161,136,120,243,195,127,
8,0,128,56,166,3,137,125,33,4,128,78,0,0,254,128,28,0,39,129,
9,0,161,136,120,27,125,124,9,0,128,56,120,243,195,127,166,3,41,125,
33,4,128,78,121,27,127,124,12,0,130,65,0,0,29,44,16,0,130,64,
52,0,126,136,61,167,254,75,88,0,0,72,2,4,224,59,80,0,0,72,
0,0,105,129,57,7,107,85,64,0,130,64,0,0,137,129,180,46,172,80,
247,6,128,85,0,0,137,145,12,0,130,64,1,0,165,104,62,6,165,84,
0,0,9,128,4,0,105,128,120,43,166,124,0,0,128,56,126,7,5,84,
233,35,255,75,120,27,127,124,8,0,0,72,4,4,224,59,120,251,227,127,
20,0,225,131,28,0,1,128,16,0,193,131,12,0,161,131,166,3,8,124,
24,0,33,56,32,0,128,78,166,2,8,124,4,0,1,144,248,255,33,148,
58,16,128,84,20,2,67,125,4,0,138,129,0,0,12,44,0,0,96,56,
120,43,166,124,12,0,130,64,2,4,96,56,44,0,0,72,0,0,12,128,
57,7,11,84,16,0,130,64,254,223,12,84,0,0,134,153,20,0,0,72,
4,0,108,128,0,0,128,56,126,7,5,84,245,34,255,75,12,0,1,128,
8,0,33,56,166,3,8,124,32,0,128,78,224,255,33,148,20,0,161,147,
16,0,129,147,120,27,124,124,166,2,8,124,36,0,1,144,12,0,97,147,
0,0,96,59,120,219,96,127,28,0,225,147,29,0,224,63,140,49,255,59,
255,255,159,57,24,0,193,147,29,0,192,63,100,49,222,59,252,255,126,57,
10,0,0,57,166,3,9,125,4,0,11,148,1,0,12,156,248,255,0,66,
4,0,220,136,0,0,6,44,16,1,130,65,2,0,28,136,3,0,60,137,
46,68,41,85,120,3,37,125,62,4,160,84,0,0,27,124,8,0,188,59,
232,0,128,64,2,0,125,136,0,0,3,44,228,0,130,65,0,0,253,136,
7,0,7,44,184,0,130,64,1,0,29,137,58,16,8,85,46,240,40,125,
0,0,9,44,196,0,130,64,20,218,67,125,3,0,106,59,37,150,2,72,
1,0,221,136,0,0,3,44,58,16,201,84,46,241,105,124,44,0,130,64,
20,0,161,131,28,0,225,131,24,0,193,131,16,0,129,131,36,0,1,128,
12,0,97,131,16,1,96,56,166,3,8,124,32,0,33,56,32,0,128,78,
2,0,125,140,0,0,0,57,0,24,8,124,120,243,192,127,174,49,127,124,
32,0,128,64,58,16,202,84,46,0,106,125,1,0,157,141,174,65,139,125,
1,0,8,57,0,24,8,124,232,255,128,65,3,0,188,136,2,0,252,136,
46,68,165,84,120,59,165,124,62,4,160,84,0,0,27,124,1,0,189,59,
60,255,128,65,28,0,0,72,20,218,131,125,3,0,108,59,0,0,27,124,
3,0,221,56,20,26,166,127,32,255,128,65,64,0,27,124,44,0,130,65,
20,0,161,131,28,0,225,131,24,0,193,131,16,0,129,131,36,0,1,128,
12,0,97,131,13,4,96,56,166,3,8,124,32,0,33,56,32,0,128,78,
20,0,161,131,28,0,225,131,24,0,193,131,16,0,129,131,36,0,1,128,
12,0,97,131,0,0,96,56,166,3,8,124,32,0,33,56,32,0,128,78,
29,0,131,61,88,49,108,136,32,0,128,78,58,16,99,84,29,0,131,61,
40,49,44,129,174,32,9,124,40,49,76,57,254,7,12,84,0,0,133,153,
0,0,42,129,174,32,9,124,254,255,12,84,0,0,134,153,32,0,128,78,
58,16,99,84,29,0,0,60,40,49,0,48,46,0,131,125,174,32,12,124,
190,246,3,84,32,0,128,78,240,255,33,148,166,2,8,124,20,0,1,144,
12,0,225,147,120,27,127,124,52,0,95,137,116,7,74,125,58,16,64,85,
20,2,127,125,4,0,139,129,0,0,12,44,196,0,130,64,60,0,127,136,
0,0,3,44,208,0,130,65,64,32,3,124,20,0,129,64,80,24,100,124,
62,6,99,84,60,0,127,152,184,0,0,72,120,83,67,125,81,255,255,75,
1,0,3,44,144,0,130,65,56,0,159,128,1,0,132,56,0,24,4,124,
56,0,159,144,12,0,128,65,0,0,128,56,56,0,159,144,0,0,128