/*
 * Copyright (c) 1995
 *	Bill Paul <wpaul@ctr.columbia.edu>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Bill Paul.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Bill Paul AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bill Paul OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/6/libexec/revnetgroup/hash.h 90377 2002-02-07 23:57:01Z imp $
 */

/* Groupname entry hung off a member_entry node. */
struct grouplist {
	char *groupname;
	struct grouplist *next;
};

/* Entry in the cooked member list hash table. */
struct member_entry {
	char *key;
	char *domain;
	struct grouplist *groups;
	struct member_entry *next;
};

/* Entry in the raw netgroup table. */
struct group_entry {
	char *key;
	char *data;
	struct group_entry *next;
};

/* Table size (chosen arbitrarily). Not too big, not too small. */
#define TABLESIZE 256
#define HASH_MASK 0x000000FF

#define LINSIZ 1024 * 10

extern void store(struct group_entry ** , char *, char *);
extern void mstore(struct member_entry ** , char *, char *, char *);
extern char *lookup(struct group_entry **, char *);
extern void __endnetgrent(void);
extern void __setnetgrent(char *);
extern int __getnetgrent(char **, char **, char **);
