#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Anna Lea
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Whispering Willows
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241005.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='whispering-willows'
GAME_NAME='Whispering Willows'

ARCHIVE_BASE_GOG_0_NAME='whispering_willows_1_6_4_53005.sh'
ARCHIVE_BASE_GOG_0_MD5='5b9ce22be3825deeadbb524e7cedb2a2'
ARCHIVE_BASE_GOG_0_SIZE='2025821'
ARCHIVE_BASE_GOG_0_VERSION='1.6.4-gog53005'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/whispering_willows'

ARCHIVE_BASE_FIREFLOWER_0_NAME='Whispering_Willows_1_27_Linux.zip'
ARCHIVE_BASE_FIREFLOWER_0_MD5='5ca10433c0da315028d8318e39fb3ad2'
ARCHIVE_BASE_FIREFLOWER_0_SIZE='2000000'
ARCHIVE_BASE_FIREFLOWER_0_VERSION='1.27-fireflower'
ARCHIVE_BASE_FIREFLOWER_0_URL='https://fireflowergames.com/products/whispering-willows'

ARCHIVE_BASE_HUMBLE_0_NAME='LINUX_NO_STEAM.rar'
ARCHIVE_BASE_HUMBLE_0_MD5='56c078a0208769ab2222f7e1cc0e0d57'
ARCHIVE_BASE_HUMBLE_0_SIZE='1884781'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.26-humble151125'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/whispering-willows'

UNITY3D_NAME='WhisperingWillows'
UNITY3D_PLUGINS='
ScreenSelector.so'
## TODO: Check if the Steam libraries can be dropped
UNITY3D_PLUGINS="$UNITY3D_PLUGINS
libCSteamworks.so
libsteam_api.so"

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_FIREFLOWER='.'
CONTENT_PATH_DEFAULT_HUMBLE='LINUX_NO_STEAM'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES_GOG='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES_GOG="$PKG_BIN_DEPENDENCIES_LIBRARIES_GOG"
PKG_BIN32_DEPENDENCIES_LIBRARIES_GOG="$PKG_BIN_DEPENDENCIES_LIBRARIES_GOG"
PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libGLU.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES_HUMBLE="$PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE"
PKG_BIN32_DEPENDENCIES_LIBRARIES_HUMBLE="$PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE"
## TODO: Check that the Fireflower build relies on the same libraries than the Humble Bundle one
PKG_BIN64_DEPENDENCIES_LIBRARIES_FIREFLOWER="$PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE"
PKG_BIN32_DEPENDENCIES_LIBRARIES_FIREFLOWER="$PKG_BIN_DEPENDENCIES_LIBRARIES_HUMBLE"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build package

packages_generation
print_instructions

# Clean up

rm --recursive "${PLAYIT_WORKDIR}"

exit 0
