#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Darwinia
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251020.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='darwinia'
GAME_NAME='Darwinia'

ARCHIVE_BASE_0_NAME='darwinia_2_3_3_45_ged1ca4106_gnu_linux_full_72588.sh'
ARCHIVE_BASE_0_MD5='20d80521ad8ef6a3c160ee9417daa678'
ARCHIVE_BASE_0_SIZE='66408'
ARCHIVE_BASE_0_VERSION='2.3.3.45-gog72588'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/darwinia'

ARCHIVE_BASE_MULTIARCH_0_NAME='gog_darwinia_2.0.0.5.sh'
ARCHIVE_BASE_MULTIARCH_0_MD5='ef55064ab82a64324e295f2ea96239d6'
ARCHIVE_BASE_MULTIARCH_0_SIZE='45000'
ARCHIVE_BASE_MULTIARCH_0_VERSION='1.4.2-gog2.0.0.5'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_FILES='
libsentry.so'
## Include the shipped EGL and GLESv2 libraries,
## to prevent rendering failures and performance problems.
CONTENT_LIBS0_BIN_FILES='
libEGL.so.1
libEGL.so
libGLESv2.so.2
libGLESv2.so'
CONTENT_GAME_BIN_FILES='
crashpad_handler
darwinia'
CONTENT_GAME_BIN64_FILES='
darwinia.bin.x86_64'
CONTENT_GAME_BIN32_FILES='
darwinia.bin.x86'
CONTENT_GAME_DATA_FILES='
darwinian.png
*.dat'
CONTENT_DOC_DATA_FILES='
*.txt'

FAKE_HOME_PERSISTENT_DIRECTORIES='
.darwinia'

APP_MAIN_EXE_BIN='darwinia'
APP_MAIN_EXE_BIN64='darwinia.bin.x86_64'
APP_MAIN_EXE_BIN32='darwinia.bin.x86'
APP_MAIN_ICON_MULTIARCH='darwinian.png'
## Convert the shipped icon to a standard size.
REQUIREMENTS_LIST_MULTIARCH='
convert'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'
PACKAGES_LIST_MULTIARCH='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libcrypto.so.3
libc.so.6
libcurl.so.4
libdl.so.2
libdrm.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libssl.so.3
libstdc++.so.6
libvulkan.so.1
libX11.so.6
libxcb.so.1
libXext.so.6
libz.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_MULTIARCH='
libc.so.6
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libogg.so.0
libpthread.so.0
libSDL-1.2.so.0
libstdc++.so.6
libvorbisfile.so.3
libvorbis.so.0'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data

## TODO: An optional icons archive should be provided for game builds not including one already.
case "$(current_archive)" in
	('ARCHIVE_BASE_MULTIARCH_'*)
		## Convert the shipped icon to a standard size.
		icon_original="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/${APP_MAIN_ICON_MULTIARCH}"
		icon_resized="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/${APP_MAIN_ICON_MULTIARCH}_resized.png"
		convert \
			-background none -gravity center "$icon_original" \
			-resize 128x128 -extent 128x128 "$icon_resized"
		mv "$icon_resized" "$icon_original"

		content_inclusion_icons 'PKG_DATA'
	;;
esac
content_inclusion_default

# libsentry.so is linked against an unversioned libcurl.so.

case "$(current_archive)" in
	('ARCHIVE_BASE_MULTIARCH_'*)
		## The old multiarch builds did not include libsentry.so.
	;;
	(*)
		ln --symbolic \
			"$(path_libraries_system)/libcurl.so.4" \
			"$(package_path 'PKG_BIN')$(path_libraries)/libcurl.so"
	;;
esac

# Write launchers.

case "$(current_archive)" in
	('ARCHIVE_BASE_MULTIARCH_'*)
		launchers_generation 'PKG_BIN64'
		launchers_generation 'PKG_BIN32'
	;;
	(*)
		## Force the use of system-provided SDL.
		APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
		$(launcher_tweak_sdl_override)"
		PKG_BIN_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES
		libSDL2-2.0.so.0"

		## The game crashes on launch when using the wayland backend of SDL.
		APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')"'
		# The game crashes on launch when using the wayland backend of SDL.
		if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
			unset SDL_VIDEODRIVER
		fi
		'

		launchers_generation
	;;
esac

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
