//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.
void acetoneiso::backupaudio()
{
QDir bin("/usr/bin");
QFile cdrdao;
QDir::setCurrent( bin.path() );
cdrdao.setFileName("cdrdao");

if (cdrdao.exists())
	{
QMessageBox::warning(this, "AcetoneISO::Warning!",tr("Please note this utility will generate a TOC/BIN image which could not be mounted or read in any way.\nHowever You can burn it later with AcetoneISO burning tools!"));


     bool ok;
     QString text = QInputDialog::getText(this, tr("AcetoneISO::Insert cd/dvd device"),
                                          tr("Please specify your CD/DVD device. If you aren't sure just leave default.\nTypical devices are:\n/dev/cdrom or /dev/cdrom0 or /dev/cdrom1 or /dev/dvd and follow this symbolism."), QLineEdit::Normal,
                                          "/dev/cdrom", &ok);



if (ok && !text.isEmpty())
{

 QDir Home = QDir::home();
		 	QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save BIN Audio file"),
										Home.path() + "/AcetoneISO_cdAudio",
										tr("Images (*.bin)"));

			
if ( fileName.isNull() )
{
 return;
}

QString	filebin = fileName.append(".bin");
QString	filetoc = fileName.append(".toc");
UMountcdrom.start("umount",QStringList()  << text);


	 showProgressDisplay();
	 BAckaudio = new QProcess();
	 BAckaudio->setReadChannel(QProcess::StandardOutput);
	 BAckaudio->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(BAckaudio, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_BAckaudio() )); 
	connect(BAckaudio, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOutbackaudio(int, QProcess::ExitStatus)));  

BAckaudio->start("cdrdao",QStringList()  << "read-cd" << "--datafile" << filebin << "--device" << text << "--buffers" << "64" << "--driver" << "generic-mmc-raw" << filetoc);

	}
}
else
QMessageBox::warning(this, "AcetoneISO::Warning!",tr("no cdrdao found in /usr/bin"));
}



