/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1996  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _manifest_h
#define _manifest_h

#include "../util/units.h"

#ifdef manifest_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/** Maximum number of players and drones. */
#define manifest_MAXPLAYERS	32

/** Maximum number of chasers. */
#define manifest_MAXCHASERS  1

/** Maximum number of missiles and cannon streams. */
#define manifest_MAXPROJECTILES	(manifest_MAXPLAYERS * 1)

#define manifest_MAXEXPLOSIONS	manifest_MAXPROJECTILES

/** Max number of weapon stations launch points per aircraft. */
#define manifest_STATIONS	9

/**
 *  We'll check every now and again to see if any aircraft are waiting to
 *  be resupplied.  RESUPPLY_EVERY defines the number of seconds
 *  between each check (30 seconds, here).
 */
#define manifest_RESUPPLY_INTERVAL	(30.0)

/**
 *  When on the ground, we won't allow planes to stray too far from their
 *  team's airport.  manifest_MAX_GROUND_DISTANCE defines that distance.
 */
#define manifest_MAX_GROUND_DISTANCE	(3.0 * units_NmToFeetFactor)

/**
 *  The maximum allowed dead reckoning errors for DIS.
 *  (Note: the units are meters and radians.)
 */
#define manifest_DIS_LOCATION_THRESHOLD		3.0
#define manifest_DIS_ORIENTATION_THRESHOLD	units_DEGtoRAD(2)

/** Identifies X-Window resources related to this program. */
#define manifest_ACM   "acm"

#undef EXTERN
#endif
