/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 11:38:45 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.biojava.bio.molbio.RestrictionSite;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RemoteFeature;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import org.postgresql.largeobject.LargeObject;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.LargeObjectDocument;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.TextDocument;
import uk.ac.sanger.artemis.util.ZipFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class PublicDBDocumentEntry_ESTest extends PublicDBDocumentEntry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Key key0 = new Key("", true);
      Key key1 = PublicDBDocumentEntry.mapKeys(key0);
      assertEquals(0, key1.length());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      uk.ac.sanger.artemis.Entry entry0 = simpleEntryGroup0.createEntry();
      EntryInformation entryInformation0 = entry0.getEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0);
      StringReader stringReader0 = new StringReader("ao,qx+");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      StreamSequence streamSequence0 = publicDBDocumentEntry0.makeNativeSequence(fastaStreamSequence0);
      assertEquals(2, streamSequence0.getFormatType());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(simpleEntryInformation0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("centromere");
      StreamSequence streamSequence0 = genbankDocumentEntry0.makeNativeSequence(emblStreamSequence0);
      assertEquals(10, streamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      // Undeclared exception!
      try { 
        PublicDBDocumentEntry.mapKeys((Key) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      // Undeclared exception!
      try { 
        genbankDocumentEntry0.makeNativeSequence((Sequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(entryInformation0, genbankDocumentEntry0, true);
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      // Undeclared exception!
      try { 
        emblDocumentEntry0.makeNativeSequence(bioJavaSequence0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.BioJavaSequence cannot be cast to uk.ac.sanger.artemis.io.StreamSequence
         //
         verifyException("uk.ac.sanger.artemis.io.EmblStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(blastEntryInformation0);
      // Undeclared exception!
      try { 
        emblDocumentEntry0.makeNativeFeature((Feature) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MockFile mockFile0 = new MockFile("@uxau0");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "@uxau0");
      Document document0 = zipFileDocument0.append("n5axf&y3DLI@");
      LogReadListener logReadListener0 = new LogReadListener("@uxau0");
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("@uxau0/n5axf&y3DLI@");
      byte[] byteArray0 = new byte[2];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(blastEntryInformation0, document0, logReadListener0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // cannot recognise format of binary file
         //
         verifyException("uk.ac.sanger.artemis.io.LineGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      uk.ac.sanger.artemis.Entry entry0 = uk.ac.sanger.artemis.Entry.newEntry(bases0);
      Range range0 = new Range((-5));
      uk.ac.sanger.artemis.Entry entry1 = entry0.truncate(bases0, range0);
      EntryInformation entryInformation0 = entry1.getEntryInformation();
      LogReadListener logReadListener0 = new LogReadListener("membrane_structure");
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, (Document) null, logReadListener0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      LargeObject largeObject0 = mock(LargeObject.class, new ViolatedAssumptionAnswer());
      doReturn((InputStream) null).when(largeObject0).getInputStream();
      LargeObjectDocument largeObjectDocument0 = new LargeObjectDocument("", "", largeObject0);
      LogReadListener logReadListener0 = new LogReadListener("isObsolete");
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, largeObjectDocument0, logReadListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.InflaterInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      byte[] byteArray0 = new byte[8];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0, (byte) (-72), (byte)24);
      BufferedInputStream bufferedInputStream0 = new BufferedInputStream(byteArrayInputStream0);
      LargeObject largeObject0 = mock(LargeObject.class, new ViolatedAssumptionAnswer());
      doReturn(bufferedInputStream0).when(largeObject0).getInputStream();
      LargeObjectDocument largeObjectDocument0 = new LargeObjectDocument("com.sshtools.j2ssh.sftp.SshFxpName", "com.sshtools.j2ssh.sftp.SshFxpName", largeObject0);
      LogReadListener logReadListener0 = new LogReadListener("com.sshtools.j2ssh.sftp.SshFxpName");
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, largeObjectDocument0, logReadListener0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.ByteArrayInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MockFile mockFile0 = new MockFile("@uxau0");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "M'");
      FileSystemHandling.shouldAllThrowIOExceptions();
      zipFileDocument0.getWriter();
      LogReadListener logReadListener0 = new LogReadListener((String) null);
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(blastEntryInformation0, zipFileDocument0, logReadListener0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      uk.ac.sanger.artemis.Entry entry0 = simpleEntryGroup0.createEntry("}U6");
      EntryInformation entryInformation0 = entry0.getEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(entryInformation0);
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, emblDocumentEntry0, true);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      EntryInformation entryInformation0 = Options.getArtemisEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, (Entry) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("centromere", "OVqraY~{(,EYV/{M#");
      Bases bases0 = new Bases(fastaStreamSequence0);
      uk.ac.sanger.artemis.Entry entry0 = uk.ac.sanger.artemis.Entry.newEntry(bases0);
      EntryInformation entryInformation0 = entry0.getEntryInformation();
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation(entryInformation0);
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry((EntryInformation) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleEntryInformation", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      FeatureHolder.EmptyFeatureHolder featureHolder_EmptyFeatureHolder0 = new FeatureHolder.EmptyFeatureHolder();
      RestrictionSite.Template restrictionSite_Template0 = new RestrictionSite.Template();
      RemoteFeature.Template remoteFeature_Template0 = new RemoteFeature.Template(restrictionSite_Template0);
      FastaFormat fastaFormat0 = new FastaFormat();
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(entryInformation0);
      Object object0 = emblDocumentEntry0.makeNativeFeature(databaseStreamFeature0, false);
      assertNotSame(emblStreamFeature0, object0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      uk.ac.sanger.artemis.FeatureVector featureVector0 = new uk.ac.sanger.artemis.FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "9\"=+8");
      uk.ac.sanger.artemis.Entry entry0 = filteredEntryGroup0.createEntry("End_range");
      EntryInformation entryInformation0 = entry0.getEntryInformation();
      File file0 = MockFile.createTempFile("End_range", "O");
      FileDocument fileDocument0 = new FileDocument(file0);
      LogReadListener logReadListener0 = new LogReadListener("9\"=+8");
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, fileDocument0, logReadListener0);
      assertTrue(PublicDBDocumentEntry.IGNORE_OBSOLETE_FEATURES);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(entryInformation0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("StringBuffer append(long)", "transmembrane_polypeptide_region");
      StreamSequence streamSequence0 = emblDocumentEntry0.makeNativeSequence(fastaStreamSequence0);
      assertEquals(1, streamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Key key0 = new Key("centromere", true);
      Key key1 = PublicDBDocumentEntry.mapKeys(key0);
      assertEquals("misc_feature", key1.toString());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Key key0 = Key.CDS;
      Key key1 = PublicDBDocumentEntry.mapKeys(key0);
      Key key2 = PublicDBDocumentEntry.mapKeys(key1);
      assertSame(key2, key1);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      Feature feature0 = genbankDocumentEntry0.forcedAdd(databaseStreamFeature0);
      Object object0 = genbankDocumentEntry0.makeNativeFeature(databaseStreamFeature0, true);
      assertFalse(object0.equals((Object)feature0));
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(entryInformation0);
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Object object0 = emblDocumentEntry0.makeNativeFeature(genbankStreamFeature0, false);
      assertNotNull(object0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      Feature feature0 = genbankDocumentEntry0.forcedAdd(databaseStreamFeature0);
      Object object0 = genbankDocumentEntry0.makeNativeFeature(feature0, false);
      assertSame(object0, feature0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(entryInformation0);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      Object object0 = emblDocumentEntry0.makeNativeFeature(emblStreamFeature0, false);
      assertSame(object0, emblStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      Object object0 = genbankDocumentEntry0.makeNativeFeature(emblStreamFeature0, false);
      assertNotNull(object0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MockFile mockFile0 = new MockFile("@uxau0");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "M'");
      LogReadListener logReadListener0 = new LogReadListener((String) null);
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(blastEntryInformation0, zipFileDocument0, logReadListener0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      PublicDBDocumentEntry.getDatabaseQualifiersToRemove();
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(genbankDocumentEntry0, false);
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(mSPcrunchEntryInformation0, blastDocumentEntry0, true);
      assertTrue(PublicDBDocumentEntry.IGNORE_OBSOLETE_FEATURES);
  }
}
