/*
    beer.h - Frontend for SAFT for X11
    Copyright (c) 1999,2006  Joey Schulze <joey@infodrom.org>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#ifndef __BEER_H__
#define __BEER_H__

#include <stdint.h>
#include <gtk/gtk.h>

/* Contains the name of the program and version */
extern char progname[];
extern char version[];

#define PROTOCOL_AUTO 1
#define PROTOCOL_IPV4 2
#define PROTOCOL_IPV6 3

struct s_conf {
  GList *addrs;
  uint8_t keep;
  uint8_t closewindow;
  uint8_t protocol;
  uint8_t dotfiles;
};

extern struct s_conf config;

void clear_history ();

/* Contains the exit code set somewhere within the program */
extern int beer_exitcode;

#define EXIT_OK		0
#define EXIT_CANCEL	1
#define EXIT_DELETE	2

#endif /* __BEER_H__ */
