/* Recorder.c generated by valac 0.34.4, the Vala compiler
 * generated from Recorder.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <time.h>
#include <gst/gst.h>
#include <gst/mpegts/mpegts.h>


#define DVB_TYPE_ID_BUS_RECORDER (dvb_id_bus_recorder_get_type ())
#define DVB_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorder))
#define DVB_IS_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDER))
#define DVB_ID_BUS_RECORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorderIface))

typedef struct _DVBIDBusRecorder DVBIDBusRecorder;
typedef struct _DVBIDBusRecorderIface DVBIDBusRecorderIface;

#define DVB_TYPE_ID_BUS_RECORDER_PROXY (dvb_id_bus_recorder_proxy_get_type ())

#define DVB_TYPE_TIMER_INFO (dvb_timer_info_get_type ())
typedef struct _DVBTimerInfo DVBTimerInfo;

#define DVB_TYPE_OVERLAP_TYPE (dvb_overlap_type_get_type ())

#define DVB_TYPE_RECORDER (dvb_recorder_get_type ())
#define DVB_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDER, DVBRecorder))
#define DVB_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDER, DVBRecorderClass))
#define DVB_IS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDER))
#define DVB_IS_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDER))
#define DVB_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDER, DVBRecorderClass))

typedef struct _DVBRecorder DVBRecorder;
typedef struct _DVBRecorderClass DVBRecorderClass;
typedef struct _DVBRecorderPrivate DVBRecorderPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANGE_TYPE (dvb_change_type_get_type ())

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))

struct _DVBTimerInfo {
	guint32 id;
	guint duration;
	gboolean active;
	gchar* channel_name;
	gchar* title;
};

typedef enum  {
	DVB_OVERLAP_TYPE_UNKNOWN,
	DVB_OVERLAP_TYPE_NONE,
	DVB_OVERLAP_TYPE_PARTIAL,
	DVB_OVERLAP_TYPE_COMPLETE
} DVBOverlapType;

struct _DVBIDBusRecorderIface {
	GTypeInterface parent_iface;
	gboolean (*AddTimer) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerWithMargin) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerForEPGEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
	gboolean (*DeleteTimer) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	guint32* (*GetTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
	gboolean (*SetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
	gboolean (*GetEndTime) (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
	gboolean (*GetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error);
	gboolean (*SetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecorder* self, guint32 timer_id, gchar** name, GError** error);
	gboolean (*GetTitle) (DVBIDBusRecorder* self, guint32 timer_id, gchar** title, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error);
	guint32* (*GetActiveTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*IsTimerActive) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	gboolean (*HasTimer) (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
	DVBOverlapType (*HasTimerForEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error);
};

struct _DVBRecorder {
	GObject parent_instance;
	DVBRecorderPrivate * priv;
};

struct _DVBRecorderClass {
	GObjectClass parent_class;
};

struct _DVBRecorderPrivate {
	DVBDeviceGroup* _DeviceGroup;
	GeeSet* active_timers;
	gboolean have_check_timers_timeout;
	guint check_timers_event_id;
	GeeHashMap* timers;
	GRecMutex __lock_timers;
	GeeMap* recordings;
	GRecMutex __lock_recordings;
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
	gboolean (*update_timer) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
};

typedef enum  {
	DVB_CHANGE_TYPE_ADDED = 0,
	DVB_CHANGE_TYPE_DELETED = 1,
	DVB_CHANGE_TYPE_UPDATED = 2
} DVBChangeType;

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	DVBEventVideoComponent* video_component;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);

static gpointer dvb_recorder_parent_class = NULL;
static DVBLoggingLogger* dvb_recorder_log;
static DVBLoggingLogger* dvb_recorder_log = NULL;
static DVBIDBusRecorderIface* dvb_recorder_dvb_id_bus_recorder_parent_iface = NULL;
static GeeTraversableIface* dvb_recorder_gee_traversable_parent_iface = NULL;
static GeeIterableIface* dvb_recorder_gee_iterable_parent_iface = NULL;

GType dvb_id_bus_recorder_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_recorder_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_timer_info_get_type (void) G_GNUC_CONST;
DVBTimerInfo* dvb_timer_info_dup (const DVBTimerInfo* self);
void dvb_timer_info_free (DVBTimerInfo* self);
void dvb_timer_info_copy (const DVBTimerInfo* self, DVBTimerInfo* dest);
void dvb_timer_info_destroy (DVBTimerInfo* self);
GType dvb_overlap_type_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_recorder_get_type (void) G_GNUC_CONST;
GType dvb_recorder_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_RECORDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDER, DVBRecorderPrivate))
enum  {
	DVB_RECORDER_DUMMY_PROPERTY,
	DVB_RECORDER_DEVICE_GROUP,
	DVB_RECORDER_COUNT,
	DVB_RECORDER_ELEMENT_TYPE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_RECORDER_CHECK_TIMERS_INTERVAL 5
#define DVB_RECORDER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE
DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev);
DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev);
static GeeIterator* dvb_recorder_real_iterator (GeeIterable* base);
static gboolean dvb_recorder_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static gboolean dvb_recorder_real_AddTimer (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
DVBTimer* dvb_recorder_create_timer (DVBRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id);
static gboolean dvb_recorder_real_AddTimerWithMargin (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (DVBFactory* self);
gint dvb_settings_get_timers_margin_start (DVBSettings* self);
gint dvb_settings_get_timers_margin_end (DVBSettings* self);
guint dvb_timer_get_Duration (DVBTimer* self);
void dvb_timer_set_Duration (DVBTimer* self, guint value);
void dvb_timer_add_to_start_time (DVBTimer* self, gint minutes);
gboolean dvb_timer_has_expired (DVBTimer* self);
gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2);
DVBDeviceGroup* dvb_recorder_get_DeviceGroup (DVBRecorder* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gchar* dvb_timer_to_string (DVBTimer* self);
guint32 dvb_timer_get_Id (DVBTimer* self);
GQuark dvb_database_sql_error_quark (void);
GType dvb_database_timers_store_get_type (void) G_GNUC_CONST;
DVBdatabaseTimersStore* dvb_factory_get_timers_store (DVBFactory* self);
gboolean dvb_database_timers_store_add_timer_to_device_group (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static gboolean dvb_recorder_check_timers (DVBRecorder* self);
static gboolean _dvb_recorder_check_timers_gsource_func (gpointer self);
GType dvb_change_type_get_type (void) G_GNUC_CONST;
static gboolean dvb_recorder_real_AddTimerForEPGEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
DVBdatabaseEPGStore* dvb_factory_get_epg_store (DVBFactory* self);
DVBEvent* dvb_database_epg_store_get_event (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
gboolean dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
static gboolean dvb_recorder_real_DeleteTimer (DVBIDBusRecorder* base, guint32 timer_id, GError** error);
gboolean dvb_recorder_delete_timer (DVBRecorder* self, guint32 timer_id);
gboolean dvb_recorder_is_timer_active (DVBRecorder* self, guint32 timer_id);
void dvb_recorder_stop_recording (DVBRecorder* self, DVBTimer* timer);
gboolean dvb_database_timers_store_remove_timer_from_device_group (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
static guint32* dvb_recorder_real_GetTimers (DVBIDBusRecorder* base, int* result_length1, GError** error);
static gboolean dvb_recorder_real_GetStartTime (DVBIDBusRecorder* base, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
static gboolean dvb_recorder_real_SetStartTime (DVBIDBusRecorder* base, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
void dvb_timer_set_start_time (DVBTimer* self, gint year, gint month, gint day, gint hour, gint minute);
gboolean dvb_database_timers_store_update_timer (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
static gboolean dvb_recorder_real_GetEndTime (DVBIDBusRecorder* base, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1);
static gboolean dvb_recorder_real_GetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint* duration, GError** error);
static gboolean dvb_recorder_real_SetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint duration, GError** error);
static gboolean dvb_recorder_real_GetChannelName (DVBIDBusRecorder* base, guint32 timer_id, gchar** name, GError** error);
GType dvb_channel_get_type (void) G_GNUC_CONST;
DVBChannel* dvb_timer_get_Channel (DVBTimer* self);
const gchar* dvb_channel_get_Name (DVBChannel* self);
static gboolean dvb_recorder_real_GetTitle (DVBIDBusRecorder* base, guint32 timer_id, gchar** title, GError** error);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id);
guint dvb_timer_get_EventID (DVBTimer* self);
static gboolean dvb_recorder_real_GetAllInformations (DVBIDBusRecorder* base, guint32 timer_id, DVBTimerInfo* info, GError** error);
static guint32* dvb_recorder_real_GetActiveTimers (DVBIDBusRecorder* base, int* result_length1, GError** error);
static gboolean dvb_recorder_real_IsTimerActive (DVBIDBusRecorder* base, guint32 timer_id, GError** error);
static gboolean dvb_recorder_real_HasTimer (DVBIDBusRecorder* base, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static DVBOverlapType dvb_recorder_real_HasTimerForEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, GError** error);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
void dvb_recorder_stop (DVBRecorder* self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
void dvb_recorder_start_recording (DVBRecorder* self, DVBTimer* timer);
static GFile* dvb_recorder_create_recording_dirs (DVBRecorder* self, DVBChannel* channel, guint* start, int start_length1);
void dvb_timer_set_sink (DVBTimer* self, GstElement* value);
GType dvb_channel_factory_get_type (void) G_GNUC_CONST;
DVBChannelFactory* dvb_device_group_get_channel_factory (DVBDeviceGroup* self);
GType dvb_player_thread_get_type (void) G_GNUC_CONST;
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
static void dvb_recorder_on_eit_structure (DVBRecorder* self, DVBPlayerThread* player, GstMpegtsSection* section);
static void _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure (DVBPlayerThread* _sender, GstMpegtsSection* section, gpointer self);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
void dvb_recording_set_ChannelSid (DVBRecording* self, guint value);
void dvb_recording_set_ChannelName (DVBRecording* self, const gchar* value);
void dvb_timer_get_start_time_time (DVBTimer* self, struct tm* result);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
void dvb_recording_set_Name (DVBRecording* self, const gchar* value);
void dvb_recording_set_Description (DVBRecording* self, const gchar* value);
guint32 dvb_recording_get_Id (DVBRecording* self);
gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec);
time_t dvb_utils_difftime (struct tm* t1, struct tm* t2);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
const gchar* dvb_recording_get_ChannelName (DVBRecording* self);
gint64 dvb_recording_get_Length (DVBRecording* self);
void dvb_recording_save_to_disk (DVBRecording* self);
GstElement* dvb_timer_get_sink (DVBTimer* self);
void dvb_recording_monitor_recording (DVBRecording* self);
gchar* dvb_utils_remove_nonalphanums (const gchar* text);
GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self);
void dvb_utils_mkdirs (GFile* directory, GError** error);
gboolean dvb_timer_is_end_due (DVBTimer* self);
gboolean dvb_timer_is_start_due (DVBTimer* self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
const gchar* dvb_recording_get_Name (DVBRecording* self);
guint dvb_recording_get_ChannelSid (DVBRecording* self);
DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self);
static void dvb_recorder_set_DeviceGroup (DVBRecorder* self, DVBDeviceGroup* value);
guint dvb_recorder_get_count (DVBRecorder* self);
static GObject * dvb_recorder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir);
static void dvb_recorder_finalize (GObject* obj);
static void _vala_dvb_recorder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_recorder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev) {
	DVBRecorder * self = NULL;
	DVBDeviceGroup* _tmp0_ = NULL;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = dev;
	self = (DVBRecorder*) g_object_new (object_type, "DeviceGroup", _tmp0_, NULL);
	return self;
}


DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev) {
	return dvb_recorder_construct (DVB_TYPE_RECORDER, dev);
}


static GeeIterator* dvb_recorder_real_iterator (GeeIterable* base) {
	DVBRecorder * self;
	GeeIterator* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	GeeIterator* _tmp4_ = NULL;
	GeeIterator* _tmp5_ = NULL;
	self = (DVBRecorder*) base;
	_tmp0_ = self->priv->timers;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static gboolean dvb_recorder_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	DVBRecorder * self;
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	GeeIterator* _tmp4_ = NULL;
	GeeIterator* _tmp5_ = NULL;
	GeeForallFunc _tmp6_ = NULL;
	void* _tmp6__target = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	self = (DVBRecorder*) base;
	_tmp0_ = self->priv->timers;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = f;
	_tmp6__target = f_target;
	_tmp7_ = gee_traversable_foreach ((GeeTraversable*) _tmp5_, _tmp6_, _tmp6__target);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp8_;
	return result;
}


/**
         * @channel: Channel number
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @timer_id: The new timer's id on success, or 0 if timer couldn't
         * be created
         * @returns: TRUE on success
         *
         * Add a new timer
         */
static gboolean dvb_recorder_real_AddTimer (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	guint32 _vala_timer_id = 0U;
	gboolean result = FALSE;
	DVBTimer* new_timer = NULL;
	guint _tmp0_ = 0U;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	guint _tmp6_ = 0U;
	DVBTimer* _tmp7_ = NULL;
	DVBTimer* _tmp8_ = NULL;
	self = (DVBRecorder*) base;
	_tmp0_ = channel;
	_tmp1_ = start_year;
	_tmp2_ = start_month;
	_tmp3_ = start_day;
	_tmp4_ = start_hour;
	_tmp5_ = start_minute;
	_tmp6_ = duration;
	_tmp7_ = dvb_recorder_create_timer (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	new_timer = _tmp7_;
	_tmp8_ = new_timer;
	if (_tmp8_ == NULL) {
		_vala_timer_id = (guint32) 0;
		result = FALSE;
		_g_object_unref0 (new_timer);
		if (timer_id) {
			*timer_id = _vala_timer_id;
		}
		return result;
	} else {
		DVBTimer* _tmp9_ = NULL;
		guint32 _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = new_timer;
		_tmp11_ = dvb_recorder_add_timer (self, _tmp9_, &_tmp10_);
		_vala_timer_id = _tmp10_;
		result = _tmp11_;
		_g_object_unref0 (new_timer);
		if (timer_id) {
			*timer_id = _vala_timer_id;
		}
		return result;
	}
	_g_object_unref0 (new_timer);
	if (timer_id) {
		*timer_id = _vala_timer_id;
	}
}


/**
         * Works the same way as AddTimer() but adds a margin before and
         * after the timer.
         *
         * If the timer with added margins conflicts with a scheduled
         * recording the margins are removed and adding the timer will
         * be tried again.
         */
static gboolean dvb_recorder_real_AddTimerWithMargin (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	guint32 _vala_timer_id = 0U;
	gboolean result = FALSE;
	DVBTimer* new_timer = NULL;
	guint _tmp0_ = 0U;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	guint _tmp6_ = 0U;
	DVBTimer* _tmp7_ = NULL;
	DVBTimer* _tmp8_ = NULL;
	DVBSettings* settings = NULL;
	DVBFactory* _tmp9_ = NULL;
	DVBFactory* _tmp10_ = NULL;
	DVBSettings* _tmp11_ = NULL;
	DVBSettings* _tmp12_ = NULL;
	gint start_margin = 0;
	DVBSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	guint end_margin = 0U;
	DVBSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	DVBTimer* _tmp17_ = NULL;
	DVBTimer* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	DVBTimer* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gboolean ret = FALSE;
	DVBTimer* _tmp24_ = NULL;
	guint32 _tmp25_ = 0U;
	gboolean _tmp26_ = FALSE;
	self = (DVBRecorder*) base;
	_tmp0_ = channel;
	_tmp1_ = start_year;
	_tmp2_ = start_month;
	_tmp3_ = start_day;
	_tmp4_ = start_hour;
	_tmp5_ = start_minute;
	_tmp6_ = duration;
	_tmp7_ = dvb_recorder_create_timer (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	new_timer = _tmp7_;
	_tmp8_ = new_timer;
	if (_tmp8_ == NULL) {
		_vala_timer_id = (guint32) 0;
		result = FALSE;
		_g_object_unref0 (new_timer);
		if (timer_id) {
			*timer_id = _vala_timer_id;
		}
		return result;
	}
	_tmp9_ = dvb_factory_new ();
	_tmp10_ = _tmp9_;
	_tmp11_ = dvb_factory_get_settings (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	settings = _tmp12_;
	_tmp13_ = settings;
	_tmp14_ = dvb_settings_get_timers_margin_start (_tmp13_);
	start_margin = -1 * _tmp14_;
	_tmp15_ = settings;
	_tmp16_ = dvb_settings_get_timers_margin_end (_tmp15_);
	end_margin = (guint) (2 * _tmp16_);
	_tmp17_ = new_timer;
	_tmp18_ = new_timer;
	_tmp19_ = dvb_timer_get_Duration (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = end_margin;
	dvb_timer_set_Duration (_tmp18_, _tmp20_ + _tmp21_);
	_tmp22_ = new_timer;
	_tmp23_ = start_margin;
	dvb_timer_add_to_start_time (_tmp22_, _tmp23_);
	ret = TRUE;
	_tmp24_ = new_timer;
	_tmp26_ = dvb_recorder_add_timer (self, _tmp24_, &_tmp25_);
	_vala_timer_id = _tmp25_;
	if (!_tmp26_) {
		DVBTimer* _tmp27_ = NULL;
		DVBTimer* _tmp28_ = NULL;
		guint _tmp29_ = 0U;
		guint _tmp30_ = 0U;
		guint _tmp31_ = 0U;
		DVBTimer* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		DVBTimer* _tmp34_ = NULL;
		guint32 _tmp35_ = 0U;
		gboolean _tmp36_ = FALSE;
		_tmp27_ = new_timer;
		_tmp28_ = new_timer;
		_tmp29_ = dvb_timer_get_Duration (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = end_margin;
		dvb_timer_set_Duration (_tmp28_, _tmp30_ - _tmp31_);
		_tmp32_ = new_timer;
		_tmp33_ = start_margin;
		dvb_timer_add_to_start_time (_tmp32_, -1 * _tmp33_);
		_tmp34_ = new_timer;
		_tmp36_ = dvb_recorder_add_timer (self, _tmp34_, &_tmp35_);
		_vala_timer_id = _tmp35_;
		ret = _tmp36_;
	}
	result = ret;
	_g_object_unref0 (settings);
	_g_object_unref0 (new_timer);
	if (timer_id) {
		*timer_id = _vala_timer_id;
	}
	return result;
}


static gboolean _dvb_recorder_check_timers_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_recorder_check_timers ((DVBRecorder*) self);
	return result;
}


gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id) {
	guint32 _vala_timer_id = 0U;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	DVBTimer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp63_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_timer != NULL, FALSE);
	ret = FALSE;
	_vala_timer_id = (guint32) 0;
	_tmp0_ = new_timer;
	_tmp1_ = dvb_timer_has_expired (_tmp0_);
	if (_tmp1_) {
		result = ret;
		if (timer_id) {
			*timer_id = _vala_timer_id;
		}
		return result;
	}
	{
		GeeHashMap* _tmp2_ = NULL;
		_tmp2_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			gboolean has_conflict = FALSE;
			gint conflict_count = 0;
			gboolean _tmp32_ = FALSE;
			has_conflict = FALSE;
			conflict_count = 0;
			{
				GeeIterator* _key_it = NULL;
				GeeHashMap* _tmp3_ = NULL;
				GeeSet* _tmp4_ = NULL;
				GeeSet* _tmp5_ = NULL;
				GeeSet* _tmp6_ = NULL;
				GeeIterator* _tmp7_ = NULL;
				GeeIterator* _tmp8_ = NULL;
				_tmp3_ = self->priv->timers;
				_tmp4_ = gee_abstract_map_get_keys ((GeeMap*) _tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				_key_it = _tmp8_;
				while (TRUE) {
					GeeIterator* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					guint32 key = 0U;
					GeeIterator* _tmp11_ = NULL;
					gpointer _tmp12_ = NULL;
					GeeHashMap* _tmp13_ = NULL;
					guint32 _tmp14_ = 0U;
					gpointer _tmp15_ = NULL;
					DVBTimer* _tmp16_ = NULL;
					DVBTimer* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					_tmp9_ = _key_it;
					_tmp10_ = gee_iterator_next (_tmp9_);
					if (!_tmp10_) {
						break;
					}
					_tmp11_ = _key_it;
					_tmp12_ = gee_iterator_get (_tmp11_);
					key = (guint32) ((guintptr) _tmp12_);
					_tmp13_ = self->priv->timers;
					_tmp14_ = key;
					_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, (gpointer) ((guintptr) _tmp14_));
					_tmp16_ = (DVBTimer*) _tmp15_;
					_tmp17_ = new_timer;
					_tmp18_ = dvb_timer_conflicts_with (_tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					_g_object_unref0 (_tmp16_);
					if (_tmp19_) {
						gint _tmp20_ = 0;
						gint _tmp21_ = 0;
						DVBDeviceGroup* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						gint _tmp24_ = 0;
						_tmp20_ = conflict_count;
						conflict_count = _tmp20_ + 1;
						_tmp21_ = conflict_count;
						_tmp22_ = self->priv->_DeviceGroup;
						_tmp23_ = dvb_device_group_get_size (_tmp22_);
						_tmp24_ = _tmp23_;
						if (_tmp21_ >= _tmp24_) {
							DVBLoggingLogger* _tmp25_ = NULL;
							GeeHashMap* _tmp26_ = NULL;
							guint32 _tmp27_ = 0U;
							gpointer _tmp28_ = NULL;
							DVBTimer* _tmp29_ = NULL;
							gchar* _tmp30_ = NULL;
							gchar* _tmp31_ = NULL;
							_tmp25_ = dvb_recorder_log;
							_tmp26_ = self->priv->timers;
							_tmp27_ = key;
							_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, (gpointer) ((guintptr) _tmp27_));
							_tmp29_ = (DVBTimer*) _tmp28_;
							_tmp30_ = dvb_timer_to_string (_tmp29_);
							_tmp31_ = _tmp30_;
							dvb_logging_logger_debug (_tmp25_, "Recorder.vala:164: Timer is conflicting with another timer: %s", _tmp31_);
							_g_free0 (_tmp31_);
							_g_object_unref0 (_tmp29_);
							has_conflict = TRUE;
							break;
						}
					}
				}
				_g_object_unref0 (_key_it);
			}
			_tmp32_ = has_conflict;
			if (!_tmp32_) {
				GeeHashMap* _tmp33_ = NULL;
				DVBTimer* _tmp34_ = NULL;
				guint32 _tmp35_ = 0U;
				guint32 _tmp36_ = 0U;
				DVBTimer* _tmp37_ = NULL;
				gboolean _tmp52_ = FALSE;
				GeeHashMap* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				DVBTimer* _tmp59_ = NULL;
				guint32 _tmp60_ = 0U;
				guint32 _tmp61_ = 0U;
				_tmp33_ = self->priv->timers;
				_tmp34_ = new_timer;
				_tmp35_ = dvb_timer_get_Id (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = new_timer;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, (gpointer) ((guintptr) _tmp36_), _tmp37_);
				{
					gboolean _tmp38_ = FALSE;
					DVBFactory* _tmp39_ = NULL;
					DVBFactory* _tmp40_ = NULL;
					DVBdatabaseTimersStore* _tmp41_ = NULL;
					DVBdatabaseTimersStore* _tmp42_ = NULL;
					DVBTimer* _tmp43_ = NULL;
					DVBDeviceGroup* _tmp44_ = NULL;
					gboolean _tmp45_ = FALSE;
					gboolean _tmp46_ = FALSE;
					_tmp39_ = dvb_factory_new ();
					_tmp40_ = _tmp39_;
					_tmp41_ = dvb_factory_get_timers_store (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = new_timer;
					_tmp44_ = self->priv->_DeviceGroup;
					_tmp45_ = dvb_database_timers_store_add_timer_to_device_group (_tmp42_, _tmp43_, _tmp44_, &_inner_error_);
					_tmp46_ = _tmp45_;
					_g_object_unref0 (_tmp42_);
					_g_object_unref0 (_tmp40_);
					_tmp38_ = _tmp46_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch110_dvb_database_sql_error;
						}
						{
							GeeHashMap* _tmp47_ = NULL;
							_tmp47_ = self->priv->timers;
							g_rec_mutex_unlock (&self->priv->__lock_timers);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					ret = _tmp38_;
				}
				goto __finally110;
				__catch110_dvb_database_sql_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp48_ = NULL;
					GError* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp48_ = dvb_recorder_log;
					_tmp49_ = e;
					_tmp50_ = _tmp49_->message;
					dvb_logging_logger_error (_tmp48_, "Recorder.vala:178: %s", _tmp50_);
					_g_error_free0 (e);
				}
				__finally110:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					{
						GeeHashMap* _tmp51_ = NULL;
						_tmp51_ = self->priv->timers;
						g_rec_mutex_unlock (&self->priv->__lock_timers);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_tmp53_ = self->priv->timers;
				_tmp54_ = gee_abstract_map_get_size ((GeeMap*) _tmp53_);
				_tmp55_ = _tmp54_;
				if (_tmp55_ == 1) {
					gboolean _tmp56_ = FALSE;
					_tmp56_ = self->priv->have_check_timers_timeout;
					_tmp52_ = !_tmp56_;
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					DVBLoggingLogger* _tmp57_ = NULL;
					guint _tmp58_ = 0U;
					_tmp57_ = dvb_recorder_log;
					dvb_logging_logger_debug (_tmp57_, "Recorder.vala:182: Creating new check timers");
					_tmp58_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) DVB_RECORDER_CHECK_TIMERS_INTERVAL, _dvb_recorder_check_timers_gsource_func, g_object_ref (self), g_object_unref);
					self->priv->check_timers_event_id = _tmp58_;
					self->priv->have_check_timers_timeout = TRUE;
				}
				_tmp59_ = new_timer;
				_tmp60_ = dvb_timer_get_Id (_tmp59_);
				_tmp61_ = _tmp60_;
				_vala_timer_id = _tmp61_;
			}
		}
		__finally109:
		{
			GeeHashMap* _tmp62_ = NULL;
			_tmp62_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp63_ = ret;
	if (_tmp63_) {
		DVBTimer* _tmp64_ = NULL;
		guint32 _tmp65_ = 0U;
		guint32 _tmp66_ = 0U;
		_tmp64_ = new_timer;
		_tmp65_ = dvb_timer_get_Id (_tmp64_);
		_tmp66_ = _tmp65_;
		g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", _tmp66_, (guint) DVB_CHANGE_TYPE_ADDED);
	}
	result = ret;
	if (timer_id) {
		*timer_id = _vala_timer_id;
	}
	return result;
}


/**
         * @event_id: id of the EPG event
         * @channel_sid: SID of channel
         * @timer_id: The new timer's id on success, or 0 if timer couldn't
         * be created
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_AddTimerForEPGEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	guint32 _vala_timer_id = 0U;
	gboolean result = FALSE;
	DVBdatabaseEPGStore* epgstore = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseEPGStore* _tmp2_ = NULL;
	DVBdatabaseEPGStore* _tmp3_ = NULL;
	DVBEvent* event = NULL;
	DVBEvent* _tmp16_ = NULL;
	struct tm start = {0};
	DVBEvent* _tmp19_ = NULL;
	struct tm _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	guint _tmp22_ = 0U;
	struct tm _tmp23_ = {0};
	gint _tmp24_ = 0;
	struct tm _tmp25_ = {0};
	gint _tmp26_ = 0;
	struct tm _tmp27_ = {0};
	gint _tmp28_ = 0;
	struct tm _tmp29_ = {0};
	gint _tmp30_ = 0;
	struct tm _tmp31_ = {0};
	gint _tmp32_ = 0;
	DVBEvent* _tmp33_ = NULL;
	guint _tmp34_ = 0U;
	guint32 _tmp35_ = 0U;
	gboolean _tmp36_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_epg_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	epgstore = _tmp3_;
	event = NULL;
	{
		DVBEvent* _tmp4_ = NULL;
		DVBdatabaseEPGStore* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		DVBDeviceGroup* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		DVBEvent* _tmp11_ = NULL;
		DVBEvent* _tmp12_ = NULL;
		_tmp5_ = epgstore;
		_tmp6_ = event_id;
		_tmp7_ = channel_sid;
		_tmp8_ = self->priv->_DeviceGroup;
		_tmp9_ = dvb_device_group_get_Id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = dvb_database_epg_store_get_event (_tmp5_, _tmp6_, _tmp7_, _tmp10_, &_inner_error_);
		_tmp4_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch111_dvb_database_sql_error;
			}
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp12_ = _tmp4_;
		_tmp4_ = NULL;
		_dvb_event_unref0 (event);
		event = _tmp12_;
		_dvb_event_unref0 (_tmp4_);
	}
	goto __finally111;
	__catch111_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = dvb_recorder_log;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		dvb_logging_logger_error (_tmp13_, "Recorder.vala:213: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally111:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			return FALSE;
		} else {
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp16_ = event;
	if (_tmp16_ == NULL) {
		DVBLoggingLogger* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		_tmp17_ = dvb_recorder_log;
		_tmp18_ = event_id;
		dvb_logging_logger_debug (_tmp17_, "Recorder.vala:216: Could not find event with id %u", _tmp18_);
		_vala_timer_id = (guint32) 0;
		result = FALSE;
		_dvb_event_unref0 (event);
		_g_object_unref0 (epgstore);
		if (timer_id) {
			*timer_id = _vala_timer_id;
		}
		return result;
	}
	_tmp19_ = event;
	dvb_event_get_local_start_time (_tmp19_, &_tmp20_);
	start = _tmp20_;
	_tmp22_ = channel_sid;
	_tmp23_ = start;
	_tmp24_ = _tmp23_.tm_year;
	_tmp25_ = start;
	_tmp26_ = _tmp25_.tm_mon;
	_tmp27_ = start;
	_tmp28_ = _tmp27_.tm_mday;
	_tmp29_ = start;
	_tmp30_ = _tmp29_.tm_hour;
	_tmp31_ = start;
	_tmp32_ = _tmp31_.tm_min;
	_tmp33_ = event;
	_tmp34_ = _tmp33_->duration;
	_tmp36_ = dvb_id_bus_recorder_AddTimerWithMargin ((DVBIDBusRecorder*) self, _tmp22_, _tmp24_ + 1900, _tmp26_ + 1, _tmp28_, _tmp30_, _tmp32_, _tmp34_ / 60, &_tmp35_, &_inner_error_);
	_vala_timer_id = _tmp35_;
	_tmp21_ = _tmp36_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			return FALSE;
		} else {
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp21_;
	_dvb_event_unref0 (event);
	_g_object_unref0 (epgstore);
	if (timer_id) {
		*timer_id = _vala_timer_id;
	}
	return result;
}


/**
         * @timer_id: The id of the timer you want to delete
         * @returns: TRUE on success
         *
         * Delete timer. If the id belongs to the currently
         * active timer recording is aborted.
         */
static gboolean dvb_recorder_real_DeleteTimer (DVBIDBusRecorder* base, guint32 timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	guint32 _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	self = (DVBRecorder*) base;
	_tmp0_ = timer_id;
	_tmp1_ = dvb_recorder_delete_timer (self, _tmp0_);
	result = _tmp1_;
	return result;
}


gboolean dvb_recorder_delete_timer (DVBRecorder* self, guint32 timer_id) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp27_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	ret = FALSE;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				guint32 _tmp4_ = 0U;
				gboolean _tmp5_ = FALSE;
				GeeHashMap* _tmp10_ = NULL;
				guint32 _tmp11_ = 0U;
				_tmp4_ = timer_id;
				_tmp5_ = dvb_recorder_is_timer_active (self, _tmp4_);
				if (_tmp5_) {
					DVBTimer* timer = NULL;
					GeeHashMap* _tmp6_ = NULL;
					guint32 _tmp7_ = 0U;
					gpointer _tmp8_ = NULL;
					DVBTimer* _tmp9_ = NULL;
					_tmp6_ = self->priv->timers;
					_tmp7_ = timer_id;
					_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, (gpointer) ((guintptr) _tmp7_));
					timer = (DVBTimer*) _tmp8_;
					_tmp9_ = timer;
					dvb_recorder_stop_recording (self, _tmp9_);
					_g_object_unref0 (timer);
				}
				_tmp10_ = self->priv->timers;
				_tmp11_ = timer_id;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, (gpointer) ((guintptr) _tmp11_), NULL);
				{
					gboolean _tmp12_ = FALSE;
					DVBFactory* _tmp13_ = NULL;
					DVBFactory* _tmp14_ = NULL;
					DVBdatabaseTimersStore* _tmp15_ = NULL;
					DVBdatabaseTimersStore* _tmp16_ = NULL;
					guint32 _tmp17_ = 0U;
					DVBDeviceGroup* _tmp18_ = NULL;
					gboolean _tmp19_ = FALSE;
					gboolean _tmp20_ = FALSE;
					_tmp13_ = dvb_factory_new ();
					_tmp14_ = _tmp13_;
					_tmp15_ = dvb_factory_get_timers_store (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = timer_id;
					_tmp18_ = self->priv->_DeviceGroup;
					_tmp19_ = dvb_database_timers_store_remove_timer_from_device_group (_tmp16_, (guint) _tmp17_, _tmp18_, &_inner_error_);
					_tmp20_ = _tmp19_;
					_g_object_unref0 (_tmp16_);
					_g_object_unref0 (_tmp14_);
					_tmp12_ = _tmp20_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch113_dvb_database_sql_error;
						}
						{
							GeeHashMap* _tmp21_ = NULL;
							_tmp21_ = self->priv->timers;
							g_rec_mutex_unlock (&self->priv->__lock_timers);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					ret = _tmp12_;
				}
				goto __finally113;
				__catch113_dvb_database_sql_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp22_ = NULL;
					GError* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp22_ = dvb_recorder_log;
					_tmp23_ = e;
					_tmp24_ = _tmp23_->message;
					dvb_logging_logger_error (_tmp22_, "Recorder.vala:253: %s", _tmp24_);
					_g_error_free0 (e);
				}
				__finally113:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					{
						GeeHashMap* _tmp25_ = NULL;
						_tmp25_ = self->priv->timers;
						g_rec_mutex_unlock (&self->priv->__lock_timers);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
		}
		__finally112:
		{
			GeeHashMap* _tmp26_ = NULL;
			_tmp26_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp27_ = ret;
	if (_tmp27_) {
		guint32 _tmp28_ = 0U;
		_tmp28_ = timer_id;
		g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", _tmp28_, (guint) DVB_CHANGE_TYPE_DELETED);
	}
	result = ret;
	return result;
}


/**
         * dvb_recorder_GetTimers
         * @returns: A list of all timer ids
         */
static guint32* dvb_recorder_real_GetTimers (DVBIDBusRecorder* base, int* result_length1, GError** error) {
	DVBRecorder * self;
	guint32* result = NULL;
	guint32* timer_arr = NULL;
	gint timer_arr_length1 = 0;
	gint _timer_arr_size_ = 0;
	guint32* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			gint _tmp2_ = 0;
			gint _tmp3_ = 0;
			guint32* _tmp4_ = NULL;
			gint i = 0;
			_tmp1_ = self->priv->timers;
			_tmp2_ = gee_abstract_map_get_size ((GeeMap*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_new0 (guint32, _tmp3_);
			timer_arr = (g_free (timer_arr), NULL);
			timer_arr = _tmp4_;
			timer_arr_length1 = _tmp3_;
			_timer_arr_size_ = timer_arr_length1;
			i = 0;
			{
				GeeIterator* _key_it = NULL;
				GeeHashMap* _tmp5_ = NULL;
				GeeSet* _tmp6_ = NULL;
				GeeSet* _tmp7_ = NULL;
				GeeSet* _tmp8_ = NULL;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_ = NULL;
				_tmp5_ = self->priv->timers;
				_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_key_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					guint32 key = 0U;
					GeeIterator* _tmp13_ = NULL;
					gpointer _tmp14_ = NULL;
					guint32* _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gint _tmp16_ = 0;
					GeeHashMap* _tmp17_ = NULL;
					guint32 _tmp18_ = 0U;
					gpointer _tmp19_ = NULL;
					DVBTimer* _tmp20_ = NULL;
					guint32 _tmp21_ = 0U;
					guint32 _tmp22_ = 0U;
					guint32 _tmp23_ = 0U;
					gint _tmp24_ = 0;
					_tmp11_ = _key_it;
					_tmp12_ = gee_iterator_next (_tmp11_);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = _key_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					key = (guint32) ((guintptr) _tmp14_);
					_tmp15_ = timer_arr;
					_tmp15__length1 = timer_arr_length1;
					_tmp16_ = i;
					_tmp17_ = self->priv->timers;
					_tmp18_ = key;
					_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, (gpointer) ((guintptr) _tmp18_));
					_tmp20_ = (DVBTimer*) _tmp19_;
					_tmp21_ = dvb_timer_get_Id (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp15_[_tmp16_] = _tmp22_;
					_tmp23_ = _tmp15_[_tmp16_];
					_g_object_unref0 (_tmp20_);
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally114:
		{
			GeeHashMap* _tmp25_ = NULL;
			_tmp25_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				timer_arr = (g_free (timer_arr), NULL);
				return NULL;
			} else {
				timer_arr = (g_free (timer_arr), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp26_ = timer_arr;
	_tmp26__length1 = timer_arr_length1;
	if (result_length1) {
		*result_length1 = _tmp26__length1;
	}
	result = _tmp26_;
	return result;
}


/**
         * @timer_id: Timer's id
         * @start_time: An array of length 5, where index 0 = year, 1 = month,
         * 2 = day, 3 = hour and 4 = minute.
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetStartTime (DVBIDBusRecorder* base, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error) {
	DVBRecorder * self;
	guint32* _vala_start_time = NULL;
	int _vala_start_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				DVBTimer* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				guint* _tmp9_ = NULL;
				_tmp4_ = self->priv->timers;
				_tmp5_ = timer_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				_tmp7_ = (DVBTimer*) _tmp6_;
				_tmp9_ = dvb_timer_get_start_time (_tmp7_, &_tmp8_);
				_vala_start_time = (g_free (_vala_start_time), NULL);
				_vala_start_time = _tmp9_;
				_vala_start_time_length1 = _tmp8_;
				_g_object_unref0 (_tmp7_);
				ret = TRUE;
			} else {
				guint* _tmp10_ = NULL;
				_tmp10_ = g_new0 (guint, 0);
				_vala_start_time = (g_free (_vala_start_time), NULL);
				_vala_start_time = _tmp10_;
				_vala_start_time_length1 = 0;
				ret = FALSE;
			}
		}
		__finally115:
		{
			GeeHashMap* _tmp11_ = NULL;
			_tmp11_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (start_time) {
		*start_time = _vala_start_time;
	} else {
		_vala_start_time = (g_free (_vala_start_time), NULL);
	}
	if (start_time_length1) {
		*start_time_length1 = _vala_start_time_length1;
	}
	return result;
}


/**
          * @timer_id: The new timer's id on success, or 0 if timer couldn't
          * @start_year: The year when the recording should start
          * @start_month: The month when recording should start
          * @start_day: The day when recording should start
          * @start_hour: The hour when recording should start
          * @start_minute: The minute when recording should start
          * @duration: How long the channel should be recorded (in minutes)
          * @returns: TRUE on success
          */
static gboolean dvb_recorder_real_SetStartTime (DVBIDBusRecorder* base, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp31_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				gboolean _tmp4_ = FALSE;
				guint32 _tmp5_ = 0U;
				gboolean _tmp6_ = FALSE;
				_tmp5_ = timer_id;
				_tmp6_ = dvb_id_bus_recorder_IsTimerActive ((DVBIDBusRecorder*) self, _tmp5_, &_inner_error_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __finally116;
				}
				if (_tmp4_) {
					g_warning ("Recorder.vala:323: Cannot change start time of already active timer");
				} else {
					DVBTimer* timer = NULL;
					GeeHashMap* _tmp7_ = NULL;
					guint32 _tmp8_ = 0U;
					gpointer _tmp9_ = NULL;
					DVBTimer* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					_tmp7_ = self->priv->timers;
					_tmp8_ = timer_id;
					_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((guintptr) _tmp8_));
					timer = (DVBTimer*) _tmp9_;
					_tmp10_ = timer;
					_tmp11_ = start_year;
					_tmp12_ = start_month;
					_tmp13_ = start_day;
					_tmp14_ = start_hour;
					_tmp15_ = start_minute;
					dvb_timer_set_start_time (_tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
					{
						gboolean _tmp16_ = FALSE;
						DVBFactory* _tmp17_ = NULL;
						DVBFactory* _tmp18_ = NULL;
						DVBdatabaseTimersStore* _tmp19_ = NULL;
						DVBdatabaseTimersStore* _tmp20_ = NULL;
						DVBTimer* _tmp21_ = NULL;
						DVBDeviceGroup* _tmp22_ = NULL;
						gboolean _tmp23_ = FALSE;
						gboolean _tmp24_ = FALSE;
						_tmp17_ = dvb_factory_new ();
						_tmp18_ = _tmp17_;
						_tmp19_ = dvb_factory_get_timers_store (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = timer;
						_tmp22_ = self->priv->_DeviceGroup;
						_tmp23_ = dvb_database_timers_store_update_timer (_tmp20_, _tmp21_, _tmp22_, &_inner_error_);
						_tmp24_ = _tmp23_;
						_g_object_unref0 (_tmp20_);
						_g_object_unref0 (_tmp18_);
						_tmp16_ = _tmp24_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
								goto __catch117_dvb_database_sql_error;
							}
							_g_object_unref0 (timer);
							{
								GeeHashMap* _tmp25_ = NULL;
								_tmp25_ = self->priv->timers;
								g_rec_mutex_unlock (&self->priv->__lock_timers);
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						ret = _tmp16_;
					}
					goto __finally117;
					__catch117_dvb_database_sql_error:
					{
						GError* e = NULL;
						DVBLoggingLogger* _tmp26_ = NULL;
						GError* _tmp27_ = NULL;
						const gchar* _tmp28_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp26_ = dvb_recorder_log;
						_tmp27_ = e;
						_tmp28_ = _tmp27_->message;
						dvb_logging_logger_error (_tmp26_, "Recorder.vala:333: %s", _tmp28_);
						_g_error_free0 (e);
					}
					__finally117:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (timer);
						_g_object_unref0 (timer);
						{
							GeeHashMap* _tmp29_ = NULL;
							_tmp29_ = self->priv->timers;
							g_rec_mutex_unlock (&self->priv->__lock_timers);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_g_object_unref0 (timer);
				}
			}
		}
		__finally116:
		{
			GeeHashMap* _tmp30_ = NULL;
			_tmp30_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp31_ = ret;
	if (_tmp31_) {
		guint32 _tmp32_ = 0U;
		_tmp32_ = timer_id;
		g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", _tmp32_, (guint) DVB_CHANGE_TYPE_UPDATED);
	}
	result = ret;
	return result;
}


/**
         * @timer_id: Timer's id
         * @end_time: Same as dvb_recorder_GetStartTime()
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetEndTime (DVBIDBusRecorder* base, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error) {
	DVBRecorder * self;
	guint* _vala_end_time = NULL;
	int _vala_end_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				DVBTimer* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				guint* _tmp9_ = NULL;
				_tmp4_ = self->priv->timers;
				_tmp5_ = timer_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				_tmp7_ = (DVBTimer*) _tmp6_;
				_tmp9_ = dvb_timer_get_end_time (_tmp7_, &_tmp8_);
				_vala_end_time = (g_free (_vala_end_time), NULL);
				_vala_end_time = _tmp9_;
				_vala_end_time_length1 = _tmp8_;
				_g_object_unref0 (_tmp7_);
				ret = TRUE;
			} else {
				guint* _tmp10_ = NULL;
				_tmp10_ = g_new0 (guint, 0);
				_vala_end_time = (g_free (_vala_end_time), NULL);
				_vala_end_time = _tmp10_;
				_vala_end_time_length1 = 0;
				ret = FALSE;
			}
		}
		__finally118:
		{
			GeeHashMap* _tmp11_ = NULL;
			_tmp11_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (end_time) {
		*end_time = _vala_end_time;
	} else {
		_vala_end_time = (g_free (_vala_end_time), NULL);
	}
	if (end_time_length1) {
		*end_time_length1 = _vala_end_time_length1;
	}
	return result;
}


/**
         * @timer_id: Timer's id
         * @duration: Duration in seconds or 0 if there's no timer with
         * the given id
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint* duration, GError** error) {
	DVBRecorder * self;
	guint _vala_duration = 0U;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				DVBTimer* _tmp7_ = NULL;
				guint _tmp8_ = 0U;
				guint _tmp9_ = 0U;
				_tmp4_ = self->priv->timers;
				_tmp5_ = timer_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				_tmp7_ = (DVBTimer*) _tmp6_;
				_tmp8_ = dvb_timer_get_Duration (_tmp7_);
				_tmp9_ = _tmp8_;
				_vala_duration = _tmp9_;
				_g_object_unref0 (_tmp7_);
				ret = TRUE;
			} else {
				_vala_duration = (guint) 0;
			}
		}
		__finally119:
		{
			GeeHashMap* _tmp10_ = NULL;
			_tmp10_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (duration) {
		*duration = _vala_duration;
	}
	return result;
}


/**
         * @timer_id: Timer's id
         * @duration: Duration in minutes
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_SetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint duration, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp25_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			ret = _tmp3_;
			_tmp4_ = ret;
			if (_tmp4_) {
				DVBTimer* timer = NULL;
				GeeHashMap* _tmp5_ = NULL;
				guint32 _tmp6_ = 0U;
				gpointer _tmp7_ = NULL;
				DVBTimer* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				_tmp5_ = self->priv->timers;
				_tmp6_ = timer_id;
				_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) _tmp6_));
				timer = (DVBTimer*) _tmp7_;
				_tmp8_ = timer;
				_tmp9_ = duration;
				dvb_timer_set_Duration (_tmp8_, _tmp9_);
				{
					gboolean _tmp10_ = FALSE;
					DVBFactory* _tmp11_ = NULL;
					DVBFactory* _tmp12_ = NULL;
					DVBdatabaseTimersStore* _tmp13_ = NULL;
					DVBdatabaseTimersStore* _tmp14_ = NULL;
					DVBTimer* _tmp15_ = NULL;
					DVBDeviceGroup* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
					gboolean _tmp18_ = FALSE;
					_tmp11_ = dvb_factory_new ();
					_tmp12_ = _tmp11_;
					_tmp13_ = dvb_factory_get_timers_store (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = timer;
					_tmp16_ = self->priv->_DeviceGroup;
					_tmp17_ = dvb_database_timers_store_update_timer (_tmp14_, _tmp15_, _tmp16_, &_inner_error_);
					_tmp18_ = _tmp17_;
					_g_object_unref0 (_tmp14_);
					_g_object_unref0 (_tmp12_);
					_tmp10_ = _tmp18_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch121_dvb_database_sql_error;
						}
						_g_object_unref0 (timer);
						{
							GeeHashMap* _tmp19_ = NULL;
							_tmp19_ = self->priv->timers;
							g_rec_mutex_unlock (&self->priv->__lock_timers);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					ret = _tmp10_;
				}
				goto __finally121;
				__catch121_dvb_database_sql_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp20_ = NULL;
					GError* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp20_ = dvb_recorder_log;
					_tmp21_ = e;
					_tmp22_ = _tmp21_->message;
					dvb_logging_logger_error (_tmp20_, "Recorder.vala:406: %s", _tmp22_);
					_g_error_free0 (e);
				}
				__finally121:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (timer);
					_g_object_unref0 (timer);
					{
						GeeHashMap* _tmp23_ = NULL;
						_tmp23_ = self->priv->timers;
						g_rec_mutex_unlock (&self->priv->__lock_timers);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (timer);
			}
		}
		__finally120:
		{
			GeeHashMap* _tmp24_ = NULL;
			_tmp24_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp25_ = ret;
	if (_tmp25_) {
		guint32 _tmp26_ = 0U;
		_tmp26_ = timer_id;
		g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", _tmp26_, (guint) DVB_CHANGE_TYPE_UPDATED);
	}
	result = ret;
	return result;
}


/**
         * @timer_id: Timer's id
         * @name: The name of the channel the timer belongs to or an
         * empty string when a timer with the given id doesn't exist
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetChannelName (DVBIDBusRecorder* base, guint32 timer_id, gchar** name, GError** error) {
	DVBRecorder * self;
	gchar* _vala_name = NULL;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				DVBTimer* t = NULL;
				GeeHashMap* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				DVBTimer* _tmp7_ = NULL;
				DVBChannel* _tmp8_ = NULL;
				DVBChannel* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				_tmp4_ = self->priv->timers;
				_tmp5_ = timer_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				t = (DVBTimer*) _tmp6_;
				_tmp7_ = t;
				_tmp8_ = dvb_timer_get_Channel (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = dvb_channel_get_Name (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strdup (_tmp11_);
				_g_free0 (_vala_name);
				_vala_name = _tmp12_;
				ret = TRUE;
				_g_object_unref0 (t);
			} else {
				gchar* _tmp13_ = NULL;
				_tmp13_ = g_strdup ("");
				_g_free0 (_vala_name);
				_vala_name = _tmp13_;
				ret = FALSE;
			}
		}
		__finally122:
		{
			GeeHashMap* _tmp14_ = NULL;
			_tmp14_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	return result;
}


/**
         * @timer_id: Timer's id
         * @title: The name of the show the timer belongs to or an
         * empty string if the timer doesn't exist or has no information
         * about the title of the show
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetTitle (DVBIDBusRecorder* base, guint32 timer_id, gchar** title, GError** error) {
	DVBRecorder * self;
	gchar* _vala_title = NULL;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				DVBTimer* t = NULL;
				GeeHashMap* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				DVBEvent* event = NULL;
				DVBTimer* _tmp7_ = NULL;
				DVBChannel* _tmp8_ = NULL;
				DVBChannel* _tmp9_ = NULL;
				DVBSchedule* _tmp10_ = NULL;
				DVBSchedule* _tmp11_ = NULL;
				DVBTimer* _tmp12_ = NULL;
				guint _tmp13_ = 0U;
				guint _tmp14_ = 0U;
				DVBEvent* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				DVBEvent* _tmp17_ = NULL;
				gchar* _tmp20_ = NULL;
				_tmp4_ = self->priv->timers;
				_tmp5_ = timer_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				t = (DVBTimer*) _tmp6_;
				_tmp7_ = t;
				_tmp8_ = dvb_timer_get_Channel (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = dvb_channel_get_Schedule (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = t;
				_tmp13_ = dvb_timer_get_EventID (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = dvb_schedule_get_event (_tmp11_, _tmp14_);
				event = _tmp15_;
				_tmp17_ = event;
				if (_tmp17_ == NULL) {
					_tmp16_ = "";
				} else {
					DVBEvent* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					_tmp18_ = event;
					_tmp19_ = _tmp18_->name;
					_tmp16_ = _tmp19_;
				}
				_tmp20_ = g_strdup (_tmp16_);
				_g_free0 (_vala_title);
				_vala_title = _tmp20_;
				ret = TRUE;
				_dvb_event_unref0 (event);
				_g_object_unref0 (t);
			} else {
				gchar* _tmp21_ = NULL;
				_tmp21_ = g_strdup ("");
				_g_free0 (_vala_title);
				_vala_title = _tmp21_;
			}
		}
		__finally123:
		{
			GeeHashMap* _tmp22_ = NULL;
			_tmp22_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (title) {
		*title = _vala_title;
	} else {
		_g_free0 (_vala_title);
	}
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean dvb_recorder_real_GetAllInformations (DVBIDBusRecorder* base, guint32 timer_id, DVBTimerInfo* info, GError** error) {
	DVBRecorder * self;
	DVBTimerInfo _vala_info = {0};
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	dvb_timer_info_destroy (&_vala_info);
	memset (&_vala_info, 0, sizeof (DVBTimerInfo));
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint32 _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->timers;
			_tmp2_ = timer_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				DVBTimer* t = NULL;
				GeeHashMap* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				guint32 _tmp7_ = 0U;
				DVBTimer* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				GeeSet* _tmp11_ = NULL;
				guint32 _tmp12_ = 0U;
				gboolean _tmp13_ = FALSE;
				DVBChannel* chan = NULL;
				DVBTimer* _tmp14_ = NULL;
				DVBChannel* _tmp15_ = NULL;
				DVBChannel* _tmp16_ = NULL;
				DVBChannel* _tmp17_ = NULL;
				DVBChannel* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				DVBEvent* event = NULL;
				DVBChannel* _tmp22_ = NULL;
				DVBSchedule* _tmp23_ = NULL;
				DVBSchedule* _tmp24_ = NULL;
				DVBTimer* _tmp25_ = NULL;
				guint _tmp26_ = 0U;
				guint _tmp27_ = 0U;
				DVBEvent* _tmp28_ = NULL;
				DVBEvent* _tmp29_ = NULL;
				_tmp4_ = self->priv->timers;
				_tmp5_ = timer_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				t = (DVBTimer*) _tmp6_;
				_tmp7_ = timer_id;
				_vala_info.id = _tmp7_;
				_tmp8_ = t;
				_tmp9_ = dvb_timer_get_Duration (_tmp8_);
				_tmp10_ = _tmp9_;
				_vala_info.duration = _tmp10_;
				_tmp11_ = self->priv->active_timers;
				_tmp12_ = timer_id;
				_tmp13_ = gee_collection_contains ((GeeCollection*) _tmp11_, (gpointer) ((guintptr) _tmp12_));
				_vala_info.active = _tmp13_;
				_tmp14_ = t;
				_tmp15_ = dvb_timer_get_Channel (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				chan = _tmp17_;
				_tmp18_ = chan;
				_tmp19_ = dvb_channel_get_Name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strdup (_tmp20_);
				_g_free0 (_vala_info.channel_name);
				_vala_info.channel_name = _tmp21_;
				_tmp22_ = chan;
				_tmp23_ = dvb_channel_get_Schedule (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = t;
				_tmp26_ = dvb_timer_get_EventID (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = dvb_schedule_get_event (_tmp24_, _tmp27_);
				event = _tmp28_;
				_tmp29_ = event;
				if (_tmp29_ != NULL) {
					DVBEvent* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					_tmp30_ = event;
					_tmp31_ = _tmp30_->name;
					_tmp32_ = g_strdup (_tmp31_);
					_g_free0 (_vala_info.title);
					_vala_info.title = _tmp32_;
				} else {
					gchar* _tmp33_ = NULL;
					_tmp33_ = g_strdup ("");
					_g_free0 (_vala_info.title);
					_vala_info.title = _tmp33_;
				}
				ret = TRUE;
				_dvb_event_unref0 (event);
				_g_object_unref0 (chan);
				_g_object_unref0 (t);
			} else {
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				_vala_info.id = (guint32) 0;
				_vala_info.duration = (guint) 0;
				_vala_info.active = FALSE;
				_tmp34_ = g_strdup ("");
				_g_free0 (_vala_info.channel_name);
				_vala_info.channel_name = _tmp34_;
				_tmp35_ = g_strdup ("");
				_g_free0 (_vala_info.title);
				_vala_info.title = _tmp35_;
				ret = FALSE;
			}
		}
		__finally124:
		{
			GeeHashMap* _tmp36_ = NULL;
			_tmp36_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (info) {
		*info = _vala_info;
	} else {
		dvb_timer_info_destroy (&_vala_info);
	}
	return result;
}


/**
         * @returns: The currently active timers
         */
static guint32* dvb_recorder_real_GetActiveTimers (DVBIDBusRecorder* base, int* result_length1, GError** error) {
	DVBRecorder * self;
	guint32* result = NULL;
	guint32* val = NULL;
	GeeSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint32* _tmp3_ = NULL;
	gint val_length1 = 0;
	gint _val_size_ = 0;
	gint i = 0;
	guint32* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	self = (DVBRecorder*) base;
	_tmp0_ = self->priv->active_timers;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (guint32, _tmp2_);
	val = _tmp3_;
	val_length1 = _tmp2_;
	_val_size_ = val_length1;
	i = 0;
	{
		GeeIterator* _timer_id_it = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp4_ = self->priv->active_timers;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_timer_id_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			guint32 timer_id = 0U;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			DVBTimer* timer = NULL;
			GeeHashMap* _tmp10_ = NULL;
			guint32 _tmp11_ = 0U;
			gpointer _tmp12_ = NULL;
			guint32* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			gint _tmp14_ = 0;
			DVBTimer* _tmp15_ = NULL;
			guint32 _tmp16_ = 0U;
			guint32 _tmp17_ = 0U;
			guint32 _tmp18_ = 0U;
			gint _tmp19_ = 0;
			_tmp6_ = _timer_id_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _timer_id_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			timer_id = (guint32) ((guintptr) _tmp9_);
			_tmp10_ = self->priv->timers;
			_tmp11_ = timer_id;
			_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, (gpointer) ((guintptr) _tmp11_));
			timer = (DVBTimer*) _tmp12_;
			_tmp13_ = val;
			_tmp13__length1 = val_length1;
			_tmp14_ = i;
			_tmp15_ = timer;
			_tmp16_ = dvb_timer_get_Id (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp13_[_tmp14_] = _tmp17_;
			_tmp18_ = _tmp13_[_tmp14_];
			_tmp19_ = i;
			i = _tmp19_ + 1;
			_g_object_unref0 (timer);
		}
		_g_object_unref0 (_timer_id_it);
	}
	_tmp20_ = val;
	_tmp20__length1 = val_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE if timer is currently active
         */
static gboolean dvb_recorder_real_IsTimerActive (DVBIDBusRecorder* base, guint32 timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	guint32 _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	self = (DVBRecorder*) base;
	_tmp0_ = timer_id;
	_tmp1_ = dvb_recorder_is_timer_active (self, _tmp0_);
	result = _tmp1_;
	return result;
}


gboolean dvb_recorder_is_timer_active (DVBRecorder* self, guint32 timer_id) {
	gboolean result = FALSE;
	GeeSet* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->active_timers;
	_tmp1_ = timer_id;
	_tmp2_ = gee_collection_contains ((GeeCollection*) _tmp0_, (gpointer) ((guintptr) _tmp1_));
	result = _tmp2_;
	return result;
}


/**
         * @returns: TRUE if a timer is already scheduled in the given
         * period of time
         */
static gboolean dvb_recorder_real_HasTimer (DVBIDBusRecorder* base, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	val = FALSE;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			{
				GeeIterator* _key_it = NULL;
				GeeHashMap* _tmp1_ = NULL;
				GeeSet* _tmp2_ = NULL;
				GeeSet* _tmp3_ = NULL;
				GeeSet* _tmp4_ = NULL;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_ = NULL;
				_tmp1_ = self->priv->timers;
				_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_key_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					guint32 key = 0U;
					GeeIterator* _tmp9_ = NULL;
					gpointer _tmp10_ = NULL;
					DVBOverlapType overlap = 0;
					GeeHashMap* _tmp11_ = NULL;
					guint32 _tmp12_ = 0U;
					gpointer _tmp13_ = NULL;
					DVBTimer* _tmp14_ = NULL;
					guint _tmp15_ = 0U;
					guint _tmp16_ = 0U;
					guint _tmp17_ = 0U;
					guint _tmp18_ = 0U;
					guint _tmp19_ = 0U;
					guint _tmp20_ = 0U;
					DVBOverlapType _tmp21_ = 0;
					DVBOverlapType _tmp22_ = 0;
					gboolean _tmp23_ = FALSE;
					DVBOverlapType _tmp24_ = 0;
					_tmp7_ = _key_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _key_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					key = (guint32) ((guintptr) _tmp10_);
					_tmp11_ = self->priv->timers;
					_tmp12_ = key;
					_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((guintptr) _tmp12_));
					_tmp14_ = (DVBTimer*) _tmp13_;
					_tmp15_ = start_year;
					_tmp16_ = start_month;
					_tmp17_ = start_day;
					_tmp18_ = start_hour;
					_tmp19_ = start_minute;
					_tmp20_ = duration;
					_tmp21_ = dvb_timer_get_overlap_local (_tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
					_tmp22_ = _tmp21_;
					_g_object_unref0 (_tmp14_);
					overlap = _tmp22_;
					_tmp24_ = overlap;
					if (_tmp24_ == DVB_OVERLAP_TYPE_PARTIAL) {
						_tmp23_ = TRUE;
					} else {
						DVBOverlapType _tmp25_ = 0;
						_tmp25_ = overlap;
						_tmp23_ = _tmp25_ == DVB_OVERLAP_TYPE_COMPLETE;
					}
					if (_tmp23_) {
						val = TRUE;
						break;
					}
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally125:
		{
			GeeHashMap* _tmp26_ = NULL;
			_tmp26_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = val;
	return result;
}


static DVBOverlapType dvb_recorder_real_HasTimerForEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, GError** error) {
	DVBRecorder * self;
	DVBOverlapType result = 0;
	DVBdatabaseEPGStore* epgstore = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseEPGStore* _tmp2_ = NULL;
	DVBdatabaseEPGStore* _tmp3_ = NULL;
	DVBEvent* event = NULL;
	DVBEvent* _tmp15_ = NULL;
	DVBOverlapType val = 0;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_epg_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	epgstore = _tmp3_;
	event = NULL;
	{
		DVBEvent* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		DVBDeviceGroup* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		DVBEvent* _tmp10_ = NULL;
		DVBEvent* _tmp11_ = NULL;
		_tmp5_ = event_id;
		_tmp6_ = channel_sid;
		_tmp7_ = self->priv->_DeviceGroup;
		_tmp8_ = dvb_device_group_get_Id (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = dvb_database_epg_store_get_event (epgstore, _tmp5_, _tmp6_, _tmp9_, &_inner_error_);
		_tmp4_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch126_dvb_database_sql_error;
			}
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp11_ = _tmp4_;
		_tmp4_ = NULL;
		_dvb_event_unref0 (event);
		event = _tmp11_;
		_dvb_event_unref0 (_tmp4_);
	}
	goto __finally126;
	__catch126_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = dvb_recorder_log;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		dvb_logging_logger_error (_tmp12_, "Recorder.vala:562: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally126:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			return 0;
		} else {
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp15_ = event;
	if (_tmp15_ == NULL) {
		DVBLoggingLogger* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		_tmp16_ = dvb_recorder_log;
		_tmp17_ = event_id;
		dvb_logging_logger_debug (_tmp16_, "Recorder.vala:565: Could not find event with id %u", _tmp17_);
		result = DVB_OVERLAP_TYPE_UNKNOWN;
		_dvb_event_unref0 (event);
		_g_object_unref0 (epgstore);
		return result;
	}
	val = DVB_OVERLAP_TYPE_NONE;
	{
		GeeHashMap* _tmp18_ = NULL;
		_tmp18_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			{
				GeeIterator* _key_it = NULL;
				GeeHashMap* _tmp19_ = NULL;
				GeeSet* _tmp20_ = NULL;
				GeeSet* _tmp21_ = NULL;
				GeeSet* _tmp22_ = NULL;
				GeeIterator* _tmp23_ = NULL;
				GeeIterator* _tmp24_ = NULL;
				_tmp19_ = self->priv->timers;
				_tmp20_ = gee_abstract_map_get_keys ((GeeMap*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = _tmp21_;
				_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp22_);
				_key_it = _tmp24_;
				while (TRUE) {
					GeeIterator* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
					guint32 key = 0U;
					GeeIterator* _tmp27_ = NULL;
					gpointer _tmp28_ = NULL;
					DVBTimer* timer = NULL;
					GeeHashMap* _tmp29_ = NULL;
					guint32 _tmp30_ = 0U;
					gpointer _tmp31_ = NULL;
					DVBTimer* _tmp32_ = NULL;
					DVBChannel* _tmp33_ = NULL;
					DVBChannel* _tmp34_ = NULL;
					guint _tmp35_ = 0U;
					guint _tmp36_ = 0U;
					guint _tmp37_ = 0U;
					_tmp25_ = _key_it;
					_tmp26_ = gee_iterator_next (_tmp25_);
					if (!_tmp26_) {
						break;
					}
					_tmp27_ = _key_it;
					_tmp28_ = gee_iterator_get (_tmp27_);
					key = (guint32) ((guintptr) _tmp28_);
					_tmp29_ = self->priv->timers;
					_tmp30_ = key;
					_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, (gpointer) ((guintptr) _tmp30_));
					timer = (DVBTimer*) _tmp31_;
					_tmp32_ = timer;
					_tmp33_ = dvb_timer_get_Channel (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = dvb_channel_get_Sid (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = channel_sid;
					if (_tmp36_ == _tmp37_) {
						DVBOverlapType overlap = 0;
						DVBTimer* _tmp38_ = NULL;
						DVBEvent* _tmp39_ = NULL;
						guint _tmp40_ = 0U;
						DVBEvent* _tmp41_ = NULL;
						guint _tmp42_ = 0U;
						DVBEvent* _tmp43_ = NULL;
						guint _tmp44_ = 0U;
						DVBEvent* _tmp45_ = NULL;
						guint _tmp46_ = 0U;
						DVBEvent* _tmp47_ = NULL;
						guint _tmp48_ = 0U;
						DVBEvent* _tmp49_ = NULL;
						guint _tmp50_ = 0U;
						DVBOverlapType _tmp51_ = 0;
						gboolean _tmp52_ = FALSE;
						DVBOverlapType _tmp53_ = 0;
						_tmp38_ = timer;
						_tmp39_ = event;
						_tmp40_ = _tmp39_->year;
						_tmp41_ = event;
						_tmp42_ = _tmp41_->month;
						_tmp43_ = event;
						_tmp44_ = _tmp43_->day;
						_tmp45_ = event;
						_tmp46_ = _tmp45_->hour;
						_tmp47_ = event;
						_tmp48_ = _tmp47_->minute;
						_tmp49_ = event;
						_tmp50_ = _tmp49_->duration;
						_tmp51_ = dvb_timer_get_overlap_utc (_tmp38_, _tmp40_, _tmp42_, _tmp44_, _tmp46_, _tmp48_, _tmp50_ / 60);
						overlap = _tmp51_;
						_tmp53_ = overlap;
						if (_tmp53_ == DVB_OVERLAP_TYPE_PARTIAL) {
							_tmp52_ = TRUE;
						} else {
							DVBOverlapType _tmp54_ = 0;
							_tmp54_ = overlap;
							_tmp52_ = _tmp54_ == DVB_OVERLAP_TYPE_COMPLETE;
						}
						if (_tmp52_) {
							DVBOverlapType _tmp55_ = 0;
							_tmp55_ = overlap;
							val = _tmp55_;
							_g_object_unref0 (timer);
							break;
						}
					}
					_g_object_unref0 (timer);
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally127:
		{
			GeeHashMap* _tmp56_ = NULL;
			_tmp56_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_dvb_event_unref0 (event);
				_g_object_unref0 (epgstore);
				return 0;
			} else {
				_dvb_event_unref0 (event);
				_g_object_unref0 (epgstore);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = val;
	_dvb_event_unref0 (event);
	_g_object_unref0 (epgstore);
	return result;
}


void dvb_recorder_stop (DVBRecorder* self) {
	guint _tmp0_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->check_timers_event_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->check_timers_event_id;
		g_source_remove (_tmp1_);
	}
	{
		GeeHashMap* _tmp2_ = NULL;
		_tmp2_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			{
				GeeIterator* _timer_id_it = NULL;
				GeeSet* _tmp3_ = NULL;
				GeeIterator* _tmp4_ = NULL;
				_tmp3_ = self->priv->active_timers;
				_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
				_timer_id_it = _tmp4_;
				while (TRUE) {
					GeeIterator* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					guint32 timer_id = 0U;
					GeeIterator* _tmp7_ = NULL;
					gpointer _tmp8_ = NULL;
					DVBTimer* timer = NULL;
					GeeHashMap* _tmp9_ = NULL;
					guint32 _tmp10_ = 0U;
					gpointer _tmp11_ = NULL;
					DVBTimer* _tmp12_ = NULL;
					_tmp5_ = _timer_id_it;
					_tmp6_ = gee_iterator_next (_tmp5_);
					if (!_tmp6_) {
						break;
					}
					_tmp7_ = _timer_id_it;
					_tmp8_ = gee_iterator_get (_tmp7_);
					timer_id = (guint32) ((guintptr) _tmp8_);
					_tmp9_ = self->priv->timers;
					_tmp10_ = timer_id;
					_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, (gpointer) ((guintptr) _tmp10_));
					timer = (DVBTimer*) _tmp11_;
					_tmp12_ = timer;
					dvb_recorder_stop_recording (self, _tmp12_);
					_g_object_unref0 (timer);
				}
				_g_object_unref0 (_timer_id_it);
			}
		}
		__finally128:
		{
			GeeHashMap* _tmp13_ = NULL;
			_tmp13_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBTimer* dvb_recorder_create_timer (DVBRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DVBTimer* result = NULL;
	DVBLoggingLogger* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	guint _tmp7_ = 0U;
	DVBChannelList* channels = NULL;
	DVBDeviceGroup* _tmp8_ = NULL;
	DVBChannelList* _tmp9_ = NULL;
	DVBChannelList* _tmp10_ = NULL;
	DVBChannelList* _tmp11_ = NULL;
	DVBChannelList* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gboolean _tmp14_ = FALSE;
	guint32 timer_id = 0U;
	DVBRecordingsStore* _tmp19_ = NULL;
	guint32 _tmp20_ = 0U;
	DVBTimer* new_timer = NULL;
	guint32 _tmp21_ = 0U;
	DVBDeviceGroup* _tmp22_ = NULL;
	DVBChannelList* _tmp23_ = NULL;
	DVBChannelList* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	DVBChannel* _tmp26_ = NULL;
	DVBChannel* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	guint _tmp33_ = 0U;
	DVBTimer* _tmp34_ = NULL;
	DVBTimer* _tmp35_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_recorder_log;
	_tmp1_ = channel;
	_tmp2_ = start_year;
	_tmp3_ = start_month;
	_tmp4_ = start_day;
	_tmp5_ = start_hour;
	_tmp6_ = start_minute;
	_tmp7_ = duration;
	dvb_logging_logger_debug (_tmp0_, "Recorder.vala:605: Creating new timer: channel: %u, start: %04d-%02d-%" \
"02d %02d:%02d, duration: %u", _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = self->priv->_DeviceGroup;
	_tmp9_ = dvb_device_group_get_Channels (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	channels = _tmp11_;
	_tmp12_ = channels;
	_tmp13_ = channel;
	_tmp14_ = dvb_channel_list_contains (_tmp12_, _tmp13_);
	if (!_tmp14_) {
		guint _tmp15_ = 0U;
		DVBDeviceGroup* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		guint _tmp18_ = 0U;
		_tmp15_ = channel;
		_tmp16_ = self->priv->_DeviceGroup;
		_tmp17_ = dvb_device_group_get_Id (_tmp16_);
		_tmp18_ = _tmp17_;
		g_warning ("Recorder.vala:611: No channel %u for device group %u", _tmp15_, _tmp18_);
		result = NULL;
		_g_object_unref0 (channels);
		return result;
	}
	_tmp19_ = dvb_recordings_store_get_instance ();
	_tmp20_ = dvb_recordings_store_get_next_id (_tmp19_);
	timer_id = _tmp20_;
	_tmp21_ = timer_id;
	_tmp22_ = self->priv->_DeviceGroup;
	_tmp23_ = dvb_device_group_get_Channels (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = channel;
	_tmp26_ = dvb_channel_list_get_channel (_tmp24_, _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = start_year;
	_tmp29_ = start_month;
	_tmp30_ = start_day;
	_tmp31_ = start_hour;
	_tmp32_ = start_minute;
	_tmp33_ = duration;
	_tmp34_ = dvb_timer_new (_tmp21_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_, _tmp33_);
	_tmp35_ = _tmp34_;
	_g_object_unref0 (_tmp27_);
	new_timer = _tmp35_;
	result = new_timer;
	_g_object_unref0 (channels);
	return result;
}


/**
         * Start recording of specified timer
         */
static void _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure (DVBPlayerThread* _sender, GstMpegtsSection* section, gpointer self) {
	dvb_recorder_on_eit_structure ((DVBRecorder*) self, _sender, section);
}


void dvb_recorder_start_recording (DVBRecorder* self, DVBTimer* timer) {
	DVBChannel* channel = NULL;
	DVBTimer* _tmp0_ = NULL;
	DVBChannel* _tmp1_ = NULL;
	DVBChannel* _tmp2_ = NULL;
	DVBChannel* _tmp3_ = NULL;
	GFile* location = NULL;
	DVBChannel* _tmp4_ = NULL;
	DVBTimer* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	guint* _tmp7_ = NULL;
	guint* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GstElement* filesink = NULL;
	GstElement* _tmp12_ = NULL;
	GstElement* _tmp13_ = NULL;
	GstElement* _tmp15_ = NULL;
	GFile* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	DVBTimer* _tmp19_ = NULL;
	GstElement* _tmp20_ = NULL;
	DVBChannelFactory* channel_factory = NULL;
	DVBDeviceGroup* _tmp21_ = NULL;
	DVBChannelFactory* _tmp22_ = NULL;
	DVBChannelFactory* _tmp23_ = NULL;
	DVBChannelFactory* _tmp24_ = NULL;
	DVBPlayerThread* player = NULL;
	DVBChannelFactory* _tmp25_ = NULL;
	DVBChannel* _tmp26_ = NULL;
	GstElement* _tmp27_ = NULL;
	GstElement* _tmp28_ = NULL;
	DVBPlayerThread* _tmp29_ = NULL;
	DVBPlayerThread* _tmp30_ = NULL;
	GeeSet* _tmp94_ = NULL;
	DVBTimer* _tmp95_ = NULL;
	guint32 _tmp96_ = 0U;
	guint32 _tmp97_ = 0U;
	DVBTimer* _tmp98_ = NULL;
	guint32 _tmp99_ = 0U;
	guint32 _tmp100_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	_tmp0_ = timer;
	_tmp1_ = dvb_timer_get_Channel (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	channel = _tmp3_;
	_tmp4_ = channel;
	_tmp5_ = timer;
	_tmp7_ = dvb_timer_get_start_time (_tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp9_ = dvb_recorder_create_recording_dirs (self, _tmp4_, _tmp8_, _tmp6_);
	_tmp10_ = _tmp9_;
	_tmp8_ = (g_free (_tmp8_), NULL);
	location = _tmp10_;
	_tmp11_ = location;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (location);
		_g_object_unref0 (channel);
		return;
	}
	_tmp12_ = gst_element_factory_make ("filesink", NULL);
	if (_tmp12_ != NULL) {
		g_object_ref_sink (_tmp12_);
	}
	filesink = _tmp12_;
	_tmp13_ = filesink;
	if (_tmp13_ == NULL) {
		DVBLoggingLogger* _tmp14_ = NULL;
		_tmp14_ = dvb_recorder_log;
		dvb_logging_logger_error (_tmp14_, "Recorder.vala:637: Could not create filesink element");
		_g_object_unref0 (filesink);
		_g_object_unref0 (location);
		_g_object_unref0 (channel);
		return;
	}
	_tmp15_ = filesink;
	_tmp16_ = location;
	_tmp17_ = g_file_get_path (_tmp16_);
	_tmp18_ = _tmp17_;
	g_object_set ((GObject*) _tmp15_, "location", _tmp18_, NULL);
	_g_free0 (_tmp18_);
	_tmp19_ = timer;
	_tmp20_ = filesink;
	dvb_timer_set_sink (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->_DeviceGroup;
	_tmp22_ = dvb_device_group_get_channel_factory (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	channel_factory = _tmp24_;
	_tmp25_ = channel_factory;
	_tmp26_ = channel;
	_tmp27_ = filesink;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_tmp29_ = dvb_channel_factory_watch_channel (_tmp25_, _tmp26_, _tmp28_, TRUE, NULL, NULL);
	player = _tmp29_;
	_tmp30_ = player;
	if (_tmp30_ != NULL) {
		DVBLoggingLogger* _tmp31_ = NULL;
		GstStateChangeReturn ret = 0;
		DVBPlayerThread* _tmp32_ = NULL;
		GstElement* _tmp33_ = NULL;
		GstElement* _tmp34_ = NULL;
		GstStateChangeReturn _tmp35_ = 0;
		GstStateChangeReturn _tmp36_ = 0;
		GstStateChangeReturn _tmp37_ = 0;
		DVBPlayerThread* _tmp42_ = NULL;
		DVBRecording* recording = NULL;
		DVBRecording* _tmp43_ = NULL;
		DVBRecording* _tmp44_ = NULL;
		DVBTimer* _tmp45_ = NULL;
		guint32 _tmp46_ = 0U;
		guint32 _tmp47_ = 0U;
		DVBRecording* _tmp48_ = NULL;
		DVBChannel* _tmp49_ = NULL;
		guint _tmp50_ = 0U;
		guint _tmp51_ = 0U;
		DVBRecording* _tmp52_ = NULL;
		DVBChannel* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		DVBRecording* _tmp56_ = NULL;
		DVBTimer* _tmp57_ = NULL;
		struct tm _tmp58_ = {0};
		DVBRecording* _tmp59_ = NULL;
		GFile* _tmp60_ = NULL;
		DVBRecording* _tmp61_ = NULL;
		DVBRecording* _tmp62_ = NULL;
		DVBTimer* _tmp63_ = NULL;
		guint _tmp64_ = 0U;
		guint _tmp65_ = 0U;
		DVBRecordingsStore* _tmp92_ = NULL;
		DVBRecording* _tmp93_ = NULL;
		_tmp31_ = dvb_recorder_log;
		dvb_logging_logger_debug (_tmp31_, "Recorder.vala:647: Setting pipeline to playing");
		_tmp32_ = player;
		_tmp33_ = dvb_player_thread_get_pipeline (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = gst_element_set_state (_tmp34_, GST_STATE_PLAYING);
		_tmp36_ = _tmp35_;
		_g_object_unref0 (_tmp34_);
		ret = _tmp36_;
		_tmp37_ = ret;
		if (_tmp37_ == GST_STATE_CHANGE_FAILURE) {
			DVBLoggingLogger* _tmp38_ = NULL;
			DVBChannelFactory* _tmp39_ = NULL;
			DVBChannel* _tmp40_ = NULL;
			GstElement* _tmp41_ = NULL;
			_tmp38_ = dvb_recorder_log;
			dvb_logging_logger_error (_tmp38_, "Recorder.vala:651: Failed setting pipeline to playing");
			_tmp39_ = channel_factory;
			_tmp40_ = channel;
			_tmp41_ = filesink;
			dvb_channel_factory_stop_channel (_tmp39_, _tmp40_, _tmp41_);
			_g_object_unref0 (player);
			_g_object_unref0 (channel_factory);
			_g_object_unref0 (filesink);
			_g_object_unref0 (location);
			_g_object_unref0 (channel);
			return;
		}
		_tmp42_ = player;
		g_signal_connect_object (_tmp42_, "eit-structure", (GCallback) _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure, self, 0);
		_tmp43_ = dvb_recording_new ();
		recording = _tmp43_;
		_tmp44_ = recording;
		_tmp45_ = timer;
		_tmp46_ = dvb_timer_get_Id (_tmp45_);
		_tmp47_ = _tmp46_;
		dvb_recording_set_Id (_tmp44_, _tmp47_);
		_tmp48_ = recording;
		_tmp49_ = channel;
		_tmp50_ = dvb_channel_get_Sid (_tmp49_);
		_tmp51_ = _tmp50_;
		dvb_recording_set_ChannelSid (_tmp48_, _tmp51_);
		_tmp52_ = recording;
		_tmp53_ = channel;
		_tmp54_ = dvb_channel_get_Name (_tmp53_);
		_tmp55_ = _tmp54_;
		dvb_recording_set_ChannelName (_tmp52_, _tmp55_);
		_tmp56_ = recording;
		_tmp57_ = timer;
		dvb_timer_get_start_time_time (_tmp57_, &_tmp58_);
		dvb_recording_set_StartTime (_tmp56_, &_tmp58_);
		_tmp59_ = recording;
		_tmp60_ = location;
		dvb_recording_set_Location (_tmp59_, _tmp60_);
		_tmp61_ = recording;
		dvb_recording_set_Name (_tmp61_, NULL);
		_tmp62_ = recording;
		dvb_recording_set_Description (_tmp62_, NULL);
		_tmp63_ = timer;
		_tmp64_ = dvb_timer_get_EventID (_tmp63_);
		_tmp65_ = _tmp64_;
		if (_tmp65_ != ((guint) 0)) {
			DVBEvent* event = NULL;
			DVBChannel* _tmp66_ = NULL;
			DVBSchedule* _tmp67_ = NULL;
			DVBSchedule* _tmp68_ = NULL;
			DVBTimer* _tmp69_ = NULL;
			guint _tmp70_ = 0U;
			guint _tmp71_ = 0U;
			DVBEvent* _tmp72_ = NULL;
			DVBEvent* _tmp73_ = NULL;
			_tmp66_ = channel;
			_tmp67_ = dvb_channel_get_Schedule (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = timer;
			_tmp70_ = dvb_timer_get_EventID (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = dvb_schedule_get_event (_tmp68_, _tmp71_);
			event = _tmp72_;
			_tmp73_ = event;
			if (_tmp73_ != NULL) {
				DVBLoggingLogger* _tmp74_ = NULL;
				DVBRecording* _tmp75_ = NULL;
				DVBEvent* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				DVBRecording* _tmp78_ = NULL;
				DVBEvent* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				DVBEvent* _tmp81_ = NULL;
				const gchar* _tmp82_ = NULL;
				gchar* _tmp83_ = NULL;
				gchar* _tmp84_ = NULL;
				_tmp74_ = dvb_recorder_log;
				dvb_logging_logger_debug (_tmp74_, "Recorder.vala:672: Transfering event information from timer");
				_tmp75_ = recording;
				_tmp76_ = event;
				_tmp77_ = _tmp76_->name;
				dvb_recording_set_Name (_tmp75_, _tmp77_);
				_tmp78_ = recording;
				_tmp79_ = event;
				_tmp80_ = _tmp79_->description;
				_tmp81_ = event;
				_tmp82_ = _tmp81_->extended_description;
				_tmp83_ = g_strdup_printf ("%s\n%s", _tmp80_, _tmp82_);
				_tmp84_ = _tmp83_;
				dvb_recording_set_Description (_tmp78_, _tmp84_);
				_g_free0 (_tmp84_);
			}
			_dvb_event_unref0 (event);
		}
		{
			GeeMap* _tmp85_ = NULL;
			_tmp85_ = self->priv->recordings;
			g_rec_mutex_lock (&self->priv->__lock_recordings);
			{
				GeeMap* _tmp86_ = NULL;
				DVBRecording* _tmp87_ = NULL;
				guint32 _tmp88_ = 0U;
				guint32 _tmp89_ = 0U;
				DVBRecording* _tmp90_ = NULL;
				_tmp86_ = self->priv->recordings;
				_tmp87_ = recording;
				_tmp88_ = dvb_recording_get_Id (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = recording;
				gee_map_set (_tmp86_, (gpointer) ((guintptr) ((guint) _tmp89_)), _tmp90_);
			}
			__finally129:
			{
				GeeMap* _tmp91_ = NULL;
				_tmp91_ = self->priv->recordings;
				g_rec_mutex_unlock (&self->priv->__lock_recordings);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (recording);
				_g_object_unref0 (player);
				_g_object_unref0 (channel_factory);
				_g_object_unref0 (filesink);
				_g_object_unref0 (location);
				_g_object_unref0 (channel);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp92_ = dvb_recordings_store_get_instance ();
		_tmp93_ = recording;
		dvb_recordings_store_add (_tmp92_, _tmp93_);
		_g_object_unref0 (recording);
	}
	_tmp94_ = self->priv->active_timers;
	_tmp95_ = timer;
	_tmp96_ = dvb_timer_get_Id (_tmp95_);
	_tmp97_ = _tmp96_;
	gee_collection_add ((GeeCollection*) _tmp94_, (gpointer) ((guintptr) _tmp97_));
	_tmp98_ = timer;
	_tmp99_ = dvb_timer_get_Id (_tmp98_);
	_tmp100_ = _tmp99_;
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "recording-started", _tmp100_);
	_g_object_unref0 (player);
	_g_object_unref0 (channel_factory);
	_g_object_unref0 (filesink);
	_g_object_unref0 (location);
	_g_object_unref0 (channel);
}


/**
         * Stop recording of specified timer
         */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


void dvb_recorder_stop_recording (DVBRecorder* self, DVBTimer* timer) {
	DVBRecording* rec = NULL;
	guint32 timer_id = 0U;
	DVBTimer* _tmp31_ = NULL;
	guint32 _tmp32_ = 0U;
	guint32 _tmp33_ = 0U;
	guint32 _tmp38_ = 0U;
	guint32 _tmp39_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	{
		GeeMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->recordings;
		g_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeMap* _tmp1_ = NULL;
			DVBTimer* _tmp2_ = NULL;
			guint32 _tmp3_ = 0U;
			guint32 _tmp4_ = 0U;
			gpointer _tmp5_ = NULL;
			time_t _tmp6_ = 0;
			struct tm _tmp7_ = {0};
			struct tm _tmp8_ = {0};
			struct tm _tmp9_ = {0};
			time_t _tmp10_ = 0;
			DVBLoggingLogger* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			gint64 _tmp15_ = 0LL;
			DVBChannelFactory* channel_factory = NULL;
			DVBDeviceGroup* _tmp16_ = NULL;
			DVBChannelFactory* _tmp17_ = NULL;
			DVBChannelFactory* _tmp18_ = NULL;
			DVBChannelFactory* _tmp19_ = NULL;
			DVBTimer* _tmp20_ = NULL;
			DVBChannel* _tmp21_ = NULL;
			DVBChannel* _tmp22_ = NULL;
			DVBTimer* _tmp23_ = NULL;
			GstElement* _tmp24_ = NULL;
			GstElement* _tmp25_ = NULL;
			GeeMap* _tmp26_ = NULL;
			DVBTimer* _tmp27_ = NULL;
			guint32 _tmp28_ = 0U;
			guint32 _tmp29_ = 0U;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = timer;
			_tmp3_ = dvb_timer_get_Id (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_map_get (_tmp1_, (gpointer) ((guintptr) ((guint) _tmp4_)));
			_g_object_unref0 (rec);
			rec = (DVBRecording*) _tmp5_;
			_tmp6_ = time (NULL);
			g_time_local (_tmp6_, &_tmp7_);
			dvb_recording_get_StartTime (rec, &_tmp8_);
			_tmp9_ = _tmp8_;
			_tmp10_ = dvb_utils_difftime (&_tmp7_, &_tmp9_);
			dvb_recording_set_Length (rec, (gint64) _tmp10_);
			_tmp11_ = dvb_recorder_log;
			_tmp12_ = dvb_recording_get_ChannelName (rec);
			_tmp13_ = _tmp12_;
			_tmp14_ = dvb_recording_get_Length (rec);
			_tmp15_ = _tmp14_;
			dvb_logging_logger_debug (_tmp11_, "Recording of channel %s stopped after %" G_GINT64_FORMAT " seconds", _tmp13_, _tmp15_);
			dvb_recording_save_to_disk (rec);
			_tmp16_ = self->priv->_DeviceGroup;
			_tmp17_ = dvb_device_group_get_channel_factory (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			channel_factory = _tmp19_;
			_tmp20_ = timer;
			_tmp21_ = dvb_timer_get_Channel (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = timer;
			_tmp24_ = dvb_timer_get_sink (_tmp23_);
			_tmp25_ = _tmp24_;
			dvb_channel_factory_stop_channel (channel_factory, _tmp22_, _tmp25_);
			_tmp26_ = self->priv->recordings;
			_tmp27_ = timer;
			_tmp28_ = dvb_timer_get_Id (_tmp27_);
			_tmp29_ = _tmp28_;
			gee_map_unset (_tmp26_, (gpointer) ((guintptr) ((guint) _tmp29_)), NULL);
			_g_object_unref0 (channel_factory);
		}
		__finally130:
		{
			GeeMap* _tmp30_ = NULL;
			_tmp30_ = self->priv->recordings;
			g_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (rec);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp31_ = timer;
	_tmp32_ = dvb_timer_get_Id (_tmp31_);
	_tmp33_ = _tmp32_;
	timer_id = _tmp33_;
	{
		GeeHashMap* _tmp34_ = NULL;
		_tmp34_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeSet* _tmp35_ = NULL;
			GeeHashMap* _tmp36_ = NULL;
			_tmp35_ = self->priv->active_timers;
			gee_collection_remove ((GeeCollection*) _tmp35_, (gpointer) ((guintptr) timer_id));
			_tmp36_ = self->priv->timers;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp36_, (gpointer) ((guintptr) timer_id), NULL);
		}
		__finally131:
		{
			GeeHashMap* _tmp37_ = NULL;
			_tmp37_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (rec);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_recording_monitor_recording (rec);
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_DELETED);
	_tmp38_ = dvb_recording_get_Id (rec);
	_tmp39_ = _tmp38_;
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "recording-finished", _tmp39_);
	_g_object_unref0 (rec);
}


/**
         * @returns: File on success, NULL otherwise
         *
         * Create directories and set location of recording
         */
static GFile* dvb_recorder_create_recording_dirs (DVBRecorder* self, DVBChannel* channel, guint* start, int start_length1) {
	GFile* result = NULL;
	gchar* channel_name = NULL;
	DVBChannel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* time = NULL;
	guint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint _tmp5_ = 0U;
	guint* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guint _tmp7_ = 0U;
	guint* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	guint _tmp9_ = 0U;
	guint* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	guint _tmp11_ = 0U;
	guint* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	guint _tmp13_ = 0U;
	gchar* _tmp14_ = NULL;
	GFile* dir = NULL;
	DVBDeviceGroup* _tmp15_ = NULL;
	GFile* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
	GFile* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GFile* _tmp22_ = NULL;
	GFile* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GFileInfo* info = NULL;
	GFileInfo* _tmp40_ = NULL;
	guint32 _tmp41_ = 0U;
	GFileInfo* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	GFile* recording = NULL;
	GFile* _tmp52_ = NULL;
	GFile* _tmp53_ = NULL;
	GFile* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_utils_remove_nonalphanums (_tmp2_);
	channel_name = _tmp3_;
	_tmp4_ = start;
	_tmp4__length1 = start_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = start;
	_tmp6__length1 = start_length1;
	_tmp7_ = _tmp6_[1];
	_tmp8_ = start;
	_tmp8__length1 = start_length1;
	_tmp9_ = _tmp8_[2];
	_tmp10_ = start;
	_tmp10__length1 = start_length1;
	_tmp11_ = _tmp10_[3];
	_tmp12_ = start;
	_tmp12__length1 = start_length1;
	_tmp13_ = _tmp12_[4];
	_tmp14_ = g_strdup_printf ("%u-%u-%u_%u-%u", _tmp5_, _tmp7_, _tmp9_, _tmp11_, _tmp13_);
	time = _tmp14_;
	_tmp15_ = self->priv->_DeviceGroup;
	_tmp16_ = dvb_device_group_get_RecordingsDirectory (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = channel_name;
	_tmp19_ = g_file_get_child (_tmp17_, _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = time;
	_tmp22_ = g_file_get_child (_tmp20_, _tmp21_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp20_);
	dir = _tmp23_;
	_tmp24_ = dir;
	_tmp25_ = g_file_query_exists (_tmp24_, NULL);
	if (!_tmp25_) {
		{
			GFile* _tmp26_ = NULL;
			_tmp26_ = dir;
			dvb_utils_mkdirs (_tmp26_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch132_g_error;
			}
		}
		goto __finally132;
		__catch132_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp27_ = NULL;
			GFile* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			GError* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp27_ = dvb_recorder_log;
			_tmp28_ = dir;
			_tmp29_ = g_file_get_path (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = e;
			_tmp32_ = _tmp31_->message;
			dvb_logging_logger_error (_tmp27_, "Recorder.vala:742: Could not create directory %s: %s", _tmp30_, _tmp32_);
			_g_free0 (_tmp30_);
			result = NULL;
			_g_error_free0 (e);
			_g_object_unref0 (dir);
			_g_free0 (time);
			_g_free0 (channel_name);
			return result;
		}
		__finally132:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (dir);
			_g_free0 (time);
			_g_free0 (channel_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GFileInfo* _tmp33_ = NULL;
		GFile* _tmp34_ = NULL;
		GFileInfo* _tmp35_ = NULL;
		GFileInfo* _tmp36_ = NULL;
		_tmp34_ = dir;
		_tmp35_ = g_file_query_info (_tmp34_, DVB_RECORDER_ATTRIBUTES, 0, NULL, &_inner_error_);
		_tmp33_ = _tmp35_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch133_g_error;
		}
		_tmp36_ = _tmp33_;
		_tmp33_ = NULL;
		_g_object_unref0 (info);
		info = _tmp36_;
		_g_object_unref0 (_tmp33_);
	}
	goto __finally133;
	__catch133_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp37_ = NULL;
		GError* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp37_ = dvb_recorder_log;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		dvb_logging_logger_error (_tmp37_, "Recorder.vala:752: Could not retrieve attributes: %s", _tmp39_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		return result;
	}
	__finally133:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp40_ = info;
	_tmp41_ = g_file_info_get_attribute_uint32 (_tmp40_, G_FILE_ATTRIBUTE_STANDARD_TYPE);
	if (_tmp41_ != ((guint32) G_FILE_TYPE_DIRECTORY)) {
		DVBLoggingLogger* _tmp42_ = NULL;
		GFile* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		_tmp42_ = dvb_recorder_log;
		_tmp43_ = dir;
		_tmp44_ = g_file_get_path (_tmp43_);
		_tmp45_ = _tmp44_;
		dvb_logging_logger_error (_tmp42_, "Recorder.vala:758: %s is not a directory", _tmp45_);
		_g_free0 (_tmp45_);
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		return result;
	}
	_tmp46_ = info;
	_tmp47_ = g_file_info_get_attribute_boolean (_tmp46_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
	if (!_tmp47_) {
		DVBLoggingLogger* _tmp48_ = NULL;
		GFile* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		_tmp48_ = dvb_recorder_log;
		_tmp49_ = dir;
		_tmp50_ = g_file_get_path (_tmp49_);
		_tmp51_ = _tmp50_;
		dvb_logging_logger_error (_tmp48_, "Recorder.vala:763: Cannot write to %s", _tmp51_);
		_g_free0 (_tmp51_);
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		return result;
	}
	_tmp52_ = dir;
	_tmp53_ = g_file_get_child (_tmp52_, "001.mpeg");
	recording = _tmp53_;
	_tmp54_ = recording;
	_tmp55_ = g_file_query_exists (_tmp54_, NULL);
	if (_tmp55_) {
		GFile* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		_tmp56_ = recording;
		_tmp57_ = g_file_get_path (_tmp56_);
		_tmp58_ = _tmp57_;
		g_warning ("Recorder.vala:769: Recording %s already exists", _tmp58_);
		_g_free0 (_tmp58_);
		result = NULL;
		_g_object_unref0 (recording);
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		return result;
	}
	result = recording;
	_g_object_unref0 (info);
	_g_object_unref0 (dir);
	_g_free0 (time);
	_g_free0 (channel_name);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static gboolean dvb_recorder_check_timers (DVBRecorder* self) {
	gboolean result = FALSE;
	DVBLoggingLogger* _tmp0_ = NULL;
	gboolean val = FALSE;
	GSList* ended_recordings = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_recorder_log;
	dvb_logging_logger_debug (_tmp0_, "Recorder.vala:776: Checking timers");
	ended_recordings = NULL;
	{
		GeeHashMap* _tmp1_ = NULL;
		_tmp1_ = self->priv->timers;
		g_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GSList* deleteable_items = NULL;
			gboolean _tmp66_ = FALSE;
			GeeHashMap* _tmp67_ = NULL;
			gint _tmp68_ = 0;
			gint _tmp69_ = 0;
			{
				GeeIterator* _timer_id_it = NULL;
				GeeSet* _tmp2_ = NULL;
				GeeIterator* _tmp3_ = NULL;
				_tmp2_ = self->priv->active_timers;
				_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
				_timer_id_it = _tmp3_;
				while (TRUE) {
					GeeIterator* _tmp4_ = NULL;
					gboolean _tmp5_ = FALSE;
					guint32 timer_id = 0U;
					GeeIterator* _tmp6_ = NULL;
					gpointer _tmp7_ = NULL;
					DVBTimer* timer = NULL;
					GeeHashMap* _tmp8_ = NULL;
					guint32 _tmp9_ = 0U;
					gpointer _tmp10_ = NULL;
					DVBTimer* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					_tmp4_ = _timer_id_it;
					_tmp5_ = gee_iterator_next (_tmp4_);
					if (!_tmp5_) {
						break;
					}
					_tmp6_ = _timer_id_it;
					_tmp7_ = gee_iterator_get (_tmp6_);
					timer_id = (guint32) ((guintptr) _tmp7_);
					_tmp8_ = self->priv->timers;
					_tmp9_ = timer_id;
					_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, (gpointer) ((guintptr) _tmp9_));
					timer = (DVBTimer*) _tmp10_;
					_tmp11_ = timer;
					_tmp12_ = dvb_timer_is_end_due (_tmp11_);
					if (_tmp12_) {
						DVBTimer* _tmp13_ = NULL;
						DVBTimer* _tmp14_ = NULL;
						_tmp13_ = timer;
						_tmp14_ = _g_object_ref0 (_tmp13_);
						ended_recordings = g_slist_prepend (ended_recordings, _tmp14_);
					}
					_g_object_unref0 (timer);
				}
				_g_object_unref0 (_timer_id_it);
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp15_ = FALSE;
					_tmp15_ = TRUE;
					while (TRUE) {
						gint _tmp17_ = 0;
						GSList* _tmp18_ = NULL;
						guint _tmp19_ = 0U;
						DVBTimer* timer = NULL;
						GSList* _tmp20_ = NULL;
						gint _tmp21_ = 0;
						gconstpointer _tmp22_ = NULL;
						DVBTimer* _tmp23_ = NULL;
						DVBTimer* _tmp24_ = NULL;
						if (!_tmp15_) {
							gint _tmp16_ = 0;
							_tmp16_ = i;
							i = _tmp16_ + 1;
						}
						_tmp15_ = FALSE;
						_tmp17_ = i;
						_tmp18_ = ended_recordings;
						_tmp19_ = g_slist_length (_tmp18_);
						if (!(((guint) _tmp17_) < _tmp19_)) {
							break;
						}
						_tmp20_ = ended_recordings;
						_tmp21_ = i;
						_tmp22_ = g_slist_nth_data (_tmp20_, (guint) _tmp21_);
						_tmp23_ = _g_object_ref0 ((DVBTimer*) _tmp22_);
						timer = _tmp23_;
						_tmp24_ = timer;
						dvb_recorder_stop_recording (self, _tmp24_);
						_g_object_unref0 (timer);
					}
				}
			}
			deleteable_items = NULL;
			{
				GeeIterator* _key_it = NULL;
				GeeHashMap* _tmp25_ = NULL;
				GeeSet* _tmp26_ = NULL;
				GeeSet* _tmp27_ = NULL;
				GeeSet* _tmp28_ = NULL;
				GeeIterator* _tmp29_ = NULL;
				GeeIterator* _tmp30_ = NULL;
				_tmp25_ = self->priv->timers;
				_tmp26_ = gee_abstract_map_get_keys ((GeeMap*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp27_;
				_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
				_tmp30_ = _tmp29_;
				_g_object_unref0 (_tmp28_);
				_key_it = _tmp30_;
				while (TRUE) {
					GeeIterator* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					guint32 key = 0U;
					GeeIterator* _tmp33_ = NULL;
					gpointer _tmp34_ = NULL;
					DVBTimer* timer = NULL;
					GeeHashMap* _tmp35_ = NULL;
					guint32 _tmp36_ = 0U;
					gpointer _tmp37_ = NULL;
					DVBLoggingLogger* _tmp38_ = NULL;
					DVBTimer* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					gboolean _tmp42_ = FALSE;
					DVBTimer* _tmp43_ = NULL;
					gboolean _tmp44_ = FALSE;
					_tmp31_ = _key_it;
					_tmp32_ = gee_iterator_next (_tmp31_);
					if (!_tmp32_) {
						break;
					}
					_tmp33_ = _key_it;
					_tmp34_ = gee_iterator_get (_tmp33_);
					key = (guint32) ((guintptr) _tmp34_);
					_tmp35_ = self->priv->timers;
					_tmp36_ = key;
					_tmp37_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp35_, (gpointer) ((guintptr) _tmp36_));
					timer = (DVBTimer*) _tmp37_;
					_tmp38_ = dvb_recorder_log;
					_tmp39_ = timer;
					_tmp40_ = dvb_timer_to_string (_tmp39_);
					_tmp41_ = _tmp40_;
					dvb_logging_logger_debug (_tmp38_, "Recorder.vala:802: Checking timer: %s", _tmp41_);
					_g_free0 (_tmp41_);
					_tmp43_ = timer;
					_tmp44_ = dvb_timer_is_start_due (_tmp43_);
					if (_tmp44_) {
						GeeSet* _tmp45_ = NULL;
						DVBTimer* _tmp46_ = NULL;
						guint32 _tmp47_ = 0U;
						guint32 _tmp48_ = 0U;
						gboolean _tmp49_ = FALSE;
						_tmp45_ = self->priv->active_timers;
						_tmp46_ = timer;
						_tmp47_ = dvb_timer_get_Id (_tmp46_);
						_tmp48_ = _tmp47_;
						_tmp49_ = gee_collection_contains ((GeeCollection*) _tmp45_, (gpointer) ((guintptr) _tmp48_));
						_tmp42_ = !_tmp49_;
					} else {
						_tmp42_ = FALSE;
					}
					if (_tmp42_) {
						DVBTimer* _tmp50_ = NULL;
						_tmp50_ = timer;
						dvb_recorder_start_recording (self, _tmp50_);
					} else {
						DVBTimer* _tmp51_ = NULL;
						gboolean _tmp52_ = FALSE;
						_tmp51_ = timer;
						_tmp52_ = dvb_timer_has_expired (_tmp51_);
						if (_tmp52_) {
							DVBLoggingLogger* _tmp53_ = NULL;
							DVBTimer* _tmp54_ = NULL;
							gchar* _tmp55_ = NULL;
							gchar* _tmp56_ = NULL;
							guint32 _tmp57_ = 0U;
							_tmp53_ = dvb_recorder_log;
							_tmp54_ = timer;
							_tmp55_ = dvb_timer_to_string (_tmp54_);
							_tmp56_ = _tmp55_;
							dvb_logging_logger_debug (_tmp53_, "Recorder.vala:810: Removing expired timer: %s", _tmp56_);
							_g_free0 (_tmp56_);
							_tmp57_ = key;
							deleteable_items = g_slist_prepend (deleteable_items, (gpointer) ((guintptr) _tmp57_));
						}
					}
					_g_object_unref0 (timer);
				}
				_g_object_unref0 (_key_it);
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp58_ = FALSE;
					_tmp58_ = TRUE;
					while (TRUE) {
						gint _tmp60_ = 0;
						GSList* _tmp61_ = NULL;
						guint _tmp62_ = 0U;
						GSList* _tmp63_ = NULL;
						gint _tmp64_ = 0;
						gconstpointer _tmp65_ = NULL;
						if (!_tmp58_) {
							gint _tmp59_ = 0;
							_tmp59_ = i;
							i = _tmp59_ + 1;
						}
						_tmp58_ = FALSE;
						_tmp60_ = i;
						_tmp61_ = deleteable_items;
						_tmp62_ = g_slist_length (_tmp61_);
						if (!(((guint) _tmp60_) < _tmp62_)) {
							break;
						}
						_tmp63_ = deleteable_items;
						_tmp64_ = i;
						_tmp65_ = g_slist_nth_data (_tmp63_, (guint) _tmp64_);
						dvb_recorder_delete_timer (self, (guint32) ((guintptr) _tmp65_));
					}
				}
			}
			_tmp67_ = self->priv->timers;
			_tmp68_ = gee_abstract_map_get_size ((GeeMap*) _tmp67_);
			_tmp69_ = _tmp68_;
			if (_tmp69_ == 0) {
				GeeSet* _tmp70_ = NULL;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				_tmp70_ = self->priv->active_timers;
				_tmp71_ = gee_collection_get_size ((GeeCollection*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp66_ = _tmp72_ == 0;
			} else {
				_tmp66_ = FALSE;
			}
			if (_tmp66_) {
				DVBLoggingLogger* _tmp73_ = NULL;
				_tmp73_ = dvb_recorder_log;
				dvb_logging_logger_debug (_tmp73_, "Recorder.vala:822: No timers left and no recording in progress");
				self->priv->have_check_timers_timeout = FALSE;
				self->priv->check_timers_event_id = (guint) 0;
				val = FALSE;
			} else {
				DVBLoggingLogger* _tmp74_ = NULL;
				GeeHashMap* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				GeeSet* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				_tmp74_ = dvb_recorder_log;
				_tmp75_ = self->priv->timers;
				_tmp76_ = gee_abstract_map_get_size ((GeeMap*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = self->priv->active_timers;
				_tmp79_ = gee_collection_get_size ((GeeCollection*) _tmp78_);
				_tmp80_ = _tmp79_;
				dvb_logging_logger_debug (_tmp74_, "Recorder.vala:828: %d timers and %d active recordings left", _tmp77_, _tmp80_);
				val = TRUE;
			}
			_g_slist_free0 (deleteable_items);
		}
		__finally134:
		{
			GeeHashMap* _tmp81_ = NULL;
			_tmp81_ = self->priv->timers;
			g_rec_mutex_unlock (&self->priv->__lock_timers);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			__g_slist_free__g_object_unref0_0 (ended_recordings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	__g_slist_free__g_object_unref0_0 (ended_recordings);
	return result;
}


static void dvb_recorder_on_eit_structure (DVBRecorder* self, DVBPlayerThread* player, GstMpegtsSection* section) {
	guint sid = 0U;
	GstMpegtsSection* _tmp0_ = NULL;
	guint16 _tmp1_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (section != NULL);
	sid = (guint) 0;
	_tmp0_ = section;
	_tmp1_ = _tmp0_->subtable_extension;
	sid = (guint) _tmp1_;
	{
		GeeMap* _tmp2_ = NULL;
		_tmp2_ = self->priv->recordings;
		g_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			{
				GeeIterator* _rec_it = NULL;
				GeeMap* _tmp3_ = NULL;
				GeeCollection* _tmp4_ = NULL;
				GeeCollection* _tmp5_ = NULL;
				GeeCollection* _tmp6_ = NULL;
				GeeIterator* _tmp7_ = NULL;
				GeeIterator* _tmp8_ = NULL;
				_tmp3_ = self->priv->recordings;
				_tmp4_ = gee_map_get_values (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				_rec_it = _tmp8_;
				while (TRUE) {
					GeeIterator* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					DVBRecording* rec = NULL;
					GeeIterator* _tmp11_ = NULL;
					gpointer _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					DVBRecording* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					_tmp9_ = _rec_it;
					_tmp10_ = gee_iterator_next (_tmp9_);
					if (!_tmp10_) {
						break;
					}
					_tmp11_ = _rec_it;
					_tmp12_ = gee_iterator_get (_tmp11_);
					rec = (DVBRecording*) _tmp12_;
					_tmp14_ = rec;
					_tmp15_ = dvb_recording_get_Name (_tmp14_);
					_tmp16_ = _tmp15_;
					if (_tmp16_ == NULL) {
						guint _tmp17_ = 0U;
						DVBRecording* _tmp18_ = NULL;
						guint _tmp19_ = 0U;
						guint _tmp20_ = 0U;
						_tmp17_ = sid;
						_tmp18_ = rec;
						_tmp19_ = dvb_recording_get_ChannelSid (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp13_ = _tmp17_ == _tmp20_;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						DVBChannel* chan = NULL;
						DVBDeviceGroup* _tmp21_ = NULL;
						DVBChannelList* _tmp22_ = NULL;
						DVBChannelList* _tmp23_ = NULL;
						guint _tmp24_ = 0U;
						DVBChannel* _tmp25_ = NULL;
						DVBSchedule* sched = NULL;
						DVBChannel* _tmp26_ = NULL;
						DVBSchedule* _tmp27_ = NULL;
						DVBSchedule* _tmp28_ = NULL;
						DVBSchedule* _tmp29_ = NULL;
						DVBEvent* event = NULL;
						DVBSchedule* _tmp30_ = NULL;
						DVBEvent* _tmp31_ = NULL;
						DVBEvent* _tmp32_ = NULL;
						_tmp21_ = self->priv->_DeviceGroup;
						_tmp22_ = dvb_device_group_get_Channels (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = sid;
						_tmp25_ = dvb_channel_list_get_channel (_tmp23_, _tmp24_);
						chan = _tmp25_;
						_tmp26_ = chan;
						_tmp27_ = dvb_channel_get_Schedule (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = _g_object_ref0 (_tmp28_);
						sched = _tmp29_;
						_tmp30_ = sched;
						_tmp31_ = dvb_schedule_get_running_event (_tmp30_);
						event = _tmp31_;
						_tmp32_ = event;
						if (_tmp32_ != NULL) {
							DVBLoggingLogger* _tmp33_ = NULL;
							DVBRecording* _tmp34_ = NULL;
							DVBEvent* _tmp35_ = NULL;
							const gchar* _tmp36_ = NULL;
							DVBRecording* _tmp37_ = NULL;
							DVBEvent* _tmp38_ = NULL;
							const gchar* _tmp39_ = NULL;
							DVBEvent* _tmp40_ = NULL;
							const gchar* _tmp41_ = NULL;
							gchar* _tmp42_ = NULL;
							gchar* _tmp43_ = NULL;
							_tmp33_ = dvb_recorder_log;
							dvb_logging_logger_debug (_tmp33_, "Recorder.vala:852: Found running event for active recording");
							_tmp34_ = rec;
							_tmp35_ = event;
							_tmp36_ = _tmp35_->name;
							dvb_recording_set_Name (_tmp34_, _tmp36_);
							_tmp37_ = rec;
							_tmp38_ = event;
							_tmp39_ = _tmp38_->description;
							_tmp40_ = event;
							_tmp41_ = _tmp40_->extended_description;
							_tmp42_ = g_strdup_printf ("%s\n%s", _tmp39_, _tmp41_);
							_tmp43_ = _tmp42_;
							dvb_recording_set_Description (_tmp37_, _tmp43_);
							_g_free0 (_tmp43_);
						}
						_dvb_event_unref0 (event);
						_g_object_unref0 (sched);
						_g_object_unref0 (chan);
					}
					_g_object_unref0 (rec);
				}
				_g_object_unref0 (_rec_it);
			}
		}
		__finally135:
		{
			GeeMap* _tmp44_ = NULL;
			_tmp44_ = self->priv->recordings;
			g_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBDeviceGroup* dvb_recorder_get_DeviceGroup (DVBRecorder* self) {
	DVBDeviceGroup* result;
	DVBDeviceGroup* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_DeviceGroup;
	result = _tmp0_;
	return result;
}


static void dvb_recorder_set_DeviceGroup (DVBRecorder* self, DVBDeviceGroup* value) {
	DVBDeviceGroup* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_DeviceGroup = _tmp0_;
	g_object_notify ((GObject *) self, "DeviceGroup");
}


guint dvb_recorder_get_count (DVBRecorder* self) {
	guint result;
	GeeMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->recordings;
	_tmp1_ = gee_map_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}


static GType dvb_recorder_real_get_element_type (GeeTraversable* base) {
	GType result;
	DVBRecorder* self;
	self = (DVBRecorder*) base;
	result = DVB_TYPE_TIMER;
	return result;
}


static GObject * dvb_recorder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBRecorder * self;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	DVBRecordingsStore* _tmp2_ = NULL;
	DVBDeviceGroup* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_recorder_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_RECORDER, DVBRecorder);
	_tmp0_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->active_timers);
	self->priv->active_timers = (GeeSet*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_TIMER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->timers);
	self->priv->timers = _tmp1_;
	self->priv->have_check_timers_timeout = FALSE;
	_tmp2_ = dvb_recordings_store_get_instance ();
	_tmp3_ = self->priv->_DeviceGroup;
	_tmp4_ = dvb_device_group_get_RecordingsDirectory (_tmp3_);
	_tmp5_ = _tmp4_;
	dvb_recordings_store_restore_from_dir (_tmp2_, _tmp5_);
	_tmp6_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->recordings);
	self->priv->recordings = (GeeMap*) _tmp6_;
	self->priv->check_timers_event_id = (guint) 0;
	return obj;
}


static void dvb_recorder_class_init (DVBRecorderClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_recorder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecorderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_recorder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_recorder_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_recorder_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recorder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDER_DEVICE_GROUP, g_param_spec_object ("DeviceGroup", "DeviceGroup", "DeviceGroup", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDER_COUNT, g_param_spec_uint ("count", "count", "count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDER_ELEMENT_TYPE, g_param_spec_gtype ("element-type", "element-type", "element-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_recorder_log = _tmp1_;
}


static void dvb_recorder_dvb_id_bus_recorder_interface_init (DVBIDBusRecorderIface * iface) {
	dvb_recorder_dvb_id_bus_recorder_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddTimer = (gboolean (*)(DVBIDBusRecorder*, guint, gint, gint, gint, gint, gint, guint, guint32*, GError**)) dvb_recorder_real_AddTimer;
	iface->AddTimerWithMargin = (gboolean (*)(DVBIDBusRecorder*, guint, gint, gint, gint, gint, gint, guint, guint32*, GError**)) dvb_recorder_real_AddTimerWithMargin;
	iface->AddTimerForEPGEvent = (gboolean (*)(DVBIDBusRecorder*, guint, guint, guint32*, GError**)) dvb_recorder_real_AddTimerForEPGEvent;
	iface->DeleteTimer = (gboolean (*)(DVBIDBusRecorder*, guint32, GError**)) dvb_recorder_real_DeleteTimer;
	iface->GetTimers = (guint32* (*)(DVBIDBusRecorder*, int*, GError**)) dvb_recorder_real_GetTimers;
	iface->GetStartTime = (gboolean (*)(DVBIDBusRecorder*, guint32, guint32**, int*, GError**)) dvb_recorder_real_GetStartTime;
	iface->SetStartTime = (gboolean (*)(DVBIDBusRecorder*, guint32, gint, gint, gint, gint, gint, GError**)) dvb_recorder_real_SetStartTime;
	iface->GetEndTime = (gboolean (*)(DVBIDBusRecorder*, guint32, guint**, int*, GError**)) dvb_recorder_real_GetEndTime;
	iface->GetDuration = (gboolean (*)(DVBIDBusRecorder*, guint32, guint*, GError**)) dvb_recorder_real_GetDuration;
	iface->SetDuration = (gboolean (*)(DVBIDBusRecorder*, guint32, guint, GError**)) dvb_recorder_real_SetDuration;
	iface->GetChannelName = (gboolean (*)(DVBIDBusRecorder*, guint32, gchar**, GError**)) dvb_recorder_real_GetChannelName;
	iface->GetTitle = (gboolean (*)(DVBIDBusRecorder*, guint32, gchar**, GError**)) dvb_recorder_real_GetTitle;
	iface->GetAllInformations = (gboolean (*)(DVBIDBusRecorder*, guint32, DVBTimerInfo*, GError**)) dvb_recorder_real_GetAllInformations;
	iface->GetActiveTimers = (guint32* (*)(DVBIDBusRecorder*, int*, GError**)) dvb_recorder_real_GetActiveTimers;
	iface->IsTimerActive = (gboolean (*)(DVBIDBusRecorder*, guint32, GError**)) dvb_recorder_real_IsTimerActive;
	iface->HasTimer = (gboolean (*)(DVBIDBusRecorder*, guint, guint, guint, guint, guint, guint, GError**)) dvb_recorder_real_HasTimer;
	iface->HasTimerForEvent = (DVBOverlapType (*)(DVBIDBusRecorder*, guint, guint, GError**)) dvb_recorder_real_HasTimerForEvent;
}


static GType dvb_recorder_gee_traversable_get_g_type (DVBRecorder* self) {
	return DVB_TYPE_TIMER;
}


static GBoxedCopyFunc dvb_recorder_gee_traversable_get_g_dup_func (DVBRecorder* self) {
	return g_object_ref;
}


static GDestroyNotify dvb_recorder_gee_traversable_get_g_destroy_func (DVBRecorder* self) {
	return g_object_unref;
}


static void dvb_recorder_gee_traversable_interface_init (GeeTraversableIface * iface) {
	dvb_recorder_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) dvb_recorder_real_foreach;
	iface->get_g_type = (GType(*)(GeeTraversable*)) dvb_recorder_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) dvb_recorder_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) dvb_recorder_gee_traversable_get_g_destroy_func;
	iface->get_element_type = dvb_recorder_real_get_element_type;
}


static GType dvb_recorder_gee_iterable_get_g_type (DVBRecorder* self) {
	return DVB_TYPE_TIMER;
}


static GBoxedCopyFunc dvb_recorder_gee_iterable_get_g_dup_func (DVBRecorder* self) {
	return g_object_ref;
}


static GDestroyNotify dvb_recorder_gee_iterable_get_g_destroy_func (DVBRecorder* self) {
	return g_object_unref;
}


static void dvb_recorder_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_recorder_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) dvb_recorder_real_iterator;
	iface->get_g_type = (GType(*)(GeeIterable*)) dvb_recorder_gee_iterable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeIterable*)) dvb_recorder_gee_iterable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeIterable*)) dvb_recorder_gee_iterable_get_g_destroy_func;
}


static void dvb_recorder_instance_init (DVBRecorder * self) {
	self->priv = DVB_RECORDER_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_timers);
	g_rec_mutex_init (&self->priv->__lock_recordings);
}


static void dvb_recorder_finalize (GObject* obj) {
	DVBRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_RECORDER, DVBRecorder);
	_g_object_unref0 (self->priv->active_timers);
	g_rec_mutex_clear (&self->priv->__lock_timers);
	_g_object_unref0 (self->priv->timers);
	g_rec_mutex_clear (&self->priv->__lock_recordings);
	_g_object_unref0 (self->priv->recordings);
	G_OBJECT_CLASS (dvb_recorder_parent_class)->finalize (obj);
}


/**
     * This class is responsible for managing upcoming recordings and
     * already recorded items for a single group of devices
     */
GType dvb_recorder_get_type (void) {
	static volatile gsize dvb_recorder_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recorder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecorder), 0, (GInstanceInitFunc) dvb_recorder_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recorder_info = { (GInterfaceInitFunc) dvb_recorder_dvb_id_bus_recorder_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) dvb_recorder_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_recorder_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_recorder_type_id;
		dvb_recorder_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecorder", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recorder_type_id, DVB_TYPE_ID_BUS_RECORDER, &dvb_id_bus_recorder_info);
		g_type_add_interface_static (dvb_recorder_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (dvb_recorder_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_once_init_leave (&dvb_recorder_type_id__volatile, dvb_recorder_type_id);
	}
	return dvb_recorder_type_id__volatile;
}


static void _vala_dvb_recorder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_RECORDER, DVBRecorder);
	switch (property_id) {
		case DVB_RECORDER_DEVICE_GROUP:
		g_value_set_object (value, dvb_recorder_get_DeviceGroup (self));
		break;
		case DVB_RECORDER_COUNT:
		g_value_set_uint (value, dvb_recorder_get_count (self));
		break;
		case DVB_RECORDER_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_traversable_get_element_type ((GeeTraversable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_recorder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_RECORDER, DVBRecorder);
	switch (property_id) {
		case DVB_RECORDER_DEVICE_GROUP:
		dvb_recorder_set_DeviceGroup (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



