// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"log"

	"entgo.io/ent/entc/integration/customid/ent/migrate"
	"entgo.io/ent/entc/integration/customid/ent/schema"
	"entgo.io/ent/entc/integration/customid/sid"
	uuidc "entgo.io/ent/entc/integration/customid/uuidcompatible"
	"github.com/google/uuid"

	"entgo.io/ent/entc/integration/customid/ent/account"
	"entgo.io/ent/entc/integration/customid/ent/blob"
	"entgo.io/ent/entc/integration/customid/ent/bloblink"
	"entgo.io/ent/entc/integration/customid/ent/car"
	"entgo.io/ent/entc/integration/customid/ent/device"
	"entgo.io/ent/entc/integration/customid/ent/doc"
	"entgo.io/ent/entc/integration/customid/ent/group"
	"entgo.io/ent/entc/integration/customid/ent/intsid"
	"entgo.io/ent/entc/integration/customid/ent/link"
	"entgo.io/ent/entc/integration/customid/ent/mixinid"
	"entgo.io/ent/entc/integration/customid/ent/note"
	"entgo.io/ent/entc/integration/customid/ent/other"
	"entgo.io/ent/entc/integration/customid/ent/pet"
	"entgo.io/ent/entc/integration/customid/ent/revision"
	"entgo.io/ent/entc/integration/customid/ent/session"
	"entgo.io/ent/entc/integration/customid/ent/token"
	"entgo.io/ent/entc/integration/customid/ent/user"

	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
)

// Client is the client that holds all ent builders.
type Client struct {
	config
	// Schema is the client for creating, migrating and dropping schema.
	Schema *migrate.Schema
	// Account is the client for interacting with the Account builders.
	Account *AccountClient
	// Blob is the client for interacting with the Blob builders.
	Blob *BlobClient
	// BlobLink is the client for interacting with the BlobLink builders.
	BlobLink *BlobLinkClient
	// Car is the client for interacting with the Car builders.
	Car *CarClient
	// Device is the client for interacting with the Device builders.
	Device *DeviceClient
	// Doc is the client for interacting with the Doc builders.
	Doc *DocClient
	// Group is the client for interacting with the Group builders.
	Group *GroupClient
	// IntSID is the client for interacting with the IntSID builders.
	IntSID *IntSIDClient
	// Link is the client for interacting with the Link builders.
	Link *LinkClient
	// MixinID is the client for interacting with the MixinID builders.
	MixinID *MixinIDClient
	// Note is the client for interacting with the Note builders.
	Note *NoteClient
	// Other is the client for interacting with the Other builders.
	Other *OtherClient
	// Pet is the client for interacting with the Pet builders.
	Pet *PetClient
	// Revision is the client for interacting with the Revision builders.
	Revision *RevisionClient
	// Session is the client for interacting with the Session builders.
	Session *SessionClient
	// Token is the client for interacting with the Token builders.
	Token *TokenClient
	// User is the client for interacting with the User builders.
	User *UserClient
}

// NewClient creates a new client configured with the given options.
func NewClient(opts ...Option) *Client {
	cfg := config{log: log.Println, hooks: &hooks{}}
	cfg.options(opts...)
	client := &Client{config: cfg}
	client.init()
	return client
}

func (c *Client) init() {
	c.Schema = migrate.NewSchema(c.driver)
	c.Account = NewAccountClient(c.config)
	c.Blob = NewBlobClient(c.config)
	c.BlobLink = NewBlobLinkClient(c.config)
	c.Car = NewCarClient(c.config)
	c.Device = NewDeviceClient(c.config)
	c.Doc = NewDocClient(c.config)
	c.Group = NewGroupClient(c.config)
	c.IntSID = NewIntSIDClient(c.config)
	c.Link = NewLinkClient(c.config)
	c.MixinID = NewMixinIDClient(c.config)
	c.Note = NewNoteClient(c.config)
	c.Other = NewOtherClient(c.config)
	c.Pet = NewPetClient(c.config)
	c.Revision = NewRevisionClient(c.config)
	c.Session = NewSessionClient(c.config)
	c.Token = NewTokenClient(c.config)
	c.User = NewUserClient(c.config)
}

// Open opens a database/sql.DB specified by the driver name and
// the data source name, and returns a new client attached to it.
// Optional parameters can be added for configuring the client.
func Open(driverName, dataSourceName string, options ...Option) (*Client, error) {
	switch driverName {
	case dialect.MySQL, dialect.Postgres, dialect.SQLite:
		drv, err := sql.Open(driverName, dataSourceName)
		if err != nil {
			return nil, err
		}
		return NewClient(append(options, Driver(drv))...), nil
	default:
		return nil, fmt.Errorf("unsupported driver: %q", driverName)
	}
}

// Tx returns a new transactional client. The provided context
// is used until the transaction is committed or rolled back.
func (c *Client) Tx(ctx context.Context) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, errors.New("ent: cannot start a transaction within a transaction")
	}
	tx, err := newTx(ctx, c.driver)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = tx
	return &Tx{
		ctx:      ctx,
		config:   cfg,
		Account:  NewAccountClient(cfg),
		Blob:     NewBlobClient(cfg),
		BlobLink: NewBlobLinkClient(cfg),
		Car:      NewCarClient(cfg),
		Device:   NewDeviceClient(cfg),
		Doc:      NewDocClient(cfg),
		Group:    NewGroupClient(cfg),
		IntSID:   NewIntSIDClient(cfg),
		Link:     NewLinkClient(cfg),
		MixinID:  NewMixinIDClient(cfg),
		Note:     NewNoteClient(cfg),
		Other:    NewOtherClient(cfg),
		Pet:      NewPetClient(cfg),
		Revision: NewRevisionClient(cfg),
		Session:  NewSessionClient(cfg),
		Token:    NewTokenClient(cfg),
		User:     NewUserClient(cfg),
	}, nil
}

// BeginTx returns a transactional client with specified options.
func (c *Client) BeginTx(ctx context.Context, opts *sql.TxOptions) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, errors.New("ent: cannot start a transaction within a transaction")
	}
	tx, err := c.driver.(interface {
		BeginTx(context.Context, *sql.TxOptions) (dialect.Tx, error)
	}).BeginTx(ctx, opts)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = &txDriver{tx: tx, drv: c.driver}
	return &Tx{
		ctx:      ctx,
		config:   cfg,
		Account:  NewAccountClient(cfg),
		Blob:     NewBlobClient(cfg),
		BlobLink: NewBlobLinkClient(cfg),
		Car:      NewCarClient(cfg),
		Device:   NewDeviceClient(cfg),
		Doc:      NewDocClient(cfg),
		Group:    NewGroupClient(cfg),
		IntSID:   NewIntSIDClient(cfg),
		Link:     NewLinkClient(cfg),
		MixinID:  NewMixinIDClient(cfg),
		Note:     NewNoteClient(cfg),
		Other:    NewOtherClient(cfg),
		Pet:      NewPetClient(cfg),
		Revision: NewRevisionClient(cfg),
		Session:  NewSessionClient(cfg),
		Token:    NewTokenClient(cfg),
		User:     NewUserClient(cfg),
	}, nil
}

// Debug returns a new debug-client. It's used to get verbose logging on specific operations.
//
//	client.Debug().
//		Account.
//		Query().
//		Count(ctx)
func (c *Client) Debug() *Client {
	if c.debug {
		return c
	}
	cfg := c.config
	cfg.driver = dialect.Debug(c.driver, c.log)
	client := &Client{config: cfg}
	client.init()
	return client
}

// Close closes the database connection and prevents new queries from starting.
func (c *Client) Close() error {
	return c.driver.Close()
}

// Use adds the mutation hooks to all the entity clients.
// In order to add hooks to a specific client, call: `client.Node.Use(...)`.
func (c *Client) Use(hooks ...Hook) {
	c.Account.Use(hooks...)
	c.Blob.Use(hooks...)
	c.BlobLink.Use(hooks...)
	c.Car.Use(hooks...)
	c.Device.Use(hooks...)
	c.Doc.Use(hooks...)
	c.Group.Use(hooks...)
	c.IntSID.Use(hooks...)
	c.Link.Use(hooks...)
	c.MixinID.Use(hooks...)
	c.Note.Use(hooks...)
	c.Other.Use(hooks...)
	c.Pet.Use(hooks...)
	c.Revision.Use(hooks...)
	c.Session.Use(hooks...)
	c.Token.Use(hooks...)
	c.User.Use(hooks...)
}

// AccountClient is a client for the Account schema.
type AccountClient struct {
	config
}

// NewAccountClient returns a client for the Account from the given config.
func NewAccountClient(c config) *AccountClient {
	return &AccountClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `account.Hooks(f(g(h())))`.
func (c *AccountClient) Use(hooks ...Hook) {
	c.hooks.Account = append(c.hooks.Account, hooks...)
}

// Create returns a builder for creating a Account entity.
func (c *AccountClient) Create() *AccountCreate {
	mutation := newAccountMutation(c.config, OpCreate)
	return &AccountCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Account entities.
func (c *AccountClient) CreateBulk(builders ...*AccountCreate) *AccountCreateBulk {
	return &AccountCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Account.
func (c *AccountClient) Update() *AccountUpdate {
	mutation := newAccountMutation(c.config, OpUpdate)
	return &AccountUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AccountClient) UpdateOne(a *Account) *AccountUpdateOne {
	mutation := newAccountMutation(c.config, OpUpdateOne, withAccount(a))
	return &AccountUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AccountClient) UpdateOneID(id sid.ID) *AccountUpdateOne {
	mutation := newAccountMutation(c.config, OpUpdateOne, withAccountID(id))
	return &AccountUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Account.
func (c *AccountClient) Delete() *AccountDelete {
	mutation := newAccountMutation(c.config, OpDelete)
	return &AccountDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AccountClient) DeleteOne(a *Account) *AccountDeleteOne {
	return c.DeleteOneID(a.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *AccountClient) DeleteOneID(id sid.ID) *AccountDeleteOne {
	builder := c.Delete().Where(account.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AccountDeleteOne{builder}
}

// Query returns a query builder for Account.
func (c *AccountClient) Query() *AccountQuery {
	return &AccountQuery{
		config: c.config,
	}
}

// Get returns a Account entity by its id.
func (c *AccountClient) Get(ctx context.Context, id sid.ID) (*Account, error) {
	return c.Query().Where(account.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AccountClient) GetX(ctx context.Context, id sid.ID) *Account {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryToken queries the token edge of a Account.
func (c *AccountClient) QueryToken(a *Account) *TokenQuery {
	query := &TokenQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(account.Table, account.FieldID, id),
			sqlgraph.To(token.Table, token.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, account.TokenTable, account.TokenColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AccountClient) Hooks() []Hook {
	return c.hooks.Account
}

// BlobClient is a client for the Blob schema.
type BlobClient struct {
	config
}

// NewBlobClient returns a client for the Blob from the given config.
func NewBlobClient(c config) *BlobClient {
	return &BlobClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `blob.Hooks(f(g(h())))`.
func (c *BlobClient) Use(hooks ...Hook) {
	c.hooks.Blob = append(c.hooks.Blob, hooks...)
}

// Create returns a builder for creating a Blob entity.
func (c *BlobClient) Create() *BlobCreate {
	mutation := newBlobMutation(c.config, OpCreate)
	return &BlobCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Blob entities.
func (c *BlobClient) CreateBulk(builders ...*BlobCreate) *BlobCreateBulk {
	return &BlobCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Blob.
func (c *BlobClient) Update() *BlobUpdate {
	mutation := newBlobMutation(c.config, OpUpdate)
	return &BlobUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *BlobClient) UpdateOne(b *Blob) *BlobUpdateOne {
	mutation := newBlobMutation(c.config, OpUpdateOne, withBlob(b))
	return &BlobUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *BlobClient) UpdateOneID(id uuid.UUID) *BlobUpdateOne {
	mutation := newBlobMutation(c.config, OpUpdateOne, withBlobID(id))
	return &BlobUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Blob.
func (c *BlobClient) Delete() *BlobDelete {
	mutation := newBlobMutation(c.config, OpDelete)
	return &BlobDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *BlobClient) DeleteOne(b *Blob) *BlobDeleteOne {
	return c.DeleteOneID(b.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *BlobClient) DeleteOneID(id uuid.UUID) *BlobDeleteOne {
	builder := c.Delete().Where(blob.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &BlobDeleteOne{builder}
}

// Query returns a query builder for Blob.
func (c *BlobClient) Query() *BlobQuery {
	return &BlobQuery{
		config: c.config,
	}
}

// Get returns a Blob entity by its id.
func (c *BlobClient) Get(ctx context.Context, id uuid.UUID) (*Blob, error) {
	return c.Query().Where(blob.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *BlobClient) GetX(ctx context.Context, id uuid.UUID) *Blob {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryParent queries the parent edge of a Blob.
func (c *BlobClient) QueryParent(b *Blob) *BlobQuery {
	query := &BlobQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := b.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(blob.Table, blob.FieldID, id),
			sqlgraph.To(blob.Table, blob.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, false, blob.ParentTable, blob.ParentColumn),
		)
		fromV = sqlgraph.Neighbors(b.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryLinks queries the links edge of a Blob.
func (c *BlobClient) QueryLinks(b *Blob) *BlobQuery {
	query := &BlobQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := b.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(blob.Table, blob.FieldID, id),
			sqlgraph.To(blob.Table, blob.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, blob.LinksTable, blob.LinksPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(b.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryBlobLinks queries the blob_links edge of a Blob.
func (c *BlobClient) QueryBlobLinks(b *Blob) *BlobLinkQuery {
	query := &BlobLinkQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := b.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(blob.Table, blob.FieldID, id),
			sqlgraph.To(bloblink.Table, bloblink.BlobColumn),
			sqlgraph.Edge(sqlgraph.O2M, true, blob.BlobLinksTable, blob.BlobLinksColumn),
		)
		fromV = sqlgraph.Neighbors(b.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *BlobClient) Hooks() []Hook {
	return c.hooks.Blob
}

// BlobLinkClient is a client for the BlobLink schema.
type BlobLinkClient struct {
	config
}

// NewBlobLinkClient returns a client for the BlobLink from the given config.
func NewBlobLinkClient(c config) *BlobLinkClient {
	return &BlobLinkClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `bloblink.Hooks(f(g(h())))`.
func (c *BlobLinkClient) Use(hooks ...Hook) {
	c.hooks.BlobLink = append(c.hooks.BlobLink, hooks...)
}

// Create returns a builder for creating a BlobLink entity.
func (c *BlobLinkClient) Create() *BlobLinkCreate {
	mutation := newBlobLinkMutation(c.config, OpCreate)
	return &BlobLinkCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of BlobLink entities.
func (c *BlobLinkClient) CreateBulk(builders ...*BlobLinkCreate) *BlobLinkCreateBulk {
	return &BlobLinkCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for BlobLink.
func (c *BlobLinkClient) Update() *BlobLinkUpdate {
	mutation := newBlobLinkMutation(c.config, OpUpdate)
	return &BlobLinkUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *BlobLinkClient) UpdateOne(bl *BlobLink) *BlobLinkUpdateOne {
	mutation := newBlobLinkMutation(c.config, OpUpdateOne)
	mutation.blob = &bl.BlobID
	mutation.link = &bl.LinkID
	return &BlobLinkUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for BlobLink.
func (c *BlobLinkClient) Delete() *BlobLinkDelete {
	mutation := newBlobLinkMutation(c.config, OpDelete)
	return &BlobLinkDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Query returns a query builder for BlobLink.
func (c *BlobLinkClient) Query() *BlobLinkQuery {
	return &BlobLinkQuery{
		config: c.config,
	}
}

// QueryBlob queries the blob edge of a BlobLink.
func (c *BlobLinkClient) QueryBlob(bl *BlobLink) *BlobQuery {
	return c.Query().
		Where(bloblink.BlobID(bl.BlobID), bloblink.LinkID(bl.LinkID)).
		QueryBlob()
}

// QueryLink queries the link edge of a BlobLink.
func (c *BlobLinkClient) QueryLink(bl *BlobLink) *BlobQuery {
	return c.Query().
		Where(bloblink.BlobID(bl.BlobID), bloblink.LinkID(bl.LinkID)).
		QueryLink()
}

// Hooks returns the client hooks.
func (c *BlobLinkClient) Hooks() []Hook {
	return c.hooks.BlobLink
}

// CarClient is a client for the Car schema.
type CarClient struct {
	config
}

// NewCarClient returns a client for the Car from the given config.
func NewCarClient(c config) *CarClient {
	return &CarClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `car.Hooks(f(g(h())))`.
func (c *CarClient) Use(hooks ...Hook) {
	c.hooks.Car = append(c.hooks.Car, hooks...)
}

// Create returns a builder for creating a Car entity.
func (c *CarClient) Create() *CarCreate {
	mutation := newCarMutation(c.config, OpCreate)
	return &CarCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Car entities.
func (c *CarClient) CreateBulk(builders ...*CarCreate) *CarCreateBulk {
	return &CarCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Car.
func (c *CarClient) Update() *CarUpdate {
	mutation := newCarMutation(c.config, OpUpdate)
	return &CarUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *CarClient) UpdateOne(ca *Car) *CarUpdateOne {
	mutation := newCarMutation(c.config, OpUpdateOne, withCar(ca))
	return &CarUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *CarClient) UpdateOneID(id int) *CarUpdateOne {
	mutation := newCarMutation(c.config, OpUpdateOne, withCarID(id))
	return &CarUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Car.
func (c *CarClient) Delete() *CarDelete {
	mutation := newCarMutation(c.config, OpDelete)
	return &CarDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *CarClient) DeleteOne(ca *Car) *CarDeleteOne {
	return c.DeleteOneID(ca.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *CarClient) DeleteOneID(id int) *CarDeleteOne {
	builder := c.Delete().Where(car.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &CarDeleteOne{builder}
}

// Query returns a query builder for Car.
func (c *CarClient) Query() *CarQuery {
	return &CarQuery{
		config: c.config,
	}
}

// Get returns a Car entity by its id.
func (c *CarClient) Get(ctx context.Context, id int) (*Car, error) {
	return c.Query().Where(car.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *CarClient) GetX(ctx context.Context, id int) *Car {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a Car.
func (c *CarClient) QueryOwner(ca *Car) *PetQuery {
	query := &PetQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := ca.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(car.Table, car.FieldID, id),
			sqlgraph.To(pet.Table, pet.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, car.OwnerTable, car.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(ca.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *CarClient) Hooks() []Hook {
	return c.hooks.Car
}

// DeviceClient is a client for the Device schema.
type DeviceClient struct {
	config
}

// NewDeviceClient returns a client for the Device from the given config.
func NewDeviceClient(c config) *DeviceClient {
	return &DeviceClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `device.Hooks(f(g(h())))`.
func (c *DeviceClient) Use(hooks ...Hook) {
	c.hooks.Device = append(c.hooks.Device, hooks...)
}

// Create returns a builder for creating a Device entity.
func (c *DeviceClient) Create() *DeviceCreate {
	mutation := newDeviceMutation(c.config, OpCreate)
	return &DeviceCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Device entities.
func (c *DeviceClient) CreateBulk(builders ...*DeviceCreate) *DeviceCreateBulk {
	return &DeviceCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Device.
func (c *DeviceClient) Update() *DeviceUpdate {
	mutation := newDeviceMutation(c.config, OpUpdate)
	return &DeviceUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *DeviceClient) UpdateOne(d *Device) *DeviceUpdateOne {
	mutation := newDeviceMutation(c.config, OpUpdateOne, withDevice(d))
	return &DeviceUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *DeviceClient) UpdateOneID(id schema.ID) *DeviceUpdateOne {
	mutation := newDeviceMutation(c.config, OpUpdateOne, withDeviceID(id))
	return &DeviceUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Device.
func (c *DeviceClient) Delete() *DeviceDelete {
	mutation := newDeviceMutation(c.config, OpDelete)
	return &DeviceDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *DeviceClient) DeleteOne(d *Device) *DeviceDeleteOne {
	return c.DeleteOneID(d.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *DeviceClient) DeleteOneID(id schema.ID) *DeviceDeleteOne {
	builder := c.Delete().Where(device.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &DeviceDeleteOne{builder}
}

// Query returns a query builder for Device.
func (c *DeviceClient) Query() *DeviceQuery {
	return &DeviceQuery{
		config: c.config,
	}
}

// Get returns a Device entity by its id.
func (c *DeviceClient) Get(ctx context.Context, id schema.ID) (*Device, error) {
	return c.Query().Where(device.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *DeviceClient) GetX(ctx context.Context, id schema.ID) *Device {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryActiveSession queries the active_session edge of a Device.
func (c *DeviceClient) QueryActiveSession(d *Device) *SessionQuery {
	query := &SessionQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := d.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(device.Table, device.FieldID, id),
			sqlgraph.To(session.Table, session.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, device.ActiveSessionTable, device.ActiveSessionColumn),
		)
		fromV = sqlgraph.Neighbors(d.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QuerySessions queries the sessions edge of a Device.
func (c *DeviceClient) QuerySessions(d *Device) *SessionQuery {
	query := &SessionQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := d.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(device.Table, device.FieldID, id),
			sqlgraph.To(session.Table, session.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, device.SessionsTable, device.SessionsColumn),
		)
		fromV = sqlgraph.Neighbors(d.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *DeviceClient) Hooks() []Hook {
	return c.hooks.Device
}

// DocClient is a client for the Doc schema.
type DocClient struct {
	config
}

// NewDocClient returns a client for the Doc from the given config.
func NewDocClient(c config) *DocClient {
	return &DocClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `doc.Hooks(f(g(h())))`.
func (c *DocClient) Use(hooks ...Hook) {
	c.hooks.Doc = append(c.hooks.Doc, hooks...)
}

// Create returns a builder for creating a Doc entity.
func (c *DocClient) Create() *DocCreate {
	mutation := newDocMutation(c.config, OpCreate)
	return &DocCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Doc entities.
func (c *DocClient) CreateBulk(builders ...*DocCreate) *DocCreateBulk {
	return &DocCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Doc.
func (c *DocClient) Update() *DocUpdate {
	mutation := newDocMutation(c.config, OpUpdate)
	return &DocUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *DocClient) UpdateOne(d *Doc) *DocUpdateOne {
	mutation := newDocMutation(c.config, OpUpdateOne, withDoc(d))
	return &DocUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *DocClient) UpdateOneID(id schema.DocID) *DocUpdateOne {
	mutation := newDocMutation(c.config, OpUpdateOne, withDocID(id))
	return &DocUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Doc.
func (c *DocClient) Delete() *DocDelete {
	mutation := newDocMutation(c.config, OpDelete)
	return &DocDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *DocClient) DeleteOne(d *Doc) *DocDeleteOne {
	return c.DeleteOneID(d.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *DocClient) DeleteOneID(id schema.DocID) *DocDeleteOne {
	builder := c.Delete().Where(doc.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &DocDeleteOne{builder}
}

// Query returns a query builder for Doc.
func (c *DocClient) Query() *DocQuery {
	return &DocQuery{
		config: c.config,
	}
}

// Get returns a Doc entity by its id.
func (c *DocClient) Get(ctx context.Context, id schema.DocID) (*Doc, error) {
	return c.Query().Where(doc.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *DocClient) GetX(ctx context.Context, id schema.DocID) *Doc {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryParent queries the parent edge of a Doc.
func (c *DocClient) QueryParent(d *Doc) *DocQuery {
	query := &DocQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := d.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(doc.Table, doc.FieldID, id),
			sqlgraph.To(doc.Table, doc.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, doc.ParentTable, doc.ParentColumn),
		)
		fromV = sqlgraph.Neighbors(d.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryChildren queries the children edge of a Doc.
func (c *DocClient) QueryChildren(d *Doc) *DocQuery {
	query := &DocQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := d.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(doc.Table, doc.FieldID, id),
			sqlgraph.To(doc.Table, doc.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, doc.ChildrenTable, doc.ChildrenColumn),
		)
		fromV = sqlgraph.Neighbors(d.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryRelated queries the related edge of a Doc.
func (c *DocClient) QueryRelated(d *Doc) *DocQuery {
	query := &DocQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := d.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(doc.Table, doc.FieldID, id),
			sqlgraph.To(doc.Table, doc.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, doc.RelatedTable, doc.RelatedPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(d.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *DocClient) Hooks() []Hook {
	return c.hooks.Doc
}

// GroupClient is a client for the Group schema.
type GroupClient struct {
	config
}

// NewGroupClient returns a client for the Group from the given config.
func NewGroupClient(c config) *GroupClient {
	return &GroupClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `group.Hooks(f(g(h())))`.
func (c *GroupClient) Use(hooks ...Hook) {
	c.hooks.Group = append(c.hooks.Group, hooks...)
}

// Create returns a builder for creating a Group entity.
func (c *GroupClient) Create() *GroupCreate {
	mutation := newGroupMutation(c.config, OpCreate)
	return &GroupCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Group entities.
func (c *GroupClient) CreateBulk(builders ...*GroupCreate) *GroupCreateBulk {
	return &GroupCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Group.
func (c *GroupClient) Update() *GroupUpdate {
	mutation := newGroupMutation(c.config, OpUpdate)
	return &GroupUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *GroupClient) UpdateOne(gr *Group) *GroupUpdateOne {
	mutation := newGroupMutation(c.config, OpUpdateOne, withGroup(gr))
	return &GroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *GroupClient) UpdateOneID(id int) *GroupUpdateOne {
	mutation := newGroupMutation(c.config, OpUpdateOne, withGroupID(id))
	return &GroupUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Group.
func (c *GroupClient) Delete() *GroupDelete {
	mutation := newGroupMutation(c.config, OpDelete)
	return &GroupDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *GroupClient) DeleteOne(gr *Group) *GroupDeleteOne {
	return c.DeleteOneID(gr.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *GroupClient) DeleteOneID(id int) *GroupDeleteOne {
	builder := c.Delete().Where(group.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &GroupDeleteOne{builder}
}

// Query returns a query builder for Group.
func (c *GroupClient) Query() *GroupQuery {
	return &GroupQuery{
		config: c.config,
	}
}

// Get returns a Group entity by its id.
func (c *GroupClient) Get(ctx context.Context, id int) (*Group, error) {
	return c.Query().Where(group.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *GroupClient) GetX(ctx context.Context, id int) *Group {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryUsers queries the users edge of a Group.
func (c *GroupClient) QueryUsers(gr *Group) *UserQuery {
	query := &UserQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := gr.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(group.Table, group.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, group.UsersTable, group.UsersPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(gr.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *GroupClient) Hooks() []Hook {
	return c.hooks.Group
}

// IntSIDClient is a client for the IntSID schema.
type IntSIDClient struct {
	config
}

// NewIntSIDClient returns a client for the IntSID from the given config.
func NewIntSIDClient(c config) *IntSIDClient {
	return &IntSIDClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `intsid.Hooks(f(g(h())))`.
func (c *IntSIDClient) Use(hooks ...Hook) {
	c.hooks.IntSID = append(c.hooks.IntSID, hooks...)
}

// Create returns a builder for creating a IntSID entity.
func (c *IntSIDClient) Create() *IntSIDCreate {
	mutation := newIntSIDMutation(c.config, OpCreate)
	return &IntSIDCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of IntSID entities.
func (c *IntSIDClient) CreateBulk(builders ...*IntSIDCreate) *IntSIDCreateBulk {
	return &IntSIDCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for IntSID.
func (c *IntSIDClient) Update() *IntSIDUpdate {
	mutation := newIntSIDMutation(c.config, OpUpdate)
	return &IntSIDUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *IntSIDClient) UpdateOne(is *IntSID) *IntSIDUpdateOne {
	mutation := newIntSIDMutation(c.config, OpUpdateOne, withIntSID(is))
	return &IntSIDUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *IntSIDClient) UpdateOneID(id sid.ID) *IntSIDUpdateOne {
	mutation := newIntSIDMutation(c.config, OpUpdateOne, withIntSIDID(id))
	return &IntSIDUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for IntSID.
func (c *IntSIDClient) Delete() *IntSIDDelete {
	mutation := newIntSIDMutation(c.config, OpDelete)
	return &IntSIDDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *IntSIDClient) DeleteOne(is *IntSID) *IntSIDDeleteOne {
	return c.DeleteOneID(is.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *IntSIDClient) DeleteOneID(id sid.ID) *IntSIDDeleteOne {
	builder := c.Delete().Where(intsid.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &IntSIDDeleteOne{builder}
}

// Query returns a query builder for IntSID.
func (c *IntSIDClient) Query() *IntSIDQuery {
	return &IntSIDQuery{
		config: c.config,
	}
}

// Get returns a IntSID entity by its id.
func (c *IntSIDClient) Get(ctx context.Context, id sid.ID) (*IntSID, error) {
	return c.Query().Where(intsid.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *IntSIDClient) GetX(ctx context.Context, id sid.ID) *IntSID {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryParent queries the parent edge of a IntSID.
func (c *IntSIDClient) QueryParent(is *IntSID) *IntSIDQuery {
	query := &IntSIDQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := is.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(intsid.Table, intsid.FieldID, id),
			sqlgraph.To(intsid.Table, intsid.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, intsid.ParentTable, intsid.ParentColumn),
		)
		fromV = sqlgraph.Neighbors(is.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryChildren queries the children edge of a IntSID.
func (c *IntSIDClient) QueryChildren(is *IntSID) *IntSIDQuery {
	query := &IntSIDQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := is.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(intsid.Table, intsid.FieldID, id),
			sqlgraph.To(intsid.Table, intsid.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, true, intsid.ChildrenTable, intsid.ChildrenColumn),
		)
		fromV = sqlgraph.Neighbors(is.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *IntSIDClient) Hooks() []Hook {
	return c.hooks.IntSID
}

// LinkClient is a client for the Link schema.
type LinkClient struct {
	config
}

// NewLinkClient returns a client for the Link from the given config.
func NewLinkClient(c config) *LinkClient {
	return &LinkClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `link.Hooks(f(g(h())))`.
func (c *LinkClient) Use(hooks ...Hook) {
	c.hooks.Link = append(c.hooks.Link, hooks...)
}

// Create returns a builder for creating a Link entity.
func (c *LinkClient) Create() *LinkCreate {
	mutation := newLinkMutation(c.config, OpCreate)
	return &LinkCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Link entities.
func (c *LinkClient) CreateBulk(builders ...*LinkCreate) *LinkCreateBulk {
	return &LinkCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Link.
func (c *LinkClient) Update() *LinkUpdate {
	mutation := newLinkMutation(c.config, OpUpdate)
	return &LinkUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *LinkClient) UpdateOne(l *Link) *LinkUpdateOne {
	mutation := newLinkMutation(c.config, OpUpdateOne, withLink(l))
	return &LinkUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *LinkClient) UpdateOneID(id uuidc.UUIDC) *LinkUpdateOne {
	mutation := newLinkMutation(c.config, OpUpdateOne, withLinkID(id))
	return &LinkUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Link.
func (c *LinkClient) Delete() *LinkDelete {
	mutation := newLinkMutation(c.config, OpDelete)
	return &LinkDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *LinkClient) DeleteOne(l *Link) *LinkDeleteOne {
	return c.DeleteOneID(l.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *LinkClient) DeleteOneID(id uuidc.UUIDC) *LinkDeleteOne {
	builder := c.Delete().Where(link.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &LinkDeleteOne{builder}
}

// Query returns a query builder for Link.
func (c *LinkClient) Query() *LinkQuery {
	return &LinkQuery{
		config: c.config,
	}
}

// Get returns a Link entity by its id.
func (c *LinkClient) Get(ctx context.Context, id uuidc.UUIDC) (*Link, error) {
	return c.Query().Where(link.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *LinkClient) GetX(ctx context.Context, id uuidc.UUIDC) *Link {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *LinkClient) Hooks() []Hook {
	return c.hooks.Link
}

// MixinIDClient is a client for the MixinID schema.
type MixinIDClient struct {
	config
}

// NewMixinIDClient returns a client for the MixinID from the given config.
func NewMixinIDClient(c config) *MixinIDClient {
	return &MixinIDClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `mixinid.Hooks(f(g(h())))`.
func (c *MixinIDClient) Use(hooks ...Hook) {
	c.hooks.MixinID = append(c.hooks.MixinID, hooks...)
}

// Create returns a builder for creating a MixinID entity.
func (c *MixinIDClient) Create() *MixinIDCreate {
	mutation := newMixinIDMutation(c.config, OpCreate)
	return &MixinIDCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of MixinID entities.
func (c *MixinIDClient) CreateBulk(builders ...*MixinIDCreate) *MixinIDCreateBulk {
	return &MixinIDCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for MixinID.
func (c *MixinIDClient) Update() *MixinIDUpdate {
	mutation := newMixinIDMutation(c.config, OpUpdate)
	return &MixinIDUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *MixinIDClient) UpdateOne(mi *MixinID) *MixinIDUpdateOne {
	mutation := newMixinIDMutation(c.config, OpUpdateOne, withMixinID(mi))
	return &MixinIDUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *MixinIDClient) UpdateOneID(id uuid.UUID) *MixinIDUpdateOne {
	mutation := newMixinIDMutation(c.config, OpUpdateOne, withMixinIDID(id))
	return &MixinIDUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for MixinID.
func (c *MixinIDClient) Delete() *MixinIDDelete {
	mutation := newMixinIDMutation(c.config, OpDelete)
	return &MixinIDDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *MixinIDClient) DeleteOne(mi *MixinID) *MixinIDDeleteOne {
	return c.DeleteOneID(mi.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *MixinIDClient) DeleteOneID(id uuid.UUID) *MixinIDDeleteOne {
	builder := c.Delete().Where(mixinid.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &MixinIDDeleteOne{builder}
}

// Query returns a query builder for MixinID.
func (c *MixinIDClient) Query() *MixinIDQuery {
	return &MixinIDQuery{
		config: c.config,
	}
}

// Get returns a MixinID entity by its id.
func (c *MixinIDClient) Get(ctx context.Context, id uuid.UUID) (*MixinID, error) {
	return c.Query().Where(mixinid.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *MixinIDClient) GetX(ctx context.Context, id uuid.UUID) *MixinID {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *MixinIDClient) Hooks() []Hook {
	return c.hooks.MixinID
}

// NoteClient is a client for the Note schema.
type NoteClient struct {
	config
}

// NewNoteClient returns a client for the Note from the given config.
func NewNoteClient(c config) *NoteClient {
	return &NoteClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `note.Hooks(f(g(h())))`.
func (c *NoteClient) Use(hooks ...Hook) {
	c.hooks.Note = append(c.hooks.Note, hooks...)
}

// Create returns a builder for creating a Note entity.
func (c *NoteClient) Create() *NoteCreate {
	mutation := newNoteMutation(c.config, OpCreate)
	return &NoteCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Note entities.
func (c *NoteClient) CreateBulk(builders ...*NoteCreate) *NoteCreateBulk {
	return &NoteCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Note.
func (c *NoteClient) Update() *NoteUpdate {
	mutation := newNoteMutation(c.config, OpUpdate)
	return &NoteUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *NoteClient) UpdateOne(n *Note) *NoteUpdateOne {
	mutation := newNoteMutation(c.config, OpUpdateOne, withNote(n))
	return &NoteUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *NoteClient) UpdateOneID(id schema.NoteID) *NoteUpdateOne {
	mutation := newNoteMutation(c.config, OpUpdateOne, withNoteID(id))
	return &NoteUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Note.
func (c *NoteClient) Delete() *NoteDelete {
	mutation := newNoteMutation(c.config, OpDelete)
	return &NoteDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *NoteClient) DeleteOne(n *Note) *NoteDeleteOne {
	return c.DeleteOneID(n.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *NoteClient) DeleteOneID(id schema.NoteID) *NoteDeleteOne {
	builder := c.Delete().Where(note.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &NoteDeleteOne{builder}
}

// Query returns a query builder for Note.
func (c *NoteClient) Query() *NoteQuery {
	return &NoteQuery{
		config: c.config,
	}
}

// Get returns a Note entity by its id.
func (c *NoteClient) Get(ctx context.Context, id schema.NoteID) (*Note, error) {
	return c.Query().Where(note.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *NoteClient) GetX(ctx context.Context, id schema.NoteID) *Note {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryParent queries the parent edge of a Note.
func (c *NoteClient) QueryParent(n *Note) *NoteQuery {
	query := &NoteQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := n.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(note.Table, note.FieldID, id),
			sqlgraph.To(note.Table, note.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, note.ParentTable, note.ParentColumn),
		)
		fromV = sqlgraph.Neighbors(n.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryChildren queries the children edge of a Note.
func (c *NoteClient) QueryChildren(n *Note) *NoteQuery {
	query := &NoteQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := n.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(note.Table, note.FieldID, id),
			sqlgraph.To(note.Table, note.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, note.ChildrenTable, note.ChildrenColumn),
		)
		fromV = sqlgraph.Neighbors(n.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *NoteClient) Hooks() []Hook {
	return c.hooks.Note
}

// OtherClient is a client for the Other schema.
type OtherClient struct {
	config
}

// NewOtherClient returns a client for the Other from the given config.
func NewOtherClient(c config) *OtherClient {
	return &OtherClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `other.Hooks(f(g(h())))`.
func (c *OtherClient) Use(hooks ...Hook) {
	c.hooks.Other = append(c.hooks.Other, hooks...)
}

// Create returns a builder for creating a Other entity.
func (c *OtherClient) Create() *OtherCreate {
	mutation := newOtherMutation(c.config, OpCreate)
	return &OtherCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Other entities.
func (c *OtherClient) CreateBulk(builders ...*OtherCreate) *OtherCreateBulk {
	return &OtherCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Other.
func (c *OtherClient) Update() *OtherUpdate {
	mutation := newOtherMutation(c.config, OpUpdate)
	return &OtherUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *OtherClient) UpdateOne(o *Other) *OtherUpdateOne {
	mutation := newOtherMutation(c.config, OpUpdateOne, withOther(o))
	return &OtherUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *OtherClient) UpdateOneID(id sid.ID) *OtherUpdateOne {
	mutation := newOtherMutation(c.config, OpUpdateOne, withOtherID(id))
	return &OtherUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Other.
func (c *OtherClient) Delete() *OtherDelete {
	mutation := newOtherMutation(c.config, OpDelete)
	return &OtherDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *OtherClient) DeleteOne(o *Other) *OtherDeleteOne {
	return c.DeleteOneID(o.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *OtherClient) DeleteOneID(id sid.ID) *OtherDeleteOne {
	builder := c.Delete().Where(other.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &OtherDeleteOne{builder}
}

// Query returns a query builder for Other.
func (c *OtherClient) Query() *OtherQuery {
	return &OtherQuery{
		config: c.config,
	}
}

// Get returns a Other entity by its id.
func (c *OtherClient) Get(ctx context.Context, id sid.ID) (*Other, error) {
	return c.Query().Where(other.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *OtherClient) GetX(ctx context.Context, id sid.ID) *Other {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *OtherClient) Hooks() []Hook {
	return c.hooks.Other
}

// PetClient is a client for the Pet schema.
type PetClient struct {
	config
}

// NewPetClient returns a client for the Pet from the given config.
func NewPetClient(c config) *PetClient {
	return &PetClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `pet.Hooks(f(g(h())))`.
func (c *PetClient) Use(hooks ...Hook) {
	c.hooks.Pet = append(c.hooks.Pet, hooks...)
}

// Create returns a builder for creating a Pet entity.
func (c *PetClient) Create() *PetCreate {
	mutation := newPetMutation(c.config, OpCreate)
	return &PetCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Pet entities.
func (c *PetClient) CreateBulk(builders ...*PetCreate) *PetCreateBulk {
	return &PetCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Pet.
func (c *PetClient) Update() *PetUpdate {
	mutation := newPetMutation(c.config, OpUpdate)
	return &PetUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *PetClient) UpdateOne(pe *Pet) *PetUpdateOne {
	mutation := newPetMutation(c.config, OpUpdateOne, withPet(pe))
	return &PetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *PetClient) UpdateOneID(id string) *PetUpdateOne {
	mutation := newPetMutation(c.config, OpUpdateOne, withPetID(id))
	return &PetUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Pet.
func (c *PetClient) Delete() *PetDelete {
	mutation := newPetMutation(c.config, OpDelete)
	return &PetDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *PetClient) DeleteOne(pe *Pet) *PetDeleteOne {
	return c.DeleteOneID(pe.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *PetClient) DeleteOneID(id string) *PetDeleteOne {
	builder := c.Delete().Where(pet.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &PetDeleteOne{builder}
}

// Query returns a query builder for Pet.
func (c *PetClient) Query() *PetQuery {
	return &PetQuery{
		config: c.config,
	}
}

// Get returns a Pet entity by its id.
func (c *PetClient) Get(ctx context.Context, id string) (*Pet, error) {
	return c.Query().Where(pet.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *PetClient) GetX(ctx context.Context, id string) *Pet {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a Pet.
func (c *PetClient) QueryOwner(pe *Pet) *UserQuery {
	query := &UserQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := pe.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(pet.Table, pet.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, pet.OwnerTable, pet.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(pe.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryCars queries the cars edge of a Pet.
func (c *PetClient) QueryCars(pe *Pet) *CarQuery {
	query := &CarQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := pe.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(pet.Table, pet.FieldID, id),
			sqlgraph.To(car.Table, car.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, pet.CarsTable, pet.CarsColumn),
		)
		fromV = sqlgraph.Neighbors(pe.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryFriends queries the friends edge of a Pet.
func (c *PetClient) QueryFriends(pe *Pet) *PetQuery {
	query := &PetQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := pe.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(pet.Table, pet.FieldID, id),
			sqlgraph.To(pet.Table, pet.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, pet.FriendsTable, pet.FriendsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(pe.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryBestFriend queries the best_friend edge of a Pet.
func (c *PetClient) QueryBestFriend(pe *Pet) *PetQuery {
	query := &PetQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := pe.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(pet.Table, pet.FieldID, id),
			sqlgraph.To(pet.Table, pet.FieldID),
			sqlgraph.Edge(sqlgraph.O2O, false, pet.BestFriendTable, pet.BestFriendColumn),
		)
		fromV = sqlgraph.Neighbors(pe.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *PetClient) Hooks() []Hook {
	return c.hooks.Pet
}

// RevisionClient is a client for the Revision schema.
type RevisionClient struct {
	config
}

// NewRevisionClient returns a client for the Revision from the given config.
func NewRevisionClient(c config) *RevisionClient {
	return &RevisionClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `revision.Hooks(f(g(h())))`.
func (c *RevisionClient) Use(hooks ...Hook) {
	c.hooks.Revision = append(c.hooks.Revision, hooks...)
}

// Create returns a builder for creating a Revision entity.
func (c *RevisionClient) Create() *RevisionCreate {
	mutation := newRevisionMutation(c.config, OpCreate)
	return &RevisionCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Revision entities.
func (c *RevisionClient) CreateBulk(builders ...*RevisionCreate) *RevisionCreateBulk {
	return &RevisionCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Revision.
func (c *RevisionClient) Update() *RevisionUpdate {
	mutation := newRevisionMutation(c.config, OpUpdate)
	return &RevisionUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *RevisionClient) UpdateOne(r *Revision) *RevisionUpdateOne {
	mutation := newRevisionMutation(c.config, OpUpdateOne, withRevision(r))
	return &RevisionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *RevisionClient) UpdateOneID(id string) *RevisionUpdateOne {
	mutation := newRevisionMutation(c.config, OpUpdateOne, withRevisionID(id))
	return &RevisionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Revision.
func (c *RevisionClient) Delete() *RevisionDelete {
	mutation := newRevisionMutation(c.config, OpDelete)
	return &RevisionDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *RevisionClient) DeleteOne(r *Revision) *RevisionDeleteOne {
	return c.DeleteOneID(r.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *RevisionClient) DeleteOneID(id string) *RevisionDeleteOne {
	builder := c.Delete().Where(revision.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &RevisionDeleteOne{builder}
}

// Query returns a query builder for Revision.
func (c *RevisionClient) Query() *RevisionQuery {
	return &RevisionQuery{
		config: c.config,
	}
}

// Get returns a Revision entity by its id.
func (c *RevisionClient) Get(ctx context.Context, id string) (*Revision, error) {
	return c.Query().Where(revision.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *RevisionClient) GetX(ctx context.Context, id string) *Revision {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *RevisionClient) Hooks() []Hook {
	return c.hooks.Revision
}

// SessionClient is a client for the Session schema.
type SessionClient struct {
	config
}

// NewSessionClient returns a client for the Session from the given config.
func NewSessionClient(c config) *SessionClient {
	return &SessionClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `session.Hooks(f(g(h())))`.
func (c *SessionClient) Use(hooks ...Hook) {
	c.hooks.Session = append(c.hooks.Session, hooks...)
}

// Create returns a builder for creating a Session entity.
func (c *SessionClient) Create() *SessionCreate {
	mutation := newSessionMutation(c.config, OpCreate)
	return &SessionCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Session entities.
func (c *SessionClient) CreateBulk(builders ...*SessionCreate) *SessionCreateBulk {
	return &SessionCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Session.
func (c *SessionClient) Update() *SessionUpdate {
	mutation := newSessionMutation(c.config, OpUpdate)
	return &SessionUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *SessionClient) UpdateOne(s *Session) *SessionUpdateOne {
	mutation := newSessionMutation(c.config, OpUpdateOne, withSession(s))
	return &SessionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *SessionClient) UpdateOneID(id schema.ID) *SessionUpdateOne {
	mutation := newSessionMutation(c.config, OpUpdateOne, withSessionID(id))
	return &SessionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Session.
func (c *SessionClient) Delete() *SessionDelete {
	mutation := newSessionMutation(c.config, OpDelete)
	return &SessionDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *SessionClient) DeleteOne(s *Session) *SessionDeleteOne {
	return c.DeleteOneID(s.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *SessionClient) DeleteOneID(id schema.ID) *SessionDeleteOne {
	builder := c.Delete().Where(session.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &SessionDeleteOne{builder}
}

// Query returns a query builder for Session.
func (c *SessionClient) Query() *SessionQuery {
	return &SessionQuery{
		config: c.config,
	}
}

// Get returns a Session entity by its id.
func (c *SessionClient) Get(ctx context.Context, id schema.ID) (*Session, error) {
	return c.Query().Where(session.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *SessionClient) GetX(ctx context.Context, id schema.ID) *Session {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryDevice queries the device edge of a Session.
func (c *SessionClient) QueryDevice(s *Session) *DeviceQuery {
	query := &DeviceQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := s.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(session.Table, session.FieldID, id),
			sqlgraph.To(device.Table, device.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, session.DeviceTable, session.DeviceColumn),
		)
		fromV = sqlgraph.Neighbors(s.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *SessionClient) Hooks() []Hook {
	return c.hooks.Session
}

// TokenClient is a client for the Token schema.
type TokenClient struct {
	config
}

// NewTokenClient returns a client for the Token from the given config.
func NewTokenClient(c config) *TokenClient {
	return &TokenClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `token.Hooks(f(g(h())))`.
func (c *TokenClient) Use(hooks ...Hook) {
	c.hooks.Token = append(c.hooks.Token, hooks...)
}

// Create returns a builder for creating a Token entity.
func (c *TokenClient) Create() *TokenCreate {
	mutation := newTokenMutation(c.config, OpCreate)
	return &TokenCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Token entities.
func (c *TokenClient) CreateBulk(builders ...*TokenCreate) *TokenCreateBulk {
	return &TokenCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Token.
func (c *TokenClient) Update() *TokenUpdate {
	mutation := newTokenMutation(c.config, OpUpdate)
	return &TokenUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *TokenClient) UpdateOne(t *Token) *TokenUpdateOne {
	mutation := newTokenMutation(c.config, OpUpdateOne, withToken(t))
	return &TokenUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *TokenClient) UpdateOneID(id sid.ID) *TokenUpdateOne {
	mutation := newTokenMutation(c.config, OpUpdateOne, withTokenID(id))
	return &TokenUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Token.
func (c *TokenClient) Delete() *TokenDelete {
	mutation := newTokenMutation(c.config, OpDelete)
	return &TokenDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *TokenClient) DeleteOne(t *Token) *TokenDeleteOne {
	return c.DeleteOneID(t.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *TokenClient) DeleteOneID(id sid.ID) *TokenDeleteOne {
	builder := c.Delete().Where(token.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &TokenDeleteOne{builder}
}

// Query returns a query builder for Token.
func (c *TokenClient) Query() *TokenQuery {
	return &TokenQuery{
		config: c.config,
	}
}

// Get returns a Token entity by its id.
func (c *TokenClient) Get(ctx context.Context, id sid.ID) (*Token, error) {
	return c.Query().Where(token.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *TokenClient) GetX(ctx context.Context, id sid.ID) *Token {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryAccount queries the account edge of a Token.
func (c *TokenClient) QueryAccount(t *Token) *AccountQuery {
	query := &AccountQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := t.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(token.Table, token.FieldID, id),
			sqlgraph.To(account.Table, account.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, token.AccountTable, token.AccountColumn),
		)
		fromV = sqlgraph.Neighbors(t.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *TokenClient) Hooks() []Hook {
	return c.hooks.Token
}

// UserClient is a client for the User schema.
type UserClient struct {
	config
}

// NewUserClient returns a client for the User from the given config.
func NewUserClient(c config) *UserClient {
	return &UserClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `user.Hooks(f(g(h())))`.
func (c *UserClient) Use(hooks ...Hook) {
	c.hooks.User = append(c.hooks.User, hooks...)
}

// Create returns a builder for creating a User entity.
func (c *UserClient) Create() *UserCreate {
	mutation := newUserMutation(c.config, OpCreate)
	return &UserCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of User entities.
func (c *UserClient) CreateBulk(builders ...*UserCreate) *UserCreateBulk {
	return &UserCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for User.
func (c *UserClient) Update() *UserUpdate {
	mutation := newUserMutation(c.config, OpUpdate)
	return &UserUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *UserClient) UpdateOne(u *User) *UserUpdateOne {
	mutation := newUserMutation(c.config, OpUpdateOne, withUser(u))
	return &UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *UserClient) UpdateOneID(id int) *UserUpdateOne {
	mutation := newUserMutation(c.config, OpUpdateOne, withUserID(id))
	return &UserUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for User.
func (c *UserClient) Delete() *UserDelete {
	mutation := newUserMutation(c.config, OpDelete)
	return &UserDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *UserClient) DeleteOne(u *User) *UserDeleteOne {
	return c.DeleteOneID(u.ID)
}

// DeleteOne returns a builder for deleting the given entity by its id.
func (c *UserClient) DeleteOneID(id int) *UserDeleteOne {
	builder := c.Delete().Where(user.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &UserDeleteOne{builder}
}

// Query returns a query builder for User.
func (c *UserClient) Query() *UserQuery {
	return &UserQuery{
		config: c.config,
	}
}

// Get returns a User entity by its id.
func (c *UserClient) Get(ctx context.Context, id int) (*User, error) {
	return c.Query().Where(user.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *UserClient) GetX(ctx context.Context, id int) *User {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryGroups queries the groups edge of a User.
func (c *UserClient) QueryGroups(u *User) *GroupQuery {
	query := &GroupQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(group.Table, group.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, user.GroupsTable, user.GroupsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryParent queries the parent edge of a User.
func (c *UserClient) QueryParent(u *User) *UserQuery {
	query := &UserQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, user.ParentTable, user.ParentColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryChildren queries the children edge of a User.
func (c *UserClient) QueryChildren(u *User) *UserQuery {
	query := &UserQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.ChildrenTable, user.ChildrenColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryPets queries the pets edge of a User.
func (c *UserClient) QueryPets(u *User) *PetQuery {
	query := &PetQuery{config: c.config}
	query.path = func(ctx context.Context) (fromV *sql.Selector, _ error) {
		id := u.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(user.Table, user.FieldID, id),
			sqlgraph.To(pet.Table, pet.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, user.PetsTable, user.PetsColumn),
		)
		fromV = sqlgraph.Neighbors(u.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *UserClient) Hooks() []Hook {
	return c.hooks.User
}
