// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents a Amazon Web Services Service Catalog AppRegistry application that
// is the top-level node in a hierarchy of related cloud resource abstractions.
type Application struct {

	// A key-value pair that identifies an associated resource.
	ApplicationTag map[string]string

	// The Amazon resource name (ARN) that specifies the application across services.
	Arn *string

	// The ISO-8601 formatted timestamp of the moment when the application was created.
	CreationTime *time.Time

	// The description of the application.
	Description *string

	// The identifier of the application.
	Id *string

	// The ISO-8601 formatted timestamp of the moment when the application was last
	// updated.
	LastUpdateTime *time.Time

	// The name of the application. The name must be unique in the region in which you
	// are creating the application.
	Name *string

	// Key-value pairs you can use to associate with the application.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary of a Amazon Web Services Service Catalog AppRegistry application.
type ApplicationSummary struct {

	// The Amazon resource name (ARN) that specifies the application across services.
	Arn *string

	// The ISO-8601 formatted timestamp of the moment when the application was created.
	CreationTime *time.Time

	// The description of the application.
	Description *string

	// The identifier of the application.
	Id *string

	// The ISO-8601 formatted timestamp of the moment when the application was last
	// updated.
	LastUpdateTime *time.Time

	// The name of the application. The name must be unique in the region in which you
	// are creating the application.
	Name *string

	noSmithyDocumentSerde
}

// The result of the application tag that's applied to a resource.
type ApplicationTagResult struct {

	// The application tag is in the process of being applied to a resource, was
	// successfully applied to a resource, or failed to apply to a resource.
	ApplicationTagStatus ApplicationTagStatus

	// The message returned if the call fails.
	ErrorMessage *string

	// A unique pagination token for each page of results. Make the call again with
	// the returned token to retrieve the next page of results.
	NextToken *string

	// The resources associated with an application
	Resources []ResourcesListItem

	noSmithyDocumentSerde
}

// Includes all of the AppRegistry settings.
type AppRegistryConfiguration struct {

	// Includes the definition of a tagQuery .
	TagQueryConfiguration *TagQueryConfiguration

	noSmithyDocumentSerde
}

// Represents a Amazon Web Services Service Catalog AppRegistry attribute group
// that is rich metadata which describes an application and its components.
type AttributeGroup struct {

	// The Amazon resource name (ARN) that specifies the attribute group across
	// services.
	Arn *string

	// The ISO-8601 formatted timestamp of the moment the attribute group was created.
	CreationTime *time.Time

	// The description of the attribute group that the user provides.
	Description *string

	// The globally unique attribute group identifier of the attribute group.
	Id *string

	// The ISO-8601 formatted timestamp of the moment the attribute group was last
	// updated. This time is the same as the creationTime for a newly created attribute
	// group.
	LastUpdateTime *time.Time

	// The name of the attribute group.
	Name *string

	// Key-value pairs you can use to associate with the attribute group.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The details related to a specific AttributeGroup.
type AttributeGroupDetails struct {

	// The Amazon resource name (ARN) that specifies the attribute group.
	Arn *string

	// The service principal that created the attribute group.
	CreatedBy *string

	// The unique identifier of the attribute group.
	Id *string

	// This field is no longer supported. We recommend you don't use the field when
	// using ListAttributeGroupsForApplication . The name of the attribute group.
	Name *string

	noSmithyDocumentSerde
}

// Summary of a Amazon Web Services Service Catalog AppRegistry attribute group.
type AttributeGroupSummary struct {

	// The Amazon resource name (ARN) that specifies the attribute group across
	// services.
	Arn *string

	// The service principal that created the attribute group.
	CreatedBy *string

	// The ISO-8601 formatted timestamp of the moment the attribute group was created.
	CreationTime *time.Time

	// The description of the attribute group that the user provides.
	Description *string

	// The globally unique attribute group identifier of the attribute group.
	Id *string

	// The ISO-8601 formatted timestamp of the moment the attribute group was last
	// updated. This time is the same as the creationTime for a newly created attribute
	// group.
	LastUpdateTime *time.Time

	// The name of the attribute group.
	Name *string

	noSmithyDocumentSerde
}

// The information about the service integration.
type Integrations struct {

	// The information about the resource group integration.
	ApplicationTagResourceGroup *ResourceGroup

	// The information about the resource group integration.
	ResourceGroup *ResourceGroup

	noSmithyDocumentSerde
}

// The information about the resource.
type Resource struct {

	// The Amazon resource name (ARN) of the resource.
	Arn *string

	// The time the resource was associated with the application.
	AssociationTime *time.Time

	// The service integration information about the resource.
	Integrations *ResourceIntegrations

	// The name of the resource.
	Name *string

	noSmithyDocumentSerde
}

// The details related to the resource.
type ResourceDetails struct {

	// The value of the tag.
	TagValue *string

	noSmithyDocumentSerde
}

// The information about the resource group integration.
type ResourceGroup struct {

	// The Amazon resource name (ARN) of the resource group.
	Arn *string

	// The error message that generates when the propagation process for the resource
	// group fails.
	ErrorMessage *string

	// The state of the propagation process for the resource group. The states
	// includes: CREATING if the resource group is in the process of being created.
	// CREATE_COMPLETE if the resource group was created successfully. CREATE_FAILED
	// if the resource group failed to be created. UPDATING if the resource group is
	// in the process of being updated. UPDATE_COMPLETE if the resource group updated
	// successfully. UPDATE_FAILED if the resource group could not update successfully.
	State ResourceGroupState

	noSmithyDocumentSerde
}

// The information about the resource.
type ResourceInfo struct {

	// The Amazon resource name (ARN) that specifies the resource across services.
	Arn *string

	// The name of the resource.
	Name *string

	// Determines whether an application tag is applied or skipped.
	Options []AssociationOption

	// The details related to the resource.
	ResourceDetails *ResourceDetails

	// Provides information about the Service Catalog App Registry resource type.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// The service integration information about the resource.
type ResourceIntegrations struct {

	// The information about the integration of Resource Groups.
	ResourceGroup *ResourceGroup

	noSmithyDocumentSerde
}

// The resource in a list of resources.
type ResourcesListItem struct {

	// The message returned if the call fails.
	ErrorMessage *string

	// The Amazon resource name (ARN) of the resource.
	ResourceArn *string

	// Provides information about the AppRegistry resource type.
	ResourceType *string

	// The status of the list item.
	Status *string

	noSmithyDocumentSerde
}

// The definition of tagQuery . Specifies which resources are associated with an
// application.
type TagQueryConfiguration struct {

	// Condition in the IAM policy that associates resources to an application.
	TagKey *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
