// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opActivateGateway = "ActivateGateway"

// ActivateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the ActivateGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateGateway for more information on using the ActivateGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ActivateGatewayRequest method.
//    req, resp := client.ActivateGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGateway
func (c *StorageGateway) ActivateGatewayRequest(input *ActivateGatewayInput) (req *request.Request, output *ActivateGatewayOutput) {
	op := &request.Operation{
		Name:       opActivateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateGatewayInput{}
	}

	output = &ActivateGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ActivateGateway API operation for AWS Storage Gateway.
//
// Activates the gateway you previously deployed on your host. In the activation
// process, you specify information such as the AWS Region that you want to
// use for storing snapshots or tapes, the time zone for scheduled snapshots
// the gateway snapshot schedule window, an activation key, and a name for your
// gateway. The activation process also associates your gateway with your account.
// For more information, see UpdateGatewayInformation.
//
// You must turn on the gateway VM before you can activate your gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ActivateGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGateway
func (c *StorageGateway) ActivateGateway(input *ActivateGatewayInput) (*ActivateGatewayOutput, error) {
	req, out := c.ActivateGatewayRequest(input)
	return out, req.Send()
}

// ActivateGatewayWithContext is the same as ActivateGateway with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ActivateGatewayWithContext(ctx aws.Context, input *ActivateGatewayInput, opts ...request.Option) (*ActivateGatewayOutput, error) {
	req, out := c.ActivateGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddCache = "AddCache"

// AddCacheRequest generates a "aws/request.Request" representing the
// client's request for the AddCache operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddCache for more information on using the AddCache
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddCacheRequest method.
//    req, resp := client.AddCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCache
func (c *StorageGateway) AddCacheRequest(input *AddCacheInput) (req *request.Request, output *AddCacheOutput) {
	op := &request.Operation{
		Name:       opAddCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCacheInput{}
	}

	output = &AddCacheOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddCache API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as cache for a gateway. This operation
// is only supported in the cached volume, tape, and file gateway type (see
// How AWS Storage Gateway works (architecture) (https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html).
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add cache, and one or more disk IDs that you want to configure
// as cache.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddCache for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCache
func (c *StorageGateway) AddCache(input *AddCacheInput) (*AddCacheOutput, error) {
	req, out := c.AddCacheRequest(input)
	return out, req.Send()
}

// AddCacheWithContext is the same as AddCache with the addition of
// the ability to pass a context and additional request options.
//
// See AddCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AddCacheWithContext(ctx aws.Context, input *AddCacheInput, opts ...request.Option) (*AddCacheOutput, error) {
	req, out := c.AddCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResource
func (c *StorageGateway) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTagsToResource API operation for AWS Storage Gateway.
//
// Adds one or more tags to the specified resource. You use tags to add metadata
// to resources, which you can use to categorize these resources. For example,
// you can categorize resources by purpose, owner, environment, or team. Each
// tag consists of a key and a value, which you define. You can add tags to
// the following AWS Storage Gateway resources:
//
//    * Storage gateways of all types
//
//    * Storage volumes
//
//    * Virtual tapes
//
//    * NFS and SMB file shares
//
// You can create a maximum of 50 tags for each resource. Virtual tapes and
// storage volumes that are recovered to a new gateway maintain their tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResource
func (c *StorageGateway) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddUploadBuffer = "AddUploadBuffer"

// AddUploadBufferRequest generates a "aws/request.Request" representing the
// client's request for the AddUploadBuffer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddUploadBuffer for more information on using the AddUploadBuffer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddUploadBufferRequest method.
//    req, resp := client.AddUploadBufferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBuffer
func (c *StorageGateway) AddUploadBufferRequest(input *AddUploadBufferInput) (req *request.Request, output *AddUploadBufferOutput) {
	op := &request.Operation{
		Name:       opAddUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddUploadBufferInput{}
	}

	output = &AddUploadBufferOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddUploadBuffer API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as upload buffer for a specified
// gateway. This operation is supported for the stored volume, cached volume
// and tape gateway types.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add upload buffer, and one or more disk IDs that you want to
// configure as upload buffer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddUploadBuffer for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBuffer
func (c *StorageGateway) AddUploadBuffer(input *AddUploadBufferInput) (*AddUploadBufferOutput, error) {
	req, out := c.AddUploadBufferRequest(input)
	return out, req.Send()
}

// AddUploadBufferWithContext is the same as AddUploadBuffer with the addition of
// the ability to pass a context and additional request options.
//
// See AddUploadBuffer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AddUploadBufferWithContext(ctx aws.Context, input *AddUploadBufferInput, opts ...request.Option) (*AddUploadBufferOutput, error) {
	req, out := c.AddUploadBufferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddWorkingStorage = "AddWorkingStorage"

// AddWorkingStorageRequest generates a "aws/request.Request" representing the
// client's request for the AddWorkingStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddWorkingStorage for more information on using the AddWorkingStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddWorkingStorageRequest method.
//    req, resp := client.AddWorkingStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorage
func (c *StorageGateway) AddWorkingStorageRequest(input *AddWorkingStorageInput) (req *request.Request, output *AddWorkingStorageOutput) {
	op := &request.Operation{
		Name:       opAddWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddWorkingStorageInput{}
	}

	output = &AddWorkingStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddWorkingStorage API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as working storage for a gateway.
// This operation is only supported in the stored volume gateway type. This
// operation is deprecated in cached volume API version 20120630. Use AddUploadBuffer
// instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// AddUploadBuffer operation to add upload buffer to a stored volume gateway.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add working storage, and one or more disk IDs that you want to
// configure as working storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddWorkingStorage for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorage
func (c *StorageGateway) AddWorkingStorage(input *AddWorkingStorageInput) (*AddWorkingStorageOutput, error) {
	req, out := c.AddWorkingStorageRequest(input)
	return out, req.Send()
}

// AddWorkingStorageWithContext is the same as AddWorkingStorage with the addition of
// the ability to pass a context and additional request options.
//
// See AddWorkingStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AddWorkingStorageWithContext(ctx aws.Context, input *AddWorkingStorageInput, opts ...request.Option) (*AddWorkingStorageOutput, error) {
	req, out := c.AddWorkingStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssignTapePool = "AssignTapePool"

// AssignTapePoolRequest generates a "aws/request.Request" representing the
// client's request for the AssignTapePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignTapePool for more information on using the AssignTapePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssignTapePoolRequest method.
//    req, resp := client.AssignTapePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AssignTapePool
func (c *StorageGateway) AssignTapePoolRequest(input *AssignTapePoolInput) (req *request.Request, output *AssignTapePoolOutput) {
	op := &request.Operation{
		Name:       opAssignTapePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignTapePoolInput{}
	}

	output = &AssignTapePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssignTapePool API operation for AWS Storage Gateway.
//
// Assigns a tape to a tape pool for archiving. The tape assigned to a pool
// is archived in the S3 storage class that is associated with the pool. When
// you use your backup application to eject the tape, the tape is archived directly
// into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds
// to the pool.
//
// Valid Values: GLACIER | DEEP_ARCHIVE
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AssignTapePool for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AssignTapePool
func (c *StorageGateway) AssignTapePool(input *AssignTapePoolInput) (*AssignTapePoolOutput, error) {
	req, out := c.AssignTapePoolRequest(input)
	return out, req.Send()
}

// AssignTapePoolWithContext is the same as AssignTapePool with the addition of
// the ability to pass a context and additional request options.
//
// See AssignTapePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AssignTapePoolWithContext(ctx aws.Context, input *AssignTapePoolInput, opts ...request.Option) (*AssignTapePoolOutput, error) {
	req, out := c.AssignTapePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachVolume = "AttachVolume"

// AttachVolumeRequest generates a "aws/request.Request" representing the
// client's request for the AttachVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachVolume for more information on using the AttachVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachVolumeRequest method.
//    req, resp := client.AttachVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AttachVolume
func (c *StorageGateway) AttachVolumeRequest(input *AttachVolumeInput) (req *request.Request, output *AttachVolumeOutput) {
	op := &request.Operation{
		Name:       opAttachVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVolumeInput{}
	}

	output = &AttachVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachVolume API operation for AWS Storage Gateway.
//
// Connects a volume to an iSCSI connection and then attaches the volume to
// the specified gateway. Detaching and attaching a volume enables you to recover
// your data from one gateway to a different gateway without creating a snapshot.
// It also makes it easier to move your volumes from an on-premises gateway
// to a gateway hosted on an Amazon EC2 instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AttachVolume for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AttachVolume
func (c *StorageGateway) AttachVolume(input *AttachVolumeInput) (*AttachVolumeOutput, error) {
	req, out := c.AttachVolumeRequest(input)
	return out, req.Send()
}

// AttachVolumeWithContext is the same as AttachVolume with the addition of
// the ability to pass a context and additional request options.
//
// See AttachVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AttachVolumeWithContext(ctx aws.Context, input *AttachVolumeInput, opts ...request.Option) (*AttachVolumeOutput, error) {
	req, out := c.AttachVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelArchival = "CancelArchival"

// CancelArchivalRequest generates a "aws/request.Request" representing the
// client's request for the CancelArchival operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelArchival for more information on using the CancelArchival
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelArchivalRequest method.
//    req, resp := client.CancelArchivalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchival
func (c *StorageGateway) CancelArchivalRequest(input *CancelArchivalInput) (req *request.Request, output *CancelArchivalOutput) {
	op := &request.Operation{
		Name:       opCancelArchival,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelArchivalInput{}
	}

	output = &CancelArchivalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelArchival API operation for AWS Storage Gateway.
//
// Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after
// the archiving process is initiated. This operation is only supported in the
// tape gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CancelArchival for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchival
func (c *StorageGateway) CancelArchival(input *CancelArchivalInput) (*CancelArchivalOutput, error) {
	req, out := c.CancelArchivalRequest(input)
	return out, req.Send()
}

// CancelArchivalWithContext is the same as CancelArchival with the addition of
// the ability to pass a context and additional request options.
//
// See CancelArchival for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CancelArchivalWithContext(ctx aws.Context, input *CancelArchivalInput, opts ...request.Option) (*CancelArchivalOutput, error) {
	req, out := c.CancelArchivalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelRetrieval = "CancelRetrieval"

// CancelRetrievalRequest generates a "aws/request.Request" representing the
// client's request for the CancelRetrieval operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelRetrieval for more information on using the CancelRetrieval
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelRetrievalRequest method.
//    req, resp := client.CancelRetrievalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrieval
func (c *StorageGateway) CancelRetrievalRequest(input *CancelRetrievalInput) (req *request.Request, output *CancelRetrievalOutput) {
	op := &request.Operation{
		Name:       opCancelRetrieval,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelRetrievalInput{}
	}

	output = &CancelRetrievalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelRetrieval API operation for AWS Storage Gateway.
//
// Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
// a gateway after the retrieval process is initiated. The virtual tape is returned
// to the VTS. This operation is only supported in the tape gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CancelRetrieval for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrieval
func (c *StorageGateway) CancelRetrieval(input *CancelRetrievalInput) (*CancelRetrievalOutput, error) {
	req, out := c.CancelRetrievalRequest(input)
	return out, req.Send()
}

// CancelRetrievalWithContext is the same as CancelRetrieval with the addition of
// the ability to pass a context and additional request options.
//
// See CancelRetrieval for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CancelRetrievalWithContext(ctx aws.Context, input *CancelRetrievalInput, opts ...request.Option) (*CancelRetrievalOutput, error) {
	req, out := c.CancelRetrievalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCachediSCSIVolume = "CreateCachediSCSIVolume"

// CreateCachediSCSIVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateCachediSCSIVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCachediSCSIVolume for more information on using the CreateCachediSCSIVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCachediSCSIVolumeRequest method.
//    req, resp := client.CreateCachediSCSIVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolume
func (c *StorageGateway) CreateCachediSCSIVolumeRequest(input *CreateCachediSCSIVolumeInput) (req *request.Request, output *CreateCachediSCSIVolumeOutput) {
	op := &request.Operation{
		Name:       opCreateCachediSCSIVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCachediSCSIVolumeInput{}
	}

	output = &CreateCachediSCSIVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCachediSCSIVolume API operation for AWS Storage Gateway.
//
// Creates a cached volume on a specified cached volume gateway. This operation
// is only supported in the cached volume gateway type.
//
// Cache storage must be allocated to the gateway before you can create a cached
// volume. Use the AddCache operation to add cache storage to a gateway.
//
// In the request, you must specify the gateway, size of the volume in bytes,
// the iSCSI target name, an IP address on which to expose the target, and a
// unique client token. In response, the gateway creates the volume and returns
// information about it. This information includes the volume Amazon Resource
// Name (ARN), its size, and the iSCSI target ARN that initiators can use to
// connect to the volume target.
//
// Optionally, you can provide the ARN for an existing volume as the SourceVolumeARN
// for this cached volume, which creates an exact copy of the existing volume’s
// latest recovery point. The VolumeSizeInBytes value must be equal to or larger
// than the size of the copied volume, in bytes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateCachediSCSIVolume for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolume
func (c *StorageGateway) CreateCachediSCSIVolume(input *CreateCachediSCSIVolumeInput) (*CreateCachediSCSIVolumeOutput, error) {
	req, out := c.CreateCachediSCSIVolumeRequest(input)
	return out, req.Send()
}

// CreateCachediSCSIVolumeWithContext is the same as CreateCachediSCSIVolume with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCachediSCSIVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateCachediSCSIVolumeWithContext(ctx aws.Context, input *CreateCachediSCSIVolumeInput, opts ...request.Option) (*CreateCachediSCSIVolumeOutput, error) {
	req, out := c.CreateCachediSCSIVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNFSFileShare = "CreateNFSFileShare"

// CreateNFSFileShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateNFSFileShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNFSFileShare for more information on using the CreateNFSFileShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNFSFileShareRequest method.
//    req, resp := client.CreateNFSFileShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShare
func (c *StorageGateway) CreateNFSFileShareRequest(input *CreateNFSFileShareInput) (req *request.Request, output *CreateNFSFileShareOutput) {
	op := &request.Operation{
		Name:       opCreateNFSFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNFSFileShareInput{}
	}

	output = &CreateNFSFileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNFSFileShare API operation for AWS Storage Gateway.
//
// Creates a Network File System (NFS) file share on an existing file gateway.
// In Storage Gateway, a file share is a file system mount point backed by Amazon
// S3 cloud storage. Storage Gateway exposes file shares using an NFS interface.
// This operation is only supported for file gateways.
//
// File gateway requires AWS Security Token Service (AWS STS) to be activated
// to enable you to create a file share. Make sure AWS STS is activated in the
// AWS Region you are creating your file gateway in. If AWS STS is not activated
// in the AWS Region, activate it. For information about how to activate AWS
// STS, see Activating and deactivating AWS STS in an AWS Region (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
// in the AWS Identity and Access Management User Guide.
//
// File gateway does not support creating hard or symbolic links on a file share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateNFSFileShare for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShare
func (c *StorageGateway) CreateNFSFileShare(input *CreateNFSFileShareInput) (*CreateNFSFileShareOutput, error) {
	req, out := c.CreateNFSFileShareRequest(input)
	return out, req.Send()
}

// CreateNFSFileShareWithContext is the same as CreateNFSFileShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNFSFileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateNFSFileShareWithContext(ctx aws.Context, input *CreateNFSFileShareInput, opts ...request.Option) (*CreateNFSFileShareOutput, error) {
	req, out := c.CreateNFSFileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSMBFileShare = "CreateSMBFileShare"

// CreateSMBFileShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateSMBFileShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSMBFileShare for more information on using the CreateSMBFileShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSMBFileShareRequest method.
//    req, resp := client.CreateSMBFileShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSMBFileShare
func (c *StorageGateway) CreateSMBFileShareRequest(input *CreateSMBFileShareInput) (req *request.Request, output *CreateSMBFileShareOutput) {
	op := &request.Operation{
		Name:       opCreateSMBFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSMBFileShareInput{}
	}

	output = &CreateSMBFileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSMBFileShare API operation for AWS Storage Gateway.
//
// Creates a Server Message Block (SMB) file share on an existing file gateway.
// In Storage Gateway, a file share is a file system mount point backed by Amazon
// S3 cloud storage. Storage Gateway exposes file shares using an SMB interface.
// This operation is only supported for file gateways.
//
// File gateways require AWS Security Token Service (AWS STS) to be activated
// to enable you to create a file share. Make sure that AWS STS is activated
// in the AWS Region you are creating your file gateway in. If AWS STS is not
// activated in this AWS Region, activate it. For information about how to activate
// AWS STS, see Activating and deactivating AWS STS in an AWS Region (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
// in the AWS Identity and Access Management User Guide.
//
// File gateways don't support creating hard or symbolic links on a file share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateSMBFileShare for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSMBFileShare
func (c *StorageGateway) CreateSMBFileShare(input *CreateSMBFileShareInput) (*CreateSMBFileShareOutput, error) {
	req, out := c.CreateSMBFileShareRequest(input)
	return out, req.Send()
}

// CreateSMBFileShareWithContext is the same as CreateSMBFileShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSMBFileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateSMBFileShareWithContext(ctx aws.Context, input *CreateSMBFileShareInput, opts ...request.Option) (*CreateSMBFileShareOutput, error) {
	req, out := c.CreateSMBFileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSnapshotRequest method.
//    req, resp := client.CreateSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshot
func (c *StorageGateway) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &CreateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for AWS Storage Gateway.
//
// Initiates a snapshot of a volume.
//
// AWS Storage Gateway provides the ability to back up point-in-time snapshots
// of your data to Amazon Simple Storage (Amazon S3) for durable off-site recovery,
// as well as import the data to an Amazon Elastic Block Store (EBS) volume
// in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway
// volume on a scheduled or ad hoc basis. This API enables you to take an ad
// hoc snapshot. For more information, see Editing a snapshot schedule (https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot).
//
// In the CreateSnapshot request, you identify the volume by providing its Amazon
// Resource Name (ARN). You must also provide description for the snapshot.
// When AWS Storage Gateway takes the snapshot of specified volume, the snapshot
// and description appears in the AWS Storage Gateway console. In response,
// AWS Storage Gateway returns you a snapshot ID. You can use this snapshot
// ID to check the snapshot progress or later use it when you want to create
// a volume from a snapshot. This operation is only supported in stored and
// cached volume gateway type.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
// see DescribeSnapshots (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html)
// or DeleteSnapshot (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html)
// in the Amazon Elastic Compute Cloud API Reference.
//
// Volume and snapshot IDs are changing to a longer length ID format. For more
// information, see the important note on the Welcome (https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html)
// page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
//   * ServiceUnavailableError
//   An internal server error has occurred because the service is unavailable.
//   For more information, see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshot
func (c *StorageGateway) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshotFromVolumeRecoveryPoint = "CreateSnapshotFromVolumeRecoveryPoint"

// CreateSnapshotFromVolumeRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshotFromVolumeRecoveryPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshotFromVolumeRecoveryPoint for more information on using the CreateSnapshotFromVolumeRecoveryPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSnapshotFromVolumeRecoveryPointRequest method.
//    req, resp := client.CreateSnapshotFromVolumeRecoveryPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPoint
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPointRequest(input *CreateSnapshotFromVolumeRecoveryPointInput) (req *request.Request, output *CreateSnapshotFromVolumeRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshotFromVolumeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotFromVolumeRecoveryPointInput{}
	}

	output = &CreateSnapshotFromVolumeRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshotFromVolumeRecoveryPoint API operation for AWS Storage Gateway.
//
// Initiates a snapshot of a gateway from a volume recovery point. This operation
// is only supported in the cached volume gateway type.
//
// A volume recovery point is a point in time at which all data of the volume
// is consistent and from which you can create a snapshot. To get a list of
// volume recovery point for cached volume gateway, use ListVolumeRecoveryPoints.
//
// In the CreateSnapshotFromVolumeRecoveryPoint request, you identify the volume
// by providing its Amazon Resource Name (ARN). You must also provide a description
// for the snapshot. When the gateway takes a snapshot of the specified volume,
// the snapshot and its description appear in the AWS Storage Gateway console.
// In response, the gateway returns you a snapshot ID. You can use this snapshot
// ID to check the snapshot progress or later use it when you want to create
// a volume from a snapshot.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
// see DescribeSnapshots (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html)
// or DeleteSnapshot (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html)
// in the Amazon Elastic Compute Cloud API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateSnapshotFromVolumeRecoveryPoint for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
//   * ServiceUnavailableError
//   An internal server error has occurred because the service is unavailable.
//   For more information, see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPoint
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPoint(input *CreateSnapshotFromVolumeRecoveryPointInput) (*CreateSnapshotFromVolumeRecoveryPointOutput, error) {
	req, out := c.CreateSnapshotFromVolumeRecoveryPointRequest(input)
	return out, req.Send()
}

// CreateSnapshotFromVolumeRecoveryPointWithContext is the same as CreateSnapshotFromVolumeRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshotFromVolumeRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPointWithContext(ctx aws.Context, input *CreateSnapshotFromVolumeRecoveryPointInput, opts ...request.Option) (*CreateSnapshotFromVolumeRecoveryPointOutput, error) {
	req, out := c.CreateSnapshotFromVolumeRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStorediSCSIVolume = "CreateStorediSCSIVolume"

// CreateStorediSCSIVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateStorediSCSIVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStorediSCSIVolume for more information on using the CreateStorediSCSIVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStorediSCSIVolumeRequest method.
//    req, resp := client.CreateStorediSCSIVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolume
func (c *StorageGateway) CreateStorediSCSIVolumeRequest(input *CreateStorediSCSIVolumeInput) (req *request.Request, output *CreateStorediSCSIVolumeOutput) {
	op := &request.Operation{
		Name:       opCreateStorediSCSIVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStorediSCSIVolumeInput{}
	}

	output = &CreateStorediSCSIVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStorediSCSIVolume API operation for AWS Storage Gateway.
//
// Creates a volume on a specified gateway. This operation is only supported
// in the stored volume gateway type.
//
// The size of the volume to create is inferred from the disk size. You can
// choose to preserve existing data on the disk, create volume from an existing
// snapshot, or create an empty volume. If you choose to create an empty gateway
// volume, then any existing data on the disk is erased.
//
// In the request, you must specify the gateway and the disk information on
// which you are creating the volume. In response, the gateway creates the volume
// and returns volume information such as the volume Amazon Resource Name (ARN),
// its size, and the iSCSI target ARN that initiators can use to connect to
// the volume target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateStorediSCSIVolume for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolume
func (c *StorageGateway) CreateStorediSCSIVolume(input *CreateStorediSCSIVolumeInput) (*CreateStorediSCSIVolumeOutput, error) {
	req, out := c.CreateStorediSCSIVolumeRequest(input)
	return out, req.Send()
}

// CreateStorediSCSIVolumeWithContext is the same as CreateStorediSCSIVolume with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStorediSCSIVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateStorediSCSIVolumeWithContext(ctx aws.Context, input *CreateStorediSCSIVolumeInput, opts ...request.Option) (*CreateStorediSCSIVolumeOutput, error) {
	req, out := c.CreateStorediSCSIVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTapePool = "CreateTapePool"

// CreateTapePoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateTapePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTapePool for more information on using the CreateTapePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTapePoolRequest method.
//    req, resp := client.CreateTapePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapePool
func (c *StorageGateway) CreateTapePoolRequest(input *CreateTapePoolInput) (req *request.Request, output *CreateTapePoolOutput) {
	op := &request.Operation{
		Name:       opCreateTapePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapePoolInput{}
	}

	output = &CreateTapePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTapePool API operation for AWS Storage Gateway.
//
// Creates a new custom tape pool. You can use custom tape pool to enable tape
// retention lock on tapes that are archived in the custom pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateTapePool for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapePool
func (c *StorageGateway) CreateTapePool(input *CreateTapePoolInput) (*CreateTapePoolOutput, error) {
	req, out := c.CreateTapePoolRequest(input)
	return out, req.Send()
}

// CreateTapePoolWithContext is the same as CreateTapePool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTapePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateTapePoolWithContext(ctx aws.Context, input *CreateTapePoolInput, opts ...request.Option) (*CreateTapePoolOutput, error) {
	req, out := c.CreateTapePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTapeWithBarcode = "CreateTapeWithBarcode"

// CreateTapeWithBarcodeRequest generates a "aws/request.Request" representing the
// client's request for the CreateTapeWithBarcode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTapeWithBarcode for more information on using the CreateTapeWithBarcode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTapeWithBarcodeRequest method.
//    req, resp := client.CreateTapeWithBarcodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcode
func (c *StorageGateway) CreateTapeWithBarcodeRequest(input *CreateTapeWithBarcodeInput) (req *request.Request, output *CreateTapeWithBarcodeOutput) {
	op := &request.Operation{
		Name:       opCreateTapeWithBarcode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapeWithBarcodeInput{}
	}

	output = &CreateTapeWithBarcodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTapeWithBarcode API operation for AWS Storage Gateway.
//
// Creates a virtual tape by using your own barcode. You write data to the virtual
// tape and then archive the tape. A barcode is unique and cannot be reused
// if it has already been used on a tape. This applies to barcodes used on deleted
// tapes. This operation is only supported in the tape gateway type.
//
// Cache storage must be allocated to the gateway before you can create a virtual
// tape. Use the AddCache operation to add cache storage to a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateTapeWithBarcode for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcode
func (c *StorageGateway) CreateTapeWithBarcode(input *CreateTapeWithBarcodeInput) (*CreateTapeWithBarcodeOutput, error) {
	req, out := c.CreateTapeWithBarcodeRequest(input)
	return out, req.Send()
}

// CreateTapeWithBarcodeWithContext is the same as CreateTapeWithBarcode with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTapeWithBarcode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateTapeWithBarcodeWithContext(ctx aws.Context, input *CreateTapeWithBarcodeInput, opts ...request.Option) (*CreateTapeWithBarcodeOutput, error) {
	req, out := c.CreateTapeWithBarcodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTapes = "CreateTapes"

// CreateTapesRequest generates a "aws/request.Request" representing the
// client's request for the CreateTapes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTapes for more information on using the CreateTapes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTapesRequest method.
//    req, resp := client.CreateTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapes
func (c *StorageGateway) CreateTapesRequest(input *CreateTapesInput) (req *request.Request, output *CreateTapesOutput) {
	op := &request.Operation{
		Name:       opCreateTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapesInput{}
	}

	output = &CreateTapesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTapes API operation for AWS Storage Gateway.
//
// Creates one or more virtual tapes. You write data to the virtual tapes and
// then archive the tapes. This operation is only supported in the tape gateway
// type.
//
// Cache storage must be allocated to the gateway before you can create virtual
// tapes. Use the AddCache operation to add cache storage to a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateTapes for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapes
func (c *StorageGateway) CreateTapes(input *CreateTapesInput) (*CreateTapesOutput, error) {
	req, out := c.CreateTapesRequest(input)
	return out, req.Send()
}

// CreateTapesWithContext is the same as CreateTapes with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTapes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateTapesWithContext(ctx aws.Context, input *CreateTapesInput, opts ...request.Option) (*CreateTapesOutput, error) {
	req, out := c.CreateTapesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAutomaticTapeCreationPolicy = "DeleteAutomaticTapeCreationPolicy"

// DeleteAutomaticTapeCreationPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAutomaticTapeCreationPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAutomaticTapeCreationPolicy for more information on using the DeleteAutomaticTapeCreationPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAutomaticTapeCreationPolicyRequest method.
//    req, resp := client.DeleteAutomaticTapeCreationPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteAutomaticTapeCreationPolicy
func (c *StorageGateway) DeleteAutomaticTapeCreationPolicyRequest(input *DeleteAutomaticTapeCreationPolicyInput) (req *request.Request, output *DeleteAutomaticTapeCreationPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAutomaticTapeCreationPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutomaticTapeCreationPolicyInput{}
	}

	output = &DeleteAutomaticTapeCreationPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAutomaticTapeCreationPolicy API operation for AWS Storage Gateway.
//
// Deletes the automatic tape creation policy of a gateway. If you delete this
// policy, new virtual tapes must be created manually. Use the Amazon Resource
// Name (ARN) of the gateway in your request to remove the policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteAutomaticTapeCreationPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteAutomaticTapeCreationPolicy
func (c *StorageGateway) DeleteAutomaticTapeCreationPolicy(input *DeleteAutomaticTapeCreationPolicyInput) (*DeleteAutomaticTapeCreationPolicyOutput, error) {
	req, out := c.DeleteAutomaticTapeCreationPolicyRequest(input)
	return out, req.Send()
}

// DeleteAutomaticTapeCreationPolicyWithContext is the same as DeleteAutomaticTapeCreationPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAutomaticTapeCreationPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteAutomaticTapeCreationPolicyWithContext(ctx aws.Context, input *DeleteAutomaticTapeCreationPolicyInput, opts ...request.Option) (*DeleteAutomaticTapeCreationPolicyOutput, error) {
	req, out := c.DeleteAutomaticTapeCreationPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBandwidthRateLimit = "DeleteBandwidthRateLimit"

// DeleteBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBandwidthRateLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBandwidthRateLimit for more information on using the DeleteBandwidthRateLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBandwidthRateLimitRequest method.
//    req, resp := client.DeleteBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimit
func (c *StorageGateway) DeleteBandwidthRateLimitRequest(input *DeleteBandwidthRateLimitInput) (req *request.Request, output *DeleteBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opDeleteBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBandwidthRateLimitInput{}
	}

	output = &DeleteBandwidthRateLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Deletes the bandwidth rate limits of a gateway. You can delete either the
// upload and download bandwidth rate limit, or you can delete both. If you
// delete only one of the limits, the other limit remains unchanged. To specify
// which gateway to work with, use the Amazon Resource Name (ARN) of the gateway
// in your request. This operation is supported for the stored volume, cached
// volume and tape gateway types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteBandwidthRateLimit for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimit
func (c *StorageGateway) DeleteBandwidthRateLimit(input *DeleteBandwidthRateLimitInput) (*DeleteBandwidthRateLimitOutput, error) {
	req, out := c.DeleteBandwidthRateLimitRequest(input)
	return out, req.Send()
}

// DeleteBandwidthRateLimitWithContext is the same as DeleteBandwidthRateLimit with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBandwidthRateLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteBandwidthRateLimitWithContext(ctx aws.Context, input *DeleteBandwidthRateLimitInput, opts ...request.Option) (*DeleteBandwidthRateLimitOutput, error) {
	req, out := c.DeleteBandwidthRateLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChapCredentials = "DeleteChapCredentials"

// DeleteChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChapCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChapCredentials for more information on using the DeleteChapCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChapCredentialsRequest method.
//    req, resp := client.DeleteChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentials
func (c *StorageGateway) DeleteChapCredentialsRequest(input *DeleteChapCredentialsInput) (req *request.Request, output *DeleteChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opDeleteChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChapCredentialsInput{}
	}

	output = &DeleteChapCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteChapCredentials API operation for AWS Storage Gateway.
//
// Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for
// a specified iSCSI target and initiator pair. This operation is supported
// in volume and tape gateway types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteChapCredentials for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentials
func (c *StorageGateway) DeleteChapCredentials(input *DeleteChapCredentialsInput) (*DeleteChapCredentialsOutput, error) {
	req, out := c.DeleteChapCredentialsRequest(input)
	return out, req.Send()
}

// DeleteChapCredentialsWithContext is the same as DeleteChapCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChapCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteChapCredentialsWithContext(ctx aws.Context, input *DeleteChapCredentialsInput, opts ...request.Option) (*DeleteChapCredentialsOutput, error) {
	req, out := c.DeleteChapCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFileShare = "DeleteFileShare"

// DeleteFileShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFileShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFileShare for more information on using the DeleteFileShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFileShareRequest method.
//    req, resp := client.DeleteFileShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShare
func (c *StorageGateway) DeleteFileShareRequest(input *DeleteFileShareInput) (req *request.Request, output *DeleteFileShareOutput) {
	op := &request.Operation{
		Name:       opDeleteFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFileShareInput{}
	}

	output = &DeleteFileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFileShare API operation for AWS Storage Gateway.
//
// Deletes a file share from a file gateway. This operation is only supported
// for file gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteFileShare for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShare
func (c *StorageGateway) DeleteFileShare(input *DeleteFileShareInput) (*DeleteFileShareOutput, error) {
	req, out := c.DeleteFileShareRequest(input)
	return out, req.Send()
}

// DeleteFileShareWithContext is the same as DeleteFileShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteFileShareWithContext(ctx aws.Context, input *DeleteFileShareInput, opts ...request.Option) (*DeleteFileShareOutput, error) {
	req, out := c.DeleteFileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGateway = "DeleteGateway"

// DeleteGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGateway for more information on using the DeleteGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGatewayRequest method.
//    req, resp := client.DeleteGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGateway
func (c *StorageGateway) DeleteGatewayRequest(input *DeleteGatewayInput) (req *request.Request, output *DeleteGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGatewayInput{}
	}

	output = &DeleteGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGateway API operation for AWS Storage Gateway.
//
// Deletes a gateway. To specify which gateway to delete, use the Amazon Resource
// Name (ARN) of the gateway in your request. The operation deletes the gateway;
// however, it does not delete the gateway virtual machine (VM) from your host
// computer.
//
// After you delete a gateway, you cannot reactivate it. Completed snapshots
// of the gateway volumes are not deleted upon deleting the gateway, however,
// pending snapshots will not complete. After you delete a gateway, your next
// step is to remove it from your environment.
//
// You no longer pay software charges after the gateway is deleted; however,
// your existing Amazon EBS snapshots persist and you will continue to be billed
// for these snapshots. You can choose to remove all remaining Amazon EBS snapshots
// by canceling your Amazon EC2 subscription. If you prefer not to cancel your
// Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2
// console. For more information, see the AWS Storage Gateway detail page (http://aws.amazon.com/storagegateway).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGateway
func (c *StorageGateway) DeleteGateway(input *DeleteGatewayInput) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	return out, req.Send()
}

// DeleteGatewayWithContext is the same as DeleteGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteGatewayWithContext(ctx aws.Context, input *DeleteGatewayInput, opts ...request.Option) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshotSchedule = "DeleteSnapshotSchedule"

// DeleteSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshotSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshotSchedule for more information on using the DeleteSnapshotSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSnapshotScheduleRequest method.
//    req, resp := client.DeleteSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotSchedule
func (c *StorageGateway) DeleteSnapshotScheduleRequest(input *DeleteSnapshotScheduleInput) (req *request.Request, output *DeleteSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotScheduleInput{}
	}

	output = &DeleteSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSnapshotSchedule API operation for AWS Storage Gateway.
//
// Deletes a snapshot of a volume.
//
// You can take snapshots of your gateway volumes on a scheduled or ad hoc basis.
// This API action enables you to delete a snapshot schedule for a volume. For
// more information, see Backing up your volumes (https://docs.aws.amazon.com/storagegateway/latest/userguide/backing-up-volumes.html).
// In the DeleteSnapshotSchedule request, you identify the volume by providing
// its Amazon Resource Name (ARN). This operation is only supported in stored
// and cached volume gateway types.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
// go to DescribeSnapshots (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html)
// in the Amazon Elastic Compute Cloud API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteSnapshotSchedule for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotSchedule
func (c *StorageGateway) DeleteSnapshotSchedule(input *DeleteSnapshotScheduleInput) (*DeleteSnapshotScheduleOutput, error) {
	req, out := c.DeleteSnapshotScheduleRequest(input)
	return out, req.Send()
}

// DeleteSnapshotScheduleWithContext is the same as DeleteSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteSnapshotScheduleWithContext(ctx aws.Context, input *DeleteSnapshotScheduleInput, opts ...request.Option) (*DeleteSnapshotScheduleOutput, error) {
	req, out := c.DeleteSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTape = "DeleteTape"

// DeleteTapeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTape operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTape for more information on using the DeleteTape
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTapeRequest method.
//    req, resp := client.DeleteTapeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTape
func (c *StorageGateway) DeleteTapeRequest(input *DeleteTapeInput) (req *request.Request, output *DeleteTapeOutput) {
	op := &request.Operation{
		Name:       opDeleteTape,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapeInput{}
	}

	output = &DeleteTapeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTape API operation for AWS Storage Gateway.
//
// Deletes the specified virtual tape. This operation is only supported in the
// tape gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteTape for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTape
func (c *StorageGateway) DeleteTape(input *DeleteTapeInput) (*DeleteTapeOutput, error) {
	req, out := c.DeleteTapeRequest(input)
	return out, req.Send()
}

// DeleteTapeWithContext is the same as DeleteTape with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTape for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteTapeWithContext(ctx aws.Context, input *DeleteTapeInput, opts ...request.Option) (*DeleteTapeOutput, error) {
	req, out := c.DeleteTapeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTapeArchive = "DeleteTapeArchive"

// DeleteTapeArchiveRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTapeArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTapeArchive for more information on using the DeleteTapeArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTapeArchiveRequest method.
//    req, resp := client.DeleteTapeArchiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchive
func (c *StorageGateway) DeleteTapeArchiveRequest(input *DeleteTapeArchiveInput) (req *request.Request, output *DeleteTapeArchiveOutput) {
	op := &request.Operation{
		Name:       opDeleteTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapeArchiveInput{}
	}

	output = &DeleteTapeArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTapeArchive API operation for AWS Storage Gateway.
//
// Deletes the specified virtual tape from the virtual tape shelf (VTS). This
// operation is only supported in the tape gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteTapeArchive for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchive
func (c *StorageGateway) DeleteTapeArchive(input *DeleteTapeArchiveInput) (*DeleteTapeArchiveOutput, error) {
	req, out := c.DeleteTapeArchiveRequest(input)
	return out, req.Send()
}

// DeleteTapeArchiveWithContext is the same as DeleteTapeArchive with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTapeArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteTapeArchiveWithContext(ctx aws.Context, input *DeleteTapeArchiveInput, opts ...request.Option) (*DeleteTapeArchiveOutput, error) {
	req, out := c.DeleteTapeArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTapePool = "DeleteTapePool"

// DeleteTapePoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTapePool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTapePool for more information on using the DeleteTapePool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTapePoolRequest method.
//    req, resp := client.DeleteTapePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapePool
func (c *StorageGateway) DeleteTapePoolRequest(input *DeleteTapePoolInput) (req *request.Request, output *DeleteTapePoolOutput) {
	op := &request.Operation{
		Name:       opDeleteTapePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapePoolInput{}
	}

	output = &DeleteTapePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTapePool API operation for AWS Storage Gateway.
//
// Delete a custom tape pool. A custom tape pool can only be deleted if there
// are no tapes in the pool and if there are no automatic tape creation policies
// that reference the custom tape pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteTapePool for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapePool
func (c *StorageGateway) DeleteTapePool(input *DeleteTapePoolInput) (*DeleteTapePoolOutput, error) {
	req, out := c.DeleteTapePoolRequest(input)
	return out, req.Send()
}

// DeleteTapePoolWithContext is the same as DeleteTapePool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTapePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteTapePoolWithContext(ctx aws.Context, input *DeleteTapePoolInput, opts ...request.Option) (*DeleteTapePoolOutput, error) {
	req, out := c.DeleteTapePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVolume for more information on using the DeleteVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVolumeRequest method.
//    req, resp := client.DeleteVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolume
func (c *StorageGateway) DeleteVolumeRequest(input *DeleteVolumeInput) (req *request.Request, output *DeleteVolumeOutput) {
	op := &request.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	output = &DeleteVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVolume API operation for AWS Storage Gateway.
//
// Deletes the specified storage volume that you previously created using the
// CreateCachediSCSIVolume or CreateStorediSCSIVolume API. This operation is
// only supported in the cached volume and stored volume types. For stored volume
// gateways, the local disk that was configured as the storage volume is not
// deleted. You can reuse the local disk to create another storage volume.
//
// Before you delete a volume, make sure there are no iSCSI connections to the
// volume you are deleting. You should also make sure there is no snapshot in
// progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to
// query snapshots on the volume you are deleting and check the snapshot status.
// For more information, go to DescribeSnapshots (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
// in the Amazon Elastic Compute Cloud API Reference.
//
// In the request, you must provide the Amazon Resource Name (ARN) of the storage
// volume you want to delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteVolume for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolume
func (c *StorageGateway) DeleteVolume(input *DeleteVolumeInput) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	return out, req.Send()
}

// DeleteVolumeWithContext is the same as DeleteVolume with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteVolumeWithContext(ctx aws.Context, input *DeleteVolumeInput, opts ...request.Option) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAvailabilityMonitorTest = "DescribeAvailabilityMonitorTest"

// DescribeAvailabilityMonitorTestRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAvailabilityMonitorTest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAvailabilityMonitorTest for more information on using the DescribeAvailabilityMonitorTest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAvailabilityMonitorTestRequest method.
//    req, resp := client.DescribeAvailabilityMonitorTestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeAvailabilityMonitorTest
func (c *StorageGateway) DescribeAvailabilityMonitorTestRequest(input *DescribeAvailabilityMonitorTestInput) (req *request.Request, output *DescribeAvailabilityMonitorTestOutput) {
	op := &request.Operation{
		Name:       opDescribeAvailabilityMonitorTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityMonitorTestInput{}
	}

	output = &DescribeAvailabilityMonitorTestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAvailabilityMonitorTest API operation for AWS Storage Gateway.
//
// Returns information about the most recent High Availability monitoring test
// that was performed on the host in a cluster. If a test isn't performed, the
// status and start time in the response would be null.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeAvailabilityMonitorTest for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeAvailabilityMonitorTest
func (c *StorageGateway) DescribeAvailabilityMonitorTest(input *DescribeAvailabilityMonitorTestInput) (*DescribeAvailabilityMonitorTestOutput, error) {
	req, out := c.DescribeAvailabilityMonitorTestRequest(input)
	return out, req.Send()
}

// DescribeAvailabilityMonitorTestWithContext is the same as DescribeAvailabilityMonitorTest with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAvailabilityMonitorTest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeAvailabilityMonitorTestWithContext(ctx aws.Context, input *DescribeAvailabilityMonitorTestInput, opts ...request.Option) (*DescribeAvailabilityMonitorTestOutput, error) {
	req, out := c.DescribeAvailabilityMonitorTestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBandwidthRateLimit = "DescribeBandwidthRateLimit"

// DescribeBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBandwidthRateLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBandwidthRateLimit for more information on using the DescribeBandwidthRateLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBandwidthRateLimitRequest method.
//    req, resp := client.DescribeBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimit
func (c *StorageGateway) DescribeBandwidthRateLimitRequest(input *DescribeBandwidthRateLimitInput) (req *request.Request, output *DescribeBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opDescribeBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBandwidthRateLimitInput{}
	}

	output = &DescribeBandwidthRateLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Returns the bandwidth rate limits of a gateway. By default, these limits
// are not set, which means no bandwidth rate limiting is in effect. This operation
// is supported for the stored volume, cached volume, and tape gateway types.
//
// This operation only returns a value for a bandwidth rate limit only if the
// limit is set. If no limits are set for the gateway, then this operation returns
// only the gateway ARN in the response body. To specify which gateway to describe,
// use the Amazon Resource Name (ARN) of the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeBandwidthRateLimit for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimit
func (c *StorageGateway) DescribeBandwidthRateLimit(input *DescribeBandwidthRateLimitInput) (*DescribeBandwidthRateLimitOutput, error) {
	req, out := c.DescribeBandwidthRateLimitRequest(input)
	return out, req.Send()
}

// DescribeBandwidthRateLimitWithContext is the same as DescribeBandwidthRateLimit with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBandwidthRateLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeBandwidthRateLimitWithContext(ctx aws.Context, input *DescribeBandwidthRateLimitInput, opts ...request.Option) (*DescribeBandwidthRateLimitOutput, error) {
	req, out := c.DescribeBandwidthRateLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBandwidthRateLimitSchedule = "DescribeBandwidthRateLimitSchedule"

// DescribeBandwidthRateLimitScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBandwidthRateLimitSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBandwidthRateLimitSchedule for more information on using the DescribeBandwidthRateLimitSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBandwidthRateLimitScheduleRequest method.
//    req, resp := client.DescribeBandwidthRateLimitScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimitSchedule
func (c *StorageGateway) DescribeBandwidthRateLimitScheduleRequest(input *DescribeBandwidthRateLimitScheduleInput) (req *request.Request, output *DescribeBandwidthRateLimitScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeBandwidthRateLimitSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBandwidthRateLimitScheduleInput{}
	}

	output = &DescribeBandwidthRateLimitScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBandwidthRateLimitSchedule API operation for AWS Storage Gateway.
//
// Returns information about the bandwidth rate limit schedule of a gateway.
// By default, gateways do not have bandwidth rate limit schedules, which means
// no bandwidth rate limiting is in effect. This operation is supported only
// in the volume and tape gateway types.
//
// This operation returns information about a gateway's bandwidth rate limit
// schedule. A bandwidth rate limit schedule consists of one or more bandwidth
// rate limit intervals. A bandwidth rate limit interval defines a period of
// time on one or more days of the week, during which bandwidth rate limits
// are specified for uploading, downloading, or both.
//
// A bandwidth rate limit interval consists of one or more days of the week,
// a start hour and minute, an ending hour and minute, and bandwidth rate limits
// for uploading and downloading
//
// If no bandwidth rate limit schedule intervals are set for the gateway, this
// operation returns an empty response. To specify which gateway to describe,
// use the Amazon Resource Name (ARN) of the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeBandwidthRateLimitSchedule for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimitSchedule
func (c *StorageGateway) DescribeBandwidthRateLimitSchedule(input *DescribeBandwidthRateLimitScheduleInput) (*DescribeBandwidthRateLimitScheduleOutput, error) {
	req, out := c.DescribeBandwidthRateLimitScheduleRequest(input)
	return out, req.Send()
}

// DescribeBandwidthRateLimitScheduleWithContext is the same as DescribeBandwidthRateLimitSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBandwidthRateLimitSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeBandwidthRateLimitScheduleWithContext(ctx aws.Context, input *DescribeBandwidthRateLimitScheduleInput, opts ...request.Option) (*DescribeBandwidthRateLimitScheduleOutput, error) {
	req, out := c.DescribeBandwidthRateLimitScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCache = "DescribeCache"

// DescribeCacheRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCache operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCache for more information on using the DescribeCache
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCacheRequest method.
//    req, resp := client.DescribeCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCache
func (c *StorageGateway) DescribeCacheRequest(input *DescribeCacheInput) (req *request.Request, output *DescribeCacheOutput) {
	op := &request.Operation{
		Name:       opDescribeCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCacheInput{}
	}

	output = &DescribeCacheOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCache API operation for AWS Storage Gateway.
//
// Returns information about the cache of a gateway. This operation is only
// supported in the cached volume, tape, and file gateway types.
//
// The response includes disk IDs that are configured as cache, and it includes
// the amount of cache allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeCache for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCache
func (c *StorageGateway) DescribeCache(input *DescribeCacheInput) (*DescribeCacheOutput, error) {
	req, out := c.DescribeCacheRequest(input)
	return out, req.Send()
}

// DescribeCacheWithContext is the same as DescribeCache with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeCacheWithContext(ctx aws.Context, input *DescribeCacheInput, opts ...request.Option) (*DescribeCacheOutput, error) {
	req, out := c.DescribeCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCachediSCSIVolumes = "DescribeCachediSCSIVolumes"

// DescribeCachediSCSIVolumesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCachediSCSIVolumes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCachediSCSIVolumes for more information on using the DescribeCachediSCSIVolumes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCachediSCSIVolumesRequest method.
//    req, resp := client.DescribeCachediSCSIVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumes
func (c *StorageGateway) DescribeCachediSCSIVolumesRequest(input *DescribeCachediSCSIVolumesInput) (req *request.Request, output *DescribeCachediSCSIVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeCachediSCSIVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCachediSCSIVolumesInput{}
	}

	output = &DescribeCachediSCSIVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCachediSCSIVolumes API operation for AWS Storage Gateway.
//
// Returns a description of the gateway volumes specified in the request. This
// operation is only supported in the cached volume gateway types.
//
// The list of gateway volumes in the request must be from one gateway. In the
// response, AWS Storage Gateway returns volume information sorted by volume
// Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeCachediSCSIVolumes for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumes
func (c *StorageGateway) DescribeCachediSCSIVolumes(input *DescribeCachediSCSIVolumesInput) (*DescribeCachediSCSIVolumesOutput, error) {
	req, out := c.DescribeCachediSCSIVolumesRequest(input)
	return out, req.Send()
}

// DescribeCachediSCSIVolumesWithContext is the same as DescribeCachediSCSIVolumes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCachediSCSIVolumes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeCachediSCSIVolumesWithContext(ctx aws.Context, input *DescribeCachediSCSIVolumesInput, opts ...request.Option) (*DescribeCachediSCSIVolumesOutput, error) {
	req, out := c.DescribeCachediSCSIVolumesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChapCredentials = "DescribeChapCredentials"

// DescribeChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChapCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChapCredentials for more information on using the DescribeChapCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChapCredentialsRequest method.
//    req, resp := client.DescribeChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentials
func (c *StorageGateway) DescribeChapCredentialsRequest(input *DescribeChapCredentialsInput) (req *request.Request, output *DescribeChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opDescribeChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChapCredentialsInput{}
	}

	output = &DescribeChapCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChapCredentials API operation for AWS Storage Gateway.
//
// Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials
// information for a specified iSCSI target, one for each target-initiator pair.
// This operation is supported in the volume and tape gateway types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeChapCredentials for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentials
func (c *StorageGateway) DescribeChapCredentials(input *DescribeChapCredentialsInput) (*DescribeChapCredentialsOutput, error) {
	req, out := c.DescribeChapCredentialsRequest(input)
	return out, req.Send()
}

// DescribeChapCredentialsWithContext is the same as DescribeChapCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChapCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeChapCredentialsWithContext(ctx aws.Context, input *DescribeChapCredentialsInput, opts ...request.Option) (*DescribeChapCredentialsOutput, error) {
	req, out := c.DescribeChapCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGatewayInformation = "DescribeGatewayInformation"

// DescribeGatewayInformationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGatewayInformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGatewayInformation for more information on using the DescribeGatewayInformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGatewayInformationRequest method.
//    req, resp := client.DescribeGatewayInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformation
func (c *StorageGateway) DescribeGatewayInformationRequest(input *DescribeGatewayInformationInput) (req *request.Request, output *DescribeGatewayInformationOutput) {
	op := &request.Operation{
		Name:       opDescribeGatewayInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGatewayInformationInput{}
	}

	output = &DescribeGatewayInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGatewayInformation API operation for AWS Storage Gateway.
//
// Returns metadata about a gateway such as its name, network interfaces, configured
// time zone, and the state (whether the gateway is running or not). To specify
// which gateway to describe, use the Amazon Resource Name (ARN) of the gateway
// in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeGatewayInformation for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformation
func (c *StorageGateway) DescribeGatewayInformation(input *DescribeGatewayInformationInput) (*DescribeGatewayInformationOutput, error) {
	req, out := c.DescribeGatewayInformationRequest(input)
	return out, req.Send()
}

// DescribeGatewayInformationWithContext is the same as DescribeGatewayInformation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGatewayInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeGatewayInformationWithContext(ctx aws.Context, input *DescribeGatewayInformationInput, opts ...request.Option) (*DescribeGatewayInformationOutput, error) {
	req, out := c.DescribeGatewayInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceStartTime = "DescribeMaintenanceStartTime"

// DescribeMaintenanceStartTimeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceStartTime operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceStartTime for more information on using the DescribeMaintenanceStartTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceStartTimeRequest method.
//    req, resp := client.DescribeMaintenanceStartTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTime
func (c *StorageGateway) DescribeMaintenanceStartTimeRequest(input *DescribeMaintenanceStartTimeInput) (req *request.Request, output *DescribeMaintenanceStartTimeOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceStartTimeInput{}
	}

	output = &DescribeMaintenanceStartTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceStartTime API operation for AWS Storage Gateway.
//
// Returns your gateway's weekly maintenance start time including the day and
// time of the week. Note that values are in terms of the gateway's time zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeMaintenanceStartTime for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTime
func (c *StorageGateway) DescribeMaintenanceStartTime(input *DescribeMaintenanceStartTimeInput) (*DescribeMaintenanceStartTimeOutput, error) {
	req, out := c.DescribeMaintenanceStartTimeRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceStartTimeWithContext is the same as DescribeMaintenanceStartTime with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceStartTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeMaintenanceStartTimeWithContext(ctx aws.Context, input *DescribeMaintenanceStartTimeInput, opts ...request.Option) (*DescribeMaintenanceStartTimeOutput, error) {
	req, out := c.DescribeMaintenanceStartTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNFSFileShares = "DescribeNFSFileShares"

// DescribeNFSFileSharesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNFSFileShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNFSFileShares for more information on using the DescribeNFSFileShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNFSFileSharesRequest method.
//    req, resp := client.DescribeNFSFileSharesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileShares
func (c *StorageGateway) DescribeNFSFileSharesRequest(input *DescribeNFSFileSharesInput) (req *request.Request, output *DescribeNFSFileSharesOutput) {
	op := &request.Operation{
		Name:       opDescribeNFSFileShares,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNFSFileSharesInput{}
	}

	output = &DescribeNFSFileSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNFSFileShares API operation for AWS Storage Gateway.
//
// Gets a description for one or more Network File System (NFS) file shares
// from a file gateway. This operation is only supported for file gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeNFSFileShares for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileShares
func (c *StorageGateway) DescribeNFSFileShares(input *DescribeNFSFileSharesInput) (*DescribeNFSFileSharesOutput, error) {
	req, out := c.DescribeNFSFileSharesRequest(input)
	return out, req.Send()
}

// DescribeNFSFileSharesWithContext is the same as DescribeNFSFileShares with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNFSFileShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeNFSFileSharesWithContext(ctx aws.Context, input *DescribeNFSFileSharesInput, opts ...request.Option) (*DescribeNFSFileSharesOutput, error) {
	req, out := c.DescribeNFSFileSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSMBFileShares = "DescribeSMBFileShares"

// DescribeSMBFileSharesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSMBFileShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSMBFileShares for more information on using the DescribeSMBFileShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSMBFileSharesRequest method.
//    req, resp := client.DescribeSMBFileSharesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBFileShares
func (c *StorageGateway) DescribeSMBFileSharesRequest(input *DescribeSMBFileSharesInput) (req *request.Request, output *DescribeSMBFileSharesOutput) {
	op := &request.Operation{
		Name:       opDescribeSMBFileShares,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSMBFileSharesInput{}
	}

	output = &DescribeSMBFileSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSMBFileShares API operation for AWS Storage Gateway.
//
// Gets a description for one or more Server Message Block (SMB) file shares
// from a file gateway. This operation is only supported for file gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeSMBFileShares for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBFileShares
func (c *StorageGateway) DescribeSMBFileShares(input *DescribeSMBFileSharesInput) (*DescribeSMBFileSharesOutput, error) {
	req, out := c.DescribeSMBFileSharesRequest(input)
	return out, req.Send()
}

// DescribeSMBFileSharesWithContext is the same as DescribeSMBFileShares with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSMBFileShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeSMBFileSharesWithContext(ctx aws.Context, input *DescribeSMBFileSharesInput, opts ...request.Option) (*DescribeSMBFileSharesOutput, error) {
	req, out := c.DescribeSMBFileSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSMBSettings = "DescribeSMBSettings"

// DescribeSMBSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSMBSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSMBSettings for more information on using the DescribeSMBSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSMBSettingsRequest method.
//    req, resp := client.DescribeSMBSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBSettings
func (c *StorageGateway) DescribeSMBSettingsRequest(input *DescribeSMBSettingsInput) (req *request.Request, output *DescribeSMBSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeSMBSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSMBSettingsInput{}
	}

	output = &DescribeSMBSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSMBSettings API operation for AWS Storage Gateway.
//
// Gets a description of a Server Message Block (SMB) file share settings from
// a file gateway. This operation is only supported for file gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeSMBSettings for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSMBSettings
func (c *StorageGateway) DescribeSMBSettings(input *DescribeSMBSettingsInput) (*DescribeSMBSettingsOutput, error) {
	req, out := c.DescribeSMBSettingsRequest(input)
	return out, req.Send()
}

// DescribeSMBSettingsWithContext is the same as DescribeSMBSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSMBSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeSMBSettingsWithContext(ctx aws.Context, input *DescribeSMBSettingsInput, opts ...request.Option) (*DescribeSMBSettingsOutput, error) {
	req, out := c.DescribeSMBSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSnapshotSchedule = "DescribeSnapshotSchedule"

// DescribeSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshotSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSnapshotSchedule for more information on using the DescribeSnapshotSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSnapshotScheduleRequest method.
//    req, resp := client.DescribeSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotSchedule
func (c *StorageGateway) DescribeSnapshotScheduleRequest(input *DescribeSnapshotScheduleInput) (req *request.Request, output *DescribeSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotScheduleInput{}
	}

	output = &DescribeSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshotSchedule API operation for AWS Storage Gateway.
//
// Describes the snapshot schedule for the specified gateway volume. The snapshot
// schedule information includes intervals at which snapshots are automatically
// initiated on the volume. This operation is only supported in the cached volume
// and stored volume types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeSnapshotSchedule for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotSchedule
func (c *StorageGateway) DescribeSnapshotSchedule(input *DescribeSnapshotScheduleInput) (*DescribeSnapshotScheduleOutput, error) {
	req, out := c.DescribeSnapshotScheduleRequest(input)
	return out, req.Send()
}

// DescribeSnapshotScheduleWithContext is the same as DescribeSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeSnapshotScheduleWithContext(ctx aws.Context, input *DescribeSnapshotScheduleInput, opts ...request.Option) (*DescribeSnapshotScheduleOutput, error) {
	req, out := c.DescribeSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStorediSCSIVolumes = "DescribeStorediSCSIVolumes"

// DescribeStorediSCSIVolumesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStorediSCSIVolumes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStorediSCSIVolumes for more information on using the DescribeStorediSCSIVolumes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStorediSCSIVolumesRequest method.
//    req, resp := client.DescribeStorediSCSIVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumes
func (c *StorageGateway) DescribeStorediSCSIVolumesRequest(input *DescribeStorediSCSIVolumesInput) (req *request.Request, output *DescribeStorediSCSIVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeStorediSCSIVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStorediSCSIVolumesInput{}
	}

	output = &DescribeStorediSCSIVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStorediSCSIVolumes API operation for AWS Storage Gateway.
//
// Returns the description of the gateway volumes specified in the request.
// The list of gateway volumes in the request must be from one gateway. In the
// response, AWS Storage Gateway returns volume information sorted by volume
// ARNs. This operation is only supported in stored volume gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeStorediSCSIVolumes for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumes
func (c *StorageGateway) DescribeStorediSCSIVolumes(input *DescribeStorediSCSIVolumesInput) (*DescribeStorediSCSIVolumesOutput, error) {
	req, out := c.DescribeStorediSCSIVolumesRequest(input)
	return out, req.Send()
}

// DescribeStorediSCSIVolumesWithContext is the same as DescribeStorediSCSIVolumes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStorediSCSIVolumes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeStorediSCSIVolumesWithContext(ctx aws.Context, input *DescribeStorediSCSIVolumesInput, opts ...request.Option) (*DescribeStorediSCSIVolumesOutput, error) {
	req, out := c.DescribeStorediSCSIVolumesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTapeArchives = "DescribeTapeArchives"

// DescribeTapeArchivesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapeArchives operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTapeArchives for more information on using the DescribeTapeArchives
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTapeArchivesRequest method.
//    req, resp := client.DescribeTapeArchivesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives
func (c *StorageGateway) DescribeTapeArchivesRequest(input *DescribeTapeArchivesInput) (req *request.Request, output *DescribeTapeArchivesOutput) {
	op := &request.Operation{
		Name:       opDescribeTapeArchives,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeArchivesInput{}
	}

	output = &DescribeTapeArchivesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTapeArchives API operation for AWS Storage Gateway.
//
// Returns a description of specified virtual tapes in the virtual tape shelf
// (VTS). This operation is only supported in the tape gateway type.
//
// If a specific TapeARN is not specified, AWS Storage Gateway returns a description
// of all virtual tapes found in the VTS associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapeArchives for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives
func (c *StorageGateway) DescribeTapeArchives(input *DescribeTapeArchivesInput) (*DescribeTapeArchivesOutput, error) {
	req, out := c.DescribeTapeArchivesRequest(input)
	return out, req.Send()
}

// DescribeTapeArchivesWithContext is the same as DescribeTapeArchives with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTapeArchives for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapeArchivesWithContext(ctx aws.Context, input *DescribeTapeArchivesInput, opts ...request.Option) (*DescribeTapeArchivesOutput, error) {
	req, out := c.DescribeTapeArchivesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTapeArchivesPages iterates over the pages of a DescribeTapeArchives operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapeArchives method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapeArchives operation.
//    pageNum := 0
//    err := client.DescribeTapeArchivesPages(params,
//        func(page *storagegateway.DescribeTapeArchivesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapeArchivesPages(input *DescribeTapeArchivesInput, fn func(*DescribeTapeArchivesOutput, bool) bool) error {
	return c.DescribeTapeArchivesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTapeArchivesPagesWithContext same as DescribeTapeArchivesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapeArchivesPagesWithContext(ctx aws.Context, input *DescribeTapeArchivesInput, fn func(*DescribeTapeArchivesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTapeArchivesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTapeArchivesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeTapeArchivesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeTapeRecoveryPoints = "DescribeTapeRecoveryPoints"

// DescribeTapeRecoveryPointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapeRecoveryPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTapeRecoveryPoints for more information on using the DescribeTapeRecoveryPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTapeRecoveryPointsRequest method.
//    req, resp := client.DescribeTapeRecoveryPointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints
func (c *StorageGateway) DescribeTapeRecoveryPointsRequest(input *DescribeTapeRecoveryPointsInput) (req *request.Request, output *DescribeTapeRecoveryPointsOutput) {
	op := &request.Operation{
		Name:       opDescribeTapeRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeRecoveryPointsInput{}
	}

	output = &DescribeTapeRecoveryPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTapeRecoveryPoints API operation for AWS Storage Gateway.
//
// Returns a list of virtual tape recovery points that are available for the
// specified tape gateway.
//
// A recovery point is a point-in-time view of a virtual tape at which all the
// data on the virtual tape is consistent. If your gateway crashes, virtual
// tapes that have recovery points can be recovered to a new gateway. This operation
// is only supported in the tape gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapeRecoveryPoints for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints
func (c *StorageGateway) DescribeTapeRecoveryPoints(input *DescribeTapeRecoveryPointsInput) (*DescribeTapeRecoveryPointsOutput, error) {
	req, out := c.DescribeTapeRecoveryPointsRequest(input)
	return out, req.Send()
}

// DescribeTapeRecoveryPointsWithContext is the same as DescribeTapeRecoveryPoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTapeRecoveryPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapeRecoveryPointsWithContext(ctx aws.Context, input *DescribeTapeRecoveryPointsInput, opts ...request.Option) (*DescribeTapeRecoveryPointsOutput, error) {
	req, out := c.DescribeTapeRecoveryPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTapeRecoveryPointsPages iterates over the pages of a DescribeTapeRecoveryPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapeRecoveryPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapeRecoveryPoints operation.
//    pageNum := 0
//    err := client.DescribeTapeRecoveryPointsPages(params,
//        func(page *storagegateway.DescribeTapeRecoveryPointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapeRecoveryPointsPages(input *DescribeTapeRecoveryPointsInput, fn func(*DescribeTapeRecoveryPointsOutput, bool) bool) error {
	return c.DescribeTapeRecoveryPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTapeRecoveryPointsPagesWithContext same as DescribeTapeRecoveryPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapeRecoveryPointsPagesWithContext(ctx aws.Context, input *DescribeTapeRecoveryPointsInput, fn func(*DescribeTapeRecoveryPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTapeRecoveryPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTapeRecoveryPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeTapeRecoveryPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeTapes = "DescribeTapes"

// DescribeTapesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTapes for more information on using the DescribeTapes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTapesRequest method.
//    req, resp := client.DescribeTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes
func (c *StorageGateway) DescribeTapesRequest(input *DescribeTapesInput) (req *request.Request, output *DescribeTapesOutput) {
	op := &request.Operation{
		Name:       opDescribeTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapesInput{}
	}

	output = &DescribeTapesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTapes API operation for AWS Storage Gateway.
//
// Returns a description of the specified Amazon Resource Name (ARN) of virtual
// tapes. If a TapeARN is not specified, returns a description of all virtual
// tapes associated with the specified gateway. This operation is only supported
// in the tape gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapes for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes
func (c *StorageGateway) DescribeTapes(input *DescribeTapesInput) (*DescribeTapesOutput, error) {
	req, out := c.DescribeTapesRequest(input)
	return out, req.Send()
}

// DescribeTapesWithContext is the same as DescribeTapes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTapes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapesWithContext(ctx aws.Context, input *DescribeTapesInput, opts ...request.Option) (*DescribeTapesOutput, error) {
	req, out := c.DescribeTapesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTapesPages iterates over the pages of a DescribeTapes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapes operation.
//    pageNum := 0
//    err := client.DescribeTapesPages(params,
//        func(page *storagegateway.DescribeTapesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapesPages(input *DescribeTapesInput, fn func(*DescribeTapesOutput, bool) bool) error {
	return c.DescribeTapesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTapesPagesWithContext same as DescribeTapesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapesPagesWithContext(ctx aws.Context, input *DescribeTapesInput, fn func(*DescribeTapesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTapesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTapesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeTapesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeUploadBuffer = "DescribeUploadBuffer"

// DescribeUploadBufferRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUploadBuffer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUploadBuffer for more information on using the DescribeUploadBuffer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUploadBufferRequest method.
//    req, resp := client.DescribeUploadBufferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBuffer
func (c *StorageGateway) DescribeUploadBufferRequest(input *DescribeUploadBufferInput) (req *request.Request, output *DescribeUploadBufferOutput) {
	op := &request.Operation{
		Name:       opDescribeUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUploadBufferInput{}
	}

	output = &DescribeUploadBufferOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUploadBuffer API operation for AWS Storage Gateway.
//
// Returns information about the upload buffer of a gateway. This operation
// is supported for the stored volume, cached volume, and tape gateway types.
//
// The response includes disk IDs that are configured as upload buffer space,
// and it includes the amount of upload buffer space allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeUploadBuffer for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBuffer
func (c *StorageGateway) DescribeUploadBuffer(input *DescribeUploadBufferInput) (*DescribeUploadBufferOutput, error) {
	req, out := c.DescribeUploadBufferRequest(input)
	return out, req.Send()
}

// DescribeUploadBufferWithContext is the same as DescribeUploadBuffer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUploadBuffer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeUploadBufferWithContext(ctx aws.Context, input *DescribeUploadBufferInput, opts ...request.Option) (*DescribeUploadBufferOutput, error) {
	req, out := c.DescribeUploadBufferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVTLDevices = "DescribeVTLDevices"

// DescribeVTLDevicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVTLDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVTLDevices for more information on using the DescribeVTLDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVTLDevicesRequest method.
//    req, resp := client.DescribeVTLDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices
func (c *StorageGateway) DescribeVTLDevicesRequest(input *DescribeVTLDevicesInput) (req *request.Request, output *DescribeVTLDevicesOutput) {
	op := &request.Operation{
		Name:       opDescribeVTLDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVTLDevicesInput{}
	}

	output = &DescribeVTLDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVTLDevices API operation for AWS Storage Gateway.
//
// Returns a description of virtual tape library (VTL) devices for the specified
// tape gateway. In the response, AWS Storage Gateway returns VTL device information.
//
// This operation is only supported in the tape gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeVTLDevices for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices
func (c *StorageGateway) DescribeVTLDevices(input *DescribeVTLDevicesInput) (*DescribeVTLDevicesOutput, error) {
	req, out := c.DescribeVTLDevicesRequest(input)
	return out, req.Send()
}

// DescribeVTLDevicesWithContext is the same as DescribeVTLDevices with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVTLDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeVTLDevicesWithContext(ctx aws.Context, input *DescribeVTLDevicesInput, opts ...request.Option) (*DescribeVTLDevicesOutput, error) {
	req, out := c.DescribeVTLDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeVTLDevicesPages iterates over the pages of a DescribeVTLDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeVTLDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeVTLDevices operation.
//    pageNum := 0
//    err := client.DescribeVTLDevicesPages(params,
//        func(page *storagegateway.DescribeVTLDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeVTLDevicesPages(input *DescribeVTLDevicesInput, fn func(*DescribeVTLDevicesOutput, bool) bool) error {
	return c.DescribeVTLDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeVTLDevicesPagesWithContext same as DescribeVTLDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeVTLDevicesPagesWithContext(ctx aws.Context, input *DescribeVTLDevicesInput, fn func(*DescribeVTLDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeVTLDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeVTLDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeVTLDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeWorkingStorage = "DescribeWorkingStorage"

// DescribeWorkingStorageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkingStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkingStorage for more information on using the DescribeWorkingStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkingStorageRequest method.
//    req, resp := client.DescribeWorkingStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorage
func (c *StorageGateway) DescribeWorkingStorageRequest(input *DescribeWorkingStorageInput) (req *request.Request, output *DescribeWorkingStorageOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkingStorageInput{}
	}

	output = &DescribeWorkingStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkingStorage API operation for AWS Storage Gateway.
//
// Returns information about the working storage of a gateway. This operation
// is only supported in the stored volumes gateway type. This operation is deprecated
// in cached volumes API version (20120630). Use DescribeUploadBuffer instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// DescribeUploadBuffer operation to add upload buffer to a stored volume gateway.
//
// The response includes disk IDs that are configured as working storage, and
// it includes the amount of working storage allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeWorkingStorage for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorage
func (c *StorageGateway) DescribeWorkingStorage(input *DescribeWorkingStorageInput) (*DescribeWorkingStorageOutput, error) {
	req, out := c.DescribeWorkingStorageRequest(input)
	return out, req.Send()
}

// DescribeWorkingStorageWithContext is the same as DescribeWorkingStorage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkingStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeWorkingStorageWithContext(ctx aws.Context, input *DescribeWorkingStorageInput, opts ...request.Option) (*DescribeWorkingStorageOutput, error) {
	req, out := c.DescribeWorkingStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachVolume = "DetachVolume"

// DetachVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DetachVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachVolume for more information on using the DetachVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachVolumeRequest method.
//    req, resp := client.DetachVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DetachVolume
func (c *StorageGateway) DetachVolumeRequest(input *DetachVolumeInput) (req *request.Request, output *DetachVolumeOutput) {
	op := &request.Operation{
		Name:       opDetachVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachVolumeInput{}
	}

	output = &DetachVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachVolume API operation for AWS Storage Gateway.
//
// Disconnects a volume from an iSCSI connection and then detaches the volume
// from the specified gateway. Detaching and attaching a volume enables you
// to recover your data from one gateway to a different gateway without creating
// a snapshot. It also makes it easier to move your volumes from an on-premises
// gateway to a gateway hosted on an Amazon EC2 instance. This operation is
// only supported in the volume gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DetachVolume for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DetachVolume
func (c *StorageGateway) DetachVolume(input *DetachVolumeInput) (*DetachVolumeOutput, error) {
	req, out := c.DetachVolumeRequest(input)
	return out, req.Send()
}

// DetachVolumeWithContext is the same as DetachVolume with the addition of
// the ability to pass a context and additional request options.
//
// See DetachVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DetachVolumeWithContext(ctx aws.Context, input *DetachVolumeInput, opts ...request.Option) (*DetachVolumeOutput, error) {
	req, out := c.DetachVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableGateway = "DisableGateway"

// DisableGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DisableGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableGateway for more information on using the DisableGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableGatewayRequest method.
//    req, resp := client.DisableGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGateway
func (c *StorageGateway) DisableGatewayRequest(input *DisableGatewayInput) (req *request.Request, output *DisableGatewayOutput) {
	op := &request.Operation{
		Name:       opDisableGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableGatewayInput{}
	}

	output = &DisableGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableGateway API operation for AWS Storage Gateway.
//
// Disables a tape gateway when the gateway is no longer functioning. For example,
// if your gateway VM is damaged, you can disable the gateway so you can recover
// virtual tapes.
//
// Use this operation for a tape gateway that is not reachable or not functioning.
// This operation is only supported in the tape gateway type.
//
// After a gateway is disabled, it cannot be enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DisableGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGateway
func (c *StorageGateway) DisableGateway(input *DisableGatewayInput) (*DisableGatewayOutput, error) {
	req, out := c.DisableGatewayRequest(input)
	return out, req.Send()
}

// DisableGatewayWithContext is the same as DisableGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DisableGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DisableGatewayWithContext(ctx aws.Context, input *DisableGatewayInput, opts ...request.Option) (*DisableGatewayOutput, error) {
	req, out := c.DisableGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opJoinDomain = "JoinDomain"

// JoinDomainRequest generates a "aws/request.Request" representing the
// client's request for the JoinDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See JoinDomain for more information on using the JoinDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the JoinDomainRequest method.
//    req, resp := client.JoinDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/JoinDomain
func (c *StorageGateway) JoinDomainRequest(input *JoinDomainInput) (req *request.Request, output *JoinDomainOutput) {
	op := &request.Operation{
		Name:       opJoinDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &JoinDomainInput{}
	}

	output = &JoinDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// JoinDomain API operation for AWS Storage Gateway.
//
// Adds a file gateway to an Active Directory domain. This operation is only
// supported for file gateways that support the SMB file protocol.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation JoinDomain for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/JoinDomain
func (c *StorageGateway) JoinDomain(input *JoinDomainInput) (*JoinDomainOutput, error) {
	req, out := c.JoinDomainRequest(input)
	return out, req.Send()
}

// JoinDomainWithContext is the same as JoinDomain with the addition of
// the ability to pass a context and additional request options.
//
// See JoinDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) JoinDomainWithContext(ctx aws.Context, input *JoinDomainInput, opts ...request.Option) (*JoinDomainOutput, error) {
	req, out := c.JoinDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAutomaticTapeCreationPolicies = "ListAutomaticTapeCreationPolicies"

// ListAutomaticTapeCreationPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAutomaticTapeCreationPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAutomaticTapeCreationPolicies for more information on using the ListAutomaticTapeCreationPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAutomaticTapeCreationPoliciesRequest method.
//    req, resp := client.ListAutomaticTapeCreationPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListAutomaticTapeCreationPolicies
func (c *StorageGateway) ListAutomaticTapeCreationPoliciesRequest(input *ListAutomaticTapeCreationPoliciesInput) (req *request.Request, output *ListAutomaticTapeCreationPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAutomaticTapeCreationPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAutomaticTapeCreationPoliciesInput{}
	}

	output = &ListAutomaticTapeCreationPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAutomaticTapeCreationPolicies API operation for AWS Storage Gateway.
//
// Lists the automatic tape creation policies for a gateway. If there are no
// automatic tape creation policies for the gateway, it returns an empty list.
//
// This operation is only supported for tape gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListAutomaticTapeCreationPolicies for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListAutomaticTapeCreationPolicies
func (c *StorageGateway) ListAutomaticTapeCreationPolicies(input *ListAutomaticTapeCreationPoliciesInput) (*ListAutomaticTapeCreationPoliciesOutput, error) {
	req, out := c.ListAutomaticTapeCreationPoliciesRequest(input)
	return out, req.Send()
}

// ListAutomaticTapeCreationPoliciesWithContext is the same as ListAutomaticTapeCreationPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListAutomaticTapeCreationPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListAutomaticTapeCreationPoliciesWithContext(ctx aws.Context, input *ListAutomaticTapeCreationPoliciesInput, opts ...request.Option) (*ListAutomaticTapeCreationPoliciesOutput, error) {
	req, out := c.ListAutomaticTapeCreationPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFileShares = "ListFileShares"

// ListFileSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListFileShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFileShares for more information on using the ListFileShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFileSharesRequest method.
//    req, resp := client.ListFileSharesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares
func (c *StorageGateway) ListFileSharesRequest(input *ListFileSharesInput) (req *request.Request, output *ListFileSharesOutput) {
	op := &request.Operation{
		Name:       opListFileShares,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFileSharesInput{}
	}

	output = &ListFileSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFileShares API operation for AWS Storage Gateway.
//
// Gets a list of the file shares for a specific file gateway, or the list of
// file shares that belong to the calling user account. This operation is only
// supported for file gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListFileShares for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares
func (c *StorageGateway) ListFileShares(input *ListFileSharesInput) (*ListFileSharesOutput, error) {
	req, out := c.ListFileSharesRequest(input)
	return out, req.Send()
}

// ListFileSharesWithContext is the same as ListFileShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListFileShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListFileSharesWithContext(ctx aws.Context, input *ListFileSharesInput, opts ...request.Option) (*ListFileSharesOutput, error) {
	req, out := c.ListFileSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFileSharesPages iterates over the pages of a ListFileShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFileShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFileShares operation.
//    pageNum := 0
//    err := client.ListFileSharesPages(params,
//        func(page *storagegateway.ListFileSharesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListFileSharesPages(input *ListFileSharesInput, fn func(*ListFileSharesOutput, bool) bool) error {
	return c.ListFileSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFileSharesPagesWithContext same as ListFileSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListFileSharesPagesWithContext(ctx aws.Context, input *ListFileSharesInput, fn func(*ListFileSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFileSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFileSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFileSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGateways = "ListGateways"

// ListGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGateways for more information on using the ListGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGatewaysRequest method.
//    req, resp := client.ListGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways
func (c *StorageGateway) ListGatewaysRequest(input *ListGatewaysInput) (req *request.Request, output *ListGatewaysOutput) {
	op := &request.Operation{
		Name:       opListGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	output = &ListGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGateways API operation for AWS Storage Gateway.
//
// Lists gateways owned by an AWS account in an AWS Region specified in the
// request. The returned list is ordered by gateway Amazon Resource Name (ARN).
//
// By default, the operation returns a maximum of 100 gateways. This operation
// supports pagination that allows you to optionally reduce the number of gateways
// returned in a response.
//
// If you have more gateways than are returned in a response (that is, the response
// returns only a truncated list of your gateways), the response contains a
// marker that you can specify in your next request to fetch the next page of
// gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListGateways for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways
func (c *StorageGateway) ListGateways(input *ListGatewaysInput) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	return out, req.Send()
}

// ListGatewaysWithContext is the same as ListGateways with the addition of
// the ability to pass a context and additional request options.
//
// See ListGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListGatewaysWithContext(ctx aws.Context, input *ListGatewaysInput, opts ...request.Option) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewaysPages iterates over the pages of a ListGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGateways operation.
//    pageNum := 0
//    err := client.ListGatewaysPages(params,
//        func(page *storagegateway.ListGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListGatewaysPages(input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool) error {
	return c.ListGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewaysPagesWithContext same as ListGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListGatewaysPagesWithContext(ctx aws.Context, input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLocalDisks = "ListLocalDisks"

// ListLocalDisksRequest generates a "aws/request.Request" representing the
// client's request for the ListLocalDisks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLocalDisks for more information on using the ListLocalDisks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLocalDisksRequest method.
//    req, resp := client.ListLocalDisksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisks
func (c *StorageGateway) ListLocalDisksRequest(input *ListLocalDisksInput) (req *request.Request, output *ListLocalDisksOutput) {
	op := &request.Operation{
		Name:       opListLocalDisks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLocalDisksInput{}
	}

	output = &ListLocalDisksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLocalDisks API operation for AWS Storage Gateway.
//
// Returns a list of the gateway's local disks. To specify which gateway to
// describe, you use the Amazon Resource Name (ARN) of the gateway in the body
// of the request.
//
// The request returns a list of all disks, specifying which are configured
// as working storage, cache storage, or stored volume or not configured at
// all. The response includes a DiskStatus field. This field can have a value
// of present (the disk is available to use), missing (the disk is no longer
// connected to the gateway), or mismatch (the disk node is occupied by a disk
// that has incorrect metadata or the disk content is corrupted).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListLocalDisks for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisks
func (c *StorageGateway) ListLocalDisks(input *ListLocalDisksInput) (*ListLocalDisksOutput, error) {
	req, out := c.ListLocalDisksRequest(input)
	return out, req.Send()
}

// ListLocalDisksWithContext is the same as ListLocalDisks with the addition of
// the ability to pass a context and additional request options.
//
// See ListLocalDisks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListLocalDisksWithContext(ctx aws.Context, input *ListLocalDisksInput, opts ...request.Option) (*ListLocalDisksOutput, error) {
	req, out := c.ListLocalDisksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource
func (c *StorageGateway) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Storage Gateway.
//
// Lists the tags that have been added to the specified resource. This operation
// is supported in storage gateways of all types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource
func (c *StorageGateway) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *storagegateway.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTapePools = "ListTapePools"

// ListTapePoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListTapePools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTapePools for more information on using the ListTapePools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTapePoolsRequest method.
//    req, resp := client.ListTapePoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapePools
func (c *StorageGateway) ListTapePoolsRequest(input *ListTapePoolsInput) (req *request.Request, output *ListTapePoolsOutput) {
	op := &request.Operation{
		Name:       opListTapePools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTapePoolsInput{}
	}

	output = &ListTapePoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTapePools API operation for AWS Storage Gateway.
//
// Lists custom tape pools. You specify custom tape pools to list by specifying
// one or more custom tape pool Amazon Resource Names (ARNs). If you don't specify
// a custom tape pool ARN, the operation lists all custom tape pools.
//
// This operation supports pagination. You can optionally specify the Limit
// parameter in the body to limit the number of tape pools in the response.
// If the number of tape pools returned in the response is truncated, the response
// includes a Marker element that you can use in your subsequent request to
// retrieve the next set of tape pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListTapePools for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapePools
func (c *StorageGateway) ListTapePools(input *ListTapePoolsInput) (*ListTapePoolsOutput, error) {
	req, out := c.ListTapePoolsRequest(input)
	return out, req.Send()
}

// ListTapePoolsWithContext is the same as ListTapePools with the addition of
// the ability to pass a context and additional request options.
//
// See ListTapePools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListTapePoolsWithContext(ctx aws.Context, input *ListTapePoolsInput, opts ...request.Option) (*ListTapePoolsOutput, error) {
	req, out := c.ListTapePoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTapePoolsPages iterates over the pages of a ListTapePools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTapePools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTapePools operation.
//    pageNum := 0
//    err := client.ListTapePoolsPages(params,
//        func(page *storagegateway.ListTapePoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListTapePoolsPages(input *ListTapePoolsInput, fn func(*ListTapePoolsOutput, bool) bool) error {
	return c.ListTapePoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTapePoolsPagesWithContext same as ListTapePoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListTapePoolsPagesWithContext(ctx aws.Context, input *ListTapePoolsInput, fn func(*ListTapePoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTapePoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTapePoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTapePoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTapes = "ListTapes"

// ListTapesRequest generates a "aws/request.Request" representing the
// client's request for the ListTapes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTapes for more information on using the ListTapes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTapesRequest method.
//    req, resp := client.ListTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes
func (c *StorageGateway) ListTapesRequest(input *ListTapesInput) (req *request.Request, output *ListTapesOutput) {
	op := &request.Operation{
		Name:       opListTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTapesInput{}
	}

	output = &ListTapesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTapes API operation for AWS Storage Gateway.
//
// Lists virtual tapes in your virtual tape library (VTL) and your virtual tape
// shelf (VTS). You specify the tapes to list by specifying one or more tape
// Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation
// lists all virtual tapes in both your VTL and VTS.
//
// This operation supports pagination. By default, the operation returns a maximum
// of up to 100 tapes. You can optionally specify the Limit parameter in the
// body to limit the number of tapes in the response. If the number of tapes
// returned in the response is truncated, the response includes a Marker element
// that you can use in your subsequent request to retrieve the next set of tapes.
// This operation is only supported in the tape gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListTapes for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes
func (c *StorageGateway) ListTapes(input *ListTapesInput) (*ListTapesOutput, error) {
	req, out := c.ListTapesRequest(input)
	return out, req.Send()
}

// ListTapesWithContext is the same as ListTapes with the addition of
// the ability to pass a context and additional request options.
//
// See ListTapes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListTapesWithContext(ctx aws.Context, input *ListTapesInput, opts ...request.Option) (*ListTapesOutput, error) {
	req, out := c.ListTapesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTapesPages iterates over the pages of a ListTapes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTapes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTapes operation.
//    pageNum := 0
//    err := client.ListTapesPages(params,
//        func(page *storagegateway.ListTapesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListTapesPages(input *ListTapesInput, fn func(*ListTapesOutput, bool) bool) error {
	return c.ListTapesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTapesPagesWithContext same as ListTapesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListTapesPagesWithContext(ctx aws.Context, input *ListTapesInput, fn func(*ListTapesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTapesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTapesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTapesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVolumeInitiators = "ListVolumeInitiators"

// ListVolumeInitiatorsRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumeInitiators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVolumeInitiators for more information on using the ListVolumeInitiators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVolumeInitiatorsRequest method.
//    req, resp := client.ListVolumeInitiatorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiators
func (c *StorageGateway) ListVolumeInitiatorsRequest(input *ListVolumeInitiatorsInput) (req *request.Request, output *ListVolumeInitiatorsOutput) {
	op := &request.Operation{
		Name:       opListVolumeInitiators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVolumeInitiatorsInput{}
	}

	output = &ListVolumeInitiatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVolumeInitiators API operation for AWS Storage Gateway.
//
// Lists iSCSI initiators that are connected to a volume. You can use this operation
// to determine whether a volume is being used or not. This operation is only
// supported in the cached volume and stored volume gateway types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumeInitiators for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiators
func (c *StorageGateway) ListVolumeInitiators(input *ListVolumeInitiatorsInput) (*ListVolumeInitiatorsOutput, error) {
	req, out := c.ListVolumeInitiatorsRequest(input)
	return out, req.Send()
}

// ListVolumeInitiatorsWithContext is the same as ListVolumeInitiators with the addition of
// the ability to pass a context and additional request options.
//
// See ListVolumeInitiators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListVolumeInitiatorsWithContext(ctx aws.Context, input *ListVolumeInitiatorsInput, opts ...request.Option) (*ListVolumeInitiatorsOutput, error) {
	req, out := c.ListVolumeInitiatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVolumeRecoveryPoints = "ListVolumeRecoveryPoints"

// ListVolumeRecoveryPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumeRecoveryPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVolumeRecoveryPoints for more information on using the ListVolumeRecoveryPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVolumeRecoveryPointsRequest method.
//    req, resp := client.ListVolumeRecoveryPointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPoints
func (c *StorageGateway) ListVolumeRecoveryPointsRequest(input *ListVolumeRecoveryPointsInput) (req *request.Request, output *ListVolumeRecoveryPointsOutput) {
	op := &request.Operation{
		Name:       opListVolumeRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVolumeRecoveryPointsInput{}
	}

	output = &ListVolumeRecoveryPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVolumeRecoveryPoints API operation for AWS Storage Gateway.
//
// Lists the recovery points for a specified gateway. This operation is only
// supported in the cached volume gateway type.
//
// Each cache volume has one recovery point. A volume recovery point is a point
// in time at which all data of the volume is consistent and from which you
// can create a snapshot or clone a new cached volume from a source volume.
// To create a snapshot from a volume recovery point use the CreateSnapshotFromVolumeRecoveryPoint
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumeRecoveryPoints for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPoints
func (c *StorageGateway) ListVolumeRecoveryPoints(input *ListVolumeRecoveryPointsInput) (*ListVolumeRecoveryPointsOutput, error) {
	req, out := c.ListVolumeRecoveryPointsRequest(input)
	return out, req.Send()
}

// ListVolumeRecoveryPointsWithContext is the same as ListVolumeRecoveryPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListVolumeRecoveryPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListVolumeRecoveryPointsWithContext(ctx aws.Context, input *ListVolumeRecoveryPointsInput, opts ...request.Option) (*ListVolumeRecoveryPointsOutput, error) {
	req, out := c.ListVolumeRecoveryPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVolumes = "ListVolumes"

// ListVolumesRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVolumes for more information on using the ListVolumes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVolumesRequest method.
//    req, resp := client.ListVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes
func (c *StorageGateway) ListVolumesRequest(input *ListVolumesInput) (req *request.Request, output *ListVolumesOutput) {
	op := &request.Operation{
		Name:       opListVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVolumesInput{}
	}

	output = &ListVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVolumes API operation for AWS Storage Gateway.
//
// Lists the iSCSI stored volumes of a gateway. Results are sorted by volume
// ARN. The response includes only the volume ARNs. If you want additional volume
// information, use the DescribeStorediSCSIVolumes or the DescribeCachediSCSIVolumes
// API.
//
// The operation supports pagination. By default, the operation returns a maximum
// of up to 100 volumes. You can optionally specify the Limit field in the body
// to limit the number of volumes in the response. If the number of volumes
// returned in the response is truncated, the response includes a Marker field.
// You can use this Marker value in your subsequent request to retrieve the
// next set of volumes. This operation is only supported in the cached volume
// and stored volume gateway types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumes for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes
func (c *StorageGateway) ListVolumes(input *ListVolumesInput) (*ListVolumesOutput, error) {
	req, out := c.ListVolumesRequest(input)
	return out, req.Send()
}

// ListVolumesWithContext is the same as ListVolumes with the addition of
// the ability to pass a context and additional request options.
//
// See ListVolumes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListVolumesWithContext(ctx aws.Context, input *ListVolumesInput, opts ...request.Option) (*ListVolumesOutput, error) {
	req, out := c.ListVolumesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVolumesPages iterates over the pages of a ListVolumes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVolumes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVolumes operation.
//    pageNum := 0
//    err := client.ListVolumesPages(params,
//        func(page *storagegateway.ListVolumesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListVolumesPages(input *ListVolumesInput, fn func(*ListVolumesOutput, bool) bool) error {
	return c.ListVolumesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVolumesPagesWithContext same as ListVolumesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListVolumesPagesWithContext(ctx aws.Context, input *ListVolumesInput, fn func(*ListVolumesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVolumesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVolumesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVolumesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opNotifyWhenUploaded = "NotifyWhenUploaded"

// NotifyWhenUploadedRequest generates a "aws/request.Request" representing the
// client's request for the NotifyWhenUploaded operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See NotifyWhenUploaded for more information on using the NotifyWhenUploaded
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the NotifyWhenUploadedRequest method.
//    req, resp := client.NotifyWhenUploadedRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/NotifyWhenUploaded
func (c *StorageGateway) NotifyWhenUploadedRequest(input *NotifyWhenUploadedInput) (req *request.Request, output *NotifyWhenUploadedOutput) {
	op := &request.Operation{
		Name:       opNotifyWhenUploaded,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NotifyWhenUploadedInput{}
	}

	output = &NotifyWhenUploadedOutput{}
	req = c.newRequest(op, input, output)
	return
}

// NotifyWhenUploaded API operation for AWS Storage Gateway.
//
// Sends you notification through CloudWatch Events when all files written to
// your file share have been uploaded to Amazon S3.
//
// AWS Storage Gateway can send a notification through Amazon CloudWatch Events
// when all files written to your file share up to that point in time have been
// uploaded to Amazon S3. These files include files written to the file share
// up to the time that you make a request for notification. When the upload
// is done, Storage Gateway sends you notification through an Amazon CloudWatch
// Event. You can configure CloudWatch Events to send the notification through
// event targets such as Amazon SNS or AWS Lambda function. This operation is
// only supported for file gateways.
//
// For more information, see Getting file upload notification (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-upload-notification)
// in the AWS Storage Gateway User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation NotifyWhenUploaded for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/NotifyWhenUploaded
func (c *StorageGateway) NotifyWhenUploaded(input *NotifyWhenUploadedInput) (*NotifyWhenUploadedOutput, error) {
	req, out := c.NotifyWhenUploadedRequest(input)
	return out, req.Send()
}

// NotifyWhenUploadedWithContext is the same as NotifyWhenUploaded with the addition of
// the ability to pass a context and additional request options.
//
// See NotifyWhenUploaded for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) NotifyWhenUploadedWithContext(ctx aws.Context, input *NotifyWhenUploadedInput, opts ...request.Option) (*NotifyWhenUploadedOutput, error) {
	req, out := c.NotifyWhenUploadedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRefreshCache = "RefreshCache"

// RefreshCacheRequest generates a "aws/request.Request" representing the
// client's request for the RefreshCache operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RefreshCache for more information on using the RefreshCache
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RefreshCacheRequest method.
//    req, resp := client.RefreshCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RefreshCache
func (c *StorageGateway) RefreshCacheRequest(input *RefreshCacheInput) (req *request.Request, output *RefreshCacheOutput) {
	op := &request.Operation{
		Name:       opRefreshCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RefreshCacheInput{}
	}

	output = &RefreshCacheOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RefreshCache API operation for AWS Storage Gateway.
//
// Refreshes the cache for the specified file share. This operation finds objects
// in the Amazon S3 bucket that were added, removed, or replaced since the gateway
// last listed the bucket's contents and cached the results. This operation
// is only supported in the file gateway type. You can subscribe to be notified
// through an Amazon CloudWatch event when your RefreshCache operation completes.
// For more information, see Getting notified about file operations (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification)
// in the AWS Storage Gateway User Guide.
//
// When this API is called, it only initiates the refresh operation. When the
// API call completes and returns a success code, it doesn't necessarily mean
// that the file refresh has completed. You should use the refresh-complete
// notification to determine that the operation has completed before you check
// for new files on the gateway file share. You can subscribe to be notified
// through an CloudWatch event when your RefreshCache operation completes.
//
// Throttle limit: This API is asynchronous so the gateway will accept no more
// than two refreshes at any time. We recommend using the refresh-complete CloudWatch
// event notification before issuing additional requests. For more information,
// see Getting notified about file operations (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification)
// in the AWS Storage Gateway User Guide.
//
// If you invoke the RefreshCache API when two requests are already being processed,
// any new request will cause an InvalidGatewayRequestException error because
// too many requests were sent to the server.
//
// For more information, see Getting notified about file operations (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification)
// in the AWS Storage Gateway User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RefreshCache for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RefreshCache
func (c *StorageGateway) RefreshCache(input *RefreshCacheInput) (*RefreshCacheOutput, error) {
	req, out := c.RefreshCacheRequest(input)
	return out, req.Send()
}

// RefreshCacheWithContext is the same as RefreshCache with the addition of
// the ability to pass a context and additional request options.
//
// See RefreshCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) RefreshCacheWithContext(ctx aws.Context, input *RefreshCacheInput, opts ...request.Option) (*RefreshCacheOutput, error) {
	req, out := c.RefreshCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResource
func (c *StorageGateway) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTagsFromResource API operation for AWS Storage Gateway.
//
// Removes one or more tags from the specified resource. This operation is supported
// in storage gateways of all types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResource
func (c *StorageGateway) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetCache = "ResetCache"

// ResetCacheRequest generates a "aws/request.Request" representing the
// client's request for the ResetCache operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetCache for more information on using the ResetCache
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetCacheRequest method.
//    req, resp := client.ResetCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCache
func (c *StorageGateway) ResetCacheRequest(input *ResetCacheInput) (req *request.Request, output *ResetCacheOutput) {
	op := &request.Operation{
		Name:       opResetCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetCacheInput{}
	}

	output = &ResetCacheOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetCache API operation for AWS Storage Gateway.
//
// Resets all cache disks that have encountered an error and makes the disks
// available for reconfiguration as cache storage. If your cache disk encounters
// an error, the gateway prevents read and write operations on virtual tapes
// in the gateway. For example, an error can occur when a disk is corrupted
// or removed from the gateway. When a cache is reset, the gateway loses its
// cache storage. At this point, you can reconfigure the disks as cache disks.
// This operation is only supported in the cached volume and tape types.
//
// If the cache disk you are resetting contains data that has not been uploaded
// to Amazon S3 yet, that data can be lost. After you reset cache disks, there
// will be no configured cache disks left in the gateway, so you must configure
// at least one new cache disk for your gateway to function properly.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ResetCache for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCache
func (c *StorageGateway) ResetCache(input *ResetCacheInput) (*ResetCacheOutput, error) {
	req, out := c.ResetCacheRequest(input)
	return out, req.Send()
}

// ResetCacheWithContext is the same as ResetCache with the addition of
// the ability to pass a context and additional request options.
//
// See ResetCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ResetCacheWithContext(ctx aws.Context, input *ResetCacheInput, opts ...request.Option) (*ResetCacheOutput, error) {
	req, out := c.ResetCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetrieveTapeArchive = "RetrieveTapeArchive"

// RetrieveTapeArchiveRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveTapeArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetrieveTapeArchive for more information on using the RetrieveTapeArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RetrieveTapeArchiveRequest method.
//    req, resp := client.RetrieveTapeArchiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchive
func (c *StorageGateway) RetrieveTapeArchiveRequest(input *RetrieveTapeArchiveInput) (req *request.Request, output *RetrieveTapeArchiveOutput) {
	op := &request.Operation{
		Name:       opRetrieveTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeArchiveInput{}
	}

	output = &RetrieveTapeArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetrieveTapeArchive API operation for AWS Storage Gateway.
//
// Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a
// tape gateway. Virtual tapes archived in the VTS are not associated with any
// gateway. However after a tape is retrieved, it is associated with a gateway,
// even though it is also listed in the VTS, that is, archive. This operation
// is only supported in the tape gateway type.
//
// Once a tape is successfully retrieved to a gateway, it cannot be retrieved
// again to another gateway. You must archive the tape again before you can
// retrieve it to another gateway. This operation is only supported in the tape
// gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RetrieveTapeArchive for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchive
func (c *StorageGateway) RetrieveTapeArchive(input *RetrieveTapeArchiveInput) (*RetrieveTapeArchiveOutput, error) {
	req, out := c.RetrieveTapeArchiveRequest(input)
	return out, req.Send()
}

// RetrieveTapeArchiveWithContext is the same as RetrieveTapeArchive with the addition of
// the ability to pass a context and additional request options.
//
// See RetrieveTapeArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) RetrieveTapeArchiveWithContext(ctx aws.Context, input *RetrieveTapeArchiveInput, opts ...request.Option) (*RetrieveTapeArchiveOutput, error) {
	req, out := c.RetrieveTapeArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetrieveTapeRecoveryPoint = "RetrieveTapeRecoveryPoint"

// RetrieveTapeRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveTapeRecoveryPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetrieveTapeRecoveryPoint for more information on using the RetrieveTapeRecoveryPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RetrieveTapeRecoveryPointRequest method.
//    req, resp := client.RetrieveTapeRecoveryPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPoint
func (c *StorageGateway) RetrieveTapeRecoveryPointRequest(input *RetrieveTapeRecoveryPointInput) (req *request.Request, output *RetrieveTapeRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opRetrieveTapeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeRecoveryPointInput{}
	}

	output = &RetrieveTapeRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetrieveTapeRecoveryPoint API operation for AWS Storage Gateway.
//
// Retrieves the recovery point for the specified virtual tape. This operation
// is only supported in the tape gateway type.
//
// A recovery point is a point in time view of a virtual tape at which all the
// data on the tape is consistent. If your gateway crashes, virtual tapes that
// have recovery points can be recovered to a new gateway.
//
// The virtual tape can be retrieved to only one gateway. The retrieved tape
// is read-only. The virtual tape can be retrieved to only a tape gateway. There
// is no charge for retrieving recovery points.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RetrieveTapeRecoveryPoint for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPoint
func (c *StorageGateway) RetrieveTapeRecoveryPoint(input *RetrieveTapeRecoveryPointInput) (*RetrieveTapeRecoveryPointOutput, error) {
	req, out := c.RetrieveTapeRecoveryPointRequest(input)
	return out, req.Send()
}

// RetrieveTapeRecoveryPointWithContext is the same as RetrieveTapeRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See RetrieveTapeRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) RetrieveTapeRecoveryPointWithContext(ctx aws.Context, input *RetrieveTapeRecoveryPointInput, opts ...request.Option) (*RetrieveTapeRecoveryPointOutput, error) {
	req, out := c.RetrieveTapeRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetLocalConsolePassword = "SetLocalConsolePassword"

// SetLocalConsolePasswordRequest generates a "aws/request.Request" representing the
// client's request for the SetLocalConsolePassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetLocalConsolePassword for more information on using the SetLocalConsolePassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetLocalConsolePasswordRequest method.
//    req, resp := client.SetLocalConsolePasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePassword
func (c *StorageGateway) SetLocalConsolePasswordRequest(input *SetLocalConsolePasswordInput) (req *request.Request, output *SetLocalConsolePasswordOutput) {
	op := &request.Operation{
		Name:       opSetLocalConsolePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLocalConsolePasswordInput{}
	}

	output = &SetLocalConsolePasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetLocalConsolePassword API operation for AWS Storage Gateway.
//
// Sets the password for your VM local console. When you log in to the local
// console for the first time, you log in to the VM with the default credentials.
// We recommend that you set a new password. You don't need to know the default
// password to set a new password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation SetLocalConsolePassword for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePassword
func (c *StorageGateway) SetLocalConsolePassword(input *SetLocalConsolePasswordInput) (*SetLocalConsolePasswordOutput, error) {
	req, out := c.SetLocalConsolePasswordRequest(input)
	return out, req.Send()
}

// SetLocalConsolePasswordWithContext is the same as SetLocalConsolePassword with the addition of
// the ability to pass a context and additional request options.
//
// See SetLocalConsolePassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) SetLocalConsolePasswordWithContext(ctx aws.Context, input *SetLocalConsolePasswordInput, opts ...request.Option) (*SetLocalConsolePasswordOutput, error) {
	req, out := c.SetLocalConsolePasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetSMBGuestPassword = "SetSMBGuestPassword"

// SetSMBGuestPasswordRequest generates a "aws/request.Request" representing the
// client's request for the SetSMBGuestPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetSMBGuestPassword for more information on using the SetSMBGuestPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetSMBGuestPasswordRequest method.
//    req, resp := client.SetSMBGuestPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetSMBGuestPassword
func (c *StorageGateway) SetSMBGuestPasswordRequest(input *SetSMBGuestPasswordInput) (req *request.Request, output *SetSMBGuestPasswordOutput) {
	op := &request.Operation{
		Name:       opSetSMBGuestPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSMBGuestPasswordInput{}
	}

	output = &SetSMBGuestPasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetSMBGuestPassword API operation for AWS Storage Gateway.
//
// Sets the password for the guest user smbguest. The smbguest user is the user
// when the authentication method for the file share is set to GuestAccess.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation SetSMBGuestPassword for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetSMBGuestPassword
func (c *StorageGateway) SetSMBGuestPassword(input *SetSMBGuestPasswordInput) (*SetSMBGuestPasswordOutput, error) {
	req, out := c.SetSMBGuestPasswordRequest(input)
	return out, req.Send()
}

// SetSMBGuestPasswordWithContext is the same as SetSMBGuestPassword with the addition of
// the ability to pass a context and additional request options.
//
// See SetSMBGuestPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) SetSMBGuestPasswordWithContext(ctx aws.Context, input *SetSMBGuestPasswordInput, opts ...request.Option) (*SetSMBGuestPasswordOutput, error) {
	req, out := c.SetSMBGuestPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opShutdownGateway = "ShutdownGateway"

// ShutdownGatewayRequest generates a "aws/request.Request" representing the
// client's request for the ShutdownGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ShutdownGateway for more information on using the ShutdownGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ShutdownGatewayRequest method.
//    req, resp := client.ShutdownGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGateway
func (c *StorageGateway) ShutdownGatewayRequest(input *ShutdownGatewayInput) (req *request.Request, output *ShutdownGatewayOutput) {
	op := &request.Operation{
		Name:       opShutdownGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ShutdownGatewayInput{}
	}

	output = &ShutdownGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ShutdownGateway API operation for AWS Storage Gateway.
//
// Shuts down a gateway. To specify which gateway to shut down, use the Amazon
// Resource Name (ARN) of the gateway in the body of your request.
//
// The operation shuts down the gateway service component running in the gateway's
// virtual machine (VM) and not the host VM.
//
// If you want to shut down the VM, it is recommended that you first shut down
// the gateway component in the VM to avoid unpredictable conditions.
//
// After the gateway is shutdown, you cannot call any other API except StartGateway,
// DescribeGatewayInformation, and ListGateways. For more information, see ActivateGateway.
// Your applications cannot read from or write to the gateway's storage volumes,
// and there are no snapshots taken.
//
// When you make a shutdown request, you will get a 200 OK success response
// immediately. However, it might take some time for the gateway to shut down.
// You can call the DescribeGatewayInformation API to check the status. For
// more information, see ActivateGateway.
//
// If do not intend to use the gateway again, you must delete the gateway (using
// DeleteGateway) to no longer pay software charges associated with the gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ShutdownGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGateway
func (c *StorageGateway) ShutdownGateway(input *ShutdownGatewayInput) (*ShutdownGatewayOutput, error) {
	req, out := c.ShutdownGatewayRequest(input)
	return out, req.Send()
}

// ShutdownGatewayWithContext is the same as ShutdownGateway with the addition of
// the ability to pass a context and additional request options.
//
// See ShutdownGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ShutdownGatewayWithContext(ctx aws.Context, input *ShutdownGatewayInput, opts ...request.Option) (*ShutdownGatewayOutput, error) {
	req, out := c.ShutdownGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAvailabilityMonitorTest = "StartAvailabilityMonitorTest"

// StartAvailabilityMonitorTestRequest generates a "aws/request.Request" representing the
// client's request for the StartAvailabilityMonitorTest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAvailabilityMonitorTest for more information on using the StartAvailabilityMonitorTest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartAvailabilityMonitorTestRequest method.
//    req, resp := client.StartAvailabilityMonitorTestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartAvailabilityMonitorTest
func (c *StorageGateway) StartAvailabilityMonitorTestRequest(input *StartAvailabilityMonitorTestInput) (req *request.Request, output *StartAvailabilityMonitorTestOutput) {
	op := &request.Operation{
		Name:       opStartAvailabilityMonitorTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAvailabilityMonitorTestInput{}
	}

	output = &StartAvailabilityMonitorTestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAvailabilityMonitorTest API operation for AWS Storage Gateway.
//
// Start a test that verifies that the specified gateway is configured for High
// Availability monitoring in your host environment. This request only initiates
// the test and that a successful response only indicates that the test was
// started. It doesn't indicate that the test passed. For the status of the
// test, invoke the DescribeAvailabilityMonitorTest API.
//
// Starting this test will cause your gateway to go offline for a brief period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation StartAvailabilityMonitorTest for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartAvailabilityMonitorTest
func (c *StorageGateway) StartAvailabilityMonitorTest(input *StartAvailabilityMonitorTestInput) (*StartAvailabilityMonitorTestOutput, error) {
	req, out := c.StartAvailabilityMonitorTestRequest(input)
	return out, req.Send()
}

// StartAvailabilityMonitorTestWithContext is the same as StartAvailabilityMonitorTest with the addition of
// the ability to pass a context and additional request options.
//
// See StartAvailabilityMonitorTest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) StartAvailabilityMonitorTestWithContext(ctx aws.Context, input *StartAvailabilityMonitorTestInput, opts ...request.Option) (*StartAvailabilityMonitorTestOutput, error) {
	req, out := c.StartAvailabilityMonitorTestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartGateway = "StartGateway"

// StartGatewayRequest generates a "aws/request.Request" representing the
// client's request for the StartGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartGateway for more information on using the StartGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartGatewayRequest method.
//    req, resp := client.StartGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGateway
func (c *StorageGateway) StartGatewayRequest(input *StartGatewayInput) (req *request.Request, output *StartGatewayOutput) {
	op := &request.Operation{
		Name:       opStartGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartGatewayInput{}
	}

	output = &StartGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartGateway API operation for AWS Storage Gateway.
//
// Starts a gateway that you previously shut down (see ShutdownGateway). After
// the gateway starts, you can then make other API calls, your applications
// can read from or write to the gateway's storage volumes and you will be able
// to take snapshot backups.
//
// When you make a request, you will get a 200 OK success response immediately.
// However, it might take some time for the gateway to be ready. You should
// call DescribeGatewayInformation and check the status before making any additional
// API calls. For more information, see ActivateGateway.
//
// To specify which gateway to start, use the Amazon Resource Name (ARN) of
// the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation StartGateway for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGateway
func (c *StorageGateway) StartGateway(input *StartGatewayInput) (*StartGatewayOutput, error) {
	req, out := c.StartGatewayRequest(input)
	return out, req.Send()
}

// StartGatewayWithContext is the same as StartGateway with the addition of
// the ability to pass a context and additional request options.
//
// See StartGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) StartGatewayWithContext(ctx aws.Context, input *StartGatewayInput, opts ...request.Option) (*StartGatewayOutput, error) {
	req, out := c.StartGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAutomaticTapeCreationPolicy = "UpdateAutomaticTapeCreationPolicy"

// UpdateAutomaticTapeCreationPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAutomaticTapeCreationPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAutomaticTapeCreationPolicy for more information on using the UpdateAutomaticTapeCreationPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAutomaticTapeCreationPolicyRequest method.
//    req, resp := client.UpdateAutomaticTapeCreationPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateAutomaticTapeCreationPolicy
func (c *StorageGateway) UpdateAutomaticTapeCreationPolicyRequest(input *UpdateAutomaticTapeCreationPolicyInput) (req *request.Request, output *UpdateAutomaticTapeCreationPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateAutomaticTapeCreationPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAutomaticTapeCreationPolicyInput{}
	}

	output = &UpdateAutomaticTapeCreationPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAutomaticTapeCreationPolicy API operation for AWS Storage Gateway.
//
// Updates the automatic tape creation policy of a gateway. Use this to update
// the policy with a new set of automatic tape creation rules. This is only
// supported for tape gateways.
//
// By default, there is no automatic tape creation policy.
//
// A gateway can have only one automatic tape creation policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateAutomaticTapeCreationPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateAutomaticTapeCreationPolicy
func (c *StorageGateway) UpdateAutomaticTapeCreationPolicy(input *UpdateAutomaticTapeCreationPolicyInput) (*UpdateAutomaticTapeCreationPolicyOutput, error) {
	req, out := c.UpdateAutomaticTapeCreationPolicyRequest(input)
	return out, req.Send()
}

// UpdateAutomaticTapeCreationPolicyWithContext is the same as UpdateAutomaticTapeCreationPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAutomaticTapeCreationPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateAutomaticTapeCreationPolicyWithContext(ctx aws.Context, input *UpdateAutomaticTapeCreationPolicyInput, opts ...request.Option) (*UpdateAutomaticTapeCreationPolicyOutput, error) {
	req, out := c.UpdateAutomaticTapeCreationPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBandwidthRateLimit = "UpdateBandwidthRateLimit"

// UpdateBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBandwidthRateLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBandwidthRateLimit for more information on using the UpdateBandwidthRateLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBandwidthRateLimitRequest method.
//    req, resp := client.UpdateBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimit
func (c *StorageGateway) UpdateBandwidthRateLimitRequest(input *UpdateBandwidthRateLimitInput) (req *request.Request, output *UpdateBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opUpdateBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBandwidthRateLimitInput{}
	}

	output = &UpdateBandwidthRateLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Updates the bandwidth rate limits of a gateway. You can update both the upload
// and download bandwidth rate limit or specify only one of the two. If you
// don't set a bandwidth rate limit, the existing rate limit remains. This operation
// is supported for the stored volume, cached volume, and tape gateway types.
//
// By default, a gateway's bandwidth rate limits are not set. If you don't set
// any limit, the gateway does not have any limitations on its bandwidth usage
// and could potentially use the maximum available bandwidth.
//
// To specify which gateway to update, use the Amazon Resource Name (ARN) of
// the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateBandwidthRateLimit for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimit
func (c *StorageGateway) UpdateBandwidthRateLimit(input *UpdateBandwidthRateLimitInput) (*UpdateBandwidthRateLimitOutput, error) {
	req, out := c.UpdateBandwidthRateLimitRequest(input)
	return out, req.Send()
}

// UpdateBandwidthRateLimitWithContext is the same as UpdateBandwidthRateLimit with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBandwidthRateLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateBandwidthRateLimitWithContext(ctx aws.Context, input *UpdateBandwidthRateLimitInput, opts ...request.Option) (*UpdateBandwidthRateLimitOutput, error) {
	req, out := c.UpdateBandwidthRateLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBandwidthRateLimitSchedule = "UpdateBandwidthRateLimitSchedule"

// UpdateBandwidthRateLimitScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBandwidthRateLimitSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBandwidthRateLimitSchedule for more information on using the UpdateBandwidthRateLimitSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBandwidthRateLimitScheduleRequest method.
//    req, resp := client.UpdateBandwidthRateLimitScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimitSchedule
func (c *StorageGateway) UpdateBandwidthRateLimitScheduleRequest(input *UpdateBandwidthRateLimitScheduleInput) (req *request.Request, output *UpdateBandwidthRateLimitScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateBandwidthRateLimitSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBandwidthRateLimitScheduleInput{}
	}

	output = &UpdateBandwidthRateLimitScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBandwidthRateLimitSchedule API operation for AWS Storage Gateway.
//
// Updates the bandwidth rate limit schedule for a specified gateway. By default,
// gateways do not have bandwidth rate limit schedules, which means no bandwidth
// rate limiting is in effect. Use this to initiate or update a gateway's bandwidth
// rate limit schedule. This operation is supported in the volume and tape gateway
// types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateBandwidthRateLimitSchedule for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimitSchedule
func (c *StorageGateway) UpdateBandwidthRateLimitSchedule(input *UpdateBandwidthRateLimitScheduleInput) (*UpdateBandwidthRateLimitScheduleOutput, error) {
	req, out := c.UpdateBandwidthRateLimitScheduleRequest(input)
	return out, req.Send()
}

// UpdateBandwidthRateLimitScheduleWithContext is the same as UpdateBandwidthRateLimitSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBandwidthRateLimitSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateBandwidthRateLimitScheduleWithContext(ctx aws.Context, input *UpdateBandwidthRateLimitScheduleInput, opts ...request.Option) (*UpdateBandwidthRateLimitScheduleOutput, error) {
	req, out := c.UpdateBandwidthRateLimitScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChapCredentials = "UpdateChapCredentials"

// UpdateChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChapCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChapCredentials for more information on using the UpdateChapCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChapCredentialsRequest method.
//    req, resp := client.UpdateChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentials
func (c *StorageGateway) UpdateChapCredentialsRequest(input *UpdateChapCredentialsInput) (req *request.Request, output *UpdateChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opUpdateChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateChapCredentialsInput{}
	}

	output = &UpdateChapCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChapCredentials API operation for AWS Storage Gateway.
//
// Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials
// for a specified iSCSI target. By default, a gateway does not have CHAP enabled;
// however, for added security, you might use it. This operation is supported
// in the volume and tape gateway types.
//
// When you update CHAP credentials, all existing connections on the target
// are closed and initiators must reconnect with the new credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateChapCredentials for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentials
func (c *StorageGateway) UpdateChapCredentials(input *UpdateChapCredentialsInput) (*UpdateChapCredentialsOutput, error) {
	req, out := c.UpdateChapCredentialsRequest(input)
	return out, req.Send()
}

// UpdateChapCredentialsWithContext is the same as UpdateChapCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChapCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateChapCredentialsWithContext(ctx aws.Context, input *UpdateChapCredentialsInput, opts ...request.Option) (*UpdateChapCredentialsOutput, error) {
	req, out := c.UpdateChapCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewayInformation = "UpdateGatewayInformation"

// UpdateGatewayInformationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayInformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGatewayInformation for more information on using the UpdateGatewayInformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewayInformationRequest method.
//    req, resp := client.UpdateGatewayInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformation
func (c *StorageGateway) UpdateGatewayInformationRequest(input *UpdateGatewayInformationInput) (req *request.Request, output *UpdateGatewayInformationOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewayInformationInput{}
	}

	output = &UpdateGatewayInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGatewayInformation API operation for AWS Storage Gateway.
//
// Updates a gateway's metadata, which includes the gateway's name and time
// zone. To specify which gateway to update, use the Amazon Resource Name (ARN)
// of the gateway in your request.
//
// For gateways activated after September 2, 2015, the gateway's ARN contains
// the gateway ID rather than the gateway name. However, changing the name of
// the gateway has no effect on the gateway's ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateGatewayInformation for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformation
func (c *StorageGateway) UpdateGatewayInformation(input *UpdateGatewayInformationInput) (*UpdateGatewayInformationOutput, error) {
	req, out := c.UpdateGatewayInformationRequest(input)
	return out, req.Send()
}

// UpdateGatewayInformationWithContext is the same as UpdateGatewayInformation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewayInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateGatewayInformationWithContext(ctx aws.Context, input *UpdateGatewayInformationInput, opts ...request.Option) (*UpdateGatewayInformationOutput, error) {
	req, out := c.UpdateGatewayInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewaySoftwareNow = "UpdateGatewaySoftwareNow"

// UpdateGatewaySoftwareNowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewaySoftwareNow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGatewaySoftwareNow for more information on using the UpdateGatewaySoftwareNow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewaySoftwareNowRequest method.
//    req, resp := client.UpdateGatewaySoftwareNowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNow
func (c *StorageGateway) UpdateGatewaySoftwareNowRequest(input *UpdateGatewaySoftwareNowInput) (req *request.Request, output *UpdateGatewaySoftwareNowOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewaySoftwareNow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewaySoftwareNowInput{}
	}

	output = &UpdateGatewaySoftwareNowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGatewaySoftwareNow API operation for AWS Storage Gateway.
//
// Updates the gateway virtual machine (VM) software. The request immediately
// triggers the software update.
//
// When you make this request, you get a 200 OK success response immediately.
// However, it might take some time for the update to complete. You can call
// DescribeGatewayInformation to verify the gateway is in the STATE_RUNNING
// state.
//
// A software update forces a system restart of your gateway. You can minimize
// the chance of any disruption to your applications by increasing your iSCSI
// Initiators' timeouts. For more information about increasing iSCSI Initiator
// timeouts for Windows and Linux, see Customizing your Windows iSCSI settings
// (https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings)
// and Customizing your Linux iSCSI settings (https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings),
// respectively.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateGatewaySoftwareNow for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNow
func (c *StorageGateway) UpdateGatewaySoftwareNow(input *UpdateGatewaySoftwareNowInput) (*UpdateGatewaySoftwareNowOutput, error) {
	req, out := c.UpdateGatewaySoftwareNowRequest(input)
	return out, req.Send()
}

// UpdateGatewaySoftwareNowWithContext is the same as UpdateGatewaySoftwareNow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewaySoftwareNow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateGatewaySoftwareNowWithContext(ctx aws.Context, input *UpdateGatewaySoftwareNowInput, opts ...request.Option) (*UpdateGatewaySoftwareNowOutput, error) {
	req, out := c.UpdateGatewaySoftwareNowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMaintenanceStartTime = "UpdateMaintenanceStartTime"

// UpdateMaintenanceStartTimeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceStartTime operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMaintenanceStartTime for more information on using the UpdateMaintenanceStartTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMaintenanceStartTimeRequest method.
//    req, resp := client.UpdateMaintenanceStartTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTime
func (c *StorageGateway) UpdateMaintenanceStartTimeRequest(input *UpdateMaintenanceStartTimeInput) (req *request.Request, output *UpdateMaintenanceStartTimeOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceStartTimeInput{}
	}

	output = &UpdateMaintenanceStartTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMaintenanceStartTime API operation for AWS Storage Gateway.
//
// Updates a gateway's weekly maintenance start time information, including
// day and time of the week. The maintenance time is the time in your gateway's
// time zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateMaintenanceStartTime for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTime
func (c *StorageGateway) UpdateMaintenanceStartTime(input *UpdateMaintenanceStartTimeInput) (*UpdateMaintenanceStartTimeOutput, error) {
	req, out := c.UpdateMaintenanceStartTimeRequest(input)
	return out, req.Send()
}

// UpdateMaintenanceStartTimeWithContext is the same as UpdateMaintenanceStartTime with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMaintenanceStartTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateMaintenanceStartTimeWithContext(ctx aws.Context, input *UpdateMaintenanceStartTimeInput, opts ...request.Option) (*UpdateMaintenanceStartTimeOutput, error) {
	req, out := c.UpdateMaintenanceStartTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNFSFileShare = "UpdateNFSFileShare"

// UpdateNFSFileShareRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNFSFileShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNFSFileShare for more information on using the UpdateNFSFileShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNFSFileShareRequest method.
//    req, resp := client.UpdateNFSFileShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShare
func (c *StorageGateway) UpdateNFSFileShareRequest(input *UpdateNFSFileShareInput) (req *request.Request, output *UpdateNFSFileShareOutput) {
	op := &request.Operation{
		Name:       opUpdateNFSFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNFSFileShareInput{}
	}

	output = &UpdateNFSFileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNFSFileShare API operation for AWS Storage Gateway.
//
// Updates a Network File System (NFS) file share. This operation is only supported
// in the file gateway type.
//
// To leave a file share field unchanged, set the corresponding input field
// to null.
//
// Updates the following file share settings:
//
//    * Default storage class for your S3 bucket
//
//    * Metadata defaults for your S3 bucket
//
//    * Allowed NFS clients for your file share
//
//    * Squash settings
//
//    * Write status of your file share
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateNFSFileShare for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShare
func (c *StorageGateway) UpdateNFSFileShare(input *UpdateNFSFileShareInput) (*UpdateNFSFileShareOutput, error) {
	req, out := c.UpdateNFSFileShareRequest(input)
	return out, req.Send()
}

// UpdateNFSFileShareWithContext is the same as UpdateNFSFileShare with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNFSFileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateNFSFileShareWithContext(ctx aws.Context, input *UpdateNFSFileShareInput, opts ...request.Option) (*UpdateNFSFileShareOutput, error) {
	req, out := c.UpdateNFSFileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSMBFileShare = "UpdateSMBFileShare"

// UpdateSMBFileShareRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSMBFileShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSMBFileShare for more information on using the UpdateSMBFileShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSMBFileShareRequest method.
//    req, resp := client.UpdateSMBFileShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShare
func (c *StorageGateway) UpdateSMBFileShareRequest(input *UpdateSMBFileShareInput) (req *request.Request, output *UpdateSMBFileShareOutput) {
	op := &request.Operation{
		Name:       opUpdateSMBFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSMBFileShareInput{}
	}

	output = &UpdateSMBFileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSMBFileShare API operation for AWS Storage Gateway.
//
// Updates a Server Message Block (SMB) file share. This operation is only supported
// for file gateways.
//
// To leave a file share field unchanged, set the corresponding input field
// to null.
//
// File gateways require AWS Security Token Service (AWS STS) to be activated
// to enable you to create a file share. Make sure that AWS STS is activated
// in the AWS Region you are creating your file gateway in. If AWS STS is not
// activated in this AWS Region, activate it. For information about how to activate
// AWS STS, see Activating and deactivating AWS STS in an AWS Region (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
// in the AWS Identity and Access Management User Guide.
//
// File gateways don't support creating hard or symbolic links on a file share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateSMBFileShare for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShare
func (c *StorageGateway) UpdateSMBFileShare(input *UpdateSMBFileShareInput) (*UpdateSMBFileShareOutput, error) {
	req, out := c.UpdateSMBFileShareRequest(input)
	return out, req.Send()
}

// UpdateSMBFileShareWithContext is the same as UpdateSMBFileShare with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSMBFileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateSMBFileShareWithContext(ctx aws.Context, input *UpdateSMBFileShareInput, opts ...request.Option) (*UpdateSMBFileShareOutput, error) {
	req, out := c.UpdateSMBFileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSMBFileShareVisibility = "UpdateSMBFileShareVisibility"

// UpdateSMBFileShareVisibilityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSMBFileShareVisibility operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSMBFileShareVisibility for more information on using the UpdateSMBFileShareVisibility
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSMBFileShareVisibilityRequest method.
//    req, resp := client.UpdateSMBFileShareVisibilityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShareVisibility
func (c *StorageGateway) UpdateSMBFileShareVisibilityRequest(input *UpdateSMBFileShareVisibilityInput) (req *request.Request, output *UpdateSMBFileShareVisibilityOutput) {
	op := &request.Operation{
		Name:       opUpdateSMBFileShareVisibility,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSMBFileShareVisibilityInput{}
	}

	output = &UpdateSMBFileShareVisibilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSMBFileShareVisibility API operation for AWS Storage Gateway.
//
// Controls whether the shares on a gateway are visible in a net view or browse
// list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateSMBFileShareVisibility for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBFileShareVisibility
func (c *StorageGateway) UpdateSMBFileShareVisibility(input *UpdateSMBFileShareVisibilityInput) (*UpdateSMBFileShareVisibilityOutput, error) {
	req, out := c.UpdateSMBFileShareVisibilityRequest(input)
	return out, req.Send()
}

// UpdateSMBFileShareVisibilityWithContext is the same as UpdateSMBFileShareVisibility with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSMBFileShareVisibility for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateSMBFileShareVisibilityWithContext(ctx aws.Context, input *UpdateSMBFileShareVisibilityInput, opts ...request.Option) (*UpdateSMBFileShareVisibilityOutput, error) {
	req, out := c.UpdateSMBFileShareVisibilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSMBSecurityStrategy = "UpdateSMBSecurityStrategy"

// UpdateSMBSecurityStrategyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSMBSecurityStrategy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSMBSecurityStrategy for more information on using the UpdateSMBSecurityStrategy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSMBSecurityStrategyRequest method.
//    req, resp := client.UpdateSMBSecurityStrategyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBSecurityStrategy
func (c *StorageGateway) UpdateSMBSecurityStrategyRequest(input *UpdateSMBSecurityStrategyInput) (req *request.Request, output *UpdateSMBSecurityStrategyOutput) {
	op := &request.Operation{
		Name:       opUpdateSMBSecurityStrategy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSMBSecurityStrategyInput{}
	}

	output = &UpdateSMBSecurityStrategyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSMBSecurityStrategy API operation for AWS Storage Gateway.
//
// Updates the SMB security strategy on a file gateway. This action is only
// supported in file gateways.
//
// This API is called Security level in the User Guide.
//
// A higher security level can affect performance of the gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateSMBSecurityStrategy for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSMBSecurityStrategy
func (c *StorageGateway) UpdateSMBSecurityStrategy(input *UpdateSMBSecurityStrategyInput) (*UpdateSMBSecurityStrategyOutput, error) {
	req, out := c.UpdateSMBSecurityStrategyRequest(input)
	return out, req.Send()
}

// UpdateSMBSecurityStrategyWithContext is the same as UpdateSMBSecurityStrategy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSMBSecurityStrategy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateSMBSecurityStrategyWithContext(ctx aws.Context, input *UpdateSMBSecurityStrategyInput, opts ...request.Option) (*UpdateSMBSecurityStrategyOutput, error) {
	req, out := c.UpdateSMBSecurityStrategyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSnapshotSchedule = "UpdateSnapshotSchedule"

// UpdateSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSnapshotSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSnapshotSchedule for more information on using the UpdateSnapshotSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSnapshotScheduleRequest method.
//    req, resp := client.UpdateSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotSchedule
func (c *StorageGateway) UpdateSnapshotScheduleRequest(input *UpdateSnapshotScheduleInput) (req *request.Request, output *UpdateSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSnapshotScheduleInput{}
	}

	output = &UpdateSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSnapshotSchedule API operation for AWS Storage Gateway.
//
// Updates a snapshot schedule configured for a gateway volume. This operation
// is only supported in the cached volume and stored volume gateway types.
//
// The default snapshot schedule for volume is once every 24 hours, starting
// at the creation time of the volume. You can use this API to change the snapshot
// schedule configured for the volume.
//
// In the request you must identify the gateway volume whose snapshot schedule
// you want to update, and the schedule information, including when you want
// the snapshot to begin on a day and the frequency (in hours) of snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateSnapshotSchedule for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotSchedule
func (c *StorageGateway) UpdateSnapshotSchedule(input *UpdateSnapshotScheduleInput) (*UpdateSnapshotScheduleOutput, error) {
	req, out := c.UpdateSnapshotScheduleRequest(input)
	return out, req.Send()
}

// UpdateSnapshotScheduleWithContext is the same as UpdateSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateSnapshotScheduleWithContext(ctx aws.Context, input *UpdateSnapshotScheduleInput, opts ...request.Option) (*UpdateSnapshotScheduleOutput, error) {
	req, out := c.UpdateSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVTLDeviceType = "UpdateVTLDeviceType"

// UpdateVTLDeviceTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVTLDeviceType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVTLDeviceType for more information on using the UpdateVTLDeviceType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVTLDeviceTypeRequest method.
//    req, resp := client.UpdateVTLDeviceTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceType
func (c *StorageGateway) UpdateVTLDeviceTypeRequest(input *UpdateVTLDeviceTypeInput) (req *request.Request, output *UpdateVTLDeviceTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateVTLDeviceType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVTLDeviceTypeInput{}
	}

	output = &UpdateVTLDeviceTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVTLDeviceType API operation for AWS Storage Gateway.
//
// Updates the type of medium changer in a tape gateway. When you activate a
// tape gateway, you select a medium changer type for the tape gateway. This
// operation enables you to select a different type of medium changer after
// a tape gateway is activated. This operation is only supported in the tape
// gateway type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateVTLDeviceType for usage and error information.
//
// Returned Error Types:
//   * InvalidGatewayRequestException
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * InternalServerError
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceType
func (c *StorageGateway) UpdateVTLDeviceType(input *UpdateVTLDeviceTypeInput) (*UpdateVTLDeviceTypeOutput, error) {
	req, out := c.UpdateVTLDeviceTypeRequest(input)
	return out, req.Send()
}

// UpdateVTLDeviceTypeWithContext is the same as UpdateVTLDeviceType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVTLDeviceType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateVTLDeviceTypeWithContext(ctx aws.Context, input *UpdateVTLDeviceTypeInput, opts ...request.Option) (*UpdateVTLDeviceTypeOutput, error) {
	req, out := c.UpdateVTLDeviceTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A JSON object containing one or more of the following fields:
//
//    * ActivateGatewayInput$ActivationKey
//
//    * ActivateGatewayInput$GatewayName
//
//    * ActivateGatewayInput$GatewayRegion
//
//    * ActivateGatewayInput$GatewayTimezone
//
//    * ActivateGatewayInput$GatewayType
//
//    * ActivateGatewayInput$MediumChangerType
//
//    * ActivateGatewayInput$TapeDriveType
type ActivateGatewayInput struct {
	_ struct{} `type:"structure"`

	// Your gateway activation key. You can obtain the activation key by sending
	// an HTTP GET request with redirects enabled to the gateway IP address (port
	// 80). The redirect URL returned in the response provides you the activation
	// key for your gateway in the query string parameter activationKey. It may
	// also include other activation-related parameters, however, these are merely
	// defaults -- the arguments you pass to the ActivateGateway API call determine
	// the actual configuration of your gateway.
	//
	// For more information, see Getting activation key (https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html)
	// in the AWS Storage Gateway User Guide.
	//
	// ActivationKey is a required field
	ActivationKey *string `min:"1" type:"string" required:"true"`

	// The name you configured for your gateway.
	//
	// GatewayName is a required field
	GatewayName *string `min:"2" type:"string" required:"true"`

	// A value that indicates the AWS Region where you want to store your data.
	// The gateway AWS Region specified must be the same AWS Region as the AWS Region
	// in your Host header in the request. For more information about available
	// AWS Regions and endpoints for AWS Storage Gateway, see AWS Storage Gateway
	// endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/sg.html)
	// in the AWS General Reference.
	//
	// Valid Values: See AWS Storage Gateway endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/sg.html)
	// in the AWS General Reference.
	//
	// GatewayRegion is a required field
	GatewayRegion *string `min:"1" type:"string" required:"true"`

	// A value that indicates the time zone you want to set for the gateway. The
	// time zone is of the format "GMT-hr:mm" or "GMT+hr:mm". For example, GMT-4:00
	// indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is
	// 2 hours ahead of GMT. The time zone is used, for example, for scheduling
	// snapshots and your gateway's maintenance schedule.
	//
	// GatewayTimezone is a required field
	GatewayTimezone *string `min:"3" type:"string" required:"true"`

	// A value that defines the type of gateway to activate. The type specified
	// is critical to all later functions of the gateway and cannot be changed after
	// activation. The default value is CACHED.
	//
	// Valid Values: STORED | CACHED | VTL | FILE_S3
	GatewayType *string `min:"2" type:"string"`

	// The value that indicates the type of medium changer to use for tape gateway.
	// This field is optional.
	//
	// Valid Values: STK-L700 | AWS-Gateway-VTL | IBM-03584L32-0402
	MediumChangerType *string `min:"2" type:"string"`

	// A list of up to 50 tags that you can assign to the gateway. Each tag is a
	// key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers that
	// can be represented in UTF-8 format, and the following special characters:
	// + - = . _ : / @. The maximum length of a tag's key is 128 characters, and
	// the maximum length for a tag's value is 256 characters.
	Tags []*Tag `type:"list"`

	// The value that indicates the type of tape drive to use for tape gateway.
	// This field is optional.
	//
	// Valid Values: IBM-ULT3580-TD5
	TapeDriveType *string `min:"2" type:"string"`
}

// String returns the string representation
func (s ActivateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateGatewayInput"}
	if s.ActivationKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationKey"))
	}
	if s.ActivationKey != nil && len(*s.ActivationKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivationKey", 1))
	}
	if s.GatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayName"))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 2))
	}
	if s.GatewayRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayRegion"))
	}
	if s.GatewayRegion != nil && len(*s.GatewayRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayRegion", 1))
	}
	if s.GatewayTimezone == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayTimezone"))
	}
	if s.GatewayTimezone != nil && len(*s.GatewayTimezone) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayTimezone", 3))
	}
	if s.GatewayType != nil && len(*s.GatewayType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayType", 2))
	}
	if s.MediumChangerType != nil && len(*s.MediumChangerType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MediumChangerType", 2))
	}
	if s.TapeDriveType != nil && len(*s.TapeDriveType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TapeDriveType", 2))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivationKey sets the ActivationKey field's value.
func (s *ActivateGatewayInput) SetActivationKey(v string) *ActivateGatewayInput {
	s.ActivationKey = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *ActivateGatewayInput) SetGatewayName(v string) *ActivateGatewayInput {
	s.GatewayName = &v
	return s
}

// SetGatewayRegion sets the GatewayRegion field's value.
func (s *ActivateGatewayInput) SetGatewayRegion(v string) *ActivateGatewayInput {
	s.GatewayRegion = &v
	return s
}

// SetGatewayTimezone sets the GatewayTimezone field's value.
func (s *ActivateGatewayInput) SetGatewayTimezone(v string) *ActivateGatewayInput {
	s.GatewayTimezone = &v
	return s
}

// SetGatewayType sets the GatewayType field's value.
func (s *ActivateGatewayInput) SetGatewayType(v string) *ActivateGatewayInput {
	s.GatewayType = &v
	return s
}

// SetMediumChangerType sets the MediumChangerType field's value.
func (s *ActivateGatewayInput) SetMediumChangerType(v string) *ActivateGatewayInput {
	s.MediumChangerType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ActivateGatewayInput) SetTags(v []*Tag) *ActivateGatewayInput {
	s.Tags = v
	return s
}

// SetTapeDriveType sets the TapeDriveType field's value.
func (s *ActivateGatewayInput) SetTapeDriveType(v string) *ActivateGatewayInput {
	s.TapeDriveType = &v
	return s
}

// AWS Storage Gateway returns the Amazon Resource Name (ARN) of the activated
// gateway. It is a string made of information such as your account, gateway
// name, and AWS Region. This ARN is used to reference the gateway in other
// API operations as well as resource-based authorization.
//
// For gateways activated prior to September 02, 2015, the gateway ARN contains
// the gateway name rather than the gateway ID. Changing the name of the gateway
// has no effect on the gateway ARN.
type ActivateGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ActivateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ActivateGatewayOutput) SetGatewayARN(v string) *ActivateGatewayOutput {
	s.GatewayARN = &v
	return s
}

type AddCacheInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string has a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	//
	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCacheInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskIds sets the DiskIds field's value.
func (s *AddCacheInput) SetDiskIds(v []*string) *AddCacheInput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddCacheInput) SetGatewayARN(v string) *AddCacheInput {
	s.GatewayARN = &v
	return s
}

type AddCacheOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCacheOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddCacheOutput) SetGatewayARN(v string) *AddCacheOutput {
	s.GatewayARN = &v
	return s
}

// AddTagsToResourceInput
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to add tags to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`

	// The key-value pair that represents the tag you want to add to the resource.
	// The value can be an empty string.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *AddTagsToResourceInput) SetResourceARN(v string) *AddTagsToResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

// AddTagsToResourceOutput
type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to add tags to.
	ResourceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *AddTagsToResourceOutput) SetResourceARN(v string) *AddTagsToResourceOutput {
	s.ResourceARN = &v
	return s
}

type AddUploadBufferInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string has a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	//
	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUploadBufferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddUploadBufferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddUploadBufferInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskIds sets the DiskIds field's value.
func (s *AddUploadBufferInput) SetDiskIds(v []*string) *AddUploadBufferInput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddUploadBufferInput) SetGatewayARN(v string) *AddUploadBufferInput {
	s.GatewayARN = &v
	return s
}

type AddUploadBufferOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUploadBufferOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddUploadBufferOutput) SetGatewayARN(v string) *AddUploadBufferOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * AddWorkingStorageInput$DiskIds
type AddWorkingStorageInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string has a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	//
	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddWorkingStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddWorkingStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddWorkingStorageInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskIds sets the DiskIds field's value.
func (s *AddWorkingStorageInput) SetDiskIds(v []*string) *AddWorkingStorageInput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddWorkingStorageInput) SetGatewayARN(v string) *AddWorkingStorageInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway for
// which working storage was configured.
type AddWorkingStorageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddWorkingStorageOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddWorkingStorageOutput) SetGatewayARN(v string) *AddWorkingStorageOutput {
	s.GatewayARN = &v
	return s
}

type AssignTapePoolInput struct {
	_ struct{} `type:"structure"`

	// Set permissions to bypass governance retention. If the lock type of the archived
	// tape is Governance, the tape's archived age is not older than RetentionLockInDays,
	// and the user does not already have BypassGovernanceRetention, setting this
	// to TRUE enables the user to bypass the retention lock. This parameter is
	// set to true by default for calls from the console.
	//
	// Valid values: TRUE | FALSE
	BypassGovernanceRetention *bool `type:"boolean"`

	// The ID of the pool that you want to add your tape to for archiving. The tape
	// in this pool is archived in the S3 storage class that is associated with
	// the pool. When you use your backup application to eject the tape, the tape
	// is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
	// Archive) that corresponds to the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	//
	// PoolId is a required field
	PoolId *string `min:"1" type:"string" required:"true"`

	// The unique Amazon Resource Name (ARN) of the virtual tape that you want to
	// add to the tape pool.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AssignTapePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignTapePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssignTapePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssignTapePoolInput"}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassGovernanceRetention sets the BypassGovernanceRetention field's value.
func (s *AssignTapePoolInput) SetBypassGovernanceRetention(v bool) *AssignTapePoolInput {
	s.BypassGovernanceRetention = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *AssignTapePoolInput) SetPoolId(v string) *AssignTapePoolInput {
	s.PoolId = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *AssignTapePoolInput) SetTapeARN(v string) *AssignTapePoolInput {
	s.TapeARN = &v
	return s
}

type AssignTapePoolOutput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Names (ARN) of the virtual tape that was added
	// to the tape pool.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AssignTapePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignTapePoolOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *AssignTapePoolOutput) SetTapeARN(v string) *AssignTapePoolOutput {
	s.TapeARN = &v
	return s
}

// AttachVolumeInput
type AttachVolumeInput struct {
	_ struct{} `type:"structure"`

	// The unique device ID or other distinguishing data that identifies the local
	// disk used to create the volume. This value is only required when you are
	// attaching a stored volume.
	DiskId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the gateway that you want to attach the
	// volume to.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The network interface of the gateway on which to expose the iSCSI target.
	// Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a
	// list of the network interfaces available on a gateway.
	//
	// Valid Values: A valid IP address.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `type:"string" required:"true"`

	// The name of the iSCSI target used by an initiator to connect to a volume
	// and used as a suffix for the target ARN. For example, specifying TargetName
	// as myvolume results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
	// The target name must be unique across all volumes on a gateway.
	//
	// If you don't specify a value, Storage Gateway uses the value that was previously
	// used for this volume as the new target name.
	TargetName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachVolumeInput"}
	if s.DiskId != nil && len(*s.DiskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiskId", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}
	if s.TargetName != nil && len(*s.TargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetName", 1))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskId sets the DiskId field's value.
func (s *AttachVolumeInput) SetDiskId(v string) *AttachVolumeInput {
	s.DiskId = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AttachVolumeInput) SetGatewayARN(v string) *AttachVolumeInput {
	s.GatewayARN = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AttachVolumeInput) SetNetworkInterfaceId(v string) *AttachVolumeInput {
	s.NetworkInterfaceId = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *AttachVolumeInput) SetTargetName(v string) *AttachVolumeInput {
	s.TargetName = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *AttachVolumeInput) SetVolumeARN(v string) *AttachVolumeInput {
	s.VolumeARN = &v
	return s
}

// AttachVolumeOutput
type AttachVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI
	// name for the initiator that was used to connect to the target.
	TargetARN *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of the volume that was attached to the gateway.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AttachVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachVolumeOutput) GoString() string {
	return s.String()
}

// SetTargetARN sets the TargetARN field's value.
func (s *AttachVolumeOutput) SetTargetARN(v string) *AttachVolumeOutput {
	s.TargetARN = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *AttachVolumeOutput) SetVolumeARN(v string) *AttachVolumeOutput {
	s.VolumeARN = &v
	return s
}

// Information about the gateway's automatic tape creation policies, including
// the automatic tape creation rules and the gateway that is using the policies.
type AutomaticTapeCreationPolicyInfo struct {
	_ struct{} `type:"structure"`

	// An automatic tape creation policy consists of a list of automatic tape creation
	// rules. This returns the rules that determine when and how to automatically
	// create new tapes.
	AutomaticTapeCreationRules []*AutomaticTapeCreationRule `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AutomaticTapeCreationPolicyInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomaticTapeCreationPolicyInfo) GoString() string {
	return s.String()
}

// SetAutomaticTapeCreationRules sets the AutomaticTapeCreationRules field's value.
func (s *AutomaticTapeCreationPolicyInfo) SetAutomaticTapeCreationRules(v []*AutomaticTapeCreationRule) *AutomaticTapeCreationPolicyInfo {
	s.AutomaticTapeCreationRules = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AutomaticTapeCreationPolicyInfo) SetGatewayARN(v string) *AutomaticTapeCreationPolicyInfo {
	s.GatewayARN = &v
	return s
}

// An automatic tape creation policy consists of automatic tape creation rules
// where each rule defines when and how to create new tapes. For more information
// about automatic tape creation, see Creating Tapes Automatically (https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically).
type AutomaticTapeCreationRule struct {
	_ struct{} `type:"structure"`

	// The minimum number of available virtual tapes that the gateway maintains
	// at all times. If the number of tapes on the gateway goes below this value,
	// the gateway creates as many new tapes as are needed to have MinimumNumTapes
	// on the gateway. For more information about automatic tape creation, see Creating
	// Tapes Automatically (https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateTapes.html#CreateTapesAutomatically).
	//
	// MinimumNumTapes is a required field
	MinimumNumTapes *int64 `min:"1" type:"integer" required:"true"`

	// The ID of the pool that you want to add your tape to for archiving. The tape
	// in this pool is archived in the Amazon S3 storage class that is associated
	// with the pool. When you use your backup application to eject the tape, the
	// tape is archived directly into the storage class (S3 Glacier or S3 Glacier
	// Deep Archive) that corresponds to the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	//
	// PoolId is a required field
	PoolId *string `min:"1" type:"string" required:"true"`

	// A prefix that you append to the barcode of the virtual tape that you are
	// creating. This prefix makes the barcode unique.
	//
	// The prefix must be 1-4 characters in length and must be one of the uppercase
	// letters from A to Z.
	//
	// TapeBarcodePrefix is a required field
	TapeBarcodePrefix *string `min:"1" type:"string" required:"true"`

	// The size, in bytes, of the virtual tape capacity.
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`

	// Set to true to indicate that tapes are to be archived as write-once-read-many
	// (WORM). Set to false when WORM is not enabled for tapes.
	Worm *bool `type:"boolean"`
}

// String returns the string representation
func (s AutomaticTapeCreationRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomaticTapeCreationRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomaticTapeCreationRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomaticTapeCreationRule"}
	if s.MinimumNumTapes == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumNumTapes"))
	}
	if s.MinimumNumTapes != nil && *s.MinimumNumTapes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumNumTapes", 1))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}
	if s.TapeBarcodePrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeBarcodePrefix"))
	}
	if s.TapeBarcodePrefix != nil && len(*s.TapeBarcodePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TapeBarcodePrefix", 1))
	}
	if s.TapeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeSizeInBytes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMinimumNumTapes sets the MinimumNumTapes field's value.
func (s *AutomaticTapeCreationRule) SetMinimumNumTapes(v int64) *AutomaticTapeCreationRule {
	s.MinimumNumTapes = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *AutomaticTapeCreationRule) SetPoolId(v string) *AutomaticTapeCreationRule {
	s.PoolId = &v
	return s
}

// SetTapeBarcodePrefix sets the TapeBarcodePrefix field's value.
func (s *AutomaticTapeCreationRule) SetTapeBarcodePrefix(v string) *AutomaticTapeCreationRule {
	s.TapeBarcodePrefix = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *AutomaticTapeCreationRule) SetTapeSizeInBytes(v int64) *AutomaticTapeCreationRule {
	s.TapeSizeInBytes = &v
	return s
}

// SetWorm sets the Worm field's value.
func (s *AutomaticTapeCreationRule) SetWorm(v bool) *AutomaticTapeCreationRule {
	s.Worm = &v
	return s
}

// Describes a bandwidth rate limit interval for a gateway. A bandwidth rate
// limit schedule consists of one or more bandwidth rate limit intervals. A
// bandwidth rate limit interval defines a period of time on one or more days
// of the week, during which bandwidth rate limits are specified for uploading,
// downloading, or both.
type BandwidthRateLimitInterval struct {
	_ struct{} `type:"structure"`

	// The average download rate limit component of the bandwidth rate limit interval,
	// in bits per second. This field does not appear in the response if the download
	// rate limit is not set.
	AverageDownloadRateLimitInBitsPerSec *int64 `min:"102400" type:"long"`

	// The average upload rate limit component of the bandwidth rate limit interval,
	// in bits per second. This field does not appear in the response if the upload
	// rate limit is not set.
	AverageUploadRateLimitInBitsPerSec *int64 `min:"51200" type:"long"`

	// The days of the week component of the bandwidth rate limit interval, represented
	// as ordinal numbers from 0 to 6, where 0 represents Sunday and 6 Saturday.
	//
	// DaysOfWeek is a required field
	DaysOfWeek []*int64 `min:"1" type:"list" required:"true"`

	// The hour of the day to end the bandwidth rate limit interval.
	//
	// EndHourOfDay is a required field
	EndHourOfDay *int64 `type:"integer" required:"true"`

	// The minute of the hour to end the bandwidth rate limit interval.
	//
	// The bandwidth rate limit interval ends at the end of the minute. To end an
	// interval at the end of an hour, use the value 59.
	//
	// EndMinuteOfHour is a required field
	EndMinuteOfHour *int64 `type:"integer" required:"true"`

	// The hour of the day to start the bandwidth rate limit interval.
	//
	// StartHourOfDay is a required field
	StartHourOfDay *int64 `type:"integer" required:"true"`

	// The minute of the hour to start the bandwidth rate limit interval. The interval
	// begins at the start of that minute. To begin an interval exactly at the start
	// of the hour, use the value 0.
	//
	// StartMinuteOfHour is a required field
	StartMinuteOfHour *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s BandwidthRateLimitInterval) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthRateLimitInterval) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BandwidthRateLimitInterval) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BandwidthRateLimitInterval"}
	if s.AverageDownloadRateLimitInBitsPerSec != nil && *s.AverageDownloadRateLimitInBitsPerSec < 102400 {
		invalidParams.Add(request.NewErrParamMinValue("AverageDownloadRateLimitInBitsPerSec", 102400))
	}
	if s.AverageUploadRateLimitInBitsPerSec != nil && *s.AverageUploadRateLimitInBitsPerSec < 51200 {
		invalidParams.Add(request.NewErrParamMinValue("AverageUploadRateLimitInBitsPerSec", 51200))
	}
	if s.DaysOfWeek == nil {
		invalidParams.Add(request.NewErrParamRequired("DaysOfWeek"))
	}
	if s.DaysOfWeek != nil && len(s.DaysOfWeek) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DaysOfWeek", 1))
	}
	if s.EndHourOfDay == nil {
		invalidParams.Add(request.NewErrParamRequired("EndHourOfDay"))
	}
	if s.EndMinuteOfHour == nil {
		invalidParams.Add(request.NewErrParamRequired("EndMinuteOfHour"))
	}
	if s.StartHourOfDay == nil {
		invalidParams.Add(request.NewErrParamRequired("StartHourOfDay"))
	}
	if s.StartMinuteOfHour == nil {
		invalidParams.Add(request.NewErrParamRequired("StartMinuteOfHour"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAverageDownloadRateLimitInBitsPerSec sets the AverageDownloadRateLimitInBitsPerSec field's value.
func (s *BandwidthRateLimitInterval) SetAverageDownloadRateLimitInBitsPerSec(v int64) *BandwidthRateLimitInterval {
	s.AverageDownloadRateLimitInBitsPerSec = &v
	return s
}

// SetAverageUploadRateLimitInBitsPerSec sets the AverageUploadRateLimitInBitsPerSec field's value.
func (s *BandwidthRateLimitInterval) SetAverageUploadRateLimitInBitsPerSec(v int64) *BandwidthRateLimitInterval {
	s.AverageUploadRateLimitInBitsPerSec = &v
	return s
}

// SetDaysOfWeek sets the DaysOfWeek field's value.
func (s *BandwidthRateLimitInterval) SetDaysOfWeek(v []*int64) *BandwidthRateLimitInterval {
	s.DaysOfWeek = v
	return s
}

// SetEndHourOfDay sets the EndHourOfDay field's value.
func (s *BandwidthRateLimitInterval) SetEndHourOfDay(v int64) *BandwidthRateLimitInterval {
	s.EndHourOfDay = &v
	return s
}

// SetEndMinuteOfHour sets the EndMinuteOfHour field's value.
func (s *BandwidthRateLimitInterval) SetEndMinuteOfHour(v int64) *BandwidthRateLimitInterval {
	s.EndMinuteOfHour = &v
	return s
}

// SetStartHourOfDay sets the StartHourOfDay field's value.
func (s *BandwidthRateLimitInterval) SetStartHourOfDay(v int64) *BandwidthRateLimitInterval {
	s.StartHourOfDay = &v
	return s
}

// SetStartMinuteOfHour sets the StartMinuteOfHour field's value.
func (s *BandwidthRateLimitInterval) SetStartMinuteOfHour(v int64) *BandwidthRateLimitInterval {
	s.StartMinuteOfHour = &v
	return s
}

// Lists refresh cache information.
type CacheAttributes struct {
	_ struct{} `type:"structure"`

	// Refreshes a file share's cache by using Time To Live (TTL). TTL is the length
	// of time since the last refresh after which access to the directory would
	// cause the file gateway to first refresh that directory's contents from the
	// Amazon S3 bucket. The TTL duration is in seconds.
	//
	// Valid Values: 300 to 2,592,000 seconds (5 minutes to 30 days)
	CacheStaleTimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CacheAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheAttributes) GoString() string {
	return s.String()
}

// SetCacheStaleTimeoutInSeconds sets the CacheStaleTimeoutInSeconds field's value.
func (s *CacheAttributes) SetCacheStaleTimeoutInSeconds(v int64) *CacheAttributes {
	s.CacheStaleTimeoutInSeconds = &v
	return s
}

// Describes an iSCSI cached volume.
type CachediSCSIVolume struct {
	_ struct{} `type:"structure"`

	// The date the volume was created. Volumes created prior to March 28, 2017
	// don’t have this timestamp.
	CreatedDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// If the cached volume was created from a snapshot, this field contains the
	// snapshot ID used, e.g., snap-78e22663. Otherwise, this field is not included.
	SourceSnapshotId *string `type:"string"`

	// The name of the iSCSI target used by an initiator to connect to a volume
	// and used as a suffix for the target ARN. For example, specifying TargetName
	// as myvolume results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
	// The target name must be unique across all volumes on a gateway.
	//
	// If you don't specify a value, Storage Gateway uses the value that was previously
	// used for this volume as the new target name.
	TargetName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the storage volume.
	VolumeARN *string `min:"50" type:"string"`

	// A value that indicates whether a storage volume is attached to or detached
	// from a gateway. For more information, see Moving your volumes to a different
	// gateway (https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume).
	VolumeAttachmentStatus *string `min:"3" type:"string"`

	// The unique identifier of the volume, e.g., vol-AE4B946D.
	VolumeId *string `min:"12" type:"string"`

	// Represents the percentage complete if the volume is restoring or bootstrapping
	// that represents the percent of data transferred. This field does not appear
	// in the response if the cached volume is not restoring or bootstrapping.
	VolumeProgress *float64 `type:"double"`

	// The size, in bytes, of the volume capacity.
	VolumeSizeInBytes *int64 `type:"long"`

	// One of the VolumeStatus values that indicates the state of the storage volume.
	VolumeStatus *string `min:"3" type:"string"`

	// One of the VolumeType enumeration values that describes the type of the volume.
	VolumeType *string `min:"3" type:"string"`

	// The size of the data stored on the volume in bytes. This value is calculated
	// based on the number of blocks that are touched, instead of the actual amount
	// of data written. This value can be useful for sequential write patterns but
	// less accurate for random write patterns. VolumeUsedInBytes is different from
	// the compressed size of the volume, which is the value that is used to calculate
	// your bill.
	//
	// This value is not available for volumes created prior to May 13, 2015, until
	// you store data on the volume.
	VolumeUsedInBytes *int64 `type:"long"`

	// An VolumeiSCSIAttributes object that represents a collection of iSCSI attributes
	// for one stored volume.
	VolumeiSCSIAttributes *VolumeiSCSIAttributes `type:"structure"`
}

// String returns the string representation
func (s CachediSCSIVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachediSCSIVolume) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CachediSCSIVolume) SetCreatedDate(v time.Time) *CachediSCSIVolume {
	s.CreatedDate = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *CachediSCSIVolume) SetKMSKey(v string) *CachediSCSIVolume {
	s.KMSKey = &v
	return s
}

// SetSourceSnapshotId sets the SourceSnapshotId field's value.
func (s *CachediSCSIVolume) SetSourceSnapshotId(v string) *CachediSCSIVolume {
	s.SourceSnapshotId = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *CachediSCSIVolume) SetTargetName(v string) *CachediSCSIVolume {
	s.TargetName = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CachediSCSIVolume) SetVolumeARN(v string) *CachediSCSIVolume {
	s.VolumeARN = &v
	return s
}

// SetVolumeAttachmentStatus sets the VolumeAttachmentStatus field's value.
func (s *CachediSCSIVolume) SetVolumeAttachmentStatus(v string) *CachediSCSIVolume {
	s.VolumeAttachmentStatus = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *CachediSCSIVolume) SetVolumeId(v string) *CachediSCSIVolume {
	s.VolumeId = &v
	return s
}

// SetVolumeProgress sets the VolumeProgress field's value.
func (s *CachediSCSIVolume) SetVolumeProgress(v float64) *CachediSCSIVolume {
	s.VolumeProgress = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *CachediSCSIVolume) SetVolumeSizeInBytes(v int64) *CachediSCSIVolume {
	s.VolumeSizeInBytes = &v
	return s
}

// SetVolumeStatus sets the VolumeStatus field's value.
func (s *CachediSCSIVolume) SetVolumeStatus(v string) *CachediSCSIVolume {
	s.VolumeStatus = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *CachediSCSIVolume) SetVolumeType(v string) *CachediSCSIVolume {
	s.VolumeType = &v
	return s
}

// SetVolumeUsedInBytes sets the VolumeUsedInBytes field's value.
func (s *CachediSCSIVolume) SetVolumeUsedInBytes(v int64) *CachediSCSIVolume {
	s.VolumeUsedInBytes = &v
	return s
}

// SetVolumeiSCSIAttributes sets the VolumeiSCSIAttributes field's value.
func (s *CachediSCSIVolume) SetVolumeiSCSIAttributes(v *VolumeiSCSIAttributes) *CachediSCSIVolume {
	s.VolumeiSCSIAttributes = v
	return s
}

// CancelArchivalInput
type CancelArchivalInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving
	// for.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelArchivalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelArchivalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelArchivalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelArchivalInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CancelArchivalInput) SetGatewayARN(v string) *CancelArchivalInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *CancelArchivalInput) SetTapeARN(v string) *CancelArchivalInput {
	s.TapeARN = &v
	return s
}

// CancelArchivalOutput
type CancelArchivalOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which archiving was
	// canceled.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CancelArchivalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelArchivalOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *CancelArchivalOutput) SetTapeARN(v string) *CancelArchivalOutput {
	s.TapeARN = &v
	return s
}

// CancelRetrievalInput
type CancelRetrievalInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval
	// for.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelRetrievalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRetrievalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelRetrievalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelRetrievalInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CancelRetrievalInput) SetGatewayARN(v string) *CancelRetrievalInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *CancelRetrievalInput) SetTapeARN(v string) *CancelRetrievalInput {
	s.TapeARN = &v
	return s
}

// CancelRetrievalOutput
type CancelRetrievalOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which retrieval was
	// canceled.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CancelRetrievalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRetrievalOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *CancelRetrievalOutput) SetTapeARN(v string) *CancelRetrievalOutput {
	s.TapeARN = &v
	return s
}

// Describes Challenge-Handshake Authentication Protocol (CHAP) information
// that supports authentication between your gateway and iSCSI initiators.
type ChapInfo struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	InitiatorName *string `min:"1" type:"string"`

	// The secret key that the initiator (for example, the Windows client) must
	// provide to participate in mutual CHAP with the target.
	SecretToAuthenticateInitiator *string `min:"1" type:"string" sensitive:"true"`

	// The secret key that the target must provide to participate in mutual CHAP
	// with the initiator (e.g., Windows client).
	SecretToAuthenticateTarget *string `min:"1" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the volume.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ChapInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChapInfo) GoString() string {
	return s.String()
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *ChapInfo) SetInitiatorName(v string) *ChapInfo {
	s.InitiatorName = &v
	return s
}

// SetSecretToAuthenticateInitiator sets the SecretToAuthenticateInitiator field's value.
func (s *ChapInfo) SetSecretToAuthenticateInitiator(v string) *ChapInfo {
	s.SecretToAuthenticateInitiator = &v
	return s
}

// SetSecretToAuthenticateTarget sets the SecretToAuthenticateTarget field's value.
func (s *ChapInfo) SetSecretToAuthenticateTarget(v string) *ChapInfo {
	s.SecretToAuthenticateTarget = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *ChapInfo) SetTargetARN(v string) *ChapInfo {
	s.TargetARN = &v
	return s
}

type CreateCachediSCSIVolumeInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you use to retry a request. If you retry a request,
	// use the same ClientToken you specified in the initial request.
	//
	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The network interface of the gateway on which to expose the iSCSI target.
	// Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a
	// list of the network interfaces available on a gateway.
	//
	// Valid Values: A valid IP address.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `type:"string" required:"true"`

	// The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the
	// new cached volume. Specify this field if you want to create the iSCSI storage
	// volume from a snapshot; otherwise, do not include this field. To list snapshots
	// for your account use DescribeSnapshots (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
	// in the Amazon Elastic Compute Cloud API Reference.
	SnapshotId *string `type:"string"`

	// The ARN for an existing volume. Specifying this ARN makes the new volume
	// into an exact copy of the specified existing volume's latest recovery point.
	// The VolumeSizeInBytes value for this new volume must be equal to or larger
	// than the size of the existing volume, in bytes.
	SourceVolumeARN *string `min:"50" type:"string"`

	// A list of up to 50 tags that you can assign to a cached volume. Each tag
	// is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers that
	// you can represent in UTF-8 format, and the following special characters:
	// + - = . _ : / @. The maximum length of a tag's key is 128 characters, and
	// the maximum length for a tag's value is 256 characters.
	Tags []*Tag `type:"list"`

	// The name of the iSCSI target used by an initiator to connect to a volume
	// and used as a suffix for the target ARN. For example, specifying TargetName
	// as myvolume results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
	// The target name must be unique across all volumes on a gateway.
	//
	// If you don't specify a value, Storage Gateway uses the value that was previously
	// used for this volume as the new target name.
	//
	// TargetName is a required field
	TargetName *string `min:"1" type:"string" required:"true"`

	// The size of the volume in bytes.
	//
	// VolumeSizeInBytes is a required field
	VolumeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateCachediSCSIVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachediSCSIVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCachediSCSIVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCachediSCSIVolumeInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 7))
	}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}
	if s.SourceVolumeARN != nil && len(*s.SourceVolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("SourceVolumeARN", 50))
	}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}
	if s.TargetName != nil && len(*s.TargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetName", 1))
	}
	if s.VolumeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSizeInBytes"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateCachediSCSIVolumeInput) SetClientToken(v string) *CreateCachediSCSIVolumeInput {
	s.ClientToken = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateCachediSCSIVolumeInput) SetGatewayARN(v string) *CreateCachediSCSIVolumeInput {
	s.GatewayARN = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *CreateCachediSCSIVolumeInput) SetKMSEncrypted(v bool) *CreateCachediSCSIVolumeInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *CreateCachediSCSIVolumeInput) SetKMSKey(v string) *CreateCachediSCSIVolumeInput {
	s.KMSKey = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *CreateCachediSCSIVolumeInput) SetNetworkInterfaceId(v string) *CreateCachediSCSIVolumeInput {
	s.NetworkInterfaceId = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateCachediSCSIVolumeInput) SetSnapshotId(v string) *CreateCachediSCSIVolumeInput {
	s.SnapshotId = &v
	return s
}

// SetSourceVolumeARN sets the SourceVolumeARN field's value.
func (s *CreateCachediSCSIVolumeInput) SetSourceVolumeARN(v string) *CreateCachediSCSIVolumeInput {
	s.SourceVolumeARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCachediSCSIVolumeInput) SetTags(v []*Tag) *CreateCachediSCSIVolumeInput {
	s.Tags = v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *CreateCachediSCSIVolumeInput) SetTargetName(v string) *CreateCachediSCSIVolumeInput {
	s.TargetName = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *CreateCachediSCSIVolumeInput) SetVolumeSizeInBytes(v int64) *CreateCachediSCSIVolumeInput {
	s.VolumeSizeInBytes = &v
	return s
}

type CreateCachediSCSIVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI
	// name that initiators can use to connect to the target.
	TargetARN *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of the configured volume.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateCachediSCSIVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachediSCSIVolumeOutput) GoString() string {
	return s.String()
}

// SetTargetARN sets the TargetARN field's value.
func (s *CreateCachediSCSIVolumeOutput) SetTargetARN(v string) *CreateCachediSCSIVolumeOutput {
	s.TargetARN = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateCachediSCSIVolumeOutput) SetVolumeARN(v string) *CreateCachediSCSIVolumeOutput {
	s.VolumeARN = &v
	return s
}

// CreateNFSFileShareInput
type CreateNFSFileShareInput struct {
	_ struct{} `type:"structure"`

	// Refresh cache information.
	CacheAttributes *CacheAttributes `type:"structure"`

	// The list of clients that are allowed to access the file gateway. The list
	// must contain either valid IP addresses or valid CIDR blocks.
	ClientList []*string `min:"1" type:"list"`

	// A unique string value that you supply that is used by file gateway to ensure
	// idempotent file share creation.
	//
	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The default storage class for objects put into an Amazon S3 bucket by the
	// file gateway. The default value is S3_INTELLIGENT_TIERING. Optional.
	//
	// Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
	DefaultStorageClass *string `min:"5" type:"string"`

	// The name of the file share. Optional.
	//
	// FileShareName must be set if an S3 prefix name is set in LocationARN.
	FileShareName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the file gateway on which you want to create
	// a file share.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// A value that enables guessing of the MIME type for uploaded objects based
	// on file extensions. Set this value to true to enable MIME type guessing,
	// otherwise set to false. The default value is true.
	//
	// Valid Values: true | false
	GuessMIMETypeEnabled *bool `type:"boolean"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The ARN of the backend storage used for storing file data. A prefix name
	// can be added to the S3 bucket name. It must end with a "/".
	//
	// LocationARN is a required field
	LocationARN *string `min:"16" type:"string" required:"true"`

	// File share default values. Optional.
	NFSFileShareDefaults *NFSFileShareDefaults `type:"structure"`

	// The notification policy of the file share.
	NotificationPolicy *string `min:"2" type:"string"`

	// A value that sets the access control list (ACL) permission for objects in
	// the S3 bucket that a file gateway puts objects into. The default value is
	// private.
	ObjectACL *string `type:"string" enum:"ObjectACL"`

	// A value that sets the write status of a file share. Set this value to true
	// to set the write status to read-only, otherwise set to false.
	//
	// Valid Values: true | false
	ReadOnly *bool `type:"boolean"`

	// A value that sets who pays the cost of the request and the cost associated
	// with data download from the S3 bucket. If this value is set to true, the
	// requester pays the costs; otherwise, the S3 bucket owner pays. However, the
	// S3 bucket owner always pays the cost of storing data.
	//
	// RequesterPays is a configuration for the S3 bucket that backs the file share,
	// so make sure that the configuration on the file share is the same as the
	// S3 bucket configuration.
	//
	// Valid Values: true | false
	RequesterPays *bool `type:"boolean"`

	// The ARN of the AWS Identity and Access Management (IAM) role that a file
	// gateway assumes when it accesses the underlying storage.
	//
	// Role is a required field
	Role *string `min:"20" type:"string" required:"true"`

	// A value that maps a user to anonymous user.
	//
	// Valid values are the following:
	//
	//    * RootSquash: Only root is mapped to anonymous user.
	//
	//    * NoSquash: No one is mapped to anonymous user.
	//
	//    * AllSquash: Everyone is mapped to anonymous user.
	Squash *string `min:"5" type:"string"`

	// A list of up to 50 tags that can be assigned to the NFS file share. Each
	// tag is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateNFSFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNFSFileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNFSFileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNFSFileShareInput"}
	if s.ClientList != nil && len(s.ClientList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientList", 1))
	}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.DefaultStorageClass != nil && len(*s.DefaultStorageClass) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultStorageClass", 5))
	}
	if s.FileShareName != nil && len(*s.FileShareName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareName", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 7))
	}
	if s.LocationARN == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationARN"))
	}
	if s.LocationARN != nil && len(*s.LocationARN) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("LocationARN", 16))
	}
	if s.NotificationPolicy != nil && len(*s.NotificationPolicy) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationPolicy", 2))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.Squash != nil && len(*s.Squash) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Squash", 5))
	}
	if s.NFSFileShareDefaults != nil {
		if err := s.NFSFileShareDefaults.Validate(); err != nil {
			invalidParams.AddNested("NFSFileShareDefaults", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheAttributes sets the CacheAttributes field's value.
func (s *CreateNFSFileShareInput) SetCacheAttributes(v *CacheAttributes) *CreateNFSFileShareInput {
	s.CacheAttributes = v
	return s
}

// SetClientList sets the ClientList field's value.
func (s *CreateNFSFileShareInput) SetClientList(v []*string) *CreateNFSFileShareInput {
	s.ClientList = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNFSFileShareInput) SetClientToken(v string) *CreateNFSFileShareInput {
	s.ClientToken = &v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *CreateNFSFileShareInput) SetDefaultStorageClass(v string) *CreateNFSFileShareInput {
	s.DefaultStorageClass = &v
	return s
}

// SetFileShareName sets the FileShareName field's value.
func (s *CreateNFSFileShareInput) SetFileShareName(v string) *CreateNFSFileShareInput {
	s.FileShareName = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateNFSFileShareInput) SetGatewayARN(v string) *CreateNFSFileShareInput {
	s.GatewayARN = &v
	return s
}

// SetGuessMIMETypeEnabled sets the GuessMIMETypeEnabled field's value.
func (s *CreateNFSFileShareInput) SetGuessMIMETypeEnabled(v bool) *CreateNFSFileShareInput {
	s.GuessMIMETypeEnabled = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *CreateNFSFileShareInput) SetKMSEncrypted(v bool) *CreateNFSFileShareInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *CreateNFSFileShareInput) SetKMSKey(v string) *CreateNFSFileShareInput {
	s.KMSKey = &v
	return s
}

// SetLocationARN sets the LocationARN field's value.
func (s *CreateNFSFileShareInput) SetLocationARN(v string) *CreateNFSFileShareInput {
	s.LocationARN = &v
	return s
}

// SetNFSFileShareDefaults sets the NFSFileShareDefaults field's value.
func (s *CreateNFSFileShareInput) SetNFSFileShareDefaults(v *NFSFileShareDefaults) *CreateNFSFileShareInput {
	s.NFSFileShareDefaults = v
	return s
}

// SetNotificationPolicy sets the NotificationPolicy field's value.
func (s *CreateNFSFileShareInput) SetNotificationPolicy(v string) *CreateNFSFileShareInput {
	s.NotificationPolicy = &v
	return s
}

// SetObjectACL sets the ObjectACL field's value.
func (s *CreateNFSFileShareInput) SetObjectACL(v string) *CreateNFSFileShareInput {
	s.ObjectACL = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *CreateNFSFileShareInput) SetReadOnly(v bool) *CreateNFSFileShareInput {
	s.ReadOnly = &v
	return s
}

// SetRequesterPays sets the RequesterPays field's value.
func (s *CreateNFSFileShareInput) SetRequesterPays(v bool) *CreateNFSFileShareInput {
	s.RequesterPays = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateNFSFileShareInput) SetRole(v string) *CreateNFSFileShareInput {
	s.Role = &v
	return s
}

// SetSquash sets the Squash field's value.
func (s *CreateNFSFileShareInput) SetSquash(v string) *CreateNFSFileShareInput {
	s.Squash = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNFSFileShareInput) SetTags(v []*Tag) *CreateNFSFileShareInput {
	s.Tags = v
	return s
}

// CreateNFSFileShareOutput
type CreateNFSFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the newly created file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateNFSFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNFSFileShareOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *CreateNFSFileShareOutput) SetFileShareARN(v string) *CreateNFSFileShareOutput {
	s.FileShareARN = &v
	return s
}

// CreateSMBFileShareInput
type CreateSMBFileShareInput struct {
	_ struct{} `type:"structure"`

	// The files and folders on this share will only be visible to users with read
	// access.
	AccessBasedEnumeration *bool `type:"boolean"`

	// A list of users or groups in the Active Directory that will be granted administrator
	// privileges on the file share. These users can do all file operations as the
	// super-user. Acceptable formats include: DOMAIN\User1, user1, @group1, and
	// @DOMAIN\group1.
	//
	// Use this option very carefully, because any user in this list can do anything
	// they like on the file share, regardless of file permissions.
	AdminUserList []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the storage used for the audit logs.
	AuditDestinationARN *string `type:"string"`

	// The authentication method that users use to access the file share. The default
	// is ActiveDirectory.
	//
	// Valid Values: ActiveDirectory | GuestAccess
	Authentication *string `min:"5" type:"string"`

	// Refresh cache information.
	CacheAttributes *CacheAttributes `type:"structure"`

	// The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
	// client determines the case sensitivity. For CaseSensitive, the gateway determines
	// the case sensitivity. The default value is ClientSpecified.
	CaseSensitivity *string `type:"string" enum:"CaseSensitivity"`

	// A unique string value that you supply that is used by file gateway to ensure
	// idempotent file share creation.
	//
	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The default storage class for objects put into an Amazon S3 bucket by the
	// file gateway. The default value is S3_INTELLIGENT_TIERING. Optional.
	//
	// Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
	DefaultStorageClass *string `min:"5" type:"string"`

	// The name of the file share. Optional.
	//
	// FileShareName must be set if an S3 prefix name is set in LocationARN.
	FileShareName *string `min:"1" type:"string"`

	// The ARN of the file gateway on which you want to create a file share.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// A value that enables guessing of the MIME type for uploaded objects based
	// on file extensions. Set this value to true to enable MIME type guessing,
	// otherwise set to false. The default value is true.
	//
	// Valid Values: true | false
	GuessMIMETypeEnabled *bool `type:"boolean"`

	// A list of users or groups in the Active Directory that are not allowed to
	// access the file share. A group must be prefixed with the @ character. Acceptable
	// formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only
	// be set if Authentication is set to ActiveDirectory.
	InvalidUserList []*string `type:"list"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The ARN of the backend storage used for storing file data. A prefix name
	// can be added to the S3 bucket name. It must end with a "/".
	//
	// LocationARN is a required field
	LocationARN *string `min:"16" type:"string" required:"true"`

	// The notification policy of the file share.
	NotificationPolicy *string `min:"2" type:"string"`

	// A value that sets the access control list (ACL) permission for objects in
	// the S3 bucket that a file gateway puts objects into. The default value is
	// private.
	ObjectACL *string `type:"string" enum:"ObjectACL"`

	// A value that sets the write status of a file share. Set this value to true
	// to set the write status to read-only, otherwise set to false.
	//
	// Valid Values: true | false
	ReadOnly *bool `type:"boolean"`

	// A value that sets who pays the cost of the request and the cost associated
	// with data download from the S3 bucket. If this value is set to true, the
	// requester pays the costs; otherwise, the S3 bucket owner pays. However, the
	// S3 bucket owner always pays the cost of storing data.
	//
	// RequesterPays is a configuration for the S3 bucket that backs the file share,
	// so make sure that the configuration on the file share is the same as the
	// S3 bucket configuration.
	//
	// Valid Values: true | false
	RequesterPays *bool `type:"boolean"`

	// The ARN of the AWS Identity and Access Management (IAM) role that a file
	// gateway assumes when it accesses the underlying storage.
	//
	// Role is a required field
	Role *string `min:"20" type:"string" required:"true"`

	// Set this value to true to enable access control list (ACL) on the SMB file
	// share. Set it to false to map file and directory permissions to the POSIX
	// permissions.
	//
	// For more information, see Using Microsoft Windows ACLs to control access
	// to an SMB file share (https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html)
	// in the AWS Storage Gateway User Guide.
	//
	// Valid Values: true | false
	SMBACLEnabled *bool `type:"boolean"`

	// A list of up to 50 tags that can be assigned to the NFS file share. Each
	// tag is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`

	// A list of users or groups in the Active Directory that are allowed to access
	// the file share. A group must be prefixed with the @ character. Acceptable
	// formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only
	// be set if Authentication is set to ActiveDirectory.
	ValidUserList []*string `type:"list"`
}

// String returns the string representation
func (s CreateSMBFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSMBFileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSMBFileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSMBFileShareInput"}
	if s.Authentication != nil && len(*s.Authentication) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Authentication", 5))
	}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.DefaultStorageClass != nil && len(*s.DefaultStorageClass) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultStorageClass", 5))
	}
	if s.FileShareName != nil && len(*s.FileShareName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareName", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 7))
	}
	if s.LocationARN == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationARN"))
	}
	if s.LocationARN != nil && len(*s.LocationARN) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("LocationARN", 16))
	}
	if s.NotificationPolicy != nil && len(*s.NotificationPolicy) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationPolicy", 2))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessBasedEnumeration sets the AccessBasedEnumeration field's value.
func (s *CreateSMBFileShareInput) SetAccessBasedEnumeration(v bool) *CreateSMBFileShareInput {
	s.AccessBasedEnumeration = &v
	return s
}

// SetAdminUserList sets the AdminUserList field's value.
func (s *CreateSMBFileShareInput) SetAdminUserList(v []*string) *CreateSMBFileShareInput {
	s.AdminUserList = v
	return s
}

// SetAuditDestinationARN sets the AuditDestinationARN field's value.
func (s *CreateSMBFileShareInput) SetAuditDestinationARN(v string) *CreateSMBFileShareInput {
	s.AuditDestinationARN = &v
	return s
}

// SetAuthentication sets the Authentication field's value.
func (s *CreateSMBFileShareInput) SetAuthentication(v string) *CreateSMBFileShareInput {
	s.Authentication = &v
	return s
}

// SetCacheAttributes sets the CacheAttributes field's value.
func (s *CreateSMBFileShareInput) SetCacheAttributes(v *CacheAttributes) *CreateSMBFileShareInput {
	s.CacheAttributes = v
	return s
}

// SetCaseSensitivity sets the CaseSensitivity field's value.
func (s *CreateSMBFileShareInput) SetCaseSensitivity(v string) *CreateSMBFileShareInput {
	s.CaseSensitivity = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSMBFileShareInput) SetClientToken(v string) *CreateSMBFileShareInput {
	s.ClientToken = &v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *CreateSMBFileShareInput) SetDefaultStorageClass(v string) *CreateSMBFileShareInput {
	s.DefaultStorageClass = &v
	return s
}

// SetFileShareName sets the FileShareName field's value.
func (s *CreateSMBFileShareInput) SetFileShareName(v string) *CreateSMBFileShareInput {
	s.FileShareName = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateSMBFileShareInput) SetGatewayARN(v string) *CreateSMBFileShareInput {
	s.GatewayARN = &v
	return s
}

// SetGuessMIMETypeEnabled sets the GuessMIMETypeEnabled field's value.
func (s *CreateSMBFileShareInput) SetGuessMIMETypeEnabled(v bool) *CreateSMBFileShareInput {
	s.GuessMIMETypeEnabled = &v
	return s
}

// SetInvalidUserList sets the InvalidUserList field's value.
func (s *CreateSMBFileShareInput) SetInvalidUserList(v []*string) *CreateSMBFileShareInput {
	s.InvalidUserList = v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *CreateSMBFileShareInput) SetKMSEncrypted(v bool) *CreateSMBFileShareInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *CreateSMBFileShareInput) SetKMSKey(v string) *CreateSMBFileShareInput {
	s.KMSKey = &v
	return s
}

// SetLocationARN sets the LocationARN field's value.
func (s *CreateSMBFileShareInput) SetLocationARN(v string) *CreateSMBFileShareInput {
	s.LocationARN = &v
	return s
}

// SetNotificationPolicy sets the NotificationPolicy field's value.
func (s *CreateSMBFileShareInput) SetNotificationPolicy(v string) *CreateSMBFileShareInput {
	s.NotificationPolicy = &v
	return s
}

// SetObjectACL sets the ObjectACL field's value.
func (s *CreateSMBFileShareInput) SetObjectACL(v string) *CreateSMBFileShareInput {
	s.ObjectACL = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *CreateSMBFileShareInput) SetReadOnly(v bool) *CreateSMBFileShareInput {
	s.ReadOnly = &v
	return s
}

// SetRequesterPays sets the RequesterPays field's value.
func (s *CreateSMBFileShareInput) SetRequesterPays(v bool) *CreateSMBFileShareInput {
	s.RequesterPays = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateSMBFileShareInput) SetRole(v string) *CreateSMBFileShareInput {
	s.Role = &v
	return s
}

// SetSMBACLEnabled sets the SMBACLEnabled field's value.
func (s *CreateSMBFileShareInput) SetSMBACLEnabled(v bool) *CreateSMBFileShareInput {
	s.SMBACLEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSMBFileShareInput) SetTags(v []*Tag) *CreateSMBFileShareInput {
	s.Tags = v
	return s
}

// SetValidUserList sets the ValidUserList field's value.
func (s *CreateSMBFileShareInput) SetValidUserList(v []*string) *CreateSMBFileShareInput {
	s.ValidUserList = v
	return s
}

// CreateSMBFileShareOutput
type CreateSMBFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the newly created file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateSMBFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSMBFileShareOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *CreateSMBFileShareOutput) SetFileShareARN(v string) *CreateSMBFileShareOutput {
	s.FileShareARN = &v
	return s
}

type CreateSnapshotFromVolumeRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// Textual description of the snapshot that appears in the Amazon EC2 console,
	// Elastic Block Store snapshots panel in the Description field, and in the
	// AWS Storage Gateway snapshot Details pane, Description field.
	//
	// SnapshotDescription is a required field
	SnapshotDescription *string `min:"1" type:"string" required:"true"`

	// A list of up to 50 tags that can be assigned to a snapshot. Each tag is a
	// key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotFromVolumeRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotFromVolumeRecoveryPointInput"}
	if s.SnapshotDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotDescription"))
	}
	if s.SnapshotDescription != nil && len(*s.SnapshotDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotDescription", 1))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotDescription sets the SnapshotDescription field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointInput) SetSnapshotDescription(v string) *CreateSnapshotFromVolumeRecoveryPointInput {
	s.SnapshotDescription = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointInput) SetTags(v []*Tag) *CreateSnapshotFromVolumeRecoveryPointInput {
	s.Tags = v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointInput) SetVolumeARN(v string) *CreateSnapshotFromVolumeRecoveryPointInput {
	s.VolumeARN = &v
	return s
}

type CreateSnapshotFromVolumeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the snapshot.
	SnapshotId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	VolumeARN *string `min:"50" type:"string"`

	// The time the volume was created from the recovery point.
	VolumeRecoveryPointTime *string `type:"string"`
}

// String returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointOutput) SetSnapshotId(v string) *CreateSnapshotFromVolumeRecoveryPointOutput {
	s.SnapshotId = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointOutput) SetVolumeARN(v string) *CreateSnapshotFromVolumeRecoveryPointOutput {
	s.VolumeARN = &v
	return s
}

// SetVolumeRecoveryPointTime sets the VolumeRecoveryPointTime field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointOutput) SetVolumeRecoveryPointTime(v string) *CreateSnapshotFromVolumeRecoveryPointOutput {
	s.VolumeRecoveryPointTime = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * CreateSnapshotInput$SnapshotDescription
//
//    * CreateSnapshotInput$VolumeARN
type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Textual description of the snapshot that appears in the Amazon EC2 console,
	// Elastic Block Store snapshots panel in the Description field, and in the
	// AWS Storage Gateway snapshot Details pane, Description field.
	//
	// SnapshotDescription is a required field
	SnapshotDescription *string `min:"1" type:"string" required:"true"`

	// A list of up to 50 tags that can be assigned to a snapshot. Each tag is a
	// key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.SnapshotDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotDescription"))
	}
	if s.SnapshotDescription != nil && len(*s.SnapshotDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotDescription", 1))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotDescription sets the SnapshotDescription field's value.
func (s *CreateSnapshotInput) SetSnapshotDescription(v string) *CreateSnapshotInput {
	s.SnapshotDescription = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotInput) SetTags(v []*Tag) *CreateSnapshotInput {
	s.Tags = v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateSnapshotInput) SetVolumeARN(v string) *CreateSnapshotInput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing the following fields:
type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot ID that is used to refer to the snapshot in future operations
	// such as describing snapshots (Amazon Elastic Compute Cloud API DescribeSnapshots)
	// or creating a volume from a snapshot (CreateStorediSCSIVolume).
	SnapshotId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateSnapshotOutput) SetSnapshotId(v string) *CreateSnapshotOutput {
	s.SnapshotId = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateSnapshotOutput) SetVolumeARN(v string) *CreateSnapshotOutput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * CreateStorediSCSIVolumeInput$DiskId
//
//    * CreateStorediSCSIVolumeInput$NetworkInterfaceId
//
//    * CreateStorediSCSIVolumeInput$PreserveExistingData
//
//    * CreateStorediSCSIVolumeInput$SnapshotId
//
//    * CreateStorediSCSIVolumeInput$TargetName
type CreateStorediSCSIVolumeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the gateway local disk that is configured as a
	// stored volume. Use ListLocalDisks (https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html)
	// to list disk IDs for a gateway.
	//
	// DiskId is a required field
	DiskId *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The network interface of the gateway on which to expose the iSCSI target.
	// Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a
	// list of the network interfaces available on a gateway.
	//
	// Valid Values: A valid IP address.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `type:"string" required:"true"`

	// Set to true true if you want to preserve the data on the local disk. Otherwise,
	// set to false to create an empty volume.
	//
	// Valid Values: true | false
	//
	// PreserveExistingData is a required field
	PreserveExistingData *bool `type:"boolean" required:"true"`

	// The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the
	// new stored volume. Specify this field if you want to create the iSCSI storage
	// volume from a snapshot; otherwise, do not include this field. To list snapshots
	// for your account use DescribeSnapshots (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
	// in the Amazon Elastic Compute Cloud API Reference.
	SnapshotId *string `type:"string"`

	// A list of up to 50 tags that can be assigned to a stored volume. Each tag
	// is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`

	// The name of the iSCSI target used by an initiator to connect to a volume
	// and used as a suffix for the target ARN. For example, specifying TargetName
	// as myvolume results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
	// The target name must be unique across all volumes on a gateway.
	//
	// If you don't specify a value, Storage Gateway uses the value that was previously
	// used for this volume as the new target name.
	//
	// TargetName is a required field
	TargetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStorediSCSIVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorediSCSIVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStorediSCSIVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStorediSCSIVolumeInput"}
	if s.DiskId == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskId"))
	}
	if s.DiskId != nil && len(*s.DiskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiskId", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 7))
	}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}
	if s.PreserveExistingData == nil {
		invalidParams.Add(request.NewErrParamRequired("PreserveExistingData"))
	}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}
	if s.TargetName != nil && len(*s.TargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskId sets the DiskId field's value.
func (s *CreateStorediSCSIVolumeInput) SetDiskId(v string) *CreateStorediSCSIVolumeInput {
	s.DiskId = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateStorediSCSIVolumeInput) SetGatewayARN(v string) *CreateStorediSCSIVolumeInput {
	s.GatewayARN = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *CreateStorediSCSIVolumeInput) SetKMSEncrypted(v bool) *CreateStorediSCSIVolumeInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *CreateStorediSCSIVolumeInput) SetKMSKey(v string) *CreateStorediSCSIVolumeInput {
	s.KMSKey = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *CreateStorediSCSIVolumeInput) SetNetworkInterfaceId(v string) *CreateStorediSCSIVolumeInput {
	s.NetworkInterfaceId = &v
	return s
}

// SetPreserveExistingData sets the PreserveExistingData field's value.
func (s *CreateStorediSCSIVolumeInput) SetPreserveExistingData(v bool) *CreateStorediSCSIVolumeInput {
	s.PreserveExistingData = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateStorediSCSIVolumeInput) SetSnapshotId(v string) *CreateStorediSCSIVolumeInput {
	s.SnapshotId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStorediSCSIVolumeInput) SetTags(v []*Tag) *CreateStorediSCSIVolumeInput {
	s.Tags = v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *CreateStorediSCSIVolumeInput) SetTargetName(v string) *CreateStorediSCSIVolumeInput {
	s.TargetName = &v
	return s
}

// A JSON object containing the following fields:
type CreateStorediSCSIVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume target, which includes the iSCSI
	// name that initiators can use to connect to the target.
	TargetARN *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of the configured volume.
	VolumeARN *string `min:"50" type:"string"`

	// The size of the volume in bytes.
	VolumeSizeInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s CreateStorediSCSIVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorediSCSIVolumeOutput) GoString() string {
	return s.String()
}

// SetTargetARN sets the TargetARN field's value.
func (s *CreateStorediSCSIVolumeOutput) SetTargetARN(v string) *CreateStorediSCSIVolumeOutput {
	s.TargetARN = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateStorediSCSIVolumeOutput) SetVolumeARN(v string) *CreateStorediSCSIVolumeOutput {
	s.VolumeARN = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *CreateStorediSCSIVolumeOutput) SetVolumeSizeInBytes(v int64) *CreateStorediSCSIVolumeOutput {
	s.VolumeSizeInBytes = &v
	return s
}

type CreateTapePoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the new custom tape pool.
	//
	// PoolName is a required field
	PoolName *string `min:"1" type:"string" required:"true"`

	// Tape retention lock time is set in days. Tape retention lock can be enabled
	// for up to 100 years (36,500 days).
	RetentionLockTimeInDays *int64 `type:"integer"`

	// Tape retention lock can be configured in two modes. When configured in governance
	// mode, AWS accounts with specific IAM permissions are authorized to remove
	// the tape retention lock from archived virtual tapes. When configured in compliance
	// mode, the tape retention lock cannot be removed by any user, including the
	// root AWS account.
	RetentionLockType *string `type:"string" enum:"RetentionLockType"`

	// The storage class that is associated with the new custom pool. When you use
	// your backup application to eject the tape, the tape is archived directly
	// into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds
	// to the pool.
	//
	// StorageClass is a required field
	StorageClass *string `type:"string" required:"true" enum:"TapeStorageClass"`

	// A list of up to 50 tags that can be assigned to tape pool. Each tag is a
	// key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateTapePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTapePoolInput"}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.PoolName != nil && len(*s.PoolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolName", 1))
	}
	if s.StorageClass == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageClass"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolName sets the PoolName field's value.
func (s *CreateTapePoolInput) SetPoolName(v string) *CreateTapePoolInput {
	s.PoolName = &v
	return s
}

// SetRetentionLockTimeInDays sets the RetentionLockTimeInDays field's value.
func (s *CreateTapePoolInput) SetRetentionLockTimeInDays(v int64) *CreateTapePoolInput {
	s.RetentionLockTimeInDays = &v
	return s
}

// SetRetentionLockType sets the RetentionLockType field's value.
func (s *CreateTapePoolInput) SetRetentionLockType(v string) *CreateTapePoolInput {
	s.RetentionLockType = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CreateTapePoolInput) SetStorageClass(v string) *CreateTapePoolInput {
	s.StorageClass = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTapePoolInput) SetTags(v []*Tag) *CreateTapePoolInput {
	s.Tags = v
	return s
}

type CreateTapePoolOutput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) that represents the custom tape pool.
	// Use the ListTapePools operation to return a list of tape pools for your account
	// and AWS Region.
	PoolARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateTapePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapePoolOutput) GoString() string {
	return s.String()
}

// SetPoolARN sets the PoolARN field's value.
func (s *CreateTapePoolOutput) SetPoolARN(v string) *CreateTapePoolOutput {
	s.PoolARN = &v
	return s
}

// CreateTapeWithBarcodeInput
type CreateTapeWithBarcodeInput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tape with. Use the ListGateways operation to return a list of
	// gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The ID of the pool that you want to add your tape to for archiving. The tape
	// in this pool is archived in the S3 storage class that is associated with
	// the pool. When you use your backup application to eject the tape, the tape
	// is archived directly into the storage class (S3 Glacier or S3 Deep Archive)
	// that corresponds to the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	PoolId *string `min:"1" type:"string"`

	// A list of up to 50 tags that can be assigned to a virtual tape that has a
	// barcode. Each tag is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`

	// The barcode that you want to assign to the tape.
	//
	// Barcodes cannot be reused. This includes barcodes used for tapes that have
	// been deleted.
	//
	// TapeBarcode is a required field
	TapeBarcode *string `min:"7" type:"string" required:"true"`

	// The size, in bytes, of the virtual tape that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 bytes).
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`

	// Set to TRUE if the tape you are creating is to be configured as a write-once-read-many
	// (WORM) tape.
	Worm *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateTapeWithBarcodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapeWithBarcodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapeWithBarcodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTapeWithBarcodeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 7))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}
	if s.TapeBarcode == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeBarcode"))
	}
	if s.TapeBarcode != nil && len(*s.TapeBarcode) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("TapeBarcode", 7))
	}
	if s.TapeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeSizeInBytes"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateTapeWithBarcodeInput) SetGatewayARN(v string) *CreateTapeWithBarcodeInput {
	s.GatewayARN = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *CreateTapeWithBarcodeInput) SetKMSEncrypted(v bool) *CreateTapeWithBarcodeInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *CreateTapeWithBarcodeInput) SetKMSKey(v string) *CreateTapeWithBarcodeInput {
	s.KMSKey = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *CreateTapeWithBarcodeInput) SetPoolId(v string) *CreateTapeWithBarcodeInput {
	s.PoolId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTapeWithBarcodeInput) SetTags(v []*Tag) *CreateTapeWithBarcodeInput {
	s.Tags = v
	return s
}

// SetTapeBarcode sets the TapeBarcode field's value.
func (s *CreateTapeWithBarcodeInput) SetTapeBarcode(v string) *CreateTapeWithBarcodeInput {
	s.TapeBarcode = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *CreateTapeWithBarcodeInput) SetTapeSizeInBytes(v int64) *CreateTapeWithBarcodeInput {
	s.TapeSizeInBytes = &v
	return s
}

// SetWorm sets the Worm field's value.
func (s *CreateTapeWithBarcodeInput) SetWorm(v bool) *CreateTapeWithBarcodeInput {
	s.Worm = &v
	return s
}

// CreateTapeOutput
type CreateTapeWithBarcodeOutput struct {
	_ struct{} `type:"structure"`

	// A unique Amazon Resource Name (ARN) that represents the virtual tape that
	// was created.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateTapeWithBarcodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapeWithBarcodeOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *CreateTapeWithBarcodeOutput) SetTapeARN(v string) *CreateTapeWithBarcodeOutput {
	s.TapeARN = &v
	return s
}

// CreateTapesInput
type CreateTapesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you use to retry a request. If you retry a request,
	// use the same ClientToken you specified in the initial request.
	//
	// Using the same ClientToken prevents creating the tape multiple times.
	//
	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tapes with. Use the ListGateways operation to return a list of
	// gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The number of virtual tapes that you want to create.
	//
	// NumTapesToCreate is a required field
	NumTapesToCreate *int64 `min:"1" type:"integer" required:"true"`

	// The ID of the pool that you want to add your tape to for archiving. The tape
	// in this pool is archived in the S3 storage class that is associated with
	// the pool. When you use your backup application to eject the tape, the tape
	// is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
	// Archive) that corresponds to the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	PoolId *string `min:"1" type:"string"`

	// A list of up to 50 tags that can be assigned to a virtual tape. Each tag
	// is a key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`

	// A prefix that you append to the barcode of the virtual tape you are creating.
	// This prefix makes the barcode unique.
	//
	// The prefix must be 1 to 4 characters in length and must be one of the uppercase
	// letters from A to Z.
	//
	// TapeBarcodePrefix is a required field
	TapeBarcodePrefix *string `min:"1" type:"string" required:"true"`

	// The size, in bytes, of the virtual tapes that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 bytes).
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`

	// Set to TRUE if the tape you are creating is to be configured as a write-once-read-many
	// (WORM) tape.
	Worm *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTapesInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 7))
	}
	if s.NumTapesToCreate == nil {
		invalidParams.Add(request.NewErrParamRequired("NumTapesToCreate"))
	}
	if s.NumTapesToCreate != nil && *s.NumTapesToCreate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumTapesToCreate", 1))
	}
	if s.PoolId != nil && len(*s.PoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolId", 1))
	}
	if s.TapeBarcodePrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeBarcodePrefix"))
	}
	if s.TapeBarcodePrefix != nil && len(*s.TapeBarcodePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TapeBarcodePrefix", 1))
	}
	if s.TapeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeSizeInBytes"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTapesInput) SetClientToken(v string) *CreateTapesInput {
	s.ClientToken = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateTapesInput) SetGatewayARN(v string) *CreateTapesInput {
	s.GatewayARN = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *CreateTapesInput) SetKMSEncrypted(v bool) *CreateTapesInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *CreateTapesInput) SetKMSKey(v string) *CreateTapesInput {
	s.KMSKey = &v
	return s
}

// SetNumTapesToCreate sets the NumTapesToCreate field's value.
func (s *CreateTapesInput) SetNumTapesToCreate(v int64) *CreateTapesInput {
	s.NumTapesToCreate = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *CreateTapesInput) SetPoolId(v string) *CreateTapesInput {
	s.PoolId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTapesInput) SetTags(v []*Tag) *CreateTapesInput {
	s.Tags = v
	return s
}

// SetTapeBarcodePrefix sets the TapeBarcodePrefix field's value.
func (s *CreateTapesInput) SetTapeBarcodePrefix(v string) *CreateTapesInput {
	s.TapeBarcodePrefix = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *CreateTapesInput) SetTapeSizeInBytes(v int64) *CreateTapesInput {
	s.TapeSizeInBytes = &v
	return s
}

// SetWorm sets the Worm field's value.
func (s *CreateTapesInput) SetWorm(v bool) *CreateTapesInput {
	s.Worm = &v
	return s
}

// CreateTapeOutput
type CreateTapesOutput struct {
	_ struct{} `type:"structure"`

	// A list of unique Amazon Resource Names (ARNs) that represents the virtual
	// tapes that were created.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s CreateTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapesOutput) GoString() string {
	return s.String()
}

// SetTapeARNs sets the TapeARNs field's value.
func (s *CreateTapesOutput) SetTapeARNs(v []*string) *CreateTapesOutput {
	s.TapeARNs = v
	return s
}

type DeleteAutomaticTapeCreationPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAutomaticTapeCreationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAutomaticTapeCreationPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAutomaticTapeCreationPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAutomaticTapeCreationPolicyInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteAutomaticTapeCreationPolicyInput) SetGatewayARN(v string) *DeleteAutomaticTapeCreationPolicyInput {
	s.GatewayARN = &v
	return s
}

type DeleteAutomaticTapeCreationPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteAutomaticTapeCreationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAutomaticTapeCreationPolicyOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteAutomaticTapeCreationPolicyOutput) SetGatewayARN(v string) *DeleteAutomaticTapeCreationPolicyOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
//
//    * DeleteBandwidthRateLimitInput$BandwidthType
type DeleteBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// One of the BandwidthType values that indicates the gateway bandwidth rate
	// limit to delete.
	//
	// Valid Values: UPLOAD | DOWNLOAD | ALL
	//
	// BandwidthType is a required field
	BandwidthType *string `min:"3" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBandwidthRateLimitInput"}
	if s.BandwidthType == nil {
		invalidParams.Add(request.NewErrParamRequired("BandwidthType"))
	}
	if s.BandwidthType != nil && len(*s.BandwidthType) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BandwidthType", 3))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidthType sets the BandwidthType field's value.
func (s *DeleteBandwidthRateLimitInput) SetBandwidthType(v string) *DeleteBandwidthRateLimitInput {
	s.BandwidthType = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteBandwidthRateLimitInput) SetGatewayARN(v string) *DeleteBandwidthRateLimitInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway whose
// bandwidth rate information was deleted.
type DeleteBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteBandwidthRateLimitOutput) SetGatewayARN(v string) *DeleteBandwidthRateLimitOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * DeleteChapCredentialsInput$InitiatorName
//
//    * DeleteChapCredentialsInput$TargetARN
type DeleteChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	//
	// InitiatorName is a required field
	InitiatorName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChapCredentialsInput"}
	if s.InitiatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("InitiatorName"))
	}
	if s.InitiatorName != nil && len(*s.InitiatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitiatorName", 1))
	}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *DeleteChapCredentialsInput) SetInitiatorName(v string) *DeleteChapCredentialsInput {
	s.InitiatorName = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *DeleteChapCredentialsInput) SetTargetARN(v string) *DeleteChapCredentialsInput {
	s.TargetARN = &v
	return s
}

// A JSON object containing the following fields:
type DeleteChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	InitiatorName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChapCredentialsOutput) GoString() string {
	return s.String()
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *DeleteChapCredentialsOutput) SetInitiatorName(v string) *DeleteChapCredentialsOutput {
	s.InitiatorName = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *DeleteChapCredentialsOutput) SetTargetARN(v string) *DeleteChapCredentialsOutput {
	s.TargetARN = &v
	return s
}

// DeleteFileShareInput
type DeleteFileShareInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share to be deleted.
	//
	// FileShareARN is a required field
	FileShareARN *string `min:"50" type:"string" required:"true"`

	// If this value is set to true, the operation deletes a file share immediately
	// and aborts all data uploads to AWS. Otherwise, the file share is not deleted
	// until all data is uploaded to AWS. This process aborts the data upload process,
	// and the file share enters the FORCE_DELETING status.
	//
	// Valid Values: true | false
	ForceDelete *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFileShareInput"}
	if s.FileShareARN == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARN"))
	}
	if s.FileShareARN != nil && len(*s.FileShareARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *DeleteFileShareInput) SetFileShareARN(v string) *DeleteFileShareInput {
	s.FileShareARN = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteFileShareInput) SetForceDelete(v bool) *DeleteFileShareInput {
	s.ForceDelete = &v
	return s
}

// DeleteFileShareOutput
type DeleteFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileShareOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *DeleteFileShareOutput) SetFileShareARN(v string) *DeleteFileShareOutput {
	s.FileShareARN = &v
	return s
}

// A JSON object containing the ID of the gateway to delete.
type DeleteGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteGatewayInput) SetGatewayARN(v string) *DeleteGatewayInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the ID of the deleted gateway.
type DeleteGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteGatewayOutput) SetGatewayARN(v string) *DeleteGatewayOutput {
	s.GatewayARN = &v
	return s
}

type DeleteSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// The volume which snapshot schedule to delete.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotScheduleInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DeleteSnapshotScheduleInput) SetVolumeARN(v string) *DeleteSnapshotScheduleInput {
	s.VolumeARN = &v
	return s
}

type DeleteSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The volume which snapshot schedule was deleted.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DeleteSnapshotScheduleOutput) SetVolumeARN(v string) *DeleteSnapshotScheduleOutput {
	s.VolumeARN = &v
	return s
}

// DeleteTapeArchiveInput
type DeleteTapeArchiveInput struct {
	_ struct{} `type:"structure"`

	// Set to TRUE to delete an archived tape that belongs to a custom pool with
	// tape retention lock. Only archived tapes with tape retention lock set to
	// governance can be deleted. Archived tapes with tape retention lock set to
	// compliance can't be deleted.
	BypassGovernanceRetention *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual
	// tape shelf (VTS).
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTapeArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTapeArchiveInput"}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassGovernanceRetention sets the BypassGovernanceRetention field's value.
func (s *DeleteTapeArchiveInput) SetBypassGovernanceRetention(v bool) *DeleteTapeArchiveInput {
	s.BypassGovernanceRetention = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *DeleteTapeArchiveInput) SetTapeARN(v string) *DeleteTapeArchiveInput {
	s.TapeARN = &v
	return s
}

// DeleteTapeArchiveOutput
type DeleteTapeArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape that was deleted from
	// the virtual tape shelf (VTS).
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeArchiveOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *DeleteTapeArchiveOutput) SetTapeARN(v string) *DeleteTapeArchiveOutput {
	s.TapeARN = &v
	return s
}

// DeleteTapeInput
type DeleteTapeInput struct {
	_ struct{} `type:"structure"`

	// Set to TRUE to delete an archived tape that belongs to a custom pool with
	// tape retention lock. Only archived tapes with tape retention lock set to
	// governance can be deleted. Archived tapes with tape retention lock set to
	// compliance can't be deleted.
	BypassGovernanceRetention *bool `type:"boolean"`

	// The unique Amazon Resource Name (ARN) of the gateway that the virtual tape
	// to delete is associated with. Use the ListGateways operation to return a
	// list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape to delete.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTapeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTapeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTapeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassGovernanceRetention sets the BypassGovernanceRetention field's value.
func (s *DeleteTapeInput) SetBypassGovernanceRetention(v bool) *DeleteTapeInput {
	s.BypassGovernanceRetention = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteTapeInput) SetGatewayARN(v string) *DeleteTapeInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *DeleteTapeInput) SetTapeARN(v string) *DeleteTapeInput {
	s.TapeARN = &v
	return s
}

// DeleteTapeOutput
type DeleteTapeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted virtual tape.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteTapeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *DeleteTapeOutput) SetTapeARN(v string) *DeleteTapeOutput {
	s.TapeARN = &v
	return s
}

type DeleteTapePoolInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom tape pool to delete.
	//
	// PoolARN is a required field
	PoolARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTapePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTapePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTapePoolInput"}
	if s.PoolARN == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolARN"))
	}
	if s.PoolARN != nil && len(*s.PoolARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("PoolARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolARN sets the PoolARN field's value.
func (s *DeleteTapePoolInput) SetPoolARN(v string) *DeleteTapePoolInput {
	s.PoolARN = &v
	return s
}

type DeleteTapePoolOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom tape pool being deleted.
	PoolARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteTapePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapePoolOutput) GoString() string {
	return s.String()
}

// SetPoolARN sets the PoolARN field's value.
func (s *DeleteTapePoolOutput) SetPoolARN(v string) *DeleteTapePoolOutput {
	s.PoolARN = &v
	return s
}

// A JSON object containing the DeleteVolumeInput$VolumeARN to delete.
type DeleteVolumeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVolumeInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DeleteVolumeInput) SetVolumeARN(v string) *DeleteVolumeInput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the storage volume
// that was deleted.
type DeleteVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the storage volume that was deleted. It
	// is the same ARN you provided in the request.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeOutput) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DeleteVolumeOutput) SetVolumeARN(v string) *DeleteVolumeOutput {
	s.VolumeARN = &v
	return s
}

type DescribeAvailabilityMonitorTestInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAvailabilityMonitorTestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityMonitorTestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAvailabilityMonitorTestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAvailabilityMonitorTestInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeAvailabilityMonitorTestInput) SetGatewayARN(v string) *DescribeAvailabilityMonitorTestInput {
	s.GatewayARN = &v
	return s
}

type DescribeAvailabilityMonitorTestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The time the High Availability monitoring test was started. If a test hasn't
	// been performed, the value of this field is null.
	StartTime *time.Time `type:"timestamp"`

	// The status of the High Availability monitoring test. If a test hasn't been
	// performed, the value of this field is null.
	Status *string `type:"string" enum:"AvailabilityMonitorTestStatus"`
}

// String returns the string representation
func (s DescribeAvailabilityMonitorTestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityMonitorTestOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeAvailabilityMonitorTestOutput) SetGatewayARN(v string) *DescribeAvailabilityMonitorTestOutput {
	s.GatewayARN = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeAvailabilityMonitorTestOutput) SetStartTime(v time.Time) *DescribeAvailabilityMonitorTestOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAvailabilityMonitorTestOutput) SetStatus(v string) *DescribeAvailabilityMonitorTestOutput {
	s.Status = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway.
type DescribeBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBandwidthRateLimitInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeBandwidthRateLimitInput) SetGatewayARN(v string) *DescribeBandwidthRateLimitInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
type DescribeBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The average download bandwidth rate limit in bits per second. This field
	// does not appear in the response if the download rate limit is not set.
	AverageDownloadRateLimitInBitsPerSec *int64 `min:"102400" type:"long"`

	// The average upload bandwidth rate limit in bits per second. This field does
	// not appear in the response if the upload rate limit is not set.
	AverageUploadRateLimitInBitsPerSec *int64 `min:"51200" type:"long"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// SetAverageDownloadRateLimitInBitsPerSec sets the AverageDownloadRateLimitInBitsPerSec field's value.
func (s *DescribeBandwidthRateLimitOutput) SetAverageDownloadRateLimitInBitsPerSec(v int64) *DescribeBandwidthRateLimitOutput {
	s.AverageDownloadRateLimitInBitsPerSec = &v
	return s
}

// SetAverageUploadRateLimitInBitsPerSec sets the AverageUploadRateLimitInBitsPerSec field's value.
func (s *DescribeBandwidthRateLimitOutput) SetAverageUploadRateLimitInBitsPerSec(v int64) *DescribeBandwidthRateLimitOutput {
	s.AverageUploadRateLimitInBitsPerSec = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeBandwidthRateLimitOutput) SetGatewayARN(v string) *DescribeBandwidthRateLimitOutput {
	s.GatewayARN = &v
	return s
}

type DescribeBandwidthRateLimitScheduleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBandwidthRateLimitScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBandwidthRateLimitScheduleInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeBandwidthRateLimitScheduleInput) SetGatewayARN(v string) *DescribeBandwidthRateLimitScheduleInput {
	s.GatewayARN = &v
	return s
}

type DescribeBandwidthRateLimitScheduleOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains the bandwidth rate limit intervals for a tape or volume
	// gateway.
	BandwidthRateLimitIntervals []*BandwidthRateLimitInterval `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitScheduleOutput) GoString() string {
	return s.String()
}

// SetBandwidthRateLimitIntervals sets the BandwidthRateLimitIntervals field's value.
func (s *DescribeBandwidthRateLimitScheduleOutput) SetBandwidthRateLimitIntervals(v []*BandwidthRateLimitInterval) *DescribeBandwidthRateLimitScheduleOutput {
	s.BandwidthRateLimitIntervals = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeBandwidthRateLimitScheduleOutput) SetGatewayARN(v string) *DescribeBandwidthRateLimitScheduleOutput {
	s.GatewayARN = &v
	return s
}

type DescribeCacheInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCacheInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeCacheInput) SetGatewayARN(v string) *DescribeCacheInput {
	s.GatewayARN = &v
	return s
}

type DescribeCacheOutput struct {
	_ struct{} `type:"structure"`

	// The amount of cache in bytes allocated to a gateway.
	CacheAllocatedInBytes *int64 `type:"long"`

	// The file share's contribution to the overall percentage of the gateway's
	// cache that has not been persisted to AWS. The sample is taken at the end
	// of the reporting period.
	CacheDirtyPercentage *float64 `type:"double"`

	// Percent of application read operations from the file shares that are served
	// from cache. The sample is taken at the end of the reporting period.
	CacheHitPercentage *float64 `type:"double"`

	// Percent of application read operations from the file shares that are not
	// served from cache. The sample is taken at the end of the reporting period.
	CacheMissPercentage *float64 `type:"double"`

	// Percent use of the gateway's cache storage. This metric applies only to the
	// gateway-cached volume setup. The sample is taken at the end of the reporting
	// period.
	CacheUsedPercentage *float64 `type:"double"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string has a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheOutput) GoString() string {
	return s.String()
}

// SetCacheAllocatedInBytes sets the CacheAllocatedInBytes field's value.
func (s *DescribeCacheOutput) SetCacheAllocatedInBytes(v int64) *DescribeCacheOutput {
	s.CacheAllocatedInBytes = &v
	return s
}

// SetCacheDirtyPercentage sets the CacheDirtyPercentage field's value.
func (s *DescribeCacheOutput) SetCacheDirtyPercentage(v float64) *DescribeCacheOutput {
	s.CacheDirtyPercentage = &v
	return s
}

// SetCacheHitPercentage sets the CacheHitPercentage field's value.
func (s *DescribeCacheOutput) SetCacheHitPercentage(v float64) *DescribeCacheOutput {
	s.CacheHitPercentage = &v
	return s
}

// SetCacheMissPercentage sets the CacheMissPercentage field's value.
func (s *DescribeCacheOutput) SetCacheMissPercentage(v float64) *DescribeCacheOutput {
	s.CacheMissPercentage = &v
	return s
}

// SetCacheUsedPercentage sets the CacheUsedPercentage field's value.
func (s *DescribeCacheOutput) SetCacheUsedPercentage(v float64) *DescribeCacheOutput {
	s.CacheUsedPercentage = &v
	return s
}

// SetDiskIds sets the DiskIds field's value.
func (s *DescribeCacheOutput) SetDiskIds(v []*string) *DescribeCacheOutput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeCacheOutput) SetGatewayARN(v string) *DescribeCacheOutput {
	s.GatewayARN = &v
	return s
}

type DescribeCachediSCSIVolumesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings where each string represents the Amazon Resource Name
	// (ARN) of a cached volume. All of the specified cached volumes must be from
	// the same gateway. Use ListVolumes to get volume ARNs for a gateway.
	//
	// VolumeARNs is a required field
	VolumeARNs []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeCachediSCSIVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCachediSCSIVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCachediSCSIVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCachediSCSIVolumesInput"}
	if s.VolumeARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARNs sets the VolumeARNs field's value.
func (s *DescribeCachediSCSIVolumesInput) SetVolumeARNs(v []*string) *DescribeCachediSCSIVolumesInput {
	s.VolumeARNs = v
	return s
}

// A JSON object containing the following fields:
type DescribeCachediSCSIVolumesOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects where each object contains metadata about one cached
	// volume.
	CachediSCSIVolumes []*CachediSCSIVolume `type:"list"`
}

// String returns the string representation
func (s DescribeCachediSCSIVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCachediSCSIVolumesOutput) GoString() string {
	return s.String()
}

// SetCachediSCSIVolumes sets the CachediSCSIVolumes field's value.
func (s *DescribeCachediSCSIVolumesOutput) SetCachediSCSIVolumes(v []*CachediSCSIVolume) *DescribeCachediSCSIVolumesOutput {
	s.CachediSCSIVolumes = v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume
// target.
type DescribeChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChapCredentialsInput"}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetARN sets the TargetARN field's value.
func (s *DescribeChapCredentialsInput) SetTargetARN(v string) *DescribeChapCredentialsInput {
	s.TargetARN = &v
	return s
}

// A JSON object containing the following fields:
type DescribeChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ChapInfo objects that represent CHAP credentials. Each object
	// in the array contains CHAP credential information for one target-initiator
	// pair. If no CHAP credentials are set, an empty array is returned. CHAP credential
	// information is provided in a JSON object with the following fields:
	//
	//    * InitiatorName: The iSCSI initiator that connects to the target.
	//
	//    * SecretToAuthenticateInitiator: The secret key that the initiator (for
	//    example, the Windows client) must provide to participate in mutual CHAP
	//    with the target.
	//
	//    * SecretToAuthenticateTarget: The secret key that the target must provide
	//    to participate in mutual CHAP with the initiator (e.g. Windows client).
	//
	//    * TargetARN: The Amazon Resource Name (ARN) of the storage volume.
	ChapCredentials []*ChapInfo `type:"list"`
}

// String returns the string representation
func (s DescribeChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChapCredentialsOutput) GoString() string {
	return s.String()
}

// SetChapCredentials sets the ChapCredentials field's value.
func (s *DescribeChapCredentialsOutput) SetChapCredentials(v []*ChapInfo) *DescribeChapCredentialsOutput {
	s.ChapCredentials = v
	return s
}

// A JSON object containing the ID of the gateway.
type DescribeGatewayInformationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayInformationInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeGatewayInformationInput) SetGatewayARN(v string) *DescribeGatewayInformationInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
type DescribeGatewayInformationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is
	// used to monitor events in the gateway.
	CloudWatchLogGroupARN *string `type:"string"`

	// Date after which this gateway will not receive software updates for new features
	// and bug fixes.
	DeprecationDate *string `min:"1" type:"string"`

	// The ID of the Amazon EC2 instance that was used to launch the gateway.
	Ec2InstanceId *string `type:"string"`

	// The AWS Region where the Amazon EC2 instance is located.
	Ec2InstanceRegion *string `type:"string"`

	// The type of endpoint for your gateway.
	//
	// Valid Values: STANDARD | FIPS
	EndpointType *string `min:"4" type:"string"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	GatewayId *string `min:"12" type:"string"`

	// The name you configured for your gateway.
	GatewayName *string `type:"string"`

	// A NetworkInterface array that contains descriptions of the gateway network
	// interfaces.
	GatewayNetworkInterfaces []*NetworkInterface `type:"list"`

	// A value that indicates the operating state of the gateway.
	GatewayState *string `min:"2" type:"string"`

	// A value that indicates the time zone configured for the gateway.
	GatewayTimezone *string `min:"3" type:"string"`

	// The type of the gateway.
	GatewayType *string `min:"2" type:"string"`

	// The type of hypervisor environment used by the host.
	HostEnvironment *string `type:"string" enum:"HostEnvironment"`

	// The date on which the last software update was applied to the gateway. If
	// the gateway has never been updated, this field does not return a value in
	// the response.
	LastSoftwareUpdate *string `min:"1" type:"string"`

	// The date on which an update to the gateway is available. This date is in
	// the time zone of the gateway. If the gateway is not available for an update
	// this field is not returned in the response.
	NextUpdateAvailabilityDate *string `min:"1" type:"string"`

	// Date after which this gateway will not receive software updates for new features.
	SoftwareUpdatesEndDate *string `min:"1" type:"string"`

	// A list of up to 50 tags assigned to the gateway, sorted alphabetically by
	// key name. Each tag is a key-value pair. For a gateway with more than 10 tags
	// assigned, you can view all tags using the ListTagsForResource API operation.
	Tags []*Tag `type:"list"`

	// The configuration settings for the virtual private cloud (VPC) endpoint for
	// your gateway.
	VPCEndpoint *string `type:"string"`
}

// String returns the string representation
func (s DescribeGatewayInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInformationOutput) GoString() string {
	return s.String()
}

// SetCloudWatchLogGroupARN sets the CloudWatchLogGroupARN field's value.
func (s *DescribeGatewayInformationOutput) SetCloudWatchLogGroupARN(v string) *DescribeGatewayInformationOutput {
	s.CloudWatchLogGroupARN = &v
	return s
}

// SetDeprecationDate sets the DeprecationDate field's value.
func (s *DescribeGatewayInformationOutput) SetDeprecationDate(v string) *DescribeGatewayInformationOutput {
	s.DeprecationDate = &v
	return s
}

// SetEc2InstanceId sets the Ec2InstanceId field's value.
func (s *DescribeGatewayInformationOutput) SetEc2InstanceId(v string) *DescribeGatewayInformationOutput {
	s.Ec2InstanceId = &v
	return s
}

// SetEc2InstanceRegion sets the Ec2InstanceRegion field's value.
func (s *DescribeGatewayInformationOutput) SetEc2InstanceRegion(v string) *DescribeGatewayInformationOutput {
	s.Ec2InstanceRegion = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *DescribeGatewayInformationOutput) SetEndpointType(v string) *DescribeGatewayInformationOutput {
	s.EndpointType = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayARN(v string) *DescribeGatewayInformationOutput {
	s.GatewayARN = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayId(v string) *DescribeGatewayInformationOutput {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayName(v string) *DescribeGatewayInformationOutput {
	s.GatewayName = &v
	return s
}

// SetGatewayNetworkInterfaces sets the GatewayNetworkInterfaces field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayNetworkInterfaces(v []*NetworkInterface) *DescribeGatewayInformationOutput {
	s.GatewayNetworkInterfaces = v
	return s
}

// SetGatewayState sets the GatewayState field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayState(v string) *DescribeGatewayInformationOutput {
	s.GatewayState = &v
	return s
}

// SetGatewayTimezone sets the GatewayTimezone field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayTimezone(v string) *DescribeGatewayInformationOutput {
	s.GatewayTimezone = &v
	return s
}

// SetGatewayType sets the GatewayType field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayType(v string) *DescribeGatewayInformationOutput {
	s.GatewayType = &v
	return s
}

// SetHostEnvironment sets the HostEnvironment field's value.
func (s *DescribeGatewayInformationOutput) SetHostEnvironment(v string) *DescribeGatewayInformationOutput {
	s.HostEnvironment = &v
	return s
}

// SetLastSoftwareUpdate sets the LastSoftwareUpdate field's value.
func (s *DescribeGatewayInformationOutput) SetLastSoftwareUpdate(v string) *DescribeGatewayInformationOutput {
	s.LastSoftwareUpdate = &v
	return s
}

// SetNextUpdateAvailabilityDate sets the NextUpdateAvailabilityDate field's value.
func (s *DescribeGatewayInformationOutput) SetNextUpdateAvailabilityDate(v string) *DescribeGatewayInformationOutput {
	s.NextUpdateAvailabilityDate = &v
	return s
}

// SetSoftwareUpdatesEndDate sets the SoftwareUpdatesEndDate field's value.
func (s *DescribeGatewayInformationOutput) SetSoftwareUpdatesEndDate(v string) *DescribeGatewayInformationOutput {
	s.SoftwareUpdatesEndDate = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeGatewayInformationOutput) SetTags(v []*Tag) *DescribeGatewayInformationOutput {
	s.Tags = v
	return s
}

// SetVPCEndpoint sets the VPCEndpoint field's value.
func (s *DescribeGatewayInformationOutput) SetVPCEndpoint(v string) *DescribeGatewayInformationOutput {
	s.VPCEndpoint = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway.
type DescribeMaintenanceStartTimeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceStartTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceStartTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceStartTimeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeMaintenanceStartTimeInput) SetGatewayARN(v string) *DescribeMaintenanceStartTimeInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
//
//    * DescribeMaintenanceStartTimeOutput$DayOfMonth
//
//    * DescribeMaintenanceStartTimeOutput$DayOfWeek
//
//    * DescribeMaintenanceStartTimeOutput$HourOfDay
//
//    * DescribeMaintenanceStartTimeOutput$MinuteOfHour
//
//    * DescribeMaintenanceStartTimeOutput$Timezone
type DescribeMaintenanceStartTimeOutput struct {
	_ struct{} `type:"structure"`

	// The day of the month component of the maintenance start time represented
	// as an ordinal number from 1 to 28, where 1 represents the first day of the
	// month and 28 represents the last day of the month.
	DayOfMonth *int64 `min:"1" type:"integer"`

	// An ordinal number between 0 and 6 that represents the day of the week, where
	// 0 represents Sunday and 6 represents Saturday. The day of week is in the
	// time zone of the gateway.
	DayOfWeek *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The hour component of the maintenance start time represented as hh, where
	// hh is the hour (0 to 23). The hour of the day is in the time zone of the
	// gateway.
	HourOfDay *int64 `type:"integer"`

	// The minute component of the maintenance start time represented as mm, where
	// mm is the minute (0 to 59). The minute of the hour is in the time zone of
	// the gateway.
	MinuteOfHour *int64 `type:"integer"`

	// A value that indicates the time zone that is set for the gateway. The start
	// time and day of week specified should be in the time zone of the gateway.
	Timezone *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DescribeMaintenanceStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceStartTimeOutput) GoString() string {
	return s.String()
}

// SetDayOfMonth sets the DayOfMonth field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetDayOfMonth(v int64) *DescribeMaintenanceStartTimeOutput {
	s.DayOfMonth = &v
	return s
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetDayOfWeek(v int64) *DescribeMaintenanceStartTimeOutput {
	s.DayOfWeek = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetGatewayARN(v string) *DescribeMaintenanceStartTimeOutput {
	s.GatewayARN = &v
	return s
}

// SetHourOfDay sets the HourOfDay field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetHourOfDay(v int64) *DescribeMaintenanceStartTimeOutput {
	s.HourOfDay = &v
	return s
}

// SetMinuteOfHour sets the MinuteOfHour field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetMinuteOfHour(v int64) *DescribeMaintenanceStartTimeOutput {
	s.MinuteOfHour = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetTimezone(v string) *DescribeMaintenanceStartTimeOutput {
	s.Timezone = &v
	return s
}

// DescribeNFSFileSharesInput
type DescribeNFSFileSharesInput struct {
	_ struct{} `type:"structure"`

	// An array containing the Amazon Resource Name (ARN) of each file share to
	// be described.
	//
	// FileShareARNList is a required field
	FileShareARNList []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeNFSFileSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNFSFileSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNFSFileSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNFSFileSharesInput"}
	if s.FileShareARNList == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARNList"))
	}
	if s.FileShareARNList != nil && len(s.FileShareARNList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARNList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileShareARNList sets the FileShareARNList field's value.
func (s *DescribeNFSFileSharesInput) SetFileShareARNList(v []*string) *DescribeNFSFileSharesInput {
	s.FileShareARNList = v
	return s
}

// DescribeNFSFileSharesOutput
type DescribeNFSFileSharesOutput struct {
	_ struct{} `type:"structure"`

	// An array containing a description for each requested file share.
	NFSFileShareInfoList []*NFSFileShareInfo `type:"list"`
}

// String returns the string representation
func (s DescribeNFSFileSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNFSFileSharesOutput) GoString() string {
	return s.String()
}

// SetNFSFileShareInfoList sets the NFSFileShareInfoList field's value.
func (s *DescribeNFSFileSharesOutput) SetNFSFileShareInfoList(v []*NFSFileShareInfo) *DescribeNFSFileSharesOutput {
	s.NFSFileShareInfoList = v
	return s
}

// DescribeSMBFileSharesInput
type DescribeSMBFileSharesInput struct {
	_ struct{} `type:"structure"`

	// An array containing the Amazon Resource Name (ARN) of each file share to
	// be described.
	//
	// FileShareARNList is a required field
	FileShareARNList []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeSMBFileSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSMBFileSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSMBFileSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSMBFileSharesInput"}
	if s.FileShareARNList == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARNList"))
	}
	if s.FileShareARNList != nil && len(s.FileShareARNList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARNList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileShareARNList sets the FileShareARNList field's value.
func (s *DescribeSMBFileSharesInput) SetFileShareARNList(v []*string) *DescribeSMBFileSharesInput {
	s.FileShareARNList = v
	return s
}

// DescribeSMBFileSharesOutput
type DescribeSMBFileSharesOutput struct {
	_ struct{} `type:"structure"`

	// An array containing a description for each requested file share.
	SMBFileShareInfoList []*SMBFileShareInfo `type:"list"`
}

// String returns the string representation
func (s DescribeSMBFileSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSMBFileSharesOutput) GoString() string {
	return s.String()
}

// SetSMBFileShareInfoList sets the SMBFileShareInfoList field's value.
func (s *DescribeSMBFileSharesOutput) SetSMBFileShareInfoList(v []*SMBFileShareInfo) *DescribeSMBFileSharesOutput {
	s.SMBFileShareInfoList = v
	return s
}

type DescribeSMBSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSMBSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSMBSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSMBSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSMBSettingsInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeSMBSettingsInput) SetGatewayARN(v string) *DescribeSMBSettingsInput {
	s.GatewayARN = &v
	return s
}

type DescribeSMBSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the status of a gateway that is a member of the Active Directory
	// domain.
	//
	//    * ACCESS_DENIED: Indicates that the JoinDomain operation failed due to
	//    an authentication error.
	//
	//    * DETACHED: Indicates that gateway is not joined to a domain.
	//
	//    * JOINED: Indicates that the gateway has successfully joined a domain.
	//
	//    * JOINING: Indicates that a JoinDomain operation is in progress.
	//
	//    * NETWORK_ERROR: Indicates that JoinDomain operation failed due to a network
	//    or connectivity error.
	//
	//    * TIMEOUT: Indicates that the JoinDomain operation failed because the
	//    operation didn't complete within the allotted time.
	//
	//    * UNKNOWN_ERROR: Indicates that the JoinDomain operation failed due to
	//    another type of error.
	ActiveDirectoryStatus *string `type:"string" enum:"ActiveDirectoryStatus"`

	// The name of the domain that the gateway is joined to.
	DomainName *string `min:"1" type:"string"`

	// The shares on this gateway appear when listing shares.
	FileSharesVisible *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// This value is true if a password for the guest user smbguest is set, otherwise
	// false.
	//
	// Valid Values: true | false
	SMBGuestPasswordSet *bool `type:"boolean"`

	// The type of security strategy that was specified for file gateway.
	//
	//    * ClientSpecified: If you use this option, requests are established based
	//    on what is negotiated by the client. This option is recommended when you
	//    want to maximize compatibility across different clients in your environment.
	//
	//    * MandatorySigning: If you use this option, file gateway only allows connections
	//    from SMBv2 or SMBv3 clients that have signing enabled. This option works
	//    with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.
	//
	//    * MandatoryEncryption: If you use this option, file gateway only allows
	//    connections from SMBv3 clients that have encryption enabled. This option
	//    is highly recommended for environments that handle sensitive data. This
	//    option works with SMB clients on Microsoft Windows 8, Windows Server 2012
	//    or newer.
	SMBSecurityStrategy *string `type:"string" enum:"SMBSecurityStrategy"`
}

// String returns the string representation
func (s DescribeSMBSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSMBSettingsOutput) GoString() string {
	return s.String()
}

// SetActiveDirectoryStatus sets the ActiveDirectoryStatus field's value.
func (s *DescribeSMBSettingsOutput) SetActiveDirectoryStatus(v string) *DescribeSMBSettingsOutput {
	s.ActiveDirectoryStatus = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeSMBSettingsOutput) SetDomainName(v string) *DescribeSMBSettingsOutput {
	s.DomainName = &v
	return s
}

// SetFileSharesVisible sets the FileSharesVisible field's value.
func (s *DescribeSMBSettingsOutput) SetFileSharesVisible(v bool) *DescribeSMBSettingsOutput {
	s.FileSharesVisible = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeSMBSettingsOutput) SetGatewayARN(v string) *DescribeSMBSettingsOutput {
	s.GatewayARN = &v
	return s
}

// SetSMBGuestPasswordSet sets the SMBGuestPasswordSet field's value.
func (s *DescribeSMBSettingsOutput) SetSMBGuestPasswordSet(v bool) *DescribeSMBSettingsOutput {
	s.SMBGuestPasswordSet = &v
	return s
}

// SetSMBSecurityStrategy sets the SMBSecurityStrategy field's value.
func (s *DescribeSMBSettingsOutput) SetSMBSecurityStrategy(v string) *DescribeSMBSettingsOutput {
	s.SMBSecurityStrategy = &v
	return s
}

// A JSON object containing the DescribeSnapshotScheduleInput$VolumeARN of the
// volume.
type DescribeSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSnapshotScheduleInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DescribeSnapshotScheduleInput) SetVolumeARN(v string) *DescribeSnapshotScheduleInput {
	s.VolumeARN = &v
	return s
}

type DescribeSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot description.
	Description *string `min:"1" type:"string"`

	// The number of hours between snapshots.
	RecurrenceInHours *int64 `min:"1" type:"integer"`

	// The hour of the day at which the snapshot schedule begins represented as
	// hh, where hh is the hour (0 to 23). The hour of the day is in the time zone
	// of the gateway.
	StartAt *int64 `type:"integer"`

	// A list of up to 50 tags assigned to the snapshot schedule, sorted alphabetically
	// by key name. Each tag is a key-value pair. For a gateway with more than 10
	// tags assigned, you can view all tags using the ListTagsForResource API operation.
	Tags []*Tag `type:"list"`

	// A value that indicates the time zone of the gateway.
	Timezone *string `min:"3" type:"string"`

	// The Amazon Resource Name (ARN) of the volume that was specified in the request.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DescribeSnapshotScheduleOutput) SetDescription(v string) *DescribeSnapshotScheduleOutput {
	s.Description = &v
	return s
}

// SetRecurrenceInHours sets the RecurrenceInHours field's value.
func (s *DescribeSnapshotScheduleOutput) SetRecurrenceInHours(v int64) *DescribeSnapshotScheduleOutput {
	s.RecurrenceInHours = &v
	return s
}

// SetStartAt sets the StartAt field's value.
func (s *DescribeSnapshotScheduleOutput) SetStartAt(v int64) *DescribeSnapshotScheduleOutput {
	s.StartAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeSnapshotScheduleOutput) SetTags(v []*Tag) *DescribeSnapshotScheduleOutput {
	s.Tags = v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DescribeSnapshotScheduleOutput) SetTimezone(v string) *DescribeSnapshotScheduleOutput {
	s.Timezone = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DescribeSnapshotScheduleOutput) SetVolumeARN(v string) *DescribeSnapshotScheduleOutput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing a list of DescribeStorediSCSIVolumesInput$VolumeARNs.
type DescribeStorediSCSIVolumesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings where each string represents the Amazon Resource Name
	// (ARN) of a stored volume. All of the specified stored volumes must be from
	// the same gateway. Use ListVolumes to get volume ARNs for a gateway.
	//
	// VolumeARNs is a required field
	VolumeARNs []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeStorediSCSIVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorediSCSIVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStorediSCSIVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStorediSCSIVolumesInput"}
	if s.VolumeARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARNs sets the VolumeARNs field's value.
func (s *DescribeStorediSCSIVolumesInput) SetVolumeARNs(v []*string) *DescribeStorediSCSIVolumesInput {
	s.VolumeARNs = v
	return s
}

type DescribeStorediSCSIVolumesOutput struct {
	_ struct{} `type:"structure"`

	// Describes a single unit of output from DescribeStorediSCSIVolumes. The following
	// fields are returned:
	//
	//    * ChapEnabled: Indicates whether mutual CHAP is enabled for the iSCSI
	//    target.
	//
	//    * LunNumber: The logical disk number.
	//
	//    * NetworkInterfaceId: The network interface ID of the stored volume that
	//    initiator use to map the stored volume as an iSCSI target.
	//
	//    * NetworkInterfacePort: The port used to communicate with iSCSI targets.
	//
	//    * PreservedExistingData: Indicates when the stored volume was created,
	//    existing data on the underlying local disk was preserved.
	//
	//    * SourceSnapshotId: If the stored volume was created from a snapshot,
	//    this field contains the snapshot ID used, e.g. snap-1122aabb. Otherwise,
	//    this field is not included.
	//
	//    * StorediSCSIVolumes: An array of StorediSCSIVolume objects where each
	//    object contains metadata about one stored volume.
	//
	//    * TargetARN: The Amazon Resource Name (ARN) of the volume target.
	//
	//    * VolumeARN: The Amazon Resource Name (ARN) of the stored volume.
	//
	//    * VolumeDiskId: The disk ID of the local disk that was specified in the
	//    CreateStorediSCSIVolume operation.
	//
	//    * VolumeId: The unique identifier of the storage volume, e.g. vol-1122AABB.
	//
	//    * VolumeiSCSIAttributes: An VolumeiSCSIAttributes object that represents
	//    a collection of iSCSI attributes for one stored volume.
	//
	//    * VolumeProgress: Represents the percentage complete if the volume is
	//    restoring or bootstrapping that represents the percent of data transferred.
	//    This field does not appear in the response if the stored volume is not
	//    restoring or bootstrapping.
	//
	//    * VolumeSizeInBytes: The size of the volume in bytes.
	//
	//    * VolumeStatus: One of the VolumeStatus values that indicates the state
	//    of the volume.
	//
	//    * VolumeType: One of the enumeration values describing the type of the
	//    volume. Currently, only STORED volumes are supported.
	StorediSCSIVolumes []*StorediSCSIVolume `type:"list"`
}

// String returns the string representation
func (s DescribeStorediSCSIVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorediSCSIVolumesOutput) GoString() string {
	return s.String()
}

// SetStorediSCSIVolumes sets the StorediSCSIVolumes field's value.
func (s *DescribeStorediSCSIVolumesOutput) SetStorediSCSIVolumes(v []*StorediSCSIVolume) *DescribeStorediSCSIVolumesOutput {
	s.StorediSCSIVolumes = v
	return s
}

// DescribeTapeArchivesInput
type DescribeTapeArchivesInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the number of virtual tapes described be limited to the specified
	// number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// virtual tapes.
	Marker *string `min:"1" type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTapeArchivesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeArchivesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapeArchivesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapeArchivesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeTapeArchivesInput) SetLimit(v int64) *DescribeTapeArchivesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapeArchivesInput) SetMarker(v string) *DescribeTapeArchivesInput {
	s.Marker = &v
	return s
}

// SetTapeARNs sets the TapeARNs field's value.
func (s *DescribeTapeArchivesInput) SetTapeARNs(v []*string) *DescribeTapeArchivesInput {
	s.TapeARNs = v
	return s
}

// DescribeTapeArchivesOutput
type DescribeTapeArchivesOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which the virtual tapes that
	// were fetched for description ended. Use this marker in your next request
	// to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If
	// there are no more virtual tapes to describe, this field does not appear in
	// the response.
	Marker *string `min:"1" type:"string"`

	// An array of virtual tape objects in the virtual tape shelf (VTS). The description
	// includes of the Amazon Resource Name (ARN) of the virtual tapes. The information
	// returned includes the Amazon Resource Names (ARNs) of the tapes, size of
	// the tapes, status of the tapes, progress of the description, and tape barcode.
	TapeArchives []*TapeArchive `type:"list"`
}

// String returns the string representation
func (s DescribeTapeArchivesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeArchivesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapeArchivesOutput) SetMarker(v string) *DescribeTapeArchivesOutput {
	s.Marker = &v
	return s
}

// SetTapeArchives sets the TapeArchives field's value.
func (s *DescribeTapeArchivesOutput) SetTapeArchives(v []*TapeArchive) *DescribeTapeArchivesOutput {
	s.TapeArchives = v
	return s
}

// DescribeTapeRecoveryPointsInput
type DescribeTapeRecoveryPointsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of virtual tape recovery points that are described
	// be limited to the specified number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// the virtual tape recovery points.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeTapeRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeRecoveryPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapeRecoveryPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapeRecoveryPointsInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeTapeRecoveryPointsInput) SetGatewayARN(v string) *DescribeTapeRecoveryPointsInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeTapeRecoveryPointsInput) SetLimit(v int64) *DescribeTapeRecoveryPointsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapeRecoveryPointsInput) SetMarker(v string) *DescribeTapeRecoveryPointsInput {
	s.Marker = &v
	return s
}

// DescribeTapeRecoveryPointsOutput
type DescribeTapeRecoveryPointsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// An opaque string that indicates the position at which the virtual tape recovery
	// points that were listed for description ended.
	//
	// Use this marker in your next request to list the next set of virtual tape
	// recovery points in the list. If there are no more recovery points to describe,
	// this field does not appear in the response.
	Marker *string `min:"1" type:"string"`

	// An array of TapeRecoveryPointInfos that are available for the specified gateway.
	TapeRecoveryPointInfos []*TapeRecoveryPointInfo `type:"list"`
}

// String returns the string representation
func (s DescribeTapeRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeRecoveryPointsOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeTapeRecoveryPointsOutput) SetGatewayARN(v string) *DescribeTapeRecoveryPointsOutput {
	s.GatewayARN = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapeRecoveryPointsOutput) SetMarker(v string) *DescribeTapeRecoveryPointsOutput {
	s.Marker = &v
	return s
}

// SetTapeRecoveryPointInfos sets the TapeRecoveryPointInfos field's value.
func (s *DescribeTapeRecoveryPointsOutput) SetTapeRecoveryPointInfos(v []*TapeRecoveryPointInfo) *DescribeTapeRecoveryPointsOutput {
	s.TapeRecoveryPointInfos = v
	return s
}

// DescribeTapesInput
type DescribeTapesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of virtual tapes described be limited to the specified
	// number.
	//
	// Amazon Web Services may impose its own limit, if this field is not set.
	Limit *int64 `min:"1" type:"integer"`

	// A marker value, obtained in a previous call to DescribeTapes. This marker
	// indicates which page of results to retrieve.
	//
	// If not specified, the first page of results is retrieved.
	Marker *string `min:"1" type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe. If this parameter is not specified,
	// Tape gateway returns a description of all virtual tapes associated with the
	// specified gateway.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapesInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeTapesInput) SetGatewayARN(v string) *DescribeTapesInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeTapesInput) SetLimit(v int64) *DescribeTapesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapesInput) SetMarker(v string) *DescribeTapesInput {
	s.Marker = &v
	return s
}

// SetTapeARNs sets the TapeARNs field's value.
func (s *DescribeTapesInput) SetTapeARNs(v []*string) *DescribeTapesInput {
	s.TapeARNs = v
	return s
}

// DescribeTapesOutput
type DescribeTapesOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string which can be used as part of a subsequent DescribeTapes
	// call to retrieve the next page of results.
	//
	// If a response does not contain a marker, then there are no more results to
	// be retrieved.
	Marker *string `min:"1" type:"string"`

	// An array of virtual tape descriptions.
	Tapes []*Tape `type:"list"`
}

// String returns the string representation
func (s DescribeTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapesOutput) SetMarker(v string) *DescribeTapesOutput {
	s.Marker = &v
	return s
}

// SetTapes sets the Tapes field's value.
func (s *DescribeTapesOutput) SetTapes(v []*Tape) *DescribeTapesOutput {
	s.Tapes = v
	return s
}

type DescribeUploadBufferInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUploadBufferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUploadBufferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUploadBufferInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeUploadBufferInput) SetGatewayARN(v string) *DescribeUploadBufferInput {
	s.GatewayARN = &v
	return s
}

type DescribeUploadBufferOutput struct {
	_ struct{} `type:"structure"`

	// An array of the gateway's local disk IDs that are configured as working storage.
	// Each local disk ID is specified as a string (minimum length of 1 and maximum
	// length of 300). If no local disks are configured as working storage, then
	// the DiskIds array is empty.
	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The total number of bytes allocated in the gateway's as upload buffer.
	UploadBufferAllocatedInBytes *int64 `type:"long"`

	// The total number of bytes being used in the gateway's upload buffer.
	UploadBufferUsedInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUploadBufferOutput) GoString() string {
	return s.String()
}

// SetDiskIds sets the DiskIds field's value.
func (s *DescribeUploadBufferOutput) SetDiskIds(v []*string) *DescribeUploadBufferOutput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeUploadBufferOutput) SetGatewayARN(v string) *DescribeUploadBufferOutput {
	s.GatewayARN = &v
	return s
}

// SetUploadBufferAllocatedInBytes sets the UploadBufferAllocatedInBytes field's value.
func (s *DescribeUploadBufferOutput) SetUploadBufferAllocatedInBytes(v int64) *DescribeUploadBufferOutput {
	s.UploadBufferAllocatedInBytes = &v
	return s
}

// SetUploadBufferUsedInBytes sets the UploadBufferUsedInBytes field's value.
func (s *DescribeUploadBufferOutput) SetUploadBufferUsedInBytes(v int64) *DescribeUploadBufferOutput {
	s.UploadBufferUsedInBytes = &v
	return s
}

// DescribeVTLDevicesInput
type DescribeVTLDevicesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of VTL devices described be limited to the specified
	// number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// the VTL devices.
	Marker *string `min:"1" type:"string"`

	// An array of strings, where each string represents the Amazon Resource Name
	// (ARN) of a VTL device.
	//
	// All of the specified VTL devices must be from the same gateway. If no VTL
	// devices are specified, the result will contain all devices on the specified
	// gateway.
	VTLDeviceARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeVTLDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVTLDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVTLDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVTLDevicesInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeVTLDevicesInput) SetGatewayARN(v string) *DescribeVTLDevicesInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeVTLDevicesInput) SetLimit(v int64) *DescribeVTLDevicesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeVTLDevicesInput) SetMarker(v string) *DescribeVTLDevicesInput {
	s.Marker = &v
	return s
}

// SetVTLDeviceARNs sets the VTLDeviceARNs field's value.
func (s *DescribeVTLDevicesInput) SetVTLDeviceARNs(v []*string) *DescribeVTLDevicesInput {
	s.VTLDeviceARNs = v
	return s
}

// DescribeVTLDevicesOutput
type DescribeVTLDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// An opaque string that indicates the position at which the VTL devices that
	// were fetched for description ended. Use the marker in your next request to
	// fetch the next set of VTL devices in the list. If there are no more VTL devices
	// to describe, this field does not appear in the response.
	Marker *string `min:"1" type:"string"`

	// An array of VTL device objects composed of the Amazon Resource Name (ARN)
	// of the VTL devices.
	VTLDevices []*VTLDevice `type:"list"`
}

// String returns the string representation
func (s DescribeVTLDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVTLDevicesOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeVTLDevicesOutput) SetGatewayARN(v string) *DescribeVTLDevicesOutput {
	s.GatewayARN = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeVTLDevicesOutput) SetMarker(v string) *DescribeVTLDevicesOutput {
	s.Marker = &v
	return s
}

// SetVTLDevices sets the VTLDevices field's value.
func (s *DescribeVTLDevicesOutput) SetVTLDevices(v []*VTLDevice) *DescribeVTLDevicesOutput {
	s.VTLDevices = v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway.
type DescribeWorkingStorageInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkingStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkingStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkingStorageInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeWorkingStorageInput) SetGatewayARN(v string) *DescribeWorkingStorageInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
type DescribeWorkingStorageOutput struct {
	_ struct{} `type:"structure"`

	// An array of the gateway's local disk IDs that are configured as working storage.
	// Each local disk ID is specified as a string (minimum length of 1 and maximum
	// length of 300). If no local disks are configured as working storage, then
	// the DiskIds array is empty.
	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The total working storage in bytes allocated for the gateway. If no working
	// storage is configured for the gateway, this field returns 0.
	WorkingStorageAllocatedInBytes *int64 `type:"long"`

	// The total working storage in bytes in use by the gateway. If no working storage
	// is configured for the gateway, this field returns 0.
	WorkingStorageUsedInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkingStorageOutput) GoString() string {
	return s.String()
}

// SetDiskIds sets the DiskIds field's value.
func (s *DescribeWorkingStorageOutput) SetDiskIds(v []*string) *DescribeWorkingStorageOutput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeWorkingStorageOutput) SetGatewayARN(v string) *DescribeWorkingStorageOutput {
	s.GatewayARN = &v
	return s
}

// SetWorkingStorageAllocatedInBytes sets the WorkingStorageAllocatedInBytes field's value.
func (s *DescribeWorkingStorageOutput) SetWorkingStorageAllocatedInBytes(v int64) *DescribeWorkingStorageOutput {
	s.WorkingStorageAllocatedInBytes = &v
	return s
}

// SetWorkingStorageUsedInBytes sets the WorkingStorageUsedInBytes field's value.
func (s *DescribeWorkingStorageOutput) SetWorkingStorageUsedInBytes(v int64) *DescribeWorkingStorageOutput {
	s.WorkingStorageUsedInBytes = &v
	return s
}

// AttachVolumeInput
type DetachVolumeInput struct {
	_ struct{} `type:"structure"`

	// Set to true to forcibly remove the iSCSI connection of the target volume
	// and detach the volume. The default is false. If this value is set to false,
	// you must manually disconnect the iSCSI connection from the target volume.
	//
	// Valid Values: true | false
	ForceDetach *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the volume to detach from the gateway.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachVolumeInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForceDetach sets the ForceDetach field's value.
func (s *DetachVolumeInput) SetForceDetach(v bool) *DetachVolumeInput {
	s.ForceDetach = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DetachVolumeInput) SetVolumeARN(v string) *DetachVolumeInput {
	s.VolumeARN = &v
	return s
}

// AttachVolumeOutput
type DetachVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume that was detached.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DetachVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachVolumeOutput) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DetachVolumeOutput) SetVolumeARN(v string) *DetachVolumeOutput {
	s.VolumeARN = &v
	return s
}

// Lists iSCSI information about a VTL device.
type DeviceiSCSIAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether mutual CHAP is enabled for the iSCSI target.
	ChapEnabled *bool `type:"boolean"`

	// The network interface identifier of the VTL device.
	NetworkInterfaceId *string `type:"string"`

	// The port used to communicate with iSCSI VTL device targets.
	NetworkInterfacePort *int64 `type:"integer"`

	// Specifies the unique Amazon Resource Name (ARN) that encodes the iSCSI qualified
	// name(iqn) of a tape drive or media changer target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeviceiSCSIAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceiSCSIAttributes) GoString() string {
	return s.String()
}

// SetChapEnabled sets the ChapEnabled field's value.
func (s *DeviceiSCSIAttributes) SetChapEnabled(v bool) *DeviceiSCSIAttributes {
	s.ChapEnabled = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *DeviceiSCSIAttributes) SetNetworkInterfaceId(v string) *DeviceiSCSIAttributes {
	s.NetworkInterfaceId = &v
	return s
}

// SetNetworkInterfacePort sets the NetworkInterfacePort field's value.
func (s *DeviceiSCSIAttributes) SetNetworkInterfacePort(v int64) *DeviceiSCSIAttributes {
	s.NetworkInterfacePort = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *DeviceiSCSIAttributes) SetTargetARN(v string) *DeviceiSCSIAttributes {
	s.TargetARN = &v
	return s
}

// DisableGatewayInput
type DisableGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DisableGatewayInput) SetGatewayARN(v string) *DisableGatewayInput {
	s.GatewayARN = &v
	return s
}

// DisableGatewayOutput
type DisableGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) of the disabled gateway.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DisableGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DisableGatewayOutput) SetGatewayARN(v string) *DisableGatewayOutput {
	s.GatewayARN = &v
	return s
}

// Represents a gateway's local disk.
type Disk struct {
	_ struct{} `type:"structure"`

	// The iSCSI qualified name (IQN) that is defined for a disk. This field is
	// not included in the response if the local disk is not defined as an iSCSI
	// target. The format of this field is targetIqn::LUNNumber::region-volumeId.
	DiskAllocationResource *string `type:"string"`

	// One of the DiskAllocationType enumeration values that identifies how a local
	// disk is used.
	//
	// Valid Values: UPLOAD_BUFFER | CACHE_STORAGE
	DiskAllocationType *string `min:"3" type:"string"`

	// A list of values that represents attributes of a local disk.
	DiskAttributeList []*string `type:"list"`

	// The unique device ID or other distinguishing data that identifies a local
	// disk.
	DiskId *string `min:"1" type:"string"`

	// The device node of a local disk as assigned by the virtualization environment.
	DiskNode *string `type:"string"`

	// The path of a local disk in the gateway virtual machine (VM).
	DiskPath *string `type:"string"`

	// The local disk size in bytes.
	DiskSizeInBytes *int64 `type:"long"`

	// A value that represents the status of a local disk.
	DiskStatus *string `type:"string"`
}

// String returns the string representation
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Disk) GoString() string {
	return s.String()
}

// SetDiskAllocationResource sets the DiskAllocationResource field's value.
func (s *Disk) SetDiskAllocationResource(v string) *Disk {
	s.DiskAllocationResource = &v
	return s
}

// SetDiskAllocationType sets the DiskAllocationType field's value.
func (s *Disk) SetDiskAllocationType(v string) *Disk {
	s.DiskAllocationType = &v
	return s
}

// SetDiskAttributeList sets the DiskAttributeList field's value.
func (s *Disk) SetDiskAttributeList(v []*string) *Disk {
	s.DiskAttributeList = v
	return s
}

// SetDiskId sets the DiskId field's value.
func (s *Disk) SetDiskId(v string) *Disk {
	s.DiskId = &v
	return s
}

// SetDiskNode sets the DiskNode field's value.
func (s *Disk) SetDiskNode(v string) *Disk {
	s.DiskNode = &v
	return s
}

// SetDiskPath sets the DiskPath field's value.
func (s *Disk) SetDiskPath(v string) *Disk {
	s.DiskPath = &v
	return s
}

// SetDiskSizeInBytes sets the DiskSizeInBytes field's value.
func (s *Disk) SetDiskSizeInBytes(v int64) *Disk {
	s.DiskSizeInBytes = &v
	return s
}

// SetDiskStatus sets the DiskStatus field's value.
func (s *Disk) SetDiskStatus(v string) *Disk {
	s.DiskStatus = &v
	return s
}

// Provides additional information about an error that was returned by the service.
// See the errorCode and errorDetails members for more information about the
// error.
type Error struct {
	_ struct{} `type:"structure"`

	// Additional information about the error.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// Human-readable text that provides detail about the error that occurred.
	ErrorDetails map[string]*string `locationName:"errorDetails" type:"map"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Error) SetErrorCode(v string) *Error {
	s.ErrorCode = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *Error) SetErrorDetails(v map[string]*string) *Error {
	s.ErrorDetails = v
	return s
}

// Describes a file share.
type FileShareInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string `min:"50" type:"string"`

	// The ID of the file share.
	FileShareId *string `min:"12" type:"string"`

	// The status of the file share.
	//
	// Valid Values: CREATING | UPDATING | AVAILABLE | DELETING
	FileShareStatus *string `min:"3" type:"string"`

	// The type of the file share.
	FileShareType *string `type:"string" enum:"FileShareType"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s FileShareInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileShareInfo) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *FileShareInfo) SetFileShareARN(v string) *FileShareInfo {
	s.FileShareARN = &v
	return s
}

// SetFileShareId sets the FileShareId field's value.
func (s *FileShareInfo) SetFileShareId(v string) *FileShareInfo {
	s.FileShareId = &v
	return s
}

// SetFileShareStatus sets the FileShareStatus field's value.
func (s *FileShareInfo) SetFileShareStatus(v string) *FileShareInfo {
	s.FileShareStatus = &v
	return s
}

// SetFileShareType sets the FileShareType field's value.
func (s *FileShareInfo) SetFileShareType(v string) *FileShareInfo {
	s.FileShareType = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *FileShareInfo) SetGatewayARN(v string) *FileShareInfo {
	s.GatewayARN = &v
	return s
}

// Describes a gateway object.
type GatewayInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon EC2 instance that was used to launch the gateway.
	Ec2InstanceId *string `type:"string"`

	// The AWS Region where the Amazon EC2 instance is located.
	Ec2InstanceRegion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	GatewayId *string `min:"12" type:"string"`

	// The name of the gateway.
	GatewayName *string `type:"string"`

	// The state of the gateway.
	//
	// Valid Values: DISABLED | ACTIVE
	GatewayOperationalState *string `min:"2" type:"string"`

	// The type of the gateway.
	GatewayType *string `min:"2" type:"string"`
}

// String returns the string representation
func (s GatewayInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayInfo) GoString() string {
	return s.String()
}

// SetEc2InstanceId sets the Ec2InstanceId field's value.
func (s *GatewayInfo) SetEc2InstanceId(v string) *GatewayInfo {
	s.Ec2InstanceId = &v
	return s
}

// SetEc2InstanceRegion sets the Ec2InstanceRegion field's value.
func (s *GatewayInfo) SetEc2InstanceRegion(v string) *GatewayInfo {
	s.Ec2InstanceRegion = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *GatewayInfo) SetGatewayARN(v string) *GatewayInfo {
	s.GatewayARN = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *GatewayInfo) SetGatewayId(v string) *GatewayInfo {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *GatewayInfo) SetGatewayName(v string) *GatewayInfo {
	s.GatewayName = &v
	return s
}

// SetGatewayOperationalState sets the GatewayOperationalState field's value.
func (s *GatewayInfo) SetGatewayOperationalState(v string) *GatewayInfo {
	s.GatewayOperationalState = &v
	return s
}

// SetGatewayType sets the GatewayType field's value.
func (s *GatewayInfo) SetGatewayType(v string) *GatewayInfo {
	s.GatewayType = &v
	return s
}

// An internal server error has occurred during the request. For more information,
// see the error and message fields.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A StorageGatewayError that provides more information about the cause of the
	// error.
	Error_ *Error `locationName:"error" type:"structure"`

	// A human-readable message describing the error that occurred.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// An exception occurred because an invalid gateway request was issued to the
// service. For more information, see the error and message fields.
type InvalidGatewayRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A StorageGatewayError that provides more detail about the cause of the error.
	Error_ *Error `locationName:"error" type:"structure"`

	// A human-readable message describing the error that occurred.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidGatewayRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidGatewayRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidGatewayRequestException(v protocol.ResponseMetadata) error {
	return &InvalidGatewayRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidGatewayRequestException) Code() string {
	return "InvalidGatewayRequestException"
}

// Message returns the exception's message.
func (s *InvalidGatewayRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidGatewayRequestException) OrigErr() error {
	return nil
}

func (s *InvalidGatewayRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidGatewayRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidGatewayRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// JoinDomainInput
type JoinDomainInput struct {
	_ struct{} `type:"structure"`

	// List of IPv4 addresses, NetBIOS names, or host names of your domain server.
	// If you need to specify the port number include it after the colon (“:”).
	// For example, mydc.mydomain.com:389.
	DomainControllers []*string `type:"list"`

	// The name of the domain that you want the gateway to join.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The organizational unit (OU) is a container in an Active Directory that can
	// hold users, groups, computers, and other OUs and this parameter specifies
	// the OU that the gateway will join within the AD domain.
	OrganizationalUnit *string `min:"1" type:"string"`

	// Sets the password of the user who has permission to add the gateway to the
	// Active Directory domain.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Specifies the time in seconds, in which the JoinDomain operation must complete.
	// The default is 20 seconds.
	TimeoutInSeconds *int64 `type:"integer"`

	// Sets the user name of user who has permission to add the gateway to the Active
	// Directory domain. The domain user account should be enabled to join computers
	// to the domain. For example, you can use the domain administrator account
	// or an account with delegated permissions to join computers to the domain.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s JoinDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JoinDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JoinDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JoinDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.OrganizationalUnit != nil && len(*s.OrganizationalUnit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationalUnit", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainControllers sets the DomainControllers field's value.
func (s *JoinDomainInput) SetDomainControllers(v []*string) *JoinDomainInput {
	s.DomainControllers = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *JoinDomainInput) SetDomainName(v string) *JoinDomainInput {
	s.DomainName = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *JoinDomainInput) SetGatewayARN(v string) *JoinDomainInput {
	s.GatewayARN = &v
	return s
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *JoinDomainInput) SetOrganizationalUnit(v string) *JoinDomainInput {
	s.OrganizationalUnit = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *JoinDomainInput) SetPassword(v string) *JoinDomainInput {
	s.Password = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *JoinDomainInput) SetTimeoutInSeconds(v int64) *JoinDomainInput {
	s.TimeoutInSeconds = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *JoinDomainInput) SetUserName(v string) *JoinDomainInput {
	s.UserName = &v
	return s
}

// JoinDomainOutput
type JoinDomainOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the status of the gateway as a member of the Active Directory domain.
	//
	//    * ACCESS_DENIED: Indicates that the JoinDomain operation failed due to
	//    an authentication error.
	//
	//    * DETACHED: Indicates that gateway is not joined to a domain.
	//
	//    * JOINED: Indicates that the gateway has successfully joined a domain.
	//
	//    * JOINING: Indicates that a JoinDomain operation is in progress.
	//
	//    * NETWORK_ERROR: Indicates that JoinDomain operation failed due to a network
	//    or connectivity error.
	//
	//    * TIMEOUT: Indicates that the JoinDomain operation failed because the
	//    operation didn't complete within the allotted time.
	//
	//    * UNKNOWN_ERROR: Indicates that the JoinDomain operation failed due to
	//    another type of error.
	ActiveDirectoryStatus *string `type:"string" enum:"ActiveDirectoryStatus"`

	// The unique Amazon Resource Name (ARN) of the gateway that joined the domain.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s JoinDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JoinDomainOutput) GoString() string {
	return s.String()
}

// SetActiveDirectoryStatus sets the ActiveDirectoryStatus field's value.
func (s *JoinDomainOutput) SetActiveDirectoryStatus(v string) *JoinDomainOutput {
	s.ActiveDirectoryStatus = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *JoinDomainOutput) SetGatewayARN(v string) *JoinDomainOutput {
	s.GatewayARN = &v
	return s
}

type ListAutomaticTapeCreationPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ListAutomaticTapeCreationPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAutomaticTapeCreationPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAutomaticTapeCreationPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAutomaticTapeCreationPoliciesInput"}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListAutomaticTapeCreationPoliciesInput) SetGatewayARN(v string) *ListAutomaticTapeCreationPoliciesInput {
	s.GatewayARN = &v
	return s
}

type ListAutomaticTapeCreationPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Gets a listing of information about the gateway's automatic tape creation
	// policies, including the automatic tape creation rules and the gateway that
	// is using the policies.
	AutomaticTapeCreationPolicyInfos []*AutomaticTapeCreationPolicyInfo `type:"list"`
}

// String returns the string representation
func (s ListAutomaticTapeCreationPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAutomaticTapeCreationPoliciesOutput) GoString() string {
	return s.String()
}

// SetAutomaticTapeCreationPolicyInfos sets the AutomaticTapeCreationPolicyInfos field's value.
func (s *ListAutomaticTapeCreationPoliciesOutput) SetAutomaticTapeCreationPolicyInfos(v []*AutomaticTapeCreationPolicyInfo) *ListAutomaticTapeCreationPoliciesOutput {
	s.AutomaticTapeCreationPolicyInfos = v
	return s
}

// ListFileShareInput
type ListFileSharesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway whose file shares you want
	// to list. If this field is not present, all file shares under your account
	// are listed.
	GatewayARN *string `min:"50" type:"string"`

	// The maximum number of file shares to return in the response. The value must
	// be an integer with a value greater than zero. Optional.
	Limit *int64 `min:"1" type:"integer"`

	// Opaque pagination token returned from a previous ListFileShares operation.
	// If present, Marker specifies where to continue the list from after a previous
	// call to ListFileShares. Optional.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFileSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFileSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFileSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFileSharesInput"}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListFileSharesInput) SetGatewayARN(v string) *ListFileSharesInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListFileSharesInput) SetLimit(v int64) *ListFileSharesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListFileSharesInput) SetMarker(v string) *ListFileSharesInput {
	s.Marker = &v
	return s
}

// ListFileShareOutput
type ListFileSharesOutput struct {
	_ struct{} `type:"structure"`

	// An array of information about the file gateway's file shares.
	FileShareInfoList []*FileShareInfo `type:"list"`

	// If the request includes Marker, the response returns that value in this field.
	Marker *string `min:"1" type:"string"`

	// If a value is present, there are more file shares to return. In a subsequent
	// request, use NextMarker as the value for Marker to retrieve the next set
	// of file shares.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFileSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFileSharesOutput) GoString() string {
	return s.String()
}

// SetFileShareInfoList sets the FileShareInfoList field's value.
func (s *ListFileSharesOutput) SetFileShareInfoList(v []*FileShareInfo) *ListFileSharesOutput {
	s.FileShareInfoList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListFileSharesOutput) SetMarker(v string) *ListFileSharesOutput {
	s.Marker = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListFileSharesOutput) SetNextMarker(v string) *ListFileSharesOutput {
	s.NextMarker = &v
	return s
}

// A JSON object containing zero or more of the following fields:
//
//    * ListGatewaysInput$Limit
//
//    * ListGatewaysInput$Marker
type ListGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the list of gateways returned be limited to the specified
	// number of items.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin the returned
	// list of gateways.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListGatewaysInput) SetLimit(v int64) *ListGatewaysInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGatewaysInput) SetMarker(v string) *ListGatewaysInput {
	s.Marker = &v
	return s
}

type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// An array of GatewayInfo objects.
	Gateways []*GatewayInfo `type:"list"`

	// Use the marker in your next request to fetch the next set of gateways in
	// the list. If there are no more gateways to list, this field does not appear
	// in the response.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysOutput) GoString() string {
	return s.String()
}

// SetGateways sets the Gateways field's value.
func (s *ListGatewaysOutput) SetGateways(v []*GatewayInfo) *ListGatewaysOutput {
	s.Gateways = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGatewaysOutput) SetMarker(v string) *ListGatewaysOutput {
	s.Marker = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway.
type ListLocalDisksInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLocalDisksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocalDisksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLocalDisksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLocalDisksInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListLocalDisksInput) SetGatewayARN(v string) *ListLocalDisksInput {
	s.GatewayARN = &v
	return s
}

type ListLocalDisksOutput struct {
	_ struct{} `type:"structure"`

	// A JSON object containing the following fields:
	//
	//    * ListLocalDisksOutput$Disks
	Disks []*Disk `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ListLocalDisksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocalDisksOutput) GoString() string {
	return s.String()
}

// SetDisks sets the Disks field's value.
func (s *ListLocalDisksOutput) SetDisks(v []*Disk) *ListLocalDisksOutput {
	s.Disks = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListLocalDisksOutput) SetGatewayARN(v string) *ListLocalDisksOutput {
	s.GatewayARN = &v
	return s
}

// ListTagsForResourceInput
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the list of tags returned be limited to the specified number
	// of items.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin returning
	// the list of tags.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource for which you want to list
	// tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListTagsForResourceInput) SetMarker(v string) *ListTagsForResourceInput {
	s.Marker = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

// ListTagsForResourceOutput
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to stop returning the
	// list of tags.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource for which you want to list
	// tags.
	ResourceARN *string `min:"50" type:"string"`

	// An array that contains the tags for the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListTagsForResourceOutput) SetMarker(v string) *ListTagsForResourceOutput {
	s.Marker = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceOutput) SetResourceARN(v string) *ListTagsForResourceOutput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTapePoolsInput struct {
	_ struct{} `type:"structure"`

	// An optional number limit for the tape pools in the list returned by this
	// call.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of tape pools.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of each of the custom tape pools you want
	// to list. If you don't specify a custom tape pool ARN, the response lists
	// all custom tape pools.
	PoolARNs []*string `type:"list"`
}

// String returns the string representation
func (s ListTapePoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTapePoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTapePoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTapePoolsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTapePoolsInput) SetLimit(v int64) *ListTapePoolsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListTapePoolsInput) SetMarker(v string) *ListTapePoolsInput {
	s.Marker = &v
	return s
}

// SetPoolARNs sets the PoolARNs field's value.
func (s *ListTapePoolsInput) SetPoolARNs(v []*string) *ListTapePoolsInput {
	s.PoolARNs = v
	return s
}

type ListTapePoolsOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates the position at which to begin the returned list
	// of tape pools. Use the marker in your next request to continue pagination
	// of tape pools. If there are no more tape pools to list, this element does
	// not appear in the response body.
	Marker *string `min:"1" type:"string"`

	// An array of PoolInfo objects, where each object describes a single custom
	// tape pool. If there are no custom tape pools, the PoolInfos is an empty array.
	PoolInfos []*PoolInfo `type:"list"`
}

// String returns the string representation
func (s ListTapePoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTapePoolsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListTapePoolsOutput) SetMarker(v string) *ListTapePoolsOutput {
	s.Marker = &v
	return s
}

// SetPoolInfos sets the PoolInfos field's value.
func (s *ListTapePoolsOutput) SetPoolInfos(v []*PoolInfo) *ListTapePoolsOutput {
	s.PoolInfos = v
	return s
}

// A JSON object that contains one or more of the following fields:
//
//    * ListTapesInput$Limit
//
//    * ListTapesInput$Marker
//
//    * ListTapesInput$TapeARNs
type ListTapesInput struct {
	_ struct{} `type:"structure"`

	// An optional number limit for the tapes in the list returned by this call.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of tapes.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of each of the tapes you want to list. If
	// you don't specify a tape ARN, the response lists all tapes in both your VTL
	// and VTS.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s ListTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTapesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTapesInput) SetLimit(v int64) *ListTapesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListTapesInput) SetMarker(v string) *ListTapesInput {
	s.Marker = &v
	return s
}

// SetTapeARNs sets the TapeARNs field's value.
func (s *ListTapesInput) SetTapeARNs(v []*string) *ListTapesInput {
	s.TapeARNs = v
	return s
}

// A JSON object containing the following fields:
//
//    * ListTapesOutput$Marker
//
//    * ListTapesOutput$VolumeInfos
type ListTapesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates the position at which to begin returning the next
	// list of tapes. Use the marker in your next request to continue pagination
	// of tapes. If there are no more tapes to list, this element does not appear
	// in the response body.
	Marker *string `min:"1" type:"string"`

	// An array of TapeInfo objects, where each object describes a single tape.
	// If there are no tapes in the tape library or VTS, then the TapeInfos is an
	// empty array.
	TapeInfos []*TapeInfo `type:"list"`
}

// String returns the string representation
func (s ListTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTapesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListTapesOutput) SetMarker(v string) *ListTapesOutput {
	s.Marker = &v
	return s
}

// SetTapeInfos sets the TapeInfos field's value.
func (s *ListTapesOutput) SetTapeInfos(v []*TapeInfo) *ListTapesOutput {
	s.TapeInfos = v
	return s
}

// ListVolumeInitiatorsInput
type ListVolumeInitiatorsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes for the gateway.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListVolumeInitiatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeInitiatorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumeInitiatorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumeInitiatorsInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *ListVolumeInitiatorsInput) SetVolumeARN(v string) *ListVolumeInitiatorsInput {
	s.VolumeARN = &v
	return s
}

// ListVolumeInitiatorsOutput
type ListVolumeInitiatorsOutput struct {
	_ struct{} `type:"structure"`

	// The host names and port numbers of all iSCSI initiators that are connected
	// to the gateway.
	Initiators []*string `type:"list"`
}

// String returns the string representation
func (s ListVolumeInitiatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeInitiatorsOutput) GoString() string {
	return s.String()
}

// SetInitiators sets the Initiators field's value.
func (s *ListVolumeInitiatorsOutput) SetInitiators(v []*string) *ListVolumeInitiatorsOutput {
	s.Initiators = v
	return s
}

type ListVolumeRecoveryPointsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListVolumeRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeRecoveryPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumeRecoveryPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumeRecoveryPointsInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListVolumeRecoveryPointsInput) SetGatewayARN(v string) *ListVolumeRecoveryPointsInput {
	s.GatewayARN = &v
	return s
}

type ListVolumeRecoveryPointsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// An array of VolumeRecoveryPointInfo objects.
	VolumeRecoveryPointInfos []*VolumeRecoveryPointInfo `type:"list"`
}

// String returns the string representation
func (s ListVolumeRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeRecoveryPointsOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListVolumeRecoveryPointsOutput) SetGatewayARN(v string) *ListVolumeRecoveryPointsOutput {
	s.GatewayARN = &v
	return s
}

// SetVolumeRecoveryPointInfos sets the VolumeRecoveryPointInfos field's value.
func (s *ListVolumeRecoveryPointsOutput) SetVolumeRecoveryPointInfos(v []*VolumeRecoveryPointInfo) *ListVolumeRecoveryPointsOutput {
	s.VolumeRecoveryPointInfos = v
	return s
}

// A JSON object that contains one or more of the following fields:
//
//    * ListVolumesInput$Limit
//
//    * ListVolumesInput$Marker
type ListVolumesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// Specifies that the list of volumes returned be limited to the specified number
	// of items.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of volumes. Obtain the marker from the response of a previous List iSCSI
	// Volumes request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumesInput"}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListVolumesInput) SetGatewayARN(v string) *ListVolumesInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListVolumesInput) SetLimit(v int64) *ListVolumesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVolumesInput) SetMarker(v string) *ListVolumesInput {
	s.Marker = &v
	return s
}

// A JSON object containing the following fields:
//
//    * ListVolumesOutput$Marker
//
//    * ListVolumesOutput$VolumeInfos
type ListVolumesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// Use the marker in your next request to continue pagination of iSCSI volumes.
	// If there are no more volumes to list, this field does not appear in the response
	// body.
	Marker *string `min:"1" type:"string"`

	// An array of VolumeInfo objects, where each object describes an iSCSI volume.
	// If no volumes are defined for the gateway, then VolumeInfos is an empty array
	// "[]".
	VolumeInfos []*VolumeInfo `type:"list"`
}

// String returns the string representation
func (s ListVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumesOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListVolumesOutput) SetGatewayARN(v string) *ListVolumesOutput {
	s.GatewayARN = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVolumesOutput) SetMarker(v string) *ListVolumesOutput {
	s.Marker = &v
	return s
}

// SetVolumeInfos sets the VolumeInfos field's value.
func (s *ListVolumesOutput) SetVolumeInfos(v []*VolumeInfo) *ListVolumesOutput {
	s.VolumeInfos = v
	return s
}

// Describes Network File System (NFS) file share default values. Files and
// folders stored as Amazon S3 objects in S3 buckets don't, by default, have
// Unix file permissions assigned to them. Upon discovery in an S3 bucket by
// Storage Gateway, the S3 objects that represent files and folders are assigned
// these default Unix permissions. This operation is only supported for file
// gateways.
type NFSFileShareDefaults struct {
	_ struct{} `type:"structure"`

	// The Unix directory mode in the form "nnnn". For example, 0666 represents
	// the default access mode for all directories inside the file share. The default
	// value is 0777.
	DirectoryMode *string `min:"1" type:"string"`

	// The Unix file mode in the form "nnnn". For example, 0666 represents the default
	// file mode inside the file share. The default value is 0666.
	FileMode *string `min:"1" type:"string"`

	// The default group ID for the file share (unless the files have another group
	// ID specified). The default value is nfsnobody.
	GroupId *int64 `type:"long"`

	// The default owner ID for files in the file share (unless the files have another
	// owner ID specified). The default value is nfsnobody.
	OwnerId *int64 `type:"long"`
}

// String returns the string representation
func (s NFSFileShareDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NFSFileShareDefaults) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NFSFileShareDefaults) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NFSFileShareDefaults"}
	if s.DirectoryMode != nil && len(*s.DirectoryMode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryMode", 1))
	}
	if s.FileMode != nil && len(*s.FileMode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileMode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryMode sets the DirectoryMode field's value.
func (s *NFSFileShareDefaults) SetDirectoryMode(v string) *NFSFileShareDefaults {
	s.DirectoryMode = &v
	return s
}

// SetFileMode sets the FileMode field's value.
func (s *NFSFileShareDefaults) SetFileMode(v string) *NFSFileShareDefaults {
	s.FileMode = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *NFSFileShareDefaults) SetGroupId(v int64) *NFSFileShareDefaults {
	s.GroupId = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *NFSFileShareDefaults) SetOwnerId(v int64) *NFSFileShareDefaults {
	s.OwnerId = &v
	return s
}

// The Unix file permissions and ownership information assigned, by default,
// to native S3 objects when file gateway discovers them in S3 buckets. This
// operation is only supported in file gateways.
type NFSFileShareInfo struct {
	_ struct{} `type:"structure"`

	// Refresh cache information.
	CacheAttributes *CacheAttributes `type:"structure"`

	// The list of clients that are allowed to access the file gateway. The list
	// must contain either valid IP addresses or valid CIDR blocks.
	ClientList []*string `min:"1" type:"list"`

	// The default storage class for objects put into an Amazon S3 bucket by the
	// file gateway. The default value is S3_INTELLIGENT_TIERING. Optional.
	//
	// Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
	DefaultStorageClass *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string `min:"50" type:"string"`

	// The ID of the file share.
	FileShareId *string `min:"12" type:"string"`

	// The name of the file share. Optional.
	//
	// FileShareName must be set if an S3 prefix name is set in LocationARN.
	FileShareName *string `min:"1" type:"string"`

	// The status of the file share.
	//
	// Valid Values: CREATING | UPDATING | AVAILABLE | DELETING
	FileShareStatus *string `min:"3" type:"string"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// A value that enables guessing of the MIME type for uploaded objects based
	// on file extensions. Set this value to true to enable MIME type guessing,
	// otherwise set to false. The default value is true.
	//
	// Valid Values: true | false
	GuessMIMETypeEnabled *bool `type:"boolean"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The ARN of the backend storage used for storing file data. A prefix name
	// can be added to the S3 bucket name. It must end with a "/".
	LocationARN *string `min:"16" type:"string"`

	// Describes Network File System (NFS) file share default values. Files and
	// folders stored as Amazon S3 objects in S3 buckets don't, by default, have
	// Unix file permissions assigned to them. Upon discovery in an S3 bucket by
	// Storage Gateway, the S3 objects that represent files and folders are assigned
	// these default Unix permissions. This operation is only supported for file
	// gateways.
	NFSFileShareDefaults *NFSFileShareDefaults `type:"structure"`

	// The notification policy of the file share.
	NotificationPolicy *string `min:"2" type:"string"`

	// A value that sets the access control list (ACL) permission for objects in
	// the S3 bucket that a file gateway puts objects into. The default value is
	// private.
	ObjectACL *string `type:"string" enum:"ObjectACL"`

	// The file share path used by the NFS client to identify the mount point.
	Path *string `type:"string"`

	// A value that sets the write status of a file share. Set this value to true
	// to set the write status to read-only, otherwise set to false.
	//
	// Valid Values: true | false
	ReadOnly *bool `type:"boolean"`

	// A value that sets who pays the cost of the request and the cost associated
	// with data download from the S3 bucket. If this value is set to true, the
	// requester pays the costs; otherwise, the S3 bucket owner pays. However, the
	// S3 bucket owner always pays the cost of storing data.
	//
	// RequesterPays is a configuration for the S3 bucket that backs the file share,
	// so make sure that the configuration on the file share is the same as the
	// S3 bucket configuration.
	//
	// Valid Values: true | false
	RequesterPays *bool `type:"boolean"`

	// The ARN of the IAM role that file gateway assumes when it accesses the underlying
	// storage.
	Role *string `min:"20" type:"string"`

	// The user mapped to anonymous user. Valid options are the following:
	//
	//    * RootSquash: Only root is mapped to anonymous user.
	//
	//    * NoSquash: No one is mapped to anonymous user.
	//
	//    * AllSquash: Everyone is mapped to anonymous user.
	Squash *string `min:"5" type:"string"`

	// A list of up to 50 tags assigned to the NFS file share, sorted alphabetically
	// by key name. Each tag is a key-value pair. For a gateway with more than 10
	// tags assigned, you can view all tags using the ListTagsForResource API operation.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s NFSFileShareInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NFSFileShareInfo) GoString() string {
	return s.String()
}

// SetCacheAttributes sets the CacheAttributes field's value.
func (s *NFSFileShareInfo) SetCacheAttributes(v *CacheAttributes) *NFSFileShareInfo {
	s.CacheAttributes = v
	return s
}

// SetClientList sets the ClientList field's value.
func (s *NFSFileShareInfo) SetClientList(v []*string) *NFSFileShareInfo {
	s.ClientList = v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *NFSFileShareInfo) SetDefaultStorageClass(v string) *NFSFileShareInfo {
	s.DefaultStorageClass = &v
	return s
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *NFSFileShareInfo) SetFileShareARN(v string) *NFSFileShareInfo {
	s.FileShareARN = &v
	return s
}

// SetFileShareId sets the FileShareId field's value.
func (s *NFSFileShareInfo) SetFileShareId(v string) *NFSFileShareInfo {
	s.FileShareId = &v
	return s
}

// SetFileShareName sets the FileShareName field's value.
func (s *NFSFileShareInfo) SetFileShareName(v string) *NFSFileShareInfo {
	s.FileShareName = &v
	return s
}

// SetFileShareStatus sets the FileShareStatus field's value.
func (s *NFSFileShareInfo) SetFileShareStatus(v string) *NFSFileShareInfo {
	s.FileShareStatus = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *NFSFileShareInfo) SetGatewayARN(v string) *NFSFileShareInfo {
	s.GatewayARN = &v
	return s
}

// SetGuessMIMETypeEnabled sets the GuessMIMETypeEnabled field's value.
func (s *NFSFileShareInfo) SetGuessMIMETypeEnabled(v bool) *NFSFileShareInfo {
	s.GuessMIMETypeEnabled = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *NFSFileShareInfo) SetKMSEncrypted(v bool) *NFSFileShareInfo {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *NFSFileShareInfo) SetKMSKey(v string) *NFSFileShareInfo {
	s.KMSKey = &v
	return s
}

// SetLocationARN sets the LocationARN field's value.
func (s *NFSFileShareInfo) SetLocationARN(v string) *NFSFileShareInfo {
	s.LocationARN = &v
	return s
}

// SetNFSFileShareDefaults sets the NFSFileShareDefaults field's value.
func (s *NFSFileShareInfo) SetNFSFileShareDefaults(v *NFSFileShareDefaults) *NFSFileShareInfo {
	s.NFSFileShareDefaults = v
	return s
}

// SetNotificationPolicy sets the NotificationPolicy field's value.
func (s *NFSFileShareInfo) SetNotificationPolicy(v string) *NFSFileShareInfo {
	s.NotificationPolicy = &v
	return s
}

// SetObjectACL sets the ObjectACL field's value.
func (s *NFSFileShareInfo) SetObjectACL(v string) *NFSFileShareInfo {
	s.ObjectACL = &v
	return s
}

// SetPath sets the Path field's value.
func (s *NFSFileShareInfo) SetPath(v string) *NFSFileShareInfo {
	s.Path = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *NFSFileShareInfo) SetReadOnly(v bool) *NFSFileShareInfo {
	s.ReadOnly = &v
	return s
}

// SetRequesterPays sets the RequesterPays field's value.
func (s *NFSFileShareInfo) SetRequesterPays(v bool) *NFSFileShareInfo {
	s.RequesterPays = &v
	return s
}

// SetRole sets the Role field's value.
func (s *NFSFileShareInfo) SetRole(v string) *NFSFileShareInfo {
	s.Role = &v
	return s
}

// SetSquash sets the Squash field's value.
func (s *NFSFileShareInfo) SetSquash(v string) *NFSFileShareInfo {
	s.Squash = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *NFSFileShareInfo) SetTags(v []*Tag) *NFSFileShareInfo {
	s.Tags = v
	return s
}

// Describes a gateway's network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The Internet Protocol version 4 (IPv4) address of the interface.
	Ipv4Address *string `type:"string"`

	// The Internet Protocol version 6 (IPv6) address of the interface. Currently
	// not supported.
	Ipv6Address *string `type:"string"`

	// The Media Access Control (MAC) address of the interface.
	//
	// This is currently unsupported and will not be returned in output.
	MacAddress *string `type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetIpv4Address sets the Ipv4Address field's value.
func (s *NetworkInterface) SetIpv4Address(v string) *NetworkInterface {
	s.Ipv4Address = &v
	return s
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *NetworkInterface) SetIpv6Address(v string) *NetworkInterface {
	s.Ipv6Address = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *NetworkInterface) SetMacAddress(v string) *NetworkInterface {
	s.MacAddress = &v
	return s
}

type NotifyWhenUploadedInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share.
	//
	// FileShareARN is a required field
	FileShareARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s NotifyWhenUploadedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyWhenUploadedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyWhenUploadedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyWhenUploadedInput"}
	if s.FileShareARN == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARN"))
	}
	if s.FileShareARN != nil && len(*s.FileShareARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *NotifyWhenUploadedInput) SetFileShareARN(v string) *NotifyWhenUploadedInput {
	s.FileShareARN = &v
	return s
}

type NotifyWhenUploadedOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string `min:"50" type:"string"`

	// The randomly generated ID of the notification that was sent. This ID is in
	// UUID format.
	NotificationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotifyWhenUploadedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyWhenUploadedOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *NotifyWhenUploadedOutput) SetFileShareARN(v string) *NotifyWhenUploadedOutput {
	s.FileShareARN = &v
	return s
}

// SetNotificationId sets the NotificationId field's value.
func (s *NotifyWhenUploadedOutput) SetNotificationId(v string) *NotifyWhenUploadedOutput {
	s.NotificationId = &v
	return s
}

// Describes a custom tape pool.
type PoolInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom tape pool. Use the ListTapePools
	// operation to return a list of custom tape pools for your account and AWS
	// Region.
	PoolARN *string `min:"50" type:"string"`

	// The name of the custom tape pool. PoolName can use all ASCII characters,
	// except '/' and '\'.
	PoolName *string `min:"1" type:"string"`

	// Status of the custom tape pool. Pool can be ACTIVE or DELETED.
	PoolStatus *string `type:"string" enum:"PoolStatus"`

	// Tape retention lock time is set in days. Tape retention lock can be enabled
	// for up to 100 years (36,500 days).
	RetentionLockTimeInDays *int64 `type:"integer"`

	// Tape retention lock type, which can be configured in two modes. When configured
	// in governance mode, AWS accounts with specific IAM permissions are authorized
	// to remove the tape retention lock from archived virtual tapes. When configured
	// in compliance mode, the tape retention lock cannot be removed by any user,
	// including the root AWS account.
	RetentionLockType *string `type:"string" enum:"RetentionLockType"`

	// The storage class that is associated with the custom pool. When you use your
	// backup application to eject the tape, the tape is archived directly into
	// the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds
	// to the pool.
	StorageClass *string `type:"string" enum:"TapeStorageClass"`
}

// String returns the string representation
func (s PoolInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PoolInfo) GoString() string {
	return s.String()
}

// SetPoolARN sets the PoolARN field's value.
func (s *PoolInfo) SetPoolARN(v string) *PoolInfo {
	s.PoolARN = &v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *PoolInfo) SetPoolName(v string) *PoolInfo {
	s.PoolName = &v
	return s
}

// SetPoolStatus sets the PoolStatus field's value.
func (s *PoolInfo) SetPoolStatus(v string) *PoolInfo {
	s.PoolStatus = &v
	return s
}

// SetRetentionLockTimeInDays sets the RetentionLockTimeInDays field's value.
func (s *PoolInfo) SetRetentionLockTimeInDays(v int64) *PoolInfo {
	s.RetentionLockTimeInDays = &v
	return s
}

// SetRetentionLockType sets the RetentionLockType field's value.
func (s *PoolInfo) SetRetentionLockType(v string) *PoolInfo {
	s.RetentionLockType = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *PoolInfo) SetStorageClass(v string) *PoolInfo {
	s.StorageClass = &v
	return s
}

// RefreshCacheInput
type RefreshCacheInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share you want to refresh.
	//
	// FileShareARN is a required field
	FileShareARN *string `min:"50" type:"string" required:"true"`

	// A comma-separated list of the paths of folders to refresh in the cache. The
	// default is ["/"]. The default refreshes objects and folders at the root of
	// the Amazon S3 bucket. If Recursive is set to true, the entire S3 bucket that
	// the file share has access to is refreshed.
	FolderList []*string `min:"1" type:"list"`

	// A value that specifies whether to recursively refresh folders in the cache.
	// The refresh includes folders that were in the cache the last time the gateway
	// listed the folder's contents. If this value set to true, each folder that
	// is listed in FolderList is recursively updated. Otherwise, subfolders listed
	// in FolderList are not refreshed. Only objects that are in folders listed
	// directly under FolderList are found and used for the update. The default
	// is true.
	//
	// Valid Values: true | false
	Recursive *bool `type:"boolean"`
}

// String returns the string representation
func (s RefreshCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshCacheInput"}
	if s.FileShareARN == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARN"))
	}
	if s.FileShareARN != nil && len(*s.FileShareARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARN", 50))
	}
	if s.FolderList != nil && len(s.FolderList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *RefreshCacheInput) SetFileShareARN(v string) *RefreshCacheInput {
	s.FileShareARN = &v
	return s
}

// SetFolderList sets the FolderList field's value.
func (s *RefreshCacheInput) SetFolderList(v []*string) *RefreshCacheInput {
	s.FolderList = v
	return s
}

// SetRecursive sets the Recursive field's value.
func (s *RefreshCacheInput) SetRecursive(v bool) *RefreshCacheInput {
	s.Recursive = &v
	return s
}

// RefreshCacheOutput
type RefreshCacheOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string `min:"50" type:"string"`

	// The randomly generated ID of the notification that was sent. This ID is in
	// UUID format.
	NotificationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RefreshCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshCacheOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *RefreshCacheOutput) SetFileShareARN(v string) *RefreshCacheOutput {
	s.FileShareARN = &v
	return s
}

// SetNotificationId sets the NotificationId field's value.
func (s *RefreshCacheOutput) SetNotificationId(v string) *RefreshCacheOutput {
	s.NotificationId = &v
	return s
}

// RemoveTagsFromResourceInput
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to remove the tags
	// from.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`

	// The keys of the tags you want to remove from the specified resource. A tag
	// is composed of a key-value pair.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *RemoveTagsFromResourceInput) SetResourceARN(v string) *RemoveTagsFromResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

// RemoveTagsFromResourceOutput
type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that the tags were removed
	// from.
	ResourceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *RemoveTagsFromResourceOutput) SetResourceARN(v string) *RemoveTagsFromResourceOutput {
	s.ResourceARN = &v
	return s
}

type ResetCacheInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetCacheInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ResetCacheInput) SetGatewayARN(v string) *ResetCacheInput {
	s.GatewayARN = &v
	return s
}

type ResetCacheOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ResetCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ResetCacheOutput) SetGatewayARN(v string) *ResetCacheOutput {
	s.GatewayARN = &v
	return s
}

// RetrieveTapeArchiveInput
type RetrieveTapeArchiveInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual
	// tape to. Use the ListGateways operation to return a list of gateways for
	// your account and AWS Region.
	//
	// You retrieve archived virtual tapes to only one gateway and the gateway must
	// be a tape gateway.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from
	// the virtual tape shelf (VTS).
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveTapeArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveTapeArchiveInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *RetrieveTapeArchiveInput) SetGatewayARN(v string) *RetrieveTapeArchiveInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *RetrieveTapeArchiveInput) SetTapeARN(v string) *RetrieveTapeArchiveInput {
	s.TapeARN = &v
	return s
}

// RetrieveTapeArchiveOutput
type RetrieveTapeArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the retrieved virtual tape.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RetrieveTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeArchiveOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *RetrieveTapeArchiveOutput) SetTapeARN(v string) *RetrieveTapeArchiveOutput {
	s.TapeARN = &v
	return s
}

// RetrieveTapeRecoveryPointInput
type RetrieveTapeRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape for which you want to
	// retrieve the recovery point.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveTapeRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveTapeRecoveryPointInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *RetrieveTapeRecoveryPointInput) SetGatewayARN(v string) *RetrieveTapeRecoveryPointInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *RetrieveTapeRecoveryPointInput) SetTapeARN(v string) *RetrieveTapeRecoveryPointInput {
	s.TapeARN = &v
	return s
}

// RetrieveTapeRecoveryPointOutput
type RetrieveTapeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which the recovery
	// point was retrieved.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *RetrieveTapeRecoveryPointOutput) SetTapeARN(v string) *RetrieveTapeRecoveryPointOutput {
	s.TapeARN = &v
	return s
}

// The Windows file permissions and ownership information assigned, by default,
// to native S3 objects when file gateway discovers them in S3 buckets. This
// operation is only supported for file gateways.
type SMBFileShareInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether AccessBasedEnumeration is enabled.
	AccessBasedEnumeration *bool `type:"boolean"`

	// A list of users or groups in the Active Directory that have administrator
	// rights to the file share. A group must be prefixed with the @ character.
	// Acceptable formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1.
	// Can only be set if Authentication is set to ActiveDirectory.
	AdminUserList []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the storage used for the audit logs.
	AuditDestinationARN *string `type:"string"`

	// The authentication method of the file share. The default is ActiveDirectory.
	//
	// Valid Values: ActiveDirectory | GuestAccess
	Authentication *string `min:"5" type:"string"`

	// Refresh cache information.
	CacheAttributes *CacheAttributes `type:"structure"`

	// The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
	// client determines the case sensitivity. For CaseSensitive, the gateway determines
	// the case sensitivity. The default value is ClientSpecified.
	CaseSensitivity *string `type:"string" enum:"CaseSensitivity"`

	// The default storage class for objects put into an Amazon S3 bucket by the
	// file gateway. The default value is S3_INTELLIGENT_TIERING. Optional.
	//
	// Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
	DefaultStorageClass *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string `min:"50" type:"string"`

	// The ID of the file share.
	FileShareId *string `min:"12" type:"string"`

	// The name of the file share. Optional.
	//
	// FileShareName must be set if an S3 prefix name is set in LocationARN.
	FileShareName *string `min:"1" type:"string"`

	// The status of the file share.
	//
	// Valid Values: CREATING | UPDATING | AVAILABLE | DELETING
	FileShareStatus *string `min:"3" type:"string"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// A value that enables guessing of the MIME type for uploaded objects based
	// on file extensions. Set this value to true to enable MIME type guessing,
	// otherwise set to false. The default value is true.
	//
	// Valid Values: true | false
	GuessMIMETypeEnabled *bool `type:"boolean"`

	// A list of users or groups in the Active Directory that are not allowed to
	// access the file share. A group must be prefixed with the @ character. Acceptable
	// formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only
	// be set if Authentication is set to ActiveDirectory.
	InvalidUserList []*string `type:"list"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The ARN of the backend storage used for storing file data. A prefix name
	// can be added to the S3 bucket name. It must end with a "/".
	LocationARN *string `min:"16" type:"string"`

	// The notification policy of the file share.
	NotificationPolicy *string `min:"2" type:"string"`

	// A value that sets the access control list (ACL) permission for objects in
	// the S3 bucket that a file gateway puts objects into. The default value is
	// private.
	ObjectACL *string `type:"string" enum:"ObjectACL"`

	// The file share path used by the SMB client to identify the mount point.
	Path *string `type:"string"`

	// A value that sets the write status of a file share. Set this value to true
	// to set the write status to read-only, otherwise set to false.
	//
	// Valid Values: true | false
	ReadOnly *bool `type:"boolean"`

	// A value that sets who pays the cost of the request and the cost associated
	// with data download from the S3 bucket. If this value is set to true, the
	// requester pays the costs; otherwise, the S3 bucket owner pays. However, the
	// S3 bucket owner always pays the cost of storing data.
	//
	// RequesterPays is a configuration for the S3 bucket that backs the file share,
	// so make sure that the configuration on the file share is the same as the
	// S3 bucket configuration.
	//
	// Valid Values: true | false
	RequesterPays *bool `type:"boolean"`

	// The ARN of the IAM role that file gateway assumes when it accesses the underlying
	// storage.
	Role *string `min:"20" type:"string"`

	// If this value is set to true, it indicates that access control list (ACL)
	// is enabled on the SMB file share. If it is set to false, it indicates that
	// file and directory permissions are mapped to the POSIX permission.
	//
	// For more information, see Using Microsoft Windows ACLs to control access
	// to an SMB file share (https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html)
	// in the AWS Storage Gateway User Guide.
	SMBACLEnabled *bool `type:"boolean"`

	// A list of up to 50 tags assigned to the SMB file share, sorted alphabetically
	// by key name. Each tag is a key-value pair. For a gateway with more than 10
	// tags assigned, you can view all tags using the ListTagsForResource API operation.
	Tags []*Tag `type:"list"`

	// A list of users or groups in the Active Directory that are allowed to access
	// the file share. A group must be prefixed with the @ character. Acceptable
	// formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only
	// be set if Authentication is set to ActiveDirectory.
	ValidUserList []*string `type:"list"`
}

// String returns the string representation
func (s SMBFileShareInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMBFileShareInfo) GoString() string {
	return s.String()
}

// SetAccessBasedEnumeration sets the AccessBasedEnumeration field's value.
func (s *SMBFileShareInfo) SetAccessBasedEnumeration(v bool) *SMBFileShareInfo {
	s.AccessBasedEnumeration = &v
	return s
}

// SetAdminUserList sets the AdminUserList field's value.
func (s *SMBFileShareInfo) SetAdminUserList(v []*string) *SMBFileShareInfo {
	s.AdminUserList = v
	return s
}

// SetAuditDestinationARN sets the AuditDestinationARN field's value.
func (s *SMBFileShareInfo) SetAuditDestinationARN(v string) *SMBFileShareInfo {
	s.AuditDestinationARN = &v
	return s
}

// SetAuthentication sets the Authentication field's value.
func (s *SMBFileShareInfo) SetAuthentication(v string) *SMBFileShareInfo {
	s.Authentication = &v
	return s
}

// SetCacheAttributes sets the CacheAttributes field's value.
func (s *SMBFileShareInfo) SetCacheAttributes(v *CacheAttributes) *SMBFileShareInfo {
	s.CacheAttributes = v
	return s
}

// SetCaseSensitivity sets the CaseSensitivity field's value.
func (s *SMBFileShareInfo) SetCaseSensitivity(v string) *SMBFileShareInfo {
	s.CaseSensitivity = &v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *SMBFileShareInfo) SetDefaultStorageClass(v string) *SMBFileShareInfo {
	s.DefaultStorageClass = &v
	return s
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *SMBFileShareInfo) SetFileShareARN(v string) *SMBFileShareInfo {
	s.FileShareARN = &v
	return s
}

// SetFileShareId sets the FileShareId field's value.
func (s *SMBFileShareInfo) SetFileShareId(v string) *SMBFileShareInfo {
	s.FileShareId = &v
	return s
}

// SetFileShareName sets the FileShareName field's value.
func (s *SMBFileShareInfo) SetFileShareName(v string) *SMBFileShareInfo {
	s.FileShareName = &v
	return s
}

// SetFileShareStatus sets the FileShareStatus field's value.
func (s *SMBFileShareInfo) SetFileShareStatus(v string) *SMBFileShareInfo {
	s.FileShareStatus = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *SMBFileShareInfo) SetGatewayARN(v string) *SMBFileShareInfo {
	s.GatewayARN = &v
	return s
}

// SetGuessMIMETypeEnabled sets the GuessMIMETypeEnabled field's value.
func (s *SMBFileShareInfo) SetGuessMIMETypeEnabled(v bool) *SMBFileShareInfo {
	s.GuessMIMETypeEnabled = &v
	return s
}

// SetInvalidUserList sets the InvalidUserList field's value.
func (s *SMBFileShareInfo) SetInvalidUserList(v []*string) *SMBFileShareInfo {
	s.InvalidUserList = v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *SMBFileShareInfo) SetKMSEncrypted(v bool) *SMBFileShareInfo {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *SMBFileShareInfo) SetKMSKey(v string) *SMBFileShareInfo {
	s.KMSKey = &v
	return s
}

// SetLocationARN sets the LocationARN field's value.
func (s *SMBFileShareInfo) SetLocationARN(v string) *SMBFileShareInfo {
	s.LocationARN = &v
	return s
}

// SetNotificationPolicy sets the NotificationPolicy field's value.
func (s *SMBFileShareInfo) SetNotificationPolicy(v string) *SMBFileShareInfo {
	s.NotificationPolicy = &v
	return s
}

// SetObjectACL sets the ObjectACL field's value.
func (s *SMBFileShareInfo) SetObjectACL(v string) *SMBFileShareInfo {
	s.ObjectACL = &v
	return s
}

// SetPath sets the Path field's value.
func (s *SMBFileShareInfo) SetPath(v string) *SMBFileShareInfo {
	s.Path = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *SMBFileShareInfo) SetReadOnly(v bool) *SMBFileShareInfo {
	s.ReadOnly = &v
	return s
}

// SetRequesterPays sets the RequesterPays field's value.
func (s *SMBFileShareInfo) SetRequesterPays(v bool) *SMBFileShareInfo {
	s.RequesterPays = &v
	return s
}

// SetRole sets the Role field's value.
func (s *SMBFileShareInfo) SetRole(v string) *SMBFileShareInfo {
	s.Role = &v
	return s
}

// SetSMBACLEnabled sets the SMBACLEnabled field's value.
func (s *SMBFileShareInfo) SetSMBACLEnabled(v bool) *SMBFileShareInfo {
	s.SMBACLEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SMBFileShareInfo) SetTags(v []*Tag) *SMBFileShareInfo {
	s.Tags = v
	return s
}

// SetValidUserList sets the ValidUserList field's value.
func (s *SMBFileShareInfo) SetValidUserList(v []*string) *SMBFileShareInfo {
	s.ValidUserList = v
	return s
}

// An internal server error has occurred because the service is unavailable.
// For more information, see the error and message fields.
type ServiceUnavailableError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A StorageGatewayError that provides more information about the cause of the
	// error.
	Error_ *Error `locationName:"error" type:"structure"`

	// A human-readable message describing the error that occurred.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableError) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableError(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableError) Code() string {
	return "ServiceUnavailableError"
}

// Message returns the exception's message.
func (s *ServiceUnavailableError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableError) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableError) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableError) RequestID() string {
	return s.RespMetadata.RequestID
}

// SetLocalConsolePasswordInput
type SetLocalConsolePasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The password you want to set for your VM local console.
	//
	// LocalConsolePassword is a required field
	LocalConsolePassword *string `min:"6" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SetLocalConsolePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLocalConsolePasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetLocalConsolePasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetLocalConsolePasswordInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.LocalConsolePassword == nil {
		invalidParams.Add(request.NewErrParamRequired("LocalConsolePassword"))
	}
	if s.LocalConsolePassword != nil && len(*s.LocalConsolePassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("LocalConsolePassword", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *SetLocalConsolePasswordInput) SetGatewayARN(v string) *SetLocalConsolePasswordInput {
	s.GatewayARN = &v
	return s
}

// SetLocalConsolePassword sets the LocalConsolePassword field's value.
func (s *SetLocalConsolePasswordInput) SetLocalConsolePassword(v string) *SetLocalConsolePasswordInput {
	s.LocalConsolePassword = &v
	return s
}

type SetLocalConsolePasswordOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s SetLocalConsolePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLocalConsolePasswordOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *SetLocalConsolePasswordOutput) SetGatewayARN(v string) *SetLocalConsolePasswordOutput {
	s.GatewayARN = &v
	return s
}

// SetSMBGuestPasswordInput
type SetSMBGuestPasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file gateway the SMB file share is
	// associated with.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The password that you want to set for your SMB server.
	//
	// Password is a required field
	Password *string `min:"6" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SetSMBGuestPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSMBGuestPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSMBGuestPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSMBGuestPasswordInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *SetSMBGuestPasswordInput) SetGatewayARN(v string) *SetSMBGuestPasswordInput {
	s.GatewayARN = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *SetSMBGuestPasswordInput) SetPassword(v string) *SetSMBGuestPasswordInput {
	s.Password = &v
	return s
}

type SetSMBGuestPasswordOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s SetSMBGuestPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSMBGuestPasswordOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *SetSMBGuestPasswordOutput) SetGatewayARN(v string) *SetSMBGuestPasswordOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway to
// shut down.
type ShutdownGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ShutdownGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShutdownGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ShutdownGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ShutdownGatewayInput) SetGatewayARN(v string) *ShutdownGatewayInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway that
// was shut down.
type ShutdownGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ShutdownGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ShutdownGatewayOutput) SetGatewayARN(v string) *ShutdownGatewayOutput {
	s.GatewayARN = &v
	return s
}

type StartAvailabilityMonitorTestInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s StartAvailabilityMonitorTestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartAvailabilityMonitorTestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAvailabilityMonitorTestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAvailabilityMonitorTestInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *StartAvailabilityMonitorTestInput) SetGatewayARN(v string) *StartAvailabilityMonitorTestInput {
	s.GatewayARN = &v
	return s
}

type StartAvailabilityMonitorTestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s StartAvailabilityMonitorTestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartAvailabilityMonitorTestOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *StartAvailabilityMonitorTestOutput) SetGatewayARN(v string) *StartAvailabilityMonitorTestOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway to
// start.
type StartGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s StartGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *StartGatewayInput) SetGatewayARN(v string) *StartGatewayInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway that
// was restarted.
type StartGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s StartGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *StartGatewayOutput) SetGatewayARN(v string) *StartGatewayOutput {
	s.GatewayARN = &v
	return s
}

// Describes an iSCSI stored volume.
type StorediSCSIVolume struct {
	_ struct{} `type:"structure"`

	// The date the volume was created. Volumes created prior to March 28, 2017
	// don’t have this timestamp.
	CreatedDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// Indicates if when the stored volume was created, existing data on the underlying
	// local disk was preserved.
	//
	// Valid Values: true | false
	PreservedExistingData *bool `type:"boolean"`

	// If the stored volume was created from a snapshot, this field contains the
	// snapshot ID used, e.g. snap-78e22663. Otherwise, this field is not included.
	SourceSnapshotId *string `type:"string"`

	// The name of the iSCSI target used by an initiator to connect to a volume
	// and used as a suffix for the target ARN. For example, specifying TargetName
	// as myvolume results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
	// The target name must be unique across all volumes on a gateway.
	//
	// If you don't specify a value, Storage Gateway uses the value that was previously
	// used for this volume as the new target name.
	TargetName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the storage volume.
	VolumeARN *string `min:"50" type:"string"`

	// A value that indicates whether a storage volume is attached to, detached
	// from, or is in the process of detaching from a gateway. For more information,
	// see Moving your volumes to a different gateway (https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#attach-detach-volume).
	VolumeAttachmentStatus *string `min:"3" type:"string"`

	// The ID of the local disk that was specified in the CreateStorediSCSIVolume
	// operation.
	VolumeDiskId *string `min:"1" type:"string"`

	// The unique identifier of the volume, e.g., vol-AE4B946D.
	VolumeId *string `min:"12" type:"string"`

	// Represents the percentage complete if the volume is restoring or bootstrapping
	// that represents the percent of data transferred. This field does not appear
	// in the response if the stored volume is not restoring or bootstrapping.
	VolumeProgress *float64 `type:"double"`

	// The size of the volume in bytes.
	VolumeSizeInBytes *int64 `type:"long"`

	// One of the VolumeStatus values that indicates the state of the storage volume.
	VolumeStatus *string `min:"3" type:"string"`

	// One of the VolumeType enumeration values describing the type of the volume.
	VolumeType *string `min:"3" type:"string"`

	// The size of the data stored on the volume in bytes. This value is calculated
	// based on the number of blocks that are touched, instead of the actual amount
	// of data written. This value can be useful for sequential write patterns but
	// less accurate for random write patterns. VolumeUsedInBytes is different from
	// the compressed size of the volume, which is the value that is used to calculate
	// your bill.
	//
	// This value is not available for volumes created prior to May 13, 2015, until
	// you store data on the volume.
	VolumeUsedInBytes *int64 `type:"long"`

	// An VolumeiSCSIAttributes object that represents a collection of iSCSI attributes
	// for one stored volume.
	VolumeiSCSIAttributes *VolumeiSCSIAttributes `type:"structure"`
}

// String returns the string representation
func (s StorediSCSIVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorediSCSIVolume) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *StorediSCSIVolume) SetCreatedDate(v time.Time) *StorediSCSIVolume {
	s.CreatedDate = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *StorediSCSIVolume) SetKMSKey(v string) *StorediSCSIVolume {
	s.KMSKey = &v
	return s
}

// SetPreservedExistingData sets the PreservedExistingData field's value.
func (s *StorediSCSIVolume) SetPreservedExistingData(v bool) *StorediSCSIVolume {
	s.PreservedExistingData = &v
	return s
}

// SetSourceSnapshotId sets the SourceSnapshotId field's value.
func (s *StorediSCSIVolume) SetSourceSnapshotId(v string) *StorediSCSIVolume {
	s.SourceSnapshotId = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *StorediSCSIVolume) SetTargetName(v string) *StorediSCSIVolume {
	s.TargetName = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *StorediSCSIVolume) SetVolumeARN(v string) *StorediSCSIVolume {
	s.VolumeARN = &v
	return s
}

// SetVolumeAttachmentStatus sets the VolumeAttachmentStatus field's value.
func (s *StorediSCSIVolume) SetVolumeAttachmentStatus(v string) *StorediSCSIVolume {
	s.VolumeAttachmentStatus = &v
	return s
}

// SetVolumeDiskId sets the VolumeDiskId field's value.
func (s *StorediSCSIVolume) SetVolumeDiskId(v string) *StorediSCSIVolume {
	s.VolumeDiskId = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *StorediSCSIVolume) SetVolumeId(v string) *StorediSCSIVolume {
	s.VolumeId = &v
	return s
}

// SetVolumeProgress sets the VolumeProgress field's value.
func (s *StorediSCSIVolume) SetVolumeProgress(v float64) *StorediSCSIVolume {
	s.VolumeProgress = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *StorediSCSIVolume) SetVolumeSizeInBytes(v int64) *StorediSCSIVolume {
	s.VolumeSizeInBytes = &v
	return s
}

// SetVolumeStatus sets the VolumeStatus field's value.
func (s *StorediSCSIVolume) SetVolumeStatus(v string) *StorediSCSIVolume {
	s.VolumeStatus = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *StorediSCSIVolume) SetVolumeType(v string) *StorediSCSIVolume {
	s.VolumeType = &v
	return s
}

// SetVolumeUsedInBytes sets the VolumeUsedInBytes field's value.
func (s *StorediSCSIVolume) SetVolumeUsedInBytes(v int64) *StorediSCSIVolume {
	s.VolumeUsedInBytes = &v
	return s
}

// SetVolumeiSCSIAttributes sets the VolumeiSCSIAttributes field's value.
func (s *StorediSCSIVolume) SetVolumeiSCSIAttributes(v *VolumeiSCSIAttributes) *StorediSCSIVolume {
	s.VolumeiSCSIAttributes = v
	return s
}

// A key-value pair that helps you manage, filter, and search for your resource.
// Allowed characters: letters, white space, and numbers, representable in UTF-8,
// and the following characters: + - = . _ : /.
type Tag struct {
	_ struct{} `type:"structure"`

	// Tag key. The key can't start with aws:.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Describes a virtual tape object.
type Tape struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The date that the tape enters a custom tape pool.
	PoolEntryDate *time.Time `type:"timestamp"`

	// The ID of the pool that contains tapes that will be archived. The tapes in
	// this pool are archived in the S3 storage class that is associated with the
	// pool. When you use your backup application to eject the tape, the tape is
	// archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive)
	// that corresponds to the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	PoolId *string `min:"1" type:"string"`

	// For archiving virtual tapes, indicates how much data remains to be uploaded
	// before archiving is complete.
	//
	// Range: 0 (not started) to 100 (complete).
	Progress *float64 `type:"double"`

	// The date that the tape is first archived with tape retention lock enabled.
	RetentionStartDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies a specific virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	// The date the virtual tape was created.
	TapeCreatedDate *time.Time `type:"timestamp"`

	// The size, in bytes, of the virtual tape capacity.
	TapeSizeInBytes *int64 `type:"long"`

	// The current state of the virtual tape.
	TapeStatus *string `type:"string"`

	// The size, in bytes, of data stored on the virtual tape.
	//
	// This value is not available for tapes created prior to May 13, 2015.
	TapeUsedInBytes *int64 `type:"long"`

	// The virtual tape library (VTL) device that the virtual tape is associated
	// with.
	VTLDevice *string `min:"50" type:"string"`

	// If the tape is archived as write-once-read-many (WORM), this value is true.
	Worm *bool `type:"boolean"`
}

// String returns the string representation
func (s Tape) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tape) GoString() string {
	return s.String()
}

// SetKMSKey sets the KMSKey field's value.
func (s *Tape) SetKMSKey(v string) *Tape {
	s.KMSKey = &v
	return s
}

// SetPoolEntryDate sets the PoolEntryDate field's value.
func (s *Tape) SetPoolEntryDate(v time.Time) *Tape {
	s.PoolEntryDate = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *Tape) SetPoolId(v string) *Tape {
	s.PoolId = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *Tape) SetProgress(v float64) *Tape {
	s.Progress = &v
	return s
}

// SetRetentionStartDate sets the RetentionStartDate field's value.
func (s *Tape) SetRetentionStartDate(v time.Time) *Tape {
	s.RetentionStartDate = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *Tape) SetTapeARN(v string) *Tape {
	s.TapeARN = &v
	return s
}

// SetTapeBarcode sets the TapeBarcode field's value.
func (s *Tape) SetTapeBarcode(v string) *Tape {
	s.TapeBarcode = &v
	return s
}

// SetTapeCreatedDate sets the TapeCreatedDate field's value.
func (s *Tape) SetTapeCreatedDate(v time.Time) *Tape {
	s.TapeCreatedDate = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *Tape) SetTapeSizeInBytes(v int64) *Tape {
	s.TapeSizeInBytes = &v
	return s
}

// SetTapeStatus sets the TapeStatus field's value.
func (s *Tape) SetTapeStatus(v string) *Tape {
	s.TapeStatus = &v
	return s
}

// SetTapeUsedInBytes sets the TapeUsedInBytes field's value.
func (s *Tape) SetTapeUsedInBytes(v int64) *Tape {
	s.TapeUsedInBytes = &v
	return s
}

// SetVTLDevice sets the VTLDevice field's value.
func (s *Tape) SetVTLDevice(v string) *Tape {
	s.VTLDevice = &v
	return s
}

// SetWorm sets the Worm field's value.
func (s *Tape) SetWorm(v bool) *Tape {
	s.Worm = &v
	return s
}

// Represents a virtual tape that is archived in the virtual tape shelf (VTS).
type TapeArchive struct {
	_ struct{} `type:"structure"`

	// The time that the archiving of the virtual tape was completed.
	//
	// The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
	// format.
	CompletionTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The time that the tape entered the custom tape pool.
	//
	// The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
	// format.
	PoolEntryDate *time.Time `type:"timestamp"`

	// The ID of the pool that was used to archive the tape. The tapes in this pool
	// are archived in the S3 storage class that is associated with the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	PoolId *string `min:"1" type:"string"`

	// If the archived tape is subject to tape retention lock, the date that the
	// archived tape started being retained.
	RetentionStartDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the tape gateway that the virtual tape
	// is being retrieved to.
	//
	// The virtual tape is retrieved from the virtual tape shelf (VTS).
	RetrievedTo *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of an archived virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies the archived virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	// The date the virtual tape was created.
	TapeCreatedDate *time.Time `type:"timestamp"`

	// The size, in bytes, of the archived virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The current state of the archived virtual tape.
	TapeStatus *string `type:"string"`

	// The size, in bytes, of data stored on the virtual tape.
	//
	// This value is not available for tapes created prior to May 13, 2015.
	TapeUsedInBytes *int64 `type:"long"`

	// Set to true if the archived tape is stored as write-once-read-many (WORM).
	Worm *bool `type:"boolean"`
}

// String returns the string representation
func (s TapeArchive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeArchive) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TapeArchive) SetCompletionTime(v time.Time) *TapeArchive {
	s.CompletionTime = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *TapeArchive) SetKMSKey(v string) *TapeArchive {
	s.KMSKey = &v
	return s
}

// SetPoolEntryDate sets the PoolEntryDate field's value.
func (s *TapeArchive) SetPoolEntryDate(v time.Time) *TapeArchive {
	s.PoolEntryDate = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *TapeArchive) SetPoolId(v string) *TapeArchive {
	s.PoolId = &v
	return s
}

// SetRetentionStartDate sets the RetentionStartDate field's value.
func (s *TapeArchive) SetRetentionStartDate(v time.Time) *TapeArchive {
	s.RetentionStartDate = &v
	return s
}

// SetRetrievedTo sets the RetrievedTo field's value.
func (s *TapeArchive) SetRetrievedTo(v string) *TapeArchive {
	s.RetrievedTo = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *TapeArchive) SetTapeARN(v string) *TapeArchive {
	s.TapeARN = &v
	return s
}

// SetTapeBarcode sets the TapeBarcode field's value.
func (s *TapeArchive) SetTapeBarcode(v string) *TapeArchive {
	s.TapeBarcode = &v
	return s
}

// SetTapeCreatedDate sets the TapeCreatedDate field's value.
func (s *TapeArchive) SetTapeCreatedDate(v time.Time) *TapeArchive {
	s.TapeCreatedDate = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *TapeArchive) SetTapeSizeInBytes(v int64) *TapeArchive {
	s.TapeSizeInBytes = &v
	return s
}

// SetTapeStatus sets the TapeStatus field's value.
func (s *TapeArchive) SetTapeStatus(v string) *TapeArchive {
	s.TapeStatus = &v
	return s
}

// SetTapeUsedInBytes sets the TapeUsedInBytes field's value.
func (s *TapeArchive) SetTapeUsedInBytes(v int64) *TapeArchive {
	s.TapeUsedInBytes = &v
	return s
}

// SetWorm sets the Worm field's value.
func (s *TapeArchive) SetWorm(v bool) *TapeArchive {
	s.Worm = &v
	return s
}

// Describes a virtual tape.
type TapeInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The date that the tape entered the custom tape pool with tape retention lock
	// enabled.
	PoolEntryDate *time.Time `type:"timestamp"`

	// The ID of the pool that you want to add your tape to for archiving. The tape
	// in this pool is archived in the S3 storage class that is associated with
	// the pool. When you use your backup application to eject the tape, the tape
	// is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
	// Archive) that corresponds to the pool.
	//
	// Valid Values: GLACIER | DEEP_ARCHIVE
	PoolId *string `min:"1" type:"string"`

	// The date that the tape became subject to tape retention lock.
	RetentionStartDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of a virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies a specific virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	// The size, in bytes, of a virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The status of the tape.
	TapeStatus *string `type:"string"`
}

// String returns the string representation
func (s TapeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeInfo) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *TapeInfo) SetGatewayARN(v string) *TapeInfo {
	s.GatewayARN = &v
	return s
}

// SetPoolEntryDate sets the PoolEntryDate field's value.
func (s *TapeInfo) SetPoolEntryDate(v time.Time) *TapeInfo {
	s.PoolEntryDate = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *TapeInfo) SetPoolId(v string) *TapeInfo {
	s.PoolId = &v
	return s
}

// SetRetentionStartDate sets the RetentionStartDate field's value.
func (s *TapeInfo) SetRetentionStartDate(v time.Time) *TapeInfo {
	s.RetentionStartDate = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *TapeInfo) SetTapeARN(v string) *TapeInfo {
	s.TapeARN = &v
	return s
}

// SetTapeBarcode sets the TapeBarcode field's value.
func (s *TapeInfo) SetTapeBarcode(v string) *TapeInfo {
	s.TapeBarcode = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *TapeInfo) SetTapeSizeInBytes(v int64) *TapeInfo {
	s.TapeSizeInBytes = &v
	return s
}

// SetTapeStatus sets the TapeStatus field's value.
func (s *TapeInfo) SetTapeStatus(v string) *TapeInfo {
	s.TapeStatus = &v
	return s
}

// Describes a recovery point.
type TapeRecoveryPointInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The time when the point-in-time view of the virtual tape was replicated for
	// later recovery.
	//
	// The default timestamp format of the tape recovery point time is in the ISO8601
	// extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
	TapeRecoveryPointTime *time.Time `type:"timestamp"`

	// The size, in bytes, of the virtual tapes to recover.
	TapeSizeInBytes *int64 `type:"long"`

	// The status of the virtual tapes.
	TapeStatus *string `type:"string"`
}

// String returns the string representation
func (s TapeRecoveryPointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeRecoveryPointInfo) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *TapeRecoveryPointInfo) SetTapeARN(v string) *TapeRecoveryPointInfo {
	s.TapeARN = &v
	return s
}

// SetTapeRecoveryPointTime sets the TapeRecoveryPointTime field's value.
func (s *TapeRecoveryPointInfo) SetTapeRecoveryPointTime(v time.Time) *TapeRecoveryPointInfo {
	s.TapeRecoveryPointTime = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *TapeRecoveryPointInfo) SetTapeSizeInBytes(v int64) *TapeRecoveryPointInfo {
	s.TapeSizeInBytes = &v
	return s
}

// SetTapeStatus sets the TapeStatus field's value.
func (s *TapeRecoveryPointInfo) SetTapeStatus(v string) *TapeRecoveryPointInfo {
	s.TapeStatus = &v
	return s
}

type UpdateAutomaticTapeCreationPolicyInput struct {
	_ struct{} `type:"structure"`

	// An automatic tape creation policy consists of a list of automatic tape creation
	// rules. The rules determine when and how to automatically create new tapes.
	//
	// AutomaticTapeCreationRules is a required field
	AutomaticTapeCreationRules []*AutomaticTapeCreationRule `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAutomaticTapeCreationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAutomaticTapeCreationPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAutomaticTapeCreationPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAutomaticTapeCreationPolicyInput"}
	if s.AutomaticTapeCreationRules == nil {
		invalidParams.Add(request.NewErrParamRequired("AutomaticTapeCreationRules"))
	}
	if s.AutomaticTapeCreationRules != nil && len(s.AutomaticTapeCreationRules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutomaticTapeCreationRules", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.AutomaticTapeCreationRules != nil {
		for i, v := range s.AutomaticTapeCreationRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AutomaticTapeCreationRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticTapeCreationRules sets the AutomaticTapeCreationRules field's value.
func (s *UpdateAutomaticTapeCreationPolicyInput) SetAutomaticTapeCreationRules(v []*AutomaticTapeCreationRule) *UpdateAutomaticTapeCreationPolicyInput {
	s.AutomaticTapeCreationRules = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateAutomaticTapeCreationPolicyInput) SetGatewayARN(v string) *UpdateAutomaticTapeCreationPolicyInput {
	s.GatewayARN = &v
	return s
}

type UpdateAutomaticTapeCreationPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateAutomaticTapeCreationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAutomaticTapeCreationPolicyOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateAutomaticTapeCreationPolicyOutput) SetGatewayARN(v string) *UpdateAutomaticTapeCreationPolicyOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec
//
//    * UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec
type UpdateBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// The average download bandwidth rate limit in bits per second.
	AverageDownloadRateLimitInBitsPerSec *int64 `min:"102400" type:"long"`

	// The average upload bandwidth rate limit in bits per second.
	AverageUploadRateLimitInBitsPerSec *int64 `min:"51200" type:"long"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBandwidthRateLimitInput"}
	if s.AverageDownloadRateLimitInBitsPerSec != nil && *s.AverageDownloadRateLimitInBitsPerSec < 102400 {
		invalidParams.Add(request.NewErrParamMinValue("AverageDownloadRateLimitInBitsPerSec", 102400))
	}
	if s.AverageUploadRateLimitInBitsPerSec != nil && *s.AverageUploadRateLimitInBitsPerSec < 51200 {
		invalidParams.Add(request.NewErrParamMinValue("AverageUploadRateLimitInBitsPerSec", 51200))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAverageDownloadRateLimitInBitsPerSec sets the AverageDownloadRateLimitInBitsPerSec field's value.
func (s *UpdateBandwidthRateLimitInput) SetAverageDownloadRateLimitInBitsPerSec(v int64) *UpdateBandwidthRateLimitInput {
	s.AverageDownloadRateLimitInBitsPerSec = &v
	return s
}

// SetAverageUploadRateLimitInBitsPerSec sets the AverageUploadRateLimitInBitsPerSec field's value.
func (s *UpdateBandwidthRateLimitInput) SetAverageUploadRateLimitInBitsPerSec(v int64) *UpdateBandwidthRateLimitInput {
	s.AverageUploadRateLimitInBitsPerSec = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateBandwidthRateLimitInput) SetGatewayARN(v string) *UpdateBandwidthRateLimitInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway whose
// throttle information was updated.
type UpdateBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateBandwidthRateLimitOutput) SetGatewayARN(v string) *UpdateBandwidthRateLimitOutput {
	s.GatewayARN = &v
	return s
}

type UpdateBandwidthRateLimitScheduleInput struct {
	_ struct{} `type:"structure"`

	// An array containing bandwidth rate limit schedule intervals for a gateway.
	// When no bandwidth rate limit intervals have been scheduled, the array is
	// empty.
	//
	// BandwidthRateLimitIntervals is a required field
	BandwidthRateLimitIntervals []*BandwidthRateLimitInterval `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBandwidthRateLimitScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBandwidthRateLimitScheduleInput"}
	if s.BandwidthRateLimitIntervals == nil {
		invalidParams.Add(request.NewErrParamRequired("BandwidthRateLimitIntervals"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.BandwidthRateLimitIntervals != nil {
		for i, v := range s.BandwidthRateLimitIntervals {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BandwidthRateLimitIntervals", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidthRateLimitIntervals sets the BandwidthRateLimitIntervals field's value.
func (s *UpdateBandwidthRateLimitScheduleInput) SetBandwidthRateLimitIntervals(v []*BandwidthRateLimitInterval) *UpdateBandwidthRateLimitScheduleInput {
	s.BandwidthRateLimitIntervals = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateBandwidthRateLimitScheduleInput) SetGatewayARN(v string) *UpdateBandwidthRateLimitScheduleInput {
	s.GatewayARN = &v
	return s
}

type UpdateBandwidthRateLimitScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitScheduleOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateBandwidthRateLimitScheduleOutput) SetGatewayARN(v string) *UpdateBandwidthRateLimitScheduleOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateChapCredentialsInput$InitiatorName
//
//    * UpdateChapCredentialsInput$SecretToAuthenticateInitiator
//
//    * UpdateChapCredentialsInput$SecretToAuthenticateTarget
//
//    * UpdateChapCredentialsInput$TargetARN
type UpdateChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	//
	// InitiatorName is a required field
	InitiatorName *string `min:"1" type:"string" required:"true"`

	// The secret key that the initiator (for example, the Windows client) must
	// provide to participate in mutual CHAP with the target.
	//
	// The secret key must be between 12 and 16 bytes when encoded in UTF-8.
	//
	// SecretToAuthenticateInitiator is a required field
	SecretToAuthenticateInitiator *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The secret key that the target must provide to participate in mutual CHAP
	// with the initiator (e.g. Windows client).
	//
	// Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
	//
	// The secret key must be between 12 and 16 bytes when encoded in UTF-8.
	SecretToAuthenticateTarget *string `min:"1" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChapCredentialsInput"}
	if s.InitiatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("InitiatorName"))
	}
	if s.InitiatorName != nil && len(*s.InitiatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitiatorName", 1))
	}
	if s.SecretToAuthenticateInitiator == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretToAuthenticateInitiator"))
	}
	if s.SecretToAuthenticateInitiator != nil && len(*s.SecretToAuthenticateInitiator) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretToAuthenticateInitiator", 1))
	}
	if s.SecretToAuthenticateTarget != nil && len(*s.SecretToAuthenticateTarget) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretToAuthenticateTarget", 1))
	}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *UpdateChapCredentialsInput) SetInitiatorName(v string) *UpdateChapCredentialsInput {
	s.InitiatorName = &v
	return s
}

// SetSecretToAuthenticateInitiator sets the SecretToAuthenticateInitiator field's value.
func (s *UpdateChapCredentialsInput) SetSecretToAuthenticateInitiator(v string) *UpdateChapCredentialsInput {
	s.SecretToAuthenticateInitiator = &v
	return s
}

// SetSecretToAuthenticateTarget sets the SecretToAuthenticateTarget field's value.
func (s *UpdateChapCredentialsInput) SetSecretToAuthenticateTarget(v string) *UpdateChapCredentialsInput {
	s.SecretToAuthenticateTarget = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *UpdateChapCredentialsInput) SetTargetARN(v string) *UpdateChapCredentialsInput {
	s.TargetARN = &v
	return s
}

// A JSON object containing the following fields:
type UpdateChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target. This is the same initiator
	// name specified in the request.
	InitiatorName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target. This is the same target specified
	// in the request.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChapCredentialsOutput) GoString() string {
	return s.String()
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *UpdateChapCredentialsOutput) SetInitiatorName(v string) *UpdateChapCredentialsOutput {
	s.InitiatorName = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *UpdateChapCredentialsOutput) SetTargetARN(v string) *UpdateChapCredentialsOutput {
	s.TargetARN = &v
	return s
}

type UpdateGatewayInformationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you
	// want to use to monitor and log events in the gateway.
	//
	// For more information, see What is Amazon CloudWatch Logs? (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html)
	CloudWatchLogGroupARN *string `type:"string"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The name you configured for your gateway.
	GatewayName *string `min:"2" type:"string"`

	// A value that indicates the time zone of the gateway.
	GatewayTimezone *string `min:"3" type:"string"`
}

// String returns the string representation
func (s UpdateGatewayInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayInformationInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 2))
	}
	if s.GatewayTimezone != nil && len(*s.GatewayTimezone) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayTimezone", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogGroupARN sets the CloudWatchLogGroupARN field's value.
func (s *UpdateGatewayInformationInput) SetCloudWatchLogGroupARN(v string) *UpdateGatewayInformationInput {
	s.CloudWatchLogGroupARN = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateGatewayInformationInput) SetGatewayARN(v string) *UpdateGatewayInformationInput {
	s.GatewayARN = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *UpdateGatewayInformationInput) SetGatewayName(v string) *UpdateGatewayInformationInput {
	s.GatewayName = &v
	return s
}

// SetGatewayTimezone sets the GatewayTimezone field's value.
func (s *UpdateGatewayInformationInput) SetGatewayTimezone(v string) *UpdateGatewayInformationInput {
	s.GatewayTimezone = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway that
// was updated.
type UpdateGatewayInformationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The name you configured for your gateway.
	GatewayName *string `type:"string"`
}

// String returns the string representation
func (s UpdateGatewayInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInformationOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateGatewayInformationOutput) SetGatewayARN(v string) *UpdateGatewayInformationOutput {
	s.GatewayARN = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *UpdateGatewayInformationOutput) SetGatewayName(v string) *UpdateGatewayInformationOutput {
	s.GatewayName = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway to
// update.
type UpdateGatewaySoftwareNowInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGatewaySoftwareNowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewaySoftwareNowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewaySoftwareNowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewaySoftwareNowInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateGatewaySoftwareNowInput) SetGatewayARN(v string) *UpdateGatewaySoftwareNowInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway that
// was updated.
type UpdateGatewaySoftwareNowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateGatewaySoftwareNowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewaySoftwareNowOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateGatewaySoftwareNowOutput) SetGatewayARN(v string) *UpdateGatewaySoftwareNowOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
//
//    * UpdateMaintenanceStartTimeInput$DayOfMonth
//
//    * UpdateMaintenanceStartTimeInput$DayOfWeek
//
//    * UpdateMaintenanceStartTimeInput$HourOfDay
//
//    * UpdateMaintenanceStartTimeInput$MinuteOfHour
type UpdateMaintenanceStartTimeInput struct {
	_ struct{} `type:"structure"`

	// The day of the month component of the maintenance start time represented
	// as an ordinal number from 1 to 28, where 1 represents the first day of the
	// month and 28 represents the last day of the month.
	DayOfMonth *int64 `min:"1" type:"integer"`

	// The day of the week component of the maintenance start time week represented
	// as an ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.
	DayOfWeek *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The hour component of the maintenance start time represented as hh, where
	// hh is the hour (00 to 23). The hour of the day is in the time zone of the
	// gateway.
	//
	// HourOfDay is a required field
	HourOfDay *int64 `type:"integer" required:"true"`

	// The minute component of the maintenance start time represented as mm, where
	// mm is the minute (00 to 59). The minute of the hour is in the time zone of
	// the gateway.
	//
	// MinuteOfHour is a required field
	MinuteOfHour *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateMaintenanceStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMaintenanceStartTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMaintenanceStartTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMaintenanceStartTimeInput"}
	if s.DayOfMonth != nil && *s.DayOfMonth < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DayOfMonth", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.HourOfDay == nil {
		invalidParams.Add(request.NewErrParamRequired("HourOfDay"))
	}
	if s.MinuteOfHour == nil {
		invalidParams.Add(request.NewErrParamRequired("MinuteOfHour"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDayOfMonth sets the DayOfMonth field's value.
func (s *UpdateMaintenanceStartTimeInput) SetDayOfMonth(v int64) *UpdateMaintenanceStartTimeInput {
	s.DayOfMonth = &v
	return s
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *UpdateMaintenanceStartTimeInput) SetDayOfWeek(v int64) *UpdateMaintenanceStartTimeInput {
	s.DayOfWeek = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateMaintenanceStartTimeInput) SetGatewayARN(v string) *UpdateMaintenanceStartTimeInput {
	s.GatewayARN = &v
	return s
}

// SetHourOfDay sets the HourOfDay field's value.
func (s *UpdateMaintenanceStartTimeInput) SetHourOfDay(v int64) *UpdateMaintenanceStartTimeInput {
	s.HourOfDay = &v
	return s
}

// SetMinuteOfHour sets the MinuteOfHour field's value.
func (s *UpdateMaintenanceStartTimeInput) SetMinuteOfHour(v int64) *UpdateMaintenanceStartTimeInput {
	s.MinuteOfHour = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the gateway whose
// maintenance start time is updated.
type UpdateMaintenanceStartTimeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateMaintenanceStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMaintenanceStartTimeOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateMaintenanceStartTimeOutput) SetGatewayARN(v string) *UpdateMaintenanceStartTimeOutput {
	s.GatewayARN = &v
	return s
}

// UpdateNFSFileShareInput
type UpdateNFSFileShareInput struct {
	_ struct{} `type:"structure"`

	// Refresh cache information.
	CacheAttributes *CacheAttributes `type:"structure"`

	// The list of clients that are allowed to access the file gateway. The list
	// must contain either valid IP addresses or valid CIDR blocks.
	ClientList []*string `min:"1" type:"list"`

	// The default storage class for objects put into an Amazon S3 bucket by the
	// file gateway. The default value is S3_INTELLIGENT_TIERING. Optional.
	//
	// Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
	DefaultStorageClass *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the file share to be updated.
	//
	// FileShareARN is a required field
	FileShareARN *string `min:"50" type:"string" required:"true"`

	// The name of the file share. Optional.
	//
	// FileShareName must be set if an S3 prefix name is set in LocationARN.
	FileShareName *string `min:"1" type:"string"`

	// A value that enables guessing of the MIME type for uploaded objects based
	// on file extensions. Set this value to true to enable MIME type guessing,
	// otherwise set to false. The default value is true.
	//
	// Valid Values: true | false
	GuessMIMETypeEnabled *bool `type:"boolean"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The default values for the file share. Optional.
	NFSFileShareDefaults *NFSFileShareDefaults `type:"structure"`

	// The notification policy of the file share.
	NotificationPolicy *string `min:"2" type:"string"`

	// A value that sets the access control list (ACL) permission for objects in
	// the S3 bucket that a file gateway puts objects into. The default value is
	// private.
	ObjectACL *string `type:"string" enum:"ObjectACL"`

	// A value that sets the write status of a file share. Set this value to true
	// to set the write status to read-only, otherwise set to false.
	//
	// Valid Values: true | false
	ReadOnly *bool `type:"boolean"`

	// A value that sets who pays the cost of the request and the cost associated
	// with data download from the S3 bucket. If this value is set to true, the
	// requester pays the costs; otherwise, the S3 bucket owner pays. However, the
	// S3 bucket owner always pays the cost of storing data.
	//
	// RequesterPays is a configuration for the S3 bucket that backs the file share,
	// so make sure that the configuration on the file share is the same as the
	// S3 bucket configuration.
	//
	// Valid Values: true | false
	RequesterPays *bool `type:"boolean"`

	// The user mapped to anonymous user.
	//
	// Valid values are the following:
	//
	//    * RootSquash: Only root is mapped to anonymous user.
	//
	//    * NoSquash: No one is mapped to anonymous user.
	//
	//    * AllSquash: Everyone is mapped to anonymous user.
	Squash *string `min:"5" type:"string"`
}

// String returns the string representation
func (s UpdateNFSFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNFSFileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNFSFileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNFSFileShareInput"}
	if s.ClientList != nil && len(s.ClientList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientList", 1))
	}
	if s.DefaultStorageClass != nil && len(*s.DefaultStorageClass) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultStorageClass", 5))
	}
	if s.FileShareARN == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARN"))
	}
	if s.FileShareARN != nil && len(*s.FileShareARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARN", 50))
	}
	if s.FileShareName != nil && len(*s.FileShareName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 7))
	}
	if s.NotificationPolicy != nil && len(*s.NotificationPolicy) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationPolicy", 2))
	}
	if s.Squash != nil && len(*s.Squash) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("Squash", 5))
	}
	if s.NFSFileShareDefaults != nil {
		if err := s.NFSFileShareDefaults.Validate(); err != nil {
			invalidParams.AddNested("NFSFileShareDefaults", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheAttributes sets the CacheAttributes field's value.
func (s *UpdateNFSFileShareInput) SetCacheAttributes(v *CacheAttributes) *UpdateNFSFileShareInput {
	s.CacheAttributes = v
	return s
}

// SetClientList sets the ClientList field's value.
func (s *UpdateNFSFileShareInput) SetClientList(v []*string) *UpdateNFSFileShareInput {
	s.ClientList = v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *UpdateNFSFileShareInput) SetDefaultStorageClass(v string) *UpdateNFSFileShareInput {
	s.DefaultStorageClass = &v
	return s
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *UpdateNFSFileShareInput) SetFileShareARN(v string) *UpdateNFSFileShareInput {
	s.FileShareARN = &v
	return s
}

// SetFileShareName sets the FileShareName field's value.
func (s *UpdateNFSFileShareInput) SetFileShareName(v string) *UpdateNFSFileShareInput {
	s.FileShareName = &v
	return s
}

// SetGuessMIMETypeEnabled sets the GuessMIMETypeEnabled field's value.
func (s *UpdateNFSFileShareInput) SetGuessMIMETypeEnabled(v bool) *UpdateNFSFileShareInput {
	s.GuessMIMETypeEnabled = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *UpdateNFSFileShareInput) SetKMSEncrypted(v bool) *UpdateNFSFileShareInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *UpdateNFSFileShareInput) SetKMSKey(v string) *UpdateNFSFileShareInput {
	s.KMSKey = &v
	return s
}

// SetNFSFileShareDefaults sets the NFSFileShareDefaults field's value.
func (s *UpdateNFSFileShareInput) SetNFSFileShareDefaults(v *NFSFileShareDefaults) *UpdateNFSFileShareInput {
	s.NFSFileShareDefaults = v
	return s
}

// SetNotificationPolicy sets the NotificationPolicy field's value.
func (s *UpdateNFSFileShareInput) SetNotificationPolicy(v string) *UpdateNFSFileShareInput {
	s.NotificationPolicy = &v
	return s
}

// SetObjectACL sets the ObjectACL field's value.
func (s *UpdateNFSFileShareInput) SetObjectACL(v string) *UpdateNFSFileShareInput {
	s.ObjectACL = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *UpdateNFSFileShareInput) SetReadOnly(v bool) *UpdateNFSFileShareInput {
	s.ReadOnly = &v
	return s
}

// SetRequesterPays sets the RequesterPays field's value.
func (s *UpdateNFSFileShareInput) SetRequesterPays(v bool) *UpdateNFSFileShareInput {
	s.RequesterPays = &v
	return s
}

// SetSquash sets the Squash field's value.
func (s *UpdateNFSFileShareInput) SetSquash(v string) *UpdateNFSFileShareInput {
	s.Squash = &v
	return s
}

// UpdateNFSFileShareOutput
type UpdateNFSFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateNFSFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNFSFileShareOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *UpdateNFSFileShareOutput) SetFileShareARN(v string) *UpdateNFSFileShareOutput {
	s.FileShareARN = &v
	return s
}

// UpdateSMBFileShareInput
type UpdateSMBFileShareInput struct {
	_ struct{} `type:"structure"`

	// The files and folders on this share will only be visible to users with read
	// access.
	AccessBasedEnumeration *bool `type:"boolean"`

	// A list of users or groups in the Active Directory that have administrator
	// rights to the file share. A group must be prefixed with the @ character.
	// Acceptable formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1.
	// Can only be set if Authentication is set to ActiveDirectory.
	AdminUserList []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the storage used for the audit logs.
	AuditDestinationARN *string `type:"string"`

	// Refresh cache information.
	CacheAttributes *CacheAttributes `type:"structure"`

	// The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
	// client determines the case sensitivity. For CaseSensitive, the gateway determines
	// the case sensitivity. The default value is ClientSpecified.
	CaseSensitivity *string `type:"string" enum:"CaseSensitivity"`

	// The default storage class for objects put into an Amazon S3 bucket by the
	// file gateway. The default value is S3_INTELLIGENT_TIERING. Optional.
	//
	// Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA
	DefaultStorageClass *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the SMB file share that you want to update.
	//
	// FileShareARN is a required field
	FileShareARN *string `min:"50" type:"string" required:"true"`

	// The name of the file share. Optional.
	//
	// FileShareName must be set if an S3 prefix name is set in LocationARN.
	FileShareName *string `min:"1" type:"string"`

	// A value that enables guessing of the MIME type for uploaded objects based
	// on file extensions. Set this value to true to enable MIME type guessing,
	// otherwise set to false. The default value is true.
	//
	// Valid Values: true | false
	GuessMIMETypeEnabled *bool `type:"boolean"`

	// A list of users or groups in the Active Directory that are not allowed to
	// access the file share. A group must be prefixed with the @ character. Acceptable
	// formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only
	// be set if Authentication is set to ActiveDirectory.
	InvalidUserList []*string `type:"list"`

	// Set to true to use Amazon S3 server-side encryption with your own AWS KMS
	// key, or false to use a key managed by Amazon S3. Optional.
	//
	// Valid Values: true | false
	KMSEncrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used
	// for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric
	// CMKs. This value can only be set when KMSEncrypted is true. Optional.
	KMSKey *string `min:"7" type:"string"`

	// The notification policy of the file share.
	NotificationPolicy *string `min:"2" type:"string"`

	// A value that sets the access control list (ACL) permission for objects in
	// the S3 bucket that a file gateway puts objects into. The default value is
	// private.
	ObjectACL *string `type:"string" enum:"ObjectACL"`

	// A value that sets the write status of a file share. Set this value to true
	// to set write status to read-only, otherwise set to false.
	//
	// Valid Values: true | false
	ReadOnly *bool `type:"boolean"`

	// A value that sets who pays the cost of the request and the cost associated
	// with data download from the S3 bucket. If this value is set to true, the
	// requester pays the costs; otherwise, the S3 bucket owner pays. However, the
	// S3 bucket owner always pays the cost of storing data.
	//
	// RequesterPays is a configuration for the S3 bucket that backs the file share,
	// so make sure that the configuration on the file share is the same as the
	// S3 bucket configuration.
	//
	// Valid Values: true | false
	RequesterPays *bool `type:"boolean"`

	// Set this value to true to enable access control list (ACL) on the SMB file
	// share. Set it to false to map file and directory permissions to the POSIX
	// permissions.
	//
	// For more information, see Using Microsoft Windows ACLs to control access
	// to an SMB file share (https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html)
	// in the AWS Storage Gateway User Guide.
	//
	// Valid Values: true | false
	SMBACLEnabled *bool `type:"boolean"`

	// A list of users or groups in the Active Directory that are allowed to access
	// the file share. A group must be prefixed with the @ character. Acceptable
	// formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only
	// be set if Authentication is set to ActiveDirectory.
	ValidUserList []*string `type:"list"`
}

// String returns the string representation
func (s UpdateSMBFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSMBFileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSMBFileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSMBFileShareInput"}
	if s.DefaultStorageClass != nil && len(*s.DefaultStorageClass) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultStorageClass", 5))
	}
	if s.FileShareARN == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARN"))
	}
	if s.FileShareARN != nil && len(*s.FileShareARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARN", 50))
	}
	if s.FileShareName != nil && len(*s.FileShareName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 7))
	}
	if s.NotificationPolicy != nil && len(*s.NotificationPolicy) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationPolicy", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessBasedEnumeration sets the AccessBasedEnumeration field's value.
func (s *UpdateSMBFileShareInput) SetAccessBasedEnumeration(v bool) *UpdateSMBFileShareInput {
	s.AccessBasedEnumeration = &v
	return s
}

// SetAdminUserList sets the AdminUserList field's value.
func (s *UpdateSMBFileShareInput) SetAdminUserList(v []*string) *UpdateSMBFileShareInput {
	s.AdminUserList = v
	return s
}

// SetAuditDestinationARN sets the AuditDestinationARN field's value.
func (s *UpdateSMBFileShareInput) SetAuditDestinationARN(v string) *UpdateSMBFileShareInput {
	s.AuditDestinationARN = &v
	return s
}

// SetCacheAttributes sets the CacheAttributes field's value.
func (s *UpdateSMBFileShareInput) SetCacheAttributes(v *CacheAttributes) *UpdateSMBFileShareInput {
	s.CacheAttributes = v
	return s
}

// SetCaseSensitivity sets the CaseSensitivity field's value.
func (s *UpdateSMBFileShareInput) SetCaseSensitivity(v string) *UpdateSMBFileShareInput {
	s.CaseSensitivity = &v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *UpdateSMBFileShareInput) SetDefaultStorageClass(v string) *UpdateSMBFileShareInput {
	s.DefaultStorageClass = &v
	return s
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *UpdateSMBFileShareInput) SetFileShareARN(v string) *UpdateSMBFileShareInput {
	s.FileShareARN = &v
	return s
}

// SetFileShareName sets the FileShareName field's value.
func (s *UpdateSMBFileShareInput) SetFileShareName(v string) *UpdateSMBFileShareInput {
	s.FileShareName = &v
	return s
}

// SetGuessMIMETypeEnabled sets the GuessMIMETypeEnabled field's value.
func (s *UpdateSMBFileShareInput) SetGuessMIMETypeEnabled(v bool) *UpdateSMBFileShareInput {
	s.GuessMIMETypeEnabled = &v
	return s
}

// SetInvalidUserList sets the InvalidUserList field's value.
func (s *UpdateSMBFileShareInput) SetInvalidUserList(v []*string) *UpdateSMBFileShareInput {
	s.InvalidUserList = v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *UpdateSMBFileShareInput) SetKMSEncrypted(v bool) *UpdateSMBFileShareInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *UpdateSMBFileShareInput) SetKMSKey(v string) *UpdateSMBFileShareInput {
	s.KMSKey = &v
	return s
}

// SetNotificationPolicy sets the NotificationPolicy field's value.
func (s *UpdateSMBFileShareInput) SetNotificationPolicy(v string) *UpdateSMBFileShareInput {
	s.NotificationPolicy = &v
	return s
}

// SetObjectACL sets the ObjectACL field's value.
func (s *UpdateSMBFileShareInput) SetObjectACL(v string) *UpdateSMBFileShareInput {
	s.ObjectACL = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *UpdateSMBFileShareInput) SetReadOnly(v bool) *UpdateSMBFileShareInput {
	s.ReadOnly = &v
	return s
}

// SetRequesterPays sets the RequesterPays field's value.
func (s *UpdateSMBFileShareInput) SetRequesterPays(v bool) *UpdateSMBFileShareInput {
	s.RequesterPays = &v
	return s
}

// SetSMBACLEnabled sets the SMBACLEnabled field's value.
func (s *UpdateSMBFileShareInput) SetSMBACLEnabled(v bool) *UpdateSMBFileShareInput {
	s.SMBACLEnabled = &v
	return s
}

// SetValidUserList sets the ValidUserList field's value.
func (s *UpdateSMBFileShareInput) SetValidUserList(v []*string) *UpdateSMBFileShareInput {
	s.ValidUserList = v
	return s
}

// UpdateSMBFileShareOutput
type UpdateSMBFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated SMB file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateSMBFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSMBFileShareOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *UpdateSMBFileShareOutput) SetFileShareARN(v string) *UpdateSMBFileShareOutput {
	s.FileShareARN = &v
	return s
}

type UpdateSMBFileShareVisibilityInput struct {
	_ struct{} `type:"structure"`

	// The shares on this gateway appear when listing shares.
	//
	// FileSharesVisible is a required field
	FileSharesVisible *bool `type:"boolean" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSMBFileShareVisibilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSMBFileShareVisibilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSMBFileShareVisibilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSMBFileShareVisibilityInput"}
	if s.FileSharesVisible == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSharesVisible"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSharesVisible sets the FileSharesVisible field's value.
func (s *UpdateSMBFileShareVisibilityInput) SetFileSharesVisible(v bool) *UpdateSMBFileShareVisibilityInput {
	s.FileSharesVisible = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateSMBFileShareVisibilityInput) SetGatewayARN(v string) *UpdateSMBFileShareVisibilityInput {
	s.GatewayARN = &v
	return s
}

type UpdateSMBFileShareVisibilityOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateSMBFileShareVisibilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSMBFileShareVisibilityOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateSMBFileShareVisibilityOutput) SetGatewayARN(v string) *UpdateSMBFileShareVisibilityOutput {
	s.GatewayARN = &v
	return s
}

type UpdateSMBSecurityStrategyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies the type of security strategy.
	//
	// ClientSpecified: if you use this option, requests are established based on
	// what is negotiated by the client. This option is recommended when you want
	// to maximize compatibility across different clients in your environment.
	//
	// MandatorySigning: if you use this option, file gateway only allows connections
	// from SMBv2 or SMBv3 clients that have signing enabled. This option works
	// with SMB clients on Microsoft Windows Vista, Windows Server 2008 or newer.
	//
	// MandatoryEncryption: if you use this option, file gateway only allows connections
	// from SMBv3 clients that have encryption enabled. This option is highly recommended
	// for environments that handle sensitive data. This option works with SMB clients
	// on Microsoft Windows 8, Windows Server 2012 or newer.
	//
	// SMBSecurityStrategy is a required field
	SMBSecurityStrategy *string `type:"string" required:"true" enum:"SMBSecurityStrategy"`
}

// String returns the string representation
func (s UpdateSMBSecurityStrategyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSMBSecurityStrategyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSMBSecurityStrategyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSMBSecurityStrategyInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.SMBSecurityStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("SMBSecurityStrategy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateSMBSecurityStrategyInput) SetGatewayARN(v string) *UpdateSMBSecurityStrategyInput {
	s.GatewayARN = &v
	return s
}

// SetSMBSecurityStrategy sets the SMBSecurityStrategy field's value.
func (s *UpdateSMBSecurityStrategyInput) SetSMBSecurityStrategy(v string) *UpdateSMBSecurityStrategyInput {
	s.SMBSecurityStrategy = &v
	return s
}

type UpdateSMBSecurityStrategyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateSMBSecurityStrategyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSMBSecurityStrategyOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateSMBSecurityStrategyOutput) SetGatewayARN(v string) *UpdateSMBSecurityStrategyOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateSnapshotScheduleInput$Description
//
//    * UpdateSnapshotScheduleInput$RecurrenceInHours
//
//    * UpdateSnapshotScheduleInput$StartAt
//
//    * UpdateSnapshotScheduleInput$VolumeARN
type UpdateSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// Optional description of the snapshot that overwrites the existing description.
	Description *string `min:"1" type:"string"`

	// Frequency of snapshots. Specify the number of hours between snapshots.
	//
	// RecurrenceInHours is a required field
	RecurrenceInHours *int64 `min:"1" type:"integer" required:"true"`

	// The hour of the day at which the snapshot schedule begins represented as
	// hh, where hh is the hour (0 to 23). The hour of the day is in the time zone
	// of the gateway.
	//
	// StartAt is a required field
	StartAt *int64 `type:"integer" required:"true"`

	// A list of up to 50 tags that can be assigned to a snapshot. Each tag is a
	// key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []*Tag `type:"list"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSnapshotScheduleInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RecurrenceInHours == nil {
		invalidParams.Add(request.NewErrParamRequired("RecurrenceInHours"))
	}
	if s.RecurrenceInHours != nil && *s.RecurrenceInHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RecurrenceInHours", 1))
	}
	if s.StartAt == nil {
		invalidParams.Add(request.NewErrParamRequired("StartAt"))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSnapshotScheduleInput) SetDescription(v string) *UpdateSnapshotScheduleInput {
	s.Description = &v
	return s
}

// SetRecurrenceInHours sets the RecurrenceInHours field's value.
func (s *UpdateSnapshotScheduleInput) SetRecurrenceInHours(v int64) *UpdateSnapshotScheduleInput {
	s.RecurrenceInHours = &v
	return s
}

// SetStartAt sets the StartAt field's value.
func (s *UpdateSnapshotScheduleInput) SetStartAt(v int64) *UpdateSnapshotScheduleInput {
	s.StartAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateSnapshotScheduleInput) SetTags(v []*Tag) *UpdateSnapshotScheduleInput {
	s.Tags = v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *UpdateSnapshotScheduleInput) SetVolumeARN(v string) *UpdateSnapshotScheduleInput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the updated storage
// volume.
type UpdateSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *UpdateSnapshotScheduleOutput) SetVolumeARN(v string) *UpdateSnapshotScheduleOutput {
	s.VolumeARN = &v
	return s
}

type UpdateVTLDeviceTypeInput struct {
	_ struct{} `type:"structure"`

	// The type of medium changer you want to select.
	//
	// Valid Values: STK-L700 | AWS-Gateway-VTL | IBM-03584L32-0402
	//
	// DeviceType is a required field
	DeviceType *string `min:"2" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the medium changer you want to select.
	//
	// VTLDeviceARN is a required field
	VTLDeviceARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVTLDeviceTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVTLDeviceTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVTLDeviceTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVTLDeviceTypeInput"}
	if s.DeviceType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceType"))
	}
	if s.DeviceType != nil && len(*s.DeviceType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceType", 2))
	}
	if s.VTLDeviceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VTLDeviceARN"))
	}
	if s.VTLDeviceARN != nil && len(*s.VTLDeviceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VTLDeviceARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceType sets the DeviceType field's value.
func (s *UpdateVTLDeviceTypeInput) SetDeviceType(v string) *UpdateVTLDeviceTypeInput {
	s.DeviceType = &v
	return s
}

// SetVTLDeviceARN sets the VTLDeviceARN field's value.
func (s *UpdateVTLDeviceTypeInput) SetVTLDeviceARN(v string) *UpdateVTLDeviceTypeInput {
	s.VTLDeviceARN = &v
	return s
}

// UpdateVTLDeviceTypeOutput
type UpdateVTLDeviceTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the medium changer you have selected.
	VTLDeviceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateVTLDeviceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVTLDeviceTypeOutput) GoString() string {
	return s.String()
}

// SetVTLDeviceARN sets the VTLDeviceARN field's value.
func (s *UpdateVTLDeviceTypeOutput) SetVTLDeviceARN(v string) *UpdateVTLDeviceTypeOutput {
	s.VTLDeviceARN = &v
	return s
}

// Represents a device object associated with a tape gateway.
type VTLDevice struct {
	_ struct{} `type:"structure"`

	// A list of iSCSI information about a VTL device.
	DeviceiSCSIAttributes *DeviceiSCSIAttributes `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) of the device (tape drive
	// or media changer).
	VTLDeviceARN *string `min:"50" type:"string"`

	// Specifies the model number of device that the VTL device emulates.
	VTLDeviceProductIdentifier *string `type:"string"`

	// Specifies the type of device that the VTL device emulates.
	VTLDeviceType *string `type:"string"`

	// Specifies the vendor of the device that the VTL device object emulates.
	VTLDeviceVendor *string `type:"string"`
}

// String returns the string representation
func (s VTLDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VTLDevice) GoString() string {
	return s.String()
}

// SetDeviceiSCSIAttributes sets the DeviceiSCSIAttributes field's value.
func (s *VTLDevice) SetDeviceiSCSIAttributes(v *DeviceiSCSIAttributes) *VTLDevice {
	s.DeviceiSCSIAttributes = v
	return s
}

// SetVTLDeviceARN sets the VTLDeviceARN field's value.
func (s *VTLDevice) SetVTLDeviceARN(v string) *VTLDevice {
	s.VTLDeviceARN = &v
	return s
}

// SetVTLDeviceProductIdentifier sets the VTLDeviceProductIdentifier field's value.
func (s *VTLDevice) SetVTLDeviceProductIdentifier(v string) *VTLDevice {
	s.VTLDeviceProductIdentifier = &v
	return s
}

// SetVTLDeviceType sets the VTLDeviceType field's value.
func (s *VTLDevice) SetVTLDeviceType(v string) *VTLDevice {
	s.VTLDeviceType = &v
	return s
}

// SetVTLDeviceVendor sets the VTLDeviceVendor field's value.
func (s *VTLDevice) SetVTLDeviceVendor(v string) *VTLDevice {
	s.VTLDeviceVendor = &v
	return s
}

// Describes a storage volume object.
type VolumeInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	GatewayId *string `min:"12" type:"string"`

	// The Amazon Resource Name (ARN) for the storage volume. For example, the following
	// is a valid ARN:
	//
	// arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeARN *string `min:"50" type:"string"`

	// One of the VolumeStatus values that indicates the state of the storage volume.
	VolumeAttachmentStatus *string `min:"3" type:"string"`

	// The unique identifier assigned to the volume. This ID becomes part of the
	// volume Amazon Resource Name (ARN), which you use as input for other operations.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeId *string `min:"12" type:"string"`

	// The size of the volume in bytes.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeSizeInBytes *int64 `type:"long"`

	// One of the VolumeType enumeration values describing the type of the volume.
	VolumeType *string `min:"3" type:"string"`
}

// String returns the string representation
func (s VolumeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeInfo) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *VolumeInfo) SetGatewayARN(v string) *VolumeInfo {
	s.GatewayARN = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *VolumeInfo) SetGatewayId(v string) *VolumeInfo {
	s.GatewayId = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *VolumeInfo) SetVolumeARN(v string) *VolumeInfo {
	s.VolumeARN = &v
	return s
}

// SetVolumeAttachmentStatus sets the VolumeAttachmentStatus field's value.
func (s *VolumeInfo) SetVolumeAttachmentStatus(v string) *VolumeInfo {
	s.VolumeAttachmentStatus = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *VolumeInfo) SetVolumeId(v string) *VolumeInfo {
	s.VolumeId = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *VolumeInfo) SetVolumeSizeInBytes(v int64) *VolumeInfo {
	s.VolumeSizeInBytes = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *VolumeInfo) SetVolumeType(v string) *VolumeInfo {
	s.VolumeType = &v
	return s
}

// Describes a storage volume recovery point object.
type VolumeRecoveryPointInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume target.
	VolumeARN *string `min:"50" type:"string"`

	// The time the recovery point was taken.
	VolumeRecoveryPointTime *string `type:"string"`

	// The size of the volume in bytes.
	VolumeSizeInBytes *int64 `type:"long"`

	// The size of the data stored on the volume in bytes.
	//
	// This value is not available for volumes created prior to May 13, 2015, until
	// you store data on the volume.
	VolumeUsageInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s VolumeRecoveryPointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeRecoveryPointInfo) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *VolumeRecoveryPointInfo) SetVolumeARN(v string) *VolumeRecoveryPointInfo {
	s.VolumeARN = &v
	return s
}

// SetVolumeRecoveryPointTime sets the VolumeRecoveryPointTime field's value.
func (s *VolumeRecoveryPointInfo) SetVolumeRecoveryPointTime(v string) *VolumeRecoveryPointInfo {
	s.VolumeRecoveryPointTime = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *VolumeRecoveryPointInfo) SetVolumeSizeInBytes(v int64) *VolumeRecoveryPointInfo {
	s.VolumeSizeInBytes = &v
	return s
}

// SetVolumeUsageInBytes sets the VolumeUsageInBytes field's value.
func (s *VolumeRecoveryPointInfo) SetVolumeUsageInBytes(v int64) *VolumeRecoveryPointInfo {
	s.VolumeUsageInBytes = &v
	return s
}

// Lists iSCSI information about a volume.
type VolumeiSCSIAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether mutual CHAP is enabled for the iSCSI target.
	ChapEnabled *bool `type:"boolean"`

	// The logical disk number.
	LunNumber *int64 `min:"1" type:"integer"`

	// The network interface identifier.
	NetworkInterfaceId *string `type:"string"`

	// The port used to communicate with iSCSI targets.
	NetworkInterfacePort *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the volume target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s VolumeiSCSIAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeiSCSIAttributes) GoString() string {
	return s.String()
}

// SetChapEnabled sets the ChapEnabled field's value.
func (s *VolumeiSCSIAttributes) SetChapEnabled(v bool) *VolumeiSCSIAttributes {
	s.ChapEnabled = &v
	return s
}

// SetLunNumber sets the LunNumber field's value.
func (s *VolumeiSCSIAttributes) SetLunNumber(v int64) *VolumeiSCSIAttributes {
	s.LunNumber = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *VolumeiSCSIAttributes) SetNetworkInterfaceId(v string) *VolumeiSCSIAttributes {
	s.NetworkInterfaceId = &v
	return s
}

// SetNetworkInterfacePort sets the NetworkInterfacePort field's value.
func (s *VolumeiSCSIAttributes) SetNetworkInterfacePort(v int64) *VolumeiSCSIAttributes {
	s.NetworkInterfacePort = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *VolumeiSCSIAttributes) SetTargetARN(v string) *VolumeiSCSIAttributes {
	s.TargetARN = &v
	return s
}

const (
	// ActiveDirectoryStatusAccessDenied is a ActiveDirectoryStatus enum value
	ActiveDirectoryStatusAccessDenied = "ACCESS_DENIED"

	// ActiveDirectoryStatusDetached is a ActiveDirectoryStatus enum value
	ActiveDirectoryStatusDetached = "DETACHED"

	// ActiveDirectoryStatusJoined is a ActiveDirectoryStatus enum value
	ActiveDirectoryStatusJoined = "JOINED"

	// ActiveDirectoryStatusJoining is a ActiveDirectoryStatus enum value
	ActiveDirectoryStatusJoining = "JOINING"

	// ActiveDirectoryStatusNetworkError is a ActiveDirectoryStatus enum value
	ActiveDirectoryStatusNetworkError = "NETWORK_ERROR"

	// ActiveDirectoryStatusTimeout is a ActiveDirectoryStatus enum value
	ActiveDirectoryStatusTimeout = "TIMEOUT"

	// ActiveDirectoryStatusUnknownError is a ActiveDirectoryStatus enum value
	ActiveDirectoryStatusUnknownError = "UNKNOWN_ERROR"
)

// ActiveDirectoryStatus_Values returns all elements of the ActiveDirectoryStatus enum
func ActiveDirectoryStatus_Values() []string {
	return []string{
		ActiveDirectoryStatusAccessDenied,
		ActiveDirectoryStatusDetached,
		ActiveDirectoryStatusJoined,
		ActiveDirectoryStatusJoining,
		ActiveDirectoryStatusNetworkError,
		ActiveDirectoryStatusTimeout,
		ActiveDirectoryStatusUnknownError,
	}
}

const (
	// AvailabilityMonitorTestStatusComplete is a AvailabilityMonitorTestStatus enum value
	AvailabilityMonitorTestStatusComplete = "COMPLETE"

	// AvailabilityMonitorTestStatusFailed is a AvailabilityMonitorTestStatus enum value
	AvailabilityMonitorTestStatusFailed = "FAILED"

	// AvailabilityMonitorTestStatusPending is a AvailabilityMonitorTestStatus enum value
	AvailabilityMonitorTestStatusPending = "PENDING"
)

// AvailabilityMonitorTestStatus_Values returns all elements of the AvailabilityMonitorTestStatus enum
func AvailabilityMonitorTestStatus_Values() []string {
	return []string{
		AvailabilityMonitorTestStatusComplete,
		AvailabilityMonitorTestStatusFailed,
		AvailabilityMonitorTestStatusPending,
	}
}

const (
	// CaseSensitivityClientSpecified is a CaseSensitivity enum value
	CaseSensitivityClientSpecified = "ClientSpecified"

	// CaseSensitivityCaseSensitive is a CaseSensitivity enum value
	CaseSensitivityCaseSensitive = "CaseSensitive"
)

// CaseSensitivity_Values returns all elements of the CaseSensitivity enum
func CaseSensitivity_Values() []string {
	return []string{
		CaseSensitivityClientSpecified,
		CaseSensitivityCaseSensitive,
	}
}

const (
	// ErrorCodeActivationKeyExpired is a ErrorCode enum value
	ErrorCodeActivationKeyExpired = "ActivationKeyExpired"

	// ErrorCodeActivationKeyInvalid is a ErrorCode enum value
	ErrorCodeActivationKeyInvalid = "ActivationKeyInvalid"

	// ErrorCodeActivationKeyNotFound is a ErrorCode enum value
	ErrorCodeActivationKeyNotFound = "ActivationKeyNotFound"

	// ErrorCodeGatewayInternalError is a ErrorCode enum value
	ErrorCodeGatewayInternalError = "GatewayInternalError"

	// ErrorCodeGatewayNotConnected is a ErrorCode enum value
	ErrorCodeGatewayNotConnected = "GatewayNotConnected"

	// ErrorCodeGatewayNotFound is a ErrorCode enum value
	ErrorCodeGatewayNotFound = "GatewayNotFound"

	// ErrorCodeGatewayProxyNetworkConnectionBusy is a ErrorCode enum value
	ErrorCodeGatewayProxyNetworkConnectionBusy = "GatewayProxyNetworkConnectionBusy"

	// ErrorCodeAuthenticationFailure is a ErrorCode enum value
	ErrorCodeAuthenticationFailure = "AuthenticationFailure"

	// ErrorCodeBandwidthThrottleScheduleNotFound is a ErrorCode enum value
	ErrorCodeBandwidthThrottleScheduleNotFound = "BandwidthThrottleScheduleNotFound"

	// ErrorCodeBlocked is a ErrorCode enum value
	ErrorCodeBlocked = "Blocked"

	// ErrorCodeCannotExportSnapshot is a ErrorCode enum value
	ErrorCodeCannotExportSnapshot = "CannotExportSnapshot"

	// ErrorCodeChapCredentialNotFound is a ErrorCode enum value
	ErrorCodeChapCredentialNotFound = "ChapCredentialNotFound"

	// ErrorCodeDiskAlreadyAllocated is a ErrorCode enum value
	ErrorCodeDiskAlreadyAllocated = "DiskAlreadyAllocated"

	// ErrorCodeDiskDoesNotExist is a ErrorCode enum value
	ErrorCodeDiskDoesNotExist = "DiskDoesNotExist"

	// ErrorCodeDiskSizeGreaterThanVolumeMaxSize is a ErrorCode enum value
	ErrorCodeDiskSizeGreaterThanVolumeMaxSize = "DiskSizeGreaterThanVolumeMaxSize"

	// ErrorCodeDiskSizeLessThanVolumeSize is a ErrorCode enum value
	ErrorCodeDiskSizeLessThanVolumeSize = "DiskSizeLessThanVolumeSize"

	// ErrorCodeDiskSizeNotGigAligned is a ErrorCode enum value
	ErrorCodeDiskSizeNotGigAligned = "DiskSizeNotGigAligned"

	// ErrorCodeDuplicateCertificateInfo is a ErrorCode enum value
	ErrorCodeDuplicateCertificateInfo = "DuplicateCertificateInfo"

	// ErrorCodeDuplicateSchedule is a ErrorCode enum value
	ErrorCodeDuplicateSchedule = "DuplicateSchedule"

	// ErrorCodeEndpointNotFound is a ErrorCode enum value
	ErrorCodeEndpointNotFound = "EndpointNotFound"

	// ErrorCodeIamnotSupported is a ErrorCode enum value
	ErrorCodeIamnotSupported = "IAMNotSupported"

	// ErrorCodeInitiatorInvalid is a ErrorCode enum value
	ErrorCodeInitiatorInvalid = "InitiatorInvalid"

	// ErrorCodeInitiatorNotFound is a ErrorCode enum value
	ErrorCodeInitiatorNotFound = "InitiatorNotFound"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "InternalError"

	// ErrorCodeInvalidGateway is a ErrorCode enum value
	ErrorCodeInvalidGateway = "InvalidGateway"

	// ErrorCodeInvalidEndpoint is a ErrorCode enum value
	ErrorCodeInvalidEndpoint = "InvalidEndpoint"

	// ErrorCodeInvalidParameters is a ErrorCode enum value
	ErrorCodeInvalidParameters = "InvalidParameters"

	// ErrorCodeInvalidSchedule is a ErrorCode enum value
	ErrorCodeInvalidSchedule = "InvalidSchedule"

	// ErrorCodeLocalStorageLimitExceeded is a ErrorCode enum value
	ErrorCodeLocalStorageLimitExceeded = "LocalStorageLimitExceeded"

	// ErrorCodeLunAlreadyAllocated is a ErrorCode enum value
	ErrorCodeLunAlreadyAllocated = "LunAlreadyAllocated "

	// ErrorCodeLunInvalid is a ErrorCode enum value
	ErrorCodeLunInvalid = "LunInvalid"

	// ErrorCodeJoinDomainInProgress is a ErrorCode enum value
	ErrorCodeJoinDomainInProgress = "JoinDomainInProgress"

	// ErrorCodeMaximumContentLengthExceeded is a ErrorCode enum value
	ErrorCodeMaximumContentLengthExceeded = "MaximumContentLengthExceeded"

	// ErrorCodeMaximumTapeCartridgeCountExceeded is a ErrorCode enum value
	ErrorCodeMaximumTapeCartridgeCountExceeded = "MaximumTapeCartridgeCountExceeded"

	// ErrorCodeMaximumVolumeCountExceeded is a ErrorCode enum value
	ErrorCodeMaximumVolumeCountExceeded = "MaximumVolumeCountExceeded"

	// ErrorCodeNetworkConfigurationChanged is a ErrorCode enum value
	ErrorCodeNetworkConfigurationChanged = "NetworkConfigurationChanged"

	// ErrorCodeNoDisksAvailable is a ErrorCode enum value
	ErrorCodeNoDisksAvailable = "NoDisksAvailable"

	// ErrorCodeNotImplemented is a ErrorCode enum value
	ErrorCodeNotImplemented = "NotImplemented"

	// ErrorCodeNotSupported is a ErrorCode enum value
	ErrorCodeNotSupported = "NotSupported"

	// ErrorCodeOperationAborted is a ErrorCode enum value
	ErrorCodeOperationAborted = "OperationAborted"

	// ErrorCodeOutdatedGateway is a ErrorCode enum value
	ErrorCodeOutdatedGateway = "OutdatedGateway"

	// ErrorCodeParametersNotImplemented is a ErrorCode enum value
	ErrorCodeParametersNotImplemented = "ParametersNotImplemented"

	// ErrorCodeRegionInvalid is a ErrorCode enum value
	ErrorCodeRegionInvalid = "RegionInvalid"

	// ErrorCodeRequestTimeout is a ErrorCode enum value
	ErrorCodeRequestTimeout = "RequestTimeout"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeSnapshotDeleted is a ErrorCode enum value
	ErrorCodeSnapshotDeleted = "SnapshotDeleted"

	// ErrorCodeSnapshotIdInvalid is a ErrorCode enum value
	ErrorCodeSnapshotIdInvalid = "SnapshotIdInvalid"

	// ErrorCodeSnapshotInProgress is a ErrorCode enum value
	ErrorCodeSnapshotInProgress = "SnapshotInProgress"

	// ErrorCodeSnapshotNotFound is a ErrorCode enum value
	ErrorCodeSnapshotNotFound = "SnapshotNotFound"

	// ErrorCodeSnapshotScheduleNotFound is a ErrorCode enum value
	ErrorCodeSnapshotScheduleNotFound = "SnapshotScheduleNotFound"

	// ErrorCodeStagingAreaFull is a ErrorCode enum value
	ErrorCodeStagingAreaFull = "StagingAreaFull"

	// ErrorCodeStorageFailure is a ErrorCode enum value
	ErrorCodeStorageFailure = "StorageFailure"

	// ErrorCodeTapeCartridgeNotFound is a ErrorCode enum value
	ErrorCodeTapeCartridgeNotFound = "TapeCartridgeNotFound"

	// ErrorCodeTargetAlreadyExists is a ErrorCode enum value
	ErrorCodeTargetAlreadyExists = "TargetAlreadyExists"

	// ErrorCodeTargetInvalid is a ErrorCode enum value
	ErrorCodeTargetInvalid = "TargetInvalid"

	// ErrorCodeTargetNotFound is a ErrorCode enum value
	ErrorCodeTargetNotFound = "TargetNotFound"

	// ErrorCodeUnauthorizedOperation is a ErrorCode enum value
	ErrorCodeUnauthorizedOperation = "UnauthorizedOperation"

	// ErrorCodeVolumeAlreadyExists is a ErrorCode enum value
	ErrorCodeVolumeAlreadyExists = "VolumeAlreadyExists"

	// ErrorCodeVolumeIdInvalid is a ErrorCode enum value
	ErrorCodeVolumeIdInvalid = "VolumeIdInvalid"

	// ErrorCodeVolumeInUse is a ErrorCode enum value
	ErrorCodeVolumeInUse = "VolumeInUse"

	// ErrorCodeVolumeNotFound is a ErrorCode enum value
	ErrorCodeVolumeNotFound = "VolumeNotFound"

	// ErrorCodeVolumeNotReady is a ErrorCode enum value
	ErrorCodeVolumeNotReady = "VolumeNotReady"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeActivationKeyExpired,
		ErrorCodeActivationKeyInvalid,
		ErrorCodeActivationKeyNotFound,
		ErrorCodeGatewayInternalError,
		ErrorCodeGatewayNotConnected,
		ErrorCodeGatewayNotFound,
		ErrorCodeGatewayProxyNetworkConnectionBusy,
		ErrorCodeAuthenticationFailure,
		ErrorCodeBandwidthThrottleScheduleNotFound,
		ErrorCodeBlocked,
		ErrorCodeCannotExportSnapshot,
		ErrorCodeChapCredentialNotFound,
		ErrorCodeDiskAlreadyAllocated,
		ErrorCodeDiskDoesNotExist,
		ErrorCodeDiskSizeGreaterThanVolumeMaxSize,
		ErrorCodeDiskSizeLessThanVolumeSize,
		ErrorCodeDiskSizeNotGigAligned,
		ErrorCodeDuplicateCertificateInfo,
		ErrorCodeDuplicateSchedule,
		ErrorCodeEndpointNotFound,
		ErrorCodeIamnotSupported,
		ErrorCodeInitiatorInvalid,
		ErrorCodeInitiatorNotFound,
		ErrorCodeInternalError,
		ErrorCodeInvalidGateway,
		ErrorCodeInvalidEndpoint,
		ErrorCodeInvalidParameters,
		ErrorCodeInvalidSchedule,
		ErrorCodeLocalStorageLimitExceeded,
		ErrorCodeLunAlreadyAllocated,
		ErrorCodeLunInvalid,
		ErrorCodeJoinDomainInProgress,
		ErrorCodeMaximumContentLengthExceeded,
		ErrorCodeMaximumTapeCartridgeCountExceeded,
		ErrorCodeMaximumVolumeCountExceeded,
		ErrorCodeNetworkConfigurationChanged,
		ErrorCodeNoDisksAvailable,
		ErrorCodeNotImplemented,
		ErrorCodeNotSupported,
		ErrorCodeOperationAborted,
		ErrorCodeOutdatedGateway,
		ErrorCodeParametersNotImplemented,
		ErrorCodeRegionInvalid,
		ErrorCodeRequestTimeout,
		ErrorCodeServiceUnavailable,
		ErrorCodeSnapshotDeleted,
		ErrorCodeSnapshotIdInvalid,
		ErrorCodeSnapshotInProgress,
		ErrorCodeSnapshotNotFound,
		ErrorCodeSnapshotScheduleNotFound,
		ErrorCodeStagingAreaFull,
		ErrorCodeStorageFailure,
		ErrorCodeTapeCartridgeNotFound,
		ErrorCodeTargetAlreadyExists,
		ErrorCodeTargetInvalid,
		ErrorCodeTargetNotFound,
		ErrorCodeUnauthorizedOperation,
		ErrorCodeVolumeAlreadyExists,
		ErrorCodeVolumeIdInvalid,
		ErrorCodeVolumeInUse,
		ErrorCodeVolumeNotFound,
		ErrorCodeVolumeNotReady,
	}
}

// The type of the file share.
const (
	// FileShareTypeNfs is a FileShareType enum value
	FileShareTypeNfs = "NFS"

	// FileShareTypeSmb is a FileShareType enum value
	FileShareTypeSmb = "SMB"
)

// FileShareType_Values returns all elements of the FileShareType enum
func FileShareType_Values() []string {
	return []string{
		FileShareTypeNfs,
		FileShareTypeSmb,
	}
}

const (
	// HostEnvironmentVmware is a HostEnvironment enum value
	HostEnvironmentVmware = "VMWARE"

	// HostEnvironmentHyperV is a HostEnvironment enum value
	HostEnvironmentHyperV = "HYPER-V"

	// HostEnvironmentEc2 is a HostEnvironment enum value
	HostEnvironmentEc2 = "EC2"

	// HostEnvironmentKvm is a HostEnvironment enum value
	HostEnvironmentKvm = "KVM"

	// HostEnvironmentOther is a HostEnvironment enum value
	HostEnvironmentOther = "OTHER"
)

// HostEnvironment_Values returns all elements of the HostEnvironment enum
func HostEnvironment_Values() []string {
	return []string{
		HostEnvironmentVmware,
		HostEnvironmentHyperV,
		HostEnvironmentEc2,
		HostEnvironmentKvm,
		HostEnvironmentOther,
	}
}

// A value that sets the access control list (ACL) permission for objects in
// the S3 bucket that a file gateway puts objects into. The default value is
// private.
const (
	// ObjectACLPrivate is a ObjectACL enum value
	ObjectACLPrivate = "private"

	// ObjectACLPublicRead is a ObjectACL enum value
	ObjectACLPublicRead = "public-read"

	// ObjectACLPublicReadWrite is a ObjectACL enum value
	ObjectACLPublicReadWrite = "public-read-write"

	// ObjectACLAuthenticatedRead is a ObjectACL enum value
	ObjectACLAuthenticatedRead = "authenticated-read"

	// ObjectACLBucketOwnerRead is a ObjectACL enum value
	ObjectACLBucketOwnerRead = "bucket-owner-read"

	// ObjectACLBucketOwnerFullControl is a ObjectACL enum value
	ObjectACLBucketOwnerFullControl = "bucket-owner-full-control"

	// ObjectACLAwsExecRead is a ObjectACL enum value
	ObjectACLAwsExecRead = "aws-exec-read"
)

// ObjectACL_Values returns all elements of the ObjectACL enum
func ObjectACL_Values() []string {
	return []string{
		ObjectACLPrivate,
		ObjectACLPublicRead,
		ObjectACLPublicReadWrite,
		ObjectACLAuthenticatedRead,
		ObjectACLBucketOwnerRead,
		ObjectACLBucketOwnerFullControl,
		ObjectACLAwsExecRead,
	}
}

const (
	// PoolStatusActive is a PoolStatus enum value
	PoolStatusActive = "ACTIVE"

	// PoolStatusDeleted is a PoolStatus enum value
	PoolStatusDeleted = "DELETED"
)

// PoolStatus_Values returns all elements of the PoolStatus enum
func PoolStatus_Values() []string {
	return []string{
		PoolStatusActive,
		PoolStatusDeleted,
	}
}

const (
	// RetentionLockTypeCompliance is a RetentionLockType enum value
	RetentionLockTypeCompliance = "COMPLIANCE"

	// RetentionLockTypeGovernance is a RetentionLockType enum value
	RetentionLockTypeGovernance = "GOVERNANCE"

	// RetentionLockTypeNone is a RetentionLockType enum value
	RetentionLockTypeNone = "NONE"
)

// RetentionLockType_Values returns all elements of the RetentionLockType enum
func RetentionLockType_Values() []string {
	return []string{
		RetentionLockTypeCompliance,
		RetentionLockTypeGovernance,
		RetentionLockTypeNone,
	}
}

const (
	// SMBSecurityStrategyClientSpecified is a SMBSecurityStrategy enum value
	SMBSecurityStrategyClientSpecified = "ClientSpecified"

	// SMBSecurityStrategyMandatorySigning is a SMBSecurityStrategy enum value
	SMBSecurityStrategyMandatorySigning = "MandatorySigning"

	// SMBSecurityStrategyMandatoryEncryption is a SMBSecurityStrategy enum value
	SMBSecurityStrategyMandatoryEncryption = "MandatoryEncryption"
)

// SMBSecurityStrategy_Values returns all elements of the SMBSecurityStrategy enum
func SMBSecurityStrategy_Values() []string {
	return []string{
		SMBSecurityStrategyClientSpecified,
		SMBSecurityStrategyMandatorySigning,
		SMBSecurityStrategyMandatoryEncryption,
	}
}

const (
	// TapeStorageClassDeepArchive is a TapeStorageClass enum value
	TapeStorageClassDeepArchive = "DEEP_ARCHIVE"

	// TapeStorageClassGlacier is a TapeStorageClass enum value
	TapeStorageClassGlacier = "GLACIER"
)

// TapeStorageClass_Values returns all elements of the TapeStorageClass enum
func TapeStorageClass_Values() []string {
	return []string{
		TapeStorageClassDeepArchive,
		TapeStorageClassGlacier,
	}
}
