// Code generated by genlib2. DO NOT EDIT.

package tensor

import (
	"testing"
	"testing/quick"
)

func TestDense_Add(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		ret, err := a.Add(b)
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add failed: %v", err)
	}

}
func TestDense_Sub(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		ret, err := a.Sub(b)
		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.Add(b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub failed: %v", err)
	}
}
func TestDense_Mul(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		ret, err := a.Mul(b)
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul failed: %v", err)
	}

}
func TestDense_Div(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		ret, err := a.Div(b)
		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.Mul(b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div failed: %v", err)
	}
}
func TestDense_Pow(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := a.Engine().(Power)
		we = we || !ok

		ret, err := a.Pow(b)
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow failed: %v", err)
	}

}
func TestDense_Add_unsafe(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		ret, err := a.Add(b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add failed: %v", err)
	}

}
func TestDense_Sub_unsafe(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		ret, err := a.Sub(b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.Add(b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub failed: %v", err)
	}
}
func TestDense_Mul_unsafe(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		ret, err := a.Mul(b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul failed: %v", err)
	}

}
func TestDense_Div_unsafe(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		ret, err := a.Div(b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.Mul(b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div failed: %v", err)
	}
}
func TestDense_Pow_unsafe(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := a.Engine().(Power)
		we = we || !ok

		ret, err := a.Pow(b, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow failed: %v", err)
	}

}
func TestDense_Add_reuse(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		ret, err := a.Add(b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add failed: %v", err)
	}

	mut := func(a, b *Dense, reuseA bool) bool {
		// req because we're only testing on one kind of tensor/engine combo
		a.e = StdEng{}
		a.oe = StdEng{}
		a.flag = 0
		b.e = StdEng{}
		b.oe = StdEng{}
		b.flag = 0

		if a.Dtype() != b.Dtype() {
			return true
		}
		if !a.Shape().Eq(b.Shape()) {
			return true
		}

		correct, err := a.Add(b)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		var ret, reuse *Dense
		if reuseA {
			ret, err = a.Add(b, WithReuse(a))
			reuse = a
		} else {
			ret, err = a.Add(b, WithReuse(b))
			reuse = b
		}

		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}

		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(mut, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Reuse Mutation test for Add failed: %v", err)
	}

}
func TestDense_Sub_reuse(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		ret, err := a.Sub(b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.Add(b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub failed: %v", err)
	}
	mut := func(a, b *Dense, reuseA bool) bool {
		// req because we're only testing on one kind of tensor/engine combo
		a.e = StdEng{}
		a.oe = StdEng{}
		a.flag = 0
		b.e = StdEng{}
		b.oe = StdEng{}
		b.flag = 0

		if a.Dtype() != b.Dtype() {
			return true
		}
		if !a.Shape().Eq(b.Shape()) {
			return true
		}

		correct, err := a.Sub(b)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		var ret, reuse *Dense
		if reuseA {
			ret, err = a.Sub(b, WithReuse(a))
			reuse = a
		} else {
			ret, err = a.Sub(b, WithReuse(b))
			reuse = b
		}

		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}

		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(mut, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Reuse Mutation test for Sub failed: %v", err)
	}

}
func TestDense_Mul_reuse(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		ret, err := a.Mul(b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul failed: %v", err)
	}

	mut := func(a, b *Dense, reuseA bool) bool {
		// req because we're only testing on one kind of tensor/engine combo
		a.e = StdEng{}
		a.oe = StdEng{}
		a.flag = 0
		b.e = StdEng{}
		b.oe = StdEng{}
		b.flag = 0

		if a.Dtype() != b.Dtype() {
			return true
		}
		if !a.Shape().Eq(b.Shape()) {
			return true
		}

		correct, err := a.Mul(b)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		var ret, reuse *Dense
		if reuseA {
			ret, err = a.Mul(b, WithReuse(a))
			reuse = a
		} else {
			ret, err = a.Mul(b, WithReuse(b))
			reuse = b
		}

		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}

		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(mut, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Reuse Mutation test for Mul failed: %v", err)
	}

}
func TestDense_Div_reuse(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		ret, err := a.Div(b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.Mul(b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div failed: %v", err)
	}
	mut := func(a, b *Dense, reuseA bool) bool {
		// req because we're only testing on one kind of tensor/engine combo
		a.e = StdEng{}
		a.oe = StdEng{}
		a.flag = 0
		b.e = StdEng{}
		b.oe = StdEng{}
		b.flag = 0

		if a.Dtype() != b.Dtype() {
			return true
		}
		if !a.Shape().Eq(b.Shape()) {
			return true
		}

		correct, err := a.Div(b)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		var ret, reuse *Dense
		if reuseA {
			ret, err = a.Div(b, WithReuse(a))
			reuse = a
		} else {
			ret, err = a.Div(b, WithReuse(b))
			reuse = b
		}

		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}

		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(mut, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Reuse Mutation test for Div failed: %v", err)
	}

}
func TestDense_Pow_reuse(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := a.Engine().(Power)
		we = we || !ok

		ret, err := a.Pow(b, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow failed: %v", err)
	}

}
func TestDense_Add_incr(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		ret, err := a.Add(b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add failed: %v", err)
	}

}
func TestDense_Sub_incr(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		ret, err := a.Sub(b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.Add(b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub failed: %v", err)
	}
}
func TestDense_Mul_incr(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		ret, err := a.Mul(b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul failed: %v", err)
	}

}
func TestDense_Div_incr(t *testing.T) {
	inv := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		ret, err := a.Div(b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.Mul(b, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div failed: %v", err)
	}
}
func TestDense_Pow_incr(t *testing.T) {
	iden := func(a *Dense) bool {
		b := New(Of(a.t), WithShape(a.Shape().Clone()...), WithEngine(a.Engine()))
		b.Memset(identityVal(1, a.t))
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := a.Engine().(Power)
		we = we || !ok

		ret, err := a.Pow(b, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow failed: %v", err)
	}

}
func TestDense_AddScalar(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := a.AddScalar(b, true)
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := a.AddScalar(b, false)
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (scalar as left, tensor as right) failed: %v", err)
	}

	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Add(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Add(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Add (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestDense_SubScalar(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := a.SubScalar(b, true)
		if err, retEarly := qcErrCheck(t, "SubVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.AddScalar(b, true, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

	inv2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := a.SubScalar(b, false)
		if err, retEarly := qcErrCheck(t, "SubSV", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.SubScalar(b, false, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (scalar as left, tensor as right) failed: %v", err)
	}
	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Sub(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Sub(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Sub (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestDense_MulScalar(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := a.MulScalar(b, true)
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := a.MulScalar(b, false)
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (scalar as left, tensor as right) failed: %v", err)
	}

	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Mul(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Mul(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Mul (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestDense_DivScalar(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Diver)
		we = we || !ok

		ret, err := a.DivScalar(b, true)
		if err, retEarly := qcErrCheck(t, "DivVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.MulScalar(b, true, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div (tensor as left, scalar as right) failed: %v", err)
	}

	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Div(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Div (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Div(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Div (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestDense_PowScalar(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := q.Engine().(Power)
		we = we || !ok

		ret, err := a.PowScalar(b, true)
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

	type Foo int
	wt1 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Pow(a, b)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

	wt2 := func(a *Dense) bool {
		b := Foo(0)
		ret, err := Pow(b, a)
		if err == nil {
			return false
		}
		_ = ret
		return true
	}
	if err := quick.Check(wt2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("WrongType test for Pow (tensor as right, scalar as left) failed: %v", err)
	}
}
func TestDense_AddScalar_unsafe(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := a.AddScalar(b, true, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := a.AddScalar(b, false, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestDense_SubScalar_unsafe(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := a.SubScalar(b, true, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "SubVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.AddScalar(b, true, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

	inv2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := a.SubScalar(b, false, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "SubSV", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.SubScalar(b, false, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (scalar as left, tensor as right) failed: %v", err)
	}
}
func TestDense_MulScalar_unsafe(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := a.MulScalar(b, true, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := a.MulScalar(b, false, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestDense_DivScalar_unsafe(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Diver)
		we = we || !ok

		ret, err := a.DivScalar(b, true, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "DivVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.MulScalar(b, true, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestDense_PowScalar_unsafe(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := q.Engine().(Power)
		we = we || !ok

		ret, err := a.PowScalar(b, true, UseUnsafe())
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if ret != a {
			t.Errorf("Expected ret to be the same as a")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestDense_AddScalar_reuse(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := a.AddScalar(b, true, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := a.AddScalar(b, false, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (scalar as left, tensor as right) failed: %v", err)
	}

	mut := func(a, b *Dense, reuseA bool) bool {
		// req because we're only testing on one kind of tensor/engine combo
		a.e = StdEng{}
		a.oe = StdEng{}
		a.flag = 0
		b.e = StdEng{}
		b.oe = StdEng{}
		b.flag = 0

		if a.Dtype() != b.Dtype() {
			return true
		}
		if !a.Shape().Eq(b.Shape()) {
			return true
		}

		correct, err := a.Add(b)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Adder)
		we = we || !ok

		var ret, reuse *Dense
		if reuseA {
			ret, err = a.Add(b, WithReuse(a))
			reuse = a
		} else {
			ret, err = a.Add(b, WithReuse(b))
			reuse = b
		}

		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}

		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(mut, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Reuse Mutation test for Add failed: %v", err)
	}

}
func TestDense_SubScalar_reuse(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := a.SubScalar(b, true, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "SubVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.AddScalar(b, true, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

	inv2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := a.SubScalar(b, false, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "SubSV", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.SubScalar(b, false, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (scalar as left, tensor as right) failed: %v", err)
	}
	mut := func(a, b *Dense, reuseA bool) bool {
		// req because we're only testing on one kind of tensor/engine combo
		a.e = StdEng{}
		a.oe = StdEng{}
		a.flag = 0
		b.e = StdEng{}
		b.oe = StdEng{}
		b.flag = 0

		if a.Dtype() != b.Dtype() {
			return true
		}
		if !a.Shape().Eq(b.Shape()) {
			return true
		}

		correct, err := a.Sub(b)
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := a.Engine().(Suber)
		we = we || !ok

		var ret, reuse *Dense
		if reuseA {
			ret, err = a.Sub(b, WithReuse(a))
			reuse = a
		} else {
			ret, err = a.Sub(b, WithReuse(b))
			reuse = b
		}

		if err, retEarly := qcErrCheck(t, "Sub", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}

		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(mut, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Reuse Mutation test for Sub failed: %v", err)
	}

}
func TestDense_MulScalar_reuse(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := a.MulScalar(b, true, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := a.MulScalar(b, false, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (scalar as left, tensor as right) failed: %v", err)
	}

	mut := func(a, b *Dense, reuseA bool) bool {
		// req because we're only testing on one kind of tensor/engine combo
		a.e = StdEng{}
		a.oe = StdEng{}
		a.flag = 0
		b.e = StdEng{}
		b.oe = StdEng{}
		b.flag = 0

		if a.Dtype() != b.Dtype() {
			return true
		}
		if !a.Shape().Eq(b.Shape()) {
			return true
		}

		correct, err := a.Mul(b)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Muler)
		we = we || !ok

		var ret, reuse *Dense
		if reuseA {
			ret, err = a.Mul(b, WithReuse(a))
			reuse = a
		} else {
			ret, err = a.Mul(b, WithReuse(b))
			reuse = b
		}

		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}

		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(mut, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Reuse Mutation test for Mul failed: %v", err)
	}

}
func TestDense_DivScalar_reuse(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Diver)
		we = we || !ok

		ret, err := a.DivScalar(b, true, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "DivVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.MulScalar(b, true, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div (tensor as left, scalar as right) failed: %v", err)
	}

	mut := func(a, b *Dense, reuseA bool) bool {
		// req because we're only testing on one kind of tensor/engine combo
		a.e = StdEng{}
		a.oe = StdEng{}
		a.flag = 0
		b.e = StdEng{}
		b.oe = StdEng{}
		b.flag = 0

		if a.Dtype() != b.Dtype() {
			return true
		}
		if !a.Shape().Eq(b.Shape()) {
			return true
		}

		correct, err := a.Div(b)
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := a.Engine().(Diver)
		we = we || !ok

		var ret, reuse *Dense
		if reuseA {
			ret, err = a.Div(b, WithReuse(a))
			reuse = a
		} else {
			ret, err = a.Div(b, WithReuse(b))
			reuse = b
		}

		if err, retEarly := qcErrCheck(t, "Div", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}

		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}
	if err := quick.Check(mut, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Reuse Mutation test for Div failed: %v", err)
	}

}
func TestDense_PowScalar_reuse(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		reuse := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := q.Engine().(Power)
		we = we || !ok

		ret, err := a.PowScalar(b, true, WithReuse(reuse))
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		if reuse != ret {
			t.Errorf("Expected reuse to be the same as retVal")
			return false
		}

		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestDense_AddScalar_incr(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := a.AddScalar(b, true, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Adder)
		we = we || !ok

		ret, err := a.AddScalar(b, false, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Add", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Add (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestDense_SubScalar_incr(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(0, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, unsignedTypes)
		_, ok := q.Engine().(Suber)
		we = we || !ok

		ret, err := a.SubScalar(b, true, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "SubVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.AddScalar(b, true, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Sub (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestDense_MulScalar_incr(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := a.MulScalar(b, true, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (tensor as left, scalar as right) failed: %v", err)
	}

	iden2 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))
		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Muler)
		we = we || !ok

		ret, err := a.MulScalar(b, false, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Mul", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(iden2, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Mul (scalar as left, tensor as right) failed: %v", err)
	}

}
func TestDense_DivScalar_incr(t *testing.T) {
	inv1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, numberTypes, nil)
		_, ok := q.Engine().(Diver)
		we = we || !ok

		ret, err := a.DivScalar(b, true, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "DivVS", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}
		ret, err = ret.MulScalar(b, true, UseUnsafe())

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}
	if err := quick.Check(inv1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Inv test for Div (tensor as left, scalar as right) failed: %v", err)
	}

}
func TestDense_PowScalar_incr(t *testing.T) {
	iden1 := func(q *Dense) bool {
		a := q.Clone().(*Dense)
		b := identityVal(1, q.t)
		incr := New(Of(a.t), WithShape(a.Shape().Clone()...))

		correct := a.Clone().(*Dense)
		incr.Memset(identityVal(100, a.t))
		correct.Add(incr, UseUnsafe())
		we, willFailEq := willerr(a, floatcmplxTypes, complexTypes)
		_, ok := q.Engine().(Power)
		we = we || !ok

		ret, err := a.PowScalar(b, true, WithIncr(incr))
		if err, retEarly := qcErrCheck(t, "Pow", a, b, we, err); retEarly {
			if err != nil {
				return false
			}
			return true
		}

		if !qcEqCheck(t, a.Dtype(), willFailEq, correct.Data(), ret.Data()) {
			return false
		}
		return true
	}

	if err := quick.Check(iden1, &quick.Config{Rand: newRand(), MaxCount: quickchecks}); err != nil {
		t.Errorf("Identity test for Pow (tensor as left, scalar as right) failed: %v", err)
	}

}
