/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// NetworkLoadBalancerForwardingRuleTargetHealthCheck struct for NetworkLoadBalancerForwardingRuleTargetHealthCheck
type NetworkLoadBalancerForwardingRuleTargetHealthCheck struct {
	// Makes the target available only if it accepts periodic health check TCP connection attempts; when turned off, the target is considered always available. The health check only consists of a connection attempt to the address and port of the target.
	Check *bool `json:"check,omitempty"`
	// The interval in milliseconds between consecutive health checks; default is 2000.
	CheckInterval *int32 `json:"checkInterval,omitempty"`
	// Maintenance mode prevents the target from receiving balanced traffic.
	Maintenance *bool `json:"maintenance,omitempty"`
}

// NewNetworkLoadBalancerForwardingRuleTargetHealthCheck instantiates a new NetworkLoadBalancerForwardingRuleTargetHealthCheck object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewNetworkLoadBalancerForwardingRuleTargetHealthCheck() *NetworkLoadBalancerForwardingRuleTargetHealthCheck {
	this := NetworkLoadBalancerForwardingRuleTargetHealthCheck{}

	return &this
}

// NewNetworkLoadBalancerForwardingRuleTargetHealthCheckWithDefaults instantiates a new NetworkLoadBalancerForwardingRuleTargetHealthCheck object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNetworkLoadBalancerForwardingRuleTargetHealthCheckWithDefaults() *NetworkLoadBalancerForwardingRuleTargetHealthCheck {
	this := NetworkLoadBalancerForwardingRuleTargetHealthCheck{}
	return &this
}

// GetCheck returns the Check field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) GetCheck() *bool {
	if o == nil {
		return nil
	}

	return o.Check

}

// GetCheckOk returns a tuple with the Check field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) GetCheckOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}

	return o.Check, true
}

// SetCheck sets field value
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) SetCheck(v bool) {

	o.Check = &v

}

// HasCheck returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) HasCheck() bool {
	if o != nil && o.Check != nil {
		return true
	}

	return false
}

// GetCheckInterval returns the CheckInterval field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) GetCheckInterval() *int32 {
	if o == nil {
		return nil
	}

	return o.CheckInterval

}

// GetCheckIntervalOk returns a tuple with the CheckInterval field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) GetCheckIntervalOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.CheckInterval, true
}

// SetCheckInterval sets field value
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) SetCheckInterval(v int32) {

	o.CheckInterval = &v

}

// HasCheckInterval returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) HasCheckInterval() bool {
	if o != nil && o.CheckInterval != nil {
		return true
	}

	return false
}

// GetMaintenance returns the Maintenance field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) GetMaintenance() *bool {
	if o == nil {
		return nil
	}

	return o.Maintenance

}

// GetMaintenanceOk returns a tuple with the Maintenance field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) GetMaintenanceOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}

	return o.Maintenance, true
}

// SetMaintenance sets field value
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) SetMaintenance(v bool) {

	o.Maintenance = &v

}

// HasMaintenance returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleTargetHealthCheck) HasMaintenance() bool {
	if o != nil && o.Maintenance != nil {
		return true
	}

	return false
}

func (o NetworkLoadBalancerForwardingRuleTargetHealthCheck) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Check != nil {
		toSerialize["check"] = o.Check
	}
	if o.CheckInterval != nil {
		toSerialize["checkInterval"] = o.CheckInterval
	}
	if o.Maintenance != nil {
		toSerialize["maintenance"] = o.Maintenance
	}
	return json.Marshal(toSerialize)
}

type NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck struct {
	value *NetworkLoadBalancerForwardingRuleTargetHealthCheck
	isSet bool
}

func (v NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck) Get() *NetworkLoadBalancerForwardingRuleTargetHealthCheck {
	return v.value
}

func (v *NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck) Set(val *NetworkLoadBalancerForwardingRuleTargetHealthCheck) {
	v.value = val
	v.isSet = true
}

func (v NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck) IsSet() bool {
	return v.isSet
}

func (v *NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNetworkLoadBalancerForwardingRuleTargetHealthCheck(val *NetworkLoadBalancerForwardingRuleTargetHealthCheck) *NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck {
	return &NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck{value: val, isSet: true}
}

func (v NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNetworkLoadBalancerForwardingRuleTargetHealthCheck) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
