// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/rethinkdb/rethinkdb-go.v6"
	"gopkg.in/rethinkdb/rethinkdb-go.v6/internal/compare"
)

// sindex api (#602)
func TestSindexApiSuite(t *testing.T) {
	suite.Run(t, new(SindexApiSuite))
}

type SindexApiSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *SindexApiSuite) SetupTest() {
	suite.T().Log("Setting up SindexApiSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("db_sindex_api").Exec(suite.session)
	err = r.DBCreate("db_sindex_api").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("db_sindex_api").Wait().Exec(suite.session)
	suite.Require().NoError(err)

	r.DB("db_sindex_api").TableDrop("table_test_sindex_api").Exec(suite.session)
	err = r.DB("db_sindex_api").TableCreate("table_test_sindex_api").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("db_sindex_api").Table("table_test_sindex_api").Wait().Exec(suite.session)
	suite.Require().NoError(err)
}

func (suite *SindexApiSuite) TearDownSuite() {
	suite.T().Log("Tearing down SindexApiSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DB("db_sindex_api").TableDrop("table_test_sindex_api").Exec(suite.session)
		r.DBDrop("db_sindex_api").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *SindexApiSuite) TestCases() {
	suite.T().Log("Running SindexApiSuite: sindex api (#602)")

	table_test_sindex_api := r.DB("db_sindex_api").Table("table_test_sindex_api")
	_ = table_test_sindex_api // Prevent any noused variable errors

	// sindex/api.yaml line #5
	// rows = [{'id':0, 'a':0, 'b':0, 'c':0, 'm':[1,2,3]},{'id':1, 'a':0, 'b':0, 'c':0, 'm':[4,5,6]},{'id':2, 'a':0, 'b':0, 'c':1, 'm':7},{'id':3, 'a':0, 'b':1, 'c':1, 'm':[10,11,12]},{'id':4, 'a':4, 'b':4, 'c':4, 'm':[14,15,16]}]
	suite.T().Log("Possibly executing: var rows []interface{} = []interface{}{map[interface{}]interface{}{'id': 0, 'a': 0, 'b': 0, 'c': 0, 'm': []interface{}{1, 2, 3}, }, map[interface{}]interface{}{'id': 1, 'a': 0, 'b': 0, 'c': 0, 'm': []interface{}{4, 5, 6}, }, map[interface{}]interface{}{'id': 2, 'a': 0, 'b': 0, 'c': 1, 'm': 7, }, map[interface{}]interface{}{'id': 3, 'a': 0, 'b': 1, 'c': 1, 'm': []interface{}{10, 11, 12}, }, map[interface{}]interface{}{'id': 4, 'a': 4, 'b': 4, 'c': 4, 'm': []interface{}{14, 15, 16}, }}")

	rows := []interface{}{map[interface{}]interface{}{"id": 0, "a": 0, "b": 0, "c": 0, "m": []interface{}{1, 2, 3}}, map[interface{}]interface{}{"id": 1, "a": 0, "b": 0, "c": 0, "m": []interface{}{4, 5, 6}}, map[interface{}]interface{}{"id": 2, "a": 0, "b": 0, "c": 1, "m": 7}, map[interface{}]interface{}{"id": 3, "a": 0, "b": 1, "c": 1, "m": []interface{}{10, 11, 12}}, map[interface{}]interface{}{"id": 4, "a": 4, "b": 4, "c": 4, "m": []interface{}{14, 15, 16}}}
	_ = rows // Prevent any noused variable errors

	{
		// sindex/api.yaml line #11
		/* ({'deleted':0,'inserted':4,'skipped':0,'errors':0,'replaced':0,'unchanged':0}) */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "inserted": 4, "skipped": 0, "errors": 0, "replaced": 0, "unchanged": 0}
		/* table_test_sindex_api.insert([{'id':0, 'a':0, 'b':0, 'c':0, 'm':[1,2,3]},
		{'id':1, 'a':0, 'b':0, 'c':0, 'm':[4,5,6]},
		{'id':2, 'a':0, 'b':0, 'c':1, 'm':7},
		{'id':3, 'a':0, 'b':1, 'c':1, 'm':[10,11,12]}]) */

		suite.T().Log("About to run line #11: table_test_sindex_api.Insert([]interface{}{map[interface{}]interface{}{'id': 0, 'a': 0, 'b': 0, 'c': 0, 'm': []interface{}{1, 2, 3}, }, map[interface{}]interface{}{'id': 1, 'a': 0, 'b': 0, 'c': 0, 'm': []interface{}{4, 5, 6}, }, map[interface{}]interface{}{'id': 2, 'a': 0, 'b': 0, 'c': 1, 'm': 7, }, map[interface{}]interface{}{'id': 3, 'a': 0, 'b': 1, 'c': 1, 'm': []interface{}{10, 11, 12}, }})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Insert([]interface{}{map[interface{}]interface{}{"id": 0, "a": 0, "b": 0, "c": 0, "m": []interface{}{1, 2, 3}}, map[interface{}]interface{}{"id": 1, "a": 0, "b": 0, "c": 0, "m": []interface{}{4, 5, 6}}, map[interface{}]interface{}{"id": 2, "a": 0, "b": 0, "c": 1, "m": 7}, map[interface{}]interface{}{"id": 3, "a": 0, "b": 1, "c": 1, "m": []interface{}{10, 11, 12}}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #11")
	}

	{
		// sindex/api.yaml line #18
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('rename-foo', r.row['b']) */

		suite.T().Log("About to run line #18: table_test_sindex_api.IndexCreateFunc('rename-foo', r.Row.AtIndex('b'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("rename-foo", r.Row.AtIndex("b")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #18")
	}

	{
		// sindex/api.yaml line #23
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('rename-bar', r.row['c']) */

		suite.T().Log("About to run line #23: table_test_sindex_api.IndexCreateFunc('rename-bar', r.Row.AtIndex('c'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("rename-bar", r.Row.AtIndex("c")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #23")
	}

	{
		// sindex/api.yaml line #28
		/* err_regex('ReqlOpFailedError','Index `rename-foo` does not exist or index `rename-bar` already exists on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]',[]) */
		var expected_ Err = err_regex("ReqlOpFailedError", "Index `rename-foo` does not exist or index `rename-bar` already exists on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]")
		/* table_test_sindex_api.index_rename('rename-foo','rename-bar') */

		suite.T().Log("About to run line #28: table_test_sindex_api.IndexRename('rename-foo', 'rename-bar')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("rename-foo", "rename-bar"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #28")
	}

	{
		// sindex/api.yaml line #31
		/* err_regex('ReqlOpFailedError','Index `rename-fake` does not exist or index `rename-stuff` already exists on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]',[]) */
		var expected_ Err = err_regex("ReqlOpFailedError", "Index `rename-fake` does not exist or index `rename-stuff` already exists on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]")
		/* table_test_sindex_api.index_rename('rename-fake','rename-stuff') */

		suite.T().Log("About to run line #31: table_test_sindex_api.IndexRename('rename-fake', 'rename-stuff')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("rename-fake", "rename-stuff"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #31")
	}

	{
		// sindex/api.yaml line #34
		/* err('ReqlQueryLogicError','Index name conflict:'+' `id` is the name of the primary key.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Index name conflict:"+" `id` is the name of the primary key.")
		/* table_test_sindex_api.index_rename('id','rename-stuff') */

		suite.T().Log("About to run line #34: table_test_sindex_api.IndexRename('id', 'rename-stuff')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("id", "rename-stuff"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #34")
	}

	{
		// sindex/api.yaml line #37
		/* err('ReqlQueryLogicError','Index name conflict:'+' `id` is the name of the primary key.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Index name conflict:"+" `id` is the name of the primary key.")
		/* table_test_sindex_api.index_rename('rename-stuff','id') */

		suite.T().Log("About to run line #37: table_test_sindex_api.IndexRename('rename-stuff', 'id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("rename-stuff", "id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #37")
	}

	{
		// sindex/api.yaml line #40
		/* {'renamed':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"renamed": 0}
		/* table_test_sindex_api.index_rename('rename-foo','rename-foo') */

		suite.T().Log("About to run line #40: table_test_sindex_api.IndexRename('rename-foo', 'rename-foo')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("rename-foo", "rename-foo"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #40")
	}

	{
		// sindex/api.yaml line #43
		/* {'renamed':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"renamed": 0}
		/* table_test_sindex_api.index_rename('rename-foo','rename-foo',overwrite=True) */

		suite.T().Log("About to run line #43: table_test_sindex_api.IndexRename('rename-foo', 'rename-foo').OptArgs(r.IndexRenameOpts{Overwrite: true, })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("rename-foo", "rename-foo").OptArgs(r.IndexRenameOpts{Overwrite: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #43")
	}

	{
		// sindex/api.yaml line #48
		/* {'renamed':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"renamed": 1}
		/* table_test_sindex_api.index_rename('rename-foo','rename-bar',overwrite=True) */

		suite.T().Log("About to run line #48: table_test_sindex_api.IndexRename('rename-foo', 'rename-bar').OptArgs(r.IndexRenameOpts{Overwrite: true, })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("rename-foo", "rename-bar").OptArgs(r.IndexRenameOpts{Overwrite: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #48")
	}

	{
		// sindex/api.yaml line #53
		/* {'renamed':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"renamed": 1}
		/* table_test_sindex_api.index_rename('rename-bar','rename-stuff',overwrite=True) */

		suite.T().Log("About to run line #53: table_test_sindex_api.IndexRename('rename-bar', 'rename-stuff').OptArgs(r.IndexRenameOpts{Overwrite: true, })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("rename-bar", "rename-stuff").OptArgs(r.IndexRenameOpts{Overwrite: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #53")
	}

	{
		// sindex/api.yaml line #58
		/* {'renamed':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"renamed": 1}
		/* table_test_sindex_api.index_rename('rename-stuff','rename-last') */

		suite.T().Log("About to run line #58: table_test_sindex_api.IndexRename('rename-stuff', 'rename-last')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexRename("rename-stuff", "rename-last"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #58")
	}

	{
		// sindex/api.yaml line #62
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('minval', lambda:r.minval) */

		suite.T().Log("About to run line #62: table_test_sindex_api.IndexCreateFunc('minval', func() interface{} { return r.MinVal})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("minval", func() interface{} { return r.MinVal }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #62")
	}

	{
		// sindex/api.yaml line #67
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('maxval', lambda:r.maxval) */

		suite.T().Log("About to run line #67: table_test_sindex_api.IndexCreateFunc('maxval', func() interface{} { return r.MaxVal})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("maxval", func() interface{} { return r.MaxVal }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #67")
	}

	{
		// sindex/api.yaml line #71
		/* bag([{'index':'rename-last','ready':true},
		{'index':'minval','ready':true},
		{'index':'maxval','ready':true}]) */
		var expected_ compare.Expected = compare.UnorderedMatch([]interface{}{map[interface{}]interface{}{"index": "rename-last", "ready": true}, map[interface{}]interface{}{"index": "minval", "ready": true}, map[interface{}]interface{}{"index": "maxval", "ready": true}})
		/* table_test_sindex_api.index_wait('rename-last', 'minval', 'maxval').pluck('index', 'ready') */

		suite.T().Log("About to run line #71: table_test_sindex_api.IndexWait('rename-last', 'minval', 'maxval').Pluck('index', 'ready')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexWait("rename-last", "minval", "maxval").Pluck("index", "ready"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #71")
	}

	{
		// sindex/api.yaml line #76
		/* 3 */
		var expected_ int = 3
		/* table_test_sindex_api.get_all(0, index='rename-last').count() */

		suite.T().Log("About to run line #76: table_test_sindex_api.GetAll(0).OptArgs(r.GetAllOpts{Index: 'rename-last', }).Count()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(0).OptArgs(r.GetAllOpts{Index: "rename-last"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #76")
	}

	{
		// sindex/api.yaml line #82
		/* 0 */
		var expected_ int = 0
		/* table_test_sindex_api.get_all(r.minval, index='minval').count() */

		suite.T().Log("About to run line #82: table_test_sindex_api.GetAll(r.MinVal).OptArgs(r.GetAllOpts{Index: 'minval', }).Count()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(r.MinVal).OptArgs(r.GetAllOpts{Index: "minval"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #82")
	}

	{
		// sindex/api.yaml line #87
		/* 0 */
		var expected_ int = 0
		/* table_test_sindex_api.get_all(r.maxval, index='maxval').count() */

		suite.T().Log("About to run line #87: table_test_sindex_api.GetAll(r.MaxVal).OptArgs(r.GetAllOpts{Index: 'maxval', }).Count()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(r.MaxVal).OptArgs(r.GetAllOpts{Index: "maxval"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #87")
	}

	{
		// sindex/api.yaml line #92
		/* 0 */
		var expected_ int = 0
		/* table_test_sindex_api.between(r.minval, r.maxval, index='minval').count() */

		suite.T().Log("About to run line #92: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'minval', }).Count()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "minval"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #92")
	}

	{
		// sindex/api.yaml line #97
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('rename-last-dup', table_test_sindex_api.index_status('rename-last').nth(0).get_field('function')) */

		suite.T().Log("About to run line #97: table_test_sindex_api.IndexCreateFunc('rename-last-dup', table_test_sindex_api.IndexStatus('rename-last').Nth(0).Field('function'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("rename-last-dup", table_test_sindex_api.IndexStatus("rename-last").Nth(0).Field("function")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #97")
	}

	{
		// sindex/api.yaml line #100
		/* [{'index':'rename-last-dup','ready':true}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"index": "rename-last-dup", "ready": true}}
		/* table_test_sindex_api.index_wait('rename-last-dup').pluck('index', 'ready') */

		suite.T().Log("About to run line #100: table_test_sindex_api.IndexWait('rename-last-dup').Pluck('index', 'ready')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexWait("rename-last-dup").Pluck("index", "ready"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #100")
	}

	{
		// sindex/api.yaml line #103
		/* 3 */
		var expected_ int = 3
		/* table_test_sindex_api.get_all(0, index='rename-last-dup').count() */

		suite.T().Log("About to run line #103: table_test_sindex_api.GetAll(0).OptArgs(r.GetAllOpts{Index: 'rename-last-dup', }).Count()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(0).OptArgs(r.GetAllOpts{Index: "rename-last-dup"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #103")
	}

	{
		// sindex/api.yaml line #109
		/* {'dropped':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"dropped": 1}
		/* table_test_sindex_api.index_drop('rename-last-dup') */

		suite.T().Log("About to run line #109: table_test_sindex_api.IndexDrop('rename-last-dup')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexDrop("rename-last-dup"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #109")
	}

	{
		// sindex/api.yaml line #110
		/* {'dropped':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"dropped": 1}
		/* table_test_sindex_api.index_drop('minval') */

		suite.T().Log("About to run line #110: table_test_sindex_api.IndexDrop('minval')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexDrop("minval"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #110")
	}

	{
		// sindex/api.yaml line #111
		/* {'dropped':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"dropped": 1}
		/* table_test_sindex_api.index_drop('maxval') */

		suite.T().Log("About to run line #111: table_test_sindex_api.IndexDrop('maxval')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexDrop("maxval"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #111")
	}

	{
		// sindex/api.yaml line #114
		/* ['rename-last'] */
		var expected_ []interface{} = []interface{}{"rename-last"}
		/* table_test_sindex_api.index_list() */

		suite.T().Log("About to run line #114: table_test_sindex_api.IndexList()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexList(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #114")
	}

	{
		// sindex/api.yaml line #117
		/* {'dropped':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"dropped": 1}
		/* table_test_sindex_api.index_drop('rename-last') */

		suite.T().Log("About to run line #117: table_test_sindex_api.IndexDrop('rename-last')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexDrop("rename-last"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #117")
	}

	{
		// sindex/api.yaml line #121
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('ai', r.row['a']) */

		suite.T().Log("About to run line #121: table_test_sindex_api.IndexCreateFunc('ai', r.Row.AtIndex('a'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("ai", r.Row.AtIndex("a")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #121")
	}

	{
		// sindex/api.yaml line #125
		/* err_regex("ReqlOpFailedError", "Index `ai` already exists on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]", []) */
		var expected_ Err = err_regex("ReqlOpFailedError", "Index `ai` already exists on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]")
		/* table_test_sindex_api.index_create('ai', r.row['a']) */

		suite.T().Log("About to run line #125: table_test_sindex_api.IndexCreateFunc('ai', r.Row.AtIndex('a'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("ai", r.Row.AtIndex("a")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #125")
	}

	{
		// sindex/api.yaml line #129
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('bi', r.row['b']) */

		suite.T().Log("About to run line #129: table_test_sindex_api.IndexCreateFunc('bi', r.Row.AtIndex('b'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("bi", r.Row.AtIndex("b")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #129")
	}

	{
		// sindex/api.yaml line #133
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('ci', r.row['c']) */

		suite.T().Log("About to run line #133: table_test_sindex_api.IndexCreateFunc('ci', r.Row.AtIndex('c'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("ci", r.Row.AtIndex("c")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #133")
	}

	{
		// sindex/api.yaml line #137
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('idi', r.row['id']) */

		suite.T().Log("About to run line #137: table_test_sindex_api.IndexCreateFunc('idi', r.Row.AtIndex('id'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("idi", r.Row.AtIndex("id")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #137")
	}

	{
		// sindex/api.yaml line #141
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('kdi', [r.row['id']]) */

		suite.T().Log("About to run line #141: table_test_sindex_api.IndexCreateFunc('kdi', []interface{}{r.Row.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("kdi", []interface{}{r.Row.AtIndex("id")}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #141")
	}

	{
		// sindex/api.yaml line #145
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('mi', r.row['m'], multi=True) */

		suite.T().Log("About to run line #145: table_test_sindex_api.IndexCreateFunc('mi', r.Row.AtIndex('m')).OptArgs(r.IndexCreateOpts{Multi: true, })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("mi", r.Row.AtIndex("m")).OptArgs(r.IndexCreateOpts{Multi: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #145")
	}

	{
		// sindex/api.yaml line #149
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('brokeni', r.row['broken']) */

		suite.T().Log("About to run line #149: table_test_sindex_api.IndexCreateFunc('brokeni', r.Row.AtIndex('broken'))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("brokeni", r.Row.AtIndex("broken")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #149")
	}

	{
		// sindex/api.yaml line #153
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_sindex_api.index_wait().pluck('index', 'ready') */

		suite.T().Log("About to run line #153: table_test_sindex_api.IndexWait().Pluck('index', 'ready')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexWait().Pluck("index", "ready"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #153")
	}

	{
		// sindex/api.yaml line #156
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_sindex_api.get(True) */

		suite.T().Log("About to run line #156: table_test_sindex_api.Get(true)")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Get(true), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #156")
	}

	{
		// sindex/api.yaml line #159
		/* null */
		var expected_ interface{} = nil
		/* table_test_sindex_api.get([]) */

		suite.T().Log("About to run line #159: table_test_sindex_api.Get([]interface{}{})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Get([]interface{}{}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #159")
	}

	{
		// sindex/api.yaml line #161
		/* null */
		var expected_ interface{} = nil
		/* table_test_sindex_api.get(-1) */

		suite.T().Log("About to run line #161: table_test_sindex_api.Get(-1)")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Get(-1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #161")
	}

	{
		// sindex/api.yaml line #164
		/* 1 */
		var expected_ int = 1
		/* table_test_sindex_api.get(1)['id'] */

		suite.T().Log("About to run line #164: table_test_sindex_api.Get(1).AtIndex('id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Get(1).AtIndex("id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #164")
	}

	{
		// sindex/api.yaml line #168
		/* 'SELECTION<OBJECT>' */
		var expected_ string = "SELECTION<OBJECT>"
		/* table_test_sindex_api.get(1).type_of() */

		suite.T().Log("About to run line #168: table_test_sindex_api.Get(1).TypeOf()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Get(1).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #168")
	}

	{
		// sindex/api.yaml line #172
		/* {'replaced':0,'skipped':0,'deleted':0,'unchanged':1,'errors':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"replaced": 0, "skipped": 0, "deleted": 0, "unchanged": 1, "errors": 0, "inserted": 0}
		/* table_test_sindex_api.get(1).update(lambda x:null) */

		suite.T().Log("About to run line #172: table_test_sindex_api.Get(1).Update(func(x r.Term) interface{} { return nil})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Get(1).Update(func(x r.Term) interface{} { return nil }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #172")
	}

	{
		// sindex/api.yaml line #180
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_sindex_api.get_all(True, index='id') */

		suite.T().Log("About to run line #180: table_test_sindex_api.GetAll(true).OptArgs(r.GetAllOpts{Index: 'id', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(true).OptArgs(r.GetAllOpts{Index: "id"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #180")
	}

	{
		// sindex/api.yaml line #185
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.get_all(-1, index='id') */

		suite.T().Log("About to run line #185: table_test_sindex_api.GetAll(-1).OptArgs(r.GetAllOpts{Index: 'id', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(-1).OptArgs(r.GetAllOpts{Index: "id"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #185")
	}

	{
		// sindex/api.yaml line #189
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.get_all(-1) */

		suite.T().Log("About to run line #189: table_test_sindex_api.GetAll(-1)")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(-1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #189")
	}

	{
		// sindex/api.yaml line #193
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.get_all([-1]) */

		suite.T().Log("About to run line #193: table_test_sindex_api.GetAll([]interface{}{-1})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll([]interface{}{-1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #193")
	}

	{
		// sindex/api.yaml line #197
		/* 1 */
		var expected_ int = 1
		/* table_test_sindex_api.get_all(1, index='id')[0]['id'] */

		suite.T().Log("About to run line #197: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'id', }).AtIndex(0).AtIndex('id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "id"}).AtIndex(0).AtIndex("id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #197")
	}

	{
		// sindex/api.yaml line #201
		/* 1 */
		var expected_ int = 1
		/* table_test_sindex_api.get_all(1)[0]['id'] */

		suite.T().Log("About to run line #201: table_test_sindex_api.GetAll(1).AtIndex(0).AtIndex('id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).AtIndex(0).AtIndex("id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #201")
	}

	{
		// sindex/api.yaml line #205
		/* bag([1,2,3]) */
		var expected_ compare.Expected = compare.UnorderedMatch([]interface{}{1, 2, 3})
		/* table_test_sindex_api.get_all(1,2,3, index='id').map(lambda x:x["id"]).coerce_to("ARRAY") */

		suite.T().Log("About to run line #205: table_test_sindex_api.GetAll(1, 2, 3).OptArgs(r.GetAllOpts{Index: 'id', }).Map(func(x r.Term) interface{} { return x.AtIndex('id')}).CoerceTo('ARRAY')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1, 2, 3).OptArgs(r.GetAllOpts{Index: "id"}).Map(func(x r.Term) interface{} { return x.AtIndex("id") }).CoerceTo("ARRAY"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #205")
	}

	{
		// sindex/api.yaml line #209
		/* bag([1,2,3]) */
		var expected_ compare.Expected = compare.UnorderedMatch([]interface{}{1, 2, 3})
		/* table_test_sindex_api.get_all(1,2,3).map(lambda x:x["id"]).coerce_to("ARRAY") */

		suite.T().Log("About to run line #209: table_test_sindex_api.GetAll(1, 2, 3).Map(func(x r.Term) interface{} { return x.AtIndex('id')}).CoerceTo('ARRAY')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1, 2, 3).Map(func(x r.Term) interface{} { return x.AtIndex("id") }).CoerceTo("ARRAY"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #209")
	}

	{
		// sindex/api.yaml line #213
		/* 'SELECTION<STREAM>' */
		var expected_ string = "SELECTION<STREAM>"
		/* table_test_sindex_api.get_all(1, index='id').type_of() */

		suite.T().Log("About to run line #213: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'id', }).TypeOf()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "id"}).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #213")
	}

	{
		// sindex/api.yaml line #217
		/* 'SELECTION<STREAM>' */
		var expected_ string = "SELECTION<STREAM>"
		/* table_test_sindex_api.get_all(1).type_of() */

		suite.T().Log("About to run line #217: table_test_sindex_api.GetAll(1).TypeOf()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #217")
	}

	{
		// sindex/api.yaml line #221
		/* {'replaced':0,'skipped':0,'deleted':0,'unchanged':1,'errors':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"replaced": 0, "skipped": 0, "deleted": 0, "unchanged": 1, "errors": 0, "inserted": 0}
		/* table_test_sindex_api.get_all(1, index='id').update(lambda x:null) */

		suite.T().Log("About to run line #221: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'id', }).Update(func(x r.Term) interface{} { return nil})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "id"}).Update(func(x r.Term) interface{} { return nil }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #221")
	}

	{
		// sindex/api.yaml line #225
		/* {'replaced':0,'skipped':0,'deleted':0,'unchanged':1,'errors':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"replaced": 0, "skipped": 0, "deleted": 0, "unchanged": 1, "errors": 0, "inserted": 0}
		/* table_test_sindex_api.get_all(1).update(lambda x:null) */

		suite.T().Log("About to run line #225: table_test_sindex_api.GetAll(1).Update(func(x r.Term) interface{} { return nil})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).Update(func(x r.Term) interface{} { return nil }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #225")
	}

	{
		// sindex/api.yaml line #229
		/* {'replaced':0,'skipped':0,'deleted':0,'unchanged':3,'errors':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"replaced": 0, "skipped": 0, "deleted": 0, "unchanged": 3, "errors": 0, "inserted": 0}
		/* table_test_sindex_api.get_all(1,2,3, index='id').update(lambda x:null) */

		suite.T().Log("About to run line #229: table_test_sindex_api.GetAll(1, 2, 3).OptArgs(r.GetAllOpts{Index: 'id', }).Update(func(x r.Term) interface{} { return nil})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1, 2, 3).OptArgs(r.GetAllOpts{Index: "id"}).Update(func(x r.Term) interface{} { return nil }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #229")
	}

	{
		// sindex/api.yaml line #233
		/* {'replaced':0,'skipped':0,'deleted':0,'unchanged':3,'errors':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"replaced": 0, "skipped": 0, "deleted": 0, "unchanged": 3, "errors": 0, "inserted": 0}
		/* table_test_sindex_api.get_all(1,2,3).update(lambda x:null) */

		suite.T().Log("About to run line #233: table_test_sindex_api.GetAll(1, 2, 3).Update(func(x r.Term) interface{} { return nil})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1, 2, 3).Update(func(x r.Term) interface{} { return nil }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #233")
	}

	{
		// sindex/api.yaml line #238
		/* err_regex("ReqlOpFailedError", "Index `fake` was not found on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]", []) */
		var expected_ Err = err_regex("ReqlOpFailedError", "Index `fake` was not found on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]")
		/* table_test_sindex_api.get_all(0, index='fake') */

		suite.T().Log("About to run line #238: table_test_sindex_api.GetAll(0).OptArgs(r.GetAllOpts{Index: 'fake', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(0).OptArgs(r.GetAllOpts{Index: "fake"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #238")
	}

	{
		// sindex/api.yaml line #242
		/* err("ReqlQueryLogicError", "Cannot use a geospatial index with `get_all`. Use `get_intersecting` instead.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use a geospatial index with `get_all`. Use `get_intersecting` instead.")
		/* table_test_sindex_api.get_all(r.point(0, 0)) */

		suite.T().Log("About to run line #242: table_test_sindex_api.GetAll(r.Point(0, 0))")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(r.Point(0, 0)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #242")
	}

	{
		// sindex/api.yaml line #246
		/* err("ReqlQueryLogicError", "Expected type STRING but found BOOL.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type STRING but found BOOL.")
		/* table_test_sindex_api.get_all(0, index=False) */

		suite.T().Log("About to run line #246: table_test_sindex_api.GetAll(0).OptArgs(r.GetAllOpts{Index: false, })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(0).OptArgs(r.GetAllOpts{Index: false}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #246")
	}

	{
		// sindex/api.yaml line #251
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_sindex_api.get_all(True, index='id') */

		suite.T().Log("About to run line #251: table_test_sindex_api.GetAll(true).OptArgs(r.GetAllOpts{Index: 'id', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(true).OptArgs(r.GetAllOpts{Index: "id"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #251")
	}

	{
		// sindex/api.yaml line #256
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.get_all([], index='id') */

		suite.T().Log("About to run line #256: table_test_sindex_api.GetAll([]interface{}{}).OptArgs(r.GetAllOpts{Index: 'id', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll([]interface{}{}).OptArgs(r.GetAllOpts{Index: "id"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #256")
	}

	{
		// sindex/api.yaml line #260
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_sindex_api.get_all(True, index='idi') */

		suite.T().Log("About to run line #260: table_test_sindex_api.GetAll(true).OptArgs(r.GetAllOpts{Index: 'idi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(true).OptArgs(r.GetAllOpts{Index: "idi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #260")
	}

	{
		// sindex/api.yaml line #265
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.get_all([], index='idi') */

		suite.T().Log("About to run line #265: table_test_sindex_api.GetAll([]interface{}{}).OptArgs(r.GetAllOpts{Index: 'idi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll([]interface{}{}).OptArgs(r.GetAllOpts{Index: "idi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #265")
	}

	{
		// sindex/api.yaml line #270
		/* 1 */
		var expected_ int = 1
		/* table_test_sindex_api.get_all(1, index='id')[0]['id'] */

		suite.T().Log("About to run line #270: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'id', }).AtIndex(0).AtIndex('id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "id"}).AtIndex(0).AtIndex("id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #270")
	}

	{
		// sindex/api.yaml line #274
		/* 1 */
		var expected_ int = 1
		/* table_test_sindex_api.get_all(1, index='idi')[0]['id'] */

		suite.T().Log("About to run line #274: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'idi', }).AtIndex(0).AtIndex('id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "idi"}).AtIndex(0).AtIndex("id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #274")
	}

	{
		// sindex/api.yaml line #278
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.get_all(1, index='ai') */

		suite.T().Log("About to run line #278: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'ai', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "ai"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #278")
	}

	{
		// sindex/api.yaml line #282
		/* [3] */
		var expected_ []interface{} = []interface{}{3}
		/* table_test_sindex_api.get_all(1, index='bi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #282: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'bi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "bi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #282")
	}

	{
		// sindex/api.yaml line #286
		/* err('ReqlQueryLogicError', 'Indexed order_by can only be performed on a TABLE or TABLE_SLICE.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Indexed order_by can only be performed on a TABLE or TABLE_SLICE. Make sure order_by comes before any transformations (such as map) or filters.")
		/* table_test_sindex_api.get_all(1, index='bi').order_by(index='id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #286: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'bi', }).OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "bi"}).OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #286")
	}

	{
		// sindex/api.yaml line #290
		/* err('ReqlQueryLogicError', 'Expected type TABLE_SLICE but found SELECTION:', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type TABLE_SLICE but found SELECTION:")
		/* table_test_sindex_api.get_all(1, index='bi').between(1, 1, index='id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #290: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'bi', }).Between(1, 1).OptArgs(r.BetweenOpts{Index: 'id', }).Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "bi"}).Between(1, 1).OptArgs(r.BetweenOpts{Index: "id"}).Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #290")
	}

	{
		// sindex/api.yaml line #294
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* table_test_sindex_api.get_all(1, index='ci').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #294: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'ci', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "ci"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #294")
	}

	{
		// sindex/api.yaml line #298
		/* 'SELECTION<STREAM>' */
		var expected_ string = "SELECTION<STREAM>"
		/* table_test_sindex_api.get_all(1, index='ci').type_of() */

		suite.T().Log("About to run line #298: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'ci', }).TypeOf()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "ci"}).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #298")
	}

	{
		// sindex/api.yaml line #302
		/* {'replaced':0,'skipped':0,'deleted':0,'unchanged':2,'errors':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"replaced": 0, "skipped": 0, "deleted": 0, "unchanged": 2, "errors": 0, "inserted": 0}
		/* table_test_sindex_api.get_all(1, index='ci').update(lambda x:null) */

		suite.T().Log("About to run line #302: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'ci', }).Update(func(x r.Term) interface{} { return nil})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "ci"}).Update(func(x r.Term) interface{} { return nil }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #302")
	}

	{
		// sindex/api.yaml line #306
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.get_all(1, index='brokeni') */

		suite.T().Log("About to run line #306: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'brokeni', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "brokeni"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #306")
	}

	{
		// sindex/api.yaml line #311
		/* [rows[0]] */
		var expected_ []interface{} = []interface{}{rows[0]}
		/* table_test_sindex_api.get_all(1, index='mi') */

		suite.T().Log("About to run line #311: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'mi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "mi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #311")
	}

	{
		// sindex/api.yaml line #316
		/* [rows[0]] */
		var expected_ []interface{} = []interface{}{rows[0]}
		/* table_test_sindex_api.get_all(2, index='mi') */

		suite.T().Log("About to run line #316: table_test_sindex_api.GetAll(2).OptArgs(r.GetAllOpts{Index: 'mi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(2).OptArgs(r.GetAllOpts{Index: "mi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #316")
	}

	{
		// sindex/api.yaml line #321
		/* [rows[1]] */
		var expected_ []interface{} = []interface{}{rows[1]}
		/* table_test_sindex_api.get_all(5, index='mi') */

		suite.T().Log("About to run line #321: table_test_sindex_api.GetAll(5).OptArgs(r.GetAllOpts{Index: 'mi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(5).OptArgs(r.GetAllOpts{Index: "mi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #321")
	}

	{
		// sindex/api.yaml line #326
		/* [rows[2]] */
		var expected_ []interface{} = []interface{}{rows[2]}
		/* table_test_sindex_api.get_all(7, index='mi') */

		suite.T().Log("About to run line #326: table_test_sindex_api.GetAll(7).OptArgs(r.GetAllOpts{Index: 'mi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(7).OptArgs(r.GetAllOpts{Index: "mi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #326")
	}

	{
		// sindex/api.yaml line #331
		/* err_regex("ReqlOpFailedError", "Index `fake` was not found on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]", []) */
		var expected_ Err = err_regex("ReqlOpFailedError", "Index `fake` was not found on table `[a-zA-Z0-9_]+.[a-zA-Z0-9_]+`[.]")
		/* table_test_sindex_api.eq_join('id', table_test_sindex_api, index='fake') */

		suite.T().Log("About to run line #331: table_test_sindex_api.EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'fake', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "fake"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #331")
	}

	{
		// sindex/api.yaml line #335
		/* err("ReqlQueryLogicError", "Expected type STRING but found BOOL.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type STRING but found BOOL.")
		/* table_test_sindex_api.eq_join('id', table_test_sindex_api, index=False) */

		suite.T().Log("About to run line #335: table_test_sindex_api.EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: false, })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: false}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #335")
	}

	{
		// sindex/api.yaml line #340
		/* [{'left':rows[1],'right':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"left": rows[1], "right": rows[0]}}
		/* table_test_sindex_api.filter({'id':1}).eq_join('id', table_test_sindex_api, index='mi') */

		suite.T().Log("About to run line #340: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 1, }).EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'mi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 1}).EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "mi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #340")
	}

	{
		// sindex/api.yaml line #345
		/* [{'left':rows[0],'right':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"left": rows[0], "right": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join('id', table_test_sindex_api) */

		suite.T().Log("About to run line #345: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin('id', table_test_sindex_api)")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin("id", table_test_sindex_api), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #345")
	}

	{
		// sindex/api.yaml line #350
		/* [{'left':rows[0],'right':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"left": rows[0], "right": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join(lambda x:x['id'], table_test_sindex_api) */

		suite.T().Log("About to run line #350: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin(func(x r.Term) interface{} { return x.AtIndex('id')}, table_test_sindex_api)")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin(func(x r.Term) interface{} { return x.AtIndex("id") }, table_test_sindex_api), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #350")
	}

	{
		// sindex/api.yaml line #355
		/* [{'left':rows[0],'right':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"left": rows[0], "right": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join('id', table_test_sindex_api, index='id') */

		suite.T().Log("About to run line #355: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'id', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "id"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #355")
	}

	{
		// sindex/api.yaml line #360
		/* [{'left':rows[0],'right':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"left": rows[0], "right": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join(lambda x:x['id'], table_test_sindex_api, index='id') */

		suite.T().Log("About to run line #360: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin(func(x r.Term) interface{} { return x.AtIndex('id')}, table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'id', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin(func(x r.Term) interface{} { return x.AtIndex("id") }, table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "id"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #360")
	}

	{
		// sindex/api.yaml line #365
		/* [{'left':rows[0],'right':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"left": rows[0], "right": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join('id', table_test_sindex_api, index='idi') */

		suite.T().Log("About to run line #365: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'idi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "idi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #365")
	}

	{
		// sindex/api.yaml line #370
		/* [{'left':rows[0],'right':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"left": rows[0], "right": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join(lambda x:x['id'], table_test_sindex_api, index='idi') */

		suite.T().Log("About to run line #370: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin(func(x r.Term) interface{} { return x.AtIndex('id')}, table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'idi', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin(func(x r.Term) interface{} { return x.AtIndex("id") }, table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "idi"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #370")
	}

	{
		// sindex/api.yaml line #375
		/* [{'right':rows[0],'left':rows[0]},
		{'right':rows[1],'left':rows[0]},
		{'right':rows[2],'left':rows[0]},
		{'right':rows[3],'left':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"right": rows[0], "left": rows[0]}, map[interface{}]interface{}{"right": rows[1], "left": rows[0]}, map[interface{}]interface{}{"right": rows[2], "left": rows[0]}, map[interface{}]interface{}{"right": rows[3], "left": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join('id', table_test_sindex_api, index='ai').order_by('right') */

		suite.T().Log("About to run line #375: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'ai', }).OrderBy('right')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "ai"}).OrderBy("right"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #375")
	}

	{
		// sindex/api.yaml line #382
		/* ([{'right':rows[0],'left':rows[0]},
		{'right':rows[1],'left':rows[0]},
		{'right':rows[2],'left':rows[0]}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"right": rows[0], "left": rows[0]}, map[interface{}]interface{}{"right": rows[1], "left": rows[0]}, map[interface{}]interface{}{"right": rows[2], "left": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join('id', table_test_sindex_api, index='bi').order_by('right') */

		suite.T().Log("About to run line #382: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'bi', }).OrderBy('right')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "bi"}).OrderBy("right"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #382")
	}

	{
		// sindex/api.yaml line #388
		/* [{'right':rows[0],'left':rows[0]}, {'right':rows[1],'left':rows[0]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"right": rows[0], "left": rows[0]}, map[interface{}]interface{}{"right": rows[1], "left": rows[0]}}
		/* table_test_sindex_api.filter({'id':0}).eq_join('id', table_test_sindex_api, index='ci').order_by('right') */

		suite.T().Log("About to run line #388: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'ci', }).OrderBy('right')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "ci"}).OrderBy("right"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #388")
	}

	{
		// sindex/api.yaml line #392
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.filter({'id':0}).eq_join('id', table_test_sindex_api, index='brokeni') */

		suite.T().Log("About to run line #392: table_test_sindex_api.Filter(map[interface{}]interface{}{'id': 0, }).EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'brokeni', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Filter(map[interface{}]interface{}{"id": 0}).EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "brokeni"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #392")
	}

	{
		// sindex/api.yaml line #397
		/* [{'left':rows[0],'right':rows[0]},
		{'left':rows[1],'right':rows[0]},
		{'left':rows[0],'right':rows[1]},
		{'left':rows[1],'right':rows[1]},
		{'left':rows[0],'right':rows[2]},
		{'left':rows[1],'right':rows[2]},
		{'left':rows[2],'right':rows[3]},
		{'left':rows[3],'right':rows[3]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"left": rows[0], "right": rows[0]}, map[interface{}]interface{}{"left": rows[1], "right": rows[0]}, map[interface{}]interface{}{"left": rows[0], "right": rows[1]}, map[interface{}]interface{}{"left": rows[1], "right": rows[1]}, map[interface{}]interface{}{"left": rows[0], "right": rows[2]}, map[interface{}]interface{}{"left": rows[1], "right": rows[2]}, map[interface{}]interface{}{"left": rows[2], "right": rows[3]}, map[interface{}]interface{}{"left": rows[3], "right": rows[3]}}
		/* table_test_sindex_api.eq_join('c', table_test_sindex_api, index='bi').order_by('right', 'left') */

		suite.T().Log("About to run line #397: table_test_sindex_api.EqJoin('c', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'bi', }).OrderBy('right', 'left')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.EqJoin("c", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "bi"}).OrderBy("right", "left"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #397")
	}

	{
		// sindex/api.yaml line #408
		/* err("ReqlQueryLogicError", "Index name conflict: `id` is the name of the primary key.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Index name conflict: `id` is the name of the primary key.")
		/* table_test_sindex_api.index_create('id') */

		suite.T().Log("About to run line #408: table_test_sindex_api.IndexCreate('id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreate("id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #408")
	}

	{
		// sindex/api.yaml line #411
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('c') */

		suite.T().Log("About to run line #411: table_test_sindex_api.IndexCreate('c')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreate("c"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #411")
	}

	{
		// sindex/api.yaml line #413
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('broken') */

		suite.T().Log("About to run line #413: table_test_sindex_api.IndexCreate('broken')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreate("broken"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #413")
	}

	{
		// sindex/api.yaml line #416
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_sindex_api.index_wait('broken') */

		suite.T().Log("About to run line #416: table_test_sindex_api.IndexWait('broken')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexWait("broken"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #416")
	}

	{
		// sindex/api.yaml line #419
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* table_test_sindex_api.get_all(1, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #419: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #419")
	}

	{
		// sindex/api.yaml line #423
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.get_all(1, index='broken').order_by('broken').map(lambda x:x['id']) */

		suite.T().Log("About to run line #423: table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: 'broken', }).OrderBy('broken').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(1).OptArgs(r.GetAllOpts{Index: "broken"}).OrderBy("broken").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #423")
	}

	{
		// sindex/api.yaml line #428
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('nil', lambda x:null) */

		suite.T().Log("About to run line #428: table_test_sindex_api.IndexCreateFunc('nil', func(x r.Term) interface{} { return nil})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("nil", func(x r.Term) interface{} { return nil }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #428")
	}

	{
		// sindex/api.yaml line #431
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_sindex_api.index_wait().pluck('index', 'ready') */

		suite.T().Log("About to run line #431: table_test_sindex_api.IndexWait().Pluck('index', 'ready')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexWait().Pluck("index", "ready"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #431")
	}

	{
		// sindex/api.yaml line #434
		/* err("ReqlNonExistenceError", "Keys cannot be NULL.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Keys cannot be NULL.")
		/* table_test_sindex_api.get_all(null, index='nil') */

		suite.T().Log("About to run line #434: table_test_sindex_api.GetAll(nil).OptArgs(r.GetAllOpts{Index: 'nil', })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.GetAll(nil).OptArgs(r.GetAllOpts{Index: "nil"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #434")
	}

	{
		// sindex/api.yaml line #439
		/* {'deleted':0,'inserted':1,'skipped':0,'errors':0,'replaced':0,'unchanged':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "inserted": 1, "skipped": 0, "errors": 0, "replaced": 0, "unchanged": 0}
		/* table_test_sindex_api.insert({'id':4, 'a':4, 'b':4, 'c':4, 'm':[14,15,16]}) */

		suite.T().Log("About to run line #439: table_test_sindex_api.Insert(map[interface{}]interface{}{'id': 4, 'a': 4, 'b': 4, 'c': 4, 'm': []interface{}{14, 15, 16}, })")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Insert(map[interface{}]interface{}{"id": 4, "a": 4, "b": 4, "c": 4, "m": []interface{}{14, 15, 16}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #439")
	}

	{
		// sindex/api.yaml line #446
		/* [{'right':rows[0],'left':rows[0]},
		{'right':rows[1],'left':rows[0]},
		{'right':rows[2],'left':rows[1]},
		{'right':rows[3],'left':rows[1]},
		{'right':rows[4],'left':rows[4]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"right": rows[0], "left": rows[0]}, map[interface{}]interface{}{"right": rows[1], "left": rows[0]}, map[interface{}]interface{}{"right": rows[2], "left": rows[1]}, map[interface{}]interface{}{"right": rows[3], "left": rows[1]}, map[interface{}]interface{}{"right": rows[4], "left": rows[4]}}
		/* table_test_sindex_api.eq_join('id', table_test_sindex_api, index='c').order_by('left', 'right').coerce_to("ARRAY") */

		suite.T().Log("About to run line #446: table_test_sindex_api.EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'c', }).OrderBy('left', 'right').CoerceTo('ARRAY')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "c"}).OrderBy("left", "right").CoerceTo("ARRAY"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #446")
	}

	{
		// sindex/api.yaml line #455
		/* [{'right':rows[0],'left':rows[0]},
		{'right':rows[1],'left':rows[0]},
		{'right':rows[2],'left':rows[1]},
		{'right':rows[3],'left':rows[1]},
		{'right':rows[4],'left':rows[4]}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"right": rows[0], "left": rows[0]}, map[interface{}]interface{}{"right": rows[1], "left": rows[0]}, map[interface{}]interface{}{"right": rows[2], "left": rows[1]}, map[interface{}]interface{}{"right": rows[3], "left": rows[1]}, map[interface{}]interface{}{"right": rows[4], "left": rows[4]}}
		/* table_test_sindex_api.eq_join('id', table_test_sindex_api, index='ci').order_by('left', 'right') */

		suite.T().Log("About to run line #455: table_test_sindex_api.EqJoin('id', table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: 'ci', }).OrderBy('left', 'right')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.EqJoin("id", table_test_sindex_api).OptArgs(r.EqJoinOpts{Index: "ci"}).OrderBy("left", "right"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #455")
	}

	{
		// sindex/api.yaml line #465
		/* err('ReqlQueryLogicError', 'Cannot use `nu' + 'll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.') */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use `nu"+"ll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.")
		/* table_test_sindex_api.between(null, 2, index='id').count() */

		suite.T().Log("About to run line #465: table_test_sindex_api.Between(nil, 2).OptArgs(r.BetweenOpts{Index: 'id', }).Count()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(nil, 2).OptArgs(r.BetweenOpts{Index: "id"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #465")
	}

	{
		// sindex/api.yaml line #466
		/* err('ReqlQueryLogicError', 'Cannot use `nu' + 'll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.') */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use `nu"+"ll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.")
		/* table_test_sindex_api.between(2, null, index='id').count() */

		suite.T().Log("About to run line #466: table_test_sindex_api.Between(2, nil).OptArgs(r.BetweenOpts{Index: 'id', }).Count()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(2, nil).OptArgs(r.BetweenOpts{Index: "id"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #466")
	}

	{
		// sindex/api.yaml line #467
		/* err('ReqlQueryLogicError', 'Cannot use `nu' + 'll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.') */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use `nu"+"ll` in BETWEEN, use `r.minval` or `r.maxval` to denote unboundedness.")
		/* table_test_sindex_api.between(null, null, index='id').count() */

		suite.T().Log("About to run line #467: table_test_sindex_api.Between(nil, nil).OptArgs(r.BetweenOpts{Index: 'id', }).Count()")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(nil, nil).OptArgs(r.BetweenOpts{Index: "id"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #467")
	}

	{
		// sindex/api.yaml line #479
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #479: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #479")
	}

	{
		// sindex/api.yaml line #483
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval).order_by(index='id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #483: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #483")
	}

	{
		// sindex/api.yaml line #487
		/* err('ReqlQueryLogicError', 'Cannot perform multiple BETWEENs on the same table.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot perform multiple BETWEENs on the same table.")
		/* table_test_sindex_api.between(r.minval, r.maxval).between(r.minval, r.maxval).map(lambda x:x['id']) */

		suite.T().Log("About to run line #487: table_test_sindex_api.Between(r.MinVal, r.MaxVal).Between(r.MinVal, r.MaxVal).Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).Between(r.MinVal, r.MaxVal).Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #487")
	}

	{
		// sindex/api.yaml line #491
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.order_by(index='id').between(r.minval, 3).map(lambda x:x['id']) */

		suite.T().Log("About to run line #491: table_test_sindex_api.OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).Between(r.MinVal, 3).Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).Between(r.MinVal, 3).Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #491")
	}

	{
		// sindex/api.yaml line #495
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #495: table_test_sindex_api.Between(0, r.MaxVal).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #495")
	}

	{
		// sindex/api.yaml line #499
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(r.minval, 4).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #499: table_test_sindex_api.Between(r.MinVal, 4).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 4).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #499")
	}

	{
		// sindex/api.yaml line #503
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 4).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #503: table_test_sindex_api.Between(0, 4).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 4).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #503")
	}

	{
		// sindex/api.yaml line #507
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(-1, 5).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #507: table_test_sindex_api.Between(-1, 5).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 5).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #507")
	}

	{
		// sindex/api.yaml line #511
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, 5).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #511: table_test_sindex_api.Between(5, 5).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, 5).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #511")
	}

	{
		// sindex/api.yaml line #515
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, r.maxval).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #515: table_test_sindex_api.Between(5, r.MaxVal).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, r.MaxVal).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #515")
	}

	{
		// sindex/api.yaml line #519
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(-1, -1).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #519: table_test_sindex_api.Between(-1, -1).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, -1).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #519")
	}

	{
		// sindex/api.yaml line #523
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, -1).order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #523: table_test_sindex_api.Between(r.MinVal, -1).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, -1).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #523")
	}

	{
		// sindex/api.yaml line #528
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #528: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #528")
	}

	{
		// sindex/api.yaml line #532
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #532: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #532")
	}

	{
		// sindex/api.yaml line #536
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, 4, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #536: table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #536")
	}

	{
		// sindex/api.yaml line #540
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, 4, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #540: table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #540")
	}

	{
		// sindex/api.yaml line #544
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(-1, 5, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #544: table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #544")
	}

	{
		// sindex/api.yaml line #548
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, 5, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #548: table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #548")
	}

	{
		// sindex/api.yaml line #552
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, r.maxval, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #552: table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #552")
	}

	{
		// sindex/api.yaml line #556
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(-1, -1, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #556: table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #556")
	}

	{
		// sindex/api.yaml line #560
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, -1, right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #560: table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #560")
	}

	{
		// sindex/api.yaml line #565
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #565: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #565")
	}

	{
		// sindex/api.yaml line #569
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #569: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #569")
	}

	{
		// sindex/api.yaml line #573
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(r.minval, 4, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #573: table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #573")
	}

	{
		// sindex/api.yaml line #577
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 4, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #577: table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #577")
	}

	{
		// sindex/api.yaml line #581
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(-1, 5, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #581: table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #581")
	}

	{
		// sindex/api.yaml line #585
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, 5, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #585: table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #585")
	}

	{
		// sindex/api.yaml line #589
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, r.maxval, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #589: table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #589")
	}

	{
		// sindex/api.yaml line #593
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(-1, -1, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #593: table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #593")
	}

	{
		// sindex/api.yaml line #597
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, -1, index='id').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #597: table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #597")
	}

	{
		// sindex/api.yaml line #602
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #602: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #602")
	}

	{
		// sindex/api.yaml line #606
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #606: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #606")
	}

	{
		// sindex/api.yaml line #610
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, 4, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #610: table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #610")
	}

	{
		// sindex/api.yaml line #614
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, 4, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #614: table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #614")
	}

	{
		// sindex/api.yaml line #618
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(-1, 5, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #618: table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #618")
	}

	{
		// sindex/api.yaml line #622
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, 5, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #622: table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #622")
	}

	{
		// sindex/api.yaml line #626
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, r.maxval, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #626: table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #626")
	}

	{
		// sindex/api.yaml line #630
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(-1, -1, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #630: table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #630")
	}

	{
		// sindex/api.yaml line #634
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, -1, index='id', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #634: table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #634")
	}

	{
		// sindex/api.yaml line #639
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #639: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #639")
	}

	{
		// sindex/api.yaml line #643
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #643: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #643")
	}

	{
		// sindex/api.yaml line #647
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(r.minval, 4, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #647: table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #647")
	}

	{
		// sindex/api.yaml line #651
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 4, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #651: table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #651")
	}

	{
		// sindex/api.yaml line #655
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(-1, 5, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #655: table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #655")
	}

	{
		// sindex/api.yaml line #659
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, 5, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #659: table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #659")
	}

	{
		// sindex/api.yaml line #663
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, r.maxval, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #663: table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #663")
	}

	{
		// sindex/api.yaml line #667
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(-1, -1, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #667: table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #667")
	}

	{
		// sindex/api.yaml line #671
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, -1, index='idi').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #671: table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: 'idi', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: "idi"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #671")
	}

	{
		// sindex/api.yaml line #676
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #676: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #676")
	}

	{
		// sindex/api.yaml line #680
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #680: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #680")
	}

	{
		// sindex/api.yaml line #684
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, 4, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #684: table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #684")
	}

	{
		// sindex/api.yaml line #688
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, 4, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #688: table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #688")
	}

	{
		// sindex/api.yaml line #692
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(-1, 5, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #692: table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 5).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #692")
	}

	{
		// sindex/api.yaml line #696
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, 5, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #696: table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, 5).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #696")
	}

	{
		// sindex/api.yaml line #700
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, r.maxval, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #700: table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #700")
	}

	{
		// sindex/api.yaml line #704
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(-1, -1, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #704: table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #704")
	}

	{
		// sindex/api.yaml line #708
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, -1, index='idi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #708: table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: 'idi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: "idi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #708")
	}

	{
		// sindex/api.yaml line #713
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #713: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #713")
	}

	{
		// sindex/api.yaml line #717
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #717: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #717")
	}

	{
		// sindex/api.yaml line #721
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(r.minval, 4, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #721: table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #721")
	}

	{
		// sindex/api.yaml line #725
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 4, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #725: table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #725")
	}

	{
		// sindex/api.yaml line #729
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, 5, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #729: table_test_sindex_api.Between(0, 5).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 5).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #729")
	}

	{
		// sindex/api.yaml line #734
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #734: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #734")
	}

	{
		// sindex/api.yaml line #738
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #738: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #738")
	}

	{
		// sindex/api.yaml line #742
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, 4, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #742: table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 4).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #742")
	}

	{
		// sindex/api.yaml line #746
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, 4, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #746: table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 4).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #746")
	}

	{
		// sindex/api.yaml line #750
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, 5, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #750: table_test_sindex_api.Between(0, 5).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 5).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #750")
	}

	{
		// sindex/api.yaml line #755
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 3, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #755: table_test_sindex_api.Between(0, 3).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 3).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #755")
	}

	{
		// sindex/api.yaml line #759
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 1, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #759: table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #759")
	}

	{
		// sindex/api.yaml line #763
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(0, 0, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #763: table_test_sindex_api.Between(0, 0).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 0).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #763")
	}

	{
		// sindex/api.yaml line #767
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(-1, 2, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #767: table_test_sindex_api.Between(-1, 2).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 2).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #767")
	}

	{
		// sindex/api.yaml line #772
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 3, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #772: table_test_sindex_api.Between(0, 3).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 3).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #772")
	}

	{
		// sindex/api.yaml line #776
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 1, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #776: table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #776")
	}

	{
		// sindex/api.yaml line #780
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 0, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #780: table_test_sindex_api.Between(0, 0).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 0).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #780")
	}

	{
		// sindex/api.yaml line #784
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(-1, 2, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #784: table_test_sindex_api.Between(-1, 2).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 2).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #784")
	}

	{
		// sindex/api.yaml line #789
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(1, 1, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #789: table_test_sindex_api.Between(1, 1).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, 1).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #789")
	}

	{
		// sindex/api.yaml line #793
		/* [4] */
		var expected_ []interface{} = []interface{}{4}
		/* table_test_sindex_api.between(1, r.maxval, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #793: table_test_sindex_api.Between(1, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, r.MaxVal).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #793")
	}

	{
		// sindex/api.yaml line #797
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, r.maxval, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #797: table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #797")
	}

	{
		// sindex/api.yaml line #801
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, 0, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #801: table_test_sindex_api.Between(r.MinVal, 0).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 0).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #801")
	}

	{
		// sindex/api.yaml line #805
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(-1, -1, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #805: table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #805")
	}

	{
		// sindex/api.yaml line #809
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, -1, index='ai').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #809: table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: 'ai', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: "ai"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #809")
	}

	{
		// sindex/api.yaml line #814
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(1, 1, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #814: table_test_sindex_api.Between(1, 1).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, 1).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #814")
	}

	{
		// sindex/api.yaml line #818
		/* [4] */
		var expected_ []interface{} = []interface{}{4}
		/* table_test_sindex_api.between(1, r.maxval, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #818: table_test_sindex_api.Between(1, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, r.MaxVal).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #818")
	}

	{
		// sindex/api.yaml line #822
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(5, r.maxval, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #822: table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #822")
	}

	{
		// sindex/api.yaml line #826
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(r.minval, 0, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #826: table_test_sindex_api.Between(r.MinVal, 0).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 0).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #826")
	}

	{
		// sindex/api.yaml line #830
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(-1, -1, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #830: table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, -1).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #830")
	}

	{
		// sindex/api.yaml line #834
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, -1, index='ai', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #834: table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: 'ai', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, -1).OptArgs(r.BetweenOpts{Index: "ai", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #834")
	}

	{
		// sindex/api.yaml line #839
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(0, 1, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #839: table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #839")
	}

	{
		// sindex/api.yaml line #843
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(-1, 1, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #843: table_test_sindex_api.Between(-1, 1).OptArgs(r.BetweenOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 1).OptArgs(r.BetweenOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #843")
	}

	{
		// sindex/api.yaml line #847
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(r.minval, 1, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #847: table_test_sindex_api.Between(r.MinVal, 1).OptArgs(r.BetweenOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 1).OptArgs(r.BetweenOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #847")
	}

	{
		// sindex/api.yaml line #851
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #851: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #851")
	}

	{
		// sindex/api.yaml line #855
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(-1, r.maxval, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #855: table_test_sindex_api.Between(-1, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, r.MaxVal).OptArgs(r.BetweenOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #855")
	}

	{
		// sindex/api.yaml line #859
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #859: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #859")
	}

	{
		// sindex/api.yaml line #863
		/* [2, 3, 4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* table_test_sindex_api.between(1, r.maxval, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #863: table_test_sindex_api.Between(1, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, r.MaxVal).OptArgs(r.BetweenOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #863")
	}

	{
		// sindex/api.yaml line #867
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(1, 1, index='c').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #867: table_test_sindex_api.Between(1, 1).OptArgs(r.BetweenOpts{Index: 'c', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, 1).OptArgs(r.BetweenOpts{Index: "c"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #867")
	}

	{
		// sindex/api.yaml line #872
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(0, 1, index='c', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #872: table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #872")
	}

	{
		// sindex/api.yaml line #876
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(-1, 1, index='c', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #876: table_test_sindex_api.Between(-1, 1).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, 1).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #876")
	}

	{
		// sindex/api.yaml line #880
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(r.minval, 1, index='c', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #880: table_test_sindex_api.Between(r.MinVal, 1).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, 1).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #880")
	}

	{
		// sindex/api.yaml line #884
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(0, r.maxval, index='c', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #884: table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, r.MaxVal).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #884")
	}

	{
		// sindex/api.yaml line #888
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(-1, r.maxval, index='c', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #888: table_test_sindex_api.Between(-1, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(-1, r.MaxVal).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #888")
	}

	{
		// sindex/api.yaml line #892
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='c', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #892: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #892")
	}

	{
		// sindex/api.yaml line #896
		/* [2, 3, 4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* table_test_sindex_api.between(1, r.maxval, index='c', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #896: table_test_sindex_api.Between(1, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, r.MaxVal).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #896")
	}

	{
		// sindex/api.yaml line #900
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* table_test_sindex_api.between(1, 1, index='c', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #900: table_test_sindex_api.Between(1, 1).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, 1).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #900")
	}

	{
		// sindex/api.yaml line #905
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('bc', lambda row:[row['b'], row['c']]) */

		suite.T().Log("About to run line #905: table_test_sindex_api.IndexCreateFunc('bc', func(row r.Term) interface{} { return []interface{}{row.AtIndex('b'), row.AtIndex('c')}})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("bc", func(row r.Term) interface{} { return []interface{}{row.AtIndex("b"), row.AtIndex("c")} }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #905")
	}

	{
		// sindex/api.yaml line #909
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* table_test_sindex_api.index_create('cb', lambda row:[row['c'], row['b']]) */

		suite.T().Log("About to run line #909: table_test_sindex_api.IndexCreateFunc('cb', func(row r.Term) interface{} { return []interface{}{row.AtIndex('c'), row.AtIndex('b')}})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexCreateFunc("cb", func(row r.Term) interface{} { return []interface{}{row.AtIndex("c"), row.AtIndex("b")} }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #909")
	}

	{
		// sindex/api.yaml line #912
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* table_test_sindex_api.index_wait().pluck('index', 'ready') */

		suite.T().Log("About to run line #912: table_test_sindex_api.IndexWait().Pluck('index', 'ready')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.IndexWait().Pluck("index", "ready"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #912")
	}

	{
		// sindex/api.yaml line #915
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, [0, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #915: table_test_sindex_api.Between(r.MinVal, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #915")
	}

	{
		// sindex/api.yaml line #919
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between(r.minval, [0, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #919: table_test_sindex_api.Between(r.MinVal, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #919")
	}

	{
		// sindex/api.yaml line #923
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(r.minval, [0, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #923: table_test_sindex_api.Between(r.MinVal, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #923")
	}

	{
		// sindex/api.yaml line #927
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(r.minval, [0, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #927: table_test_sindex_api.Between(r.MinVal, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #927")
	}

	{
		// sindex/api.yaml line #931
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between(r.minval, [1, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #931: table_test_sindex_api.Between(r.MinVal, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #931")
	}

	{
		// sindex/api.yaml line #935
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(r.minval, [1, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #935: table_test_sindex_api.Between(r.MinVal, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #935")
	}

	{
		// sindex/api.yaml line #939
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between(r.minval, [1, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #939: table_test_sindex_api.Between(r.MinVal, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #939")
	}

	{
		// sindex/api.yaml line #943
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between(r.minval, [1, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #943: table_test_sindex_api.Between(r.MinVal, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #943")
	}

	{
		// sindex/api.yaml line #947
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #947: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #947")
	}

	{
		// sindex/api.yaml line #951
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #951: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #951")
	}

	{
		// sindex/api.yaml line #956
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(r.minval, [0, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #956: table_test_sindex_api.Between(r.MinVal, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #956")
	}

	{
		// sindex/api.yaml line #960
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(r.minval, [0, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #960: table_test_sindex_api.Between(r.MinVal, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #960")
	}

	{
		// sindex/api.yaml line #964
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between(r.minval, [0, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #964: table_test_sindex_api.Between(r.MinVal, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #964")
	}

	{
		// sindex/api.yaml line #968
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between(r.minval, [0, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #968: table_test_sindex_api.Between(r.MinVal, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #968")
	}

	{
		// sindex/api.yaml line #972
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between(r.minval, [1, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #972: table_test_sindex_api.Between(r.MinVal, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #972")
	}

	{
		// sindex/api.yaml line #976
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between(r.minval, [1, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #976: table_test_sindex_api.Between(r.MinVal, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #976")
	}

	{
		// sindex/api.yaml line #980
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(r.minval, [1, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #980: table_test_sindex_api.Between(r.MinVal, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #980")
	}

	{
		// sindex/api.yaml line #984
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between(r.minval, [1, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #984: table_test_sindex_api.Between(r.MinVal, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #984")
	}

	{
		// sindex/api.yaml line #988
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #988: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #988")
	}

	{
		// sindex/api.yaml line #992
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between(r.minval, r.maxval, index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #992: table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(r.MinVal, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #992")
	}

	{
		// sindex/api.yaml line #997
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 0], [0, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #997: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #997")
	}

	{
		// sindex/api.yaml line #1001
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 0], [0, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1001: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1001")
	}

	{
		// sindex/api.yaml line #1005
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between([0, 0], [0, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1005: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1005")
	}

	{
		// sindex/api.yaml line #1009
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between([0, 0], [0, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1009: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1009")
	}

	{
		// sindex/api.yaml line #1013
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between([0, 0], [1, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1013: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1013")
	}

	{
		// sindex/api.yaml line #1017
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between([0, 0], [1, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1017: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1017")
	}

	{
		// sindex/api.yaml line #1021
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between([0, 0], [1, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1021: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1021")
	}

	{
		// sindex/api.yaml line #1025
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between([0, 0], [1, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1025: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1025")
	}

	{
		// sindex/api.yaml line #1029
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between([0, 0], r.maxval, index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1029: table_test_sindex_api.Between([]interface{}{0, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1029")
	}

	{
		// sindex/api.yaml line #1033
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between([0, 0], r.maxval, index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1033: table_test_sindex_api.Between([]interface{}{0, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1033")
	}

	{
		// sindex/api.yaml line #1038
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between([0, 0], [0, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1038: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1038")
	}

	{
		// sindex/api.yaml line #1042
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between([0, 0], [0, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1042: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1042")
	}

	{
		// sindex/api.yaml line #1046
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between([0, 0], [0, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1046: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1046")
	}

	{
		// sindex/api.yaml line #1050
		/* [0, 1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* table_test_sindex_api.between([0, 0], [0, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1050: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1050")
	}

	{
		// sindex/api.yaml line #1054
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between([0, 0], [1, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1054: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1054")
	}

	{
		// sindex/api.yaml line #1058
		/* [0, 1, 2] */
		var expected_ []interface{} = []interface{}{0, 1, 2}
		/* table_test_sindex_api.between([0, 0], [1, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1058: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1058")
	}

	{
		// sindex/api.yaml line #1062
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between([0, 0], [1, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1062: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1062")
	}

	{
		// sindex/api.yaml line #1066
		/* [0, 1, 2, 3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* table_test_sindex_api.between([0, 0], [1, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1066: table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1066")
	}

	{
		// sindex/api.yaml line #1070
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between([0, 0], r.maxval, index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1070: table_test_sindex_api.Between([]interface{}{0, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1070")
	}

	{
		// sindex/api.yaml line #1074
		/* [0, 1, 2, 3, 4] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3, 4}
		/* table_test_sindex_api.between([0, 0], r.maxval, index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1074: table_test_sindex_api.Between([]interface{}{0, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1074")
	}

	{
		// sindex/api.yaml line #1079
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 1], [0, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1079: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1079")
	}

	{
		// sindex/api.yaml line #1083
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 1], [0, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1083: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1083")
	}

	{
		// sindex/api.yaml line #1087
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 1], [0, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1087: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1087")
	}

	{
		// sindex/api.yaml line #1091
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 1], [0, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1091: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1091")
	}

	{
		// sindex/api.yaml line #1095
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* table_test_sindex_api.between([0, 1], [1, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1095: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1095")
	}

	{
		// sindex/api.yaml line #1099
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 1], [1, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1099: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1099")
	}

	{
		// sindex/api.yaml line #1103
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* table_test_sindex_api.between([0, 1], [1, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1103: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1103")
	}

	{
		// sindex/api.yaml line #1107
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* table_test_sindex_api.between([0, 1], [1, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1107: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1107")
	}

	{
		// sindex/api.yaml line #1111
		/* [2, 3, 4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* table_test_sindex_api.between([0, 1], r.maxval, index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1111: table_test_sindex_api.Between([]interface{}{0, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1111")
	}

	{
		// sindex/api.yaml line #1115
		/* [2, 3, 4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* table_test_sindex_api.between([0, 1], r.maxval, index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1115: table_test_sindex_api.Between([]interface{}{0, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1115")
	}

	{
		// sindex/api.yaml line #1120
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 1], [0, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1120: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1120")
	}

	{
		// sindex/api.yaml line #1124
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 1], [0, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1124: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1124")
	}

	{
		// sindex/api.yaml line #1128
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* table_test_sindex_api.between([0, 1], [0, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1128: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1128")
	}

	{
		// sindex/api.yaml line #1132
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([0, 1], [0, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1132: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1132")
	}

	{
		// sindex/api.yaml line #1136
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* table_test_sindex_api.between([0, 1], [1, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1136: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1136")
	}

	{
		// sindex/api.yaml line #1140
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* table_test_sindex_api.between([0, 1], [1, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1140: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1140")
	}

	{
		// sindex/api.yaml line #1144
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* table_test_sindex_api.between([0, 1], [1, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1144: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1144")
	}

	{
		// sindex/api.yaml line #1148
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* table_test_sindex_api.between([0, 1], [1, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1148: table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1148")
	}

	{
		// sindex/api.yaml line #1152
		/* [2, 3, 4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* table_test_sindex_api.between([0, 1], r.maxval, index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1152: table_test_sindex_api.Between([]interface{}{0, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1152")
	}

	{
		// sindex/api.yaml line #1156
		/* [2, 3, 4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* table_test_sindex_api.between([0, 1], r.maxval, index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1156: table_test_sindex_api.Between([]interface{}{0, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{0, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1156")
	}

	{
		// sindex/api.yaml line #1161
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [0, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1161: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1161")
	}

	{
		// sindex/api.yaml line #1165
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [0, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1165: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1165")
	}

	{
		// sindex/api.yaml line #1169
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [0, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1169: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1169")
	}

	{
		// sindex/api.yaml line #1173
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [0, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1173: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1173")
	}

	{
		// sindex/api.yaml line #1177
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [1, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1177: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1177")
	}

	{
		// sindex/api.yaml line #1181
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [1, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1181: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1181")
	}

	{
		// sindex/api.yaml line #1185
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [1, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1185: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1185")
	}

	{
		// sindex/api.yaml line #1189
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* table_test_sindex_api.between([1, 0], [1, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1189: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1189")
	}

	{
		// sindex/api.yaml line #1193
		/* [3, 4] */
		var expected_ []interface{} = []interface{}{3, 4}
		/* table_test_sindex_api.between([1, 0], r.maxval, index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1193: table_test_sindex_api.Between([]interface{}{1, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1193")
	}

	{
		// sindex/api.yaml line #1197
		/* [2, 3, 4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* table_test_sindex_api.between([1, 0], r.maxval, index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1197: table_test_sindex_api.Between([]interface{}{1, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1197")
	}

	{
		// sindex/api.yaml line #1202
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [0, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1202: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1202")
	}

	{
		// sindex/api.yaml line #1206
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [0, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1206: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1206")
	}

	{
		// sindex/api.yaml line #1210
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [0, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1210: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1210")
	}

	{
		// sindex/api.yaml line #1214
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [0, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1214: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1214")
	}

	{
		// sindex/api.yaml line #1218
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 0], [1, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1218: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1218")
	}

	{
		// sindex/api.yaml line #1222
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* table_test_sindex_api.between([1, 0], [1, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1222: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1222")
	}

	{
		// sindex/api.yaml line #1226
		/* [3] */
		var expected_ []interface{} = []interface{}{3}
		/* table_test_sindex_api.between([1, 0], [1, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1226: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1226")
	}

	{
		// sindex/api.yaml line #1230
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* table_test_sindex_api.between([1, 0], [1, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1230: table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1230")
	}

	{
		// sindex/api.yaml line #1234
		/* [3, 4] */
		var expected_ []interface{} = []interface{}{3, 4}
		/* table_test_sindex_api.between([1, 0], r.maxval, index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1234: table_test_sindex_api.Between([]interface{}{1, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1234")
	}

	{
		// sindex/api.yaml line #1238
		/* [2, 3, 4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* table_test_sindex_api.between([1, 0], r.maxval, index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1238: table_test_sindex_api.Between([]interface{}{1, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 0}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1238")
	}

	{
		// sindex/api.yaml line #1243
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [0, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1243: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1243")
	}

	{
		// sindex/api.yaml line #1247
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [0, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1247: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1247")
	}

	{
		// sindex/api.yaml line #1251
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [0, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1251: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1251")
	}

	{
		// sindex/api.yaml line #1255
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [0, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1255: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1255")
	}

	{
		// sindex/api.yaml line #1259
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [1, 0], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1259: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1259")
	}

	{
		// sindex/api.yaml line #1263
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [1, 0], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1263: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1263")
	}

	{
		// sindex/api.yaml line #1267
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [1, 1], index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1267: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1267")
	}

	{
		// sindex/api.yaml line #1271
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [1, 1], index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1271: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1271")
	}

	{
		// sindex/api.yaml line #1275
		/* [3, 4] */
		var expected_ []interface{} = []interface{}{3, 4}
		/* table_test_sindex_api.between([1, 1], r.maxval, index='bc').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1275: table_test_sindex_api.Between([]interface{}{1, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1275")
	}

	{
		// sindex/api.yaml line #1279
		/* [3, 4] */
		var expected_ []interface{} = []interface{}{3, 4}
		/* table_test_sindex_api.between([1, 1], r.maxval, index='cb').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1279: table_test_sindex_api.Between([]interface{}{1, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1279")
	}

	{
		// sindex/api.yaml line #1284
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [0, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1284: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1284")
	}

	{
		// sindex/api.yaml line #1288
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [0, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1288: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1288")
	}

	{
		// sindex/api.yaml line #1292
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [0, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1292: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1292")
	}

	{
		// sindex/api.yaml line #1296
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [0, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1296: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{0, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1296")
	}

	{
		// sindex/api.yaml line #1300
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [1, 0], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1300: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1300")
	}

	{
		// sindex/api.yaml line #1304
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* table_test_sindex_api.between([1, 1], [1, 0], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1304: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 0}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1304")
	}

	{
		// sindex/api.yaml line #1308
		/* [3] */
		var expected_ []interface{} = []interface{}{3}
		/* table_test_sindex_api.between([1, 1], [1, 1], index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1308: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1308")
	}

	{
		// sindex/api.yaml line #1312
		/* [3] */
		var expected_ []interface{} = []interface{}{3}
		/* table_test_sindex_api.between([1, 1], [1, 1], index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1312: table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, []interface{}{1, 1}).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1312")
	}

	{
		// sindex/api.yaml line #1316
		/* [3, 4] */
		var expected_ []interface{} = []interface{}{3, 4}
		/* table_test_sindex_api.between([1, 1], r.maxval, index='bc', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1316: table_test_sindex_api.Between([]interface{}{1, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'bc', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "bc", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1316")
	}

	{
		// sindex/api.yaml line #1320
		/* [3, 4] */
		var expected_ []interface{} = []interface{}{3, 4}
		/* table_test_sindex_api.between([1, 1], r.maxval, index='cb', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1320: table_test_sindex_api.Between([]interface{}{1, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'cb', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between([]interface{}{1, 1}, r.MaxVal).OptArgs(r.BetweenOpts{Index: "cb", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1320")
	}

	{
		// sindex/api.yaml line #1325
		/* [0,0,0] */
		var expected_ []interface{} = []interface{}{0, 0, 0}
		/* table_test_sindex_api.between(1, 3, index='mi', right_bound='closed').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1325: table_test_sindex_api.Between(1, 3).OptArgs(r.BetweenOpts{Index: 'mi', RightBound: 'closed', }).Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, 3).OptArgs(r.BetweenOpts{Index: "mi", RightBound: "closed"}).Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1325")
	}

	{
		// sindex/api.yaml line #1330
		/* [0,0,0,1,1,1,2,3,3,3,4,4,4] */
		var expected_ []interface{} = []interface{}{0, 0, 0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 4}
		/* table_test_sindex_api.between(1, 16, index='mi', right_bound='closed').order_by('id').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1330: table_test_sindex_api.Between(1, 16).OptArgs(r.BetweenOpts{Index: 'mi', RightBound: 'closed', }).OrderBy('id').Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(1, 16).OptArgs(r.BetweenOpts{Index: "mi", RightBound: "closed"}).OrderBy("id").Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1330")
	}

	{
		// sindex/api.yaml line #1335
		/* [0,0,0,1,1,1,2,3,3,3,4,4,4] */
		var expected_ []interface{} = []interface{}{0, 0, 0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 4}
		/* table_test_sindex_api.order_by(index='mi').map(lambda x:x['id']) */

		suite.T().Log("About to run line #1335: table_test_sindex_api.OrderBy().OptArgs(r.OrderByOpts{Index: 'mi', }).Map(func(x r.Term) interface{} { return x.AtIndex('id')})")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.OrderBy().OptArgs(r.OrderByOpts{Index: "mi"}).Map(func(x r.Term) interface{} { return x.AtIndex("id") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1335")
	}

	{
		// sindex/api.yaml line #1341
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* table_test_sindex_api.between(0, 1, index='c', right_bound='closed', left_bound='open').order_by('id')['id'] */

		suite.T().Log("About to run line #1341: table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: 'c', RightBound: 'closed', LeftBound: 'open', }).OrderBy('id').AtIndex('id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: "c", RightBound: "closed", LeftBound: "open"}).OrderBy("id").AtIndex("id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1341")
	}

	{
		// sindex/api.yaml line #1345
		/* [1] */
		var expected_ []interface{} = []interface{}{1}
		/* table_test_sindex_api.between(0, 1, index='id', right_bound='closed', left_bound='open').order_by('id')['id'] */

		suite.T().Log("About to run line #1345: table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: 'id', RightBound: 'closed', LeftBound: 'open', }).OrderBy('id').AtIndex('id')")

		runAndAssert(suite.Suite, expected_, table_test_sindex_api.Between(0, 1).OptArgs(r.BetweenOpts{Index: "id", RightBound: "closed", LeftBound: "open"}).OrderBy("id").AtIndex("id"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #1345")
	}
}
