/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */
#ifdef HAVE_CONFIG_H
# include "../gf_config.h"
#endif

#define PURPLE_PLUGINS

#include "gf_internal.h"
#include "gf_action.h"
#include "gf_blist.h"
#include "gf_display.h"
#include "gf_event.h"
#include "gf_gtk_utils.h"
#include "gf_item_text.h"
#include "gf_preferences.h"
#include "gf_theme.h"
#include "gf_theme_editor.h"
#include "gf_stock.h"

#include <debug.h>
#include <pidgin.h>
#include <plugin.h>
#include <gtkplugin.h>
#include <version.h>


#include <stdlib.h>
#include <time.h>

static gboolean
gf_load(PurplePlugin *plugin) {

	gf_actions_init();
	gf_blist_init(plugin);
	gf_events_init(plugin);
	gf_theme_editor_init(plugin);
	gf_item_text_init();
	gf_display_init(plugin);
	gf_gtk_utils_init();
	gf_stock_init();
	gf_themes_probe();
	gf_themes_load_saved();

	return TRUE;
}

static gboolean
gf_unload(PurplePlugin *plugin) {
	time_t t;

	/* seed the random number generator here so that two notifications that
	 * occur within a second of each other use different notifications.
	 */
	t = time(NULL);
	srand(t);

	gf_stock_uninit();
	gf_themes_unprobe();
	gf_themes_save_loaded();
	gf_themes_unload();
	gf_gtk_utils_uninit();
	gf_display_uninit();
	gf_item_text_uninit();
	gf_theme_editor_uninit();
	gf_events_uninit();
	gf_blist_uninit();
	gf_actions_uninit();

	return TRUE;
}

static PidginPluginUiInfo ui_info = {
	gf_preferences_get_frame,			/* get prefs frame	*/
	0,									/* page number - reserved	*/
	NULL,								/* reserved 1	*/
	NULL,								/* reserved 2	*/
	NULL,								/* reserved 3	*/
	NULL								/* reserved 4	*/
};

static PurplePluginInfo gf_info = {
	PURPLE_PLUGIN_MAGIC,
	PURPLE_MAJOR_VERSION,
	PURPLE_MINOR_VERSION,
	PURPLE_PLUGIN_STANDARD,
	PIDGIN_PLUGIN_TYPE,
	0,
	NULL,
	PURPLE_PRIORITY_DEFAULT,

	"gtk-amc_grim-Guifications",
	NULL,
#ifdef _WIN32
	GF_VERSION,
#else
	VERSION,
#endif
	NULL,
	NULL,

	"Gary Kramlich <grim@guifications.org>",
	GF_WEBSITE,

	gf_load,
	gf_unload,
	NULL,

	&ui_info,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

static void
init_plugin(PurplePlugin *plugin) {

#ifdef ENABLE_NLS
	bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif /* ENABLE_NLS */

	gf_info.name		= _("Guifications");
	gf_info.summary		= _("The end all, be all, toaster popup plugin");
	gf_info.description	= _("Guifications:\n"
							"The end all, be all, toaster popup plugin");
	gf_preferences_add();
}

PURPLE_INIT_PLUGIN(Guifications2, init_plugin, gf_info)
