set -e

# prepare test environment
prepare() {
    cp -a default.build.properties Gemfile Rakefile rakelib spec test "$AUTOPKGTEST_TMP"
    cp -a /usr/share/jruby/bin "$AUTOPKGTEST_TMP/bin"
    ln -s /usr/share/jruby/lib "$AUTOPKGTEST_TMP/lib"
    export LANG=C.UTF-8
    export LC_ALL=C.UTF-8
    export CI=1
    export JOBS=2

    # create a writeable GEM_HOME in /tmp
    # with extra gems needed to run the testsuite
    rm -rf /tmp/jruby_gems
    mkdir /tmp/jruby_gems
    cp -a /usr/share/jruby/lib/ruby/gems/shared/* /tmp/jruby_gems
	for gem in diff-lcs minitest power_assert rake rspec rspec-core rspec-expectations rspec-mocks rspec-support test-unit; do
		# some gems are copied from libruby*, others from local rubygems
		if test -e /usr/lib/ruby/gems/*/gems/${gem}-*; then
			gembase="/usr/lib/ruby/gems/*"
		else
			gembase=/usr/share/rubygems-integration/all
		fi
		echo "installing ${gem} gem into jruby ..."
		cp -a ${gembase}/gems/${gem}-* /tmp/jruby_gems/gems
		cp -a ${gembase}/specifications/${gem}-* /tmp/jruby_gems/specifications
	done
    export GEM_HOME=/tmp/jruby_gems

    # copy/fixup the rake binary
    cp /usr/bin/rake ./bin
    sed -i '1s|^#!.*|#!/usr/bin/jruby|' ./bin/rake
}

# run 1 test at a time and output test names
# so we can more easily catch hanging tests
debug_tests() {
    export JOBS=1
    # modifies ADDITIONAL_TEST_OPTIONS
    sed -i 's/--tty=no/-v/' "$AUTOPKGTEST_TMP/rakelib/test.rake"
    # modifies TESTOPT
    sed -i 's/--no-use-color/--no-use-color -v/' "$AUTOPKGTEST_TMP/rakelib/test.rake"
}
