
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAnimationDriver.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAnimationDriver>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAnimationDriver

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAnimationDriver::staticMetaObject);
}


// void QAnimationDriver::advance()


static void _init_f_advance_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_advance_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver *)cls)->advance ();
}


// qint64 QAnimationDriver::elapsed()


static void _init_f_elapsed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_elapsed_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAnimationDriver *)cls)->elapsed ());
}


// void QAnimationDriver::install()


static void _init_f_install_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_install_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver *)cls)->install ();
}


// bool QAnimationDriver::isRunning()


static void _init_f_isRunning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRunning_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAnimationDriver *)cls)->isRunning ());
}


// void QAnimationDriver::setStartTime(qint64 startTime)


static void _init_f_setStartTime_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startTime");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartTime_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver *)cls)->setStartTime (arg1);
}


// qint64 QAnimationDriver::startTime()


static void _init_f_startTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_startTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAnimationDriver *)cls)->startTime ());
}


// void QAnimationDriver::uninstall()


static void _init_f_uninstall_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_uninstall_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver *)cls)->uninstall ();
}


// static QString QAnimationDriver::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAnimationDriver::tr (arg1, arg2, arg3));
}


// static QString QAnimationDriver::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAnimationDriver::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAnimationDriver () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("advance", "@brief Method void QAnimationDriver::advance()\n", false, &_init_f_advance_0, &_call_f_advance_0);
  methods += new qt_gsi::GenericMethod ("elapsed", "@brief Method qint64 QAnimationDriver::elapsed()\n", true, &_init_f_elapsed_c0, &_call_f_elapsed_c0);
  methods += new qt_gsi::GenericMethod ("install", "@brief Method void QAnimationDriver::install()\n", false, &_init_f_install_0, &_call_f_install_0);
  methods += new qt_gsi::GenericMethod ("isRunning?", "@brief Method bool QAnimationDriver::isRunning()\n", true, &_init_f_isRunning_c0, &_call_f_isRunning_c0);
  methods += new qt_gsi::GenericMethod ("setStartTime|startTime=", "@brief Method void QAnimationDriver::setStartTime(qint64 startTime)\n", false, &_init_f_setStartTime_986, &_call_f_setStartTime_986);
  methods += new qt_gsi::GenericMethod (":startTime", "@brief Method qint64 QAnimationDriver::startTime()\n", true, &_init_f_startTime_c0, &_call_f_startTime_c0);
  methods += new qt_gsi::GenericMethod ("uninstall", "@brief Method void QAnimationDriver::uninstall()\n", false, &_init_f_uninstall_0, &_call_f_uninstall_0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAnimationDriver::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAnimationDriver::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("started()", "started", "@brief Signal declaration for QAnimationDriver::started()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("stopped()", "stopped", "@brief Signal declaration for QAnimationDriver::stopped()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAnimationDriver::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAnimationDriver::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAnimationDriver> decl_QAnimationDriver (qtdecl_QObject (), "QtCore", "QAnimationDriver_Native",
  methods_QAnimationDriver (),
  "@hide\n@alias QAnimationDriver");

GSI_QTCORE_PUBLIC gsi::Class<QAnimationDriver> &qtdecl_QAnimationDriver () { return decl_QAnimationDriver; }

}


class QAnimationDriver_Adaptor : public QAnimationDriver, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAnimationDriver_Adaptor();

  //  [adaptor ctor] QAnimationDriver::QAnimationDriver(QObject *parent)
  QAnimationDriver_Adaptor() : QAnimationDriver()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAnimationDriver::QAnimationDriver(QObject *parent)
  QAnimationDriver_Adaptor(QObject *parent) : QAnimationDriver(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QAnimationDriver::advanceAnimation(qint64 timeStep)
  void fp_QAnimationDriver_advanceAnimation_986 (qint64 timeStep) {
    QAnimationDriver::advanceAnimation(timeStep);
  }

  //  [expose] bool QAnimationDriver::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAnimationDriver_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAnimationDriver::isSignalConnected(signal);
  }

  //  [expose] int QAnimationDriver::receivers(const char *signal)
  int fp_QAnimationDriver_receivers_c1731 (const char *signal) const {
    return QAnimationDriver::receivers(signal);
  }

  //  [expose] QObject *QAnimationDriver::sender()
  QObject * fp_QAnimationDriver_sender_c0 () const {
    return QAnimationDriver::sender();
  }

  //  [expose] int QAnimationDriver::senderSignalIndex()
  int fp_QAnimationDriver_senderSignalIndex_c0 () const {
    return QAnimationDriver::senderSignalIndex();
  }

  //  [adaptor impl] void QAnimationDriver::advance()
  void cbs_advance_0_0()
  {
    QAnimationDriver::advance();
  }

  virtual void advance()
  {
    if (cb_advance_0_0.can_issue()) {
      cb_advance_0_0.issue<QAnimationDriver_Adaptor>(&QAnimationDriver_Adaptor::cbs_advance_0_0);
    } else {
      QAnimationDriver::advance();
    }
  }

  //  [emitter impl] void QAnimationDriver::destroyed(QObject *)
  void emitter_QAnimationDriver_destroyed_1302(QObject *arg1)
  {
    emit QAnimationDriver::destroyed(arg1);
  }

  //  [adaptor impl] qint64 QAnimationDriver::elapsed()
  qint64 cbs_elapsed_c0_0() const
  {
    return QAnimationDriver::elapsed();
  }

  virtual qint64 elapsed() const
  {
    if (cb_elapsed_c0_0.can_issue()) {
      return cb_elapsed_c0_0.issue<QAnimationDriver_Adaptor, qint64>(&QAnimationDriver_Adaptor::cbs_elapsed_c0_0);
    } else {
      return QAnimationDriver::elapsed();
    }
  }

  //  [adaptor impl] bool QAnimationDriver::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAnimationDriver::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAnimationDriver_Adaptor, bool, QEvent *>(&QAnimationDriver_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAnimationDriver::event(arg1);
    }
  }

  //  [adaptor impl] bool QAnimationDriver::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAnimationDriver::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAnimationDriver_Adaptor, bool, QObject *, QEvent *>(&QAnimationDriver_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAnimationDriver::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QAnimationDriver::objectNameChanged(const QString &objectName)
  void emitter_QAnimationDriver_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAnimationDriver::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QAnimationDriver::started()
  void emitter_QAnimationDriver_started_0()
  {
    emit QAnimationDriver::started();
  }

  //  [emitter impl] void QAnimationDriver::stopped()
  void emitter_QAnimationDriver_stopped_0()
  {
    emit QAnimationDriver::stopped();
  }

  //  [adaptor impl] void QAnimationDriver::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAnimationDriver::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAnimationDriver_Adaptor, QChildEvent *>(&QAnimationDriver_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAnimationDriver::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAnimationDriver::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAnimationDriver::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAnimationDriver_Adaptor, QEvent *>(&QAnimationDriver_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAnimationDriver::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAnimationDriver::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAnimationDriver::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAnimationDriver_Adaptor, const QMetaMethod &>(&QAnimationDriver_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAnimationDriver::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAnimationDriver::start()
  void cbs_start_0_0()
  {
    QAnimationDriver::start();
  }

  virtual void start()
  {
    if (cb_start_0_0.can_issue()) {
      cb_start_0_0.issue<QAnimationDriver_Adaptor>(&QAnimationDriver_Adaptor::cbs_start_0_0);
    } else {
      QAnimationDriver::start();
    }
  }

  //  [adaptor impl] void QAnimationDriver::stop()
  void cbs_stop_0_0()
  {
    QAnimationDriver::stop();
  }

  virtual void stop()
  {
    if (cb_stop_0_0.can_issue()) {
      cb_stop_0_0.issue<QAnimationDriver_Adaptor>(&QAnimationDriver_Adaptor::cbs_stop_0_0);
    } else {
      QAnimationDriver::stop();
    }
  }

  //  [adaptor impl] void QAnimationDriver::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAnimationDriver::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAnimationDriver_Adaptor, QTimerEvent *>(&QAnimationDriver_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAnimationDriver::timerEvent(arg1);
    }
  }

  gsi::Callback cb_advance_0_0;
  gsi::Callback cb_elapsed_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_start_0_0;
  gsi::Callback cb_stop_0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAnimationDriver_Adaptor::~QAnimationDriver_Adaptor() { }

//  Constructor QAnimationDriver::QAnimationDriver(QObject *parent) (adaptor class)

static void _init_ctor_QAnimationDriver_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAnimationDriver_Adaptor> ();
}

static void _call_ctor_QAnimationDriver_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QAnimationDriver_Adaptor *> (new QAnimationDriver_Adaptor (arg1));
}


// void QAnimationDriver::advance()

static void _init_cbs_advance_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_advance_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver_Adaptor *)cls)->cbs_advance_0_0 ();
}

static void _set_callback_cbs_advance_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_advance_0_0 = cb;
}


// exposed void QAnimationDriver::advanceAnimation(qint64 timeStep)

static void _init_fp_advanceAnimation_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timeStep", true, "-1");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_advanceAnimation_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args ? gsi::arg_reader<qint64 >() (args, heap) : gsi::arg_maker<qint64 >() (-1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver_Adaptor *)cls)->fp_QAnimationDriver_advanceAnimation_986 (arg1);
}


// void QAnimationDriver::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAnimationDriver::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAnimationDriver::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QAnimationDriver_Adaptor *)cls)->emitter_QAnimationDriver_destroyed_1302 (arg1);
}


// void QAnimationDriver::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// qint64 QAnimationDriver::elapsed()

static void _init_cbs_elapsed_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_elapsed_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAnimationDriver_Adaptor *)cls)->cbs_elapsed_c0_0 ());
}

static void _set_callback_cbs_elapsed_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_elapsed_c0_0 = cb;
}


// bool QAnimationDriver::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAnimationDriver_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAnimationDriver::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAnimationDriver_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QAnimationDriver::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAnimationDriver_Adaptor *)cls)->fp_QAnimationDriver_isSignalConnected_c2394 (arg1));
}


// emitter void QAnimationDriver::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAnimationDriver_Adaptor *)cls)->emitter_QAnimationDriver_objectNameChanged_4567 (arg1);
}


// exposed int QAnimationDriver::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAnimationDriver_Adaptor *)cls)->fp_QAnimationDriver_receivers_c1731 (arg1));
}


// exposed QObject *QAnimationDriver::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAnimationDriver_Adaptor *)cls)->fp_QAnimationDriver_sender_c0 ());
}


// exposed int QAnimationDriver::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAnimationDriver_Adaptor *)cls)->fp_QAnimationDriver_senderSignalIndex_c0 ());
}


// void QAnimationDriver::start()

static void _init_cbs_start_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_start_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver_Adaptor *)cls)->cbs_start_0_0 ();
}

static void _set_callback_cbs_start_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_start_0_0 = cb;
}


// emitter void QAnimationDriver::started()

static void _init_emitter_started_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_started_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAnimationDriver_Adaptor *)cls)->emitter_QAnimationDriver_started_0 ();
}


// void QAnimationDriver::stop()

static void _init_cbs_stop_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_stop_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver_Adaptor *)cls)->cbs_stop_0_0 ();
}

static void _set_callback_cbs_stop_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_stop_0_0 = cb;
}


// emitter void QAnimationDriver::stopped()

static void _init_emitter_stopped_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_stopped_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAnimationDriver_Adaptor *)cls)->emitter_QAnimationDriver_stopped_0 ();
}


// void QAnimationDriver::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAnimationDriver_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAnimationDriver_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QAnimationDriver> &qtdecl_QAnimationDriver ();

static gsi::Methods methods_QAnimationDriver_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAnimationDriver::QAnimationDriver(QObject *parent)\nThis method creates an object of class QAnimationDriver.", &_init_ctor_QAnimationDriver_Adaptor_1302, &_call_ctor_QAnimationDriver_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QAnimationDriver::advance()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_0_0, &_call_cbs_advance_0_0);
  methods += new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_0_0, &_call_cbs_advance_0_0, &_set_callback_cbs_advance_0_0);
  methods += new qt_gsi::GenericMethod ("*advanceAnimation", "@brief Method void QAnimationDriver::advanceAnimation(qint64 timeStep)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_advanceAnimation_986, &_call_fp_advanceAnimation_986);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAnimationDriver::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAnimationDriver::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAnimationDriver::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAnimationDriver::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("elapsed", "@brief Virtual method qint64 QAnimationDriver::elapsed()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_elapsed_c0_0, &_call_cbs_elapsed_c0_0);
  methods += new qt_gsi::GenericMethod ("elapsed", "@hide", true, &_init_cbs_elapsed_c0_0, &_call_cbs_elapsed_c0_0, &_set_callback_cbs_elapsed_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAnimationDriver::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAnimationDriver::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAnimationDriver::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAnimationDriver::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAnimationDriver::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAnimationDriver::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAnimationDriver::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*start", "@brief Virtual method void QAnimationDriver::start()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("*start", "@hide", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0, &_set_callback_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("emit_started", "@brief Emitter for signal void QAnimationDriver::started()\nCall this method to emit this signal.", false, &_init_emitter_started_0, &_call_emitter_started_0);
  methods += new qt_gsi::GenericMethod ("*stop", "@brief Virtual method void QAnimationDriver::stop()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("*stop", "@hide", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0, &_set_callback_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("emit_stopped", "@brief Emitter for signal void QAnimationDriver::stopped()\nCall this method to emit this signal.", false, &_init_emitter_stopped_0, &_call_emitter_stopped_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAnimationDriver::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QAnimationDriver_Adaptor> decl_QAnimationDriver_Adaptor (qtdecl_QAnimationDriver (), "QtCore", "QAnimationDriver",
  methods_QAnimationDriver_Adaptor (),
  "@qt\n@brief Binding of QAnimationDriver");

}

