
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUndoStack.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QUndoStack>
#include <QAction>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QUndoCommand>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUndoStack

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QUndoStack::staticMetaObject);
}


// void QUndoStack::beginMacro(const QString &text)


static void _init_f_beginMacro_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_beginMacro_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->beginMacro (arg1);
}


// bool QUndoStack::canRedo()


static void _init_f_canRedo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canRedo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUndoStack *)cls)->canRedo ());
}


// bool QUndoStack::canUndo()


static void _init_f_canUndo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canUndo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUndoStack *)cls)->canUndo ());
}


// int QUndoStack::cleanIndex()


static void _init_f_cleanIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cleanIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QUndoStack *)cls)->cleanIndex ());
}


// void QUndoStack::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->clear ();
}


// const QUndoCommand *QUndoStack::command(int index)


static void _init_f_command_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const QUndoCommand * > ();
}

static void _call_f_command_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<const QUndoCommand * > ((const QUndoCommand *)((QUndoStack *)cls)->command (arg1));
}


// int QUndoStack::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QUndoStack *)cls)->count ());
}


// QAction *QUndoStack::createRedoAction(QObject *parent, const QString &prefix)


static void _init_f_createRedoAction_c3219 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("prefix", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QAction * > ();
}

static void _call_f_createRedoAction_c3219 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QAction * > ((QAction *)((QUndoStack *)cls)->createRedoAction (arg1, arg2));
}


// QAction *QUndoStack::createUndoAction(QObject *parent, const QString &prefix)


static void _init_f_createUndoAction_c3219 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("prefix", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QAction * > ();
}

static void _call_f_createUndoAction_c3219 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QAction * > ((QAction *)((QUndoStack *)cls)->createUndoAction (arg1, arg2));
}


// void QUndoStack::endMacro()


static void _init_f_endMacro_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endMacro_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->endMacro ();
}


// int QUndoStack::index()


static void _init_f_index_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_index_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QUndoStack *)cls)->index ());
}


// bool QUndoStack::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUndoStack *)cls)->isActive ());
}


// bool QUndoStack::isClean()


static void _init_f_isClean_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isClean_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUndoStack *)cls)->isClean ());
}


// void QUndoStack::push(QUndoCommand *cmd)


static void _init_f_push_1812 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cmd");
  decl->add_arg<QUndoCommand * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_push_1812 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUndoCommand *arg1 = gsi::arg_reader<QUndoCommand * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->push (arg1);
}


// void QUndoStack::redo()


static void _init_f_redo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_redo_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->redo ();
}


// QString QUndoStack::redoText()


static void _init_f_redoText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_redoText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUndoStack *)cls)->redoText ());
}


// void QUndoStack::setActive(bool active)


static void _init_f_setActive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("active", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActive_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->setActive (arg1);
}


// void QUndoStack::setClean()


static void _init_f_setClean_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setClean_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->setClean ();
}


// void QUndoStack::setIndex(int idx)


static void _init_f_setIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->setIndex (arg1);
}


// void QUndoStack::setUndoLimit(int limit)


static void _init_f_setUndoLimit_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("limit");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUndoLimit_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->setUndoLimit (arg1);
}


// QString QUndoStack::text(int idx)


static void _init_f_text_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_text_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QUndoStack *)cls)->text (arg1));
}


// void QUndoStack::undo()


static void _init_f_undo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_undo_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack *)cls)->undo ();
}


// int QUndoStack::undoLimit()


static void _init_f_undoLimit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_undoLimit_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QUndoStack *)cls)->undoLimit ());
}


// QString QUndoStack::undoText()


static void _init_f_undoText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_undoText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUndoStack *)cls)->undoText ());
}


// static QString QUndoStack::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QUndoStack::tr (arg1, arg2, arg3));
}


// static QString QUndoStack::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QUndoStack::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QUndoStack () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("beginMacro", "@brief Method void QUndoStack::beginMacro(const QString &text)\n", false, &_init_f_beginMacro_2025, &_call_f_beginMacro_2025);
  methods += new qt_gsi::GenericMethod ("canRedo", "@brief Method bool QUndoStack::canRedo()\n", true, &_init_f_canRedo_c0, &_call_f_canRedo_c0);
  methods += new qt_gsi::GenericMethod ("canUndo", "@brief Method bool QUndoStack::canUndo()\n", true, &_init_f_canUndo_c0, &_call_f_canUndo_c0);
  methods += new qt_gsi::GenericMethod ("cleanIndex", "@brief Method int QUndoStack::cleanIndex()\n", true, &_init_f_cleanIndex_c0, &_call_f_cleanIndex_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QUndoStack::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("command", "@brief Method const QUndoCommand *QUndoStack::command(int index)\n", true, &_init_f_command_c767, &_call_f_command_c767);
  methods += new qt_gsi::GenericMethod ("count", "@brief Method int QUndoStack::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod ("createRedoAction", "@brief Method QAction *QUndoStack::createRedoAction(QObject *parent, const QString &prefix)\n", true, &_init_f_createRedoAction_c3219, &_call_f_createRedoAction_c3219);
  methods += new qt_gsi::GenericMethod ("createUndoAction", "@brief Method QAction *QUndoStack::createUndoAction(QObject *parent, const QString &prefix)\n", true, &_init_f_createUndoAction_c3219, &_call_f_createUndoAction_c3219);
  methods += new qt_gsi::GenericMethod ("endMacro", "@brief Method void QUndoStack::endMacro()\n", false, &_init_f_endMacro_0, &_call_f_endMacro_0);
  methods += new qt_gsi::GenericMethod (":index", "@brief Method int QUndoStack::index()\n", true, &_init_f_index_c0, &_call_f_index_c0);
  methods += new qt_gsi::GenericMethod ("isActive?|:active", "@brief Method bool QUndoStack::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
  methods += new qt_gsi::GenericMethod ("isClean?", "@brief Method bool QUndoStack::isClean()\n", true, &_init_f_isClean_c0, &_call_f_isClean_c0);
  methods += new qt_gsi::GenericMethod ("push", "@brief Method void QUndoStack::push(QUndoCommand *cmd)\n", false, &_init_f_push_1812, &_call_f_push_1812);
  methods += new qt_gsi::GenericMethod ("redo", "@brief Method void QUndoStack::redo()\n", false, &_init_f_redo_0, &_call_f_redo_0);
  methods += new qt_gsi::GenericMethod ("redoText", "@brief Method QString QUndoStack::redoText()\n", true, &_init_f_redoText_c0, &_call_f_redoText_c0);
  methods += new qt_gsi::GenericMethod ("setActive|active=", "@brief Method void QUndoStack::setActive(bool active)\n", false, &_init_f_setActive_864, &_call_f_setActive_864);
  methods += new qt_gsi::GenericMethod ("setClean", "@brief Method void QUndoStack::setClean()\n", false, &_init_f_setClean_0, &_call_f_setClean_0);
  methods += new qt_gsi::GenericMethod ("setIndex|index=", "@brief Method void QUndoStack::setIndex(int idx)\n", false, &_init_f_setIndex_767, &_call_f_setIndex_767);
  methods += new qt_gsi::GenericMethod ("setUndoLimit|undoLimit=", "@brief Method void QUndoStack::setUndoLimit(int limit)\n", false, &_init_f_setUndoLimit_767, &_call_f_setUndoLimit_767);
  methods += new qt_gsi::GenericMethod ("text", "@brief Method QString QUndoStack::text(int idx)\n", true, &_init_f_text_c767, &_call_f_text_c767);
  methods += new qt_gsi::GenericMethod ("undo", "@brief Method void QUndoStack::undo()\n", false, &_init_f_undo_0, &_call_f_undo_0);
  methods += new qt_gsi::GenericMethod (":undoLimit", "@brief Method int QUndoStack::undoLimit()\n", true, &_init_f_undoLimit_c0, &_call_f_undoLimit_c0);
  methods += new qt_gsi::GenericMethod ("undoText", "@brief Method QString QUndoStack::undoText()\n", true, &_init_f_undoText_c0, &_call_f_undoText_c0);
  methods += gsi::qt_signal<bool > ("canRedoChanged(bool)", "canRedoChanged", gsi::arg("canRedo"), "@brief Signal declaration for QUndoStack::canRedoChanged(bool canRedo)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("canUndoChanged(bool)", "canUndoChanged", gsi::arg("canUndo"), "@brief Signal declaration for QUndoStack::canUndoChanged(bool canUndo)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("cleanChanged(bool)", "cleanChanged", gsi::arg("clean"), "@brief Signal declaration for QUndoStack::cleanChanged(bool clean)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QUndoStack::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("indexChanged(int)", "indexChanged", gsi::arg("idx"), "@brief Signal declaration for QUndoStack::indexChanged(int idx)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QUndoStack::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("redoTextChanged(const QString &)", "redoTextChanged", gsi::arg("redoText"), "@brief Signal declaration for QUndoStack::redoTextChanged(const QString &redoText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("undoTextChanged(const QString &)", "undoTextChanged", gsi::arg("undoText"), "@brief Signal declaration for QUndoStack::undoTextChanged(const QString &undoText)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QUndoStack::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QUndoStack::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QUndoStack> decl_QUndoStack (qtdecl_QObject (), "QtWidgets", "QUndoStack_Native",
  methods_QUndoStack (),
  "@hide\n@alias QUndoStack");

GSI_QTWIDGETS_PUBLIC gsi::Class<QUndoStack> &qtdecl_QUndoStack () { return decl_QUndoStack; }

}


class QUndoStack_Adaptor : public QUndoStack, public qt_gsi::QtObjectBase
{
public:

  virtual ~QUndoStack_Adaptor();

  //  [adaptor ctor] QUndoStack::QUndoStack(QObject *parent)
  QUndoStack_Adaptor() : QUndoStack()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUndoStack::QUndoStack(QObject *parent)
  QUndoStack_Adaptor(QObject *parent) : QUndoStack(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QUndoStack::isSignalConnected(const QMetaMethod &signal)
  bool fp_QUndoStack_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QUndoStack::isSignalConnected(signal);
  }

  //  [expose] int QUndoStack::receivers(const char *signal)
  int fp_QUndoStack_receivers_c1731 (const char *signal) const {
    return QUndoStack::receivers(signal);
  }

  //  [expose] QObject *QUndoStack::sender()
  QObject * fp_QUndoStack_sender_c0 () const {
    return QUndoStack::sender();
  }

  //  [expose] int QUndoStack::senderSignalIndex()
  int fp_QUndoStack_senderSignalIndex_c0 () const {
    return QUndoStack::senderSignalIndex();
  }

  //  [emitter impl] void QUndoStack::canRedoChanged(bool canRedo)
  void emitter_QUndoStack_canRedoChanged_864(bool canRedo)
  {
    emit QUndoStack::canRedoChanged(canRedo);
  }

  //  [emitter impl] void QUndoStack::canUndoChanged(bool canUndo)
  void emitter_QUndoStack_canUndoChanged_864(bool canUndo)
  {
    emit QUndoStack::canUndoChanged(canUndo);
  }

  //  [emitter impl] void QUndoStack::cleanChanged(bool clean)
  void emitter_QUndoStack_cleanChanged_864(bool clean)
  {
    emit QUndoStack::cleanChanged(clean);
  }

  //  [emitter impl] void QUndoStack::destroyed(QObject *)
  void emitter_QUndoStack_destroyed_1302(QObject *arg1)
  {
    emit QUndoStack::destroyed(arg1);
  }

  //  [adaptor impl] bool QUndoStack::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QUndoStack::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QUndoStack_Adaptor, bool, QEvent *>(&QUndoStack_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QUndoStack::event(arg1);
    }
  }

  //  [adaptor impl] bool QUndoStack::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QUndoStack::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QUndoStack_Adaptor, bool, QObject *, QEvent *>(&QUndoStack_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QUndoStack::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QUndoStack::indexChanged(int idx)
  void emitter_QUndoStack_indexChanged_767(int idx)
  {
    emit QUndoStack::indexChanged(idx);
  }

  //  [emitter impl] void QUndoStack::objectNameChanged(const QString &objectName)
  void emitter_QUndoStack_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QUndoStack::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QUndoStack::redoTextChanged(const QString &redoText)
  void emitter_QUndoStack_redoTextChanged_2025(const QString &redoText)
  {
    emit QUndoStack::redoTextChanged(redoText);
  }

  //  [emitter impl] void QUndoStack::undoTextChanged(const QString &undoText)
  void emitter_QUndoStack_undoTextChanged_2025(const QString &undoText)
  {
    emit QUndoStack::undoTextChanged(undoText);
  }

  //  [adaptor impl] void QUndoStack::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QUndoStack::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QUndoStack_Adaptor, QChildEvent *>(&QUndoStack_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QUndoStack::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoStack::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QUndoStack::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QUndoStack_Adaptor, QEvent *>(&QUndoStack_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QUndoStack::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoStack::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QUndoStack::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QUndoStack_Adaptor, const QMetaMethod &>(&QUndoStack_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QUndoStack::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QUndoStack::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QUndoStack::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QUndoStack_Adaptor, QTimerEvent *>(&QUndoStack_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QUndoStack::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QUndoStack_Adaptor::~QUndoStack_Adaptor() { }

//  Constructor QUndoStack::QUndoStack(QObject *parent) (adaptor class)

static void _init_ctor_QUndoStack_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QUndoStack_Adaptor> ();
}

static void _call_ctor_QUndoStack_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QUndoStack_Adaptor *> (new QUndoStack_Adaptor (arg1));
}


// emitter void QUndoStack::canRedoChanged(bool canRedo)

static void _init_emitter_canRedoChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("canRedo");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_canRedoChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QUndoStack_Adaptor *)cls)->emitter_QUndoStack_canRedoChanged_864 (arg1);
}


// emitter void QUndoStack::canUndoChanged(bool canUndo)

static void _init_emitter_canUndoChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("canUndo");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_canUndoChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QUndoStack_Adaptor *)cls)->emitter_QUndoStack_canUndoChanged_864 (arg1);
}


// void QUndoStack::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QUndoStack::cleanChanged(bool clean)

static void _init_emitter_cleanChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("clean");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_cleanChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QUndoStack_Adaptor *)cls)->emitter_QUndoStack_cleanChanged_864 (arg1);
}


// void QUndoStack::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QUndoStack::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QUndoStack_Adaptor *)cls)->emitter_QUndoStack_destroyed_1302 (arg1);
}


// void QUndoStack::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QUndoStack::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QUndoStack_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QUndoStack::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QUndoStack_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QUndoStack::indexChanged(int idx)

static void _init_emitter_indexChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_indexChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QUndoStack_Adaptor *)cls)->emitter_QUndoStack_indexChanged_767 (arg1);
}


// exposed bool QUndoStack::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QUndoStack_Adaptor *)cls)->fp_QUndoStack_isSignalConnected_c2394 (arg1));
}


// emitter void QUndoStack::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QUndoStack_Adaptor *)cls)->emitter_QUndoStack_objectNameChanged_4567 (arg1);
}


// exposed int QUndoStack::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QUndoStack_Adaptor *)cls)->fp_QUndoStack_receivers_c1731 (arg1));
}


// emitter void QUndoStack::redoTextChanged(const QString &redoText)

static void _init_emitter_redoTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("redoText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_redoTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QUndoStack_Adaptor *)cls)->emitter_QUndoStack_redoTextChanged_2025 (arg1);
}


// exposed QObject *QUndoStack::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QUndoStack_Adaptor *)cls)->fp_QUndoStack_sender_c0 ());
}


// exposed int QUndoStack::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QUndoStack_Adaptor *)cls)->fp_QUndoStack_senderSignalIndex_c0 ());
}


// void QUndoStack::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUndoStack_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoStack_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QUndoStack::undoTextChanged(const QString &undoText)

static void _init_emitter_undoTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("undoText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_undoTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QUndoStack_Adaptor *)cls)->emitter_QUndoStack_undoTextChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QUndoStack> &qtdecl_QUndoStack ();

static gsi::Methods methods_QUndoStack_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUndoStack::QUndoStack(QObject *parent)\nThis method creates an object of class QUndoStack.", &_init_ctor_QUndoStack_Adaptor_1302, &_call_ctor_QUndoStack_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_canRedoChanged", "@brief Emitter for signal void QUndoStack::canRedoChanged(bool canRedo)\nCall this method to emit this signal.", false, &_init_emitter_canRedoChanged_864, &_call_emitter_canRedoChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_canUndoChanged", "@brief Emitter for signal void QUndoStack::canUndoChanged(bool canUndo)\nCall this method to emit this signal.", false, &_init_emitter_canUndoChanged_864, &_call_emitter_canUndoChanged_864);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QUndoStack::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_cleanChanged", "@brief Emitter for signal void QUndoStack::cleanChanged(bool clean)\nCall this method to emit this signal.", false, &_init_emitter_cleanChanged_864, &_call_emitter_cleanChanged_864);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QUndoStack::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QUndoStack::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QUndoStack::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QUndoStack::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QUndoStack::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_indexChanged", "@brief Emitter for signal void QUndoStack::indexChanged(int idx)\nCall this method to emit this signal.", false, &_init_emitter_indexChanged_767, &_call_emitter_indexChanged_767);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QUndoStack::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QUndoStack::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QUndoStack::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_redoTextChanged", "@brief Emitter for signal void QUndoStack::redoTextChanged(const QString &redoText)\nCall this method to emit this signal.", false, &_init_emitter_redoTextChanged_2025, &_call_emitter_redoTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QUndoStack::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QUndoStack::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QUndoStack::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_undoTextChanged", "@brief Emitter for signal void QUndoStack::undoTextChanged(const QString &undoText)\nCall this method to emit this signal.", false, &_init_emitter_undoTextChanged_2025, &_call_emitter_undoTextChanged_2025);
  return methods;
}

gsi::Class<QUndoStack_Adaptor> decl_QUndoStack_Adaptor (qtdecl_QUndoStack (), "QtWidgets", "QUndoStack",
  methods_QUndoStack_Adaptor (),
  "@qt\n@brief Binding of QUndoStack");

}

