; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbp -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32ZBP-ZBKB
; RUN: llc -mtriple=riscv32 -mattr=+zbkb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32ZBP-ZBKB

define i32 @pack_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: pack_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    slli a1, a1, 16
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-ZBKB-LABEL: pack_i32:
; RV32ZBP-ZBKB:       # %bb.0:
; RV32ZBP-ZBKB-NEXT:    pack a0, a0, a1
; RV32ZBP-ZBKB-NEXT:    ret
  %shl = and i32 %a, 65535
  %shl1 = shl i32 %b, 16
  %or = or i32 %shl1, %shl
  ret i32 %or
}

; As we are not matching directly i64 code patterns on RV32 some i64 patterns
; don't have yet any matching bit manipulation instructions on RV32.
; This test is presented here in case future expansions of the Bitmanip
; extensions introduce instructions suitable for this pattern.

define i64 @pack_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: pack_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:    ret
  %shl = and i64 %a, 4294967295
  %shl1 = shl i64 %b, 32
  %or = or i64 %shl1, %shl
  ret i64 %or
}

; As we are not matching directly i64 code patterns on RV32 some i64 patterns
; don't have yet any matching bit manipulation instructions on RV32.
; This test is presented here in case future expansions of the Bitmanip
; extensions introduce instructions suitable for this pattern.

define i64 @packu_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: packu_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:    ret
  %shr = lshr i64 %a, 32
  %shr1 = and i64 %b, -4294967296
  %or = or i64 %shr1, %shr
  ret i64 %or
}

define i32 @packh_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: packh_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 255
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    srli a1, a1, 16
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-ZBKB-LABEL: packh_i32:
; RV32ZBP-ZBKB:       # %bb.0:
; RV32ZBP-ZBKB-NEXT:    packh a0, a0, a1
; RV32ZBP-ZBKB-NEXT:    ret
  %and = and i32 %a, 255
  %and1 = shl i32 %b, 8
  %shl = and i32 %and1, 65280
  %or = or i32 %shl, %and
  ret i32 %or
}

define i32 @packh_i32_2(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: packh_i32_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 255
; RV32I-NEXT:    andi a1, a1, 255
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-ZBKB-LABEL: packh_i32_2:
; RV32ZBP-ZBKB:       # %bb.0:
; RV32ZBP-ZBKB-NEXT:    packh a0, a0, a1
; RV32ZBP-ZBKB-NEXT:    ret
  %and = and i32 %a, 255
  %and1 = and i32 %b, 255
  %shl = shl i32 %and1, 8
  %or = or i32 %shl, %and
  ret i32 %or
}

define i64 @packh_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: packh_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 255
; RV32I-NEXT:    slli a1, a2, 24
; RV32I-NEXT:    srli a1, a1, 16
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32ZBP-ZBKB-LABEL: packh_i64:
; RV32ZBP-ZBKB:       # %bb.0:
; RV32ZBP-ZBKB-NEXT:    packh a0, a0, a2
; RV32ZBP-ZBKB-NEXT:    li a1, 0
; RV32ZBP-ZBKB-NEXT:    ret
  %and = and i64 %a, 255
  %and1 = shl i64 %b, 8
  %shl = and i64 %and1, 65280
  %or = or i64 %shl, %and
  ret i64 %or
}

define i64 @packh_i64_2(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: packh_i64_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 255
; RV32I-NEXT:    andi a1, a2, 255
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32ZBP-ZBKB-LABEL: packh_i64_2:
; RV32ZBP-ZBKB:       # %bb.0:
; RV32ZBP-ZBKB-NEXT:    packh a0, a0, a2
; RV32ZBP-ZBKB-NEXT:    li a1, 0
; RV32ZBP-ZBKB-NEXT:    ret
  %and = and i64 %a, 255
  %and1 = and i64 %b, 255
  %shl = shl i64 %and1, 8
  %or = or i64 %shl, %and
  ret i64 %or
}
