<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile doxygen_version="1.9.1">
  <compound kind="file">
    <name>apreq.h</name>
    <path>/home/jorton/src/asf/libapreq-v2.17/include/</path>
    <filename>apreq_8h.html</filename>
    <class kind="struct">apreq_value_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a02bf89714a74397155a11b9ccb942b0d</anchor>
      <arglist>(d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_NONSTD</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a8a1e7333187fdbc476473ac72d2ff38b</anchor>
      <arglist>(d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_DATA</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a142563500999527d486a2eac8c3a0973</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_READ_BLOCK_SIZE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a73bfd1896ab59181f8e052fb8cc147cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_READ_LIMIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a744fa55285c4a3868a9154f473d58ac4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_BRIGADE_LIMIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>af54c8645b8266fa7c9b2e261c608744f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_NELTS</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a253093cc2fffe7094828714ade120466</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_OFF</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a5bcc4e81747b13b7bfbb946648453f9e</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_ON</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>adf8584e758a62fe0a79023821c359222</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_GET</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a07141b4d0c7daa6d5aba5ff33d52a31f</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_SET</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a817a3e293b1ae4210ee68871d6b67e1f</anchor>
      <arglist>(f, name, value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_CHARSET_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>aa9a11ce4168273452b3fde6e42221d74</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_CHARSET_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a901fbcbe68a29cfce368b6640bd5bcde</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_TAINTED_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>acecc7cc6c676725990e0be5f14179ca7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_TAINTED_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a3b151396d29841edc92a2889a38fda79</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_VERSION_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a16af9730d0124fef7849c36121d63141</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_VERSION_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>ae70e687e9866ea4a61ed3594c97bf5ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_SECURE_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a79ac15b3b3d9905367b9758514513dc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_SECURE_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>acbe05bd23b067595cae2318473f42d9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_HTTPONLY_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a9fc978fd97cc558ff5f51a14503daab7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_HTTPONLY_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a71f0dc8a9004339edfa279266fab50e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>apreq_attr_to_type</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a6355f965e8eabf742537bfd8da534376</anchor>
      <arglist>(T, A, P)</arglist>
    </member>
    <member kind="typedef">
      <type>struct apreq_value_t</type>
      <name>apreq_value_t</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>ad1d0e6fa5f9cdecb695541c697789f3e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>apreq_charset_t</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a6607dfa756796989c15014870b48c8cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>apreq_join_t</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>ac3784c04255e92629350505d35b0473e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_AS_IS</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>ac3784c04255e92629350505d35b0473ea9b74c73cbfdf7aad3effc0627018ff08</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_ENCODE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>ac3784c04255e92629350505d35b0473ea6cc82b38c229380cc7fbb274b7e3cf36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_DECODE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>ac3784c04255e92629350505d35b0473ea9dd8468f9547f1dee0709f906e98cdc6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_QUOTE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>ac3784c04255e92629350505d35b0473eab22a5a8f345963488381335b2f909fb9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>apreq_match_t</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a590d7bfd9cd294f652d388c4f37fc8d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_MATCH_FULL</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a590d7bfd9cd294f652d388c4f37fc8d5a6ff614170217cfafb5c32c1cefd6caba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_MATCH_PARTIAL</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a590d7bfd9cd294f652d388c4f37fc8d5a2fbd9432fdb0e8bec90bd9ec76dcb3f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>apreq_expires_t</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>aeb51f7cb925e3218c622ff82b8ee2f70</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_EXPIRES_HTTP</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>aeb51f7cb925e3218c622ff82b8ee2f70ad0fecca3f99d74b155630437504119f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_EXPIRES_NSCOOKIE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>aeb51f7cb925e3218c622ff82b8ee2f70aa7e0989ec9839a8494ea328ff30eb5a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_value_table_add</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a0d27c51db1532fa3f829838ed90f6226</anchor>
      <arglist>(const apreq_value_t *v, apr_table_t *t)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a163e7aaee57baa89b4d7e00a4279b035</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_pre_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>aff013107e72c94b917617fd42dce79e8</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_post_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>acecad02f3b9982190143d1097bbfa555</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_cookie.h</name>
    <path>/home/jorton/src/asf/libapreq-v2.17/include/</path>
    <filename>apreq__cookie_8h.html</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <class kind="struct">apreq_cookie_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_MAX_LENGTH</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a681b8ef60cad05e684876d4dd2be043b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct apreq_cookie_t</type>
      <name>apreq_cookie_t</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a40b9ebd9bc37f9019c0091ee97c4c535</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_cookie_t *</type>
      <name>apreq_value_to_cookie</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>ab69d56f31d7c8f6f6f598a133817b46e</anchor>
      <arglist>(const char *val)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_version</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a04eaee766e51f143ff2ca4d8a0107004</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_version_set</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>aeff5b05ca6b935dd61dcc9da1a047546</anchor>
      <arglist>(apreq_cookie_t *c, unsigned v)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_is_secure</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a7553c7f54497ce30e1828082c98c813e</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_secure_on</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a1df7a1ba35cf4c47fc907f40b95fe5e4</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_secure_off</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>ad9f4813b99b80801ba1dc11d0099ac10</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_is_httponly</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a61c3709414b9fe614e32587da8ee8e8a</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_httponly_on</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>aa9a94a9b03dea7b286a9c4041d3c7e4e</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_httponly_off</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a619cc2d56e20134e91bf1d31ab26bfec</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_is_tainted</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a08618139ba29e98cd2327de3f0e961fe</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_tainted_on</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>afeec2e0802ae883d4f2fda750b74ca55</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_tainted_off</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>ac3b777e9709fa062ff978afef3867964</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parse_cookie_header</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a113be08c01bc82605ec52d80c054cbf6</anchor>
      <arglist>(apr_pool_t *pool, apr_table_t *jar, const char *header)</arglist>
    </member>
    <member kind="function">
      <type>apreq_cookie_t *</type>
      <name>apreq_cookie_make</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a53b5bb02baf7fb318cd643fb55820422</anchor>
      <arglist>(apr_pool_t *pool, const char *name, const apr_size_t nlen, const char *value, const apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_cookie_as_string</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a10c1d6639303c3f85fb5818d88e654d3</anchor>
      <arglist>(const apreq_cookie_t *c, apr_pool_t *p)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>apreq_cookie_serialize</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>afc06d8f5e4ee8530013c4f3c3b12e01f</anchor>
      <arglist>(const apreq_cookie_t *c, char *buf, apr_size_t len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apreq_cookie_expires</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a8c6eb3c7c0f003bdc150d2ce99dacc7f</anchor>
      <arglist>(apreq_cookie_t *c, const char *time_str)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_error.h</name>
    <path>/home/jorton/src/asf/libapreq-v2.17/include/</path>
    <filename>apreq__error_8h.html</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="define">
      <type>#define</type>
      <name>APR_EBADARG</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a7f8849f2cb2d0bfd64f644a6ca0cec2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_GENERAL</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a14b149a0f859ce1078d36db8e8f45a2a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_TAINTED</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a035ee2cee3527332669bdaf17142f520</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_INTERRUPT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a91b1099a9cbf13d45a45a14b7d279b75</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADDATA</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>ade2a5d60e2db8fc32d8c43580d74c0c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADCHAR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a04b6a01738a1ee7fd1ecc79d256e721f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADSEQ</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a73a69e21acc2cf849310a421ab43d2ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADATTR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a3d696f49030bb7fc65f2804037d3ccb7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADHEADER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a11e549980ef0fce49ac7179bb9164d57</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADUTF8</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a88ab15be9af4235cb6b1d9c6c512f0e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NODATA</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a6e29823668899ad81365ae68f96f3ae4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOTOKEN</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a59be3610ba54a58fbb3cd6bb655ff972</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOATTR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>affdf9393e5c9277aeae3ea8d2ecf55fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOHEADER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a3ce3cf5b410b1ccc2e42ae46d4577f20</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOPARSER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a02ebfa80f1a413b46212df5682db5890</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_MISMATCH</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a33080081185585997ef9c5232ec4dd8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_OVERLIMIT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>abcc1b4c98b1d8c5d128cffd50afb978e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_UNDERLIMIT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a0370b1ba3534f6ae9f422c6b351c79cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOTEMPTY</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a17d6bb14537a52ef53b56e4b385c76b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_strerror</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a48c0198d940b53fbd4d843d7deb65e47</anchor>
      <arglist>(apr_status_t s, char *buf, apr_size_t bufsize)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_module.h</name>
    <path>/home/jorton/src/asf/libapreq-v2.17/include/</path>
    <filename>apreq__module_8h.html</filename>
    <includes id="apreq__cookie_8h" name="apreq_cookie.h" local="yes" imported="no">apreq_cookie.h</includes>
    <includes id="apreq__parser_8h" name="apreq_parser.h" local="yes" imported="no">apreq_parser.h</includes>
    <includes id="apreq__error_8h" name="apreq_error.h" local="yes" imported="no">apreq_error.h</includes>
    <class kind="struct">apreq_handle_t</class>
    <class kind="struct">apreq_module_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MODULE</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a7d6d0550f527e18c8cfab702e65daf3b</anchor>
      <arglist>(pre, mmn)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>apreq_cookie</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a5b5398d109fb933fb0367ef947e7c7b6</anchor>
      <arglist>(req, name)</arglist>
    </member>
    <member kind="typedef">
      <type>struct apreq_handle_t</type>
      <name>apreq_handle_t</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>acc662f2b62f1d13f6c9e03536f565952</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct apreq_module_t</type>
      <name>apreq_module_t</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>ab584b3f1216e609ba8082d081cfb5659</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_module_status_is_error</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a08dedd0ec5b291dad6b58644896eb2ed</anchor>
      <arglist>(apr_status_t s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_jar</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a2652c9a9b0e0f4162051fc3904ac480a</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_args</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>ade74830e449fa5bb24694ffc3b8374ca</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_body</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>ae928689622d094025a8efb8c6c17d680</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_cookie_t *</type>
      <name>apreq_jar_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a63dfa7b7b303d061fe56c7109528d430</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_args_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>aeadd074ee9dd8095d857820ce15f1701</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_body_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a7c4cb1c2b91f5539b2231d09ebea2239</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a136584883dac2b5c76052bed1c4e61dc</anchor>
      <arglist>(apreq_handle_t *req, const apreq_parser_t **parser)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a6842f8b5a1d1f9115ba8ff7b1da1e78b</anchor>
      <arglist>(apreq_handle_t *req, apreq_parser_t *parser)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_hook_add</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a0c24fc39ad03c54839a9cb03dc00dc28</anchor>
      <arglist>(apreq_handle_t *req, apreq_hook_t *hook)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_limit_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>ab368191aa61cd0386e824c1a6dbd6e49</anchor>
      <arglist>(apreq_handle_t *req, apr_size_t bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_limit_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>ad98e3dac181ac837159581812229d8e3</anchor>
      <arglist>(apreq_handle_t *req, apr_size_t *bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_read_limit_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a97d4d8090e7847ace598c7a65b309564</anchor>
      <arglist>(apreq_handle_t *req, apr_uint64_t bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_read_limit_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>ab5cc462231ee5e4389ceb46eab1e456f</anchor>
      <arglist>(apreq_handle_t *req, apr_uint64_t *bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_temp_dir_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>afc1b7d33062581140fd16b859b06d24a</anchor>
      <arglist>(apreq_handle_t *req, const char *path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_temp_dir_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a51c4bd2bc98e9355f8595341ba6aff0b</anchor>
      <arglist>(apreq_handle_t *req, const char **path)</arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_cgi</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a3f9b9c725672298c86b081aaa258fbdc</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_custom</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>abeaaad6c03b54ca963f9f14a3031e912</anchor>
      <arglist>(apr_pool_t *pool, const char *query_string, const char *cookie, apreq_parser_t *parser, apr_uint64_t read_limit, apr_bucket_brigade *in)</arglist>
    </member>
    <member kind="function">
      <type>apreq_param_t *</type>
      <name>apreq_param</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a08c59b5f07fb36080bb4d62e68bfeddf</anchor>
      <arglist>(apreq_handle_t *req, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>apr_table_t *</type>
      <name>apreq_params</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a0dff48fd4e83399a07853abe9d67c251</anchor>
      <arglist>(apreq_handle_t *req, apr_pool_t *p)</arglist>
    </member>
    <member kind="function">
      <type>apr_table_t *</type>
      <name>apreq_cookies</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a7435376b1f543c604d8326de3157e075</anchor>
      <arglist>(apreq_handle_t *req, apr_pool_t *p)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_param.h</name>
    <path>/home/jorton/src/asf/libapreq-v2.17/include/</path>
    <filename>apreq__param_8h.html</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <class kind="struct">apreq_param_t</class>
    <member kind="typedef">
      <type>struct apreq_param_t</type>
      <name>apreq_param_t</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>ad7b3956f0310dec4b970ad7135aeabd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_param_is_tainted</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>af407c2ab726bc8bc34a1b1924a4f327a</anchor>
      <arglist>(const apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_param_tainted_on</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a967919466da31283c6d668c58fe5223c</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_param_tainted_off</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>ae76641d443483db5274624f948e1c347</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_charset_t</type>
      <name>apreq_param_charset_set</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>abe765ec55aebc8409ddd6d3db44ff917</anchor>
      <arglist>(apreq_param_t *p, apreq_charset_t c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_charset_t</type>
      <name>apreq_param_charset_get</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>abe2a7a47df83a5667fe2834bfc03f15a</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_value_to_param</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a121453693ef7c6af821ae723b6dbe34b</anchor>
      <arglist>(const char *val)</arglist>
    </member>
    <member kind="function">
      <type>apreq_param_t *</type>
      <name>apreq_param_make</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a25c915d3d0fd1694d2c538f108646560</anchor>
      <arglist>(apr_pool_t *p, const char *name, const apr_size_t nlen, const char *val, const apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_param_decode</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>aeea075c59169992492f6f5c40b9b8a70</anchor>
      <arglist>(apreq_param_t **param, apr_pool_t *pool, const char *word, apr_size_t nlen, apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_param_encode</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a4b8b032f9d2ae8e0a6e95b6dd95b5aa9</anchor>
      <arglist>(apr_pool_t *pool, const apreq_param_t *param)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parse_query_string</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a0aa638519951d85d1faf7bf6ba986226</anchor>
      <arglist>(apr_pool_t *pool, apr_table_t *t, const char *qs)</arglist>
    </member>
    <member kind="function">
      <type>apr_array_header_t *</type>
      <name>apreq_params_as_array</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a76c7e698fd45f3f3e07db60fcba15e52</anchor>
      <arglist>(apr_pool_t *p, const apr_table_t *t, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>apreq_params_as_string</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a0f1db12120bb2307f5e33186f094b0d6</anchor>
      <arglist>(apr_pool_t *p, const apr_table_t *t, const char *key, apreq_join_t mode)</arglist>
    </member>
    <member kind="function">
      <type>const apr_table_t *</type>
      <name>apreq_uploads</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>ae449c4a1890767d1e9a50c78ea42769c</anchor>
      <arglist>(const apr_table_t *body, apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>const apreq_param_t *</type>
      <name>apreq_upload</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a1be07e7c4c8a687203ccc0d38ec3aedd</anchor>
      <arglist>(const apr_table_t *body, const char *name)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_parser.h</name>
    <path>/home/jorton/src/asf/libapreq-v2.17/include/</path>
    <filename>apreq__parser_8h.html</filename>
    <includes id="apreq__param_8h" name="apreq_param.h" local="yes" imported="no">apreq_param.h</includes>
    <class kind="struct">apreq_hook_t</class>
    <class kind="struct">apreq_parser_t</class>
    <class kind="struct">apreq_hook_find_param_ctx_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_PARSER_ARGS</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>af39d2adfdd09c2fe0c8c6a3c1ea1437e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_HOOK_ARGS</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a61c8b1c319752bde3cc35e98247707bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a855c07ea7fc9e240c8620d29eea4a019</anchor>
      <arglist>(f)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>abaa196498d8cf959e07b4c84d5264f7f</anchor>
      <arglist>(f)</arglist>
    </member>
    <member kind="typedef">
      <type>struct apreq_hook_t</type>
      <name>apreq_hook_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a2c35885676cec315fc7dea19a6d1d870</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct apreq_parser_t</type>
      <name>apreq_parser_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>ade5e15a40b9e1ec626ee56c494c7cdbb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>apr_status_t(*</type>
      <name>apreq_parser_function_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>affb8f3ab5b29a4e09f3aa3bde8630118</anchor>
      <arglist>)(APREQ_PARSER_ARGS)</arglist>
    </member>
    <member kind="typedef">
      <type>apr_status_t(*</type>
      <name>apreq_hook_function_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a6ff78d9001f60363061d0608b52afbe0</anchor>
      <arglist>)(APREQ_HOOK_ARGS)</arglist>
    </member>
    <member kind="typedef">
      <type>struct apreq_hook_find_param_ctx_t</type>
      <name>apreq_hook_find_param_ctx_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>ab9e03fd28359c5a82771a25d806c2165</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_run</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a3c00aa3a31daba2c06110d5fc8edf1fe</anchor>
      <arglist>(struct apreq_parser_t *psr, apr_table_t *t, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_hook_run</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a14d03a414fc4a0663af55fbb1f532bab</anchor>
      <arglist>(struct apreq_hook_t *h, apreq_param_t *param, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a6fd1ffe554941172fce54217c35f9db3</anchor>
      <arglist>(apreq_parse_headers)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>aec4b20f646ea57ad84d6a3391c548838</anchor>
      <arglist>(apreq_parse_urlencoded)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a3bb6d9580fcbaf11cef33072ed3b14cb</anchor>
      <arglist>(apreq_parse_multipart)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a2833122bb6995f056a96df80a9f5a45f</anchor>
      <arglist>(apreq_parse_generic)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>adda61d873abf1c0ed1857bda405baa49</anchor>
      <arglist>(apreq_hook_apr_xml_parser)</arglist>
    </member>
    <member kind="function">
      <type>apreq_parser_t *</type>
      <name>apreq_parser_make</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a562191171c5df0a83360435d0fe1a667</anchor>
      <arglist>(apr_pool_t *pool, apr_bucket_alloc_t *ba, const char *content_type, apreq_parser_function_t pfn, apr_size_t brigade_limit, const char *temp_dir, apreq_hook_t *hook, void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>apreq_hook_t *</type>
      <name>apreq_hook_make</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a3cf15457eea6991b36f47f6139ab163c</anchor>
      <arglist>(apr_pool_t *pool, apreq_hook_function_t hook, apreq_hook_t *next, void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parser_add_hook</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a97972c08b20917465b745c8b8eec95ed</anchor>
      <arglist>(apreq_parser_t *p, apreq_hook_t *h)</arglist>
    </member>
    <member kind="function">
      <type>apreq_parser_function_t</type>
      <name>apreq_parser</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a73013ecad087f14075d319a4a983dd82</anchor>
      <arglist>(const char *enctype)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_register_parser</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a595f05be3d241a5b339fd6ef948bfbc8</anchor>
      <arglist>(const char *enctype, apreq_parser_function_t pfn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a162c74d59738663d7cb2109ee0b87c0a</anchor>
      <arglist>(apreq_hook_disable_uploads)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>ad169b0ac7b7b1a66d3df3ae66c96a16c</anchor>
      <arglist>(apreq_hook_discard_brigade)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a5deeed0646b3d61cafe4eb5b6e40b16c</anchor>
      <arglist>(apreq_hook_find_param)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_util.h</name>
    <path>/home/jorton/src/asf/libapreq-v2.17/include/</path>
    <filename>apreq__util_8h.html</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="function">
      <type>char *</type>
      <name>apreq_join</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a1aa668dc806fce4bd0fef348d1601930</anchor>
      <arglist>(apr_pool_t *p, const char *sep, const apr_array_header_t *arr, apreq_join_t mode)</arglist>
    </member>
    <member kind="function">
      <type>apr_ssize_t</type>
      <name>apreq_index</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>ac72c51ffe478faa804eaea5f68276dd8</anchor>
      <arglist>(const char *hay, apr_size_t hlen, const char *ndl, apr_size_t nlen, const apreq_match_t type)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_quote</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>ab4aa9bed839bb576444f464666e0bd85</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_quote_once</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>afef8b7af9d36b0f7ec24e9d0f64a29a7</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_encode</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a034ccdfdcf751be6c0f8c2a1d30c2ae6</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_cp1252_to_utf8</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a801aa204656988ff4aa32cec6dd80e5a</anchor>
      <arglist>(char *dest, const char *src, apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apreq_charset_t</type>
      <name>apreq_charset_divine</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>ae11e0b3e2304a2e8c30aaa464ea78037</anchor>
      <arglist>(const char *src, apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_decode</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a3c1d46b8c0e7991ae1ced0178c2f4738</anchor>
      <arglist>(char *dest, apr_size_t *dlen, const char *src, apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_decodev</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a13a090a30a4d05353caabab92a67179d</anchor>
      <arglist>(char *dest, apr_size_t *dlen, struct iovec *v, int nelts)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE char *</type>
      <name>apreq_escape</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a785be2ceae273b0a7b2ffda223b2ebae</anchor>
      <arglist>(apr_pool_t *p, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_ssize_t</type>
      <name>apreq_unescape</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a979c0af9322189581bde4644eec5fd41</anchor>
      <arglist>(char *str)</arglist>
    </member>
    <member kind="function">
      <type>apr_int64_t</type>
      <name>apreq_atoi64f</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a69acb9425572cb8f694d49277160b1f7</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>apr_int64_t</type>
      <name>apreq_atoi64t</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a4e838a92724aa7d9be0b978dc5c4e50c</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_brigade_fwrite</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a3bbe5ee2d1537c6a9f30d0fed9f5f1e1</anchor>
      <arglist>(apr_file_t *f, apr_off_t *wlen, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_file_mktemp</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>ab266a81c528de92654eb37f9890c4a7d</anchor>
      <arglist>(apr_file_t **fp, apr_pool_t *pool, const char *path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_setaside</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a91f3144692934b2daf54fb3c9ca7b180</anchor>
      <arglist>(apr_bucket_brigade *bb, apr_pool_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_copy</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>ab4def9e77622cf22cfa427e7fbf2ac45</anchor>
      <arglist>(apr_bucket_brigade *d, apr_bucket_brigade *s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_brigade_move</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>aa23561a0d169b50454a815926ccc0ba5</anchor>
      <arglist>(apr_bucket_brigade *d, apr_bucket_brigade *s, apr_bucket *e)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_header_attribute</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a8195b6a32954928a6088e7cea077dd75</anchor>
      <arglist>(const char *hdr, const char *name, const apr_size_t nlen, const char **val, apr_size_t *vlen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_brigade_concat</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a4ddf563c9902474bdedbf014e24aafc8</anchor>
      <arglist>(apr_pool_t *pool, const char *temp_dir, apr_size_t brigade_limit, apr_bucket_brigade *out, apr_bucket_brigade *in)</arglist>
    </member>
    <member kind="function">
      <type>apr_file_t *</type>
      <name>apreq_brigade_spoolfile</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>aec0de2141b6b742a1468667eb8f8158e</anchor>
      <arglist>(apr_bucket_brigade *bb)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_version.h</name>
    <path>/home/jorton/src/asf/libapreq-v2.17/include/</path>
    <filename>apreq__version_8h.html</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MAJOR_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a7fb04b0c2a9da6237e235b845ee89f9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MINOR_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a44bf530fbecff4ee7bcc0158784da0ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_PATCH_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a365b89d742846921cb3619341e5eb266</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_VERSION_STRING</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>add82c8ea79b8cc142eeec45772d24fdb</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_IS_DEV_STRING</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>ac9445f3e18e852cae2a91bd2a63394be</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apreq_version</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a8d20db97717fa1bad4f31c7f9a29594f</anchor>
      <arglist>(apr_version_t *pvsn)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>apreq_version_string</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a663ea74082d9bbe18a0c15b66b8fddaa</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_cookie_t</name>
    <filename>structapreq__cookie__t.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>path</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>a75e2ad6da3068f50aca9b989e7e1729c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>domain</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>a8097326f4b8711db7d3f085f283ac5a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>port</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>a45dafe4c4b5a751a40bb4123ed691837</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>comment</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>af911681788862a8b0910074ef886bed2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>commentURL</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>a1fa5dfca7e94ebeb6f31d87d926f7626</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_time_t</type>
      <name>max_age</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>ae4f9a1bec2731a70e14b43342abe1077</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned</type>
      <name>flags</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>a7d83540c84756a3d4ad3c8503d24de6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const apreq_value_t</type>
      <name>v</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>a4a4741916f814017f20b64061755cf76</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_handle_t</name>
    <filename>structapreq__handle__t.html</filename>
    <member kind="variable">
      <type>const struct apreq_module_t *</type>
      <name>module</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>aa22bbb005e208580eff0ffe8d57cde46</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>a698eaa56cf54f2cbbc39704fb9d8ab42</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_alloc_t *</type>
      <name>bucket_alloc</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>a89a335e21236423de239a6a6d2526559</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_hook_find_param_ctx_t</name>
    <filename>structapreq__hook__find__param__ctx__t.html</filename>
  </compound>
  <compound kind="struct">
    <name>apreq_hook_t</name>
    <filename>structapreq__hook__t.html</filename>
    <member kind="variable">
      <type>apreq_hook_function_t</type>
      <name>hook</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>a9e61fe14dbacf28528f69de468fb1fc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apreq_hook_t *</type>
      <name>next</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>a09efec3f75c52dbeaeedde059c953f7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>a2316f4a8fb1cf0a9d5a46866b3229db1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>ctx</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>a52aeaf774a4d37758b6a3de625913ac5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_module_t</name>
    <filename>structapreq__module__t.html</filename>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>ae326f2fad3c575876a0da35c5a81123a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_uint32_t</type>
      <name>magic_number</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>adae50d06225fdd6eefeb18ff83045cf7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>jar</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>a10c511ad46d0b2b4ce7a0604991bed72</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>args</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>a14ba1d0aabf56f1b192d925fafaa2ee5</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>body</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>ad1af73336e0ee49e646e1a1a3a23d8e2</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_cookie_t *(*</type>
      <name>jar_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>adf5c6b34126c0c2fc649d6a9aea1052f</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_param_t *(*</type>
      <name>args_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>abc9a40e7a6e4303355f84051469b48a2</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_param_t *(*</type>
      <name>body_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>a908dd59f44f9c1e6eed8d71fac5b7554</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>parser_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>a2a42030641ddc29cc629549bbf8f58b3</anchor>
      <arglist>)(apreq_handle_t *, const apreq_parser_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>parser_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>adb0cf9c30845f70e267ebd43895be40d</anchor>
      <arglist>)(apreq_handle_t *, apreq_parser_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>hook_add</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>ad376b42c74164633f8c5e95515736e19</anchor>
      <arglist>)(apreq_handle_t *, apreq_hook_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>brigade_limit_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>ac1bcc2dcac811dea8cc8a9fd061a6b44</anchor>
      <arglist>)(apreq_handle_t *, apr_size_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>brigade_limit_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>a77b7df138df0f31cb242e4eec9fc77b0</anchor>
      <arglist>)(apreq_handle_t *, apr_size_t)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>read_limit_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>a153d2c1b612d9abf03dddfe66827994f</anchor>
      <arglist>)(apreq_handle_t *, apr_uint64_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>read_limit_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>aba6308fcc4257ed357b137bf21a9e5ac</anchor>
      <arglist>)(apreq_handle_t *, apr_uint64_t)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>temp_dir_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>a712b4c529bfafd030c58377e73534cd7</anchor>
      <arglist>)(apreq_handle_t *, const char **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>temp_dir_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>acc8487557a17cae2887c669d7a5d2733</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_param_t</name>
    <filename>structapreq__param__t.html</filename>
    <member kind="variable">
      <type>apr_table_t *</type>
      <name>info</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>abb8ddaeb79c4d96691289520a2a4777f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_brigade *</type>
      <name>upload</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>a03674c98f355545deeb3fcbe109d8c9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned</type>
      <name>flags</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>a802bd45ab5afd0784d730e0dbb01aa71</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const apreq_value_t</type>
      <name>v</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>af710878750c677daa9cd61868434d67f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_parser_t</name>
    <filename>structapreq__parser__t.html</filename>
    <member kind="variable">
      <type>apreq_parser_function_t</type>
      <name>parser</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>adc117877c27713515c7617b560efb9a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>content_type</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>a3acc7764c18c52c33bb64e3ee3375670</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>a8148c125f670a73aedb9b228612b5901</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_alloc_t *</type>
      <name>bucket_alloc</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>ae2d1910ffc51047ff2759843d1babbc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>brigade_limit</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>a203d6cfc8d36892a995a535bfe644e32</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>temp_dir</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>a928f16aae17f84fadf06a52a51a6385c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apreq_hook_t *</type>
      <name>hook</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>add1d982c326705e8da838041a645de33</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>ctx</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>ab73f196059129e0ca7926526ebba0a78</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_value_t</name>
    <filename>structapreq__value__t.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>name</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>a3015440cd334584cafa3e19078cbf778</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>nlen</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>ae0d07fb5f672d1bd32c9bb53b4da941a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>dlen</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>a7881ecfbe424c4708792fe4b2b1bd4a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char</type>
      <name>data</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>a4aab05328f30a972ae6cd56235a4350e</anchor>
      <arglist>[1]</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>libapreq2</name>
    <title>Apache Request Library</title>
    <filename>group__libapreq2.html</filename>
    <file>apreq.h</file>
    <file>apreq_cookie.h</file>
    <file>apreq_error.h</file>
    <file>apreq_module.h</file>
    <file>apreq_param.h</file>
    <file>apreq_parser.h</file>
    <file>apreq_util.h</file>
    <file>apreq_version.h</file>
    <docanchor file="group__libapreq2.html" title="Configuring libapreq2 Applications">apreq2_config</docanchor>
  </compound>
  <compound kind="group">
    <name>apreq_module</name>
    <title>Modules</title>
    <filename>group__apreq__module.html</filename>
    <subgroup>mod_apreq2</subgroup>
  </compound>
  <compound kind="group">
    <name>apreq_lang</name>
    <title>Language Bindings</title>
    <filename>group__apreq__lang.html</filename>
    <subgroup>apreq_xs</subgroup>
  </compound>
  <compound kind="group">
    <name>apreq_xs</name>
    <title>Perl</title>
    <filename>group__apreq__xs.html</filename>
    <subgroup>apreq_xs_request</subgroup>
    <subgroup>apreq_xs_upload</subgroup>
    <subgroup>apreq_xs_cookie</subgroup>
    <subgroup>apreq_xs_apr_request</subgroup>
    <subgroup>apreq_xs_apr_request_cookie</subgroup>
    <subgroup>apreq_xs_apr_request_param</subgroup>
    <subgroup>apreq_xs_apr_request_error</subgroup>
    <subgroup>apreq_xs_apr_request_cgi</subgroup>
    <subgroup>apreq_xs_apr_request_apache2</subgroup>
  </compound>
  <compound kind="group">
    <name>apreq_xs_request</name>
    <title>Apache2::Request</title>
    <filename>group__apreq__xs__request.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_upload</name>
    <title>Apache2::Upload</title>
    <filename>group__apreq__xs__upload.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_cookie</name>
    <title>Apache2::Cookie</title>
    <filename>group__apreq__xs__cookie.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request</name>
    <title>APR::Request</title>
    <filename>group__apreq__xs__apr__request.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_cookie</name>
    <title>APR::Request::Cookie</title>
    <filename>group__apreq__xs__apr__request__cookie.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_param</name>
    <title>APR::Request::Param</title>
    <filename>group__apreq__xs__apr__request__param.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_error</name>
    <title>APR::Request::Error</title>
    <filename>group__apreq__xs__apr__request__error.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_cgi</name>
    <title>APR::Request::CGI</title>
    <filename>group__apreq__xs__apr__request__cgi.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_apache2</name>
    <title>APR::Request::Apache2</title>
    <filename>group__apreq__xs__apr__request__apache2.html</filename>
  </compound>
  <compound kind="group">
    <name>mod_apreq2</name>
    <title>Apache 2.X Filter Module</title>
    <filename>group__mod__apreq2.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FILTER_NAME</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>ga4b67634b709506e4912f86ebda448504</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_APACHE2_MMN</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>gaab4a3c4b04f2aee2e17b648da09463b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_apache2</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>ga68f508b2e1d9909328d7b1277ce4aa80</anchor>
      <arglist>(request_rec *r)</arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>apreq_license</name>
    <title>LICENSE</title>
    <filename>apreq_license.html</filename>
  </compound>
  <compound kind="page">
    <name>apreq_notice</name>
    <title>NOTICE</title>
    <filename>apreq_notice.html</filename>
  </compound>
  <compound kind="page">
    <name>apreq_install</name>
    <title>INSTALL</title>
    <filename>apreq_install.html</filename>
  </compound>
  <compound kind="page">
    <name>apreq_faq</name>
    <title>FAQ</title>
    <filename>apreq_faq.html</filename>
  </compound>
  <compound kind="page">
    <name>index</name>
    <title></title>
    <filename>index.html</filename>
  </compound>
</tagfile>
