# Stefan Achatz 2012
#
# Tries to find libcairo and sets following variables according to found capabilities:
#
# CAIRO_FOUND
# CAIRO_INCLUDE_DIRS
# CAIRO_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_CAIRO cairo)

FIND_PATH(CAIRO_INCLUDE_DIRS cairo.h
  HINTS
    ${PKG_CAIRO_INCLUDE_DIRS}
    ${PKG_CAIRO_INCLUDEDIR}
  PATH_SUFFIXES cairo
)

FIND_LIBRARY(CAIRO_LIBRARIES cairo
  HINTS ${PKG_CAIRO_LIBRARY_DIRS}
)

IF(CAIRO_LIBRARIES AND CAIRO_INCLUDE_DIRS)
  SET(CAIRO_FOUND true)
ENDIF()

IF(CAIRO_FIND_REQUIRED AND NOT CAIRO_FOUND)
  MESSAGE(FATAL_ERROR "Could not find CAIRO")
ENDIF()
