package PDF::Builder::Resource::Font::CoreFont::timesitalic;

use strict;
use warnings;

our $VERSION = '3.025'; # VERSION
our $LAST_UPDATE = '3.019'; # manually update whenever code is changed

=head1 NAME

PDF::Builder::Resource::Font::CoreFont::timesitalic - font-specific information for italic Times font

=cut

sub data { return {
    'fontname' => 'Times-Italic',
    'type' => 'Type1',
    'apiname' => 'TiIt',
    'ascender' => '683',
    'capheight' => '653',
    'descender' => '-217',
    'iscore' => '1',
    'isfixedpitch' => '0',
    'issymbol' => '0',
    'italicangle' => '-15.5',
    'stdhw' => '32',
    'stdvw' => '76',
    'underlineposition' => '-100',
    'underlinethickness' => '50',
    'xheight' => '441',
    'firstchar' => '32',
    'lastchar' => '255',
    'flags' => '106',
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
    'fontbbox' => [ -169, -217, 1010, 883 ],
# source: \Windows\Fonts\timesi.ttf
# font underline position = -223
# CIDs 0 .. 3577 to be output
# fontbbox = (-497 -306 1333 1023)
    'wx' => { # HORIZ. WIDTH TABLE
	# +1  official .afm spec one larger than what TTF reports
	# (+1)  not in .afm spec, but increased (by 1) per base letter
	# -1  official .afm spec one smaller than what TTF reports
	# others as noted (.afm spec or original .pm plus some %)
        'A'       => 611,                                         # +1
        'AE'       => 889,
        'AEacute'       => 889,
        'AEmacron'       => 889,
        'Aacute'       => 611,                                    # +1
        'Abreve'       => 611,                                    # +1
        'Abreveacute'       => 611,                               # (+1)
        'Abrevecyrillic'       => 610,
        'Abrevedotbelow'       => 611,                            # (+1)
        'Abrevegrave'       => 611,                               # (+1)
        'Abrevehookabove'       => 611,                           # (+1)
        'Abrevetilde'       => 611,                               # (+1)
        'Acaron'       => 611,                                    # (+1)
        'Acircumflex'       => 611,                               # +1
        'Acircumflexacute'       => 611,                          # (+1)
        'Acircumflexdotbelow'       => 611,                       # (+1)
        'Acircumflexgrave'       => 611,                          # (+1)
        'Acircumflexhookabove'       => 611,                      # (+1)
        'Acircumflextilde'       => 611,                          # (+1)
        'Adblgrave'       => 611,                                 # (+1)
        'Adieresis'       => 611,                                 # +1
        'Adieresiscyrillic'       => 610,
        'Adieresismacron'       => 611,                           # (+1)
        'Adotbelow'       => 611,                                 # (+1)
        'Adotmacron'       => 611,                                # (+1)
        'Agrave'       => 611,                                    # +1
        'Ahookabove'       => 611,                                # (+1)
        'Aiecyrillic'       => 889,
        'Ainvertedbreve'       => 611,                            # (+1)
        'Alpha'       => 611,                                     # (+1)
        'Alphatonos'       => 611,                                # (+1)
        'Amacron'       => 611,                                   # +1
        'Aogonek'       => 611,                                   # +1
        'Aring'       => 611,                                     # +1
        'Aringacute'       => 611,                                # (+1)
        'Aringbelow'       => 611,                                # (+1)
        'Atilde'       => 611,                                    # +1
        'Aybarmenian'       => 721,
        'B'       => 611,                                         # +1
        'Bdotaccent'       => 611,                                # (+1)
        'Bdotbelow'       => 611,                                 # (+1)
        'Benarmenian'       => 695,
        'Beta'       => 611,                                      # (+1)
        'Bhook'       => 661,
        'Blinebelow'       => 611,                                # (+1)
        'Btopbar'       => 589,
        'C'       => 667,                                         # +1
        'Caarmenian'       => 733,
        'Cacute'       => 667,                                    # +1
        'Ccaron'       => 667,                                    # +1
        'Ccedilla'       => 667,                                  # +1
        'Ccedillaacute'       => 667,                             # (+1)
        'Ccircumflex'       => 667,                               # (+1)
        'Cdotaccent'       => 667,                                # (+1)
        'Chaarmenian'       => 696,
        'Cheabkhasiancyrillic'       => 814,
        'Chedescenderabkhasiancyrillic'       => 814,
        'Chedescendercyrillic'       => 688,
        'Chedieresiscyrillic'       => 688,
        'Cheharmenian'       => 719,
        'Chekhakassiancyrillic'       => 688,
        'Cheverticalstrokecyrillic'       => 688,
        'Chi'       => 610,
        'Chook'       => 667,                                     # (+1)
        'Coarmenian'       => 690,
        'D'       => 722,
        'DZ'       => 1278,
        'DZcaron'       => 1278,
        'Daarmenian'       => 743,
        'Dafrican'       => 722,
        'Dcaron'       => 722,
        'Dcedilla'       => 722,
        'Dcircumflexbelow'       => 722,
        'Dcroat'       => 722,
        'Ddotaccent'       => 722,
        'Ddotbelow'       => 722,
        'Deicoptic'       => 391,
        'Delta'       => 545,               # afm 612 too wide, was 586
        'Dhook'       => 779,
        'Digammagreek'       => 610,
        'Dlinebelow'       => 722,
        'Dtopbar'       => 589,
        'Dz'       => 1111,
        'Dzcaron'       => 1111,
        'Dzeabkhasiancyrillic'       => 495,
        'E'       => 611,                                         # +1
        'Eacute'       => 611,                                    # +1
        'Ebreve'       => 611,                                    # (+1)
        'Ecaron'       => 611,                                    # +1
        'Ecedillabreve'       => 611,                             # (+1)
        'Echarmenian'       => 687,
        'Ecircumflex'       => 611,                               # +1
        'Ecircumflexacute'       => 611,                          # (+1)
        'Ecircumflexbelow'       => 611,                          # (+1)
        'Ecircumflexdotbelow'       => 611,                       # (+1)
        'Ecircumflexgrave'       => 611,                          # (+1)
        'Ecircumflexhookabove'       => 611,                      # (+1)
        'Ecircumflextilde'       => 611,                          # (+1)
        'Edblgrave'       => 611,                                 # (+1)
        'Edieresis'       => 611,                                 # +1
        'Edotaccent'       => 611,                                # +1
        'Edotbelow'       => 611,                                 # (+1)
        'Egrave'       => 611,                                    # +1
        'Eharmenian'       => 622,
        'Ehookabove'       => 611,                                # (+1)
        'Eightroman'       => 1284,
        'Einvertedbreve'       => 611,                            # (+1)
        'Eiotifiedcyrillic'       => 961,
        'Elevenroman'       => 953,
        'Emacron'       => 611,                                   # +1
        'Emacronacute'       => 611,                              # (+1)
        'Emacrongrave'       => 611,                              # (+1)
        'Endescendercyrillic'       => 722,
        'Eng'       => 696,
        'Enghecyrillic'       => 868,
        'Enhookcyrillic'       => 722,
        'Eogonek'       => 611,                                   # +1
        'Eopen'       => 495,
        'Epsilon'       => 611,                                   # (+1)
        'Epsilontonos'       => 679,
        'Ereversed'       => 611,                                 # (+1)
        'Esdescendercyrillic'       => 666,
        'Esh'       => 594,
        'Eta'       => 722,
        'Etarmenian'       => 702,
        'Etatonos'       => 791,
        'Eth'       => 722,
        'Etilde'       => 611,                                    # (+1)
        'Etildebelow'       => 611,                               # (+1)
        'Euro'       => 500,
        'Ezh'       => 540,
        'Ezhcaron'       => 540,
        'Ezhreversed'       => 540,
        'F'       => 611,                                         # +1
        'Fdotaccent'       => 611,                                # (+1)
        'Feharmenian'       => 809,
        'Feicoptic'       => 580,
        'Fhook'       => 611,                                     # (+1)
        'Fiveroman'       => 610,
        'Fourroman'       => 920,
        'G'       => 722,
        'Gacute'       => 722,
        'Gamma'       => 568,
        'Gammaafrican'       => 704,
        'Gangiacoptic'       => 620,
        'Gbreve'       => 722,
        'Gcaron'       => 722,
        'Gcircumflex'       => 722,
        'Gcommaaccent'       => 722,
        'Gdotaccent'       => 722,
        'Ghadarmenian'       => 720,
        'Ghemiddlehookcyrillic'       => 635,
        'Ghestrokecyrillic'       => 568,
        'Ghook'       => 722,
        'Gimarmenian'       => 728,
        'Gmacron'       => 722,
        'Gsmallhook'       => 494,
        'Gstroke'       => 722,
        'H'       => 722,
        'H18533'       => 604,
        'H18543'       => 354,
        'H18551'       => 354,
        'H22073'       => 604,
        'Haabkhasiancyrillic'       => 666,
        'Hadescendercyrillic'       => 610,
        'Hbar'       => 722,
        'Hbrevebelow'       => 722,
        'Hcedilla'       => 722,
        'Hcircumflex'       => 722,
        'Hdieresis'       => 722,
        'Hdotaccent'       => 722,
        'Hdotbelow'       => 722,
        'Hoarmenian'       => 589,
        'Horicoptic'       => 541,
        'I'       => 333,
        'IJ'       => 750,
        'Iacute'       => 333,
        'Ibreve'       => 333,
        'Icaron'       => 333,
        'Icircumflex'       => 333,
        'Idblgrave'       => 333,
        'Idieresis'       => 333,
        'Idieresisacute'       => 333,
        'Idieresiscyrillic'       => 722,
        'Idotaccent'       => 333,
        'Idotbelow'       => 333,
        'Iebrevecyrillic'       => 610,
        'Ifraktur'       => 553,
        'Igrave'       => 333,
        'Ihookabove'       => 333,
        'Iinvertedbreve'       => 333,
        'Imacron'       => 333,
        'Imacroncyrillic'       => 722,
        'Iniarmenian'       => 663,
        'Iogonek'       => 333,
        'Iota'       => 333,
        'Iotaafrican'       => 277,
        'Iotadieresis'       => 333,
        'Iotatonos'       => 401,
        'Istroke'       => 333,
        'Itilde'       => 333,
        'Itildebelow'       => 333,
        'Izhitsadblgravecyrillic'       => 669,
        'J'       => 444,                                         # +1
        'Jaarmenian'       => 726,
        'Jcircumflex'       => 444,                               # (+1)
        'Jheharmenian'       => 713,
        'K'       => 667,                                         # +1
        'Kabashkircyrillic'       => 749,
        'Kacute'       => 667,                                    # (+1)
        'Kadescendercyrillic'       => 664,
        'Kahookcyrillic'       => 664,
        'Kappa'       => 667,                                     # (+1)
        'Kastrokecyrillic'       => 664,
        'Kaverticalstrokecyrillic'       => 664,
        'Kcaron'       => 667,                                    # (+1)
        'Kcommaaccent'       => 667,                              # +1
        'Kdotbelow'       => 667,                                 # (+1)
        'Keharmenian'       => 804,
        'Kenarmenian'       => 700,
        'Kheicoptic'       => 773,
        'Khook'       => 667,                                     # (+1)
        'Klinebelow'       => 667,                                # (+1)
        'Koppacyrillic'       => 666,
        'Koppagreek'       => 516,
        'Ksicyrillic'       => 495,
        'L'       => 556,
        'LJ'       => 1000,
        'Lacute'       => 556,
        'Lambda'       => 604,
        'Lcaron'       => 550,              # afm 611 too wide, was 556
        'Lcircumflexbelow'       => 556,
        'Lcommaaccent'       => 556,
        'Ldot'       => 556,
        'Ldotbelow'       => 556,
        'Ldotbelowmacron'       => 556,
        'Liwnarmenian'       => 508,
        'Lj'       => 833,
        'Llinebelow'       => 556,
        'Lslash'       => 556,
        'M'       => 833,
        'Macute'       => 833,
        'Mdotaccent'       => 833,
        'Mdotbelow'       => 833,
        'Menarmenian'       => 814,
        'Mturned'       => 783,
        'Mu'       => 833,
        'N'       => 667,                                         # +1
        'NJ'       => 1112,
        'Nacute'       => 667,                                    # +1
        'Ncaron'       => 667,                                    # +1
        'Ncircumflexbelow'       => 667,                          # (+1)
        'Ncommaaccent'       => 667,                              # +1
        'Ndotaccent'       => 667,                                # (+1)
        'Ndotbelow'       => 667,                                 # (+1)
        'Nhookleft'       => 667,                                 # (+1)
        'Nineroman'       => 948,
        'Nj'       => 944,
        'Nlinebelow'       => 667,                                # (+1)
        'Nowarmenian'       => 704,
        'Ntilde'       => 667,                                    # +1
        'Nu'       => 666,
        'O'       => 722,
        'OE'       => 944,                                        # +1
        'Oacute'       => 722,
        'Obarredcyrillic'       => 722,
        'Obarreddieresiscyrillic'       => 722,
        'Obreve'       => 722,
        'Ocaron'       => 722,
        'Ocenteredtilde'       => 722,
        'Ocircumflex'       => 722,
        'Ocircumflexacute'       => 722,
        'Ocircumflexdotbelow'       => 722,
        'Ocircumflexgrave'       => 722,
        'Ocircumflexhookabove'       => 722,
        'Ocircumflextilde'       => 722,
        'Odblgrave'       => 722,
        'Odieresis'       => 722,
        'Odieresiscyrillic'       => 722,
        'Odotbelow'       => 722,
        'Ograve'       => 722,
        'Oharmenian'       => 738,
        'Ohookabove'       => 722,
        'Ohorn'       => 722,
        'Ohornacute'       => 722,
        'Ohorndotbelow'       => 722,
        'Ohorngrave'       => 722,
        'Ohornhookabove'       => 722,
        'Ohorntilde'       => 722,
        'Ohungarumlaut'       => 722,
        'Oi'       => 924,
        'Oinvertedbreve'       => 722,
        'Omacron'       => 722,
        'Omacronacute'       => 722,
        'Omacrongrave'       => 722,
        'Omega'       => 723,
        'Omegacyrillic'       => 1135,
        'Omegaroundcyrillic'       => 782,
        'Omegatitlocyrillic'       => 1135,
        'Omegatonos'       => 726,
        'Omicron'       => 722,
        'Omicrontonos'       => 722,
        'Oneroman'       => 333,
        'Oogonek'       => 722,
        'Oogonekmacron'       => 722,
        'Oopen'       => 666,
        'Oslash'       => 722,
        'Oslashacute'       => 722,
        'Otcyrillic'       => 1135,
        'Otilde'       => 722,
        'Otildeacute'       => 722,
        'Otildedieresis'       => 722,
        'P'       => 611,                                         # +1
        'Pacute'       => 611,                                    # (+1)
        'Pdotaccent'       => 611,                                # (+1)
        'Peharmenian'       => 830,
        'Pemiddlehookcyrillic'       => 1016,
        'Phi'       => 761,
        'Phook'       => 662,
        'Pi'       => 722,
        'Piwrarmenian'       => 780,
        'Psi'       => 703,
        'Psicyrillic'       => 703,
        'Q'       => 722,
        'R'       => 611,                                         # +1
        'Raarmenian'       => 792,
        'Racute'       => 611,                                    # +1
        'Rcaron'       => 611,                                    # +1
        'Rcommaaccent'       => 611,                              # +1
        'Rdblgrave'       => 611,                                 # (+1)
        'Rdotaccent'       => 611,                                # (+1)
        'Rdotbelow'       => 611,                                 # (+1)
        'Rdotbelowmacron'       => 611,                           # (+1)
        'Reharmenian'       => 679,
        'Rfraktur'       => 794,
        'Rho'       => 610,
        'Rinvertedbreve'       => 611,                            # (+1)
        'Rlinebelow'       => 611,                                # (+1)
        'Rsmallinverted'       => 479,
        'Rsmallinvertedsuperior'       => 284,
        'S'       => 500,
        'SF010000'       => 708,
        'SF020000'       => 708,
        'SF030000'       => 708,
        'SF040000'       => 708,
        'SF050000'       => 708,
        'SF060000'       => 708,
        'SF070000'       => 708,
        'SF080000'       => 708,
        'SF090000'       => 708,
        'SF100000'       => 708,
        'SF110000'       => 615,
        'SF190000'       => 708,
        'SF200000'       => 708,
        'SF210000'       => 708,
        'SF220000'       => 708,
        'SF230000'       => 708,
        'SF240000'       => 708,
        'SF250000'       => 708,
        'SF260000'       => 708,
        'SF270000'       => 708,
        'SF280000'       => 708,
        'SF360000'       => 708,
        'SF370000'       => 708,
        'SF380000'       => 708,
        'SF390000'       => 708,
        'SF400000'       => 708,
        'SF410000'       => 708,
        'SF420000'       => 708,
        'SF430000'       => 708,
        'SF440000'       => 708,
        'SF450000'       => 708,
        'SF460000'       => 708,
        'SF470000'       => 708,
        'SF480000'       => 708,
        'SF490000'       => 708,
        'SF500000'       => 708,
        'SF510000'       => 708,
        'SF520000'       => 708,
        'SF530000'       => 708,
        'SF540000'       => 708,
        'Sacute'       => 500,
        'Sacutedotaccent'       => 500,
        'Sampigreek'       => 701,
        'Scaron'       => 500,
        'Scarondotaccent'       => 500,
        'Scedilla'       => 500,
        'Schwacyrillic'       => 694,
        'Schwadieresiscyrillic'       => 694,
        'Scircumflex'       => 500,
        'Scommaaccent'       => 500,
        'Sdotaccent'       => 500,
        'Sdotbelow'       => 500,
        'Sdotbelowdotaccent'       => 500,
        'Seharmenian'       => 714,
        'Sevenroman'       => 1233,
        'Shaarmenian'       => 690,
        'Sheicoptic'       => 783,
        'Shhacyrillic'       => 688,
        'Shimacoptic'       => 700,
        'Sigma'       => 594,
        'Sixroman'       => 931,
        'Stigmagreek'       => 666,
        'T'       => 556,
        'Tau'       => 556,
        'Tbar'       => 556,
        'Tcaron'       => 556,
        'Tcedilla'       => 556,
        'Tcircumflexbelow'       => 556,
        'Tcommaaccent'       => 556,
        'Tdotaccent'       => 556,
        'Tdotbelow'       => 556,
        'Tedescendercyrillic'       => 556,
        'Tenroman'       => 610,
        'Tetsecyrillic'       => 722,
        'Theta'       => 722,
        'Thook'       => 556,
        'Thorn'       => 611,                                     # +1
        'Threeroman'       => 936,
        'Tiwnarmenian'       => 647,
        'Tlinebelow'       => 556,
        'Toarmenian'       => 891,
        'Tonefive'       => 461,
        'Tonesix'       => 589,
        'Tonetwo'       => 500,
        'Tretroflexhook'       => 556,
        'Twelveroman'       => 1254,
        'Tworoman'       => 634,
        'U'       => 722,
        'Uacute'       => 722,
        'Ubreve'       => 722,
        'Ucaron'       => 722,
        'Ucircumflex'       => 722,
        'Ucircumflexbelow'       => 722,
        'Udblgrave'       => 722,
        'Udieresis'       => 722,
        'Udieresisacute'       => 722,
        'Udieresisbelow'       => 722,
        'Udieresiscaron'       => 722,
        'Udieresiscyrillic'       => 672,
        'Udieresisgrave'       => 722,
        'Udieresismacron'       => 722,
        'Udotbelow'       => 722,
        'Ugrave'       => 722,
        'Uhookabove'       => 722,
        'Uhorn'       => 753,
        'Uhornacute'       => 753,
        'Uhorndotbelow'       => 753,
        'Uhorngrave'       => 753,
        'Uhornhookabove'       => 753,
        'Uhorntilde'       => 753,
        'Uhungarumlaut'       => 722,
        'Uhungarumlautcyrillic'       => 672,
        'Uinvertedbreve'       => 722,
        'Ukcyrillic'       => 1107,
        'Umacron'       => 722,
        'Umacroncyrillic'       => 672,
        'Umacrondieresis'       => 722,
        'Uogonek'       => 722,
        'Upsilon'       => 556,
        'Upsilon1'       => 636,
        'Upsilonacutehooksymbolgreek'       => 758,
        'Upsilonafrican'       => 723,
        'Upsilondieresis'       => 556,
        'Upsilondieresishooksymbolgreek'       => 636,
        'Upsilontonos'       => 660,
        'Uring'       => 722,
        'Ustraightcyrillic'       => 556,
        'Ustraightstrokecyrillic'       => 556,
        'Utilde'       => 722,
        'Utildeacute'       => 722,
        'Utildebelow'       => 722,
        'V'       => 611,                                         # +1
        'Vdotbelow'       => 611,                                      # (+1)
        'Vewarmenian'       => 738,
        'Vhook'       => 679,
        'Voarmenian'       => 714,
        'Vtilde'       => 611,                                      # (+1)
        'W'       => 833,
        'Wacute'       => 833,
        'Wcircumflex'       => 833,
        'Wdieresis'       => 833,
        'Wdotaccent'       => 833,
        'Wdotbelow'       => 833,
        'Wgrave'       => 833,
        'X'       => 611,                                         # +1
        'Xdieresis'       => 611,                                 # (+1)
        'Xdotaccent'       => 611,                                # (+1)
        'Xeharmenian'       => 929,
        'Xi'       => 639,
        'Y'       => 556,
        'Yacute'       => 556,
        'Ycircumflex'       => 556,
        'Ydieresis'       => 556,
        'Ydotaccent'       => 556,
        'Ydotbelow'       => 556,
        'Yerudieresiscyrillic'       => 872,
        'Ygrave'       => 556,
        'Yhook'       => 576,
        'Yhookabove'       => 556,
        'Yiarmenian'       => 708,
        'Yiwnarmenian'       => 561,
        'Ytilde'       => 556,
        'Yusbigcyrillic'       => 855,
        'Yusbigiotifiedcyrillic'       => 1187,
        'Yuslittlecyrillic'       => 696,
        'Yuslittleiotifiedcyrillic'       => 1019,
        'Z'       => 556,
        'Zaarmenian'       => 720,
        'Zacute'       => 556,
        'Zcaron'       => 556,
        'Zcircumflex'       => 556,
        'Zdotaccent'       => 556,
        'Zdotbelow'       => 556,
        'Zedescendercyrillic'       => 495,
        'Zedieresiscyrillic'       => 495,
        'Zeta'       => 556,
        'Zhearmenian'       => 761,
        'Zhebrevecyrillic'       => 916,
        'Zhedescendercyrillic'       => 916,
        'Zhedieresiscyrillic'       => 916,
        'Zlinebelow'       => 556,
        'Zstroke'       => 556,
        'a'       => 500,
        'aacute'       => 500,
        'abbreviationmarkarmenian'       => 557,
        'abreve'       => 500,
        'abreveacute'       => 500,
        'abrevecyrillic'       => 500,
        'abrevedotbelow'       => 500,
        'abrevegrave'       => 500,
        'abrevehookabove'       => 500,
        'abrevetilde'       => 500,
        'acaron'       => 500,
        'acircumflex'       => 500,
        'acircumflexacute'       => 500,
        'acircumflexdotbelow'       => 500,
        'acircumflexgrave'       => 500,
        'acircumflexhookabove'       => 500,
        'acircumflextilde'       => 500,
        'acute'       => 333,
        'acutebelowcmb'       => 0,
        'acutecomb'       => 0,
        'acutelowmod'       => 333,
        'acutetonecmb'       => 0,
        'adblgrave'       => 500,
        'adieresis'       => 500,
        'adieresiscyrillic'       => 500,
        'adieresismacron'       => 500,
        'adotbelow'       => 500,
        'adotmacron'       => 500,
        'ae'       => 667,                                        # +1
        'aeacute'       => 667,                                   # (+1)
        'aemacron'       => 667,                                  # (+1)
        'afii00208'       => 1000,
        'afii10017'       => 610,
        'afii10018'       => 589,
        'afii10019'       => 610,
        'afii10020'       => 568,
        'afii10021'       => 636,
        'afii10022'       => 610,
        'afii10023'       => 610,
        'afii10024'       => 916,
        'afii10025'       => 495,
        'afii10026'       => 722,
        'afii10027'       => 722,
        'afii10028'       => 664,
        'afii10029'       => 677,
        'afii10030'       => 833,
        'afii10031'       => 722,
        'afii10032'       => 722,
        'afii10033'       => 722,
        'afii10034'       => 610,
        'afii10035'       => 666,
        'afii10036'       => 556,
        'afii10037'       => 672,
        'afii10038'       => 804,
        'afii10039'       => 610,
        'afii10040'       => 722,
        'afii10041'       => 688,
        'afii10042'       => 1042,
        'afii10043'       => 1042,
        'afii10044'       => 675,
        'afii10045'       => 872,
        'afii10046'       => 589,
        'afii10047'       => 654,
        'afii10048'       => 1032,
        'afii10049'       => 657,
        'afii10050'       => 439,
        'afii10051'       => 796,
        'afii10052'       => 568,
        'afii10053'       => 668,
        'afii10054'       => 500,
        'afii10055'       => 333,
        'afii10056'       => 333,
        'afii10057'       => 443,
        'afii10058'       => 927,
        'afii10059'       => 920,
        'afii10060'       => 798,
        'afii10061'       => 664,
        'afii10062'       => 672,
        'afii10065'       => 500,
        'afii10066'       => 502,
        'afii10067'       => 434,
        'afii10068'       => 390,
        'afii10069'       => 505,
        'afii10070'       => 443,
        'afii10071'       => 443,
        'afii10072'       => 930,
        'afii10073'       => 390,
        'afii10074'       => 500,
        'afii10075'       => 500,
        'afii10076'       => 467,
        'afii10077'       => 436,
        'afii10078'       => 638,
        'afii10079'       => 496,
        'afii10080'       => 500,
        'afii10081'       => 500,
        'afii10082'       => 500,
        'afii10083'       => 443,
        'afii10084'       => 722,
        'afii10085'       => 443,
        'afii10086'       => 709,
        'afii10087'       => 443,
        'afii10088'       => 500,
        'afii10089'       => 477,
        'afii10090'       => 754,
        'afii10091'       => 754,
        'afii10092'       => 519,
        'afii10093'       => 677,
        'afii10094'       => 455,
        'afii10095'       => 440,
        'afii10096'       => 705,
        'afii10097'       => 464,
        'afii10098'       => 314,
        'afii10099'       => 479,
        'afii10100'       => 376,
        'afii10101'       => 436,
        'afii10102'       => 389,
        'afii10103'       => 277,
        'afii10104'       => 277,
        'afii10105'       => 277,
        'afii10106'       => 679,
        'afii10107'       => 711,
        'afii10108'       => 500,
        'afii10109'       => 467,
        'afii10110'       => 443,
        'afii10145'       => 722,
        'afii10146'       => 674,
        'afii10147'       => 722,
        'afii10148'       => 669,
        'afii10193'       => 500,
        'afii10194'       => 666,
        'afii10195'       => 500,
        'afii10196'       => 555,
        'afii10846'       => 443,
        'afii299'       => 0,
        'afii300'       => 0,
        'afii301'       => 0,
        'afii57636'       => 787,
        'afii57645'       => 370,
        'afii57658'       => 333,
        'afii57664'       => 478,
        'afii57665'       => 437,
        'afii57666'       => 320,
        'afii57667'       => 417,
        'afii57668'       => 475,
        'afii57669'       => 263,
        'afii57670'       => 253,
        'afii57671'       => 470,
        'afii57672'       => 478,
        'afii57673'       => 241,
        'afii57674'       => 437,
        'afii57675'       => 410,
        'afii57676'       => 429,
        'afii57677'       => 472,
        'afii57678'       => 470,
        'afii57679'       => 255,
        'afii57680'       => 279,
        'afii57681'       => 461,
        'afii57682'       => 438,
        'afii57683'       => 430,
        'afii57684'       => 428,
        'afii57685'       => 445,
        'afii57686'       => 448,
        'afii57687'       => 444,
        'afii57688'       => 447,
        'afii57689'       => 619,
        'afii57690'       => 474,
        'afii57694'       => 619,
        'afii57695'       => 619,
        'afii57700'       => 263,
        'afii57705'       => 483,
        'afii57716'       => 527,
        'afii57717'       => 505,
        'afii57718'       => 483,
        'afii57723'       => 263,
        'afii57793'       => 0,
        'afii57794'       => 0,
        'afii57795'       => 0,
        'afii57796'       => 0,
        'afii57797'       => 0,
        'afii57798'       => 0,
        'afii57799'       => 0,
        'afii57800'       => 0,
        'afii57801'       => 0,
        'afii57802'       => 0,
        'afii57803'       => 0,
        'afii57804'       => 0,
        'afii57806'       => 0,
        'afii57807'       => 0,
        'afii57839'       => 0,
        'afii57841'       => 0,
        'afii57842'       => 333,
        'afii57929'       => 333,
        'afii61248'       => 833,
        'afii61289'       => 416,
        'afii61352'       => 942,
        'afii61573'       => 1000,
        'afii61574'       => 1000,
        'afii61575'       => 1000,
        'afii61664'       => 0,
        'afii64937'       => 333,
        'agrave'       => 500,
        'ahookabove'       => 500,
        'aiecyrillic'       => 666,
        'ainvertedbreve'       => 500,
        'alefdageshhebrew'       => 478,
        'aleflamedhebrew'       => 535,
        'alefpatahhebrew'       => 478,
        'alefqamatshebrew'       => 478,
        'aleph'       => 592,
        'alpha'       => 524,
        'alphatonos'       => 524,
        'amacron'       => 500,
        'ampersand'       => 778,                                 # +1
        'angstrom'       => 610,
        'anoteleia'       => 333,
        'aogonek'       => 500,
        'apostrophearmenian'       => 249,
        'approxequal'       => 548,
        'arighthalfring'       => 500,
        'aring'       => 500,
        'aringacute'       => 500,
        'aringbelow'       => 500,
        'arrowboth'       => 1000,
        'arrowdown'       => 500,
        'arrowheaddownmod'       => 674,
        'arrowheadleftmod'       => 674,
        'arrowheadrightmod'       => 674,
        'arrowheadupmod'       => 674,
        'arrowleft'       => 1000,
        'arrowright'       => 1000,
        'arrowup'       => 500,
        'arrowupdn'       => 500,
        'arrowupdnbse'       => 500,
        'asciicircum'       => 422,                               # +1
        'asciitilde'       => 541,
        'ascript'       => 500,
        'ascriptturned'       => 500,
        'asterisk'       => 500,
        'asterism'       => 938,
        'at'       => 920,                                        # +1
        'atilde'       => 500,
        'aturned'       => 441,
        'aybarmenian'       => 723,
        'ayinaltonehebrew'       => 438,
        'b'       => 500,
        'backslash'       => 278,                                 # +1
        'bar'       => 275,                                       # +1
        'bdotaccent'       => 500,
        'bdotbelow'       => 500,
        'benarmenian'       => 476,
        'bernou'       => 926,
        'beta'       => 498,
        'betasymbolgreek'       => 498,
        'betdagesh'       => 437,
        'beth'       => 559,
        'betrafehebrew'       => 437,
        'bhook'       => 500,
        'bilabialclick'       => 722,
        'blinebelow'       => 500,
        'block'       => 708,
        'braceleft'       => 400,                                 # +1
        'braceright'       => 400,                                # +1
        'bracketleft'       => 389,
        'bracketright'       => 389,
        'breve'       => 333,
        'brevebelowcmb'       => 0,
        'brevecmb'       => 0,
        'breveinvertedbelowcmb'       => 0,
        'breveinvertedcmb'       => 0,
        'breveinverteddoublecmb'       => 0,
        'bridgebelowcmb'       => 0,
        'bridgeinvertedbelowcmb'       => 0,
        'brokenbar'       => 275,                                 # +1
        'bstroke'       => 500,
        'btopbar'       => 500,
        'bullet'       => 350,
        'c'       => 444,                                         # +1
        'caarmenian'       => 498,
        'cacute'       => 444,                                    # +1
        'candrabinducmb'       => 0,
        'caret'       => 312,
        'caron'       => 333,
        'caronbelowcmb'       => 0,
        'caroncmb'       => 0,
        'ccaron'       => 444,                                    # +1
        'ccedilla'       => 444,                                  # +1
        'ccedillaacute'       => 444,                             # (+1)
        'ccircumflex'       => 444,                               # (+1)
        'ccurl'       => 444,                                     # (+1)
        'cdotaccent'       => 444,                                # (+1)
        'cedilla'       => 333,
        'cedillacmb'       => 0,
        'cent'       => 500,
        'centigrade'       => 980,
        'chaarmenian'       => 277,
        'cheabkhasiancyrillic'       => 546,
        'chedescenderabkhasiancyrillic'       => 546,
        'chedescendercyrillic'       => 477,
        'chedieresiscyrillic'       => 477,
        'cheharmenian'       => 478,
        'chekhakassiancyrillic'       => 477,
        'cheverticalstrokecyrillic'       => 477,
        'chi'       => 439,
        'chook'       => 444,                                     # (+1)
        'circle'       => 604,
        'circumflex'       => 333,
        'circumflexbelowcmb'       => 0,
        'circumflexcmb'       => 0,
        'clickalveolar'       => 249,
        'clickdental'       => 200,
        'clickretroflex'       => 333,
        'club'       => 656,
        'coarmenian'       => 477,
        'colon'       => 333,
        'colonmonetary'       => 666,
        'colontriangularhalfmod'       => 277,
        'colontriangularmod'       => 277,
        'comma'       => 250,
        'commaabovecmb'       => 0,
        'commaaboverightcmb'       => 0,
        'commaaccent'       => 250,
        'commaarmenian'       => 207,
        'commareversedabovecmb'       => 0,
        'commaturnedabovecmb'       => 0,
        'commaturnedmod'       => 333,
        'copyright'       => 760,                                 # +1
        'copysr'       => 759,
        'cruzeiro'       => 666,
        'cstretched'       => 441,
        'currency'       => 500,
        'd'       => 500,
        'daarmenian'       => 499,
        'dagger'       => 500,
        'daggerdbl'       => 500,
        'daletdagesh'       => 417,
        'daleth'       => 515,
        'dargahebrew'       => 0,
        'dasiapneumatacyrilliccmb'       => 0,
        'dblarchinvertedbelowcmb'       => 0,
        'dblgravecmb'       => 0,
        'dbllowlinecmb'       => 0,
        'dbloverlinecmb'       => 0,
        'dblprimemod'       => 419,
        'dblverticalbar'       => 280,
        'dblverticallineabovecmb'       => 0,
        'dcaron'       => 544,                        # use afm, was TTF 608
        'dcedilla'       => 500,
        'dcircumflexbelow'       => 500,
        'dcroat'       => 500,
        'ddotaccent'       => 500,
        'ddotbelow'       => 500,
        'degree'       => 400,                                    # +1
        'dehihebrew'       => 0,
        'deicoptic'       => 338,
        'delta'       => 464,
        'deltaturned'       => 464,
        'dezh'       => 794,
        'dhook'       => 500,
        'dialytikatonoscmb'       => 0,
        'diamond'       => 510,
        'dieresis'       => 333,
        'dieresisbelowcmb'       => 0,
        'dieresiscmb'       => 0,
        'dieresistonos'       => 333,
        'divide'       => 600,                        # afm 675, TTF 548
        'dkshade'       => 729,
        'dlinebelow'       => 500,
        'dnblock'       => 708,
        'dollar'       => 500,
        'dong'       => 512,
        'dotaccent'       => 333,
        'dotaccentcmb'       => 0,
        'dotbelowcomb'       => 0,
        'dotlessi'       => 278,                                  # +1
        'dotlessj'       => 277,
        'dotlessjstrokehook'       => 286,
        'dottedcircle'       => 594,
        'downtackbelowcmb'       => 0,
        'downtackmod'       => 333,
        'dtail'       => 500,
        'dtopbar'       => 500,
        'dz'       => 889,
        'dzaltone'       => 755,
        'dzcaron'       => 889,
        'dzcurl'       => 754,
        'dzeabkhasiancyrillic'       => 444,
        'e'       => 444,                                         # +1
        'eacute'       => 444,                                    # +1
        'ebreve'       => 444,                                    # (+1)
        'ecaron'       => 444,                                    # +1
        'ecedillabreve'       => 444,                             # (+1)
        'echarmenian'       => 488,
        'echyiwnarmenian'       => 586,
        'ecircumflex'       => 444,                               # +1
        'ecircumflexacute'       => 444,                          # (+1)
        'ecircumflexbelow'       => 444,                          # (+1)
        'ecircumflexdotbelow'       => 444,                       # (+1)
        'ecircumflexgrave'       => 444,                          # (+1)
        'ecircumflexhookabove'       => 444,                      # (+1)
        'ecircumflextilde'       => 444,                          # (+1)
        'edblgrave'       => 444,                                 # (+1)
        'edieresis'       => 444,                                 # +1
        'edotaccent'       => 444,                                # +1
        'edotbelow'       => 444,                                 # (+1)
        'egrave'       => 444,                                    # +1
        'eharmenian'       => 402,
        'ehookabove'       => 444,                                # (+1)
        'eight'       => 500,
        'eightinferior'       => 299,
        'eightroman'       => 1217,
        'eightsuperior'       => 299,
        'einvertedbreve'       => 444,                            # (+1)
        'eiotifiedcyrillic'       => 673,
        'elevenroman'       => 724,
        'ellipsis'       => 889,
        'emacron'       => 444,                                   # +1
        'emacronacute'       => 444,                              # (+1)
        'emacrongrave'       => 444,                              # (+1)
        'emdash'       => 889,
        'emphasismarkarmenian'       => 166,
        'emsp'       => 1000,
        'emsp13'       => 333,
        'emsp14'       => 250,
        'endash'       => 500,
        'endescendercyrillic'       => 496,
        'eng'       => 481,
        'enghecyrillic'       => 622,
        'enhookcyrillic'       => 496,
        'enspace'       => 500,
        'eogonek'       => 444,                                   # +1
        'eopen'       => 394,
        'eopenclosed'       => 468,
        'eopenreversed'       => 390,
        'eopenreversedclosed'       => 468,
        'eopenreversedhook'       => 550,
        'epsilon'       => 394,
        'epsilontonos'       => 394,
        'equal'       => 675,                                     # +1
        'equalsuperior'       => 299,
        'equivalence'       => 674,
        'ereversed'       => 444,                                 # (+1)
        'esdescendercyrillic'       => 443,
        'esh'       => 286,
        'eshcurl'       => 286,
        'eshreversedloop'       => 266,
        'eshsquatreversed'       => 251,
        'estimated'       => 600,
        'eta'       => 496,
        'etarmenian'       => 497,
        'etatonos'       => 496,
        'eth'       => 500,
        'etilde'       => 444,                                    # (+1)
        'etildebelow'       => 444,                               # (+1)
        'etnahtafoukhhebrew'       => 0,
        'eturned'       => 444,                                   # (+1)
        'exclam'       => 333,
        'exclamarmenian'       => 120,
        'exclamdbl'       => 572,
        'exclamdown'       => 389,
        'ezh'       => 443,
        'ezhcaron'       => 443,
        'ezhcurl'       => 443,
        'ezhreversed'       => 443,
        'ezhtail'       => 443,
        'f'       => 278,                                         # +1
        'fahrenheit'       => 900,
        'fdotaccent'       => 278,                                # (+1)
        'feharmenian'       => 682,
        'feicoptic'       => 519,
        'female'       => 750,
        'ff'       => 555,
        'ffi'       => 822,
        'ffl'       => 821,
        'fi'       => 500,
        'figuredash'       => 500,
        'filledbox'       => 604,
        'filledrect'       => 1000,
        'finalkafdagesh'       => 437,
        'five'       => 500,
        'fiveeighths'       => 750,
        'fiveinferior'       => 299,
        'fiveroman'       => 443,
        'fivesuperior'       => 299,
        'fl'       => 500,
        'florin'       => 500,
        'four'       => 500,
        'fourinferior'       => 299,
        'fourroman'       => 719,
        'foursuperior'       => 299,
        'fourthtonechinese'       => 333,
        'frac15'       => 750,
        'frac16'       => 750,
        'frac25'       => 750,
        'frac35'       => 750,
        'frac45'       => 750,
        'frac56'       => 750,
        'fraction'       => 167,                                  # +1
        'franc'       => 500,
        'g'       => 500,
        'gacute'       => 500,
        'gamma'       => 394,
        'gammad'       => 463,
        'gammalatinsmall'       => 476,
        'gammasuperior'       => 292,
        'gangiacoptic'       => 524,
        'gbreve'       => 500,
        'gcaron'       => 500,
        'gcircumflex'       => 500,
        'gcommaaccent'       => 500,
        'gdotaccent'       => 500,
        'gereshaccenthebrew'       => 0,
        'gereshhebrew'       => 190,
        'gereshmuqdamhebrew'       => 0,
        'germandbls'       => 500,
        'gershayimaccenthebrew'       => 0,
        'gershayimhebrew'       => 367,
        'ghadarmenian'       => 498,
        'ghemiddlehookcyrillic'       => 444,
        'ghestrokecyrillic'       => 390,
        'ghook'       => 500,
        'gimarmenian'       => 515,
        'gimel'       => 412,
        'gimeldagesh'       => 320,
        'glottalinvertedstroke'       => 323,
        'glottalstop'       => 411,
        'glottalstopinverted'       => 411,
        'glottalstopmod'       => 271,
        'glottalstopreversed'       => 411,
        'glottalstopreversedmod'       => 271,
        'glottalstopreversedsuperior'       => 271,
        'glottalstopstroke'       => 411,
        'glottalstopstrokereversed'       => 411,
        'gmacron'       => 500,
        'grave'       => 333,
        'gravebelowcmb'       => 0,
        'gravecomb'       => 0,
        'gravelowmod'       => 333,
        'gravetonecmb'       => 0,
        'greater'       => 675,                                   # +1
        'greaterequal'       => 549,                              # +1
        'gscript'       => 500,
        'gstroke'       => 500,
        'guillemotleft'       => 500,
        'guillemotright'       => 500,
        'guilsinglleft'       => 333,
        'guilsinglright'       => 333,
        'h'       => 500,
        'haabkhasiancyrillic'       => 443,
        'hadescendercyrillic'       => 443,
        'hairsp'       => 83,
        'hamilt'       => 905,
        'hbar'       => 500,
        'hbrevebelow'       => 500,
        'hcedilla'       => 500,
        'hcircumflex'       => 500,
        'hdieresis'       => 500,
        'hdotaccent'       => 500,
        'hdotbelow'       => 500,
        'heart'       => 593,
        'hedagesh'       => 475,
        'henghook'       => 500,
        'hhook'       => 500,
        'hhooksuperior'       => 283,
        'hlinebelow'       => 500,
        'hoarmenian'       => 487,
        'hookabovecomb'       => 0,
        'hookpalatalizedbelowcmb'       => 0,
        'hookretroflexbelowcmb'       => 0,
        'horicoptic'       => 541,
        'horncmb'       => 0,
        'house'       => 600,
        'hsuperior'       => 283,
        'hturned'       => 500,
        'hungarumlaut'       => 333,
        'hungarumlautcmb'       => 0,
        'hv'       => 756,
        'hybull'       => 333,
        'hyphen'       => 333,
        'hyphentwo'       => 333,
        'i'       => 278,                                         # +1
        'iacute'       => 278,                                    # +1
        'ibreve'       => 278,                                    # (+1)
        'icaron'       => 278,                                    # (+1)
        'icircumflex'       => 278,                               # +1
        'idblgrave'       => 278,                                 # (+1)
        'idieresis'       => 278,                                 # +1
        'idieresisacute'       => 278,                            # (+1)
        'idieresiscyrillic'       => 500,
        'idotbelow'       => 278,                                 # (+1)
        'iebrevecyrillic'       => 443,
        'igrave'       => 278,                                    # +1
        'ihookabove'       => 278,                                # (+1)
        'iinvertedbreve'       => 278,                            # (+1)
        'ij'       => 500,
        'iluyhebrew'       => 0,
        'imacron'       => 278,                                   # +1
        'imacroncyrillic'       => 500,
        'infinity'       => 712,
        'iniarmenian'       => 498,
        'integral'       => 273,
        'integralbt'       => 604,
        'integraltp'       => 604,
        'intersection'       => 722,
        'invbullet'       => 604,
        'invcircle'       => 604,
        'invsmileface'       => 1052,
        'iogonek'       => 278,                                   # +1
        'iota'       => 277,
        'iotadieresis'       => 277,
        'iotadieresistonos'       => 277,
        'iotalatin'       => 277,
        'iotatonos'       => 277,
        'istroke'       => 278,                                   # (+1)
        'itilde'       => 278,                                    # (+1)
        'itildebelow'       => 278,                               # (+1)
        'izhitsadblgravecyrillic'       => 555,
        'j'       => 278,                                         # +1
        'jaarmenian'       => 479,
        'jcaron'       => 278,                                    # (+1)
        'jcircumflex'       => 278,                               # (+1)
        'jcrossedtail'       => 278,                              # (+1)
        'jdotlessstroke'       => 278,                            # (+1)
        'jheharmenian'       => 436,
        'jsuperior'       => 164,
        'k'       => 444,                                         # +1
        'kabashkircyrillic'       => 527,
        'kacute'       => 444,                                    # (+1)
        'kadescendercyrillic'       => 467,
        'kafdagesh'       => 410,
        'kafrafehebrew'       => 410,
        'kahookcyrillic'       => 467,
        'kappa'       => 479,
        'kappasymbolgreek'       => 562,
        'kastrokecyrillic'       => 467,
        'kaverticalstrokecyrillic'       => 467,
        'kcaron'       => 444,                                    # (+1)
        'kcommaaccent'       => 444,                              # +1
        'kdotbelow'       => 444,                                 # (+1)
        'keharmenian'       => 520,
        'kenarmenian'       => 472,
        'kgreenlandic'       => 443,
        'kheicoptic'       => 436,
        'khook'       => 444,                                     # (+1)
        'klinebelow'       => 444,                                # (+1)
        'koppacyrillic'       => 443,
        'koroniscmb'       => 0,
        'ksicyrillic'       => 390,
        'kturned'       => 444,                                   # (+1)
        'l'       => 278,                                         # +1
        'lacute'       => 278,                                    # +1
        'lagran'       => 708,
        'lambda'       => 433,
        'lambdastroke'       => 433,
        'lameddagesh'       => 429,
        'lbar'       => 278,                                      # (+1)
        'lbelt'       => 278,                                     # (+1)
        'lcaron'       => 300,                        # afm, was TTF 363
        'lcircumflexbelow'       => 278,                          # (+1)
        'lcommaaccent'       => 278,                              # +1
        'ldot'       => 322,
        'ldotbelow'       => 278,                                 # (+1)
        'ldotbelowmacron'       => 278,                           # (+1)
        'leftangleabovecmb'       => 0,
        'lefttackbelowcmb'       => 0,
        'less'       => 675,                                      # +1
        'lessequal'       => 549,                                 # +1
        'lezh'       => 552,
        'lfblock'       => 708,
        'lhookretroflex'       => 278,                            # (+1)
        'lira'       => 500,
        'liwnarmenian'       => 249,
        'lj'       => 555,
        'llinebelow'       => 278,                                # (+1)
        'lmiddletilde'       => 278,                              # (+1)
        'logicalnot'       => 675,                                # +1
        'longs'       => 277,
        'lowlinecmb'       => 0,
        'lozenge'       => 494,                       # afm 471, use TTF
        'lslash'       => 278,                                    # +1
        'ltshade'       => 708,
        'm'       => 722,
        'macron'       => 493,                        # afm 333, TTF 500
        'macronbelowcmb'       => 0,
        'macroncmb'       => 0,
        'macronlowmod'       => 333,
        'macute'       => 722,
        'mahapakhhebrew'       => 0,
        'male'       => 750,
        'masoracirclehebrew'       => 0,
        'mdotaccent'       => 722,
        'mdotbelow'       => 722,
        'memdagesh'       => 470,
        'menarmenian'       => 505,
        'merkhahebrew'       => 0,
        'merkhakefulahebrew'       => 0,
        'mhook'       => 722,
        'minus'       => 675,                                     # +1
        'minusbelowcmb'       => 0,
        'minusmod'       => 333,
        'minute'       => 218,
        'mlonglegturned'       => 722,
        'mturned'       => 722,
        'mu'       => 500,                                        # -1
        'multiply'       => 675,                                  # +1
        'munahhebrew'       => 0,
        'musicalnote'       => 500,
        'musicalnotedbl'       => 750,
        'musicsharpsign'       => 500,
        'n'       => 500,
        'nacute'       => 500,
        'napostrophe'       => 577,
        'ncaron'       => 500,
        'ncircumflexbelow'       => 500,
        'ncommaaccent'       => 500,
        'ndotaccent'       => 500,
        'ndotbelow'       => 500,
        'nhookleft'       => 500,
        'nhookretroflex'       => 500,
        'nine'       => 500,
        'nineinferior'       => 299,
        'nineroman'       => 725,
        'ninesuperior'       => 299,
        'nj'       => 777,
        'nlegrightlong'       => 496,
        'nlinebelow'       => 500,
        'notequal'       => 549,                                  # +1
        'nowarmenian'       => 487,
        'nsuperior'       => 314,
        'ntilde'       => 500,
        'nu'       => 443,
        'numbersign'       => 500,
        'numeralsigngreek'       => 333,
        'numeralsignlowergreek'       => 333,
        'numsp'       => 500,
        'nundagesh'       => 279,
        'o'       => 500,
        'oacute'       => 500,
        'obarred'       => 500,
        'obarredcyrillic'       => 500,
        'obarreddieresiscyrillic'       => 500,
        'obreve'       => 500,
        'ocaron'       => 500,
        'ocircumflex'       => 500,
        'ocircumflexacute'       => 500,
        'ocircumflexdotbelow'       => 500,
        'ocircumflexgrave'       => 500,
        'ocircumflexhookabove'       => 500,
        'ocircumflextilde'       => 500,
        'odblgrave'       => 500,
        'odieresis'       => 500,
        'odieresiscyrillic'       => 500,
        'odotbelow'       => 500,
        'oe'       => 667,                                  # +1
        'ogonek'       => 333,
        'ogonekcmb'       => 0,
        'ograve'       => 500,
        'oharmenian'       => 506,
        'ohookabove'       => 500,
        'ohorn'       => 533,
        'ohornacute'       => 533,
        'ohorndotbelow'       => 533,
        'ohorngrave'       => 533,
        'ohornhookabove'       => 533,
        'ohorntilde'       => 533,
        'ohungarumlaut'       => 500,
        'oi'       => 675,
        'oinvertedbreve'       => 500,
        'olehebrew'       => 0,
        'omacron'       => 500,
        'omacronacute'       => 500,
        'omacrongrave'       => 500,
        'omega'       => 706,
        'omega1'       => 706,
        'omegacyrillic'       => 636,
        'omegalatinclosed'       => 706,
        'omegaroundcyrillic'       => 576,
        'omegatitlocyrillic'       => 807,
        'omegatonos'       => 697,
        'omicron'       => 500,
        'omicrontonos'       => 500,
        'one'       => 500,
        'onedotenleader'       => 372,
        'oneeighth'       => 750,
        'onehalf'       => 750,
        'oneinferior'       => 299,
        'onequarter'       => 750,
        'oneroman'       => 277,
        'onesuperior'       => 300,                               # +1
        'onethird'       => 750,
        'oogonek'       => 500,
        'oogonekmacron'       => 500,
        'oopen'       => 443,
        'openbullet'       => 354,
        'order'       => 405,
        'ordfeminine'       => 276,                               # +1
        'ordmasculine'       => 310,
        'orthogonal'       => 979,
        'oslash'       => 500,
        'oslashacute'       => 500,
        'otcyrillic'       => 636,
        'otilde'       => 500,
        'otildeacute'       => 500,
        'otildedieresis'       => 500,
        'overline'       => 333,
        'overlinecmb'       => 0,
        'p'       => 500,
        'pacute'       => 500,
        'palatalizationcyrilliccmb'       => 0,
        'palochkacyrillic'       => 333,
        'paragraph'       => 523,                                 # +1
        'parenleft'       => 333,
        'parenleftinferior'       => 199,
        'parenleftsuperior'       => 199,
        'parenright'       => 333,
        'parenrightinferior'       => 199,
        'parenrightsuperior'       => 199,
        'partialdiff'       => 494,                   # afm 476, use TTF
        'pashtahebrew'       => 0,
        'pazerhebrew'       => 0,
        'pdotaccent'       => 500,
        'pedagesh'       => 428,
        'pefinaldageshhebrew'       => 430,
        'peharmenian'       => 713,
        'pemiddlehookcyrillic'       => 690,
        'perafehebrew'       => 428,
        'percent'       => 833,
        'period'       => 250,
        'periodarmenian'       => 277,
        'periodcentered'       => 250,
        'perispomenigreekcmb'       => 0,
        'perthousand'       => 1000,
        'peseta'       => 989,
        'phi'       => 553,
        'phi1'       => 517,
        'philatin'       => 541,
        'phmmat'       => 1115,
        'phook'       => 500,
        'pi'       => 500,
        'piwrarmenian'       => 721,
        'planck'       => 500,
        'plus'       => 675,                                      # +1
        'plusbelowcmb'       => 0,
        'plusminus'       => 565,                     # afm 675, was 548
        'plusmod'       => 333,
        'plussuperior'       => 299,
        'prescription'       => 666,
        'primemod'       => 213,
        'primereversed'       => 218,
        'product'       => 823,
        'psi'       => 621,
        'psicyrillic'       => 621,
        'psilipneumatacyrilliccmb'       => 0,
        'puncsp'       => 250,
        'q'       => 500,
        'qadmahebrew'       => 0,
        'qarneyparahebrew'       => 0,
        'qhook'       => 500,
        'qofdagesh'       => 444,
        'question'       => 500,
        'questionarmenian'       => 231,
        'questiondown'       => 500,
        'questiongreek'       => 333,
        'quotedbl'       => 420,                                  # +1
        'quotedblbase'       => 556,
        'quotedblleft'       => 556,
        'quotedblright'       => 556,
        'quoteleft'       => 333,
        'quotereversed'       => 333,
        'quoteright'       => 333,
        'quotesinglbase'       => 333,
        'quotesingle'       => 214,                               # +1
        'r'       => 389,
        'raarmenian'       => 527,
        'racute'       => 389,
        'radical'       => 453,                       # use afm, was TTF 548
        'ramshorn'       => 456,
        'rcaron'       => 389,
        'rcommaaccent'       => 389,
        'rdblgrave'       => 389,
        'rdotaccent'       => 389,
        'rdotbelow'       => 389,
        'rdotbelowmacron'       => 389,
        'referencemark'       => 1000,
        'registered'       => 760,                                # +1
        'reharmenian'       => 497,
        'reshdageshhebrew'       => 447,
        'reviahebrew'       => 0,
        'revlogicalnot'       => 674,
        'rfishhook'       => 358,
        'rfishhookreversed'       => 358,
        'rho'       => 479,
        'rhook'       => 389,
        'rhookturned'       => 389,
        'rhookturnedsuperior'       => 222,
        'rhosymbolgreek'       => 507,
        'rhotichookmod'       => 333,
        'righttackbelowcmb'       => 0,
        'ring'       => 333,
        'ringbelowcmb'       => 0,
        'ringcmb'       => 0,
        'ringhalfleft'       => 333,
        'ringhalfleftarmenian'       => 199,
        'ringhalfleftbelowcmb'       => 0,
        'ringhalfleftcentered'       => 333,
        'ringhalfright'       => 333,
        'ringhalfrightbelowcmb'       => 0,
        'ringhalfrightcentered'       => 333,
        'rinvertedbreve'       => 389,
        'rlinebelow'       => 389,
        'rlongleg'       => 389,
        'rlonglegturned'       => 389,
        'rtblock'       => 708,
        'rturned'       => 389,
        'rturnedsuperior'       => 222,
        's'       => 389,
        'sacute'       => 389,
        'sacutedotaccent'       => 389,
        'samekhdagesh'       => 461,
        'scaron'       => 389,
        'scarondotaccent'       => 389,
        'scedilla'       => 389,
        'schwadieresiscyrillic'       => 443,
        'schwahook'       => 592,
        'scircumflex'       => 389,
        'scommaaccent'       => 389,
        'sdotaccent'       => 389,
        'sdotbelow'       => 389,
        'sdotbelowdotaccent'       => 389,
        'seagullbelowcmb'       => 0,
        'second'       => 416,
        'secondtonechinese'       => 333,
        'section'       => 500,
        'segoltahebrew'       => 0,
        'seharmenian'       => 497,
        'semicolon'       => '333',
        'seven'       => 500,
        'seveneighths'       => 750,
        'seveninferior'       => 299,
        'sevenroman'       => 971,
        'sevensuperior'       => 299,
        'shaarmenian'       => 363,
        'shade'       => 708,
        'shalshelethebrew'       => 0,
        'sheicoptic'       => 722,
        'shhacyrillic'       => 500,
        'shimacoptic'       => 494,
        'shindagesh'       => 619,
        'shindageshshindot'       => 619,
        'shindageshsindot'       => 619,
        'shook'       => 389,
        'sigma'       => 493,
        'sigma1'       => 405,
        'sigmalunatesymbolgreek'       => 445,
        'six'       => 500,
        'sixinferior'       => 299,
        'sixroman'       => 724,
        'sixsuperior'       => 299,
        'slash'       => 278,                                     # +1
        'slongdotaccent'       => 277,
        'smileface'       => 1020,
        'soliduslongoverlaycmb'       => 0,
        'solidusshortoverlaycmb'       => 0,
        'space'       => 250,
        'spade'       => 531,
        'squarebelowcmb'       => 0,
        'sterling'       => 500,
        'strokelongoverlaycmb'       => 0,
        'strokeshortoverlaycmb'       => 0,
        'summation'       => 712,                     # afm 600 too narrow
        'sun'       => 916,
        't'       => 278,                                         # +1
        'tau'       => 357,
        'tavdages'       => 474,
        'tbar'       => 278,
        'tcaron'       => 300,                        # use afm, was TTF 363
        'tccurl'       => 639,
        'tcedilla'       => 278,                                  # (+1)
        'tcircumflexbelow'       => 278,                          # (+1)
        'tcommaaccent'       => 278,                              # +1
        'tdieresis'       => 278,                                 # (+1)
        'tdotaccent'       => 278,                                # (+1)
        'tdotbelow'       => 278,                                 # (+1)
        'tedescendercyrillic'       => 722,
        'telephone'       => 1059,
        'telishagedolahebrew'       => 0,
        'telishaqetanahebrew'       => 0,
        'tenroman'       => 443,
        'tesh'       => 447,
        'tetdagesh'       => 478,
        'tetsecyrillic'       => 500,
        'tevirhebrew'       => 0,
        'theta'       => 491,
        'theta1'       => 490,
        'thook'       => 278,                                    # (+1)
        'thorn'       => 500,
        'thousandcyrillic'       => 279,
        'three'       => 500,
        'threeeighths'       => 750,
        'threeinferior'       => 299,
        'threequarters'       => 750,
        'threeroman'       => 770,
        'threesuperior'       => 300,                             # +1
        'tilde'       => 333,
        'tildebelowcmb'       => 0,
        'tildecomb'       => 0,
        'tildedoublecmb'       => 0,
        'tildeoverlaycmb'       => 0,
        'tildeverticalcmb'       => 0,
        'tipehahebrew'       => 0,
        'titlocyrilliccmb'       => 0,
        'tiwnarmenian'       => 734,
        'tlinebelow'       => 278,                                # (+1)
        'toarmenian'       => 635,
        'tonebarextrahighmod'       => 382,
        'tonebarextralowmod'       => 382,
        'tonebarhighmod'       => 382,
        'tonebarlowmod'       => 382,
        'tonebarmidmod'       => 382,
        'tonefive'       => 383,
        'tonesix'       => 500,
        'tonetwo'       => 389,
        'tonos'       => 333,
        'tpalatalhook'       => 278,                              # (+1)
        'tprime'       => 419,
        'trademark'       => 980,                                 # +1
        'tretroflexhook'       => 278,                            # (+1)
        'triagdn'       => 989,
        'triaglf'       => 989,
        'triagrt'       => 989,
        'triagup'       => 989,
        'ts'       => 560,
        'tsadidagesh'       => 448,
        'tturned'       => 278,                                   # (+1)
        'twelveroman'       => 970,
        'two'       => 500,
        'twodotenleader'       => 630,
        'twoinferior'       => 299,
        'tworoman'       => 524,
        'twostroke'       => 500,
        'twosuperior'       => 300,                               # +1
        'twothirds'       => 750,
        'u'       => 500,
        'uacute'       => 500,
        'ubar'       => 500,
        'ubreve'       => 500,
        'ucaron'       => 500,
        'ucircumflex'       => 500,
        'ucircumflexbelow'       => 500,
        'udblgrave'       => 500,
        'udieresis'       => 500,
        'udieresisacute'       => 500,
        'udieresisbelow'       => 500,
        'udieresiscaron'       => 500,
        'udieresiscyrillic'       => 443,
        'udieresisgrave'       => 500,
        'udieresismacron'       => 500,
        'udotbelow'       => 500,
        'ugrave'       => 500,
        'uhookabove'       => 500,
        'uhorn'       => 545,
        'uhornacute'       => 545,
        'uhorndotbelow'       => 545,
        'uhorngrave'       => 545,
        'uhornhookabove'       => 545,
        'uhorntilde'       => 545,
        'uhungarumlaut'       => 500,
        'uhungarumlautcyrillic'       => 443,
        'uinvertedbreve'       => 500,
        'ukcyrillic'       => 888,
        'umacron'       => 500,
        'umacroncyrillic'       => 443,
        'umacrondieresis'       => 500,
        'underscore'       => 500,
        'underscoredbl'       => 500,
        'uni01F6'       => 947,
        'uni01F7'       => 597,
        'uni01F8'       => 666,
        'uni01F9'       => 500,
        'uni021C'       => 618,
        'uni021D'       => 391,
        'uni021E'       => 722,
        'uni021F'       => 500,
        'uni0220'       => 659,
        'uni0221'       => 500,
        'uni0222'       => 611,
        'uni0223'       => 539,
        'uni0224'       => 556,
        'uni0225'       => 389,
        'uni0226'       => 610,
        'uni0227'       => 500,
        'uni0228'       => 610,
        'uni0229'       => 443,
        'uni022A'       => 722,
        'uni022B'       => 500,
        'uni022C'       => 722,
        'uni022D'       => 500,
        'uni022E'       => 722,
        'uni022F'       => 500,
        'uni0230'       => 722,
        'uni0231'       => 500,
        'uni0232'       => 556,
        'uni0233'       => 443,
        'uni0234'       => 277,
        'uni0235'       => 500,
        'uni0236'       => 277,
        'uni0238'       => 752,
        'uni0239'       => 753,
        'uni023A'       => 610,
        'uni023B'       => 666,
        'uni023C'       => 500,
        'uni023D'       => 556,
        'uni023E'       => 556,
        'uni023F'       => 389,
        'uni0240'       => 389,
        'uni0241'       => 486,
        'uni0242'       => 436,
        'uni0243'       => 610,
        'uni0244'       => 722,
        'uni0245'       => 604,
        'uni0246'       => 610,
        'uni0247'       => 443,
        'uni0248'       => 443,
        'uni0249'       => 277,
        'uni024A'       => 708,
        'uni024B'       => 500,
        'uni024C'       => 610,
        'uni024D'       => 389,
        'uni024E'       => 556,
        'uni024F'       => 443,
        'uni0262'       => 494,
        'uni026A'       => 268,
        'uni0274'       => 507,
        'uni0276'       => 673,
        'uni0280'       => 444,
        'uni028F'       => 377,
        'uni0299'       => 429,
        'uni029C'       => 511,
        'uni029F'       => 389,
        'uni02A9'       => 726,
        'uni02AA'       => 544,
        'uni02AB'       => 512,
        'uni02AC'       => 514,
        'uni02AD'       => 480,
        'uni02AE'       => 536,
        'uni02AF'       => 536,
        'uni02B3'       => 222,
        'uni02DF'       => 381,
        'uni02E1'       => 136,
        'uni02E2'       => 210,
        'uni02EA'       => 333,
        'uni02EB'       => 333,
        'uni02EC'       => 333,
        'uni02ED'       => 333,
        'uni02EE'       => 556,
        'uni02EF'       => 333,
        'uni02F0'       => 333,
        'uni02F1'       => 333,
        'uni02F2'       => 333,
        'uni02F3'       => 333,
        'uni02F4'       => 333,
        'uni02F5'       => 333,
        'uni02F6'       => 333,
        'uni02F7'       => 333,
        'uni02F8'       => 333,
        'uni02F9'       => 333,
        'uni02FA'       => 333,
        'uni02FB'       => 333,
        'uni02FC'       => 333,
        'uni02FD'       => 397,
        'uni02FE'       => 397,
        'uni02FF'       => 333,
        'uni0326'       => 0,
        'uni0346'       => 0,
        'uni0347'       => 0,
        'uni0348'       => 0,
        'uni0349'       => 0,
        'uni034A'       => 0,
        'uni034B'       => 0,
        'uni034C'       => 0,
        'uni034D'       => 0,
        'uni034E'       => 0,
        'uni034F'       => 0,
        'uni0350'       => 0,
        'uni0351'       => 0,
        'uni0352'       => 0,
        'uni0353'       => 0,
        'uni0354'       => 0,
        'uni0355'       => 0,
        'uni0356'       => 0,
        'uni0357'       => 0,
        'uni0358'       => 0,
        'uni0359'       => 0,
        'uni035A'       => 0,
        'uni035B'       => 0,
        'uni035C'       => 0,
        'uni035D'       => 0,
        'uni035E'       => 0,
        'uni035F'       => 0,
        'uni0362'       => 0,
        'uni0363'       => 0,
        'uni0364'       => 0,
        'uni0365'       => 0,
        'uni0366'       => 0,
        'uni0367'       => 0,
        'uni0368'       => 0,
        'uni0369'       => 0,
        'uni036A'       => 0,
        'uni036B'       => 0,
        'uni036C'       => 0,
        'uni036D'       => 0,
        'uni036E'       => 0,
        'uni036F'       => 0,
        'uni0370'       => 519,
        'uni0371'       => 388,
        'uni0372'       => 556,
        'uni0373'       => 517,
        'uni0376'       => 722,
        'uni0377'       => 531,
        'uni037B'       => 445,
        'uni037C'       => 445,
        'uni037D'       => 445,
        'uni037F'       => 443,
        'uni03CF'       => 647,
        'uni03D7'       => 562,
        'uni03D8'       => 722,
        'uni03D9'       => 500,
        'uni03DB'       => 444,
        'uni03DF'       => 451,
        'uni03E1'       => 521,
        'uni03F4'       => 722,
        'uni03F5'       => 402,
        'uni03F6'       => 402,
        'uni03F7'       => 610,
        'uni03F8'       => 500,
        'uni03F9'       => 666,
        'uni03FA'       => 833,
        'uni03FB'       => 599,
        'uni03FC'       => 479,
        'uni03FD'       => 666,
        'uni03FE'       => 666,
        'uni03FF'       => 666,
        'uni0400'       => 610,
        'uni040D'       => 722,
        'uni0450'       => 443,
        'uni045D'       => 500,
        'uni0487'       => 0,
        'uni0488'       => 0,
        'uni0489'       => 0,
        'uni048A'       => 722,
        'uni048B'       => 500,
        'uni048C'       => 589,
        'uni048D'       => 455,
        'uni048E'       => 610,
        'uni048F'       => 500,
        'uni04C5'       => 677,
        'uni04C6'       => 436,
        'uni04C9'       => 722,
        'uni04CA'       => 496,
        'uni04CD'       => 833,
        'uni04CE'       => 638,
        'uni04CF'       => 277,
        'uni04EC'       => 654,
        'uni04ED'       => 440,
        'uni04F6'       => 568,
        'uni04F7'       => 390,
        'uni04FA'       => 568,
        'uni04FB'       => 390,
        'uni04FC'       => 610,
        'uni04FD'       => 443,
        'uni04FE'       => 610,
        'uni04FF'       => 443,
        'uni0500'       => 589,
        'uni0501'       => 500,
        'uni0502'       => 801,
        'uni0503'       => 704,
        'uni0504'       => 776,
        'uni0505'       => 646,
        'uni0506'       => 519,
        'uni0507'       => 390,
        'uni0508'       => 903,
        'uni0509'       => 643,
        'uni050A'       => 947,
        'uni050B'       => 695,
        'uni050C'       => 722,
        'uni050D'       => 494,
        'uni050E'       => 678,
        'uni050F'       => 918,
        'uni0510'       => 495,
        'uni0511'       => 436,
        'uni0512'       => 677,
        'uni0513'       => 436,
        'uni0514'       => 981,
        'uni0515'       => 665,
        'uni0516'       => 912,
        'uni0517'       => 694,
        'uni0518'       => 937,
        'uni0519'       => 695,
        'uni051A'       => 722,
        'uni051B'       => 500,
        'uni051C'       => 833,
        'uni051D'       => 666,
        'uni051E'       => 666,
        'uni051F'       => 479,
        'uni0520'       => 993,
        'uni0521'       => 626,
        'uni0522'       => 1037,
        'uni0523'       => 683,
        'uni0524'       => 722,
        'uni0525'       => 500,
        'uni0526'       => 688,
        'uni0527'       => 500,
        'uni0528'       => 722,
        'uni0529'       => 496,
        'uni052A'       => 1277,
        'uni052B'       => 1032,
        'uni052C'       => 698,
        'uni052D'       => 509,
        'uni052E'       => 677,
        'uni052F'       => 436,
        'uni058A'       => 369,
        'uni058D'       => 934,
        'uni058E'       => 934,
        'uni058F'       => 760,
        'uni05A2'       => 0,
        'uni05BA'       => 0,
        'uni05C5'       => 0,
        'uni05C6'       => 304,
        'uni05C7'       => 0,
        'uni1D00'       => 398,
        'uni1D01'       => 570,
        'uni1D02'       => 666,
        'uni1D03'       => 407,
        'uni1D04'       => 451,
        'uni1D05'       => 508,
        'uni1D06'       => 508,
        'uni1D07'       => 390,
        'uni1D08'       => 390,
        'uni1D09'       => 277,
        'uni1D0A'       => 378,
        'uni1D0B'       => 458,
        'uni1D0C'       => 399,
        'uni1D0D'       => 599,
        'uni1D0E'       => 505,
        'uni1D0F'       => 500,
        'uni1D10'       => 472,
        'uni1D11'       => 520,
        'uni1D12'       => 520,
        'uni1D13'       => 573,
        'uni1D14'       => 666,
        'uni1D15'       => 439,
        'uni1D16'       => 491,
        'uni1D17'       => 491,
        'uni1D18'       => 409,
        'uni1D19'       => 491,
        'uni1D1A'       => 401,
        'uni1D1B'       => 379,
        'uni1D1C'       => 490,
        'uni1D1D'       => 555,
        'uni1D1E'       => 686,
        'uni1D1F'       => 616,
        'uni1D20'       => 420,
        'uni1D21'       => 577,
        'uni1D22'       => 401,
        'uni1D23'       => 352,
        'uni1D24'       => 401,
        'uni1D25'       => 549,
        'uni1D26'       => 396,
        'uni1D27'       => 398,
        'uni1D28'       => 501,
        'uni1D29'       => 409,
        'uni1D2A'       => 495,
        'uni1D2B'       => 454,
        'uni1D2C'       => 416,
        'uni1D2D'       => 572,
        'uni1D2E'       => 419,
        'uni1D2F'       => 418,
        'uni1D30'       => 479,
        'uni1D31'       => 406,
        'uni1D32'       => 406,
        'uni1D33'       => 455,
        'uni1D34'       => 356,
        'uni1D35'       => 261,
        'uni1D36'       => 340,
        'uni1D37'       => 493,
        'uni1D38'       => 399,
        'uni1D39'       => 566,
        'uni1D3A'       => 458,
        'uni1D3B'       => 493,
        'uni1D3C'       => 475,
        'uni1D3D'       => 336,
        'uni1D3E'       => 390,
        'uni1D3F'       => 435,
        'uni1D40'       => 386,
        'uni1D41'       => 499,
        'uni1D42'       => 567,
        'uni1D43'       => 398,
        'uni1D44'       => 398,
        'uni1D45'       => 398,
        'uni1D46'       => 394,
        'uni1D47'       => 269,
        'uni1D48'       => 310,
        'uni1D49'       => 262,
        'uni1D4A'       => 262,
        'uni1D4B'       => 236,
        'uni1D4C'       => 236,
        'uni1D4D'       => 285,
        'uni1D4E'       => 158,
        'uni1D4F'       => 281,
        'uni1D50'       => 416,
        'uni1D51'       => 270,
        'uni1D52'       => 285,
        'uni1D53'       => 259,
        'uni1D54'       => 285,
        'uni1D55'       => 285,
        'uni1D56'       => 282,
        'uni1D57'       => 167,
        'uni1D58'       => 292,
        'uni1D59'       => 317,
        'uni1D5A'       => 430,
        'uni1D5B'       => 279,
        'uni1D5C'       => 355,
        'uni1D5D'       => 284,
        'uni1D5E'       => 230,
        'uni1D5F'       => 278,
        'uni1D60'       => 305,
        'uni1D61'       => 269,
        'uni1D62'       => 158,
        'uni1D63'       => 246,
        'uni1D64'       => 292,
        'uni1D65'       => 279,
        'uni1D66'       => 284,
        'uni1D67'       => 230,
        'uni1D68'       => 284,
        'uni1D69'       => 305,
        'uni1D6A'       => 269,
        'uni1D6B'       => 726,
        'uni1D6C'       => 500,
        'uni1D6D'       => 500,
        'uni1D6E'       => 277,
        'uni1D6F'       => 722,
        'uni1D70'       => 500,
        'uni1D71'       => 500,
        'uni1D72'       => 389,
        'uni1D73'       => 358,
        'uni1D74'       => 389,
        'uni1D75'       => 277,
        'uni1D76'       => 389,
        'uni1D77'       => 500,
        'uni1D78'       => 292,
        'uni1D79'       => 471,
        'uni1D7A'       => 700,
        'uni1D7B'       => 268,
        'uni1D7C'       => 277,
        'uni1D7D'       => 500,
        'uni1D7E'       => 490,
        'uni1D7F'       => 520,
        'uni1D80'       => 500,
        'uni1D81'       => 500,
        'uni1D82'       => 354,
        'uni1D83'       => 591,
        'uni1D84'       => 443,
        'uni1D85'       => 277,
        'uni1D86'       => 722,
        'uni1D87'       => 500,
        'uni1D88'       => 500,
        'uni1D89'       => 389,
        'uni1D8A'       => 389,
        'uni1D8B'       => 352,
        'uni1D8C'       => 443,
        'uni1D8D'       => 443,
        'uni1D8E'       => 389,
        'uni1D8F'       => 500,
        'uni1D90'       => 500,
        'uni1D91'       => 500,
        'uni1D92'       => 443,
        'uni1D93'       => 394,
        'uni1D94'       => 390,
        'uni1D95'       => 443,
        'uni1D96'       => 277,
        'uni1D97'       => 443,
        'uni1D98'       => 286,
        'uni1D99'       => 500,
        'uni1D9A'       => 443,
        'uni1D9B'       => 398,
        'uni1D9C'       => 262,
        'uni1D9D'       => 262,
        'uni1D9E'       => 290,
        'uni1D9F'       => 236,
        'uni1DA0'       => 173,
        'uni1DA1'       => 173,
        'uni1DA2'       => 316,
        'uni1DA3'       => 292,
        'uni1DA4'       => 158,
        'uni1DA5'       => 158,
        'uni1DA6'       => 158,
        'uni1DA7'       => 158,
        'uni1DA8'       => 158,
        'uni1DA9'       => 158,
        'uni1DAA'       => 158,
        'uni1DAB'       => 221,
        'uni1DAC'       => 395,
        'uni1DAD'       => 395,
        'uni1DAE'       => 270,
        'uni1DAF'       => 270,
        'uni1DB0'       => 270,
        'uni1DB1'       => 285,
        'uni1DB2'       => 310,
        'uni1DB3'       => 226,
        'uni1DB4'       => 173,
        'uni1DB5'       => 167,
        'uni1DB6'       => 292,
        'uni1DB7'       => 297,
        'uni1DB8'       => 292,
        'uni1DB9'       => 292,
        'uni1DBA'       => 279,
        'uni1DBB'       => 241,
        'uni1DBC'       => 241,
        'uni1DBD'       => 263,
        'uni1DBE'       => 241,
        'uni1DBF'       => 285,
        'uni1DC0'       => 0,
        'uni1DC1'       => 0,
        'uni1DC2'       => 0,
        'uni1DC3'       => 0,
        'uni1DC4'       => 0,
        'uni1DC5'       => 0,
        'uni1DC6'       => 0,
        'uni1DC7'       => 0,
        'uni1DC8'       => 0,
        'uni1DC9'       => 0,
        'uni1DCA'       => 0,
        'uni1DFE'       => 0,
        'uni1DFF'       => 0,
        'uni1E9C'       => 277,
        'uni1E9D'       => 277,
        'uni1E9E'       => 684,
        'uni1E9F'       => 464,
        'uni1EFA'       => 816,
        'uni1EFB'       => 527,
        'uni1EFC'       => 552,
        'uni1EFD'       => 459,
        'uni1EFE'       => 623,
        'uni1EFF'       => 466,
        'uni1F00'       => 524,
        'uni1F01'       => 524,
        'uni1F02'       => 524,
        'uni1F03'       => 524,
        'uni1F04'       => 524,
        'uni1F05'       => 524,
        'uni1F06'       => 524,
        'uni1F07'       => 524,
        'uni1F08'       => 610,
        'uni1F09'       => 610,
        'uni1F0A'       => 659,
        'uni1F0B'       => 659,
        'uni1F0C'       => 610,
        'uni1F0D'       => 610,
        'uni1F0E'       => 610,
        'uni1F0F'       => 610,
        'uni1F10'       => 394,
        'uni1F11'       => 394,
        'uni1F12'       => 394,
        'uni1F13'       => 394,
        'uni1F14'       => 394,
        'uni1F15'       => 394,
        'uni1F18'       => 708,
        'uni1F19'       => 708,
        'uni1F1A'       => 854,
        'uni1F1B'       => 854,
        'uni1F1C'       => 854,
        'uni1F1D'       => 854,
        'uni1F20'       => 496,
        'uni1F21'       => 496,
        'uni1F22'       => 496,
        'uni1F23'       => 496,
        'uni1F24'       => 496,
        'uni1F25'       => 496,
        'uni1F26'       => 496,
        'uni1F27'       => 496,
        'uni1F28'       => 819,
        'uni1F29'       => 819,
        'uni1F2A'       => 966,
        'uni1F2B'       => 966,
        'uni1F2C'       => 966,
        'uni1F2D'       => 966,
        'uni1F2E'       => 966,
        'uni1F2F'       => 966,
        'uni1F30'       => 277,
        'uni1F31'       => 277,
        'uni1F32'       => 277,
        'uni1F33'       => 277,
        'uni1F34'       => 277,
        'uni1F35'       => 277,
        'uni1F36'       => 277,
        'uni1F37'       => 277,
        'uni1F38'       => 430,
        'uni1F39'       => 430,
        'uni1F3A'       => 577,
        'uni1F3B'       => 577,
        'uni1F3C'       => 577,
        'uni1F3D'       => 577,
        'uni1F3E'       => 577,
        'uni1F3F'       => 577,
        'uni1F40'       => 500,
        'uni1F41'       => 500,
        'uni1F42'       => 500,
        'uni1F43'       => 500,
        'uni1F44'       => 500,
        'uni1F45'       => 500,
        'uni1F48'       => 819,
        'uni1F49'       => 819,
        'uni1F4A'       => 966,
        'uni1F4B'       => 966,
        'uni1F4C'       => 868,
        'uni1F4D'       => 868,
        'uni1F50'       => 458,
        'uni1F51'       => 458,
        'uni1F52'       => 458,
        'uni1F53'       => 458,
        'uni1F54'       => 458,
        'uni1F55'       => 458,
        'uni1F56'       => 458,
        'uni1F57'       => 458,
        'uni1F59'       => 653,
        'uni1F5B'       => 849,
        'uni1F5D'       => 849,
        'uni1F5F'       => 849,
        'uni1F60'       => 706,
        'uni1F61'       => 706,
        'uni1F62'       => 706,
        'uni1F63'       => 706,
        'uni1F64'       => 706,
        'uni1F65'       => 706,
        'uni1F66'       => 706,
        'uni1F67'       => 706,
        'uni1F68'       => 820,
        'uni1F69'       => 820,
        'uni1F6A'       => 967,
        'uni1F6B'       => 967,
        'uni1F6C'       => 869,
        'uni1F6D'       => 869,
        'uni1F6E'       => 869,
        'uni1F6F'       => 869,
        'uni1F70'       => 524,
        'uni1F71'       => 524,
        'uni1F72'       => 394,
        'uni1F73'       => 394,
        'uni1F74'       => 496,
        'uni1F75'       => 496,
        'uni1F76'       => 277,
        'uni1F77'       => 277,
        'uni1F78'       => 500,
        'uni1F79'       => 500,
        'uni1F7A'       => 458,
        'uni1F7B'       => 458,
        'uni1F7C'       => 706,
        'uni1F7D'       => 706,
        'uni1F80'       => 524,
        'uni1F81'       => 524,
        'uni1F82'       => 524,
        'uni1F83'       => 524,
        'uni1F84'       => 524,
        'uni1F85'       => 524,
        'uni1F86'       => 524,
        'uni1F87'       => 524,
        'uni1F88'       => 610,
        'uni1F89'       => 610,
        'uni1F8A'       => 659,
        'uni1F8B'       => 659,
        'uni1F8C'       => 610,
        'uni1F8D'       => 610,
        'uni1F8E'       => 610,
        'uni1F8F'       => 610,
        'uni1F90'       => 496,
        'uni1F91'       => 496,
        'uni1F92'       => 496,
        'uni1F93'       => 496,
        'uni1F94'       => 496,
        'uni1F95'       => 496,
        'uni1F96'       => 496,
        'uni1F97'       => 496,
        'uni1F98'       => 819,
        'uni1F99'       => 819,
        'uni1F9A'       => 966,
        'uni1F9B'       => 966,
        'uni1F9C'       => 966,
        'uni1F9D'       => 966,
        'uni1F9E'       => 966,
        'uni1F9F'       => 966,
        'uni1FA0'       => 706,
        'uni1FA1'       => 706,
        'uni1FA2'       => 706,
        'uni1FA3'       => 706,
        'uni1FA4'       => 706,
        'uni1FA5'       => 706,
        'uni1FA6'       => 706,
        'uni1FA7'       => 706,
        'uni1FA8'       => 820,
        'uni1FA9'       => 820,
        'uni1FAA'       => 967,
        'uni1FAB'       => 967,
        'uni1FAC'       => 869,
        'uni1FAD'       => 869,
        'uni1FAE'       => 869,
        'uni1FAF'       => 869,
        'uni1FB0'       => 524,
        'uni1FB1'       => 524,
        'uni1FB2'       => 524,
        'uni1FB3'       => 524,
        'uni1FB4'       => 524,
        'uni1FB6'       => 524,
        'uni1FB7'       => 524,
        'uni1FB8'       => 610,
        'uni1FB9'       => 610,
        'uni1FBA'       => 610,
        'uni1FBB'       => 610,
        'uni1FBC'       => 610,
        'uni1FBD'       => 333,
        'uni1FBE'       => 333,
        'uni1FBF'       => 333,
        'uni1FC0'       => 333,
        'uni1FC1'       => 333,
        'uni1FC2'       => 496,
        'uni1FC3'       => 496,
        'uni1FC4'       => 496,
        'uni1FC6'       => 496,
        'uni1FC7'       => 496,
        'uni1FC8'       => 757,
        'uni1FC9'       => 757,
        'uni1FCA'       => 868,
        'uni1FCB'       => 868,
        'uni1FCC'       => 722,
        'uni1FCD'       => 333,
        'uni1FCE'       => 333,
        'uni1FCF'       => 333,
        'uni1FD0'       => 277,
        'uni1FD1'       => 277,
        'uni1FD2'       => 277,
        'uni1FD3'       => 277,
        'uni1FD6'       => 277,
        'uni1FD7'       => 277,
        'uni1FD8'       => 333,
        'uni1FD9'       => 333,
        'uni1FDA'       => 479,
        'uni1FDB'       => 479,
        'uni1FDD'       => 333,
        'uni1FDE'       => 333,
        'uni1FDF'       => 333,
        'uni1FE0'       => 458,
        'uni1FE1'       => 458,
        'uni1FE2'       => 458,
        'uni1FE3'       => 458,
        'uni1FE4'       => 479,
        'uni1FE5'       => 479,
        'uni1FE6'       => 458,
        'uni1FE7'       => 458,
        'uni1FE8'       => 556,
        'uni1FE9'       => 556,
        'uni1FEA'       => 751,
        'uni1FEB'       => 751,
        'uni1FEC'       => 708,
        'uni1FED'       => 333,
        'uni1FEE'       => 333,
        'uni1FEF'       => 333,
        'uni1FF2'       => 706,
        'uni1FF3'       => 706,
        'uni1FF4'       => 706,
        'uni1FF6'       => 706,
        'uni1FF7'       => 706,
        'uni1FF8'       => 868,
        'uni1FF9'       => 722,
        'uni1FFA'       => 869,
        'uni1FFB'       => 723,
        'uni1FFC'       => 723,
        'uni1FFD'       => 333,
        'uni1FFE'       => 333,
        'uni2000'       => 500,
        'uni2001'       => 1000,
        'uni2006'       => 166,
        'uni2011'       => 333,
        'uni201F'       => 556,
        'uni2023'       => 350,
        'uni2027'       => 250,
        'uni2028'       => 1000,
        'uni2029'       => 1000,
        'uni202A'       => 1000,
        'uni202B'       => 1000,
        'uni202F'       => 200,
        'uni2031'       => 1340,
        'uni2036'       => 416,
        'uni2037'       => 419,
        'uni2038'       => 312,
        'uni203D'       => 500,
        'uni203F'       => 956,
        'uni2040'       => 956,
        'uni2045'       => 389,
        'uni2046'       => 389,
        'uni2047'       => 851,
        'uni2048'       => 674,
        'uni2049'       => 763,
        'uni204A'       => 500,
        'uni204B'       => 522,
        'uni204C'       => 453,
        'uni204D'       => 453,
        'uni204E'       => 500,
        'uni204F'       => 297,
        'uni2050'       => 956,
        'uni2051'       => 500,
        'uni2052'       => 500,
        'uni2053'       => 541,
        'uni2054'       => 956,
        'uni2055'       => 500,
        'uni2056'       => 500,
        'uni2057'       => 564,
        'uni2058'       => 615,
        'uni2059'       => 639,
        'uni205A'       => 333,
        'uni205B'       => 882,
        'uni205C'       => 639,
        'uni205D'       => 333,
        'uni205E'       => 333,
        'uni205F'       => 222,
        'uni2060'       => 0,
        'uni2061'       => 1000,
        'uni2062'       => 1000,
        'uni2063'       => 1000,
        'uni2064'       => 1000,
        'uni2066'       => 1000,
        'uni2067'       => 1000,
        'uni2068'       => 1000,
        'uni2069'       => 1000,
        'uni206A'       => 1000,
        'uni206B'       => 1000,
        'uni206C'       => 1000,
        'uni206D'       => 1000,
        'uni206E'       => 1000,
        'uni206F'       => 1000,
        'uni2071'       => 166,
        'uni207B'       => 299,
        'uni208A'       => 299,
        'uni208B'       => 299,
        'uni208C'       => 299,
        'uni2090'       => 292,
        'uni2091'       => 262,
        'uni2092'       => 285,
        'uni2093'       => 284,
        'uni2094'       => 262,
        'uni2095'       => 283,
        'uni2096'       => 281,
        'uni2097'       => 136,
        'uni2098'       => 416,
        'uni2099'       => 283,
        'uni209A'       => 282,
        'uni209B'       => 210,
        'uni209C'       => 167,
        'uni20A0'       => 616,
        'uni20A5'       => 722,
        'uni20A6'       => 666,
        'uni20A8'       => 1055,
        'uni20AD'       => 666,
        'uni20AE'       => 556,
        'uni20AF'       => 1000,
        'uni20B0'       => 500,
        'uni20B1'       => 610,
        'uni20B2'       => 722,
        'uni20B3'       => 610,
        'uni20B4'       => 500,
        'uni20B5'       => 666,
        'uni20B6'       => 500,
        'uni20B7'       => 500,
        'uni20B8'       => 556,
        'uni20B9'       => 500,
        'uni20BA'       => 500,
        'uni20BB'       => 651,
        'uni20BC'       => 657,
        'uni20BD'       => 500,
        'uni20BE'       => 758,
        'uni20BF'       => 610,
        'uni20F0'       => 0,
        'uni2100'       => 891,
        'uni2101'       => 853,
        'uni2102'       => 666,
        'uni2104'       => 610,
        'uni2106'       => 888,
        'uni2107'       => 500,
        'uni2108'       => 654,
        'uni210A'       => 509,
        'uni210C'       => 987,
        'uni210D'       => 722,
        'uni210E'       => 500,
        'uni2110'       => 687,
        'uni2114'       => 746,
        'uni2115'       => 722,
        'uni2119'       => 556,
        'uni211A'       => 722,
        'uni211B'       => 926,
        'uni211D'       => 666,
        'uni211F'       => 610,
        'uni2120'       => 906,
        'uni2123'       => 610,
        'uni2124'       => 610,
        'uni2125'       => 443,
        'uni2127'       => 743,
        'uni2128'       => 698,
        'uni2129'       => 269,
        'uni212A'       => 666,
        'uni212D'       => 645,
        'uni212F'       => 384,
        'uni2130'       => 615,
        'uni2131'       => 687,
        'uni2132'       => 556,
        'uni2139'       => 326,
        'uni213A'       => 973,
        'uni213B'       => 1103,
        'uni213C'       => 548,
        'uni213D'       => 441,
        'uni213E'       => 578,
        'uni213F'       => 722,
        'uni2140'       => 712,
        'uni2141'       => 777,
        'uni2142'       => 556,
        'uni2143'       => 556,
        'uni2144'       => 666,
        'uni2145'       => 722,
        'uni2146'       => 500,
        'uni2147'       => 443,
        'uni2148'       => 277,
        'uni2149'       => 277,
        'uni214A'       => 635,
        'uni214B'       => 777,
        'uni214C'       => 776,
        'uni214D'       => 881,
        'uni214E'       => 390,
        'uni214F'       => 1051,
        'uni2150'       => 750,
        'uni2151'       => 750,
        'uni2152'       => 970,
        'uni215F'       => 458,
        'uni216C'       => 556,
        'uni216D'       => 666,
        'uni216E'       => 722,
        'uni216F'       => 833,
        'uni217C'       => 277,
        'uni217D'       => 443,
        'uni217E'       => 500,
        'uni217F'       => 722,
        'uni2180'       => 1111,
        'uni2181'       => 722,
        'uni2182'       => 1111,
        'uni2183'       => 666,
        'uni2184'       => 445,
        'uni2185'       => 732,
        'uni2186'       => 634,
        'uni2187'       => 722,
        'uni2188'       => 1111,
        'uni2189'       => 750,
        'uni218A'       => 500,
        'uni218B'       => 500,
        'uni2C60'       => 556,
        'uni2C61'       => 277,
        'uni2C62'       => 556,
        'uni2C63'       => 610,
        'uni2C64'       => 610,
        'uni2C65'       => 500,
        'uni2C66'       => 277,
        'uni2C67'       => 722,
        'uni2C68'       => 500,
        'uni2C69'       => 666,
        'uni2C6A'       => 443,
        'uni2C6B'       => 556,
        'uni2C6C'       => 389,
        'uni2C6D'       => 717,
        'uni2C6E'       => 833,
        'uni2C6F'       => 610,
        'uni2C70'       => 717,
        'uni2C71'       => 556,
        'uni2C72'       => 833,
        'uni2C73'       => 799,
        'uni2C74'       => 443,
        'uni2C75'       => 599,
        'uni2C76'       => 408,
        'uni2C77'       => 553,
        'uni2C78'       => 554,
        'uni2C79'       => 389,
        'uni2C7A'       => 500,
        'uni2C7B'       => 390,
        'uni2C7C'       => 164,
        'uni2C7D'       => 420,
        'uni2C7E'       => 500,
        'uni2C7F'       => 556,
        'uni2E00'       => 333,
        'uni2E01'       => 333,
        'uni2E02'       => 333,
        'uni2E03'       => 333,
        'uni2E04'       => 333,
        'uni2E05'       => 333,
        'uni2E06'       => 428,
        'uni2E07'       => 428,
        'uni2E08'       => 419,
        'uni2E09'       => 419,
        'uni2E0A'       => 419,
        'uni2E0B'       => 436,
        'uni2E0C'       => 436,
        'uni2E0D'       => 436,
        'uni2E0E'       => 838,
        'uni2E0F'       => 0,
        'uni2E10'       => 0,
        'uni2E11'       => 0,
        'uni2E12'       => 234,
        'uni2E13'       => 500,
        'uni2E14'       => 613,
        'uni2E15'       => 613,
        'uni2E16'       => 674,
        'uni2E17'       => 333,
        'uni2E18'       => 500,
        'uni2E19'       => 500,
        'uni2E1A'       => 333,
        'uni2E1B'       => 541,
        'uni2E1C'       => 436,
        'uni2E1D'       => 436,
        'uni2E1E'       => 541,
        'uni2E1F'       => 541,
        'uni2E20'       => 389,
        'uni2E21'       => 389,
        'uni2E22'       => 389,
        'uni2E23'       => 389,
        'uni2E24'       => 389,
        'uni2E25'       => 389,
        'uni2E26'       => 744,
        'uni2E27'       => 744,
        'uni2E28'       => 513,
        'uni2E29'       => 513,
        'uni2E2A'       => 639,
        'uni2E2B'       => 639,
        'uni2E2C'       => 639,
        'uni2E2D'       => 615,
        'uni2E2E'       => 500,
        'uni2E2F'       => 333,
        'uni2E30'       => 354,
        'uni2E31'       => 250,
        'uni2E32'       => 250,
        'uni2E33'       => 250,
        'uni2E34'       => 250,
        'uni2E35'       => 333,
        'uni2E36'       => 500,
        'uni2E37'       => 500,
        'uni2E38'       => 500,
        'uni2E39'       => 500,
        'uni2E3A'       => 1000,
        'uni2E3B'       => 1000,
        'uni2E3C'       => 250,
        'uni2E3D'       => 277,
        'uni2E3E'       => 277,
        'uni2E3F'       => 666,
        'uni2E40'       => 333,
        'uni2E41'       => 250,
        'uni2E42'       => 556,
        'uniA717'       => 0,
        'uniA718'       => 0,
        'uniA719'       => 0,
        'uniA71A'       => 0,
        'uniA71B'       => 500,
        'uniA71C'       => 500,
        'uniA71D'       => 333,
        'uniA71E'       => 333,
        'uniA71F'       => 333,
        'uniA720'       => 0,
        'uniA721'       => 0,
        'uniA722'       => 253,
        'uniA723'       => 216,
        'uniA724'       => 253,
        'uniA725'       => 216,
        'uniA726'       => 722,
        'uniA727'       => 465,
        'uniA728'       => 737,
        'uniA729'       => 601,
        'uniA72A'       => 495,
        'uniA72B'       => 495,
        'uniA72C'       => 435,
        'uniA72D'       => 435,
        'uniA72E'       => 525,
        'uniA72F'       => 525,
        'uniA730'       => 427,
        'uniA731'       => 400,
        'uniA732'       => 967,
        'uniA733'       => 663,
        'uniA734'       => 1049,
        'uniA735'       => 720,
        'uniA736'       => 978,
        'uniA737'       => 679,
        'uniA738'       => 828,
        'uniA739'       => 593,
        'uniA73A'       => 828,
        'uniA73B'       => 593,
        'uniA73C'       => 828,
        'uniA73D'       => 593,
        'uniA73E'       => 666,
        'uniA73F'       => 443,
        'uniA740'       => 666,
        'uniA741'       => 443,
        'uniA742'       => 666,
        'uniA743'       => 443,
        'uniA744'       => 666,
        'uniA745'       => 443,
        'uniA746'       => 642,
        'uniA747'       => 298,
        'uniA748'       => 556,
        'uniA749'       => 277,
        'uniA74A'       => 754,
        'uniA74B'       => 500,
        'uniA74C'       => 773,
        'uniA74D'       => 546,
        'uniA74E'       => 1242,
        'uniA74F'       => 827,
        'uniA750'       => 610,
        'uniA751'       => 500,
        'uniA752'       => 659,
        'uniA753'       => 594,
        'uniA754'       => 808,
        'uniA755'       => 744,
        'uniA756'       => 722,
        'uniA757'       => 500,
        'uniA758'       => 812,
        'uniA759'       => 584,
        'uniA75A'       => 667,
        'uniA75B'       => 488,
        'uniA75C'       => 636,
        'uniA75D'       => 472,
        'uniA75E'       => 610,
        'uniA75F'       => 443,
        'uniA760'       => 833,
        'uniA761'       => 666,
        'uniA762'       => 540,
        'uniA763'       => 503,
        'uniA764'       => 610,
        'uniA765'       => 500,
        'uniA766'       => 610,
        'uniA767'       => 500,
        'uniA768'       => 545,
        'uniA769'       => 423,
        'uniA76A'       => 376,
        'uniA76B'       => 376,
        'uniA76C'       => 528,
        'uniA76D'       => 528,
        'uniA76E'       => 500,
        'uniA76F'       => 500,
        'uniA770'       => 291,
        'uniA771'       => 643,
        'uniA772'       => 400,
        'uniA773'       => 864,
        'uniA774'       => 644,
        'uniA775'       => 427,
        'uniA776'       => 664,
        'uniA777'       => 625,
        'uniA778'       => 463,
        'uniA779'       => 722,
        'uniA77A'       => 500,
        'uniA77B'       => 441,
        'uniA77C'       => 333,
        'uniA77D'       => 471,
        'uniA77E'       => 471,
        'uniA77F'       => 471,
        'uniA780'       => 556,
        'uniA781'       => 277,
        'uniA782'       => 694,
        'uniA783'       => 500,
        'uniA784'       => 441,
        'uniA785'       => 333,
        'uniA786'       => 632,
        'uniA787'       => 430,
        'uniA788'       => 333,
        'uniA789'       => 333,
        'uniA78A'       => 404,
        'uniA78B'       => 213,
        'uniA78C'       => 213,
        'uniA78D'       => 722,
        'uniA78E'       => 455,
        'uniA78F'       => 250,
        'uniA790'       => 666,
        'uniA791'       => 500,
        'uniA792'       => 666,
        'uniA793'       => 443,
        'uniA794'       => 443,
        'uniA795'       => 500,
        'uniA796'       => 675,
        'uniA797'       => 624,
        'uniA798'       => 610,
        'uniA799'       => 277,
        'uniA79A'       => 692,
        'uniA79B'       => 517,
        'uniA79C'       => 722,
        'uniA79D'       => 500,
        'uniA79E'       => 692,
        'uniA79F'       => 517,
        'uniA7A0'       => 722,
        'uniA7A1'       => 500,
        'uniA7A2'       => 666,
        'uniA7A3'       => 443,
        'uniA7A4'       => 666,
        'uniA7A5'       => 500,
        'uniA7A6'       => 610,
        'uniA7A7'       => 389,
        'uniA7A8'       => 500,
        'uniA7A9'       => 389,
        'uniA7AA'       => 775,
        'uniA7AB'       => 495,
        'uniA7AC'       => 717,
        'uniA7AD'       => 624,
        'uniA7AE'       => 556,
        'uniA7B0'       => 666,
        'uniA7B1'       => 556,
        'uniA7B2'       => 443,
        'uniA7B3'       => 610,
        'uniA7B4'       => 610,
        'uniA7B5'       => 498,
        'uniA7B6'       => 902,
        'uniA7B7'       => 706,
        'uniA7F7'       => 740,
        'uniA7F8'       => 440,
        'uniA7F9'       => 473,
        'uniA7FA'       => 722,
        'uniA7FB'       => 610,
        'uniA7FC'       => 610,
        'uniA7FD'       => 833,
        'uniA7FE'       => 333,
        'uniA7FF'       => 1091,
        'uniAB30'       => 523,
        'uniAB31'       => 654,
        'uniAB32'       => 388,
        'uniAB33'       => 443,
        'uniAB34'       => 546,
        'uniAB35'       => 277,
        'uniAB36'       => 479,
        'uniAB37'       => 315,
        'uniAB38'       => 277,
        'uniAB39'       => 277,
        'uniAB3A'       => 709,
        'uniAB3B'       => 494,
        'uniAB3C'       => 484,
        'uniAB3D'       => 389,
        'uniAB3E'       => 389,
        'uniAB3F'       => 500,
        'uniAB40'       => 720,
        'uniAB41'       => 666,
        'uniAB42'       => 666,
        'uniAB43'       => 827,
        'uniAB44'       => 827,
        'uniAB45'       => 466,
        'uniAB46'       => 504,
        'uniAB47'       => 319,
        'uniAB48'       => 501,
        'uniAB49'       => 453,
        'uniAB4A'       => 565,
        'uniAB4B'       => 395,
        'uniAB4C'       => 590,
        'uniAB4D'       => 286,
        'uniAB4E'       => 500,
        'uniAB4F'       => 500,
        'uniAB50'       => 722,
        'uniAB51'       => 722,
        'uniAB52'       => 500,
        'uniAB53'       => 439,
        'uniAB54'       => 439,
        'uniAB55'       => 428,
        'uniAB56'       => 443,
        'uniAB57'       => 443,
        'uniAB58'       => 443,
        'uniAB59'       => 443,
        'uniAB5A'       => 443,
        'uniAB5B'       => 333,
        'uniAB5C'       => 321,
        'uniAB5D'       => 211,
        'uniAB5E'       => 211,
        'uniAB5F'       => 316,
        'uniAB60'       => 677,
        'uniAB61'       => 673,
        'uniAB62'       => 735,
        'uniAB63'       => 790,
        'uniAB64'       => 500,
        'uniAB65'       => 568,
        'uniF301'       => 0,
        'uniFB05'       => 526,
        'uniFB06'       => 652,
        'uniFB13'       => 993,
        'uniFB14'       => 994,
        'uniFB15'       => 1004,
        'uniFB16'       => 983,
        'uniFB17'       => 1250,
        'uniFB1D'       => 241,
        'uniFB1E'       => 0,
        'uniFB21'       => 629,
        'uniFB22'       => 563,
        'uniFB23'       => 622,
        'uniFB24'       => 557,
        'uniFB25'       => 576,
        'uniFB26'       => 619,
        'uniFB27'       => 599,
        'uniFB28'       => 620,
        'uniFB29'       => 563,
        'uniFE20'       => 0,
        'uniFE21'       => 0,
        'uniFE22'       => 0,
        'uniFE23'       => 0,
        'uniFFFC'       => 1000,
        'uogonek'       => 500,
        'upblock'       => 708,
        'upperdothebrew'       => 0,
        'upsilon'       => 458,
        'upsilondieresis'       => 458,
        'upsilondieresistonos'       => 458,
        'upsilonlatin'       => 520,
        'upsilontonos'       => 458,
        'uptackbelowcmb'       => 0,
        'uptackmod'       => 333,
        'uring'       => 500,
        'ustraightcyrillic'       => 500,
        'ustraightstrokecyrillic'       => 500,
        'utilde'       => 500,
        'utildeacute'       => 500,
        'utildebelow'       => 500,
        'v'       => 444,                                         # +1
        'vdotbelow'       => 444,                                 # (+1)
        'verticallineabovecmb'       => 0,
        'verticallinebelowcmb'       => 0,
        'verticallinelowmod'       => 333,
        'verticallinemod'       => 333,
        'vewarmenian'       => 496,
        'vhook'       => 489,
        'voarmenian'       => 497,
        'vtilde'       => 444,                                    # (+1)
        'vturned'       => 444,                                   # (+1)
        'w'       => 667,                                         # +1
        'wacute'       => 667,                                    # (+1)
        'wcircumflex'       => 667,                               # (+1)
        'wdieresis'       => 667,                                 # (+1)
        'wdotaccent'       => 667,                                # (+1)
        'wdotbelow'       => 667,                                 # (+1)
        'weierstrass'       => 740,
        'wgrave'       => 667,                                    # (+1)
        'won'       => 833,
        'wring'       => 667,                                     # (+1)
        'wsuperior'       => 389,
        'wturned'       => 667,                                   # (+1)
        'wynn'       => 522,
        'x'       => 444,                                         # +1
        'xabovecmb'       => 0,
        'xdieresis'       => 444,                                 # (+1)
        'xdotaccent'       => 444,                                # (+1)
        'xeharmenian'       => 744,
        'xi'       => 428,
        'xsuperior'       => 282,
        'y'       => 444,                                         # +1
        'yacute'       => 444,                                    # +1
        'ycircumflex'       => 444,                               # (+1)
        'ydieresis'       => 444,                                 # +1
        'ydotaccent'       => 444,                                # (+1)
        'ydotbelow'       => 444,                                 # (+1)
        'yen'       => 500,
        'yerahbenyomohebrew'       => 0,
        'yerudieresiscyrillic'       => 677,
        'yetivhebrew'       => 0,
        'ygrave'       => 444,                                    # (+1)
        'yhook'       => 510,
        'yhookabove'       => 444,                                # (+1)
        'yiarmenian'       => 228,
        'yiwnarmenian'       => 315,
        'yoddagesh'       => 241,
        'yotgreek'       => 277,
        'ypogegrammeni'       => 333,
        'ypogegrammenigreekcmb'       => 0,
        'yr'       => 610,
        'yring'       => 444,                                     # (+1)
        'ysuperior'       => 254,
        'ytilde'       => 444,                                    # (+1)
        'yturned'       => 444,                                   # (+1)
        'yusbigcyrillic'       => 635,
        'yusbigiotifiedcyrillic'       => 884,
        'yuslittlecyrillic'       => 541,
        'yuslittleiotifiedcyrillic'       => 781,
        'z'       => 389,
        'zaarmenian'       => 510,
        'zacute'       => 389,
        'zaqefgadolhebrew'       => 0,
        'zaqefqatanhebrew'       => 0,
        'zarqahebrew'       => 0,
        'zayindagesh'       => 268,
        'zcaron'       => 389,
        'zcircumflex'       => 389,
        'zcurl'       => 389,
        'zdotaccent'       => 389,
        'zdotbelow'       => 389,
        'zedescendercyrillic'       => 390,
        'zedieresiscyrillic'       => 390,
        'zero'       => 500,
        'zeroinferior'       => 299,
        'zerosuperior'       => 299,
        'zerowidthspace'       => 0,
        'zeta'       => 404,
        'zhearmenian'       => 532,
        'zhebrevecyrillic'       => 930,
        'zhedescendercyrillic'       => 930,
        'zhedieresiscyrillic'       => 930,
        'zinorhebrew'       => 0,
        'zlinebelow'       => 389,
        'zretroflexhook'       => 389,
        'zstroke'       => 389,
    },
    'wxold' => { # HORIZ. WIDTH TABLE
        'space' => '250',                        # C+0x20 # U+0x0020
        'exclam' => '333',                       # C+0x21 # U+0x0021
        'quotedbl' => '419',                     # C+0x22 # U+0x0022
        'numbersign' => '500',                   # C+0x23 # U+0x0023
        'dollar' => '500',                       # C+0x24 # U+0x0024
        'percent' => '833',                      # C+0x25 # U+0x0025
        'ampersand' => '777',                    # C+0x26 # U+0x0026
        'quotesingle' => '213',                  # C+0x27 # U+0x0027
        'parenleft' => '333',                    # C+0x28 # U+0x0028
        'parenright' => '333',                   # C+0x29 # U+0x0029
        'asterisk' => '500',                     # C+0x2A # U+0x002A
        'plus' => '674',                         # C+0x2B # U+0x002B
        'comma' => '250',                        # C+0x2C # U+0x002C
        'hyphen' => '333',                       # C+0x2D # U+0x002D
        'period' => '250',                       # C+0x2E # U+0x002E
        'slash' => '277',                        # C+0x2F # U+0x002F
        'zero' => '500',                         # C+0x30 # U+0x0030
        'one' => '500',                          # C+0x31 # U+0x0031
        'two' => '500',                          # C+0x32 # U+0x0032
        'three' => '500',                        # C+0x33 # U+0x0033
        'four' => '500',                         # C+0x34 # U+0x0034
        'five' => '500',                         # C+0x35 # U+0x0035
        'six' => '500',                          # C+0x36 # U+0x0036
        'seven' => '500',                        # C+0x37 # U+0x0037
        'eight' => '500',                        # C+0x38 # U+0x0038
        'nine' => '500',                         # C+0x39 # U+0x0039
        'colon' => '333',                        # C+0x3A # U+0x003A
        'semicolon' => '333',                    # C+0x3B # U+0x003B
        'less' => '674',                         # C+0x3C # U+0x003C
        'equal' => '674',                        # C+0x3D # U+0x003D
        'greater' => '674',                      # C+0x3E # U+0x003E
        'question' => '500',                     # C+0x3F # U+0x003F
        'at' => '919',                           # C+0x40 # U+0x0040
        'A' => '610',                            # C+0x41 # U+0x0041
        'B' => '610',                            # C+0x42 # U+0x0042
        'C' => '666',                            # C+0x43 # U+0x0043
        'D' => '722',                            # C+0x44 # U+0x0044
        'E' => '610',                            # C+0x45 # U+0x0045
        'F' => '610',                            # C+0x46 # U+0x0046
        'G' => '722',                            # C+0x47 # U+0x0047
        'H' => '722',                            # C+0x48 # U+0x0048
        'I' => '333',                            # C+0x49 # U+0x0049
        'J' => '443',                            # C+0x4A # U+0x004A
        'K' => '666',                            # C+0x4B # U+0x004B
        'L' => '556',                            # C+0x4C # U+0x004C
        'M' => '833',                            # C+0x4D # U+0x004D
        'N' => '666',                            # C+0x4E # U+0x004E
        'O' => '722',                            # C+0x4F # U+0x004F
        'P' => '610',                            # C+0x50 # U+0x0050
        'Q' => '722',                            # C+0x51 # U+0x0051
        'R' => '610',                            # C+0x52 # U+0x0052
        'S' => '500',                            # C+0x53 # U+0x0053
        'T' => '556',                            # C+0x54 # U+0x0054
        'U' => '722',                            # C+0x55 # U+0x0055
        'V' => '610',                            # C+0x56 # U+0x0056
        'W' => '833',                            # C+0x57 # U+0x0057
        'X' => '610',                            # C+0x58 # U+0x0058
        'Y' => '556',                            # C+0x59 # U+0x0059
        'Z' => '556',                            # C+0x5A # U+0x005A
        'bracketleft' => '389',                  # C+0x5B # U+0x005B
        'backslash' => '277',                    # C+0x5C # U+0x005C
        'bracketright' => '389',                 # C+0x5D # U+0x005D
        'asciicircum' => '421',                  # C+0x5E # U+0x005E
        'underscore' => '500',                   # C+0x5F # U+0x005F
        'grave' => '333',                        # C+0x60 # U+0x0060
        'a' => '500',                            # C+0x61 # U+0x0061
        'b' => '500',                            # C+0x62 # U+0x0062
        'c' => '443',                            # C+0x63 # U+0x0063
        'd' => '500',                            # C+0x64 # U+0x0064
        'e' => '443',                            # C+0x65 # U+0x0065
        'f' => '277',                            # C+0x66 # U+0x0066
        'g' => '500',                            # C+0x67 # U+0x0067
        'h' => '500',                            # C+0x68 # U+0x0068
        'i' => '277',                            # C+0x69 # U+0x0069
        'j' => '277',                            # C+0x6A # U+0x006A
        'k' => '443',                            # C+0x6B # U+0x006B
        'l' => '277',                            # C+0x6C # U+0x006C
        'm' => '722',                            # C+0x6D # U+0x006D
        'n' => '500',                            # C+0x6E # U+0x006E
        'o' => '500',                            # C+0x6F # U+0x006F
        'p' => '500',                            # C+0x70 # U+0x0070
        'q' => '500',                            # C+0x71 # U+0x0071
        'r' => '389',                            # C+0x72 # U+0x0072
        's' => '389',                            # C+0x73 # U+0x0073
        't' => '277',                            # C+0x74 # U+0x0074
        'u' => '500',                            # C+0x75 # U+0x0075
        'v' => '443',                            # C+0x76 # U+0x0076
        'w' => '666',                            # C+0x77 # U+0x0077
        'x' => '443',                            # C+0x78 # U+0x0078
        'y' => '443',                            # C+0x79 # U+0x0079
        'z' => '389',                            # C+0x7A # U+0x007A
        'braceleft' => '399',                    # C+0x7B # U+0x007B
        'bar' => '274',                          # C+0x7C # U+0x007C
        'braceright' => '399',                   # C+0x7D # U+0x007D
        'asciitilde' => '541',                   # C+0x7E # U+0x007E
        'bullet' => '350',                       # C+0x7F # U+0x2022
        'Euro' => '500',                         # C+0x80 # U+0x20AC
        'quotesinglbase' => '333',               # C+0x82 # U+0x201A
        'florin' => '500',                       # C+0x83 # U+0x0192
        'quotedblbase' => '556',                 # C+0x84 # U+0x201E
        'ellipsis' => '889',                     # C+0x85 # U+0x2026
        'dagger' => '500',                       # C+0x86 # U+0x2020
        'daggerdbl' => '500',                    # C+0x87 # U+0x2021
        'circumflex' => '333',                   # C+0x88 # U+0x02C6
        'perthousand' => '1000',                 # C+0x89 # U+0x2030
        'Scaron' => '500',                       # C+0x8A # U+0x0160
        'guilsinglleft' => '333',                # C+0x8B # U+0x2039
        'OE' => '943',                           # C+0x8C # U+0x0152
        'Zcaron' => '556',                       # C+0x8E # U+0x017D
        'quoteleft' => '333',                    # C+0x91 # U+0x2018
        'quoteright' => '333',                   # C+0x92 # U+0x2019
        'quotedblleft' => '556',                 # C+0x93 # U+0x201C
        'quotedblright' => '556',                # C+0x94 # U+0x201D
        'endash' => '500',                       # C+0x96 # U+0x2013
        'emdash' => '889',                       # C+0x97 # U+0x2014
        'tilde' => '333',                        # C+0x98 # U+0x02DC
        'trademark' => '979',                    # C+0x99 # U+0x2122
        'scaron' => '389',                       # C+0x9A # U+0x0161
        'guilsinglright' => '333',               # C+0x9B # U+0x203A
        'oe' => '666',                           # C+0x9C # U+0x0153
        'zcaron' => '389',                       # C+0x9E # U+0x017E
        'Ydieresis' => '556',                    # C+0x9F # U+0x0178
        'exclamdown' => '389',                   # C+0xA1 # U+0x00A1
        'cent' => '500',                         # C+0xA2 # U+0x00A2
        'sterling' => '500',                     # C+0xA3 # U+0x00A3
        'currency' => '500',                     # C+0xA4 # U+0x00A4
        'yen' => '500',                          # C+0xA5 # U+0x00A5
        'brokenbar' => '274',                    # C+0xA6 # U+0x00A6
        'section' => '500',                      # C+0xA7 # U+0x00A7
        'dieresis' => '333',                     # C+0xA8 # U+0x00A8
        'copyright' => '759',                    # C+0xA9 # U+0x00A9
        'ordfeminine' => '275',                  # C+0xAA # U+0x00AA
        'guillemotleft' => '500',                # C+0xAB # U+0x00AB
        'logicalnot' => '674',                   # C+0xAC # U+0x00AC
        'registered' => '759',                   # C+0xAE # U+0x00AE
        'macron' => '520',                       # C+0xAF # U+0x00AF
        'degree' => '399',                       # C+0xB0 # U+0x00B0
        'plusminus' => '548',                    # C+0xB1 # U+0x00B1
        'twosuperior' => '299',                  # C+0xB2 # U+0x00B2
        'threesuperior' => '299',                # C+0xB3 # U+0x00B3
        'acute' => '333',                        # C+0xB4 # U+0x00B4
        'mu' => '501',                           # C+0xB5 # U+0x00B5
        'paragraph' => '522',                    # C+0xB6 # U+0x00B6
        'periodcentered' => '250',               # C+0xB7 # U+0x00B7
        'cedilla' => '333',                      # C+0xB8 # U+0x00B8
        'onesuperior' => '299',                  # C+0xB9 # U+0x00B9
        'ordmasculine' => '310',                 # C+0xBA # U+0x00BA
        'guillemotright' => '500',               # C+0xBB # U+0x00BB
        'onequarter' => '750',                   # C+0xBC # U+0x00BC
        'onehalf' => '750',                      # C+0xBD # U+0x00BD
        'threequarters' => '750',                # C+0xBE # U+0x00BE
        'questiondown' => '500',                 # C+0xBF # U+0x00BF
        'Agrave' => '610',                       # C+0xC0 # U+0x00C0
        'Aacute' => '610',                       # C+0xC1 # U+0x00C1
        'Acircumflex' => '610',                  # C+0xC2 # U+0x00C2
        'Atilde' => '610',                       # C+0xC3 # U+0x00C3
        'Adieresis' => '610',                    # C+0xC4 # U+0x00C4
        'Aring' => '610',                        # C+0xC5 # U+0x00C5
        'AE' => '889',                           # C+0xC6 # U+0x00C6
        'Ccedilla' => '666',                     # C+0xC7 # U+0x00C7
        'Egrave' => '610',                       # C+0xC8 # U+0x00C8
        'Eacute' => '610',                       # C+0xC9 # U+0x00C9
        'Ecircumflex' => '610',                  # C+0xCA # U+0x00CA
        'Edieresis' => '610',                    # C+0xCB # U+0x00CB
        'Igrave' => '333',                       # C+0xCC # U+0x00CC
        'Iacute' => '333',                       # C+0xCD # U+0x00CD
        'Icircumflex' => '333',                  # C+0xCE # U+0x00CE
        'Idieresis' => '333',                    # C+0xCF # U+0x00CF
        'Eth' => '722',                          # C+0xD0 # U+0x00D0
        'Ntilde' => '666',                       # C+0xD1 # U+0x00D1
        'Ograve' => '722',                       # C+0xD2 # U+0x00D2
        'Oacute' => '722',                       # C+0xD3 # U+0x00D3
        'Ocircumflex' => '722',                  # C+0xD4 # U+0x00D4
        'Otilde' => '722',                       # C+0xD5 # U+0x00D5
        'Odieresis' => '722',                    # C+0xD6 # U+0x00D6
        'multiply' => '674',                     # C+0xD7 # U+0x00D7
        'Oslash' => '722',                       # C+0xD8 # U+0x00D8
        'Ugrave' => '722',                       # C+0xD9 # U+0x00D9
        'Uacute' => '722',                       # C+0xDA # U+0x00DA
        'Ucircumflex' => '722',                  # C+0xDB # U+0x00DB
        'Udieresis' => '722',                    # C+0xDC # U+0x00DC
        'Yacute' => '556',                       # C+0xDD # U+0x00DD
        'Thorn' => '610',                        # C+0xDE # U+0x00DE
        'germandbls' => '500',                   # C+0xDF # U+0x00DF
        'agrave' => '500',                       # C+0xE0 # U+0x00E0
        'aacute' => '500',                       # C+0xE1 # U+0x00E1
        'acircumflex' => '500',                  # C+0xE2 # U+0x00E2
        'atilde' => '500',                       # C+0xE3 # U+0x00E3
        'adieresis' => '500',                    # C+0xE4 # U+0x00E4
        'aring' => '500',                        # C+0xE5 # U+0x00E5
        'ae' => '666',                           # C+0xE6 # U+0x00E6
        'ccedilla' => '443',                     # C+0xE7 # U+0x00E7
        'egrave' => '443',                       # C+0xE8 # U+0x00E8
        'eacute' => '443',                       # C+0xE9 # U+0x00E9
        'ecircumflex' => '443',                  # C+0xEA # U+0x00EA
        'edieresis' => '443',                    # C+0xEB # U+0x00EB
        'igrave' => '277',                       # C+0xEC # U+0x00EC
        'iacute' => '277',                       # C+0xED # U+0x00ED
        'icircumflex' => '277',                  # C+0xEE # U+0x00EE
        'idieresis' => '277',                    # C+0xEF # U+0x00EF
        'eth' => '500',                          # C+0xF0 # U+0x00F0
        'ntilde' => '500',                       # C+0xF1 # U+0x00F1
        'ograve' => '500',                       # C+0xF2 # U+0x00F2
        'oacute' => '500',                       # C+0xF3 # U+0x00F3
        'ocircumflex' => '500',                  # C+0xF4 # U+0x00F4
        'otilde' => '500',                       # C+0xF5 # U+0x00F5
        'odieresis' => '500',                    # C+0xF6 # U+0x00F6
        'divide' => '548',                       # C+0xF7 # U+0x00F7
        'oslash' => '500',                       # C+0xF8 # U+0x00F8
        'ugrave' => '500',                       # C+0xF9 # U+0x00F9
        'uacute' => '500',                       # C+0xFA # U+0x00FA
        'ucircumflex' => '500',                  # C+0xFB # U+0x00FB
        'udieresis' => '500',                    # C+0xFC # U+0x00FC
        'yacute' => '443',                       # C+0xFD # U+0x00FD
        'thorn' => '500',                        # C+0xFE # U+0x00FE
        'ydieresis' => '443',                    # C+0xFF # U+0x00FF
        'dotlessi' => '277',                     # U+0x0131
        'Lslash' => '556',                       # U+0x0141
        'lslash' => '277',                       # U+0x0142
        'caron' => '333',                        # U+0x02C7
        'breve' => '333',                        # U+0x02D8
        'dotaccent' => '333',                    # U+0x02D9
        'ring' => '333',                         # U+0x02DA
        'ogonek' => '333',                       # U+0x02DB
        'hungarumlaut' => '333',                 # U+0x02DD
	    'dblgravecmb' => '333',                  # U+0x030F
        'fraction' => '166',                     # U+0x2044
        'minus' => '674',                        # U+0x2212
        'fi' => '500',                           # U+0xFB01
        'fl' => '500',                           # U+0xFB02
    }, # HORIZ. WIDTH TABLE
} };

1;
