#
# @file    TestXMLError.py
# @brief   XMLError unit tests, C++ version
#
# @author  Akiya Jouraku (Python conversion)
# @author  Michael Hucka 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/xml/test/TestXMLError.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestXMLError(unittest.TestCase):


  def test_XMLError_create(self):
    error = libsbml.XMLError()
    self.assertTrue( error != None )
    error = None
    error = libsbml.XMLError(libsbml.DuplicateXMLAttribute)
    self.assertTrue( error.getErrorId() == libsbml.DuplicateXMLAttribute )
    self.assertTrue( error.getSeverity() == libsbml.LIBSBML_SEV_ERROR )
    self.assertTrue( error.getSeverityAsString() ==  "Error"  )
    self.assertTrue( error.getCategory() == libsbml.LIBSBML_CAT_XML )
    self.assertTrue( error.getCategoryAsString() ==  "XML content" )
#   self.assertTrue( error.getMessage() ==  "Duplicate XML attribute.\n"  )
    self.assertTrue( error.getShortMessage() ==  "Duplicate attribute"  )
    error = None
    error = libsbml.XMLError(12345, "My message")
    self.assertTrue( error.getErrorId() == 12345 )
    self.assertTrue( error.getMessage() ==  "My message"  )
    self.assertTrue( error.getSeverity() == libsbml.LIBSBML_SEV_FATAL )
    self.assertTrue( error.getSeverityAsString() ==  "Fatal"  )
    self.assertTrue( error.getCategory() == libsbml.LIBSBML_CAT_INTERNAL )
    self.assertTrue( error.getCategoryAsString() ==  "Internal" )
    error = None
    error = libsbml.XMLError(12345, "My message",0,0,libsbml.LIBSBML_SEV_INFO,libsbml.LIBSBML_CAT_SYSTEM)
    self.assertTrue( error.getErrorId() == 12345 )
    self.assertTrue( error.getMessage() ==  "My message"  )
    self.assertTrue( error.getSeverity() == libsbml.LIBSBML_SEV_INFO )
    self.assertTrue( error.getSeverityAsString() ==  "Informational"  )
    self.assertTrue( error.getCategory() == libsbml.LIBSBML_CAT_SYSTEM )
    self.assertTrue( error.getCategoryAsString() ==  "Operating system" )
    self.assertEqual( True, error.isInfo() )
    self.assertEqual( True, error.isSystem() )
    error = None
    error = libsbml.XMLError(10000, "Another message",0,0,libsbml.LIBSBML_SEV_FATAL,libsbml.LIBSBML_CAT_XML)
    self.assertTrue( error.getErrorId() == 10000 )
    self.assertTrue( error.getMessage() ==  "Another message"  )
    self.assertTrue( error.getSeverity() == libsbml.LIBSBML_SEV_FATAL )
    self.assertTrue( error.getSeverityAsString() ==  "Fatal"  )
    self.assertTrue( error.getCategory() == libsbml.LIBSBML_CAT_XML )
    self.assertTrue( error.getCategoryAsString() ==  "XML content" )
    self.assertEqual( True, error.isFatal() )
    self.assertEqual( True, error.isXML() )
    error = None
    pass  

  def test_XMLError_setters(self):
    error = libsbml.XMLError()
    self.assertTrue( error != None )
    i = error.setLine(23)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( error.getLine() == 23 )
    i = error.setColumn(45)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( error.getColumn() == 45 )
    error = None
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestXMLError))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
