package org.apache.maven.plugins.assembly.io;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.shared.io.location.ClasspathResourceLocatorStrategy;
import org.apache.maven.shared.io.location.Location;
import org.apache.maven.shared.io.logging.MessageHolder;

/**
 * @version $Id: PrefixedClasspathLocatorStrategy.java 1691831 2015-07-19 15:06:13Z rfscholte $
 */
class PrefixedClasspathLocatorStrategy
    extends ClasspathResourceLocatorStrategy
{

    private final String prefix;

    public PrefixedClasspathLocatorStrategy( String prefix )
    {
        this.prefix = formatPrefix( prefix );
    }

    private String formatPrefix( String prefix )
    {
        if ( prefix.startsWith( "/" ) )
        {
            prefix = prefix.substring( 1 );
        }

        if ( prefix.length() > 0 && !prefix.endsWith( "/" ) )
        {
            prefix += "/";
        }

        return prefix;
    }

    @Override
    public Location resolve( String locationSpecification, MessageHolder messageHolder )
    {
        String spec = formatLocation( locationSpecification );

        return super.resolve( spec, messageHolder );
    }

    private String formatLocation( String location )
    {
        if ( location.startsWith( "/" ) )
        {
            location = location.substring( 1 );
        }

        return prefix + location;
    }

}
