/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

File f = new File( basedir, "child/target/child-1-src/test.txt" );

if ( !f.exists() )
{
    System.out.println( "Filtered file from file-set: " + f + " is missing." );
    return false;
}

StringBuffer sb = new StringBuffer();

FileReader reader = new FileReader( f );
char[] cbuf = new char[16];
int read = -1;
while( ( read = reader.read( cbuf ) ) > -1 )
{
    sb.append( cbuf, 0, read );
}

reader.close();

System.out.println( "Contents of test.txt: '" + sb.toString() + "' should contain the unix newline: '\\n'." );

if ( sb.toString().indexOf( "1\nchild" ) == -1 )
{
    System.out.println( "test.txt has wrong line ending" );
    return false;
}
if ( sb.toString().indexOf( "child\n" ) > -1 )
{
    System.out.println( "test.txt has an extra line ending at the end of the file" );
    return false;
}
return true;
