# --------------------------------------------------------------------------------------
# Copyright (c) 2021-2024, Nucleic Development Team.
#
# Distributed under the terms of the Modified BSD License.
#
# The full license is in the file LICENSE, distributed with this software.
# --------------------------------------------------------------------------------------
from typing import Generic, List, Optional, Tuple, TypeVar, Union, overload

K = TypeVar("K")
V = TypeVar("V")
D = TypeVar("D")

class sortedmap(Generic[K, V]):
    @overload
    def get(self, key: K, default: None = None) -> Optional[V]: ...
    @overload
    def get(self, key: K, default: D) -> Union[V, D]: ...
    @overload
    def pop(self, key: K, default: None = None) -> V: ...
    @overload
    def pop(self, key: K, default: D) -> Union[V, D]: ...
    def clear(self) -> None: ...
    def keys(self) -> List[K]: ...
    def values(self) -> List[V]: ...
    def items(self) -> List[Tuple[K, V]]: ...
    def copy(self) -> sortedmap[K, V]: ...
    def __contains__(self, key: K) -> bool: ...
    def __getitem__(self, key: K) -> V: ...
    def __setitem__(self, key: K, value: V) -> None: ...
    def __delitem__(self, key: K) -> None: ...
    def __sizeof__(self) -> int: ...
