# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_request(
    resource_group_name: str,
    query_pack_name: str,
    subscription_id: str,
    *,
    top: Optional[int] = None,
    include_body: Optional[bool] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "queryPackName": _SERIALIZER.url("query_pack_name", query_pack_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int")
    if include_body is not None:
        _params["includeBody"] = _SERIALIZER.query("include_body", include_body, "bool")
    if skip_token is not None:
        _params["$skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_request(
    resource_group_name: str,
    query_pack_name: str,
    subscription_id: str,
    *,
    top: Optional[int] = None,
    include_body: Optional[bool] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/search",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "queryPackName": _SERIALIZER.url("query_pack_name", query_pack_name, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int")
    if include_body is not None:
        _params["includeBody"] = _SERIALIZER.query("include_body", include_body, "bool")
    if skip_token is not None:
        _params["$skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    resource_group_name: str, query_pack_name: str, id: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "queryPackName": _SERIALIZER.url("query_pack_name", query_pack_name, "str"),
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_put_request(
    resource_group_name: str, query_pack_name: str, id: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "queryPackName": _SERIALIZER.url("query_pack_name", query_pack_name, "str"),
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_request(
    resource_group_name: str, query_pack_name: str, id: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "queryPackName": _SERIALIZER.url("query_pack_name", query_pack_name, "str"),
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    resource_group_name: str, query_pack_name: str, id: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "queryPackName": _SERIALIZER.url("query_pack_name", query_pack_name, "str"),
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


class QueriesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.loganalytics.LogAnalyticsManagementClient`'s
        :attr:`queries` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        query_pack_name: str,
        top: Optional[int] = None,
        include_body: Optional[bool] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.LogAnalyticsQueryPackQuery"]:
        """Gets a list of Queries defined within a Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param top: Maximum items returned in page. Default value is None.
        :type top: int
        :param include_body: Flag indicating whether or not to return the body of each applicable
         query. If false, only return the query information. Default value is None.
        :type include_body: bool
        :param skip_token: Base64 encoded token used to fetch the next page of items. Default is null.
         Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LogAnalyticsQueryPackQuery or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
        cls: ClsType[_models.LogAnalyticsQueryPackQueryListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    resource_group_name=resource_group_name,
                    query_pack_name=query_pack_name,
                    subscription_id=self._config.subscription_id,
                    top=top,
                    include_body=include_body,
                    skip_token=skip_token,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("LogAnalyticsQueryPackQueryListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries"
    }

    @overload
    def search(
        self,
        resource_group_name: str,
        query_pack_name: str,
        query_search_properties: _models.LogAnalyticsQueryPackQuerySearchProperties,
        top: Optional[int] = None,
        include_body: Optional[bool] = None,
        skip_token: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Iterable["_models.LogAnalyticsQueryPackQuery"]:
        """Search a list of Queries defined within a Log Analytics QueryPack according to given search
        properties.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param query_search_properties: Properties by which to search queries in the given Log
         Analytics QueryPack. Required.
        :type query_search_properties:
         ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuerySearchProperties
        :param top: Maximum items returned in page. Default value is None.
        :type top: int
        :param include_body: Flag indicating whether or not to return the body of each applicable
         query. If false, only return the query information. Default value is None.
        :type include_body: bool
        :param skip_token: Base64 encoded token used to fetch the next page of items. Default is null.
         Default value is None.
        :type skip_token: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LogAnalyticsQueryPackQuery or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def search(
        self,
        resource_group_name: str,
        query_pack_name: str,
        query_search_properties: IO,
        top: Optional[int] = None,
        include_body: Optional[bool] = None,
        skip_token: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Iterable["_models.LogAnalyticsQueryPackQuery"]:
        """Search a list of Queries defined within a Log Analytics QueryPack according to given search
        properties.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param query_search_properties: Properties by which to search queries in the given Log
         Analytics QueryPack. Required.
        :type query_search_properties: IO
        :param top: Maximum items returned in page. Default value is None.
        :type top: int
        :param include_body: Flag indicating whether or not to return the body of each applicable
         query. If false, only return the query information. Default value is None.
        :type include_body: bool
        :param skip_token: Base64 encoded token used to fetch the next page of items. Default is null.
         Default value is None.
        :type skip_token: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LogAnalyticsQueryPackQuery or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def search(
        self,
        resource_group_name: str,
        query_pack_name: str,
        query_search_properties: Union[_models.LogAnalyticsQueryPackQuerySearchProperties, IO],
        top: Optional[int] = None,
        include_body: Optional[bool] = None,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.LogAnalyticsQueryPackQuery"]:
        """Search a list of Queries defined within a Log Analytics QueryPack according to given search
        properties.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param query_search_properties: Properties by which to search queries in the given Log
         Analytics QueryPack. Is either a model type or a IO type. Required.
        :type query_search_properties:
         ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuerySearchProperties or IO
        :param top: Maximum items returned in page. Default value is None.
        :type top: int
        :param include_body: Flag indicating whether or not to return the body of each applicable
         query. If false, only return the query information. Default value is None.
        :type include_body: bool
        :param skip_token: Base64 encoded token used to fetch the next page of items. Default is null.
         Default value is None.
        :type skip_token: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either LogAnalyticsQueryPackQuery or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LogAnalyticsQueryPackQueryListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(query_search_properties, (IO, bytes)):
            _content = query_search_properties
        else:
            _json = self._serialize.body(query_search_properties, "LogAnalyticsQueryPackQuerySearchProperties")

        def prepare_request(next_link=None):
            if not next_link:

                request = build_search_request(
                    resource_group_name=resource_group_name,
                    query_pack_name=query_pack_name,
                    subscription_id=self._config.subscription_id,
                    top=top,
                    include_body=include_body,
                    skip_token=skip_token,
                    api_version=api_version,
                    content_type=content_type,
                    json=_json,
                    content=_content,
                    template_url=self.search.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("LogAnalyticsQueryPackQueryListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    search.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/search"
    }

    @distributed_trace
    def get(
        self, resource_group_name: str, query_pack_name: str, id: str, **kwargs: Any
    ) -> _models.LogAnalyticsQueryPackQuery:
        """Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param id: The id of a specific query defined in the Log Analytics QueryPack. Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LogAnalyticsQueryPackQuery or the result of cls(response)
        :rtype: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
        cls: ClsType[_models.LogAnalyticsQueryPackQuery] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            query_pack_name=query_pack_name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LogAnalyticsQueryPackQuery", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}"
    }

    @overload
    def put(
        self,
        resource_group_name: str,
        query_pack_name: str,
        id: str,
        query_payload: _models.LogAnalyticsQueryPackQuery,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LogAnalyticsQueryPackQuery:
        """Adds or Updates a specific Query within a Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param id: The id of a specific query defined in the Log Analytics QueryPack. Required.
        :type id: str
        :param query_payload: Properties that need to be specified to create a new query and add it to
         a Log Analytics QueryPack. Required.
        :type query_payload: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LogAnalyticsQueryPackQuery or the result of cls(response)
        :rtype: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def put(
        self,
        resource_group_name: str,
        query_pack_name: str,
        id: str,
        query_payload: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LogAnalyticsQueryPackQuery:
        """Adds or Updates a specific Query within a Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param id: The id of a specific query defined in the Log Analytics QueryPack. Required.
        :type id: str
        :param query_payload: Properties that need to be specified to create a new query and add it to
         a Log Analytics QueryPack. Required.
        :type query_payload: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LogAnalyticsQueryPackQuery or the result of cls(response)
        :rtype: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def put(
        self,
        resource_group_name: str,
        query_pack_name: str,
        id: str,
        query_payload: Union[_models.LogAnalyticsQueryPackQuery, IO],
        **kwargs: Any
    ) -> _models.LogAnalyticsQueryPackQuery:
        """Adds or Updates a specific Query within a Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param id: The id of a specific query defined in the Log Analytics QueryPack. Required.
        :type id: str
        :param query_payload: Properties that need to be specified to create a new query and add it to
         a Log Analytics QueryPack. Is either a model type or a IO type. Required.
        :type query_payload: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LogAnalyticsQueryPackQuery or the result of cls(response)
        :rtype: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LogAnalyticsQueryPackQuery] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(query_payload, (IO, bytes)):
            _content = query_payload
        else:
            _json = self._serialize.body(query_payload, "LogAnalyticsQueryPackQuery")

        request = build_put_request(
            resource_group_name=resource_group_name,
            query_pack_name=query_pack_name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.put.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LogAnalyticsQueryPackQuery", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    put.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}"
    }

    @overload
    def update(
        self,
        resource_group_name: str,
        query_pack_name: str,
        id: str,
        query_payload: _models.LogAnalyticsQueryPackQuery,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LogAnalyticsQueryPackQuery:
        """Adds or Updates a specific Query within a Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param id: The id of a specific query defined in the Log Analytics QueryPack. Required.
        :type id: str
        :param query_payload: Properties that need to be specified to create a new query and add it to
         a Log Analytics QueryPack. Required.
        :type query_payload: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LogAnalyticsQueryPackQuery or the result of cls(response)
        :rtype: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update(
        self,
        resource_group_name: str,
        query_pack_name: str,
        id: str,
        query_payload: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LogAnalyticsQueryPackQuery:
        """Adds or Updates a specific Query within a Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param id: The id of a specific query defined in the Log Analytics QueryPack. Required.
        :type id: str
        :param query_payload: Properties that need to be specified to create a new query and add it to
         a Log Analytics QueryPack. Required.
        :type query_payload: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LogAnalyticsQueryPackQuery or the result of cls(response)
        :rtype: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update(
        self,
        resource_group_name: str,
        query_pack_name: str,
        id: str,
        query_payload: Union[_models.LogAnalyticsQueryPackQuery, IO],
        **kwargs: Any
    ) -> _models.LogAnalyticsQueryPackQuery:
        """Adds or Updates a specific Query within a Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param id: The id of a specific query defined in the Log Analytics QueryPack. Required.
        :type id: str
        :param query_payload: Properties that need to be specified to create a new query and add it to
         a Log Analytics QueryPack. Is either a model type or a IO type. Required.
        :type query_payload: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LogAnalyticsQueryPackQuery or the result of cls(response)
        :rtype: ~azure.mgmt.loganalytics.models.LogAnalyticsQueryPackQuery
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LogAnalyticsQueryPackQuery] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(query_payload, (IO, bytes)):
            _content = query_payload
        else:
            _json = self._serialize.body(query_payload, "LogAnalyticsQueryPackQuery")

        request = build_update_request(
            resource_group_name=resource_group_name,
            query_pack_name=query_pack_name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LogAnalyticsQueryPackQuery", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}"
    }

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, query_pack_name: str, id: str, **kwargs: Any
    ) -> None:
        """Deletes a specific Query defined within an Log Analytics QueryPack.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param query_pack_name: The name of the Log Analytics QueryPack resource. Required.
        :type query_pack_name: str
        :param id: The id of a specific query defined in the Log Analytics QueryPack. Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2019-09-01"] = kwargs.pop("api_version", _params.pop("api-version", "2019-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            query_pack_name=query_pack_name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}"
    }
