# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional

from ... import _serialization


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2021_10_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2021_10_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class MdeOnboardingData(Resource):
    """The resource of the configuration or data needed to onboard the machine to MDE.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar onboarding_package_windows: The onboarding package used to onboard Windows machines to
     MDE, coded in base64. This can also be used for onboarding using the dedicated VM Extension.
    :vartype onboarding_package_windows: bytes
    :ivar onboarding_package_linux: The onboarding package used to onboard Linux machines to MDE,
     coded in base64. This can also be used for onboarding using the dedicated VM Extension.
    :vartype onboarding_package_linux: bytes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "onboarding_package_windows": {"key": "properties.onboardingPackageWindows", "type": "bytearray"},
        "onboarding_package_linux": {"key": "properties.onboardingPackageLinux", "type": "bytearray"},
    }

    def __init__(
        self,
        *,
        onboarding_package_windows: Optional[bytes] = None,
        onboarding_package_linux: Optional[bytes] = None,
        **kwargs
    ):
        """
        :keyword onboarding_package_windows: The onboarding package used to onboard Windows machines to
         MDE, coded in base64. This can also be used for onboarding using the dedicated VM Extension.
        :paramtype onboarding_package_windows: bytes
        :keyword onboarding_package_linux: The onboarding package used to onboard Linux machines to
         MDE, coded in base64. This can also be used for onboarding using the dedicated VM Extension.
        :paramtype onboarding_package_linux: bytes
        """
        super().__init__(**kwargs)
        self.onboarding_package_windows = onboarding_package_windows
        self.onboarding_package_linux = onboarding_package_linux


class MdeOnboardingDataList(_serialization.Model):
    """List of all MDE onboarding data resources.

    :ivar value: List of the resources of the configuration or data needed to onboard the machine
     to MDE.
    :vartype value: list[~azure.mgmt.security.v2021_10_01_preview.models.MdeOnboardingData]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MdeOnboardingData]"},
    }

    def __init__(self, *, value: Optional[List["_models.MdeOnboardingData"]] = None, **kwargs):
        """
        :keyword value: List of the resources of the configuration or data needed to onboard the
         machine to MDE.
        :paramtype value: list[~azure.mgmt.security.v2021_10_01_preview.models.MdeOnboardingData]
        """
        super().__init__(**kwargs)
        self.value = value
