# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerinstance.aio import ContainerInstanceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerInstanceManagementContainersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerInstanceManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_logs(self, resource_group):
        response = await self.client.containers.list_logs(
            resource_group_name=resource_group.name,
            container_group_name="str",
            container_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_execute_command(self, resource_group):
        response = await self.client.containers.execute_command(
            resource_group_name=resource_group.name,
            container_group_name="str",
            container_name="str",
            container_exec_request={"command": "str", "terminalSize": {"cols": 0, "rows": 0}},
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attach(self, resource_group):
        response = await self.client.containers.attach(
            resource_group_name=resource_group.name,
            container_group_name="str",
            container_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...
