# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class PlaybackGrantTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.media.v1.player_streamer("VJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .playback_grant().create()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://media.twilio.com/v1/PlayerStreamers/VJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/PlaybackGrant',
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "sid": "VJcafebabecafebabecafebabecafebabe",
                "url": "https://media.twilio.com/v1/PlayerStreamers/VJcafebabecafebabecafebabecafebabe/PlaybackGrant",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-30T20:00:00Z",
                "grant": {
                    "playbackUrl": "http://video.net/123/blabla?token=123",
                    "playerStreamerSid": "VJcafebabecafebabecafebabecafebabe",
                    "requestCredentials": null
                }
            }
            '''
        ))

        actual = self.client.media.v1.player_streamer("VJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .playback_grant().create()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.media.v1.player_streamer("VJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .playback_grant().fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://media.twilio.com/v1/PlayerStreamers/VJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/PlaybackGrant',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-30T20:00:00Z",
                "url": "https://media.twilio.com/v1/PlayerStreamers/VJcafebabecafebabecafebabecafebabe/PlaybackGrant",
                "sid": "VJcafebabecafebabecafebabecafebabe",
                "grant": {
                    "playbackUrl": "http://video.net/123/blabla?token=123",
                    "playerStreamerSid": "VJcafebabecafebabecafebabecafebabe",
                    "requestCredentials": null
                }
            }
            '''
        ))

        actual = self.client.media.v1.player_streamer("VJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .playback_grant().fetch()

        self.assertIsNotNone(actual)
