% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5S.R
\name{H5Screate_simple}
\alias{H5Screate_simple}
\title{Create a simple dataspace}
\usage{
H5Screate_simple(dims, maxdims, native = FALSE)
}
\arguments{
\item{dims}{An integer vector defining the initial dimensions of the dataspace.
The length of \code{dims} determines the rank of the dataspace.}

\item{maxdims}{An integer vector with the same length length as \code{dims}.  Specifies the
upper limit on the size of the dataspace dimensions.  Only needs to be specified
if this is different from the values given to \code{dims}.}

\item{native}{An object of class \code{logical}. If \code{TRUE}, array-like
objects are treated as stored in HDF5 row-major rather than R column-major
orientation. Using \code{native = TRUE} increases HDF5 file portability between
programming languages. A file written with \code{native = TRUE} should also be
read with \code{native = TRUE}.}
}
\value{
Returns an object of class \linkS4class{H5IdComponent} representing a
dataspace.
}
\description{
Create a simple dataspace
}
\seealso{
\link{H5Screate}
}
