% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{file_touch}
\alias{file_touch}
\title{Change file access and modification times}
\usage{
file_touch(path, access_time = Sys.time(), modification_time = access_time)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{access_time, modification_time}{The times to set, inputs will be
coerced to \link{POSIXct} objects.}
}
\description{
Unlike the touch POSIX utility this does not create the file if it does not
exist. Use \code{\link[=file_create]{file_create()}} to do this if needed.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
file_create("foo")
file_touch("foo", "2018-01-01")
file_info("foo")[c("access_time", "modification_time", "change_time", "birth_time")]
\dontshow{setwd(.old_wd)}
}
