% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovax.R
\name{anovax}
\alias{anovax}
\alias{anovax.lmerMod}
\alias{anovax.default}
\alias{print.anovax}
\title{anova like function}
\usage{
anovax(object, ..., test = "x2", control = list(nsim = 1000, cl = NULL))

\method{anovax}{lmerMod}(object, ..., test = "x2", control = list(nsim = 1000, cl = NULL))

\method{anovax}{default}(object, ..., test = "x2", control = list(nsim = 1000, cl = NULL))

\method{print}{anovax}(x, ...)
}
\arguments{
\item{object}{A model object object}

\item{...}{further arguments}

\item{test}{A character string}

\item{control}{A list controling simulations, only relevant for
parametric bootstrapping.}

\item{x}{anovax object}
}
\description{
anova like function

print anovax object
}
\examples{
lmm1 <- lmer(sugpct ~ block + sow + harvest + (1|block:harvest), data=beets)
lmm0 <- update(lmm1, .~. - sow)
anovax(lmm1, .~. - harvest, test="KR")
anovax(lmm1, .~. - harvest, test="SAT")
## anovax(lmm1, .~. - harvest, test="PB", control=list(nsim=50, cl=1))

anovax(lmm1, test="KR")
anovax(lmm1, test="SAT")
anovax(lmm1, test="PB", control=list(nsim=50, cl=1))

}
\author{
Søren Højsgaard
}
