% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_ntfy.R
\name{handler_ntfy}
\alias{handler_ntfy}
\title{Progression Handler: Progress Reported via the Ntfy.sh Messaging Service}
\usage{
handler_ntfy(
  intrusiveness = getOption("progressr.intrusiveness.ntfy", 5),
  target = "gui",
  ...,
  title = "Progress update from R"
)
}
\arguments{
\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{title}{title of notification. See \url{https://docs.ntfy.sh/publish/#message-title}}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[ntfy:ntfy_send]{ntfy::ntfy_send()}} of the \pkg{ntfy} package,
which sends notifications via the \url{https://ntfy.sh} framework.
}
\section{Requirements}{

This progression handler requires the \pkg{ntfy} package.
}

\examples{
pkg <- "ntfy"
if (requireNamespace(pkg, quietly = TRUE)) {
  ## We need to specify a ntfy.sh topic that progress messages
  ## should be sent to. See help("ntfy_topic", package = "ntfy")
  ## for details
  Sys.setenv(NTFY_TOPIC = "R-my-secret-topic")

  handlers("ntfy")
  with_progress({ y <- slow_sum(1:10) })
  print(y)
}
}
