% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictRisk.R, R/wglm.R
\name{predictRisk}
\alias{predictRisk}
\alias{predictRisk.CauseSpecificCox}
\alias{predictRisk.riskRegression}
\alias{predictRisk.FGR}
\alias{predictRisk.prodlim}
\alias{predictRisk.rfsrc}
\alias{predictRisk.aalen}
\alias{predictRisk.ARR}
\alias{predictRisk.cox.aalen}
\alias{predictRisk.coxph}
\alias{predictRisk.cph}
\alias{predictRisk.default}
\alias{predictRisk.matrix}
\alias{predictRisk.pecCtree}
\alias{predictRisk.pecCforest}
\alias{predictRisk.psm}
\alias{predictRisk.selectCox}
\alias{predictRisk.survfit}
\alias{predictRisk.randomForest}
\alias{predictRisk.lrm}
\alias{predictRisk.glm}
\alias{predictRisk.rpart}
\alias{predictRisk.gbm}
\alias{predictRisk.flexsurvreg}
\alias{predictRisk.double}
\alias{predictRisk.integer}
\alias{predictRisk.factor}
\alias{predictRisk.numeric}
\alias{predictRisk.formula}
\alias{predictRisk.BinaryTree}
\alias{predictRisk.comprisk}
\alias{predictRisk.coxphTD}
\alias{predictRisk.CSCTD}
\alias{predictRisk.coxph.penal}
\alias{predictRisk.ranger}
\alias{predictRisk.penfitS3}
\alias{predictRisk.SuperPredictor}
\alias{predictRisk.Hal9001}
\alias{predictRisk.GLMnet}
\alias{predictRisk.singleEventCB}
\alias{predictRisk.wglm}
\title{Extrating predicting risks from regression models}
\usage{
predictRisk(object, newdata, ...)

\method{predictRisk}{default}(object, newdata, times, cause, ...)

\method{predictRisk}{double}(object, newdata, times, cause, ...)

\method{predictRisk}{integer}(object, newdata, times, cause, ...)

\method{predictRisk}{factor}(object, newdata, times, cause, ...)

\method{predictRisk}{numeric}(object, newdata, times, cause, ...)

\method{predictRisk}{glm}(object, newdata, iid = FALSE, average.iid = FALSE, ...)

\method{predictRisk}{formula}(object, newdata, ...)

\method{predictRisk}{BinaryTree}(object, newdata, ...)

\method{predictRisk}{lrm}(object, newdata, ...)

\method{predictRisk}{rpart}(object, newdata, ...)

\method{predictRisk}{randomForest}(object, newdata, ...)

\method{predictRisk}{matrix}(object, newdata, times, cause, ...)

\method{predictRisk}{aalen}(object, newdata, times, ...)

\method{predictRisk}{cox.aalen}(object, newdata, times, ...)

\method{predictRisk}{comprisk}(object, newdata, times, ...)

\method{predictRisk}{coxph}(
  object,
  newdata,
  times,
  product.limit = FALSE,
  diag = FALSE,
  iid = FALSE,
  average.iid = FALSE,
  ...
)

\method{predictRisk}{coxphTD}(object, newdata, times, landmark, ...)

\method{predictRisk}{CSCTD}(object, newdata, times, cause, landmark, ...)

\method{predictRisk}{coxph.penal}(object, newdata, times, ...)

\method{predictRisk}{cph}(
  object,
  newdata,
  times,
  product.limit = FALSE,
  diag = FALSE,
  iid = FALSE,
  average.iid = FALSE,
  ...
)

\method{predictRisk}{selectCox}(object, newdata, times, ...)

\method{predictRisk}{prodlim}(object, newdata, times, cause, ...)

\method{predictRisk}{survfit}(object, newdata, times, ...)

\method{predictRisk}{psm}(object, newdata, times, ...)

\method{predictRisk}{ranger}(object, newdata, times, cause, ...)

\method{predictRisk}{rfsrc}(object, newdata, times, cause, ...)

\method{predictRisk}{FGR}(object, newdata, times, cause, ...)

\method{predictRisk}{riskRegression}(object, newdata, times, cause, ...)

\method{predictRisk}{ARR}(object, newdata, times, cause, ...)

\method{predictRisk}{CauseSpecificCox}(
  object,
  newdata,
  times,
  cause,
  product.limit = TRUE,
  diag = FALSE,
  iid = FALSE,
  average.iid = FALSE,
  ...
)

\method{predictRisk}{penfitS3}(object, newdata, times, ...)

\method{predictRisk}{SuperPredictor}(object, newdata, ...)

\method{predictRisk}{gbm}(object, newdata, times, ...)

\method{predictRisk}{flexsurvreg}(object, newdata, times, ...)

\method{predictRisk}{Hal9001}(object, newdata, times, cause, ...)

\method{predictRisk}{GLMnet}(object, newdata, times, ...)

\method{predictRisk}{singleEventCB}(object, newdata, times, cause, ...)

\method{predictRisk}{wglm}(
  object,
  newdata,
  times = NULL,
  product.limit = FALSE,
  diag = FALSE,
  iid = FALSE,
  average.iid = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted model from which to extract predicted event
probabilities.}

\item{newdata}{A data frame containing predictor variable combinations for
which to compute predicted event probabilities.}

\item{\dots}{Additional arguments that are passed on to the current method.}

\item{times}{A vector of times in the range of the response variable, for
which the cumulative incidences event probabilities are computed.}

\item{cause}{Identifies the cause of interest among the competing events.}

\item{iid}{Should the iid decomposition be output using an attribute?}

\item{average.iid}{Should the average iid decomposition be output using an attribute?}

\item{product.limit}{If \code{TRUE} the survival is computed using the product limit estimator.
Otherwise the exponential approximation is used (i.e. exp(-cumulative hazard)).}

\item{diag}{when \code{FALSE} the hazard/cumlative hazard/survival for all observations at all times is computed,
otherwise it is only computed for the i-th observation at the i-th time.}

\item{landmark}{The starting time for the computation of the cumulative risk.}
}
\value{
For binary outcome a vector with predicted risks. For survival outcome with and without
competing risks
a matrix with as many rows as \code{NROW(newdata)} and as many
columns as \code{length(times)}. Each entry is a probability and in
rows the values should be increasing.
}
\description{
Extract event probabilities from fitted regression models and machine learning objects.
The function predictRisk is a generic function, meaning that it invokes
specifically designed functions depending on the 'class' of the first
argument. See \code{\link{predictRisk}}.
}
\details{
In uncensored binary outcome data there is no need to choose a time point.

When operating on models for survival analysis (without competing risks) the function still
predicts the risk, as 1 - S(t|X) where S(t|X) is survival chance of a subject characterized
by X.

When there are competing risks (and the data are right censored) one needs
to specify both the time horizon for prediction (can be a vector) and the
cause of the event. The function then extracts the absolute risks F_c(t|X)
aka the cumulative incidence of an event of type/cause c until time t for a
subject characterized by X. Depending on the model it may or not be possible
to predict the risk of all causes in a competing risks setting. For example. a
cause-specific Cox (CSC) object allows to predict both cases whereas a Fine-Gray regression
model (FGR) is specific to one of the causes.
}
\examples{
## binary outcome
library(rms)
set.seed(7)
d <- sampleData(80,outcome="binary")
nd <- sampleData(80,outcome="binary")
fit <- lrm(Y~X1+X8,data=d)
predictRisk(fit,newdata=nd)

# GLMnet example
fit <- GLMnet(Y~X1+X8,data=d) ## Uses CV as default
predictRisk(fit,newdata=nd)

\dontrun{
library(SuperLearner)
set.seed(1)
sl = SuperLearner(Y = d$Y, X = d[,-1], family = binomial(),
      SL.library = c("SL.mean", "SL.glmnet", "SL.randomForest"))
}

## survival outcome
# generate survival data
library(prodlim)
set.seed(100)
d <- sampleData(100,outcome="survival")
d[,X1:=as.numeric(as.character(X1))]
d[,X2:=as.numeric(as.character(X2))]
# then fit a Cox model
library(rms)
cphmodel <- cph(Surv(time,event)~X1+X2,data=d,surv=TRUE,x=TRUE,y=TRUE)
# or via survival
library(survival)
coxphmodel <- coxph(Surv(time,event)~X1+X2,data=d,x=TRUE,y=TRUE)

# Extract predicted survival probabilities
# at selected time-points:
ttt <- quantile(d$time)
# for selected predictor values:
ndat <- data.frame(X1=c(0.25,0.25,-0.05,0.05),X2=c(0,1,0,1))
# as follows
predictRisk(cphmodel,newdata=ndat,times=ttt)
predictRisk(coxphmodel,newdata=ndat,times=ttt)

# stratified cox model
sfit <- coxph(Surv(time,event)~strata(X1)+X2,data=d,x=TRUE,y=TRUE)
predictRisk(sfit,newdata=d[1:3,],times=c(1,3,5,10))

## simulate learning and validation data
set.seed(10)
learndat <- sampleData(100,outcome="survival")
valdat <- sampleData(100,outcome="survival")
## use the learning data to fit a Cox model
library(survival)
fitCox <- coxph(Surv(time,event)~X1+X2,data=learndat,x=TRUE,y=TRUE)
## suppose we want to predict the survival probabilities for all subjects
## in the validation data at the following time points:
## 0, 12, 24, 36, 48, 60
psurv <- predictRisk(fitCox,newdata=valdat,times=seq(0,60,12))
## This is a matrix with event probabilities (1-survival)
## one column for each of the 5 time points
## one row for each validation set individual

# Use GLMnet to predict survvival probabilities
fitGLMnet <- GLMnet(Surv(time,event)~X1+X8,data=learndat) ## Use CV as standard.
psurv <- predictRisk(fitGLMnet,newdata=valdat,times=seq(0,60,12))

# Use hal9001 as an example
\dontrun{
fitHAL <- Hal9001(Surv(time,event)~X1+X8,data=learndat) ## Use CV as standard.
psurv <- predictRisk(fitHAL,newdata=valdat,times=seq(0,60,12))
}

if (require("randomForestSRC",quietly=TRUE)){
# Do the same for a randomSurvivalForest model
library(randomForestSRC)
rsfmodel <- rfsrc(Surv(time,event)~X1+X2,data=learndat)
prsfsurv=predictRisk(rsfmodel,newdata=valdat,times=seq(0,60,12))
plot(psurv,prsfsurv)
}
## Cox with ridge option
f1 <- coxph(Surv(time,event)~X1+X2,data=learndat,x=TRUE,y=TRUE)
f2 <- coxph(Surv(time,event)~ridge(X1)+ridge(X2),data=learndat,x=TRUE,y=TRUE)
\dontrun{
plot(predictRisk(f1,newdata=valdat,times=10),
     riskRegression:::predictRisk.coxph(f2,newdata=valdat,times=10),
     xlim=c(0,1),
     ylim=c(0,1),
     xlab="Unpenalized predicted survival chance at 10",
     ylab="Ridge predicted survival chance at 10")
}

# aalen model
library(timereg)
data(sTRACE)
out <- aalen(Surv(time, status==9) ~ sex + diabetes + chf + vf,
             data=sTRACE, max.time=7, n.sim=0, resample.iid=1)
print(methods(predictRisk))
predictRisk(object=out, newdata=sTRACE[1:5,], times=c(1, 2, 3))
# cox.aalen model
library(timereg)
data(sTRACE)
out <- cox.aalen(Surv(time,status==9) ~ prop(age) + prop(sex) +
                 prop(diabetes) + chf + vf,
                 data=sTRACE, max.time=7, n.sim=0, resample.iid=1)
predictRisk(object=out, newdata=sTRACE[1:5,], times=c(1, 2, 3))
## competing risks

library(survival)
library(riskRegression)
library(prodlim)
train <- prodlim::SimCompRisk(100)
test <- prodlim::SimCompRisk(10)
cox.fit  <- CSC(Hist(time,cause)~X1+X2,data=train)
predictRisk(cox.fit,newdata=test,times=seq(1:10),cause=1)

## with strata
cox.fit2  <- CSC(list(Hist(time,cause)~strata(X1)+X2,Hist(time,cause)~X1+X2),data=train)
predictRisk(cox.fit2,newdata=test,times=seq(1:10),cause=1)


library(timereg)
data(bmt)
add <- comp.risk(Event(time, cause) ~ platelet + age + tcell, data=bmt, cause=1)
ndata <- data.frame(platelet=c(1, 0, 0), age=c(0, 1, 0), tcell=c(0, 0, 1))
predictRisk(object=add, newdata=ndata, times=c(1, 2, 3))

}
\author{
Thomas A. Gerds \email{tag@biostat.ku.dk}
}
\keyword{survival}
