% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_name}
\alias{call_name}
\alias{call_ns}
\alias{is_call_simple}
\title{Extract function name or namespace of a call}
\usage{
call_name(call)

call_ns(call)

is_call_simple(x, ns = NULL)
}
\arguments{
\item{call}{A defused call.}

\item{x}{An object to test.}

\item{ns}{Whether call is namespaced. If \code{NULL}, \code{is_call_simple()}
is insensitive to namespaces. If \code{TRUE}, \code{is_call_simple()}
detects namespaced calls. If \code{FALSE}, it detects unnamespaced
calls.}
}
\value{
The function name or namespace as a string, or \code{NULL} if
the call is not named or namespaced.
}
\description{
\code{call_name()} and \code{call_ns()} extract the function name or
namespace of \emph{simple} calls as a string. They return \code{NULL} for
complex calls.
\itemize{
\item Simple calls: \code{foo()}, \code{bar::foo()}.
\item Complex calls: \code{foo()()}, \code{bar::foo}, \code{foo$bar()}, \code{(function() NULL)()}.
}

The \code{is_call_simple()} predicate helps you determine whether a call
is simple. There are two invariants you can count on:
\enumerate{
\item If \code{is_call_simple(x)} returns \code{TRUE}, \code{call_name(x)} returns a
string. Otherwise it returns \code{NULL}.
\item If \code{is_call_simple(x, ns = TRUE)} returns \code{TRUE}, \code{call_ns()}
returns a string. Otherwise it returns \code{NULL}.
}
}
\examples{
# Is the function named?
is_call_simple(quote(foo()))
is_call_simple(quote(foo[[1]]()))

# Is the function namespaced?
is_call_simple(quote(list()), ns = TRUE)
is_call_simple(quote(base::list()), ns = TRUE)

# Extract the function name from quoted calls:
call_name(quote(foo(bar)))
call_name(quo(foo(bar)))

# Namespaced calls are correctly handled:
call_name(quote(base::matrix(baz)))

# Anonymous and subsetted functions return NULL:
call_name(quote(foo$bar()))
call_name(quote(foo[[bar]]()))
call_name(quote(foo()()))

# Extract namespace of a call with call_ns():
call_ns(quote(base::bar()))

# If not namespaced, call_ns() returns NULL:
call_ns(quote(bar()))
}
