% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break_antimeridian.R
\name{st_break_antimeridian}
\alias{st_break_antimeridian}
\alias{st_break_antimeridian.sf}
\alias{st_break_antimeridian.sfc}
\title{Break antimeridian for plotting not centred on Greenwich}
\usage{
st_break_antimeridian(x, lon_0 = 0, tol = 1e-04, ...)

\method{st_break_antimeridian}{sf}(x, lon_0 = 0, tol = 1e-04, ...)

\method{st_break_antimeridian}{sfc}(x, lon_0 = 0, tol = 1e-04, ...)
}
\arguments{
\item{x}{object of class \code{sf} or \code{sfc}}

\item{lon_0}{target central longitude (degrees)}

\item{tol}{half of break width (degrees, default 0.0001)}

\item{...}{ignored here}
}
\description{
Longitudes can be broken at the antimeridian of a target central longitude
to permit plotting of (usually world) line or polygon objects centred
on the chosen central longitude. The method may only be used with
non-projected, geographical coordinates and linestring or polygon objects.
s2 is turned off internally to permit the use of a rectangular bounding
box. If the input geometries go outside \verb{[-180, 180]} degrees longitude,
the protruding geometries will also be split using the same \code{tol=}
values; in this case empty geometries will be dropped first.
}
\examples{
\donttest{
if (require("maps", quietly=TRUE)) {
 opar = par(mfrow=c(3, 2))
 wld = st_as_sf(map(fill=FALSE, interior=FALSE, plot=FALSE), fill=FALSE)
 for (lon_0 in c(-170, -90, -10, 10, 90, 170)) {
  wld |> st_break_antimeridian(lon_0=lon_0) |>
   st_transform(paste0("+proj=natearth +lon_0=", lon_0)) |>
   st_geometry() |> plot(main=lon_0)
 }
 par(opar)
}
}
}
