% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tree}
\alias{tree}
\title{Turn the output of \code{\link{str}()} into a tree diagram}
\usage{
tree(...)
}
\arguments{
\item{...}{Arguments to be passed to \code{\link{str}()} (note that the
\code{comp.str} is hardcoded inside this function, and it is the only
argument that you cannot customize).}
}
\value{
A character string as a \code{\link{raw_string}()}.
}
\description{
The super useful function \code{str()} uses \verb{..} to indicate the level
of sub-elements of an object, which may be difficult to read. This function
uses vertical pipes to connect all sub-elements on the same level, so it is
clearer which elements belong to the same parent element in an object with a
nested structure (such as a nested list).
}
\examples{
fit = lsfit(1:9, 1:9)
str(fit)
xfun::tree(fit)

fit = lm(dist ~ speed, data = cars)
str(fit)
xfun::tree(fit)

# some trivial examples
xfun::tree(1:10)
xfun::tree(iris)
}
