=begin
= Ruby/PGPLOT

A Ruby interface to the
((<PGPLOT|URL:http://astro.caltech.edu/~tjp/pgplot/>))
graphics library.

* ((<Repository(GitHub)|URL:https://github.com/masa16/ruby-pgplot>))

== Requirement

* ((<PGPLOT Library|URL:http://www.astro.caltech.edu/~tjp/pgplot/>))
* GNU FORTRAN compiler
* ((<NArray|URL:http://masa16.github.io/narray/>)) version 0.5 or 0.6 (no plan to support narray-devel)

== Download

* ((<Releases|URL:https://github.com/masa16/ruby-pgplot/releases>))

== Installation

* PGPLOT
  * ((<in Japanese|URL:install.html.ja>))
  * ((<original site|URL:http://www.astro.caltech.edu/~tjp/pgplot/install.html>))
* Install Ruby/PGPLOT
  * ((<in English|URL:README>))
  * ((<in Japanese|URL:README.ja>))

== Examples

* ((<(({pgline})) : Line plot|URL:pgline.html>))
* ((<(({pghist})) : Histogram plot|URL:pghist.html>))
* ((<(({pgcont})) : Contour map|URL:pgcont.html>))
* ((<(({pgimag})) : Image map|URL:pgimag.html>))

== Manual

* ((<Method index Categorized|URL:rbpg-ind.html>))
* ((<Method index and Description|URL:rbpgplot.html>))
* ((<Tutorial|URL:tutorial-01.html.ja>)) (in Japanese)
* ((<Reference|URL:method.html.ja>)) (in Japanese)

== Link

* ((<Rongo|URL:http://jun.artcompsci.org/softwares/rongo/>))
  - simple mongo-like plotting library using Ruby/PGPLOT.

=end
