Rust Interface for the Stateless OpenPGP Protocol
=================================================

A set of types and traits formalizing the [Stateless OpenPGP
Protocol].  Currently, SOP is only defined as a command line
interface, but we are working on a [C Interface].  This interface is
the Rust equivalent of the yet to be defined C API.

[Stateless OpenPGP Protocol]: https://gitlab.com/dkg/openpgp-stateless-cli
[C Interface]: https://gitlab.com/dkg/openpgp-stateless-cli/-/issues/32

Command Line Interface
----------------------

This crate contains an implementation of the Stateless OpenPGP Command
Line Interface in terms of the Rust types and traits.  Once you
implemented the traits, you get the command line interface basically
for free by adding this snippet to your `Cargo.toml`:

```toml
[[bin]]
path = "src/main.rs"
required-features = ["cli"]

[features]
cli = ["sop/cli"]
```

And creating `src/main.rs` along the lines of:

```rust
fn main() {
    sop::cli::main(&MySOPImplementation::default());
}
```
