/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.common.sphgeom;

import cds.healpix.common.math.Math;
import java.util.Locale;

public final class Vect3D {
    private final double x;
    private final double y;
    private final double z;

    public Vect3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vect3D(double lonRad, double latRad) {
        double cosDec = java.lang.Math.cos(latRad);
        this.x = cosDec * java.lang.Math.cos(lonRad);
        this.y = cosDec * java.lang.Math.sin(lonRad);
        this.z = java.lang.Math.sin(latRad);
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public Vect3D clone() {
        return new Vect3D(this.x, this.y, this.z);
    }

    public double toLon() {
        double tmp = java.lang.Math.atan2(this.y, this.x);
        return tmp < 0.0 ? java.lang.Math.PI * 2 + tmp : tmp;
    }

    public double toLat() {
        return Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y));
    }

    public Vect3D opposite() {
        return new Vect3D(-this.x, -this.y, -this.z);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final Vect3D normalized() {
        double norm = this.norm();
        return new Vect3D(this.x / norm, this.y / norm, this.z / norm);
    }

    public static double scalarProd(Vect3D v1, Vect3D v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public static Vect3D crossProd(Vect3D v1, Vect3D v2) {
        return new Vect3D(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
    }

    public final String toString() {
        return String.format(Locale.US, "(%+011.9f, %+011.9f, %+011.9f)", this.x, this.y, this.z);
    }
}

