#include <vdk/vdkprops.h>
#include <iostream>

class TestProp
{
public:
     TestProp(char* val)
	  : prop1("property 1", this, 0),
	    prop2("property 2", this, "Defaultvalue for property"),
            prop3("property 3", this, val)
     {}
     VDKReadWriteValueProp<TestProp, int> prop1;
     VDKReadWriteValueProp<TestProp, const char*> prop2;
     VDKReadWriteValueProp<TestProp, char*> prop3;
};

void report_prop1(int x){
     cout << "Property changed to: " << x << endl;
}

void report_prop2(const char* str){
     cout << "Property changed to: " << str << endl;
}

int main(int argc, char** argv)
{
<<<<<<< props_test.cc
     char* val=new char [sizeof("HALLO")];
     strcpy(val,"HALLO");

     TestProp obj(val);
     int works=obj.prop1.Value();
//     char* wont_work=obj.prop2.Value();
     char * back_door=obj.prop3.Value();
//     back_door[0]='_';
     cout << back_door << endl;

=======
     TestProp obj;
#define TEST_CONST_CAST 0
#if TEST_CONST_CAST     
     // If the following line works, something is wrong,
     // compiler should abort with '..lacks a cast'.
     char* back_door=obj.prop3.Value();
     back_door[0]="_";
#endif
>>>>>>> 1.4
     cout << "Object initial state: " << endl
          << "Prop 1: " << obj.prop1.Value() << endl
          << "prop 2: " << obj.prop2.Value() << endl
          << "Prop 3: " << obj.prop3.Value() << endl;

     obj.prop1.OnValueChanged.connect(slot(report_prop1));
     obj.prop2.OnValueChanged.connect(slot(report_prop2));     
     obj.prop1=1;
     obj.prop2="Changed Prop";
     cout << "You should have changes made to the props";
     return 1;
}
