#include <vdk/sigc_eventsignals.h>
#include <vdk/sigc_eventtraits.h>
#include <sigc_eventtraits.cc>
#include <vdk/vdkobj.h>

/** **********************************************************************
 *                      VDKAnyEventSignal
 *  **********************************************************************/

VDKRawEventSignal::VDKRawEventSignal(VDKObject* obj)
     : _obj(obj),
       _handler_id(0)
{};

VDKRawEventSignal::~VDKRawEventSignal()
{
     if(_handler_id!=0){
	  gtk_signal_disconnect(GTK_OBJECT(_obj->ConnectingWidget()),
				_handler_id);
     }
};

Connection
VDKRawEventSignal::connect(const Slot2<void, VDKObject*, 
			   const GdkEvent*>& sl)
{
     if(_handler_id==0)
	  _handler_id=gtk_signal_connect(GTK_OBJECT(_obj->ConnectingWidget()),
					 "event",
					 GTK_SIGNAL_FUNC(&VDKRawEventSignal::event_handler),
					 (gpointer) this);
     return VDKSignal1<void, const GdkEvent *>::connect(sl);
}

Connection
VDKRawEventSignal::connect(const Slot1<void, const GdkEvent*>& sl)
{
     if(_handler_id==0)
	  _handler_id=gtk_signal_connect(GTK_OBJECT(_obj->ConnectingWidget()),
					 "event",
					 GTK_SIGNAL_FUNC(&VDKRawEventSignal::event_handler),
					 (gpointer) this);
     return VDKSignal1<void, const GdkEvent*>::connect(sl);
}

void
VDKRawEventSignal::disconnect(Connection& c)
{
     c.disconnect();
     if(empty() && _handler_id!=0){
	  gtk_signal_disconnect(GTK_OBJECT(_obj->ConnectingWidget()),
				_handler_id);
	  _handler_id=0;
     }
}

gint
VDKRawEventSignal::event_handler(GtkObject* wid, 
				 GdkEvent* eve,
				 gpointer sig)
{
     VDKRawEventSignal* s=reinterpret_cast<VDKRawEventSignal*>(sig);
     s->emit(s->_obj, eve);
     return FALSE;
}
/* ***********************************************************************
 * *                         DirectEventSignal                           *
 * **********************************************************************/
template<W2_TraitEnum id, class T_vevent>
DirectEventSignal<id,T_vevent>::~DirectEventSignal()
{
     if(_handler_id)
	  gtk_signal_disconnect(GTK_OBJECT(_sender->ConnectingWidget()),
				_handler_id);
}

template<W2_TraitEnum id, class T_vevent>
Connection
DirectEventSignal<id, T_vevent>::connect(const Slot2<void,VDKObject*,const T_vevent &>& sl)
{
     if(_handler_id==0){ // ensure gtksigc connectivity
	  _handler_id=gtk_signal_connect(GTK_OBJECT(_sender->ConnectingWidget()),
					 T_trait::signame,
					 GTK_SIGNAL_FUNC(&DirectEventSignal::event_handler),
					 (gpointer) this);
     }
     return VDKSignal1<void, const T_vevent&>::connect(sl);
}

template<W2_TraitEnum id, class T_vevent>
Connection
DirectEventSignal<id, T_vevent>::connect(const Slot1<void,const T_vevent &>& sl)
{
     if(_handler_id==0){ // ensure gtksigc connectivity
	  _handler_id=gtk_signal_connect(GTK_OBJECT(_sender->ConnectingWidget()),
					 T_trait::signame,
					 GTK_SIGNAL_FUNC(&DirectEventSignal::event_handler),
					 (gpointer) this);
     }
     return VDKSignal1<void, const T_vevent&>::connect(sl);
}

template<W2_TraitEnum id, class T_vevent>
void
DirectEventSignal<id, T_vevent>::disconnect(Connection& con)
{
     con.disconnect();
     if(empty()){
	  gtk_signal_disconnect(GTK_OBJECT(_sender->ConnectingWidget()),
				_handler_id);
	  _handler_id=0;
     }
}

template<W2_TraitEnum id, class T_vevent>
void
DirectEventSignal<id, T_vevent>::event_handler(GtkObject*, GdkEvent* eve, gpointer obj)
{
     DirectEventSignal* s=
	  reinterpret_cast<DirectEventSignal*>(obj);
     s->emit(s->_sender,T_vevent((const T_trait::ge_type *) eve,
				 s->_sender));
}

/* ************************************************************************
 * ***********             SignalWrapperStage1M2                ***********
 * ***********************************************************************/

template<W2_TraitEnum id1, int sc1, W2_TraitEnum id2, int sc2, class T_vevent>
bool 
SignalWrapperStage1M2<id1,sc1,id2,sc2,T_vevent>::empty() const
{
     return (swrap1.empty() && swrap2.empty());
}

template<W2_TraitEnum id1, int sc1, W2_TraitEnum id2, int sc2, class T_vevent>
Connection 
SignalWrapperStage1M2<id1,sc1,id2,sc2,T_vevent>::connect(const Slot2<void, VDKObject*, const T_vevent&>& sl, T_vcmp spec)
{
     Connection res;
     if(swrap1.responsible(spec))
	  res=swrap1.connect(sl, spec); // Overhead, i know. Will be 
                                        // removed when
     else if(swrap2.responsible(spec))  // Expressiontemplates are used
	  res=swrap2.connect(sl, spec); 
     return res;
}

template<W2_TraitEnum id1, int sc1, W2_TraitEnum id2, int sc2, class T_vevent>
Connection 
SignalWrapperStage1M2<id1,sc1,id2,sc2,T_vevent>::connect(const Slot1<void, const T_vevent&>& sl,
						 T_vcmp spec)
{
     Connection res;
     if(swrap1.responsible(spec))
	  res=swrap1.connect(sl, spec); 
     else if(swrap2.responsible(spec))  
	  res=swrap2.connect(sl, spec); 
     return res;
}

template<W2_TraitEnum id1, int sc1, W2_TraitEnum id2, int sc2,class T_vevent>
void 
SignalWrapperStage1M2<id1,sc1,id2,sc2,T_vevent>::disconnect(Connection& con)
{
     con.disconnect();
     swrap1.cleanup();
     swrap2.cleanup();
}

/* ************************************************************************
 * *******                 SignalWrapperStage2Base             ************
 * ***********************************************************************/
template<W2_TraitEnum id, class T_vevent, int sc, class leaf>
SignalWrapperStage2Base<id,T_vevent,sc,leaf>::~SignalWrapperStage2Base()
{
     // Hope connections will be destroyed autom.
     if(_handler_id)
	  gtk_signal_disconnect(GTK_OBJECT(_sender->ConnectingWidget()),
				_handler_id);
}

template<W2_TraitEnum id, class T_vevent, int sc, class leaf>
void
SignalWrapperStage2Base<id,T_vevent,sc,leaf>::cleanup(){
     if(empty() && (_handler_id!=0)){ // second is (should be) irrelevant
	  gtk_signal_disconnect(GTK_OBJECT(_sender->ConnectingWidget()),
				_handler_id);
	  _handler_id=0;
     }
}

template<W2_TraitEnum id, class T_vevent, int sc, class leaf>
Connection
SignalWrapperStage2Base<id,T_vevent,sc,leaf>::connect(const Slot2<void,VDKObject*,
						                  const T_vevent &>& sl,
						      T_vcmp spec)
{
     Connection res;
     int vpos=leaf::vdk2vec(spec);
     if(vpos!=-1){ // we are responsible
	  if(_handler_id==0){ // ensure gtksigc connectivity
	       _handler_id=gtk_signal_connect(GTK_OBJECT(_sender->ConnectingWidget()),
					      Trait::signame,
					      GTK_SIGNAL_FUNC(&SignalWrapperStage2Base::event_handler),
					      (gpointer) this);
	  }
	  res=sig_vec[vpos].connect(sl);
     } 
     return res;
}

template<W2_TraitEnum id, class T_vevent, int sc, class leaf>
Connection
SignalWrapperStage2Base<id,T_vevent,sc,leaf>::connect(const Slot1<void,const T_vevent &>& sl,
					       T_vcmp spec)
{
     Connection res;
     int vpos=leaf::vdk2vec(spec);
     if(vpos!=-1){ // we are responsible 
	  if(_handler_id==0){ // ensure gtksigc connectivity
	       _handler_id=gtk_signal_connect(GTK_OBJECT(_sender->ConnectingWidget()),
					       Trait::signame,
					       GTK_SIGNAL_FUNC(&SignalWrapperStage2Base::event_handler),
					       (gpointer) this);
	  }
	  res=sig_vec[vpos].connect(sl);
     } 
     return res;
}

template<W2_TraitEnum id, class T_vevent, int sc, class leaf>
void
SignalWrapperStage2Base<id,T_vevent,sc,leaf>::event_handler(GtkObject* wid,
						     GdkEvent* eve,
						     gpointer obj)
{
     int pos=leaf::eve2vec(eve);
     if(pos!=-1){
	  SignalWrapperStage2Base<id,T_vevent,sc,leaf>* s=
	       reinterpret_cast<SignalWrapperStage2Base<id,T_vevent,sc,leaf>* >(obj);
	  s->sig_vec[pos].emit(s->_sender,T_vevent((const Trait::ge_type *) eve,
						   s->_sender));
     }
}

template<W2_TraitEnum id, class T_vevent, int sc, class leaf>
bool
SignalWrapperStage2Base<id,T_vevent,sc,leaf>::empty() const
{
     bool e_flag=false; // read: isEmpty-Flag
     for(int i=0; i < sc && !e_flag ; i++){
	  e_flag=sig_vec[i].empty();
     }
     return e_flag;     
}

template<W2_TraitEnum id, class T_vevent, int sc, class leaf>
bool
SignalWrapperStage2Base<id,T_vevent,sc,leaf>::responsible(T_vcmp spec) const
{
     return (leaf::vdk2vec(spec) != -1);
}

/* ************************************************************************** 
 *                   (Partial) Specializations of above                     *
 * **************************************************************************/

/* 1 value to compare */
template<W2_TraitEnum id, class T_vevent>
int
SignalWrapperStage2<id,T_vevent,1>::eve2vec(GdkEvent* eve)
{
     T_gcmp cmpval=W2_Trait<id>::Field(eve);
     if(cmpval==W2_Trait<id>::GN1)
	  return 0;
     return -1;
}

template<W2_TraitEnum id, class T_vevent>
int
SignalWrapperStage2<id,T_vevent,1>::vdk2vec(T_vcmp val)
{
     if(val==W2_Trait<id>::EN1)
	  return 0;
     return -1;
}

/* 2 value to compare */
template<W2_TraitEnum id, class T_vevent>
int
SignalWrapperStage2<id,T_vevent,2>::eve2vec(GdkEvent* eve)
{
     T_gcmp cmpval=W2_Trait<id>::Field(eve);
     switch(cmpval){
     case W2_Trait<id>::GN1:
	  return 0;
     case W2_Trait<id>::GN2:
	  return 1;
     default:
	  break;
     }
     return -1;
}

template<W2_TraitEnum id, class T_vevent>
int
SignalWrapperStage2<id,T_vevent,2>::vdk2vec(T_vcmp val)
{
     switch(val){
     case W2_Trait<id>::EN1:
	  return 0;
     case W2_Trait<id>::EN2:
	  return 1;
     default:
	  break;
     }
     return -1;
}

/* 3 value to compare */
template<W2_TraitEnum id, class T_vevent>
int
SignalWrapperStage2<id,T_vevent,3>::eve2vec(GdkEvent* eve)
{
     T_gcmp cmpval=W2_Trait<id>::Field(eve);
     switch(cmpval){
     case W2_Trait<id>::GN1:
	  return 0;
     case W2_Trait<id>::GN2:
	  return 1;
     case W2_Trait<id>::GN3:
	  return 2;
     default:
	  break;
     }
     return -1;
}

template<W2_TraitEnum id, class T_vevent>
int
SignalWrapperStage2<id,T_vevent,3>::vdk2vec(T_vcmp val)
{
     switch(val){
     case W2_Trait<id>::EN1:
	  return 0;
     case W2_Trait<id>::EN2:
	  return 1;
     case W2_Trait<id>::EN3:
	  return 2;
     default:
	  break;
     }
     return -1;
}

///////////
template VDKButtonSignal;
template VDKKeySignal;
template VDKKeyFocusSignal;
template VDKPointerFocusSignal;
template VDKPointerSignal;
template VDKMapSignal;
template VDKGeometrySignal;
template VDKPaintSignal;
