// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SHSUB_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SHSUB_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_shsub_4S[] = {
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff80, 0xffc04100, 0x003ffe80, 0xffffffff,
  0xffc04080, 0x00003f80, 0x003ffe7f, 0xffffffff,
  0x00003f00, 0x00003f7f, 0x003ffe7f, 0xfffffff0,
  0x00003eff, 0x00003f7f, 0x003ffe70, 0xffffffc1,
  0x00003eff, 0x00003f70, 0x003ffe41, 0xffffffc1,
  0x00003ef0, 0x00003f41, 0x003ffe41, 0xffffffc0,
  0x00003ec1, 0x00003f41, 0x003ffe40, 0xffffc001,
  0x00003ec1, 0x00003f40, 0x003fbe81, 0xffffc001,
  0x00003ec0, 0xffffff81, 0x003fbe81, 0xffffc000,
  0xffffff01, 0xffffff81, 0x003fbe80, 0xe6666666,
  0xffffff01, 0xffffff80, 0xe6a664e6, 0xd5555555,
  0xffffff00, 0xe666a5e6, 0xd59553d5, 0xc0000001,
  0xe666a566, 0xd55594d5, 0xc03ffe81, 0xc0000001,
  0xd5559455, 0xc0003f81, 0xc03ffe81, 0xc0000000,
  0xc0003f01, 0xc0003f81, 0xc03ffe80, 0x40000000,
  0xc0003f01, 0xc0003f80, 0x403ffe80, 0x3fffffff,
  0xc0003f00, 0x40003f80, 0x403ffe7f, 0x2aaaaaab,
  0x40003f00, 0x40003f7f, 0x2aeaa92b, 0x1999999a,
  0x40003eff, 0x2aaaea2b, 0x19d9981a, 0x00004000,
  0x2aaae9ab, 0x1999d91a, 0x00403e80, 0x00003fff,
  0x1999d89a, 0x00007f80, 0x00403e7f, 0x00003fff,
  0x00007f00, 0x00007f7f, 0x00403e7f, 0x00003ffe,
  0x00007eff, 0x00007f7f, 0x00403e7e, 0x00000040,
  0x00007eff, 0x00007f7e, 0x003ffec0, 0x0000003f,
  0x00007efe, 0x00003fc0, 0x003ffebf, 0x0000003f,
  0x00003f40, 0x00003fbf, 0x003ffebf, 0x0000003e,
  0x00003f3f, 0x00003fbf, 0x003ffebe, 0x00000010,
  0x00003f3f, 0x00003fbe, 0x003ffe90, 0x00000001,
  0x00003f3e, 0x00003f90, 0x003ffe81, 0x00000001,
  0x00003f10, 0x00003f81, 0x003ffe81, 0x00000000,
  0x00003f81, 0x003ffe81, 0x00000000, 0x00000000,
  0x00003f81, 0x003ffe80, 0x00000000, 0x00000000,
  0x00003f80, 0x003ffe80, 0xffffffff, 0xffffffff,
  0x00003f80, 0x003ffe7f, 0xffffffff, 0xfffffff0,
  0x00003f7f, 0x003ffe7f, 0xfffffff0, 0xffffffc2,
  0x00003f7f, 0x003ffe70, 0xffffffc1, 0xffffffc1,
  0x00003f70, 0x003ffe41, 0xffffffc1, 0xffffffc1,
  0x00003f41, 0x003ffe41, 0xffffffc0, 0xffffc002,
  0x00003f41, 0x003ffe40, 0xffffc001, 0xffffc001,
  0x00003f40, 0x003fbe81, 0xffffc001, 0xffffc001,
  0xffffff81, 0x003fbe81, 0xffffc000, 0xe6666667,
  0xffffff81, 0x003fbe80, 0xe6666666, 0xd5555556,
  0xffffff80, 0xe6a664e6, 0xd5555555, 0xc0000002,
  0xe666a5e6, 0xd59553d5, 0xc0000001, 0xc0000001,
  0xd55594d5, 0xc03ffe81, 0xc0000001, 0xc0000001,
  0xc0003f81, 0xc03ffe81, 0xc0000000, 0x40000000,
  0xc0003f81, 0xc03ffe80, 0x40000000, 0x40000000,
  0xc0003f80, 0x403ffe80, 0x3fffffff, 0x2aaaaaab,
  0x40003f80, 0x403ffe7f, 0x2aaaaaab, 0x1999999a,
  0x40003f7f, 0x2aeaa92b, 0x1999999a, 0x00004000,
  0x2aaaea2b, 0x19d9981a, 0x00004000, 0x00004000,
  0x1999d91a, 0x00403e80, 0x00003fff, 0x00003fff,
  0x00007f80, 0x00403e7f, 0x00003fff, 0x00003fff,
  0x00007f7f, 0x00403e7f, 0x00003ffe, 0x00000040,
  0x00007f7f, 0x00403e7e, 0x00000040, 0x00000040,
  0x00007f7e, 0x003ffec0, 0x0000003f, 0x0000003f,
  0x00003fc0, 0x003ffebf, 0x0000003f, 0x0000003f,
  0x00003fbf, 0x003ffebf, 0x0000003e, 0x00000010,
  0x00003fbf, 0x003ffebe, 0x00000010, 0x00000002,
  0x00003fbe, 0x003ffe90, 0x00000001, 0x00000001,
  0x00003f90, 0x003ffe81, 0x00000001, 0x00000001,
  0x003ffe81, 0x00000001, 0x00000001, 0x00000001,
  0x003ffe81, 0x00000000, 0x00000000, 0x00000000,
  0x003ffe80, 0x00000000, 0x00000000, 0x00000000,
  0x003ffe80, 0xffffffff, 0xffffffff, 0xfffffff1,
  0x003ffe7f, 0xffffffff, 0xfffffff0, 0xffffffc2,
  0x003ffe7f, 0xfffffff0, 0xffffffc2, 0xffffffc2,
  0x003ffe70, 0xffffffc1, 0xffffffc1, 0xffffffc1,
  0x003ffe41, 0xffffffc1, 0xffffffc1, 0xffffc002,
  0x003ffe41, 0xffffffc0, 0xffffc002, 0xffffc002,
  0x003ffe40, 0xffffc001, 0xffffc001, 0xffffc001,
  0x003fbe81, 0xffffc001, 0xffffc001, 0xe6666667,
  0x003fbe81, 0xffffc000, 0xe6666667, 0xd5555556,
  0x003fbe80, 0xe6666666, 0xd5555556, 0xc0000002,
  0xe6a664e6, 0xd5555555, 0xc0000002, 0xc0000002,
  0xd59553d5, 0xc0000001, 0xc0000001, 0xc0000001,
  0xc03ffe81, 0xc0000001, 0xc0000001, 0x40000001,
  0xc03ffe81, 0xc0000000, 0x40000000, 0x40000000,
  0xc03ffe80, 0x40000000, 0x40000000, 0x2aaaaaac,
  0x403ffe80, 0x3fffffff, 0x2aaaaaab, 0x1999999b,
  0x403ffe7f, 0x2aaaaaab, 0x1999999a, 0x00004001,
  0x2aeaa92b, 0x1999999a, 0x00004000, 0x00004000,
  0x19d9981a, 0x00004000, 0x00004000, 0x00004000,
  0x00403e80, 0x00003fff, 0x00003fff, 0x00003fff,
  0x00403e7f, 0x00003fff, 0x00003fff, 0x00000041,
  0x00403e7f, 0x00003ffe, 0x00000040, 0x00000040,
  0x00403e7e, 0x00000040, 0x00000040, 0x00000040,
  0x003ffec0, 0x0000003f, 0x0000003f, 0x0000003f,
  0x003ffebf, 0x0000003f, 0x0000003f, 0x00000011,
  0x003ffebf, 0x0000003e, 0x00000010, 0x00000002,
  0x003ffebe, 0x00000010, 0x00000002, 0x00000002,
  0x003ffe90, 0x00000001, 0x00000001, 0x00000001,
  0x00000001, 0x00000001, 0x00000001, 0x00000010,
  0x00000001, 0x00000001, 0x00000001, 0x0000000f,
  0x00000000, 0x00000000, 0x00000000, 0x0000000f,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xfffffff1, 0xffffffd1,
  0xffffffff, 0xfffffff0, 0xffffffc2, 0xffffffd1,
  0xfffffff0, 0xffffffc2, 0xffffffc2, 0xffffffd0,
  0xffffffc1, 0xffffffc1, 0xffffffc1, 0xffffc011,
  0xffffffc1, 0xffffffc1, 0xffffc002, 0xffffc011,
  0xffffffc0, 0xffffc002, 0xffffc002, 0xffffc010,
  0xffffc001, 0xffffc001, 0xffffc001, 0xe6666676,
  0xffffc001, 0xffffc001, 0xe6666667, 0xd5555565,
  0xffffc000, 0xe6666667, 0xd5555556, 0xc0000011,
  0xe6666666, 0xd5555556, 0xc0000002, 0xc0000011,
  0xd5555555, 0xc0000002, 0xc0000002, 0xc0000010,
  0xc0000001, 0xc0000001, 0xc0000001, 0x40000010,
  0xc0000001, 0xc0000001, 0x40000001, 0x4000000f,
  0xc0000000, 0x40000000, 0x40000000, 0x2aaaaabb,
  0x40000000, 0x40000000, 0x2aaaaaac, 0x199999aa,
  0x3fffffff, 0x2aaaaaab, 0x1999999b, 0x00004010,
  0x2aaaaaab, 0x1999999a, 0x00004001, 0x0000400f,
  0x1999999a, 0x00004000, 0x00004000, 0x0000400f,
  0x00004000, 0x00004000, 0x00004000, 0x0000400e,
  0x00003fff, 0x00003fff, 0x00003fff, 0x00000050,
  0x00003fff, 0x00003fff, 0x00000041, 0x0000004f,
  0x00003ffe, 0x00000040, 0x00000040, 0x0000004f,
  0x00000040, 0x00000040, 0x00000040, 0x0000004e,
  0x0000003f, 0x0000003f, 0x0000003f, 0x00000020,
  0x0000003f, 0x0000003f, 0x00000011, 0x00000011,
  0x0000003e, 0x00000010, 0x00000002, 0x00000011,
  0x00000010, 0x00000002, 0x00000002, 0x00000010,
  0x00000002, 0x00000002, 0x00000010, 0x0000003e,
  0x00000001, 0x00000001, 0x00000010, 0x0000003e,
  0x00000001, 0x00000001, 0x0000000f, 0x0000003d,
  0x00000000, 0x00000000, 0x0000000f, 0x0000002e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xfffffff1, 0xffffffd1, 0xffffffff,
  0xfffffff0, 0xffffffc2, 0xffffffd1, 0xffffffff,
  0xffffffc2, 0xffffffc2, 0xffffffd0, 0xffffc040,
  0xffffffc1, 0xffffffc1, 0xffffc011, 0xffffc03f,
  0xffffffc1, 0xffffc002, 0xffffc011, 0xffffc03f,
  0xffffc002, 0xffffc002, 0xffffc010, 0xe66666a5,
  0xffffc001, 0xffffc001, 0xe6666676, 0xd5555594,
  0xffffc001, 0xe6666667, 0xd5555565, 0xc0000040,
  0xe6666667, 0xd5555556, 0xc0000011, 0xc000003f,
  0xd5555556, 0xc0000002, 0xc0000011, 0xc000003f,
  0xc0000002, 0xc0000002, 0xc0000010, 0x4000003e,
  0xc0000001, 0xc0000001, 0x40000010, 0x4000003e,
  0xc0000001, 0x40000001, 0x4000000f, 0x2aaaaae9,
  0x40000000, 0x40000000, 0x2aaaaabb, 0x199999d8,
  0x40000000, 0x2aaaaaac, 0x199999aa, 0x0000403e,
  0x2aaaaaab, 0x1999999b, 0x00004010, 0x0000403e,
  0x1999999a, 0x00004001, 0x0000400f, 0x0000403d,
  0x00004000, 0x00004000, 0x0000400f, 0x0000403d,
  0x00004000, 0x00004000, 0x0000400e, 0x0000007e,
  0x00003fff, 0x00003fff, 0x00000050, 0x0000007e,
  0x00003fff, 0x00000041, 0x0000004f, 0x0000007d,
  0x00000040, 0x00000040, 0x0000004f, 0x0000007d,
  0x00000040, 0x00000040, 0x0000004e, 0x0000004e,
  0x0000003f, 0x0000003f, 0x00000020, 0x00000040,
  0x0000003f, 0x00000011, 0x00000011, 0x0000003f,
  0x00000010, 0x00000002, 0x00000011, 0x0000003f,
  0x00000002, 0x00000011, 0x0000003f, 0x0000003f,
  0x00000002, 0x00000010, 0x0000003e, 0x0000003e,
  0x00000001, 0x00000010, 0x0000003e, 0x0000003e,
  0x00000001, 0x0000000f, 0x0000003d, 0x0000002f,
  0x00000000, 0x0000000f, 0x0000002e, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xfffffff1, 0xffffffd1, 0xffffffff, 0xffffffff,
  0xffffffc2, 0xffffffd1, 0xffffffff, 0xffffc040,
  0xffffffc2, 0xffffffd0, 0xffffc040, 0xffffc040,
  0xffffffc1, 0xffffc011, 0xffffc03f, 0xffffc03f,
  0xffffc002, 0xffffc011, 0xffffc03f, 0xe66666a5,
  0xffffc002, 0xffffc010, 0xe66666a5, 0xd5555594,
  0xffffc001, 0xe6666676, 0xd5555594, 0xc0000040,
  0xe6666667, 0xd5555565, 0xc0000040, 0xc0000040,
  0xd5555556, 0xc0000011, 0xc000003f, 0xc000003f,
  0xc0000002, 0xc0000011, 0xc000003f, 0x4000003f,
  0xc0000002, 0xc0000010, 0x4000003e, 0x4000003e,
  0xc0000001, 0x40000010, 0x4000003e, 0x2aaaaaea,
  0x40000001, 0x4000000f, 0x2aaaaae9, 0x199999d9,
  0x40000000, 0x2aaaaabb, 0x199999d8, 0x0000403f,
  0x2aaaaaac, 0x199999aa, 0x0000403e, 0x0000403e,
  0x1999999b, 0x00004010, 0x0000403e, 0x0000403e,
  0x00004001, 0x0000400f, 0x0000403d, 0x0000403d,
  0x00004000, 0x0000400f, 0x0000403d, 0x0000007f,
  0x00004000, 0x0000400e, 0x0000007e, 0x0000007e,
  0x00003fff, 0x00000050, 0x0000007e, 0x0000007e,
  0x00000041, 0x0000004f, 0x0000007d, 0x0000007d,
  0x00000040, 0x0000004f, 0x0000007d, 0x0000004f,
  0x00000040, 0x0000004e, 0x0000004e, 0x00000040,
  0x0000003f, 0x00000020, 0x00000040, 0x00000040,
  0x00000011, 0x00000011, 0x0000003f, 0x0000003f,
  0x00000011, 0x0000003f, 0x0000003f, 0x0000003f,
  0x00000011, 0x0000003f, 0x0000003f, 0x0000003f,
  0x00000010, 0x0000003e, 0x0000003e, 0x0000003e,
  0x00000010, 0x0000003e, 0x0000003e, 0x0000002f,
  0x0000000f, 0x0000003d, 0x0000002f, 0x00000001,
  0x0000000f, 0x0000002e, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffd1, 0xffffffff, 0xffffffff, 0xffffc041,
  0xffffffd1, 0xffffffff, 0xffffc040, 0xffffc040,
  0xffffffd0, 0xffffc040, 0xffffc040, 0xffffc040,
  0xffffc011, 0xffffc03f, 0xffffc03f, 0xe66666a6,
  0xffffc011, 0xffffc03f, 0xe66666a5, 0xd5555595,
  0xffffc010, 0xe66666a5, 0xd5555594, 0xc0000041,
  0xe6666676, 0xd5555594, 0xc0000040, 0xc0000040,
  0xd5555565, 0xc0000040, 0xc0000040, 0xc0000040,
  0xc0000011, 0xc000003f, 0xc000003f, 0x4000003f,
  0xc0000011, 0xc000003f, 0x4000003f, 0x4000003f,
  0xc0000010, 0x4000003e, 0x4000003e, 0x2aaaaaea,
  0x40000010, 0x4000003e, 0x2aaaaaea, 0x199999d9,
  0x4000000f, 0x2aaaaae9, 0x199999d9, 0x0000403f,
  0x2aaaaabb, 0x199999d8, 0x0000403f, 0x0000403f,
  0x199999aa, 0x0000403e, 0x0000403e, 0x0000403e,
  0x00004010, 0x0000403e, 0x0000403e, 0x0000403e,
  0x0000400f, 0x0000403d, 0x0000403d, 0x0000007f,
  0x0000400f, 0x0000403d, 0x0000007f, 0x0000007f,
  0x0000400e, 0x0000007e, 0x0000007e, 0x0000007e,
  0x00000050, 0x0000007e, 0x0000007e, 0x0000007e,
  0x0000004f, 0x0000007d, 0x0000007d, 0x0000004f,
  0x0000004f, 0x0000007d, 0x0000004f, 0x00000041,
  0x0000004e, 0x0000004e, 0x00000040, 0x00000040,
  0x00000020, 0x00000040, 0x00000040, 0x00000040,
  0x00000040, 0x00000040, 0x00000040, 0x00003ffe,
  0x0000003f, 0x0000003f, 0x0000003f, 0x00003ffe,
  0x0000003f, 0x0000003f, 0x0000003f, 0x00003ffd,
  0x0000003e, 0x0000003e, 0x0000003e, 0x00003fee,
  0x0000003e, 0x0000003e, 0x0000002f, 0x00003fc0,
  0x0000003d, 0x0000002f, 0x00000001, 0x00003fbf,
  0x0000002e, 0x00000000, 0x00000000, 0x00003fbf,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffc041, 0xffffffff,
  0xffffffff, 0xffffc040, 0xffffc040, 0xffffffff,
  0xffffc040, 0xffffc040, 0xffffc040, 0xe666a665,
  0xffffc03f, 0xffffc03f, 0xe66666a6, 0xd5559554,
  0xffffc03f, 0xe66666a5, 0xd5555595, 0xc0004000,
  0xe66666a5, 0xd5555594, 0xc0000041, 0xc0003fff,
  0xd5555594, 0xc0000040, 0xc0000040, 0xc0003fff,
  0xc0000040, 0xc0000040, 0xc0000040, 0x40003ffe,
  0xc000003f, 0xc000003f, 0x4000003f, 0x40003ffe,
  0xc000003f, 0x4000003f, 0x4000003f, 0x2aaaeaa9,
  0x4000003e, 0x4000003e, 0x2aaaaaea, 0x1999d998,
  0x4000003e, 0x2aaaaaea, 0x199999d9, 0x00007ffe,
  0x2aaaaae9, 0x199999d9, 0x0000403f, 0x00007ffe,
  0x199999d8, 0x0000403f, 0x0000403f, 0x00007ffd,
  0x0000403e, 0x0000403e, 0x0000403e, 0x00007ffd,
  0x0000403e, 0x0000403e, 0x0000403e, 0x0000403e,
  0x0000403d, 0x0000403d, 0x0000007f, 0x0000403e,
  0x0000403d, 0x0000007f, 0x0000007f, 0x0000403d,
  0x0000007e, 0x0000007e, 0x0000007e, 0x0000403d,
  0x0000007e, 0x0000007e, 0x0000007e, 0x0000400e,
  0x0000007d, 0x0000007d, 0x0000004f, 0x00004000,
  0x0000007d, 0x0000004f, 0x00000041, 0x00003fff,
  0x0000004e, 0x00000040, 0x00000040, 0x00003fff,
  0x00000040, 0x00000040, 0x00003fff, 0x00003fff,
  0x00000040, 0x00000040, 0x00003ffe, 0x00003ffe,
  0x0000003f, 0x0000003f, 0x00003ffe, 0x00003ffe,
  0x0000003f, 0x0000003f, 0x00003ffd, 0x00003fef,
  0x0000003e, 0x0000003e, 0x00003fee, 0x00003fc0,
  0x0000003e, 0x0000002f, 0x00003fc0, 0x00003fc0,
  0x0000002f, 0x00000001, 0x00003fbf, 0x00003fbf,
  0x00000000, 0x00000000, 0x00003fbf, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffc041, 0xffffffff, 0xffffffff,
  0xffffc040, 0xffffc040, 0xffffffff, 0xe666a665,
  0xffffc040, 0xffffc040, 0xe666a665, 0xd5559554,
  0xffffc03f, 0xe66666a6, 0xd5559554, 0xc0004000,
  0xe66666a5, 0xd5555595, 0xc0004000, 0xc0004000,
  0xd5555594, 0xc0000041, 0xc0003fff, 0xc0003fff,
  0xc0000040, 0xc0000040, 0xc0003fff, 0x40003fff,
  0xc0000040, 0xc0000040, 0x40003ffe, 0x40003ffe,
  0xc000003f, 0x4000003f, 0x40003ffe, 0x2aaaeaaa,
  0x4000003f, 0x4000003f, 0x2aaaeaa9, 0x1999d999,
  0x4000003e, 0x2aaaaaea, 0x1999d998, 0x00007fff,
  0x2aaaaaea, 0x199999d9, 0x00007ffe, 0x00007ffe,
  0x199999d9, 0x0000403f, 0x00007ffe, 0x00007ffe,
  0x0000403f, 0x0000403f, 0x00007ffd, 0x00007ffd,
  0x0000403e, 0x0000403e, 0x00007ffd, 0x0000403f,
  0x0000403e, 0x0000403e, 0x0000403e, 0x0000403e,
  0x0000403d, 0x0000007f, 0x0000403e, 0x0000403e,
  0x0000007f, 0x0000007f, 0x0000403d, 0x0000403d,
  0x0000007e, 0x0000007e, 0x0000403d, 0x0000400f,
  0x0000007e, 0x0000007e, 0x0000400e, 0x00004000,
  0x0000007d, 0x0000004f, 0x00004000, 0x00004000,
  0x0000004f, 0x00000041, 0x00003fff, 0x00003fff,
  0x00000041, 0x00003fff, 0x00003fff, 0x00003fff,
  0x00000040, 0x00003fff, 0x00003fff, 0x00003fff,
  0x00000040, 0x00003ffe, 0x00003ffe, 0x00003ffe,
  0x0000003f, 0x00003ffe, 0x00003ffe, 0x00003fef,
  0x0000003f, 0x00003ffd, 0x00003fef, 0x00003fc1,
  0x0000003e, 0x00003fee, 0x00003fc0, 0x00003fc0,
  0x0000002f, 0x00003fc0, 0x00003fc0, 0x00003fc0,
  0x00000001, 0x00003fbf, 0x00003fbf, 0x00000001,
  0x00000000, 0x00003fbf, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffc041, 0xffffffff, 0xffffffff, 0xe666a666,
  0xffffc040, 0xffffffff, 0xe666a665, 0xd5559555,
  0xffffc040, 0xe666a665, 0xd5559554, 0xc0004001,
  0xe66666a6, 0xd5559554, 0xc0004000, 0xc0004000,
  0xd5555595, 0xc0004000, 0xc0004000, 0xc0004000,
  0xc0000041, 0xc0003fff, 0xc0003fff, 0x40003fff,
  0xc0000040, 0xc0003fff, 0x40003fff, 0x40003fff,
  0xc0000040, 0x40003ffe, 0x40003ffe, 0x2aaaeaaa,
  0x4000003f, 0x40003ffe, 0x2aaaeaaa, 0x1999d999,
  0x4000003f, 0x2aaaeaa9, 0x1999d999, 0x00007fff,
  0x2aaaaaea, 0x1999d998, 0x00007fff, 0x00007fff,
  0x199999d9, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x0000403f, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x0000403f, 0x00007ffd, 0x00007ffd, 0x0000403f,
  0x0000403e, 0x00007ffd, 0x0000403f, 0x0000403f,
  0x0000403e, 0x0000403e, 0x0000403e, 0x0000403e,
  0x0000007f, 0x0000403e, 0x0000403e, 0x0000403e,
  0x0000007f, 0x0000403d, 0x0000403d, 0x0000400f,
  0x0000007e, 0x0000403d, 0x0000400f, 0x00004001,
  0x0000007e, 0x0000400e, 0x00004000, 0x00004000,
  0x0000004f, 0x00004000, 0x00004000, 0x00004000,
  0x00004000, 0x00004000, 0x00004000, 0x19999999,
  0x00003fff, 0x00003fff, 0x00003fff, 0x19999999,
  0x00003fff, 0x00003fff, 0x00003fff, 0x19999998,
  0x00003ffe, 0x00003ffe, 0x00003ffe, 0x19999989,
  0x00003ffe, 0x00003ffe, 0x00003fef, 0x1999995b,
  0x00003ffd, 0x00003fef, 0x00003fc1, 0x1999995a,
  0x00003fee, 0x00003fc0, 0x00003fc0, 0x1999995a,
  0x00003fc0, 0x00003fc0, 0x00003fc0, 0x1999599b,
  0x00003fbf, 0x00003fbf, 0x00000001, 0x1999599a,
  0x00003fbf, 0x00000000, 0x00000000, 0x1999599a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xe666a666, 0xeeeeeeef,
  0xffffffff, 0xe666a665, 0xd5559555, 0xd999999b,
  0xe666a665, 0xd5559554, 0xc0004001, 0xd999999a,
  0xd5559554, 0xc0004000, 0xc0004000, 0xd999999a,
  0xc0004000, 0xc0004000, 0xc0004000, 0x59999999,
  0xc0003fff, 0xc0003fff, 0x40003fff, 0x59999999,
  0xc0003fff, 0x40003fff, 0x40003fff, 0x44444444,
  0x40003ffe, 0x40003ffe, 0x2aaaeaaa, 0x33333333,
  0x40003ffe, 0x2aaaeaaa, 0x1999d999, 0x1999d999,
  0x2aaaeaa9, 0x1999d999, 0x00007fff, 0x1999d999,
  0x1999d998, 0x00007fff, 0x00007fff, 0x1999d998,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x1999d998,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x199999d9,
  0x00007ffd, 0x00007ffd, 0x0000403f, 0x199999d9,
  0x00007ffd, 0x0000403f, 0x0000403f, 0x199999d8,
  0x0000403e, 0x0000403e, 0x0000403e, 0x199999d8,
  0x0000403e, 0x0000403e, 0x0000403e, 0x199999a9,
  0x0000403d, 0x0000403d, 0x0000400f, 0x1999999b,
  0x0000403d, 0x0000400f, 0x00004001, 0x1999999a,
  0x0000400e, 0x00004000, 0x00004000, 0x1999999a,
  0x00004000, 0x00004000, 0x1999999a, 0x2aaaaaaa,
  0x00004000, 0x00004000, 0x19999999, 0x2aaaaaaa,
  0x00003fff, 0x00003fff, 0x19999999, 0x2aaaaaa9,
  0x00003fff, 0x00003fff, 0x19999998, 0x2aaaaa9a,
  0x00003ffe, 0x00003ffe, 0x19999989, 0x2aaaaa6c,
  0x00003ffe, 0x00003fef, 0x1999995b, 0x2aaaaa6b,
  0x00003fef, 0x00003fc1, 0x1999995a, 0x2aaaaa6b,
  0x00003fc0, 0x00003fc0, 0x1999995a, 0x2aaa6aac,
  0x00003fc0, 0x00003fc0, 0x1999599b, 0x2aaa6aab,
  0x00003fbf, 0x00000001, 0x1999599a, 0x2aaa6aab,
  0x00000000, 0x00000000, 0x1999599a, 0x11111111,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xe666a666, 0xeeeeeeef, 0xeaaaaaac,
  0xe666a665, 0xd5559555, 0xd999999b, 0xeaaaaaab,
  0xd5559554, 0xc0004001, 0xd999999a, 0xeaaaaaab,
  0xc0004000, 0xc0004000, 0xd999999a, 0x6aaaaaaa,
  0xc0004000, 0xc0004000, 0x59999999, 0x6aaaaaaa,
  0xc0003fff, 0x40003fff, 0x59999999, 0x55555555,
  0x40003fff, 0x40003fff, 0x44444444, 0x44444444,
  0x40003ffe, 0x2aaaeaaa, 0x33333333, 0x2aaaeaaa,
  0x2aaaeaaa, 0x1999d999, 0x1999d999, 0x2aaaeaaa,
  0x1999d999, 0x00007fff, 0x1999d999, 0x2aaaeaa9,
  0x00007fff, 0x00007fff, 0x1999d998, 0x2aaaeaa9,
  0x00007ffe, 0x00007ffe, 0x1999d998, 0x2aaaaaea,
  0x00007ffe, 0x00007ffe, 0x199999d9, 0x2aaaaaea,
  0x00007ffd, 0x0000403f, 0x199999d9, 0x2aaaaae9,
  0x0000403f, 0x0000403f, 0x199999d8, 0x2aaaaae9,
  0x0000403e, 0x0000403e, 0x199999d8, 0x2aaaaaba,
  0x0000403e, 0x0000403e, 0x199999a9, 0x2aaaaaac,
  0x0000403d, 0x0000400f, 0x1999999b, 0x2aaaaaab,
  0x0000400f, 0x00004001, 0x1999999a, 0x2aaaaaab,
  0x00004001, 0x1999999a, 0x2aaaaaab, 0x3ffffffe,
  0x00004000, 0x1999999a, 0x2aaaaaaa, 0x3ffffffe,
  0x00004000, 0x19999999, 0x2aaaaaaa, 0x3ffffffd,
  0x00003fff, 0x19999999, 0x2aaaaaa9, 0x3fffffee,
  0x00003fff, 0x19999998, 0x2aaaaa9a, 0x3fffffc0,
  0x00003ffe, 0x19999989, 0x2aaaaa6c, 0x3fffffbf,
  0x00003fef, 0x1999995b, 0x2aaaaa6b, 0x3fffffbf,
  0x00003fc1, 0x1999995a, 0x2aaaaa6b, 0x3fffc000,
  0x00003fc0, 0x1999995a, 0x2aaa6aac, 0x3fffbfff,
  0x00003fc0, 0x1999599b, 0x2aaa6aab, 0x3fffbfff,
  0x00000001, 0x1999599a, 0x2aaa6aab, 0x26666665,
  0x00000000, 0x1999599a, 0x11111111, 0x15555554,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xe666a666, 0xeeeeeeef, 0xeaaaaaac, 0xffffffff,
  0xd5559555, 0xd999999b, 0xeaaaaaab, 0xffffffff,
  0xc0004001, 0xd999999a, 0xeaaaaaab, 0x7ffffffe,
  0xc0004000, 0xd999999a, 0x6aaaaaaa, 0x7ffffffe,
  0xc0004000, 0x59999999, 0x6aaaaaaa, 0x6aaaaaa9,
  0x40003fff, 0x59999999, 0x55555555, 0x59999998,
  0x40003fff, 0x44444444, 0x44444444, 0x40003ffe,
  0x2aaaeaaa, 0x33333333, 0x2aaaeaaa, 0x40003ffe,
  0x1999d999, 0x1999d999, 0x2aaaeaaa, 0x40003ffd,
  0x00007fff, 0x1999d999, 0x2aaaeaa9, 0x40003ffd,
  0x00007fff, 0x1999d998, 0x2aaaeaa9, 0x4000003e,
  0x00007ffe, 0x1999d998, 0x2aaaaaea, 0x4000003e,
  0x00007ffe, 0x199999d9, 0x2aaaaaea, 0x4000003d,
  0x0000403f, 0x199999d9, 0x2aaaaae9, 0x4000003d,
  0x0000403f, 0x199999d8, 0x2aaaaae9, 0x4000000e,
  0x0000403e, 0x199999d8, 0x2aaaaaba, 0x40000000,
  0x0000403e, 0x199999a9, 0x2aaaaaac, 0x3fffffff,
  0x0000400f, 0x1999999b, 0x2aaaaaab, 0x3fffffff,
  0x1999999b, 0x2aaaaaab, 0x3fffffff, 0x3fffffff,
  0x1999999a, 0x2aaaaaab, 0x3ffffffe, 0x3ffffffe,
  0x1999999a, 0x2aaaaaaa, 0x3ffffffe, 0x3ffffffe,
  0x19999999, 0x2aaaaaaa, 0x3ffffffd, 0x3fffffef,
  0x19999999, 0x2aaaaaa9, 0x3fffffee, 0x3fffffc0,
  0x19999998, 0x2aaaaa9a, 0x3fffffc0, 0x3fffffc0,
  0x19999989, 0x2aaaaa6c, 0x3fffffbf, 0x3fffffbf,
  0x1999995b, 0x2aaaaa6b, 0x3fffffbf, 0x3fffc000,
  0x1999995a, 0x2aaaaa6b, 0x3fffc000, 0x3fffc000,
  0x1999995a, 0x2aaa6aac, 0x3fffbfff, 0x3fffbfff,
  0x1999599b, 0x2aaa6aab, 0x3fffbfff, 0x26666665,
  0x1999599a, 0x2aaa6aab, 0x26666665, 0x15555554,
  0x1999599a, 0x11111111, 0x15555554, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xeeeeeeef, 0xeaaaaaac, 0xffffffff, 0xffffffff,
  0xd999999b, 0xeaaaaaab, 0xffffffff, 0x7fffffff,
  0xd999999a, 0xeaaaaaab, 0x7ffffffe, 0x7ffffffe,
  0xd999999a, 0x6aaaaaaa, 0x7ffffffe, 0x6aaaaaaa,
  0x59999999, 0x6aaaaaaa, 0x6aaaaaa9, 0x59999999,
  0x59999999, 0x55555555, 0x59999998, 0x40003fff,
  0x44444444, 0x44444444, 0x40003ffe, 0x40003ffe,
  0x33333333, 0x2aaaeaaa, 0x40003ffe, 0x40003ffe,
  0x1999d999, 0x2aaaeaaa, 0x40003ffd, 0x40003ffd,
  0x1999d999, 0x2aaaeaa9, 0x40003ffd, 0x4000003f,
  0x1999d998, 0x2aaaeaa9, 0x4000003e, 0x4000003e,
  0x1999d998, 0x2aaaaaea, 0x4000003e, 0x4000003e,
  0x199999d9, 0x2aaaaaea, 0x4000003d, 0x4000003d,
  0x199999d9, 0x2aaaaae9, 0x4000003d, 0x4000000f,
  0x199999d8, 0x2aaaaae9, 0x4000000e, 0x40000000,
  0x199999d8, 0x2aaaaaba, 0x40000000, 0x40000000,
  0x199999a9, 0x2aaaaaac, 0x3fffffff, 0x3fffffff,
  0x2aaaaaac, 0x3fffffff, 0x3fffffff, 0x3fffffff,
  0x2aaaaaab, 0x3fffffff, 0x3fffffff, 0x3fffffff,
  0x2aaaaaab, 0x3ffffffe, 0x3ffffffe, 0x3ffffffe,
  0x2aaaaaaa, 0x3ffffffe, 0x3ffffffe, 0x3fffffef,
  0x2aaaaaaa, 0x3ffffffd, 0x3fffffef, 0x3fffffc1,
  0x2aaaaaa9, 0x3fffffee, 0x3fffffc0, 0x3fffffc0,
  0x2aaaaa9a, 0x3fffffc0, 0x3fffffc0, 0x3fffffc0,
  0x2aaaaa6c, 0x3fffffbf, 0x3fffffbf, 0x3fffc001,
  0x2aaaaa6b, 0x3fffffbf, 0x3fffc000, 0x3fffc000,
  0x2aaaaa6b, 0x3fffc000, 0x3fffc000, 0x3fffc000,
  0x2aaa6aac, 0x3fffbfff, 0x3fffbfff, 0x26666666,
  0x2aaa6aab, 0x3fffbfff, 0x26666665, 0x15555555,
  0x2aaa6aab, 0x26666665, 0x15555554, 0x00000001,
  0x11111111, 0x15555554, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xeaaaaaac, 0xffffffff, 0xffffffff, 0x7fffffff,
  0xeaaaaaab, 0xffffffff, 0x7fffffff, 0x7fffffff,
  0xeaaaaaab, 0x7ffffffe, 0x7ffffffe, 0x6aaaaaaa,
  0x6aaaaaaa, 0x7ffffffe, 0x6aaaaaaa, 0x59999999,
  0x6aaaaaaa, 0x6aaaaaa9, 0x59999999, 0x40003fff,
  0x55555555, 0x59999998, 0x40003fff, 0x40003fff,
  0x44444444, 0x40003ffe, 0x40003ffe, 0x40003ffe,
  0x2aaaeaaa, 0x40003ffe, 0x40003ffe, 0x40003ffe,
  0x2aaaeaaa, 0x40003ffd, 0x40003ffd, 0x4000003f,
  0x2aaaeaa9, 0x40003ffd, 0x4000003f, 0x4000003f,
  0x2aaaeaa9, 0x4000003e, 0x4000003e, 0x4000003e,
  0x2aaaaaea, 0x4000003e, 0x4000003e, 0x4000003e,
  0x2aaaaaea, 0x4000003d, 0x4000003d, 0x4000000f,
  0x2aaaaae9, 0x4000003d, 0x4000000f, 0x40000001,
  0x2aaaaae9, 0x4000000e, 0x40000000, 0x40000000,
  0x2aaaaaba, 0x40000000, 0x40000000, 0x40000000,
  0x40000000, 0x40000000, 0x40000000, 0xc0000000,
  0x3fffffff, 0x3fffffff, 0x3fffffff, 0xbfffffff,
  0x3fffffff, 0x3fffffff, 0x3fffffff, 0xbfffffff,
  0x3ffffffe, 0x3ffffffe, 0x3ffffffe, 0xbffffff0,
  0x3ffffffe, 0x3ffffffe, 0x3fffffef, 0xbfffffc1,
  0x3ffffffd, 0x3fffffef, 0x3fffffc1, 0xbfffffc1,
  0x3fffffee, 0x3fffffc0, 0x3fffffc0, 0xbfffffc0,
  0x3fffffc0, 0x3fffffc0, 0x3fffffc0, 0xbfffc001,
  0x3fffffbf, 0x3fffffbf, 0x3fffc001, 0xbfffc001,
  0x3fffffbf, 0x3fffc000, 0x3fffc000, 0xbfffc000,
  0x3fffc000, 0x3fffc000, 0x3fffc000, 0xa6666666,
  0x3fffbfff, 0x3fffbfff, 0x26666666, 0x95555555,
  0x3fffbfff, 0x26666665, 0x15555555, 0x80000001,
  0x26666665, 0x15555554, 0x00000001, 0x80000001,
  0x15555554, 0x00000000, 0x00000000, 0x80000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0x7fffffff, 0xffffffff,
  0xffffffff, 0x7fffffff, 0x7fffffff, 0xeaaaaaab,
  0x7ffffffe, 0x7ffffffe, 0x6aaaaaaa, 0xd999999a,
  0x7ffffffe, 0x6aaaaaaa, 0x59999999, 0xc0004000,
  0x6aaaaaa9, 0x59999999, 0x40003fff, 0xc0003fff,
  0x59999998, 0x40003fff, 0x40003fff, 0xc0003fff,
  0x40003ffe, 0x40003ffe, 0x40003ffe, 0xc0003ffe,
  0x40003ffe, 0x40003ffe, 0x40003ffe, 0xc0000040,
  0x40003ffd, 0x40003ffd, 0x4000003f, 0xc000003f,
  0x40003ffd, 0x4000003f, 0x4000003f, 0xc000003f,
  0x4000003e, 0x4000003e, 0x4000003e, 0xc000003e,
  0x4000003e, 0x4000003e, 0x4000003e, 0xc0000010,
  0x4000003d, 0x4000003d, 0x4000000f, 0xc0000001,
  0x4000003d, 0x4000000f, 0x40000001, 0xc0000001,
  0x4000000e, 0x40000000, 0x40000000, 0xc0000000,
  0x40000000, 0x40000000, 0xc0000000, 0xc0000000,
  0x40000000, 0x40000000, 0xc0000000, 0xc0000000,
  0x3fffffff, 0x3fffffff, 0xbfffffff, 0xbfffffff,
  0x3fffffff, 0x3fffffff, 0xbfffffff, 0xbffffff0,
  0x3ffffffe, 0x3ffffffe, 0xbffffff0, 0xbfffffc2,
  0x3ffffffe, 0x3fffffef, 0xbfffffc1, 0xbfffffc1,
  0x3fffffef, 0x3fffffc1, 0xbfffffc1, 0xbfffffc1,
  0x3fffffc0, 0x3fffffc0, 0xbfffffc0, 0xbfffc002,
  0x3fffffc0, 0x3fffffc0, 0xbfffc001, 0xbfffc001,
  0x3fffffbf, 0x3fffc001, 0xbfffc001, 0xbfffc001,
  0x3fffc000, 0x3fffc000, 0xbfffc000, 0xa6666667,
  0x3fffc000, 0x3fffc000, 0xa6666666, 0x95555556,
  0x3fffbfff, 0x26666666, 0x95555555, 0x80000002,
  0x26666665, 0x15555555, 0x80000001, 0x80000001,
  0x15555554, 0x00000001, 0x80000001, 0x80000001,
  0x00000000, 0x00000000, 0x80000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x7fffffff, 0xffffffff, 0xeaaaaaab,
  0x7fffffff, 0x7fffffff, 0xeaaaaaab, 0xd999999a,
  0x7ffffffe, 0x6aaaaaaa, 0xd999999a, 0xc0004000,
  0x6aaaaaaa, 0x59999999, 0xc0004000, 0xc0004000,
  0x59999999, 0x40003fff, 0xc0003fff, 0xc0003fff,
  0x40003fff, 0x40003fff, 0xc0003fff, 0xc0003fff,
  0x40003ffe, 0x40003ffe, 0xc0003ffe, 0xc0000040,
  0x40003ffe, 0x40003ffe, 0xc0000040, 0xc0000040,
  0x40003ffd, 0x4000003f, 0xc000003f, 0xc000003f,
  0x4000003f, 0x4000003f, 0xc000003f, 0xc000003f,
  0x4000003e, 0x4000003e, 0xc000003e, 0xc0000010,
  0x4000003e, 0x4000003e, 0xc0000010, 0xc0000002,
  0x4000003d, 0x4000000f, 0xc0000001, 0xc0000001,
  0x4000000f, 0x40000001, 0xc0000001, 0xc0000001,
  0x40000001, 0xc0000001, 0xc0000001, 0xd5555555,
  0x40000000, 0xc0000000, 0xc0000000, 0xd5555554,
  0x40000000, 0xc0000000, 0xc0000000, 0xd5555554,
  0x3fffffff, 0xbfffffff, 0xbfffffff, 0xd5555545,
  0x3fffffff, 0xbfffffff, 0xbffffff0, 0xd5555516,
  0x3ffffffe, 0xbffffff0, 0xbfffffc2, 0xd5555516,
  0x3fffffef, 0xbfffffc1, 0xbfffffc1, 0xd5555515,
  0x3fffffc1, 0xbfffffc1, 0xbfffffc1, 0xd5551556,
  0x3fffffc0, 0xbfffffc0, 0xbfffc002, 0xd5551556,
  0x3fffffc0, 0xbfffc001, 0xbfffc001, 0xd5551555,
  0x3fffc001, 0xbfffc001, 0xbfffc001, 0xbbbbbbbb,
  0x3fffc000, 0xbfffc000, 0xa6666667, 0xaaaaaaaa,
  0x3fffc000, 0xa6666666, 0x95555556, 0x95555556,
  0x26666666, 0x95555555, 0x80000002, 0x95555556,
  0x15555555, 0x80000001, 0x80000001, 0x95555555,
  0x00000001, 0x80000001, 0x80000001, 0x15555555,
  0x00000000, 0x80000000, 0x00000000, 0x15555554,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x7fffffff, 0xffffffff, 0xeaaaaaab, 0xeeeeeeef,
  0x7fffffff, 0xeaaaaaab, 0xd999999a, 0xd5559555,
  0x6aaaaaaa, 0xd999999a, 0xc0004000, 0xd5559554,
  0x59999999, 0xc0004000, 0xc0004000, 0xd5559554,
  0x40003fff, 0xc0003fff, 0xc0003fff, 0xd5559553,
  0x40003fff, 0xc0003fff, 0xc0003fff, 0xd5555595,
  0x40003ffe, 0xc0003ffe, 0xc0000040, 0xd5555594,
  0x40003ffe, 0xc0000040, 0xc0000040, 0xd5555594,
  0x4000003f, 0xc000003f, 0xc000003f, 0xd5555593,
  0x4000003f, 0xc000003f, 0xc000003f, 0xd5555565,
  0x4000003e, 0xc000003e, 0xc0000010, 0xd5555556,
  0x4000003e, 0xc0000010, 0xc0000002, 0xd5555556,
  0x4000000f, 0xc0000001, 0xc0000001, 0xd5555555,
  0xc0000001, 0xc0000001, 0xd5555555, 0xe6666666,
  0xc0000001, 0xc0000001, 0xd5555555, 0xe6666665,
  0xc0000000, 0xc0000000, 0xd5555554, 0xe6666665,
  0xc0000000, 0xc0000000, 0xd5555554, 0xe6666656,
  0xbfffffff, 0xbfffffff, 0xd5555545, 0xe6666627,
  0xbfffffff, 0xbffffff0, 0xd5555516, 0xe6666627,
  0xbffffff0, 0xbfffffc2, 0xd5555516, 0xe6666626,
  0xbfffffc1, 0xbfffffc1, 0xd5555515, 0xe6662667,
  0xbfffffc1, 0xbfffffc1, 0xd5551556, 0xe6662667,
  0xbfffffc0, 0xbfffc002, 0xd5551556, 0xe6662666,
  0xbfffc001, 0xbfffc001, 0xd5551555, 0xcccccccc,
  0xbfffc001, 0xbfffc001, 0xbbbbbbbb, 0xbbbbbbbb,
  0xbfffc000, 0xa6666667, 0xaaaaaaaa, 0xa6666667,
  0xa6666666, 0x95555556, 0x95555556, 0xa6666667,
  0x95555555, 0x80000002, 0x95555556, 0xa6666666,
  0x80000001, 0x80000001, 0x95555555, 0x26666666,
  0x80000001, 0x80000001, 0x15555555, 0x26666665,
  0x80000000, 0x00000000, 0x15555554, 0x11111111,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xeaaaaaab, 0xeeeeeeef, 0xe666a666,
  0xeaaaaaab, 0xd999999a, 0xd5559555, 0xe666a665,
  0xd999999a, 0xc0004000, 0xd5559554, 0xe666a665,
  0xc0004000, 0xc0004000, 0xd5559554, 0xe666a664,
  0xc0003fff, 0xc0003fff, 0xd5559553, 0xe66666a6,
  0xc0003fff, 0xc0003fff, 0xd5555595, 0xe66666a5,
  0xc0003ffe, 0xc0000040, 0xd5555594, 0xe66666a5,
  0xc0000040, 0xc0000040, 0xd5555594, 0xe66666a4,
  0xc000003f, 0xc000003f, 0xd5555593, 0xe6666676,
  0xc000003f, 0xc000003f, 0xd5555565, 0xe6666667,
  0xc000003e, 0xc0000010, 0xd5555556, 0xe6666667,
  0xc0000010, 0xc0000002, 0xd5555556, 0xe6666666,
  0xc0000002, 0xd5555556, 0xe6666666, 0xffffc000,
  0xc0000001, 0xd5555555, 0xe6666666, 0xffffbfff,
  0xc0000001, 0xd5555555, 0xe6666665, 0xffffbfff,
  0xc0000000, 0xd5555554, 0xe6666665, 0xffffbff0,
  0xc0000000, 0xd5555554, 0xe6666656, 0xffffbfc1,
  0xbfffffff, 0xd5555545, 0xe6666627, 0xffffbfc1,
  0xbffffff0, 0xd5555516, 0xe6666627, 0xffffbfc0,
  0xbfffffc2, 0xd5555516, 0xe6666626, 0xffff8001,
  0xbfffffc1, 0xd5555515, 0xe6662667, 0xffff8001,
  0xbfffffc1, 0xd5551556, 0xe6662667, 0xffff8000,
  0xbfffc002, 0xd5551556, 0xe6662666, 0xe6662666,
  0xbfffc001, 0xd5551555, 0xcccccccc, 0xd5551555,
  0xbfffc001, 0xbbbbbbbb, 0xbbbbbbbb, 0xbfffc001,
  0xa6666667, 0xaaaaaaaa, 0xa6666667, 0xbfffc001,
  0x95555556, 0x95555556, 0xa6666667, 0xbfffc000,
  0x80000002, 0x95555556, 0xa6666666, 0x3fffc000,
  0x80000001, 0x95555555, 0x26666666, 0x3fffbfff,
  0x80000001, 0x15555555, 0x26666665, 0x2aaa6aab,
  0x00000000, 0x15555554, 0x11111111, 0x1999599a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xeaaaaaab, 0xeeeeeeef, 0xe666a666, 0xffffffff,
  0xd999999a, 0xd5559555, 0xe666a665, 0xffffffff,
  0xc0004000, 0xd5559554, 0xe666a665, 0xfffffffe,
  0xc0004000, 0xd5559554, 0xe666a664, 0xffffc040,
  0xc0003fff, 0xd5559553, 0xe66666a6, 0xffffc03f,
  0xc0003fff, 0xd5555595, 0xe66666a5, 0xffffc03f,
  0xc0000040, 0xd5555594, 0xe66666a5, 0xffffc03e,
  0xc0000040, 0xd5555594, 0xe66666a4, 0xffffc010,
  0xc000003f, 0xd5555593, 0xe6666676, 0xffffc001,
  0xc000003f, 0xd5555565, 0xe6666667, 0xffffc001,
  0xc0000010, 0xd5555556, 0xe6666667, 0xffffc000,
  0xd5555556, 0xe6666667, 0xffffc000, 0xffffc000,
  0xd5555556, 0xe6666666, 0xffffc000, 0xffffc000,
  0xd5555555, 0xe6666666, 0xffffbfff, 0xffffbfff,
  0xd5555555, 0xe6666665, 0xffffbfff, 0xffffbff0,
  0xd5555554, 0xe6666665, 0xffffbff0, 0xffffbfc2,
  0xd5555554, 0xe6666656, 0xffffbfc1, 0xffffbfc1,
  0xd5555545, 0xe6666627, 0xffffbfc1, 0xffffbfc1,
  0xd5555516, 0xe6666627, 0xffffbfc0, 0xffff8002,
  0xd5555516, 0xe6666626, 0xffff8001, 0xffff8001,
  0xd5555515, 0xe6662667, 0xffff8001, 0xffff8001,
  0xd5551556, 0xe6662667, 0xffff8000, 0xe6662667,
  0xd5551556, 0xe6662666, 0xe6662666, 0xd5551556,
  0xd5551555, 0xcccccccc, 0xd5551555, 0xbfffc002,
  0xbbbbbbbb, 0xbbbbbbbb, 0xbfffc001, 0xbfffc001,
  0xaaaaaaaa, 0xa6666667, 0xbfffc001, 0xbfffc001,
  0x95555556, 0xa6666667, 0xbfffc000, 0x3fffc000,
  0x95555556, 0xa6666666, 0x3fffc000, 0x3fffc000,
  0x95555555, 0x26666666, 0x3fffbfff, 0x2aaa6aab,
  0x15555555, 0x26666665, 0x2aaa6aab, 0x1999599a,
  0x15555554, 0x11111111, 0x1999599a, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xeeeeeeef, 0xe666a666, 0xffffffff, 0xffffffff,
  0xd5559555, 0xe666a665, 0xffffffff, 0xffffffff,
  0xd5559554, 0xe666a665, 0xfffffffe, 0xffffc040,
  0xd5559554, 0xe666a664, 0xffffc040, 0xffffc040,
  0xd5559553, 0xe66666a6, 0xffffc03f, 0xffffc03f,
  0xd5555595, 0xe66666a5, 0xffffc03f, 0xffffc03f,
  0xd5555594, 0xe66666a5, 0xffffc03e, 0xffffc010,
  0xd5555594, 0xe66666a4, 0xffffc010, 0xffffc002,
  0xd5555593, 0xe6666676, 0xffffc001, 0xffffc001,
  0xd5555565, 0xe6666667, 0xffffc001, 0xffffc001,
  0xe6666667, 0xffffc001, 0xffffc001, 0xffffc001,
  0xe6666667, 0xffffc000, 0xffffc000, 0xffffc000,
  0xe6666666, 0xffffc000, 0xffffc000, 0xffffc000,
  0xe6666666, 0xffffbfff, 0xffffbfff, 0xffffbff1,
  0xe6666665, 0xffffbfff, 0xffffbff0, 0xffffbfc2,
  0xe6666665, 0xffffbff0, 0xffffbfc2, 0xffffbfc2,
  0xe6666656, 0xffffbfc1, 0xffffbfc1, 0xffffbfc1,
  0xe6666627, 0xffffbfc1, 0xffffbfc1, 0xffff8002,
  0xe6666627, 0xffffbfc0, 0xffff8002, 0xffff8002,
  0xe6666626, 0xffff8001, 0xffff8001, 0xffff8001,
  0xe6662667, 0xffff8001, 0xffff8001, 0xe6662667,
  0xe6662667, 0xffff8000, 0xe6662667, 0xd5551556,
  0xe6662666, 0xe6662666, 0xd5551556, 0xbfffc002,
  0xcccccccc, 0xd5551555, 0xbfffc002, 0xbfffc002,
  0xbbbbbbbb, 0xbfffc001, 0xbfffc001, 0xbfffc001,
  0xa6666667, 0xbfffc001, 0xbfffc001, 0x3fffc001,
  0xa6666667, 0xbfffc000, 0x3fffc000, 0x3fffc000,
  0xa6666666, 0x3fffc000, 0x3fffc000, 0x2aaa6aac,
  0x26666666, 0x3fffbfff, 0x2aaa6aab, 0x1999599b,
  0x26666665, 0x2aaa6aab, 0x1999599a, 0x00000001,
  0x11111111, 0x1999599a, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xe666a666, 0xffffffff, 0xffffffff, 0xffffffff,
  0xe666a665, 0xffffffff, 0xffffffff, 0xffffc041,
  0xe666a665, 0xfffffffe, 0xffffc040, 0xffffc040,
  0xe666a664, 0xffffc040, 0xffffc040, 0xffffc040,
  0xe66666a6, 0xffffc03f, 0xffffc03f, 0xffffc03f,
  0xe66666a5, 0xffffc03f, 0xffffc03f, 0xffffc011,
  0xe66666a5, 0xffffc03e, 0xffffc010, 0xffffc002,
  0xe66666a4, 0xffffc010, 0xffffc002, 0xffffc002,
  0xe6666676, 0xffffc001, 0xffffc001, 0xffffc001,
  0xffffc001, 0xffffc001, 0xffffc001, 0xffffc001,
  0xffffc001, 0xffffc001, 0xffffc001, 0xffffc001,
  0xffffc000, 0xffffc000, 0xffffc000, 0xffffc000,
  0xffffc000, 0xffffc000, 0xffffc000, 0xffffbff1,
  0xffffbfff, 0xffffbfff, 0xffffbff1, 0xffffbfc3,
  0xffffbfff, 0xffffbff0, 0xffffbfc2, 0xffffbfc2,
  0xffffbff0, 0xffffbfc2, 0xffffbfc2, 0xffffbfc2,
  0xffffbfc1, 0xffffbfc1, 0xffffbfc1, 0xffff8003,
  0xffffbfc1, 0xffffbfc1, 0xffff8002, 0xffff8002,
  0xffffbfc0, 0xffff8002, 0xffff8002, 0xffff8002,
  0xffff8001, 0xffff8001, 0xffff8001, 0xe6662668,
  0xffff8001, 0xffff8001, 0xe6662667, 0xd5551557,
  0xffff8000, 0xe6662667, 0xd5551556, 0xbfffc003,
  0xe6662666, 0xd5551556, 0xbfffc002, 0xbfffc002,
  0xd5551555, 0xbfffc002, 0xbfffc002, 0xbfffc002,
  0xbfffc001, 0xbfffc001, 0xbfffc001, 0x3fffc001,
  0xbfffc001, 0xbfffc001, 0x3fffc001, 0x3fffc001,
  0xbfffc000, 0x3fffc000, 0x3fffc000, 0x2aaa6aac,
  0x3fffc000, 0x3fffc000, 0x2aaa6aac, 0x1999599b,
  0x3fffbfff, 0x2aaa6aab, 0x1999599b, 0x00000001,
  0x2aaa6aab, 0x1999599a, 0x00000001, 0x00000001,
  0x1999599a, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffc041,
  0xffffffff, 0xffffffff, 0xffffc041, 0xffffc041,
  0xfffffffe, 0xffffc040, 0xffffc040, 0xffffc040,
  0xffffc040, 0xffffc040, 0xffffc040, 0xffffc040,
  0xffffc03f, 0xffffc03f, 0xffffc03f, 0xffffc011,
  0xffffc03f, 0xffffc03f, 0xffffc011, 0xffffc003,
  0xffffc03e, 0xffffc010, 0xffffc002, 0xffffc002,
  0xffffc010, 0xffffc002, 0xffffc002, 0xffffc002,
  0xffffc002, 0xffffc002, 0xffffc002, 0xffffffc0,
  0xffffc001, 0xffffc001, 0xffffc001, 0xffffffbf,
  0xffffc001, 0xffffc001, 0xffffc001, 0xffffffbf,
  0xffffc000, 0xffffc000, 0xffffc000, 0xffffffb0,
  0xffffc000, 0xffffc000, 0xffffbff1, 0xffffff81,
  0xffffbfff, 0xffffbff1, 0xffffbfc3, 0xffffff81,
  0xffffbff0, 0xffffbfc2, 0xffffbfc2, 0xffffff80,
  0xffffbfc2, 0xffffbfc2, 0xffffbfc2, 0xffffbfc1,
  0xffffbfc1, 0xffffbfc1, 0xffff8003, 0xffffbfc1,
  0xffffbfc1, 0xffff8002, 0xffff8002, 0xffffbfc0,
  0xffff8002, 0xffff8002, 0xffff8002, 0xe6666626,
  0xffff8001, 0xffff8001, 0xe6662668, 0xd5555515,
  0xffff8001, 0xe6662667, 0xd5551557, 0xbfffffc1,
  0xe6662667, 0xd5551556, 0xbfffc003, 0xbfffffc1,
  0xd5551556, 0xbfffc002, 0xbfffc002, 0xbfffffc0,
  0xbfffc002, 0xbfffc002, 0xbfffc002, 0x3fffffc0,
  0xbfffc001, 0xbfffc001, 0x3fffc001, 0x3fffffbf,
  0xbfffc001, 0x3fffc001, 0x3fffc001, 0x2aaaaa6b,
  0x3fffc000, 0x3fffc000, 0x2aaa6aac, 0x1999995a,
  0x3fffc000, 0x2aaa6aac, 0x1999599b, 0x00003fc0,
  0x2aaa6aab, 0x1999599b, 0x00000001, 0x00003fbf,
  0x1999599a, 0x00000001, 0x00000001, 0x00003fbf,
  0x00000000, 0x00000000, 0x00000000, 0x00003fbe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffc041, 0xffffffff,
  0xffffffff, 0xffffc041, 0xffffc041, 0xffffffff,
  0xffffc040, 0xffffc040, 0xffffc040, 0xfffffffe,
  0xffffc040, 0xffffc040, 0xffffc040, 0xffffffd0,
  0xffffc03f, 0xffffc03f, 0xffffc011, 0xffffffc1,
  0xffffc03f, 0xffffc011, 0xffffc003, 0xffffffc1,
  0xffffc010, 0xffffc002, 0xffffc002, 0xffffffc0,
  0xffffc002, 0xffffc002, 0xffffffc0, 0xffffffc0,
  0xffffc002, 0xffffc002, 0xffffffc0, 0xffffffc0,
  0xffffc001, 0xffffc001, 0xffffffbf, 0xffffffbf,
  0xffffc001, 0xffffc001, 0xffffffbf, 0xffffffb0,
  0xffffc000, 0xffffc000, 0xffffffb0, 0xffffff82,
  0xffffc000, 0xffffbff1, 0xffffff81, 0xffffff81,
  0xffffbff1, 0xffffbfc3, 0xffffff81, 0xffffff81,
  0xffffbfc2, 0xffffbfc2, 0xffffff80, 0xffffbfc2,
  0xffffbfc2, 0xffffbfc2, 0xffffbfc1, 0xffffbfc1,
  0xffffbfc1, 0xffff8003, 0xffffbfc1, 0xffffbfc1,
  0xffff8002, 0xffff8002, 0xffffbfc0, 0xe6666627,
  0xffff8002, 0xffff8002, 0xe6666626, 0xd5555516,
  0xffff8001, 0xe6662668, 0xd5555515, 0xbfffffc2,
  0xe6662667, 0xd5551557, 0xbfffffc1, 0xbfffffc1,
  0xd5551556, 0xbfffc003, 0xbfffffc1, 0xbfffffc1,
  0xbfffc002, 0xbfffc002, 0xbfffffc0, 0x3fffffc0,
  0xbfffc002, 0xbfffc002, 0x3fffffc0, 0x3fffffc0,
  0xbfffc001, 0x3fffc001, 0x3fffffbf, 0x2aaaaa6b,
  0x3fffc001, 0x3fffc001, 0x2aaaaa6b, 0x1999995a,
  0x3fffc000, 0x2aaa6aac, 0x1999995a, 0x00003fc0,
  0x2aaa6aac, 0x1999599b, 0x00003fc0, 0x00003fc0,
  0x1999599b, 0x00000001, 0x00003fbf, 0x00003fbf,
  0x00000001, 0x00000001, 0x00003fbf, 0x00003fbf,
  0x00000000, 0x00000000, 0x00003fbe, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffc041, 0xffffffff, 0xffffffff,
  0xffffc041, 0xffffc041, 0xffffffff, 0xffffffff,
  0xffffc040, 0xffffc040, 0xfffffffe, 0xffffffd0,
  0xffffc040, 0xffffc040, 0xffffffd0, 0xffffffc2,
  0xffffc03f, 0xffffc011, 0xffffffc1, 0xffffffc1,
  0xffffc011, 0xffffc003, 0xffffffc1, 0xffffffc1,
  0xffffc003, 0xffffffc1, 0xffffffc1, 0xffffffc1,
  0xffffc002, 0xffffffc0, 0xffffffc0, 0xffffffc0,
  0xffffc002, 0xffffffc0, 0xffffffc0, 0xffffffc0,
  0xffffc001, 0xffffffbf, 0xffffffbf, 0xffffffb1,
  0xffffc001, 0xffffffbf, 0xffffffb0, 0xffffff82,
  0xffffc000, 0xffffffb0, 0xffffff82, 0xffffff82,
  0xffffbff1, 0xffffff81, 0xffffff81, 0xffffff81,
  0xffffbfc3, 0xffffff81, 0xffffff81, 0xffffbfc2,
  0xffffbfc2, 0xffffff80, 0xffffbfc2, 0xffffbfc2,
  0xffffbfc2, 0xffffbfc1, 0xffffbfc1, 0xffffbfc1,
  0xffff8003, 0xffffbfc1, 0xffffbfc1, 0xe6666627,
  0xffff8002, 0xffffbfc0, 0xe6666627, 0xd5555516,
  0xffff8002, 0xe6666626, 0xd5555516, 0xbfffffc2,
  0xe6662668, 0xd5555515, 0xbfffffc2, 0xbfffffc2,
  0xd5551557, 0xbfffffc1, 0xbfffffc1, 0xbfffffc1,
  0xbfffc003, 0xbfffffc1, 0xbfffffc1, 0x3fffffc1,
  0xbfffc002, 0xbfffffc0, 0x3fffffc0, 0x3fffffc0,
  0xbfffc002, 0x3fffffc0, 0x3fffffc0, 0x2aaaaa6c,
  0x3fffc001, 0x3fffffbf, 0x2aaaaa6b, 0x1999995b,
  0x3fffc001, 0x2aaaaa6b, 0x1999995a, 0x00003fc1,
  0x2aaa6aac, 0x1999995a, 0x00003fc0, 0x00003fc0,
  0x1999599b, 0x00003fc0, 0x00003fc0, 0x00003fc0,
  0x00000001, 0x00003fbf, 0x00003fbf, 0x00003fbf,
  0x00000001, 0x00003fbf, 0x00003fbf, 0x00000001,
  0x00000000, 0x00003fbe, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffc041, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffc041, 0xffffffff, 0xffffffff, 0xffffffd1,
  0xffffc040, 0xfffffffe, 0xffffffd0, 0xffffffc2,
  0xffffc040, 0xffffffd0, 0xffffffc2, 0xffffffc2,
  0xffffc011, 0xffffffc1, 0xffffffc1, 0xffffffc1,
  0xffffffc1, 0xffffffc1, 0xffffffc1, 0xffffffc1,
  0xffffffc1, 0xffffffc1, 0xffffffc1, 0xffffffc1,
  0xffffffc0, 0xffffffc0, 0xffffffc0, 0xffffffc0,
  0xffffffc0, 0xffffffc0, 0xffffffc0, 0xffffffb1,
  0xffffffbf, 0xffffffbf, 0xffffffb1, 0xffffff83,
  0xffffffbf, 0xffffffb0, 0xffffff82, 0xffffff82,
  0xffffffb0, 0xffffff82, 0xffffff82, 0xffffff82,
  0xffffff81, 0xffffff81, 0xffffff81, 0xffffbfc3,
  0xffffff81, 0xffffff81, 0xffffbfc2, 0xffffbfc2,
  0xffffff80, 0xffffbfc2, 0xffffbfc2, 0xffffbfc2,
  0xffffbfc1, 0xffffbfc1, 0xffffbfc1, 0xe6666628,
  0xffffbfc1, 0xffffbfc1, 0xe6666627, 0xd5555517,
  0xffffbfc0, 0xe6666627, 0xd5555516, 0xbfffffc3,
  0xe6666626, 0xd5555516, 0xbfffffc2, 0xbfffffc2,
  0xd5555515, 0xbfffffc2, 0xbfffffc2, 0xbfffffc2,
  0xbfffffc1, 0xbfffffc1, 0xbfffffc1, 0x3fffffc1,
  0xbfffffc1, 0xbfffffc1, 0x3fffffc1, 0x3fffffc1,
  0xbfffffc0, 0x3fffffc0, 0x3fffffc0, 0x2aaaaa6c,
  0x3fffffc0, 0x3fffffc0, 0x2aaaaa6c, 0x1999995b,
  0x3fffffbf, 0x2aaaaa6b, 0x1999995b, 0x00003fc1,
  0x2aaaaa6b, 0x1999995a, 0x00003fc1, 0x00003fc1,
  0x1999995a, 0x00003fc0, 0x00003fc0, 0x00003fc0,
  0x00003fc0, 0x00003fc0, 0x00003fc0, 0x00003fc0,
  0x00003fbf, 0x00003fbf, 0x00003fbf, 0x00000001,
  0x00003fbf, 0x00003fbf, 0x00000001, 0x00000001,
  0x00003fbe, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffd1,
  0xffffffff, 0xffffffff, 0xffffffd1, 0xffffffc3,
  0xfffffffe, 0xffffffd0, 0xffffffc2, 0xffffffc2,
  0xffffffd0, 0xffffffc2, 0xffffffc2, 0xffffffc2,
  0xffffffc2, 0xffffffc2, 0xffffffc2, 0xfffffff0,
  0xffffffc1, 0xffffffc1, 0xffffffc1, 0xffffffef,
  0xffffffc1, 0xffffffc1, 0xffffffc1, 0xffffffef,
  0xffffffc0, 0xffffffc0, 0xffffffc0, 0xffffffe0,
  0xffffffc0, 0xffffffc0, 0xffffffb1, 0xffffffb1,
  0xffffffbf, 0xffffffb1, 0xffffff83, 0xffffffb1,
  0xffffffb0, 0xffffff82, 0xffffff82, 0xffffffb0,
  0xffffff82, 0xffffff82, 0xffffff82, 0xffffbff1,
  0xffffff81, 0xffffff81, 0xffffbfc3, 0xffffbff1,
  0xffffff81, 0xffffbfc2, 0xffffbfc2, 0xffffbff0,
  0xffffbfc2, 0xffffbfc2, 0xffffbfc2, 0xe6666656,
  0xffffbfc1, 0xffffbfc1, 0xe6666628, 0xd5555545,
  0xffffbfc1, 0xe6666627, 0xd5555517, 0xbffffff1,
  0xe6666627, 0xd5555516, 0xbfffffc3, 0xbffffff1,
  0xd5555516, 0xbfffffc2, 0xbfffffc2, 0xbffffff0,
  0xbfffffc2, 0xbfffffc2, 0xbfffffc2, 0x3ffffff0,
  0xbfffffc1, 0xbfffffc1, 0x3fffffc1, 0x3fffffef,
  0xbfffffc1, 0x3fffffc1, 0x3fffffc1, 0x2aaaaa9b,
  0x3fffffc0, 0x3fffffc0, 0x2aaaaa6c, 0x1999998a,
  0x3fffffc0, 0x2aaaaa6c, 0x1999995b, 0x00003ff0,
  0x2aaaaa6b, 0x1999995b, 0x00003fc1, 0x00003fef,
  0x1999995a, 0x00003fc1, 0x00003fc1, 0x00003fef,
  0x00003fc0, 0x00003fc0, 0x00003fc0, 0x00003fee,
  0x00003fc0, 0x00003fc0, 0x00003fc0, 0x00000030,
  0x00003fbf, 0x00003fbf, 0x00000001, 0x0000002f,
  0x00003fbf, 0x00000001, 0x00000001, 0x0000002f,
  0x00000000, 0x00000000, 0x00000000, 0x0000002e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffd1, 0xfffffff1,
  0xffffffff, 0xffffffd1, 0xffffffc3, 0xfffffff1,
  0xffffffd0, 0xffffffc2, 0xffffffc2, 0xfffffff0,
  0xffffffc2, 0xffffffc2, 0xfffffff0, 0xfffffffe,
  0xffffffc2, 0xffffffc2, 0xfffffff0, 0xfffffffe,
  0xffffffc1, 0xffffffc1, 0xffffffef, 0xfffffffd,
  0xffffffc1, 0xffffffc1, 0xffffffef, 0xffffffee,
  0xffffffc0, 0xffffffc0, 0xffffffe0, 0xffffffc0,
  0xffffffc0, 0xffffffb1, 0xffffffb1, 0xffffffbf,
  0xffffffb1, 0xffffff83, 0xffffffb1, 0xffffffbf,
  0xffffff82, 0xffffff82, 0xffffffb0, 0xffffc000,
  0xffffff82, 0xffffff82, 0xffffbff1, 0xffffbfff,
  0xffffff81, 0xffffbfc3, 0xffffbff1, 0xffffbfff,
  0xffffbfc2, 0xffffbfc2, 0xffffbff0, 0xe6666665,
  0xffffbfc2, 0xffffbfc2, 0xe6666656, 0xd5555554,
  0xffffbfc1, 0xe6666628, 0xd5555545, 0xc0000000,
  0xe6666627, 0xd5555517, 0xbffffff1, 0xbfffffff,
  0xd5555516, 0xbfffffc3, 0xbffffff1, 0xbfffffff,
  0xbfffffc2, 0xbfffffc2, 0xbffffff0, 0x3ffffffe,
  0xbfffffc2, 0xbfffffc2, 0x3ffffff0, 0x3ffffffe,
  0xbfffffc1, 0x3fffffc1, 0x3fffffef, 0x2aaaaaa9,
  0x3fffffc1, 0x3fffffc1, 0x2aaaaa9b, 0x19999998,
  0x3fffffc0, 0x2aaaaa6c, 0x1999998a, 0x00003ffe,
  0x2aaaaa6c, 0x1999995b, 0x00003ff0, 0x00003ffe,
  0x1999995b, 0x00003fc1, 0x00003fef, 0x00003ffd,
  0x00003fc1, 0x00003fc1, 0x00003fef, 0x00003ffd,
  0x00003fc0, 0x00003fc0, 0x00003fee, 0x0000003e,
  0x00003fc0, 0x00003fc0, 0x00000030, 0x0000003e,
  0x00003fbf, 0x00000001, 0x0000002f, 0x0000003d,
  0x00000001, 0x00000001, 0x0000002f, 0x0000003d,
  0x00000000, 0x00000000, 0x0000002e, 0x0000000e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffd1, 0xfffffff1, 0xffffffff,
  0xffffffd1, 0xffffffc3, 0xfffffff1, 0xffffffff,
  0xffffffc3, 0xfffffff1, 0xffffffff, 0xffffffff,
  0xffffffc2, 0xfffffff0, 0xfffffffe, 0xfffffffe,
  0xffffffc2, 0xfffffff0, 0xfffffffe, 0xfffffffe,
  0xffffffc1, 0xffffffef, 0xfffffffd, 0xffffffef,
  0xffffffc1, 0xffffffef, 0xffffffee, 0xffffffc0,
  0xffffffc0, 0xffffffe0, 0xffffffc0, 0xffffffc0,
  0xffffffb1, 0xffffffb1, 0xffffffbf, 0xffffffbf,
  0xffffff83, 0xffffffb1, 0xffffffbf, 0xffffc000,
  0xffffff82, 0xffffffb0, 0xffffc000, 0xffffc000,
  0xffffff82, 0xffffbff1, 0xffffbfff, 0xffffbfff,
  0xffffbfc3, 0xffffbff1, 0xffffbfff, 0xe6666665,
  0xffffbfc2, 0xffffbff0, 0xe6666665, 0xd5555554,
  0xffffbfc2, 0xe6666656, 0xd5555554, 0xc0000000,
  0xe6666628, 0xd5555545, 0xc0000000, 0xc0000000,
  0xd5555517, 0xbffffff1, 0xbfffffff, 0xbfffffff,
  0xbfffffc3, 0xbffffff1, 0xbfffffff, 0x3fffffff,
  0xbfffffc2, 0xbffffff0, 0x3ffffffe, 0x3ffffffe,
  0xbfffffc2, 0x3ffffff0, 0x3ffffffe, 0x2aaaaaaa,
  0x3fffffc1, 0x3fffffef, 0x2aaaaaa9, 0x19999999,
  0x3fffffc1, 0x2aaaaa9b, 0x19999998, 0x00003fff,
  0x2aaaaa6c, 0x1999998a, 0x00003ffe, 0x00003ffe,
  0x1999995b, 0x00003ff0, 0x00003ffe, 0x00003ffe,
  0x00003fc1, 0x00003fef, 0x00003ffd, 0x00003ffd,
  0x00003fc1, 0x00003fef, 0x00003ffd, 0x0000003f,
  0x00003fc0, 0x00003fee, 0x0000003e, 0x0000003e,
  0x00003fc0, 0x00000030, 0x0000003e, 0x0000003e,
  0x00000001, 0x0000002f, 0x0000003d, 0x0000003d,
  0x00000001, 0x0000002f, 0x0000003d, 0x0000000f,
  0x00000000, 0x0000002e, 0x0000000e, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffd1, 0xfffffff1, 0xffffffff, 0xffffffff,
  0xfffffff1, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffff1, 0xffffffff, 0xffffffff, 0xffffffff,
  0xfffffff0, 0xfffffffe, 0xfffffffe, 0xfffffffe,
  0xfffffff0, 0xfffffffe, 0xfffffffe, 0xffffffef,
  0xffffffef, 0xfffffffd, 0xffffffef, 0xffffffc1,
  0xffffffef, 0xffffffee, 0xffffffc0, 0xffffffc0,
  0xffffffe0, 0xffffffc0, 0xffffffc0, 0xffffffc0,
  0xffffffb1, 0xffffffbf, 0xffffffbf, 0xffffc001,
  0xffffffb1, 0xffffffbf, 0xffffc000, 0xffffc000,
  0xffffffb0, 0xffffc000, 0xffffc000, 0xffffc000,
  0xffffbff1, 0xffffbfff, 0xffffbfff, 0xe6666666,
  0xffffbff1, 0xffffbfff, 0xe6666665, 0xd5555555,
  0xffffbff0, 0xe6666665, 0xd5555554, 0xc0000001,
  0xe6666656, 0xd5555554, 0xc0000000, 0xc0000000,
  0xd5555545, 0xc0000000, 0xc0000000, 0xc0000000,
  0xbffffff1, 0xbfffffff, 0xbfffffff, 0x3fffffff,
  0xbffffff1, 0xbfffffff, 0x3fffffff, 0x3fffffff,
  0xbffffff0, 0x3ffffffe, 0x3ffffffe, 0x2aaaaaaa,
  0x3ffffff0, 0x3ffffffe, 0x2aaaaaaa, 0x19999999,
  0x3fffffef, 0x2aaaaaa9, 0x19999999, 0x00003fff,
  0x2aaaaa9b, 0x19999998, 0x00003fff, 0x00003fff,
  0x1999998a, 0x00003ffe, 0x00003ffe, 0x00003ffe,
  0x00003ff0, 0x00003ffe, 0x00003ffe, 0x00003ffe,
  0x00003fef, 0x00003ffd, 0x00003ffd, 0x0000003f,
  0x00003fef, 0x00003ffd, 0x0000003f, 0x0000003f,
  0x00003fee, 0x0000003e, 0x0000003e, 0x0000003e,
  0x00000030, 0x0000003e, 0x0000003e, 0x0000003e,
  0x0000002f, 0x0000003d, 0x0000003d, 0x0000000f,
  0x0000002f, 0x0000003d, 0x0000000f, 0x00000001,
  0x0000002e, 0x0000000e, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
};
const unsigned kExpectedCount_NEON_shsub_4S = 961;

#endif  // VIXL_SIM_SHSUB_4S_TRACE_AARCH64_H_
