/*
 * @(#)BevelP.h
 *
 * Copyright 2023  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Bevel */

#ifndef _BevelP_h
#define _BevelP_h

#include "xwin.h"
#include "timer.h"
#include "Bevel.h"

#ifdef WINVER
extern void destroyPuzzle(HBRUSH brush);
extern void resizePuzzle(BevelWidget w);
extern void sizePuzzle(BevelWidget w);
extern void initializePuzzle(BevelWidget w, HBRUSH brush);
extern void exposePuzzle(BevelWidget w);
extern void dimPuzzle(BevelWidget w);
extern int  movePuzzleDir(BevelWidget w, const int direction);
extern void setPuzzle(BevelWidget w, int reason);
extern void setPuzzleMove(BevelWidget w, int reason, int face, int position,
	int direction, int control, int fast);

#else

/* This gets around C's inability to do inheritance */
typedef struct _BevelClassPart {
	int         ignore;
} BevelClassPart;

typedef struct _BevelClassRec {
	CoreClassPart coreClass;
	BevelClassPart bevelClass;
} BevelClassRec;

extern BevelClassRec bevelClassRec;

extern void quitPuzzle(BevelWidget w, XEvent *event, char **args, int nArgs);
extern void movePuzzleCw(BevelWidget w, XEvent *event, char **args, int nArgs);
extern void movePuzzleCcw(BevelWidget w, XEvent *event, char **args,
	int nArgs);
#endif

#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define TR 8
#define BR 9
#define BL 10
#define TL 11
#define MAX_ORIENT 4
#define MAX_ROTATE 2
#define MAX_CUBES (2 * MAX_ORIENT)
#define MINOR 0
#define MAJOR 1

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _BevelLocPos {
	int         face, position, direction;
} BevelLocPos;

typedef struct _moveRecord {
#if 0
	int face, position, direction, control;
#endif
	unsigned short int packed;  /* This makes assumptions on the data. */
} moveRecord;

typedef struct _MoveStack {
	moveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _BevelStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} BevelStack;

typedef struct _BevelLoc {
	int face, rotation;
} BevelLoc;

typedef struct _BevelPart {
	BevelLoc    cubeLoc[MAX_FACES][MAX_CUBES];
	BevelLoc    faceLoc[MAX_CUBES];
	BevelLoc    rowLoc[MAX_ORIENT][MAX_CUBES];
	BevelLoc    minorLoc[MAX_ROTATE], majorLoc[MAX_ROTATE][MAX_ORIENT];
	BevelLoc    bevelLoc[MAX_FACES][MAX_CUBES];
	int         currentFace, currentPosition, currentDirection, currentFast;
	int         currentControl;
	Boolean     started, cheat, sound;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         degreeTurn, view;
	int         delay;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAX_FACES];
#ifdef WINVER
	char        userName[81], scoreFile[81], moveSound[81];
	char        faceChar[MAX_FACES];
#else
	int         menu, pixmapSize;
	char       *userName, *scoreFile, *moveSound, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAX_FACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAX_FACES];
	XtCallbackList select;
#endif
} BevelPart;

typedef struct _BevelRec {
	CorePart    core;
	BevelPart   bevel;
} BevelRec;

typedef struct _RowNext {
	int         face, direction, sideFace;
} RowNext;

extern void hidePuzzle(
#ifdef WINVER
const BevelWidget w
#else
BevelWidget w, XEvent *event, char **args, int nArgs
#endif
);
extern void selectPuzzle(BevelWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent *event, char **args, int nArgs
#endif
);
extern void releasePuzzle(BevelWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent *event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void practicePuzzleWithQuery(BevelWidget w
, XEvent *event, char **args, int nArgs
);
extern void practicePuzzleWithDoubleClick(BevelWidget w
, XEvent *event, char **args, int nArgs
);
extern void randomizePuzzleWithQuery(BevelWidget w
, XEvent *event, char **args, int nArgs
);
extern void randomizePuzzleWithDoubleClick(BevelWidget w
, XEvent *event, char **args, int nArgs
);
#endif
extern void getPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void writePuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void undoPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void redoPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void clearPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void randomizePuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void solvePuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void findPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void practicePuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void orientizePuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void viewPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void speedUpPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void slowDownPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void toggleSoundPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void enterPuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void leavePuzzle(BevelWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);

extern void movePuzzleInput(BevelWidget w, int x, int y, int direction,
	int control, int alt);
extern void setPuzzle(BevelWidget w, int reason);
extern void movePuzzle(BevelWidget w, int face, int position, int direction,
	int control, int speed);
extern void movePuzzleDelay(BevelWidget w,
	int face, int position, int direction, int control);
extern void setAllColors(BevelWidget w);
extern void clearPieces(BevelWidget w);
extern void solveSomePieces(BevelWidget w);
extern void findSomeMoves(BevelWidget w);
extern void drawAllPieces(BevelWidget w);
extern Boolean checkSolved(BevelWidget w);
extern void newMoves(BevelStack *s);
extern void deleteMoves(BevelStack *s);
extern void setMove(BevelStack *s,
	int face, int position, int direction, int control);
extern void getMove(BevelStack *s,
	int *face, int *position, int *direction, int *control);
extern int madeMoves(BevelStack *s);
extern void flushMoves(BevelWidget w, BevelStack *s, Boolean undo);
extern int numMoves(BevelStack *s);
extern Boolean scanMoves(FILE *fp, BevelWidget w, int moves);
extern void printMoves(FILE *fp, BevelStack *s);
extern Boolean scanStartPosition(FILE *fp, BevelWidget w);
extern void printStartPosition(FILE *fp, BevelWidget w);
extern void setStartPosition(BevelWidget w);

#ifdef DEBUG
extern void printCube(BevelWidget w);

#endif

#endif /* _BevelP_h */
