//  Copyright John Maddock 2008.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<typename table_type<T>::type>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<typename table_type<T>::type, 5>, 3200> nccs = {{
      {{ SC_(1.951913356781005859375000000000000000000), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.908610105514526367187500000000000000000e-1), SC_(9.191713210042786241188236234883914114395e-2), SC_(9.080828678995721375881176376511608588560e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(6.366568565368652343750000000000000000000), SC_(2.079620361328125000000000000000000000000), SC_(8.979177306921986952474050864260945461537e-2), SC_(9.102082269307801304752594913573905453846e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(6.889215946197509765625000000000000000000), SC_(4.420564651489257812500000000000000000000), SC_(2.322522640917811378036214577533389504074e-1), SC_(7.677477359082188621963785422466610495926e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(7.142335891723632812500000000000000000000), SC_(6.820687294006347656250000000000000000000), SC_(4.029439026943616888034033394094687890419e-1), SC_(5.970560973056383111965966605905312109581e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(9.234277725219726562500000000000000000000), SC_(1.006757259368896484375000000000000000000e1), SC_(4.912552959077002677485496881218430896094e-1), SC_(5.087447040922997322514503118781569103906e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.942635536193847656250000000000000000000e1), SC_(2.116448593139648437500000000000000000000e1), SC_(5.344158171377402637365393278378581649496e-1), SC_(4.655841828622597362634606721621418350504e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.950807952880859375000000000000000000000e1), SC_(2.143853378295898437500000000000000000000e1), SC_(5.427110898702781884985658638646815339571e-1), SC_(4.572889101297218115014341361353184660429e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(2.197235107421875000000000000000000000000e1), SC_(2.392426490783691406250000000000000000000e1), SC_(5.412751121814981951824612055009695852890e-1), SC_(4.587248878185018048175387944990304147110e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(2.249290275573730468750000000000000000000e1), SC_(2.444726181030273437500000000000000000000e1), SC_(5.409219532207546156929103529206929272982e-1), SC_(4.590780467792453843070896470793070727018e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(2.503655242919921875000000000000000000000e1), SC_(2.701545524597167968750000000000000000000e1), SC_(5.398488681606659449009007854898639088100e-1), SC_(4.601511318393340550990992145101360911900e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(2.539736366271972656250000000000000000000e1), SC_(2.762277030944824218750000000000000000000e1), SC_(5.489826827593184212047987802360330000285e-1), SC_(4.510173172406815787952012197639669999715e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(2.709540176391601562500000000000000000000e1), SC_(3.195204734802246093750000000000000000000e1), SC_(6.402283129477376083547421708583723034402e-1), SC_(3.597716870522623916452578291416276965598e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(2.837726783752441406250000000000000000000e1), SC_(3.639501953125000000000000000000000000000e1), SC_(7.328503378322701372366867357591531160795e-1), SC_(2.671496621677298627633132642408468839205e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(2.982279586791992187500000000000000000000e1), SC_(4.130712127685546875000000000000000000000e1), SC_(8.120315212974665140882026008610420369286e-1), SC_(1.879684787025334859117973991389579630714e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(3.152261734008789062500000000000000000000e1), SC_(5.021179199218750000000000000000000000000e1), SC_(9.186319322366888176750588602864877172835e-1), SC_(8.136806776331118232494113971351228271646e-2) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(3.423733520507812500000000000000000000000e1), SC_(7.237849426269531250000000000000000000000e1), SC_(9.951873088673392922733292174972560412168e-1), SC_(4.812691132660707726670782502743958783235e-3) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(3.477303314208984375000000000000000000000e1), SC_(1.101748352050781250000000000000000000000e2), SC_(9.999971837793305211473087127894649237140e-1), SC_(2.816220669478852691287210535076286027043e-6) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(3.767639541625976562500000000000000000000e1), SC_(1.585132293701171875000000000000000000000e2), SC_(9.999999999217985889295034646019210191196e-1), SC_(7.820141107049653539807898088039446209823e-11) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(4.238486480712890625000000000000000000000e1), SC_(2.216838836669921875000000000000000000000e2), SC_(9.999999999999999601293913998035171348369e-1), SC_(3.987060860019648286516310053058333358666e-17) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(4.420680999755859375000000000000000000000e1), SC_(4.615872383117675781250000000000000000000), SC_(1.905661027512242706659103721587818984333e-6), SC_(9.999980943389724877572933408962784121810e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(5.538459396362304687500000000000000000000e1), SC_(1.433412647247314453125000000000000000000e1), SC_(9.034581449355297571199439006101212682858e-5), SC_(9.999096541855064470242880056099389878732e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(5.569964599609375000000000000000000000000e1), SC_(2.882577896118164062500000000000000000000e1), SC_(1.502491024742726900721768573150553664461e-2), SC_(9.849750897525727309927823142684944633554e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(5.940588760375976562500000000000000000000e1), SC_(4.601834869384765625000000000000000000000e1), SC_(1.611280641977754491265049708566642649071e-1), SC_(8.388719358022245508734950291433357350929e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(6.038262176513671875000000000000000000000e1), SC_(5.610107803344726562500000000000000000000e1), SC_(3.657521178731620226395103904384252292498e-1), SC_(6.342478821268379773604896095615747707502e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(6.163340759277343750000000000000000000000e1), SC_(6.294946670532226562500000000000000000000e1), SC_(5.091374904325356692615510556985159084002e-1), SC_(4.908625095674643307384489443014840915998e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(6.331008529663085937500000000000000000000e1), SC_(6.519673919677734375000000000000000000000e1), SC_(5.231859749752328120091326913983730165168e-1), SC_(4.768140250247671879908673086016269834832e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(6.341989517211914062500000000000000000000e1), SC_(6.537181091308593750000000000000000000000e1), SC_(5.247798390357895659922652920258981413362e-1), SC_(4.752201609642104340077347079741018586638e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(7.225879669189453125000000000000000000000e1), SC_(7.421813201904296875000000000000000000000e1), SC_(5.234172204634461348973050395185083796154e-1), SC_(4.765827795365538651026949604814916203846e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(7.844540405273437500000000000000000000000e1), SC_(8.047771453857421875000000000000000000000e1), SC_(5.241166012332058450099735584802403396666e-1), SC_(4.758833987667941549900264415197596603334e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(7.974770355224609375000000000000000000000e1), SC_(8.251660919189453125000000000000000000000e1), SC_(5.401275541463796727029721715244411607698e-1), SC_(4.598724458536203272970278284755588392302e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(8.435225677490234375000000000000000000000e1), SC_(9.493458557128906250000000000000000000000e1), SC_(6.945150702027718064387971840673098423325e-1), SC_(3.054849297972281935612028159326901576675e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(8.441753387451171875000000000000000000000e1), SC_(1.036433410644531250000000000000000000000e2), SC_(8.272511071589428500718069542694108681095e-1), SC_(1.727488928410571499281930457305891318905e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(9.495173645019531250000000000000000000000e1), SC_(1.259747390747070312500000000000000000000e2), SC_(9.242119719038375857308175896733646764492e-1), SC_(7.578802809616241426918241032663532355085e-2) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(9.707512664794921875000000000000000000000e1), SC_(1.485405578613281250000000000000000000000e2), SC_(9.890367746031278342312969412157252380369e-1), SC_(1.096322539687216576870305878427476196306e-2) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(9.811781311035156250000000000000000000000e1), SC_(2.001394500732421875000000000000000000000e2), SC_(9.999867471525884221223495220849233657771e-1), SC_(1.325284741157787765047791507663422291772e-5) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.007325439453125000000000000000000000000e2), SC_(3.080533752441406250000000000000000000000e2), SC_(9.999999999999626856367701345315672334662e-1), SC_(3.731436322986546843276653379798110295426e-14) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.093762969970703125000000000000000000000e2), SC_(4.453128356933593750000000000000000000000e2), SC_(9.999999999999999999999999869957388503105e-1), SC_(1.300426114968953210370021710236260945941e-26) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.094441146850585937500000000000000000000e2), SC_(5.569801025390625000000000000000000000000e2), SC_(9.999999999999999999999999999999999999985e-1), SC_(1.454780177561926332042209107700037715461e-39) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.264718551635742187500000000000000000000e2), SC_(1.284237670898437500000000000000000000000e1), SC_(5.222989929752465381367695253781868498622e-15), SC_(9.999999999999947770100702475346186323047e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.279526672363281250000000000000000000000e2), SC_(3.247614669799804687500000000000000000000e1), SC_(7.092987538615312696053198552453967755005e-9), SC_(9.999999929070124613846873039468014475460e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.310955810546875000000000000000000000000e2), SC_(6.652375030517578125000000000000000000000e1), SC_(4.149921419238204980392051630305258887363e-4), SC_(9.995850078580761795019607948369694741113e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.311481323242187500000000000000000000000e2), SC_(9.982504272460937500000000000000000000000e1), SC_(6.612715986899804491611660635109993003519e-2), SC_(9.338728401310019550838833936489000699648e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.327210998535156250000000000000000000000e2), SC_(1.212057113647460937500000000000000000000e2), SC_(2.899836628432815307947437260175033162688e-1), SC_(7.100163371567184692052562739824966837312e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.357470245361328125000000000000000000000e2), SC_(1.363219604492187500000000000000000000000e2), SC_(4.935330558490911252185725134753965026552e-1), SC_(5.064669441509088747814274865246034973448e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.362719116210937500000000000000000000000e2), SC_(1.380856018066406250000000000000000000000e2), SC_(5.146537665673362067255846059601319698069e-1), SC_(4.853462334326637932744153940398680301931e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.389657287597656250000000000000000000000e2), SC_(1.409176483154296875000000000000000000000e2), SC_(5.168378642075320211457630901833535233871e-1), SC_(4.831621357924679788542369098166464766129e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.412092285156250000000000000000000000000e2), SC_(1.431754608154296875000000000000000000000e2), SC_(5.169436664301119716716053496901880183243e-1), SC_(4.830563335698880283283946503098119816757e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.451677856445312500000000000000000000000e2), SC_(1.472668304443359375000000000000000000000e2), SC_(5.188981985493474256932176544847754096874e-1), SC_(4.811018014506525743067823455152245903126e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.481294555664062500000000000000000000000e2), SC_(1.515821838378906250000000000000000000000e2), SC_(5.406622878092400357690536608444921680034e-1), SC_(4.593377121907599642309463391555078319966e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.486264953613281250000000000000000000000e2), SC_(1.656362609863281250000000000000000000000e2), SC_(7.391397189328775581384348958477215460740e-1), SC_(2.608602810671224418615651041522784539260e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.515480346679687500000000000000000000000e2), SC_(1.841999511718750000000000000000000000000e2), SC_(8.896558084407117967808474192131987138874e-1), SC_(1.103441915592882032191525807868012861126e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.527500000000000000000000000000000000000e2), SC_(2.011124877929687500000000000000000000000e2), SC_(9.629705966174118390791283637763410295302e-1), SC_(3.702940338258816092087163622365897046984e-2) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.584414672851562500000000000000000000000e2), SC_(2.405900878906250000000000000000000000000e2), SC_(9.980712396528729011573908230977135787903e-1), SC_(1.928760347127098842609176902286421209744e-3) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.594559783935546875000000000000000000000e2), SC_(3.228157958984375000000000000000000000000e2), SC_(9.999999445917227847846508437559823409047e-1), SC_(5.540827721521534915624401765909528966399e-8) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.595857238769531250000000000000000000000e2), SC_(4.846129150390625000000000000000000000000e2), SC_(9.999999999999999999957405096393651479609e-1), SC_(4.259490360634852039115781052649444943445e-21) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.596211700439453125000000000000000000000e2), SC_(6.462923583984375000000000000000000000000e2), SC_(9.999999999999999999999999999999999998666e-1), SC_(1.334240896327898129861145777016715981703e-37) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.600560913085937500000000000000000000000e2), SC_(8.100400390625000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.959033484704693563237887368387876094125e-56) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.629447326660156250000000000000000000000e2), SC_(1.648966598510742187500000000000000000000e1), SC_(9.167717762926751639562323741092713671023e-19), SC_(9.999999999999999990832282237073248360438e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.643806610107421875000000000000000000000e2), SC_(4.158314514160156250000000000000000000000e1), SC_(6.635104828532394976511689206464619299402e-11), SC_(9.999999999336489517146760502348831079354e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.646915740966796875000000000000000000000e2), SC_(8.332174682617187500000000000000000000000e1), SC_(8.877933385269344342993873370536241618220e-5), SC_(9.999112206661473065565700612662946375838e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.670017089843750000000000000000000000000e2), SC_(1.267152252197265625000000000000000000000e2), SC_(4.404080534539653836326637077307100132619e-2), SC_(9.559591946546034616367336292269289986738e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.698258666992187500000000000000000000000e2), SC_(1.546000061035156250000000000000000000000e2), SC_(2.626077736179533577014264746732463461010e-1), SC_(7.373922263820466422985735253267536538990e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.744857635498046875000000000000000000000e2), SC_(1.746733093261718750000000000000000000000e2), SC_(4.884483877627272382067126274402840282987e-1), SC_(5.115516122372727617932873725597159717013e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.756861267089843750000000000000000000000e2), SC_(1.774604034423828125000000000000000000000e2), SC_(5.123292472343257121491820306091457768603e-1), SC_(4.876707527656742878508179693908542231397e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.811583862304687500000000000000000000000e2), SC_(1.831103057861328125000000000000000000000e2), SC_(5.147641643089927252992451128098223098027e-1), SC_(4.852358356910072747007548871901776901973e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.826751708984375000000000000000000000000e2), SC_(1.846455535888671875000000000000000000000e2), SC_(5.149744024532565112252628480173107351569e-1), SC_(4.850255975467434887747371519826892648431e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.831471099853515625000000000000000000000e2), SC_(1.852841339111328125000000000000000000000e2), SC_(5.173989231868442191648149838015326477406e-1), SC_(4.826010768131557808351850161984673522594e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.867986450195312500000000000000000000000e2), SC_(1.906380615234375000000000000000000000000e2), SC_(5.418383678452370019625910654590176634153e-1), SC_(4.581616321547629980374089345409823365847e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.900444183349609375000000000000000000000e2), SC_(2.111959686279296875000000000000000000000e2), SC_(7.621614574411497854116712351443224484737e-1), SC_(2.378385425588502145883287648556775515263e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.914333953857421875000000000000000000000e2), SC_(2.320623931884765625000000000000000000000e2), SC_(9.138501265164190617009519777365495932300e-1), SC_(8.614987348358093829904802226345040676996e-2) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.915013732910156250000000000000000000000e2), SC_(2.514892730712890625000000000000000000000e2), SC_(9.765876955044236881680262029418342130911e-1), SC_(2.341230449557631183197379705816578690893e-2) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.918984832763671875000000000000000000000e2), SC_(2.907756042480468750000000000000000000000e2), SC_(9.992337754696606270473018942762985364855e-1), SC_(7.662245303393729526981057237014635145146e-4) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.929777069091796875000000000000000000000e2), SC_(3.898592529296875000000000000000000000000e2), SC_(9.999999971376018688384410865365041737010e-1), SC_(2.862398131161558913463495826299024286779e-9) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.935389862060546875000000000000000000000e2), SC_(5.864727172851562500000000000000000000000e2), SC_(9.999999999999999999999995652648341061328e-1), SC_(4.347351658938672284673136467960414189993e-25) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.937735595703125000000000000000000000000e2), SC_(7.829019165039062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.661186488229068453487714707131587552013e-45) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.941185607910156250000000000000000000000e2), SC_(9.803524169921875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(8.922479928837041211361486727912709375066e-68) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.962219390869140625000000000000000000000e2), SC_(1.981738662719726562500000000000000000000e1), SC_(3.505734027992608020264856944689029590037e-22), SC_(9.999999999999999999996494265972007391980e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.985762634277343750000000000000000000000e2), SC_(5.013204574584960937500000000000000000000e1), SC_(8.438784065482668776443535288715718203042e-13), SC_(9.999999999991561215934517331223556464711e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.988137054443359375000000000000000000000e2), SC_(1.003828125000000000000000000000000000000e2), SC_(1.886909192024499376961525144158126850823e-5), SC_(9.999811309080797550062303847485584187315e-1) }}, 
      {{ SC_(1.951913356781005859375000000000000000000), SC_(1.992922668457031250000000000000000000000e2), SC_(1.509331359863281250000000000000000000000e2), SC_(3.089820420481789721640202810808322921302e-2), SC_(9.691017957951821027835979718919167707870e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.923051261901855468750000000000000000000e1), SC_(4.106550779352854586592116751005689870035e-1), SC_(5.893449220647145413407883248994310129965e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(2.650933647155761718750000000000000000000e1), SC_(5.259841921535170243848539268924414419265e-1), SC_(4.740158078464829756151460731075585580735e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(2.727245521545410156250000000000000000000e1), SC_(5.374500840485187786429314870030982284700e-1), SC_(4.625499159514812213570685129969017715300e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(2.755287551879882812500000000000000000000e1), SC_(5.386136302106575066447173824064396927371e-1), SC_(4.613863697893424933552826175935603072629e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(2.964778327941894531250000000000000000000e1), SC_(5.375770101369802987870875309182258884537e-1), SC_(4.624229898630197012129124690817741115463e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(3.987673187255859375000000000000000000000e1), SC_(5.339862124553635286053141461209497907985e-1), SC_(4.660137875446364713946858538790502092015e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(4.031780242919921875000000000000000000000e1), SC_(5.469325718862134980271219845468685922526e-1), SC_(4.530674281137865019728780154531314077474e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(4.662117767333984375000000000000000000000e1), SC_(6.703076301144170164264538707312395443440e-1), SC_(3.296923698855829835735461292687604556560e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(5.148413467407226562500000000000000000000e1), SC_(7.841387174579462182997530348635198210550e-1), SC_(2.158612825420537817002469651364801789450e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(5.908121490478515625000000000000000000000e1), SC_(8.716263111174612241849624015990365327750e-1), SC_(1.283736888825387758150375984009634672250e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(6.871185302734375000000000000000000000000e1), SC_(9.614654370451057187380181299263501920030e-1), SC_(3.853456295489428126198187007364980799696e-2) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(9.501188659667968750000000000000000000000e1), SC_(9.993267213707996393912063393085907734506e-1), SC_(6.732786292003606087936606914092265494017e-4) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(1.463634185791015625000000000000000000000e2), SC_(9.999999892368315780836985781885943957270e-1), SC_(1.076316842191630142181140560427300559658e-8) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(2.009333496093750000000000000000000000000e2), SC_(9.999999999999903499628810018880955368126e-1), SC_(9.650037118998111904463187444500118225659e-15) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(2.596658020019531250000000000000000000000e2), SC_(9.999999999999999999991991622119461367414e-1), SC_(8.008377880538632586075216773844561291081e-22) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.464787483215332031250000000000000000000), SC_(5.530337159229242574890042121836041219985e-10), SC_(9.999999994469662840770757425109957878164e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(1.379589271545410156250000000000000000000e1), SC_(1.049191155078189882371817166836359821413e-5), SC_(9.999895080884492181011762818283316364018e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(2.904346847534179687500000000000000000000e1), SC_(7.338755749292713503871059646032248642210e-3), SC_(9.926612442507072864961289403539677513578e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(4.709654998779296875000000000000000000000e1), SC_(1.353775684540510283153055369561329405837e-1), SC_(8.646224315459489716846944630438670594163e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(5.815561294555664062500000000000000000000e1), SC_(3.498814900994391070706353702001448851230e-1), SC_(6.501185099005608929293646297998551148770e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(7.503718566894531250000000000000000000000e1), SC_(5.047420877858410581744435876512126454864e-1), SC_(4.952579122141589418255564123487873545136e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(7.603407287597656250000000000000000000000e1), SC_(5.214813032442956563111351436710465497436e-1), SC_(4.785186967557043436888648563289534502564e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(7.981642913818359375000000000000000000000e1), SC_(5.227776429953706444975914975084136239324e-1), SC_(4.772223570046293555024085024915863760676e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(8.080123901367187500000000000000000000000e1), SC_(5.228260069036264313449683939508316860310e-1), SC_(4.771739930963735686550316060491683139690e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(8.212599182128906250000000000000000000000e1), SC_(5.243781162830113357771718082521991679024e-1), SC_(4.756218837169886642228281917478008320976e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(8.455783081054687500000000000000000000000e1), SC_(5.415319670266749747707829988075268848347e-1), SC_(4.584680329733250252292170011924731151653e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(9.221348571777343750000000000000000000000e1), SC_(7.020647886773129595992163039483391292775e-1), SC_(2.979352113226870404007836960516608707225e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.112032089233398437500000000000000000000e2), SC_(8.464378094649198200044786912391713590978e-1), SC_(1.535621905350801799955213087608286409022e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.285127258300781250000000000000000000000e2), SC_(9.348632404864001473606559543048967360836e-1), SC_(6.513675951359985263934404569510326391638e-2) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.502373657226562500000000000000000000000e2), SC_(9.918731558205961060228743763287456913490e-1), SC_(8.126844179403893977125623671254308651023e-3) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(2.095255889892578125000000000000000000000e2), SC_(9.999958330001272783255604536901110822856e-1), SC_(4.166999872721674439546309888917714377234e-6) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(3.144842224121093750000000000000000000000e2), SC_(9.999999999999968935989057028206191571016e-1), SC_(3.106401094297179380842898369324617802812e-15) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(4.614490966796875000000000000000000000000e2), SC_(9.999999999999999999999999999249096797479e-1), SC_(7.509032025210056405314211401773924821958e-29) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(5.874283447265625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.742249533734918496554876149304573313077e-43) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.185283565521240234375000000000000000000e1), SC_(3.475236797258460791004220189646188256133e-16), SC_(9.999999999999996524763202741539208995780e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(3.028577041625976562500000000000000000000e1), SC_(2.811464095472051617964497655185986179761e-9), SC_(9.999999971885359045279483820355023448140e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(6.489341735839843750000000000000000000000e1), SC_(2.702168088181380185222070105067039122464e-4), SC_(9.997297831911818619814777929894932960878e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(9.739099121093750000000000000000000000000e1), SC_(6.065338305501645172713154834894981636356e-2), SC_(9.393466169449835482728684516510501836364e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.321941528320312500000000000000000000000e2), SC_(2.733443413750177553036319453844929136241e-1), SC_(7.266556586249822446963680546155070863759e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(1.468795776367187500000000000000000000000e2), SC_(4.913690375995312861830109186629315829170e-1), SC_(5.086309624004687138169890813370684170830e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.513546142578125000000000000000000000000e2), SC_(5.138535392029746616123297730375686410723e-1), SC_(4.861464607970253383876702269624313589277e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.515586700439453125000000000000000000000e2), SC_(5.163878223949485240690148718598528210013e-1), SC_(4.836121776050514759309851281401471789987e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(1.531469573974609375000000000000000000000e2), SC_(5.165566586145040383646756593900776162182e-1), SC_(4.834433413854959616353243406099223837818e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(1.563137207031250000000000000000000000000e2), SC_(5.187109543897593695516040831915068724889e-1), SC_(4.812890456102406304483959168084931275111e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(1.582492675781250000000000000000000000000e2), SC_(5.417571978394294148580445442940135072911e-1), SC_(4.582428021605705851419554557059864927089e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(1.753139038085937500000000000000000000000e2), SC_(7.502820337586663031000130128204896812137e-1), SC_(2.497179662413336968999869871795103187863e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(1.939437255859375000000000000000000000000e2), SC_(9.013380665307144983834301388880843472050e-1), SC_(9.866193346928550161656986111191565279503e-2) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(2.152518157958984375000000000000000000000e2), SC_(9.708773262874531490016805946501191982967e-1), SC_(2.912267371254685099831940534988080170334e-2) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(2.528099975585937500000000000000000000000e2), SC_(9.987910125248408856232334895034807153557e-1), SC_(1.208987475159114376766510496519284644297e-3) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(3.380740661621093750000000000000000000000e2), SC_(9.999999858706789109006193403725546390480e-1), SC_(1.412932108909938065962744536095204087068e-8) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(5.158757324218750000000000000000000000000e2), SC_(9.999999999999999999999586722669580508515e-1), SC_(4.132773304194914848651535413649762299930e-23) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(6.926421508789062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.921457412349703341781869172412956610082e-41) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(8.942600097656250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.098638022426037405887835756705204663433e-64) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(1.798665237426757812500000000000000000000e1), SC_(2.200592650817558573492814808634092113662e-22), SC_(9.999999999999999999997799407349182441427e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(4.499906539916992187500000000000000000000e1), SC_(1.629875149181676270447627124110655039018e-12), SC_(9.999999999983701248508183237295523728759e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.001585388183593750000000000000000000000e1), SC_(2.768376208713935988732690243921824897359e-5), SC_(9.999723162379128606401126730975607817510e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(1.353499755859375000000000000000000000000e2), SC_(3.453111380026774736617071600480443474730e-2), SC_(9.654688861997322526338292839951955652527e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(1.650197448730468750000000000000000000000e2), SC_(2.490346681730032831144465344004704097473e-1), SC_(7.509653318269967168855534655995295902527e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(1.829432830810546875000000000000000000000e2), SC_(4.868851670671602020094553811122657990362e-1), SC_(5.131148329328397979905446188877342009638e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(1.849170074462890625000000000000000000000e2), SC_(5.120125714055588788392583454839455243544e-1), SC_(4.879874285944411211607416545160544756456e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(1.874122467041015625000000000000000000000e2), SC_(5.147069139759497995501675687577267609196e-1), SC_(4.852930860240502004498324312422732390804e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(1.902554321289062500000000000000000000000e2), SC_(5.148777453099649425608797337591095350497e-1), SC_(4.851222546900350574391202662408904649503e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(1.950912017822265625000000000000000000000e2), SC_(5.172710407027106722191842854133021034935e-1), SC_(4.827289592972893277808157145866978965065e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(1.980576324462890625000000000000000000000e2), SC_(5.428726371439458223217107443875707151094e-1), SC_(4.571273628560541776782892556124292848906e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(2.217258148193359375000000000000000000000e2), SC_(7.719636851754905838053458686524640305620e-1), SC_(2.280363148245094161946541313475359694380e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(2.437028656005859375000000000000000000000e2), SC_(9.232666847020823902113643250011108137623e-1), SC_(7.673331529791760978863567499888918623774e-2) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(2.646249389648437500000000000000000000000e2), SC_(9.812694603464963595015310447096934669216e-1), SC_(1.873053965350364049846895529030653307837e-2) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(3.108137817382812500000000000000000000000e2), SC_(9.995793165684844154984477967041733275254e-1), SC_(4.206834315155845015522032958266724745837e-4) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(4.209099121093750000000000000000000000000e2), SC_(9.999999996296334682681685111873858683602e-1), SC_(3.703665317318314888126141316398345428113e-10) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(6.355317993164062500000000000000000000000e2), SC_(9.999999999999999999999999991254994771261e-1), SC_(8.745005228739308417489521141300788876246e-28) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(8.476476440429687500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.942268203657379607176944166598414680859e-50) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(1.061545166015625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.388901730464632285795450654891215852334e-75) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(2.133882522583007812500000000000000000000e1), SC_(8.652302993310430171251473645995584962282e-26), SC_(9.999999999999999999999999134769700668957e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(5.348738098144531250000000000000000000000e1), SC_(2.215269447012621491175708805219677614871e-14), SC_(9.999999999999778473055298737850882429119e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(1.070920486450195312500000000000000000000e2), SC_(5.965485299266903391650452683304822896904e-6), SC_(9.999940345147007330966083495473166951771e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(1.608968200683593750000000000000000000000e2), SC_(2.392646509991517841275189437703243304155e-2), SC_(9.760735349000848215872481056229675669585e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(1.949692230224609375000000000000000000000e2), SC_(2.298735411882663615771595224277588702276e-1), SC_(7.701264588117336384228404775722411297724e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(2.167969360351562500000000000000000000000e2), SC_(4.833197520874171716033617522191369396903e-1), SC_(5.166802479125828283966382477808630603097e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(2.190050201416015625000000000000000000000e2), SC_(5.105598193191399688567068899761054571383e-1), SC_(4.894401806808600311432931100238945428617e-1) }}, 
      {{ SC_(2.041053962707519531250000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.197028045654296875000000000000000000000e2), SC_(5.135654827887897764991803291821773592588e-1), SC_(4.864345172112102235008196708178226407412e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.382156944274902343750000000000000000000e1), SC_(5.393973404340031284482567229244415914306e-1), SC_(4.606026595659968715517432770755584085694e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(2.925828742980957031250000000000000000000e1), SC_(5.386171213895055469167596312458178682887e-1), SC_(4.613828786104944530832403687541821317113e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(3.004922103881835937500000000000000000000e1), SC_(5.506879802477725422538152328180398009574e-1), SC_(4.493120197522274577461847671819601990426e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(3.300531005859375000000000000000000000000e1), SC_(6.660026928003810438322876583712399638718e-1), SC_(3.339973071996189561677123416287600361282e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(3.851612091064453125000000000000000000000e1), SC_(7.744051920478462984324437240009985569743e-1), SC_(2.255948079521537015675562759990014430257e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(5.497549819946289062500000000000000000000e1), SC_(8.704899349875384159407209087918627638120e-1), SC_(1.295100650124615840592790912081372361880e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(6.355585098266601562500000000000000000000e1), SC_(9.601022042317186004852918253226640438961e-1), SC_(3.989779576828139951470817467733595610392e-2) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(8.966967773437500000000000000000000000000e1), SC_(9.992731295106097523796684323449526237814e-1), SC_(7.268704893902476203315676550473762185930e-4) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(1.360661773681640625000000000000000000000e2), SC_(9.999999819487288886902268485464235965190e-1), SC_(1.805127111130977315145357640348099597179e-8) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(1.915961608886718750000000000000000000000e2), SC_(9.999999999999834941729145040523647341820e-1), SC_(1.650582708549594763526581801129164649872e-14) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(2.412992706298828125000000000000000000000e2), SC_(9.999999999999999999945708346025668225265e-1), SC_(5.429165397433177473458621832426023649700e-21) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(4.995789527893066406250000000000000000000), SC_(4.783791679863929288739592891514690065520e-10), SC_(9.999999995216208320136070711260407108485e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(1.280993938446044921875000000000000000000e1), SC_(1.087720387564603140357852171224465795431e-5), SC_(9.999891227961243539685964214782877553420e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(2.634264373779296875000000000000000000000e1), SC_(8.330667190251120127018929114816228859096e-3), SC_(9.916693328097488798729810708851837711409e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(4.078883361816406250000000000000000000000e1), SC_(1.467447244726621709910684667585720186689e-1), SC_(8.532552755273378290089315332414279813311e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.138983917236328125000000000000000000000e1), SC_(3.572901561510026106736002765972602895827e-1), SC_(6.427098438489973893263997234027397104173e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(5.705916595458984375000000000000000000000e1), SC_(5.101032195277946970427207229003183824981e-1), SC_(4.898967804722053029572792770996816175019e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(6.047834777832031250000000000000000000000e1), SC_(5.245990659187459429465601244432899711543e-1), SC_(4.754009340812540570534398755567100288457e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(6.524735260009765625000000000000000000000e1), SC_(5.253172073260585622731907637396735491844e-1), SC_(4.746827926739414377268092362603264508156e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(6.707600402832031250000000000000000000000e1), SC_(5.251384644879191457941919083475761647334e-1), SC_(4.748615355120808542058080916524238352666e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(7.832533264160156250000000000000000000000e1), SC_(5.249507261903580794581546714225522471049e-1), SC_(4.750492738096419205418453285774477528951e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(7.934775543212890625000000000000000000000e1), SC_(5.419589894465646780861529848677391442704e-1), SC_(4.580410105534353219138470151322608557296e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(9.049521636962890625000000000000000000000e1), SC_(7.023174293318717627989497398333914598357e-1), SC_(2.976825706681282372010502601666085401643e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(9.989413452148437500000000000000000000000e1), SC_(8.382166244667784680444211519295336868231e-1), SC_(1.617833755332215319555788480704663131769e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(1.098446578979492187500000000000000000000e2), SC_(9.235613479187674096970159698808856775034e-1), SC_(7.643865208123259030298403011911432249662e-2) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(1.292588653564453125000000000000000000000e2), SC_(9.883915967353635942710657703833222560810e-1), SC_(1.160840326463640572893422961667774391902e-2) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(1.725647735595703125000000000000000000000e2), SC_(9.999807360631496821883957454964090376793e-1), SC_(1.926393685031781160425450359096232070037e-5) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(2.853638610839843750000000000000000000000e2), SC_(9.999999999999677868414053382329782324291e-1), SC_(3.221315859466176702176757092945718278972e-14) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(4.052315673828125000000000000000000000000e2), SC_(9.999999999999999999999999456721260808389e-1), SC_(5.432787391916105785898965460655735359259e-26) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(5.130509643554687500000000000000000000000e2), SC_(9.999999999999999999999999999999999999920e-1), SC_(7.953463800013936626336527567693687966741e-39) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.072147464752197265625000000000000000000e1), SC_(2.134829176464298967762993070288008220838e-15), SC_(9.999999999999978651708235357010322370069e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(2.682000541687011718750000000000000000000e1), SC_(1.182922603367470520028255865112670330715e-8), SC_(9.999999881707739663252947997174413488733e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(5.890711212158203125000000000000000000000e1), SC_(4.283924646676764420863093003818554501850e-4), SC_(9.995716075353323235579136906996181445498e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(8.995320892333984375000000000000000000000e1), SC_(6.672592500750255249249521296796648194262e-2), SC_(9.332740749924974475075047870320335180574e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.088822708129882812500000000000000000000e2), SC_(2.922399906653099067953246850997356233092e-1), SC_(7.077600093346900932046753149002643766908e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(1.223590850830078125000000000000000000000e2), SC_(4.949237531506560140638725619732570867495e-1), SC_(5.050762468493439859361274380267429132505e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.321065521240234375000000000000000000000e2), SC_(5.151991035107488537130721100500934052583e-1), SC_(4.848008964892511462869278899499065947417e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.323066101074218750000000000000000000000e2), SC_(5.175887731913992781327518235724173202314e-1), SC_(4.824112268086007218672481764275826797686e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.493492889404296875000000000000000000000e2), SC_(5.167844681704247892771651897721958189486e-1), SC_(4.832155318295752107228348102278041810514e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(1.509659729003906250000000000000000000000e2), SC_(5.189889873725158667329266995398370658921e-1), SC_(4.810110126274841332670733004601629341079e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.554976501464843750000000000000000000000e2), SC_(5.418203213653951842265520478199187973985e-1), SC_(4.581796786346048157734479521800812026015e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.694116821289062500000000000000000000000e2), SC_(7.481378457509126589119634050944946839093e-1), SC_(2.518621542490873410880365949055053160907e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(1.867003173828125000000000000000000000000e2), SC_(8.984635705666289051828808794077693595215e-1), SC_(1.015364294333710948171191205922306404785e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(2.061923522949218750000000000000000000000e2), SC_(9.688778451282297886628490939899470813417e-1), SC_(3.112215487177021133715090601005291865834e-2) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(2.387015991210937500000000000000000000000e2), SC_(9.984868731354923418141844149409681473466e-1), SC_(1.513126864507658185815585059031852653398e-3) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(3.236564331054687500000000000000000000000e2), SC_(9.999999758133699190291795212340989127936e-1), SC_(2.418663008097082047876590108720643475276e-8) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(4.922151489257812500000000000000000000000e2), SC_(9.999999999999999999997308636539456490552e-1), SC_(2.691363460543509447510509588661961612714e-22) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(6.721210937500000000000000000000000000000e2), SC_(9.999999999999999999999999999999999999998e-1), SC_(1.649406843902133386542318554427647555239e-40) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(8.549597167968750000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.609404678421411092606208068386849652787e-61) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(1.714889907836914062500000000000000000000e1), SC_(7.710905743978706411402072379688102619748e-22), SC_(9.999999999999999999992289094256021293589e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(4.360263061523437500000000000000000000000e1), SC_(2.493199312226213446761022209359116361831e-12), SC_(9.999999999975068006877737865532389777906e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(8.780624389648437500000000000000000000000e1), SC_(3.121628621368548604611241282784182565631e-5), SC_(9.999687837137863145139538875871721581743e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(1.359779663085937500000000000000000000000e2), SC_(3.366428997676973224640490001098547147980e-2), SC_(9.663357100232302677535950999890145285202e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(1.640866088867187500000000000000000000000e2), SC_(2.488444764818370397060564113189528634922e-1), SC_(7.511555235181629602939435886810471365078e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(1.806237335205078125000000000000000000000e2), SC_(4.870642566875539828306937426956203663545e-1), SC_(5.129357433124460171693062573043796336455e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(1.823011779785156250000000000000000000000e2), SC_(5.121438871971701416636715323620306730621e-1), SC_(4.878561128028298583363284676379693269379e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(1.829185791015625000000000000000000000000e2), SC_(5.149043778756734015159705178636818607076e-1), SC_(4.850956221243265984840294821363181392924e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(1.858258056640625000000000000000000000000e2), SC_(5.150659828012825260087359529897143816278e-1), SC_(4.849340171987174739912640470102856183722e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(1.874304046630859375000000000000000000000e2), SC_(5.175383053580094488712678971365647630612e-1), SC_(4.824616946419905511287321028634352369388e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(1.894295959472656250000000000000000000000e2), SC_(5.427182213827090118157918100931414038153e-1), SC_(4.572817786172909881842081899068585961847e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(2.088506164550781250000000000000000000000e2), SC_(7.669670466810108988485048351682079095934e-1), SC_(2.330329533189891011514951648317920904066e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(2.312260284423828125000000000000000000000e2), SC_(9.189961663968104396321810594198815311006e-1), SC_(8.100383360318956036781894058011846889938e-2) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(2.565527038574218750000000000000000000000e2), SC_(9.801766427991221689456391420317564560926e-1), SC_(1.982335720087783105436085796824354390738e-2) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(2.978229370117187500000000000000000000000e2), SC_(9.994848784879091465252227597948429070726e-1), SC_(5.151215120908534747772402051570929273599e-4) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(4.080417480468750000000000000000000000000e2), SC_(9.999999994072957597629311538302026954753e-1), SC_(5.927042402370688461697973045246594287841e-10) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(6.166129760742187500000000000000000000000e2), SC_(9.999999999999999999999999962632768137858e-1), SC_(3.736723186214170979245735537612688244085e-27) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(8.240383911132812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(8.856883590453333794899547559763732768650e-49) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(1.048305664062500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.291755652429688327523910645594715846600e-74) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(2.129069137573242187500000000000000000000e1), SC_(4.926320343767348544587319183572815212140e-26), SC_(9.999999999999999999999999507367965623265e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(5.357397079467773437500000000000000000000e1), SC_(1.613349777151118199628240506869900207787e-14), SC_(9.999999999999838665022284888180037175949e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(1.071819305419921875000000000000000000000e2), SC_(5.480863677954843187316752476786944551097e-6), SC_(9.999945191363220451568126832475232130554e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(1.610707244873046875000000000000000000000e2), SC_(2.349608059796322713982197158761939568392e-2), SC_(9.765039194020367728601780284123806043161e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(1.942561645507812500000000000000000000000e2), SC_(2.295823660795995541714612580574383529931e-1), SC_(7.704176339204004458285387419425616470069e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(2.142374572753906250000000000000000000000e2), SC_(4.834938861512742954773384010118879464854e-1), SC_(5.165061138487257045226615989881120535146e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(2.164194183349609375000000000000000000000e2), SC_(5.106617831465703103520037582468927786053e-1), SC_(4.893382168534296896479962417531072213947e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.169810485839843750000000000000000000000e2), SC_(5.136632412139303640727014132848765330916e-1), SC_(4.863367587860696359272985867151234669084e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(2.191063385009765625000000000000000000000e2), SC_(5.138991740847107608956441628065395428823e-1), SC_(4.861008259152892391043558371934604571177e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(2.216602020263671875000000000000000000000e2), SC_(5.165646063609265268049261146778165228328e-1), SC_(4.834353936390734731950738853221834771672e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(2.238929595947265625000000000000000000000e2), SC_(5.438136126209364350160387969519669800464e-1), SC_(4.561863873790635649839612030480330199536e-1) }}, 
      {{ SC_(2.286248970031738281250000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.443702392578125000000000000000000000000e2), SC_(7.821293078465972968912945822024567975929e-1), SC_(2.178706921534027031087054177975432024071e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.920456504821777343750000000000000000000e1), SC_(7.701619689864883552282645774894494583129e-1), SC_(2.298380310135116447717354225105505416871e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(3.867111206054687500000000000000000000000e1), SC_(8.536882104199552135278250323672546940713e-1), SC_(1.463117895800447864721749676327453059287e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(4.540448379516601562500000000000000000000e1), SC_(9.475024272020092576461053443301108007543e-1), SC_(5.249757279799074235389465566988919924575e-2) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(6.104555130004882812500000000000000000000e1), SC_(9.979009213090929483152041761442604410212e-1), SC_(2.099078690907051684795823855739558978840e-3) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(9.784414672851562500000000000000000000000e1), SC_(9.999996429509347028169492236371385870386e-1), SC_(3.570490652971830507763628614129613520355e-7) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(1.712271728515625000000000000000000000000e2), SC_(9.999999999998383336887154175309094063336e-1), SC_(1.616663112845824690905936663884408349737e-13) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(2.144425964355468750000000000000000000000e2), SC_(9.999999999999999997757721708726539451557e-1), SC_(2.242278291273460548442597260119626534044e-19) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(4.535279273986816406250000000000000000000), SC_(8.565692251194593994203576397529588980703e-10), SC_(9.999999991434307748805406005796423602470e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(1.146833610534667968750000000000000000000e1), SC_(1.770369311452079774808791280723135249249e-5), SC_(9.999822963068854792022519120871927686475e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(2.420849609375000000000000000000000000000e1), SC_(9.766082864890789239727054097066193738191e-3), SC_(9.902339171351092107602729459029338062618e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(3.658335113525390625000000000000000000000e1), SC_(1.564258244093260433227198118772908886105e-1), SC_(8.435741755906739566772801881227091113895e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(4.542825698852539062500000000000000000000e1), SC_(3.655080168733646719484535924077720043407e-1), SC_(6.344919831266353280515464075922279956593e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(5.124012756347656250000000000000000000000e1), SC_(5.122428532989247820748093139497423256434e-1), SC_(4.877571467010752179251906860502576743566e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(5.315003204345703125000000000000000000000e1), SC_(5.264836165592178795141820818888911932754e-1), SC_(4.735163834407821204858179181111088067246e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(5.490305709838867187500000000000000000000e1), SC_(5.276734203484701811667412576337144846365e-1), SC_(4.723265796515298188332587423662855153635e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(5.762353897094726562500000000000000000000e1), SC_(5.271664490002280943602948186740637820871e-1), SC_(4.728335509997719056397051813259362179129e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(5.821162796020507812500000000000000000000e1), SC_(5.285613103783394796281871881550087397627e-1), SC_(4.714386896216605203718128118449912602373e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(6.166740417480468750000000000000000000000e1), SC_(5.433665159143070463569332727465969539736e-1), SC_(4.566334840856929536430667272534030460264e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(7.234183502197265625000000000000000000000e1), SC_(6.904477229649337236044782162891063807128e-1), SC_(3.095522770350662763955217837108936192872e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(8.110470581054687500000000000000000000000e1), SC_(8.206615926511738711300403731930846310722e-1), SC_(1.793384073488261288699596268069153689278e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(1.023945388793945312500000000000000000000e2), SC_(9.182308420573196807915339615684586769129e-1), SC_(8.176915794268031920846603843154132308711e-2) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(1.186201324462890625000000000000000000000e2), SC_(9.859306758347213800631144762801057743742e-1), SC_(1.406932416527861993688552371989422562583e-2) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(1.655726623535156250000000000000000000000e2), SC_(9.999743802065006385048518236614685978626e-1), SC_(2.561979349936149514817633853140213736433e-5) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(2.512891845703125000000000000000000000000e2), SC_(9.999999999993573538036574940738193444883e-1), SC_(6.426461963425059261806555116993767058959e-13) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(3.400553894042968750000000000000000000000e2), SC_(9.999999999999999999998323057556669433067e-1), SC_(1.676942443330566932731945498391528364892e-22) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(4.334526062011718750000000000000000000000e2), SC_(9.999999999999999999999999999999987255602e-1), SC_(1.274439834175491278262670360552931198558e-33) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(8.680033683776855468750000000000000000000), SC_(1.760475488719150682001991285372308951858e-13), SC_(9.999999999998239524511280849317998008715e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(2.390980911254882812500000000000000000000e1), SC_(4.730351611576702341581824925655315179538e-8), SC_(9.999999526964838842329765841817507434468e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(5.091292190551757812500000000000000000000e1), SC_(8.721790887970133293939985858314287555404e-4), SC_(9.991278209112029866706060014141685712445e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(7.734610748291015625000000000000000000000e1), SC_(8.077083803306832687138444790760108692094e-2), SC_(9.192291619669316731286155520923989130791e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(9.695942687988281250000000000000000000000e1), SC_(3.032727225955075498637871498329900404363e-1), SC_(6.967272774044924501362128501670099595637e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(1.067199935913085937500000000000000000000e2), SC_(4.976075564339134169509266294758530292253e-1), SC_(5.023924435660865830490733705241469707747e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.182138442993164062500000000000000000000e2), SC_(5.163513180834612711836006063716303988600e-1), SC_(4.836486819165387288163993936283696011400e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.204555664062500000000000000000000000000e2), SC_(5.184614991283887098953466366562391034888e-1), SC_(4.815385008716112901046533633437608965112e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.215104064941406250000000000000000000000e2), SC_(5.186105984573671017091498468726219380780e-1), SC_(4.813894015426328982908501531273780619220e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(1.242370986938476562500000000000000000000e2), SC_(5.205072903261599694711644415639164079791e-1), SC_(4.794927096738400305288355584360835920209e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.340843048095703125000000000000000000000e2), SC_(5.414551452540069595496903169831985949218e-1), SC_(4.585448547459930404503096830168014050782e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.461070098876953125000000000000000000000e2), SC_(7.360494882004618959918008062723301413110e-1), SC_(2.639505117995381040081991937276698586890e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.798227539062500000000000000000000000000e2), SC_(8.949827246931510558590003197893663285614e-1), SC_(1.050172753068489441409996802106336714386e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(1.967330169677734375000000000000000000000e2), SC_(9.662000055501751033309967128734649027753e-1), SC_(3.379999444982489666900328712653509722470e-2) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(2.317140197753906250000000000000000000000e2), SC_(9.982924410113071455176928220367578826960e-1), SC_(1.707558988692854482307177963242117304006e-3) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(3.090571289062500000000000000000000000000e2), SC_(9.999999549410783965661460668729832742530e-1), SC_(4.505892160343385393312701672574700358421e-8) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(4.683045959472656250000000000000000000000e2), SC_(9.999999999999999999978116854202624012407e-1), SC_(2.188314579737598759276302286768665796697e-21) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(6.365098876953125000000000000000000000000e2), SC_(9.999999999999999999999999999999999999869e-1), SC_(1.307095074601476900712178027665943453586e-38) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(7.982617187500000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(8.278429920103773647817726159299326673268e-58) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(1.623461723327636718750000000000000000000e1), SC_(5.549047436055906006476328967592193635551e-21), SC_(9.999999999999999999944509525639440939935e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(4.114741516113281250000000000000000000000e1), SC_(8.113176937670734628368361659539744006118e-12), SC_(9.999999999918868230623292653716316383405e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(8.427410888671875000000000000000000000000e1), SC_(4.219558343179008701205038369785544994783e-5), SC_(9.999578044165682099129879496163021445501e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(1.286324157714843750000000000000000000000e2), SC_(3.732662283247705719661052815613140975482e-2), SC_(9.626733771675229428033894718438685902452e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(1.548062286376953125000000000000000000000e2), SC_(2.551272129958804038614477861244959930290e-1), SC_(7.448727870041195961385522138755040069710e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(1.731791839599609375000000000000000000000e2), SC_(4.879115759978640927168867850734290674208e-1), SC_(5.120884240021359072831132149265709325792e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(1.759542999267578125000000000000000000000e2), SC_(5.124626081917060939941221153209293529325e-1), SC_(4.875373918082939060058778846790706470675e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(1.818218994140625000000000000000000000000e2), SC_(5.149531527297794016509991435541716444972e-1), SC_(4.850468472702205983490008564458283555028e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(1.828547058105468750000000000000000000000e2), SC_(5.151891648360485510117023347851236926724e-1), SC_(4.848108351639514489882976652148763073276e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(1.831491241455078125000000000000000000000e2), SC_(5.176874341698160146157534134696684324086e-1), SC_(4.823125658301839853842465865303315675914e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(1.848316345214843750000000000000000000000e2), SC_(5.426073548865914229800269238792805496698e-1), SC_(4.573926451134085770199730761207194503302e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(2.017801818847656250000000000000000000000e2), SC_(7.639128122662960221638409944902850677662e-1), SC_(2.360871877337039778361590055097149322338e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(2.235902099609375000000000000000000000000e2), SC_(9.159839765753484996431120586034988357841e-1), SC_(8.401602342465150035688794139650116421594e-2) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(2.440894317626953125000000000000000000000e2), SC_(9.779266913628038775060884242240889807447e-1), SC_(2.207330863719612249391157577591101925528e-2) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(2.821080322265625000000000000000000000000e2), SC_(9.993197166476411721074563503516766980028e-1), SC_(6.802833523588278925436496483233019971951e-4) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(3.807642822265625000000000000000000000000e2), SC_(9.999999980768508639503680241409835559560e-1), SC_(1.923149136049631975859016444044031299917e-9) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(5.796188964843750000000000000000000000000e2), SC_(9.999999999999999999999999014718486019588e-1), SC_(9.852815139804122998488038285117918382967e-26) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(7.914648437500000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.809396052211381573774227727789016711657e-47) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(9.953327636718750000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.704763675893128304004172981334565603419e-71) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(2.045388221740722656250000000000000000000e1), SC_(3.006439398825021696671940812080421641720e-25), SC_(9.999999999999999999999996993560601174978e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(5.151390075683593750000000000000000000000e1), SC_(4.310215342417523174788209741800095735466e-14), SC_(9.999999999999568978465758247682521179026e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(1.032637786865234375000000000000000000000e2), SC_(7.658038971208463714727942220196475854424e-6), SC_(9.999923419610287915362852720577798035241e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(1.576343078613281250000000000000000000000e2), SC_(2.458897892371515974133931041919903030264e-2), SC_(9.754110210762848402586606895808009696974e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(1.920823669433593750000000000000000000000e2), SC_(2.307348318865330634261894973945215413789e-1), SC_(7.692651681134669365738105026054784586211e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(2.126657104492187500000000000000000000000e2), SC_(4.836335525274568124849561374134384932427e-1), SC_(5.163664474725431875150438625865615067573e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(2.146669311523437500000000000000000000000e2), SC_(5.107305001271888080522064798525232832715e-1), SC_(4.892694998728111919477935201474767167285e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.152789306640625000000000000000000000000e2), SC_(5.137206663704105802088870638618588638898e-1), SC_(4.862793336295894197911129361381411361102e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(2.163797912597656250000000000000000000000e2), SC_(5.139869686375501549997682875456175042940e-1), SC_(4.860130313624498450002317124543824957060e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(2.171363677978515625000000000000000000000e2), SC_(5.166820356674524795990709449893173088702e-1), SC_(4.833179643325475204009290550106826911298e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(2.193255310058593750000000000000000000000e2), SC_(5.436828890080030718798290974050788647470e-1), SC_(4.563171109919969281201709025949211352530e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.392489013671875000000000000000000000000e2), SC_(7.801716800782299481324515543737574742180e-1), SC_(2.198283199217700518675484456262425257820e-1) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(2.635228881835937500000000000000000000000e2), SC_(9.310712714784943569641002790992706734386e-1), SC_(6.892872852150564303589972090072932656145e-2) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(2.885437011718750000000000000000000000000e2), SC_(9.850897264939032094869456929877126183622e-1), SC_(1.491027350609679051305430701228738163783e-2) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(3.332912292480468750000000000000000000000e2), SC_(9.997304496163785046088634030046415378289e-1), SC_(2.695503836214953911365969953584621711362e-4) }}, 
      {{ SC_(2.338043975830078125000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(4.453453979492187500000000000000000000000e2), SC_(9.999999998867614239346382682292284074603e-1), SC_(1.132385760653617317707715925396778568489e-10) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(8.168122100830078125000000000000000000000e1), SC_(9.999996362400567691725674365197240051348e-1), SC_(3.637599432308274325634802759948652059836e-7) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(1.305477752685546875000000000000000000000e2), SC_(9.999999999952023459209922463564365282374e-1), SC_(4.797654079007753643563471762640410451391e-12) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(1.657979583740234375000000000000000000000e2), SC_(9.999999999999999607136426039585448178158e-1), SC_(3.928635739604145518218419957583695179360e-17) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(3.341271162033081054687500000000000000000), SC_(8.653329267576242096138550933791373114887e-10), SC_(9.999999991346670732423757903861449066209e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(8.876163482666015625000000000000000000000), SC_(2.331311469078223390389757782940410883778e-5), SC_(9.999766868853092177660961024221705958912e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(2.284836578369140625000000000000000000000e1), SC_(9.244645678385878601069930525529301005594e-3), SC_(9.907553543216141213989300694744706989944e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(3.433384323120117187500000000000000000000e1), SC_(1.560941137042895892217396407051696929965e-1), SC_(8.439058862957104107782603592948303070035e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(4.341845321655273437500000000000000000000e1), SC_(3.652400986378852753187782420931732689928e-1), SC_(6.347599013621147246812217579068267310072e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(4.827564620971679687500000000000000000000e1), SC_(5.131202743756140081494189711258215934908e-1), SC_(4.868797256243859918505810288741784065092e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(5.125562286376953125000000000000000000000e1), SC_(5.270042323285088770087827934459241130890e-1), SC_(4.729957676714911229912172065540758869110e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(5.166773986816406250000000000000000000000e1), SC_(5.285513295434212751258747488301180860883e-1), SC_(4.714486704565787248741252511698819139117e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(5.337111282348632812500000000000000000000e1), SC_(5.282589030463858798667600659800321993615e-1), SC_(4.717410969536141201332399340199678006385e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(5.470229339599609375000000000000000000000e1), SC_(5.294396604110062449183833319452449379747e-1), SC_(4.705603395889937550816166680547550620253e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(5.665410232543945312500000000000000000000e1), SC_(5.442899888496431582340068842126963703587e-1), SC_(4.557100111503568417659931157873036296413e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(6.357229232788085937500000000000000000000e1), SC_(6.867982551932145424171171446845070745187e-1), SC_(3.132017448067854575828828553154929254813e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(7.260926055908203125000000000000000000000e1), SC_(8.150647171222219308878015608021594335873e-1), SC_(1.849352828777780691121984391978405664127e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(7.935643005371093750000000000000000000000e1), SC_(9.007936914375933066942137824022033771312e-1), SC_(9.920630856240669330578621759779662286877e-2) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(9.592015075683593750000000000000000000000e1), SC_(9.796162673478140171090671361828038267508e-1), SC_(2.038373265218598289093286381719617324915e-2) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(1.373104858398437500000000000000000000000e2), SC_(9.999233838975136176666663758508405168462e-1), SC_(7.661610248638233333362414915948315379860e-5) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(2.114315643310546875000000000000000000000e2), SC_(9.999999999846254813148731756362244456313e-1), SC_(1.537451868512682436377555436865387217146e-11) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(3.266198730468750000000000000000000000000e2), SC_(9.999999999999999999995081296770202609362e-1), SC_(4.918703229797390638484490072323894232220e-22) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(4.098501281738281250000000000000000000000e2), SC_(9.999999999999999999999999999999799024614e-1), SC_(2.009753862257585737251712126887791245081e-32) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(8.567625999450683593750000000000000000000), SC_(7.809528400287202713482614281697686219505e-14), SC_(9.999999999999219047159971279728651738572e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(2.166324996948242187500000000000000000000e1), SC_(9.502649282951249841689179780918139080860e-8), SC_(9.999999049735071704875015831082021908186e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(4.395189285278320312500000000000000000000e1), SC_(1.466581349889766319694457539910376214141e-3), SC_(9.985334186501102336803055424600896237859e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(6.718534851074218750000000000000000000000e1), SC_(9.245753192556240531064205623956241961847e-2), SC_(9.075424680744375946893579437604375803815e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(8.072123718261718750000000000000000000000e1), SC_(3.183876234174548078936742567087127103717e-1), SC_(6.816123765825451921063257432912872896283e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(9.754388427734375000000000000000000000000e1), SC_(4.992370014975295928158522604351045337902e-1), SC_(5.007629985024704071841477395648954662098e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.046110687255859375000000000000000000000e2), SC_(5.176964989881761766210662273970460054104e-1), SC_(4.823035010118238233789337726029539945896e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.060180816650390625000000000000000000000e2), SC_(5.197464245601009290846317996648898350416e-1), SC_(4.802535754398990709153682003351101649584e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.106336975097656250000000000000000000000e2), SC_(5.195412213722418296325574261061300478021e-1), SC_(4.804587786277581703674425738938699521979e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(1.107986068725585937500000000000000000000e2), SC_(5.215400772674177938228747251751450556512e-1), SC_(4.784599227325822061771252748248549443488e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.224343338012695312500000000000000000000e2), SC_(5.415131980869488174364463241751660764583e-1), SC_(4.584868019130511825635536758248339235417e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.356800537109375000000000000000000000000e2), SC_(7.314594595006114610871169150124572929680e-1), SC_(2.685405404993885389128830849875427070320e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.492658386230468750000000000000000000000e2), SC_(8.780967075031328953906365784156630772471e-1), SC_(1.219032924968671046093634215843369227529e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(1.651037902832031250000000000000000000000e2), SC_(9.557192991134635106539941015912767093641e-1), SC_(4.428070088653648934600589840872329063586e-2) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(2.034700012207031250000000000000000000000e2), SC_(9.972476481057015371077183535594258653137e-1), SC_(2.752351894298462892281646440574134686350e-3) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(2.714289855957031250000000000000000000000e2), SC_(9.999997903086934205025130157670094318314e-1), SC_(2.096913065794974869842329905681685836058e-7) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(4.582266845703125000000000000000000000000e2), SC_(9.999999999999999999960298040706927493119e-1), SC_(3.970195929307250688130996126879386662072e-21) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(6.168921508789062500000000000000000000000e2), SC_(9.999999999999999999999999999999999999087e-1), SC_(9.128392315532929637091687628313407369064e-38) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(7.868297729492187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.322149846593347365080447601949738427284e-57) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.574185085296630859375000000000000000000e1), SC_(7.292965739366899782411583922546845587963e-21), SC_(9.999999999999999999927070342606331002176e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(3.974786758422851562500000000000000000000e1), SC_(1.161939384553544432828196928358536193318e-11), SC_(9.999999999883806061544645556717180307164e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(8.100869750976562500000000000000000000000e1), SC_(5.141396549708590389635413747204232129701e-5), SC_(9.999485860345029140961036458625279576787e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(1.219067077636718750000000000000000000000e2), SC_(4.036488145479633432830166202074931430659e-2), SC_(9.596351185452036656716983379792506856934e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(1.487124786376953125000000000000000000000e2), SC_(2.584518299261610529973334651568653962083e-1), SC_(7.415481700738389470026665348431346037917e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(1.658048095703125000000000000000000000000e2), SC_(4.886945230967673104324092670683767532633e-1), SC_(5.113054769032326895675907329316232467367e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(1.712667236328125000000000000000000000000e2), SC_(5.127139400574618519019776881240412151693e-1), SC_(4.872860599425381480980223118759587848307e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(1.743998260498046875000000000000000000000e2), SC_(5.152925590987274597855389192387472711838e-1), SC_(4.847074409012725402144610807612527288162e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(1.749143524169921875000000000000000000000e2), SC_(5.155439911971029695090017407976664507044e-1), SC_(4.844560088028970304909982592023335492956e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(1.779962310791015625000000000000000000000e2), SC_(5.178988563827036938507494537203826046092e-1), SC_(4.821011436172963061492505462796173953908e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(1.808105773925781250000000000000000000000e2), SC_(5.426283402212447043409728585644225794952e-1), SC_(4.573716597787552956590271414355774205048e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(2.031830291748046875000000000000000000000e2), SC_(7.654244762843846951542590477209729449074e-1), SC_(2.345755237156153048457409522790270550926e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(2.228716278076171875000000000000000000000e2), SC_(9.164997426661461902749894332598414236583e-1), SC_(8.350025733385380972501056674015857634173e-2) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(2.416129150390625000000000000000000000000e2), SC_(9.778373770785726815367221258557450740501e-1), SC_(2.216262292142731846327787414425492594988e-2) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(2.788373107910156250000000000000000000000e2), SC_(9.993062800177515862119596410078074479265e-1), SC_(6.937199822484137880403589921925520735174e-4) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(3.726529235839843750000000000000000000000e2), SC_(9.999999975514477007896307971773436949893e-1), SC_(2.448552299210369202822656305010687601194e-9) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(5.676453247070312500000000000000000000000e2), SC_(9.999999999999999999999997860010281569830e-1), SC_(2.139989718430170241482454793113091170003e-25) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(7.626041259765625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.086590553272924492566938217266426911381e-45) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(9.548096923828125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.641841121035897082560581646670619757585e-68) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(1.932720756530761718750000000000000000000e1), SC_(1.812892978830599002054504628091206184915e-24), SC_(9.999999999999999999999981871070211694010e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(4.902405929565429687500000000000000000000e1), SC_(1.086659630173249111282136712172045518612e-13), SC_(9.999999999998913340369826750888717863288e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(1.003780670166015625000000000000000000000e2), SC_(9.037733960865063734575444457518107998115e-6), SC_(9.999909622660391349362654245555424818920e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(1.514673767089843750000000000000000000000e2), SC_(2.634167773450085920361791202981609234380e-2), SC_(9.736583222654991407963820879701839076562e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(1.866858825683593750000000000000000000000e2), SC_(2.331396191525271945606498310909613312718e-1), SC_(7.668603808474728054393501689090386687282e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(2.068560943603515625000000000000000000000e2), SC_(4.841231116633212145387156823238633508387e-1), SC_(5.158768883366787854612843176761366491613e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(2.092080688476562500000000000000000000000e2), SC_(5.109512126215888928712158729027936224799e-1), SC_(4.890487873784111071287841270972063775201e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.130690155029296875000000000000000000000e2), SC_(5.138064939349578893399518560665422645392e-1), SC_(4.861935060650421106600481439334577354608e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(2.163364257812500000000000000000000000000e2), SC_(5.140028019542381759284730022772281515710e-1), SC_(4.859971980457618240715269977227718484290e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(2.179214782714843750000000000000000000000e2), SC_(5.166859094983983211093723261625804121509e-1), SC_(4.833140905016016788906276738374195878491e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(2.199494628906250000000000000000000000000e2), SC_(5.438223348045090869781390225409451894884e-1), SC_(4.561776651954909130218609774590548105116e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.399857482910156250000000000000000000000e2), SC_(7.812300692568605186873539931436716512111e-1), SC_(2.187699307431394813126460068563283487889e-1) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(2.630977172851562500000000000000000000000e2), SC_(9.315644370913994341149404226342223970190e-1), SC_(6.843556290860056588505957736577760298095e-2) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(2.857521667480468750000000000000000000000e2), SC_(9.849821401602975474798248315634072983154e-1), SC_(1.501785983970245252017516843659270168458e-2) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(3.300658874511718750000000000000000000000e2), SC_(9.997251333857847767022899432242924398118e-1), SC_(2.748666142152232977100567757075601882264e-4) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(4.407778625488281250000000000000000000000e2), SC_(9.999999998763207307161892474296295946308e-1), SC_(1.236792692838107525703704053691897112171e-10) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(6.674769287109375000000000000000000000000e2), SC_(9.999999999999999999999999999726793349758e-1), SC_(2.732066502416234500714517971601231580014e-29) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(8.993865356445312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.933495182830549060295238151699184361284e-53) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(1.125420410156250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.671885948268207140044109906359341500984e-80) }}, 
      {{ SC_(2.627037620544433593750000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.255626487731933593750000000000000000000e1), SC_(9.902104378127656037233374552739057867335e-28), SC_(9.999999999999999999999999990097895621872e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(7.229155540466308593750000000000000000000), SC_(1.876633931015677559701451890893615443882e-5), SC_(9.999812336606898432244029854810910638456e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(1.716324615478515625000000000000000000000e1), SC_(1.185993740421549179787815622573032089305e-2), SC_(9.881400625957845082021218437742696791070e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(2.613685607910156250000000000000000000000e1), SC_(1.694334475207283722719978283782895800484e-1), SC_(8.305665524792716277280021716217104199516e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(3.159203338623046875000000000000000000000e1), SC_(3.787082318022105306148573178857203335827e-1), SC_(6.212917681977894693851426821142796664173e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(3.682226181030273437500000000000000000000e1), SC_(5.177898643324157550403031275679404328431e-1), SC_(4.822101356675842449596968724320595671569e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(4.733889389038085937500000000000000000000e1), SC_(5.281428658767564092564961326564078988499e-1), SC_(4.718571341232435907435038673435921011501e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(4.746800231933593750000000000000000000000e1), SC_(5.297443695080577135693899563636382149554e-1), SC_(4.702556304919422864306100436363617850446e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(4.993726730346679687500000000000000000000e1), SC_(5.291890445930621035162955819702194612292e-1), SC_(4.708109554069378964837044180297805387708e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(5.050328445434570312500000000000000000000e1), SC_(5.305330597143102377874922644851578217672e-1), SC_(4.694669402856897622125077355148421782328e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(5.352643966674804687500000000000000000000e1), SC_(5.449321029164408817756424677037243032244e-1), SC_(4.550678970835591182243575322962756967756e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(5.869301986694335937500000000000000000000e1), SC_(6.851948011936819387402208810330329395564e-1), SC_(3.148051988063180612597791189669670604436e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(6.606639862060546875000000000000000000000e1), SC_(8.105423097706992073743472135565654773537e-1), SC_(1.894576902293007926256527864434345226463e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(7.323834991455078125000000000000000000000e1), SC_(8.969293313879487574642096505994694344144e-1), SC_(1.030706686120512425357903494005305655856e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(8.667408752441406250000000000000000000000e1), SC_(9.767404578369664204738069669998660989519e-1), SC_(2.325954216303357952619303300013390104806e-2) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(1.189650878906250000000000000000000000000e2), SC_(9.998469434438143874300710362186386737128e-1), SC_(1.530565561856125699289637813613262872021e-4) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(1.865917663574218750000000000000000000000e2), SC_(9.999999998937808977603895224553439260418e-1), SC_(1.062191022396104775446560739581687359467e-10) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(2.509318237304687500000000000000000000000e2), SC_(9.999999999999999963699374540589370906349e-1), SC_(3.630062545941062909365051889213951638018e-18) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(3.281816101074218750000000000000000000000e2), SC_(9.999999999999999999999999974778821479464e-1), SC_(2.522117852053558712464999005386659841907e-27) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(7.034478664398193359375000000000000000000), SC_(9.750286830191128782536481291570282810453e-13), SC_(9.999999999990249713169808871217463518708e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(1.804168319702148437500000000000000000000e1), SC_(4.111677830850868116366171464819844448388e-7), SC_(9.999995888322169149131883633828535180156e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(4.167226028442382812500000000000000000000e1), SC_(1.676252767693557024441465813469009200439e-3), SC_(9.983237472323064429755585341865309907996e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(6.274467468261718750000000000000000000000e1), SC_(9.763608428826338969726591321361042165547e-2), SC_(9.023639157117366103027340867863895783445e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(7.862923431396484375000000000000000000000e1), SC_(3.195793733429435352306749678438359343419e-1), SC_(6.804206266570564647693250321561640656581e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(8.745912170410156250000000000000000000000e1), SC_(5.012828713069137219090211897096442071735e-1), SC_(4.987171286930862780909788102903557928265e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(8.950373840332031250000000000000000000000e1), SC_(5.195095012630494537412764498971276617281e-1), SC_(4.804904987369505462587235501028723382719e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(9.127001190185546875000000000000000000000e1), SC_(5.213524032992570542913305322044732234088e-1), SC_(4.786475967007429457086694677955267765912e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(9.138896179199218750000000000000000000000e1), SC_(5.215455967531493423501822932298578190658e-1), SC_(4.784544032468506576498177067701421809342e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.003189392089843750000000000000000000000e2), SC_(5.224903846839075460304140547659031101956e-1), SC_(4.775096153160924539695859452340968898044e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.074693756103515625000000000000000000000e2), SC_(5.416307571584065131325348817065435639230e-1), SC_(4.583692428415934868674651182934564360770e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.184783935546875000000000000000000000000e2), SC_(7.223749220564437858968530166812674733623e-1), SC_(2.776250779435562141031469833187325266377e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.347746276855468750000000000000000000000e2), SC_(8.692518005157869374654665640523344379414e-1), SC_(1.307481994842130625345334359476655620586e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(1.460906829833984375000000000000000000000e2), SC_(9.478515038875889682332394039996912352065e-1), SC_(5.214849611241103176676059600030876479348e-2) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.843674926757812500000000000000000000000e2), SC_(9.961848646235269697593812982791757830170e-1), SC_(3.815135376473030240618701720824216983013e-3) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(2.500700988769531250000000000000000000000e2), SC_(9.999995009338332669976112426089602196003e-1), SC_(4.990661667330023887573910397803997311632e-7) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(3.782332153320312500000000000000000000000e2), SC_(9.999999999999999956874894000009676227158e-1), SC_(4.312510599999032377284186244219495891315e-18) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(5.147698974609375000000000000000000000000e2), SC_(9.999999999999999999999999999999764473399e-1), SC_(2.355266009182904205279233895482939100880e-32) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(6.866811523437500000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.603086739201292486445287704446956362229e-51) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.374040412902832031250000000000000000000e1), SC_(4.220242270765552441757712963588629878700e-19), SC_(9.999999999999999995779757729234447558242e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(3.860794448852539062500000000000000000000e1), SC_(1.673270113919030832611422899953595794536e-11), SC_(9.999999999832672988608096916738857710005e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(7.795629882812500000000000000000000000000e1), SC_(6.385411534149447804281803898518710595165e-5), SC_(9.999361458846585055219571819610148128940e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.192916336059570312500000000000000000000e2), SC_(4.143981535466014512352310564638223366138e-2), SC_(9.585601846453398548764768943536177663386e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.431972503662109375000000000000000000000e2), SC_(2.618589776382208035846197959262317212976e-1), SC_(7.381410223617791964153802040737682787024e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(1.590742187500000000000000000000000000000e2), SC_(4.894700860717230273476499155988294597006e-1), SC_(5.105299139282769726523500844011705402994e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(1.635432434082031250000000000000000000000e2), SC_(5.131431362786220043441366981280260891274e-1), SC_(4.868568637213779956558633018719739108726e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(1.642318420410156250000000000000000000000e2), SC_(5.157811310482198157607590177393667399556e-1), SC_(4.842188689517801842392409822606332600444e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(1.669423522949218750000000000000000000000e2), SC_(5.159187971909615609444136490390814224662e-1), SC_(4.840812028090384390555863509609185775338e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(1.693383331298828125000000000000000000000e2), SC_(5.182454506292580090632823220317547104040e-1), SC_(4.817545493707419909367176779682452895960e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(1.748589935302734375000000000000000000000e2), SC_(5.425490837972952828628397281085420292789e-1), SC_(4.574509162027047171371602718914579707211e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(1.936983337402343750000000000000000000000e2), SC_(7.616035894238038757465795955963196592474e-1), SC_(2.383964105761961242534204044036803407526e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(2.119037170410156250000000000000000000000e2), SC_(9.122864139270828925412944270784007581169e-1), SC_(8.771358607291710745870557292159924188314e-2) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(2.333603515625000000000000000000000000000e2), SC_(9.764027534664663198743099591434309535227e-1), SC_(2.359724653353368012569004085656904647728e-2) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(2.710648803710937500000000000000000000000e2), SC_(9.992198569377593315232438807934788574161e-1), SC_(7.801430622406684767561192065211425838828e-4) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(3.728027954101562500000000000000000000000e2), SC_(9.999999977271058183668840513744348032943e-1), SC_(2.272894181633115948625565196705678831008e-9) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(5.622477416992187500000000000000000000000e2), SC_(9.999999999999999999999997091617343722111e-1), SC_(2.908382656277889440140888836089307897267e-25) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(7.501826171875000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.830191537910562612268409024684319536822e-45) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(9.379055175781250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.439039586754926663658409785546924139060e-67) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(1.880160331726074218750000000000000000000e1), SC_(3.733565327116871167208105901465346254739e-24), SC_(9.999999999999999999999962664346728831288e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(4.772616577148437500000000000000000000000e1), SC_(1.713129730577344037004394238937632181221e-13), SC_(9.999999999998286870269422655962995605761e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(9.617029571533203125000000000000000000000e1), SC_(1.246200921207264466535811061019626728362e-5), SC_(9.999875379907879273553346418893898037327e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(1.444886322021484375000000000000000000000e2), SC_(2.877538259004737568141033662906867893852e-2), SC_(9.712246174099526243185896633709313210615e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(1.754654693603515625000000000000000000000e2), SC_(2.396290160464116035691342940459626147574e-1), SC_(7.603709839535883964308657059540373852426e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(1.958079376220703125000000000000000000000e2), SC_(4.852141460046351090663782421864580012920e-1), SC_(5.147858539953648909336217578135419987080e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(2.022432556152343750000000000000000000000e2), SC_(5.112426665854271269035331843827574356152e-1), SC_(4.887573334145728730964668156172425643848e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(2.036460571289062500000000000000000000000e2), SC_(5.141371802317714954662624729941492970056e-1), SC_(4.858628197682285045337375270058507029944e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(2.091392364501953125000000000000000000000e2), SC_(5.142453370712724161047686789558988721919e-1), SC_(4.857546629287275838952313210441011278081e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(2.108457489013671875000000000000000000000e2), SC_(5.168857104413307276956159161563676303445e-1), SC_(4.831142895586692723043840838436323696555e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(2.132181091308593750000000000000000000000e2), SC_(5.436758405329523594951813242055225600384e-1), SC_(4.563241594670476405048186757944774399616e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.362344360351562500000000000000000000000e2), SC_(7.801442361657512923678392854322630496527e-1), SC_(2.198557638342487076321607145677369503473e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(2.616052246093750000000000000000000000000e2), SC_(9.314396711276951359161860049490842387823e-1), SC_(6.856032887230486408381399505091576121769e-2) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(2.852113037109375000000000000000000000000e2), SC_(9.850639748260030361376784440776895363087e-1), SC_(1.493602517399696386232155592231046369125e-2) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(3.291919555664062500000000000000000000000e2), SC_(9.997270689947423451015375380447126275926e-1), SC_(2.729310052576548984624619552873724074446e-4) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(4.397168273925781250000000000000000000000e2), SC_(9.999999998787265823945332382320039204416e-1), SC_(1.212734176054667617679960795584463162888e-10) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(6.628129272460937500000000000000000000000e2), SC_(9.999999999999999999999999999651037260212e-1), SC_(3.489627397878550622841243581809212504739e-29) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(8.859956665039062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.575696830099811389085703677985618016352e-52) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(1.108667480468750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.630904330254495387376119200327470296708e-79) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.220784950256347656250000000000000000000e1), SC_(1.378861636398863714276370233819239396516e-27), SC_(9.999999999999999999999999986211383636011e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(5.604546737670898437500000000000000000000e1), SC_(2.597858676041513701652440257452754111086e-15), SC_(9.999999999999974021413239584862983475597e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(1.132680969238281250000000000000000000000e2), SC_(2.706795633815785344742182048637274813414e-6), SC_(9.999972932043661842146552578179513627252e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(1.700802307128906250000000000000000000000e2), SC_(2.001801576554867787147982959684942899382e-2), SC_(9.799819842344513221285201704031505710062e-1) }}, 
      {{ SC_(2.795992469787597656250000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.045269775390625000000000000000000000000e2), SC_(2.221166534842367768440687527246518476883e-1), SC_(7.778833465157632231559312472753481523117e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.989015960693359375000000000000000000000e1), SC_(5.194997592913189816526036930080035478780e-1), SC_(4.805002407086810183473963069919964521220e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(3.556634902954101562500000000000000000000e1), SC_(5.319449011002781897562469452077848049103e-1), SC_(4.680550988997218102437530547922151950897e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(3.612459945678710937500000000000000000000e1), SC_(5.333231217600885739147763289264645775531e-1), SC_(4.666768782399114260852236710735354224469e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(3.638135528564453125000000000000000000000e1), SC_(5.333974391861699209821555154207235741207e-1), SC_(4.666025608138300790178444845792764258793e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(3.850812911987304687500000000000000000000e1), SC_(5.341244189447486326076102238799447830170e-1), SC_(4.658755810552513673923897761200552169830e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(4.914835357666015625000000000000000000000e1), SC_(5.458199058718306646303985572651323592335e-1), SC_(4.541800941281693353696014427348676407665e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(5.361780929565429687500000000000000000000e1), SC_(6.834805784200447797204295810842476676802e-1), SC_(3.165194215799552202795704189157523323198e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(6.144928359985351562500000000000000000000e1), SC_(8.077831285083335919916922361260940376749e-1), SC_(1.922168714916664080083077638739059623251e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(6.724677276611328125000000000000000000000e1), SC_(8.929491107912315213706206266744795570512e-1), SC_(1.070508892087684786293793733255204429488e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(8.140789794921875000000000000000000000000e1), SC_(9.752374269470447906563697095835239424661e-1), SC_(2.476257305295520934363029041647605753395e-2) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(1.092654876708984375000000000000000000000e2), SC_(9.997884756560312217337089885888437016442e-1), SC_(2.115243439687782662910114111562983558325e-4) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(1.689923553466796875000000000000000000000e2), SC_(9.999999996077435524113228629039259017986e-1), SC_(3.922564475886771370960740982013934673538e-10) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(2.304505920410156250000000000000000000000e2), SC_(9.999999999999999693458139333514238576691e-1), SC_(3.065418606664857614233086334378418570458e-17) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(2.952908935546875000000000000000000000000e2), SC_(9.999999999999999999999997919967207634223e-1), SC_(2.080032792365777384490223137260581404146e-25) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(6.075799942016601562500000000000000000000), SC_(3.432859776131613619837012938135891247937e-12), SC_(9.999999999965671402238683863801629870619e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(1.586817932128906250000000000000000000000e1), SC_(8.811701324843491841455515264040459419198e-7), SC_(9.999991188298675156508158544484735959541e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(3.200420761108398437500000000000000000000e1), SC_(3.686240592015203712995472265697842823544e-3), SC_(9.963137594079847962870045277343021571765e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(5.018383026123046875000000000000000000000e1), SC_(1.174466418857299378003619562407103662325e-1), SC_(8.825533581142700621996380437592896337675e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(6.445822143554687500000000000000000000000e1), SC_(3.348183905905068155091613335387573146548e-1), SC_(6.651816094094931844908386664612426853452e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(7.270777130126953125000000000000000000000e1), SC_(5.048067795564375726981437882837289688921e-1), SC_(4.951932204435624273018562117162710311079e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(8.453536224365234375000000000000000000000e1), SC_(5.202063498550914986961815648364803313797e-1), SC_(4.797936501449085013038184351635196686203e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(8.493502807617187500000000000000000000000e1), SC_(5.221738561170636840211489106825145260131e-1), SC_(4.778261438829363159788510893174854739869e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(8.865013122558593750000000000000000000000e1), SC_(5.218954678418186593006012329667860498537e-1), SC_(4.781045321581813406993987670332139501463e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(8.970762634277343750000000000000000000000e1), SC_(5.236240601813464001146832147364584692096e-1), SC_(4.763759398186535998853167852635415307904e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(9.177747344970703125000000000000000000000e1), SC_(5.419987147150138613607318894352456142246e-1), SC_(4.580012852849861386392681105647543857754e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(1.018000183105468750000000000000000000000e2), SC_(7.130715947898707623662520124117643400793e-1), SC_(2.869284052101292376337479875882356599207e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(1.111863327026367187500000000000000000000e2), SC_(8.524577510546902171581038929408632816738e-1), SC_(1.475422489453097828418961070591367183262e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.319424285888671875000000000000000000000e2), SC_(9.411091359525718359984173384816667630129e-1), SC_(5.889086404742816400158266151833323698709e-2) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.615211791992187500000000000000000000000e2), SC_(9.942984786358796838894965839027603086432e-1), SC_(5.701521364120316110503416097239691356803e-3) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(2.179661712646484375000000000000000000000e2), SC_(9.999980682124484606200407742478844119846e-1), SC_(1.931787551539379959225752115588015438250e-6) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(3.407629089355468750000000000000000000000e2), SC_(9.999999999999998936158109886402278742197e-1), SC_(1.063841890113597721257802849535382502878e-16) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(4.546116638183593750000000000000000000000e2), SC_(9.999999999999999999999999999665381089380e-1), SC_(3.346189106196598819109569722884428370620e-29) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(6.209356079101562500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.060886463294138456269683870133666171997e-46) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.263105106353759765625000000000000000000e1), SC_(3.414813297006626667916916362633713753275e-18), SC_(9.999999999999999965851867029933733320831e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(3.183829879760742187500000000000000000000e1), SC_(4.174209016176762337268720460033413542141e-10), SC_(9.999999995825790983823237662731279539967e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(6.498396301269531250000000000000000000000e1), SC_(1.959905637322366760764892172498616950081e-4), SC_(9.998040094362677633239235107827501383050e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.039587554931640625000000000000000000000e2), SC_(5.147235004109416380298505486044188981442e-2), SC_(9.485276499589058361970149451395581101856e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.248115539550781250000000000000000000000e2), SC_(2.756140542309928539467310577833128963153e-1), SC_(7.243859457690071460532689422166871036847e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.541501770019531250000000000000000000000e2), SC_(4.900535446250763317696653619961431884742e-1), SC_(5.099464553749236682303346380038568115258e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(1.570308685302734375000000000000000000000e2), SC_(5.135275147946166906447029266250852008437e-1), SC_(4.864724852053833093552970733749147991563e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.603309631347656250000000000000000000000e2), SC_(5.159851625655630940457794104587126562053e-1), SC_(4.840148374344369059542205895412873437947e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.603995513916015625000000000000000000000e2), SC_(5.162468264211388095004936228098590930795e-1), SC_(4.837531735788611904995063771901409069205e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(1.621184387207031250000000000000000000000e2), SC_(5.185571328838595472198603010470253249447e-1), SC_(4.814428671161404527801396989529746750553e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(1.666322326660156250000000000000000000000e2), SC_(5.424055819618275259500384381109522274165e-1), SC_(4.575944180381724740499615618890477725835e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(1.820580291748046875000000000000000000000e2), SC_(7.565415273136834652965515582109338252511e-1), SC_(2.434584726863165347034484417890661747489e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(2.018413391113281250000000000000000000000e2), SC_(9.081338404525205452761026674569733418085e-1), SC_(9.186615954747945472389733254302665819145e-2) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(2.215779876708984375000000000000000000000e2), SC_(9.740023633817632025014305649211522852507e-1), SC_(2.599763661823679749856943507884771474925e-2) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(2.616047363281250000000000000000000000000e2), SC_(9.990902832849738315015003444427793365156e-1), SC_(9.097167150261684984996555572206634844082e-4) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(3.547296752929687500000000000000000000000e2), SC_(9.999999952335181717029905828472179522673e-1), SC_(4.766481828297009417152782047732666332776e-9) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(5.335856323242187500000000000000000000000e2), SC_(9.999999999999999999999966745183809876079e-1), SC_(3.325481619012392080826835172394265095510e-24) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(7.231336669921875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(9.027692990752186436758262525811964217983e-44) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(9.099268798828125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.547018008581033164492247828453752868848e-66) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(1.876768493652343750000000000000000000000e1), SC_(2.760563792661305480209067885207330284931e-24), SC_(9.999999999999999999999972394362073386945e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(4.717284011840820312500000000000000000000e1), SC_(1.943674650655538969982297493876813715721e-13), SC_(9.999999999998056325349344461030017702506e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(9.441055297851562500000000000000000000000e1), SC_(1.398126102866038307665248007429465348298e-5), SC_(9.999860187389713396169233475199257053465e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(1.416424102783203125000000000000000000000e2), SC_(2.971296179202454853644137737696373159047e-2), SC_(9.702870382079754514635586226230362684095e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(1.703623199462890625000000000000000000000e2), SC_(2.425023514503756721344578606413279411412e-1), SC_(7.574976485496243278655421393586720588588e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(1.902583160400390625000000000000000000000e2), SC_(4.857659862375764686765051756864795841275e-1), SC_(5.142340137624235313234948243135204158725e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(1.934224243164062500000000000000000000000e2), SC_(5.116308161875224283760034469666914231532e-1), SC_(4.883691838124775716239965530333085768468e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(1.939269561767578125000000000000000000000e2), SC_(5.145013151756255725360865302772264559206e-1), SC_(4.854986848243744274639134697227735440794e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(1.962567138671875000000000000000000000000e2), SC_(5.147036875061172745106586208873524279615e-1), SC_(4.852963124938827254893413791126475720385e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(1.992603149414062500000000000000000000000e2), SC_(5.172261834673244192838416414676397088022e-1), SC_(4.827738165326755807161583585323602911978e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(2.057583618164062500000000000000000000000e2), SC_(5.434966090805407270143705372758878059537e-1), SC_(4.565033909194592729856294627241121940463e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(2.254136657714843750000000000000000000000e2), SC_(7.759947384146940035858243137603542274138e-1), SC_(2.240052615853059964141756862396457725862e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(2.524725341796875000000000000000000000000e2), SC_(9.286039042434487070460180048667355993035e-1), SC_(7.139609575655129295398199513326440069652e-2) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(2.754837036132812500000000000000000000000e2), SC_(9.838629012417190705685709637369741276924e-1), SC_(1.613709875828092943142903626302587230759e-2) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(3.185737304687500000000000000000000000000e2), SC_(9.996752902691822585102626703123951277916e-1), SC_(3.247097308177414897373296876048722084446e-4) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(4.320680541992187500000000000000000000000e2), SC_(9.999999998388401663358913596303904009194e-1), SC_(1.611598336641086403696095990805778915000e-10) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(6.578394165039062500000000000000000000000e2), SC_(9.999999999999999999999999999522258995251e-1), SC_(4.777410047490013449233288747206941097743e-29) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(8.826751098632812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.916309709272735536488146742452166863499e-52) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(1.103683837890625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.044123989577021831019665356733359101644e-78) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.211338615417480468750000000000000000000e1), SC_(1.190054272418103155974690621861854384727e-27), SC_(9.999999999999999999999999988099457275819e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(5.555327224731445312500000000000000000000e1), SC_(2.872722940206569641532100243507339639663e-15), SC_(9.999999999999971272770597934303584678998e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(1.113871841430664062500000000000000000000e2), SC_(3.071951105530415132158129500126008690911e-6), SC_(9.999969280488944695848678418704998739913e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(1.672567138671875000000000000000000000000e2), SC_(2.065566395144984899636850019858482175923e-2), SC_(9.793443360485501510036314998014151782408e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.010185394287109375000000000000000000000e2), SC_(2.237515103700514248000843581033444779068e-1), SC_(7.762484896299485751999156418966555220932e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(2.232027435302734375000000000000000000000e2), SC_(4.824154822517567614346311144797603778845e-1), SC_(5.175845177482432385653688855202396221155e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(2.275838317871093750000000000000000000000e2), SC_(5.102483036496506503226947667435261960769e-1), SC_(4.897516963503493496773052332564738039231e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(2.280490875244140625000000000000000000000e2), SC_(5.133496364292376174009502274122974296651e-1), SC_(4.866503635707623825990497725877025703349e-1) }}, 
      {{ SC_(2.923538208007812500000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.285505065917968750000000000000000000000e2), SC_(5.136466073528654284094086431155348172528e-1), SC_(4.863533926471345715905913568844651827472e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.335502243041992187500000000000000000000e1), SC_(5.346261332302501980736979598275554162371e-1), SC_(4.653738667697498019263020401724445837629e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(3.911888885498046875000000000000000000000e1), SC_(5.480980659909809118819464476874123503103e-1), SC_(4.519019340090190881180535523125876496897e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(4.317964553833007812500000000000000000000e1), SC_(6.826306410009410343032050773044969622869e-1), SC_(3.173693589990589656967949226955030377131e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(4.740880966186523437500000000000000000000e1), SC_(8.018409305874028150492780541730654866655e-1), SC_(1.981590694125971849507219458269345133345e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(5.407906341552734375000000000000000000000e1), SC_(8.870237156594488896878456592433106060543e-1), SC_(1.129762843405511103121543407566893939457e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(7.768704223632812500000000000000000000000e1), SC_(9.757434216297004986518131851892079553873e-1), SC_(2.425657837029950134818681481079204461274e-2) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(1.037461700439453125000000000000000000000e2), SC_(9.997889984211918429215253000530216647957e-1), SC_(2.110015788081570784746999469783352043023e-4) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(1.630120697021484375000000000000000000000e2), SC_(9.999999996250973973410208414977134581651e-1), SC_(3.749026026589791585022865418348700233046e-10) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(2.194316406250000000000000000000000000000e2), SC_(9.999999999999999536038439424526524566552e-1), SC_(4.639615605754734754334480488269626928328e-17) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(2.870077819824218750000000000000000000000e2), SC_(9.999999999999999999999997871951256661881e-1), SC_(2.128048743338118825876682147863237716058e-25) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(5.776237010955810546875000000000000000000), SC_(1.234824311708574803878182602502815380768e-12), SC_(9.999999999987651756882914251961218173975e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(1.486510181427001953125000000000000000000e1), SC_(7.342112471983936265402643991007950254553e-7), SC_(9.999992657887528016063734597356008992050e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(3.037113571166992187500000000000000000000e1), SC_(3.562497773293500319124802227315978709325e-3), SC_(9.964375022267064996808751977726840212907e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(4.664085006713867187500000000000000000000e1), SC_(1.195538178562043322452377192278055098976e-1), SC_(8.804461821437956677547622807721944901024e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(5.749885940551757812500000000000000000000e1), SC_(3.404129456612665732407063162693145899216e-1), SC_(6.595870543387334267592936837306854100784e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(6.593631744384765625000000000000000000000e1), SC_(5.064361332064192196946669902935475551229e-1), SC_(4.935638667935807803053330097064524448771e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(6.707089996337890625000000000000000000000e1), SC_(5.231645434167252424726534674206986751199e-1), SC_(4.768354565832747575273465325793013248801e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(7.004139709472656250000000000000000000000e1), SC_(5.245025433930742530256109566688161645450e-1), SC_(4.754974566069257469743890433311838354550e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(7.475734710693359375000000000000000000000e1), SC_(5.238992025451400299422983270951603887400e-1), SC_(4.761007974548599700577016729048396112600e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(7.664839172363281250000000000000000000000e1), SC_(5.253718696293442551765946767951396692582e-1), SC_(4.746281303706557448234053232048603307418e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(8.862709808349609375000000000000000000000e1), SC_(5.423498787668737532742432805893117419585e-1), SC_(4.576501212331262467257567194106882580415e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(9.687111663818359375000000000000000000000e1), SC_(7.118856357925233354085720873658752566723e-1), SC_(2.881143642074766645914279126341247433277e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(1.101250686645507812500000000000000000000e2), SC_(8.538546339733538161189409726807851118656e-1), SC_(1.461453660266461838810590273192148881344e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(1.205719146728515625000000000000000000000e2), SC_(9.362557317957951552476941448371226769308e-1), SC_(6.374426820420484475230585516287732306922e-2) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(1.409976196289062500000000000000000000000e2), SC_(9.921204493235597173376409370489707802303e-1), SC_(7.879550676440282662359062951029219769671e-3) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(1.913501892089843750000000000000000000000e2), SC_(9.999946864296167705889930902286175048132e-1), SC_(5.313570383229411006909771382495186767557e-6) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(2.873546752929687500000000000000000000000e2), SC_(9.999999999999916306506466533030974400176e-1), SC_(8.369349353346696902559982359702105553741e-15) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(4.184952087402343750000000000000000000000e2), SC_(9.999999999999999999999999984177045142708e-1), SC_(1.582295485729248842298664046427139867829e-27) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(5.540520629882812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.161687185404714678045454196948068057430e-42) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.121127128601074218750000000000000000000e1), SC_(2.651368879761130310366403044367541953765e-17), SC_(9.999999999999999734863112023886968963360e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(2.917931556701660156250000000000000000000e1), SC_(1.007126251268226377148578114567182370061e-9), SC_(9.999999989928737487317736228514218854328e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(5.839126968383789062500000000000000000000e1), SC_(3.140151047822411167454567078349481222240e-4), SC_(9.996859848952177588832545432921650518778e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(9.548755645751953125000000000000000000000e1), SC_(5.698009622749070524123315968508915001647e-2), SC_(9.430199037725092947587668403149108499835e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.164961090087890625000000000000000000000e2), SC_(2.810528368015605530797182671307596518514e-1), SC_(7.189471631984394469202817328692403481486e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.291779937744140625000000000000000000000e2), SC_(4.934318727070447803251561210249847192255e-1), SC_(5.065681272929552196748438789750152807745e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(1.329644470214843750000000000000000000000e2), SC_(5.151643691416033352635783646017080851750e-1), SC_(4.848356308583966647364216353982919148250e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.417413024902343750000000000000000000000e2), SC_(5.170526967650396550245381407272726847556e-1), SC_(4.829473032349603449754618592727273152444e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.418233032226562500000000000000000000000e2), SC_(5.173002672152787291543276844684029101547e-1), SC_(4.826997327847212708456723155315970898453e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.589956970214843750000000000000000000000e2), SC_(5.187283412345212683158290081987589764905e-1), SC_(4.812716587654787316841709918012410235095e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(1.619208526611328125000000000000000000000e2), SC_(5.424577195744090830104865115414336950016e-1), SC_(4.575422804255909169895134884585663049984e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.798066558837890625000000000000000000000e2), SC_(7.565305196470007572278038667738983589785e-1), SC_(2.434694803529992427721961332261016410215e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.962157745361328125000000000000000000000e2), SC_(9.065528798211256892675364874503542009929e-1), SC_(9.344712017887431073246351254964579900713e-2) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(2.146119232177734375000000000000000000000e2), SC_(9.729022456793148447578205509509512368592e-1), SC_(2.709775432068515524217944904904876314084e-2) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(2.521680450439453125000000000000000000000e2), SC_(9.989682998698602192897540558865912859850e-1), SC_(1.031700130139780710245944113408714014996e-3) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(3.372738342285156250000000000000000000000e2), SC_(9.999999910084641166129482544033484907241e-1), SC_(8.991535883387051745596651509275883435014e-9) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(5.139921875000000000000000000000000000000e2), SC_(9.999999999999999999999862869897609846508e-1), SC_(1.371301023901534918406189838079062129757e-23) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(6.942969360351562500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.892531167644262871562189146406863954375e-42) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(8.876639404296875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.030414307995925267990707351526253830557e-64) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(1.804944610595703125000000000000000000000e1), SC_(5.545834779460199526374752710087594541727e-24), SC_(9.999999999999999999999944541652205398005e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(4.524787521362304687500000000000000000000e1), SC_(3.485595723042695240145621912372839976976e-13), SC_(9.999999999996514404276957304759854378088e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(9.195652008056640625000000000000000000000e1), SC_(1.565709887096675083888721928488089141330e-5), SC_(9.999843429011290332491611127807151191086e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(1.388362579345703125000000000000000000000e2), SC_(3.026618536600738762760596695896275628771e-2), SC_(9.697338146339926123723940330410372437123e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(1.717258148193359375000000000000000000000e2), SC_(2.405617930886190706551222275908380772139e-1), SC_(7.594382069113809293448777724091619227861e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(1.899027709960937500000000000000000000000e2), SC_(4.856924469223366240643993131508403178738e-1), SC_(5.143075530776633759356006868491596821262e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(1.917587738037109375000000000000000000000e2), SC_(5.117101115702110396145907152598247796071e-1), SC_(4.882898884297889603854092847401752203929e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(1.919861755371093750000000000000000000000e2), SC_(5.145924957649073764606560140000177777282e-1), SC_(4.854075042350926235393439859999822222718e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(1.924403381347656250000000000000000000000e2), SC_(5.148641500606852222976223917443207876464e-1), SC_(4.851358499393147777023776082556792123536e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(1.955050506591796875000000000000000000000e2), SC_(5.173691427549815667464042782172408992990e-1), SC_(4.826308572450184332535957217827591007010e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(1.987131195068359375000000000000000000000e2), SC_(5.434222279011163312705778269385683872220e-1), SC_(4.565777720988836687294221730614316127780e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(2.167622375488281250000000000000000000000e2), SC_(7.732145623335463981563054581812223113010e-1), SC_(2.267854376664536018436945418187776886990e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(2.392400665283203125000000000000000000000e2), SC_(9.246030347373267016821147970015730171180e-1), SC_(7.539696526267329831788520299842698288202e-2) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(2.628481140136718750000000000000000000000e2), SC_(9.823201079051770455614140946054507964476e-1), SC_(1.767989209482295443858590539454920355237e-2) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(3.102761535644531250000000000000000000000e2), SC_(9.996389795893249201920298899476353312407e-1), SC_(3.610204106750798079701100523646687592799e-4) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(4.161022644042968750000000000000000000000e2), SC_(9.999999997141696241630700430670597964831e-1), SC_(2.858303758369299569329402035169240342668e-10) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(6.405701904296875000000000000000000000000e2), SC_(9.999999999999999999999999998380662326249e-1), SC_(1.619337673751096657317898372164441311682e-28) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(8.601607055664062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.858339736195843835002073420140899457833e-51) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(1.077560546875000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.635425363833560776253862494016824246823e-77) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.191636466979980468750000000000000000000e1), SC_(7.523495127124981046743132260086197737585e-28), SC_(9.999999999999999999999999992476504872875e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(5.560235595703125000000000000000000000000e1), SC_(1.943111995524082496449217069090298900599e-15), SC_(9.999999999999980568880044759175035507829e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(1.118992004394531250000000000000000000000e2), SC_(2.650384335042753940247380619634589271428e-6), SC_(9.999973496156649572460597526193803654107e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(1.678997802734375000000000000000000000000e2), SC_(2.005006770738865892946366647604671202300e-2), SC_(9.799499322926113410705363335239532879770e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.018371276855468750000000000000000000000e2), SC_(2.223691482674558298568054385817319041624e-1), SC_(7.776308517325441701431945614182680958376e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(2.230892944335937500000000000000000000000e2), SC_(4.823235747337502932001043843957232646105e-1), SC_(5.176764252662497067998956156042767353895e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(2.256780853271484375000000000000000000000e2), SC_(5.103196542782730448525617475827127891004e-1), SC_(4.896803457217269551474382524172872108996e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(2.261385650634765625000000000000000000000e2), SC_(5.134203362454828229082947924760670808147e-1), SC_(4.865796637545171770917052075239329191853e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.265062255859375000000000000000000000000e2), SC_(5.137210557040320815185023303873917032935e-1), SC_(4.862789442959679184814976696126082967065e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(2.288155364990234375000000000000000000000e2), SC_(5.164691536804952034663165464043430190086e-1), SC_(4.835308463195047965336834535956569809914e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(2.332506866455078125000000000000000000000e2), SC_(5.445073443298298183626385021830310623191e-1), SC_(4.554926556701701816373614978169689376809e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(2.542965850830078125000000000000000000000e2), SC_(7.884835013807152692344324969702059356178e-1), SC_(2.115164986192847307655675030297940643822e-1) }}, 
      {{ SC_(3.236500549316406250000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.779887390136718750000000000000000000000e2), SC_(9.375858011026448760207307613499442947047e-1), SC_(6.241419889735512397926923865005570529531e-2) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(5.127811431884765625000000000000000000000e1), SC_(8.994146527043670062806469008689900421341e-1), SC_(1.005853472956329937193530991310099578659e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(6.728186798095703125000000000000000000000e1), SC_(9.773620630652627019744279957514551934893e-1), SC_(2.263793693473729802557200424854480651071e-2) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(9.075445556640625000000000000000000000000e1), SC_(9.998150703488529814837167703072717674090e-1), SC_(1.849296511470185162832296927282325909516e-4) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(1.368910522460937500000000000000000000000e2), SC_(9.999999993880501360918553821562566079534e-1), SC_(6.119498639081446178437433920466181922438e-10) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(1.908891601562500000000000000000000000000e2), SC_(9.999999999999998938912972792355138154357e-1), SC_(1.061087027207644861845642641430987219568e-16) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(2.895718383789062500000000000000000000000e2), SC_(9.999999999999999999999999888203740591183e-1), SC_(1.117962594088170405234122676633901150734e-26) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(5.799609184265136718750000000000000000000), SC_(4.493736573977763618487936974539471797097e-14), SC_(9.999999999999550626342602223638151206303e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(1.511509037017822265625000000000000000000e1), SC_(1.799060455569734727777987857422185392537e-7), SC_(9.999998200939544430265272222012142577815e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(3.049045562744140625000000000000000000000e1), SC_(2.436411598295612715535954106238981840690e-3), SC_(9.975635884017043872844640458937610181593e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(4.764342117309570312500000000000000000000e1), SC_(1.087891288294088503625163477574992831360e-1), SC_(8.912108711705911496374836522425007168640e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(5.749683761596679687500000000000000000000e1), SC_(3.342555000459142750713703151123965907900e-1), SC_(6.657444999540857249286296848876034092100e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(6.492758178710937500000000000000000000000e1), SC_(5.060768484036570409786386996217682765379e-1), SC_(4.939231515963429590213613003782317234621e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(6.679841613769531250000000000000000000000e1), SC_(5.231301656833541753371636883992508154940e-1), SC_(4.768698343166458246628363116007491845060e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(6.831080627441406250000000000000000000000e1), SC_(5.247963575949033783398600187364934919859e-1), SC_(4.752036424050966216601399812635065080141e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(7.001763153076171875000000000000000000000e1), SC_(5.246952706287749508612357037371929651104e-1), SC_(4.753047293712250491387642962628070348896e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(7.279807281494140625000000000000000000000e1), SC_(5.260191694173885345548411983241612656671e-1), SC_(4.739808305826114654451588016758387343329e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(7.399365997314453125000000000000000000000e1), SC_(5.436620626188993338850107512052367729214e-1), SC_(4.563379373811006661149892487947632270786e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(8.378084564208984375000000000000000000000e1), SC_(7.082860246292630118049373737158305429607e-1), SC_(2.917139753707369881950626262841694570393e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(9.704746246337890625000000000000000000000e1), SC_(8.486416873647254161485079805429178152082e-1), SC_(1.513583126352745838514920194570821847918e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(1.075032653808593750000000000000000000000e2), SC_(9.322710545468315234772498808422724325757e-1), SC_(6.772894545316847652275011915772756742425e-2) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(1.408088989257812500000000000000000000000e2), SC_(9.929663205912257667666974252946791759067e-1), SC_(7.033679408774233233302574705320824093262e-3) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(1.883753051757812500000000000000000000000e2), SC_(9.999956238256198130869014273998131263615e-1), SC_(4.376174380186913098572600186873638495242e-6) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(2.936817016601562500000000000000000000000e2), SC_(9.999999999999978834625806131688059295340e-1), SC_(2.116537419386831194070465959227612828013e-15) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(3.954825439453125000000000000000000000000e2), SC_(9.999999999999999999999999928356703077197e-1), SC_(7.164329692280340782703529944086232552303e-27) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(5.006070556640625000000000000000000000000e2), SC_(9.999999999999999999999999999999999999994e-1), SC_(5.936074101112393452131313530066774048509e-40) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(1.017980957031250000000000000000000000000e1), SC_(2.167217306172687204107118907313227779822e-17), SC_(9.999999999999999783278269382731279589288e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(2.547697639465332031250000000000000000000e1), SC_(2.331900301737149598918969026460480764885e-9), SC_(9.999999976680996982628504010810309735395e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(5.537340545654296875000000000000000000000e1), SC_(3.181594746950224239701373180658200317915e-4), SC_(9.996818405253049775760298626819341799682e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(8.770005798339843750000000000000000000000e1), SC_(6.073506790902455882525354064086473209380e-2), SC_(9.392649320909754411747464593591352679062e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.064121398925781250000000000000000000000e2), SC_(2.865321373344263570757480118002393035295e-1), SC_(7.134678626655736429242519881997606964705e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.216118698120117187500000000000000000000e2), SC_(4.943118168853015171967501596007366864952e-1), SC_(5.056881831146984828032498403992633135048e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(1.227826461791992187500000000000000000000e2), SC_(5.159972080552526220251490825240286686585e-1), SC_(4.840027919447473779748509174759713313415e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.334397430419921875000000000000000000000e2), SC_(5.176351694404395132728338656954808225599e-1), SC_(4.823648305595604867271661343045191774401e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.355767059326171875000000000000000000000e2), SC_(5.177425465836406558821008182812930644232e-1), SC_(4.822574534163593441178991817187069355768e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.367424316406250000000000000000000000000e2), SC_(5.199311214313711209142327819106415633924e-1), SC_(4.800688785686288790857672180893584366076e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(1.406127471923828125000000000000000000000e2), SC_(5.424230560268125492559875322835419234252e-1), SC_(4.575769439731874507440124677164580765748e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.626507415771484375000000000000000000000e2), SC_(7.504790077219671052925022393387657431899e-1), SC_(2.495209922780328947074977606612342568101e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.775185546875000000000000000000000000000e2), SC_(8.996765339215734851124308393605223526032e-1), SC_(1.003234660784265148875691606394776473968e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(2.144478149414062500000000000000000000000e2), SC_(9.739811471992173961448936873543803987788e-1), SC_(2.601885280078260385510631264561960122117e-2) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(2.496610107421875000000000000000000000000e2), SC_(9.990155058254900853521170022556278233810e-1), SC_(9.844941745099146478829977443721766190211e-4) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(3.391671752929687500000000000000000000000e2), SC_(9.999999936364901661062999987902876834289e-1), SC_(6.363509833893700001209712316571077811567e-9) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(5.089084167480468750000000000000000000000e2), SC_(9.999999999999999999999891212105215584645e-1), SC_(1.087878947844153548247467345828760088122e-23) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(6.848364257812500000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.979353122902319775358880122380810879828e-42) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(8.711751708984375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.621813822754178344936697003021564501812e-64) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(1.747599220275878906250000000000000000000e1), SC_(2.873620313042783350315798053256889063859e-24), SC_(9.999999999999999999999971263796869572166e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(4.436343383789062500000000000000000000000e1), SC_(2.488950330238247704907326828028471517444e-13), SC_(9.999999999997511049669761752295092673172e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(8.984861755371093750000000000000000000000e1), SC_(1.523065569584518545507112798578532421202e-5), SC_(9.999847693443041548145449288720142146758e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(1.377418518066406250000000000000000000000e2), SC_(2.942189026347199542699315603130885780742e-2), SC_(9.705781097365280045730068439686911421926e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(1.679557189941406250000000000000000000000e2), SC_(2.408654963037534344270930509339803207996e-1), SC_(7.591345036962465655729069490660196792004e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(1.852433624267578125000000000000000000000e2), SC_(4.859746436358902748925262712690598583967e-1), SC_(5.140253563641097251074737287309401416033e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(1.898460083007812500000000000000000000000e2), SC_(5.118039490400358961828470173587850954991e-1), SC_(4.881960509599641038171529826412149045009e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(1.912380065917968750000000000000000000000e2), SC_(5.146526086608992567450082402593410991774e-1), SC_(4.853473913391007432549917597406589008226e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(1.969491729736328125000000000000000000000e2), SC_(5.147278528764015503314661013933990016729e-1), SC_(4.852721471235984496685338986066009983271e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(1.981419372558593750000000000000000000000e2), SC_(5.173428181109690261432757363747601570298e-1), SC_(4.826571818890309738567242636252398429702e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(2.000544586181640625000000000000000000000e2), SC_(5.437383401174216972556389329104575997687e-1), SC_(4.562616598825783027443610670895424002313e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(2.179201049804687500000000000000000000000e2), SC_(7.755081475904042579610956306587071097357e-1), SC_(2.244918524095957420389043693412928902643e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(2.382529296875000000000000000000000000000e2), SC_(9.258317995897296637566527139505049703795e-1), SC_(7.416820041027033624334728604949502962050e-2) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(2.618625488281250000000000000000000000000e2), SC_(9.828544112035767257617285386191002008571e-1), SC_(1.714558879642327423827146138089979914291e-2) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(3.043030090332031250000000000000000000000e2), SC_(9.996316423260272954416600305186924984849e-1), SC_(3.683576739727045583399694813075015150605e-4) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(4.063591613769531250000000000000000000000e2), SC_(9.999999996599807452425954150703642987558e-1), SC_(3.400192547574045849296357012442411578964e-10) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(6.164691162109375000000000000000000000000e2), SC_(9.999999999999999999999999992746079316519e-1), SC_(7.253920683480631503907956656237183341779e-28) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(8.332554931640625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.796954097272367711403015545932209370427e-50) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(1.064868896484375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.975277355363517397595680685639920442021e-77) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(2.141741371154785156250000000000000000000e1), SC_(3.705540008420248224312313852271072376401e-28), SC_(9.999999999999999999999999996294459991580e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(5.491159820556640625000000000000000000000e1), SC_(1.313080141286942163708243479676218530322e-15), SC_(9.999999999999986869198587130578362917565e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(1.105815887451171875000000000000000000000e2), SC_(2.427528455456777161941422184988577316627e-6), SC_(9.999975724715445432228380585778150114227e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(1.662263336181640625000000000000000000000e2), SC_(1.969141261169886019056039409004607561281e-2), SC_(9.803085873883011398094396059099539243872e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.027579803466796875000000000000000000000e2), SC_(2.200428683545842718912669128860071112202e-1), SC_(7.799571316454157281087330871139928887798e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(2.262471008300781250000000000000000000000e2), SC_(4.818200833084154376268370958249476292941e-1), SC_(5.181799166915845623731629041750523707059e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(2.296914825439453125000000000000000000000e2), SC_(5.101758507493821817230979421448582918092e-1), SC_(4.898241492506178182769020578551417081908e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(2.299893798828125000000000000000000000000e2), SC_(5.133297860473097638538848298524860210699e-1), SC_(4.866702139526902361461151701475139789301e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.304095306396484375000000000000000000000e2), SC_(5.136338012105853721173974275142674945258e-1), SC_(4.863661987894146278826025724857325054742e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(2.316971893310546875000000000000000000000e2), SC_(5.164494490973211395395695012095203782283e-1), SC_(4.835505509026788604604304987904796217717e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(2.343472595214843750000000000000000000000e2), SC_(5.447909215773838246016988222350921541110e-1), SC_(4.552090784226161753983011777649078458890e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(2.554877319335937500000000000000000000000e2), SC_(7.905033230314979663300633165897957040921e-1), SC_(2.094966769685020336699366834102042959079e-1) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.791278991699218750000000000000000000000e2), SC_(9.391657865003116878546785743674361177926e-1), SC_(6.083421349968831214532142563256388220740e-2) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(3.051229248046875000000000000000000000000e2), SC_(9.882226693264237191706450441810696488561e-1), SC_(1.177733067357628082935495581893035114389e-2) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(3.555964050292968750000000000000000000000e2), SC_(9.998528447761650932780040335529071095178e-1), SC_(1.471552238349067219959664470928904822018e-4) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(4.746034240722656250000000000000000000000e2), SC_(9.999999999826299621202647611998660183126e-1), SC_(1.737003787973523880013398168744251609005e-11) }}, 
      {{ SC_(3.848801040649414062500000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(7.133408203125000000000000000000000000000e2), SC_(9.999999999999999999999999999998756124632e-1), SC_(1.243875367522066428729788697203036666745e-31) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.837698822021484375000000000000000000000e2), SC_(9.999999999999999954589167549602271300731e-1), SC_(4.541083245039772869926893000931696142121e-18) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(2.567617187500000000000000000000000000000e2), SC_(9.999999999999999999999999858586532411883e-1), SC_(1.414134675881166423970071707766734574187e-26) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(5.187499523162841796875000000000000000000), SC_(1.520819916859988428528813032452695001539e-15), SC_(9.999999999999984791800831400115714711870e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(1.303202819824218750000000000000000000000e1), SC_(5.795665911127149114203322614438899677664e-8), SC_(9.999999420433408887285088579667738556110e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(2.711002731323242187500000000000000000000e1), SC_(1.828243127091555563326944105047727280304e-3), SC_(9.981717568729084444366730558949522727197e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(4.830909729003906250000000000000000000000e1), SC_(9.807777401797689075990108258476608948539e-2), SC_(9.019222259820231092400989174152339105146e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(5.804446411132812500000000000000000000000e1), SC_(3.264594838365989498784225683694926627961e-1), SC_(6.735405161634010501215774316305073372039e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(6.628855133056640625000000000000000000000e1), SC_(5.048703394152219905173196218282845635929e-1), SC_(4.951296605847780094826803781717154364071e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(6.741120147705078125000000000000000000000e1), SC_(5.228204096205099625834720056840697903940e-1), SC_(4.771795903794900374165279943159302096060e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(7.002232360839843750000000000000000000000e1), SC_(5.244056385010239553063664610928729988991e-1), SC_(4.755943614989760446936335389071270011009e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(7.039018249511718750000000000000000000000e1), SC_(5.245502092155069744413143682431941343978e-1), SC_(4.754497907844930255586856317568058656022e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(7.215325927734375000000000000000000000000e1), SC_(5.261126380268297541430142319384287377619e-1), SC_(4.738873619731702458569857680615712622381e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(7.409667205810546875000000000000000000000e1), SC_(5.442173935891012405330028910050983269122e-1), SC_(4.557826064108987594669971089949016730878e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(8.228942871093750000000000000000000000000e1), SC_(7.124213751254903423975724641018119412907e-1), SC_(2.875786248745096576024275358981880587093e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.181007385253906250000000000000000000000e1), SC_(8.509714402985930376864629280293091494385e-1), SC_(1.490285597014069623135370719706908505615e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(1.029900436401367187500000000000000000000e2), SC_(9.344131233910151479484574027772764845104e-1), SC_(6.558687660898485205154259722272351548963e-2) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(1.196382064819335937500000000000000000000e2), SC_(9.912019119759287554219816608338231718620e-1), SC_(8.798088024071244578018339166176828137962e-3) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(1.653243408203125000000000000000000000000e2), SC_(9.999922675685426618572162219050236497081e-1), SC_(7.732431457338142783778094976350291909989e-6) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(2.621119079589843750000000000000000000000e2), SC_(9.999999999999878466731258063066815524331e-1), SC_(1.215332687419369331844756691033339462077e-14) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(3.567703247070312500000000000000000000000e2), SC_(9.999999999999999999999998416219351740368e-1), SC_(1.583780648259632457802175089094603285599e-25) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(5.018518371582031250000000000000000000000e2), SC_(9.999999999999999999999999999999999999999e-1), SC_(6.035395478899136343812012314202939454863e-41) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(1.006854248046875000000000000000000000000e1), SC_(1.653371613061651384090873567722210596898e-18), SC_(9.999999999999999983466283869383486159091e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(2.609791564941406250000000000000000000000e1), SC_(5.909718447590029314549085446166998477847e-10), SC_(9.999999994090281552409970685450914553833e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(5.268419647216796875000000000000000000000e1), SC_(2.978046447349496425424758772049624510090e-4), SC_(9.997021953552650503574575241227950375490e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(7.996438598632812500000000000000000000000e1), SC_(6.393205620852317560474905364005073583470e-2), SC_(9.360679437914768243952509463599492641653e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(9.746627044677734375000000000000000000000e1), SC_(2.904951952044205623594670172602041369760e-1), SC_(7.095048047955794376405329827397958630240e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(1.073216171264648437500000000000000000000e2), SC_(4.963194375514279400243386094224926064045e-1), SC_(5.036805624485720599756613905775073935955e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.171273269653320312500000000000000000000e2), SC_(5.164950024230042221696751141010203718403e-1), SC_(4.835049975769957778303248858989796281597e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.234311828613281250000000000000000000000e2), SC_(5.183992090074111093238642267189991882343e-1), SC_(4.816007909925888906761357732810008117657e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.247459487915039062500000000000000000000e2), SC_(5.185454022255630949834265447639472638621e-1), SC_(4.814545977744369050165734552360527361379e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.294673767089843750000000000000000000000e2), SC_(5.204502598671771115934682816051175126451e-1), SC_(4.795497401328228884065317183948824873549e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(1.306973419189453125000000000000000000000e2), SC_(5.427355190552750959829417940091187985204e-1), SC_(4.572644809447249040170582059908812014796e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.539312744140625000000000000000000000000e2), SC_(7.488456806120623210283466511429536491385e-1), SC_(2.511543193879376789716533488570463508615e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.704730834960937500000000000000000000000e2), SC_(8.988250722844948333864089660717813282470e-1), SC_(1.011749277155051666135910339282186717530e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.860346679687500000000000000000000000000e2), SC_(9.681121049167669756632930758488627923750e-1), SC_(3.188789508323302433670692415113720762502e-2) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(2.185774841308593750000000000000000000000e2), SC_(9.984490123272745328430736072353842281710e-1), SC_(1.550987672725467156926392764615771829024e-3) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(3.087241516113281250000000000000000000000e2), SC_(9.999999822074114160405393118314487981144e-1), SC_(1.779258858395946068816855120188557149423e-8) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(4.632896728515625000000000000000000000000e2), SC_(9.999999999999999999997068242117409681133e-1), SC_(2.931757882590318867105359201024410962125e-22) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(6.858305053710937500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(5.008535108073069391067974137443615879619e-43) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(8.646922607421875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.234066120967813209931610294919337644112e-64) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.760813713073730468750000000000000000000e1), SC_(2.368173715303092604598761776942959512752e-25), SC_(9.999999999999999999999997631826284696907e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(4.403347778320312500000000000000000000000e1), SC_(1.229451785913550158405888159874511559287e-13), SC_(9.999999999998770548214086449841594111840e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(8.885343933105468750000000000000000000000e1), SC_(1.309009450480409987278052147863656724890e-5), SC_(9.999869099054951959001272194785213634328e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(1.355496063232421875000000000000000000000e2), SC_(2.891069195915898578020727926383180243044e-2), SC_(9.710893080408410142197927207361681975696e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(1.631319122314453125000000000000000000000e2), SC_(2.416029905076708089639764750668984781187e-1), SC_(7.583970094923291910360235249331015218813e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(1.821119995117187500000000000000000000000e2), SC_(4.860659523526827739439816852306183016583e-1), SC_(5.139340476473172260560183147693816983417e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(1.860088195800781250000000000000000000000e2), SC_(5.119885302721057720583517657036864565908e-1), SC_(4.880114697278942279416482342963135434092e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(1.901535644531250000000000000000000000000e2), SC_(5.147265388756809706061832819253036603186e-1), SC_(4.852734611243190293938167180746963396814e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(1.931345520019531250000000000000000000000e2), SC_(5.149043115609391087852607575156504222873e-1), SC_(4.850956884390608912147392424843495777127e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(1.938058929443359375000000000000000000000e2), SC_(5.175363475448210991953387217908998269633e-1), SC_(4.824636524551789008046612782091001730367e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(1.984991455078125000000000000000000000000e2), SC_(5.439943851677686697803783622537894975774e-1), SC_(4.560056148322313302196216377462105024226e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(2.175093688964843750000000000000000000000e2), SC_(7.772878445863623928144324681152332479786e-1), SC_(2.227121554136376071855675318847667520214e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(2.441127014160156250000000000000000000000e2), SC_(9.295711190996118666205147297081213273424e-1), SC_(7.042888090038813337948527029187867265757e-2) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(2.657742614746093750000000000000000000000e2), SC_(9.841251327640098161268273792141547108254e-1), SC_(1.587486723599018387317262078584528917458e-2) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(3.068572387695312500000000000000000000000e2), SC_(9.996801873596621937750842396783181901913e-1), SC_(3.198126403378062249157603216818098087082e-4) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(4.092138977050781250000000000000000000000e2), SC_(9.999999997721364633934610139732314447340e-1), SC_(2.278635366065389860267685552659956784704e-10) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(6.151256103515625000000000000000000000000e2), SC_(9.999999999999999999999999996031869770991e-1), SC_(3.968130229009211485023216758051641610954e-28) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(8.317220458984375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.567930102893672927289823091455867877272e-51) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(1.046832153320312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.170663466551560523585301565731546225969e-76) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(2.096773529052734375000000000000000000000e1), SC_(1.297843134085788692705175852039894218331e-28), SC_(9.999999999999999999999999998702156865914e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(5.299687194824218750000000000000000000000e1), SC_(1.499628429970313110487605671396116786749e-15), SC_(9.999999999999985003715700296868895123943e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(1.074058227539062500000000000000000000000e2), SC_(2.563289985892851021590905150429423055245e-6), SC_(9.999974367100141071489784090948495705769e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(1.646036529541015625000000000000000000000e2), SC_(1.924536376077915501565263577348578451371e-2), SC_(9.807546362392208449843473642265142154863e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(1.986047058105468750000000000000000000000e2), SC_(2.203891189197252603449991080491542738604e-1), SC_(7.796108810802747396550008919508457261396e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(2.238827209472656250000000000000000000000e2), SC_(4.818173715677903722431354744959810980947e-1), SC_(5.181826284322096277568645255040189019053e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(2.274332885742187500000000000000000000000e2), SC_(5.102582554901526798281063934014154153081e-1), SC_(4.897417445098473201718936065985845846919e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(2.281328887939453125000000000000000000000e2), SC_(5.134106344738831471274697209074109735225e-1), SC_(4.865893655261168528725302790925890264775e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.318076019287109375000000000000000000000e2), SC_(5.136208560300940864401509542966516726752e-1), SC_(4.863791439699059135598490457033483273248e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(2.352652435302734375000000000000000000000e2), SC_(5.164169710104737578328653240878496568157e-1), SC_(4.835830289895262421671346759121503431843e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(2.387833709716796875000000000000000000000e2), SC_(5.451985150353356895234826489203779418899e-1), SC_(4.548014849646643104765173510796220581101e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(2.601358642578125000000000000000000000000e2), SC_(7.939142192367483986742544695231957495128e-1), SC_(2.060857807632516013257455304768042504872e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.842611389160156250000000000000000000000e2), SC_(9.419255847655498800708148939883037822435e-1), SC_(5.807441523445011992918510601169621775652e-2) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(3.093525085449218750000000000000000000000e2), SC_(9.890989602799361058873321853065855392701e-1), SC_(1.090103972006389411266781469341446072995e-2) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(3.577871398925781250000000000000000000000e2), SC_(9.998708879295995078033021780614629035856e-1), SC_(1.291120704004921966978219385370964143695e-4) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(4.775186767578125000000000000000000000000e2), SC_(9.999999999882826488408835367262866301554e-1), SC_(1.171735115911646327371336984455935194574e-11) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(7.173129882812500000000000000000000000000e2), SC_(9.999999999999999999999999999999568142746e-1), SC_(4.318572535496110794468805497615532185511e-32) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(9.648308715820312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.060212499251243679294308441892766431924e-58) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(1.217810180664062500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.714860995501953621580173333702587362699e-88) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(2.437994956970214843750000000000000000000e1), SC_(5.628697935686835714850732887092021670811e-32), SC_(9.999999999999999999999999999999437130206e-1) }}, 
      {{ SC_(4.498577499389648437500000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(6.106951141357421875000000000000000000000e1), SC_(2.741876285771921080846150437380568823662e-17), SC_(9.999999999999999725812371422807891915385e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.868892097473144531250000000000000000000e1), SC_(6.071136954163337696668702586140087000503e-4), SC_(9.993928863045836662303331297413859912999e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(4.709078598022460937500000000000000000000e1), SC_(8.061441416022293003675276258103027557725e-2), SC_(9.193855858397770699632472374189697244227e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(5.697932434082031250000000000000000000000e1), SC_(3.118678634257653977087653105069671025884e-1), SC_(6.881321365742346022912346894930328974116e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(6.292784881591796875000000000000000000000e1), SC_(5.032837073238516702386451254797372858312e-1), SC_(4.967162926761483297613548745202627141688e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(6.558977508544921875000000000000000000000e1), SC_(5.222934859318927655976120340988598779442e-1), SC_(4.777065140681072344023879659011401220558e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(7.584750366210937500000000000000000000000e1), SC_(5.232205717684640981270600522879293539037e-1), SC_(4.767794282315359018729399477120706460963e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(7.593682098388671875000000000000000000000e1), SC_(5.234290424496163301086309467185690488054e-1), SC_(4.765709575503836698913690532814309511946e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(7.847189331054687500000000000000000000000e1), SC_(5.251065938705519603330444311290829876845e-1), SC_(4.748934061294480396669555688709170123155e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(7.970318603515625000000000000000000000000e1), SC_(5.447640655827728261787709673181912759832e-1), SC_(4.552359344172271738212290326818087240168e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(8.960347747802734375000000000000000000000e1), SC_(7.248107780450639567834082598639078970270e-1), SC_(2.751892219549360432165917401360921029730e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(9.818222045898437500000000000000000000000e1), SC_(8.662953342642451649329528300945040856713e-1), SC_(1.337046657357548350670471699054959143287e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(1.085715103149414062500000000000000000000e2), SC_(9.454626384752552086959703750633127723080e-1), SC_(5.453736152474479130402962493668722769200e-2) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(1.271976242065429687500000000000000000000e2), SC_(9.942039641227567915688621494767426754653e-1), SC_(5.796035877243208431137850523257324534679e-3) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(1.724878845214843750000000000000000000000e2), SC_(9.999973877905646547610440257124428913791e-1), SC_(2.612209435345238955974287557108620926708e-6) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(2.638312988281250000000000000000000000000e2), SC_(9.999999999999985805937061787379469021812e-1), SC_(1.419406293821262053097818838088915701226e-15) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(3.626339111328125000000000000000000000000e2), SC_(9.999999999999999999999999967953647767745e-1), SC_(3.204635223225508936979284369605149071276e-27) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(4.559709167480468750000000000000000000000e2), SC_(9.999999999999999999999999999999999999994e-1), SC_(6.071396435645842426842373682942319289407e-40) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(9.409754753112792968750000000000000000000), SC_(1.928915461530717005815510169993076870940e-20), SC_(9.999999999999999999807108453846928299418e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(2.470150375366210937500000000000000000000e1), SC_(1.201040521718750299387646455663602966649e-10), SC_(9.999999998798959478281249700612353544336e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(5.031398010253906250000000000000000000000e1), SC_(1.976355056985899029362412928935502725394e-4), SC_(9.998023644943014100970637587071064497275e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(8.385430908203125000000000000000000000000e1), SC_(5.371460579043165172904870883834525801714e-2), SC_(9.462853942095683482709512911616547419829e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(1.009087066650390625000000000000000000000e2), SC_(2.803881074232065404715939177721013966492e-1), SC_(7.196118925767934595284060822278986033508e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(1.146687622070312500000000000000000000000e2), SC_(4.943335414325928284892888402003520191987e-1), SC_(5.056664585674071715107111597996479808013e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(1.166869659423828125000000000000000000000e2), SC_(5.164936689792551148054832858515944058382e-1), SC_(4.835063310207448851945167141484055941618e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(1.180545501708984375000000000000000000000e2), SC_(5.188618632946476234384959953761437801862e-1), SC_(4.811381367053523765615040046238562198138e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(1.197432098388671875000000000000000000000e2), SC_(5.189772729753677023016420458683881621381e-1), SC_(4.810227270246322976983579541316118378619e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(1.199608917236328125000000000000000000000e2), SC_(5.212092920470899884293088595967735171655e-1), SC_(4.787907079529100115706911404032264828345e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.299667510986328125000000000000000000000e2), SC_(5.434721794108151358026411281291733548366e-1), SC_(4.565278205891848641973588718708266451634e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.483532104492187500000000000000000000000e2), SC_(7.512440950854045646378273938120350907047e-1), SC_(2.487559049145954353621726061879649092953e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.634026336669921875000000000000000000000e2), SC_(9.005516014591330849868065998769135595328e-1), SC_(9.944839854086691501319340012308644046723e-2) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.830054168701171875000000000000000000000e2), SC_(9.701859746828166208996024430428086525651e-1), SC_(2.981402531718337910039755695719134743493e-2) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(2.112580261230468750000000000000000000000e2), SC_(9.985600496835074921296210431101867420476e-1), SC_(1.439950316492507870378956889813257952396e-3) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(3.027457580566406250000000000000000000000e2), SC_(9.999999868906271896451284227050371206301e-1), SC_(1.310937281035487157729496287936989174549e-8) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(4.604888305664062500000000000000000000000e2), SC_(9.999999999999999999999124794934061852760e-1), SC_(8.752050659381472397203450922717685022664e-23) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(6.181558227539062500000000000000000000000e2), SC_(9.999999999999999999999999999999999999998e-1), SC_(1.999094045376907599625058229400889667804e-40) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(7.857684326171875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.951887750929805629175904098204125455354e-61) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.657974433898925781250000000000000000000e1), SC_(3.212050575020044264492685920811943314854e-26), SC_(9.999999999999999999999999678794942497996e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(4.146631622314453125000000000000000000000e1), SC_(8.039071558575980874451212201366761782424e-14), SC_(9.999999999999196092844142401912554878780e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(9.144650268554687500000000000000000000000e1), SC_(6.690079142245145753580593759920122323992e-6), SC_(9.999933099208577548542464194062400798777e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(1.382803649902343750000000000000000000000e2), SC_(2.542605774330500076134582881154954062567e-2), SC_(9.745739422566949992386541711884504593743e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.687650451660156250000000000000000000000e2), SC_(2.338032771956545434356368106033665264902e-1), SC_(7.661967228043454565643631893966334735098e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.856935882568359375000000000000000000000e2), SC_(4.851996312716507172585819187163384753313e-1), SC_(5.148003687283492827414180812836615246687e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(1.889531097412109375000000000000000000000e2), SC_(5.118457876829275261396151849421128238888e-1), SC_(4.881542123170724738603848150578871761112e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(1.921681671142578125000000000000000000000e2), SC_(5.146947504217363866806228668092844747096e-1), SC_(4.853052495782636133193771331907155252904e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(1.927123260498046875000000000000000000000e2), SC_(5.149732938983674407694320508015531658915e-1), SC_(4.850267061016325592305679491984468341085e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(1.955822601318359375000000000000000000000e2), SC_(5.175771966352232939550773258383304376744e-1), SC_(4.824228033647767060449226741616695623256e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(1.996066741943359375000000000000000000000e2), SC_(5.445646425718837614772681640301745954252e-1), SC_(4.554353574281162385227318359698254045748e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(2.217478332519531250000000000000000000000e2), SC_(7.824988037141275006149686925952468634415e-1), SC_(2.175011962858724993850313074047531365585e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(2.454607238769531250000000000000000000000e2), SC_(9.329308373090075325105150690971230189212e-1), SC_(6.706916269099246748948493090287698107877e-2) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(2.665619201660156250000000000000000000000e2), SC_(9.854280334817255158930954315300141708461e-1), SC_(1.457196651827448410690456846998582915390e-2) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(3.119537658691406250000000000000000000000e2), SC_(9.997548636617127602179173181229394401801e-1), SC_(2.451363382872397820826818770605598199138e-4) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(4.183422851562500000000000000000000000000e2), SC_(9.999999999074686469802716600484944787511e-1), SC_(9.253135301972833995150552124894306178171e-11) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(6.445878295898437500000000000000000000000e2), SC_(9.999999999999999999999999999923108827461e-1), SC_(7.689117253924342302067504027758585718011e-30) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(8.635084838867187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.415815786915462987103669997752697970454e-53) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(1.080034301757812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.573710899971561477318647974661675200299e-80) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(2.160423088073730468750000000000000000000e1), SC_(6.557404882060962207511661726081648890684e-31), SC_(9.999999999999999999999999999993442595118e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(5.411930847167968750000000000000000000000e1), SC_(1.883699883040158311197535646975237553192e-16), SC_(9.999999999999998116300116959841688802464e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(1.096829376220703125000000000000000000000e2), SC_(1.382663797833570005951101626539633737314e-6), SC_(9.999986173362021664299940488983734603663e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(1.656013488769531250000000000000000000000e2), SC_(1.745506986585797900524496063784465882836e-2), SC_(9.825449301341420209947550393621553411716e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(1.990014343261718750000000000000000000000e2), SC_(2.165727873779222354527982924183318520010e-1), SC_(7.834272126220777645472017075816681479990e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(2.211886291503906250000000000000000000000e2), SC_(4.816534334236932234207474725298284509165e-1), SC_(5.183465665763067765792525274701715490835e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(2.260207672119140625000000000000000000000e2), SC_(5.103061692552517272891269325610608631880e-1), SC_(4.896938307447482727108730674389391368120e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(2.309069061279296875000000000000000000000e2), SC_(5.133682655446086059924611631277463375891e-1), SC_(4.866317344553913940075388368722536624109e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(2.321304779052734375000000000000000000000e2), SC_(5.136563360671567418340579942583255246644e-1), SC_(4.863436639328432581659420057416744753356e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(2.378171234130859375000000000000000000000e2), SC_(5.164428214872935341079753175877428907569e-1), SC_(4.835571785127064658920246824122571092431e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(2.414872741699218750000000000000000000000e2), SC_(5.457550137595218338920448783424733253081e-1), SC_(4.542449862404781661079551216575266746919e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(2.635250854492187500000000000000000000000e2), SC_(7.981084867014164412608155671694973651733e-1), SC_(2.018915132985835587391844328305026348267e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.918637695312500000000000000000000000000e2), SC_(9.461534847108482618794181662921981869154e-1), SC_(5.384651528915173812058183370780181308457e-2) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(3.204052124023437500000000000000000000000e2), SC_(9.907896200116139160115197623845445499356e-1), SC_(9.210379988386083988480237615455450064378e-3) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(3.717817993164062500000000000000000000000e2), SC_(9.999147068718901584669801824468687711815e-1), SC_(8.529312810984153301981755313122881845113e-5) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(4.958450317382812500000000000000000000000e2), SC_(9.999999999967403193323204466610138766632e-1), SC_(3.259680667679553338986123336758677693831e-12) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(7.449588623046875000000000000000000000000e2), SC_(9.999999999999999999999999999999989766190e-1), SC_(1.023381027016152316019796976688512325613e-33) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(9.975953979492187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(8.236620230793247399494149212723563656705e-61) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(1.249800659179687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.284058976280692060538818718793224181403e-91) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(2.501947021484375000000000000000000000000e1), SC_(3.324082550017707389509161767325199517077e-34), SC_(9.999999999999999999999999999999996675917e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(6.263492584228515625000000000000000000000e1), SC_(2.939298577013434551405348965891891948283e-18), SC_(9.999999999999999970607014229865654485947e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(1.263215408325195312500000000000000000000e2), SC_(3.250894313286567364494450908202302201023e-7), SC_(9.999996749105686713432635505549091797698e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(1.912480468750000000000000000000000000000e2), SC_(1.229780093801942686626304246243715876534e-2), SC_(9.877021990619805731337369575375628412347e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(2.297113647460937500000000000000000000000e2), SC_(2.008858813183342034742584273323380378240e-1), SC_(7.991141186816657965257415726676619621760e-1) }}, 
      {{ SC_(5.642114639282226562500000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.531562805175781250000000000000000000000e2), SC_(4.788179606123021650044326249320094457376e-1), SC_(5.211820393876978349955673750679905542624e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(6.100448608398437500000000000000000000000e1), SC_(5.220701334218685682121387955994065705875e-1), SC_(4.779298665781314317878612044005934294125e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(6.647542572021484375000000000000000000000e1), SC_(5.239717003611910340839009411943307512235e-1), SC_(4.760282996388089659160990588056692487765e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(6.700476837158203125000000000000000000000e1), SC_(5.241490985032232423528751904944475181175e-1), SC_(4.758509014967767576471248095055524818825e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(6.731844329833984375000000000000000000000e1), SC_(5.261012548742582097245207985816843322741e-1), SC_(4.738987451257417902754792014183156677259e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(7.003656005859375000000000000000000000000e1), SC_(5.456073325802385777623929677855324244051e-1), SC_(4.543926674197614222376070322144675755949e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(8.748873138427734375000000000000000000000e1), SC_(7.271523395302389672388711198565783871902e-1), SC_(2.728476604697610327611288801434216128098e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(9.554032897949218750000000000000000000000e1), SC_(8.688797810853511476788649870534546238130e-1), SC_(1.311202189146488523211350129465453761870e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(1.067055664062500000000000000000000000000e2), SC_(9.475159358790424705606284413991697584113e-1), SC_(5.248406412095752943937155860083024158870e-2) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(1.239026412963867187500000000000000000000e2), SC_(9.945532044593791299002839329537719078578e-1), SC_(5.446795540620870099716067046228092142220e-3) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(1.702908172607421875000000000000000000000e2), SC_(9.999978966914045430495760437901710959686e-1), SC_(2.103308595456950423956209828904031420724e-6) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(2.565186462402343750000000000000000000000e2), SC_(9.999999999999988319062659987490801537796e-1), SC_(1.168093734001250919846220378735788733165e-15) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(3.488170166015625000000000000000000000000e2), SC_(9.999999999999999999999999956218780767532e-1), SC_(4.378121923246773549191814583847933378525e-27) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(4.424306030273437500000000000000000000000e2), SC_(9.999999999999999999999999999999999999993e-1), SC_(7.412900143342126034119901156877159424896e-40) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(8.993165969848632812500000000000000000000), SC_(4.577250426737877235238872055085051084040e-21), SC_(9.999999999999999999954227495732621227648e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(2.290786743164062500000000000000000000000e1), SC_(1.008262950020593573983970345529372064081e-10), SC_(9.999999998991737049979406426016029654471e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(4.717309570312500000000000000000000000000e1), SC_(1.976107064407965237291264526165154916604e-4), SC_(9.998023892935592034762708735473834845083e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(7.116141510009765625000000000000000000000e1), SC_(6.037156806961218069499573223669227829895e-2), SC_(9.396284319303878193050042677633077217011e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(8.800672149658203125000000000000000000000e1), SC_(2.875073378816985375343413135584232008491e-1), SC_(7.124926621183014624656586864415767991509e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(1.014687881469726562500000000000000000000e2), SC_(4.961690259691524414580882992315531590524e-1), SC_(5.038309740308475585419117007684468409476e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(1.042113494873046875000000000000000000000e2), SC_(5.176378437489693768071589093724548893542e-1), SC_(4.823621562510306231928410906275451106458e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(1.154934539794921875000000000000000000000e2), SC_(5.190699837701747873886630112646168396466e-1), SC_(4.809300162298252126113369887353831603534e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(1.158200836181640625000000000000000000000e2), SC_(5.192928966137789449299896731176475862185e-1), SC_(4.807071033862210550700103268823524137815e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(1.196342620849609375000000000000000000000e2), SC_(5.212601732429314138954680019932495959422e-1), SC_(4.787398267570685861045319980067504040578e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(1.216963882446289062500000000000000000000e2), SC_(5.437515146725754077068632178654001950189e-1), SC_(4.562484853274245922931367821345998049811e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(1.339164886474609375000000000000000000000e2), SC_(7.465198096397234363267890994995666158521e-1), SC_(2.534801903602765636732109005004333841479e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(1.481027374267578125000000000000000000000e2), SC_(8.950619598651652506484525424246585295524e-1), SC_(1.049380401348347493515474575753414704476e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(1.605873718261718750000000000000000000000e2), SC_(9.651906069774498867570738531604436968995e-1), SC_(3.480939302255011324292614683955630310054e-2) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.985514678955078125000000000000000000000e2), SC_(9.983315122336655850842431540087264621267e-1), SC_(1.668487766334414915756845991273537873325e-3) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(2.771085205078125000000000000000000000000e2), SC_(9.999999683132996780899601154201391517821e-1), SC_(3.168670032191003988457986084821788547845e-8) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(4.195697021484375000000000000000000000000e2), SC_(9.999999999999999999981576864438065144514e-1), SC_(1.842313556193485548648535738366565046356e-21) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(5.778444824218750000000000000000000000000e2), SC_(9.999999999999999999999999999999999999882e-1), SC_(1.184443524282507263845484259439543315453e-38) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(7.226319580078125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.720295905517965105269506213249330402779e-57) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.550605964660644531250000000000000000000e1), SC_(6.515939716206212137909263274233270030212e-26), SC_(9.999999999999999999999999348406028379379e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(3.929599761962890625000000000000000000000e1), SC_(1.228546362713019124034947887374712034236e-13), SC_(9.999999999998771453637286980875965052113e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(7.911333465576171875000000000000000000000e1), SC_(1.633327107880901445081791938254188107586e-5), SC_(9.999836667289211909855491820806174581189e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(1.206310501098632812500000000000000000000e2), SC_(3.141596322636122899001549600078819369571e-2), SC_(9.685840367736387710099845039992118063043e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.525366363525390625000000000000000000000e2), SC_(2.423310463829551992667388363029214265801e-1), SC_(7.576689536170448007332611636970785734199e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.678574523925781250000000000000000000000e2), SC_(4.870131539278518658536685702201429364742e-1), SC_(5.129868460721481341463314297798570635258e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.863941345214843750000000000000000000000e2), SC_(5.119633316805432788345210305536589231119e-1), SC_(4.880366683194567211654789694463410768881e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(1.880615234375000000000000000000000000000e2), SC_(5.148730967956835742338283656998432120504e-1), SC_(4.851269032043164257661716343001567879496e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(1.912235565185546875000000000000000000000e2), SC_(5.150464965766815418869529772887393473392e-1), SC_(4.849535034233184581130470227112606526608e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.914482574462890625000000000000000000000e2), SC_(5.177428198247785948042221513534678298133e-1), SC_(4.822571801752214051957778486465321701867e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(1.947582550048828125000000000000000000000e2), SC_(5.446238596140229543482301154767865416276e-1), SC_(4.553761403859770456517698845232134583724e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(2.154414672851562500000000000000000000000e2), SC_(7.811887636516416221871371009203545839350e-1), SC_(2.188112363483583778128628990796454160650e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(2.356569366455078125000000000000000000000e2), SC_(9.307287709445470334682990680730358038511e-1), SC_(6.927122905545296653170093192696419614893e-2) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(2.587969360351562500000000000000000000000e2), SC_(9.848381391665248012803153215117115184202e-1), SC_(1.516186083347519871968467848828848157980e-2) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(3.019771118164062500000000000000000000000e2), SC_(9.997245139911452229629233093868899556164e-1), SC_(2.754860088547770370766906131100443836330e-4) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(4.105532836914062500000000000000000000000e2), SC_(9.999999998908139913618093353046204182117e-1), SC_(1.091860086381906646953795817883119470512e-10) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(6.247149658203125000000000000000000000000e2), SC_(9.999999999999999999999999999712144654352e-1), SC_(2.878553456483530399228506377311034240693e-29) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(8.349414062500000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.347654895381418885141332315379240254114e-52) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(1.058284423828125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.483952811091726337853008941857693137966e-79) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(2.128588676452636718750000000000000000000e1), SC_(3.552367233004205491920345729246740985959e-31), SC_(9.999999999999999999999999999996447632767e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(5.463758087158203125000000000000000000000e1), SC_(8.781852276512874012402430977324255631072e-17), SC_(9.999999999999999121814772348712598759757e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(1.097824172973632812500000000000000000000e2), SC_(1.191536642386123944685807136115354434078e-6), SC_(9.999988084633576138760553141928638846456e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(1.647709350585937500000000000000000000000e2), SC_(1.716538626981454767015823694704744958322e-2), SC_(9.828346137301854523298417630529525504168e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(1.977570190429687500000000000000000000000e2), SC_(2.160499131437996259090901946065576786747e-1), SC_(7.839500868562003740909098053934423213253e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(2.179633026123046875000000000000000000000e2), SC_(4.818148728766911175047052276329687348278e-1), SC_(5.181851271233088824952947723670312651722e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(2.228305358886718750000000000000000000000e2), SC_(5.104221797257441057129715974821168726845e-1), SC_(4.895778202742558942870284025178831273155e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(2.244895172119140625000000000000000000000e2), SC_(5.135761388953101882702203709990121330929e-1), SC_(4.864238611046898117297796290009878669071e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(2.248229064941406250000000000000000000000e2), SC_(5.138872180533416513225706408712380130089e-1), SC_(4.861127819466583486774293591287619869911e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(2.273376922607421875000000000000000000000e2), SC_(5.167162735984025324212195074652638164398e-1), SC_(4.832837264015974675787804925347361835602e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(2.322340698242187500000000000000000000000e2), SC_(5.456343463090226242937446097787442366026e-1), SC_(4.543656536909773757062553902212557633974e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(2.580540771484375000000000000000000000000e2), SC_(7.971403479817072073393886159073224128669e-1), SC_(2.028596520182927926606113840926775871331e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(2.829539794921875000000000000000000000000e2), SC_(9.445890814272451283892625852181956678332e-1), SC_(5.541091857275487161073741478180433216681e-2) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(3.136473999023437500000000000000000000000e2), SC_(9.904841148676629756584839956109673792997e-1), SC_(9.515885132337024341516004389032620700308e-3) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(3.641760253906250000000000000000000000000e2), SC_(9.999077391604471215727206530538406641682e-1), SC_(9.226083955287842727934694615933583181301e-5) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(4.865119323730468750000000000000000000000e2), SC_(9.999999999958486195534590171879647280938e-1), SC_(4.151380446540982812035271906236287952478e-12) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(7.407225341796875000000000000000000000000e2), SC_(9.999999999999999999999999999999990225469e-1), SC_(9.774530703744906072226587192521605894999e-34) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(1.000613098144531250000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.809021197959362098652316247080784939314e-61) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(1.257711303710937500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.584203111101794931797541621984861045947e-92) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(2.516102409362792968750000000000000000000e1), SC_(7.039997569761518264138274595472649501956e-35), SC_(9.999999999999999999999999999999999296000e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(6.300183486938476562500000000000000000000e1), SC_(1.507926593411370615655228225890684819710e-18), SC_(9.999999999999999984920734065886293843448e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(1.265432815551757812500000000000000000000e2), SC_(2.789575924196763773709567225759265916101e-7), SC_(9.999997210424075803236226290432774240734e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(1.902358856201171875000000000000000000000e2), SC_(1.214054959429626934589639369879487934715e-2), SC_(9.878594504057037306541036063012051206529e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(2.284941711425781250000000000000000000000e2), SC_(2.004450279758038426457457067953456121017e-1), SC_(7.995549720241961573542542932046543878983e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.516851501464843750000000000000000000000e2), SC_(4.788142811232911173033836711038491924900e-1), SC_(5.211857188767088826966163288961508075100e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(2.560744934082031250000000000000000000000e2), SC_(5.092846496579953472391309915893392433609e-1), SC_(4.907153503420046527608690084106607566391e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(2.586851196289062500000000000000000000000e2), SC_(5.126204873621230318503816167046547068426e-1), SC_(4.873795126378769681496183832953452931574e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(2.589484558105468750000000000000000000000e2), SC_(5.129554716636639512611313700078783488297e-1), SC_(4.870445283363360487388686299921216511703e-1) }}, 
      {{ SC_(6.010885620117187500000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(2.596605224609375000000000000000000000000e2), SC_(5.160131312963474439008241984282824220065e-1), SC_(4.839868687036525560991758015717175779935e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(6.391475677490234375000000000000000000000e1), SC_(5.459094628379855390819126754782223524993e-1), SC_(4.540905371620144609180873245217776475007e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(7.556099700927734375000000000000000000000e1), SC_(7.262941177428364042554932169902435643964e-1), SC_(2.737058822571635957445067830097564356036e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(8.305735015869140625000000000000000000000e1), SC_(8.672239523543063302972481923355099097607e-1), SC_(1.327760476456936697027518076644900902393e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(9.030784606933593750000000000000000000000e1), SC_(9.450127015340457304617487039858692798357e-1), SC_(5.498729846595426953825129601413072016433e-2) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(1.073392791748046875000000000000000000000e2), SC_(9.939357419298215030205964508028440793252e-1), SC_(6.064258070178496979403549197155920674812e-3) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(1.635031890869140625000000000000000000000e2), SC_(9.999978378873628843775446355205432145866e-1), SC_(2.162112637115622455364479456785413378153e-6) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(2.454999694824218750000000000000000000000e2), SC_(9.999999999999984623829566923389153445122e-1), SC_(1.537617043307661084655487793792989122775e-15) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(3.371903686523437500000000000000000000000e2), SC_(9.999999999999999999999999934337841162494e-1), SC_(6.566215883750598735683821674964430452116e-27) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(4.240907287597656250000000000000000000000e2), SC_(9.999999999999999999999999999999999999973e-1), SC_(2.676867333184640492904527575631283920162e-39) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(8.736179351806640625000000000000000000000), SC_(1.742552935501273390179270914827947428097e-21), SC_(9.999999999999999999982574470644987266098e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(2.193065071105957031250000000000000000000e1), SC_(8.022916515675681384271544317070485573906e-11), SC_(9.999999999197708348432431861572845568293e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(4.471031951904296875000000000000000000000e1), SC_(1.994840200197297040062859801594959284753e-4), SC_(9.998005159799802702959937140198405040715e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(6.802687835693359375000000000000000000000e1), SC_(6.067204405075460051427608036283387688291e-2), SC_(9.393279559492453994857239196371661231171e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(8.293323516845703125000000000000000000000e1), SC_(2.892641286767514405180632293126781123310e-1), SC_(7.107358713232485594819367706873218876690e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(9.290937805175781250000000000000000000000e1), SC_(4.973675778905312254956739609942261465448e-1), SC_(5.026324221094687745043260390057738534552e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(9.646601867675781250000000000000000000000e1), SC_(5.183943310255713962640806200436001365587e-1), SC_(4.816056689744286037359193799563998634413e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(9.709827423095703125000000000000000000000e1), SC_(5.207175718224836950659992047732013432665e-1), SC_(4.792824281775163049340007952267986567335e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(1.000116348266601562500000000000000000000e2), SC_(5.206756395515725364491365958908399814398e-1), SC_(4.793243604484274635508634041091600185602e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(1.048148193359375000000000000000000000000e2), SC_(5.224235981796593973778807789662251777380e-1), SC_(4.775764018203406026221192210337748222620e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(1.075973739624023437500000000000000000000e2), SC_(5.441161731338155570874789300381960231051e-1), SC_(4.558838268661844429125210699618039768949e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(1.294808197021484375000000000000000000000e2), SC_(7.457556450248433822928850535367543509326e-1), SC_(2.542443549751566177071149464632456490674e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(1.416298675537109375000000000000000000000e2), SC_(8.932036135587769878585868226341031431874e-1), SC_(1.067963864412230121414131773658968568126e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(1.582504577636718750000000000000000000000e2), SC_(9.652854426017132189592620977888870636066e-1), SC_(3.471455739828678104073790221111293639339e-2) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(1.840617980957031250000000000000000000000e2), SC_(9.979664628313583396269956084265938939343e-1), SC_(2.033537168641660373004391573406106065732e-3) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(2.479172973632812500000000000000000000000e2), SC_(9.999999072916490781817367933672258174953e-1), SC_(9.270835092181826320663277418250472469977e-8) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(3.769060058593750000000000000000000000000e2), SC_(9.999999999999999999495763563605482282653e-1), SC_(5.042364363945177173465026672153154686693e-20) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(5.029805297851562500000000000000000000000e2), SC_(9.999999999999999999999999999999999450065e-1), SC_(5.499345462466126499990492572525966460691e-35) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(6.729202270507812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.011661299548607853575910674795676761770e-54) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.407706451416015625000000000000000000000e1), SC_(4.015448388111356477570728579481724599359e-25), SC_(9.999999999999999999999995984551611888644e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(3.551823425292968750000000000000000000000e1), SC_(4.589134210360159448641714847257675923820e-13), SC_(9.999999999995410865789639840551358285153e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(7.333874511718750000000000000000000000000e1), SC_(2.381621113984273320129408072231901952613e-5), SC_(9.999761837888601572667987059192776809805e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(1.100570755004882812500000000000000000000e2), SC_(3.553839587658008319980861790821771594167e-2), SC_(9.644616041234199168001913820917822840583e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.415492706298828125000000000000000000000e2), SC_(2.483699208837101085189723503707077093159e-1), SC_(7.516300791162898914810276496292922906841e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.578063507080078125000000000000000000000e2), SC_(4.880841215525386108119169471009482661043e-1), SC_(5.119158784474613891880830528990517338957e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.602826080322265625000000000000000000000e2), SC_(5.133368859895882739442732230326755401732e-1), SC_(4.866631140104117260557267769673244598268e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(1.630577850341796875000000000000000000000e2), SC_(5.160136666040424957392993488498757715289e-1), SC_(4.839863333959575042607006511501242284711e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(1.717187042236328125000000000000000000000e2), SC_(5.158826430767062296614644078171451929435e-1), SC_(4.841173569232937703385355921828548070565e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(1.719411315917968750000000000000000000000e2), SC_(5.184739289050414135494792074336095871944e-1), SC_(4.815260710949585864505207925663904128056e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.906850585937500000000000000000000000000e2), SC_(5.446390863640211996515675478713788875273e-1), SC_(4.553609136359788003484324521286211124727e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(2.093057098388671875000000000000000000000e2), SC_(7.795018088069700714737472099540242609719e-1), SC_(2.204981911930299285262527900459757390281e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(2.321049957275390625000000000000000000000e2), SC_(9.301750767960068360630999578646065790398e-1), SC_(6.982492320399316393690004213539342096024e-2) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(2.515153808593750000000000000000000000000e2), SC_(9.841331775973182298176072020465245180158e-1), SC_(1.586682240268177018239279795347548198425e-2) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(2.925695190429687500000000000000000000000e2), SC_(9.996867268835863391385460948609048928148e-1), SC_(3.132731164136608614539051390951071852451e-4) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(3.961445312500000000000000000000000000000e2), SC_(9.999999998176041497422688377219488552471e-1), SC_(1.823958502577311622780511447529402335781e-10) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(5.957914428710937500000000000000000000000e2), SC_(9.999999999999999999999999997179341260017e-1), SC_(2.820658739982830350139195992351387631503e-28) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(8.051638793945312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(5.925159684258756777000270044446852314010e-51) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(1.017672363281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.622045233361773816900199221330673188260e-77) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(2.074930381774902343750000000000000000000e1), SC_(5.038946396639433586268871435674179732270e-31), SC_(9.999999999999999999999999999994961053603e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(5.261367416381835937500000000000000000000e1), SC_(1.694868466603149775002210857167512879739e-16), SC_(9.999999999999998305131533396850224997789e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(1.054758682250976562500000000000000000000e2), SC_(1.583863082459474953610342318697401949105e-6), SC_(9.999984161369175405250463896576813025981e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(1.604049530029296875000000000000000000000e2), SC_(1.790620054154827744806784360489066687921e-2), SC_(9.820937994584517225519321563951093331208e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(1.935677185058593750000000000000000000000e2), SC_(2.175673990323038068363760565961357605471e-1), SC_(7.824326009676961931636239434038642394529e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(2.185590362548828125000000000000000000000e2), SC_(4.816723901809147938351072487088528548291e-1), SC_(5.183276098190852061648927512911471451709e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(2.215594482421875000000000000000000000000e2), SC_(5.104682167675189414431611740625757361102e-1), SC_(4.895317832324810585568388259374242638898e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(2.219109649658203125000000000000000000000e2), SC_(5.136644281246463031190947628696697743847e-1), SC_(4.863355718753536968809052371303302256153e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(2.219686126708984375000000000000000000000e2), SC_(5.139834086563725828851878522099740746666e-1), SC_(4.860165913436274171148121477900259253334e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(2.226037292480468750000000000000000000000e2), SC_(5.168512172201547295101778206084314747782e-1), SC_(4.831487827798452704898221793915685252218e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(2.275226745605468750000000000000000000000e2), SC_(5.455951443547406723347751375049656887717e-1), SC_(4.544048556452593276652248624950343112283e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(2.493764953613281250000000000000000000000e2), SC_(7.946373553711085280327930545927351336599e-1), SC_(2.053626446288914719672069454072648663401e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(2.724201965332031250000000000000000000000e2), SC_(9.422549900733338402013163760748528520783e-1), SC_(5.774500992666615979868362392514714792171e-2) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(2.981250305175781250000000000000000000000e2), SC_(9.893119052165937790951851188088083090789e-1), SC_(1.068809478340622090481488119119169092107e-2) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(3.482266540527343750000000000000000000000e2), SC_(9.998819863794169672736180652686400167023e-1), SC_(1.180136205830327263819347313599832976738e-4) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(4.736220092773437500000000000000000000000e2), SC_(9.999999999934462133329302701656873217519e-1), SC_(6.553786667069729834312678248103548239070e-12) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(7.140341186523437500000000000000000000000e2), SC_(9.999999999999999999999999999999919263938e-1), SC_(8.073606187230950918521472135960932714959e-33) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(9.739345092773437500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(5.030266853447122186341291881857212380000e-60) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(1.225002075195312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.039744730987896026269071914223389255437e-90) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(2.454723548889160156250000000000000000000e1), SC_(1.285333104881069084062862049947063529353e-34), SC_(9.999999999999999999999999999999998714667e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(6.228097152709960937500000000000000000000e1), SC_(1.590896037629155024661097038113636030007e-18), SC_(9.999999999999999984091039623708449753389e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(1.261848297119140625000000000000000000000e2), SC_(2.652303694639572676111845737463232116136e-7), SC_(9.999997347696305360427323888154262536768e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(1.903189697265625000000000000000000000000e2), SC_(1.193180854243100924454091630003998311850e-2), SC_(9.880681914575689907554590836999600168815e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(2.284439544677734375000000000000000000000e2), SC_(1.998443809910236396227307873702551491711e-1), SC_(8.001556190089763603772692126297448508289e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.516814880371093750000000000000000000000e2), SC_(4.787364930475245296575603451140086004218e-1), SC_(5.212635069524754703424396548859913995782e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(2.550476531982421875000000000000000000000e2), SC_(5.093146265701595441521336566309110610459e-1), SC_(4.906853734298404558478663433690889389541e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(2.558642272949218750000000000000000000000e2), SC_(5.126983390216422594670302594464652406473e-1), SC_(4.873016609783577405329697405535347593527e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(2.561244201660156250000000000000000000000e2), SC_(5.130326062651402791164735295312909042946e-1), SC_(4.869673937348597208835264704687090957054e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(2.567002563476562500000000000000000000000e2), SC_(5.160856638197900001343171227893704507929e-1), SC_(4.839143361802099998656828772106295492071e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(2.611326599121093750000000000000000000000e2), SC_(5.466053516114912309546166515527351165158e-1), SC_(4.533946483885087690453833484472648834842e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(2.869916381835937500000000000000000000000e2), SC_(8.076589936710173469358887423425521103973e-1), SC_(1.923410063289826530641112576574478896027e-1) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(3.133667602539062500000000000000000000000e2), SC_(9.522991792083310801457201447184481191179e-1), SC_(4.770082079166891985427985528155188088207e-2) }}, 
      {{ SC_(6.232524108886718750000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(3.401027221679687500000000000000000000000e2), SC_(9.925009354399721410469327028125635748208e-1), SC_(7.499064560027858953067297187436425179231e-3) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.288307800292968750000000000000000000000e2), SC_(9.980309030686217858114185761666784129312e-1), SC_(1.969096931378214188581423833321587068781e-3) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(1.825941314697265625000000000000000000000e2), SC_(9.999998835327314493294780285649570016646e-1), SC_(1.164672685506705219714350429983354422790e-7) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(2.754591369628906250000000000000000000000e2), SC_(9.999999999999999995252257835730682431494e-1), SC_(4.747742164269317568506087665531469464188e-19) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(3.682913208007812500000000000000000000000e2), SC_(9.999999999999999999999999999999859701791e-1), SC_(1.402982092691668786935903581993940948372e-32) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(4.708238525390625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.201558772563460457840515554435488956903e-47) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(1.043568515777587890625000000000000000000e1), SC_(4.280190495318426367349831100848450534302e-28), SC_(9.999999999999999999999999995719809504682e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(2.610964393615722656250000000000000000000e1), SC_(8.830907591640942863477831534378514618950e-14), SC_(9.999999999999116909240835905713652216847e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(5.345142364501953125000000000000000000000e1), SC_(2.430789956347992416250156051503942140546e-5), SC_(9.999756921004365200758374984394849605786e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(8.056755065917968750000000000000000000000e1), SC_(3.800766060785281237594796557375182163311e-2), SC_(9.619923393921471876240520344262481783669e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(9.897034454345703125000000000000000000000e1), SC_(2.600128589985640156552072016375851173269e-1), SC_(7.399871410014359843447927983624148826731e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(1.092245788574218750000000000000000000000e2), SC_(4.924085780060246862498171856172690612195e-1), SC_(5.075914219939753137501828143827309387805e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(1.119138717651367187500000000000000000000e2), SC_(5.163879747734731871738653740506993732932e-1), SC_(4.836120252265268128261346259493006267068e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(1.133077621459960937500000000000000000000e2), SC_(5.189771270924637094537918857034223560329e-1), SC_(4.810228729075362905462081142965776439671e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(1.147647705078125000000000000000000000000e2), SC_(5.191492537964310537440612324628296958109e-1), SC_(4.808507462035689462559387675371703041891e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(1.165695648193359375000000000000000000000e2), SC_(5.214605427772170810805547500606600694513e-1), SC_(4.785394572227829189194452499393399305487e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(1.203595123291015625000000000000000000000e2), SC_(5.455224191425514618504855392405918746270e-1), SC_(4.544775808574485381495144607594081253730e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(1.316738891601562500000000000000000000000e2), SC_(7.600536503913664023894797237901123938702e-1), SC_(2.399463496086335976105202762098876061298e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(1.471282653808593750000000000000000000000e2), SC_(9.093508903107626718524426242721323280126e-1), SC_(9.064910968923732814755737572786767198735e-2) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(1.655099639892578125000000000000000000000e2), SC_(9.744103917696970438794868909368470506975e-1), SC_(2.558960823030295612051310906315294930248e-2) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(1.937059478759765625000000000000000000000e2), SC_(9.989834119613775551096314918853312216705e-1), SC_(1.016588038622444890368508114668778329506e-3) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(2.806301879882812500000000000000000000000e2), SC_(9.999999941123894440770840792495679207441e-1), SC_(5.887610555922915920750432079255946999379e-9) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(4.218904418945312500000000000000000000000e2), SC_(9.999999999999999999999714917507838565510e-1), SC_(2.850824921614344903026192937245473779060e-23) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(5.773455200195312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.049450771319867069423962663612665681911e-41) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(7.265655517578125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.124282726362037123397067034927099482610e-61) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(1.465639019012451171875000000000000000000e1), SC_(2.969424979719447292838475583147541971924e-30), SC_(9.999999999999999999999999999970305750203e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(3.706014633178710937500000000000000000000e1), SC_(3.340514917111336453167199882107751447534e-15), SC_(9.999999999999966594850828886635468328001e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(7.417519378662109375000000000000000000000e1), SC_(6.920088253280068773997565892017911340265e-6), SC_(9.999930799117467199312260024341079820887e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.178919754028320312500000000000000000000e2), SC_(2.543874445528588941497168862048199850415e-2), SC_(9.745612555447141105850283113795180014958e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.470382995605468750000000000000000000000e2), SC_(2.341113075776360759439090084363798418964e-1), SC_(7.658886924223639240560909915636201581036e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.630314178466796875000000000000000000000e2), SC_(4.862013522129933942915226508606026000284e-1), SC_(5.137986477870066057084773491393973999716e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.691134643554687500000000000000000000000e2), SC_(5.127529863951958414493052737007792028953e-1), SC_(4.872470136048041585506947262992207971047e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(1.693480224609375000000000000000000000000e2), SC_(5.157442483495176385713257290547662161369e-1), SC_(4.842557516504823614286742709452337838631e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(1.799002227783203125000000000000000000000e2), SC_(5.155796299877717461488761173449553997848e-1), SC_(4.844203700122282538511238826550446002152e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(1.821876220703125000000000000000000000000e2), SC_(5.182503406022728654198445273588311827857e-1), SC_(4.817496593977271345801554726411688172143e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(1.848787841796875000000000000000000000000e2), SC_(5.457172707774207106656613556310004443296e-1), SC_(4.542827292225792893343386443689995556704e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(2.042293548583984375000000000000000000000e2), SC_(7.855936500696548355930179280120573294404e-1), SC_(2.144063499303451644069820719879426705596e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(2.331681671142578125000000000000000000000e2), SC_(9.369572086185195594527002133700744880746e-1), SC_(6.304279138148044054729978662992551192544e-2) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(2.526869812011718750000000000000000000000e2), SC_(9.868926257925613484640252680343054606994e-1), SC_(1.310737420743865153597473196569453930059e-2) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(3.171035156250000000000000000000000000000e2), SC_(9.998617061798344937356604697985825273232e-1), SC_(1.382938201655062643395302014174726767748e-4) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(4.257663269042968750000000000000000000000e2), SC_(9.999999999832203285734194155437142811465e-1), SC_(1.677967142658058445628571885347614751156e-11) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(6.480782470703125000000000000000000000000e2), SC_(9.999999999999999999999999999998471104550e-1), SC_(1.528895449658284315961996285289096979276e-31) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(8.643145141601562500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.262478263236416171807056144315596532289e-56) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(1.088257934570312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.551175707335824893925287275503605532145e-84) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(2.206775283813476562500000000000000000000e1), SC_(4.749833875399850116042030842198717799692e-36), SC_(9.999999999999999999999999999999999952502e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(5.530060195922851562500000000000000000000e1), SC_(1.525203377755430211165036462042002079807e-18), SC_(9.999999999999999984747966222445697888350e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(1.119481124877929687500000000000000000000e2), SC_(3.583737316568287818141330481336555091891e-7), SC_(9.999996416262683431712181858669518663445e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(1.696047973632812500000000000000000000000e2), SC_(1.313961450255911992228638225039391527826e-2), SC_(9.868603854974408800777136177496060847217e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(2.070884552001953125000000000000000000000e2), SC_(2.031156436596714928457012881122563317437e-1), SC_(7.968843563403285071542987118877436682563e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(2.307293548583984375000000000000000000000e2), SC_(4.796545029793801650326058557622496851792e-1), SC_(5.203454970206198349673941442377503148208e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(2.333234405517578125000000000000000000000e2), SC_(5.100018016762066197465070668853294831514e-1), SC_(4.899981983237933802534929331146705168486e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(2.364785308837890625000000000000000000000e2), SC_(5.132832943358944237051332052530107031801e-1), SC_(4.867167056641055762948667947469892968199e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(2.377042694091796875000000000000000000000e2), SC_(5.135876236640227872821098061538243830849e-1), SC_(4.864123763359772127178901938461756169151e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(2.436153411865234375000000000000000000000e2), SC_(5.165072570049228270752829439663681819953e-1), SC_(4.834927429950771729247170560336318180047e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(2.468303375244140625000000000000000000000e2), SC_(5.471333602311752087014096448788931285728e-1), SC_(4.528666397688247912985903551211068714272e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(2.689678344726562500000000000000000000000e2), SC_(8.076234264566991136211294244212894958678e-1), SC_(1.923765735433008863788705755787105041322e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(2.934620056152343750000000000000000000000e2), SC_(9.519631474917147995720021515022026150850e-1), SC_(4.803685250828520042799784849779738491496e-2) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(3.184825439453125000000000000000000000000e2), SC_(9.923420136746904934704935639846029860431e-1), SC_(7.657986325309506529506436015397013956891e-3) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(3.718128356933593750000000000000000000000e2), SC_(9.999457010529441763415588218310329350815e-1), SC_(5.429894705582365844117816896706491846521e-5) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(4.986223144531250000000000000000000000000e2), SC_(9.999999999992193800528407427714932654490e-1), SC_(7.806199471592572285067345509579718908751e-13) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(7.488662109375000000000000000000000000000e2), SC_(9.999999999999999999999999999999999767299e-1), SC_(2.327010682711910881053929715373106872619e-35) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(1.007728820800781250000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.950201228072119606002379609955949587004e-64) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(1.273781860351562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.208170970995738029583995337093159699020e-96) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(2.594162559509277343750000000000000000000e1), SC_(1.688395521503833789068759361593763341058e-39), SC_(9.999999999999999999999999999999999999983e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(6.515415954589843750000000000000000000000e1), SC_(1.602703372046666469568257776325420588866e-20), SC_(9.999999999999999999839729662795333353043e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(1.330444335937500000000000000000000000000e2), SC_(6.150396496883464588264202989491353637202e-8), SC_(9.999999384960350311653541173579701050865e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(2.007042388916015625000000000000000000000e2), SC_(8.739811624162855820154477195192312690337e-3), SC_(9.912601883758371441798455228048076873097e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(2.412698364257812500000000000000000000000e2), SC_(1.876221576052760654678492661466393820825e-1), SC_(8.123778423947239345321507338533606179175e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.690118408203125000000000000000000000000e2), SC_(4.765129704049313417348354377107014121798e-1), SC_(5.234870295950686582651645622892985878202e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(2.746999511718750000000000000000000000000e2), SC_(5.086972035858797653052336658874131000054e-1), SC_(4.913027964141202346947663341125868999946e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(2.763638916015625000000000000000000000000e2), SC_(5.122592394655786899177165064120933971728e-1), SC_(4.877407605344213100822834935879066028272e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(2.764595336914062500000000000000000000000e2), SC_(5.126179841238091056783387607753170890022e-1), SC_(4.873820158761908943216612392246829109978e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(2.771058349609375000000000000000000000000e2), SC_(5.158499378343805789973713291534771471321e-1), SC_(4.841500621656194210026286708465228528679e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(2.806872863769531250000000000000000000000e2), SC_(5.481090237914244557466666911577681511678e-1), SC_(4.518909762085755442533333088422318488322e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(3.063164367675781250000000000000000000000e2), SC_(8.192266747654469481523289204040560021897e-1), SC_(1.807733252345530518476710795959439978103e-1) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(3.344448547363281250000000000000000000000e2), SC_(9.600825940728992802225046903163809001928e-1), SC_(3.991740592710071977749530968361909980717e-2) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(3.627637939453125000000000000000000000000e2), SC_(9.946803095611177558222966089327019002376e-1), SC_(5.319690438882244177703391067298099762440e-3) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(4.217286376953125000000000000000000000000e2), SC_(9.999770184257361971426596113532871447095e-1), SC_(2.298157426380285734038864671285529050763e-5) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(5.670135498046875000000000000000000000000e2), SC_(9.999999999999573538590448031720137888630e-1), SC_(4.264614095519682798621113700313122013601e-14) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(8.512326049804687500000000000000000000000e2), SC_(9.999999999999999999999999999999999999971e-1), SC_(2.870855766462663788106725406817256447657e-39) }}, 
      {{ SC_(8.493049621582031250000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(1.136891113281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.878383654497795266992502241561603130172e-71) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.927322387695312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.998995258219082611120097022981279937784e-53) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(6.366568565368652343750000000000000000000), SC_(1.039563274383544921875000000000000000000e1), SC_(1.104397050593403851103101270776115243944e-31), SC_(9.999999999999999999999999999998895602949e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(6.889215946197509765625000000000000000000), SC_(2.611974143981933593750000000000000000000e1), SC_(2.317636651833409139915662153170459943853e-15), SC_(9.999999999999976823633481665908600843378e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(7.142335891723632812500000000000000000000), SC_(5.236604309082031250000000000000000000000e1), SC_(8.601167238251968265736252250117611246058e-6), SC_(9.999913988327617480317342637477498823888e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(9.234277725219726562500000000000000000000), SC_(8.011801910400390625000000000000000000000e1), SC_(3.037502304505311414655186542835214065259e-2), SC_(9.696249769549468858534481345716478593474e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.942635536193847656250000000000000000000e1), SC_(1.053144912719726562500000000000000000000e2), SC_(2.462754480046412675730770435602715982939e-1), SC_(7.537245519953587324269229564397284017061e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.950807952880859375000000000000000000000e1), SC_(1.159268569946289062500000000000000000000e2), SC_(4.900705004015661277222983807493998385811e-1), SC_(5.099294995984338722777016192506001614189e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(2.197235107421875000000000000000000000000e1), SC_(1.194425430297851562500000000000000000000e2), SC_(5.154398359442200740161734165331229321262e-1), SC_(4.845601640557799259838265834668770678738e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(2.249290275573730468750000000000000000000e1), SC_(1.200826568603515625000000000000000000000e2), SC_(5.182440213233354238767092131938503392568e-1), SC_(4.817559786766645761232907868061496607432e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(2.503655242919921875000000000000000000000e1), SC_(1.226385726928710937500000000000000000000e2), SC_(5.183943871658136575017637349963986138413e-1), SC_(4.816056128341863424982362650036013861587e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(2.539736366271972656250000000000000000000e1), SC_(1.231101074218750000000000000000000000000e2), SC_(5.209325434983156243008652045972961788362e-1), SC_(4.790674565016843756991347954027038211638e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(2.709540176391601562500000000000000000000e1), SC_(1.259319992065429687500000000000000000000e2), SC_(5.463361287024207221801128963807833171036e-1), SC_(4.536638712975792778198871036192166828964e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(2.837726783752441406250000000000000000000e1), SC_(1.385637207031250000000000000000000000000e2), SC_(7.702013910877171129941327198176563099597e-1), SC_(2.297986089122828870058672801823436900403e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(2.982279586791992187500000000000000000000e1), SC_(1.528950653076171875000000000000000000000e2), SC_(9.188969054390273213789425642134805720496e-1), SC_(8.110309456097267862105743578651942795041e-2) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(3.152261734008789062500000000000000000000e1), SC_(1.678460693359375000000000000000000000000e2), SC_(9.786219637644560824163081996495514436331e-1), SC_(2.137803623554391758369180035044855636687e-2) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(3.423733520507812500000000000000000000000e1), SC_(1.977406311035156250000000000000000000000e2), SC_(9.993270430307107581707154290577526298937e-1), SC_(6.729569692892418292845709422473701063174e-4) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(3.477303314208984375000000000000000000000e1), SC_(2.647255859375000000000000000000000000000e2), SC_(9.999999961195696478110966983165829063543e-1), SC_(3.880430352188903301683417093645684401969e-9) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(3.767639541625976562500000000000000000000e1), SC_(4.057984313964843750000000000000000000000e2), SC_(9.999999999999999999999921084777737176110e-1), SC_(7.891522226282389012461341677115468276880e-24) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(4.238486480712890625000000000000000000000e1), SC_(5.598984375000000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.566151757345437209661090406813896144509e-42) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(4.420680999755859375000000000000000000000e1), SC_(7.089828491210937500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(9.714627788909819185451019019627597279128e-63) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(5.538459396362304687500000000000000000000e1), SC_(1.529743480682373046875000000000000000000e1), SC_(1.490870163037275587663860638660711229475e-33), SC_(9.999999999999999999999999999999985091298e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(5.569964599609375000000000000000000000000e1), SC_(3.832234954833984375000000000000000000000e1), SC_(1.428744789171451979271870759552141612362e-16), SC_(9.999999999999998571255210828548020728129e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(5.940588760375976562500000000000000000000e1), SC_(7.849781799316406250000000000000000000000e1), SC_(2.442427150885103600117560297939299973408e-6), SC_(9.999975575728491148963998824397020607000e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(6.038262176513671875000000000000000000000e1), SC_(1.184792861938476562500000000000000000000e2), SC_(2.180949685896357168308958393775773143669e-2), SC_(9.781905031410364283169104160622422685633e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(6.163340759277343750000000000000000000000e1), SC_(1.433008422851562500000000000000000000000e2), SC_(2.293613439882603338154340669623584963290e-1), SC_(7.706386560117396661845659330376415036710e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(6.331008529663085937500000000000000000000e1), SC_(1.592908477783203125000000000000000000000e2), SC_(4.857473542471996584369919504210248335245e-1), SC_(5.142526457528003415630080495789751664755e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(6.341989517211914062500000000000000000000e1), SC_(1.608486328125000000000000000000000000000e2), SC_(5.130840280351654611190013015301166460120e-1), SC_(4.869159719648345388809986984698833539880e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(7.225879669189453125000000000000000000000e1), SC_(1.698485412597656250000000000000000000000e2), SC_(5.157043720771799857163753315931181666595e-1), SC_(4.842956279228200142836246684068818333405e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(7.844540405273437500000000000000000000000e1), SC_(1.760527648925781250000000000000000000000e2), SC_(5.157442724777002505985255185196691539471e-1), SC_(4.842557275222997494014744814803308460529e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(7.974770355224609375000000000000000000000e1), SC_(1.775148162841796875000000000000000000000e2), SC_(5.184915716375086676308397782599951165170e-1), SC_(4.815084283624913323691602217400048834830e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(8.435225677490234375000000000000000000000e1), SC_(1.837614288330078125000000000000000000000e2), SC_(5.464126735107658031967243512649472721203e-1), SC_(4.535873264892341968032756487350527278797e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(8.441753387451171875000000000000000000000e1), SC_(2.002080230712890625000000000000000000000e2), SC_(7.891405601209304302131886390600026709253e-1), SC_(2.108594398790695697868113609399973290747e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(9.495173645019531250000000000000000000000e1), SC_(2.310497894287109375000000000000000000000e2), SC_(9.401039112777915385400381673132969325594e-1), SC_(5.989608872220846145996183268670306744061e-2) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(9.707512664794921875000000000000000000000e1), SC_(2.530643463134765625000000000000000000000e2), SC_(9.883244354782702529255727822673038759931e-1), SC_(1.167556452172974707442721773269612400686e-2) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(9.811781311035156250000000000000000000000e1), SC_(2.935613403320312500000000000000000000000e2), SC_(9.998398478245514514658752773113342633153e-1), SC_(1.601521754485485341247226886657366846810e-4) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.007325439453125000000000000000000000000e2), SC_(3.966445922851562500000000000000000000000e2), SC_(9.999999999724768165922584189163666848087e-1), SC_(2.752318340774158108363331519130063846728e-11) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.093762969970703125000000000000000000000e2), SC_(6.208981323242187500000000000000000000000e2), SC_(9.999999999999999999999999999997408021734e-1), SC_(2.591978266334164961853664263585612659771e-31) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.094441146850585937500000000000000000000e2), SC_(8.281354980468750000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.294891005852857250618437598962830058232e-55) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.264718551635742187500000000000000000000e2), SC_(1.120308105468750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.819455803196709095963354653504503559863e-88) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.279526672363281250000000000000000000000e2), SC_(2.255424308776855468750000000000000000000e1), SC_(8.539454060860415835906357466920645127127e-39), SC_(9.999999999999999999999999999999999999915e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.310955810546875000000000000000000000000e2), SC_(5.717133331298828125000000000000000000000e1), SC_(8.072984344852486780588405000798570188469e-20), SC_(9.999999999999999999192701565514751321941e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.311481323242187500000000000000000000000e2), SC_(1.143689422607421875000000000000000000000e2), SC_(1.662785669195874592227020413391880314813e-7), SC_(9.999998337214330804125407772979586608120e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.327210998535156250000000000000000000000e2), SC_(1.727331390380859375000000000000000000000e2), SC_(1.127633362215814354723844114520096310097e-2), SC_(9.887236663778418564527615588547990368990e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.357470245361328125000000000000000000000e2), SC_(2.100030975341796875000000000000000000000e2), SC_(1.974665772776847846347863296925803771300e-1), SC_(8.025334227223152153652136703074196228700e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.362719116210937500000000000000000000000e2), SC_(2.315230560302734375000000000000000000000e2), SC_(4.790325681815479613456875191144524291039e-1), SC_(5.209674318184520386543124808855475708961e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.389657287597656250000000000000000000000e2), SC_(2.363189239501953125000000000000000000000e2), SC_(5.098632011983016239552733542543261789121e-1), SC_(4.901367988016983760447266457456738210879e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.412092285156250000000000000000000000000e2), SC_(2.387989807128906250000000000000000000000e2), SC_(5.132394681821740634645869936806266522986e-1), SC_(4.867605318178259365354130063193733477014e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.451677856445312500000000000000000000000e2), SC_(2.427818145751953125000000000000000000000e2), SC_(5.134758241441685163494947156675326026913e-1), SC_(4.865241758558314836505052843324673973087e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.481294555664062500000000000000000000000e2), SC_(2.459649353027343750000000000000000000000e2), SC_(5.165340258078720928283597222461131331629e-1), SC_(4.834659741921279071716402777538868668371e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.486264953613281250000000000000000000000e2), SC_(2.486784057617187500000000000000000000000e2), SC_(5.477482892782370312550092137300571667279e-1), SC_(4.522517107217629687449907862699428332721e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.515480346679687500000000000000000000000e2), SC_(2.740515747070312500000000000000000000000e2), SC_(8.127413900819276172148797653174312810996e-1), SC_(1.872586099180723827851202346825687189004e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.527500000000000000000000000000000000000e2), SC_(3.004077148437500000000000000000000000000e2), SC_(9.557684287200725320105500482990158379016e-1), SC_(4.423157127992746798944995170098416209837e-2) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.584414672851562500000000000000000000000e2), SC_(3.328405761718750000000000000000000000000e2), SC_(9.938151102493476576472529999237972415465e-1), SC_(6.184889750652342352747000076202758453517e-3) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.594559783935546875000000000000000000000e2), SC_(3.855685729980468750000000000000000000000e2), SC_(9.999654603658833660890314428772691789795e-1), SC_(3.453963411663391096855712273082102047358e-5) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.595857238769531250000000000000000000000e2), SC_(5.143509521484375000000000000000000000000e2), SC_(9.999999999997862081213396985426669159505e-1), SC_(2.137918786603014573330840494670797288122e-13) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.596211700439453125000000000000000000000e2), SC_(7.716328125000000000000000000000000000000e2), SC_(9.999999999999999999999999999999999993910e-1), SC_(6.090137528690012276401850866234401943342e-37) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.600560913085937500000000000000000000000e2), SC_(1.030583374023437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.148358909221477565435321929273544003356e-66) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.629447326660156250000000000000000000000e2), SC_(1.302672363281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.551196553623045002935487043541298096600e-100) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.643806610107421875000000000000000000000e2), SC_(2.619704055786132812500000000000000000000e1), SC_(6.808064806812399361947337235644148415808e-42), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.646915740966796875000000000000000000000e2), SC_(6.557032775878906250000000000000000000000e1), SC_(1.874939420887980021183940060082776358488e-21), SC_(9.999999999999999999981250605791120199788e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.670017089843750000000000000000000000000e2), SC_(1.322957305908203125000000000000000000000e2), SC_(3.862886778014135580670424330170302966462e-8), SC_(9.999999613711322198586441932957566982970e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.698258666992187500000000000000000000000e2), SC_(2.005617065429687500000000000000000000000e2), SC_(7.895809122576224528059744011312045619022e-3), SC_(9.921041908774237754719402559886879543810e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.744857635498046875000000000000000000000e2), SC_(2.448679504394531250000000000000000000000e2), SC_(1.825078544198161108555554932281404513874e-1), SC_(8.174921455801838891444445067718595486126e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.756861267089843750000000000000000000000e2), SC_(2.705431213378906250000000000000000000000e2), SC_(4.759132523364918535866240336496937635467e-1), SC_(5.240867476635081464133759663503062364533e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.811583862304687500000000000000000000000e2), SC_(2.784693908691406250000000000000000000000e2), SC_(5.085657492840818322414425386894059023833e-1), SC_(4.914342507159181677585574613105940976167e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.826751708984375000000000000000000000000e2), SC_(2.802649230957031250000000000000000000000e2), SC_(5.121953841751896623216142855605259460256e-1), SC_(4.878046158248103376783857144394740539744e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.831471099853515625000000000000000000000e2), SC_(2.807649536132812500000000000000000000000e2), SC_(5.125523055813089793863034115220654756112e-1), SC_(4.874476944186910206136965884779345243888e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.867986450195312500000000000000000000000e2), SC_(2.846727905273437500000000000000000000000e2), SC_(5.157939693139686252070437253167651951056e-1), SC_(4.842060306860313747929562746832348048944e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.900444183349609375000000000000000000000e2), SC_(2.905104980468750000000000000000000000000e2), SC_(5.489068334240575417493613458492406183057e-1), SC_(4.510931665759424582506386541507593816943e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.914333953857421875000000000000000000000e2), SC_(3.179254455566406250000000000000000000000e2), SC_(8.256236741516348775374969719914357136398e-1), SC_(1.743763258483651224625030280085642863602e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.915013732910156250000000000000000000000e2), SC_(3.469093627929687500000000000000000000000e2), SC_(9.640083872796000822694492547251727135656e-1), SC_(3.599161272039991773055074527482728643442e-2) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.918984832763671875000000000000000000000e2), SC_(3.763346862792968750000000000000000000000e2), SC_(9.956524400993372319033875001986615114617e-1), SC_(4.347559900662768096612499801338488538268e-3) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.929777069091796875000000000000000000000e2), SC_(4.358511657714843750000000000000000000000e2), SC_(9.999853255149685843840441229267522681735e-1), SC_(1.467448503141561595587707324773182654363e-5) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.935389862060546875000000000000000000000e2), SC_(5.822574462890625000000000000000000000000e2), SC_(9.999999999999877612604703560567486432691e-1), SC_(1.223873952964394325135673089449286588146e-14) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.937735595703125000000000000000000000000e2), SC_(8.740899658203125000000000000000000000000e2), SC_(9.999999999999999999999999999999999999999e-1), SC_(7.940935397864044104644987120247050006147e-41) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.941185607910156250000000000000000000000e2), SC_(1.166833251953125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.812470508617244277100126524096127002956e-73) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.962219390869140625000000000000000000000e2), SC_(1.469058593750000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.720757501425070060339054557524843076565e-111) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.985762634277343750000000000000000000000e2), SC_(2.961660194396972656250000000000000000000e1), SC_(6.004544894880326541661138090121905640572e-45), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.988137054443359375000000000000000000000e2), SC_(7.410086059570312500000000000000000000000e1), SC_(3.623834880220112075441758904493022968097e-23), SC_(9.999999999999999999999637616511977988792e-1) }}, 
      {{ SC_(9.758975219726562500000000000000000000000e1), SC_(1.992922668457031250000000000000000000000e2), SC_(1.484410095214843750000000000000000000000e2), SC_(1.008741232308076218627214138705344465581e-8), SC_(9.999999899125876769192378137278586129466e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(7.663918304443359375000000000000000000000e1), SC_(2.837582689296021068501127469995083878991e-2), SC_(9.716241731070397893149887253000491612101e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(9.683590698242187500000000000000000000000e1), SC_(2.448530814652795630263353694699575845015e-1), SC_(7.551469185347204369736646305300424154985e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.070369186401367187500000000000000000000e2), SC_(4.900799697780332074355379015831066670023e-1), SC_(5.099200302219667925644620984168933329977e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.082628479003906250000000000000000000000e2), SC_(5.157425522010756905030077879361018519967e-1), SC_(4.842574477989243094969922120638981480033e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.104631576538085937500000000000000000000e2), SC_(5.185199368893563544145021540944818715771e-1), SC_(4.814800631106436455854978459055181284229e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.206673049926757812500000000000000000000e2), SC_(5.183880701299398176051338900059000177245e-1), SC_(4.816119298700601823948661099940999822755e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.208577041625976562500000000000000000000e2), SC_(5.209668183352677169292968012302927896502e-1), SC_(4.790331816647322830707031987697072103498e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.244332427978515625000000000000000000000e2), SC_(5.466087056418140120054380813537924930304e-1), SC_(4.533912943581859879945619186462075069696e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.360939636230468750000000000000000000000e2), SC_(7.720835394629515290069916242296521959224e-1), SC_(2.279164605370484709930083757703478040776e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(1.515185241699218750000000000000000000000e2), SC_(9.208561379511900422973886313899537619170e-1), SC_(7.914386204880995770261136861004623808302e-2) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.646141052246093750000000000000000000000e2), SC_(9.793546410974441458702498208247790028172e-1), SC_(2.064535890255585412975017917522099718275e-2) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.924864196777343750000000000000000000000e2), SC_(9.993608909362510487341079386235115236294e-1), SC_(6.391090637489512658920613764884763706247e-4) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.592123107910156250000000000000000000000e2), SC_(9.999999966811687402038308783202864510279e-1), SC_(3.318831259796169121679713548972102104645e-9) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(3.931550292968750000000000000000000000000e2), SC_(9.999999999999999999999918502046549230544e-1), SC_(8.149795345076945638270926142566043513534e-24) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(5.310059814453125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.253474452798511672196760705632872805814e-41) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(6.773310546875000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(9.056533364159983973387837649303297378651e-62) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.360019207000732421875000000000000000000e1), SC_(1.363831386791331545128333059865096206109e-33), SC_(9.999999999999999999999999999999986361686e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(3.472631835937500000000000000000000000000e1), SC_(1.792894689984824263975650645258384461988e-16), SC_(9.999999999999998207105310015175736024349e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(7.180686950683593750000000000000000000000e1), SC_(2.926295689806563164435143023061477344011e-6), SC_(9.999970737043101934368355648569769385227e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.090767745971679687500000000000000000000e2), SC_(2.297903132736454985438511757631315054529e-2), SC_(9.770209686726354501456148824236868494547e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(1.409521331787109375000000000000000000000e2), SC_(2.284148748943714387808073344356192770267e-1), SC_(7.715851251056285612191926655643807229733e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(1.553592376708984375000000000000000000000e2), SC_(4.858676067190296160305042981482538017503e-1), SC_(5.141323932809703839694957018517461982497e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.604741363525390625000000000000000000000e2), SC_(5.130606775967251820119768829679095467386e-1), SC_(4.869393224032748179880231170320904532614e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(1.616115112304687500000000000000000000000e2), SC_(5.160662467898213684342866171785632666510e-1), SC_(4.839337532101786315657133828214367333490e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(1.628785858154296875000000000000000000000e2), SC_(5.163145296080495830348925270023210092429e-1), SC_(4.836854703919504169651074729976789907571e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(1.647035217285156250000000000000000000000e2), SC_(5.189999481011707403135630765982884430195e-1), SC_(4.810000518988292596864369234017115569805e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(1.662952575683593750000000000000000000000e2), SC_(5.464584650820156351319625530575974343904e-1), SC_(4.535415349179843648680374469424025656096e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(1.908364410400390625000000000000000000000e2), SC_(7.876377854769387710969544801475081179973e-1), SC_(2.123622145230612289030455198524918820027e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.156091461181640625000000000000000000000e2), SC_(9.372882957553841637985510565321565597255e-1), SC_(6.271170424461583620144894346784344027450e-2) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.352695617675781250000000000000000000000e2), SC_(9.870856315065940351153752980456403228742e-1), SC_(1.291436849340596488462470195435967712584e-2) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.783717041015625000000000000000000000000e2), SC_(9.998109253498527631754141677518590046258e-1), SC_(1.890746501472368245858322481409953742339e-4) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(3.712928466796875000000000000000000000000e2), SC_(9.999999999395311318067011595118849640002e-1), SC_(6.046886819329884048811503599976660298072e-11) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.885418701171875000000000000000000000000e2), SC_(9.999999999999999999999999999977530134217e-1), SC_(2.246986578287609016129533723280098383066e-30) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(7.932160644531250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.225652730011671131144660346055782615532e-54) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(9.967334594726562500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.779757000652485520370261346730306306548e-81) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.019614219665527343750000000000000000000e1), SC_(1.177910840421154858648882054356475705512e-37), SC_(9.999999999999999999999999999999999998822e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.265129470825195312500000000000000000000e1), SC_(2.935303511262723875160743174680651779445e-19), SC_(9.999999999999999997064696488737276124839e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(1.053365020751953125000000000000000000000e2), SC_(2.842755506364667287954244237417033287308e-7), SC_(9.999997157244493635332712045755762582967e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(1.707755584716796875000000000000000000000e2), SC_(1.117513585618008084315862762318596579827e-2), SC_(9.888248641438199191568413723768140342017e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.062633819580078125000000000000000000000e2), SC_(1.978651482024546643318914219516082305949e-1), SC_(8.021348517975453356681085780483917694051e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(2.300012207031250000000000000000000000000e2), SC_(4.789931542685349311898236377683414907850e-1), SC_(5.210068457314650688101763622316585092150e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(2.321446380615234375000000000000000000000e2), SC_(5.099947766269143641599100058071126416685e-1), SC_(4.900052233730856358400899941928873583315e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(2.339499816894531250000000000000000000000e2), SC_(5.133835259964053593777954609287901529831e-1), SC_(4.866164740035946406222045390712098470169e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.369996032714843750000000000000000000000e2), SC_(5.136419600871698503085646316157011581913e-1), SC_(4.863580399128301496914353683842988418087e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(2.377383117675781250000000000000000000000e2), SC_(5.167406145321605813739329518088430036959e-1), SC_(4.832593854678394186260670481911569963041e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(2.425965576171875000000000000000000000000e2), SC_(5.477624153161662297934473320023437587770e-1), SC_(4.522375846838337702065526679976562412230e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(2.666819152832031250000000000000000000000e2), SC_(8.115404305294876347683221089750422101751e-1), SC_(1.884595694705123652316778910249577898249e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(2.956760253906250000000000000000000000000e2), SC_(9.555227773797212209130870735899551807973e-1), SC_(4.447722262027877908691292641004481920274e-2) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.241658325195312500000000000000000000000e2), SC_(9.935556033053315758902860407469955033769e-1), SC_(6.444396694668424109713959253004496623094e-3) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.747830810546875000000000000000000000000e2), SC_(9.999611656259587138961950681358759745194e-1), SC_(3.883437404128610380493186412402548055017e-5) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.055538330078125000000000000000000000000e2), SC_(9.999999999997441765592168630029839350856e-1), SC_(2.558234407831369970160649143634929782220e-13) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(7.619366455078125000000000000000000000000e2), SC_(9.999999999999999999999999999999999991367e-1), SC_(8.633152292195036323906810115448562970348e-37) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(1.038681396484375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.229026264363069372324066840929333864370e-67) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(1.303424316406250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.904248619152200985936805765864774703098e-100) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(2.608146095275878906250000000000000000000e1), SC_(1.932926146179872150140569060004002671727e-42), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(6.521250915527343750000000000000000000000e1), SC_(1.229334216843736642000501818828481042764e-21), SC_(9.999999999999999999987706657831562633580e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(1.306424865722656250000000000000000000000e2), SC_(3.776537702615832635975415402696686352214e-8), SC_(9.999999622346229738416736402458459730331e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(1.981302185058593750000000000000000000000e2), SC_(7.898038240720302189722742669652301998835e-3), SC_(9.921019617592796978102772573303476980012e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(2.390485992431640625000000000000000000000e2), SC_(1.838332897224847685548154609744920774216e-1), SC_(8.161667102775152314451845390255079225784e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(2.632612609863281250000000000000000000000e2), SC_(4.763256692071146057704057892463701556220e-1), SC_(5.236743307928853942295942107536298443780e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(2.679623718261718750000000000000000000000e2), SC_(5.088558009978913420170350171647872778295e-1), SC_(4.911441990021086579829649828352127221705e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(2.710547485351562500000000000000000000000e2), SC_(5.124126892334962159651882474936143781879e-1), SC_(4.875873107665037840348117525063856218121e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(2.757422485351562500000000000000000000000e2), SC_(5.126710444976534004022008912918319473401e-1), SC_(4.873289555023465995977991087081680526599e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(2.771919250488281250000000000000000000000e2), SC_(5.159429009577238308158715174837244003339e-1), SC_(4.840570990422761691841284825162755996661e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(2.852111511230468750000000000000000000000e2), SC_(5.489018089183053977203003706557071898758e-1), SC_(4.510981910816946022796996293442928101242e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.122944641113281250000000000000000000000e2), SC_(8.249090361567005096543241814760099288439e-1), SC_(1.750909638432994903456758185239900711561e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.412511901855468750000000000000000000000e2), SC_(9.636121520860563339788412912917442043166e-1), SC_(3.638784791394366602115870870825579568340e-2) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.744357604980468750000000000000000000000e2), SC_(9.957015571952256997182518967326654284099e-1), SC_(4.298442804774300281748103267334571590099e-3) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(4.369099731445312500000000000000000000000e2), SC_(9.999864368605267808100801422041181731367e-1), SC_(1.356313947321918991985779588182686333625e-5) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.853245849609375000000000000000000000000e2), SC_(9.999999999999909944210488298681777236143e-1), SC_(9.005578951170131822276385657680500316960e-15) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(8.781907958984375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.482800634215070591266059048573868559240e-41) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.172509521484375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.181329752207514360857087748637998197060e-74) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(1.471032958984375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.475212793922116639772271462455302209361e-111) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(2.947678947448730468750000000000000000000e1), SC_(1.965410192206069544447373983548406709249e-45), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(7.375061035156250000000000000000000000000e1), SC_(2.458090206466822700153980376486111047421e-23), SC_(9.999999999999999999999754190979353317730e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(1.476737213134765625000000000000000000000e2), SC_(9.259687273176735020287803486770344345170e-9), SC_(9.999999907403127268232649797121965132297e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(2.230881042480468750000000000000000000000e2), SC_(5.732861023021250528578777593710228450701e-3), SC_(9.942671389769787494714212224062897715493e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(2.698246154785156250000000000000000000000e2), SC_(1.716831518929250353778052758379431172748e-1), SC_(8.283168481070749646221947241620568827252e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(2.970421752929687500000000000000000000000e2), SC_(4.738256768058942501866389441167373148342e-1), SC_(5.261743231941057498133610558832626851658e-1) }}, 
      {{ SC_(1.012288818359375000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.002206420898437500000000000000000000000e2), SC_(5.079823053463424108241198654090730566458e-1), SC_(4.920176946536575891758801345909269433542e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.107861099243164062500000000000000000000e2), SC_(5.179448023728523806717555758441805121571e-1), SC_(4.820551976271476193282444241558194878429e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.162076034545898437500000000000000000000e2), SC_(5.181682348008028360629585641034480524457e-1), SC_(4.818317651991971639370414358965519475543e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.168353500366210937500000000000000000000e2), SC_(5.208165963470069965773204591537593735217e-1), SC_(4.791834036529930034226795408462406264783e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.181414642333984375000000000000000000000e2), SC_(5.472550660609063315237751080829713950231e-1), SC_(4.527449339390936684762248919170286049769e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.309700622558593750000000000000000000000e2), SC_(7.776309283678508715655242529814721402440e-1), SC_(2.223690716321491284344757470185278597560e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.551069335937500000000000000000000000000e2), SC_(9.269958328485108284346322304954482515323e-1), SC_(7.300416715148917156536776950455174846766e-2) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.681387329101562500000000000000000000000e2), SC_(9.822368076747498166252949659822691395975e-1), SC_(1.776319232525018337470503401773086040250e-2) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.977026367187500000000000000000000000000e2), SC_(9.995484432491671086570996712626831375374e-1), SC_(4.515567508328913429003287373168624625573e-4) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.646446228027343750000000000000000000000e2), SC_(9.999999987677483670160557292012559474237e-1), SC_(1.232251632983944270798744052576333414035e-9) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(4.045979003906250000000000000000000000000e2), SC_(9.999999999999999999999995397888271693926e-1), SC_(4.602111728306074262753239893922995980293e-25) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(5.409071044921875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.470329714562060789243799824644161527671e-43) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(6.846240844726562500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.184352418269938157817670185083878916545e-64) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.382066822052001953125000000000000000000e1), SC_(6.143184852961594386086348913692271574484e-36), SC_(9.999999999999999999999999999999999938568e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(3.491305160522460937500000000000000000000e1), SC_(1.923824481784932809890708692641145394489e-17), SC_(9.999999999999999807617551821506719010929e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(7.067601776123046875000000000000000000000e1), SC_(1.681126657671775231150939750049467285581e-6), SC_(9.999983188733423282247688490602499505327e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.080500564575195312500000000000000000000e2), SC_(2.049410718204816615492487733183271671107e-2), SC_(9.795058928179518338450751226681672832889e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.301421966552734375000000000000000000000e2), SC_(2.275872002930157977446116902741353660649e-1), SC_(7.724127997069842022553883097258646339351e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.460307617187500000000000000000000000000e2), SC_(4.859963348734574438969151924275481298596e-1), SC_(5.140036651265425561030848075724518701404e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.520620727539062500000000000000000000000e2), SC_(5.133527714021262684879857061839808908828e-1), SC_(4.866472285978737315120142938160191091172e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.540362243652343750000000000000000000000e2), SC_(5.163448579301690455570643866669106371598e-1), SC_(4.836551420698309544429356133330893628402e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(1.652305297851562500000000000000000000000e2), SC_(5.161639035767327276650678712423922633791e-1), SC_(4.838360964232672723349321287576077366209e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(1.656945953369140625000000000000000000000e2), SC_(5.189699884595737225353930579227668939319e-1), SC_(4.810300115404262774646069420772331060681e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.709276580810546875000000000000000000000e2), SC_(5.470219193648170366468120902203428750892e-1), SC_(4.529780806351829633531879097796571249108e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(1.872332458496093750000000000000000000000e2), SC_(7.904199900689241561605960105445857814287e-1), SC_(2.095800099310758438394039894554142185713e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.057554016113281250000000000000000000000e2), SC_(9.379200513069084449788127386619401780557e-1), SC_(6.207994869309155502118726133805982194427e-2) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.250813293457031250000000000000000000000e2), SC_(9.873100739550104135768184580120695815897e-1), SC_(1.268992604498958642318154198793041841027e-2) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.598739624023437500000000000000000000000e2), SC_(9.997950968799245053433006628898152653966e-1), SC_(2.049031200754946566993371101847346034000e-4) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(3.641764221191406250000000000000000000000e2), SC_(9.999999999549650327643766336300256791981e-1), SC_(4.503496723562336636997432080189903710513e-11) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.648244628906250000000000000000000000000e2), SC_(9.999999999999999999999999999962342595531e-1), SC_(3.765740446935804529985530571359477955693e-30) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(7.583084716796875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.785645368968494125758460383291514799578e-53) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(9.709083251953125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.266737912427280217128804000384075237530e-80) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(1.942469596862792968750000000000000000000e1), SC_(6.239526179316262480121565662604139328113e-39), SC_(9.999999999999999999999999999999999999938e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.119528961181640625000000000000000000000e1), SC_(1.034805208704070788983558520824762752570e-19), SC_(9.999999999999999998965194791295929211016e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(1.034522705078125000000000000000000000000e2), SC_(2.103044063513030227650406910365005498886e-7), SC_(9.999997896955936486969772349593089634995e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(1.559604187011718750000000000000000000000e2), SC_(1.230260494296858220072764301030238154520e-2), SC_(9.876973950570314177992723569896976184548e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(1.895057525634765625000000000000000000000e2), SC_(2.020093470658086062786803082151163929953e-1), SC_(7.979906529341913937213196917848836070047e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.170136566162109375000000000000000000000e2), SC_(4.796604388999859212415169866453056343513e-1), SC_(5.203395611000140787584830133546943656487e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.190542602539062500000000000000000000000e2), SC_(5.104257873948622682787332826178559665589e-1), SC_(4.895742126051377317212667173821440334411e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.363012695312500000000000000000000000000e2), SC_(5.133232885928881472606134990354545394301e-1), SC_(4.866767114071118527393865009645454605699e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.378058624267578125000000000000000000000e2), SC_(5.136315620091057379599682797093070743835e-1), SC_(4.863684379908942620400317202906929256165e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(2.411659240722656250000000000000000000000e2), SC_(5.167107278124064103498494173142303047169e-1), SC_(4.832892721875935896501505826857696952831e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(2.433873138427734375000000000000000000000e2), SC_(5.481861029583497515926210524291149704781e-1), SC_(4.518138970416502484073789475708850295219e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(2.668055725097656250000000000000000000000e2), SC_(8.141205773774077839364004149348717820666e-1), SC_(1.858794226225922160635995850651282179334e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.946917419433593750000000000000000000000e2), SC_(9.569743395443468744140097640697601971334e-1), SC_(4.302566045565312558599023593023980286665e-2) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.199317016601562500000000000000000000000e2), SC_(9.937897594918712048169069141706620017733e-1), SC_(6.210240508128795183093085829337998226737e-3) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.731926879882812500000000000000000000000e2), SC_(9.999659913272270967396947552964180485525e-1), SC_(3.400867277290326030524470358195144747605e-5) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(5.020772705078125000000000000000000000000e2), SC_(9.999999999998135793146726073646841660526e-1), SC_(1.864206853273926353158339473752534891161e-13) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(7.649915771484375000000000000000000000000e2), SC_(9.999999999999999999999999999999999997998e-1), SC_(2.002356406614401335285098377093326753269e-37) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(1.031835449218750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.679033588172113495588949609312255446310e-67) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(1.292279541015625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.488355348886929008005299588924807489615e-101) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(2.613774490356445312500000000000000000000e1), SC_(4.601708584387757520647064508438916674113e-44), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(6.564485168457031250000000000000000000000e1), SC_(2.442182230714361095973128363501214022261e-22), SC_(9.999999999999999999997557817769285638904e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(1.341354370117187500000000000000000000000e2), SC_(1.937423675369722287129956868587013100534e-8), SC_(9.999999806257632463027771287004313141299e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(2.019640502929687500000000000000000000000e2), SC_(6.979336683866140200194094112512579395504e-3), SC_(9.930206633161338597998059058874874206045e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(2.424736175537109375000000000000000000000e2), SC_(1.798885817548290366211479368740076406265e-1), SC_(8.201114182451709633788520631259923593735e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(2.667561035156250000000000000000000000000e2), SC_(4.757056918082723321841898900543431303679e-1), SC_(5.242943081917276678158101099456568696321e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(2.696156311035156250000000000000000000000e2), SC_(5.087836682859000691134232422925733839667e-1), SC_(4.912163317140999308865767577074266160333e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(2.727741394042968750000000000000000000000e2), SC_(5.123845880365167966842914620191526411524e-1), SC_(4.876154119634832033157085379808473588476e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(2.742375183105468750000000000000000000000e2), SC_(5.127206594610382081445092233893119075475e-1), SC_(4.872793405389617918554907766106880924525e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(2.747955322265625000000000000000000000000e2), SC_(5.160337026699842568637520093625007476499e-1), SC_(4.839662973300157431362479906374992523501e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(2.795994262695312500000000000000000000000e2), SC_(5.491048207831745897267388383015915167306e-1), SC_(4.508951792168254102732611616984084832694e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.076208190917968750000000000000000000000e2), SC_(8.257398664158895989440110379492939737898e-1), SC_(1.742601335841104010559889620507060262102e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.411782226562500000000000000000000000000e2), SC_(9.648265554778764665401279485307504332576e-1), SC_(3.517344452212353345987205146924956674243e-2) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.711701660156250000000000000000000000000e2), SC_(9.958649184958937955987531007354229496767e-1), SC_(4.135081504106204401246899264577050323337e-3) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.364816894531250000000000000000000000000e2), SC_(9.999882044937201894291519028155655035852e-1), SC_(1.179550627981057084809718443449641479524e-5) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.850091552734375000000000000000000000000e2), SC_(9.999999999999940543281557310108944850848e-1), SC_(5.945671844268989105514915210830038347469e-15) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(8.789295654296875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.061186343211241262056437693599164199555e-41) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(1.186512207031250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.178729321979657366642127834731343685749e-75) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(1.499369140625000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.693977917243021439589459639831144540696e-114) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.012628173828125000000000000000000000000e1), SC_(1.725811143865098792124876451479166746672e-47), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(7.533269500732421875000000000000000000000e1), SC_(3.122780763580911776339677775787226359192e-24), SC_(9.999999999999999999999968772192364190882e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.508639526367187500000000000000000000000e2), SC_(4.952213406295185115967611588793426512377e-9), SC_(9.999999950477865937048148840323884112066e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(2.271053466796875000000000000000000000000e2), SC_(5.075245246785867141675194999557664225596e-3), SC_(9.949247547532141328583248050004423357744e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(2.730315551757812500000000000000000000000e2), SC_(1.682685427938004249209349062453758787372e-1), SC_(8.317314572061995750790650937546241212628e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.005669250488281250000000000000000000000e2), SC_(4.732589094888298364649082215140134719333e-1), SC_(5.267410905111701635350917784859865280667e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.036440124511718750000000000000000000000e2), SC_(5.078766655412643451717560865313850084480e-1), SC_(4.921233344587356548282439134686149915520e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.060513610839843750000000000000000000000e2), SC_(5.116747645613167633423787644920065288384e-1), SC_(4.883252354386832366576212355079934711616e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.084365234375000000000000000000000000000e2), SC_(5.120147874194457972604057291904095924643e-1), SC_(4.879852125805542027395942708095904075357e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.089517822265625000000000000000000000000e2), SC_(5.154835319444264427962524571896828228375e-1), SC_(4.845164680555735572037475428103171771625e-1) }}, 
      {{ SC_(1.098294143676757812500000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.122128906250000000000000000000000000000e2), SC_(5.500242260514656922519333753926978510909e-1), SC_(4.499757739485343077480666246073021489091e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.219389572143554687500000000000000000000e2), SC_(7.771367663330746612567644048519088566461e-1), SC_(2.228632336669253387432355951480911433539e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.395161590576171875000000000000000000000e2), SC_(9.250997396857577553602487151589233416802e-1), SC_(7.490026031424224463975128484107665831975e-2) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.518219299316406250000000000000000000000e2), SC_(9.813081206607002363658880957858105962267e-1), SC_(1.869187933929976363411190421418940377331e-2) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.755588378906250000000000000000000000000e2), SC_(9.994695931248452280065403296606226051002e-1), SC_(5.304068751547719934596703393773948997595e-4) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(2.382623443603515625000000000000000000000e2), SC_(9.999999978805938132712706339180387569059e-1), SC_(2.119406186728729366081961243094056538051e-9) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(3.879697875976562500000000000000000000000e2), SC_(9.999999999999999999999988396849853376672e-1), SC_(1.160315014662332769855745023440743684188e-24) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(5.176198730468750000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.007186626640829150154281331256803619776e-42) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(6.593462524414062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.902649707794865317057828931248202115808e-63) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.323898029327392578125000000000000000000e1), SC_(9.010994408803214566237853468065123167655e-36), SC_(9.999999999999999999999999999999999909890e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(3.373336029052734375000000000000000000000e1), SC_(2.402421312955870169722247181645230464271e-17), SC_(9.999999999999999759757868704412983027775e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(6.764713287353515625000000000000000000000e1), SC_(1.908053525950344028304004459816616705561e-6), SC_(9.999980919464740496559716959955401833833e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.027442169189453125000000000000000000000e2), SC_(2.135578800722514326663344846781498416795e-2), SC_(9.786442119927748567333665515321850158321e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.244467468261718750000000000000000000000e2), SC_(2.296155935191101041171056804796346082799e-1), SC_(7.703844064808898958828943195203653917201e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(1.383224945068359375000000000000000000000e2), SC_(4.866534484878318693183841216800247621982e-1), SC_(5.133465515121681306816158783199752378018e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.412780914306640625000000000000000000000e2), SC_(5.138856574227925581169085892605509093930e-1), SC_(4.861143425772074418830914107394490906070e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.441342315673828125000000000000000000000e2), SC_(5.167929208214042835595056071982827815401e-1), SC_(4.832070791785957164404943928017172184599e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.446843872070312500000000000000000000000e2), SC_(5.170725583348048706256607044658729671691e-1), SC_(4.829274416651951293743392955341270328309e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.477208709716796875000000000000000000000e2), SC_(5.196889361118096339788060981614254918346e-1), SC_(4.803110638881903660211939018385745081654e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.538045806884765625000000000000000000000e2), SC_(5.469864581897138526227850586416420337022e-1), SC_(4.530135418102861473772149413583579662978e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.695140686035156250000000000000000000000e2), SC_(7.855238185212998821613904849788573148219e-1), SC_(2.144761814787001178386095150211426851781e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(1.983377990722656250000000000000000000000e2), SC_(9.362076317683054194252948140936683593511e-1), SC_(6.379236823169458057470518590633164064889e-2) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.152754974365234375000000000000000000000e2), SC_(9.864422149277580330626126315453050672382e-1), SC_(1.355778507224196693738736845469493276176e-2) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.539541625976562500000000000000000000000e2), SC_(9.997771279411177484129969935079173603900e-1), SC_(2.228720588822515870030064920826396099524e-4) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(3.405590209960937500000000000000000000000e2), SC_(9.999999998926955626565081427970422731488e-1), SC_(1.073044373434918572029577268512495980540e-10) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.145909423828125000000000000000000000000e2), SC_(9.999999999999999999999999998036830015796e-1), SC_(1.963169984204496599297298135017391243284e-28) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(6.928279418945312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.749632015307389865287585530577230750778e-50) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(8.665839233398437500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.526193009307931026274754537800481003610e-74) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(1.821557044982910156250000000000000000000e1), SC_(3.676478592842965324775413015592983366797e-38), SC_(9.999999999999999999999999999999999999632e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(4.708557510375976562500000000000000000000e1), SC_(4.806518686889745151818782373082511517851e-19), SC_(9.999999999999999995193481313110254848181e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(9.482229614257812500000000000000000000000e1), SC_(3.895620767999707312922174605063141547669e-7), SC_(9.999996104379232000292687077825394936858e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(1.456868591308593750000000000000000000000e2), SC_(1.386842950589145730493930959345761448862e-2), SC_(9.861315704941085426950606904065423855114e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(1.748829803466796875000000000000000000000e2), SC_(2.084267369238022936386564207613392974183e-1), SC_(7.915732630761977063613435792386607025817e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.028001556396484375000000000000000000000e2), SC_(4.808731292037423905767801891115369806011e-1), SC_(5.191268707962576094232198108884630193989e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.067650451660156250000000000000000000000e2), SC_(5.108921137701894615132009783786668504066e-1), SC_(4.891078862298105384867990216213331495934e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.080147094726562500000000000000000000000e2), SC_(5.142018217078786724419644409309163898247e-1), SC_(4.857981782921213275580355590690836101753e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.106505126953125000000000000000000000000e2), SC_(5.144505251312430122541040649663090908759e-1), SC_(4.855494748687569877458959350336909091241e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.194924774169921875000000000000000000000e2), SC_(5.172399321115565286911816103381198677045e-1), SC_(4.827600678884434713088183896618801322955e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.215344085693359375000000000000000000000e2), SC_(5.477161045241085167917263228718084021951e-1), SC_(4.522838954758914832082736771281915978049e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.600056152343750000000000000000000000000e2), SC_(8.121447604242499586047693476448544995662e-1), SC_(1.878552395757500413952306523551455004338e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.854194946289062500000000000000000000000e2), SC_(9.552407402511911233967529688629836231160e-1), SC_(4.475925974880887660324703113701637688399e-2) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(3.132902221679687500000000000000000000000e2), SC_(9.934610715748517243761470543823668510484e-1), SC_(6.538928425148275623852945617633148951626e-3) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.615675354003906250000000000000000000000e2), SC_(9.999588469788077907462839708055578829595e-1), SC_(4.115302119220925371602919444211704053353e-5) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(4.852359924316406250000000000000000000000e2), SC_(9.999999999996293582614511756411353618697e-1), SC_(3.706417385488243588646381302593609468436e-13) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(7.369317626953125000000000000000000000000e2), SC_(9.999999999999999999999999999999999978118e-1), SC_(2.188221629331300367855710652284713703348e-36) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(9.846752319335937500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.811401795343203056998670266136310753327e-65) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(1.244313110351562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.550685886261931204741726247254349478918e-98) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(2.511061286926269531250000000000000000000e1), SC_(3.141701778609410465700165178492208149322e-43), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(6.376617050170898437500000000000000000000e1), SC_(5.500995073611670924516326736042910254951e-22), SC_(9.999999999999999999994499004926388329075e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(1.290131835937500000000000000000000000000e2), SC_(2.913148268493764467974821090080763880132e-8), SC_(9.999999708685173150623553202517890991924e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(1.938925323486328125000000000000000000000e2), SC_(7.719579770683417302154075102287319164291e-3), SC_(9.922804202293165826978459248977126808357e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(2.353004455566406250000000000000000000000e2), SC_(1.827213101263701582664588589065568049032e-1), SC_(8.172786898736298417335411410934431950968e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(2.600204467773437500000000000000000000000e2), SC_(4.762120683123114591150934824059886099215e-1), SC_(5.237879316876885408849065175940113900785e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(2.680700378417968750000000000000000000000e2), SC_(5.088279852698398877130474193853872675686e-1), SC_(4.911720147301601122869525806146127324314e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(2.693528747558593750000000000000000000000e2), SC_(5.124649755753549898323180350394930623858e-1), SC_(4.875350244246450101676819649605069376142e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(2.695095520019531250000000000000000000000e2), SC_(5.128282177183606346491334633574535198542e-1), SC_(4.871717822816393653508665366425464801458e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(2.697875976562500000000000000000000000000e2), SC_(5.161253068472230245544124164273857358881e-1), SC_(4.838746931527769754455875835726142641119e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(2.726525268554687500000000000000000000000e2), SC_(5.489217515011988691650576806586428532692e-1), SC_(4.510782484988011308349423193413571467308e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.001257934570312500000000000000000000000e2), SC_(8.236745685091281147147797647831072416478e-1), SC_(1.763254314908718852852202352168927583522e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.291330871582031250000000000000000000000e2), SC_(9.629436829034439211783266109080948721466e-1), SC_(3.705631709655607882167338909190512785339e-2) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.569649963378906250000000000000000000000e2), SC_(9.953710729812006895883153957058989603777e-1), SC_(4.628927018799310411684604294101039622284e-3) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.153479309082031250000000000000000000000e2), SC_(9.999831866487952629999635200225537193354e-1), SC_(1.681335120473700003647997744628066456006e-5) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.594455566406250000000000000000000000000e2), SC_(9.999999999999827574977842814672106685386e-1), SC_(1.724250221571853278933146141005801147664e-14) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(8.531479492187500000000000000000000000000e2), SC_(9.999999999999999999999999999999999999999e-1), SC_(9.865776040734646884182070910313578404366e-41) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(1.142332031250000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.529147581137782745222539649523826313257e-73) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(1.455276489257812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.914238638514548150017818038644572221703e-111) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(2.925720787048339843750000000000000000000e1), SC_(9.713305903888383640983225724737703183016e-47), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(7.326100158691406250000000000000000000000e1), SC_(7.953655410038746110764870718758509973255e-24), SC_(9.999999999999999999999920463445899612539e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(1.483477783203125000000000000000000000000e2), SC_(6.073270475630406028461026240840610774979e-9), SC_(9.999999939267295243695939715389737591594e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(2.249559936523437500000000000000000000000e2), SC_(5.213053529170006420507657278897698785737e-3), SC_(9.947869464708299935794923427211023012143e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(2.711972656250000000000000000000000000000e2), SC_(1.689241411217285707018946246557802865278e-1), SC_(8.310758588782714292981053753442197134722e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(2.983842773437500000000000000000000000000e2), SC_(4.734091628459602179130757953498826904880e-1), SC_(5.265908371540397820869242046501173095120e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.014935913085937500000000000000000000000e2), SC_(5.079302657641317529177043923799438792566e-1), SC_(4.920697342358682470822956076200561207434e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.028746032714843750000000000000000000000e2), SC_(5.117375275667254236414658790561578071451e-1), SC_(4.882624724332745763585341209438421928549e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.034662170410156250000000000000000000000e2), SC_(5.121097790224033106962494122471257978540e-1), SC_(4.878902209775966893037505877528742021460e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.039741516113281250000000000000000000000e2), SC_(5.155569336708223256246315679920170848723e-1), SC_(4.844430663291776743753684320079829151277e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.070556030273437500000000000000000000000e2), SC_(5.498773333541018356873569473327962961524e-1), SC_(4.501226666458981643126430526672037038476e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.367307128906250000000000000000000000000e2), SC_(8.336117476771685251713950641126305458412e-1), SC_(1.663882523228314748286049358873694541588e-1) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.701677856445312500000000000000000000000e2), SC_(9.690136222481081341408099703232897725397e-1), SC_(3.098637775189186585919002967671022746032e-2) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(4.013237609863281250000000000000000000000e2), SC_(9.967539662896745526517097767012623027779e-1), SC_(3.246033710325447348290223298737697222082e-3) }}, 
      {{ SC_(1.098968963623046875000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(4.637837219238281250000000000000000000000e2), SC_(9.999925743677093360826561730060743980598e-1), SC_(7.425632290663917343826993925601940172779e-6) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.555923767089843750000000000000000000000e2), SC_(9.999999998286286085344735241193365100361e-1), SC_(1.713713914655264758806634899638516841736e-10) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(3.996181640625000000000000000000000000000e2), SC_(9.999999999999999999999999971560817151573e-1), SC_(2.843918284842671547627082288762461956036e-27) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(5.349148559570312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.130165704542335491877983211966146264942e-47) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(6.699091186523437500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(5.631336529342050572381027575722132468001e-69) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.360737800598144531250000000000000000000e1), SC_(1.139984106316046205031518527627157413450e-40), SC_(9.999999999999999999999999999999999999999e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(3.656646347045898437500000000000000000000e1), SC_(1.369707985864775085555247217113950904861e-19), SC_(9.999999999999999998630292014135224914445e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(7.317378234863281250000000000000000000000e1), SC_(3.959058009351148916181344282370041643804e-7), SC_(9.999996040941990648851083818655717629958e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.116088867187500000000000000000000000000e2), SC_(1.518486787327083330334604481291867541577e-2), SC_(9.848151321267291666966539551870813245842e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.343991546630859375000000000000000000000e2), SC_(2.140516299388024418229661064873556589517e-1), SC_(7.859483700611975581770338935126443410483e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(1.503572845458984375000000000000000000000e2), SC_(4.838564210098541986975599011843991957917e-1), SC_(5.161435789901458013024400988156008042083e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.520846252441406250000000000000000000000e2), SC_(5.129144979508127524134646942162826640490e-1), SC_(4.870855020491872475865353057837173359510e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.539348907470703125000000000000000000000e2), SC_(5.160753869319178126949056927272802305607e-1), SC_(4.839246130680821873050943072727197694393e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.552322845458984375000000000000000000000e2), SC_(5.163536638920899019370601726506186463143e-1), SC_(4.836463361079100980629398273493813536857e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(1.568189544677734375000000000000000000000e2), SC_(5.192102831565613359809811383747143202328e-1), SC_(4.807897168434386640190188616252856797672e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.599457244873046875000000000000000000000e2), SC_(5.481015266142195762029933279026422390656e-1), SC_(4.518984733857804237970066720973577609344e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.771845092773437500000000000000000000000e2), SC_(7.965221953026762789964385546454974834861e-1), SC_(2.034778046973237210035614453545025165139e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.939350280761718750000000000000000000000e2), SC_(9.423753200468884405093871874609333797645e-1), SC_(5.762467995311155949061281253906662023547e-2) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.138706359863281250000000000000000000000e2), SC_(9.889773391231153033237547954253798714708e-1), SC_(1.102266087688469667624520457462012852916e-2) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.538365478515625000000000000000000000000e2), SC_(9.998605003276144843748079249539825662250e-1), SC_(1.394996723855156251920750460174337750236e-4) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(3.420925903320312500000000000000000000000e2), SC_(9.999999999735360399643658179339050128533e-1), SC_(2.646396003563418206609498714666438587859e-11) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(5.466722412109375000000000000000000000000e2), SC_(9.999999999999999999999999999993947871862e-1), SC_(6.052128137933574017890693808680473592990e-31) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(7.301565551757812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.968246638623841304660524256672000045539e-54) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(9.312268676757812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.190890411657906668258947439265789231399e-81) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(1.872221183776855468750000000000000000000e1), SC_(1.903453321867421424791600899022535933060e-42), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(4.711822509765625000000000000000000000000e1), SC_(1.157874728567165783978813460155145337550e-20), SC_(9.999999999999999999884212527143283421602e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(9.507479095458984375000000000000000000000e1), SC_(1.376915425377995594197731375022346148975e-7), SC_(9.999998623084574622004405802268624977654e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(1.426945343017578125000000000000000000000e2), SC_(1.170233137625443670718366061111582660730e-2), SC_(9.882976686237455632928163393888841733927e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(1.791884613037109375000000000000000000000e2), SC_(1.988243245918184428430368060774912261204e-1), SC_(8.011756754081815571569631939225087738796e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.032320556640625000000000000000000000000e2), SC_(4.798100910513901377903589972721567256299e-1), SC_(5.201899089486098622096410027278432743701e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.063805999755859375000000000000000000000e2), SC_(5.107758283762837447009978493377563088274e-1), SC_(4.892241716237162552990021506622436911726e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.111917419433593750000000000000000000000e2), SC_(5.140689760169401890046247512562332251960e-1), SC_(4.859310239830598109953752487437667748040e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.112781524658203125000000000000000000000e2), SC_(5.144131267126497439731324874798660500270e-1), SC_(4.855868732873502560268675125201339499730e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.220130310058593750000000000000000000000e2), SC_(5.172512829897559290554735491344340841570e-1), SC_(4.827487170102440709445264508655659158430e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.261537628173828125000000000000000000000e2), SC_(5.486840548198268452977216572667497993890e-1), SC_(4.513159451801731547022783427332502006110e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.474530487060546875000000000000000000000e2), SC_(8.141320280739485714948402391209704014407e-1), SC_(1.858679719260514285051597608790295985593e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.730864562988281250000000000000000000000e2), SC_(9.565964892350569614459430319797332905511e-1), SC_(4.340351076494303855405696802026670944890e-2) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(3.070805053710937500000000000000000000000e2), SC_(9.941116076196742107830622121080445748708e-1), SC_(5.888392380325789216937787891955425129152e-3) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(3.544254150390625000000000000000000000000e2), SC_(9.999672872685840423831168161396639387196e-1), SC_(3.271273141595761688318386033606128042873e-5) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(5.066226806640625000000000000000000000000e2), SC_(9.999999999999412064804099248553208530435e-1), SC_(5.879351959007514467914695648310421140857e-14) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(7.643764648437500000000000000000000000000e2), SC_(9.999999999999999999999999999999999999830e-1), SC_(1.701106558215671877445306263597061385196e-38) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(1.031740234375000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.727543820986769261767958006649567702636e-69) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(1.289937988281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.935010867956636224556561481388887238552e-103) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(2.595606040954589843750000000000000000000e1), SC_(3.165753282198992336105389270425062627430e-47), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(6.564662933349609375000000000000000000000e1), SC_(1.224917196414828656763418683986422669955e-23), SC_(9.999999999999999999999877508280358517134e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(1.315556945800781250000000000000000000000e2), SC_(1.059134868324274727243533142675639553995e-8), SC_(9.999999894086513167572527275646685732436e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(1.993539276123046875000000000000000000000e2), SC_(6.159857779341086419317384881554839409944e-3), SC_(9.938401422206589135806826151184451605901e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(2.412438354492187500000000000000000000000e2), SC_(1.751418520491144033197048293297601311475e-1), SC_(8.248581479508855966802951706702398688525e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(2.692872009277343750000000000000000000000e2), SC_(4.747832202848699527753561902220711641980e-1), SC_(5.252167797151300472246438097779288358020e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(2.746939697265625000000000000000000000000e2), SC_(5.085811956384626782736774218610019727455e-1), SC_(4.914188043615373217263225781389980272545e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(2.754660034179687500000000000000000000000e2), SC_(5.123385165805848428812581095413875755246e-1), SC_(4.876614834194151571187418904586124244754e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(2.784153442382812500000000000000000000000e2), SC_(5.126505682735770702711813410015595025314e-1), SC_(4.873494317264229297288186589984404974686e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(2.798690795898437500000000000000000000000e2), SC_(5.160329163259257045201857394145634636948e-1), SC_(4.839670836740742954798142605854365363052e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(2.881337585449218750000000000000000000000e2), SC_(5.500594725537146623231461800944957104021e-1), SC_(4.499405274462853376768538199055042895979e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.149250183105468750000000000000000000000e2), SC_(8.320152830170637247496843037485389658153e-1), SC_(1.679847169829362752503156962514610341847e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.437102966308593750000000000000000000000e2), SC_(9.675970080721260564614528591459801692381e-1), SC_(3.240299192787394353854714085401983076189e-2) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.723988342285156250000000000000000000000e2), SC_(9.964243143546240249029092290610506968547e-1), SC_(3.575685645375975097090770938949303145255e-3) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.303433532714843750000000000000000000000e2), SC_(9.999903912204598188869955735883038042368e-1), SC_(9.608779540181113004426411696195763236071e-6) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.795684814453125000000000000000000000000e2), SC_(9.999999999999969541345667993088129184202e-1), SC_(3.045865433200691187081579807128316259519e-15) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(8.736604614257812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.609064528429886327453994014044639153321e-42) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(1.166124267578125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.934069024581731032507281638537947027245e-76) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(1.469205932617187500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.129261620107556600726059069923316514245e-114) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(2.966653442382812500000000000000000000000e1), SC_(3.523935028365043589956774504819647786906e-50), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(7.533131408691406250000000000000000000000e1), SC_(1.949447363476994284564466815044589070571e-25), SC_(9.999999999999999999999998050552636523006e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(1.512628173828125000000000000000000000000e2), SC_(2.263162033666016175560416152106784891972e-9), SC_(9.999999977368379663339838244395838478932e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(2.309983978271484375000000000000000000000e2), SC_(4.179748025060246475300207413940776430706e-3), SC_(9.958202519749397535246997925860592235693e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(2.785631713867187500000000000000000000000e2), SC_(1.618885406958836507310804787810488222984e-1), SC_(8.381114593041163492689195212189511777016e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.068867492675781250000000000000000000000e2), SC_(4.721764008239014035444564454544658505144e-1), SC_(5.278235991760985964555435545455341494856e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.133244934082031250000000000000000000000e2), SC_(5.075969825876086597055980666190728847635e-1), SC_(4.924030174123913402944019333809271152365e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.168839111328125000000000000000000000000e2), SC_(5.114889136162672953488862220773547252087e-1), SC_(4.885110863837327046511137779226452747913e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.183047180175781250000000000000000000000e2), SC_(5.118605108649691589272351193154119881474e-1), SC_(4.881394891350308410727648806845880118526e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.186592407226562500000000000000000000000e2), SC_(5.154336378226897618020665687172893307087e-1), SC_(4.845663621773102381979334312827106692913e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.219253540039062500000000000000000000000e2), SC_(5.509687825816296899937729608088760690881e-1), SC_(4.490312174183703100062270391911239309119e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.517989196777343750000000000000000000000e2), SC_(8.412545064472518308246426901078228551859e-1), SC_(1.587454935527481691753573098921771448141e-1) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.844541931152343750000000000000000000000e2), SC_(9.727522383793077470009944882482560331083e-1), SC_(2.724776162069225299900551175174396689168e-2) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.167969360351562500000000000000000000000e2), SC_(9.974749188262017746495976312896709749347e-1), SC_(2.525081173798225350402368710329025065278e-3) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(4.814371032714843750000000000000000000000e2), SC_(9.999958822759998194894450495521345026815e-1), SC_(4.117724000180510554950447865497318482875e-6) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(6.461228637695312500000000000000000000000e2), SC_(9.999999999999998056844071479183163638163e-1), SC_(1.943155928520816836361837437489197927062e-16) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(9.762473144531250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.338866389197452312050429263304613749346e-46) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(1.302612792968750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.984236770775583138381271262385472847969e-83) }}, 
      {{ SC_(1.268394927978515625000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(1.630658935546875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.492213022918283893822155963641735931954e-125) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.292696094512939453125000000000000000000e1), SC_(4.582464927024288814917616699119064357087e-41), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(3.366986846923828125000000000000000000000e1), SC_(1.178220621843824258845580577798584348881e-19), SC_(9.999999999999999998821779378156175741154e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(6.760106658935546875000000000000000000000e1), SC_(3.927002195118771335528946758716340315530e-7), SC_(9.999996072997804881228664471053241283660e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.015914306640625000000000000000000000000e2), SC_(1.542471020725749409618725902911829954735e-2), SC_(9.845752897927425059038127409708817004526e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.237924728393554687500000000000000000000e2), SC_(2.149529816514100977992042794662166163120e-1), SC_(7.850470183485899022007957205337833836880e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.462618865966796875000000000000000000000e2), SC_(4.839260368957714276389437098794780847278e-1), SC_(5.160739631042285723610562901205219152722e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.476731719970703125000000000000000000000e2), SC_(5.130173058827379897790463165077468232687e-1), SC_(4.869826941172620102209536834922531767313e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.502852630615234375000000000000000000000e2), SC_(5.161617569720552262218812451632726112824e-1), SC_(4.838382430279447737781187548367273887176e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.508208923339843750000000000000000000000e2), SC_(5.164678354461370763795283600557893286739e-1), SC_(4.835321645538629236204716399442106713261e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(1.535028076171875000000000000000000000000e2), SC_(5.192951088834128535659109004190528175805e-1), SC_(4.807048911165871464340890995809471824195e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.552473754882812500000000000000000000000e2), SC_(5.482127825825371478409341702359666369437e-1), SC_(4.517872174174628521590658297640333630563e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.709491424560546875000000000000000000000e2), SC_(7.961661305840622711715857172895010173838e-1), SC_(2.038338694159377288284142827104989826162e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.880282287597656250000000000000000000000e2), SC_(9.421170045285366312866260781776917884929e-1), SC_(5.788299547146336871337392182230821150705e-2) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.055764160156250000000000000000000000000e2), SC_(9.887379454354424952870705051986801481796e-1), SC_(1.126205456455750471292949480131985182035e-2) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.397532958984375000000000000000000000000e2), SC_(9.998434862830275218314724517676241227399e-1), SC_(1.565137169724781685275482323758772601049e-4) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(3.251004943847656250000000000000000000000e2), SC_(9.999999999612183237202624753264042993261e-1), SC_(3.878167627973752467359570067388775228183e-11) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.892578125000000000000000000000000000000e2), SC_(9.999999999999999999999999999773082052885e-1), SC_(2.269179471146977364050227636473481347640e-29) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(6.639572143554687500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(8.830300421562265139148773273526956376098e-52) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(8.534888916015625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.183467671269807886797823607379133717295e-77) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.725197219848632812500000000000000000000e1), SC_(4.065042275347460830127791860634043656884e-42), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(4.592437744140625000000000000000000000000e1), SC_(1.167413164189807905349569749618574091270e-20), SC_(9.999999999999999999883258683581019209465e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(9.200627899169921875000000000000000000000e1), SC_(1.498866273853029260860726946692159969947e-7), SC_(9.999998501133726146970739139273053307840e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.407890930175781250000000000000000000000e2), SC_(1.170039279320285323360250704063473029166e-2), SC_(9.882996072067971467663974929593652697083e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(1.698259735107421875000000000000000000000e2), SC_(2.016203010621049776965504924032212442582e-1), SC_(7.983796989378950223034495075967787557418e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(1.880468597412109375000000000000000000000e2), SC_(4.809149282957236051070771449372542713586e-1), SC_(5.190850717042763948929228550627457286414e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(1.914313812255859375000000000000000000000e2), SC_(5.113289395571003259739534308203984213157e-1), SC_(4.886710604428996740260465691796015786843e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(1.917328033447265625000000000000000000000e2), SC_(5.147073898635805018799250627719116223946e-1), SC_(4.852926101364194981200749372280883776054e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.005917816162109375000000000000000000000e2), SC_(5.147510156006126583130933839712033248673e-1), SC_(4.852489843993873416869066160287966751327e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.069650878906250000000000000000000000000e2), SC_(5.176539437722673112585837384940101017501e-1), SC_(4.823460562277326887414162615059898982499e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.101412048339843750000000000000000000000e2), SC_(5.485130736863785701525651446728720391741e-1), SC_(4.514869263136214298474348553271279608259e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.339316864013671875000000000000000000000e2), SC_(8.110532474343222951289614512687527022795e-1), SC_(1.889467525656777048710385487312472977205e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.552765350341796875000000000000000000000e2), SC_(9.538135726582623415309178654000750571725e-1), SC_(4.618642734173765846908213459992494282754e-2) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.902440185546875000000000000000000000000e2), SC_(9.934314366018790197779270729568576807355e-1), SC_(6.568563398120980222072927043142319264546e-3) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(3.380820312500000000000000000000000000000e2), SC_(9.999591668942588068727851316438920415761e-1), SC_(4.083310574119312721486835610795842389138e-5) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(4.528614501953125000000000000000000000000e2), SC_(9.999999999995549885793708628957238877996e-1), SC_(4.450114206291371042761122003864507273376e-13) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(6.871363525390625000000000000000000000000e2), SC_(9.999999999999999999999999999999999920045e-1), SC_(7.995481909429825969393144374579597958890e-36) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(9.507568359375000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.487334125985094221433410148417855996867e-65) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(1.188785156250000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.749203057702571685077705929939341521976e-97) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.547847557067871093750000000000000000000e1), SC_(3.634410664267692913883682456894812109213e-47), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(6.406639099121093750000000000000000000000e1), SC_(1.782567323500644393262234739764963733311e-23), SC_(9.999999999999999999999821743267649935561e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(1.297042541503906250000000000000000000000e2), SC_(1.132597722064203913738893105892593031750e-8), SC_(9.999999886740227793579608626110689410741e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(1.945957946777343750000000000000000000000e2), SC_(6.428781273536023865052734765903242214749e-3), SC_(9.935712187264639761349472652340967577853e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(2.349305877685546875000000000000000000000e2), SC_(1.769985498803863125402071879059227013389e-1), SC_(8.230014501196136874597928120940772986611e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.614193420410156250000000000000000000000e2), SC_(4.752839838678417879059632866813437913287e-1), SC_(5.247160161321582120940367133186562086713e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(2.643202514648437500000000000000000000000e2), SC_(5.088673645474825038617989079860655225671e-1), SC_(4.911326354525174961382010920139344774329e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(2.672786254882812500000000000000000000000e2), SC_(5.125280703047660189841026155897981465962e-1), SC_(4.874719296952339810158973844102018534038e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(2.695491027832031250000000000000000000000e2), SC_(5.128504868661368491450560362525044121988e-1), SC_(4.871495131338631508549439637474955878012e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(2.737542114257812500000000000000000000000e2), SC_(5.161490973195654375955874779399824574780e-1), SC_(4.838509026804345624044125220600175425220e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(2.792068176269531250000000000000000000000e2), SC_(5.498994680546463645783454931212821423614e-1), SC_(4.501005319453536354216545068787178576386e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.046333312988281250000000000000000000000e2), SC_(8.297488012395389793616942518387083081043e-1), SC_(1.702511987604610206383057481612916918957e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.358331604003906250000000000000000000000e2), SC_(9.667179619090683117539090651758449633672e-1), SC_(3.328203809093168824609093482415503663285e-2) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.653818054199218750000000000000000000000e2), SC_(9.962703612534747445074165338227969228094e-1), SC_(3.729638746525255492583466177203077190609e-3) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.301315917968750000000000000000000000000e2), SC_(9.999906220323273921500398354172104678602e-1), SC_(9.377967672607849960164582789532139816226e-6) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(5.755377807617187500000000000000000000000e2), SC_(9.999999999999966860994439577722939618111e-1), SC_(3.313900556042227706038188852354425303647e-15) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(8.636958618164062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.052029550387935115217891524465721551923e-42) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(1.151736328125000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.164954634694333890960966019572723886908e-75) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(1.441845092773437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.925723215365451903096085377142920710728e-113) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(2.912576293945312500000000000000000000000e1), SC_(5.132066721156359009052768713752112291691e-50), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(7.317339324951171875000000000000000000000e1), SC_(3.880362457592612000433363447231333583075e-25), SC_(9.999999999999999999999996119637542407388e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(1.465022430419921875000000000000000000000e2), SC_(3.084584855938910553076916525273528205379e-9), SC_(9.999999969154151440610894469230834747265e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(2.214859771728515625000000000000000000000e2), SC_(4.639239636400465761809311603191312547615e-3), SC_(9.953607603635995342381906883968086874524e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(2.683249206542968750000000000000000000000e2), SC_(1.650196762809109491344135101669710043861e-1), SC_(8.349803237190890508655864898330289956139e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(2.997706909179687500000000000000000000000e2), SC_(4.725966215907723151841604053573302967233e-1), SC_(5.274033784092276848158395946426697032767e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.036950378417968750000000000000000000000e2), SC_(5.078236112757741973971540288230204172302e-1), SC_(4.921763887242258026028459711769795827698e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.094713134765625000000000000000000000000e2), SC_(5.116304157861251881925786665870403727254e-1), SC_(4.883695842138748118074213334129596272746e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.110191955566406250000000000000000000000e2), SC_(5.119958024668449615522314893775298009614e-1), SC_(4.880041975331550384477685106224701990386e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.117714843750000000000000000000000000000e2), SC_(5.155369896037851799528803061440167212560e-1), SC_(4.844630103962148200471196938559832787440e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.182626953125000000000000000000000000000e2), SC_(5.509259478430890345896242664492441125403e-1), SC_(4.490740521569109654103757335507558874597e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.501930847167968750000000000000000000000e2), SC_(8.411938655814060291685486715154750653885e-1), SC_(1.588061344185939708314513284845249346115e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.836955871582031250000000000000000000000e2), SC_(9.728259771955427871421866041868181481007e-1), SC_(2.717402280445721285781339581318185189928e-2) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.157585449218750000000000000000000000000e2), SC_(9.974830775898833446272648035068459827142e-1), SC_(2.516922410116655372735196493154017285794e-3) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.803170776367187500000000000000000000000e2), SC_(9.999959127237828995928905854280004871015e-1), SC_(4.087276217100407109414571999512898455798e-6) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(6.425812377929687500000000000000000000000e2), SC_(9.999999999999997914107007822360436972936e-1), SC_(2.085892992177639563027063725336447887420e-16) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(9.655556640625000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.829051201830508684203073029055164586765e-46) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(1.288345947265625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.057026538550920394266426713921674189594e-83) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(1.612157226562500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.446606271891851927865707026563052201202e-124) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.245348739624023437500000000000000000000e1), SC_(8.552239171556125354611517865202732096451e-53), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(8.172229003906250000000000000000000000000e1), SC_(8.939240727677368610752405172164272016854e-27), SC_(9.999999999999999999999999910607592723226e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(1.635633087158203125000000000000000000000e2), SC_(7.878683841337515530549616486052172188299e-10), SC_(9.999999992121316158662484469450383513948e-1) }}, 
      {{ SC_(1.283129119873046875000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(2.457038726806640625000000000000000000000e2), SC_(3.437252318379480223363284109821892537011e-3), SC_(9.965627476816205197766367158901781074630e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.317587890625000000000000000000000000000e2), SC_(1.994585292653203103778039745942033035425e-1), SC_(8.005414707346796896221960254057966964575e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.502904357910156250000000000000000000000e2), SC_(4.814164147334697498227055026340551656930e-1), SC_(5.185835852665302501772944973659448343070e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.521788482666015625000000000000000000000e2), SC_(5.121475483605678440895438419906926589590e-1), SC_(4.878524516394321559104561580093073410410e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.525842895507812500000000000000000000000e2), SC_(5.155474901411855862172212697635822982229e-1), SC_(4.844525098588144137827787302364177017771e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.546917114257812500000000000000000000000e2), SC_(5.158594685562822671473496248638567909576e-1), SC_(4.841405314437177328526503751361432090424e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.650331878662109375000000000000000000000e2), SC_(5.187371223055943321647510060455959718186e-1), SC_(4.812628776944056678352489939544040281814e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.665995483398437500000000000000000000000e2), SC_(5.493255608559857703964351756049152537786e-1), SC_(4.506744391440142296035648243950847462214e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.841557464599609375000000000000000000000e2), SC_(8.082094011133940320773834696060845607191e-1), SC_(1.917905988866059679226165303939154392809e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.015218353271484375000000000000000000000e2), SC_(9.512353515489793002325245769676115054960e-1), SC_(4.876464845102069976747542303238849450403e-2) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.216220550537109375000000000000000000000e2), SC_(9.919307368140897535725546910166602329351e-1), SC_(8.069263185910246427445308983339767064922e-3) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.562589721679687500000000000000000000000e2), SC_(9.999262381825297893132582144032121438305e-1), SC_(7.376181747021068674178559678785616954062e-5) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(3.450747070312500000000000000000000000000e2), SC_(9.999999999958316994900233470431198304395e-1), SC_(4.168300509976652956880169560463232488951e-12) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(5.214577026367187500000000000000000000000e2), SC_(9.999999999999999999999999999999617181333e-1), SC_(3.828186667135446051070435634475979983324e-32) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(7.010590209960937500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.261029934718208241601166597574611075888e-56) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(8.848228759765625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.236957209306082065113700915629853845588e-83) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.796792984008789062500000000000000000000e1), SC_(6.601371327686017619890932252567130381024e-47), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.505374908447265625000000000000000000000e1), SC_(1.921384215699796950172771953834906045332e-22), SC_(9.999999999999999999998078615784300203050e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(9.155917358398437500000000000000000000000e1), SC_(4.532140993837725951288335436545258103226e-8), SC_(9.999999546785900616227404871166456345474e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.408701171875000000000000000000000000000e2), SC_(9.199133994956499034149025261507223828423e-3), SC_(9.908008660050435009658509747384927761716e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.706838989257812500000000000000000000000e2), SC_(1.922375903969051453701098372407171317177e-1), SC_(8.077624096030948546298901627592828682823e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(1.988182830810546875000000000000000000000e2), SC_(4.788230556655258723996172322013189766698e-1), SC_(5.211769443344741276003827677986810233302e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.009404602050781250000000000000000000000e2), SC_(5.107479342509818804973835577028828620458e-1), SC_(4.892520657490181195026164422971171379542e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.048478393554687500000000000000000000000e2), SC_(5.141758802891227549769538798692144313099e-1), SC_(4.858241197108772450230461201307855686901e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.058451690673828125000000000000000000000e2), SC_(5.145027192568199604672436427574143847957e-1), SC_(4.854972807431800395327563572425856152043e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.072824554443359375000000000000000000000e2), SC_(5.176680856387179517748348866702020462202e-1), SC_(4.823319143612820482251651133297979537798e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.108395690917968750000000000000000000000e2), SC_(5.495048892637217763932155072941385928424e-1), SC_(4.504951107362782236067844927058614071576e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.297480316162109375000000000000000000000e2), SC_(8.167506170020243631587297784172695839270e-1), SC_(1.832493829979756368412702215827304160730e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.612409057617187500000000000000000000000e2), SC_(9.590689492254473162806940952271645395284e-1), SC_(4.093105077455268371930590477283546047165e-2) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.910535583496093750000000000000000000000e2), SC_(9.945478425856577956651719194661043992099e-1), SC_(5.452157414342204334828080533895600790143e-3) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(3.377844848632812500000000000000000000000e2), SC_(9.999726892492532809697720055479554889841e-1), SC_(2.731075074671903022799445204451101593737e-5) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.595884399414062500000000000000000000000e2), SC_(9.999999999998926084573993897115926746730e-1), SC_(1.073915426006102884073253270278125158008e-13) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(6.895784912109375000000000000000000000000e2), SC_(9.999999999999999999999999999999999996839e-1), SC_(3.161311004369760945847618422866109520774e-37) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(9.615747680664062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(5.728155051492904205951390768269186148270e-68) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(1.212585449218750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.616016134612894954978996678232082190930e-101) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.435597801208496093750000000000000000000e1), SC_(4.381051228273087133287661096143238045433e-50), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(6.154362487792968750000000000000000000000e1), SC_(1.577802963362263375441826737009324002981e-24), SC_(9.999999999999999999999984221970366377366e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(1.274091262817382812500000000000000000000e2), SC_(5.387385851547731199274992960881505490831e-9), SC_(9.999999946126141484522688007250070391185e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(1.911645507812500000000000000000000000000e2), SC_(5.597945996747934030396562678131059742361e-3), SC_(9.944020540032520659696034373218689402576e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.447224273681640625000000000000000000000e2), SC_(1.679831979373056315294779440228312111111e-1), SC_(8.320168020626943684705220559771687888889e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.706606750488281250000000000000000000000e2), SC_(4.738176877366991815255632653961819664248e-1), SC_(5.261823122633008184744367346038180335752e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(2.762610168457031250000000000000000000000e2), SC_(5.084547713396421445256610916001919899495e-1), SC_(4.915452286603578554743389083998080100505e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(2.765900878906250000000000000000000000000e2), SC_(5.123145991948913570377927958221175765306e-1), SC_(4.876854008051086429622072041778824234694e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(2.781908874511718750000000000000000000000e2), SC_(5.126669121337764508006529126932328842300e-1), SC_(4.873330878662235491993470873067671157700e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.814701538085937500000000000000000000000e2), SC_(5.160927050386455611612472421091684795237e-1), SC_(4.839072949613544388387527578908315204763e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(2.845310058593750000000000000000000000000e2), SC_(5.507984757343979354205059804801097134556e-1), SC_(4.492015242656020645794940195198902865444e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.128484497070312500000000000000000000000e2), SC_(8.363868200514831579205853193890332261260e-1), SC_(1.636131799485168420794146806109667738740e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.439814453125000000000000000000000000000e2), SC_(9.702272440453196270759522458840594927950e-1), SC_(2.977275595468037292404775411594050720504e-2) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.777926635742187500000000000000000000000e2), SC_(9.970732721833435887146098423500096396489e-1), SC_(2.926727816656411285390157649990360351099e-3) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.403571166992187500000000000000000000000e2), SC_(9.999943102779454746062157257878579485132e-1), SC_(5.689722054525393784274212142051486781764e-6) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.881369018554687500000000000000000000000e2), SC_(9.999999999999992493202991129813901825744e-1), SC_(7.506797008870186098174255802508582403921e-16) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(8.909699707031250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.381311319196800246961096593781924595067e-44) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(1.192767822265625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.313814865703047978524530010801891161440e-79) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(1.519417114257812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.368724633437390771705454888026564506269e-120) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.048979568481445312500000000000000000000e1), SC_(1.910527424036988712423044200492914383306e-54), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(7.625691986083984375000000000000000000000e1), SC_(5.030597316166044143055301847869459674795e-27), SC_(9.999999999999999999999999949694026838340e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(1.525315551757812500000000000000000000000e2), SC_(8.479280295280911474576025684798361929804e-10), SC_(9.999999991520719704719088525423974315202e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(2.291235351562500000000000000000000000000e2), SC_(3.607056449542736189103265803400002740458e-3), SC_(9.963929435504572638108967341965999972595e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(2.775480041503906250000000000000000000000e2), SC_(1.572550384851004321725139474333273914895e-1), SC_(8.427449615148995678274860525666726085105e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.067243957519531250000000000000000000000e2), SC_(4.714311334062553257207763334941155485682e-1), SC_(5.285688665937446742792236665058844514318e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.098234252929687500000000000000000000000e2), SC_(5.076165921764306551544239963084371439386e-1), SC_(4.923834078235693448455760036915628560614e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.124436645507812500000000000000000000000e2), SC_(5.115852352203645020513871646969335029223e-1), SC_(4.884147647796354979486128353030664970777e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.152993469238281250000000000000000000000e2), SC_(5.119359893848685535954415378949770113932e-1), SC_(4.880640106151314464045584621050229886068e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.202476806640625000000000000000000000000e2), SC_(5.155006725300750147826922675935492215671e-1), SC_(4.844993274699249852173077324064507784329e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.243393554687500000000000000000000000000e2), SC_(5.517814485164034440325835726965473111679e-1), SC_(4.482185514835965559674164273034526888321e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.592603759765625000000000000000000000000e2), SC_(8.471882787879292682335206975424051975249e-1), SC_(1.528117212120707317664793024575948024751e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.937405700683593750000000000000000000000e2), SC_(9.757355183596186297176204260681456723802e-1), SC_(2.426448164038137028237957393185432761975e-2) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.271657409667968750000000000000000000000e2), SC_(9.979903446845468213520826686829549648112e-1), SC_(2.009655315453178647917331317045035188832e-3) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.983609008789062500000000000000000000000e2), SC_(9.999977780940211809957222674655337688595e-1), SC_(2.221905978819004277732534466231140465904e-6) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(6.709727783203125000000000000000000000000e2), SC_(9.999999999999999739854464983868793443927e-1), SC_(2.601455350161312065560727643952840936692e-17) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(1.010626098632812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.221612677999659677775328504151517124037e-49) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(1.347773315429687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.188410331311569148995567500365233221558e-87) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.686702270507812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.944450109215702146926456067273329115577e-131) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.384196853637695312500000000000000000000e1), SC_(3.978620480057730550981035057476950085281e-57), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(8.474523925781250000000000000000000000000e1), SC_(1.347673868500614036306409928799205562685e-28), SC_(9.999999999999999999999999998652326131499e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(1.696077575683593750000000000000000000000e2), SC_(2.242438411389220449045301388701569211063e-10), SC_(9.999999997757561588610779550954698611298e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(2.546703796386718750000000000000000000000e2), SC_(2.651038480835377877822184627549437799199e-3), SC_(9.973489615191646221221778153724505622008e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.074974975585937500000000000000000000000e2), SC_(1.479645896707045427536864273645348181478e-1), SC_(8.520354103292954572463135726354651818522e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.405780334472656250000000000000000000000e2), SC_(4.693049000464843733566969208149446432778e-1), SC_(5.306950999535156266433030791850553567222e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.439114379882812500000000000000000000000e2), SC_(5.068639499807016935583734037399314477311e-1), SC_(4.931360500192983064416265962600685522689e-1) }}, 
      {{ SC_(1.454419555664062500000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.447342224121093750000000000000000000000e2), SC_(5.110207794887157888628744172800628153740e-1), SC_(4.889792205112842111371255827199371846260e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.596219024658203125000000000000000000000e2), SC_(5.152859928874562034312238678480215195344e-1), SC_(4.847140071125437965687761321519784804656e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.651808319091796875000000000000000000000e2), SC_(5.184507752465737126849208055597217761840e-1), SC_(4.815492247534262873150791944402782238160e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.671938476562500000000000000000000000000e2), SC_(5.501976764482786807180043392737176201952e-1), SC_(4.498023235517213192819956607262823798048e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.823707427978515625000000000000000000000e2), SC_(8.160599734172070149024015016878241834752e-1), SC_(1.839400265827929850975984983121758165248e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(2.014602508544921875000000000000000000000e2), SC_(9.567546726165931750214594398779168579764e-1), SC_(4.324532738340682497854056012208314202360e-2) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.314982757568359375000000000000000000000e2), SC_(9.937248527951695692732469595341375272018e-1), SC_(6.275147204830430726753040465862472798224e-3) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.672359619140625000000000000000000000000e2), SC_(9.999587642293315646703361243909490717982e-1), SC_(4.123577066843532966387560905092820178585e-5) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(3.612431945800781250000000000000000000000e2), SC_(9.999999999993100463296189381337209681983e-1), SC_(6.899536703810618662790318016740645637929e-13) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(5.434264526367187500000000000000000000000e2), SC_(9.999999999999999999999999999999997275624e-1), SC_(2.724376309420012118369798561071785662651e-34) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(7.347431640625000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.087230239933867024760618711397047805365e-60) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(9.202330932617187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.567419179086294829588310870898807851253e-88) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.857446479797363281250000000000000000000e1), SC_(1.040917701821829602707330651307970105364e-50), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.675662994384765625000000000000000000000e1), SC_(3.871324818238046779548484190648576466275e-24), SC_(9.999999999999999999999961286751817619532e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(9.423602294921875000000000000000000000000e1), SC_(1.452490653919403204489942893034546562257e-8), SC_(9.999999854750934608059679551005710696545e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.426288909912109375000000000000000000000e2), SC_(7.393854167787743893654405805556048059518e-3), SC_(9.926061458322122561063455941944439519405e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.735979156494140625000000000000000000000e2), SC_(1.840897201177736735045701965142092526005e-1), SC_(8.159102798822263264954298034857907473995e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.914880523681640625000000000000000000000e2), SC_(4.781437239393776962018368676033175111525e-1), SC_(5.218562760606223037981631323966824888475e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.961293182373046875000000000000000000000e2), SC_(5.106599556956208992110150160591176220244e-1), SC_(4.893400443043791007889849839408823779756e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.010341186523437500000000000000000000000e2), SC_(5.141576739683647574716097332744173752771e-1), SC_(4.858423260316352425283902667255826247229e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.028763427734375000000000000000000000000e2), SC_(5.144740307647449904260077183151261843119e-1), SC_(4.855259692352550095739922816848738156881e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.142478942871093750000000000000000000000e2), SC_(5.174909501876697071361656210423940133129e-1), SC_(4.825090498123302928638343789576059866871e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.164923858642578125000000000000000000000e2), SC_(5.503375734033052039570866459590788270722e-1), SC_(4.496624265966947960429133540409211729278e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.398606414794921875000000000000000000000e2), SC_(8.242554401892767303928411944307309629608e-1), SC_(1.757445598107232696071588055692690370392e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.628382568359375000000000000000000000000e2), SC_(9.625178249650905925896330008039767650015e-1), SC_(3.748217503490940741036699919602323499851e-2) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.863674316406250000000000000000000000000e2), SC_(9.951886826761178212253760504279202588228e-1), SC_(4.811317323882178774623949572079741177181e-3) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(3.329389953613281250000000000000000000000e2), SC_(9.999794299588796887283592098692122589945e-1), SC_(2.057004112031127164079013078774100545842e-5) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(4.441382751464843750000000000000000000000e2), SC_(9.999999999999328285703827183657668374836e-1), SC_(6.717142961728163423316251642428327910803e-14) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(6.927241210937500000000000000000000000000e2), SC_(9.999999999999999999999999999999999999811e-1), SC_(1.886707385768946578178499397894725288723e-38) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(9.483786010742187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.033266859290020860875149513191095094685e-69) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(1.191984741210937500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.360501929547063911402908516452093587151e-103) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.430014991760253906250000000000000000000e1), SC_(4.065271060375704104720813546362136874370e-53), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(6.076669311523437500000000000000000000000e1), SC_(1.168481099520743340412743366987327403523e-25), SC_(9.999999999999999999999998831518900479257e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(1.268004913330078125000000000000000000000e2), SC_(2.610745769152682639779842140944599723165e-9), SC_(9.999999973892542308473173602201578590554e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(1.917932739257812500000000000000000000000e2), SC_(4.789021001323157204415318087088686610096e-3), SC_(9.952109789986768427955846819129113133899e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.310903472900390625000000000000000000000e2), SC_(1.678402777932975993676447387345000399357e-1), SC_(8.321597222067024006323552612654999600643e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.567879638671875000000000000000000000000e2), SC_(4.740533699966581930288661412858770849580e-1), SC_(5.259466300033418069711338587141229150420e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.677575073242187500000000000000000000000e2), SC_(5.086017720520391102505992364240671503892e-1), SC_(4.913982279479608897494007635759328496108e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.680933532714843750000000000000000000000e2), SC_(5.124898248397879702208100018308616464743e-1), SC_(4.875101751602120297791899981691383535257e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.851495971679687500000000000000000000000e2), SC_(5.125189839889218098382345729867055360666e-1), SC_(4.874810160110781901617654270132944639334e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.868885498046875000000000000000000000000e2), SC_(5.160578779024560321626855958436308731571e-1), SC_(4.839421220975439678373144041563691268429e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(2.926422424316406250000000000000000000000e2), SC_(5.515858292136329138533224119337741941488e-1), SC_(4.484141707863670861466775880662258058512e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.187770996093750000000000000000000000000e2), SC_(8.413216122795027149962328410754250954029e-1), SC_(1.586783877204972850037671589245749045971e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(3.496444396972656250000000000000000000000e2), SC_(9.726707892131586679100506852519523435557e-1), SC_(2.732921078684133208994931474804765644430e-2) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.827151489257812500000000000000000000000e2), SC_(9.974966072145017074845283032557939050172e-1), SC_(2.503392785498292515471696744206094982772e-3) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.423817138671875000000000000000000000000e2), SC_(9.999958047010066465155768525461664248618e-1), SC_(4.195298993353484423147453833575138157682e-6) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(5.952299804687500000000000000000000000000e2), SC_(9.999999999999997440855291585935719204890e-1), SC_(2.559144708414064280795109687195963476953e-16) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(8.995753784179687500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.469562017565620001766991697035378785158e-45) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(1.215268066406250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.111749546852307530666567254508781859980e-82) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(1.533893432617187500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.557684987123447103988864914967901296308e-123) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.072757530212402343750000000000000000000e1), SC_(2.575228980238981578619449270966925806676e-57), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(7.754931640625000000000000000000000000000e1), SC_(2.559131511816824742365486014232669660472e-28), SC_(9.999999999999999999999999997440868488183e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(1.556996154785156250000000000000000000000e2), SC_(3.437358547592186523570248517344752540946e-10), SC_(9.999999996562641452407813476429751482655e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(2.378180236816406250000000000000000000000e2), SC_(2.865798480424545002025324030586022864004e-3), SC_(9.971342015195754549979746759694139771360e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(2.862947082519531250000000000000000000000e2), SC_(1.509836320359853220472128419289086162786e-1), SC_(8.490163679640146779527871580710913837214e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.150526428222656250000000000000000000000e2), SC_(4.703426364661179994622163457397887145504e-1), SC_(5.296573635338820005377836542602112854496e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.179521484375000000000000000000000000000e2), SC_(5.073759593150107649327828482943149632706e-1), SC_(4.926240406849892350672171517056850367294e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.187053222656250000000000000000000000000e2), SC_(5.114726633705356419406819640739132061144e-1), SC_(4.885273366294643580593180359260867938856e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.216261596679687500000000000000000000000e2), SC_(5.118331082455357219916092140425985162651e-1), SC_(4.881668917544642780083907859574014837349e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.233529663085937500000000000000000000000e2), SC_(5.155176585552392491150437672275715086772e-1), SC_(4.844823414447607508849562327724284913228e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.265742187500000000000000000000000000000e2), SC_(5.523847518482064294955987262094396197587e-1), SC_(4.476152481517935705044012737905603802413e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.582160339355468750000000000000000000000e2), SC_(8.499802395758123077724530185244393525461e-1), SC_(1.500197604241876922275469814755606474539e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.941701354980468750000000000000000000000e2), SC_(9.771271614387081814143151946348638239334e-1), SC_(2.287283856129181858568480536513617606655e-2) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(4.330755004882812500000000000000000000000e2), SC_(9.982786121619625449141881157034068225965e-1), SC_(1.721387838037455085811884296593177403469e-3) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(5.015030822753906250000000000000000000000e2), SC_(9.999983571353091634643712389464336187082e-1), SC_(1.642864690836535628761053566381291836674e-6) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(6.796152343750000000000000000000000000000e2), SC_(9.999999999999999911909117229629834867669e-1), SC_(8.809088277037016513233092584591640353988e-18) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(1.023973205566406250000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.372493386124767552364767719608700145734e-50) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(1.367185424804687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.921865723773920725272871795822480735133e-90) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(1.727239379882812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.441492843143597344541406434122711861998e-136) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.486936569213867187500000000000000000000e1), SC_(1.727864315585746116790051690832704340092e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(8.752066040039062500000000000000000000000e1), SC_(4.129262784302369149878994313445654821938e-30), SC_(9.999999999999999999999999999958707372157e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(1.750753173828125000000000000000000000000e2), SC_(7.865081746139244247863486979714137551299e-11), SC_(9.999999999213491825386075575213651302029e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(2.629107971191406250000000000000000000000e2), SC_(2.130447824142161280014294229156170134129e-3), SC_(9.978695521758578387199857057708438298659e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.164642639160156250000000000000000000000e2), SC_(1.422266026734052283717728750656184054683e-1), SC_(8.577733973265947716282271249343815945317e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.486663513183593750000000000000000000000e2), SC_(4.683135847470131341465612051748708356036e-1), SC_(5.316864152529868658534387948251291643964e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.520703735351562500000000000000000000000e2), SC_(5.066537663266246113110833797028606010321e-1), SC_(4.933462336733753886889166202971393989679e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.527678222656250000000000000000000000000e2), SC_(5.109004497839167303506649299238041670602e-1), SC_(4.890995502160832696493350700761958329398e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.549066772460937500000000000000000000000e2), SC_(5.112935277081267067917183802321191632584e-1), SC_(4.887064722918732932082816197678808367416e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.575827636718750000000000000000000000000e2), SC_(5.151000018803481919275665059376693819429e-1), SC_(4.848999981196518080724334940623306180571e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.610375671386718750000000000000000000000e2), SC_(5.532774190595329773568358986142806273919e-1), SC_(4.467225809404670226431641013857193726081e-1) }}, 
      {{ SC_(1.586492462158203125000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.937356872558593750000000000000000000000e2), SC_(8.575195307535325938032348816818834519662e-1), SC_(1.424804692464674061967651183181165480338e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.929357147216796875000000000000000000000e2), SC_(9.570693338363647863966233790977164302073e-1), SC_(4.293066616363521360337662090228356979272e-2) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(2.160464935302734375000000000000000000000e2), SC_(9.936312098167122816693428079768950692299e-1), SC_(6.368790183287718330657192023104930770075e-3) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(2.500684204101562500000000000000000000000e2), SC_(9.999570111323311163869251662009930978716e-1), SC_(4.298886766888361307483379900690212837482e-5) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.339307861328125000000000000000000000000e2), SC_(9.999999999990898477350596006928546476215e-1), SC_(9.101522649403993071453523785479395095246e-13) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(5.071720275878906250000000000000000000000e2), SC_(9.999999999999999999999999999999992446714e-1), SC_(7.553285628081406613421098281032505838452e-34) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(7.169976806640625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.034440306131801239232616417495324791554e-60) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(8.966557617187500000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(5.979795998065211966101533775869991539086e-88) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.817954063415527343750000000000000000000e1), SC_(5.988753265225587518752371647765255044985e-51), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.557899093627929687500000000000000000000e1), SC_(3.297409121036376917885492387931709769599e-24), SC_(9.999999999999999999999967025908789636231e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(9.242980957031250000000000000000000000000e1), SC_(1.399496159692364017397380291747912089041e-8), SC_(9.999999860050384030763598260261970825209e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.389153137207031250000000000000000000000e2), SC_(7.409097283317391839862147646630111622763e-3), SC_(9.925909027166826081601378523533698883772e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.682266082763671875000000000000000000000e2), SC_(1.845296658630289633835156063015359872185e-1), SC_(8.154703341369710366164843936984640127815e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.863183288574218750000000000000000000000e2), SC_(4.782931939480897152103403659613009233946e-1), SC_(5.217068060519102847896596340386990766054e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(1.894562225341796875000000000000000000000e2), SC_(5.108147676790201602347777319752702843662e-1), SC_(4.891852323209798397652222680247297156338e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.913456726074218750000000000000000000000e2), SC_(5.143830848116127005671437929130779498563e-1), SC_(4.856169151883872994328562070869220501437e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.940798034667968750000000000000000000000e2), SC_(5.146794396478673622106924325632260673938e-1), SC_(4.853205603521326377893075674367739326062e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.947907104492187500000000000000000000000e2), SC_(5.179235364415607831328528877903097275843e-1), SC_(4.820764635584392168671471122096902724157e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.994744415283203125000000000000000000000e2), SC_(5.502964993590219270385473112401443511490e-1), SC_(4.497035006409780729614526887598556488510e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.224287109375000000000000000000000000000e2), SC_(8.215361047531186530855901271767420365538e-1), SC_(1.784638952468813469144098728232579634462e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.448358612060546875000000000000000000000e2), SC_(9.607653539733417566546051423634732187549e-1), SC_(3.923464602665824334539485763652678124509e-2) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.797699584960937500000000000000000000000e2), SC_(9.950735968942745740137551894384249776193e-1), SC_(4.926403105725425986244810561575022380737e-3) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(3.232840576171875000000000000000000000000e2), SC_(9.999775356527200454864217220993483652377e-1), SC_(2.246434727995451357827790065163476228905e-5) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(4.384578857421875000000000000000000000000e2), SC_(9.999999999999265958246637663877840919638e-1), SC_(7.340417533623361221590803620072446838485e-14) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(6.606170654296875000000000000000000000000e2), SC_(9.999999999999999999999999999999999998505e-1), SC_(1.495405398491226275087964053847305293663e-37) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(8.858258666992187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.901958885375072385460886694212133760345e-66) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(1.115665771484375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.173249103932186128352499946119116749783e-98) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.232429504394531250000000000000000000000e1), SC_(2.163929719177191468524755170035540163283e-52), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.802046203613281250000000000000000000000e1), SC_(2.067968834137357474821326712810344647456e-25), SC_(9.999999999999999999999997932031165862643e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(1.191342315673828125000000000000000000000e2), SC_(3.917328679134418894815255514139735584133e-9), SC_(9.999999960826713208655811051847444858603e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(1.796780700683593750000000000000000000000e2), SC_(5.339566756248631926860225488807671720889e-3), SC_(9.946604332437513680731397745111923282791e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.197577819824218750000000000000000000000e2), SC_(1.708531580970571327650813701038887134857e-1), SC_(8.291468419029428672349186298961112865143e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.417982025146484375000000000000000000000e2), SC_(4.749603690550220171599482767729191533452e-1), SC_(5.250396309449779828400517232270808466548e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.545200195312500000000000000000000000000e2), SC_(5.089513523466609067454739337356650561803e-1), SC_(4.910486476533390932545260662643349438197e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.568981933593750000000000000000000000000e2), SC_(5.127426218829053184905590285958233530112e-1), SC_(4.872573781170946815094409714041766469888e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.579666442871093750000000000000000000000e2), SC_(5.131031724104995960797124895154822517159e-1), SC_(4.868968275895004039202875104845177482841e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.608161621093750000000000000000000000000e2), SC_(5.165190859178221780332694080083143870117e-1), SC_(4.834809140821778219667305919916856129883e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.718913269042968750000000000000000000000e2), SC_(5.512121410321766096479654615090502594486e-1), SC_(4.487878589678233903520345384909497405514e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.961939086914062500000000000000000000000e2), SC_(8.366545858529221689541771572077297909458e-1), SC_(1.633454141470778310458228427922702090542e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(3.435539245605468750000000000000000000000e2), SC_(9.721742987034973281802971569042252236659e-1), SC_(2.782570129650267181970284309577477633409e-2) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(3.741084289550781250000000000000000000000e2), SC_(9.973644720722291219465862631447670511151e-1), SC_(2.635527927770878053413736855232948884914e-3) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.363779602050781250000000000000000000000e2), SC_(9.999955096976195693566897934533748950067e-1), SC_(4.490302380430643310206546625104993303492e-6) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(5.819423828125000000000000000000000000000e2), SC_(9.999999999999996003790385885952780960981e-1), SC_(3.996209614114047219039018561022122399207e-16) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(8.776324462890625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.388543444231666456941521536188971211311e-45) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(1.182280273437500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.064436632895761675948866836169504163204e-80) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(1.480474853515625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.166186374906501336816582508554153429163e-120) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(2.987887954711914062500000000000000000000e1), SC_(5.959781610202916084116446049668453446923e-57), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(7.525807189941406250000000000000000000000e1), SC_(5.055150657239756988495199659370575529021e-28), SC_(9.999999999999999999999999994944849342760e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(1.524954223632812500000000000000000000000e2), SC_(4.097371848342789724932006790675793489037e-10), SC_(9.999999995902628151657210275067993209324e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(2.309643859863281250000000000000000000000e2), SC_(3.066551680738491524054665788443709542280e-3), SC_(9.969334483192615084759453342115562904577e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(2.776045837402343750000000000000000000000e2), SC_(1.532517872144344328531169026138868912326e-1), SC_(8.467482127855655671468830973861131087674e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.082573852539062500000000000000000000000e2), SC_(4.707112047787123900588934935587748267659e-1), SC_(5.292887952212876099411065064412251732341e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.122604980468750000000000000000000000000e2), SC_(5.074994597061379314854992995930631219723e-1), SC_(4.925005402938620685145007004069368780277e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.182645263671875000000000000000000000000e2), SC_(5.114807947143102361427396505731193038857e-1), SC_(4.885192052856897638572603494268806961143e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.193109741210937500000000000000000000000e2), SC_(5.118738758657344977955250964379919519732e-1), SC_(4.881261241342655022044749035620080480268e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.197282104492187500000000000000000000000e2), SC_(5.155715314378513527890361691981481763495e-1), SC_(4.844284685621486472109638308018518236505e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.226386413574218750000000000000000000000e2), SC_(5.523368165575818280518090402930036636029e-1), SC_(4.476631834424181719481909597069963363971e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.518670654296875000000000000000000000000e2), SC_(8.488830238234888092518120556558660886900e-1), SC_(1.511169761765111907481879443441339113100e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.873213806152343750000000000000000000000e2), SC_(9.766082540264216600463015397991671372549e-1), SC_(2.339174597357833995369846020083286274510e-2) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(4.214648437500000000000000000000000000000e2), SC_(9.981404102532920866788207112982962278079e-1), SC_(1.859589746707913321179288701703772192093e-3) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(4.867719726562500000000000000000000000000e2), SC_(9.999979669494702582754212460824088205646e-1), SC_(2.033050529741724578753917591179435412450e-6) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(6.536495361328125000000000000000000000000e2), SC_(9.999999999999999765431087533508731029285e-1), SC_(2.345689124664912689707146530777187493352e-17) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(9.889467773437500000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.065957417014911561697654110856259100613e-49) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(1.337235351562500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.303547479382727619877351764775517787001e-88) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(1.677545898437500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.095894295178444588783931412140203015116e-133) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.409814453125000000000000000000000000000e1), SC_(4.141242719221779181226927842468965188856e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(8.562455749511718750000000000000000000000e1), SC_(7.477259324345562651019031782866869153740e-30), SC_(9.999999999999999999999999999925227406757e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(1.714850769042968750000000000000000000000e2), SC_(9.812862886421745485476581205515609153729e-11), SC_(9.999999999018713711357825451452341879448e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(2.599662780761718750000000000000000000000e2), SC_(2.182906112771322680800339986527665256395e-3), SC_(9.978170938872286773191996600134723347436e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.148807373046875000000000000000000000000e2), SC_(1.423980808820912877869072132116286433199e-1), SC_(8.576019191179087122130927867883713566801e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.477438964843750000000000000000000000000e2), SC_(4.683225351892631620326640590152385463786e-1), SC_(5.316774648107368379673359409847614536214e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.509731140136718750000000000000000000000e2), SC_(5.066718603378133369924578016879551097593e-1), SC_(4.933281396621866630075421983120448902407e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.517215576171875000000000000000000000000e2), SC_(5.109174073874902580683265800264003113874e-1), SC_(4.890825926125097419316734199735996886126e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.528360595703125000000000000000000000000e2), SC_(5.113260518606027027477842739187573028522e-1), SC_(4.886739481393972972522157260812426971478e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.537154541015625000000000000000000000000e2), SC_(5.151487422641237236705832024889533787294e-1), SC_(4.848512577358762763294167975110466212706e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.571325683593750000000000000000000000000e2), SC_(5.532186968703824948841570505330183729682e-1), SC_(4.467813031296175051158429494669816270318e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.893357849121093750000000000000000000000e2), SC_(8.568466125395117209913530153187213582190e-1), SC_(1.431533874604882790086469846812786417810e-1) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.272539978027343750000000000000000000000e2), SC_(9.801180310646984764126489446902913273206e-1), SC_(1.988196893530152358735105530970867267944e-2) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.659190979003906250000000000000000000000e2), SC_(9.986716437101334251103538766347867780151e-1), SC_(1.328356289866574889646123365213221984926e-3) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(5.379552001953125000000000000000000000000e2), SC_(9.999991099368246658205889417794929985556e-1), SC_(8.900631753341794110582205070014444102557e-7) }}, 
      {{ SC_(1.598230590820312500000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(7.182306518554687500000000000000000000000e2), SC_(9.999999999999999982837422275207207927853e-1), SC_(1.716257772479279207214667997767140971680e-18) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.836375122070312500000000000000000000000e2), SC_(9.999999999999999999999999999999990588450e-1), SC_(9.411550281838102923470078406950247081572e-34) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(6.664895019531250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.511174488215685156177655321490905004278e-59) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(8.357251586914062500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.891650053518411293515854764791917087363e-86) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.673981475830078125000000000000000000000e1), SC_(7.208524540900774420980441153156522493139e-51), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(4.237252426147460937500000000000000000000e1), SC_(3.959831160055268267719778788363849050906e-24), SC_(9.999999999999999999999960401688399447317e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(8.984108734130859375000000000000000000000e1), SC_(1.449885724720183512758480436321496638399e-8), SC_(9.999999855011427527981648724151956367850e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.348229064941406250000000000000000000000e2), SC_(7.503099346090090931012875458573533007255e-3), SC_(9.924969006539099090689871245414264669927e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.640053405761718750000000000000000000000e2), SC_(1.850322192999108129348267563090565766109e-1), SC_(8.149677807000891870651732436909434233891e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.809212341308593750000000000000000000000e2), SC_(4.784940795543486072365283356520462701374e-1), SC_(5.215059204456513927634716643479537298626e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(1.851070709228515625000000000000000000000e2), SC_(5.109124373467922793983564936979261264885e-1), SC_(4.890875626532077206016435063020738735115e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.856531829833984375000000000000000000000e2), SC_(5.145066107735198902278062104032361046002e-1), SC_(4.854933892264801097721937895967638953998e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.873699493408203125000000000000000000000e2), SC_(5.148290490554282195844938127378373389996e-1), SC_(4.851709509445717804155061872621626610004e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.888217315673828125000000000000000000000e2), SC_(5.180460939122323130966438539297914870120e-1), SC_(4.819539060877676869033561460702085129880e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(1.919794006347656250000000000000000000000e2), SC_(5.502999980621038227318295794586899489426e-1), SC_(4.497000019378961772681704205413100510574e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.109562683105468750000000000000000000000e2), SC_(8.199221256656962310345997435233109549343e-1), SC_(1.800778743343037689654002564766890450657e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.333917846679687500000000000000000000000e2), SC_(9.597114951937012288931477636311578972547e-1), SC_(4.028850480629877110685223636884210274535e-2) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.535374755859375000000000000000000000000e2), SC_(9.943904789705793643229393670858182292180e-1), SC_(5.609521029420635677060632914181770781952e-3) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.968983154296875000000000000000000000000e2), SC_(9.999700711958033254582401949830478017134e-1), SC_(2.992880419667454175980501695219828658433e-5) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(4.052813720703125000000000000000000000000e2), SC_(9.999999999998053068868268151191991514180e-1), SC_(1.946931131731848808008485820248576864107e-13) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(6.133878173828125000000000000000000000000e2), SC_(9.999999999999999999999999999999999967322e-1), SC_(3.267831108405804626730741972593913791660e-36) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(8.625616455078125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.685454645623702964919536275267021583122e-65) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(1.079777343750000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.690478158248361837341225995074508479597e-97) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.196616935729980468750000000000000000000e1), SC_(2.449076079492404979243117764110687428286e-52), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(5.515960693359375000000000000000000000000e1), SC_(4.143384173381787260935714359633903223275e-25), SC_(9.999999999999999999999995856615826618213e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(1.109446105957031250000000000000000000000e2), SC_(6.064341225407951538056448983340771517366e-9), SC_(9.999999939356587745920484619435510166592e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(1.676744232177734375000000000000000000000e2), SC_(5.944081810752263217222352759287449103059e-3), SC_(9.940559181892477367827776472407125508969e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.013081359863281250000000000000000000000e2), SC_(1.760892028448021934206614946943786176282e-1), SC_(8.239107971551978065793385053056213823718e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.301894683837890625000000000000000000000e2), SC_(4.756803357482827849403719043497487170389e-1), SC_(5.243196642517172150596280956502512829611e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.384625244140625000000000000000000000000e2), SC_(5.093992445197505854090646418686190971786e-1), SC_(4.906007554802494145909353581313809028214e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.400035095214843750000000000000000000000e2), SC_(5.131455262946957204446046204483712969009e-1), SC_(4.868544737053042795553953795516287030991e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.446325225830078125000000000000000000000e2), SC_(5.134130199596818611661711660989597667243e-1), SC_(4.865869800403181388338288339010402332757e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.449180297851562500000000000000000000000e2), SC_(5.168304121527725570745962870255053570190e-1), SC_(4.831695878472274429254037129744946429810e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.577596130371093750000000000000000000000e2), SC_(5.509761776008344765194672410118898493109e-1), SC_(4.490238223991655234805327589881101506891e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.830640258789062500000000000000000000000e2), SC_(8.339104591737248970023320129969575160359e-1), SC_(1.660895408262751029976679870030424839641e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(3.100483703613281250000000000000000000000e2), SC_(9.684750067094448277994045531858596207883e-1), SC_(3.152499329055517220059544681414037921166e-2) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(3.392848205566406250000000000000000000000e2), SC_(9.966449755730414395437622134620519907721e-1), SC_(3.355024426958560456237786537948009227855e-3) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(4.044481811523437500000000000000000000000e2), SC_(9.999927748392568031470877401776304350943e-1), SC_(7.225160743196852912259822369564905705803e-6) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(5.393998413085937500000000000000000000000e2), SC_(9.999999999999980174726924111427950575215e-1), SC_(1.982527307588857204942478500177738763493e-15) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(8.601829833984375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.860125192704301234962313043245005432233e-44) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(1.152833984375000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.856204532143472635601253254153847770268e-79) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(1.456756835937500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.429765933761755562836278014229726804580e-119) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(2.914039421081542968750000000000000000000e1), SC_(1.583737911039139748821669811285359056509e-56), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(7.324423217773437500000000000000000000000e1), SC_(1.011126440669768389869408237461836645396e-27), SC_(9.999999999999999999999999989888735593302e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(1.480014190673828125000000000000000000000e2), SC_(5.551166632798585932931381609128460447320e-10), SC_(9.999999994448833367201414067068618390872e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(2.223957824707031250000000000000000000000e2), SC_(3.366648545681736211276551408060230254030e-3), SC_(9.966333514543182637887234485919397697460e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(2.692994079589843750000000000000000000000e2), SC_(1.556206348603064273847534684792847515458e-1), SC_(8.443793651396935726152465315207152484542e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(2.984503784179687500000000000000000000000e2), SC_(4.713025806692654166931476745047267639077e-1), SC_(5.286974193307345833068523254952732360923e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.051181640625000000000000000000000000000e2), SC_(5.076617940174420004497605485758792818655e-1), SC_(4.923382059825579995502394514241207181345e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.083852539062500000000000000000000000000e2), SC_(5.116623634398308914430303795924212075663e-1), SC_(4.883376365601691085569696204075787924337e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.089132080078125000000000000000000000000e2), SC_(5.120603296537036284938455474083122204761e-1), SC_(4.879396703462963715061544525916877795239e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.121156616210937500000000000000000000000e2), SC_(5.156792456428944191198127075691827388087e-1), SC_(4.843207543571055808801872924308172611913e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.161358642578125000000000000000000000000e2), SC_(5.521982318626555381142866447673480515012e-1), SC_(4.478017681373444618857133552326519484988e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.505669860839843750000000000000000000000e2), SC_(8.487050777584280358335151818784692531650e-1), SC_(1.512949222415719641664848181215307468350e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.836541748046875000000000000000000000000e2), SC_(9.763070494376406131330903437352442833676e-1), SC_(2.369295056235938686690965626475571663241e-2) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.157940063476562500000000000000000000000e2), SC_(9.980672469380236432808120865529597983202e-1), SC_(1.932753061976356719187913447040201679848e-3) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.798154907226562500000000000000000000000e2), SC_(9.999977483471995952502136914485375358539e-1), SC_(2.251652800404749786308551462464146110750e-6) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(6.406237792968750000000000000000000000000e2), SC_(9.999999999999999614883059049591264923544e-1), SC_(3.851169409504087350764559649431971122908e-17) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(9.696016845703125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.357414814139726760815218443569757205529e-48) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(1.298545898437500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.145876571447359579691097635342834228256e-86) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(1.624736938476562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.710906303838141192178132575636562273686e-129) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.272574996948242187500000000000000000000e1), SC_(3.893670014283447801282981972232212080198e-59), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(8.252041625976562500000000000000000000000e1), SC_(2.516733046201041086736246447744491549060e-29), SC_(9.999999999999999999999999999748326695380e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(1.673707885742187500000000000000000000000e2), SC_(1.316672691376538893890786576869703339106e-10), SC_(9.999999998683327308623461106109213423130e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(2.519564666748046875000000000000000000000e2), SC_(2.390597937623021870380817326627620535424e-3), SC_(9.976094020623769781296191826733723794646e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.072727661132812500000000000000000000000e2), SC_(1.444555919813087896335585472308637160393e-1), SC_(8.555444080186912103664414527691362839607e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.395016479492187500000000000000000000000e2), SC_(4.687934571949234256083321587882749350632e-1), SC_(5.312065428050765743916678412117250649368e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.430595397949218750000000000000000000000e2), SC_(5.068311266747084782960453920886209251575e-1), SC_(4.931688733252915217039546079113790748425e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.470544433593750000000000000000000000000e2), SC_(5.109912904886728083015962513958425769669e-1), SC_(4.890087095113271916984037486041574230331e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.503352661132812500000000000000000000000e2), SC_(5.113645730658084045485536335818710826586e-1), SC_(4.886354269341915954514463664181289173414e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.520409240722656250000000000000000000000e2), SC_(5.151694492412412046868539612772668237338e-1), SC_(4.848305507587587953131460387227331762662e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.552747802734375000000000000000000000000e2), SC_(5.531868964017089215994436543245300699992e-1), SC_(4.468131035982910784005563456754699300008e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.873697204589843750000000000000000000000e2), SC_(8.565275777918925039489648816125578723296e-1), SC_(1.434724222081074960510351183874421276704e-1) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.238802490234375000000000000000000000000e2), SC_(9.798779649518852100945017491233989549085e-1), SC_(2.012203504811478990549825087660104509155e-2) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.599332275390625000000000000000000000000e2), SC_(9.986145017613672350268257845118983760535e-1), SC_(1.385498238632764973174215488101623946525e-3) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.310440673828125000000000000000000000000e2), SC_(9.999990120783746439128695918116272257489e-1), SC_(9.879216253560871304081883727742511206611e-7) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(7.087487792968750000000000000000000000000e2), SC_(9.999999999999999975333181168580100858100e-1), SC_(2.466681883141989914190014136150487502214e-18) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(1.069433227539062500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.267823483850436099742328580810813935661e-52) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(1.435328369140625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.648847699132163811874733873699785851255e-94) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(1.795347656250000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.494787470905363298638897232569954102121e-140) }}, 
      {{ SC_(1.602558135986328125000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.595481109619140625000000000000000000000e1), SC_(1.138485027491722401913967154213658563032e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(4.102167510986328125000000000000000000000e1), SC_(1.688140497517798307963164499194198786378e-24), SC_(9.999999999999999999999983118595024822017e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(8.474828338623046875000000000000000000000e1), SC_(1.222807063350542462722177270062505098232e-8), SC_(9.999999877719293664945753727782272993749e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.275144195556640625000000000000000000000e2), SC_(7.275867710603546637074402152574043974626e-3), SC_(9.927241322893964533629255978474259560254e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.532451019287109375000000000000000000000e2), SC_(1.843948488248935732284636649058550422915e-1), SC_(8.156051511751064267715363350941449577085e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.706406402587890625000000000000000000000e2), SC_(4.784912138472802461845166971327721517425e-1), SC_(5.215087861527197538154833028672278482575e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.823738098144531250000000000000000000000e2), SC_(5.108866962368173617076685703868733821573e-1), SC_(4.891133037631826382923314296131266178427e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.826380920410156250000000000000000000000e2), SC_(5.145066528296554228714059018200652092287e-1), SC_(4.854933471703445771285940981799347907713e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.851208648681640625000000000000000000000e2), SC_(5.148210624939973933120702528985128602972e-1), SC_(4.851789375060026066879297471014871397028e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.858085479736328125000000000000000000000e2), SC_(5.180725224983938766895203921514510305746e-1), SC_(4.819274775016061233104796078485489694254e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(1.900482330322265625000000000000000000000e2), SC_(5.504822617840749077709821681668316249193e-1), SC_(4.495177382159250922290178318331683750807e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.073801116943359375000000000000000000000e2), SC_(8.209053557827910655073253172355436031099e-1), SC_(1.790946442172089344926746827644563968901e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.282704925537109375000000000000000000000e2), SC_(9.601670163888846522926655064628846332422e-1), SC_(3.983298361111534770733449353711536675783e-2) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.489594573974609375000000000000000000000e2), SC_(9.945229769747383974717112293919766499984e-1), SC_(5.477023025261602528288770608023350001569e-3) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.894291992187500000000000000000000000000e2), SC_(9.999708295592941665135304716687568692901e-1), SC_(2.917044070583348646952833124313070994973e-5) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(3.893052368164062500000000000000000000000e2), SC_(9.999999999997752352224257862170077309425e-1), SC_(2.247647775742137829922690575132075421171e-13) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(5.921020507812500000000000000000000000000e2), SC_(9.999999999999999999999999999999999942656e-1), SC_(5.734409611226432068947254849467064372523e-36) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(7.916121826171875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.863350493514311088900064590356034732944e-63) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.004031982421875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.359633921279777761945978150160143827412e-93) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.055148696899414062500000000000000000000e1), SC_(1.592659369404402772961201056667457480996e-52), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(5.183420562744140625000000000000000000000e1), SC_(4.458458560489953227586823664858694858388e-25), SC_(9.999999999999999999999995541541439510047e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(1.092573013305664062500000000000000000000e2), SC_(5.417528330763532411901322732178457735177e-9), SC_(9.999999945824716692364675880986772678215e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(1.641222381591796875000000000000000000000e2), SC_(5.891527513165444424230189475942838588804e-3), SC_(9.941084724868345555757698105240571614112e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.002822875976562500000000000000000000000e2), SC_(1.750659378388011216815330463085500015613e-1), SC_(8.249340621611988783184669536914499984387e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.212775115966796875000000000000000000000e2), SC_(4.760366878925385022008733664667964388119e-1), SC_(5.239633121074614977991266335332035611881e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.245386505126953125000000000000000000000e2), SC_(5.097652046299679348361736784065825551375e-1), SC_(4.902347953700320651638263215934174448625e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.264400939941406250000000000000000000000e2), SC_(5.134675106190230875081512107011352528865e-1), SC_(4.865324893809769124918487892988647471135e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.265725555419921875000000000000000000000e2), SC_(5.138395852225048956594691321796275926191e-1), SC_(4.861604147774951043405308678203724073809e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.356241912841796875000000000000000000000e2), SC_(5.170254731480892003560977232685144466464e-1), SC_(4.829745268519107996439022767314855533536e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.439911651611328125000000000000000000000e2), SC_(5.509129740124357351030734975105801273291e-1), SC_(4.490870259875642648969265024894198726709e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.671654968261718750000000000000000000000e2), SC_(8.314910696748083820342353358209604678053e-1), SC_(1.685089303251916179657646641790395321947e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.969787292480468750000000000000000000000e2), SC_(9.674882131756639276900827361607091854220e-1), SC_(3.251178682433607230991726383929081457798e-2) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(3.218117980957031250000000000000000000000e2), SC_(9.963430306452977857262381447854223904387e-1), SC_(3.656969354702214273761855214577609561271e-3) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(3.871225891113281250000000000000000000000e2), SC_(9.999912979853052853857409404831646438279e-1), SC_(8.702014694714614259059516835356172075424e-6) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(5.204102783203125000000000000000000000000e2), SC_(9.999999999999967056930138334707122634489e-1), SC_(3.294306986166529287736551086386940885477e-15) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(7.837434082031250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.750365710965323187070565942497474345837e-42) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(1.055450195312500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.928642183143624778532518562061604830604e-75) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(1.362531494140625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.029106870092005444429693229337273759637e-113) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.725741386413574218750000000000000000000e1), SC_(6.461475397131317911253089094154841312650e-56), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(7.240046691894531250000000000000000000000e1), SC_(7.824167508356573708209221422643234721401e-28), SC_(9.999999999999999999999999992175832491643e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(1.455413360595703125000000000000000000000e2), SC_(5.659842249507354448110078229298320147911e-10), SC_(9.999999994340157750492645551889921770702e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(2.206691894531250000000000000000000000000e2), SC_(3.330863040614532243986954309644485531641e-3), SC_(9.966691369593854677560130456903555144684e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(2.648503112792968750000000000000000000000e2), SC_(1.560957922122950306714430729404655214295e-1), SC_(8.439042077877049693285569270595344785705e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(2.928926086425781250000000000000000000000e2), SC_(4.715149593845736597598775989542690147531e-1), SC_(5.284850406154263402401224010457309852469e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.985781555175781250000000000000000000000e2), SC_(5.078012180890575926312959349209529626623e-1), SC_(4.921987819109424073687040650790470373377e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(2.994019165039062500000000000000000000000e2), SC_(5.118328726558574934126871642298541233347e-1), SC_(4.881671273441425065873128357701458766653e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.021259460449218750000000000000000000000e2), SC_(5.121862435080432205655938818198346609484e-1), SC_(4.878137564919567794344061181801653390516e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.046435852050781250000000000000000000000e2), SC_(5.157995063285204817900457449021481942800e-1), SC_(4.842004936714795182099542550978518057200e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.113807678222656250000000000000000000000e2), SC_(5.522116790139512795494066597569781477135e-1), SC_(4.477883209860487204505933402430218522865e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.423854064941406250000000000000000000000e2), SC_(8.476437044401252128445187883172746998080e-1), SC_(1.523562955598747871554812116827253001920e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.741078186035156250000000000000000000000e2), SC_(9.757122912646984693758294404572558931057e-1), SC_(2.428770873530153062417055954274410689430e-2) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.090814514160156250000000000000000000000e2), SC_(9.980198126052688558986691253621387244580e-1), SC_(1.980187394731144101330874637861275541999e-3) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(4.738200073242187500000000000000000000000e2), SC_(9.999976649923323265567905262771550384995e-1), SC_(2.335007667673443209473722844961500455875e-6) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(6.431429443359375000000000000000000000000e2), SC_(9.999999999999999706227930613930392326573e-1), SC_(2.937720693860696076734270823538817289450e-17) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(9.677579956054687500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.511177135296502130515309707903202018125e-48) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(1.290862915039062500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.361879657699109860681304583357221194930e-86) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(1.613755859375000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.033093603218028514313828964615645242030e-129) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.231861114501953125000000000000000000000e1), SC_(2.045574151812155471703345448020721133687e-59), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(8.151868438720703125000000000000000000000e1), SC_(2.226051127735723989410595176673993607313e-29), SC_(9.999999999999999999999999999777394887226e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(1.637553405761718750000000000000000000000e2), SC_(1.499499461178407147407367468486507843373e-10), SC_(9.999999998500500538821592852592632531513e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(2.458661956787109375000000000000000000000e2), SC_(2.497645462529884703009834377297974775065e-3), SC_(9.975023545374701152969901656227020252249e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(2.971185302734375000000000000000000000000e2), SC_(1.466428140477884378897763150676267062947e-1), SC_(8.533571859522115621102236849323732937053e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.296263122558593750000000000000000000000e2), SC_(4.692663002829133831001411461957592900177e-1), SC_(5.307336997170866168998588538042407099823e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.372781677246093750000000000000000000000e2), SC_(5.069398949419523245042226029435087158363e-1), SC_(4.930601050580476754957773970564912841637e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.388161315917968750000000000000000000000e2), SC_(5.111263312348596199021883466575094580027e-1), SC_(4.888736687651403800978116533424905419973e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.443228149414062500000000000000000000000e2), SC_(5.114601283958852114026475076960853449249e-1), SC_(4.885398716041147885973524923039146550751e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.461510009765625000000000000000000000000e2), SC_(5.152502752507040443219387579063894752132e-1), SC_(4.847497247492959556780612420936105247868e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.497398681640625000000000000000000000000e2), SC_(5.531553669224508830123111393798667905713e-1), SC_(4.468446330775491169876888606201332094287e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.849215087890625000000000000000000000000e2), SC_(8.566272824452111890768091080074436740107e-1), SC_(1.433727175547888109231908919925563259893e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(4.238093566894531250000000000000000000000e2), SC_(9.801175136641996577210705843021400730258e-1), SC_(1.988248633580034227892941569785992697416e-2) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.609324340820312500000000000000000000000e2), SC_(9.986571361207000269564011683602360213241e-1), SC_(1.342863879299973043598831639763978675905e-3) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.319470825195312500000000000000000000000e2), SC_(9.999990780318954278611521462784621364275e-1), SC_(9.219681045721388478537215378635724557163e-7) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(7.100570068359375000000000000000000000000e2), SC_(9.999999999999999980068057003443881029386e-1), SC_(1.993194299655611897061387331798595201791e-18) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(1.068323242187500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.255030133349220254412931599628772187623e-52) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(1.426676025390625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.362134988246259646725014504871721964890e-93) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(1.784517822265625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.684774386923034335712970165899734419181e-140) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.572485733032226562500000000000000000000e1), SC_(4.836045946499507207202961170058175579692e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(8.983798217773437500000000000000000000000e1), SC_(6.995833148323670518425846180031863868643e-31), SC_(9.999999999999999999999999999993004166852e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(1.808531341552734375000000000000000000000e2), SC_(4.057286237045208566636785367139639240052e-11), SC_(9.999999999594271376295479143336321463286e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(2.714577941894531250000000000000000000000e2), SC_(1.846524148263094250027447394628043746310e-3), SC_(9.981534758517369057499725526053719562537e-1) }}, 
      {{ SC_(1.631300048828125000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.261800231933593750000000000000000000000e2), SC_(1.384912339962814326890192754125986664472e-1), SC_(8.615087660037185673109807245874013335528e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.664421691894531250000000000000000000000e2), SC_(4.779766711013397897146894886742960878527e-1), SC_(5.220233288986602102853105113257039121473e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.733597259521484375000000000000000000000e2), SC_(5.108706546657225748847055211756376441423e-1), SC_(4.891293453342774251152944788243623558577e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.740559234619140625000000000000000000000e2), SC_(5.145144370147239183272848042352436489666e-1), SC_(4.854855629852760816727151957647563510334e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.743264770507812500000000000000000000000e2), SC_(5.148768991552688837180996454895543799423e-1), SC_(4.851231008447311162819003545104456200577e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.765773925781250000000000000000000000000e2), SC_(5.181381005491163885166420496134021333696e-1), SC_(4.818618994508836114833579503865978666304e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.884589996337890625000000000000000000000e2), SC_(5.507436518499100328791098559257522479311e-1), SC_(4.492563481500899671208901440742477520689e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.053422546386718750000000000000000000000e2), SC_(8.228200935401360618683012679425205959868e-1), SC_(1.771799064598639381316987320574794040132e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.269668731689453125000000000000000000000e2), SC_(9.613978247261713932617431218197790365355e-1), SC_(3.860217527382860673825687818022096346449e-2) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.465574798583984375000000000000000000000e2), SC_(9.948197435884916449536380931668343782724e-1), SC_(5.180256411508355046361906833165621727622e-3) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.883048706054687500000000000000000000000e2), SC_(9.999745525262401021180394493869279250095e-1), SC_(2.544747375989788196055061307207499049435e-5) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(3.851281433105468750000000000000000000000e2), SC_(9.999999999998389617990455639971957961238e-1), SC_(1.610382009544360028042038762033094838424e-13) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(5.827863159179687500000000000000000000000e2), SC_(9.999999999999999999999999999999999969030e-1), SC_(3.097045018168169634133734395538870192421e-36) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(7.821759033203125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.302262998377234048664056747860718406271e-63) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(9.849475097656250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(8.170807051786698523668057752306776430918e-94) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.986893272399902343750000000000000000000e1), SC_(2.068383057763205727362399200171838061929e-53), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(5.035100936889648437500000000000000000000e1), SC_(2.027565664151689294705389288645871786258e-25), SC_(9.999999999999999999999997972434335848311e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.009698638916015625000000000000000000000e2), SC_(5.772235212717535443972776143885169057885e-9), SC_(9.999999942277647872824645560272238561148e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.536323242187500000000000000000000000000e2), SC_(6.007601722916313336054732127756058454390e-3), SC_(9.939923982770836866639452678722439415456e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.885964050292968750000000000000000000000e2), SC_(1.760565432335908631899184946127165848836e-1), SC_(8.239434567664091368100815053872834151164e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.092597656250000000000000000000000000000e2), SC_(4.764177708740347828778797785099694052873e-1), SC_(5.235822291259652171221202214900305947127e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.223287506103515625000000000000000000000e2), SC_(5.097699456384067972389553252164180831586e-1), SC_(4.902300543615932027610446747835819168414e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.228663482666015625000000000000000000000e2), SC_(5.135256724475241404338456185330856501378e-1), SC_(4.864743275524758595661543814669143498622e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.265952453613281250000000000000000000000e2), SC_(5.138133680467338420758755301225226804577e-1), SC_(4.861866319532661579241244698774773195423e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.277768707275390625000000000000000000000e2), SC_(5.171891600572094347881811898461377469046e-1), SC_(4.828108399427905652118188101538622530954e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.310881042480468750000000000000000000000e2), SC_(5.509784416291935664437379420264019107183e-1), SC_(4.490215583708064335562620579735980892817e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.535244750976562500000000000000000000000e2), SC_(8.302625098021913920021086317552880324165e-1), SC_(1.697374901978086079978913682447119675835e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.767039184570312500000000000000000000000e2), SC_(9.660569195075744937097193519054288613400e-1), SC_(3.394308049242550629028064809457113865999e-2) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(3.112531433105468750000000000000000000000e2), SC_(9.962668893465637648204199635863579166522e-1), SC_(3.733110653436235179580036413642083347846e-3) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(3.684181518554687500000000000000000000000e2), SC_(9.999897925960712172544621206392346282081e-1), SC_(1.020740392878274553787936076537179189539e-5) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.938287963867187500000000000000000000000e2), SC_(9.999999999999936660004204677517910195108e-1), SC_(6.333999579532248208980489219335558523667e-15) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(7.545568847656250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.385566600510519753928579581058227105258e-41) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(1.006336914062500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.919794515061501006167119908106247213267e-73) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(1.310592163085937500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.436041191669181099913826717678909246858e-111) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.642418289184570312500000000000000000000e1), SC_(2.444188251300665889480268294323896866756e-56), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(6.632112884521484375000000000000000000000e1), SC_(2.886226942320935272935152992655889650557e-27), SC_(9.999999999999999999999999971137730576791e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(1.339496154785156250000000000000000000000e2), SC_(9.858003504855630994811787273916241031403e-10), SC_(9.999999990141996495144369005188212726084e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.074072570800781250000000000000000000000e2), SC_(3.682650385999991362606825672978629950646e-3), SC_(9.963173496140000086373931743270213700494e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.489497222900390625000000000000000000000e2), SC_(1.595094217770457340618620299182674986371e-1), SC_(8.404905782229542659381379700817325013629e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.907021789550781250000000000000000000000e2), SC_(4.714540962310060302906905775205450134063e-1), SC_(5.285459037689939697093094224794549865937e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.948242797851562500000000000000000000000e2), SC_(5.078682956594048505623009048597369033737e-1), SC_(4.921317043405951494376990951402630966263e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(2.982622680664062500000000000000000000000e2), SC_(5.118516347025868446696621695311826379338e-1), SC_(4.881483652974131553303378304688173620662e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(2.983446655273437500000000000000000000000e2), SC_(5.122564728209114765940890255922527458081e-1), SC_(4.877435271790885234059109744077472541919e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(3.001877136230468750000000000000000000000e2), SC_(5.158821529539984011028514477987972876897e-1), SC_(4.841178470460015988971485522012027123103e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.059428710937500000000000000000000000000e2), SC_(5.522684934890695291330928736805671683592e-1), SC_(4.477315065109304708669071263194328316408e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.337824707031250000000000000000000000000e2), SC_(8.468360395503375807388260704981786994704e-1), SC_(1.531639604496624192611739295018213005296e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.673589477539062500000000000000000000000e2), SC_(9.755357855785878725160377115798454984295e-1), SC_(2.446421442141212748396228842015450157049e-2) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(4.008886718750000000000000000000000000000e2), SC_(9.979736046657400260639421114164716457252e-1), SC_(2.026395334259973936057888583528354274819e-3) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.685017089843750000000000000000000000000e2), SC_(9.999976669199228653879623764302977648508e-1), SC_(2.333080077134612037623569702235149213657e-6) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(6.305922851562500000000000000000000000000e2), SC_(9.999999999999999622063603760603109409523e-1), SC_(3.779363962393968905904765210751166826768e-17) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(9.473796386718750000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.204220343414628505153486150447079929681e-48) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(1.274858886718750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.110927542965173995098558291571221591566e-86) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(1.599583496093750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.448279259184714036204419772362969960272e-129) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.256081771850585937500000000000000000000e1), SC_(1.987564301248108767602645025588093827857e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(8.165567016601562500000000000000000000000e1), SC_(9.853488595032242812881703516591125311055e-30), SC_(9.999999999999999999999999999901465114050e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(1.633762207031250000000000000000000000000e2), SC_(1.255600257347747041659487175593500773161e-10), SC_(9.999999998744399742652252958340512824406e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(2.450909118652343750000000000000000000000e2), SC_(2.422154378135604730852236055574801457634e-3), SC_(9.975778456218643952691477639444251985424e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(2.945004882812500000000000000000000000000e2), SC_(1.463384912429847457494625833802131111228e-1), SC_(8.536615087570152542505374166197868888772e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.268103332519531250000000000000000000000e2), SC_(4.692640219095721269224126046943006243627e-1), SC_(5.307359780904278730775873953056993756373e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.312158203125000000000000000000000000000e2), SC_(5.070505980454182397836994201758563061810e-1), SC_(4.929494019545817602163005798241436938190e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.318582763671875000000000000000000000000e2), SC_(5.112429929311399448197622382805486658689e-1), SC_(4.887570070688600551802377617194513341311e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.342018127441406250000000000000000000000e2), SC_(5.116245532326515923657959401634581103930e-1), SC_(4.883754467673484076342040598365418896070e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.373295593261718750000000000000000000000e2), SC_(5.153738049436796937476311457679623320086e-1), SC_(4.846261950563203062523688542320376679914e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.450690002441406250000000000000000000000e2), SC_(5.531990973886113003009993318655448770025e-1), SC_(4.468009026113886996990006681344551229975e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.771381225585937500000000000000000000000e2), SC_(8.558968352948536722656303312738753665662e-1), SC_(1.441031647051463277343696687261246334338e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.179901123046875000000000000000000000000e2), SC_(9.799958924087051347641993025351694978223e-1), SC_(2.000410759129486523580069746483050217772e-2) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.547944030761718750000000000000000000000e2), SC_(9.986401191499408854252225491282349185539e-1), SC_(1.359880850059114574777450871765081446113e-3) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(5.254707031250000000000000000000000000000e2), SC_(9.999990530548292000571732809972646178366e-1), SC_(9.469451707999428267190027353821634125199e-7) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(7.079306640625000000000000000000000000000e2), SC_(9.999999999999999982696141544782069237819e-1), SC_(1.730385845521793076218124451087763925707e-18) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(1.071633300781250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.189904226930539909922018638666734288954e-52) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(1.434400390625000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.029173028349022486988584547133661159193e-94) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(1.793340454101562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.281232275988992497667337715642659115906e-141) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.590652084350585937500000000000000000000e1), SC_(5.634084092706225546396609104910307998931e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(9.003610229492187500000000000000000000000e1), SC_(3.144442533906394251126708997605338415369e-31), SC_(9.999999999999999999999999999996855557466e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(1.803528442382812500000000000000000000000e2), SC_(3.477005660893807141467205780919626293359e-11), SC_(9.999999999652299433910619285853279421908e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(2.707052001953125000000000000000000000000e2), SC_(1.795342508328501664010438040320487195586e-3), SC_(9.982046574916714983359895619596795128044e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.251567382812500000000000000000000000000e2), SC_(1.378508770784769049737424175063541799336e-1), SC_(8.621491229215230950262575824936458200664e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.597547607421875000000000000000000000000e2), SC_(4.673405336688780177015000288375656143489e-1), SC_(5.326594663311219822984999711624343856511e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.653772277832031250000000000000000000000e2), SC_(5.063649806710630047912075144600176885452e-1), SC_(4.936350193289369952087924855399823114548e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.659804077148437500000000000000000000000e2), SC_(5.107026302988849429638945711853317834892e-1), SC_(4.892973697011150570361054288146682165108e-1) }}, 
      {{ SC_(1.671667022705078125000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.664956359863281250000000000000000000000e2), SC_(5.111300197278608513503391871187108033195e-1), SC_(4.888699802721391486496608128812891966805e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.769411773681640625000000000000000000000e2), SC_(5.179189192416087824924420132051893474286e-1), SC_(4.820810807583912175075579867948106525714e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.839960174560546875000000000000000000000e2), SC_(5.513110299721553218237850786367987725932e-1), SC_(4.486889700278446781762149213632012274068e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(2.009666290283203125000000000000000000000e2), SC_(8.273908704104600005687505570987213886085e-1), SC_(1.726091295895399994312494429012786113915e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(2.195400543212890625000000000000000000000e2), SC_(9.640199064344190745604969186882255930666e-1), SC_(3.598009356558092543950308131177440693339e-2) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(2.405545806884765625000000000000000000000e2), SC_(9.954812568777056247426817632011896685083e-1), SC_(4.518743122294375257318236798810331491656e-3) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.928511047363281250000000000000000000000e2), SC_(9.999823121009826831032256443240219496782e-1), SC_(1.768789901731689677435567597805032178446e-5) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(3.906315917968750000000000000000000000000e2), SC_(9.999999999999462276067805724041044886130e-1), SC_(5.377239321942759589551138703924079446611e-14) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(5.933402099609375000000000000000000000000e2), SC_(9.999999999999999999999999999999999998617e-1), SC_(1.383457376467341632457751726746559364262e-37) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(7.932024536132812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.721887429275702348365274558393143746143e-66) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(1.004221313476562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.382987629182647063392033634843746534214e-97) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.012050819396972656250000000000000000000e1), SC_(6.892552656102166342469620795417095598154e-56), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(5.072577667236328125000000000000000000000e1), SC_(1.727626929617828101261129524587872331135e-26), SC_(9.999999999999999999999999827237307038217e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.020924911499023437500000000000000000000e2), SC_(2.762920665636996198759683452612074319749e-9), SC_(9.999999972370793343630038012403165473879e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(1.542228851318359375000000000000000000000e2), SC_(5.203628776663447287365867779844150547589e-3), SC_(9.947963712233365527126341322201558494524e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.865972900390625000000000000000000000000e2), SC_(1.719018224553095704799489288699680565611e-1), SC_(8.280981775446904295200510711300319434389e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.079445953369140625000000000000000000000e2), SC_(4.757206985361444475600365175075675211769e-1), SC_(5.242793014638555524399634824924324788231e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.103701782226562500000000000000000000000e2), SC_(5.099212407023403843934587417049622713132e-1), SC_(4.900787592976596156065412582950377286868e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.134841003417968750000000000000000000000e2), SC_(5.136503548378169711364426922884002606453e-1), SC_(4.863496451621830288635573077115997393547e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.182143859863281250000000000000000000000e2), SC_(5.139299462828341412575254839683085128514e-1), SC_(4.860700537171658587424745160316914871486e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.202345581054687500000000000000000000000e2), SC_(5.173222224941632884688923209523949133684e-1), SC_(4.826777775058367115311076790476050866316e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.335042266845703125000000000000000000000e2), SC_(5.515036165421076540744023387226987804276e-1), SC_(4.484963834578923459255976612773012195724e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.546580963134765625000000000000000000000e2), SC_(8.338337735800678783495091873706632270735e-1), SC_(1.661662264199321216504908126293367729265e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.822563171386718750000000000000000000000e2), SC_(9.684729295730302563227648265394290929053e-1), SC_(3.152707042696974367723517346057090709471e-2) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(3.070474243164062500000000000000000000000e2), SC_(9.965585396426980208753729996389237208689e-1), SC_(3.441460357301979124627000361076279131147e-3) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(3.561616821289062500000000000000000000000e2), SC_(9.999905769832490355484447331090077158602e-1), SC_(9.423016750964451555266890992284139769792e-6) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(4.782355957031250000000000000000000000000e2), SC_(9.999999999999946737650064399827162530450e-1), SC_(5.326234993560017283746955030628827279334e-15) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(7.176828002929687500000000000000000000000e2), SC_(9.999999999999999999999999999999999999999e-1), SC_(8.151315659688229933003879486565091948380e-41) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(9.922659912109375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.183728309140270287466483094893973788555e-73) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(1.271265625000000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.473704405868702642424191251660917175501e-111) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.555554199218750000000000000000000000000e1), SC_(6.207784480032583427152833668100905520883e-58), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(6.503999328613281250000000000000000000000e1), SC_(6.213401041422586321942419512623348936695e-28), SC_(9.999999999999999999999999993786598958577e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(1.301126251220703125000000000000000000000e2), SC_(7.321465361344666863212890040575943926177e-10), SC_(9.999999992678534638655333136787109959424e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.030695953369140625000000000000000000000e2), SC_(3.479997963421688627756799038360270205090e-3), SC_(9.965200020365783113722432009616397297949e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.455945587158203125000000000000000000000e2), SC_(1.575082042233415656169081275999254416765e-1), SC_(8.424917957766584343830918724000745583235e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.711862792968750000000000000000000000000e2), SC_(4.721849392402891501467064324131801218983e-1), SC_(5.278150607597108498532935675868198781017e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.762637023925781250000000000000000000000e2), SC_(5.082578864450083243430870276626239380449e-1), SC_(4.917421135549916756569129723373760619551e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.851840209960937500000000000000000000000e2), SC_(5.120971853631907002967313887969194662375e-1), SC_(4.879028146368092997032686112030805337625e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.852803649902343750000000000000000000000e2), SC_(5.125004657925493106196731959575867348299e-1), SC_(4.874995342074506893803268040424132651701e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(3.025818786621093750000000000000000000000e2), SC_(5.158787155720376084647626639868043110131e-1), SC_(4.841212844279623915352373360131956889869e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(3.067979736328125000000000000000000000000e2), SC_(5.526806832621698333420436033615199252679e-1), SC_(4.473193167378301666579563966384800747321e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(3.375936279296875000000000000000000000000e2), SC_(8.498752260241925176865536555610502359049e-1), SC_(1.501247739758074823134463444389497640951e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.683470153808593750000000000000000000000e2), SC_(9.766467899222811998406011798054365916497e-1), SC_(2.335321007771880015939882019456340835031e-2) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(4.010874328613281250000000000000000000000e2), SC_(9.981353670031801354211431397371726147039e-1), SC_(1.864632996819864578856860262827385296130e-3) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(4.673321228027343750000000000000000000000e2), SC_(9.999980276674051465096396677270793220375e-1), SC_(1.972332594853490360332272920677962549456e-6) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(6.241592407226562500000000000000000000000e2), SC_(9.999999999999999718013439241603388397951e-1), SC_(2.819865607583966116020492406878185568359e-17) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(9.443203125000000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.245972645744974137051916546060036928431e-48) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(1.268067749023437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.691495401052107271020389260055995479922e-87) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(1.604877441406250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.027413717923384150654783500173778066669e-130) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.239371871948242187500000000000000000000e1), SC_(3.958772436363683999189517729198756214506e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(8.110855102539062500000000000000000000000e1), SC_(2.301183220238318618168024091304790298773e-30), SC_(9.999999999999999999999999999976988167798e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(1.636778717041015625000000000000000000000e2), SC_(7.816632390400635590050405322665297513842e-11), SC_(9.999999999218336760959936440994959467733e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(2.464182739257812500000000000000000000000e2), SC_(2.187014351328254979512211163028769698358e-3), SC_(9.978129856486717450204877888369712303016e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.008242492675781250000000000000000000000e2), SC_(1.423336206087897103783781956065190731049e-1), SC_(8.576663793912102896216218043934809268951e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.319110412597656250000000000000000000000e2), SC_(4.685916694273098752095273160355229151655e-1), SC_(5.314083305726901247904726839644770848345e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.350580444335937500000000000000000000000e2), SC_(5.069318516898639224307235468155372152629e-1), SC_(4.930681483101360775692764531844627847371e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.354288940429687500000000000000000000000e2), SC_(5.111819861507644698933846997203499118198e-1), SC_(4.888180138492355301066153002796500881802e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.358973999023437500000000000000000000000e2), SC_(5.115998311611917734328771916592436641580e-1), SC_(4.884001688388082265671228083407563358420e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.390912170410156250000000000000000000000e2), SC_(5.153880302049897792282419553387254434076e-1), SC_(4.846119697950102207717580446612745565924e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.435902404785156250000000000000000000000e2), SC_(5.535175877651327981473083913737474318151e-1), SC_(4.464824122348672018526916086262525681849e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.745491943359375000000000000000000000000e2), SC_(8.573020059906785254192097445499975749626e-1), SC_(1.426979940093214745807902554500024250374e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.113713073730468750000000000000000000000e2), SC_(9.802406819653646481124866659001246206687e-1), SC_(1.975931803463535188751333409987537933127e-2) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(4.493236389160156250000000000000000000000e2), SC_(9.986853706288146108700988182244227016792e-1), SC_(1.314629371185389129901181775577298320775e-3) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(5.254401855468750000000000000000000000000e2), SC_(9.999992013847649926484187899276902230648e-1), SC_(7.986152350073515812100723097769352269359e-7) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(7.029876708984375000000000000000000000000e2), SC_(9.999999999999999987200906421455856967220e-1), SC_(1.279909357854414303277991233674160874234e-18) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(1.070898315429687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.342843309851576227748631345694600225102e-53) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(1.433931518554687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.509692630182433623515396588596265662192e-95) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(1.794774169921875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.347903419514625093557349799611575735168e-142) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.626063537597656250000000000000000000000e1), SC_(5.724097378409486936650746686865417925184e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(9.146302795410156250000000000000000000000e1), SC_(3.647744865376508387261444312076611250222e-32), SC_(9.999999999999999999999999999999635225513e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(1.836205444335937500000000000000000000000e2), SC_(1.777743644671142380943412343604755092944e-11), SC_(9.999999999822225635532885761905658765640e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(2.754818115234375000000000000000000000000e2), SC_(1.565594611931550059639700704705115865342e-3), SC_(9.984344053880684499403602992952948841347e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.309355468750000000000000000000000000000e2), SC_(1.343542887395655410493790904818520252195e-1), SC_(8.656457112604344589506209095181479747805e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.650975646972656250000000000000000000000e2), SC_(4.667034062781292653762920385960488806304e-1), SC_(5.332965937218707346237079614039511193696e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.689773254394531250000000000000000000000e2), SC_(5.062658951240628139388004539939520546897e-1), SC_(4.937341048759371860611995460060479453103e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.695812683105468750000000000000000000000e2), SC_(5.106524336785722853498777976178984470249e-1), SC_(4.893475663214277146501222023821015529751e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.699632568359375000000000000000000000000e2), SC_(5.110863631314553813237809120281796337454e-1), SC_(4.889136368685446186762190879718203662546e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.724017028808593750000000000000000000000e2), SC_(5.150141113071189492544385053906446281704e-1), SC_(4.849858886928810507455614946093553718296e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.781278076171875000000000000000000000000e2), SC_(5.543861604096707678253245858353651852448e-1), SC_(4.456138395903292321746754141646348147552e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(4.120835571289062500000000000000000000000e2), SC_(8.646520346482401979484906890279239429311e-1), SC_(1.353479653517598020515093109720760570689e-1) }}, 
      {{ SC_(1.758077087402343750000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(4.501199951171875000000000000000000000000e2), SC_(9.830750467283451240592325738283526034736e-1), SC_(1.692495327165487594076742617164739652643e-2) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.368720703125000000000000000000000000000e2), SC_(9.959284325433291351806356039713217160428e-1), SC_(4.071567456670864819364396028678283957171e-3) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(2.814287414550781250000000000000000000000e2), SC_(9.999851760408873315045990128468528377589e-1), SC_(1.482395911266849540098715314716224105013e-5) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(3.762836303710937500000000000000000000000e2), SC_(9.999999999999676330369909793133168439190e-1), SC_(3.236696300902068668315608099031373857273e-14) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(5.651848144531250000000000000000000000000e2), SC_(9.999999999999999999999999999999999999454e-1), SC_(5.455773979032228793850130219166695164585e-38) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(7.619475097656250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.883805744572279030680836664679932630793e-66) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.003394775390625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.430352365859786565546060311435266158130e-99) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.007606887817382812500000000000000000000e1), SC_(1.963240619630300465411670224279583281150e-57), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(5.080623626708984375000000000000000000000e1), SC_(3.589044313508221648026011624844942764795e-27), SC_(9.999999999999999999999999964109556864918e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.018727493286132812500000000000000000000e2), SC_(1.758106596737527230431770396769038722354e-9), SC_(9.999999982418934032624727695682296032310e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(1.547168579101562500000000000000000000000e2), SC_(4.731886296067968070246146381639320252367e-3), SC_(9.952681137039320319297538536183606797476e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.859849548339843750000000000000000000000e2), SC_(1.690031242367542332425067846095907249993e-1), SC_(8.309968757632457667574932153904092750007e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.062645111083984375000000000000000000000e2), SC_(4.752720367628289274750163733239117032874e-1), SC_(5.247279632371710725249836266760882967126e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.094202423095703125000000000000000000000e2), SC_(5.098153335472054978403665519147650005781e-1), SC_(4.901846664527945021596334480852349994219e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.110753936767578125000000000000000000000e2), SC_(5.136198237844799851143408768037618037830e-1), SC_(4.863801762155200148856591231962381962170e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.127964935302734375000000000000000000000e2), SC_(5.139714992343591302241402986347373928481e-1), SC_(4.860285007656408697758597013652626071519e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.157054290771484375000000000000000000000e2), SC_(5.173766437814973554167033725798783227920e-1), SC_(4.826233562185026445832966274201216772080e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.181858825683593750000000000000000000000e2), SC_(5.517215407500014736744652379671950495965e-1), SC_(4.482784592499985263255347620328049504035e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.408218841552734375000000000000000000000e2), SC_(8.339703169471781899541693574920722686738e-1), SC_(1.660296830528218100458306425079277313262e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.683649597167968750000000000000000000000e2), SC_(9.684692032586166434789039573490893815870e-1), SC_(3.153079674138335652109604265091061841301e-2) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.930972290039062500000000000000000000000e2), SC_(9.965579433270994874025337014129526128069e-1), SC_(3.442056672900512597466298587047387193131e-3) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(3.549557800292968750000000000000000000000e2), SC_(9.999918655653250499966931423648287879708e-1), SC_(8.134434674950003306857635171212029158420e-6) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(4.739044799804687500000000000000000000000e2), SC_(9.999999999999962007353725319743892408318e-1), SC_(3.799264627468025610759168196891535879323e-15) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(7.219754638671875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.775173773987073809788485937430110232785e-41) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(9.665408935546875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.190965534781176520261510437766767393885e-73) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(1.214430053710937500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.884558087909005034093302199872414459911e-109) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.445626831054687500000000000000000000000e1), SC_(8.737872093099492251667146995628284287094e-59), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(6.116812133789062500000000000000000000000e1), SC_(4.959073745787425206070092380296544383306e-28), SC_(9.999999999999999999999999995040926254213e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(1.267556915283203125000000000000000000000e2), SC_(6.187989699159549411364344299776161893243e-10), SC_(9.999999993812010300840450588635655700224e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(1.947734985351562500000000000000000000000e2), SC_(3.519717870194765625258627119899026895059e-3), SC_(9.964802821298052343747413728801009731049e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.349002685546875000000000000000000000000e2), SC_(1.583633961608283132848250848716551669476e-1), SC_(8.416366038391716867151749151283448330524e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.629488220214843750000000000000000000000e2), SC_(4.723466384402144426203612509464694959384e-1), SC_(5.276533615597855573796387490535305040616e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.654044799804687500000000000000000000000e2), SC_(5.084763673680364339537032758355689735739e-1), SC_(4.915236326319635660462967241644310264261e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.762043457031250000000000000000000000000e2), SC_(5.122637728299327521514414107253385179663e-1), SC_(4.877362271700672478485585892746614820337e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.783555603027343750000000000000000000000e2), SC_(5.126257350066910678711260134863656199621e-1), SC_(4.873742649933089321288739865136343800379e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.796498107910156250000000000000000000000e2), SC_(5.162507632549228056827894612138180981155e-1), SC_(4.837492367450771943172105387861819018845e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.848049926757812500000000000000000000000e2), SC_(5.525127581864622588872348732911405784680e-1), SC_(4.474872418135377411127651267088594215320e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(3.196918029785156250000000000000000000000e2), SC_(8.478037028163804321086873211011333775590e-1), SC_(1.521962971836195678913126788988666224410e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(3.488360595703125000000000000000000000000e2), SC_(9.755941147166082440031121561035979663263e-1), SC_(2.440588528339175599688784389640203367369e-2) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.000417785644531250000000000000000000000e2), SC_(9.982188953692877585405794321262790195470e-1), SC_(1.781104630712241459420567873720980452976e-3) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(4.638078918457031250000000000000000000000e2), SC_(9.999981576621887506126449470334512591001e-1), SC_(1.842337811249387355052966548740899869394e-6) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(6.246963500976562500000000000000000000000e2), SC_(9.999999999999999806177135275460923348821e-1), SC_(1.938228647245390766511793469898226614633e-17) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(9.372021484375000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.584657079851231102965695307054174092416e-48) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(1.255894775390625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.918575560460397554939094141202494908466e-87) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(1.584998168945312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.123068287536474738254778042612230028199e-130) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.175245094299316406250000000000000000000e1), SC_(7.137052980022629186774216429640744922461e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(8.005458068847656250000000000000000000000e1), SC_(1.155626815993267488736278583149568801904e-30), SC_(9.999999999999999999999999999988443731840e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(1.612309112548828125000000000000000000000e2), SC_(6.931898578743127433571889140011316675739e-11), SC_(9.999999999306810142125687256642811085999e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(2.448152770996093750000000000000000000000e2), SC_(2.104388118073936842967907210513893591118e-3), SC_(9.978956118819260631570320927894861064089e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(2.964438476562500000000000000000000000000e2), SC_(1.420709401136953647812982750869944636985e-1), SC_(8.579290598863046352187017249130055363015e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.265802917480468750000000000000000000000e2), SC_(4.686571685495126248049567139985166102609e-1), SC_(5.313428314504873751950432860014833897391e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.324678344726562500000000000000000000000e2), SC_(5.069592852894608265447553080046699691330e-1), SC_(4.930407147105391734552446919953300308670e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.340025939941406250000000000000000000000e2), SC_(5.112031405449057782438353514285837438794e-1), SC_(4.887968594550942217561646485714162561206e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.397280273437500000000000000000000000000e2), SC_(5.115391334899720161922402250398197284917e-1), SC_(4.884608665100279838077597749601802715083e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.410492858886718750000000000000000000000e2), SC_(5.153856780295402617243266809089228531180e-1), SC_(4.846143219704597382756733190910771468820e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.442467041015625000000000000000000000000e2), SC_(5.537609814858640226602166729858074015834e-1), SC_(4.462390185141359773397833270141925984166e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.749611511230468750000000000000000000000e2), SC_(8.586194631954405615712201260318861062496e-1), SC_(1.413805368045594384287798739681138937504e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.095704345703125000000000000000000000000e2), SC_(9.805966972562876143143282180000301474081e-1), SC_(1.940330274371238568567178199996985259188e-2) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(4.474565124511718750000000000000000000000e2), SC_(9.987303737294238036471235454023767479291e-1), SC_(1.269626270576196352876454597623252070904e-3) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(5.184498291015625000000000000000000000000e2), SC_(9.999992022521725723878759071559121061673e-1), SC_(7.977478274276121240928440878938327112937e-7) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(6.918883056640625000000000000000000000000e2), SC_(9.999999999999999985656473018402679089119e-1), SC_(1.434352698159732091088145559649709156148e-18) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(1.044762939453125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.402716649535995267256987873377446008443e-52) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(1.404313842773437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.033920027054359437669377437093564275388e-94) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(1.778691650390625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.009882543616256079855028205212344121823e-142) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.569387435913085937500000000000000000000e1), SC_(1.191855283766803112532803993600212115760e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(9.060274505615234375000000000000000000000e1), SC_(1.900617205274710353716983486257930508942e-32), SC_(9.999999999999999999999999999999809938279e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(1.819638824462890625000000000000000000000e2), SC_(1.536071724816940256628034243792852448778e-11), SC_(9.999999999846392827518305974337196575621e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(2.732998046875000000000000000000000000000e2), SC_(1.524501372873645292168294489195346903784e-3), SC_(9.984754986271263547078317055108046530962e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.312460937500000000000000000000000000000e2), SC_(1.330378310347497078219845209926437471557e-1), SC_(8.669621689652502921780154790073562528443e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.675840454101562500000000000000000000000e2), SC_(4.663518955985882436931217912495412910456e-1), SC_(5.336481044014117563068782087504587089544e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.723132934570312500000000000000000000000e2), SC_(5.061839068877470261139480634697214890697e-1), SC_(4.938160931122529738860519365302785109303e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.727539672851562500000000000000000000000e2), SC_(5.106076358133663629127459008726442506910e-1), SC_(4.893923641866336370872540991273557493090e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.731883850097656250000000000000000000000e2), SC_(5.110443145239133308943578556307817182864e-1), SC_(4.889556854760866691056421443692182817136e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.746045227050781250000000000000000000000e2), SC_(5.150133818918737918524570763452782305887e-1), SC_(4.849866181081262081475429236547217694113e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.785394897460937500000000000000000000000e2), SC_(5.546059530639289713987637370816199307372e-1), SC_(4.453940469360710286012362629183800692628e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.125287780761718750000000000000000000000e2), SC_(8.658216145975300426187804511730311505410e-1), SC_(1.341783854024699573812195488269688494590e-1) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(4.504454040527343750000000000000000000000e2), SC_(9.834906796851442455514902167418021745974e-1), SC_(1.650932031485575444850978325819782540261e-2) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.907168884277343750000000000000000000000e2), SC_(9.990775031877147241595400183712977942378e-1), SC_(9.224968122852758404599816287022057622446e-4) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(5.697432861328125000000000000000000000000e2), SC_(9.999996458048769200831978774625729024811e-1), SC_(3.541951230799168021225374270975188693450e-7) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(7.601325683593750000000000000000000000000e2), SC_(9.999999999999999999054756695244886301008e-1), SC_(9.452433047551136989919217958504745827325e-20) }}, 
      {{ SC_(1.812525939941406250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(1.141634521484375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.243875127511385930895331971805583023815e-56) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(7.348739624023437500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.242487949704463614605491817044118491242e-66) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(9.456417846679687500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.855669657816947616648903591942911920800e-98) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.896510124206542968750000000000000000000e1), SC_(9.544205936514435146842117544259975253945e-58), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(4.747603225708007812500000000000000000000e1), SC_(2.980620797478100944683913069985268096529e-27), SC_(9.999999999999999999999999970193792025219e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(9.599803924560546875000000000000000000000e1), SC_(1.716868094509639311831054757152831477303e-9), SC_(9.999999982831319054903606881689452428472e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.516411132812500000000000000000000000000e2), SC_(4.670196177339403855105329601132640520081e-3), SC_(9.953298038226605961448946703988673594799e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.820428771972656250000000000000000000000e2), SC_(1.686847181879930505045794750504775387502e-1), SC_(8.313152818120069494954205249495224612498e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.026868133544921875000000000000000000000e2), SC_(4.752504151612513619469102555431213515985e-1), SC_(5.247495848387486380530897444568786484015e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.050494537353515625000000000000000000000e2), SC_(5.098600363835945064931865236054379132505e-1), SC_(4.901399636164054935068134763945620867495e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.077983398437500000000000000000000000000e2), SC_(5.136524704609525327592602356549565886019e-1), SC_(4.863475295390474672407397643450434113981e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.081799774169921875000000000000000000000e2), SC_(5.140303569596350967025844574765112990958e-1), SC_(4.859696430403649032974155425234887009042e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.100670623779296875000000000000000000000e2), SC_(5.174573046038784861057439936882010793741e-1), SC_(4.825426953961215138942560063117989206259e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.132504577636718750000000000000000000000e2), SC_(5.517956601162330509076472266707338463732e-1), SC_(4.482043398837669490923527733292661536268e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.338430633544921875000000000000000000000e2), SC_(8.337705685008073454497569793902872343922e-1), SC_(1.662294314991926545502430206097127656078e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.571412963867187500000000000000000000000e2), SC_(9.680143590021371270404571852430870493346e-1), SC_(3.198564099786287295954281475691295066545e-2) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.820988464355468750000000000000000000000e2), SC_(9.964621838626337648802746339506627111458e-1), SC_(3.537816137366235119725366049337288854196e-3) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(3.263022460937500000000000000000000000000e2), SC_(9.999895336081073492108244443998839208132e-1), SC_(1.046639189265078917555560011607918684789e-5) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(4.408763732910156250000000000000000000000e2), SC_(9.999999999999916954393499662377253405694e-1), SC_(8.304560650033762274659430604395940868942e-15) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(6.754400024414062500000000000000000000000e2), SC_(9.999999999999999999999999999999999999998e-1), SC_(2.422791261082750354616811078404066270844e-40) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(9.078743896484375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.986529056041334222680362485915086691714e-71) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(1.190731933593750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.127025689820031432078525555327236567344e-108) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.384614372253417968750000000000000000000e1), SC_(6.306537346293969033752245163005967603951e-59), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(6.054191970825195312500000000000000000000e1), SC_(3.968595797744429841674797373996330873309e-28), SC_(9.999999999999999999999999996031404202256e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(1.215722045898437500000000000000000000000e2), SC_(7.290921631948524031989820527022838233835e-10), SC_(9.999999992709078368051475968010179472977e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(1.832964019775390625000000000000000000000e2), SC_(3.812197337157590561583818230621814530720e-3), SC_(9.961878026628424094384161817693781854693e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.214646911621093750000000000000000000000e2), SC_(1.610817452958104614448462860651423902970e-1), SC_(8.389182547041895385551537139348576097030e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.437198791503906250000000000000000000000e2), SC_(4.733272750397627088522966119960762421799e-1), SC_(5.266727249602372911477033880039237578201e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.547655792236328125000000000000000000000e2), SC_(5.087206871631334172344533608362374635412e-1), SC_(4.912793128368665827655466391637625364588e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.612072143554687500000000000000000000000e2), SC_(5.125658496953742617529221198029380994714e-1), SC_(4.874341503046257382470778801970619005286e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.625357360839843750000000000000000000000e2), SC_(5.129382140787459615659917926233051072466e-1), SC_(4.870617859212540384340082073766948927534e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.673811645507812500000000000000000000000e2), SC_(5.164568437107518397768604766905664454226e-1), SC_(4.835431562892481602231395233094335545774e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.698511047363281250000000000000000000000e2), SC_(5.523429643610347647821257327244603241443e-1), SC_(4.476570356389652352178742672755396758557e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(3.054848937988281250000000000000000000000e2), SC_(8.455200490371149045000460575752834692504e-1), SC_(1.544799509628850954999539424247165307496e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(3.358043212890625000000000000000000000000e2), SC_(9.746489481247796297641039430976492642885e-1), SC_(2.535105187522037023589605690235073571146e-2) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(3.651434631347656250000000000000000000000e2), SC_(9.977796034235170755615176657377412157049e-1), SC_(2.220396576482924438482334262258784295063e-3) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(4.252414855957031250000000000000000000000e2), SC_(9.999968808671344999406734290868077136404e-1), SC_(3.119132865500059326570913192286359577243e-6) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(5.842761840820312500000000000000000000000e2), SC_(9.999999999999999207685779096706539038026e-1), SC_(7.923142209032934609619742611391371569198e-17) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(8.766176757812500000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.474736915469826291447684675656342998594e-46) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(1.236934570312500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.316668445315793262076016974493265344747e-86) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(1.553572387695312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.680617208914552848990775216943248174613e-129) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(3.138573646545410156250000000000000000000e1), SC_(5.761995054679313965293013760981216482622e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(7.847747802734375000000000000000000000000e1), SC_(1.513484308559754227251045757139803472954e-30), SC_(9.999999999999999999999999999984865156914e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(1.577414550781250000000000000000000000000e2), SC_(8.122793659598545610047472233418596802875e-11), SC_(9.999999999187720634040145438995252776658e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.388816223144531250000000000000000000000e2), SC_(2.210024206865195017217766802155753280659e-3), SC_(9.977899757931348049827822331978442467193e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(2.871303100585937500000000000000000000000e2), SC_(1.441182304572586098553460209196717926105e-1), SC_(8.558817695427413901446539790803282073895e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.185102539062500000000000000000000000000e2), SC_(4.690500514589325592905047202288629093931e-1), SC_(5.309499485410674407094952797711370906069e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.236470336914062500000000000000000000000e2), SC_(5.071349743056531748237476516343878975567e-1), SC_(4.928650256943468251762523483656121024433e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.279295654296875000000000000000000000000e2), SC_(5.113032105269475733050595833471693587669e-1), SC_(4.886967894730524266949404166528306412331e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.309243164062500000000000000000000000000e2), SC_(5.116796022089201443721558701953373515932e-1), SC_(4.883203977910798556278441298046626484068e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.317196960449218750000000000000000000000e2), SC_(5.155067710008173152300576804347217146404e-1), SC_(4.844932289991826847699423195652782853596e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.376529235839843750000000000000000000000e2), SC_(5.536713230480099277922681435375635410772e-1), SC_(4.463286769519900722077318564624364589228e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.690629577636718750000000000000000000000e2), SC_(8.578231267790076496653326929986577503152e-1), SC_(1.421768732209923503346673070013422496848e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.094439086914062500000000000000000000000e2), SC_(9.807245202967281759616611562861427106758e-1), SC_(1.927547970327182403833884371385728932421e-2) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(4.448830871582031250000000000000000000000e2), SC_(9.987239785338816782018505068189656025472e-1), SC_(1.276021466118321798149493181034397452783e-3) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(5.135213012695312500000000000000000000000e2), SC_(9.999991652855814859040379501720146828889e-1), SC_(8.347144185140959620498279853171110663033e-7) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(6.847659301757812500000000000000000000000e2), SC_(9.999999999999999982702379962812009351694e-1), SC_(1.729762003718799064830573442382068390021e-18) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(1.028453613281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.267915207449059499272198603413618014447e-52) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(1.382826171875000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.687817389290017933011777627621400084474e-93) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(1.735712280273437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.682401659016374828069208484471807624867e-140) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.474533843994140625000000000000000000000e1), SC_(2.846930007691253911995234312405406359822e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(8.744087219238281250000000000000000000000e1), SC_(5.055110648669567214346673946848956645072e-32), SC_(9.999999999999999999999999999999494488935e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(1.762938232421875000000000000000000000000e2), SC_(2.165142946302918910216071238933638944300e-11), SC_(9.999999999783485705369708108978392876107e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(2.679356689453125000000000000000000000000e2), SC_(1.597656112323445527538304690368353247935e-3), SC_(9.984023438876765544724616953096316467521e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.226031494140625000000000000000000000000e2), SC_(1.348876278657163806151361274155913641059e-1), SC_(8.651123721342836193848638725844086358941e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.602809753417968750000000000000000000000e2), SC_(4.666947961631800676746836252819631984345e-1), SC_(5.333052038368199323253163747180368015655e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.650715332031250000000000000000000000000e2), SC_(5.063123358344823342202917163293088775824e-1), SC_(4.936876641655176657797082836706911224176e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.659089050292968750000000000000000000000e2), SC_(5.107067608027107002572385248714852005123e-1), SC_(4.892932391972892997427614751285147994877e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.695973815917968750000000000000000000000e2), SC_(5.110950749850264001472153430879805487505e-1), SC_(4.889049250149735998527846569120194512495e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.731790466308593750000000000000000000000e2), SC_(5.150344521068844043660741089275048628358e-1), SC_(4.849655478931155956339258910724951371642e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.779371337890625000000000000000000000000e2), SC_(5.546489962579405050228903758886995920429e-1), SC_(4.453510037420594949771096241113004079571e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.116895141601562500000000000000000000000e2), SC_(8.659663395106043136895581899346688641576e-1), SC_(1.340336604893956863104418100653311358424e-1) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(4.495923461914062500000000000000000000000e2), SC_(9.835434705974896448638844917700568999690e-1), SC_(1.645652940251035513611550822994310003099e-2) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.884613342285156250000000000000000000000e2), SC_(9.990737744343491392157342807973089230242e-1), SC_(9.262255656508607842657192026910769758021e-4) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(5.644511718750000000000000000000000000000e2), SC_(9.999996257343463538564323066161826489379e-1), SC_(3.742656536461435676933838173510621449530e-7) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(7.530706787109375000000000000000000000000e2), SC_(9.999999999999999998848704813090692326161e-1), SC_(1.151295186909307673839297542050153759655e-19) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(1.130641113281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.457005946703869424800876748459599047206e-55) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(1.515934936523437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.651445193267555682384593883351037841782e-100) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(1.906690429687500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.002603437201160106510116844271426573483e-150) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.815755081176757812500000000000000000000e1), SC_(8.058073493095919976480458336224623274764e-68), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.827617950439453125000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(9.551351928710937500000000000000000000000e1), SC_(1.921765148352726421550493577411842741321e-33), SC_(9.999999999999999999999999999999980782349e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.209403228759765625000000000000000000000e1), SC_(1.685016000032264234665004659107098490759e-9), SC_(9.999999983149839999677357653349953408929e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.421984558105468750000000000000000000000e2), SC_(4.752880611529763374663986544116252505617e-3), SC_(9.952471193884702366253360134558837474944e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.711085205078125000000000000000000000000e2), SC_(1.693842469611125360323648558886143346640e-1), SC_(8.306157530388874639676351441113856653360e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.884699707031250000000000000000000000000e2), SC_(4.755564644946550712994872153323308303342e-1), SC_(5.244435355053449287005127846676691696658e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.922731933593750000000000000000000000000e2), SC_(5.100283907478073256418767357984568260078e-1), SC_(4.899716092521926743581232642015431739922e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.026577301025390625000000000000000000000e2), SC_(5.137256408121326074554684677279523213692e-1), SC_(4.862743591878673925445315322720476786308e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.027597198486328125000000000000000000000e2), SC_(5.141075221271354601477088810567422208841e-1), SC_(4.858924778728645398522911189432577791159e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.054089355468750000000000000000000000000e2), SC_(5.175216763522201723277646638500095858711e-1), SC_(4.824783236477798276722353361499904141289e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.077815093994140625000000000000000000000e2), SC_(5.518099642742940223183196389840495145389e-1), SC_(4.481900357257059776816803610159504854611e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.290947113037109375000000000000000000000e2), SC_(8.334685690254846303142326164212462884313e-1), SC_(1.665314309745153696857673835787537115687e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.503544921875000000000000000000000000000e2), SC_(9.677090508681216882122360507956487973984e-1), SC_(3.229094913187831178776394920435120260164e-2) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.734247741699218750000000000000000000000e2), SC_(9.963673052147791418170153233435346151889e-1), SC_(3.632694785220858182984676656465384811110e-3) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(3.174129638671875000000000000000000000000e2), SC_(9.999888791576978026534637080263084463618e-1), SC_(1.112084230219734653629197369155363819699e-5) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(4.261083374023437500000000000000000000000e2), SC_(9.999999999999887223604467930493292319582e-1), SC_(1.127763955320695067076804178024151779493e-14) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(6.442619628906250000000000000000000000000e2), SC_(9.999999999999999999999999999999999999988e-1), SC_(1.245106275962889632965273737780232452139e-39) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(8.698748168945312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.231388145447274633672625140815866482531e-70) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.090021972656250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.671101367169842307522001129504954081074e-103) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.209077644348144531250000000000000000000e1), SC_(1.870925719094384660761826570426912211991e-58), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(5.640406036376953125000000000000000000000e1), SC_(8.642641418469439364555084370600405043040e-28), SC_(9.999999999999999999999999991357358581531e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.137190856933593750000000000000000000000e2), SC_(1.004867896608569330008423334459122048277e-9), SC_(9.999999989951321033914306699915766655409e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(1.789619750976562500000000000000000000000e2), SC_(3.920710421708997715181464955396908391572e-3), SC_(9.960792895782910022848185350446030916084e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.150379028320312500000000000000000000000e2), SC_(1.623697517636647716642295438985662068385e-1), SC_(8.376302482363352283357704561014337931615e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.402108764648437500000000000000000000000e2), SC_(4.734824406337584048774525298235875999727e-1), SC_(5.265175593662415951225474701764124000273e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.433703765869140625000000000000000000000e2), SC_(5.089934165345009712714955561624544024496e-1), SC_(4.910065834654990287285044438375455975504e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.448647766113281250000000000000000000000e2), SC_(5.129064692282866013557213784459402416867e-1), SC_(4.870935307717133986442786215540597583133e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.465661163330078125000000000000000000000e2), SC_(5.132658769156167211293432270985917791447e-1), SC_(4.867341230843832788706567729014082208553e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.468979187011718750000000000000000000000e2), SC_(5.168143244570775543227283330034481975657e-1), SC_(4.831856755429224456772716669965518024343e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.580450744628906250000000000000000000000e2), SC_(5.522012778117524293814621580983421830129e-1), SC_(4.477987221882475706185378419016578169871e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.878444519042968750000000000000000000000e2), SC_(8.423964038426509599792272082106174125109e-1), SC_(1.576035961573490400207727917893825874891e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(3.155748901367187500000000000000000000000e2), SC_(9.729226521781737584642910147726553075030e-1), SC_(2.707734782182624153570898522734469249696e-2) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(3.478587036132812500000000000000000000000e2), SC_(9.975331766092007155725154568813426441323e-1), SC_(2.466823390799284427484543118657355867655e-3) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(4.014733276367187500000000000000000000000e2), SC_(9.999957211083337893147680588895478816172e-1), SC_(4.278891666210685231941110452118382837992e-6) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(5.563662109375000000000000000000000000000e2), SC_(9.999999999999997903162397957165460764328e-1), SC_(2.096837602042834539235672340139176975850e-16) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(8.409194335937500000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.118616154047934723490814037074403042919e-45) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(1.125396728515625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.063438630262803420409787542624676895394e-81) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(1.419819580078125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.174701808652247443108764823880836321334e-121) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.926076698303222656250000000000000000000e1), SC_(9.475689740586741470954121400369369347207e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(7.316886901855468750000000000000000000000e1), SC_(8.755593145324296334312914190913139739184e-30), SC_(9.999999999999999999999999999912444068547e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(1.548516082763671875000000000000000000000e2), SC_(9.632739676926083366993864185535461954913e-11), SC_(9.999999999036726032307391663300613581446e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.333880157470703125000000000000000000000e2), SC_(2.332895832235340060213951626363406633407e-3), SC_(9.976671041677646599397860483736365933666e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(2.828942565917968750000000000000000000000e2), SC_(1.451027505863895643856659708641320909473e-1), SC_(8.548972494136104356143340291358679090527e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.112357177734375000000000000000000000000e2), SC_(4.694451719440147951823906793162789392845e-1), SC_(5.305548280559852048176093206837210607155e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(3.156365051269531250000000000000000000000e2), SC_(5.073030996816583186236918842252339983949e-1), SC_(4.926969003183416813763081157747660016051e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.189783935546875000000000000000000000000e2), SC_(5.114561203816223394612185972251851569247e-1), SC_(4.885438796183776605387814027748148430753e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.195352478027343750000000000000000000000e2), SC_(5.118690020956833216566211780726972397126e-1), SC_(4.881309979043166783433788219273027602874e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.225192871093750000000000000000000000000e2), SC_(5.156269884612771509246197854263208514979e-1), SC_(4.843730115387228490753802145736791485021e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.276850280761718750000000000000000000000e2), SC_(5.534673156239209099416340142043860139182e-1), SC_(4.465326843760790900583659857956139860818e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.612391052246093750000000000000000000000e2), SC_(8.564188282878458789241912956540716875735e-1), SC_(1.435811717121541210758087043459283124265e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.976330261230468750000000000000000000000e2), SC_(9.798701735883745852575524520877335968883e-1), SC_(2.012982641162541474244754791226640311169e-2) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(4.314151916503906250000000000000000000000e2), SC_(9.986000141584911579108681181976389766738e-1), SC_(1.399985841508842089131881802361023326179e-3) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(5.021691284179687500000000000000000000000e2), SC_(9.999990149856497715580491025170725729879e-1), SC_(9.850143502284419508974829274270120632913e-7) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(6.719627685546875000000000000000000000000e2), SC_(9.999999999999999972309818369684048634674e-1), SC_(2.769018163031595136532635108927955276534e-18) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(1.025018554687500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.939180175647008037542722481687628746094e-52) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(1.370749389648437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.083490003912408955420530780817789430770e-93) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(1.714085449218750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.063118138371561899127243354790166918770e-138) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.428525543212890625000000000000000000000e1), SC_(4.829105843727813829012300559097294336149e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(8.582186889648437500000000000000000000000e1), SC_(8.700432286914446308669588569579759576117e-32), SC_(9.999999999999999999999999999999129956771e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(1.730880432128906250000000000000000000000e2), SC_(2.670327146092806994207262544815937300301e-11), SC_(9.999999999732967285390719300579273745518e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(2.607090148925781250000000000000000000000e2), SC_(1.726282604059430754566640121162991727733e-3), SC_(9.982737173959405692454333598788370082723e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.131306457519531250000000000000000000000e2), SC_(1.372037028396090910003872936113911967627e-1), SC_(8.627962971603909089996127063886088032373e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.467307739257812500000000000000000000000e2), SC_(4.674299262639035550168952362543928589416e-1), SC_(5.325700737360964449831047637456071410584e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.527041931152343750000000000000000000000e2), SC_(5.065458756201416301367558630623290736885e-1), SC_(4.934541243798583698632441369376709263115e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.577171325683593750000000000000000000000e2), SC_(5.108284356876714805323267910025479059828e-1), SC_(4.891715643123285194676732089974520940172e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.589533691406250000000000000000000000000e2), SC_(5.112476590096261855679019890142761298056e-1), SC_(4.887523409903738144320980109857238701944e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.647541809082031250000000000000000000000e2), SC_(5.151246473793965901595492520166526561863e-1), SC_(4.848753526206034098404507479833473438137e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.695656127929687500000000000000000000000e2), SC_(5.544569956144859250442748892191564289470e-1), SC_(4.455430043855140749557251107808435710530e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.030163269042968750000000000000000000000e2), SC_(8.644286041390122249789957627924387603621e-1), SC_(1.355713958609877750210042372075612396379e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.440360412597656250000000000000000000000e2), SC_(9.832106487040955691513810859303952505962e-1), SC_(1.678935129590443084861891406960474940383e-2) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(4.852585144042968750000000000000000000000e2), SC_(9.990552534721425846670300057856775999315e-1), SC_(9.447465278574153329699942143224000685317e-4) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(5.619971313476562500000000000000000000000e2), SC_(9.999996143896091342600023547539654557537e-1), SC_(3.856103908657399976452460345442463382609e-7) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(7.494654541015625000000000000000000000000e2), SC_(9.999999999999999998705361743581884343670e-1), SC_(1.294638256418115656330498742976919275104e-19) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.125389526367187500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.109673103657089186649506807105910986269e-55) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(1.504836303710937500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.784342939200133156065657659452124339680e-100) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(1.883851806640625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.372968822738199825906793653495588064222e-149) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.770049667358398437500000000000000000000e1), SC_(1.456126934800111878953993527346095459873e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(9.433747863769531250000000000000000000000e1), SC_(2.867682281833985579140465234546382482303e-33), SC_(9.999999999999999999999999999999971323177e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(1.897266540527343750000000000000000000000e2), SC_(7.757586427835869635143688138079450022560e-12), SC_(9.999999999922424135721641303648563118619e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(2.863557128906250000000000000000000000000e2), SC_(1.285813083282444067563485364667944243370e-3), SC_(9.987141869167175559324365146353320557566e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.438405456542968750000000000000000000000e2), SC_(1.294425578236359440164929677487451074440e-1), SC_(8.705574421763640559835070322512548925560e-1) }}, 
      {{ SC_(1.832313690185546875000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.786983947753906250000000000000000000000e2), SC_(4.656670769084474561130519876573377573799e-1), SC_(5.343329230915525438869480123426622426201e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.922404937744140625000000000000000000000e2), SC_(5.096891548066271543998904486423615841212e-1), SC_(4.903108451933728456001095513576384158788e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.978427886962890625000000000000000000000e2), SC_(5.135714331219395863833239062931664402277e-1), SC_(4.864285668780604136166760937068335597723e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.983852844238281250000000000000000000000e2), SC_(5.139586583853762858862492594699581771981e-1), SC_(4.860413416146237141137507405300418228019e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.988171844482421875000000000000000000000e2), SC_(5.174673380730124830829471854735680701997e-1), SC_(4.825326619269875169170528145264319298003e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(2.027176208496093750000000000000000000000e2), SC_(5.523383169226843715050007055803578443059e-1), SC_(4.476616830773156284949992944196421556941e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.319928588867187500000000000000000000000e2), SC_(8.377537425265674336141070037115737164787e-1), SC_(1.622462574734325663858929962884262835213e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.531811828613281250000000000000000000000e2), SC_(9.700601210792110940495563424232143582122e-1), SC_(2.993987892078890595044365757678564178779e-2) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.774831542968750000000000000000000000000e2), SC_(9.968686510247471485840445029456880333461e-1), SC_(3.131348975252851415955497054311966653929e-3) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(3.209537048339843750000000000000000000000e2), SC_(9.999920643272623606946471923949174248423e-1), SC_(7.935672737639305352807605082575157721362e-6) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(4.330255737304687500000000000000000000000e2), SC_(9.999999999999960999188043255519191812583e-1), SC_(3.900081195674448080818741732306921317459e-15) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(6.506207885742187500000000000000000000000e2), SC_(9.999999999999999999999999999999999999999e-1), SC_(7.938912815624065440864458470495113001845e-41) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(8.742864990234375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(8.193242220814925437526600222718474992125e-72) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.099267456054687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.291451685828465514192741631378498628526e-106) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.212990379333496093750000000000000000000e1), SC_(9.412622165494096916125933187685691830616e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(5.574971008300781250000000000000000000000e1), SC_(1.006768299872501662042190428297473294374e-28), SC_(9.999999999999999999999999998993231700127e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.128567810058593750000000000000000000000e2), SC_(5.420216477867025398368243437675113651732e-10), SC_(9.999999994579783522132974601631756562325e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(1.696869506835937500000000000000000000000e2), SC_(3.680873802993236714545238682866695887744e-3), SC_(9.963191261970067632854547613171333041123e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.062373504638671875000000000000000000000e2), SC_(1.603409570153826491790808917950382336901e-1), SC_(8.396590429846173508209191082049617663099e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.315224761962890625000000000000000000000e2), SC_(4.732702741342295295890518565648871418934e-1), SC_(5.267297258657704704109481434351128581066e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.354473571777343750000000000000000000000e2), SC_(5.090478415382884090609531415013106341645e-1), SC_(4.909521584617115909390468584986893658355e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.468608245849609375000000000000000000000e2), SC_(5.128034695703501553565683551940471716911e-1), SC_(4.871965304296498446434316448059528283089e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.472005920410156250000000000000000000000e2), SC_(5.131975011461437165232973343118821048142e-1), SC_(4.868024988538562834767026656881178951858e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.511330108642578125000000000000000000000e2), SC_(5.167363924175305614071024041588902304820e-1), SC_(4.832636075824694385928975958411097695180e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.543774414062500000000000000000000000000e2), SC_(5.526155283859910506615869206481638652553e-1), SC_(4.473844716140089493384130793518361347447e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.784205932617187500000000000000000000000e2), SC_(8.436580847192428558610818507203528261901e-1), SC_(1.563419152807571441389181492796471738099e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(3.057435913085937500000000000000000000000e2), SC_(9.735049462555835499598970195470006744452e-1), SC_(2.649505374441645004010298045299932555484e-2) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(3.313649291992187500000000000000000000000e2), SC_(9.975395175408419746359662947160314114155e-1), SC_(2.460482459158025364033705283968588584471e-3) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(3.956025390625000000000000000000000000000e2), SC_(9.999963109725272948846014510073461101289e-1), SC_(3.689027472705115398548992653889871099889e-6) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(5.398432617187500000000000000000000000000e2), SC_(9.999999999999998042761956156883953109283e-1), SC_(1.957238043843116046890716635516810628579e-16) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(8.136718139648437500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.047863783798577976267199482727287222805e-45) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(1.103313964843750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.982975592696410467256788004114526068545e-81) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(1.379468872070312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.143609913793258948031627862895800372248e-120) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.864279747009277343750000000000000000000e1), SC_(2.363108751521356990025886298876196913648e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(7.213784027099609375000000000000000000000e1), SC_(1.949265846807560874927916288771950625004e-30), SC_(9.999999999999999999999999999980507341532e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(1.447970275878906250000000000000000000000e2), SC_(1.122893372216221392983149677327125615949e-10), SC_(9.999999998877106627783778607016850322673e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.191565856933593750000000000000000000000e2), SC_(2.455153067591199997685982169007998505921e-3), SC_(9.975448469324088000023140178309920014941e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(2.707672729492187500000000000000000000000e2), SC_(1.457501450604838121143428267883256653732e-1), SC_(8.542498549395161878856571732116743346268e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.979111633300781250000000000000000000000e2), SC_(4.697797598890697875162150250589852214728e-1), SC_(5.302202401109302124837849749410147785272e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(3.176301574707031250000000000000000000000e2), SC_(5.072112594037922320719570622356516251743e-1), SC_(4.927887405962077679280429377643483748257e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(3.194288940429687500000000000000000000000e2), SC_(5.114382525567652470993875078704121530954e-1), SC_(4.885617474432347529006124921295878469046e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(3.226040649414062500000000000000000000000e2), SC_(5.118117370834290605810483993584593170467e-1), SC_(4.881882629165709394189516006415406829533e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.229469909667968750000000000000000000000e2), SC_(5.156507147774783113903126362225134874853e-1), SC_(4.843492852225216886096873637774865125147e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(3.274393005371093750000000000000000000000e2), SC_(5.538287999926953549989195203874725914171e-1), SC_(4.461712000073046450010804796125274085829e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.599455871582031250000000000000000000000e2), SC_(8.581823172463709163554567122978949672205e-1), SC_(1.418176827536290836445432877021050327795e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.932977905273437500000000000000000000000e2), SC_(9.803551088559173310348093652414615563352e-1), SC_(1.964489114408266896519063475853844366484e-2) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(4.295745239257812500000000000000000000000e2), SC_(9.986888274546182764934594133135587167718e-1), SC_(1.311172545381723506540586686441283228212e-3) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(4.990281982421875000000000000000000000000e2), SC_(9.999991367369989545485974513628697573876e-1), SC_(8.632630010454514025486371302426123648765e-7) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(6.732880249023437500000000000000000000000e2), SC_(9.999999999999999984436163876557510924310e-1), SC_(1.556383612344248907568961988439876007486e-18) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(1.018817016601562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.800749727491173148741130240951395798026e-52) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(1.360410888671875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.127345252841678266930785408741363672208e-93) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(1.715121337890625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.084517776240452156215197653007187182572e-140) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.442262268066406250000000000000000000000e1), SC_(6.605765899281863848638512110309990066779e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(8.747942352294921875000000000000000000000e1), SC_(9.105411495263399685276042269072792568104e-33), SC_(9.999999999999999999999999999999908945885e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(1.754660949707031250000000000000000000000e2), SC_(1.451735522188951684401453852416887417831e-11), SC_(9.999999999854826447781104831559854614758e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(2.632964477539062500000000000000000000000e2), SC_(1.541828269419706104207881197014704133489e-3), SC_(9.984581717305802938957921188029852958665e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.159876708984375000000000000000000000000e2), SC_(1.344363918974562374774114479960756364409e-1), SC_(8.655636081025437625225885520039243635591e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.480169982910156250000000000000000000000e2), SC_(4.670041454413619223806067827805343150719e-1), SC_(5.329958545586380776193932172194656849281e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.540665283203125000000000000000000000000e2), SC_(5.064819412584617773231640338747216946180e-1), SC_(4.935180587415382226768359661252783053820e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.558568725585937500000000000000000000000e2), SC_(5.108539869233627888935821867837776222896e-1), SC_(4.891460130766372111064178132162223777104e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.562033996582031250000000000000000000000e2), SC_(5.112891303493122348365149877656711037957e-1), SC_(4.887108696506877651634850122343288962043e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.588364257812500000000000000000000000000e2), SC_(5.152207591198118773542086945127214031665e-1), SC_(4.847792408801881226457913054872785968335e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.649151000976562500000000000000000000000e2), SC_(5.546743992153571149285747361820213660777e-1), SC_(4.453256007846428850714252638179786339223e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(4.025581665039062500000000000000000000000e2), SC_(8.660638388543014355438868714711187933891e-1), SC_(1.339361611456985644561131285288812066109e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.405948486328125000000000000000000000000e2), SC_(9.836036539683020289955448663270069423086e-1), SC_(1.639634603169797100445513367299305769142e-2) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.844249877929687500000000000000000000000e2), SC_(9.991151044789278828156345113611191028133e-1), SC_(8.848955210721171843654886388808971866683e-4) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(5.612271118164062500000000000000000000000e2), SC_(9.999996689976629726218528289200726973211e-1), SC_(3.310023370273781471710799273026788661754e-7) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(7.492467041015625000000000000000000000000e2), SC_(9.999999999999999999196080559670831033274e-1), SC_(8.039194403291689667264895785274442770760e-20) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(1.134824584960937500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.693726740082947499146002291382508532841e-56) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(1.526082519531250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.838814434493724904602547824947245858291e-102) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(1.914548095703125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.511480003887899762502450686108111879154e-152) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.829776000976562500000000000000000000000e1), SC_(1.094763835202593824938097802175553038810e-69), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(9.584367370605468750000000000000000000000e1), SC_(3.375046645993334196158442976487187184888e-34), SC_(9.999999999999999999999999999999996624953e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(1.922269592285156250000000000000000000000e2), SC_(4.259890548546173790406021058233314164377e-12), SC_(9.999999999957401094514538262095939789418e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(2.887614135742187500000000000000000000000e2), SC_(1.156126860010163298545678772049196366665e-3), SC_(9.988438731399898367014543212279508036333e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.467247924804687500000000000000000000000e2), SC_(1.269549462179318333726791141068481813036e-1), SC_(8.730450537820681666273208858931518186964e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.817388305664062500000000000000000000000e2), SC_(4.651843238766891171998487128389244199605e-1), SC_(5.348156761233108828001512871610755800395e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.873104858398437500000000000000000000000e2), SC_(5.058772403598168669891347230809281940412e-1), SC_(4.941227596401831330108652769190718059588e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.900524902343750000000000000000000000000e2), SC_(5.103697628631277946701711094691103523159e-1), SC_(4.896302371368722053298288905308896476841e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.903289489746093750000000000000000000000e2), SC_(5.108196874001600918791118792240370086198e-1), SC_(4.891803125998399081208881207759629913802e-1) }}, 
      {{ SC_(1.914762268066406250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.911592712402343750000000000000000000000e2), SC_(5.148926320555258553410878891420852947050e-1), SC_(4.851073679444741446589121108579147052950e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.944255523681640625000000000000000000000e2), SC_(5.523417515884961093991383869746238434442e-1), SC_(4.476582484115038906008616130253761565558e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(2.177014617919921875000000000000000000000e2), SC_(8.369622054041517111839239888278962628726e-1), SC_(1.630377945958482888160760111721037371274e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(2.381197052001953125000000000000000000000e2), SC_(9.695947025851206240207084830571325981413e-1), SC_(3.040529741487937597929151694286740185868e-2) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(2.582920227050781250000000000000000000000e2), SC_(9.967377684093063266081190808255125566178e-1), SC_(3.262231590693673391880919174487443382239e-3) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(3.011672058105468750000000000000000000000e2), SC_(9.999912166265589872389557476094483904908e-1), SC_(8.783373441012761044252390551609509180550e-6) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(4.219404296875000000000000000000000000000e2), SC_(9.999999999999952538116230206228907229609e-1), SC_(4.746188376979377109277039106094931422673e-15) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(6.331558227539062500000000000000000000000e2), SC_(9.999999999999999999999999999999999999998e-1), SC_(1.655305019200974221282484433834282121379e-40) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(8.540648193359375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.166872703940109824549994643745260781238e-71) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.070183837890625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.505374852607585031379597654199409064683e-105) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.165804100036621093750000000000000000000e1), SC_(1.137447482408550941940496904383492710207e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(5.423530578613281250000000000000000000000e1), SC_(1.214846664491726460640664167000234122069e-28), SC_(9.999999999999999999999999998785153335508e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.093196258544921875000000000000000000000e2), SC_(6.010225731549354843719011353296719382421e-10), SC_(9.999999993989774268450645156280988646703e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(1.649408416748046875000000000000000000000e2), SC_(3.772287876273362754198168397085678232374e-3), SC_(9.962277121237266372458018316029143217676e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(1.992299804687500000000000000000000000000e2), SC_(1.614601259658635711711869035375856670535e-1), SC_(8.385398740341364288288130964624143329465e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.208358001708984375000000000000000000000e2), SC_(4.737166683508053607184865269773818741783e-1), SC_(5.262833316491946392815134730226181258217e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.255554046630859375000000000000000000000e2), SC_(5.092531628408322973646007584397316357186e-1), SC_(4.907468371591677026353992415602683642814e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.263168945312500000000000000000000000000e2), SC_(5.131919545159566644738115750312685456126e-1), SC_(4.868080454840433355261884249687314543874e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.292431640625000000000000000000000000000e2), SC_(5.135348782371576040337109186644448991176e-1), SC_(4.864651217628423959662890813355551008824e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.341626434326171875000000000000000000000e2), SC_(5.170165046318180959317038747398939226972e-1), SC_(4.829834953681819040682961252601060773028e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.381081695556640625000000000000000000000e2), SC_(5.524705803885961469938878280255036421949e-1), SC_(4.475294196114038530061121719744963578051e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.716213073730468750000000000000000000000e2), SC_(8.426256474202963457456513572470997279273e-1), SC_(1.573743525797036542543486427529002720727e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.966921997070312500000000000000000000000e2), SC_(9.728228916611262856474017453846130201232e-1), SC_(2.717710833887371435259825461538697987676e-2) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(3.262346496582031250000000000000000000000e2), SC_(9.974721057485224128960964684169992161770e-1), SC_(2.527894251477587103903531583000783822958e-3) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(3.778897094726562500000000000000000000000e2), SC_(9.999954332076461069164231937858184575506e-1), SC_(4.566792353893083576806214181542449392799e-6) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(5.063545227050781250000000000000000000000e2), SC_(9.999999999999994306668090993019467985500e-1), SC_(5.693331909006980532014499669398602358857e-16) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(7.645618286132812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(9.388936940189096776196646133069951813397e-44) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(1.019854980468750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.373137653121593104331862991237173221670e-77) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(1.319013183593750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.526861993361847628979478058008934396653e-117) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.699892616271972656250000000000000000000e1), SC_(1.540245894330979827849351883123171527940e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(6.782289123535156250000000000000000000000e1), SC_(6.867722107460524571738984967401542786846e-30), SC_(9.999999999999999999999999999931322778925e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(1.379480590820312500000000000000000000000e2), SC_(1.672429220783640254701972745489158583404e-10), SC_(9.999999998327570779216359745298027254511e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.069710388183593750000000000000000000000e2), SC_(2.754658207506638981849217514418076565098e-3), SC_(9.972453417924933610181507824855819234349e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.578460388183593750000000000000000000000e2), SC_(1.489320299549130023689370834766996601982e-1), SC_(8.510679700450869976310629165233003398018e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.857327880859375000000000000000000000000e2), SC_(4.704515644286714925370922847739516061453e-1), SC_(5.295484355713285074629077152260483938547e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.893720092773437500000000000000000000000e2), SC_(5.078233336421360695519440013425652302767e-1), SC_(4.921766663578639304480559986574347697233e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.922763977050781250000000000000000000000e2), SC_(5.119220805984452946621920669189921381726e-1), SC_(4.880779194015547053378079330810078618274e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(3.009502563476562500000000000000000000000e2), SC_(5.121824669357127528985976072430147822542e-1), SC_(4.878175330642872471014023927569852177458e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(3.012889709472656250000000000000000000000e2), SC_(5.159477890546165818903511040810210204756e-1), SC_(4.840522109453834181096488959189789795244e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(3.211958618164062500000000000000000000000e2), SC_(5.537020740433234378330031921142779940559e-1), SC_(4.462979259566765621669968078857220059441e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(3.514461669921875000000000000000000000000e2), SC_(8.566193866904155771133951565854267209159e-1), SC_(1.433806133095844228866048434145732790841e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(3.871673278808593750000000000000000000000e2), SC_(9.799093678119048402822117485563795119770e-1), SC_(2.009063218809515971778825144362048802298e-2) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.194995727539062500000000000000000000000e2), SC_(9.985946249960016181917215344600258313147e-1), SC_(1.405375003998381808278465539974168685341e-3) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(4.863974304199218750000000000000000000000e2), SC_(9.999989586397980566419120878186844702951e-1), SC_(1.041360201943358087912181315529704900887e-6) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(6.545817871093750000000000000000000000000e2), SC_(9.999999999999999968404899525677455559264e-1), SC_(3.159510047432254444073632661220615148914e-18) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(9.834472656250000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.519007365950934520787562513758748253660e-51) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(1.322038330078125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.685900058943582515181771745791757523456e-91) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(1.663765380859375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.661991429763939090557242237957953918896e-137) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.367116546630859375000000000000000000000e1), SC_(2.053530364807888815422047252032774944138e-66), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(8.491832733154296875000000000000000000000e1), SC_(2.359339411120259515523282025482215863732e-32), SC_(9.999999999999999999999999999999764066059e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(1.700851745605468750000000000000000000000e2), SC_(2.116202445362595384356182015812112368664e-11), SC_(9.999999999788379755463740461564381798419e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(2.573189086914062500000000000000000000000e2), SC_(1.645805180387698596087971615014775842399e-3), SC_(9.983541948196123014039120283849852241576e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.098644714355468750000000000000000000000e2), SC_(1.359385076521869075204984456809059365575e-1), SC_(8.640614923478130924795015543190940634425e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.464854736328125000000000000000000000000e2), SC_(4.670850310052358436686636523924727300911e-1), SC_(5.329149689947641563313363476075272699089e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.506488342285156250000000000000000000000e2), SC_(5.065471371804994165043045907005627606378e-1), SC_(4.934528628195005834956954092994372393622e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.511295776367187500000000000000000000000e2), SC_(5.109258047979434795660538394150628380473e-1), SC_(4.890741952020565204339461605849371619527e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.512001647949218750000000000000000000000e2), SC_(5.113634916992053613743686082133575199559e-1), SC_(4.886365083007946386256313917866424800441e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.519515686035156250000000000000000000000e2), SC_(5.152979811552170026172883188551766051417e-1), SC_(4.847020188447829973827116811448233948583e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.580334777832031250000000000000000000000e2), SC_(5.545146782605287080462357013488507651447e-1), SC_(4.454853217394712919537642986511492348553e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.915169677734375000000000000000000000000e2), SC_(8.640507602004774540988474619794141023551e-1), SC_(1.359492397995225459011525380205858976449e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(4.274825134277343750000000000000000000000e2), SC_(9.827535902312571066999862583311925068665e-1), SC_(1.724640976874289330001374166880749313350e-2) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(4.661092224121093750000000000000000000000e2), SC_(9.989896685650590041056812188865005611322e-1), SC_(1.010331434940995894318781113499438867818e-3) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(5.420545654296875000000000000000000000000e2), SC_(9.999995539992979295353178768853638718462e-1), SC_(4.460007020704646821231146361281537942115e-7) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(7.320592041015625000000000000000000000000e2), SC_(9.999999999999999998421539440406624782229e-1), SC_(1.578460559593375217771174869430263047689e-19) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(1.101689941406250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.188161636909193603695616113203878711617e-55) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(1.490808959960937500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.494290225275854444979458227363311730068e-100) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(1.871095092773437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.920088575954070534853008265891514100113e-150) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.746909713745117187500000000000000000000e1), SC_(4.372865610715037758607762797074131579640e-69), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(9.458562469482421875000000000000000000000e1), SC_(5.537136422028997039528706279297036471531e-34), SC_(9.999999999999999999999999999999994462864e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(1.907941284179687500000000000000000000000e2), SC_(4.724234167838375368163700786873645567698e-12), SC_(9.999999999952757658321616246318362992131e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(2.872329101562500000000000000000000000000e2), SC_(1.175818202341330469697395084973792434416e-3), SC_(9.988241817976586695303026049150262075656e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.447406921386718750000000000000000000000e2), SC_(1.274145080626004395342545885350479055819e-1), SC_(8.725854919373995604657454114649520944181e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.796079101562500000000000000000000000000e2), SC_(4.652951505416967610983736824493475301965e-1), SC_(5.347048494583032389016263175506524698035e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.841370239257812500000000000000000000000e2), SC_(5.059320111700551873915916029941020381918e-1), SC_(4.940679888299448126084083970058979618082e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.850828247070312500000000000000000000000e2), SC_(5.104364416202663642580882767395134923327e-1), SC_(4.895635583797336357419117232604865076673e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.853559570312500000000000000000000000000e2), SC_(5.108848859104946794825017410075922600399e-1), SC_(4.891151140895053205174982589924077399601e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.860480957031250000000000000000000000000e2), SC_(5.149415092710091020683018258949337095594e-1), SC_(4.850584907289908979316981741050662904406e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.916434631347656250000000000000000000000e2), SC_(5.553342608339123863061452399875957005910e-1), SC_(4.446657391660876136938547600124042994090e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.291321411132812500000000000000000000000e2), SC_(8.708902302808843383746282691223892322674e-1), SC_(1.291097697191156616253717308776107677326e-1) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(4.684290771484375000000000000000000000000e2), SC_(9.853068800524576022070367265206744729122e-1), SC_(1.469311994754239779296327347932552708781e-2) }}, 
      {{ SC_(1.915438537597656250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.080869445800781250000000000000000000000e2), SC_(9.992569927608480827503081869867908108037e-1), SC_(7.430072391519172496918130132091891963282e-4) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.893435363769531250000000000000000000000e2), SC_(9.999911684697243663983680037613878819544e-1), SC_(8.831530275633601631996238612118045600499e-6) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(3.966111145019531250000000000000000000000e2), SC_(9.999999999999938235585069607124150299815e-1), SC_(6.176441493039287584970018453786273877460e-15) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(5.964846191406250000000000000000000000000e2), SC_(9.999999999999999999999999999999999999996e-1), SC_(4.408164392760834003313786087535375546880e-40) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(7.963253173828125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.570990496143071598917411216685300947766e-70) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.005866394042968750000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.199478736446690523802760610643682155571e-103) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.113653564453125000000000000000000000000e1), SC_(1.086312926225913155302304131693868354841e-60), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(5.286177062988281250000000000000000000000e1), SC_(1.263544684630448028327382690206905367304e-28), SC_(9.999999999999999999999999998736455315370e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.069556732177734375000000000000000000000e2), SC_(6.179118525812815113263968146963286214653e-10), SC_(9.999999993820881474187184886736031853037e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.608239288330078125000000000000000000000e2), SC_(3.818791247057436349206223899463307228732e-3), SC_(9.961812087529425636507937761005366927713e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(1.952779998779296875000000000000000000000e2), SC_(1.618234271045210405525722263752950606566e-1), SC_(8.381765728954789594474277736247049393434e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.151630096435546875000000000000000000000e2), SC_(4.738891418787252814494428972824498096852e-1), SC_(5.261108581212747185505571027175501903148e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.188153686523437500000000000000000000000e2), SC_(5.093727079289292232181483930907100357871e-1), SC_(4.906272920710707767818516069092899642129e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.203162689208984375000000000000000000000e2), SC_(5.132887111642426362094241626556489934240e-1), SC_(4.867112888357573637905758373443510065760e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.217839813232421875000000000000000000000e2), SC_(5.136589919819711532816474127329089421948e-1), SC_(4.863410080180288467183525872670910578052e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.236850738525390625000000000000000000000e2), SC_(5.171780688687443100795852480328128404265e-1), SC_(4.828219311312556899204147519671871595735e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.284380950927734375000000000000000000000e2), SC_(5.524336586283690121185050832648449774491e-1), SC_(4.475663413716309878814949167351550225509e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.493832397460937500000000000000000000000e2), SC_(8.397332693798559914620391836479949320773e-1), SC_(1.602667306201440085379608163520050679227e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.755384826660156250000000000000000000000e2), SC_(9.714088694914179437215879990599397236763e-1), SC_(2.859113050858205627841200094006027632373e-2) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(3.046210021972656250000000000000000000000e2), SC_(9.971999795558021126202398606969251672337e-1), SC_(2.800020444197887379760139303074832766347e-3) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(3.542187194824218750000000000000000000000e2), SC_(9.999941487766349866241981194670065677534e-1), SC_(5.851223365013375801880532993432246601406e-6) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(4.946471862792968750000000000000000000000e2), SC_(9.999999999999992182501944832570204634195e-1), SC_(7.817498055167429795365804773908456837102e-16) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(7.429158935546875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.603700112442098597160578279986536021394e-43) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.005379516601562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.325801618467183304609033630065639181454e-77) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(1.261608154296875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(9.558644727533889980665676447947477062432e-114) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.535724067687988281250000000000000000000e1), SC_(6.451270483892047889481211832016620597687e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(6.381227111816406250000000000000000000000e1), SC_(1.784206581072005328049397197008882076634e-29), SC_(9.999999999999999999999999999821579341893e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(1.276794433593750000000000000000000000000e2), SC_(2.811032021275285624786101467403899766872e-10), SC_(9.999999997188967978724714375213898532596e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(1.981483459472656250000000000000000000000e2), SC_(2.964591851242199909798408203264918108456e-3), SC_(9.970354081487578000902015917967350818915e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.433459472656250000000000000000000000000e2), SC_(1.522894412988621383021198402564239279826e-1), SC_(8.477105587011378616978801597435760720174e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.689698486328125000000000000000000000000e2), SC_(4.713452345865868007896929312727287621660e-1), SC_(5.286547654134131992103070687272712378340e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.760149841308593750000000000000000000000e2), SC_(5.081215015098330713942711632524285868092e-1), SC_(4.918784984901669286057288367475714131908e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.763565368652343750000000000000000000000e2), SC_(5.122222056015839729418702851870082228153e-1), SC_(4.877777943984160270581297148129917771847e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.869194335937500000000000000000000000000e2), SC_(5.124354606714290055689252384676149136966e-1), SC_(4.875645393285709944310747615323850863034e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.893031616210937500000000000000000000000e2), SC_(5.161254820494971151556667529673601115050e-1), SC_(4.838745179505028848443332470326398884950e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.929573974609375000000000000000000000000e2), SC_(5.531876542840171889193387701338165635613e-1), SC_(4.468123457159828110806612298661834364387e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(3.219386901855468750000000000000000000000e2), SC_(8.513005674208074825441551801642125084159e-1), SC_(1.486994325791925174558448198357874915841e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(3.615783691406250000000000000000000000000e2), SC_(9.780024455378845261091197379641652777936e-1), SC_(2.199755446211547389088026203583472220644e-2) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(3.917980346679687500000000000000000000000e2), SC_(9.983115035140286580062560483020154141170e-1), SC_(1.688496485971341993743951697984585883000e-3) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(4.776162719726562500000000000000000000000e2), SC_(9.999988248251383671568829954336245034118e-1), SC_(1.175174861632843117004566375496588217177e-6) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(6.397833251953125000000000000000000000000e2), SC_(9.999999999999999946281268476409928253791e-1), SC_(5.371873152359007174620879218383492670535e-18) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(9.691037597656250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.915176364219277853615766291492565246730e-50) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(1.292348510742187500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.378650065322474710899178009783716890734e-90) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(1.623300537109375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.414519621676446831209443583238453137745e-134) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.276860427856445312500000000000000000000e1), SC_(6.571893492262682733314210755030323694121e-66), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(8.205272674560546875000000000000000000000e1), SC_(6.222351828065297326438639201279564667216e-32), SC_(9.999999999999999999999999999999377764817e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(1.654523620605468750000000000000000000000e2), SC_(2.854286609305837561879548908425614142518e-11), SC_(9.999999999714571339069416243812045109157e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(2.498611755371093750000000000000000000000e2), SC_(1.777485056971065661941746848459128049370e-3), SC_(9.982225149430289343380582531515408719506e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.033960876464843750000000000000000000000e2), SC_(1.374464142949311058872070346861157283499e-1), SC_(8.625535857050688941127929653138842716501e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.366677551269531250000000000000000000000e2), SC_(4.676061264556768713877751846593086960642e-1), SC_(5.323938735443231286122248153406913039358e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.402249145507812500000000000000000000000e2), SC_(5.067480681068630175444128622371878959473e-1), SC_(4.932519318931369824555871377628121040527e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.434870300292968750000000000000000000000e2), SC_(5.110439266156648170369597949746588478845e-1), SC_(4.889560733843351829630402050253411521155e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.447234802246093750000000000000000000000e2), SC_(5.114608799864389794294869058064228226797e-1), SC_(4.885391200135610205705130941935771773203e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.507308654785156250000000000000000000000e2), SC_(5.153133433326934518913429622805797440030e-1), SC_(4.846866566673065481086570377194202559970e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.549089050292968750000000000000000000000e2), SC_(5.544580134886761944149541549546055895276e-1), SC_(4.455419865113238055850458450453944104724e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.866771850585937500000000000000000000000e2), SC_(8.632458907222372176758540701455728414523e-1), SC_(1.367541092777627823241459298544271585477e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.218722229003906250000000000000000000000e2), SC_(9.824101164948558873017233995248595319124e-1), SC_(1.758988350514411269827660047514046808764e-2) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(4.575935974121093750000000000000000000000e2), SC_(9.989296696726025673453976637674844138742e-1), SC_(1.070330327397432654602336232515586125818e-3) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(5.323255615234375000000000000000000000000e2), SC_(9.999994857485403085169487378603671324530e-1), SC_(5.142514596914830512621396328675470434363e-7) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(7.126392822265625000000000000000000000000e2), SC_(9.999999999999999996701455829344745352491e-1), SC_(3.298544170655254647509208150966727941752e-19) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(1.069891601562500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.424744138825007450930271596812329680433e-54) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(1.435762817382812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.076777782962802700135032812122087438678e-97) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(1.808824340820312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.349222606350203484313110999500743711845e-146) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.664247512817382812500000000000000000000e1), SC_(1.449031753605033048264477834517658333359e-68), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(9.190628051757812500000000000000000000000e1), SC_(1.492965252096906827452702273412266894488e-33), SC_(9.999999999999999999999999999999985070347e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(1.865486907958984375000000000000000000000e2), SC_(6.340291443090956342860390999473869753546e-12), SC_(9.999999999936597085569090436571396090005e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(2.809606323242187500000000000000000000000e2), SC_(1.258292552687747195229433670426670577251e-3), SC_(9.987417074473122528047705663295733294227e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.375775146484375000000000000000000000000e2), SC_(1.290482415043883811325440533071975484394e-1), SC_(8.709517584956116188674559466928024515606e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.749502563476562500000000000000000000000e2), SC_(4.655279699175087941015634047587942320674e-1), SC_(5.344720300824912058984365952412057679326e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.816014099121093750000000000000000000000e2), SC_(5.059750051743469325143446227416571488303e-1), SC_(4.940249948256530674856553772583428511697e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.833723754882812500000000000000000000000e2), SC_(5.104597151985650722650138398672064962173e-1), SC_(4.895402848014349277349861601327935037827e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.834787292480468750000000000000000000000e2), SC_(5.109098869634117461163543633783265306224e-1), SC_(4.890901130365882538836456366216734693776e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.842213134765625000000000000000000000000e2), SC_(5.149604345139531691084038701458710853699e-1), SC_(4.850395654860468308915961298541289146301e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.887658386230468750000000000000000000000e2), SC_(5.552765949510064345395840057587934245365e-1), SC_(4.447234050489935654604159942412065754635e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.240257873535156250000000000000000000000e2), SC_(8.700513024660412992573558843717430513134e-1), SC_(1.299486975339587007426441156282569486866e-1) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(4.628550720214843750000000000000000000000e2), SC_(9.850057470361535912337785878393254065584e-1), SC_(1.499425296384640876622141216067459344162e-2) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.018748168945312500000000000000000000000e2), SC_(9.992247064529382248329146415816119848902e-1), SC_(7.752935470617751670853584183880151098297e-4) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(5.822414550781250000000000000000000000000e2), SC_(9.999997646124643871863394206304647360379e-1), SC_(2.353875356128136605793695352639621225505e-7) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(7.810305175781250000000000000000000000000e2), SC_(9.999999999999999999779248248724596532960e-1), SC_(2.207517512754034670401954986070661690535e-20) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(1.172258056640625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.095070095321831462795347849221808980291e-57) }}, 
      {{ SC_(1.919389953613281250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(1.564925048828125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.014814951218737511926786753760116294160e-104) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(9.698475341796875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.356327861902998665044540644020592145027e-103) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.993793869018554687500000000000000000000e1), SC_(7.079484859217400071457088682952950926931e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(4.997550964355468750000000000000000000000e1), SC_(1.117206806049894950836116877627077168224e-28), SC_(9.999999999999999999999999998882793193950e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.000775756835937500000000000000000000000e2), SC_(6.289299854251269040844162749557914768213e-10), SC_(9.999999993710700145748730959155837250442e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.516853332519531250000000000000000000000e2), SC_(3.853958852732881584807054555457278774432e-3), SC_(9.961460411472671184151929454445427212256e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(1.911952514648437500000000000000000000000e2), SC_(1.617433276107272024011537066660855883985e-1), SC_(8.382566723892727975988462933339144116015e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.103956909179687500000000000000000000000e2), SC_(4.739317315253452599637366328382512057996e-1), SC_(5.260682684746547400362633671617487942004e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.147701873779296875000000000000000000000e2), SC_(5.094139578848911016382862556666823716839e-1), SC_(4.905860421151088983617137443333176283161e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.155057220458984375000000000000000000000e2), SC_(5.133445559966746464345169615468185507507e-1), SC_(4.866554440033253535654830384531814492493e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.180711822509765625000000000000000000000e2), SC_(5.137009889985030743958547665421670621531e-1), SC_(4.862990110014969256041452334578329378469e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.186286010742187500000000000000000000000e2), SC_(5.172416794224209433175223358392053367281e-1), SC_(4.827583205775790566824776641607946632719e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.223092956542968750000000000000000000000e2), SC_(5.524732716938170843995371339181026175326e-1), SC_(4.475267283061829156004628660818973824674e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.435290985107421875000000000000000000000e2), SC_(8.395533139828482244095556042831974286019e-1), SC_(1.604466860171517755904443957168025713981e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.674027404785156250000000000000000000000e2), SC_(9.711602881270757997364456065527545275374e-1), SC_(2.883971187292420026355439344724547246264e-2) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.918960571289062500000000000000000000000e2), SC_(9.970933324000584060049800008507729846736e-1), SC_(2.906667599941593995019999149227015326422e-3) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(3.408752441406250000000000000000000000000e2), SC_(9.999935940772495539533537812071084094467e-1), SC_(6.405922750446046646218792891590553299927e-6) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(4.555717163085937500000000000000000000000e2), SC_(9.999999999999979883325136912510417377951e-1), SC_(2.011667486308748958262204869334103491367e-15) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(6.920676269531250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.031800243397427270795091134442464707154e-42) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(9.415906982421875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.852607999000258547374482946561934116086e-74) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.186098144531250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.404041682980427433777799293545683746052e-110) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.483974266052246093750000000000000000000e1), SC_(5.364661049504583411733564316171204403499e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(6.217811584472656250000000000000000000000e1), SC_(1.988655833151305520101970304270948623194e-29), SC_(9.999999999999999999999999999801134416685e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.262093505859375000000000000000000000000e2), SC_(2.794029368648650837149525955508966216375e-10), SC_(9.999999997205970631351349162850474044491e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(1.900465850830078125000000000000000000000e2), SC_(3.123013978983607939085471196573399442325e-3), SC_(9.968769860210163920609145288034266005577e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.291815948486328125000000000000000000000e2), SC_(1.550919173751294648155284392872122314889e-1), SC_(8.449080826248705351844715607127877685111e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.537596740722656250000000000000000000000e2), SC_(4.720745157359491567903739994151414636125e-1), SC_(5.279254842640508432096260005848585363875e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.561762695312500000000000000000000000000e2), SC_(5.085613219292726420128273413871693164056e-1), SC_(4.914386780707273579871726586128306835944e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.652716064453125000000000000000000000000e2), SC_(5.124317269386415715754729518481905005357e-1), SC_(4.875682730613584284245270481518094994643e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.714853820800781250000000000000000000000e2), SC_(5.127210428986463283247479446898338441228e-1), SC_(4.872789571013536716752520553101661558772e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.730332946777343750000000000000000000000e2), SC_(5.163792778619339531139413359138933463341e-1), SC_(4.836207221380660468860586640861066536659e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.801387329101562500000000000000000000000e2), SC_(5.530351751215045972322836735990440213882e-1), SC_(4.469648248784954027677163264009559786118e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(3.051734008789062500000000000000000000000e2), SC_(8.486474591540691327423230169427174037345e-1), SC_(1.513525408459308672576769830572825962655e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(3.455574645996093750000000000000000000000e2), SC_(9.768848436866329985934446942145693410913e-1), SC_(2.311515631336700140655530578543065890867e-2) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(3.771143188476562500000000000000000000000e2), SC_(9.981637235388023121701756012650260241806e-1), SC_(1.836276461197687829824398734973975819428e-3) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(4.366959228515625000000000000000000000000e2), SC_(9.999979446180963885002153502693213047280e-1), SC_(2.055381903611499784649730678695271989819e-6) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(5.874907226562500000000000000000000000000e2), SC_(9.999999999999999663439714068575286373436e-1), SC_(3.365602859314247136265640213723787418267e-17) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(9.071672973632812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.038897948809785917417054809840626788457e-48) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(1.209827758789062500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.171211601895539174393548459832788574016e-86) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(1.597423339843750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.366288826355948195874864557934162264872e-133) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(3.209654998779296875000000000000000000000e1), SC_(1.007758349647924997555494502262793173389e-65), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(8.102709960937500000000000000000000000000e1), SC_(7.176163067228905473989576090081626596488e-32), SC_(9.999999999999999999999999999999282383693e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(1.620804748535156250000000000000000000000e2), SC_(3.376547413390601533058389990978729343905e-11), SC_(9.999999999662345258660939846694161000902e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(2.443004455566406250000000000000000000000e2), SC_(1.864497423955676032682038057042800875363e-3), SC_(9.981355025760443239673179619429571991246e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(2.958838500976562500000000000000000000000e2), SC_(1.390281628249781586113164574090081215726e-1), SC_(8.609718371750218413886835425909918784274e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.259918823242187500000000000000000000000e2), SC_(4.681444933726258781376169269135483242708e-1), SC_(5.318555066273741218623830730864516757292e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.316465759277343750000000000000000000000e2), SC_(5.069136444271966956210110038208737685818e-1), SC_(4.930863555728033043789889961791262314182e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.342220458984375000000000000000000000000e2), SC_(5.111906277277946932867249532851863429963e-1), SC_(4.888093722722053067132750467148136570037e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.382144165039062500000000000000000000000e2), SC_(5.115605068033746322498510325344035712941e-1), SC_(4.884394931966253677501489674655964287059e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.414834289550781250000000000000000000000e2), SC_(5.154250634508108910087421490419484335195e-1), SC_(4.845749365491891089912578509580515664805e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.450556945800781250000000000000000000000e2), SC_(5.542791823715692902140949748083825195954e-1), SC_(4.457208176284307097859050251916174804046e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.790169372558593750000000000000000000000e2), SC_(8.620775133121157376070281504367951294819e-1), SC_(1.379224866878842623929718495632048705181e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(4.149154052734375000000000000000000000000e2), SC_(9.820292975084268482347895305461851800948e-1), SC_(1.797070249157315176521046945381481990515e-2) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(4.568905639648437500000000000000000000000e2), SC_(9.989348993774708839007296445065057972061e-1), SC_(1.065100622529116099270355493494202793861e-3) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(5.287032470703125000000000000000000000000e2), SC_(9.999994685179490903285631229178378977018e-1), SC_(5.314820509096714368770821621022981917046e-7) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(7.051970825195312500000000000000000000000e2), SC_(9.999999999999999995878582576423742363401e-1), SC_(4.121417423576257636599475652867478633069e-19) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(1.057901855468750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.217012023542934600958854142387033937213e-53) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(1.412275634765625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.518769082147717143208324614360983726286e-96) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(1.779787719726562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.289081726628480016761065051505850425434e-144) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.573934936523437500000000000000000000000e1), SC_(3.777498912203669230839675377384990842481e-68), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(8.942610168457031250000000000000000000000e1), SC_(3.188794976447674953427281084095486983454e-33), SC_(9.999999999999999999999999999999968112050e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(1.800072631835937500000000000000000000000e2), SC_(9.655807150563530506435945030622962774551e-12), SC_(9.999999999903441928494364694935640549694e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(2.721290283203125000000000000000000000000e2), SC_(1.375454380276325440024780767000786451978e-3), SC_(9.986245456197236745599752192329992135480e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.307487182617187500000000000000000000000e2), SC_(1.304525917162356330288249227785619622304e-1), SC_(8.695474082837643669711750772214380377696e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.650119628906250000000000000000000000000e2), SC_(4.660173312897363414985039381647102802606e-1), SC_(5.339826687102636585014960618352897197394e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.737970275878906250000000000000000000000e2), SC_(5.061099139895667310871503705692845406778e-1), SC_(4.938900860104332689128496294307154593222e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.756879882812500000000000000000000000000e2), SC_(5.105660254477545899047984780381901174239e-1), SC_(4.894339745522454100952015219618098825761e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.761975402832031250000000000000000000000e2), SC_(5.110076880719513620790206594733871933380e-1), SC_(4.889923119280486379209793405266128066620e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.801912841796875000000000000000000000000e2), SC_(5.150042187975939803664416182180071519864e-1), SC_(4.849957812024060196335583817819928480136e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.868878173828125000000000000000000000000e2), SC_(5.552716767603984898357172639624896720004e-1), SC_(4.447283232396015101642827360375103279996e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.228908691406250000000000000000000000000e2), SC_(8.700586125270903608080204373073832546398e-1), SC_(1.299413874729096391919795626926167453602e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(4.614170532226562500000000000000000000000e2), SC_(9.849923290671613773099178763388389574229e-1), SC_(1.500767093283862269008212366116104257709e-2) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.003847045898437500000000000000000000000e2), SC_(9.992233753678839263153808776032908550182e-1), SC_(7.766246321160736846191223967091449818486e-4) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(5.789858398437500000000000000000000000000e2), SC_(9.999997574033421483267360969023860487988e-1), SC_(2.425966578516732639030976139512012374337e-7) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(7.731036376953125000000000000000000000000e2), SC_(9.999999999999999999715520872518334932276e-1), SC_(2.844791274816650677237020580857646804727e-20) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(1.160359130859375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.516475066670231391459937241865394758919e-57) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(1.548525512695312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.236299537197625770921236073007164908231e-103) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(1.946173706054687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.941885649095342714066748680698036939334e-155) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.915890884399414062500000000000000000000e1), SC_(1.197588697022321341466316720506334944082e-70), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(9.795663452148437500000000000000000000000e1), SC_(1.074277080686761218824788755827425790150e-34), SC_(9.999999999999999999999999999999998925723e-1) }}, 
      {{ SC_(1.930128173828125000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(1.961525421142578125000000000000000000000e2), SC_(2.939123642211351451907300439381825214808e-12), SC_(9.999999999970608763577886485480926995606e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.458959960937500000000000000000000000000e2), SC_(3.836369681301586735262234154448541527128e-3), SC_(9.961636303186984132647377658455514584729e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(1.799440612792968750000000000000000000000e2), SC_(1.623138175101686942792070272728995823604e-1), SC_(8.376861824898313057207929727271004176396e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.984559020996093750000000000000000000000e2), SC_(4.741249755755487496808921606050862850299e-1), SC_(5.258750244244512503191078393949137149701e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(2.005129089355468750000000000000000000000e2), SC_(5.095677572742610292395591551886878316582e-1), SC_(4.904322427257389707604408448113121683418e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(2.028055725097656250000000000000000000000e2), SC_(5.134786865448284027275150830616592065727e-1), SC_(4.865213134551715972724849169383407934273e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.130189514160156250000000000000000000000e2), SC_(5.137624393207943666908604502383789420986e-1), SC_(4.862375606792056333091395497616210579014e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.132924652099609375000000000000000000000e2), SC_(5.173036115605493169601185055834296202506e-1), SC_(4.826963884394506830398814944165703797494e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.176990814208984375000000000000000000000e2), SC_(5.524944078544490207746728523749723751744e-1), SC_(4.475055921455509792253271476250276248256e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.376706237792968750000000000000000000000e2), SC_(8.392463381609262825640079827758315082177e-1), SC_(1.607536618390737174359920172241684917823e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.623294372558593750000000000000000000000e2), SC_(9.710239024631509767562621909261517061695e-1), SC_(2.897609753684902324373780907384829383053e-2) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.846592407226562500000000000000000000000e2), SC_(9.970435073073685145661060158866024730570e-1), SC_(2.956492692631485433893984113397526943048e-3) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(3.310000305175781250000000000000000000000e2), SC_(9.999931884063136397014840439873990580162e-1), SC_(6.811593686360298515956012600941983774969e-6) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(4.438971252441406250000000000000000000000e2), SC_(9.999999999999975356400032684991509399554e-1), SC_(2.464359996731500849060044642217493743292e-15) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(6.701822509765625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.645594360111761527578630256444071067512e-41) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(9.003756103515625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.166514250553488953421387114374646453887e-73) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.139043090820312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.557219774386718666664965704274502142402e-108) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.283443260192871093750000000000000000000e1), SC_(1.644267670966118344128233793299882213251e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(5.781192016601562500000000000000000000000e1), SC_(4.055036418025581194434426856550531691346e-29), SC_(9.999999999999999999999999999594496358197e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.179780731201171875000000000000000000000e2), SC_(3.817646249962779969140436849001188186757e-10), SC_(9.999999996182353750037220030859563150999e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(1.783335876464843750000000000000000000000e2), SC_(3.373769151783918823809273733915167379696e-3), SC_(9.966262308482160811761907262660848326203e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.240602874755859375000000000000000000000e2), SC_(1.559484341312282346354152663510997678864e-1), SC_(8.440515658687717653645847336489002321136e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.467782287597656250000000000000000000000e2), SC_(4.723843004409912220240930925326138552094e-1), SC_(5.276156995590087779759069074673861447906e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.527241973876953125000000000000000000000e2), SC_(5.086318822244048997123446150425337427071e-1), SC_(4.913681177755951002876553849574662572929e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.539539184570312500000000000000000000000e2), SC_(5.126488825847419824720476783165511938794e-1), SC_(4.873511174152580175279523216834488061206e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.552302246093750000000000000000000000000e2), SC_(5.130286288471015821150086668934853688008e-1), SC_(4.869713711528984178849913331065146311992e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.571382751464843750000000000000000000000e2), SC_(5.166360789280768881378363558351036806580e-1), SC_(4.833639210719231118621636441648963193420e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.595610961914062500000000000000000000000e2), SC_(5.527908043152260785232141431248048554563e-1), SC_(4.472091956847739214767858568751951445437e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.924130859375000000000000000000000000000e2), SC_(8.466622309954984505193871066033541459662e-1), SC_(1.533377690045015494806128933966458540338e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(3.264200439453125000000000000000000000000e2), SC_(9.754636450266182239116845568878278616342e-1), SC_(2.453635497338177608831544311217213836580e-2) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(3.553146972656250000000000000000000000000e2), SC_(9.979114442688663506005079616127359150450e-1), SC_(2.088555731133649399492038387264084955048e-3) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(4.168853149414062500000000000000000000000e2), SC_(9.999973527764456485184945155694181600817e-1), SC_(2.647223554351481505484430581839918332875e-6) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(5.559776611328125000000000000000000000000e2), SC_(9.999999999999999036499869329557573230656e-1), SC_(9.635001306704424267693443329548169604947e-17) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(8.655690307617187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.345239054878306674411714602430898870239e-47) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(1.162585693359375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.542766579105996966391533714444483376850e-84) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(1.458445434570312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.599441825842078955200204286752931789838e-125) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.943038368225097656250000000000000000000e1), SC_(2.778426519967732420567707468225825548705e-64), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(7.573689270019531250000000000000000000000e1), SC_(3.867588072446125763369077635178733924271e-31), SC_(9.999999999999999999999999999996132411928e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(1.515077056884765625000000000000000000000e2), SC_(6.511743395383864450179224919560722052553e-11), SC_(9.999999999348825660461613554982077508044e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.400323638916015625000000000000000000000e2), SC_(1.938161461816197493996079875347774269488e-3), SC_(9.980618385381838025060039201246522257305e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(2.893715515136718750000000000000000000000e2), SC_(1.404899324559517148421126064136408208769e-1), SC_(8.595100675440482851578873935863591791231e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(3.214201965332031250000000000000000000000e2), SC_(4.683695426770338549318010756609617686173e-1), SC_(5.316304573229661450681989243390382313827e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.243947143554687500000000000000000000000e2), SC_(5.070578832332186759507481780967383159647e-1), SC_(4.929421167667813240492518219032616840353e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(3.262923889160156250000000000000000000000e2), SC_(5.113199216038242020942662345733028322897e-1), SC_(4.886800783961757979057337654266971677103e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.293512268066406250000000000000000000000e2), SC_(5.117000950617156409378036592307231606744e-1), SC_(4.882999049382843590621963407692768393256e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.301730651855468750000000000000000000000e2), SC_(5.155655950416666626649464236634940908359e-1), SC_(4.844344049583333373350535763365059091641e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.358623962402343750000000000000000000000e2), SC_(5.541018087876389458777290337244625042427e-1), SC_(4.458981912123610541222709662755374957573e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.682585754394531250000000000000000000000e2), SC_(8.602286912638974845106236629302714393350e-1), SC_(1.397713087361025154893763370697285606650e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.064869079589843750000000000000000000000e2), SC_(9.814975327105659256092590759586515934198e-1), SC_(1.850246728943407439074092404134840658015e-2) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(4.442109375000000000000000000000000000000e2), SC_(9.988405657912492701488145030748285419929e-1), SC_(1.159434208750729851185496925171458007100e-3) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(5.132966918945312500000000000000000000000e2), SC_(9.999993356439631927154186581390223508540e-1), SC_(6.643560368072845813418609776491459739267e-7) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(6.902386474609375000000000000000000000000e2), SC_(9.999999999999999992906442359151758168075e-1), SC_(7.093557640848241831924897029739575488401e-19) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(1.038963867187500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.202848778485209896802323958425447058006e-53) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(1.408051025390625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.927430827822162187559694313877504572337e-96) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(1.765136474609375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.499406173522123923317644861049459386475e-143) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.531570053100585937500000000000000000000e1), SC_(5.664348709529903437051240849415935413714e-68), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(8.829811096191406250000000000000000000000e1), SC_(4.401014235034326077580973636787786523216e-33), SC_(9.999999999999999999999999999999955989858e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(1.768136901855468750000000000000000000000e2), SC_(1.178240748069050256807040163814435000468e-11), SC_(9.999999999882175925193094974319295983619e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(2.673870239257812500000000000000000000000e2), SC_(1.441964343579586399951480216402026070120e-3), SC_(9.985580356564204136000485197835979739299e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.221567687988281250000000000000000000000e2), SC_(1.324076169894047824037903540644253450243e-1), SC_(8.675923830105952175962096459355746549757e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.546802673339843750000000000000000000000e2), SC_(4.665514953700421315233161435802431648240e-1), SC_(5.334485046299578684766838564197568351760e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.602124328613281250000000000000000000000e2), SC_(5.063565802777426214683084647731344529114e-1), SC_(4.936434197222573785316915352268655470886e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.633971557617187500000000000000000000000e2), SC_(5.107416446958363588656710045874748922900e-1), SC_(4.892583553041636411343289954125251077100e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.680938720703125000000000000000000000000e2), SC_(5.111196752845129879952348205040053120918e-1), SC_(4.888803247154870120047651794959946879082e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.696266784667968750000000000000000000000e2), SC_(5.151134373137837897069435670584756050539e-1), SC_(4.848865626862162102930564329415243949461e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.784769592285156250000000000000000000000e2), SC_(5.550859960050705452379748778549927098616e-1), SC_(4.449140039949294547620251221450072901384e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.138711242675781250000000000000000000000e2), SC_(8.685504824397677343048517093105489380848e-1), SC_(1.314495175602322656951482906894510619152e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.520620727539062500000000000000000000000e2), SC_(9.844704685984041900883968785700060778090e-1), SC_(1.552953140159580991160312142999392219099e-2) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(4.944808959960937500000000000000000000000e2), SC_(9.991928894757876921009143914721726770583e-1), SC_(8.071105242123078990856085278273229417377e-4) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(5.754235839843750000000000000000000000000e2), SC_(9.999997462266743318345811082817370614213e-1), SC_(2.537733256681654188917182629385786599390e-7) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(7.700093994140625000000000000000000000000e2), SC_(9.999999999999999999688643058219527000875e-1), SC_(3.113569417804729991252878956263552664032e-20) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(1.155218017578125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.547468842527009874418313850481025103132e-57) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.541879150390625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.041376652482757275410640900773066359893e-103) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(1.932745117187500000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.142446025874828304207464558673027551698e-154) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.871102905273437500000000000000000000000e1), SC_(2.003399328698510360963110321026629281213e-70), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(9.683621215820312500000000000000000000000e1), SC_(1.527381945691237314958318191846297309576e-34), SC_(9.999999999999999999999999999999998472618e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(1.938449249267578125000000000000000000000e2), SC_(3.396727462161943359239426033561020991621e-12), SC_(9.999999999966032725378380566407605739664e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(2.923449096679687500000000000000000000000e2), SC_(1.087377414776988423740069414003098480131e-3), SC_(9.989126225852230115762599305859969015199e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.529328002929687500000000000000000000000e2), SC_(1.250364695018262861598708685239074169769e-1), SC_(8.749635304981737138401291314760925830231e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.884611511230468750000000000000000000000e2), SC_(4.647476156790600221753780054541823302305e-1), SC_(5.352523843209399778246219945458176697695e-1) }}, 
      {{ SC_(1.935712890625000000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.924707031250000000000000000000000000000e2), SC_(5.057801533195832957047205794152152883081e-1), SC_(4.942198466804167042952794205847847116919e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.947613830566406250000000000000000000000e2), SC_(5.135092032620718690794224008622225878798e-1), SC_(4.864907967379281309205775991377774121202e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(2.001912689208984375000000000000000000000e2), SC_(5.138827021858604034324170847350047073633e-1), SC_(4.861172978141395965675829152649952926367e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(2.008946075439453125000000000000000000000e2), SC_(5.174113333643939309499137175752654457279e-1), SC_(4.825886666356060690500862824247345542721e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(2.029564971923828125000000000000000000000e2), SC_(5.524904809694793581090212722490215601318e-1), SC_(4.475095190305206418909787277509784398682e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(2.233428802490234375000000000000000000000e2), SC_(8.383996230272094286574504713414879553065e-1), SC_(1.616003769727905713425495286585120446935e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.558772735595703125000000000000000000000e2), SC_(9.707838764767466372479571549222497124379e-1), SC_(2.921612352325336275204284507775028756208e-2) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.773066101074218750000000000000000000000e2), SC_(9.969883218303030586640162404461997989738e-1), SC_(3.011678169696941335983759553800201026163e-3) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(3.236655578613281250000000000000000000000e2), SC_(9.999928837262122328953711582069310061590e-1), SC_(7.116273787767104628841793068993840980409e-6) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(4.325951843261718750000000000000000000000e2), SC_(9.999999999999969955636226694564550385671e-1), SC_(3.004436377330543544961432948598822477185e-15) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(6.565237426757812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.953339402122163162797378400177712884434e-41) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(8.768082275390625000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.080736226285789066669771786882580041952e-72) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.104500488281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.617364030001309479489645215084251935067e-107) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.221819686889648437500000000000000000000e1), SC_(1.986755240962492187999126488777829907895e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(5.590687179565429687500000000000000000000e1), SC_(5.105156803202481818771027904387975552668e-29), SC_(9.999999999999999999999999999489484319680e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.126636505126953125000000000000000000000e2), SC_(4.509714144773889807186201559108633174688e-10), SC_(9.999999995490285855226110192813798440891e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(1.710315246582031250000000000000000000000e2), SC_(3.516141046869618946512625062054498360037e-3), SC_(9.964838589531303810534873749379455016400e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.057199554443359375000000000000000000000e2), SC_(1.592919192590682238167019559726586073439e-1), SC_(8.407080807409317761832980440273413926561e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.291662750244140625000000000000000000000e2), SC_(4.731752534509140636495812587889562460092e-1), SC_(5.268247465490859363504187412110437539908e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.359533538818359375000000000000000000000e2), SC_(5.089948993564656778691252605938216194566e-1), SC_(4.910051006435343221308747394061783805434e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.380115051269531250000000000000000000000e2), SC_(5.129516188922002842668990329009931855465e-1), SC_(4.870483811077997157331009670990068144535e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.492142028808593750000000000000000000000e2), SC_(5.131416422934467620489589218388753978061e-1), SC_(4.868583577065532379510410781611246021939e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.497538452148437500000000000000000000000e2), SC_(5.167563246127383807040003439237568421028e-1), SC_(4.832436753872616192959996560762431578972e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.557426757812500000000000000000000000000e2), SC_(5.527616449915676771751002687149979106374e-1), SC_(4.472383550084323228248997312850020893626e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.796060485839843750000000000000000000000e2), SC_(8.446864861492297603129770125821524667758e-1), SC_(1.553135138507702396870229874178475332242e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(3.065257263183593750000000000000000000000e2), SC_(9.739726977329769061928523084242783345047e-1), SC_(2.602730226702309380714769157572166549527e-2) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(3.342492065429687500000000000000000000000e2), SC_(9.976494165302558770455173234994478687684e-1), SC_(2.350583469744122954482676500552131231622e-3) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(3.858368530273437500000000000000000000000e2), SC_(9.999961126876018214697427351226094551428e-1), SC_(3.887312398178530257264877390544857248289e-6) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(5.321269531250000000000000000000000000000e2), SC_(9.999999999999997917410757701464724661510e-1), SC_(2.082589242298535275338490140186905145437e-16) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(8.167502441406250000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.491831162513753744264579952158976183828e-45) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(1.094209594726562500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.755367976738014718684122394265742506906e-81) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(1.390784790039062500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.135190551378145376772932341600310316145e-121) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.782222366333007812500000000000000000000e1), SC_(1.686362567269413958987552944527111552803e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(7.218910217285156250000000000000000000000e1), SC_(1.127090707203657962939374907317842644763e-30), SC_(9.999999999999999999999999999988729092928e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(1.454399108886718750000000000000000000000e2), SC_(9.326968511437790113164864748093269416446e-11), SC_(9.999999999067303148856220988683513525191e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.189418640136718750000000000000000000000e2), SC_(2.391390081383103009819693655104396181103e-3), SC_(9.976086099186168969901803063448956038189e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.650834960937500000000000000000000000000e2), SC_(1.464118366469234943359323708891025792665e-1), SC_(8.535881633530765056640676291108974207335e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(3.001491699218750000000000000000000000000e2), SC_(4.695306677570615216593720194760291217225e-1), SC_(5.304693322429384783406279805239708782775e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(3.029455566406250000000000000000000000000e2), SC_(5.075075419572136002829540354690051350467e-1), SC_(4.924924580427863997170459645309948649533e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(3.202765502929687500000000000000000000000e2), SC_(5.114205195696788520621654618931359103257e-1), SC_(4.885794804303211479378345381068640896743e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(3.217895507812500000000000000000000000000e2), SC_(5.118233061005509495366856428687003228784e-1), SC_(4.881766938994490504633143571312996771216e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(3.252251892089843750000000000000000000000e2), SC_(5.156292681376507773295873988751057854362e-1), SC_(4.843707318623492226704126011248942145638e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.282023315429687500000000000000000000000e2), SC_(5.539494285450269711463344186853324529042e-1), SC_(4.460505714549730288536655813146675470958e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(3.591783752441406250000000000000000000000e2), SC_(8.586163798004462043627569955134272935690e-1), SC_(1.413836201995537956372430044865727064310e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.954620666503906250000000000000000000000e2), SC_(9.807412401360523754822733005311338863031e-1), SC_(1.925875986394762451772669946886611369691e-2) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(4.290995483398437500000000000000000000000e2), SC_(9.987140387346258097262582425875938992286e-1), SC_(1.285961265374190273741757412406100771403e-3) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(4.991556396484375000000000000000000000000e2), SC_(9.999991820668481103776819211001959308639e-1), SC_(8.179331518896223180788998040691361082547e-7) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(6.700278320312500000000000000000000000000e2), SC_(9.999999999999999984855127939857573451360e-1), SC_(1.514487206014242654864040301523514282018e-18) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(1.016917419433593750000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.988141503911506579308748927701455796568e-52) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(1.367736572265625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.795952602897018072579789155481537881779e-94) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(1.712155883789062500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.533018327357479258040378619079817509323e-140) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.453527450561523437500000000000000000000e1), SC_(1.726243213995840006066428384205584313769e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(8.663867187500000000000000000000000000000e1), SC_(7.866140000098226950200290865686534010691e-33), SC_(9.999999999999999999999999999999921338600e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(1.761230773925781250000000000000000000000e2), SC_(1.222086494299784448232785447227548816140e-11), SC_(9.999999999877791350570021555176721455277e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(2.649454956054687500000000000000000000000e2), SC_(1.477946936547121326246983414488927292525e-3), SC_(9.985220530634528786737530165855110727075e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.180513610839843750000000000000000000000e2), SC_(1.333523293046245719387509968674738363874e-1), SC_(8.666476706953754280612490031325261636126e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.498916015625000000000000000000000000000e2), SC_(4.668005505434214405596222528635822516878e-1), SC_(5.331994494565785594403777471364177483122e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.535069274902343750000000000000000000000e2), SC_(5.064817199141699266515047546688857021319e-1), SC_(4.935182800858300733484952453311142978681e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.567494201660156250000000000000000000000e2), SC_(5.108397464231182976492068925269883360716e-1), SC_(4.891602535768817023507931074730116639284e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.582211914062500000000000000000000000000e2), SC_(5.112602667713525469511371881724814677424e-1), SC_(4.887397332286474530488628118275185322576e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.588547973632812500000000000000000000000e2), SC_(5.152297497091274812657647369834709110761e-1), SC_(4.847702502908725187342352630165290889239e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.644144592285156250000000000000000000000e2), SC_(5.547578277439759722330573869033907393353e-1), SC_(4.452421722560240277669426130966092606647e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.999936218261718750000000000000000000000e2), SC_(8.660892769894124951263682026858691855151e-1), SC_(1.339107230105875048736317973141308144849e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(4.419485778808593750000000000000000000000e2), SC_(9.838637262768752029840124397587775532635e-1), SC_(1.613627372312479701598756024122244673653e-2) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(4.803380432128906250000000000000000000000e2), SC_(9.991069976657521503057769843209813680566e-1), SC_(8.930023342478496942230156790186319434438e-4) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(5.624445800781250000000000000000000000000e2), SC_(9.999996902945307135043269759678350833558e-1), SC_(3.097054692864956730240321649166441912095e-7) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(7.529597167968750000000000000000000000000e2), SC_(9.999999999999999999396231724700789479250e-1), SC_(6.037682752992105207499333458268559791945e-20) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(1.130855346679687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.604234240763656678183114145624367363869e-56) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(1.522413330078125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.481442706844661140887597997265325959608e-102) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(1.919245605468750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.341775500661299944118310743267452227456e-153) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.852381134033203125000000000000000000000e1), SC_(2.476606459965253621398958258254441321664e-70), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(9.632651519775390625000000000000000000000e1), SC_(1.796728050276292846536776081343147591721e-34), SC_(9.999999999999999999999999999999998203272e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.928515930175781250000000000000000000000e2), SC_(3.614796292698542125603492426577251878119e-12), SC_(9.999999999963852037073014578743965075734e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(2.900867919921875000000000000000000000000e2), SC_(1.113396621412919077126125244058680014840e-3), SC_(9.988866033785870809228738747559413199852e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.486093139648437500000000000000000000000e2), SC_(1.260043620686036400689364737303857711634e-1), SC_(8.739956379313963599310635262696142288366e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.837024536132812500000000000000000000000e2), SC_(4.649891875538260782882342178431891509171e-1), SC_(5.350108124461739217117657821568108490829e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.875353393554687500000000000000000000000e2), SC_(5.058642817409471234186418745537419484671e-1), SC_(4.941357182590528765813581254462580515329e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.900266113281250000000000000000000000000e2), SC_(5.103700407348804533015211595976060545286e-1), SC_(4.896299592651195466984788404023939454714e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.924201965332031250000000000000000000000e2), SC_(5.107940360903653201308131656262408819083e-1), SC_(4.892059639096346798691868343737591180917e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.930110473632812500000000000000000000000e2), SC_(5.148847816010773786384104772876709315103e-1), SC_(4.851152183989226213615895227123290684897e-1) }}, 
      {{ SC_(1.938046875000000000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.970279235839843750000000000000000000000e2), SC_(5.555561533968569756585939424649758272338e-1), SC_(4.444438466031430243414060575350241727662e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(2.146151275634765625000000000000000000000e2), SC_(8.383720419078108299834646553166870361262e-1), SC_(1.616279580921891700165353446833129638738e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(2.406174468994140625000000000000000000000e2), SC_(9.704148794688290843402047166998318433612e-1), SC_(2.958512053117091565979528330016815663880e-2) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(2.613483276367187500000000000000000000000e2), SC_(9.969092016214257132132862696811293290017e-1), SC_(3.090798378574286786713730318870670998310e-3) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(3.019354553222656250000000000000000000000e2), SC_(9.999922032409435553319911682822327868181e-1), SC_(7.796759056444668008831717767213181858229e-6) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(4.067644958496093750000000000000000000000e2), SC_(9.999999999999958263669969562823283230176e-1), SC_(4.173633003043717671676982383023860252422e-15) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(6.407229614257812500000000000000000000000e2), SC_(9.999999999999999999999999999999999999999e-1), SC_(5.201743473264585183660762667788686335825e-41) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(8.546241455078125000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.344763177663572988061458982688797184838e-72) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.080601562500000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.486546923733755050052931264674484886330e-106) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.166408729553222656250000000000000000000e1), SC_(2.045595108853650878469535513464922299904e-61), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(5.479612731933593750000000000000000000000e1), SC_(5.355423509033884434012448389582609946889e-29), SC_(9.999999999999999999999999999464457649097e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(1.097726669311523437500000000000000000000e2), SC_(4.763176216505864148786859598855337680553e-10), SC_(9.999999995236823783494135851213140401145e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(1.659325256347656250000000000000000000000e2), SC_(3.590718714697199996151407754897988916395e-3), SC_(9.964092812853028000038485922451020110836e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.002727050781250000000000000000000000000e2), SC_(1.599617896114220650716727769007772244783e-1), SC_(8.400382103885779349283272230992227755217e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.217310638427734375000000000000000000000e2), SC_(4.734404544058604518388100391004524370026e-1), SC_(5.265595455941395481611899608995475629974e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.254449157714843750000000000000000000000e2), SC_(5.091987863742397075461314823224603317470e-1), SC_(4.908012136257602924538685176775396682530e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.283852996826171875000000000000000000000e2), SC_(5.131204733334369546976839593493644635483e-1), SC_(4.868795266665630453023160406506355364517e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.289438934326171875000000000000000000000e2), SC_(5.135085808667221207977465685737989298414e-1), SC_(4.864914191332778792022534314262010701586e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(2.320561981201171875000000000000000000000e2), SC_(5.170384266586478675389159581309319643704e-1), SC_(4.829615733413521324610840418690680356296e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(2.388981628417968750000000000000000000000e2), SC_(5.526319687640116357184478018422941296054e-1), SC_(4.473680312359883642815521981577058703946e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.621902465820312500000000000000000000000e2), SC_(8.422846155423621037647855578597569536092e-1), SC_(1.577153844576378962352144421402430463908e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.994390869140625000000000000000000000000e2), SC_(9.735099706101248703047242796258609045110e-1), SC_(2.649002938987512969527572037413909548897e-2) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(3.248018798828125000000000000000000000000e2), SC_(9.975391024563196259465574483358313172984e-1), SC_(2.460897543680374053442551664168682701576e-3) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(3.803307800292968750000000000000000000000e2), SC_(9.999958954144623511375785369906204217497e-1), SC_(4.104585537648862421463009379578250288739e-6) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(5.090611572265625000000000000000000000000e2), SC_(9.999999999999995833448011029689290410545e-1), SC_(4.166551988970310709589455133094056001226e-16) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(7.673441162109375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(4.269990718661804228106332741782640160044e-44) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(1.029832153320312500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.321415150705164489895591169762204254738e-78) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(1.287839355468750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.203933029709419104970825944965334614875e-115) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.664067649841308593750000000000000000000e1), SC_(4.975723783303104543442035878654639907800e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(6.814834594726562500000000000000000000000e1), SC_(3.362435589493233863287414329680646087238e-30), SC_(9.999999999999999999999999999966375644105e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(1.369478302001953125000000000000000000000e2), SC_(1.487892784554257758908138689895309341191e-10), SC_(9.999999998512107215445742241091861310105e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.088751525878906250000000000000000000000e2), SC_(2.617696087756651721641024926554512564528e-3), SC_(9.973823039122433482783589750734454874355e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.507089385986328125000000000000000000000e2), SC_(1.497521198961114453732814045419918281606e-1), SC_(8.502478801038885546267185954580081718394e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.862087097167968750000000000000000000000e2), SC_(4.702761180024746401976893694717292034501e-1), SC_(5.297238819975253598023106305282707965499e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.909318542480468750000000000000000000000e2), SC_(5.077665306443541286744760936064773196672e-1), SC_(4.922334693556458713255239063935226803328e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.922657775878906250000000000000000000000e2), SC_(5.119146660976046142489322678754331378035e-1), SC_(4.880853339023953857510677321245668621965e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(2.949099731445312500000000000000000000000e2), SC_(5.122842487584911106037156248057327752008e-1), SC_(4.877157512415088893962843751942672247992e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(3.038277893066406250000000000000000000000e2), SC_(5.159187603288383729509596420725680513148e-1), SC_(4.840812396711616270490403579274319486852e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(3.066279907226562500000000000000000000000e2), SC_(5.535395283080839450977074420040905445156e-1), SC_(4.464604716919160549022925579959094554844e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(3.526817932128906250000000000000000000000e2), SC_(8.575113434990475669807192544314554650929e-1), SC_(1.424886565009524330192807455685445349071e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(3.865207824707031250000000000000000000000e2), SC_(9.801303733988280782135643264342720651351e-1), SC_(1.986962660117192178643567356572793486494e-2) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(4.228165588378906250000000000000000000000e2), SC_(9.986614959019991438218673657374508225831e-1), SC_(1.338504098000856178132634262549177416941e-3) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(4.879441223144531250000000000000000000000e2), SC_(9.999990410208493783164417898733151890987e-1), SC_(9.589791506216835582101266848109012536181e-7) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(6.537381591796875000000000000000000000000e2), SC_(9.999999999999999972583874961192489551904e-1), SC_(2.741612503880751044809594775720252813348e-18) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(9.896849365234375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(2.514620136249282025984249833256359837582e-51) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(1.321679443359375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.335810630605210698579801293249271662299e-92) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(1.665568603515625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.570334151724636911021165659304622381058e-137) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.353571701049804687500000000000000000000e1), SC_(6.716264853655404245971063394909364109332e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(8.482893371582031250000000000000000000000e1), SC_(1.437140800451543588502121570103755405333e-32), SC_(9.999999999999999999999999999999856285920e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(1.711387023925781250000000000000000000000e2), SC_(1.703130085618126314726379548928391144017e-11), SC_(9.999999999829686991438187368527362045107e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(2.570808715820312500000000000000000000000e2), SC_(1.605332981659678560092525358724736943273e-3), SC_(9.983946670183403214399074746412752630567e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.111263732910156250000000000000000000000e2), SC_(1.349616832934493610008028942037664126641e-1), SC_(8.650383167065506389991971057962335873359e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.434289855957031250000000000000000000000e2), SC_(4.671366578172192239304526402181056345698e-1), SC_(5.328633421827807760695473597818943654302e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.522368164062500000000000000000000000000e2), SC_(5.065037611491297616633050519306803359745e-1), SC_(4.934962388508702383366949480693196640255e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.536039428710937500000000000000000000000e2), SC_(5.108868120633572783350453567952179570862e-1), SC_(4.891131879366427216649546432047820429138e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(3.537690734863281250000000000000000000000e2), SC_(5.113250403584193496260861823211400738201e-1), SC_(4.886749596415806503739138176788599261799e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(3.541229248046875000000000000000000000000e2), SC_(5.152832476554650871276219057457120312564e-1), SC_(4.847167523445349128723780942542879687436e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(3.577460632324218750000000000000000000000e2), SC_(5.546157983538822888422604059507259336718e-1), SC_(4.453842016461177111577395940492740663282e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.928020019531250000000000000000000000000e2), SC_(8.648557726434075556459794971957378973810e-1), SC_(1.351442273565924443540205028042621026190e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(4.302343750000000000000000000000000000000e2), SC_(9.831437344046299157490827191190611827568e-1), SC_(1.685626559537008425091728088093881724324e-2) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(4.664913940429687500000000000000000000000e2), SC_(9.990160893500882339354270984968922601931e-1), SC_(9.839106499117660645729015031077398068937e-4) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(5.417244873046875000000000000000000000000e2), SC_(9.999995754910038534899740065813969435759e-1), SC_(4.245089961465100259934186030564241385068e-7) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(7.279476318359375000000000000000000000000e2), SC_(9.999999999999999998418045759513557085849e-1), SC_(1.581954240486442914150935568410013102411e-19) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(1.105901123046875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.951649180567943234621586641875037039523e-55) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(1.479336425781250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.064467575689560564996877575985597602090e-99) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(1.876531738281250000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.409881894319420667611262036194116714431e-150) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.768231201171875000000000000000000000000e1), SC_(8.799764591986106355946560189395606974724e-70), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(9.432376861572265625000000000000000000000e1), SC_(3.757720402542461059125443817400015769012e-34), SC_(9.999999999999999999999999999999996242280e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(1.904732971191406250000000000000000000000e2), SC_(4.237481039984742019034579583967524189090e-12), SC_(9.999999999957625189600152579809654204160e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(2.881442871093750000000000000000000000000e2), SC_(1.134619822981691001244091209480076312246e-3), SC_(9.988653801770183089987559087905199236878e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.470232238769531250000000000000000000000e2), SC_(1.263044696157464861465460800970299800737e-1), SC_(8.736955303842535138534539199029700199263e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.817928771972656250000000000000000000000e2), SC_(4.650771228203104256491959417732451630402e-1), SC_(5.349228771796895743508040582267548369598e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.856604003906250000000000000000000000000e2), SC_(5.058953212378158996040714892109770620599e-1), SC_(4.941046787621841003959285107890229379401e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.871256713867187500000000000000000000000e2), SC_(5.104090274039939994877625112368341942832e-1), SC_(4.895909725960060005122374887631658057168e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(3.877257385253906250000000000000000000000e2), SC_(5.108549640966246086670058809257231493554e-1), SC_(4.891450359033753913329941190742768506446e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(3.883094482421875000000000000000000000000e2), SC_(5.149298874378574567896028856050100367820e-1), SC_(4.850701125621425432103971143949899632180e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(3.921492004394531250000000000000000000000e2), SC_(5.554467431753288622511007896269077159680e-1), SC_(4.445532568246711377488992103730922840320e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(4.294068908691406250000000000000000000000e2), SC_(8.714406385766448615942554657129267148676e-1), SC_(1.285593614233551384057445342870732851324e-1) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(4.712691040039062500000000000000000000000e2), SC_(9.856361811767327659908148867041196712205e-1), SC_(1.436381882326723400918511329588032877946e-2) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(5.108501586914062500000000000000000000000e2), SC_(9.992880245327946654171772058464146742316e-1), SC_(7.119754672053345828227941535853257683929e-4) }}, 
      {{ SC_(1.941479644775390625000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(5.901604003906250000000000000000000000000e2), SC_(9.999998012635846873942898852679952883544e-1), SC_(1.987364153126057101147320047116455658270e-7) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(3.943950500488281250000000000000000000000e2), SC_(9.999999999999966911353464085921934608406e-1), SC_(3.308864653591407806539159423007918197812e-15) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(6.078221435546875000000000000000000000000e2), SC_(9.999999999999999999999999999999999999999e-1), SC_(6.480813492357149447316074847883180912175e-41) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(8.125202026367187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.462482456314658419883009700310547203741e-71) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.016915832519531250000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.935579525724936357931457860224878829682e-105) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(2.054751205444335937500000000000000000000e1), SC_(6.988622037250258265632022879817058144825e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(5.391679763793945312500000000000000000000e1), SC_(3.202833110956564581998480192997886000850e-29), SC_(9.999999999999999999999999999679716688904e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(1.078744506835937500000000000000000000000e2), SC_(4.159107063489952898312558556836144610191e-10), SC_(9.999999995840892936510047101687441443164e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(1.636598815917968750000000000000000000000e2), SC_(3.497149958706101142592993022238726338952e-3), SC_(9.965028500412938988574070069777612736610e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(1.968603515625000000000000000000000000000e2), SC_(1.593146669416829491534057303229373325208e-1), SC_(8.406853330583170508465942696770626674792e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.190646057128906250000000000000000000000e2), SC_(4.733337387626487505524188162984705998505e-1), SC_(5.266662612373512494475811837015294001495e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.214165649414062500000000000000000000000e2), SC_(5.092214757378391540109482806097358475843e-1), SC_(4.907785242621608459890517193902641524157e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.233362274169921875000000000000000000000e2), SC_(5.131719121437573599190844846294597882332e-1), SC_(4.868280878562426400809155153705402117668e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.246405639648437500000000000000000000000e2), SC_(5.135501869230950651863095822417533283995e-1), SC_(4.864498130769049348136904177582466716005e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.262897033691406250000000000000000000000e2), SC_(5.171104835183420322292033042202039429422e-1), SC_(4.828895164816579677707966957797960570578e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(2.300410766601562500000000000000000000000e2), SC_(5.527068362431611820194355944722947201591e-1), SC_(4.472931637568388179805644055277052798409e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.535259857177734375000000000000000000000e2), SC_(8.420726295504602247622651610878750721126e-1), SC_(1.579273704495397752377348389121249278874e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(2.772166442871093750000000000000000000000e2), SC_(9.724522945573274829064009331903399464049e-1), SC_(2.754770544267251709359906680966005359514e-2) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(3.040923767089843750000000000000000000000e2), SC_(9.973653187884520508486986258910357331517e-1), SC_(2.634681211547949151301374108964266848253e-3) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(3.579385375976562500000000000000000000000e2), SC_(9.999951130255543779830402570614820696673e-1), SC_(4.886974445622016959742938517930332683048e-6) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(4.808952636718750000000000000000000000000e2), SC_(9.999999999999992343118366846257220267867e-1), SC_(7.656881633153742779732132531270787573386e-16) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(7.548762817382812500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(5.896217835379827684122961666930014773409e-44) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(1.007761901855468750000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.215212771188961494426133149527677475506e-77) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.278233520507812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.251548941658176957400108992988921225640e-115) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.566234397888183593750000000000000000000e1), SC_(3.700677185300324954669535150537024687406e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(6.446855926513671875000000000000000000000e1), SC_(5.146655701108632128421425617758508485569e-30), SC_(9.999999999999999999999999999948533442989e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(1.297754516601562500000000000000000000000e2), SC_(1.867518705450759655047596253939234014894e-10), SC_(9.999999998132481294549240344952403746061e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(1.947455444335937500000000000000000000000e2), SC_(2.873803206344906959524816841685345206146e-3), SC_(9.971261967936550930404751831583146547939e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.416496582031250000000000000000000000000e2), SC_(1.510712143237768935693844961716864961966e-1), SC_(8.489287856762231064306155038283135038034e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.719393615722656250000000000000000000000e2), SC_(4.709146227598564335284520002752230901069e-1), SC_(5.290853772401435664715479997247769098931e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.757125549316406250000000000000000000000e2), SC_(5.080844888290352384460545329000221862343e-1), SC_(4.919155111709647615539454670999778137657e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(2.805930786132812500000000000000000000000e2), SC_(5.121237202607092021079080576228648083841e-1), SC_(4.878762797392907978920919423771351916159e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(2.806864318847656250000000000000000000000e2), SC_(5.125366180731616223636690525640131147679e-1), SC_(4.874633819268383776363309474359868852321e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(2.914837646484375000000000000000000000000e2), SC_(5.161022434934836336465066054524742972676e-1), SC_(4.838977565065163663534933945475257027324e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(2.962491149902343750000000000000000000000e2), SC_(5.534578980492226391496847071144135433964e-1), SC_(4.465421019507773608503152928855864566036e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(3.237945251464843750000000000000000000000e2), SC_(8.528808913980104346523720480044133022198e-1), SC_(1.471191086019895653476279519955866977802e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(3.563680725097656250000000000000000000000e2), SC_(9.781311076268954123059457588540898437386e-1), SC_(2.186889237310458769405424114591015626135e-2) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(3.973022460937500000000000000000000000000e2), SC_(9.984444929001757485873501842892600880831e-1), SC_(1.555507099824251412649815710739911916929e-3) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(4.585274047851562500000000000000000000000e2), SC_(9.999986026142985737254875350611862527777e-1), SC_(1.397385701426274512464938813747222261642e-6) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(6.454253540039062500000000000000000000000e2), SC_(9.999999999999999967537324821855956858192e-1), SC_(3.246267517814404314180834753730998705385e-18) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(9.725804443359375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(6.773761633195625550175402496730360582683e-51) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(1.309345703125000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.831839826874676203487180316684331155819e-91) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(1.636944824218750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.701351282501766022267637290534268499813e-136) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(3.289619064331054687500000000000000000000e1), SC_(5.891407463704156404705165516721124069764e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(8.299696350097656250000000000000000000000e1), SC_(1.812176364657325067100026603484678693682e-32), SC_(9.999999999999999999999999999999818782364e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(1.662563781738281250000000000000000000000e2), SC_(2.117826788447057916411308114988517251066e-11), SC_(9.999999999788217321155294208358869188501e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(2.514049072265625000000000000000000000000e2), SC_(1.668586023920085385065802553232874325364e-3), SC_(9.983314139760799146149341974467671256746e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.037050476074218750000000000000000000000e2), SC_(1.362318618119789973117650910558366126810e-1), SC_(8.637681381880210026882349089441633873190e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.379945373535156250000000000000000000000e2), SC_(4.673372398959752562929716055830429271037e-1), SC_(5.326627601040247437070283944169570728963e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.440259399414062500000000000000000000000e2), SC_(5.066514953935384437674346169832858679476e-1), SC_(4.933485046064615562325653830167141320524e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.448673095703125000000000000000000000000e2), SC_(5.110188694510963532527652747086175826717e-1), SC_(4.889811305489036467472347252913824173283e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(3.478236694335937500000000000000000000000e2), SC_(5.114129711022832660705000936877574773502e-1), SC_(4.885870288977167339294999063122425226498e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(3.493398437500000000000000000000000000000e2), SC_(5.153451778010147153148429113428195375851e-1), SC_(4.846548221989852846851570886571804624149e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(3.582291259765625000000000000000000000000e2), SC_(5.547148508775148945775514516651632057934e-1), SC_(4.452851491224851054224485483348367942066e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.912665100097656250000000000000000000000e2), SC_(8.650370568374972140988954003665266749766e-1), SC_(1.349629431625027859011045996334733250234e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(4.269918518066406250000000000000000000000e2), SC_(9.831021886046312273350515952879901850010e-1), SC_(1.689781139536877266494840471200981499905e-2) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(4.626205749511718750000000000000000000000e2), SC_(9.990077822132460613745621715038826626758e-1), SC_(9.922177867539386254378284961173373241785e-4) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(5.344454345703125000000000000000000000000e2), SC_(9.999995458017193060012664452999890581213e-1), SC_(4.541982806939987335547000109418787219714e-7) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(7.183710937500000000000000000000000000000e2), SC_(9.999999999999999997981954424133876728511e-1), SC_(2.018045575866123271489335577355517019000e-19) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(1.081864501953125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.006183369430704280283596014812856028721e-54) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(1.443729614257812500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.837258595465293474954936157746938670288e-98) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(1.816212768554687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.752441965601169646397953740086434263391e-147) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.660667037963867187500000000000000000000e1), SC_(1.900519406327234602935480865974466933325e-69), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(9.268164825439453125000000000000000000000e1), SC_(4.806319679853864163594559912048473267689e-34), SC_(9.999999999999999999999999999999995193680e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(1.859634704589843750000000000000000000000e2), SC_(5.292453792679856435393807804011276015723e-12), SC_(9.999999999947075462073201435646061921960e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(2.830494384765625000000000000000000000000e2), SC_(1.177741217511741206680178260646075946325e-3), SC_(9.988222587824882587933198217393539240537e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.410244140625000000000000000000000000000e2), SC_(1.272598436476643966342905152120851277314e-1), SC_(8.727401563523356033657094847879148722686e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.755940551757812500000000000000000000000e2), SC_(4.653209523635925786868195084309811478834e-1), SC_(5.346790476364074213131804915690188521166e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.826564636230468750000000000000000000000e2), SC_(5.059396737613408889504973557193282516465e-1), SC_(4.940603262386591110495026442806717483535e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(3.862852478027343750000000000000000000000e2), SC_(5.104202268189616432686455393226706395974e-1), SC_(4.895797731810383567313544606773293604026e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(3.877130126953125000000000000000000000000e2), SC_(5.108558855942851424930573096712581437111e-1), SC_(4.891441144057148575069426903287418562889e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(3.881299438476562500000000000000000000000e2), SC_(5.149396593646670182274212597936609229056e-1), SC_(4.850603406353329817725787402063390770944e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(3.920206909179687500000000000000000000000e2), SC_(5.555238061014516914109127913421825626292e-1), SC_(4.444761938985483085890872086578174373708e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(4.281404113769531250000000000000000000000e2), SC_(8.716220662328096395520910824697536791279e-1), SC_(1.283779337671903604479089175302463208721e-1) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(4.677358093261718750000000000000000000000e2), SC_(9.855694091804612681629449348782134782904e-1), SC_(1.443059081953873183705506512178652170963e-2) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(5.070187072753906250000000000000000000000e2), SC_(9.992807250500027311638266178400317788649e-1), SC_(7.192749499972688361733821599682211351002e-4) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(5.855390625000000000000000000000000000000e2), SC_(9.999997949171069340700620081694496271885e-1), SC_(2.050828930659299379918305503728114611512e-7) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(7.849255371093750000000000000000000000000e2), SC_(9.999999999999999999853056965061590141955e-1), SC_(1.469430349384098580452338611520995702359e-20) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(1.184451171875000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.039622049060896120857124612720583580269e-58) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(1.580218139648437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.429002122782311422549309273276524432232e-105) }}, 
      {{ SC_(1.962408294677734375000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(1.977665405273437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.964745656484624422472260548894849669967e-157) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.995400810241699218750000000000000000000e1), SC_(1.461749811971243298683985221051498962911e-62), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(5.123748397827148437500000000000000000000e1), SC_(1.882691556823769051620545630173346368538e-29), SC_(9.999999999999999999999999999811730844318e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(1.027362976074218750000000000000000000000e2), SC_(3.628110705022264214295406315723981208690e-10), SC_(9.999999996371889294977735785704593684276e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(1.542942810058593750000000000000000000000e2), SC_(3.438733586751055680813785478530552492893e-3), SC_(9.965612664132489443191862145214694475071e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(1.870358886718750000000000000000000000000e2), SC_(1.588873160164913961761167086363292234456e-1), SC_(8.411126839835086038238832913636707765544e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.158296356201171875000000000000000000000e2), SC_(4.731960132957495835818507443868545774001e-1), SC_(5.268039867042504164181492556131454225999e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.178733673095703125000000000000000000000e2), SC_(5.092144163108905315839709418270623311134e-1), SC_(4.907855836891094684160290581729376688866e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.205557250976562500000000000000000000000e2), SC_(5.131719440341081586936978654552879049081e-1), SC_(4.868280559658918413063021345447120950919e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.210983886718750000000000000000000000000e2), SC_(5.135641996962504767937848213120054356090e-1), SC_(4.864358003037495232062151786879945643910e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.238435668945312500000000000000000000000e2), SC_(5.171244291783683128059856466109064690897e-1), SC_(4.828755708216316871940143533890935309103e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(2.262205505371093750000000000000000000000e2), SC_(5.528372492874627275476300673236197277283e-1), SC_(4.471627507125372724523699326763802722717e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(2.482466583251953125000000000000000000000e2), SC_(8.425409793460870108929130567818507895234e-1), SC_(1.574590206539129891070869432181492104766e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(2.723527832031250000000000000000000000000e2), SC_(9.727047661753891359838031427583805717258e-1), SC_(2.729523382461086401619685724161942827416e-2) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(2.969280090332031250000000000000000000000e2), SC_(9.973861092301032349027118059108624329120e-1), SC_(2.613890769896765097288194089137567087992e-3) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(3.451589965820312500000000000000000000000e2), SC_(9.999949411603523631660227690744211701758e-1), SC_(5.058839647636833977230925578829824169538e-6) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(4.656414184570312500000000000000000000000e2), SC_(9.999999999999991181925157553647183742186e-1), SC_(8.818074842446352816257813678295237266470e-16) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(7.000692138671875000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(8.268111073618078280973718353690024621551e-43) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(9.450390625000000000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.131404494674792916431696388072993645669e-75) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.204841186523437500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.447622443586931335512115852058196852087e-112) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.427902030944824218750000000000000000000e1), SC_(2.687070943686635685356991346586037834370e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(6.349199295043945312500000000000000000000e1), SC_(3.523592932263021655263701868153205994958e-30), SC_(9.999999999999999999999999999964764070677e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(1.271415100097656250000000000000000000000e2), SC_(1.781261838250440184034740565491751903664e-10), SC_(9.999999998218738161749559815965259434508e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(1.934919433593750000000000000000000000000e2), SC_(2.806870025567902582921438936597116766866e-3), SC_(9.971931299744320974170785610634028832331e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.330693969726562500000000000000000000000e2), SC_(1.520057031052408900012924347695988454836e-1), SC_(8.479942968947591099987075652304011545164e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.576146240234375000000000000000000000000e2), SC_(4.714883300450530371191277266219960271981e-1), SC_(5.285116699549469628808722733780039728019e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.616315612792968750000000000000000000000e2), SC_(5.083674828314493629656932299648781671318e-1), SC_(4.916325171685506370343067700351218328682e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.620032653808593750000000000000000000000e2), SC_(5.124604006245425298986276068577365134245e-1), SC_(4.875395993754574701013723931422634865755e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(2.708692626953125000000000000000000000000e2), SC_(5.127072625105133467008523589446164394690e-1), SC_(4.872927374894866532991476410553835605310e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(2.773058166503906250000000000000000000000e2), SC_(5.163190664182322868187946230676765764963e-1), SC_(4.836809335817677131812053769323234235037e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(2.811143798828125000000000000000000000000e2), SC_(5.533408777508061819249878892582116518262e-1), SC_(4.466591222491938180750121107417883481738e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(3.112292175292968750000000000000000000000e2), SC_(8.514233931473010671634310901968261359290e-1), SC_(1.485766068526989328365689098031738640710e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(3.396011047363281250000000000000000000000e2), SC_(9.771900276159287419979576406193524752839e-1), SC_(2.280997238407125800204235938064752471612e-2) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(3.815956115722656250000000000000000000000e2), SC_(9.983228160188893661799564585439006881628e-1), SC_(1.677183981110633820043541456099311837179e-3) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(4.434877624511718750000000000000000000000e2), SC_(9.999983761332426484830707654790307586385e-1), SC_(1.623866757351516929234520969241361463155e-6) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(5.934023437500000000000000000000000000000e2), SC_(9.999999999999999819764851846244938389139e-1), SC_(1.802351481537550616108613687339114792300e-17) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(8.979477539062500000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.414646760462879504137052933072385786354e-48) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(1.231838623046875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.973807555354734120230973309159040733030e-88) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(1.540137451171875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.318781894764675565866483943430698700799e-131) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(3.250552368164062500000000000000000000000e1), SC_(3.027133583592376731310570259243029407871e-67), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(8.163401031494140625000000000000000000000e1), SC_(1.785667159640981675564700963169233728085e-32), SC_(9.999999999999999999999999999999821433284e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(1.648394775390625000000000000000000000000e2), SC_(2.035740408141590533465054099242736128682e-11), SC_(9.999999999796425959185840946653494590076e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(2.472986297607421875000000000000000000000e2), SC_(1.698128277277837273593298356126890371306e-3), SC_(9.983018717227221627264067016438731096287e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(2.981740112304687500000000000000000000000e2), SC_(1.369398588643118961803327662783924924969e-1), SC_(8.630601411356881038196672337216075075031e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.309870910644531250000000000000000000000e2), SC_(4.676065652754057679484336560777446152109e-1), SC_(5.323934347245942320515663439222553847891e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.345204467773437500000000000000000000000e2), SC_(5.068243166129390383555576565161355164581e-1), SC_(4.931756833870609616444423434838644835419e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.375491027832031250000000000000000000000e2), SC_(5.111314119526164824437897395643449824634e-1), SC_(4.888685880473835175562102604356550175366e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(3.398265991210937500000000000000000000000e2), SC_(5.115329239935725664341609050851270076662e-1), SC_(4.884670760064274335658390949148729923338e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(3.440949401855468750000000000000000000000e2), SC_(5.154143633039160415851963735808736154995e-1), SC_(4.845856366960839584148036264191263845005e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(3.501799621582031250000000000000000000000e2), SC_(5.546327251012879103081120317746003208635e-1), SC_(4.453672748987120896918879682253996791365e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(3.819308776855468750000000000000000000000e2), SC_(8.638850591078398912587457463501601139689e-1), SC_(1.361149408921601087412542536498398860311e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(4.201577148437500000000000000000000000000e2), SC_(9.828544238579791979411536477560861918994e-1), SC_(1.714557614202080205884635224391380810060e-2) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(4.567333679199218750000000000000000000000e2), SC_(9.989879592392681080137321253765285026180e-1), SC_(1.012040760731891986267874623471497382030e-3) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(5.355372314453125000000000000000000000000e2), SC_(9.999995752642290417665472190583594463362e-1), SC_(4.247357709582334527809416405536638151990e-7) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(7.160787353515625000000000000000000000000e2), SC_(9.999999999999999998097254395170953774520e-1), SC_(1.902745604829046225480116597000942452000e-19) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(1.074507324218750000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.247614859588685033491027779428182848171e-54) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(1.432818115234375000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(7.158741063416180039507077187833883119961e-98) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(1.793197265625000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(4.120853058974222923844779672138925828526e-146) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.615281295776367187500000000000000000000e1), SC_(1.245454364395098998339779788249385524007e-69), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(9.074101257324218750000000000000000000000e1), SC_(6.428429849797889983015214140344659092114e-34), SC_(9.999999999999999999999999999999993571570e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(1.816374816894531250000000000000000000000e2), SC_(6.381284201716699886341302144076424674890e-12), SC_(9.999999999936187157982833001136586978559e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(2.741888122558593750000000000000000000000e2), SC_(1.270134703705065971836809346005183970856e-3), SC_(9.987298652962949340281631906539948160291e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.315682983398437500000000000000000000000e2), SC_(1.289568845656035148224352643017138929681e-1), SC_(8.710431154343964851775647356982861070319e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.693384704589843750000000000000000000000e2), SC_(4.655560553839596624561278216431140849415e-1), SC_(5.344439446160403375438721783568859150585e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.738952331542968750000000000000000000000e2), SC_(5.060842470435287429131537433430935765127e-1), SC_(4.939157529564712570868462566569064234873e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(3.797417602539062500000000000000000000000e2), SC_(5.105088059508796179066103041851879185775e-1), SC_(4.894911940491203820933896958148120814225e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(3.812966918945312500000000000000000000000e2), SC_(5.109408062165737296214704378698192533496e-1), SC_(4.890591937834262703785295621301807466504e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(3.821122131347656250000000000000000000000e2), SC_(5.150066491858047713174248146458720075786e-1), SC_(4.849933508141952286825751853541279924214e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(3.892358398437500000000000000000000000000e2), SC_(5.555461780014650615719170599325174257685e-1), SC_(4.444538219985349384280829400674825742315e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(4.274906005859375000000000000000000000000e2), SC_(8.719644960539146492848647923231491430606e-1), SC_(1.280355039460853507151352076768508569394e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(4.680201721191406250000000000000000000000e2), SC_(9.857356842799107332047583922850337744797e-1), SC_(1.426431572008926679524160771496622552028e-2) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(5.071101379394531250000000000000000000000e2), SC_(9.992956960887940120680848237033672600248e-1), SC_(7.043039112059879319151762966327399752170e-4) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(5.857227783203125000000000000000000000000e2), SC_(9.999998049153099809027111454357275890157e-1), SC_(1.950846900190972888545642724109842663306e-7) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(7.831221923828125000000000000000000000000e2), SC_(9.999999999999999999862541087063624353695e-1), SC_(1.374589129363756463053694569749791191272e-20) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(1.176367187500000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.789096684411263945359513162494217124286e-58) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(1.569427734375000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(8.678444093096238309116459387167908044956e-105) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(1.963509643554687500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.002911998680394170209569134758851689629e-156) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.948052978515625000000000000000000000000e1), SC_(5.024506081758582064695027102491293941963e-72), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(9.928990936279296875000000000000000000000e1), SC_(2.219954437777408158222290725867061062874e-35), SC_(9.999999999999999999999999999999999778005e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(1.986985473632812500000000000000000000000e2), SC_(1.836591493414889394945616728710807077278e-12), SC_(9.999999999981634085065851106050543832713e-1) }}, 
      {{ SC_(1.985833740234375000000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(2.984067382812500000000000000000000000000e2), SC_(9.666576621171638211703444924417595294723e-4), SC_(9.990333423378828361788296555075582404705e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(9.566968083381652832031250000000000000000e-1), SC_(1.802272491455078125000000000000000000000e2), SC_(1.586734790403500931989828328951367806751e-1), SC_(8.413265209596499068010171671048632193249e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(6.366568565368652343750000000000000000000), SC_(2.036057434082031250000000000000000000000e2), SC_(4.733610404407883855032555403826675945176e-1), SC_(5.266389595592116144967444596173324054824e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(6.889215946197509765625000000000000000000), SC_(2.059788513183593750000000000000000000000e2), SC_(5.093181827859121664405562385201876630261e-1), SC_(4.906818172140878335594437614798123369739e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(7.142335891723632812500000000000000000000), SC_(2.064381408691406250000000000000000000000e2), SC_(5.132995826184644044914406612666840107027e-1), SC_(4.867004173815355955085593387333159892973e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(9.234277725219726562500000000000000000000), SC_(2.085509490966796875000000000000000000000e2), SC_(5.136840912589905122778079198832670028337e-1), SC_(4.863159087410094877221920801167329971663e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.942635536193847656250000000000000000000e1), SC_(2.189409027099609375000000000000000000000e2), SC_(5.171753638001812889117298345181633919381e-1), SC_(4.828246361998187110882701654818366080619e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.950807952880859375000000000000000000000e1), SC_(2.209919281005859375000000000000000000000e2), SC_(5.528670699445256937369363736045359334419e-1), SC_(4.471329300554743062630636263954640665581e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(2.197235107421875000000000000000000000000e1), SC_(2.433949737548828125000000000000000000000e2), SC_(8.424294885569235997610737179323081203342e-1), SC_(1.575705114430764002389262820676918796658e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(2.249290275573730468750000000000000000000e1), SC_(2.661464538574218750000000000000000000000e2), SC_(9.725784402817104000558626930136874800349e-1), SC_(2.742155971828959994413730698631251996507e-2) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(2.503655242919921875000000000000000000000e1), SC_(2.916320800781250000000000000000000000000e2), SC_(9.973686785952923635749571444848320405869e-1), SC_(2.631321404707636425042855515167959413092e-3) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(2.539736366271972656250000000000000000000e1), SC_(3.370397644042968750000000000000000000000e2), SC_(9.999947529991024217089982348573203740874e-1), SC_(5.247000897578291001765142679625912575104e-6) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(2.709540176391601562500000000000000000000e1), SC_(4.527824096679687500000000000000000000000e2), SC_(9.999999999999989201117498244509084078754e-1), SC_(1.079888250175549091592124622985753275610e-15) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(2.837726783752441406250000000000000000000e1), SC_(6.830192260742187500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(1.596173863478020974160494704614658560640e-42) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(2.982279586791992187500000000000000000000e1), SC_(9.164744262695312500000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(7.455957003768529406461545771049812165338e-75) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(3.152261734008789062500000000000000000000e1), SC_(1.154092041015625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.693222372366514029556108319256273073032e-110) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(3.423733520507812500000000000000000000000e1), SC_(2.335331535339355468750000000000000000000e1), SC_(3.103182379472903797601940814985594672749e-63), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(3.477303314208984375000000000000000000000e1), SC_(5.851721191406250000000000000000000000000e1), SC_(7.420641678914550895308006723734516551112e-30), SC_(9.999999999999999999999999999925793583211e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(3.767639541625976562500000000000000000000e1), SC_(1.184860992431640625000000000000000000000e2), SC_(2.383139839135143731922234253494684226556e-10), SC_(9.999999997616860160864856268077765746505e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(4.238486480712890625000000000000000000000e1), SC_(1.812604980468750000000000000000000000000e2), SC_(3.027357340450312671247602441976583838184e-3), SC_(9.969726426595496873287523975580234161618e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(4.420680999755859375000000000000000000000e1), SC_(2.191523590087890625000000000000000000000e2), SC_(1.544004671524164671894090930806851592772e-1), SC_(8.455995328475835328105909069193148407228e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(5.538459396362304687500000000000000000000e1), SC_(2.521336059570312500000000000000000000000e2), SC_(4.717010394632957111000217685075435347177e-1), SC_(5.282989605367042888999782314924564652823e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(5.569964599609375000000000000000000000000e1), SC_(2.547404632568359375000000000000000000000e2), SC_(5.085064634043854272643008119337915428271e-1), SC_(4.914935365956145727356991880662084571729e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(5.940588760375976562500000000000000000000e1), SC_(2.587016906738281250000000000000000000000e2), SC_(5.125169162440256991403526062617440053744e-1), SC_(4.874830837559743008596473937382559946256e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(6.038262176513671875000000000000000000000e1), SC_(2.597044067382812500000000000000000000000e2), SC_(5.129080861569142407257142135128426031641e-1), SC_(4.870919138430857592742857864871573968359e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(6.163340759277343750000000000000000000000e1), SC_(2.611901550292968750000000000000000000000e2), SC_(5.165684159239572039760357165390752194857e-1), SC_(4.834315840760427960239642834609247805143e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(6.331008529663085937500000000000000000000e1), SC_(2.652319641113281250000000000000000000000e2), SC_(5.531745854351384031064771924275531720248e-1), SC_(4.468254145648615968935228075724468279752e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(6.341989517211914062500000000000000000000e1), SC_(2.889872741699218750000000000000000000000e2), SC_(8.480809538563064598505202795459528835631e-1), SC_(1.519190461436935401494797204540471164369e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(7.225879669189453125000000000000000000000e1), SC_(3.258655395507812500000000000000000000000e2), SC_(9.762916737191814395013111152174334518554e-1), SC_(2.370832628081856049868888478256654814462e-2) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(7.844540405273437500000000000000000000000e1), SC_(3.610635681152343750000000000000000000000e2), SC_(9.981151164217188367115242273673616021111e-1), SC_(1.884883578281163288475772632638397888942e-3) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(7.974770355224609375000000000000000000000e1), SC_(4.185652770996093750000000000000000000000e2), SC_(9.999977834200703695571672244148127730619e-1), SC_(2.216579929630442832775585187226938128851e-6) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(8.435225677490234375000000000000000000000e1), SC_(5.672961425781250000000000000000000000000e2), SC_(9.999999999999999582156647231511972583150e-1), SC_(4.178433527684880274168501371346571094419e-17) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(8.441753387451171875000000000000000000000e1), SC_(8.511400146484375000000000000000000000000e2), SC_(1.000000000000000000000000000000000000000), SC_(3.925070158959466953812479298717915302202e-47) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(9.495173645019531250000000000000000000000e1), SC_(1.176990234375000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.483287238711652862667480704405226065147e-85) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(9.707512664794921875000000000000000000000e1), SC_(1.481854736328125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.514425769807175623558095528529580391211e-127) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(9.811781311035156250000000000000000000000e1), SC_(2.974136352539062500000000000000000000000e1), SC_(7.951503824873234670315135566997042985015e-66), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.007325439453125000000000000000000000000e2), SC_(7.500708770751953125000000000000000000000e1), SC_(1.351138180982215102176233383969144843736e-31), SC_(9.999999999999999999999999999998648861819e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.093762969970703125000000000000000000000e2), SC_(1.543360595703125000000000000000000000000e2), SC_(3.842311051911953531699511314150830125915e-11), SC_(9.999999999615768894808804646830048868585e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.094441146850585937500000000000000000000e2), SC_(2.315549468994140625000000000000000000000e2), SC_(1.977771601141785005040394981394662386973e-3), SC_(9.980222283988582149949596050186053376130e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.264718551635742187500000000000000000000e2), SC_(2.931908874511718750000000000000000000000e2), SC_(1.379394613924815578740312961727573956301e-1), SC_(8.620605386075184421259687038272426043699e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.279526672363281250000000000000000000000e2), SC_(3.239759826660156250000000000000000000000e2), SC_(4.679501016162186391406519275639482219570e-1), SC_(5.320498983837813608593480724360517780430e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.310955810546875000000000000000000000000e2), SC_(3.300610046386718750000000000000000000000e2), SC_(5.069084021374822564265958345673588983285e-1), SC_(4.930915978625177435734041654326411016715e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.311481323242187500000000000000000000000e2), SC_(3.304439392089843750000000000000000000000e2), SC_(5.112441754093731192770461370966518166597e-1), SC_(4.887558245906268807229538629033481833403e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.327210998535156250000000000000000000000e2), SC_(3.320501098632812500000000000000000000000e2), SC_(5.116528911763111280094804346204772872348e-1), SC_(4.883471088236888719905195653795227127652e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.357470245361328125000000000000000000000e2), SC_(3.353778991699218750000000000000000000000e2), SC_(5.155208220685295000915831311905315735513e-1), SC_(4.844791779314704999084168688094684264487e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.362719116210937500000000000000000000000e2), SC_(3.389234008789062500000000000000000000000e2), SC_(5.544203142815802710390962198185787464169e-1), SC_(4.455796857184197289609037801814212535831e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.389657287597656250000000000000000000000e2), SC_(3.720877075195312500000000000000000000000e2), SC_(8.622908847894982566097825610829691392981e-1), SC_(1.377091152105017433902174389170308607019e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.412092285156250000000000000000000000000e2), SC_(4.086060485839843750000000000000000000000e2), SC_(9.821607322117884979495654377827711966550e-1), SC_(1.783926778821150205043456221722880334497e-2) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.451677856445312500000000000000000000000e2), SC_(4.478026428222656250000000000000000000000e2), SC_(9.989298174363830482551903570127157560119e-1), SC_(1.070182563616951744809642987284243988141e-3) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.481294555664062500000000000000000000000e2), SC_(5.211378784179687500000000000000000000000e2), SC_(9.999994797904691860176751277865619206758e-1), SC_(5.202095308139823248722134380793241867631e-7) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.486264953613281250000000000000000000000e2), SC_(6.958446044921875000000000000000000000000e2), SC_(9.999999999999999996045263399197254490884e-1), SC_(3.954736600802745509115943800189889355831e-19) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.515480346679687500000000000000000000000e2), SC_(1.052531494140625000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(6.601257805885150289909120658456231227750e-54) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.527500000000000000000000000000000000000e2), SC_(1.408183227539062500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.000237582081951046145742432553355955693e-96) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.584414672851562500000000000000000000000e2), SC_(1.788686401367187500000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(5.957827315427703908759646403474290650064e-146) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.594559783935546875000000000000000000000e2), SC_(3.587517929077148437500000000000000000000e1), SC_(1.356176082172300107520771145977600912607e-69), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.595857238769531250000000000000000000000e2), SC_(8.972038269042968750000000000000000000000e1), SC_(8.216070643082009610897966985030390252065e-34), SC_(9.999999999999999999999999999999991783929e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.596211700439453125000000000000000000000e2), SC_(1.794584960937500000000000000000000000000e2), SC_(7.166324162989548688114040163345096606824e-12), SC_(9.999999999928336758370104513118859598367e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.600560913085937500000000000000000000000e2), SC_(2.695139160156250000000000000000000000000e2), SC_(1.327523249276128325865905450265666297728e-3), SC_(9.986724767507238716741340945497343337023e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.629447326660156250000000000000000000000e2), SC_(3.260164794921875000000000000000000000000e2), SC_(1.301004072687408931880643785374331713448e-1), SC_(8.698995927312591068119356214625668286552e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.643806610107421875000000000000000000000e2), SC_(3.600397033691406250000000000000000000000e2), SC_(4.660182128381547289926298172432381841274e-1), SC_(5.339817871618452710073701827567618158726e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.646915740966796875000000000000000000000e2), SC_(3.636233825683593750000000000000000000000e2), SC_(5.062665303560026040030081445813429265462e-1), SC_(4.937334696439973959969918554186570734538e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.670017089843750000000000000000000000000e2), SC_(3.662975158691406250000000000000000000000e2), SC_(5.106973005574084169848510356025972361947e-1), SC_(4.893026994425915830151489643974027638053e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.698258666992187500000000000000000000000e2), SC_(3.691585998535156250000000000000000000000e2), SC_(5.111052702424046835457855804537903702324e-1), SC_(4.888947297575953164542144195462096297676e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.744857635498046875000000000000000000000e2), SC_(3.741553649902343750000000000000000000000e2), SC_(5.150887834143480940075807657281644704146e-1), SC_(4.849112165856519059924192342718355295854e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.756861267089843750000000000000000000000e2), SC_(3.787317504882812500000000000000000000000e2), SC_(5.553201941675350167646371773361318286268e-1), SC_(4.446798058324649832353628226638681713732e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.811583862304687500000000000000000000000e2), SC_(4.184996337890625000000000000000000000000e2), SC_(8.705310827199552808744555344825350400779e-1), SC_(1.294689172800447191255444655174649599221e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.826751708984375000000000000000000000000e2), SC_(4.583652038574218750000000000000000000000e2), SC_(9.852368357723595013366611071898316886584e-1), SC_(1.476316422764049866333889281016831134165e-2) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.831471099853515625000000000000000000000e2), SC_(4.971757812500000000000000000000000000000e2), SC_(9.992475277030363823098749022492933911247e-1), SC_(7.524722969636176901250977507066088753398e-4) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.867986450195312500000000000000000000000e2), SC_(5.791416625976562500000000000000000000000e2), SC_(9.999997868073928052689964204548628458249e-1), SC_(2.131926071947310035795451371541751186443e-7) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.900444183349609375000000000000000000000e2), SC_(7.786804199218750000000000000000000000000e2), SC_(9.999999999999999999842890448735225215767e-1), SC_(1.571095512647747842332431001488736906025e-20) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.914333953857421875000000000000000000000e2), SC_(1.172187500000000000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(3.535476598966853255870979872762898186893e-58) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.915013732910156250000000000000000000000e2), SC_(1.563188720703125000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(1.503818272229840966678812511638176571203e-104) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.918984832763671875000000000000000000000e2), SC_(1.955971435546875000000000000000000000000e3), SC_(1.000000000000000000000000000000000000000), SC_(2.310477211914576555408738212352063615286e-156) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.929777069091796875000000000000000000000e2), SC_(3.922735214233398437500000000000000000000e1), SC_(5.529022449107786967054709588291909745351e-72), SC_(1.000000000000000000000000000000000000000) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.935389862060546875000000000000000000000e2), SC_(9.820869445800781250000000000000000000000e1), SC_(3.003464474651918107665338937597739013444e-35), SC_(9.999999999999999999999999999999999699654e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.937735595703125000000000000000000000000e2), SC_(1.965346832275390625000000000000000000000e2), SC_(2.080463495775573742672052667674087592048e-12), SC_(9.999999999979195365042244262573279473323e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.941185607910156250000000000000000000000e2), SC_(2.950607910156250000000000000000000000000e2), SC_(9.973915776745850702522937113932704987176e-4), SC_(9.990026084223254149297477062886067295013e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.962219390869140625000000000000000000000e2), SC_(3.559659729003906250000000000000000000000e2), SC_(1.231238558149305651892248029845975246239e-1), SC_(8.768761441850694348107751970154024753761e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.985762634277343750000000000000000000000e2), SC_(3.938933410644531250000000000000000000000e2), SC_(4.642429596210990429025849224204611903317e-1), SC_(5.357570403789009570974150775795388096683e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.988137054443359375000000000000000000000e2), SC_(3.977113952636718750000000000000000000000e2), SC_(5.056692632383849664727396199463872273040e-1), SC_(4.943307367616150335272603800536127726960e-1) }}, 
      {{ SC_(1.992958068847656250000000000000000000000e2), SC_(1.992922668457031250000000000000000000000e2), SC_(3.985880737304687500000000000000000000000e2), SC_(5.102581793845303603671068481454659458711e-1), SC_(4.897418206154696396328931518545340541289e-1) }}
   }};
#undef SC_

